// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See layer_chassis_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2024 The Khronos Group Inc.
 * Copyright (c) 2015-2024 Valve Corporation
 * Copyright (c) 2015-2024 LunarG, Inc.
 * Copyright (c) 2015-2024 Google Inc.
 * Copyright (c) 2023-2024 RasterGrid Kft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#include "chassis/chassis.h"
#include <array>
#include <cstring>
#include <mutex>

#include "chassis/dispatch_object.h"
#include "chassis/validation_object.h"
#include "layer_options.h"
#include "state_tracker/descriptor_sets.h"
#include "chassis/chassis_modification_state.h"
#include "core_checks/core_validation.h"

#include "profiling/profiling.h"

// Extension exposed by the validation layer
static constexpr std::array<VkExtensionProperties, 4> kInstanceExtensions = {
    VkExtensionProperties{VK_EXT_DEBUG_REPORT_EXTENSION_NAME, VK_EXT_DEBUG_REPORT_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_DEBUG_UTILS_EXTENSION_NAME, VK_EXT_DEBUG_UTILS_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_VALIDATION_FEATURES_EXTENSION_NAME, VK_EXT_VALIDATION_FEATURES_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_LAYER_SETTINGS_EXTENSION_NAME, VK_EXT_LAYER_SETTINGS_SPEC_VERSION},
};
static constexpr std::array<VkExtensionProperties, 3> kDeviceExtensions = {
    VkExtensionProperties{VK_EXT_VALIDATION_CACHE_EXTENSION_NAME, VK_EXT_VALIDATION_CACHE_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_DEBUG_MARKER_EXTENSION_NAME, VK_EXT_DEBUG_MARKER_SPEC_VERSION},
    VkExtensionProperties{VK_EXT_TOOLING_INFO_EXTENSION_NAME, VK_EXT_TOOLING_INFO_SPEC_VERSION},
};
namespace vulkan_layer_chassis {
static const VkLayerProperties global_layer = {
    OBJECT_LAYER_NAME,
    VK_LAYER_API_VERSION,
    1,
    "LunarG validation Layer",
};

// These functions reference generated data so they cannot be part of chassis_main.cpp
VKAPI_ATTR VkResult VKAPI_CALL EnumerateInstanceLayerProperties(uint32_t* pCount, VkLayerProperties* pProperties) {
    return util_GetLayerProperties(1, &global_layer, pCount, pProperties);
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateDeviceLayerProperties(VkPhysicalDevice physicalDevice, uint32_t* pCount,
                                                              VkLayerProperties* pProperties) {
    return util_GetLayerProperties(1, &global_layer, pCount, pProperties);
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateInstanceExtensionProperties(const char* pLayerName, uint32_t* pCount,
                                                                    VkExtensionProperties* pProperties) {
    if (pLayerName && !strcmp(pLayerName, global_layer.layerName)) {
        return util_GetExtensionProperties(static_cast<uint32_t>(kInstanceExtensions.size()), kInstanceExtensions.data(), pCount,
                                           pProperties);
    }

    return VK_ERROR_LAYER_NOT_PRESENT;
}

VKAPI_ATTR VkResult VKAPI_CALL EnumerateDeviceExtensionProperties(VkPhysicalDevice physicalDevice, const char* pLayerName,
                                                                  uint32_t* pCount, VkExtensionProperties* pProperties) {
    if (pLayerName && !strcmp(pLayerName, global_layer.layerName)) {
        return util_GetExtensionProperties(static_cast<uint32_t>(kDeviceExtensions.size()), kDeviceExtensions.data(), pCount,
                                           pProperties);
    }

    assert(physicalDevice);
    auto layer_data = vvl::dispatch::GetData(physicalDevice);
    return layer_data->instance_dispatch_table.EnumerateDeviceExtensionProperties(physicalDevice, pLayerName, pCount, pProperties);
}
VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDevices(VkInstance instance, uint32_t* pPhysicalDeviceCount,
                                                        VkPhysicalDevice* pPhysicalDevices) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDevices, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDevices);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->EnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordEnumeratePhysicalDevices(instance, pPhysicalDeviceCount, pPhysicalDevices, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFeatures(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFeatures(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFeatures(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                             VkFormatProperties* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFormatProperties(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                      VkImageType type, VkImageTiling tiling,
                                                                      VkImageUsageFlags usage, VkImageCreateFlags flags,
                                                                      VkImageFormatProperties* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                              pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                    pImageFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                           pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties(physicalDevice, format, type, tiling, usage, flags,
                                                                     pImageFormatProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceProperties(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceProperties(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceProperties(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties(VkPhysicalDevice physicalDevice,
                                                                  uint32_t* pQueueFamilyPropertyCount,
                                                                  VkQueueFamilyProperties* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                              pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                    pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                  pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties(physicalDevice, pQueueFamilyPropertyCount,
                                                                     pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties(VkPhysicalDevice physicalDevice,
                                                             VkPhysicalDeviceMemoryProperties* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceQueue(VkDevice device, uint32_t queueFamilyIndex, uint32_t queueIndex, VkQueue* pQueue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceQueue, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceQueue]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceQueue);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceQueue]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceQueue]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceQueue(device, queueFamilyIndex, queueIndex, pQueue, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit(VkQueue queue, uint32_t submitCount, const VkSubmitInfo* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueSubmit(queue, submitCount, pSubmits, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordQueueSubmit(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL QueueWaitIdle(VkQueue queue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueWaitIdle, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueWaitIdle]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueWaitIdle(queue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueWaitIdle);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueWaitIdle]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueWaitIdle(queue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueWaitIdle(queue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueWaitIdle]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordQueueWaitIdle(queue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DeviceWaitIdle(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDeviceWaitIdle, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDeviceWaitIdle]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDeviceWaitIdle(device, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDeviceWaitIdle);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDeviceWaitIdle]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDeviceWaitIdle(device, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->DeviceWaitIdle(device);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDeviceWaitIdle]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordDeviceWaitIdle(device, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AllocateMemory(VkDevice device, const VkMemoryAllocateInfo* pAllocateInfo,
                                              const VkAllocationCallbacks* pAllocator, VkDeviceMemory* pMemory) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAllocateMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAllocateMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAllocateMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAllocateMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AllocateMemory(device, pAllocateInfo, pAllocator, pMemory);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAllocateMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAllocateMemory(device, pAllocateInfo, pAllocator, pMemory, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL FreeMemory(VkDevice device, VkDeviceMemory memory, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeMemory(device, memory, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeMemory(device, memory, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->FreeMemory(device, memory, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeMemory(device, memory, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory(VkDevice device, VkDeviceMemory memory, VkDeviceSize offset, VkDeviceSize size,
                                         VkMemoryMapFlags flags, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory(device, memory, offset, size, flags, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory(device, memory, offset, size, flags, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->MapMemory(device, memory, offset, size, flags, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory(device, memory, offset, size, flags, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UnmapMemory(VkDevice device, VkDeviceMemory memory) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory(device, memory, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory(device, memory, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->UnmapMemory(device, memory);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory(device, memory, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL FlushMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                       const VkMappedMemoryRange* pMemoryRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFlushMappedMemoryRanges, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFlushMappedMemoryRanges]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkFlushMappedMemoryRanges);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFlushMappedMemoryRanges]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->FlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFlushMappedMemoryRanges]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordFlushMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL InvalidateMappedMemoryRanges(VkDevice device, uint32_t memoryRangeCount,
                                                            const VkMappedMemoryRange* pMemoryRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkInvalidateMappedMemoryRanges, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateInvalidateMappedMemoryRanges]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkInvalidateMappedMemoryRanges);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordInvalidateMappedMemoryRanges]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->InvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordInvalidateMappedMemoryRanges]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordInvalidateMappedMemoryRanges(device, memoryRangeCount, pMemoryRanges, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDeviceMemoryCommitment(VkDevice device, VkDeviceMemory memory,
                                                     VkDeviceSize* pCommittedMemoryInBytes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryCommitment, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryCommitment]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryCommitment);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryCommitment]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryCommitment]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryCommitment(device, memory, pCommittedMemoryInBytes, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory(VkDevice device, VkBuffer buffer, VkDeviceMemory memory,
                                                VkDeviceSize memoryOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory(device, buffer, memory, memoryOffset, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory(device, buffer, memory, memoryOffset, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindBufferMemory(device, buffer, memory, memoryOffset);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory(device, buffer, memory, memoryOffset, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory(VkDevice device, VkImage image, VkDeviceMemory memory, VkDeviceSize memoryOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory(device, image, memory, memoryOffset, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory(device, image, memory, memoryOffset, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindImageMemory(device, image, memory, memoryOffset);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory(device, image, memory, memoryOffset, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements(VkDevice device, VkBuffer buffer,
                                                       VkMemoryRequirements* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetBufferMemoryRequirements(device, buffer, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements(device, buffer, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements(VkDevice device, VkImage image, VkMemoryRequirements* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements(device, image, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements(device, image, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageMemoryRequirements(device, image, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements(device, image, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements(VkDevice device, VkImage image, uint32_t* pSparseMemoryRequirementCount,
                                                            VkSparseImageMemoryRequirements* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                                        pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                              pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements(device, image, pSparseMemoryRequirementCount,
                                                               pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                        VkImageType type, VkSampleCountFlagBits samples,
                                                                        VkImageUsageFlags usage, VkImageTiling tiling,
                                                                        uint32_t* pPropertyCount,
                                                                        VkSparseImageFormatProperties* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage,
                                                                                    tiling, pPropertyCount, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                          pPropertyCount, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                        pPropertyCount, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties(physicalDevice, format, type, samples, usage, tiling,
                                                                           pPropertyCount, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueBindSparse(VkQueue queue, uint32_t bindInfoCount, const VkBindSparseInfo* pBindInfo,
                                               VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueBindSparse, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueBindSparse]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueBindSparse);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueBindSparse]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueBindSparse(queue, bindInfoCount, pBindInfo, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueBindSparse]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordQueueBindSparse(queue, bindInfoCount, pBindInfo, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateFence(VkDevice device, const VkFenceCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateFence, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateFence]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateFence(device, pCreateInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateFence);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateFence]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateFence(device, pCreateInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateFence(device, pCreateInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateFence]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateFence(device, pCreateInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyFence(VkDevice device, VkFence fence, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyFence, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyFence]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyFence(device, fence, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyFence);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyFence]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyFence(device, fence, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyFence(device, fence, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyFence]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyFence(device, fence, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetFences, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetFences]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetFences(device, fenceCount, pFences, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetFences);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetFences]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetFences(device, fenceCount, pFences, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ResetFences(device, fenceCount, pFences);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetFences]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetFences(device, fenceCount, pFences, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceStatus(VkDevice device, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceStatus, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceStatus]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceStatus(device, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceStatus);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceStatus]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceStatus(device, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetFenceStatus(device, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceStatus]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetFenceStatus(device, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitForFences(VkDevice device, uint32_t fenceCount, const VkFence* pFences, VkBool32 waitAll,
                                             uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitForFences, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitForFences]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitForFences(device, fenceCount, pFences, waitAll, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitForFences);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitForFences]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitForFences(device, fenceCount, pFences, waitAll, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->WaitForFences(device, fenceCount, pFences, waitAll, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitForFences]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordWaitForFences(device, fenceCount, pFences, waitAll, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSemaphore(VkDevice device, const VkSemaphoreCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkSemaphore* pSemaphore) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSemaphore]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSemaphore]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSemaphore]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSemaphore(device, pCreateInfo, pAllocator, pSemaphore, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySemaphore(VkDevice device, VkSemaphore semaphore, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySemaphore]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySemaphore(device, semaphore, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySemaphore]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySemaphore(device, semaphore, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroySemaphore(device, semaphore, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySemaphore]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySemaphore(device, semaphore, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateEvent(VkDevice device, const VkEventCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkEvent* pEvent) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateEvent(device, pCreateInfo, pAllocator, pEvent, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateEvent(device, pCreateInfo, pAllocator, pEvent, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateEvent(device, pCreateInfo, pAllocator, pEvent);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateEvent(device, pCreateInfo, pAllocator, pEvent, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyEvent(VkDevice device, VkEvent event, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyEvent(device, event, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyEvent(device, event, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyEvent(device, event, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyEvent(device, event, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetEventStatus(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetEventStatus, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetEventStatus]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetEventStatus(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetEventStatus);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetEventStatus]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetEventStatus(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetEventStatus(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetEventStatus]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetEventStatus(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SetEvent(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetEvent(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetEvent(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SetEvent(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetEvent(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ResetEvent(VkDevice device, VkEvent event) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetEvent, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetEvent(device, event, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetEvent(device, event, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ResetEvent(device, event);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetEvent(device, event, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateQueryPool(VkDevice device, const VkQueryPoolCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkQueryPool* pQueryPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateQueryPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateQueryPool(device, pCreateInfo, pAllocator, pQueryPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyQueryPool(VkDevice device, VkQueryPool queryPool, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyQueryPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyQueryPool(device, queryPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyQueryPool(device, queryPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyQueryPool(device, queryPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyQueryPool(device, queryPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetQueryPoolResults(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount,
                                                   size_t dataSize, void* pData, VkDeviceSize stride, VkQueryResultFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueryPoolResults, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueryPoolResults]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride,
                                                           flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueryPoolResults);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueryPoolResults]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags,
                                                 record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueryPoolResults]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetQueryPoolResults(device, queryPool, firstQuery, queryCount, dataSize, pData, stride, flags,
                                                  record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyBuffer(VkDevice device, VkBuffer buffer, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyBuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyBuffer(device, buffer, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyBuffer(device, buffer, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyBuffer(device, buffer, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyBuffer(device, buffer, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateBufferView(VkDevice device, const VkBufferViewCreateInfo* pCreateInfo,
                                                const VkAllocationCallbacks* pAllocator, VkBufferView* pView) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateBufferView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateBufferView]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateBufferView(device, pCreateInfo, pAllocator, pView, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateBufferView);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateBufferView]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateBufferView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateBufferView(device, pCreateInfo, pAllocator, pView);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateBufferView]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateBufferView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyBufferView(VkDevice device, VkBufferView bufferView, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyBufferView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyBufferView]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyBufferView(device, bufferView, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyBufferView);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyBufferView]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyBufferView(device, bufferView, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyBufferView(device, bufferView, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyBufferView]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyBufferView(device, bufferView, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateImage(VkDevice device, const VkImageCreateInfo* pCreateInfo,
                                           const VkAllocationCallbacks* pAllocator, VkImage* pImage) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateImage(device, pCreateInfo, pAllocator, pImage, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateImage(device, pCreateInfo, pAllocator, pImage, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateImage(device, pCreateInfo, pAllocator, pImage);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateImage(device, pCreateInfo, pAllocator, pImage, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyImage(VkDevice device, VkImage image, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyImage(device, image, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyImage(device, image, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyImage(device, image, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyImage(device, image, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout(VkDevice device, VkImage image, const VkImageSubresource* pSubresource,
                                                     VkSubresourceLayout* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSubresourceLayout(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateImageView(VkDevice device, const VkImageViewCreateInfo* pCreateInfo,
                                               const VkAllocationCallbacks* pAllocator, VkImageView* pView) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateImageView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateImageView]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateImageView(device, pCreateInfo, pAllocator, pView, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateImageView);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateImageView]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateImageView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateImageView(device, pCreateInfo, pAllocator, pView);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateImageView]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateImageView(device, pCreateInfo, pAllocator, pView, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyImageView(VkDevice device, VkImageView imageView, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyImageView, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyImageView]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyImageView(device, imageView, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyImageView);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyImageView]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyImageView(device, imageView, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyImageView(device, imageView, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyImageView]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyImageView(device, imageView, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyShaderModule(VkDevice device, VkShaderModule shaderModule,
                                               const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyShaderModule, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyShaderModule]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyShaderModule(device, shaderModule, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyShaderModule);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyShaderModule]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyShaderModule(device, shaderModule, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyShaderModule(device, shaderModule, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyShaderModule]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyShaderModule(device, shaderModule, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePipelineCache(VkDevice device, const VkPipelineCacheCreateInfo* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkPipelineCache* pPipelineCache) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePipelineCache, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePipelineCache]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePipelineCache);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePipelineCache]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePipelineCache]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePipelineCache(device, pCreateInfo, pAllocator, pPipelineCache, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineCache(VkDevice device, VkPipelineCache pipelineCache,
                                                const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineCache, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineCache]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineCache(device, pipelineCache, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineCache);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineCache]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineCache(device, pipelineCache, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPipelineCache(device, pipelineCache, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineCache]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineCache(device, pipelineCache, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineCacheData(VkDevice device, VkPipelineCache pipelineCache, size_t* pDataSize,
                                                    void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineCacheData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineCacheData]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineCacheData(device, pipelineCache, pDataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineCacheData);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineCacheData]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineCacheData(device, pipelineCache, pDataSize, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineCacheData(device, pipelineCache, pDataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineCacheData]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineCacheData(device, pipelineCache, pDataSize, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL MergePipelineCaches(VkDevice device, VkPipelineCache dstCache, uint32_t srcCacheCount,
                                                   const VkPipelineCache* pSrcCaches) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMergePipelineCaches, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMergePipelineCaches]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMergePipelineCaches);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMergePipelineCaches]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->MergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMergePipelineCaches]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordMergePipelineCaches(device, dstCache, srcCacheCount, pSrcCaches, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipeline(VkDevice device, VkPipeline pipeline, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipeline, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipeline]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipeline(device, pipeline, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipeline);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipeline]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipeline(device, pipeline, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPipeline(device, pipeline, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipeline]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipeline(device, pipeline, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineLayout(VkDevice device, VkPipelineLayout pipelineLayout,
                                                 const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineLayout(device, pipelineLayout, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineLayout(device, pipelineLayout, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPipelineLayout(device, pipelineLayout, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineLayout(device, pipelineLayout, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSampler(VkDevice device, const VkSamplerCreateInfo* pCreateInfo,
                                             const VkAllocationCallbacks* pAllocator, VkSampler* pSampler) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSampler, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSampler]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSampler(device, pCreateInfo, pAllocator, pSampler, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSampler);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSampler]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSampler(device, pCreateInfo, pAllocator, pSampler, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSampler(device, pCreateInfo, pAllocator, pSampler);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSampler]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSampler(device, pCreateInfo, pAllocator, pSampler, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySampler(VkDevice device, VkSampler sampler, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySampler, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySampler]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySampler(device, sampler, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySampler);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySampler]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySampler(device, sampler, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroySampler(device, sampler, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySampler]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySampler(device, sampler, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorSetLayout(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator,
                                                         VkDescriptorSetLayout* pSetLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorSetLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorSetLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorSetLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorSetLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorSetLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorSetLayout(device, pCreateInfo, pAllocator, pSetLayout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorSetLayout(VkDevice device, VkDescriptorSetLayout descriptorSetLayout,
                                                      const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorSetLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorSetLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorSetLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorSetLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorSetLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorSetLayout(device, descriptorSetLayout, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorPool(VkDevice device, const VkDescriptorPoolCreateInfo* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkDescriptorPool* pDescriptorPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorPool(device, pCreateInfo, pAllocator, pDescriptorPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                 const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorPool(device, descriptorPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorPool(device, descriptorPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyDescriptorPool(device, descriptorPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorPool(device, descriptorPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetDescriptorPool(VkDevice device, VkDescriptorPool descriptorPool,
                                                   VkDescriptorPoolResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetDescriptorPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetDescriptorPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetDescriptorPool(device, descriptorPool, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetDescriptorPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetDescriptorPool(device, descriptorPool, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ResetDescriptorPool(device, descriptorPool, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetDescriptorPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetDescriptorPool(device, descriptorPool, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL FreeDescriptorSets(VkDevice device, VkDescriptorPool descriptorPool, uint32_t descriptorSetCount,
                                                  const VkDescriptorSet* pDescriptorSets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeDescriptorSets, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeDescriptorSets]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->FreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeDescriptorSets(device, descriptorPool, descriptorSetCount, pDescriptorSets, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSets(VkDevice device, uint32_t descriptorWriteCount,
                                                const VkWriteDescriptorSet* pDescriptorWrites, uint32_t descriptorCopyCount,
                                                const VkCopyDescriptorSet* pDescriptorCopies) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSets, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSets]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                            pDescriptorCopies, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                  pDescriptorCopies, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->UpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                              pDescriptorCopies);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSets(device, descriptorWriteCount, pDescriptorWrites, descriptorCopyCount,
                                                   pDescriptorCopies, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateFramebuffer(VkDevice device, const VkFramebufferCreateInfo* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkFramebuffer* pFramebuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateFramebuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateFramebuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateFramebuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateFramebuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateFramebuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateFramebuffer(device, pCreateInfo, pAllocator, pFramebuffer, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyFramebuffer(VkDevice device, VkFramebuffer framebuffer, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyFramebuffer, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyFramebuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyFramebuffer(device, framebuffer, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyFramebuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyFramebuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyFramebuffer(device, framebuffer, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyFramebuffer(device, framebuffer, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyFramebuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyFramebuffer(device, framebuffer, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass(VkDevice device, const VkRenderPassCreateInfo* pCreateInfo,
                                                const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyRenderPass(VkDevice device, VkRenderPass renderPass, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyRenderPass, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyRenderPass]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyRenderPass(device, renderPass, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyRenderPass(device, renderPass, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyRenderPass(device, renderPass, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyRenderPass(device, renderPass, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderAreaGranularity(VkDevice device, VkRenderPass renderPass, VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderAreaGranularity, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderAreaGranularity]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderAreaGranularity(device, renderPass, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderAreaGranularity);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderAreaGranularity]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderAreaGranularity(device, renderPass, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetRenderAreaGranularity(device, renderPass, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderAreaGranularity]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderAreaGranularity(device, renderPass, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCommandPool(VkDevice device, const VkCommandPoolCreateInfo* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkCommandPool* pCommandPool) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCommandPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCommandPool(device, pCreateInfo, pAllocator, pCommandPool, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyCommandPool(VkDevice device, VkCommandPool commandPool, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCommandPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCommandPool(device, commandPool, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCommandPool(device, commandPool, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyCommandPool(device, commandPool, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCommandPool(device, commandPool, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ResetCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetCommandPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetCommandPool(device, commandPool, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetCommandPool(device, commandPool, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ResetCommandPool(device, commandPool, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetCommandPool(device, commandPool, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AllocateCommandBuffers(VkDevice device, const VkCommandBufferAllocateInfo* pAllocateInfo,
                                                      VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAllocateCommandBuffers, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAllocateCommandBuffers]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAllocateCommandBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAllocateCommandBuffers]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAllocateCommandBuffers]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAllocateCommandBuffers(device, pAllocateInfo, pCommandBuffers, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL FreeCommandBuffers(VkDevice device, VkCommandPool commandPool, uint32_t commandBufferCount,
                                              const VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkFreeCommandBuffers, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateFreeCommandBuffers]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkFreeCommandBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordFreeCommandBuffers]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->FreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordFreeCommandBuffers]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordFreeCommandBuffers(device, commandPool, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EndCommandBuffer(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEndCommandBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateEndCommandBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEndCommandBuffer(commandBuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEndCommandBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordEndCommandBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordEndCommandBuffer(commandBuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->EndCommandBuffer(commandBuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordEndCommandBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordEndCommandBuffer(commandBuffer, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ResetCommandBuffer(VkCommandBuffer commandBuffer, VkCommandBufferResetFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetCommandBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetCommandBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetCommandBuffer(commandBuffer, flags, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetCommandBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetCommandBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetCommandBuffer(commandBuffer, flags, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ResetCommandBuffer(commandBuffer, flags);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetCommandBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetCommandBuffer(commandBuffer, flags, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindPipeline(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                           VkPipeline pipeline) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindPipeline, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindPipeline]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindPipeline);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindPipeline]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindPipeline]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindPipeline(commandBuffer, pipelineBindPoint, pipeline, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewport(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount,
                                          const VkViewport* pViewports) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewport, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewport]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewport);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewport]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewport]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewport(commandBuffer, firstViewport, viewportCount, pViewports, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetScissor(VkCommandBuffer commandBuffer, uint32_t firstScissor, uint32_t scissorCount,
                                         const VkRect2D* pScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetScissor, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetScissor]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetScissor);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetScissor]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetScissor]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetScissor(commandBuffer, firstScissor, scissorCount, pScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineWidth(VkCommandBuffer commandBuffer, float lineWidth) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineWidth, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineWidth]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineWidth(commandBuffer, lineWidth, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineWidth);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineWidth]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineWidth(commandBuffer, lineWidth, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetLineWidth(commandBuffer, lineWidth);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineWidth]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineWidth(commandBuffer, lineWidth, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBias(VkCommandBuffer commandBuffer, float depthBiasConstantFactor, float depthBiasClamp,
                                           float depthBiasSlopeFactor) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBias, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBias]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                                       error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBias);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBias]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                             record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBias]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBias(commandBuffer, depthBiasConstantFactor, depthBiasClamp, depthBiasSlopeFactor,
                                              record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetBlendConstants(VkCommandBuffer commandBuffer, const float blendConstants[4]) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetBlendConstants, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetBlendConstants]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetBlendConstants(commandBuffer, blendConstants, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetBlendConstants);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetBlendConstants]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetBlendConstants(commandBuffer, blendConstants, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetBlendConstants(commandBuffer, blendConstants);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetBlendConstants]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetBlendConstants(commandBuffer, blendConstants, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBounds(VkCommandBuffer commandBuffer, float minDepthBounds, float maxDepthBounds) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBounds, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBounds]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBounds);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBounds]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBounds]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBounds(commandBuffer, minDepthBounds, maxDepthBounds, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilCompareMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask,
                                                    uint32_t compareMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilCompareMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilCompareMask]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilCompareMask);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilCompareMask]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilCompareMask(commandBuffer, faceMask, compareMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilCompareMask]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilCompareMask(commandBuffer, faceMask, compareMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilWriteMask(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t writeMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilWriteMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilWriteMask]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilWriteMask);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilWriteMask]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilWriteMask(commandBuffer, faceMask, writeMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilWriteMask]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilWriteMask(commandBuffer, faceMask, writeMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilReference(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, uint32_t reference) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilReference, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilReference]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilReference(commandBuffer, faceMask, reference, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilReference);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilReference]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilReference(commandBuffer, faceMask, reference, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilReference(commandBuffer, faceMask, reference);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilReference]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilReference(commandBuffer, faceMask, reference, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                 VkPipelineLayout layout, uint32_t firstSet, uint32_t descriptorSetCount,
                                                 const VkDescriptorSet* pDescriptorSets, uint32_t dynamicOffsetCount,
                                                 const uint32_t* pDynamicOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                             pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                   pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                               pDescriptorSets, dynamicOffsetCount, pDynamicOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets(commandBuffer, pipelineBindPoint, layout, firstSet, descriptorSetCount,
                                                    pDescriptorSets, dynamicOffsetCount, pDynamicOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                              VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindIndexBuffer(commandBuffer, buffer, offset, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer(commandBuffer, buffer, offset, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindVertexBuffers(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
                                                const VkBuffer* pBuffers, const VkDeviceSize* pOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindVertexBuffers, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindVertexBuffers]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindVertexBuffers);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindVertexBuffers]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindVertexBuffers]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindVertexBuffers(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDraw(VkCommandBuffer commandBuffer, uint32_t vertexCount, uint32_t instanceCount,
                                   uint32_t firstVertex, uint32_t firstInstance) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDraw, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDraw]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDraw);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDraw]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDraw]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDraw(commandBuffer, vertexCount, instanceCount, firstVertex, firstInstance, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexed(VkCommandBuffer commandBuffer, uint32_t indexCount, uint32_t instanceCount,
                                          uint32_t firstIndex, int32_t vertexOffset, uint32_t firstInstance) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexed, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexed]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset,
                                                      firstInstance, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexed);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexed]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance,
                                            record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexed]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexed(commandBuffer, indexCount, instanceCount, firstIndex, vertexOffset, firstInstance,
                                             record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset, uint32_t drawCount,
                                           uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirect]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirect]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirect]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                  uint32_t drawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirect]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirect]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirect]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirect(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatch(VkCommandBuffer commandBuffer, uint32_t groupCountX, uint32_t groupCountY,
                                       uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatch, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatch]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatch);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatch]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatch]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatch(commandBuffer, groupCountX, groupCountY, groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchIndirect(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchIndirect, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchIndirect]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchIndirect(commandBuffer, buffer, offset, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchIndirect);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchIndirect]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchIndirect(commandBuffer, buffer, offset, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchIndirect(commandBuffer, buffer, offset);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchIndirect]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchIndirect(commandBuffer, buffer, offset, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkBuffer dstBuffer,
                                         uint32_t regionCount, const VkBufferCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer(commandBuffer, srcBuffer, dstBuffer, regionCount, pRegions, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                        VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                        const VkImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                                    pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                          record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                           record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                        VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                        const VkImageBlit* pRegions, VkFilter filter) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                                    pRegions, filter, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                          filter, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                      filter);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions,
                                           filter, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage(VkCommandBuffer commandBuffer, VkBuffer srcBuffer, VkImage dstImage,
                                                VkImageLayout dstImageLayout, uint32_t regionCount,
                                                const VkBufferImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount,
                                                            pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions,
                                                  record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage(commandBuffer, srcBuffer, dstImage, dstImageLayout, regionCount, pRegions,
                                                   record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                                VkBuffer dstBuffer, uint32_t regionCount, const VkBufferImageCopy* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount,
                                                            pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions,
                                                  record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer(commandBuffer, srcImage, srcImageLayout, dstBuffer, regionCount, pRegions,
                                                   record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdUpdateBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                           VkDeviceSize dataSize, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdUpdateBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdUpdateBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdUpdateBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdUpdateBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdUpdateBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdUpdateBuffer(commandBuffer, dstBuffer, dstOffset, dataSize, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdFillBuffer(VkCommandBuffer commandBuffer, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                         VkDeviceSize size, uint32_t data) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdFillBuffer, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdFillBuffer]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdFillBuffer);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdFillBuffer]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdFillBuffer]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdFillBuffer(commandBuffer, dstBuffer, dstOffset, size, data, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearColorImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
                                              const VkClearColorValue* pColor, uint32_t rangeCount,
                                              const VkImageSubresourceRange* pRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearColorImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearColorImage]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearColorImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearColorImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearColorImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearColorImage(commandBuffer, image, imageLayout, pColor, rangeCount, pRanges, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearDepthStencilImage(VkCommandBuffer commandBuffer, VkImage image, VkImageLayout imageLayout,
                                                     const VkClearDepthStencilValue* pDepthStencil, uint32_t rangeCount,
                                                     const VkImageSubresourceRange* pRanges) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearDepthStencilImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearDepthStencilImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount,
                                                                 pRanges, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearDepthStencilImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearDepthStencilImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges,
                                                       record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearDepthStencilImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearDepthStencilImage(commandBuffer, image, imageLayout, pDepthStencil, rangeCount, pRanges,
                                                        record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdClearAttachments(VkCommandBuffer commandBuffer, uint32_t attachmentCount,
                                               const VkClearAttachment* pAttachments, uint32_t rectCount,
                                               const VkClearRect* pRects) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdClearAttachments, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdClearAttachments]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdClearAttachments);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdClearAttachments]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdClearAttachments]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdClearAttachments(commandBuffer, attachmentCount, pAttachments, rectCount, pRects, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage(VkCommandBuffer commandBuffer, VkImage srcImage, VkImageLayout srcImageLayout,
                                           VkImage dstImage, VkImageLayout dstImageLayout, uint32_t regionCount,
                                           const VkImageResolve* pRegions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout,
                                                       regionCount, pRegions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                             pRegions, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount, pRegions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage(commandBuffer, srcImage, srcImageLayout, dstImage, dstImageLayout, regionCount,
                                              pRegions, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetEvent(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResetEvent(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                         VkPipelineStageFlags srcStageMask, VkPipelineStageFlags dstStageMask,
                                         uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
                                         uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                                         uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents(
                commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount, pMemoryBarriers,
                bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                           pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                           imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                       pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount,
                                       pImageMemoryBarriers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents(commandBuffer, eventCount, pEvents, srcStageMask, dstStageMask, memoryBarrierCount,
                                            pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                            imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier(VkCommandBuffer commandBuffer, VkPipelineStageFlags srcStageMask,
                                              VkPipelineStageFlags dstStageMask, VkDependencyFlags dependencyFlags,
                                              uint32_t memoryBarrierCount, const VkMemoryBarrier* pMemoryBarriers,
                                              uint32_t bufferMemoryBarrierCount, const VkBufferMemoryBarrier* pBufferMemoryBarriers,
                                              uint32_t imageMemoryBarrierCount, const VkImageMemoryBarrier* pImageMemoryBarriers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier(
                commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount, pMemoryBarriers,
                bufferMemoryBarrierCount, pBufferMemoryBarriers, imageMemoryBarrierCount, pImageMemoryBarriers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                                pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                                imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                            pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                            imageMemoryBarrierCount, pImageMemoryBarriers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier(commandBuffer, srcStageMask, dstStageMask, dependencyFlags, memoryBarrierCount,
                                                 pMemoryBarriers, bufferMemoryBarrierCount, pBufferMemoryBarriers,
                                                 imageMemoryBarrierCount, pImageMemoryBarriers, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                         VkQueryControlFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginQuery, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginQuery]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginQuery(commandBuffer, queryPool, query, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginQuery);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginQuery]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginQuery(commandBuffer, queryPool, query, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginQuery(commandBuffer, queryPool, query, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginQuery]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginQuery(commandBuffer, queryPool, query, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndQuery(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndQuery, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndQuery]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndQuery(commandBuffer, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndQuery);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndQuery]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndQuery(commandBuffer, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndQuery(commandBuffer, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndQuery]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndQuery(commandBuffer, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetQueryPool(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery,
                                             uint32_t queryCount) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetQueryPool, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetQueryPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetQueryPool(commandBuffer, queryPool, firstQuery, queryCount, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage,
                                             VkQueryPool queryPool, uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp(commandBuffer, pipelineStage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyQueryPoolResults(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t firstQuery,
                                                   uint32_t queryCount, VkBuffer dstBuffer, VkDeviceSize dstOffset,
                                                   VkDeviceSize stride, VkQueryResultFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyQueryPoolResults, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyQueryPoolResults]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer,
                                                               dstOffset, stride, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyQueryPoolResults);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyQueryPoolResults]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride,
                                                     flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset, stride,
                                                 flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyQueryPoolResults]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyQueryPoolResults(commandBuffer, queryPool, firstQuery, queryCount, dstBuffer, dstOffset,
                                                      stride, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants(VkCommandBuffer commandBuffer, VkPipelineLayout layout, VkShaderStageFlags stageFlags,
                                            uint32_t offset, uint32_t size, const void* pValues) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants(commandBuffer, layout, stageFlags, offset, size, pValues, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                              VkSubpassContents contents) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass(commandBuffer, pRenderPassBegin, contents, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass(VkCommandBuffer commandBuffer, VkSubpassContents contents) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass(commandBuffer, contents, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass(commandBuffer, contents, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdNextSubpass(commandBuffer, contents);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass(commandBuffer, contents, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndRenderPass(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdExecuteCommands(VkCommandBuffer commandBuffer, uint32_t commandBufferCount,
                                              const VkCommandBuffer* pCommandBuffers) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdExecuteCommands, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdExecuteCommands]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdExecuteCommands);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdExecuteCommands]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdExecuteCommands]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdExecuteCommands(commandBuffer, commandBufferCount, pCommandBuffers, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory2(VkDevice device, uint32_t bindInfoCount,
                                                 const VkBindBufferMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory2(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindBufferMemory2(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory2(VkDevice device, uint32_t bindInfoCount, const VkBindImageMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory2(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindImageMemory2(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory2(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDeviceGroupPeerMemoryFeatures(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex,
                                                            uint32_t remoteDeviceIndex,
                                                            VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeatures, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeatures]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                        pPeerMemoryFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeatures);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeatures]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                              pPeerMemoryFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                          pPeerMemoryFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeatures]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPeerMemoryFeatures(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                               pPeerMemoryFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDeviceMask(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDeviceMask, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDeviceMask]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDeviceMask(commandBuffer, deviceMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDeviceMask);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDeviceMask]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDeviceMask(commandBuffer, deviceMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDeviceMask(commandBuffer, deviceMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDeviceMask]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDeviceMask(commandBuffer, deviceMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchBase(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY,
                                           uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY, uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchBase, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchBase]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                       groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchBase);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchBase]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                             groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY, groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchBase]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchBase(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                              groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceGroups(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
                                                             VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceGroups, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount,
                                                                     pPhysicalDeviceGroupProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceGroups);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                           record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->EnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordEnumeratePhysicalDeviceGroups(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                            record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements2(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
                                                       VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageMemoryRequirements2(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements2(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
                                                        VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements2(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements2(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
                                                             uint32_t* pSparseMemoryRequirementCount,
                                                             VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                                         pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                               pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount, pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements2(device, pInfo, pSparseMemoryRequirementCount,
                                                                pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFeatures2(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFeatures2(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties2(VkPhysicalDevice physicalDevice, VkPhysicalDeviceProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties2(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceProperties2(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceProperties2(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceProperties2(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties2(VkPhysicalDevice physicalDevice, VkFormat format,
                                                              VkFormatProperties2* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFormatProperties2(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties2(VkPhysicalDevice physicalDevice,
                                                                       const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
                                                                       VkImageFormatProperties2* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo,
                                                                               pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                     record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->GetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties2(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                      record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties2(VkPhysicalDevice physicalDevice,
                                                                   uint32_t* pQueueFamilyPropertyCount,
                                                                   VkQueueFamilyProperties2* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                               pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                     pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                   pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties2(physicalDevice, pQueueFamilyPropertyCount,
                                                                      pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties2(VkPhysicalDevice physicalDevice,
                                                              VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties2(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties2(VkPhysicalDevice physicalDevice,
                                                                         const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo,
                                                                         uint32_t* pPropertyCount,
                                                                         VkSparseImageFormatProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount,
                                                                                     pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties,
                                                                           record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties2(physicalDevice, pFormatInfo, pPropertyCount,
                                                                            pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL TrimCommandPool(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTrimCommandPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTrimCommandPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTrimCommandPool(device, commandPool, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkTrimCommandPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTrimCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordTrimCommandPool(device, commandPool, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->TrimCommandPool(device, commandPool, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTrimCommandPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordTrimCommandPool(device, commandPool, flags, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceQueue2(VkDevice device, const VkDeviceQueueInfo2* pQueueInfo, VkQueue* pQueue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceQueue2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceQueue2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceQueue2(device, pQueueInfo, pQueue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceQueue2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceQueue2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceQueue2(device, pQueueInfo, pQueue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceQueue2(device, pQueueInfo, pQueue);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceQueue2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceQueue2(device, pQueueInfo, pQueue, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSamplerYcbcrConversion(VkDevice device, const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkSamplerYcbcrConversion* pYcbcrConversion) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSamplerYcbcrConversion, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSamplerYcbcrConversion]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSamplerYcbcrConversion);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSamplerYcbcrConversion]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSamplerYcbcrConversion]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSamplerYcbcrConversion(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySamplerYcbcrConversion(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySamplerYcbcrConversion, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySamplerYcbcrConversion]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySamplerYcbcrConversion);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySamplerYcbcrConversion]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySamplerYcbcrConversion]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySamplerYcbcrConversion(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorUpdateTemplate(VkDevice device,
                                                              const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorUpdateTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorUpdateTemplate]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                      error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorUpdateTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorUpdateTemplate]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorUpdateTemplate]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorUpdateTemplate(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                             record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorUpdateTemplate(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                           const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorUpdateTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorUpdateTemplate]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorUpdateTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorUpdateTemplate]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorUpdateTemplate]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorUpdateTemplate(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSetWithTemplate(VkDevice device, VkDescriptorSet descriptorSet,
                                                           VkDescriptorUpdateTemplate descriptorUpdateTemplate, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSetWithTemplate, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSetWithTemplate]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                       error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSetWithTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSetWithTemplate]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->UpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSetWithTemplate]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSetWithTemplate(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalBufferProperties(VkPhysicalDevice physicalDevice,
                                                                     const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
                                                                     VkExternalBufferProperties* pExternalBufferProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                                 pExternalBufferProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                       pExternalBufferProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                     pExternalBufferProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalBufferProperties(physicalDevice, pExternalBufferInfo,
                                                                        pExternalBufferProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalFenceProperties(VkPhysicalDevice physicalDevice,
                                                                    const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
                                                                    VkExternalFenceProperties* pExternalFenceProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalFenceProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo,
                                                                                pExternalFenceProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalFenceProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties,
                                                                      record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalFenceProperties(physicalDevice, pExternalFenceInfo, pExternalFenceProperties,
                                                                       record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalSemaphoreProperties(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphoreProperties,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                                    pExternalSemaphoreProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphoreProperties);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                          pExternalSemaphoreProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                        pExternalSemaphoreProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalSemaphoreProperties(physicalDevice, pExternalSemaphoreInfo,
                                                                           pExternalSemaphoreProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutSupport(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                         VkDescriptorSetLayoutSupport* pSupport) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutSupport, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutSupport]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutSupport);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutSupport]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutSupport]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutSupport(device, pCreateInfo, pSupport, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCount]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCount);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCount]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                  stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCount]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                   stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCount(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                       VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                       uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCount,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCount]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                   maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCount);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCount]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                         maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCount]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCount(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                          maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass2(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass2(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass2(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                               const VkSubpassBeginInfo* pSubpassBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass2(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass2(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo,
                                           const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass2(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass2(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndRenderPass2(commandBuffer, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass2(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL ResetQueryPool(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetQueryPool, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetQueryPool]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetQueryPool(device, queryPool, firstQuery, queryCount, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetQueryPool);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetQueryPool(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->ResetQueryPool(device, queryPool, firstQuery, queryCount);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetQueryPool]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetQueryPool(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreCounterValue(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreCounterValue, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreCounterValue]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreCounterValue(device, semaphore, pValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreCounterValue);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreCounterValue]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreCounterValue(device, semaphore, pValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSemaphoreCounterValue(device, semaphore, pValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreCounterValue]) {
            ValidationObject::BlockingOperationGuard lock(vo);

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetSemaphoreCounterValue(device, semaphore, pValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitSemaphores(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitSemaphores, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitSemaphores]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitSemaphores(device, pWaitInfo, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitSemaphores);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitSemaphores]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitSemaphores(device, pWaitInfo, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->WaitSemaphores(device, pWaitInfo, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitSemaphores]) {
            ValidationObject::BlockingOperationGuard lock(vo);

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordWaitSemaphores(device, pWaitInfo, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SignalSemaphore(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSignalSemaphore, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSignalSemaphore]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSignalSemaphore(device, pSignalInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSignalSemaphore);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSignalSemaphore]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSignalSemaphore(device, pSignalInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SignalSemaphore(device, pSignalInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSignalSemaphore]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSignalSemaphore(device, pSignalInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkDeviceAddress VKAPI_CALL GetBufferDeviceAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferDeviceAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferDeviceAddress]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferDeviceAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferDeviceAddress);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferDeviceAddress]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferDeviceAddress(device, pInfo, record_obj);
        }
    }
    VkDeviceAddress result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferDeviceAddress(device, pInfo);
    }
    record_obj.device_address = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferDeviceAddress]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferDeviceAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetBufferOpaqueCaptureAddress(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferOpaqueCaptureAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferOpaqueCaptureAddress]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferOpaqueCaptureAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferOpaqueCaptureAddress);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferOpaqueCaptureAddress]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferOpaqueCaptureAddress(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferOpaqueCaptureAddress]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetDeviceMemoryOpaqueCaptureAddress(VkDevice device,
                                                                   const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddress, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddress]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddress);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddress]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceMemoryOpaqueCaptureAddress(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddress]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryOpaqueCaptureAddress(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePrivateDataSlot(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkPrivateDataSlot* pPrivateDataSlot) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePrivateDataSlot, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePrivateDataSlot]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePrivateDataSlot);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePrivateDataSlot]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePrivateDataSlot]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePrivateDataSlot(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPrivateDataSlot(VkDevice device, VkPrivateDataSlot privateDataSlot,
                                                  const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPrivateDataSlot, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPrivateDataSlot]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPrivateDataSlot);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPrivateDataSlot]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPrivateDataSlot(device, privateDataSlot, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPrivateDataSlot]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPrivateDataSlot(device, privateDataSlot, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL SetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                              VkPrivateDataSlot privateDataSlot, uint64_t data) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetPrivateData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetPrivateData]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetPrivateData);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetPrivateData]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SetPrivateData(device, objectType, objectHandle, privateDataSlot, data);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetPrivateData]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetPrivateData(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPrivateData(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                          VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPrivateData, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPrivateData]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPrivateData);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPrivateData]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetPrivateData(device, objectType, objectHandle, privateDataSlot, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPrivateData]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPrivateData(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent2(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent2(commandBuffer, event, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent2(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetEvent2(commandBuffer, event, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent2(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent2(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent2(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent2(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResetEvent2(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent2(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents2(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                          const VkDependencyInfo* pDependencyInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents2(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier2(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier2(commandBuffer, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier2(commandBuffer, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPipelineBarrier2(commandBuffer, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier2(commandBuffer, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp2(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                              uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteTimestamp2(commandBuffer, stage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp2(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit2(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit2, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit2(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit2(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueSubmit2(queue, submitCount, pSubmits, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit2]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordQueueSubmit2(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer2(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBuffer2(commandBuffer, pCopyBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer2(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage2(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage2(commandBuffer, pCopyImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage2(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImage2(commandBuffer, pCopyImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage2(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage2(VkCommandBuffer commandBuffer,
                                                 const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage2(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer2(VkCommandBuffer commandBuffer,
                                                 const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer2(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage2(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage2(commandBuffer, pBlitImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage2(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBlitImage2(commandBuffer, pBlitImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage2(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage2(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage2(commandBuffer, pResolveImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage2(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResolveImage2(commandBuffer, pResolveImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage2(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRendering(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRendering, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRendering]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRendering(commandBuffer, pRenderingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRendering);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRendering]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRendering(commandBuffer, pRenderingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginRendering(commandBuffer, pRenderingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRendering]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRendering(commandBuffer, pRenderingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRendering(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRendering, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRendering]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRendering(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRendering);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRendering]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRendering(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndRendering(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRendering]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRendering(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCullMode(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCullMode, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCullMode]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCullMode(commandBuffer, cullMode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCullMode);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCullMode]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCullMode(commandBuffer, cullMode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetCullMode(commandBuffer, cullMode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCullMode]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCullMode(commandBuffer, cullMode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetFrontFace(VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFrontFace, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFrontFace]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFrontFace(commandBuffer, frontFace, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFrontFace);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFrontFace]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFrontFace(commandBuffer, frontFace, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetFrontFace(commandBuffer, frontFace);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFrontFace]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFrontFace(commandBuffer, frontFace, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetPrimitiveTopology(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPrimitiveTopology, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPrimitiveTopology]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPrimitiveTopology);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPrimitiveTopology]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetPrimitiveTopology(commandBuffer, primitiveTopology);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPrimitiveTopology]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPrimitiveTopology(commandBuffer, primitiveTopology, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportWithCount(VkCommandBuffer commandBuffer, uint32_t viewportCount,
                                                   const VkViewport* pViewports) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportWithCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportWithCount]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportWithCount);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportWithCount]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetViewportWithCount(commandBuffer, viewportCount, pViewports);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportWithCount]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportWithCount(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetScissorWithCount(VkCommandBuffer commandBuffer, uint32_t scissorCount, const VkRect2D* pScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetScissorWithCount, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetScissorWithCount]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetScissorWithCount);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetScissorWithCount]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetScissorWithCount(commandBuffer, scissorCount, pScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetScissorWithCount]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetScissorWithCount(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindVertexBuffers2(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
                                                 const VkBuffer* pBuffers, const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes,
                                                 const VkDeviceSize* pStrides) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindVertexBuffers2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindVertexBuffers2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                                             pStrides, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindVertexBuffers2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindVertexBuffers2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides,
                                                   record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindVertexBuffers2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindVertexBuffers2(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides,
                                                    record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthTestEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthTestEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthTestEnable(commandBuffer, depthTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthTestEnable(commandBuffer, depthTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthTestEnable(commandBuffer, depthTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthTestEnable(commandBuffer, depthTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthWriteEnable(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthWriteEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthWriteEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthWriteEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthWriteEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthWriteEnable(commandBuffer, depthWriteEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthWriteEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthWriteEnable(commandBuffer, depthWriteEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthCompareOp(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthCompareOp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthCompareOp]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthCompareOp(commandBuffer, depthCompareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthCompareOp);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthCompareOp]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthCompareOp(commandBuffer, depthCompareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthCompareOp(commandBuffer, depthCompareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthCompareOp]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthCompareOp(commandBuffer, depthCompareOp, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBoundsTestEnable(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBoundsTestEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBoundsTestEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBoundsTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBoundsTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBoundsTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBoundsTestEnable(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilTestEnable(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilTestEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilTestEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilTestEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilTestEnable(commandBuffer, stencilTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilTestEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilTestEnable(commandBuffer, stencilTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilOp(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp,
                                           VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilOp, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilOp]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilOp);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilOp]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilOp]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilOp(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRasterizerDiscardEnable(VkCommandBuffer commandBuffer, VkBool32 rasterizerDiscardEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRasterizerDiscardEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRasterizerDiscardEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRasterizerDiscardEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRasterizerDiscardEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRasterizerDiscardEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRasterizerDiscardEnable(commandBuffer, rasterizerDiscardEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBiasEnable(VkCommandBuffer commandBuffer, VkBool32 depthBiasEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBiasEnable, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBiasEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBiasEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBiasEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBiasEnable(commandBuffer, depthBiasEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBiasEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBiasEnable(commandBuffer, depthBiasEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetPrimitiveRestartEnable(VkCommandBuffer commandBuffer, VkBool32 primitiveRestartEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPrimitiveRestartEnable,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPrimitiveRestartEnable]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPrimitiveRestartEnable);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPrimitiveRestartEnable]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPrimitiveRestartEnable]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPrimitiveRestartEnable(commandBuffer, primitiveRestartEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceBufferMemoryRequirements(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
                                                             VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceBufferMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceBufferMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceBufferMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceBufferMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceBufferMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceBufferMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                            VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageMemoryRequirements(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSparseMemoryRequirements(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                                  uint32_t* pSparseMemoryRequirementCount,
                                                                  VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirements, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirements]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                              pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirements);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                    pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirements]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSparseMemoryRequirements(device, pInfo, pSparseMemoryRequirementCount,
                                                                     pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineStipple(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor,
                                             uint16_t lineStipplePattern) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineStipple, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineStipple]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineStipple);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineStipple]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineStipple]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineStipple(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory2(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory2(device, pMemoryMapInfo, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory2(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->MapMemory2(device, pMemoryMapInfo, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory2(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UnmapMemory2(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory2(device, pMemoryUnmapInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory2(device, pMemoryUnmapInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->UnmapMemory2(device, pMemoryUnmapInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory2(device, pMemoryUnmapInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer2(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                               VkDeviceSize size, VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer2(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderingAreaGranularity(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo,
                                                       VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderingAreaGranularity, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderingAreaGranularity]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderingAreaGranularity);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderingAreaGranularity]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderingAreaGranularity]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderingAreaGranularity(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSubresourceLayout(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo,
                                                           VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSubresourceLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSubresourceLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSubresourceLayout(device, pInfo, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSubresourceLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSubresourceLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSubresourceLayout(device, pInfo, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageSubresourceLayout(device, pInfo, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSubresourceLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSubresourceLayout(device, pInfo, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout2(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource,
                                                      VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout2, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout2(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout2(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSubresourceLayout2(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout2(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount,
                                                const VkWriteDescriptorSet* pDescriptorWrites) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                            pDescriptorWrites, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                  pDescriptorWrites, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                              pDescriptorWrites);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                   pDescriptorWrites, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate(VkCommandBuffer commandBuffer,
                                                            VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                            VkPipelineLayout layout, uint32_t set, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                        error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                              record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                               record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingAttachmentLocations(VkCommandBuffer commandBuffer,
                                                              const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingAttachmentLocations,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingAttachmentLocations]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingAttachmentLocations);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingAttachmentLocations]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingAttachmentLocations]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingAttachmentLocations(commandBuffer, pLocationInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingInputAttachmentIndices(
    VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndices,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndices]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndices);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndices]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndices]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingInputAttachmentIndices(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets2(VkCommandBuffer commandBuffer,
                                                  const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets2(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants2(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants2(commandBuffer, pPushConstantsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants2(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushConstants2(commandBuffer, pPushConstantsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants2(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet2(VkCommandBuffer commandBuffer,
                                                 const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet2, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet2]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet2(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate2(
    VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate2(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CopyMemoryToImage(VkDevice device, const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyMemoryToImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyMemoryToImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyMemoryToImage(device, pCopyMemoryToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyMemoryToImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyMemoryToImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyMemoryToImage(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyMemoryToImage(device, pCopyMemoryToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyMemoryToImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyMemoryToImage(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToMemory(VkDevice device, const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToMemory, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToMemory]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToMemory(device, pCopyImageToMemoryInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToMemory);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToMemory]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToMemory(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyImageToMemory(device, pCopyImageToMemoryInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToMemory]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToMemory(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToImage(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToImage, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToImage]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToImage(device, pCopyImageToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToImage);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToImage]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToImage(device, pCopyImageToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyImageToImage(device, pCopyImageToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToImage]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToImage(device, pCopyImageToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL TransitionImageLayout(VkDevice device, uint32_t transitionCount,
                                                     const VkHostImageLayoutTransitionInfo* pTransitions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTransitionImageLayout, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTransitionImageLayout]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTransitionImageLayout(device, transitionCount, pTransitions, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkTransitionImageLayout);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTransitionImageLayout]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordTransitionImageLayout(device, transitionCount, pTransitions, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->TransitionImageLayout(device, transitionCount, pTransitions);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTransitionImageLayout]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordTransitionImageLayout(device, transitionCount, pTransitions, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySurfaceKHR(VkInstance instance, VkSurfaceKHR surface, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySurfaceKHR(instance, surface, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySurfaceKHR(instance, surface, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->DestroySurfaceKHR(instance, surface, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySurfaceKHR(instance, surface, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceSupportKHR(VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex,
                                                                  VkSurfaceKHR surface, VkBool32* pSupported) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceSupportKHR(physicalDevice, queueFamilyIndex, surface, pSupported, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                       VkSurfaceCapabilitiesKHR* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities,
                                                                               error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilitiesKHR(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceFormatsKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                  uint32_t* pSurfaceFormatCount,
                                                                  VkSurfaceFormatKHR* pSurfaceFormats) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormatsKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount,
                                                                          pSurfaceFormats, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormatsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats,
                                                                record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->GetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceFormatsKHR(physicalDevice, surface, pSurfaceFormatCount, pSurfaceFormats,
                                                                 record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfacePresentModesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                       uint32_t* pPresentModeCount,
                                                                       VkPresentModeKHR* pPresentModes) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount,
                                                                               pPresentModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes,
                                                                     record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->GetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfacePresentModesKHR(physicalDevice, surface, pPresentModeCount, pPresentModes,
                                                                      record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSwapchainKHR(VkDevice device, const VkSwapchainCreateInfoKHR* pCreateInfo,
                                                  const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSwapchainKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSwapchainKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSwapchainKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSwapchainKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSwapchainKHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordCreateSwapchainKHR(device, pCreateInfo, pAllocator, pSwapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySwapchainKHR(VkDevice device, VkSwapchainKHR swapchain, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySwapchainKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySwapchainKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySwapchainKHR(device, swapchain, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySwapchainKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySwapchainKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySwapchainKHR(device, swapchain, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroySwapchainKHR(device, swapchain, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySwapchainKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySwapchainKHR(device, swapchain, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainImagesKHR(VkDevice device, VkSwapchainKHR swapchain, uint32_t* pSwapchainImageCount,
                                                     VkImage* pSwapchainImages) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainImagesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainImagesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainImagesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainImagesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainImagesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSwapchainImagesKHR(device, swapchain, pSwapchainImageCount, pSwapchainImages, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireNextImageKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t timeout,
                                                   VkSemaphore semaphore, VkFence fence, uint32_t* pImageIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireNextImageKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireNextImageKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireNextImageKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireNextImageKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireNextImageKHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordAcquireNextImageKHR(device, swapchain, timeout, semaphore, fence, pImageIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetDeviceGroupPresentCapabilitiesKHR(VkDevice device, VkDeviceGroupPresentCapabilitiesKHR* pDeviceGroupPresentCapabilities) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPresentCapabilitiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPresentCapabilitiesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPresentCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPresentCapabilitiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPresentCapabilitiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPresentCapabilitiesKHR(device, pDeviceGroupPresentCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeviceGroupSurfacePresentModesKHR(VkDevice device, VkSurfaceKHR surface,
                                                                    VkDeviceGroupPresentModeFlagsKHR* pModes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceGroupSurfacePresentModesKHR(device, surface, pModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupSurfacePresentModesKHR(device, surface, pModes, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDevicePresentRectanglesKHR(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                     uint32_t* pRectCount, VkRect2D* pRects) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDevicePresentRectanglesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDevicePresentRectanglesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDevicePresentRectanglesKHR(physicalDevice, surface, pRectCount, pRects, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireNextImage2KHR(VkDevice device, const VkAcquireNextImageInfoKHR* pAcquireInfo,
                                                    uint32_t* pImageIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireNextImage2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireNextImage2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireNextImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireNextImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AcquireNextImage2KHR(device, pAcquireInfo, pImageIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireNextImage2KHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordAcquireNextImage2KHR(device, pAcquireInfo, pImageIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                     VkDisplayPropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceDisplayPropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPlanePropertiesKHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                          VkDisplayPlanePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlanePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                                  error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlanePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceDisplayPlanePropertiesKHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneSupportedDisplaysKHR(VkPhysicalDevice physicalDevice, uint32_t planeIndex,
                                                                   uint32_t* pDisplayCount, VkDisplayKHR* pDisplays) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneSupportedDisplaysKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays,
                                                                           error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneSupportedDisplaysKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDisplayPlaneSupportedDisplaysKHR(physicalDevice, planeIndex, pDisplayCount, pDisplays, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayModePropertiesKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                           uint32_t* pPropertyCount, VkDisplayModePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayModePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayModePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDisplayModePropertiesKHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDisplayModeKHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                    const VkDisplayModeCreateInfoKHR* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkDisplayModeKHR* pMode) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDisplayModeKHR, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDisplayModeKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDisplayModeKHR(physicalDevice, display, pCreateInfo, pAllocator, pMode, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneCapabilitiesKHR(VkPhysicalDevice physicalDevice, VkDisplayModeKHR mode,
                                                              uint32_t planeIndex, VkDisplayPlaneCapabilitiesKHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDisplayPlaneCapabilitiesKHR(physicalDevice, mode, planeIndex, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDisplayPlaneSurfaceKHR(VkInstance instance, const VkDisplaySurfaceCreateInfoKHR* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDisplayPlaneSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDisplayPlaneSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDisplayPlaneSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSharedSwapchainsKHR(VkDevice device, uint32_t swapchainCount,
                                                         const VkSwapchainCreateInfoKHR* pCreateInfos,
                                                         const VkAllocationCallbacks* pAllocator, VkSwapchainKHR* pSwapchains) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSharedSwapchainsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSharedSwapchainsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains,
                                                                 error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSharedSwapchainsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSharedSwapchainsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSharedSwapchainsKHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordCreateSharedSwapchainsKHR(device, swapchainCount, pCreateInfos, pAllocator, pSwapchains, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_XLIB_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateXlibSurfaceKHR(VkInstance instance, const VkXlibSurfaceCreateInfoKHR* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateXlibSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateXlibSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateXlibSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceXlibPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                           uint32_t queueFamilyIndex, Display* dpy,
                                                                           VisualID visualID) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceXlibPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                                   error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceXlibPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                         record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceXlibPresentationSupportKHR(physicalDevice, queueFamilyIndex, dpy, visualID,
                                                                          record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XLIB_KHR
#ifdef VK_USE_PLATFORM_XCB_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateXcbSurfaceKHR(VkInstance instance, const VkXcbSurfaceCreateInfoKHR* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateXcbSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateXcbSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateXcbSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceXcbPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                          uint32_t queueFamilyIndex, xcb_connection_t* connection,
                                                                          xcb_visualid_t visual_id) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceXcbPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection,
                                                                                  visual_id, error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceXcbPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id,
                                                                        record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->GetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceXcbPresentationSupportKHR(physicalDevice, queueFamilyIndex, connection, visual_id,
                                                                         record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XCB_KHR
#ifdef VK_USE_PLATFORM_WAYLAND_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateWaylandSurfaceKHR(VkInstance instance, const VkWaylandSurfaceCreateInfoKHR* pCreateInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateWaylandSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateWaylandSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateWaylandSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceWaylandPresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                              uint32_t queueFamilyIndex,
                                                                              struct wl_display* display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceWaylandPresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display,
                                                                                      error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceWaylandPresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display, record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceWaylandPresentationSupportKHR(physicalDevice, queueFamilyIndex, display, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WAYLAND_KHR
#ifdef VK_USE_PLATFORM_ANDROID_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateAndroidSurfaceKHR(VkInstance instance, const VkAndroidSurfaceCreateInfoKHR* pCreateInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateAndroidSurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateAndroidSurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateAndroidSurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateWin32SurfaceKHR(VkInstance instance, const VkWin32SurfaceCreateInfoKHR* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateWin32SurfaceKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateWin32SurfaceKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateWin32SurfaceKHR(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceWin32PresentationSupportKHR(VkPhysicalDevice physicalDevice,
                                                                            uint32_t queueFamilyIndex) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceWin32PresentationSupportKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceWin32PresentationSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceWin32PresentationSupportKHR(physicalDevice, queueFamilyIndex, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoCapabilitiesKHR(VkPhysicalDevice physicalDevice,
                                                                     const VkVideoProfileInfoKHR* pVideoProfile,
                                                                     VkVideoCapabilitiesKHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoCapabilitiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoCapabilitiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceVideoCapabilitiesKHR(physicalDevice, pVideoProfile, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoFormatPropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                         const VkPhysicalDeviceVideoFormatInfoKHR* pVideoFormatInfo,
                                                                         uint32_t* pVideoFormatPropertyCount,
                                                                         VkVideoFormatPropertiesKHR* pVideoFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoFormatPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceVideoFormatPropertiesKHR(
                physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount, pVideoFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoFormatPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount,
                                                                       pVideoFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo,
                                                                              pVideoFormatPropertyCount, pVideoFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceVideoFormatPropertiesKHR(physicalDevice, pVideoFormatInfo, pVideoFormatPropertyCount,
                                                                        pVideoFormatProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateVideoSessionKHR(VkDevice device, const VkVideoSessionCreateInfoKHR* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkVideoSessionKHR* pVideoSession) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateVideoSessionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateVideoSessionKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateVideoSessionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateVideoSessionKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateVideoSessionKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateVideoSessionKHR(device, pCreateInfo, pAllocator, pVideoSession, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyVideoSessionKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                  const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyVideoSessionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyVideoSessionKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyVideoSessionKHR(device, videoSession, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyVideoSessionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyVideoSessionKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyVideoSessionKHR(device, videoSession, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyVideoSessionKHR(device, videoSession, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyVideoSessionKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyVideoSessionKHR(device, videoSession, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetVideoSessionMemoryRequirementsKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                                    uint32_t* pMemoryRequirementsCount,
                                                                    VkVideoSessionMemoryRequirementsKHR* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetVideoSessionMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetVideoSessionMemoryRequirementsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                            pMemoryRequirements, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetVideoSessionMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetVideoSessionMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                  pMemoryRequirements, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                       pMemoryRequirements);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetVideoSessionMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetVideoSessionMemoryRequirementsKHR(device, videoSession, pMemoryRequirementsCount,
                                                                   pMemoryRequirements, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindVideoSessionMemoryKHR(VkDevice device, VkVideoSessionKHR videoSession,
                                                         uint32_t bindSessionMemoryInfoCount,
                                                         const VkBindVideoSessionMemoryInfoKHR* pBindSessionMemoryInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindVideoSessionMemoryKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindVideoSessionMemoryKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount,
                                                                 pBindSessionMemoryInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindVideoSessionMemoryKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindVideoSessionMemoryKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos,
                                                       record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            device_dispatch->BindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindVideoSessionMemoryKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindVideoSessionMemoryKHR(device, videoSession, bindSessionMemoryInfoCount, pBindSessionMemoryInfos,
                                                        record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateVideoSessionParametersKHR(VkDevice device,
                                                               const VkVideoSessionParametersCreateInfoKHR* pCreateInfo,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               VkVideoSessionParametersKHR* pVideoSessionParameters) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateVideoSessionParametersKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters,
                                                                       error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateVideoSessionParametersKHR(device, pCreateInfo, pAllocator, pVideoSessionParameters, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UpdateVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters,
                                                               const VkVideoSessionParametersUpdateInfoKHR* pUpdateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateVideoSessionParametersKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->UpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateVideoSessionParametersKHR(device, videoSessionParameters, pUpdateInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyVideoSessionParametersKHR(VkDevice device, VkVideoSessionParametersKHR videoSessionParameters,
                                                            const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyVideoSessionParametersKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyVideoSessionParametersKHR(device, videoSessionParameters, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoBeginCodingInfoKHR* pBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginVideoCodingKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginVideoCodingKHR(commandBuffer, pBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginVideoCodingKHR(commandBuffer, pBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndVideoCodingKHR(VkCommandBuffer commandBuffer, const VkVideoEndCodingInfoKHR* pEndCodingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndVideoCodingKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndVideoCodingKHR(commandBuffer, pEndCodingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdControlVideoCodingKHR(VkCommandBuffer commandBuffer,
                                                    const VkVideoCodingControlInfoKHR* pCodingControlInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdControlVideoCodingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdControlVideoCodingKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdControlVideoCodingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdControlVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdControlVideoCodingKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdControlVideoCodingKHR(commandBuffer, pCodingControlInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDecodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoDecodeInfoKHR* pDecodeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDecodeVideoKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDecodeVideoKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDecodeVideoKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDecodeVideoKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDecodeVideoKHR(commandBuffer, pDecodeInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDecodeVideoKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDecodeVideoKHR(commandBuffer, pDecodeInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderingKHR(VkCommandBuffer commandBuffer, const VkRenderingInfo* pRenderingInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderingKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderingKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginRenderingKHR(commandBuffer, pRenderingInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderingKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderingKHR(commandBuffer, pRenderingInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderingKHR(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderingKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderingKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderingKHR(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderingKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderingKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderingKHR(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndRenderingKHR(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderingKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderingKHR(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFeatures2KHR(VkPhysicalDevice physicalDevice, VkPhysicalDeviceFeatures2* pFeatures) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFeatures2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFeatures2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFeatures2KHR(physicalDevice, pFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceProperties2KHR(VkPhysicalDevice physicalDevice,
                                                           VkPhysicalDeviceProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceProperties2KHR(physicalDevice, pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceProperties2KHR(physicalDevice, pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceFormatProperties2KHR(VkPhysicalDevice physicalDevice, VkFormat format,
                                                                 VkFormatProperties2* pFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFormatProperties2KHR(physicalDevice, format, pFormatProperties, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceImageFormatProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                          const VkPhysicalDeviceImageFormatInfo2* pImageFormatInfo,
                                                                          VkImageFormatProperties2* pImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo,
                                                                                  pImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceImageFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            instance_dispatch->GetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceImageFormatProperties2KHR(physicalDevice, pImageFormatInfo, pImageFormatProperties,
                                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                      uint32_t* pQueueFamilyPropertyCount,
                                                                      VkQueueFamilyProperties2* pQueueFamilyProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                                  pQueueFamilyProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                        pQueueFamilyProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                      pQueueFamilyProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyProperties2KHR(physicalDevice, pQueueFamilyPropertyCount,
                                                                         pQueueFamilyProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMemoryProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                 VkPhysicalDeviceMemoryProperties2* pMemoryProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMemoryProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceMemoryProperties2KHR(physicalDevice, pMemoryProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceSparseImageFormatProperties2KHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceSparseImageFormatInfo2* pFormatInfo, uint32_t* pPropertyCount,
    VkSparseImageFormatProperties2* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                                        pProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSparseImageFormatProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                              pProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                            pProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSparseImageFormatProperties2KHR(physicalDevice, pFormatInfo, pPropertyCount,
                                                                               pProperties, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceGroupPeerMemoryFeaturesKHR(VkDevice device, uint32_t heapIndex, uint32_t localDeviceIndex,
                                                               uint32_t remoteDeviceIndex,
                                                               VkPeerMemoryFeatureFlags* pPeerMemoryFeatures) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeaturesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                           pPeerMemoryFeatures, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupPeerMemoryFeaturesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                 pPeerMemoryFeatures, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                             pPeerMemoryFeatures);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR(device, heapIndex, localDeviceIndex, remoteDeviceIndex,
                                                                  pPeerMemoryFeatures, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDeviceMaskKHR(VkCommandBuffer commandBuffer, uint32_t deviceMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDeviceMaskKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDeviceMaskKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDeviceMaskKHR(commandBuffer, deviceMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDeviceMaskKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDeviceMaskKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDeviceMaskKHR(commandBuffer, deviceMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDeviceMaskKHR(commandBuffer, deviceMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDeviceMaskKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDeviceMaskKHR(commandBuffer, deviceMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchBaseKHR(VkCommandBuffer commandBuffer, uint32_t baseGroupX, uint32_t baseGroupY,
                                              uint32_t baseGroupZ, uint32_t groupCountX, uint32_t groupCountY,
                                              uint32_t groupCountZ) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchBaseKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchBaseKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX,
                                                          groupCountY, groupCountZ, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchBaseKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchBaseKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                groupCountZ, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                            groupCountZ);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchBaseKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchBaseKHR(commandBuffer, baseGroupX, baseGroupY, baseGroupZ, groupCountX, groupCountY,
                                                 groupCountZ, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL TrimCommandPoolKHR(VkDevice device, VkCommandPool commandPool, VkCommandPoolTrimFlags flags) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTrimCommandPoolKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTrimCommandPoolKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTrimCommandPoolKHR(device, commandPool, flags, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkTrimCommandPoolKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTrimCommandPoolKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordTrimCommandPoolKHR(device, commandPool, flags, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->TrimCommandPoolKHR(device, commandPool, flags);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTrimCommandPoolKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordTrimCommandPoolKHR(device, commandPool, flags, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceGroupsKHR(VkInstance instance, uint32_t* pPhysicalDeviceGroupCount,
                                                                VkPhysicalDeviceGroupProperties* pPhysicalDeviceGroupProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceGroupsKHR, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount,
                                                                        pPhysicalDeviceGroupProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceGroupsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                              record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->EnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount,
                                                                     pPhysicalDeviceGroupProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordEnumeratePhysicalDeviceGroupsKHR(instance, pPhysicalDeviceGroupCount, pPhysicalDeviceGroupProperties,
                                                               record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalBufferPropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalBufferInfo* pExternalBufferInfo,
    VkExternalBufferProperties* pExternalBufferProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                                    pExternalBufferProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalBufferPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                          pExternalBufferProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                        pExternalBufferProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalBufferPropertiesKHR(physicalDevice, pExternalBufferInfo,
                                                                           pExternalBufferProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandleKHR(VkDevice device, const VkMemoryGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                       HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandlePropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType,
                                                                 HANDLE handle,
                                                                 VkMemoryWin32HandlePropertiesKHR* pMemoryWin32HandleProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandlePropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandlePropertiesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandlePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandlePropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandlePropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandlePropertiesKHR(device, handleType, handle, pMemoryWin32HandleProperties,
                                                                record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryFdKHR(VkDevice device, const VkMemoryGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryFdKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryFdPropertiesKHR(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, int fd,
                                                        VkMemoryFdPropertiesKHR* pMemoryFdProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryFdPropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryFdPropertiesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryFdPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryFdPropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryFdPropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryFdPropertiesKHR(device, handleType, fd, pMemoryFdProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalSemaphorePropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceExternalSemaphoreInfo* pExternalSemaphoreInfo,
    VkExternalSemaphoreProperties* pExternalSemaphoreProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                                       pExternalSemaphoreProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalSemaphorePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                             pExternalSemaphoreProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                           pExternalSemaphoreProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalSemaphorePropertiesKHR(physicalDevice, pExternalSemaphoreInfo,
                                                                              pExternalSemaphoreProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL
ImportSemaphoreWin32HandleKHR(VkDevice device, const VkImportSemaphoreWin32HandleInfoKHR* pImportSemaphoreWin32HandleInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportSemaphoreWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportSemaphoreWin32HandleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportSemaphoreWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportSemaphoreWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportSemaphoreWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportSemaphoreWin32HandleKHR(device, pImportSemaphoreWin32HandleInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreWin32HandleKHR(VkDevice device,
                                                          const VkSemaphoreGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                          HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreWin32HandleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSemaphoreWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportSemaphoreFdKHR(VkDevice device, const VkImportSemaphoreFdInfoKHR* pImportSemaphoreFdInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportSemaphoreFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportSemaphoreFdKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportSemaphoreFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportSemaphoreFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportSemaphoreFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportSemaphoreFdKHR(device, pImportSemaphoreFdInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreFdKHR(VkDevice device, const VkSemaphoreGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreFdKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSemaphoreFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSemaphoreFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetKHR(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                   VkPipelineLayout layout, uint32_t set, uint32_t descriptorWriteCount,
                                                   const VkWriteDescriptorSet* pDescriptorWrites) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                               pDescriptorWrites, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                     pDescriptorWrites, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                 pDescriptorWrites);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetKHR(commandBuffer, pipelineBindPoint, layout, set, descriptorWriteCount,
                                                      pDescriptorWrites, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplateKHR(VkCommandBuffer commandBuffer,
                                                               VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                               VkPipelineLayout layout, uint32_t set, const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplateKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplateKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set,
                                                                           pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                 record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplateKHR(commandBuffer, descriptorUpdateTemplate, layout, set, pData,
                                                                  record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDescriptorUpdateTemplateKHR(VkDevice device,
                                                                 const VkDescriptorUpdateTemplateCreateInfo* pCreateInfo,
                                                                 const VkAllocationCallbacks* pAllocator,
                                                                 VkDescriptorUpdateTemplate* pDescriptorUpdateTemplate) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDescriptorUpdateTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDescriptorUpdateTemplateKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDescriptorUpdateTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDescriptorUpdateTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDescriptorUpdateTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDescriptorUpdateTemplateKHR(device, pCreateInfo, pAllocator, pDescriptorUpdateTemplate,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDescriptorUpdateTemplateKHR(VkDevice device, VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                              const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDescriptorUpdateTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDescriptorUpdateTemplateKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDescriptorUpdateTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDescriptorUpdateTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDescriptorUpdateTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDescriptorUpdateTemplateKHR(device, descriptorUpdateTemplate, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL UpdateDescriptorSetWithTemplateKHR(VkDevice device, VkDescriptorSet descriptorSet,
                                                              VkDescriptorUpdateTemplate descriptorUpdateTemplate,
                                                              const void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUpdateDescriptorSetWithTemplateKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUpdateDescriptorSetWithTemplateKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                          error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUpdateDescriptorSetWithTemplateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUpdateDescriptorSetWithTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->UpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUpdateDescriptorSetWithTemplateKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUpdateDescriptorSetWithTemplateKHR(device, descriptorSet, descriptorUpdateTemplate, pData,
                                                                 record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateRenderPass2KHR(VkDevice device, const VkRenderPassCreateInfo2* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkRenderPass* pRenderPass) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateRenderPass2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateRenderPass2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateRenderPass2KHR(device, pCreateInfo, pAllocator, pRenderPass, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBeginRenderPass2KHR(VkCommandBuffer commandBuffer, const VkRenderPassBeginInfo* pRenderPassBegin,
                                                  const VkSubpassBeginInfo* pSubpassBeginInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginRenderPass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginRenderPass2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginRenderPass2KHR(commandBuffer, pRenderPassBegin, pSubpassBeginInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdNextSubpass2KHR(VkCommandBuffer commandBuffer, const VkSubpassBeginInfo* pSubpassBeginInfo,
                                              const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdNextSubpass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdNextSubpass2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdNextSubpass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdNextSubpass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdNextSubpass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdNextSubpass2KHR(commandBuffer, pSubpassBeginInfo, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndRenderPass2KHR(VkCommandBuffer commandBuffer, const VkSubpassEndInfo* pSubpassEndInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndRenderPass2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndRenderPass2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndRenderPass2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndRenderPass2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndRenderPass2KHR(commandBuffer, pSubpassEndInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainStatusKHR(VkDevice device, VkSwapchainKHR swapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainStatusKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainStatusKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainStatusKHR(device, swapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainStatusKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainStatusKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainStatusKHR(device, swapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSwapchainStatusKHR(device, swapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainStatusKHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetSwapchainStatusKHR(device, swapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceExternalFencePropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                       const VkPhysicalDeviceExternalFenceInfo* pExternalFenceInfo,
                                                                       VkExternalFenceProperties* pExternalFenceProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalFencePropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                                   pExternalFenceProperties, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalFencePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                         pExternalFenceProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                       pExternalFenceProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalFencePropertiesKHR(physicalDevice, pExternalFenceInfo,
                                                                          pExternalFenceProperties, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportFenceWin32HandleKHR(VkDevice device,
                                                         const VkImportFenceWin32HandleInfoKHR* pImportFenceWin32HandleInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportFenceWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportFenceWin32HandleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportFenceWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportFenceWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportFenceWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportFenceWin32HandleKHR(device, pImportFenceWin32HandleInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceWin32HandleKHR(VkDevice device, const VkFenceGetWin32HandleInfoKHR* pGetWin32HandleInfo,
                                                      HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceWin32HandleKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceWin32HandleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceWin32HandleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceWin32HandleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetFenceWin32HandleKHR(device, pGetWin32HandleInfo, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL ImportFenceFdKHR(VkDevice device, const VkImportFenceFdInfoKHR* pImportFenceFdInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportFenceFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportFenceFdKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportFenceFdKHR(device, pImportFenceFdInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportFenceFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportFenceFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportFenceFdKHR(device, pImportFenceFdInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ImportFenceFdKHR(device, pImportFenceFdInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportFenceFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportFenceFdKHR(device, pImportFenceFdInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetFenceFdKHR(VkDevice device, const VkFenceGetFdInfoKHR* pGetFdInfo, int* pFd) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetFenceFdKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetFenceFdKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetFenceFdKHR(device, pGetFdInfo, pFd, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetFenceFdKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetFenceFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetFenceFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetFenceFdKHR(device, pGetFdInfo, pFd);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetFenceFdKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetFenceFdKHR(device, pGetFdInfo, pFd, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
    VkPhysicalDevice physicalDevice, uint32_t queueFamilyIndex, uint32_t* pCounterCount, VkPerformanceCounterKHR* pCounters,
    VkPerformanceCounterDescriptionKHR* pCounterDescriptions) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->EnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
            physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordEnumeratePhysicalDeviceQueueFamilyPerformanceQueryCountersKHR(
                physicalDevice, queueFamilyIndex, pCounterCount, pCounters, pCounterDescriptions, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
    VkPhysicalDevice physicalDevice, const VkQueryPoolPerformanceCreateInfoKHR* pPerformanceQueryCreateInfo, uint32_t* pNumPasses) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(
                physicalDevice, pPerformanceQueryCreateInfo, pNumPasses, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                   pNumPasses, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                 pNumPasses);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceQueueFamilyPerformanceQueryPassesKHR(physicalDevice, pPerformanceQueryCreateInfo,
                                                                                    pNumPasses, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireProfilingLockKHR(VkDevice device, const VkAcquireProfilingLockInfoKHR* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireProfilingLockKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireProfilingLockKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireProfilingLockKHR(device, pInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireProfilingLockKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireProfilingLockKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireProfilingLockKHR(device, pInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AcquireProfilingLockKHR(device, pInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireProfilingLockKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireProfilingLockKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL ReleaseProfilingLockKHR(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseProfilingLockKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseProfilingLockKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseProfilingLockKHR(device, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseProfilingLockKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseProfilingLockKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseProfilingLockKHR(device, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->ReleaseProfilingLockKHR(device);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseProfilingLockKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseProfilingLockKHR(device, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilities2KHR(VkPhysicalDevice physicalDevice,
                                                                        const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                        VkSurfaceCapabilities2KHR* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                                error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                      record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilities2KHR(physicalDevice, pSurfaceInfo, pSurfaceCapabilities,
                                                                       record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceFormats2KHR(VkPhysicalDevice physicalDevice,
                                                                   const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                   uint32_t* pSurfaceFormatCount,
                                                                   VkSurfaceFormat2KHR* pSurfaceFormats) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormats2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                           pSurfaceFormats, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceFormats2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount, pSurfaceFormats,
                                                                 record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                        pSurfaceFormats);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceFormats2KHR(physicalDevice, pSurfaceInfo, pSurfaceFormatCount,
                                                                  pSurfaceFormats, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayProperties2KHR(VkPhysicalDevice physicalDevice, uint32_t* pPropertyCount,
                                                                      VkDisplayProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceDisplayProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceDisplayPlaneProperties2KHR(VkPhysicalDevice physicalDevice,
                                                                           uint32_t* pPropertyCount,
                                                                           VkDisplayPlaneProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlaneProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties,
                                                                                   error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDisplayPlaneProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceDisplayPlaneProperties2KHR(physicalDevice, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayModeProperties2KHR(VkPhysicalDevice physicalDevice, VkDisplayKHR display,
                                                            uint32_t* pPropertyCount, VkDisplayModeProperties2KHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayModeProperties2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayModeProperties2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDisplayModeProperties2KHR(physicalDevice, display, pPropertyCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDisplayPlaneCapabilities2KHR(VkPhysicalDevice physicalDevice,
                                                               const VkDisplayPlaneInfo2KHR* pDisplayPlaneInfo,
                                                               VkDisplayPlaneCapabilities2KHR* pCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDisplayPlaneCapabilities2KHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDisplayPlaneCapabilities2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDisplayPlaneCapabilities2KHR(physicalDevice, pDisplayPlaneInfo, pCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetImageMemoryRequirements2KHR(VkDevice device, const VkImageMemoryRequirementsInfo2* pInfo,
                                                          VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageMemoryRequirements2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetBufferMemoryRequirements2KHR(VkDevice device, const VkBufferMemoryRequirementsInfo2* pInfo,
                                                           VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferMemoryRequirements2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferMemoryRequirements2KHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSparseMemoryRequirements2KHR(VkDevice device, const VkImageSparseMemoryRequirementsInfo2* pInfo,
                                                                uint32_t* pSparseMemoryRequirementCount,
                                                                VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSparseMemoryRequirements2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSparseMemoryRequirements2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                            pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSparseMemoryRequirements2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSparseMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                  pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                              pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSparseMemoryRequirements2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSparseMemoryRequirements2KHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                   pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateSamplerYcbcrConversionKHR(VkDevice device,
                                                               const VkSamplerYcbcrConversionCreateInfo* pCreateInfo,
                                                               const VkAllocationCallbacks* pAllocator,
                                                               VkSamplerYcbcrConversion* pYcbcrConversion) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateSamplerYcbcrConversionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateSamplerYcbcrConversionKHR]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateSamplerYcbcrConversionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateSamplerYcbcrConversionKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateSamplerYcbcrConversionKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateSamplerYcbcrConversionKHR(device, pCreateInfo, pAllocator, pYcbcrConversion, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroySamplerYcbcrConversionKHR(VkDevice device, VkSamplerYcbcrConversion ycbcrConversion,
                                                            const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroySamplerYcbcrConversionKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroySamplerYcbcrConversionKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroySamplerYcbcrConversionKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroySamplerYcbcrConversionKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroySamplerYcbcrConversionKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroySamplerYcbcrConversionKHR(device, ycbcrConversion, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindBufferMemory2KHR(VkDevice device, uint32_t bindInfoCount,
                                                    const VkBindBufferMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindBufferMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindBufferMemory2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindBufferMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindBufferMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindBufferMemory2KHR(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindBufferMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindBufferMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL BindImageMemory2KHR(VkDevice device, uint32_t bindInfoCount,
                                                   const VkBindImageMemoryInfo* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindImageMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindImageMemory2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindImageMemory2KHR(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindImageMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindImageMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindImageMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindImageMemory2KHR(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindImageMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindImageMemory2KHR(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutSupportKHR(VkDevice device, const VkDescriptorSetLayoutCreateInfo* pCreateInfo,
                                                            VkDescriptorSetLayoutSupport* pSupport) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutSupportKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutSupportKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutSupportKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutSupportKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutSupportKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutSupportKHR(device, pCreateInfo, pSupport, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                   VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                   uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCountKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCountKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                               maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCountKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCountKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                 stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCountKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                      stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCountKHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                          VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                          uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCountKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCountKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                      maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCountKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCountKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                        stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCountKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCountKHR(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreCounterValueKHR(VkDevice device, VkSemaphore semaphore, uint64_t* pValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreCounterValueKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreCounterValueKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreCounterValueKHR(device, semaphore, pValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreCounterValueKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreCounterValueKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreCounterValueKHR(device, semaphore, pValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSemaphoreCounterValueKHR(device, semaphore, pValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreCounterValueKHR]) {
            ValidationObject::BlockingOperationGuard lock(vo);

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetSemaphoreCounterValueKHR(device, semaphore, pValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL WaitSemaphoresKHR(VkDevice device, const VkSemaphoreWaitInfo* pWaitInfo, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitSemaphoresKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitSemaphoresKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitSemaphoresKHR(device, pWaitInfo, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitSemaphoresKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitSemaphoresKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitSemaphoresKHR(device, pWaitInfo, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->WaitSemaphoresKHR(device, pWaitInfo, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitSemaphoresKHR]) {
            ValidationObject::BlockingOperationGuard lock(vo);

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordWaitSemaphoresKHR(device, pWaitInfo, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SignalSemaphoreKHR(VkDevice device, const VkSemaphoreSignalInfo* pSignalInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSignalSemaphoreKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSignalSemaphoreKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSignalSemaphoreKHR(device, pSignalInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSignalSemaphoreKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSignalSemaphoreKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSignalSemaphoreKHR(device, pSignalInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SignalSemaphoreKHR(device, pSignalInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSignalSemaphoreKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSignalSemaphoreKHR(device, pSignalInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetPhysicalDeviceFragmentShadingRatesKHR(VkPhysicalDevice physicalDevice, uint32_t* pFragmentShadingRateCount,
                                         VkPhysicalDeviceFragmentShadingRateKHR* pFragmentShadingRates) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceFragmentShadingRatesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                                pFragmentShadingRates, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceFragmentShadingRatesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                      pFragmentShadingRates, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                             pFragmentShadingRates);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceFragmentShadingRatesKHR(physicalDevice, pFragmentShadingRateCount,
                                                                       pFragmentShadingRates, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetFragmentShadingRateKHR(VkCommandBuffer commandBuffer, const VkExtent2D* pFragmentSize,
                                                        const VkFragmentShadingRateCombinerOpKHR combinerOps[2]) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFragmentShadingRateKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFragmentShadingRateKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFragmentShadingRateKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFragmentShadingRateKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFragmentShadingRateKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFragmentShadingRateKHR(commandBuffer, pFragmentSize, combinerOps, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingAttachmentLocationsKHR(VkCommandBuffer commandBuffer,
                                                                 const VkRenderingAttachmentLocationInfo* pLocationInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingAttachmentLocationsKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingAttachmentLocationsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingAttachmentLocationsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingAttachmentLocationsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingAttachmentLocationsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingAttachmentLocationsKHR(commandBuffer, pLocationInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetRenderingInputAttachmentIndicesKHR(
    VkCommandBuffer commandBuffer, const VkRenderingInputAttachmentIndexInfo* pInputAttachmentIndexInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndicesKHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndicesKHR]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetRenderingInputAttachmentIndicesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndicesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndicesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetRenderingInputAttachmentIndicesKHR(commandBuffer, pInputAttachmentIndexInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL WaitForPresentKHR(VkDevice device, VkSwapchainKHR swapchain, uint64_t presentId, uint64_t timeout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkWaitForPresentKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateWaitForPresentKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateWaitForPresentKHR(device, swapchain, presentId, timeout, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkWaitForPresentKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordWaitForPresentKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordWaitForPresentKHR(device, swapchain, presentId, timeout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->WaitForPresentKHR(device, swapchain, presentId, timeout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordWaitForPresentKHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordWaitForPresentKHR(device, swapchain, presentId, timeout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkDeviceAddress VKAPI_CALL GetBufferDeviceAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferDeviceAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferDeviceAddressKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferDeviceAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferDeviceAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferDeviceAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferDeviceAddressKHR(device, pInfo, record_obj);
        }
    }
    VkDeviceAddress result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferDeviceAddressKHR(device, pInfo);
    }
    record_obj.device_address = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferDeviceAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferDeviceAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetBufferOpaqueCaptureAddressKHR(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferOpaqueCaptureAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferOpaqueCaptureAddressKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferOpaqueCaptureAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferOpaqueCaptureAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferOpaqueCaptureAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferOpaqueCaptureAddressKHR(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferOpaqueCaptureAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetDeviceMemoryOpaqueCaptureAddressKHR(VkDevice device,
                                                                      const VkDeviceMemoryOpaqueCaptureAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddressKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceMemoryOpaqueCaptureAddressKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDeferredOperationKHR(VkDevice device, const VkAllocationCallbacks* pAllocator,
                                                          VkDeferredOperationKHR* pDeferredOperation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDeferredOperationKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateDeferredOperationKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDeferredOperationKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateDeferredOperationKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateDeferredOperationKHR(device, pAllocator, pDeferredOperation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateDeferredOperationKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDeferredOperationKHR(device, pAllocator, pDeferredOperation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDeferredOperationKHR(VkDevice device, VkDeferredOperationKHR operation,
                                                       const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDeferredOperationKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyDeferredOperationKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDeferredOperationKHR(device, operation, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDeferredOperationKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyDeferredOperationKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDeferredOperationKHR(device, operation, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyDeferredOperationKHR(device, operation, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyDeferredOperationKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDeferredOperationKHR(device, operation, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR uint32_t VKAPI_CALL GetDeferredOperationMaxConcurrencyKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeferredOperationMaxConcurrencyKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeferredOperationMaxConcurrencyKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeferredOperationMaxConcurrencyKHR(device, operation, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeferredOperationMaxConcurrencyKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeferredOperationMaxConcurrencyKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeferredOperationMaxConcurrencyKHR(device, operation, record_obj);
        }
    }
    uint32_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeferredOperationMaxConcurrencyKHR(device, operation);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeferredOperationMaxConcurrencyKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeferredOperationMaxConcurrencyKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeferredOperationResultKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeferredOperationResultKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeferredOperationResultKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeferredOperationResultKHR(device, operation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeferredOperationResultKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeferredOperationResultKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeferredOperationResultKHR(device, operation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeferredOperationResultKHR(device, operation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeferredOperationResultKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeferredOperationResultKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DeferredOperationJoinKHR(VkDevice device, VkDeferredOperationKHR operation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDeferredOperationJoinKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDeferredOperationJoinKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDeferredOperationJoinKHR(device, operation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDeferredOperationJoinKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDeferredOperationJoinKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDeferredOperationJoinKHR(device, operation, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->DeferredOperationJoinKHR(device, operation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDeferredOperationJoinKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDeferredOperationJoinKHR(device, operation, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutablePropertiesKHR(VkDevice device, const VkPipelineInfoKHR* pPipelineInfo,
                                                                  uint32_t* pExecutableCount,
                                                                  VkPipelineExecutablePropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutablePropertiesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutablePropertiesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutablePropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutablePropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutablePropertiesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutablePropertiesKHR(device, pPipelineInfo, pExecutableCount, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutableStatisticsKHR(VkDevice device,
                                                                  const VkPipelineExecutableInfoKHR* pExecutableInfo,
                                                                  uint32_t* pStatisticCount,
                                                                  VkPipelineExecutableStatisticKHR* pStatistics) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutableStatisticsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutableStatisticsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutableStatisticsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutableStatisticsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutableStatisticsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutableStatisticsKHR(device, pExecutableInfo, pStatisticCount, pStatistics, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineExecutableInternalRepresentationsKHR(
    VkDevice device, const VkPipelineExecutableInfoKHR* pExecutableInfo, uint32_t* pInternalRepresentationCount,
    VkPipelineExecutableInternalRepresentationKHR* pInternalRepresentations) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineExecutableInternalRepresentationsKHR,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineExecutableInternalRepresentationsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineExecutableInternalRepresentationsKHR(
                device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineExecutableInternalRepresentationsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineExecutableInternalRepresentationsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount,
                                                                             pInternalRepresentations, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineExecutableInternalRepresentationsKHR(
            device, pExecutableInfo, pInternalRepresentationCount, pInternalRepresentations);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineExecutableInternalRepresentationsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineExecutableInternalRepresentationsKHR(device, pExecutableInfo, pInternalRepresentationCount,
                                                                              pInternalRepresentations, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL MapMemory2KHR(VkDevice device, const VkMemoryMapInfo* pMemoryMapInfo, void** ppData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkMapMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateMapMemory2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateMapMemory2KHR(device, pMemoryMapInfo, ppData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkMapMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordMapMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordMapMemory2KHR(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->MapMemory2KHR(device, pMemoryMapInfo, ppData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordMapMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordMapMemory2KHR(device, pMemoryMapInfo, ppData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL UnmapMemory2KHR(VkDevice device, const VkMemoryUnmapInfo* pMemoryUnmapInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUnmapMemory2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUnmapMemory2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUnmapMemory2KHR(device, pMemoryUnmapInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkUnmapMemory2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUnmapMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUnmapMemory2KHR(device, pMemoryUnmapInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->UnmapMemory2KHR(device, pMemoryUnmapInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUnmapMemory2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUnmapMemory2KHR(device, pMemoryUnmapInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(
    VkPhysicalDevice physicalDevice, const VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR* pQualityLevelInfo,
    VkVideoEncodeQualityLevelPropertiesKHR* pQualityLevelProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                             pQualityLevelProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                   pQualityLevelProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                          pQualityLevelProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceVideoEncodeQualityLevelPropertiesKHR(physicalDevice, pQualityLevelInfo,
                                                                                    pQualityLevelProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetEncodedVideoSessionParametersKHR(VkDevice device, const VkVideoEncodeSessionParametersGetInfoKHR* pVideoSessionParametersInfo,
                                    VkVideoEncodeSessionParametersFeedbackInfoKHR* pFeedbackInfo, size_t* pDataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetEncodedVideoSessionParametersKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetEncodedVideoSessionParametersKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo,
                                                                           pDataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetEncodedVideoSessionParametersKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetEncodedVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                 pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                      pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetEncodedVideoSessionParametersKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetEncodedVideoSessionParametersKHR(device, pVideoSessionParametersInfo, pFeedbackInfo, pDataSize,
                                                                  pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdEncodeVideoKHR(VkCommandBuffer commandBuffer, const VkVideoEncodeInfoKHR* pEncodeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEncodeVideoKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEncodeVideoKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEncodeVideoKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEncodeVideoKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEncodeVideoKHR(commandBuffer, pEncodeInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEncodeVideoKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEncodeVideoKHR(commandBuffer, pEncodeInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetEvent2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetEvent2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetEvent2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetEvent2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetEvent2KHR(commandBuffer, event, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetEvent2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetEvent2KHR(commandBuffer, event, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResetEvent2KHR(VkCommandBuffer commandBuffer, VkEvent event, VkPipelineStageFlags2 stageMask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResetEvent2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResetEvent2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResetEvent2KHR(commandBuffer, event, stageMask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResetEvent2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResetEvent2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResetEvent2KHR(commandBuffer, event, stageMask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResetEvent2KHR(commandBuffer, event, stageMask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResetEvent2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResetEvent2KHR(commandBuffer, event, stageMask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWaitEvents2KHR(VkCommandBuffer commandBuffer, uint32_t eventCount, const VkEvent* pEvents,
                                             const VkDependencyInfo* pDependencyInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWaitEvents2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWaitEvents2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWaitEvents2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWaitEvents2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWaitEvents2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWaitEvents2KHR(commandBuffer, eventCount, pEvents, pDependencyInfos, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPipelineBarrier2KHR(VkCommandBuffer commandBuffer, const VkDependencyInfo* pDependencyInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPipelineBarrier2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPipelineBarrier2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPipelineBarrier2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPipelineBarrier2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPipelineBarrier2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPipelineBarrier2KHR(commandBuffer, pDependencyInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteTimestamp2KHR(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkQueryPool queryPool,
                                                 uint32_t query) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteTimestamp2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteTimestamp2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteTimestamp2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteTimestamp2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteTimestamp2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteTimestamp2KHR(commandBuffer, stage, queryPool, query, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSubmit2KHR(VkQueue queue, uint32_t submitCount, const VkSubmitInfo2* pSubmits, VkFence fence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSubmit2KHR, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSubmit2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSubmit2KHR(queue, submitCount, pSubmits, fence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSubmit2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSubmit2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSubmit2KHR(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueSubmit2KHR(queue, submitCount, pSubmits, fence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSubmit2KHR]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordQueueSubmit2KHR(queue, submitCount, pSubmits, fence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBuffer2KHR(VkCommandBuffer commandBuffer, const VkCopyBufferInfo2* pCopyBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBuffer2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBuffer2KHR(commandBuffer, pCopyBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImage2KHR(VkCommandBuffer commandBuffer, const VkCopyImageInfo2* pCopyImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImage2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImage2KHR(commandBuffer, pCopyImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImage2KHR(commandBuffer, pCopyImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyBufferToImage2KHR(VkCommandBuffer commandBuffer,
                                                    const VkCopyBufferToImageInfo2* pCopyBufferToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyBufferToImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyBufferToImage2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyBufferToImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyBufferToImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyBufferToImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyBufferToImage2KHR(commandBuffer, pCopyBufferToImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyImageToBuffer2KHR(VkCommandBuffer commandBuffer,
                                                    const VkCopyImageToBufferInfo2* pCopyImageToBufferInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyImageToBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyImageToBuffer2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyImageToBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyImageToBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyImageToBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyImageToBuffer2KHR(commandBuffer, pCopyImageToBufferInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBlitImage2KHR(VkCommandBuffer commandBuffer, const VkBlitImageInfo2* pBlitImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBlitImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBlitImage2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBlitImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBlitImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBlitImage2KHR(commandBuffer, pBlitImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBlitImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBlitImage2KHR(commandBuffer, pBlitImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdResolveImage2KHR(VkCommandBuffer commandBuffer, const VkResolveImageInfo2* pResolveImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdResolveImage2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdResolveImage2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdResolveImage2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdResolveImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdResolveImage2KHR(commandBuffer, pResolveImageInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdResolveImage2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdResolveImage2KHR(commandBuffer, pResolveImageInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdTraceRaysIndirect2KHR(VkCommandBuffer commandBuffer, VkDeviceAddress indirectDeviceAddress) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdTraceRaysIndirect2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdTraceRaysIndirect2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdTraceRaysIndirect2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdTraceRaysIndirect2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdTraceRaysIndirect2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdTraceRaysIndirect2KHR(commandBuffer, indirectDeviceAddress, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceBufferMemoryRequirementsKHR(VkDevice device, const VkDeviceBufferMemoryRequirements* pInfo,
                                                                VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceBufferMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceBufferMemoryRequirementsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceBufferMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceBufferMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceBufferMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceBufferMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                               VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageMemoryRequirementsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageMemoryRequirementsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageMemoryRequirementsKHR(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSparseMemoryRequirementsKHR(VkDevice device, const VkDeviceImageMemoryRequirements* pInfo,
                                                                     uint32_t* pSparseMemoryRequirementCount,
                                                                     VkSparseImageMemoryRequirements2* pSparseMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirementsKHR,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirementsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                                 pSparseMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSparseMemoryRequirementsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                       pSparseMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                   pSparseMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirementsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSparseMemoryRequirementsKHR(device, pInfo, pSparseMemoryRequirementCount,
                                                                        pSparseMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindIndexBuffer2KHR(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                  VkDeviceSize size, VkIndexType indexType) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindIndexBuffer2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindIndexBuffer2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindIndexBuffer2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindIndexBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindIndexBuffer2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindIndexBuffer2KHR(commandBuffer, buffer, offset, size, indexType, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetRenderingAreaGranularityKHR(VkDevice device, const VkRenderingAreaInfo* pRenderingAreaInfo,
                                                          VkExtent2D* pGranularity) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRenderingAreaGranularityKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRenderingAreaGranularityKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRenderingAreaGranularityKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRenderingAreaGranularityKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRenderingAreaGranularityKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRenderingAreaGranularityKHR(device, pRenderingAreaInfo, pGranularity, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDeviceImageSubresourceLayoutKHR(VkDevice device, const VkDeviceImageSubresourceInfo* pInfo,
                                                              VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceImageSubresourceLayoutKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceImageSubresourceLayoutKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceImageSubresourceLayoutKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceImageSubresourceLayoutKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceImageSubresourceLayoutKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceImageSubresourceLayoutKHR(device, pInfo, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout2KHR(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource,
                                                         VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout2KHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout2KHR(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePipelineBinariesKHR(VkDevice device, const VkPipelineBinaryCreateInfoKHR* pCreateInfo,
                                                         const VkAllocationCallbacks* pAllocator,
                                                         VkPipelineBinaryHandlesInfoKHR* pBinaries) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePipelineBinariesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePipelineBinariesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePipelineBinariesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePipelineBinariesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePipelineBinariesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePipelineBinariesKHR(device, pCreateInfo, pAllocator, pBinaries, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPipelineBinaryKHR(VkDevice device, VkPipelineBinaryKHR pipelineBinary,
                                                    const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPipelineBinaryKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPipelineBinaryKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPipelineBinaryKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPipelineBinaryKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPipelineBinaryKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPipelineBinaryKHR(device, pipelineBinary, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineKeyKHR(VkDevice device, const VkPipelineCreateInfoKHR* pPipelineCreateInfo,
                                                 VkPipelineBinaryKeyKHR* pPipelineKey) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineKeyKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineKeyKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineKeyKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineKeyKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineKeyKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineKeyKHR(device, pPipelineCreateInfo, pPipelineKey, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPipelineBinaryDataKHR(VkDevice device, const VkPipelineBinaryDataInfoKHR* pInfo,
                                                        VkPipelineBinaryKeyKHR* pPipelineBinaryKey, size_t* pPipelineBinaryDataSize,
                                                        void* pPipelineBinaryData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPipelineBinaryDataKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPipelineBinaryDataKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                                pPipelineBinaryData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPipelineBinaryDataKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPipelineBinaryDataKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                      pPipelineBinaryData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                           pPipelineBinaryData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPipelineBinaryDataKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPipelineBinaryDataKHR(device, pInfo, pPipelineBinaryKey, pPipelineBinaryDataSize,
                                                       pPipelineBinaryData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseCapturedPipelineDataKHR(VkDevice device, const VkReleaseCapturedPipelineDataInfoKHR* pInfo,
                                                              const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseCapturedPipelineDataKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseCapturedPipelineDataKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseCapturedPipelineDataKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseCapturedPipelineDataKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseCapturedPipelineDataKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseCapturedPipelineDataKHR(device, pInfo, pAllocator, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCooperativeMatrixPropertiesKHR(VkPhysicalDevice physicalDevice,
                                                                               uint32_t* pPropertyCount,
                                                                               VkCooperativeMatrixPropertiesKHR* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                                       error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                             record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesKHR(physicalDevice, pPropertyCount, pProperties,
                                                                              record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineStippleKHR(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor,
                                                uint16_t lineStipplePattern) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineStippleKHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineStippleKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineStippleKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineStippleKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineStippleKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineStippleKHR(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCalibrateableTimeDomainsKHR(VkPhysicalDevice physicalDevice,
                                                                            uint32_t* pTimeDomainCount,
                                                                            VkTimeDomainKHR* pTimeDomains) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsKHR,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                                    error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                          record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceCalibrateableTimeDomainsKHR(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                           record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetCalibratedTimestampsKHR(VkDevice device, uint32_t timestampCount,
                                                          const VkCalibratedTimestampInfoKHR* pTimestampInfos,
                                                          uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetCalibratedTimestampsKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetCalibratedTimestampsKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps,
                                                                  pMaxDeviation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetCalibratedTimestampsKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetCalibratedTimestampsKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetCalibratedTimestampsKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetCalibratedTimestampsKHR(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorSets2KHR(VkCommandBuffer commandBuffer,
                                                     const VkBindDescriptorSetsInfo* pBindDescriptorSetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorSets2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorSets2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorSets2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorSets2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorSets2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorSets2KHR(commandBuffer, pBindDescriptorSetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushConstants2KHR(VkCommandBuffer commandBuffer, const VkPushConstantsInfo* pPushConstantsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushConstants2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushConstants2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushConstants2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushConstants2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushConstants2KHR(commandBuffer, pPushConstantsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushConstants2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushConstants2KHR(commandBuffer, pPushConstantsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSet2KHR(VkCommandBuffer commandBuffer,
                                                    const VkPushDescriptorSetInfo* pPushDescriptorSetInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSet2KHR, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSet2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSet2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSet2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSet2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSet2KHR(commandBuffer, pPushDescriptorSetInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPushDescriptorSetWithTemplate2KHR(
    VkCommandBuffer commandBuffer, const VkPushDescriptorSetWithTemplateInfo* pPushDescriptorSetWithTemplateInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2KHR,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2KHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo,
                                                                            error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPushDescriptorSetWithTemplate2KHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2KHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2KHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPushDescriptorSetWithTemplate2KHR(commandBuffer, pPushDescriptorSetWithTemplateInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDescriptorBufferOffsets2EXT(
    VkCommandBuffer commandBuffer, const VkSetDescriptorBufferOffsetsInfoEXT* pSetDescriptorBufferOffsetsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDescriptorBufferOffsets2EXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDescriptorBufferOffsets2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDescriptorBufferOffsets2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDescriptorBufferOffsets2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDescriptorBufferOffsets2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDescriptorBufferOffsets2EXT(commandBuffer, pSetDescriptorBufferOffsetsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorBufferEmbeddedSamplers2EXT(
    VkCommandBuffer commandBuffer, const VkBindDescriptorBufferEmbeddedSamplersInfoEXT* pBindDescriptorBufferEmbeddedSamplersInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT(
                commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplers2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo,
                                                                         record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT(commandBuffer, pBindDescriptorBufferEmbeddedSamplersInfo,
                                                                          record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDebugReportCallbackEXT(VkInstance instance,
                                                            const VkDebugReportCallbackCreateInfoEXT* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkDebugReportCallbackEXT* pCallback) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDebugReportCallbackEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDebugReportCallbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback);
    }
    LayerCreateReportCallback(instance_dispatch->debug_report, false, pCreateInfo, pCallback);
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDebugReportCallbackEXT(instance, pCreateInfo, pAllocator, pCallback, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDebugReportCallbackEXT(VkInstance instance, VkDebugReportCallbackEXT callback,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDebugReportCallbackEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDebugReportCallbackEXT(instance, callback, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDebugReportCallbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDebugReportCallbackEXT(instance, callback, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->DestroyDebugReportCallbackEXT(instance, callback, pAllocator);
    }
    LayerDestroyCallback(instance_dispatch->debug_report, callback);
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDebugReportCallbackEXT(instance, callback, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DebugReportMessageEXT(VkInstance instance, VkDebugReportFlagsEXT flags,
                                                 VkDebugReportObjectTypeEXT objectType, uint64_t object, size_t location,
                                                 int32_t messageCode, const char* pLayerPrefix, const char* pMessage) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugReportMessageEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode,
                                                             pLayerPrefix, pMessage, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugReportMessageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                   pMessage, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->DebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                 pMessage);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDebugReportMessageEXT(instance, flags, objectType, object, location, messageCode, pLayerPrefix,
                                                    pMessage, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL DebugMarkerSetObjectTagEXT(VkDevice device, const VkDebugMarkerObjectTagInfoEXT* pTagInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugMarkerSetObjectTagEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDebugMarkerSetObjectTagEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDebugMarkerSetObjectTagEXT(device, pTagInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugMarkerSetObjectTagEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDebugMarkerSetObjectTagEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDebugMarkerSetObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->DebugMarkerSetObjectTagEXT(device, pTagInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDebugMarkerSetObjectTagEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDebugMarkerSetObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DebugMarkerSetObjectNameEXT(VkDevice device, const VkDebugMarkerObjectNameInfoEXT* pNameInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDebugMarkerSetObjectNameEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDebugMarkerSetObjectNameEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDebugMarkerSetObjectNameEXT(device, pNameInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDebugMarkerSetObjectNameEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDebugMarkerSetObjectNameEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDebugMarkerSetObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    device_dispatch->debug_report->SetMarkerObjectName(pNameInfo);
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->DebugMarkerSetObjectNameEXT(device, pNameInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDebugMarkerSetObjectNameEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDebugMarkerSetObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerBeginEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerBeginEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerBeginEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerBeginEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerBeginEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerBeginEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerBeginEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerEndEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerEndEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerEndEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerEndEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerEndEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerEndEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerEndEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDebugMarkerEndEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerEndEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerEndEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDebugMarkerInsertEXT(VkCommandBuffer commandBuffer, const VkDebugMarkerMarkerInfoEXT* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDebugMarkerInsertEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDebugMarkerInsertEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDebugMarkerInsertEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDebugMarkerInsertEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDebugMarkerInsertEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDebugMarkerInsertEXT(commandBuffer, pMarkerInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindTransformFeedbackBuffersEXT(VkCommandBuffer commandBuffer, uint32_t firstBinding,
                                                              uint32_t bindingCount, const VkBuffer* pBuffers,
                                                              const VkDeviceSize* pOffsets, const VkDeviceSize* pSizes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindTransformFeedbackBuffersEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindTransformFeedbackBuffersEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers,
                                                                          pOffsets, pSizes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindTransformFeedbackBuffersEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindTransformFeedbackBuffersEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets,
                                                                pSizes, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindTransformFeedbackBuffersEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindTransformFeedbackBuffersEXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets,
                                                                 pSizes, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer,
                                                        uint32_t counterBufferCount, const VkBuffer* pCounterBuffers,
                                                        const VkDeviceSize* pCounterBufferOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginTransformFeedbackEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginTransformFeedbackEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount,
                                                                    pCounterBuffers, pCounterBufferOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginTransformFeedbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginTransformFeedbackEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                          pCounterBufferOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                      pCounterBufferOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginTransformFeedbackEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                           pCounterBufferOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndTransformFeedbackEXT(VkCommandBuffer commandBuffer, uint32_t firstCounterBuffer,
                                                      uint32_t counterBufferCount, const VkBuffer* pCounterBuffers,
                                                      const VkDeviceSize* pCounterBufferOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndTransformFeedbackEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndTransformFeedbackEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount,
                                                                  pCounterBuffers, pCounterBufferOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndTransformFeedbackEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndTransformFeedbackEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                        pCounterBufferOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                    pCounterBufferOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndTransformFeedbackEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndTransformFeedbackEXT(commandBuffer, firstCounterBuffer, counterBufferCount, pCounterBuffers,
                                                         pCounterBufferOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                   VkQueryControlFlags flags, uint32_t index) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginQueryIndexedEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginQueryIndexedEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginQueryIndexedEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginQueryIndexedEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginQueryIndexedEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginQueryIndexedEXT(commandBuffer, queryPool, query, flags, index, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndQueryIndexedEXT(VkCommandBuffer commandBuffer, VkQueryPool queryPool, uint32_t query,
                                                 uint32_t index) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndQueryIndexedEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndQueryIndexedEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndQueryIndexedEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndQueryIndexedEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndQueryIndexedEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndQueryIndexedEXT(commandBuffer, queryPool, query, index, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectByteCountEXT(VkCommandBuffer commandBuffer, uint32_t instanceCount,
                                                       uint32_t firstInstance, VkBuffer counterBuffer,
                                                       VkDeviceSize counterBufferOffset, uint32_t counterOffset,
                                                       uint32_t vertexStride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectByteCountEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectByteCountEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                                   counterBufferOffset, counterOffset, vertexStride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectByteCountEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectByteCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                         counterBufferOffset, counterOffset, vertexStride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                     counterBufferOffset, counterOffset, vertexStride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectByteCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectByteCountEXT(commandBuffer, instanceCount, firstInstance, counterBuffer,
                                                          counterBufferOffset, counterOffset, vertexStride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCuModuleNVX(VkDevice device, const VkCuModuleCreateInfoNVX* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkCuModuleNVX* pModule) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCuModuleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCuModuleNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCuModuleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCuModuleNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCuModuleNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCuModuleNVX(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCuFunctionNVX(VkDevice device, const VkCuFunctionCreateInfoNVX* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkCuFunctionNVX* pFunction) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCuFunctionNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCuFunctionNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCuFunctionNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCuFunctionNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCuFunctionNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCuFunctionNVX(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyCuModuleNVX(VkDevice device, VkCuModuleNVX module, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCuModuleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCuModuleNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCuModuleNVX(device, module, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCuModuleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCuModuleNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCuModuleNVX(device, module, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyCuModuleNVX(device, module, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCuModuleNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCuModuleNVX(device, module, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyCuFunctionNVX(VkDevice device, VkCuFunctionNVX function,
                                                const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCuFunctionNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCuFunctionNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCuFunctionNVX(device, function, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCuFunctionNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCuFunctionNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCuFunctionNVX(device, function, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyCuFunctionNVX(device, function, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCuFunctionNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCuFunctionNVX(device, function, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCuLaunchKernelNVX(VkCommandBuffer commandBuffer, const VkCuLaunchInfoNVX* pLaunchInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCuLaunchKernelNVX, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCuLaunchKernelNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCuLaunchKernelNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCuLaunchKernelNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCuLaunchKernelNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCuLaunchKernelNVX(commandBuffer, pLaunchInfo, record_obj);
        }
    }
}

VKAPI_ATTR uint32_t VKAPI_CALL GetImageViewHandleNVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewHandleNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewHandleNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewHandleNVX(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewHandleNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewHandleNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewHandleNVX(device, pInfo, record_obj);
        }
    }
    uint32_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageViewHandleNVX(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewHandleNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewHandleNVX(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR uint64_t VKAPI_CALL GetImageViewHandle64NVX(VkDevice device, const VkImageViewHandleInfoNVX* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewHandle64NVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewHandle64NVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewHandle64NVX(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewHandle64NVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewHandle64NVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewHandle64NVX(device, pInfo, record_obj);
        }
    }
    uint64_t result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageViewHandle64NVX(device, pInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewHandle64NVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewHandle64NVX(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageViewAddressNVX(VkDevice device, VkImageView imageView,
                                                      VkImageViewAddressPropertiesNVX* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewAddressNVX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewAddressNVX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewAddressNVX(device, imageView, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewAddressNVX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewAddressNVX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewAddressNVX(device, imageView, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageViewAddressNVX(device, imageView, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewAddressNVX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewAddressNVX(device, imageView, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                   VkBuffer countBuffer, VkDeviceSize countBufferOffset, uint32_t maxDrawCount,
                                                   uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndirectCountAMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndirectCountAMD]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                               maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndirectCountAMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndirectCountAMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                     stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                 stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndirectCountAMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                      stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawIndexedIndirectCountAMD(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                          VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                          uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawIndexedIndirectCountAMD,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawIndexedIndirectCountAMD]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                                      maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawIndexedIndirectCountAMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawIndexedIndirectCountAMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                            maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset, maxDrawCount,
                                                        stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawIndexedIndirectCountAMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawIndexedIndirectCountAMD(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetShaderInfoAMD(VkDevice device, VkPipeline pipeline, VkShaderStageFlagBits shaderStage,
                                                VkShaderInfoTypeAMD infoType, size_t* pInfoSize, void* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetShaderInfoAMD, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetShaderInfoAMD]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetShaderInfoAMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetShaderInfoAMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetShaderInfoAMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetShaderInfoAMD(device, pipeline, shaderStage, infoType, pInfoSize, pInfo, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_GGP
VKAPI_ATTR VkResult VKAPI_CALL CreateStreamDescriptorSurfaceGGP(VkInstance instance,
                                                                const VkStreamDescriptorSurfaceCreateInfoGGP* pCreateInfo,
                                                                const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateStreamDescriptorSurfaceGGP, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateStreamDescriptorSurfaceGGP);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateStreamDescriptorSurfaceGGP(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_GGP
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceExternalImageFormatPropertiesNV(
    VkPhysicalDevice physicalDevice, VkFormat format, VkImageType type, VkImageTiling tiling, VkImageUsageFlags usage,
    VkImageCreateFlags flags, VkExternalMemoryHandleTypeFlagsNV externalHandleType,
    VkExternalImageFormatPropertiesNV* pExternalImageFormatProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceExternalImageFormatPropertiesNV,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceExternalImageFormatPropertiesNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceExternalImageFormatPropertiesNV(
            physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceExternalImageFormatPropertiesNV(
                physicalDevice, format, type, tiling, usage, flags, externalHandleType, pExternalImageFormatProperties, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryWin32HandleNV(VkDevice device, VkDeviceMemory memory,
                                                      VkExternalMemoryHandleTypeFlagsNV handleType, HANDLE* pHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryWin32HandleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryWin32HandleNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryWin32HandleNV(device, memory, handleType, pHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryWin32HandleNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryWin32HandleNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryWin32HandleNV(device, memory, handleType, pHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryWin32HandleNV(device, memory, handleType, pHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryWin32HandleNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryWin32HandleNV(device, memory, handleType, pHandle, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_VI_NN
VKAPI_ATTR VkResult VKAPI_CALL CreateViSurfaceNN(VkInstance instance, const VkViSurfaceCreateInfoNN* pCreateInfo,
                                                 const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateViSurfaceNN, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateViSurfaceNN);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateViSurfaceNN(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_VI_NN
VKAPI_ATTR void VKAPI_CALL CmdBeginConditionalRenderingEXT(VkCommandBuffer commandBuffer,
                                                           const VkConditionalRenderingBeginInfoEXT* pConditionalRenderingBegin) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginConditionalRenderingEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginConditionalRenderingEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginConditionalRenderingEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginConditionalRenderingEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginConditionalRenderingEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginConditionalRenderingEXT(commandBuffer, pConditionalRenderingBegin, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndConditionalRenderingEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndConditionalRenderingEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndConditionalRenderingEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndConditionalRenderingEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndConditionalRenderingEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndConditionalRenderingEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndConditionalRenderingEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndConditionalRenderingEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndConditionalRenderingEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndConditionalRenderingEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportWScalingNV(VkCommandBuffer commandBuffer, uint32_t firstViewport, uint32_t viewportCount,
                                                    const VkViewportWScalingNV* pViewportWScalings) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportWScalingNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportWScalingNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings,
                                                                error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportWScalingNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportWScalingNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportWScalingNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportWScalingNV(commandBuffer, firstViewport, viewportCount, pViewportWScalings, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseDisplayEXT(VkPhysicalDevice physicalDevice, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseDisplayEXT(physicalDevice, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseDisplayEXT(physicalDevice, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->ReleaseDisplayEXT(physicalDevice, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseDisplayEXT(physicalDevice, display, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_XLIB_XRANDR_EXT
VKAPI_ATTR VkResult VKAPI_CALL AcquireXlibDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireXlibDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireXlibDisplayEXT(physicalDevice, dpy, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireXlibDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireXlibDisplayEXT(physicalDevice, dpy, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->AcquireXlibDisplayEXT(physicalDevice, dpy, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireXlibDisplayEXT(physicalDevice, dpy, display, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRandROutputDisplayEXT(VkPhysicalDevice physicalDevice, Display* dpy, RROutput rrOutput,
                                                        VkDisplayKHR* pDisplay) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRandROutputDisplayEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRandROutputDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRandROutputDisplayEXT(physicalDevice, dpy, rrOutput, pDisplay, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_XLIB_XRANDR_EXT
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfaceCapabilities2EXT(VkPhysicalDevice physicalDevice, VkSurfaceKHR surface,
                                                                        VkSurfaceCapabilities2EXT* pSurfaceCapabilities) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2EXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities,
                                                                                error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfaceCapabilities2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfaceCapabilities2EXT(physicalDevice, surface, pSurfaceCapabilities, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL DisplayPowerControlEXT(VkDevice device, VkDisplayKHR display,
                                                      const VkDisplayPowerInfoEXT* pDisplayPowerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDisplayPowerControlEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDisplayPowerControlEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDisplayPowerControlEXT(device, display, pDisplayPowerInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkDisplayPowerControlEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDisplayPowerControlEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDisplayPowerControlEXT(device, display, pDisplayPowerInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->DisplayPowerControlEXT(device, display, pDisplayPowerInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDisplayPowerControlEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDisplayPowerControlEXT(device, display, pDisplayPowerInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL RegisterDeviceEventEXT(VkDevice device, const VkDeviceEventInfoEXT* pDeviceEventInfo,
                                                      const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkRegisterDeviceEventEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateRegisterDeviceEventEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkRegisterDeviceEventEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordRegisterDeviceEventEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->RegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordRegisterDeviceEventEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordRegisterDeviceEventEXT(device, pDeviceEventInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL RegisterDisplayEventEXT(VkDevice device, VkDisplayKHR display,
                                                       const VkDisplayEventInfoEXT* pDisplayEventInfo,
                                                       const VkAllocationCallbacks* pAllocator, VkFence* pFence) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkRegisterDisplayEventEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateRegisterDisplayEventEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkRegisterDisplayEventEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordRegisterDisplayEventEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->RegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordRegisterDisplayEventEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordRegisterDisplayEventEXT(device, display, pDisplayEventInfo, pAllocator, pFence, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSwapchainCounterEXT(VkDevice device, VkSwapchainKHR swapchain,
                                                      VkSurfaceCounterFlagBitsEXT counter, uint64_t* pCounterValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSwapchainCounterEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSwapchainCounterEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSwapchainCounterEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSwapchainCounterEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSwapchainCounterEXT(device, swapchain, counter, pCounterValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSwapchainCounterEXT]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetSwapchainCounterEXT(device, swapchain, counter, pCounterValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRefreshCycleDurationGOOGLE(VkDevice device, VkSwapchainKHR swapchain,
                                                             VkRefreshCycleDurationGOOGLE* pDisplayTimingProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRefreshCycleDurationGOOGLE, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRefreshCycleDurationGOOGLE]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRefreshCycleDurationGOOGLE);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRefreshCycleDurationGOOGLE]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRefreshCycleDurationGOOGLE]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetRefreshCycleDurationGOOGLE(device, swapchain, pDisplayTimingProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPastPresentationTimingGOOGLE(VkDevice device, VkSwapchainKHR swapchain,
                                                               uint32_t* pPresentationTimingCount,
                                                               VkPastPresentationTimingGOOGLE* pPresentationTimings) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPastPresentationTimingGOOGLE, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPastPresentationTimingGOOGLE]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount,
                                                                       pPresentationTimings, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPastPresentationTimingGOOGLE);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPastPresentationTimingGOOGLE]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings,
                                                             record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result =
            device_dispatch->GetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPastPresentationTimingGOOGLE]) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetPastPresentationTimingGOOGLE(device, swapchain, pPresentationTimingCount, pPresentationTimings,
                                                              record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleEXT(VkCommandBuffer commandBuffer, uint32_t firstDiscardRectangle,
                                                     uint32_t discardRectangleCount, const VkRect2D* pDiscardRectangles) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                                 pDiscardRectangles, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                       pDiscardRectangles, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount, pDiscardRectangles);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleEXT(commandBuffer, firstDiscardRectangle, discardRectangleCount,
                                                        pDiscardRectangles, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleEnableEXT(VkCommandBuffer commandBuffer, VkBool32 discardRectangleEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleEnableEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleEnableEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleEnableEXT(commandBuffer, discardRectangleEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDiscardRectangleModeEXT(VkCommandBuffer commandBuffer,
                                                         VkDiscardRectangleModeEXT discardRectangleMode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDiscardRectangleModeEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDiscardRectangleModeEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDiscardRectangleModeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDiscardRectangleModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDiscardRectangleModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDiscardRectangleModeEXT(commandBuffer, discardRectangleMode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL SetHdrMetadataEXT(VkDevice device, uint32_t swapchainCount, const VkSwapchainKHR* pSwapchains,
                                             const VkHdrMetadataEXT* pMetadata) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetHdrMetadataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetHdrMetadataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetHdrMetadataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetHdrMetadataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->SetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetHdrMetadataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetHdrMetadataEXT(device, swapchainCount, pSwapchains, pMetadata, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_IOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL CreateIOSSurfaceMVK(VkInstance instance, const VkIOSSurfaceCreateInfoMVK* pCreateInfo,
                                                   const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateIOSSurfaceMVK, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateIOSSurfaceMVK);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateIOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_IOS_MVK
#ifdef VK_USE_PLATFORM_MACOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL CreateMacOSSurfaceMVK(VkInstance instance, const VkMacOSSurfaceCreateInfoMVK* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateMacOSSurfaceMVK, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateMacOSSurfaceMVK);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateMacOSSurfaceMVK(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_MACOS_MVK
VKAPI_ATTR VkResult VKAPI_CALL SetDebugUtilsObjectNameEXT(VkDevice device, const VkDebugUtilsObjectNameInfoEXT* pNameInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetDebugUtilsObjectNameEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetDebugUtilsObjectNameEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetDebugUtilsObjectNameEXT(device, pNameInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetDebugUtilsObjectNameEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetDebugUtilsObjectNameEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetDebugUtilsObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    device_dispatch->debug_report->SetUtilsObjectName(pNameInfo);
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SetDebugUtilsObjectNameEXT(device, pNameInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetDebugUtilsObjectNameEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetDebugUtilsObjectNameEXT(device, pNameInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL SetDebugUtilsObjectTagEXT(VkDevice device, const VkDebugUtilsObjectTagInfoEXT* pTagInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetDebugUtilsObjectTagEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetDebugUtilsObjectTagEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetDebugUtilsObjectTagEXT(device, pTagInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetDebugUtilsObjectTagEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetDebugUtilsObjectTagEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetDebugUtilsObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SetDebugUtilsObjectTagEXT(device, pTagInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetDebugUtilsObjectTagEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetDebugUtilsObjectTagEXT(device, pTagInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL QueueBeginDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueBeginDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueBeginDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueBeginDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueBeginDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
    device_dispatch->debug_report->BeginQueueDebugUtilsLabel(queue, pLabelInfo);
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->QueueBeginDebugUtilsLabelEXT(queue, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueBeginDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueBeginDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL QueueEndDebugUtilsLabelEXT(VkQueue queue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueEndDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueEndDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueEndDebugUtilsLabelEXT(queue, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueEndDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueEndDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueEndDebugUtilsLabelEXT(queue, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->QueueEndDebugUtilsLabelEXT(queue);
    }
    device_dispatch->debug_report->EndQueueDebugUtilsLabel(queue);
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueEndDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueEndDebugUtilsLabelEXT(queue, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL QueueInsertDebugUtilsLabelEXT(VkQueue queue, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueInsertDebugUtilsLabelEXT, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueInsertDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueInsertDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueInsertDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
    device_dispatch->debug_report->InsertQueueDebugUtilsLabel(queue, pLabelInfo);
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->QueueInsertDebugUtilsLabelEXT(queue, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueInsertDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueInsertDebugUtilsLabelEXT(queue, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBeginDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBeginDebugUtilsLabelEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBeginDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBeginDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBeginDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBeginDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBeginDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdEndDebugUtilsLabelEXT(VkCommandBuffer commandBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdEndDebugUtilsLabelEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdEndDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdEndDebugUtilsLabelEXT(commandBuffer, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdEndDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdEndDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdEndDebugUtilsLabelEXT(commandBuffer, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdEndDebugUtilsLabelEXT(commandBuffer);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdEndDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdEndDebugUtilsLabelEXT(commandBuffer, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdInsertDebugUtilsLabelEXT(VkCommandBuffer commandBuffer, const VkDebugUtilsLabelEXT* pLabelInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdInsertDebugUtilsLabelEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdInsertDebugUtilsLabelEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdInsertDebugUtilsLabelEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdInsertDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdInsertDebugUtilsLabelEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdInsertDebugUtilsLabelEXT(commandBuffer, pLabelInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateDebugUtilsMessengerEXT(VkInstance instance,
                                                            const VkDebugUtilsMessengerCreateInfoEXT* pCreateInfo,
                                                            const VkAllocationCallbacks* pAllocator,
                                                            VkDebugUtilsMessengerEXT* pMessenger) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDebugUtilsMessengerEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDebugUtilsMessengerEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger);
    }
    LayerCreateMessengerCallback(instance_dispatch->debug_report, false, pCreateInfo, pMessenger);
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDebugUtilsMessengerEXT(instance, pCreateInfo, pAllocator, pMessenger, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyDebugUtilsMessengerEXT(VkInstance instance, VkDebugUtilsMessengerEXT messenger,
                                                         const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyDebugUtilsMessengerEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyDebugUtilsMessengerEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->DestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator);
    }
    LayerDestroyCallback(instance_dispatch->debug_report, messenger);
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyDebugUtilsMessengerEXT(instance, messenger, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL SubmitDebugUtilsMessageEXT(VkInstance instance, VkDebugUtilsMessageSeverityFlagBitsEXT messageSeverity,
                                                      VkDebugUtilsMessageTypeFlagsEXT messageTypes,
                                                      const VkDebugUtilsMessengerCallbackDataEXT* pCallbackData) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSubmitDebugUtilsMessageEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkSubmitDebugUtilsMessageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->SubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSubmitDebugUtilsMessageEXT(instance, messageSeverity, messageTypes, pCallbackData, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_ANDROID_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetAndroidHardwareBufferPropertiesANDROID(VkDevice device, const struct AHardwareBuffer* buffer,
                                                                         VkAndroidHardwareBufferPropertiesANDROID* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAndroidHardwareBufferPropertiesANDROID,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAndroidHardwareBufferPropertiesANDROID]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAndroidHardwareBufferPropertiesANDROID);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAndroidHardwareBufferPropertiesANDROID]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAndroidHardwareBufferPropertiesANDROID]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAndroidHardwareBufferPropertiesANDROID(device, buffer, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryAndroidHardwareBufferANDROID(VkDevice device,
                                                                     const VkMemoryGetAndroidHardwareBufferInfoANDROID* pInfo,
                                                                     struct AHardwareBuffer** pBuffer) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryAndroidHardwareBufferANDROID, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryAndroidHardwareBufferANDROID]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryAndroidHardwareBufferANDROID);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryAndroidHardwareBufferANDROID]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryAndroidHardwareBufferANDROID]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryAndroidHardwareBufferANDROID(device, pInfo, pBuffer, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_ANDROID_KHR
#ifdef VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR VkResult VKAPI_CALL CreateExecutionGraphPipelinesAMDX(VkDevice device, VkPipelineCache pipelineCache,
                                                                 uint32_t createInfoCount,
                                                                 const VkExecutionGraphPipelineCreateInfoAMDX* pCreateInfos,
                                                                 const VkAllocationCallbacks* pAllocator, VkPipeline* pPipelines) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateExecutionGraphPipelinesAMDX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateExecutionGraphPipelinesAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos,
                                                                         pAllocator, pPipelines, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateExecutionGraphPipelinesAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateExecutionGraphPipelinesAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                               pPipelines, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos,
                                                                    pAllocator, pPipelines);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateExecutionGraphPipelinesAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateExecutionGraphPipelinesAMDX(device, pipelineCache, createInfoCount, pCreateInfos, pAllocator,
                                                                pPipelines, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetExecutionGraphPipelineScratchSizeAMDX(VkDevice device, VkPipeline executionGraph,
                                                                        VkExecutionGraphPipelineScratchSizeAMDX* pSizeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetExecutionGraphPipelineScratchSizeAMDX,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetExecutionGraphPipelineScratchSizeAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetExecutionGraphPipelineScratchSizeAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetExecutionGraphPipelineScratchSizeAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetExecutionGraphPipelineScratchSizeAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetExecutionGraphPipelineScratchSizeAMDX(device, executionGraph, pSizeInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetExecutionGraphPipelineNodeIndexAMDX(VkDevice device, VkPipeline executionGraph,
                                                                      const VkPipelineShaderStageNodeCreateInfoAMDX* pNodeInfo,
                                                                      uint32_t* pNodeIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetExecutionGraphPipelineNodeIndexAMDX, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetExecutionGraphPipelineNodeIndexAMDX]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetExecutionGraphPipelineNodeIndexAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetExecutionGraphPipelineNodeIndexAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetExecutionGraphPipelineNodeIndexAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetExecutionGraphPipelineNodeIndexAMDX(device, executionGraph, pNodeInfo, pNodeIndex, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdInitializeGraphScratchMemoryAMDX(VkCommandBuffer commandBuffer, VkPipeline executionGraph,
                                                               VkDeviceAddress scratch, VkDeviceSize scratchSize) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdInitializeGraphScratchMemoryAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdInitializeGraphScratchMemoryAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize,
                                                                           error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdInitializeGraphScratchMemoryAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdInitializeGraphScratchMemoryAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdInitializeGraphScratchMemoryAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdInitializeGraphScratchMemoryAMDX(commandBuffer, executionGraph, scratch, scratchSize, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch, VkDeviceSize scratchSize,
                                                const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphAMDX, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphIndirectAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch,
                                                        VkDeviceSize scratchSize, const VkDispatchGraphCountInfoAMDX* pCountInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphIndirectAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphIndirectAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphIndirectAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphIndirectAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphIndirectAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphIndirectAMDX(commandBuffer, scratch, scratchSize, pCountInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDispatchGraphIndirectCountAMDX(VkCommandBuffer commandBuffer, VkDeviceAddress scratch,
                                                             VkDeviceSize scratchSize, VkDeviceAddress countInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDispatchGraphIndirectCountAMDX,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDispatchGraphIndirectCountAMDX]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDispatchGraphIndirectCountAMDX);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDispatchGraphIndirectCountAMDX]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDispatchGraphIndirectCountAMDX]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDispatchGraphIndirectCountAMDX(commandBuffer, scratch, scratchSize, countInfo, record_obj);
        }
    }
}

#endif  // VK_ENABLE_BETA_EXTENSIONS
VKAPI_ATTR void VKAPI_CALL CmdSetSampleLocationsEXT(VkCommandBuffer commandBuffer,
                                                    const VkSampleLocationsInfoEXT* pSampleLocationsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetSampleLocationsEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetSampleLocationsEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetSampleLocationsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetSampleLocationsEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetSampleLocationsEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetSampleLocationsEXT(commandBuffer, pSampleLocationsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetPhysicalDeviceMultisamplePropertiesEXT(VkPhysicalDevice physicalDevice, VkSampleCountFlagBits samples,
                                                                     VkMultisamplePropertiesEXT* pMultisampleProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceMultisamplePropertiesEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties,
                                                                                 error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceMultisamplePropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        instance_dispatch->GetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceMultisamplePropertiesEXT(physicalDevice, samples, pMultisampleProperties,
                                                                        record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageDrmFormatModifierPropertiesEXT(VkDevice device, VkImage image,
                                                                      VkImageDrmFormatModifierPropertiesEXT* pProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageDrmFormatModifierPropertiesEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageDrmFormatModifierPropertiesEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageDrmFormatModifierPropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageDrmFormatModifierPropertiesEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageDrmFormatModifierPropertiesEXT(device, image, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageDrmFormatModifierPropertiesEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageDrmFormatModifierPropertiesEXT(device, image, pProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBindShadingRateImageNV(VkCommandBuffer commandBuffer, VkImageView imageView,
                                                     VkImageLayout imageLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindShadingRateImageNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindShadingRateImageNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindShadingRateImageNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindShadingRateImageNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindShadingRateImageNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindShadingRateImageNV(commandBuffer, imageView, imageLayout, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportShadingRatePaletteNV(VkCommandBuffer commandBuffer, uint32_t firstViewport,
                                                              uint32_t viewportCount,
                                                              const VkShadingRatePaletteNV* pShadingRatePalettes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportShadingRatePaletteNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportShadingRatePaletteNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount,
                                                                          pShadingRatePalettes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportShadingRatePaletteNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportShadingRatePaletteNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes,
                                                                record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportShadingRatePaletteNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportShadingRatePaletteNV(commandBuffer, firstViewport, viewportCount, pShadingRatePalettes,
                                                                 record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCoarseSampleOrderNV(VkCommandBuffer commandBuffer, VkCoarseSampleOrderTypeNV sampleOrderType,
                                                     uint32_t customSampleOrderCount,
                                                     const VkCoarseSampleOrderCustomNV* pCustomSampleOrders) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCoarseSampleOrderNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCoarseSampleOrderNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount,
                                                                 pCustomSampleOrders, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCoarseSampleOrderNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCoarseSampleOrderNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders,
                                                       record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCoarseSampleOrderNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCoarseSampleOrderNV(commandBuffer, sampleOrderType, customSampleOrderCount, pCustomSampleOrders,
                                                        record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateAccelerationStructureNV(VkDevice device,
                                                             const VkAccelerationStructureCreateInfoNV* pCreateInfo,
                                                             const VkAllocationCallbacks* pAllocator,
                                                             VkAccelerationStructureNV* pAccelerationStructure) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateAccelerationStructureNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateAccelerationStructureNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure,
                                                                     error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateAccelerationStructureNV(device, pCreateInfo, pAllocator, pAccelerationStructure, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyAccelerationStructureNV(VkDevice device, VkAccelerationStructureNV accelerationStructure,
                                                          const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyAccelerationStructureNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyAccelerationStructureNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyAccelerationStructureNV(device, accelerationStructure, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyAccelerationStructureNV(device, accelerationStructure, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetAccelerationStructureMemoryRequirementsNV(
    VkDevice device, const VkAccelerationStructureMemoryRequirementsInfoNV* pInfo, VkMemoryRequirements2KHR* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAccelerationStructureMemoryRequirementsNV,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAccelerationStructureMemoryRequirementsNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAccelerationStructureMemoryRequirementsNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAccelerationStructureMemoryRequirementsNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAccelerationStructureMemoryRequirementsNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAccelerationStructureMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL BindAccelerationStructureMemoryNV(VkDevice device, uint32_t bindInfoCount,
                                                                 const VkBindAccelerationStructureMemoryInfoNV* pBindInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkBindAccelerationStructureMemoryNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateBindAccelerationStructureMemoryNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkBindAccelerationStructureMemoryNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordBindAccelerationStructureMemoryNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->BindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordBindAccelerationStructureMemoryNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordBindAccelerationStructureMemoryNV(device, bindInfoCount, pBindInfos, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdBuildAccelerationStructureNV(VkCommandBuffer commandBuffer,
                                                           const VkAccelerationStructureInfoNV* pInfo, VkBuffer instanceData,
                                                           VkDeviceSize instanceOffset, VkBool32 update,
                                                           VkAccelerationStructureNV dst, VkAccelerationStructureNV src,
                                                           VkBuffer scratch, VkDeviceSize scratchOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBuildAccelerationStructureNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBuildAccelerationStructureNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update,
                                                                       dst, src, scratch, scratchOffset, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBuildAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBuildAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                             scratch, scratchOffset, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                         scratch, scratchOffset);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBuildAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBuildAccelerationStructureNV(commandBuffer, pInfo, instanceData, instanceOffset, update, dst, src,
                                                              scratch, scratchOffset, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCopyAccelerationStructureNV(VkCommandBuffer commandBuffer, VkAccelerationStructureNV dst,
                                                          VkAccelerationStructureNV src, VkCopyAccelerationStructureModeKHR mode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCopyAccelerationStructureNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCopyAccelerationStructureNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCopyAccelerationStructureNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCopyAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCopyAccelerationStructureNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCopyAccelerationStructureNV(commandBuffer, dst, src, mode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdTraceRaysNV(VkCommandBuffer commandBuffer, VkBuffer raygenShaderBindingTableBuffer,
                                          VkDeviceSize raygenShaderBindingOffset, VkBuffer missShaderBindingTableBuffer,
                                          VkDeviceSize missShaderBindingOffset, VkDeviceSize missShaderBindingStride,
                                          VkBuffer hitShaderBindingTableBuffer, VkDeviceSize hitShaderBindingOffset,
                                          VkDeviceSize hitShaderBindingStride, VkBuffer callableShaderBindingTableBuffer,
                                          VkDeviceSize callableShaderBindingOffset, VkDeviceSize callableShaderBindingStride,
                                          uint32_t width, uint32_t height, uint32_t depth) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdTraceRaysNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdTraceRaysNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdTraceRaysNV(
                commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset, missShaderBindingTableBuffer,
                missShaderBindingOffset, missShaderBindingStride, hitShaderBindingTableBuffer, hitShaderBindingOffset,
                hitShaderBindingStride, callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride,
                width, height, depth, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdTraceRaysNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdTraceRaysNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                            missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                            hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                            callableShaderBindingTableBuffer, callableShaderBindingOffset,
                                            callableShaderBindingStride, width, height, depth, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                        missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                        hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                        callableShaderBindingTableBuffer, callableShaderBindingOffset, callableShaderBindingStride,
                                        width, height, depth);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdTraceRaysNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdTraceRaysNV(commandBuffer, raygenShaderBindingTableBuffer, raygenShaderBindingOffset,
                                             missShaderBindingTableBuffer, missShaderBindingOffset, missShaderBindingStride,
                                             hitShaderBindingTableBuffer, hitShaderBindingOffset, hitShaderBindingStride,
                                             callableShaderBindingTableBuffer, callableShaderBindingOffset,
                                             callableShaderBindingStride, width, height, depth, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetRayTracingShaderGroupHandlesKHR(VkDevice device, VkPipeline pipeline, uint32_t firstGroup,
                                                                  uint32_t groupCount, size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesKHR, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesKHR]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                          error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesKHR);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesKHR]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesKHR]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRayTracingShaderGroupHandlesKHR(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                 record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetRayTracingShaderGroupHandlesNV(VkDevice device, VkPipeline pipeline, uint32_t firstGroup,
                                                                 uint32_t groupCount, size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                         error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetRayTracingShaderGroupHandlesNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetRayTracingShaderGroupHandlesNV(device, pipeline, firstGroup, groupCount, dataSize, pData,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetAccelerationStructureHandleNV(VkDevice device, VkAccelerationStructureNV accelerationStructure,
                                                                size_t dataSize, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAccelerationStructureHandleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAccelerationStructureHandleNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAccelerationStructureHandleNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAccelerationStructureHandleNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAccelerationStructureHandleNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAccelerationStructureHandleNV(device, accelerationStructure, dataSize, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdWriteAccelerationStructuresPropertiesNV(VkCommandBuffer commandBuffer,
                                                                      uint32_t accelerationStructureCount,
                                                                      const VkAccelerationStructureNV* pAccelerationStructures,
                                                                      VkQueryType queryType, VkQueryPool queryPool,
                                                                      uint32_t firstQuery) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteAccelerationStructuresPropertiesNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteAccelerationStructuresPropertiesNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteAccelerationStructuresPropertiesNV(commandBuffer, accelerationStructureCount,
                                                                    pAccelerationStructures, queryType, queryPool, firstQuery);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteAccelerationStructuresPropertiesNV(
                commandBuffer, accelerationStructureCount, pAccelerationStructures, queryType, queryPool, firstQuery, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CompileDeferredNV(VkDevice device, VkPipeline pipeline, uint32_t shader) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCompileDeferredNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCompileDeferredNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCompileDeferredNV(device, pipeline, shader, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCompileDeferredNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCompileDeferredNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCompileDeferredNV(device, pipeline, shader, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CompileDeferredNV(device, pipeline, shader);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCompileDeferredNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCompileDeferredNV(device, pipeline, shader, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetMemoryHostPointerPropertiesEXT(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType,
                                                                 const void* pHostPointer,
                                                                 VkMemoryHostPointerPropertiesEXT* pMemoryHostPointerProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryHostPointerPropertiesEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryHostPointerPropertiesEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer,
                                                                         pMemoryHostPointerProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryHostPointerPropertiesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryHostPointerPropertiesEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties,
                                                               record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryHostPointerPropertiesEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryHostPointerPropertiesEXT(device, handleType, pHostPointer, pMemoryHostPointerProperties,
                                                                record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdWriteBufferMarkerAMD(VkCommandBuffer commandBuffer, VkPipelineStageFlagBits pipelineStage,
                                                   VkBuffer dstBuffer, VkDeviceSize dstOffset, uint32_t marker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteBufferMarkerAMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteBufferMarkerAMD]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteBufferMarkerAMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteBufferMarkerAMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteBufferMarkerAMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteBufferMarkerAMD(commandBuffer, pipelineStage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdWriteBufferMarker2AMD(VkCommandBuffer commandBuffer, VkPipelineStageFlags2 stage, VkBuffer dstBuffer,
                                                    VkDeviceSize dstOffset, uint32_t marker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdWriteBufferMarker2AMD, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdWriteBufferMarker2AMD]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdWriteBufferMarker2AMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdWriteBufferMarker2AMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdWriteBufferMarker2AMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdWriteBufferMarker2AMD(commandBuffer, stage, dstBuffer, dstOffset, marker, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCalibrateableTimeDomainsEXT(VkPhysicalDevice physicalDevice,
                                                                            uint32_t* pTimeDomainCount,
                                                                            VkTimeDomainKHR* pTimeDomains) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                                    error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCalibrateableTimeDomainsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                          record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceCalibrateableTimeDomainsEXT(physicalDevice, pTimeDomainCount, pTimeDomains,
                                                                           record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetCalibratedTimestampsEXT(VkDevice device, uint32_t timestampCount,
                                                          const VkCalibratedTimestampInfoKHR* pTimestampInfos,
                                                          uint64_t* pTimestamps, uint64_t* pMaxDeviation) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetCalibratedTimestampsEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetCalibratedTimestampsEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps,
                                                                  pMaxDeviation, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetCalibratedTimestampsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetCalibratedTimestampsEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                        record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetCalibratedTimestampsEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetCalibratedTimestampsEXT(device, timestampCount, pTimestampInfos, pTimestamps, pMaxDeviation,
                                                         record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksNV(VkCommandBuffer commandBuffer, uint32_t taskCount, uint32_t firstTask) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksNV(commandBuffer, taskCount, firstTask, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksIndirectNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                      uint32_t drawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksIndirectNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksIndirectNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksIndirectNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksIndirectNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksIndirectNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksIndirectNV(commandBuffer, buffer, offset, drawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdDrawMeshTasksIndirectCountNV(VkCommandBuffer commandBuffer, VkBuffer buffer, VkDeviceSize offset,
                                                           VkBuffer countBuffer, VkDeviceSize countBufferOffset,
                                                           uint32_t maxDrawCount, uint32_t stride) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdDrawMeshTasksIndirectCountNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer,
                                                                       countBufferOffset, maxDrawCount, stride, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdDrawMeshTasksIndirectCountNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                             maxDrawCount, stride, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                         maxDrawCount, stride);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdDrawMeshTasksIndirectCountNV(commandBuffer, buffer, offset, countBuffer, countBufferOffset,
                                                              maxDrawCount, stride, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetExclusiveScissorEnableNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor,
                                                          uint32_t exclusiveScissorCount,
                                                          const VkBool32* pExclusiveScissorEnables) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetExclusiveScissorEnableNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetExclusiveScissorEnableNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                                      pExclusiveScissorEnables, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetExclusiveScissorEnableNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetExclusiveScissorEnableNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                            pExclusiveScissorEnables, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                        pExclusiveScissorEnables);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetExclusiveScissorEnableNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetExclusiveScissorEnableNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                             pExclusiveScissorEnables, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetExclusiveScissorNV(VkCommandBuffer commandBuffer, uint32_t firstExclusiveScissor,
                                                    uint32_t exclusiveScissorCount, const VkRect2D* pExclusiveScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetExclusiveScissorNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetExclusiveScissorNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                                pExclusiveScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetExclusiveScissorNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetExclusiveScissorNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                      pExclusiveScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount, pExclusiveScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetExclusiveScissorNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetExclusiveScissorNV(commandBuffer, firstExclusiveScissor, exclusiveScissorCount,
                                                       pExclusiveScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCheckpointNV(VkCommandBuffer commandBuffer, const void* pCheckpointMarker) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCheckpointNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCheckpointNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCheckpointNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCheckpointNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetCheckpointNV(commandBuffer, pCheckpointMarker);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCheckpointNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCheckpointNV(commandBuffer, pCheckpointMarker, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetQueueCheckpointDataNV(VkQueue queue, uint32_t* pCheckpointDataCount,
                                                    VkCheckpointDataNV* pCheckpointData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueueCheckpointDataNV, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueueCheckpointDataNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueueCheckpointDataNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueueCheckpointDataNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueueCheckpointDataNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetQueueCheckpointDataNV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetQueueCheckpointData2NV(VkQueue queue, uint32_t* pCheckpointDataCount,
                                                     VkCheckpointData2NV* pCheckpointData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetQueueCheckpointData2NV, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetQueueCheckpointData2NV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetQueueCheckpointData2NV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetQueueCheckpointData2NV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetQueueCheckpointData2NV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetQueueCheckpointData2NV(queue, pCheckpointDataCount, pCheckpointData, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL InitializePerformanceApiINTEL(VkDevice device,
                                                             const VkInitializePerformanceApiInfoINTEL* pInitializeInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkInitializePerformanceApiINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateInitializePerformanceApiINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateInitializePerformanceApiINTEL(device, pInitializeInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkInitializePerformanceApiINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordInitializePerformanceApiINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordInitializePerformanceApiINTEL(device, pInitializeInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->InitializePerformanceApiINTEL(device, pInitializeInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordInitializePerformanceApiINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordInitializePerformanceApiINTEL(device, pInitializeInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL UninitializePerformanceApiINTEL(VkDevice device) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkUninitializePerformanceApiINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateUninitializePerformanceApiINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateUninitializePerformanceApiINTEL(device, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkUninitializePerformanceApiINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordUninitializePerformanceApiINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordUninitializePerformanceApiINTEL(device, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->UninitializePerformanceApiINTEL(device);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordUninitializePerformanceApiINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordUninitializePerformanceApiINTEL(device, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CmdSetPerformanceMarkerINTEL(VkCommandBuffer commandBuffer,
                                                            const VkPerformanceMarkerInfoINTEL* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPerformanceMarkerINTEL,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPerformanceMarkerINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPerformanceMarkerINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPerformanceMarkerINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPerformanceMarkerINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPerformanceMarkerINTEL(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CmdSetPerformanceStreamMarkerINTEL(VkCommandBuffer commandBuffer,
                                                                  const VkPerformanceStreamMarkerInfoINTEL* pMarkerInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPerformanceStreamMarkerINTEL,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPerformanceStreamMarkerINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPerformanceStreamMarkerINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPerformanceStreamMarkerINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPerformanceStreamMarkerINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPerformanceStreamMarkerINTEL(commandBuffer, pMarkerInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CmdSetPerformanceOverrideINTEL(VkCommandBuffer commandBuffer,
                                                              const VkPerformanceOverrideInfoINTEL* pOverrideInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPerformanceOverrideINTEL,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPerformanceOverrideINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPerformanceOverrideINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPerformanceOverrideINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPerformanceOverrideINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPerformanceOverrideINTEL(commandBuffer, pOverrideInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquirePerformanceConfigurationINTEL(VkDevice device,
                                                                    const VkPerformanceConfigurationAcquireInfoINTEL* pAcquireInfo,
                                                                    VkPerformanceConfigurationINTEL* pConfiguration) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquirePerformanceConfigurationINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquirePerformanceConfigurationINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquirePerformanceConfigurationINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquirePerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquirePerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquirePerformanceConfigurationINTEL(device, pAcquireInfo, pConfiguration, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ReleasePerformanceConfigurationINTEL(VkDevice device,
                                                                    VkPerformanceConfigurationINTEL configuration) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleasePerformanceConfigurationINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleasePerformanceConfigurationINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleasePerformanceConfigurationINTEL(device, configuration, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleasePerformanceConfigurationINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleasePerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleasePerformanceConfigurationINTEL(device, configuration, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ReleasePerformanceConfigurationINTEL(device, configuration);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleasePerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleasePerformanceConfigurationINTEL(device, configuration, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL QueueSetPerformanceConfigurationINTEL(VkQueue queue, VkPerformanceConfigurationINTEL configuration) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(queue);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkQueueSetPerformanceConfigurationINTEL, VulkanTypedHandle(queue, kVulkanObjectTypeQueue));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateQueueSetPerformanceConfigurationINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateQueueSetPerformanceConfigurationINTEL(queue, configuration, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkQueueSetPerformanceConfigurationINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordQueueSetPerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordQueueSetPerformanceConfigurationINTEL(queue, configuration, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->QueueSetPerformanceConfigurationINTEL(queue, configuration);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordQueueSetPerformanceConfigurationINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordQueueSetPerformanceConfigurationINTEL(queue, configuration, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPerformanceParameterINTEL(VkDevice device, VkPerformanceParameterTypeINTEL parameter,
                                                            VkPerformanceValueINTEL* pValue) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPerformanceParameterINTEL, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPerformanceParameterINTEL]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPerformanceParameterINTEL(device, parameter, pValue, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPerformanceParameterINTEL);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPerformanceParameterINTEL]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPerformanceParameterINTEL(device, parameter, pValue, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetPerformanceParameterINTEL(device, parameter, pValue);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPerformanceParameterINTEL]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPerformanceParameterINTEL(device, parameter, pValue, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL SetLocalDimmingAMD(VkDevice device, VkSwapchainKHR swapChain, VkBool32 localDimmingEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetLocalDimmingAMD, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetLocalDimmingAMD]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetLocalDimmingAMD(device, swapChain, localDimmingEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetLocalDimmingAMD);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetLocalDimmingAMD]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetLocalDimmingAMD(device, swapChain, localDimmingEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->SetLocalDimmingAMD(device, swapChain, localDimmingEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetLocalDimmingAMD]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetLocalDimmingAMD(device, swapChain, localDimmingEnable, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_FUCHSIA
VKAPI_ATTR VkResult VKAPI_CALL CreateImagePipeSurfaceFUCHSIA(VkInstance instance,
                                                             const VkImagePipeSurfaceCreateInfoFUCHSIA* pCreateInfo,
                                                             const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateImagePipeSurfaceFUCHSIA, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateImagePipeSurfaceFUCHSIA(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateImagePipeSurfaceFUCHSIA);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateImagePipeSurfaceFUCHSIA(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateImagePipeSurfaceFUCHSIA(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateImagePipeSurfaceFUCHSIA(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_FUCHSIA
#ifdef VK_USE_PLATFORM_METAL_EXT
VKAPI_ATTR VkResult VKAPI_CALL CreateMetalSurfaceEXT(VkInstance instance, const VkMetalSurfaceCreateInfoEXT* pCreateInfo,
                                                     const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateMetalSurfaceEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateMetalSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateMetalSurfaceEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateMetalSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateMetalSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateMetalSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_METAL_EXT
VKAPI_ATTR VkDeviceAddress VKAPI_CALL GetBufferDeviceAddressEXT(VkDevice device, const VkBufferDeviceAddressInfo* pInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferDeviceAddressEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferDeviceAddressEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferDeviceAddressEXT(device, pInfo, error_obj);
            if (skip) return 0;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferDeviceAddressEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferDeviceAddressEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferDeviceAddressEXT(device, pInfo, record_obj);
        }
    }
    VkDeviceAddress result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferDeviceAddressEXT(device, pInfo);
    }
    record_obj.device_address = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferDeviceAddressEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferDeviceAddressEXT(device, pInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceCooperativeMatrixPropertiesNV(VkPhysicalDevice physicalDevice,
                                                                              uint32_t* pPropertyCount,
                                                                              VkCooperativeMatrixPropertiesNV* pProperties) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesNV,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties,
                                                                                      error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceCooperativeMatrixPropertiesNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties,
                                                                            record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceCooperativeMatrixPropertiesNV(physicalDevice, pPropertyCount, pProperties,
                                                                             record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(
    VkPhysicalDevice physicalDevice, uint32_t* pCombinationCount, VkFramebufferMixedSamplesCombinationNV* pCombinations) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(
                physicalDevice, pCombinationCount, pCombinations, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(physicalDevice, pCombinationCount,
                                                                                             pCombinations, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(
            physicalDevice, pCombinationCount, pCombinations);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSupportedFramebufferMixedSamplesCombinationsNV(physicalDevice, pCombinationCount,
                                                                                              pCombinations, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL GetPhysicalDeviceSurfacePresentModes2EXT(VkPhysicalDevice physicalDevice,
                                                                        const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                        uint32_t* pPresentModeCount,
                                                                        VkPresentModeKHR* pPresentModes) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModes2EXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount,
                                                                                pPresentModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceSurfacePresentModes2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount,
                                                                      pPresentModes, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount,
                                                                             pPresentModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceSurfacePresentModes2EXT(physicalDevice, pSurfaceInfo, pPresentModeCount,
                                                                       pPresentModes, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireFullScreenExclusiveModeEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateAcquireFullScreenExclusiveModeEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireFullScreenExclusiveModeEXT(device, swapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireFullScreenExclusiveModeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordAcquireFullScreenExclusiveModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireFullScreenExclusiveModeEXT(device, swapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->AcquireFullScreenExclusiveModeEXT(device, swapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordAcquireFullScreenExclusiveModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireFullScreenExclusiveModeEXT(device, swapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseFullScreenExclusiveModeEXT(VkDevice device, VkSwapchainKHR swapchain) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseFullScreenExclusiveModeEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseFullScreenExclusiveModeEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseFullScreenExclusiveModeEXT(device, swapchain, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseFullScreenExclusiveModeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseFullScreenExclusiveModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseFullScreenExclusiveModeEXT(device, swapchain, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ReleaseFullScreenExclusiveModeEXT(device, swapchain);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseFullScreenExclusiveModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseFullScreenExclusiveModeEXT(device, swapchain, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeviceGroupSurfacePresentModes2EXT(VkDevice device,
                                                                     const VkPhysicalDeviceSurfaceInfo2KHR* pSurfaceInfo,
                                                                     VkDeviceGroupPresentModeFlagsKHR* pModes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModes2EXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModes2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceGroupSurfacePresentModes2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModes2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModes2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceGroupSurfacePresentModes2EXT(device, pSurfaceInfo, pModes, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL CreateHeadlessSurfaceEXT(VkInstance instance, const VkHeadlessSurfaceCreateInfoEXT* pCreateInfo,
                                                        const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateHeadlessSurfaceEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateHeadlessSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateHeadlessSurfaceEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateHeadlessSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateHeadlessSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateHeadlessSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetLineStippleEXT(VkCommandBuffer commandBuffer, uint32_t lineStippleFactor,
                                                uint16_t lineStipplePattern) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetLineStippleEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetLineStippleEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetLineStippleEXT(commandBuffer, lineStippleFactor, lineStipplePattern, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetLineStippleEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetLineStippleEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetLineStippleEXT(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetLineStippleEXT(commandBuffer, lineStippleFactor, lineStipplePattern);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetLineStippleEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetLineStippleEXT(commandBuffer, lineStippleFactor, lineStipplePattern, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL ResetQueryPoolEXT(VkDevice device, VkQueryPool queryPool, uint32_t firstQuery, uint32_t queryCount) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkResetQueryPoolEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateResetQueryPoolEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateResetQueryPoolEXT(device, queryPool, firstQuery, queryCount, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkResetQueryPoolEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordResetQueryPoolEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordResetQueryPoolEXT(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->ResetQueryPoolEXT(device, queryPool, firstQuery, queryCount);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordResetQueryPoolEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordResetQueryPoolEXT(device, queryPool, firstQuery, queryCount, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetCullModeEXT(VkCommandBuffer commandBuffer, VkCullModeFlags cullMode) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetCullModeEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetCullModeEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetCullModeEXT(commandBuffer, cullMode, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetCullModeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetCullModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetCullModeEXT(commandBuffer, cullMode, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetCullModeEXT(commandBuffer, cullMode);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetCullModeEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetCullModeEXT(commandBuffer, cullMode, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetFrontFaceEXT(VkCommandBuffer commandBuffer, VkFrontFace frontFace) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFrontFaceEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFrontFaceEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFrontFaceEXT(commandBuffer, frontFace, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFrontFaceEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFrontFaceEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFrontFaceEXT(commandBuffer, frontFace, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetFrontFaceEXT(commandBuffer, frontFace);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFrontFaceEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFrontFaceEXT(commandBuffer, frontFace, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetPrimitiveTopologyEXT(VkCommandBuffer commandBuffer, VkPrimitiveTopology primitiveTopology) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetPrimitiveTopologyEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetPrimitiveTopologyEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetPrimitiveTopologyEXT(commandBuffer, primitiveTopology, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetPrimitiveTopologyEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetPrimitiveTopologyEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetPrimitiveTopologyEXT(commandBuffer, primitiveTopology, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetPrimitiveTopologyEXT(commandBuffer, primitiveTopology);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetPrimitiveTopologyEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetPrimitiveTopologyEXT(commandBuffer, primitiveTopology, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetViewportWithCountEXT(VkCommandBuffer commandBuffer, uint32_t viewportCount,
                                                      const VkViewport* pViewports) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetViewportWithCountEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetViewportWithCountEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetViewportWithCountEXT(commandBuffer, viewportCount, pViewports, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetViewportWithCountEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetViewportWithCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetViewportWithCountEXT(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetViewportWithCountEXT(commandBuffer, viewportCount, pViewports);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetViewportWithCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetViewportWithCountEXT(commandBuffer, viewportCount, pViewports, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetScissorWithCountEXT(VkCommandBuffer commandBuffer, uint32_t scissorCount,
                                                     const VkRect2D* pScissors) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetScissorWithCountEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetScissorWithCountEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetScissorWithCountEXT(commandBuffer, scissorCount, pScissors, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetScissorWithCountEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetScissorWithCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetScissorWithCountEXT(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetScissorWithCountEXT(commandBuffer, scissorCount, pScissors);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetScissorWithCountEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetScissorWithCountEXT(commandBuffer, scissorCount, pScissors, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindVertexBuffers2EXT(VkCommandBuffer commandBuffer, uint32_t firstBinding, uint32_t bindingCount,
                                                    const VkBuffer* pBuffers, const VkDeviceSize* pOffsets,
                                                    const VkDeviceSize* pSizes, const VkDeviceSize* pStrides) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindVertexBuffers2EXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindVertexBuffers2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindVertexBuffers2EXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets,
                                                                pSizes, pStrides, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindVertexBuffers2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindVertexBuffers2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindVertexBuffers2EXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                                      pStrides, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindVertexBuffers2EXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes, pStrides);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindVertexBuffers2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindVertexBuffers2EXT(commandBuffer, firstBinding, bindingCount, pBuffers, pOffsets, pSizes,
                                                       pStrides, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthTestEnableEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthTestEnableEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthTestEnableEXT(commandBuffer, depthTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthTestEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthTestEnableEXT(commandBuffer, depthTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthTestEnableEXT(commandBuffer, depthTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthTestEnableEXT(commandBuffer, depthTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthWriteEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthWriteEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthWriteEnableEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthWriteEnableEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthWriteEnableEXT(commandBuffer, depthWriteEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthWriteEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthWriteEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthWriteEnableEXT(commandBuffer, depthWriteEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthWriteEnableEXT(commandBuffer, depthWriteEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthWriteEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthWriteEnableEXT(commandBuffer, depthWriteEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthCompareOpEXT(VkCommandBuffer commandBuffer, VkCompareOp depthCompareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthCompareOpEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthCompareOpEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthCompareOpEXT(commandBuffer, depthCompareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthCompareOpEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthCompareOpEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthCompareOpEXT(commandBuffer, depthCompareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthCompareOpEXT(commandBuffer, depthCompareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthCompareOpEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthCompareOpEXT(commandBuffer, depthCompareOp, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBoundsTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 depthBoundsTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBoundsTestEnableEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBoundsTestEnableEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBoundsTestEnableEXT(commandBuffer, depthBoundsTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBoundsTestEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBoundsTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBoundsTestEnableEXT(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBoundsTestEnableEXT(commandBuffer, depthBoundsTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBoundsTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBoundsTestEnableEXT(commandBuffer, depthBoundsTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilTestEnableEXT(VkCommandBuffer commandBuffer, VkBool32 stencilTestEnable) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilTestEnableEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilTestEnableEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetStencilTestEnableEXT(commandBuffer, stencilTestEnable, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilTestEnableEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilTestEnableEXT(commandBuffer, stencilTestEnable, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilTestEnableEXT(commandBuffer, stencilTestEnable);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilTestEnableEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilTestEnableEXT(commandBuffer, stencilTestEnable, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetStencilOpEXT(VkCommandBuffer commandBuffer, VkStencilFaceFlags faceMask, VkStencilOp failOp,
                                              VkStencilOp passOp, VkStencilOp depthFailOp, VkCompareOp compareOp) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetStencilOpEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetStencilOpEXT]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdSetStencilOpEXT(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetStencilOpEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetStencilOpEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetStencilOpEXT(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetStencilOpEXT(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetStencilOpEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetStencilOpEXT(commandBuffer, faceMask, failOp, passOp, depthFailOp, compareOp, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CopyMemoryToImageEXT(VkDevice device, const VkCopyMemoryToImageInfo* pCopyMemoryToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyMemoryToImageEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyMemoryToImageEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyMemoryToImageEXT(device, pCopyMemoryToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyMemoryToImageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyMemoryToImageEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyMemoryToImageEXT(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyMemoryToImageEXT(device, pCopyMemoryToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyMemoryToImageEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyMemoryToImageEXT(device, pCopyMemoryToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToMemoryEXT(VkDevice device, const VkCopyImageToMemoryInfo* pCopyImageToMemoryInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToMemoryEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToMemoryEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToMemoryEXT(device, pCopyImageToMemoryInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToMemoryEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToMemoryEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToMemoryEXT(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyImageToMemoryEXT(device, pCopyImageToMemoryInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToMemoryEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToMemoryEXT(device, pCopyImageToMemoryInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CopyImageToImageEXT(VkDevice device, const VkCopyImageToImageInfo* pCopyImageToImageInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCopyImageToImageEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCopyImageToImageEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCopyImageToImageEXT(device, pCopyImageToImageInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCopyImageToImageEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCopyImageToImageEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCopyImageToImageEXT(device, pCopyImageToImageInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CopyImageToImageEXT(device, pCopyImageToImageInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCopyImageToImageEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCopyImageToImageEXT(device, pCopyImageToImageInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL TransitionImageLayoutEXT(VkDevice device, uint32_t transitionCount,
                                                        const VkHostImageLayoutTransitionInfo* pTransitions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkTransitionImageLayoutEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateTransitionImageLayoutEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateTransitionImageLayoutEXT(device, transitionCount, pTransitions, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkTransitionImageLayoutEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordTransitionImageLayoutEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordTransitionImageLayoutEXT(device, transitionCount, pTransitions, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->TransitionImageLayoutEXT(device, transitionCount, pTransitions);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordTransitionImageLayoutEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordTransitionImageLayoutEXT(device, transitionCount, pTransitions, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetImageSubresourceLayout2EXT(VkDevice device, VkImage image, const VkImageSubresource2* pSubresource,
                                                         VkSubresourceLayout2* pLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageSubresourceLayout2EXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageSubresourceLayout2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageSubresourceLayout2EXT(device, image, pSubresource, pLayout, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageSubresourceLayout2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageSubresourceLayout2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageSubresourceLayout2EXT(device, image, pSubresource, pLayout, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetImageSubresourceLayout2EXT(device, image, pSubresource, pLayout);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageSubresourceLayout2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageSubresourceLayout2EXT(device, image, pSubresource, pLayout, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL ReleaseSwapchainImagesEXT(VkDevice device, const VkReleaseSwapchainImagesInfoEXT* pReleaseInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkReleaseSwapchainImagesEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateReleaseSwapchainImagesEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateReleaseSwapchainImagesEXT(device, pReleaseInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkReleaseSwapchainImagesEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordReleaseSwapchainImagesEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordReleaseSwapchainImagesEXT(device, pReleaseInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ReleaseSwapchainImagesEXT(device, pReleaseInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordReleaseSwapchainImagesEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordReleaseSwapchainImagesEXT(device, pReleaseInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetGeneratedCommandsMemoryRequirementsNV(VkDevice device,
                                                                    const VkGeneratedCommandsMemoryRequirementsInfoNV* pInfo,
                                                                    VkMemoryRequirements2* pMemoryRequirements) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetGeneratedCommandsMemoryRequirementsNV,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetGeneratedCommandsMemoryRequirementsNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetGeneratedCommandsMemoryRequirementsNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetGeneratedCommandsMemoryRequirementsNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetGeneratedCommandsMemoryRequirementsNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetGeneratedCommandsMemoryRequirementsNV(device, pInfo, pMemoryRequirements, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdPreprocessGeneratedCommandsNV(VkCommandBuffer commandBuffer,
                                                            const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdPreprocessGeneratedCommandsNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdPreprocessGeneratedCommandsNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdPreprocessGeneratedCommandsNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdPreprocessGeneratedCommandsNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdPreprocessGeneratedCommandsNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdPreprocessGeneratedCommandsNV(commandBuffer, pGeneratedCommandsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdExecuteGeneratedCommandsNV(VkCommandBuffer commandBuffer, VkBool32 isPreprocessed,
                                                         const VkGeneratedCommandsInfoNV* pGeneratedCommandsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdExecuteGeneratedCommandsNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdExecuteGeneratedCommandsNV]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdExecuteGeneratedCommandsNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdExecuteGeneratedCommandsNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdExecuteGeneratedCommandsNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdExecuteGeneratedCommandsNV(commandBuffer, isPreprocessed, pGeneratedCommandsInfo, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindPipelineShaderGroupNV(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                        VkPipeline pipeline, uint32_t groupIndex) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindPipelineShaderGroupNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindPipelineShaderGroupNV]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindPipelineShaderGroupNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindPipelineShaderGroupNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindPipelineShaderGroupNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindPipelineShaderGroupNV(commandBuffer, pipelineBindPoint, pipeline, groupIndex, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateIndirectCommandsLayoutNV(VkDevice device,
                                                              const VkIndirectCommandsLayoutCreateInfoNV* pCreateInfo,
                                                              const VkAllocationCallbacks* pAllocator,
                                                              VkIndirectCommandsLayoutNV* pIndirectCommandsLayout) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateIndirectCommandsLayoutNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateIndirectCommandsLayoutNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout,
                                                                      error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateIndirectCommandsLayoutNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateIndirectCommandsLayoutNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateIndirectCommandsLayoutNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateIndirectCommandsLayoutNV(device, pCreateInfo, pAllocator, pIndirectCommandsLayout, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyIndirectCommandsLayoutNV(VkDevice device, VkIndirectCommandsLayoutNV indirectCommandsLayout,
                                                           const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyIndirectCommandsLayoutNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyIndirectCommandsLayoutNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyIndirectCommandsLayoutNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyIndirectCommandsLayoutNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyIndirectCommandsLayoutNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyIndirectCommandsLayoutNV(device, indirectCommandsLayout, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDepthBias2EXT(VkCommandBuffer commandBuffer, const VkDepthBiasInfoEXT* pDepthBiasInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDepthBias2EXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDepthBias2EXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDepthBias2EXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDepthBias2EXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDepthBias2EXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDepthBias2EXT(commandBuffer, pDepthBiasInfo, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL AcquireDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireDrmDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireDrmDisplayEXT(physicalDevice, drmFd, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireDrmDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireDrmDisplayEXT(physicalDevice, drmFd, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->AcquireDrmDisplayEXT(physicalDevice, drmFd, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordAcquireDrmDisplayEXT(physicalDevice, drmFd, display, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetDrmDisplayEXT(VkPhysicalDevice physicalDevice, int32_t drmFd, uint32_t connectorId,
                                                VkDisplayKHR* display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDrmDisplayEXT, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDrmDisplayEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDrmDisplayEXT(physicalDevice, drmFd, connectorId, display, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreatePrivateDataSlotEXT(VkDevice device, const VkPrivateDataSlotCreateInfo* pCreateInfo,
                                                        const VkAllocationCallbacks* pAllocator,
                                                        VkPrivateDataSlot* pPrivateDataSlot) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreatePrivateDataSlotEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreatePrivateDataSlotEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreatePrivateDataSlotEXT(device, pCreateInfo, pAllocator, pPrivateDataSlot, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreatePrivateDataSlotEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreatePrivateDataSlotEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreatePrivateDataSlotEXT(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreatePrivateDataSlotEXT(device, pCreateInfo, pAllocator, pPrivateDataSlot);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreatePrivateDataSlotEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreatePrivateDataSlotEXT(device, pCreateInfo, pAllocator, pPrivateDataSlot, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyPrivateDataSlotEXT(VkDevice device, VkPrivateDataSlot privateDataSlot,
                                                     const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyPrivateDataSlotEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyPrivateDataSlotEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyPrivateDataSlotEXT(device, privateDataSlot, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyPrivateDataSlotEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyPrivateDataSlotEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyPrivateDataSlotEXT(device, privateDataSlot, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyPrivateDataSlotEXT(device, privateDataSlot, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyPrivateDataSlotEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyPrivateDataSlotEXT(device, privateDataSlot, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL SetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                                 VkPrivateDataSlot privateDataSlot, uint64_t data) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkSetPrivateDataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateSetPrivateDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateSetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, data, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkSetPrivateDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordSetPrivateDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordSetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->SetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, data);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordSetPrivateDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordSetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, data, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL GetPrivateDataEXT(VkDevice device, VkObjectType objectType, uint64_t objectHandle,
                                             VkPrivateDataSlot privateDataSlot, uint64_t* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPrivateDataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetPrivateDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, pData, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPrivateDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetPrivateDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, pData);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetPrivateDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPrivateDataEXT(device, objectType, objectHandle, privateDataSlot, pData, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCudaModuleNV(VkDevice device, const VkCudaModuleCreateInfoNV* pCreateInfo,
                                                  const VkAllocationCallbacks* pAllocator, VkCudaModuleNV* pModule) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCudaModuleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCudaModuleNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCudaModuleNV(device, pCreateInfo, pAllocator, pModule, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCudaModuleNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCudaModuleNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCudaModuleNV(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateCudaModuleNV(device, pCreateInfo, pAllocator, pModule);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCudaModuleNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCudaModuleNV(device, pCreateInfo, pAllocator, pModule, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetCudaModuleCacheNV(VkDevice device, VkCudaModuleNV module, size_t* pCacheSize, void* pCacheData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetCudaModuleCacheNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetCudaModuleCacheNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetCudaModuleCacheNV(device, module, pCacheSize, pCacheData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetCudaModuleCacheNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetCudaModuleCacheNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetCudaModuleCacheNV(device, module, pCacheSize, pCacheData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetCudaModuleCacheNV(device, module, pCacheSize, pCacheData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetCudaModuleCacheNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetCudaModuleCacheNV(device, module, pCacheSize, pCacheData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateCudaFunctionNV(VkDevice device, const VkCudaFunctionCreateInfoNV* pCreateInfo,
                                                    const VkAllocationCallbacks* pAllocator, VkCudaFunctionNV* pFunction) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateCudaFunctionNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCreateCudaFunctionNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateCudaFunctionNV(device, pCreateInfo, pAllocator, pFunction, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateCudaFunctionNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCreateCudaFunctionNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateCudaFunctionNV(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->CreateCudaFunctionNV(device, pCreateInfo, pAllocator, pFunction);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCreateCudaFunctionNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateCudaFunctionNV(device, pCreateInfo, pAllocator, pFunction, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL DestroyCudaModuleNV(VkDevice device, VkCudaModuleNV module, const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCudaModuleNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCudaModuleNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCudaModuleNV(device, module, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCudaModuleNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCudaModuleNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCudaModuleNV(device, module, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyCudaModuleNV(device, module, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCudaModuleNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCudaModuleNV(device, module, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL DestroyCudaFunctionNV(VkDevice device, VkCudaFunctionNV function,
                                                 const VkAllocationCallbacks* pAllocator) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkDestroyCudaFunctionNV, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateDestroyCudaFunctionNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateDestroyCudaFunctionNV(device, function, pAllocator, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkDestroyCudaFunctionNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordDestroyCudaFunctionNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordDestroyCudaFunctionNV(device, function, pAllocator, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->DestroyCudaFunctionNV(device, function, pAllocator);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordDestroyCudaFunctionNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordDestroyCudaFunctionNV(device, function, pAllocator, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdCudaLaunchKernelNV(VkCommandBuffer commandBuffer, const VkCudaLaunchInfoNV* pLaunchInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdCudaLaunchKernelNV, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdCudaLaunchKernelNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdCudaLaunchKernelNV(commandBuffer, pLaunchInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdCudaLaunchKernelNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdCudaLaunchKernelNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdCudaLaunchKernelNV(commandBuffer, pLaunchInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdCudaLaunchKernelNV(commandBuffer, pLaunchInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdCudaLaunchKernelNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdCudaLaunchKernelNV(commandBuffer, pLaunchInfo, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_METAL_EXT
VKAPI_ATTR void VKAPI_CALL ExportMetalObjectsEXT(VkDevice device, VkExportMetalObjectsInfoEXT* pMetalObjectsInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkExportMetalObjectsEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateExportMetalObjectsEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateExportMetalObjectsEXT(device, pMetalObjectsInfo, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkExportMetalObjectsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordExportMetalObjectsEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordExportMetalObjectsEXT(device, pMetalObjectsInfo, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->ExportMetalObjectsEXT(device, pMetalObjectsInfo);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordExportMetalObjectsEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordExportMetalObjectsEXT(device, pMetalObjectsInfo, record_obj);
        }
    }
}

#endif  // VK_USE_PLATFORM_METAL_EXT
VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutSizeEXT(VkDevice device, VkDescriptorSetLayout layout,
                                                         VkDeviceSize* pLayoutSizeInBytes) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutSizeEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutSizeEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutSizeEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutSizeEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutSizeEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutSizeEXT(device, layout, pLayoutSizeInBytes, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorSetLayoutBindingOffsetEXT(VkDevice device, VkDescriptorSetLayout layout, uint32_t binding,
                                                                  VkDeviceSize* pOffset) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorSetLayoutBindingOffsetEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorSetLayoutBindingOffsetEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorSetLayoutBindingOffsetEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorSetLayoutBindingOffsetEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorSetLayoutBindingOffsetEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorSetLayoutBindingOffsetEXT(device, layout, binding, pOffset, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL GetDescriptorEXT(VkDevice device, const VkDescriptorGetInfoEXT* pDescriptorInfo, size_t dataSize,
                                            void* pDescriptor) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDescriptorEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDescriptorEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDescriptorEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDescriptorEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->GetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDescriptorEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDescriptorEXT(device, pDescriptorInfo, dataSize, pDescriptor, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorBuffersEXT(VkCommandBuffer commandBuffer, uint32_t bufferCount,
                                                       const VkDescriptorBufferBindingInfoEXT* pBindingInfos) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorBuffersEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorBuffersEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorBuffersEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorBuffersEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorBuffersEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorBuffersEXT(commandBuffer, bufferCount, pBindingInfos, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdSetDescriptorBufferOffsetsEXT(VkCommandBuffer commandBuffer, VkPipelineBindPoint pipelineBindPoint,
                                                            VkPipelineLayout layout, uint32_t firstSet, uint32_t setCount,
                                                            const uint32_t* pBufferIndices, const VkDeviceSize* pOffsets) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetDescriptorBufferOffsetsEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetDescriptorBufferOffsetsEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet,
                                                                        setCount, pBufferIndices, pOffsets, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetDescriptorBufferOffsetsEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetDescriptorBufferOffsetsEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet, setCount,
                                                              pBufferIndices, pOffsets, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet, setCount,
                                                          pBufferIndices, pOffsets);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetDescriptorBufferOffsetsEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetDescriptorBufferOffsetsEXT(commandBuffer, pipelineBindPoint, layout, firstSet, setCount,
                                                               pBufferIndices, pOffsets, record_obj);
        }
    }
}

VKAPI_ATTR void VKAPI_CALL CmdBindDescriptorBufferEmbeddedSamplersEXT(VkCommandBuffer commandBuffer,
                                                                      VkPipelineBindPoint pipelineBindPoint,
                                                                      VkPipelineLayout layout, uint32_t set) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplersEXT,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplersEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set,
                                                                                  error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdBindDescriptorBufferEmbeddedSamplersEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT(commandBuffer, pipelineBindPoint, layout, set, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetBufferOpaqueCaptureDescriptorDataEXT(VkDevice device,
                                                                       const VkBufferCaptureDescriptorDataInfoEXT* pInfo,
                                                                       void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetBufferOpaqueCaptureDescriptorDataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetBufferOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetBufferOpaqueCaptureDescriptorDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetBufferOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetBufferOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetBufferOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageOpaqueCaptureDescriptorDataEXT(VkDevice device,
                                                                      const VkImageCaptureDescriptorDataInfoEXT* pInfo,
                                                                      void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageOpaqueCaptureDescriptorDataEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageOpaqueCaptureDescriptorDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetImageViewOpaqueCaptureDescriptorDataEXT(VkDevice device,
                                                                          const VkImageViewCaptureDescriptorDataInfoEXT* pInfo,
                                                                          void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetImageViewOpaqueCaptureDescriptorDataEXT,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetImageViewOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetImageViewOpaqueCaptureDescriptorDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSamplerOpaqueCaptureDescriptorDataEXT(VkDevice device,
                                                                        const VkSamplerCaptureDescriptorDataInfoEXT* pInfo,
                                                                        void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSamplerOpaqueCaptureDescriptorDataEXT,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSamplerOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSamplerOpaqueCaptureDescriptorDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(
    VkDevice device, const VkAccelerationStructureCaptureDescriptorDataInfoEXT* pInfo, void* pData) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
                          VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetAccelerationStructureOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetAccelerationStructureOpaqueCaptureDescriptorDataEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT(device, pInfo, pData, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR void VKAPI_CALL CmdSetFragmentShadingRateEnumNV(VkCommandBuffer commandBuffer, VkFragmentShadingRateNV shadingRate,
                                                           const VkFragmentShadingRateCombinerOpKHR combinerOps[2]) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetFragmentShadingRateEnumNV,
                          VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetFragmentShadingRateEnumNV]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetFragmentShadingRateEnumNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetFragmentShadingRateEnumNV]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetFragmentShadingRateEnumNV]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetFragmentShadingRateEnumNV(commandBuffer, shadingRate, combinerOps, record_obj);
        }
    }
}

VKAPI_ATTR VkResult VKAPI_CALL GetDeviceFaultInfoEXT(VkDevice device, VkDeviceFaultCountsEXT* pFaultCounts,
                                                     VkDeviceFaultInfoEXT* pFaultInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetDeviceFaultInfoEXT, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetDeviceFaultInfoEXT]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetDeviceFaultInfoEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetDeviceFaultInfoEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetDeviceFaultInfoEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetDeviceFaultInfoEXT(device, pFaultCounts, pFaultInfo, record_obj);
        }
    }
    return result;
}

#ifdef VK_USE_PLATFORM_WIN32_KHR
VKAPI_ATTR VkResult VKAPI_CALL AcquireWinrtDisplayNV(VkPhysicalDevice physicalDevice, VkDisplayKHR display) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkAcquireWinrtDisplayNV, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateAcquireWinrtDisplayNV(physicalDevice, display, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkAcquireWinrtDisplayNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordAcquireWinrtDisplayNV(physicalDevice, display, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->AcquireWinrtDisplayNV(physicalDevice, display);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordAcquireWinrtDisplayNV(physicalDevice, display, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetWinrtDisplayNV(VkPhysicalDevice physicalDevice, uint32_t deviceRelativeId,
                                                 VkDisplayKHR* pDisplay) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetWinrtDisplayNV, VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetWinrtDisplayNV);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();

            if (result == VK_ERROR_DEVICE_LOST) {
                vo->is_device_lost = true;
            }
            vo->PostCallRecordGetWinrtDisplayNV(physicalDevice, deviceRelativeId, pDisplay, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_WIN32_KHR
#ifdef VK_USE_PLATFORM_DIRECTFB_EXT
VKAPI_ATTR VkResult VKAPI_CALL CreateDirectFBSurfaceEXT(VkInstance instance, const VkDirectFBSurfaceCreateInfoEXT* pCreateInfo,
                                                        const VkAllocationCallbacks* pAllocator, VkSurfaceKHR* pSurface) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(instance);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCreateDirectFBSurfaceEXT, VulkanTypedHandle(instance, kVulkanObjectTypeInstance));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateCreateDirectFBSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkCreateDirectFBSurfaceEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCreateDirectFBSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->CreateDirectFBSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCreateDirectFBSurfaceEXT(instance, pCreateInfo, pAllocator, pSurface, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkBool32 VKAPI_CALL GetPhysicalDeviceDirectFBPresentationSupportEXT(VkPhysicalDevice physicalDevice,
                                                                               uint32_t queueFamilyIndex, IDirectFB* dfb) {
    VVL_ZoneScoped;

    auto instance_dispatch = vvl::dispatch::GetData(physicalDevice);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetPhysicalDeviceDirectFBPresentationSupportEXT,
                          VulkanTypedHandle(physicalDevice, kVulkanObjectTypePhysicalDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb,
                                                                                       error_obj);
            if (skip) return VK_FALSE;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetPhysicalDeviceDirectFBPresentationSupportEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb, record_obj);
        }
    }
    VkBool32 result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = instance_dispatch->GetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : instance_dispatch->object_dispatch) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetPhysicalDeviceDirectFBPresentationSupportEXT(physicalDevice, queueFamilyIndex, dfb, record_obj);
        }
    }
    return result;
}

#endif  // VK_USE_PLATFORM_DIRECTFB_EXT
VKAPI_ATTR void VKAPI_CALL CmdSetVertexInputEXT(VkCommandBuffer commandBuffer, uint32_t vertexBindingDescriptionCount,
                                                const VkVertexInputBindingDescription2EXT* pVertexBindingDescriptions,
                                                uint32_t vertexAttributeDescriptionCount,
                                                const VkVertexInputAttributeDescription2EXT* pVertexAttributeDescriptions) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(commandBuffer);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkCmdSetVertexInputEXT, VulkanTypedHandle(commandBuffer, kVulkanObjectTypeCommandBuffer));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateCmdSetVertexInputEXT]) {
            auto lock = vo->ReadLock();
            skip |=
                vo->PreCallValidateCmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions,
                                                        vertexAttributeDescriptionCount, pVertexAttributeDescriptions, error_obj);
            if (skip) return;
        }
    }
    RecordObject record_obj(vvl::Func::vkCmdSetVertexInputEXT);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordCmdSetVertexInputEXT]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordCmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions,
                                                  vertexAttributeDescriptionCount, pVertexAttributeDescriptions, record_obj);
        }
    }
    {
        VVL_ZoneScopedN("Dispatch");
        device_dispatch->CmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions,
                                              vertexAttributeDescriptionCount, pVertexAttributeDescriptions);
    }
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordCmdSetVertexInputEXT]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordCmdSetVertexInputEXT(commandBuffer, vertexBindingDescriptionCount, pVertexBindingDescriptions,
                                                   vertexAttributeDescriptionCount, pVertexAttributeDescriptions, record_obj);
        }
    }
}

#ifdef VK_USE_PLATFORM_FUCHSIA
VKAPI_ATTR VkResult VKAPI_CALL GetMemoryZirconHandleFUCHSIA(VkDevice device,
                                                            const VkMemoryGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo,
                                                            zx_handle_t* pZirconHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryZirconHandleFUCHSIA, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryZirconHandleFUCHSIA]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryZirconHandleFUCHSIA);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL
GetMemoryZirconHandlePropertiesFUCHSIA(VkDevice device, VkExternalMemoryHandleTypeFlagBits handleType, zx_handle_t zirconHandle,
                                       VkMemoryZirconHandlePropertiesFUCHSIA* pMemoryZirconHandleProperties) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetMemoryZirconHandlePropertiesFUCHSIA, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo :
             device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetMemoryZirconHandlePropertiesFUCHSIA]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle,
                                                                              pMemoryZirconHandleProperties, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetMemoryZirconHandlePropertiesFUCHSIA);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetMemoryZirconHandlePropertiesFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle, pMemoryZirconHandleProperties,
                                                                    record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle,
                                                                         pMemoryZirconHandleProperties);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetMemoryZirconHandlePropertiesFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetMemoryZirconHandlePropertiesFUCHSIA(device, handleType, zirconHandle,
                                                                     pMemoryZirconHandleProperties, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL ImportSemaphoreZirconHandleFUCHSIA(
    VkDevice device, const VkImportSemaphoreZirconHandleInfoFUCHSIA* pImportSemaphoreZirconHandleInfo) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkImportSemaphoreZirconHandleFUCHSIA, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateImportSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkImportSemaphoreZirconHandleFUCHSIA);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordImportSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->ImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordImportSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordImportSemaphoreZirconHandleFUCHSIA(device, pImportSemaphoreZirconHandleInfo, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL GetSemaphoreZirconHandleFUCHSIA(VkDevice device,
                                                               const VkSemaphoreGetZirconHandleInfoFUCHSIA* pGetZirconHandleInfo,
                                                               zx_handle_t* pZirconHandle) {
    VVL_ZoneScoped;

    auto device_dispatch = vvl::dispatch::GetData(device);
    bool skip = false;
    ErrorObject error_obj(vvl::Func::vkGetSemaphoreZirconHandleFUCHSIA, VulkanTypedHandle(device, kVulkanObjectTypeDevice));
    {
        VVL_ZoneScopedN("PreCallValidate");
        for (const auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallValidateGetSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->ReadLock();
            skip |= vo->PreCallValidateGetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, error_obj);
            if (skip) return VK_ERROR_VALIDATION_FAILED_EXT;
        }
    }
    RecordObject record_obj(vvl::Func::vkGetSemaphoreZirconHandleFUCHSIA);
    {
        VVL_ZoneScopedN("PreCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPreCallRecordGetSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PreCallRecordGetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, record_obj);
        }
    }
    VkResult result;
    {
        VVL_ZoneScopedN("Dispatch");
        result = device_dispatch->GetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle);
    }
    record_obj.result = result;
    {
        VVL_ZoneScopedN("PostCallRecord");
        for (auto& vo : device_dispatch->intercept_vectors[InterceptIdPostCallRecordGetSemaphoreZirconHandleFUCHSIA]) {
            auto lock = vo->WriteLock();
            vo->PostCallRecordGetSemaphoreZirconHandleFUCHSIA(device, pGetZirconHandleInfo, pZirconHandle, record_obj);
        }
    }
    return result;
}

VKAPI_ATTR VkResult VKAPI_CALL CreateBufferCollectionFUCHSIA(VkDevice device,
                                                             const VkBufferCollectionCreateInfoFUCHSIA* pCreateInfo,
                                                             const VkAllocationCallbacks* pAllocator,
                                                             VkBufferCollectionFUCHSIA* pCollection) {
    VVL_ZoneScoped;

    au