#!/usr/bin/perl -w
use Fcntl 'SEEK_SET';

@INFILES=("cty.dat", "master.scp", "titlpage.html", 
    "tucnakcw", "tucnaknames", "tucnakrc", "tucnakdw", "tucnakwiz",
    "tucnakvexckac",
    "tucnakvexcdok",
    "tucnakvexcagcw", "tucnakvexcokres", "tucnakvexcrsgbdc",
    "tucnakvexcusaca", 
    "tucnakvexcwna", 
    "tucnakvexcwsa", 
    "update_deb.sh", "update_eee.sh");
$OUTFILE="../src/txts.inc";
$OUTH="../src/txts.h";
$PREFIX="txt";


open GD, ">$OUTFILE" or die "Can't open file $OUTFILE";
print GD "/* Automatically generated by txt2inc.pl */\n\n";

$h="/* Automatically generated by txt2inc.pl */\n\n";

for $filename (@INFILES){
    $nr="";
    $data="";
    print "$filename\n";
    open (FD, $filename) or die;
    sysseek(FD, 0, 2);
    sysseek(FD, 0, 0);

    $ident=$filename;
    $ident=~s/\..*//;

    while($s=<FD>){
        $s=~s/[\r\n]+//g;
        $s=~s/\\/\\\\/g; 
        $s=~s/\"/\\"/g; 
        $s=~s/\t/\\t/g;
        $s="\"$s\\n\"\n";
        if (length($data) + length($s) > 65530){
            print GD "const char $PREFIX"."_$ident$nr"."[".length($data)."] = \n";
            print GD $data;
            print GD ";\n\n";
            $h.=sprintf "extern const char $PREFIX"."_$ident$nr"."[".length($data)."];\n";
            $data="";
            $nr++;
        }
        $data.=$s;
    }
    if (length($data)>0){
        print GD "const char $PREFIX"."_$ident$nr"."[".length($data)."] = \n";
        print GD $data;
        print GD ";\n\n";
        $h.=sprintf "extern const char $PREFIX"."_$ident$nr"."[".length($data)."];\n";
    }
    close(FD);
}

close GD;

#print $h;

$oldh=`cat $OUTH`;
if (!$oldh or $h ne $oldh){
    print "new header\n";
    open FD, ">$OUTH" or die;
    print FD $h;
    close FD;
}else{
    print "same header\n";
}
