// Copyright 2002 - 2008, 2010, 2011 National Technology Engineering
// Solutions of Sandia, LLC (NTESS). Under the terms of Contract
// DE-NA0003525 with NTESS, the U.S. Government retains certain rights
// in this software.
//
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

#ifndef AdaptMain_hpp
#define AdaptMain_hpp

  namespace percept {

    static std::string detailed_docString = 
      "Welcome to Percept's command-line interface.  Percept can uniformly refine a mesh in parallel to\n"
      "create very large simulation inputs, while respecting the geometry of the original model using CAD\n"
      "data. It can convert a mesh from one topology to another (eg Tetrahedra to Hexahedra) or enrich a\n"
      "linear mesh to quadratic (eg Quad4 to Quad9). It contains an option to project new nodes to CAD\n"
      "geometry and smooth the resulting mesh including surface nodes. An option exists to load balance \n"
      "the mesh (read it in and split it over M processors) on input.  Percept can be used to smooth an \n"
      "existing mesh using the Mesquite shape-based quality measure.\n"
      "The basic usage is to specify an input and output mesh and an operation to perform on the mesh:\n"
      "\n"
      "mesh_adapt --input_mesh=in.e --output_mesh=out.e --refine=DEFAULT\n"
      "\n"
      "(these are the minimal options).  If DEFAULT is chose for the refine or enrich option, the input\n"
      "mesh will be examined for each type of element and an appropriate refine/enrich option will be\n"
      "chosen automatically; therefore, hybrid meshes can be processed.  To convert topology, an option for\n"
      "--convert must be chosen, and the input mesh is required to have one topology.\n"
      "\n"
      "Respecting Spacing\n"
      "\n"
      "The option --respect_spacing is on by default; it computes a spacing value on each edge of the\n"
      "original mesh, averages this to the nodes, then uses this value to determine a location on the edge\n"
      "(or face) to place new nodes to respect the spacing/grading of the original mesh.  Thus, for a\n"
      "boundary-layer type mesh in a flow simulation, refinement will produce nodes with the same grading\n"
      "as the original mesh.  This option does not currently work with some topologies (e.g. quadratic\n"
      "elements), thus you may need to turn it off if Percept gives an error message about a small or\n"
      "negative Jacobian.\n"
      "\n"
      "Geometry Enforcement\n"
      "\n"
      "Percept can refine/convert/enrich a mesh and have new nodes 'snapped' to the original geometry.\n"
      "Cubit can be used to output a .3dm (OpenNURBS) file that contains the geometry of the model used to\n"
      "create the mesh (see option 'parallel refine' in Cubit).  If your mesh was not created originally in\n"
      "Cubit, but you have the .SAT (ACIS) or other geometry file, you can re-associate the mesh with the\n"
      "geometry in Cubit and then output the .3dm file required by Percept.  A typical command would then\n"
      "be\n"
      "\n"
      "  mesh_adapt --input_mesh=in.e --output_mesh=out.e --refine=DEFAULT --input_geometry=in.3dm\n"
      "\n"
      "You can request that the mesh be smoothed after node projection to remove any inverted elements and\n"
      "then improve the mesh quality using the Mesquite shape-based quality measure.  Just add\n"
      "--smooth_geometry=1 to the command line.  Optionally, add --smooth_surfaces=1 to request nodes be\n"
      "moved on the surfaces to further improve mesh quality after projection.\n"
      "\n"
      "Smoothing an Existing Mesh\n"
      "\n"
      "An existing mesh can be smoothed using Mesquite's shape-based quality measure.  This is useful, for\n"
      "example, to create a mesh with elements that are more uniform in volume which may help increase\n"
      "minimum time step sizes in explicit dynamics runs.  Use a command line like this:\n"
      "\n"
      "  mesh_adapt --input_mesh=in.e --output_mesh=out.e --refine=DEFAULT --number_refines=0\n"
      "  --smooth_use_reference_mesh=0 --fix_all_block_boundaries=1 --smooth_geometry=1\n"
      "\n"
      "The --fix_all_block_boundaries=1 options freezes the position of nodes on block boundaries,\n"
      "including those shared between two blocks.\n"
      "\n"
      "Subsetting Operation\n"
      "\n"
      "Operations can be restricted to a subset of blocks using --blocks=<command> where command is a\n"
      "string specifying a list of blocks to include, exclude or both.  See the usage message for full\n"
      "details.  An example is\n"
      "\n"
      "  mesh_adapt --input_mesh=in.e --output_mesh=out.e --refine=DEFAULT\n"
      "     --blocks=block_1..block_10,-block_8\n"
      "\n"
      "which would refine blocks 1-10 but not block_8.  Note that this can cause a mesh to have some blocks\n"
      "refined and neighboring blocks not refined, which may result in an invalid mesh.\n"
      "\n"
      "Verify/Query Operations\n"
      "\n"
      "The element volumes can be verified (on input and output) with --verify_meshes=1. Information about\n"
      "the mesh (parts, number of elements, nodes, etc.) can be printed with --print_info={1,2,3} with\n"
      "larger numbers giving more info (no other operations are performed if --print_info is non-zero).  If\n"
      "one adds --query_only=1, the requested operations will not be performed, but the estimates of\n"
      "refined mesh size will be printed.  If --estimate_memory_usage=1 is used, especially with\n"
      "--query_only=1, and estimate of required memory will be printed.  If --print_memory_usage=1 is set,\n"
      "the actual memory used will be printed.\n"
      "\n"
      "Mesh Sizing Queries\n"
      "\n"
      "Use --compute_hmesh={edges,eigens} to print a histogram of mesh edge lengths or Jacobian\n"
      "eigenvalues.  This is useful for just an input mesh query, or to compare the before/after refine\n"
      "values when doing a mesh refinement sequence in a verification study.  Use\n"
      "--print_hmesh_surface_normal=1 to print a histogram of mesh normal spacing at boundaries (useful for\n"
      "evaluating the near-wall mesh size in e.g. a turbulent wall calculation).\n"
      "\n"
      "Mesh/Field Histograms\n"
      "\n"
      "Percept can probe the mesh and field data of an input Exodus database and compute and print a\n"
      "histogram of the results.  Use --histogram=<command> where command is a string with instructions on\n"
      "what to print, which are in YAML format (see yaml.org).  The string is specified in yaml 'flow'\n"
      "format, e.g.\n"
      "\n"
      " { fields: [pressure,temperature], file_root: my_query, time: 0.1 }\n"
      "\n"
      "will probe the mesh at time value 0.1 and write histograms of pressure and temperature to files\n"
      "my_query.pressure.hist, and my_query.temperature.hist. Instead of specifying commands in the string\n"
      "to --histogram, <command> can just be a file name which will be read for commands in yaml\n"
      "format. Additional options are shown in the usage message.\n"
      "\n"
      "Ioss Options\n"
      "\n"
      "Percept can be used to create meshes with billions of elements and nodes using the Exodus large-mesh\n"
      "settings (which uses all 64-bit integers internally to allow exa-scale identifiers).  During mesh\n"
      "input, Exodus can be instructed to decompose the mesh 'on-the-fly' with the 'auto-decomp' option.\n"
      "On output, the mesh can be joined 'on-the-fly' to produce a single output mesh (as opposed to a\n"
      "file-per-process as is the Exodus default).  A typical command is\n"
      "\n"
      "  mpiexec -n P mesh_adapt --input_mesh=in.e --output_mesh=out.e --refine=DEFAULT\n"
      "  --ioss_read_options='large,auto-decomp:yes' --ioss_write_options='large,auto-join:no'\n"
      "\n"
      "which would leave files in their 'split' state.\n"
      "\n"
      "Debugging/Advanced Options\n"
      "\n"
      "1. Use --dump_geometry_file to print contents of a .3dm file.\n"
      "2. --proc_rank_field=1 adds an element-based field with the value of the processor rank\n"
      "3. --progress_meter=1 will show a 'percent-complete' progress bar and other progress information\n"
      "4. --remove_geometry_blocks=1 will remove blocks in the input mesh that contain "
      "geometric-associativity information\n";

  }

#endif
