/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.piccolo2d.PCamera;
import org.piccolo2d.PNode;
import org.piccolo2d.event.PInputEvent;
import org.piccolo2d.extras.event.PSelectionEventHandler;
import org.piccolo2d.extras.swt.PSWTBoundsHandle;
import org.piccolo2d.extras.swt.PSWTPath;
import org.piccolo2d.extras.swt.SWTGraphics2D;
import org.piccolo2d.util.PBounds;
import org.piccolo2d.util.PPaintContext;

public class PSWTSelectionEventHandler
extends PSelectionEventHandler {
    PSWTPath marquee;
    PNode marqueeParent;
    Point2D pressPt;
    Point2D canvasPressPt;

    public PSWTSelectionEventHandler(PNode marqueeParent, PNode selectableParent) {
        super(new PNode(), selectableParent);
        this.marqueeParent = marqueeParent;
    }

    public PSWTSelectionEventHandler(PNode marqueeParent, List selectableParents) {
        super(new PNode(), selectableParents);
        this.marqueeParent = marqueeParent;
    }

    public void decorateSelectedNode(PNode node) {
        PSWTBoundsHandle.addBoundsHandlesTo(node);
    }

    public void undecorateSelectedNode(PNode node) {
        PSWTBoundsHandle.removeBoundsHandlesFrom(node);
    }

    protected void initializeSelection(PInputEvent pie) {
        super.initializeSelection(pie);
        this.pressPt = pie.getPosition();
        this.canvasPressPt = pie.getCanvasPosition();
    }

    protected void initializeMarquee(PInputEvent e) {
        super.initializeMarquee(e);
        this.marquee = new PSWTPath(new Rectangle2D.Float((float)this.pressPt.getX(), (float)this.pressPt.getY(), 0.0f, 0.0f)){
            private static final long serialVersionUID = 1L;

            protected void paint(PPaintContext paintContext) {
                SWTGraphics2D s2g = (SWTGraphics2D)paintContext.getGraphics();
                s2g.gc.setLineStyle(2);
                super.paint(paintContext);
                s2g.gc.setLineStyle(1);
            }
        };
        this.marquee.setStrokeColor(Color.black);
        this.marquee.setPaint(null);
        this.marqueeParent.addChild((PNode)this.marquee);
    }

    protected void updateMarquee(PInputEvent pie) {
        super.updateMarquee(pie);
        PBounds b = new PBounds();
        if (this.marqueeParent instanceof PCamera) {
            b.add(this.canvasPressPt);
            b.add(pie.getCanvasPosition());
        } else {
            b.add(this.pressPt);
            b.add(pie.getPosition());
        }
        this.marquee.setPathToRectangle((float)b.x, (float)b.y, (float)b.width, (float)b.height);
        b.reset();
        b.add(this.pressPt);
        b.add(pie.getPosition());
    }

    protected PBounds getMarqueeBounds() {
        if (this.marquee != null) {
            return this.marquee.getBounds();
        }
        return new PBounds();
    }

    protected void endMarqueeSelection(PInputEvent e) {
        super.endMarqueeSelection(e);
        this.marquee.removeFromParent();
        this.marquee = null;
    }

    protected void dragActivityStep(PInputEvent aEvent) {
    }
}

