/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UTIL_APR_H
#define _SC_UTIL_APR_H

// sc
#include "String.h"

// apr
struct apr_pool_t;


namespace apr
{

/** initialize apr subsystem. */
void initialize( int argc, char* argv[] );

/** create an apr pool with @a parent as parent pool. */
apr_pool_t* createPool( apr_pool_t* parent = 0 );

/** destroy @a pool. */
void destroyPool( apr_pool_t* pool );

// portable
sc::String getDefaultEncoding();
sc::String getLocaleEncoding();


/**
 * \brief scoped apr pool.
 */
class Pool
{
public:
  Pool( apr_pool_t* parent = 0, bool subpool = true )
  {
    if( subpool )
    {
      _pool = createPool(parent);
    }
    else
    {
      _pool = parent;
    }
  }

  ~Pool()
  {
    destroyPool(_pool);
  }

  operator apr_pool_t*() const
  {
    return _pool;
  }

private:
  apr_pool_t* _pool;
};


} // namespace

#endif // _SC_UTIL_APR_H
