/************************************************************************

The PLANETARY SOLUTION VSOP87 by Bretagnon P. and Francou G. can be found at
ftp://ftp.imcce.fr/pub/ephem/planets/vsop87

I (Johannes Gajdosik) have just taken the data obtained from above
(VSOP87.mer,...,VSOP87.nep) and rearranged it into this piece of software.

I can neigther allow nor forbid the usage of VSOP87.
The copyright notice below covers not the work of Bretagnon P. and Francou G.
but just my work, that is the compilation of the VSOP87 data
into the software supplied in this file.


Copyright (c) 2006 Johannes Gajdosik

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation
the rights to use, copy, modify, merge, publish, distribute, sublicense,
and/or sell copies of the Software, and to permit persons to whom the
Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

This is my implementation of the VSOP87 planetary solution.
I tried to optimize for speed by rearranging the terms so that
for a given touple of (a[0],a[1],...,a[11]) the values
  (cos,sin)(a[0]*lambda[0](T)+...a[11]*lambda[11](T))
have only to be calculated once.
Furthermore I used the addition formulas
  (cos,sin)(x+y) = ...
so that for given T the functions cos and sin have only to be called 12 times.

****************************************************************/

#include "vsop87.h"
#include "calc_interpolated_elements.h"
#include "elliptic_to_rectangular.h"

#include <string.h>
#include <math.h>

static
const int vsop87_max_lambda_factor[12] = {
  16,
  27,
  27,
  32,
  22,
  26,
  24,
  23,
  2,
  1,
  2,
  1,
};

static
const double lambda_0[12] = {
  4.40260884240,
  3.17614669689,
  1.75347045953,
  6.20347611291,
  0.59954649739,
  0.87401675650,
  5.48129387159,
  5.31188628676,
  5.19846674103,
  1.62790523337,
  2.35555589827,
  3.81034454697,
};

static
const double lambda_1[12] = {
  26087.9031415742,
  10213.2855462110,
   6283.0758499914,
   3340.6124266998,
	529.6909650946,
	213.2990954380,
	 74.7815985673,
	 38.1330356378,
  77713.7714681205,
  84334.6615813083,
  83286.9142695536,
  83997.0911355954,
};


  /* taken out from vsop87_constants: */
static
const double vsop87_l[8] = {
   26087.90314157420,
   10213.28554621100,
	6283.07584999140,
	3340.61242669981,
	 529.69096509460,
	 213.29909543800,
	  74.78159856730,
	  38.13303563780,
};

static
const double vsop87_constants[253] = {
	   0.38709830982,
	   0.00000000000,
	   0.00000000000,
	   4.40260884240,
	   0.0,
	  -0.00000934669,
	   0.00000003100,
	   0.04466059760,
	  -0.00552114624,
	  -0.00001860568,
	   0.00000079123,
	   0.00000000590,
	  -0.00000000016,
	   0.20072331368,
	   0.00143750118,
	  -0.00007974120,
	  -0.00000030459,
	   0.00000000812,
	  -0.00000000008,
	   0.04061563384,
	   0.00065433117,
	  -0.00001071215,
	   0.00000022459,
	  -0.00000000377,
	  -0.00000000003,
	   0.04563550461,
	  -0.00127633657,
	  -0.00000913350,
	   0.00000018993,
	  -0.00000000640,
	  -0.00000000002,
	   0.72332981996,
	   0.00000000000,
	   0.00000000000,
	   3.17614669689,
	   0.0,
	   0.00000287889,
	  -0.00000003038,
	  -0.00449282133,
	   0.00031259019,
	   0.00000604065,
	  -0.00000068351,
	   0.00000000494,
	   0.00000000060,
	   0.00506684726,
	  -0.00036121239,
	   0.00001846764,
	   0.00000003281,
	  -0.00000000614,
	  -0.00000000017,
	   0.00682410142,
	   0.00138133826,
	  -0.00001090942,
	  -0.00000186418,
	   0.00000000602,
	   0.00000000075,
	   0.02882285775,
	  -0.00040384791,
	  -0.00006232891,
	   0.00000024731,
	   0.00000004229,
	  -0.00000000006,
	   1.00000101778,
	   0.00000000000,
	   0.00000000000,
	   1.75347045953,
	   0.0,
	  -0.00000991013,
	  -0.00000002537,
	   0.00000000000,
	   0.00000000000,
	  -0.00374081650,
	  -0.00082267418,
	   0.00002762465,
	   0.00000116955,
	  -0.00000002696,
	  -0.00000000071,
	   0.01628447663,
	  -0.00062029655,
	  -0.00003382631,
	   0.00000085101,
	   0.00000002770,
	  -0.00000000047,
	   0.00000000000,
	  -0.00113468869,
	   0.00001237314,
	   0.00000126542,
	  -0.00000001372,
	  -0.00000000032,
	   0.00000000000,
	   0.00010180375,
	   0.00004701998,
	  -0.00000054174,
	  -0.00000002508,
	   0.00000000046,
	   1.52367934191,
	   0.00000000000,
	   0.00000000000,
	   6.20347611291,
	   0.0,
	   0.00000457003,
	  -0.00000005057,
	   0.00000000000,
	   0.00000000000,
	   0.08536560252,
	   0.00376330152,
	  -0.00024657776,
	  -0.00000367305,
	   0.00000011112,
	   0.00000000026,
	  -0.03789973236,
	   0.00624657465,
	   0.00015529482,
	  -0.00000634879,
	  -0.00000006593,
	   0.00000000073,
	   0.01047042574,
	   0.00017138526,
	  -0.00004077491,
	  -0.00000138835,
	   0.00000000916,
	   0.00000000176,
	   0.01228449307,
	  -0.00108020083,
	  -0.00001922224,
	   0.00000087186,
	   0.00000003090,
	   5.20260319132,
	   0.00000191323,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   0.59954649739,
	   0.0,
	  -0.00014837133,
	   0.00000007482,
	   0.00000000000,
	   0.00000000000,
	   0.04698572124,
	   0.00113010377,
	  -0.00010930126,
	  -0.00000428748,
	   0.00000020539,
	   0.01200385748,
	   0.00217149360,
	   0.00009858539,
	  -0.00000513109,
	  -0.00000009007,
	  -0.00206561098,
	  -0.00031340156,
	  -0.00001667392,
	   0.00000076926,
	   0.01118377157,
	  -0.00023427562,
	   0.00002086760,
	   0.00000050721,
	   9.55490959574,
	  -0.00002138957,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   0.87401675650,
	   0.0,
	   0.00036659741,
	  -0.00000033330,
	   0.00000000217,
	   0.00000000000,
	  -0.00296003595,
	  -0.00529602626,
	   0.00030928405,
	   0.00001296215,
	  -0.00000059959,
	   0.00000000000,
	   0.05542964254,
	  -0.00375593887,
	  -0.00031990236,
	   0.00001598633,
	   0.00000032451,
	   0.00000000000,
	  -0.00871747436,
	   0.00080171499,
	   0.00004142282,
	  -0.00000196049,
	  -0.00000009439,
	   0.01989147301,
	   0.00059439766,
	  -0.00005235117,
	  -0.00000127219,
	   0.00000008295,
	  19.21844606178,
	  -0.00000037163,
	   0.00000009791,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   5.48129387159,
	   0.0,
	  -0.00000848828,
	   0.00000010450,
	   0.00000000000,
	   0.00000000000,
	  -0.04595132376,
	   0.00018344115,
	  -0.00000080849,
	  -0.00000045396,
	   0.00000002185,
	   0.00563791307,
	  -0.00074964350,
	   0.00001210200,
	  -0.00000042088,
	  -0.00000001714,
	   0.00185915075,
	  -0.00012449382,
	  -0.00000207373,
	   0.00000007621,
	   0.00648617008,
	  -0.00011744733,
	   0.00000317799,
	   0.00000007317,
	  30.11038686942,
	  -0.00000166346,
	   0.00000006857,
	   0.00000000000,
	   0.00000000000,
	   0.00000000000,
	   5.31188628676,
	   0.0,
	   0.00000102311,
	  -0.00000004340,
	   0.00000000000,
	   0.00000000000,
	   0.00599977571,
	   0.00000871304,
	  -0.00000119902,
	  -0.00000004034,
	   0.00000000000,
	   0.00000000000,
	   0.00669242413,
	   0.00007824336,
	   0.00000080801,
	  -0.00000003955,
	   0.00000000000,
	   0.00000000000,
	  -0.01029147819,
	  -0.00000072727,
	  -0.00000006568,
	   0.00000001668,
	   0.01151683985,
	   0.00002575536,
	   0.00000019377,
	   0.00000001331,
};

static
const double vsop87_coefficients[61126*2] = {
	  -0.00000002893,    -0.00000011799,
	   0.00000000332,    -0.00000000078,
	   0.00000000001,     0.00000000003,
	  -0.00000091933,     0.00000023240,
	  -0.00000000656,    -0.00000002636,
	   0.00000000033,    -0.00000000009,
	  -0.00000063987,     0.00000001677,
	   0.00000000006,    -0.00000000055,
	   0.00000001754,    -0.00000064219,
	  -0.00000000058,    -0.00000000056,
	  -0.00000001018,     0.00000001921,
	   0.00000000087,     0.00000000151,
	  -0.00000004656,    -0.00000001902,
	  -0.00000000125,     0.00000000062,
	   0.00000002356,    -0.00000000340,
	   0.00000034105,    -0.00000000214,
	  -0.00000000097,     0.00000033741,
	   0.00000000025,    -0.00000000050,
	   0.00000000125,     0.00000000028,
	   0.00000001423,     0.00000000081,
	  -0.00000000035,     0.00000000059,
	   0.00000039352,    -0.00000000242,
	  -0.00000000244,     0.00000038921,
	  -0.00000002629,    -0.00000006147,
	   0.00000000453,    -0.00000000270,
	   0.00000048318,    -0.00000000210,
	  -0.00000000203,     0.00000047817,
	  -0.00000000124,    -0.00000000139,
	   0.00000000059,     0.00000000064,
	   0.00000001642,    -0.00000006257,
	   0.00000000289,    -0.00000000150,
	   0.00000089329,    -0.00000000565,
	  -0.00000000372,     0.00000088559,
	  -0.00000000180,    -0.00000000143,
	   0.00000010075,     0.00000000464,
	  -0.00000000678,     0.00000000954,
	   0.00000120906,    -0.00000000875,
	  -0.00000000297,     0.00000120136,
	  -0.00000000332,    -0.00000000171,
	   0.00000001393,     0.00000011733,
	  -0.00000000173,    -0.00000000044,
	   0.00000171894,    -0.00000000976,
	  -0.00000000859,     0.00000170186,
	   0.00000000307,     0.00000000307,
	   0.00000002168,    -0.00000001934,
	   0.00000214912,    -0.00000001640,
	  -0.00000000844,     0.00000213398,
	  -0.00000000066,    -0.00000000043,
	  -0.00000000073,    -0.00000000049,
	  -0.00000000005,    -0.00000000003,
	  -0.00000000003,     0.00000000005,
	  -0.00000000007,     0.00000000009,
	  -0.00000000007,     0.00000000027,
	   0.00000000005,     0.00000000001,
	   0.00000000028,     0.00000000006,
	   0.00000000001,    -0.00000000005,
	   0.00000000002,     0.00000000004,
	   0.00000000005,     0.00000000003,
	  -0.00000000001,     0.00000000004,
	   0.00000000054,     0.00000000015,
	   0.00000000002,    -0.00000000011,
	   0.00000000142,    -0.00000000013,
	  -0.00000000002,    -0.00000000022,
	  -0.00000000014,    -0.00000000143,
	  -0.00000000023,     0.00000000002,
	   0.00000000011,     0.00000000010,
	   0.00000000013,    -0.00000000012,
	   0.00000000020,     0.00000000001,
	   0.00000000023,    -0.00000000002,
	   0.00000000000,    -0.00000000004,
	  -0.00000000020,    -0.00000000285,
	  -0.00000000045,     0.00000000005,
	  -0.00000000297,    -0.00000000677,
	  -0.00000000091,     0.00000000040,
	   0.00000000002,     0.00000000004,
	  -0.00000000686,     0.00000000303,
	   0.00000000040,     0.00000000092,
	   0.00000000004,    -0.00000000002,
	   0.00000000026,    -0.00000000060,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000070,    -0.00000000042,
	  -0.00000000003,     0.00000000007,
	   0.00000000024,     0.00000000056,
	   0.00000000057,    -0.00000000024,
	   0.00000000002,    -0.00000000008,
	  -0.00000000008,    -0.00000000002,
	  -0.00000000005,     0.00000000000,
	   0.00000000000,     0.00000000005,
	   0.00000000006,    -0.00000000032,
	   0.00000000000,     0.00000000005,
	   0.00000000005,     0.00000000000,
	   0.00000000014,     0.00000000000,
	  -0.00000000063,    -0.00000000146,
	  -0.00000000018,     0.00000000008,
	  -0.00000001283,     0.00000000552,
	   0.00000000078,     0.00000000171,
	   0.00000000007,    -0.00000000003,
	  -0.00000003012,     0.00000002660,
	   0.00000000258,     0.00000000304,
	   0.00000000012,    -0.00000000011,
	   0.00000002703,     0.00000003054,
	   0.00000000309,    -0.00000000262,
	  -0.00000000011,    -0.00000000013,
	  -0.00000000283,    -0.00000000033,
	   0.00000000005,     0.00000000013,
	  -0.00000000099,     0.00000000359,
	   0.00000000023,     0.00000000001,
	   0.00000000029,     0.00000000068,
	   0.00000000072,    -0.00000000031,
	   0.00000000250,    -0.00000000219,
	  -0.00000000221,    -0.00000000259,
	  -0.00000000003,     0.00000000011,
	   0.00000000011,     0.00000000003,
	   0.00000000001,    -0.00000000005,
	   0.00000000048,     0.00000000012,
	  -0.00000000033,    -0.00000000001,
	  -0.00000000001,     0.00000000034,
	   0.00000000026,     0.00000000003,
	   0.00000002208,    -0.00000017037,
	   0.00000000500,     0.00000000347,
	   0.00000000001,    -0.00000000093,
	  -0.00000000091,     0.00000000002,
	   0.00000000001,    -0.00000000009,
	  -0.00000000224,     0.00000001642,
	  -0.00000000048,    -0.00000000042,
	   0.00000000084,    -0.00000000576,
	  -0.00000000969,     0.00000000846,
	   0.00000000083,     0.00000000098,
	   0.00000000004,    -0.00000000004,
	   0.00000003239,     0.00000003521,
	   0.00000000345,    -0.00000000319,
	  -0.00000000012,    -0.00000000012,
	   0.00000020786,     0.00000012709,
	   0.00000000881,    -0.00000001318,
	  -0.00000000038,    -0.00000000023,
	   0.00000012949,    -0.00000021142,
	  -0.00000001346,    -0.00000000909,
	  -0.00000000025,     0.00000000039,
	   0.00000000221,     0.00000001231,
	   0.00000000006,    -0.00000000030,
	   0.00000001794,     0.00000000034,
	  -0.00000000018,    -0.00000000061,
	   0.00000000359,    -0.00000000314,
	  -0.00000000029,    -0.00000000034,
	  -0.00000000185,    -0.00000000203,
	  -0.00000001743,    -0.00000001067,
	  -0.00000000069,     0.00000000104,
	  -0.00000001115,     0.00000001770,
	   0.00000000107,     0.00000000074,
	  -0.00000000003,    -0.00000000068,
	  -0.00000000083,    -0.00000000006,
	  -0.00000000004,     0.00000000017,
	  -0.00000000696,    -0.00000000163,
	   0.00000000000,     0.00000000018,
	   0.00000000109,     0.00000000000,
	   0.00000000000,    -0.00000000112,
	   0.00000000005,     0.00000000000,
	   0.00000000015,    -0.00000000159,
	   0.00000000003,     0.00000000002,
	   0.00000000001,    -0.00000000015,
	  -0.00000000011,     0.00000000002,
	   0.00000000007,    -0.00000000004,
	   0.00000016706,     0.00000010365,
	   0.00000000718,    -0.00000001078,
	  -0.00000000031,    -0.00000000019,
	  -0.00000146974,     0.00000231921,
	   0.00000015141,     0.00000010270,
	   0.00000000280,    -0.00000000452,
	   0.00000064161,    -0.00000238769,
	  -0.00000007418,    -0.00000002531,
	  -0.00000000018,     0.00000000119,
	  -0.00000243967,    -0.00000066559,
	  -0.00000002771,     0.00000007730,
	   0.00000000132,     0.00000000035,
	   0.00000006138,    -0.00000003078,
	  -0.00000000053,     0.00000000274,
	  -0.00000000003,    -0.00000000007,
	  -0.00000002102,    -0.00000012748,
	  -0.00000000093,     0.00000000113,
	  -0.00000000014,     0.00000000009,
	  -0.00000004647,    -0.00000002879,
	  -0.00000000200,     0.00000000299,
	   0.00000000009,     0.00000000005,
	   0.00000007314,    -0.00000011549,
	  -0.00000000753,    -0.00000000511,
	  -0.00000004963,     0.00000020844,
	   0.00000000598,     0.00000000171,
	   0.00000021294,     0.00000005391,
	   0.00000000212,    -0.00000000638,
	  -0.00000000412,     0.00000000085,
	   0.00000000044,     0.00000000587,
	  -0.00000000002,     0.00000000000,
	   0.00000000000,     0.00000000044,
	  -0.00000000010,    -0.00000000002,
	  -0.00000000009,     0.00000000004,
	  -0.00000016521,     0.00000071340,
	   0.00000002014,     0.00000000574,
	   0.00000000005,    -0.00000000027,
	   0.00001686982,     0.00000394035,
	   0.00000013916,    -0.00000047867,
	  -0.00000000613,    -0.00000000132,
	   0.00000445156,    -0.00000003021,
	   0.00000000012,     0.00000000363,
	   0.00000000011,     0.00000000015,
	   0.00000001223,    -0.00000463407,
	  -0.00000000322,    -0.00000000275,
	   0.00000000003,     0.00000000013,
	  -0.00000001112,    -0.00000001817,
	  -0.00000000122,     0.00000000203,
	  -0.00000000006,    -0.00000000010,
	   0.00000013525,    -0.00000000665,
	  -0.00000000081,    -0.00000000152,
	  -0.00000000012,    -0.00000000007,
	   0.00000002806,    -0.00000013517,
	  -0.00000000356,    -0.00000000086,
	  -0.00000081288,    -0.00000019014,
	  -0.00000000674,     0.00000002308,
	   0.00000012697,     0.00000000229,
	  -0.00000000427,    -0.00000011417,
	   0.00000000043,     0.00000000029,
	   0.00000000123,    -0.00000000225,
	  -0.00000000624,    -0.00000000122,
	   0.00000013008,     0.00000000057,
	   0.00000000017,    -0.00000000006,
	   0.00000000449,    -0.00000201760,
	  -0.00000000058,    -0.00000000289,
	   0.00000000004,     0.00000000005,
	  -0.00000000260,    -0.00000018158,
	   0.00000000039,    -0.00000000170,
	  -0.00000000001,     0.00000000007,
	  -0.00000002130,     0.00000005242,
	   0.00000000042,    -0.00000000584,
	  -0.00000000654,     0.00000001479,
	  -0.00000000021,    -0.00000000047,
	   0.00000000001,     0.00000000007,
	   0.00000000357,    -0.00000005883,
	  -0.00000000031,     0.00000000044,
	   0.00000043444,    -0.00000000082,
	   0.00000000015,     0.00000044908,
	   0.00000000376,     0.00000000274,
	  -0.00000000039,     0.00000000018,
	   0.00000001221,    -0.00000000294,
	   0.00000000528,     0.00000000186,
	   0.00000000226,    -0.00000000238,
	   0.00000000016,     0.00000000010,
	  -0.00000000010,    -0.00000000003,
	  -0.00000000003,     0.00000000010,
	  -0.00000000018,     0.00000000032,
	  -0.00000000003,     0.00000000012,
	   0.00000000011,     0.00000000003,
	   0.00000000020,     0.00000000005,
	   0.00000000005,     0.00000000000,
	   0.00000000000,    -0.00000000005,
	   0.00000000004,     0.00000000007,
	   0.00000000070,     0.00000000041,
	  -0.00000000005,     0.00000000006,
	   0.00000000421,    -0.00000000815,
	   0.00000000081,     0.00000000065,
	   0.00000001241,    -0.00000000892,
	   0.00000000057,     0.00000000089,
	   0.00000000838,     0.00000001262,
	  -0.00000000087,     0.00000000049,
	   0.00000000069,    -0.00000000415,
	   0.00000000005,     0.00000000010,
	   0.00000000468,     0.00000000042,
	  -0.00000000009,     0.00000000010,
	  -0.00000000021,     0.00000000043,
	  -0.00000000046,     0.00000000041,
	  -0.00000000040,    -0.00000000046,
	   0.00000000001,    -0.00000000011,
	   0.00000000002,     0.00000000000,
	  -0.00000000156,    -0.00000000006,
	   0.00000000006,    -0.00000000021,
	  -0.00000000245,    -0.00000000153,
	   0.00000000018,    -0.00000000023,
	   0.00000000160,    -0.00000000239,
	   0.00000000022,     0.00000000019,
	  -0.00000000082,     0.00000000014,
	   0.00000000001,    -0.00000000004,
	  -0.00000000023,    -0.00000000089,
	   0.00000000006,     0.00000000000,
	  -0.00000000032,    -0.00000000098,
	  -0.00000000002,     0.00000000000,
	   0.00000000011,     0.00000000026,
	  -0.00000000005,     0.00000000001,
	  -0.00000000009,     0.00000000055,
	  -0.00000000007,    -0.00000000002,
	  -0.00000000054,    -0.00000000011,
	   0.00000000003,    -0.00000000007,
	   0.00000000008,     0.00000000015,
	  -0.00000000016,     0.00000000010,
	   0.00000000004,    -0.00000000004,
	   0.00000000011,    -0.00000000002,
	   0.00000000002,     0.00000000011,
	   0.00000000003,     0.00000000002,
	   0.00000000002,     0.00000000005,
	  -0.00000000003,    -0.00000000004,
	  -0.00000000004,     0.00000000003,
	   0.00000000016,    -0.00000000016,
	   0.00000000003,    -0.00000000005,
	  -0.00000000005,    -0.00000000003,
	   0.00000000005,     0.00000000000,
	   0.00000000001,     0.00000000001,
	   0.00000037671,    -0.00000029029,
	   0.00000007389,     0.00000010232,
	   0.00000000021,    -0.00000000019,
	  -0.00000000020,    -0.00000000021,
	  -0.00000003026,     0.00000002275,
	  -0.00000000612,    -0.00000000742,
	   0.00000013396,    -0.00000010090,
	   0.00000002593,     0.00000003165,
	   0.00000000008,     0.00000000001,
	   0.00000000003,     0.00000000002,
	   0.00000000004,     0.00000000003,
	   0.00000000016,     0.00000000004,
	   0.00000000004,    -0.00000000016,
	   0.00000000005,     0.00000000001,
	   0.00000000004,    -0.00000000030,
	  -0.00000000023,    -0.00000000153,
	  -0.00000000012,    -0.00000000001,
	  -0.00000000154,     0.00000000023,
	  -0.00000000001,     0.00000000012,
	   0.00000000003,    -0.00000000015,
	  -0.00000000017,    -0.00000000006,
	  -0.00000000010,    -0.00000000073,
	  -0.00000000005,     0.00000000000,
	   0.00000000457,    -0.00000000010,
	   0.00000000012,    -0.00000000039,
	  -0.00000001699,     0.00000000989,
	   0.00000000042,     0.00000000124,
	   0.00000001001,     0.00000001720,
	   0.00000000128,    -0.00000000042,
	  -0.00000000166,     0.00000000028,
	   0.00000000005,     0.00000000207,
	   0.00000000001,     0.00000000005,
	   0.00000000136,    -0.00000000078,
	  -0.00000000078,    -0.00000000138,
	   0.00000002569,    -0.00000001468,
	  -0.00000000060,    -0.00000000180,
	  -0.00000000008,    -0.00000000003,
	  -0.00000171761,    -0.00000297696,
	  -0.00000020815,     0.00000007247,
	  -0.00000000284,     0.00000000933,
	  -0.00000047216,    -0.00000037766,
	  -0.00000002269,     0.00000001739,
	  -0.00000000007,     0.00000000093,
	  -0.00000038482,     0.00000047909,
	   0.00000001759,     0.00000002397,
	   0.00000000098,     0.00000000008,
	  -0.00000002101,    -0.00000003442,
	   0.00000000055,    -0.00000000091,
	   0.00000000001,     0.00000000004,
	  -0.00000004920,     0.00000001886,
	  -0.00000000122,    -0.00000000015,
	  -0.00000000902,     0.00000000516,
	   0.00000000021,     0.00000000063,
	   0.00000005863,     0.00000010166,
	   0.00000000733,    -0.00000000238,
	   0.00000003610,     0.00000003135,
	   0.00000000185,    -0.00000000104,
	   0.00000003208,    -0.00000003629,
	  -0.00000000105,    -0.00000000191,
	   0.00000000051,     0.00000000128,
	   0.00000000142,    -0.00000000047,
	  -0.00000002090,    -0.00000001846,
	  -0.00000000118,     0.00000000069,
	  -0.00000000001,     0.00000000005,
	  -0.00000039197,     0.00000046999,
	   0.00000001701,     0.00000002406,
	   0.00000000110,     0.00000000007,
	  -0.00000012312,     0.00000037424,
	   0.00000000836,     0.00000000583,
	   0.00000000018,     0.00000000004,
	   0.00000038180,     0.00000012845,
	   0.00000000677,    -0.00000000874,
	   0.00000000001,    -0.00000000020,
	  -0.00000000936,     0.00000001288,
	  -0.00000000068,    -0.00000000053,
	   0.00000001496,     0.00000001958,
	  -0.00000000044,     0.00000000083,
	   0.00000000525,     0.00000000498,
	   0.00000000032,    -0.00000000013,
	   0.00000001330,    -0.00000001591,
	  -0.00000000049,    -0.00000000076,
	   0.00000000728,    -0.00000004191,
	  -0.00000000118,    -0.00000000003,
	  -0.00000004223,    -0.00000000771,
	  -0.00000000006,     0.00000000119,
	   0.00000000045,    -0.00000000033,
	  -0.00000000034,    -0.00000000054,
	   0.00000000002,    -0.00000000016,
	  -0.00000002929,     0.00000012451,
	   0.00000000338,     0.00000000092,
	   0.00000000002,    -0.00000000004,
	   0.00000155661,     0.00000037045,
	   0.00000001172,    -0.00000004206,
	  -0.00000000050,    -0.00000000023,
	   0.00000077060,    -0.00000000470,
	  -0.00000000113,     0.00000000109,
	   0.00000000006,    -0.00000000002,
	   0.00000000788,    -0.00000081360,
	  -0.00000000146,    -0.00000000051,
	  -0.00000000538,    -0.00000000701,
	  -0.00000000002,     0.00000000037,
	   0.00000001609,    -0.00000000928,
	   0.00000000077,     0.00000000023,
	   0.00000000226,    -0.00000003441,
	  -0.00000000117,     0.00000000033,
	  -0.00000004831,    -0.00000001230,
	  -0.00000000052,     0.00000000133,
	   0.00000018697,     0.00000000024,
	  -0.00000000051,    -0.00000018586,
	   0.00000000034,    -0.00000000030,
	  -0.00000000050,    -0.00000000025,
	   0.00000000036,    -0.00000000063,
	  -0.00000000013,    -0.00000000009,
	   0.00000003048,     0.00000000041,
	  -0.00000000003,     0.00000000000,
	   0.00000000379,    -0.00000040772,
	   0.00000000001,     0.00000000035,
	  -0.00000000098,    -0.00000003461,
	   0.00000000037,     0.00000000009,
	  -0.00000001177,     0.00000001064,
	   0.00000000041,    -0.00000000077,
	  -0.00000000121,     0.00000000965,
	  -0.00000000016,    -0.00000000034,
	   0.00000000054,    -0.00000001177,
	   0.00000000003,    -0.00000000074,
	   0.00000064299,    -0.00000000002,
	  -0.00000000013,     0.00000047031,
	   0.00000000137,    -0.00000000529,
	   0.00000000050,    -0.00000000132,
	   0.00000000657,     0.00000000701,
	   0.00000000030,    -0.00000000021,
	   0.00000000725,    -0.00000000619,
	  -0.00000000022,    -0.00000000027,
	  -0.00000000047,     0.00000000244,
	   0.00000000027,     0.00000000001,
	  -0.00000000001,    -0.00000000009,
	  -0.00000000006,     0.00000000001,
	   0.00000000004,    -0.00000000002,
	   0.00000000033,     0.00000000015,
	   0.00000000110,    -0.00000000287,
	   0.00000000002,     0.00000000008,
	   0.00000000424,    -0.00000000352,
	   0.00000000004,     0.00000000018,
	   0.00000000334,     0.00000000427,
	  -0.00000000017,     0.00000000004,
	   0.00000000096,    -0.00000000155,
	   0.00000000168,     0.00000000094,
	   0.00000000028,    -0.00000000029,
	   0.00000000028,     0.00000000028,
	   0.00000000000,    -0.00000000003,
	  -0.00000000037,     0.00000000004,
	  -0.00000000067,    -0.00000000027,
	   0.00000000028,    -0.00000000065,
	  -0.00000000020,     0.00000000000,
	  -0.00000000001,    -0.00000000022,
	   0.00000000002,     0.00000000004,
	   0.00000000000,     0.00000000010,
	  -0.00000000010,     0.00000000000,
	   0.00000000005,     0.00000000000,
	  -0.00000000005,     0.00000000001,
	   0.00000000001,     0.00000000005,
	  -0.00000000007,    -0.00000000022,
	  -0.00000000003,    -0.00000000005,
	  -0.00000000005,     0.00000000003,
	   0.00000000039,    -0.00000000123,
	  -0.00000000061,    -0.00000000007,
	   0.00000000000,     0.00000000013,
	  -0.00000000014,     0.00000000009,
	   0.00000000005,     0.00000000005,
	   0.00000000010,     0.00000000014,
	   0.00000000005,    -0.00000000005,
	  -0.00000000025,    -0.00000000045,
	  -0.00000000016,     0.00000000013,
	   0.00000000000,    -0.00000000018,
	  -0.00000000006,     0.00000000001,
	  -0.00000000019,     0.00000000000,
	   0.00000000001,     0.00000000006,
	   0.00000000000,    -0.00000000003,
	  -0.00000000065,    -0.00000000015,
	  -0.00000000002,     0.00000000021,
	  -0.00000000030,    -0.00000000021,
	  -0.00000000004,     0.00000000009,
	  -0.00000000022,     0.00000000031,
	   0.00000000009,     0.00000000004,
	   0.00000000025,     0.00000000036,
	   0.00000000037,    -0.00000000025,
	  -0.00000000007,    -0.00000000007,
	  -0.00000000002,     0.00000000002,
	  -0.00000000133,     0.00000000094,
	   0.00000000027,     0.00000000029,
	   0.00000000002,    -0.00000000003,
	  -0.00000000095,     0.00000000035,
	   0.00000000010,     0.00000000017,
	   0.00000000037,     0.00000000098,
	   0.00000000018,    -0.00000000011,
	  -0.00000000003,     0.00000000004,
	   0.00000000031,     0.00000000057,
	   0.00000000038,    -0.00000000026,
	   0.00000000114,     0.00000000059,
	   0.00000000058,    -0.00000000115,
	  -0.00000000035,    -0.00000000002,
	   0.00000000000,     0.00000000006,
	  -0.00000000063,     0.00000000459,
	   0.00000000079,     0.00000000002,
	  -0.00000000076,     0.00000000279,
	   0.00000000037,     0.00000000002,
	   0.00000000292,     0.00000000080,
	   0.00000000003,    -0.00000000040,
	  -0.00000000006,    -0.00000000001,
	   0.00000000002,     0.00000000011,
	   0.00000000191,     0.00000000160,
	   0.00000000036,    -0.00000000032,
	   0.00000000023,    -0.00000000126,
	   0.00000000452,     0.00000000164,
	   0.00000000038,    -0.00000000053,
	   0.00000000160,    -0.00000000451,
	  -0.00000000053,    -0.00000000037,
	  -0.00000000085,     0.00000000071,
	   0.00000000008,     0.00000000008,
	   0.00000000774,     0.00000000994,
	   0.00000000090,    -0.00000000085,
	  -0.00000000003,    -0.00000000003,
	   0.00000000481,     0.00000000593,
	   0.00000000031,    -0.00000000038,
	   0.00000000635,    -0.00000000498,
	  -0.00000000040,    -0.00000000036,
	  -0.00000000006,     0.00000000003,
	   0.00000000019,     0.00000000008,
	   0.00000001147,     0.00000000762,
	   0.00000000145,    -0.00000000142,
	  -0.00000000010,    -0.00000000013,
	  -0.00000000219,    -0.00000000239,
	   0.00000002841,     0.00000000892,
	   0.00000000113,    -0.00000000205,
	   0.00000000879,    -0.00000002827,
	  -0.00000000203,    -0.00000000110,
	  -0.00000000037,     0.00000000252,
	   0.00000000007,     0.00000000000,
	   0.00000002540,     0.00000000312,
	   0.00000000001,    -0.00000000075,
	   0.00000001485,    -0.00000000068,
	  -0.00000000009,    -0.00000001576,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000008,    -0.00000000007,
	   0.00000000019,    -0.00000000018,
	   0.00000010520,     0.00000004122,
	   0.00000000443,    -0.00000000762,
	  -0.00000000031,    -0.00000000019,
	  -0.00000001293,     0.00000001462,
	   0.00000000112,     0.00000000084,
	   0.00000019758,     0.00000000056,
	   0.00000000006,    -0.00000019665,
	   0.00000000016,     0.00000000037,
	   0.00000000036,    -0.00000000014,
	   0.00000000050,    -0.00000000017,
	  -0.00000000155,    -0.00000000626,
	  -0.00000000097,    -0.00000000045,
	   0.00000000036,     0.00000000026,
	  -0.00000000007,    -0.00000000001,
	  -0.00000000002,     0.00000000012,
	  -0.00000000001,    -0.00000000015,
	   0.00000110067,     0.00000000014,
	   0.00000000041,     0.00000060244,
	  -0.00000001530,     0.00000001368,
	  -0.00000000069,    -0.00000000225,
	   0.00000000745,     0.00000003097,
	  -0.00000000112,     0.00000000135,
	   0.00000000549,     0.00000000600,
	   0.00000000601,    -0.00000000545,
	  -0.00000000005,    -0.00000000004,
	  -0.00000000031,     0.00000000050,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000027,     0.00000000043,
	  -0.00000000041,    -0.00000000027,
	   0.00000000005,     0.00000000006,
	  -0.00000000008,     0.00000000005,
	   0.00000000371,    -0.00000000304,
	  -0.00000000276,    -0.00000000339,
	  -0.00000000610,     0.00000000241,
	  -0.00000000024,    -0.00000000043,
	  -0.00000000254,    -0.00000000616,
	   0.00000000043,    -0.00000000026,
	   0.00000000424,     0.00000000464,
	  -0.00000000463,     0.00000000422,
	   0.00000000006,     0.00000000004,
	   0.00000000014,     0.00000000002,
	  -0.00000000002,     0.00000000014,
	   0.00000000004,    -0.00000000002,
	   0.00000000002,     0.00000000004,
	   0.00000000038,    -0.00000000035,
	   0.00000000035,     0.00000000038,
	   0.00000000021,    -0.00000000020,
	   0.00000000002,    -0.00000000005,
	  -0.00000000005,    -0.00000000002,
	  -0.00000000005,    -0.00000000001,
	   0.00000000003,    -0.00000000004,
	   0.00000000004,     0.00000000003,
	   0.00000000000,     0.00000000002,
	   0.00000000016,     0.00000000001,
	   0.00000000009,     0.00000000006,
	   0.00000000006,    -0.00000000010,
	   0.00000000005,     0.00000000003,
	   0.00000000001,    -0.00000000004,
	   0.00000000001,     0.00000000023,
	   0.00000000003,     0.00000000002,
	   0.00000000196,     0.00000000020,
	   0.00000000019,    -0.00000000026,
	   0.00000000119,     0.00000000049,
	   0.00000000015,    -0.00000000011,
	   0.00000000051,    -0.00000000129,
	  -0.00000000013,    -0.00000000016,
	  -0.00000000004,     0.00000000002,
	   0.00000000005,     0.00000000003,
	  -0.00000000014,     0.00000000252,
	   0.00000000028,     0.00000000019,
	   0.00000000002,    -0.00000000001,
	   0.00000002130,     0.00000000295,
	   0.00000000181,    -0.00000000238,
	  -0.00000000010,    -0.00000000017,
	   0.00000001360,     0.00000000334,
	   0.00000000114,    -0.00000000117,
	  -0.00000000004,    -0.00000000005,
	   0.00000000359,    -0.00000001465,
	  -0.00000000130,    -0.00000000125,
	  -0.00000000009,     0.00000000005,
	  -0.00000000032,     0.00000000010,
	   0.00000000042,     0.00000000017,
	   0.00000000132,    -0.00000000073,
	  -0.00000000073,    -0.00000000132,
	  -0.00000000303,     0.00000002265,
	   0.00000000154,     0.00000000099,
	   0.00000000006,    -0.00000000005,
	   0.00000019335,     0.00000003356,
	   0.00000000899,    -0.00000001323,
	  -0.00000000045,    -0.00000000057,
	   0.00000012914,     0.00000001306,
	   0.00000000447,    -0.00000000596,
	  -0.00000000019,    -0.00000000023,
	   0.00000001591,    -0.00000013842,
	  -0.00000000678,    -0.00000000515,
	  -0.00000000025,     0.00000000020,
	  -0.00000000152,    -0.00000000007,
	  -0.00000000010,    -0.00000000003,
	   0.00000000284,     0.00000000005,
	   0.00000000000,    -0.00000000006,
	   0.00000001517,    -0.00000000836,
	   0.00000002208,    -0.00000000570,
	   0.00000000040,    -0.00000000084,
	  -0.00000000569,    -0.00000002207,
	  -0.00000000084,    -0.00000000040,
	   0.00000000021,    -0.00000000004,
	   0.00000000003,    -0.00000000002,
	  -0.00000000002,    -0.00000000003,
	  -0.00000000003,     0.00000000004,
	  -0.00000002952,     0.00000013854,
	   0.00000000386,     0.00000000084,
	   0.00000000002,    -0.00000000005,
	   0.00000119357,     0.00000024982,
	   0.00000000707,    -0.00000003341,
	  -0.00000000037,    -0.00000000017,
	   0.00000083538,    -0.00000001560,
	  -0.00000000131,     0.00000000143,
	   0.00000000007,    -0.00000000006,
	   0.00000000607,    -0.00000089213,
	  -0.00000000165,    -0.00000000048,
	  -0.00000000010,     0.00000000003,
	  -0.00000000189,    -0.00000000677,
	  -0.00000000010,     0.00000000014,
	   0.00000001143,    -0.00000000787,
	   0.00000000016,     0.00000000007,
	   0.00000030149,    -0.00000007751,
	   0.00000000710,    -0.00000001386,
	   0.00000000509,     0.00000002005,
	   0.00000000076,     0.00000000037,
	   0.00000030723,    -0.00000000042,
	  -0.00000000024,    -0.00000030691,
	   0.00000002845,    -0.00000000732,
	   0.00000000038,     0.00000000048,
	   0.00000000005,    -0.00000000008,
	   0.00000000000,     0.00000000003,
	   0.00000000022,     0.00000000000,
	  -0.00000000001,    -0.00000000007,
	   0.00000000014,     0.00000000001,
	   0.00000000001,    -0.00000000016,
	  -0.00000000005,     0.00000000000,
	   0.00000000001,    -0.00000000002,
	  -0.00000000017,    -0.00000000007,
	  -0.00000000011,    -0.00000000004,
	  -0.00000000004,     0.00000000011,
	   0.00000000011,     0.00000000008,
	   0.00000000008,     0.00000000004,
	   0.00000000005,    -0.00000000008,
	   0.00000000960,    -0.00000000510,
	   0.00000000003,    -0.00000000014,
	  -0.00000004360,    -0.00000011071,
	  -0.00000000122,    -0.00000000020,
	  -0.00000003339,    -0.00000000905,
	  -0.00000000070,    -0.00000000029,
	   0.00000000005,    -0.00000000001,
	  -0.00000000964,     0.00000000941,
	  -0.00000000152,    -0.00000000006,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000057,     0.00000000247,
	  -0.00000000115,    -0.00000000333,
	  -0.00000000009,    -0.00000000007,
	   0.00000629494,    -0.00000000680,
	   0.00000000094,     0.00000117441,
	  -0.00000001423,    -0.00000000720,
	  -0.00000000026,    -0.00000000108,
	  -0.00000000356,     0.00000002845,
	  -0.00000000054,     0.00000000053,
	   0.00000001300,     0.00000001037,
	   0.00000001036,    -0.00000001298,
	   0.00000007193,     0.00000000167,
	   0.00000026441,    -0.00000000015,
	   0.00000062162,    -0.00000000092,
	  -0.00000000017,     0.00000000001,
	  -0.00000000005,    -0.00000000001,
	   0.00000000033,     0.00000000036,
	   0.00000000001,     0.00000000020,
	   0.00000000006,    -0.00000000001,
	   0.00000000167,     0.00000000003,
	  -0.00000000003,    -0.00000000057,
	   0.00000000109,    -0.00000000006,
	  -0.00000000004,    -0.00000000036,
	  -0.00000000004,    -0.00000000118,
	  -0.00000000039,     0.00000000003,
	   0.00000000002,    -0.00000000007,
	  -0.00000000062,    -0.00000000022,
	  -0.00000000005,     0.00000000004,
	  -0.00000000046,    -0.00000000006,
	  -0.00000000003,     0.00000000003,
	  -0.00000000009,     0.00000000049,
	   0.00000000003,     0.00000000003,
	  -0.00000000001,     0.00000000002,
	   0.00000000019,     0.00000000006,
	   0.00000000013,     0.00000000002,
	   0.00000000002,    -0.00000000014,
	   0.00000000120,     0.00000000000,
	   0.00000000000,    -0.00000000120,
	   0.00000000137,    -0.00000000001,
	  -0.00000000001,     0.00000000134,
	   0.00000000179,    -0.00000000001,
	  -0.00000000001,    -0.00000000179,
	   0.00000000192,    -0.00000000002,
	  -0.00000000002,     0.00000000189,
	  -0.00000000006,     0.00000000000,
	   0.00000000001,     0.00000000004,
	  -0.00000000007,     0.00000000080,
	   0.00000000025,    -0.00000000001,
	   0.00000000692,     0.00000000054,
	  -0.00000000010,    -0.00000000220,
	   0.00000000470,    -0.00000000072,
	  -0.00000000040,    -0.00000000134,
	  -0.00000000064,    -0.00000000504,
	  -0.00000000144,     0.00000000039,
	   0.00000000005,    -0.00000000005,
	   0.00000000156,    -0.00000000025,
	  -0.00000000025,    -0.00000000156,
	   0.00000000000,    -0.00000000015,
	  -0.00000000003,     0.00000000001,
	  -0.00000000127,     0.00000000002,
	   0.00000000012,     0.00000000026,
	  -0.00000000072,     0.00000000020,
	   0.00000000011,     0.00000000011,
	   0.00000000019,     0.00000000078,
	   0.00000000013,    -0.00000000011,
	  -0.00000000253,     0.00000000028,
	   0.00000000028,     0.00000000253,
	   0.00000000121,     0.00000000016,
	  -0.00000000005,    -0.00000000017,
	   0.00000000125,    -0.00000001015,
	  -0.00000000141,     0.00000000046,
	   0.00000000003,     0.00000000005,
	  -0.00000000088,    -0.00000000650,
	  -0.00000000067,     0.00000000054,
	   0.00000000003,     0.00000000003,
	  -0.00000000700,     0.00000000072,
	   0.00000000054,     0.00000000076,
	   0.00000000003,    -0.00000000003,
	  -0.00000000010,     0.00000000003,
	  -0.00000000003,    -0.00000000006,
	  -0.00000005431,     0.00000000611,
	   0.00000000785,     0.00000000986,
	  -0.00000000190,    -0.00000003401,
	  -0.00000000321,     0.00000000225,
	  -0.00000003404,     0.00000000190,
	   0.00000000226,     0.00000000321,
	  -0.00000000143,     0.00000000649,
	   0.00000000016,     0.00000000005,
	   0.00000005517,     0.00000001223,
	   0.00000000044,    -0.00000000149,
	   0.00000003928,    -0.00000000070,
	  -0.00000000001,     0.00000000006,
	   0.00000000036,    -0.00000004183,
	  -0.00000000005,    -0.00000000007,
	  -0.00000000001,    -0.00000000035,
	   0.00000000060,    -0.00000000024,
	  -0.00000005015,    -0.00000086743,
	  -0.00000008186,     0.00000005805,
	   0.00000003288,    -0.00000000181,
	  -0.00000000220,    -0.00000000310,
	   0.00000040548,    -0.00000000094,
	  -0.00000000101,    -0.00000040611,
	   0.00000000030,     0.00000000008,
	   0.00000000071,    -0.00000000326,
	   0.00000000010,     0.00000000003,
	   0.00000000008,    -0.00000000055,
	   0.00000000014,     0.00000000002,
	  -0.00000000195,     0.00000000001,
	   0.00000000010,    -0.00000000003,
	   0.00000000001,     0.00000000005,
	  -0.00000000002,    -0.00000000006,
	   0.00001549886,    -0.00000003717,
	   0.00000000287,     0.00000160007,
	   0.00000000120,    -0.00000004488,
	   0.00000000212,     0.00000000299,
	  -0.00000002240,    -0.00000000240,
	   0.00000000148,    -0.00000000424,
	   0.00000002012,     0.00000001034,
	   0.00000001035,    -0.00000002012,
	   0.00000006506,     0.00000000152,
	   0.00000014646,    -0.00000000026,
	   0.00000000239,     0.00000000059,
	   0.00000000059,    -0.00000000239,
	   0.00000000001,    -0.00000000002,
	  -0.00000000017,    -0.00000000005,
	  -0.00000000012,     0.00000000000,
	   0.00000000000,     0.00000000013,
	   0.00000010429,     0.00000002565,
	  -0.00000003949,    -0.00000000484,
	  -0.00000000483,     0.00000003947,
	   0.00000000005,     0.00000000002,
	   0.00000000001,    -0.00000000004,
	  -0.00000006311,     0.00000000182,
	  -0.00000000003,    -0.00000000131,
	  -0.00000000834,     0.00000000057,
	   0.00000000056,     0.00000000838,
	  -0.00000000003,     0.00000000012,
	   0.00000000103,     0.00000000023,
	   0.00000000073,    -0.00000000001,
	   0.00000000001,    -0.00000000078,
	  -0.00000203626,    -0.00000024696,
	   0.00000000815,     0.00000003294,
	   0.00000000479,    -0.00000003910,
	   0.00000057124,    -0.00000000012,
	  -0.00000000027,    -0.00000057065,
	  -0.00000000045,    -0.00000000058,
	  -0.00000000058,     0.00000000045,
	  -0.00000033926,     0.00000001958,
	  -0.00000000099,    -0.00000001725,
	   0.00000000004,    -0.00000000003,
	   0.00004401244,    -0.00000001497,
	   0.00000000058,     0.00000227581,
	   0.00000002633,    -0.00000000652,
	  -0.00000000329,    -0.00000005261,
	   0.00000002229,     0.00000002229,
	   0.00000000046,    -0.00000000066,
	   0.00000002227,    -0.00000002228,
	  -0.00000000066,    -0.00000000046,
	   0.00000007344,    -0.00000000610,
	   0.00000000701,    -0.00000000048,
	  -0.00000000048,    -0.00000000701,
	  -0.00000002953,    -0.00000000538,
	   0.00000000804,     0.00000000053,
	   0.00000000052,    -0.00000000803,
	   0.00000045604,    -0.00000002698,
	   0.00000000086,     0.00000001467,
	   0.00000020752,    -0.00000023191,
	  -0.00000001256,    -0.00000001132,
	   0.00000001323,    -0.00000000171,
	   0.00000000189,     0.00000001337,
	   0.00000002216,     0.00000002216,
	   0.00000000045,    -0.00000000066,
	  -0.00000002215,     0.00000002215,
	   0.00000000066,     0.00000000046,
	  -0.00000000691,    -0.00000000045,
	  -0.00000000045,     0.00000000691,
	  -0.00000042001,    -0.00000002325,
	   0.00000000080,    -0.00000001433,
	   0.00000000001,     0.00000000545,
	  -0.00000000001,    -0.00000000185,
	   0.00000000252,    -0.00000000296,
	   0.00000000295,     0.00000000252,
	  -0.00000000057,    -0.00000000045,
	   0.00000000044,    -0.00000000057,
	   0.00000000643,    -0.00000000721,
	  -0.00000000721,    -0.00000000643,
	  -0.00000000001,     0.00000000004,
	   0.00000000032,     0.00000000007,
	   0.00000000022,     0.00000000000,
	   0.00000000000,    -0.00000000024,
	   0.00000032094,     0.00000001807,
	  -0.00000000096,     0.00000001693,
	   0.00000000203,    -0.00000000004,
	   0.00000000000,    -0.00000000221,
	   0.00000051623,    -0.00000057823,
	   0.00000000715,     0.00000000639,
	   0.00000071582,    -0.00000000134,
	  -0.00000000132,    -0.00000071582,
	   0.00008622130,    -0.00000016016,
	   0.00000000396,     0.00000285067,
	  -0.00000000429,    -0.00000000954,
	  -0.00000000475,     0.00000000858,
	   0.00000003660,     0.00000002421,
	   0.00000000048,    -0.00000000092,
	   0.00000002421,    -0.00000003659,
	  -0.00000000092,    -0.00000000048,
	   0.00000030410,    -0.00000049951,
	  -0.00000000234,     0.00000002902,
	  -0.00000001693,    -0.00000001141,
	   0.00000000093,     0.00000000009,
	  -0.00000000210,    -0.00000000231,
	   0.00000000231,    -0.00000000215,
	   0.00000003648,     0.00000002414,
	   0.00000000048,    -0.00000000092,
	  -0.00000002413,     0.00000003649,
	   0.00000000092,     0.00000000048,
	   0.00000000252,    -0.00000000414,
	   0.00000000414,     0.00000000252,
	   0.00000001056,    -0.00000000122,
	   0.00000000037,     0.00000000045,
	   0.00000001114,    -0.00000001622,
	   0.00000000014,    -0.00000000061,
	  -0.00000000850,    -0.00000004045,
	   0.00000000101,    -0.00000000010,
	   0.00000004223,    -0.00000001012,
	   0.00000000030,     0.00000000116,
	   0.00000001901,     0.00000001328,
	   0.00000000010,    -0.00000000050,
	  -0.00000001310,     0.00000001949,
	   0.00000000047,     0.00000000009,
	  -0.00000000075,     0.00000000063,
	   0.00000001482,     0.00000006566,
	  -0.00000000168,     0.00000000046,
	  -0.00000006540,     0.00000001444,
	  -0.00000000043,    -0.00000000165,
	  -0.00000000046,    -0.00000000020,
	   0.00000000021,    -0.00000000050,
	  -0.00000000014,     0.00000000203,
	   0.00000001769,     0.00000007764,
	  -0.00000000198,     0.00000000051,
	  -0.00000007724,     0.00000001674,
	  -0.00000000051,    -0.00000000194,
	   0.00000001100,    -0.00000000813,
	   0.00000000096,     0.00000000105,
	   0.00000002165,     0.00000009568,
	  -0.00000000245,     0.00000000064,
	  -0.00000009516,     0.00000002082,
	  -0.00000000061,    -0.00000000242,
	   0.00000000020,    -0.00000000033,
	   0.00000001317,     0.00000000048,
	   0.00000000034,     0.00000000076,
	   0.00000004040,     0.00000017690,
	  -0.00000000453,     0.00000000118,
	  -0.00000017630,     0.00000003859,
	  -0.00000000114,    -0.00000000445,
	   0.00000000351,     0.00000002019,
	  -0.00000000271,    -0.00000000081,
	   0.00000005490,     0.00000023938,
	  -0.00000000616,     0.00000000171,
	  -0.00000023907,     0.00000005277,
	  -0.00000000162,    -0.00000000599,
	  -0.00000002272,     0.00000000797,
	  -0.00000000022,    -0.00000000094,
	   0.00000007752,     0.00000034045,
	  -0.00000000872,     0.00000000231,
	  -0.00000033886,     0.00000007388,
	  -0.00000000223,    -0.00000000854,
	  -0.00000000048,     0.00000000074,
	   0.00000000480,     0.00000000344,
	   0.00000009775,     0.00000042547,
	  -0.00000001183,     0.00000000311,
	  -0.00000042480,     0.00000009310,
	  -0.00000000299,    -0.00000001157,
	   0.00000000005,     0.00000000000,
	  -0.00000000003,    -0.00000000004,
	  -0.00000000012,    -0.00000000006,
	  -0.00000000007,     0.00000000012,
	   0.00000000003,     0.00000000000,
	   0.00000000134,    -0.00000000840,
	  -0.00000000062,     0.00000000006,
	   0.00000000001,    -0.00000000004,
	  -0.00000000007,    -0.00000000001,
	  -0.00000000007,     0.00000000069,
	  -0.00000000003,    -0.00000000001,
	  -0.00000000013,     0.00000000022,
	   0.00000000005,     0.00000000003,
	  -0.00000000012,     0.00000000066,
	   0.00000000012,     0.00000000002,
	   0.00000000067,     0.00000000012,
	   0.00000000002,    -0.00000000013,
	  -0.00000000005,     0.00000000003,
	   0.00000000003,     0.00000000007,
	  -0.00000000002,     0.00000000003,
	   0.00000000012,    -0.00000000001,
	  -0.00000000005,     0.00000000000,
	   0.00000000000,     0.00000000006,
	  -0.00000000003,     0.00000000018,
	   0.00000000003,     0.00000000001,
	   0.00000000112,     0.00000000023,
	   0.00000000004,    -0.00000000021,
	   0.00000000339,    -0.00000000046,
	  -0.00000000007,    -0.00000000053,
	  -0.00000000046,    -0.00000000347,
	  -0.00000000055,     0.00000000006,
	   0.00000000020,     0.00000000017,
	   0.00000000025,    -0.00000000022,
	  -0.00000000003,    -0.00000000003,
	   0.00000000006,     0.00000000003,
	   0.00000000004,    -0.00000000006,
	  -0.00000000006,     0.00000000009,
	   0.00000000001,    -0.00000000005,
	  -0.00000000006,    -0.00000000002,
	  -0.00000000001,     0.00000000003,
	   0.00000000166,     0.00000000076,
	  -0.00000000005,     0.00000000001,
	   0.00000000012,     0.00000000002,
	   0.00000000003,    -0.00000000013,
	   0.00000000003,     0.00000000003,
	   0.00000000011,     0.00000000003,
	   0.00000000120,    -0.00000000015,
	  -0.00000000002,    -0.00000000019,
	  -0.00000000054,    -0.00000000412,
	  -0.00000000069,     0.00000000010,
	  -0.00000000814,    -0.00000001711,
	  -0.00000000228,     0.00000000103,
	   0.00000000006,     0.00000000013,
	  -0.00000001767,     0.00000000822,
	   0.00000000104,     0.00000000238,
	   0.00000000014,    -0.00000000006,
	   0.00000000046,    -0.00000000111,
	  -0.00000000009,    -0.00000000001,
	  -0.00000000138,    -0.00000000088,
	  -0.00000000006,     0.00000000014,
	  -0.00000000039,     0.00000000005,
	   0.00000000068,     0.00000000146,
	   0.00000000151,    -0.00000000068,
	   0.00000000008,     0.00000000009,
	  -0.00000000009,    -0.00000000005,
	  -0.00000000006,     0.00000000009,
	   0.00000000037,     0.00000000024,
	   0.00000000001,    -0.00000000002,
	  -0.00000005038,     0.00000007774,
	   0.00000000439,     0.00000000283,
	   0.00000000079,    -0.00000000268,
	  -0.00000000007,     0.00000000000,
	  -0.00000000283,    -0.00000000092,
	  -0.00000000001,     0.00000000009,
	   0.00000000004,    -0.00000000002,
	   0.00000000000,    -0.00000000016,
	   0.00000000396,    -0.00000000609,
	  -0.00000000038,    -0.00000000024,
	  -0.00000000102,     0.00000000157,
	   0.00000000030,     0.00000000009,
	   0.00000000007,     0.00000000000,
	   0.00000000000,    -0.00000000008,
	   0.00000000001,    -0.00000000010,
	   0.00000000014,    -0.00000000003,
	  -0.00000000458,    -0.00000000991,
	  -0.00000000133,     0.00000000059,
	   0.00000000003,     0.00000000007,
	   0.00000003528,    -0.00000001557,
	  -0.00000000196,    -0.00000000479,
	  -0.00000000029,     0.00000000011,
	  -0.00000009998,     0.00000009204,
	   0.00000000870,     0.00000001003,
	   0.00000000041,    -0.00000000037,
	   0.00000009397,     0.00000010458,
	   0.00000001075,    -0.00000000893,
	  -0.00000000038,    -0.00000000046,
	  -0.00000000671,    -0.00000000061,
	   0.00000000013,     0.00000000028,
	  -0.00000000300,     0.00000000945,
	   0.00000000067,     0.00000000012,
	   0.00000000128,     0.00000000276,
	   0.00000000035,    -0.00000000015,
	  -0.00000000146,     0.00000000064,
	   0.00000000863,    -0.00000000789,
	  -0.00000000070,    -0.00000000081,
	  -0.00000000798,    -0.00000000906,
	  -0.00000000088,     0.00000000071,
	   0.00000000016,    -0.00000000043,
	   0.00000000007,     0.00000000004,
	   0.00000000139,    -0.00000000230,
	  -0.00000000010,    -0.00000000003,
	   0.00000000011,    -0.00000000045,
	  -0.00000000048,    -0.00000000013,
	  -0.00000000002,     0.00000000005,
	   0.00000000078,     0.00000000023,
	   0.00000000021,     0.00000000000,
	   0.00000000001,    -0.00000000021,
	   0.00000000000,    -0.00000000014,
	  -0.00000000002,     0.00000000004,
	  -0.00000000002,     0.00000000000,
	   0.00000000056,     0.00000000202,
	  -0.00000000006,     0.00000000002,
	   0.00000000007,     0.00000000009,
	   0.00000000009,    -0.00000000008,
	   0.00000027093,    -0.00000024393,
	  -0.00000002331,    -0.00000002755,
	  -0.00000000116,     0.00000000100,
	  -0.00002382689,    -0.00002642046,
	  -0.00000268486,     0.00000227661,
	   0.00000009746,     0.00000011260,
	  -0.00000290473,    -0.00000171580,
	  -0.00000011708,     0.00000018101,
	   0.00000000524,     0.00000000296,
	  -0.00000185004,     0.00000300434,
	   0.00000019125,     0.00000013414,
	   0.00000000395,    -0.00000000576,
	  -0.00000002399,    -0.00000011183,
	   0.00000000027,     0.00000000287,
	  -0.00000000010,    -0.00000000006,
	  -0.00000019945,    -0.00000001680,
	   0.00000000070,     0.00000000794,
	   0.00000000021,     0.00000000019,
	  -0.00000006279,     0.00000005653,
	   0.00000000540,     0.00000000638,
	   0.00000000027,    -0.00000000023,
	   0.00000118533,     0.00000131440,
	   0.00000013357,    -0.00000011325,
	  -0.00000000485,    -0.00000000560,
	   0.00000025416,     0.00000015119,
	   0.00000001030,    -0.00000001592,
	  -0.00000000046,    -0.00000000026,
	   0.00000016221,    -0.00000026022,
	  -0.00000001666,    -0.00000001172,
	  -0.00000000034,     0.00000000050,
	  -0.00000000028,     0.00000000683,
	   0.00000000896,     0.00000000153,
	   0.00000000001,    -0.00000000005,
	  -0.00000000056,    -0.00000000015,
	  -0.00000000013,     0.00000000001,
	   0.00000000000,     0.00000000015,
	   0.00000000005,     0.00000000000,
	   0.00000000002,    -0.00000000044,
	   0.00000002285,     0.00000000789,
	   0.00000000207,    -0.00000000371,
	   0.00000000015,     0.00000000002,
	   0.00000000002,    -0.00000000016,
	  -0.00000000117,    -0.00000000046,
	  -0.00000000001,     0.00000000001,
	   0.00000000258,     0.00000000125,
	   0.00000000020,    -0.00000000022,
	   0.00000000013,     0.00000000001,
	   0.00000000002,    -0.00000000014,
	   0.00000000019,     0.00000000009,
	   0.00000000010,    -0.00000000010,
	  -0.00000011573,    -0.00000007038,
	  -0.00000000495,     0.00000000733,
	   0.00000000022,     0.00000000014,
	  -0.00000099815,     0.00000165967,
	   0.00000010447,     0.00000006980,
	   0.00000000188,    -0.00000000304,
	  -0.00000020001,     0.00000079557,
	   0.00000002368,     0.00000000692,
	   0.00000000002,    -0.00000000035,
	   0.00000084438,     0.00000024070,
	   0.00000001092,    -0.00000002765,
	  -0.00000000051,    -0.00000000017,
	  -0.00000001045,     0.00000000669,
	   0.00000000001,    -0.00000000084,
	   0.00000000204,     0.00000003749,
	   0.00000000068,    -0.00000000016,
	   0.00000000004,    -0.00000000002,
	   0.00000002146,     0.00000001305,
	   0.00000000092,    -0.00000000136,
	   0.00000004934,    -0.00000008205,
	  -0.00000000516,    -0.00000000345,
	   0.00000001838,    -0.00000007146,
	  -0.00000000201,    -0.00000000064,
	  -0.00000007424,    -0.00000002114,
	  -0.00000000089,     0.00000000225,
	   0.00000000103,    -0.00000000003,
	   0.00000000016,    -0.00000000167,
	   0.00000000040,    -0.00000000024,
	  -0.00000000002,    -0.00000000005,
	  -0.00000000006,     0.00000000005,
	   0.00000000005,     0.00000000006,
	  -0.00000000008,    -0.00000000009,
	  -0.00000000003,    -0.00000000002,
	  -0.00000000002,     0.00000000003,
	  -0.00000000004,     0.00000000000,
	   0.00000000000,     0.00000000033,
	   0.00000000008,    -0.00000000037,
	  -0.00000000005,    -0.00000000001,
	  -0.00000006169,     0.00000022782,
	   0.00000000716,     0.00000000249,
	   0.00000000002,    -0.00000000012,
	   0.00000204097,     0.00000054296,
	   0.00000002183,    -0.00000006329,
	  -0.00000000104,    -0.00000000021,
	   0.00000066978,    -0.00000003128,
	  -0.00000000175,     0.00000000324,
	   0.00000000009,     0.00000000008,
	   0.00000002150,    -0.00000077593,
	  -0.00000000271,    -0.00000000182,
	  -0.00000000003,     0.00000000011,
	  -0.00000000354,    -0.00000000799,
	  -0.00000000016,     0.00000000034,
	   0.00000002648,     0.00000000134,
	  -0.00000000014,    -0.00000000055,
	   0.00000000857,    -0.00000003168,
	  -0.00000000099,    -0.00000000035,
	  -0.00000009706,    -0.00000002577,
	  -0.00000000099,     0.00000000280,
	  -0.00000006318,     0.00000000110,
	  -0.00000000163,     0.00000006816,
	   0.00000000036,    -0.00000000036,
	  -0.00000000119,    -0.00000000044,
	  -0.00000000024,     0.00000000020,
	  -0.00000000004,     0.00000000007,
	   0.00000000007,     0.00000000005,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000003,     0.00000000006,
	   0.00000037683,    -0.00000000075,
	   0.00000000005,     0.00000000002,
	  -0.00000000477,    -0.00000238782,
	   0.00000000013,    -0.00000000067,
	   0.00000000007,     0.00000000001,
	  -0.00000001090,     0.00000018615,
	   0.00000000137,     0.00000000138,
	  -0.00000000001,    -0.00000000006,
	  -0.00000005006,    -0.00000003844,
	  -0.00000000005,     0.00000000492,
	  -0.00000001092,     0.00000000693,
	   0.00000000000,    -0.00000000025,
	  -0.00000000070,    -0.00000002596,
	  -0.00000000004,     0.00000000023,
	  -0.00000003458,    -0.00000000043,
	   0.00000000036,     0.00000010540,
	   0.00000000827,     0.00000002882,
	  -0.00000000094,     0.00000000018,
	   0.00000003654,    -0.00000000642,
	   0.00000000024,     0.00000000073,
	  -0.00000000028,    -0.00000000034,
	  -0.00000000037,     0.00000000126,
	  -0.00000000002,    -0.00000000010,
	  -0.00000000002,     0.00000000001,
	   0.00000000273,     0.00000000527,
	  -0.00000000003,    -0.00000000038,
	   0.00000000012,     0.00000000012,
	   0.00000000013,    -0.00000000013,
	   0.00000000006,     0.00000000004,
	   0.00000000005,     0.00000000001,
	  -0.00000000331,    -0.00000001257,
	   0.00000000038,    -0.00000000006,
	  -0.00000009708,     0.00000002747,
	  -0.00000000069,    -0.00000000312,
	  -0.00000003591,     0.00000000332,
	  -0.00000000017,    -0.00000000022,
	   0.00000000267,    -0.00000003985,
	  -0.00000000018,     0.00000000001,
	  -0.00000000366,     0.00000000627,
	   0.00000000032,     0.00000000012,
	  -0.00000001058,    -0.00000000435,
	  -0.00000000002,     0.00000000026,
	   0.00000001724,     0.00000007675,
	  -0.00000000212,     0.00000000055,
	  -0.00000007485,     0.00000001643,
	  -0.00000000050,    -0.00000000188,
	  -0.00000000249,    -0.00000000009,
	   0.00000000007,    -0.00000000295,
	  -0.00000000006,     0.00000000070,
	   0.00000000151,     0.00000000046,
	   0.00000000002,    -0.00000000006,
	  -0.00000000003,    -0.00000000001,
	  -0.00000000026,     0.00000000022,
	  -0.00000000015,     0.00000000017,
	  -0.00000000014,    -0.00000000014,
	  -0.00000000022,     0.00000000008,
	  -0.00000000010,    -0.00000000023,
	   0.00000000006,     0.00000000003,
	   0.00000000005,     0.00000000004,
	  -0.00000000004,     0.00000000004,
	   0.00000000003,     0.00000000004,
	  -0.00000000004,     0.00000000004,
	  -0.00000000067,    -0.00000000005,
	   0.00000000031,    -0.00000000020,
	  -0.00000000111,     0.00000000019,
	   0.00000000012,    -0.00000000001,
	  -0.00000000010,     0.00000000005,
	   0.00000000005,     0.00000000010,
	   0.00000000002,     0.00000000005,
	   0.00000000003,    -0.00000000003,
	   0.00000000006,    -0.00000000003,
	  -0.00000000007,     0.00000000011,
	   0.00000000011,     0.00000000007,
	   0.00000000005,    -0.00000000007,
	  -0.00000000442,    -0.00000000299,
	  -0.00000000045,     0.00000000048,
	  -0.00000000166,    -0.00000000034,
	  -0.00000000007,     0.00000000015,
	  -0.00000000035,     0.00000000169,
	   0.00000000015,     0.00000000007,
	  -0.00000000013,    -0.00000000008,
	  -0.00000000012,     0.00000000014,
	  -0.00000000013,    -0.00000000003,
	  -0.00000000055,     0.00000000269,
	   0.00000000024,     0.00000000010,
	   0.00000000038,     0.00000000214,
	   0.00000000017,     0.00000000001,
	   0.00000000219,    -0.00000000037,
	   0.00000000002,    -0.00000000018,
	  -0.00000000003,     0.00000000016,
	   0.00000000020,     0.00000000007,
	   0.00000000007,     0.00000000047,
	   0.00000000004,     0.00000000000,
	   0.00000000679,    -0.00000000125,
	   0.00000000000,    -0.00000000060,
	   0.00000000545,    -0.00000000332,
	  -0.00000000014,    -0.00000000042,
	  -0.00000000334,    -0.00000000566,
	  -0.00000000045,     0.00000000013,
	   0.00000000039,    -0.00000000008,
	   0.00000000000,    -0.00000000054,
	  -0.00000000045,     0.00000000027,
	   0.00000000027,     0.00000000046,
	   0.00000000177,    -0.00000000103,
	  -0.00000000004,    -0.00000000014,
	  -0.00000001226,    -0.00000001973,
	  -0.00000000150,     0.00000000055,
	  -0.00000001658,    -0.00000001287,
	  -0.00000000081,     0.00000000062,
	  -0.00000001374,     0.00000001698,
	   0.00000000063,     0.00000000092,
	  -0.00000000055,    -0.00000000079,
	  -0.00000000138,     0.00000000046,
	  -0.00000000039,     0.00000000023,
	   0.00000000043,     0.00000000069,
	   0.00000000138,     0.00000000109,
	   0.00000000113,    -0.00000000139,
	  -0.00000000725,    -0.00000000583,
	  -0.00000000038,     0.00000000026,
	  -0.00000005085,     0.00000006646,
	   0.00000000258,     0.00000000318,
	   0.00000000013,     0.00000000000,
	  -0.00000001913,     0.00000006084,
	   0.00000000135,     0.00000000087,
	   0.00000006393,     0.00000002251,
	   0.00000000123,    -0.00000000151,
	  -0.00000000064,     0.00000000132,
	  -0.00000000008,    -0.00000000007,
	   0.00000000172,     0.00000000274,
	  -0.00000000005,     0.00000000011,
	   0.00000000127,     0.00000000102,
	   0.00000000172,    -0.00000000224,
	   0.00000000168,    -0.00000000523,
	  -0.00000000532,    -0.00000000180,
	  -0.00000001266,     0.00000003785,
	   0.00000000085,     0.00000000065,
	   0.00000000002,     0.00000000000,
	   0.00000026961,     0.00000008558,
	   0.00000000414,    -0.00000000630,
	   0.00000000002,    -0.00000000011,
	   0.00000013325,    -0.00000000615,
	  -0.00000000067,     0.00000000032,
	   0.00000000500,    -0.00000015164,
	  -0.00000000051,    -0.00000000026,
	  -0.00000000172,    -0.00000000218,
	   0.00000000356,    -0.00000000143,
	   0.00000000016,     0.00000000004,
	   0.00000000164,    -0.00000000502,
	  -0.00000000867,    -0.00000000275,
	  -0.00000001112,    -0.00000000029,
	  -0.00000000058,     0.00000001155,
	   0.00000012974,     0.00000000022,
	  -0.00000000006,    -0.00000000003,
	   0.00000000128,    -0.00000070309,
	  -0.00000000016,     0.00000000035,
	  -0.00000000421,     0.00000007648,
	   0.00000000054,     0.00000000068,
	  -0.00000001933,    -0.00000001675,
	   0.00000000006,     0.00000000214,
	  -0.00000000366,     0.00000000557,
	  -0.00000000022,    -0.00000000019,
	  -0.00000000313,    -0.00000000587,
	   0.00000000012,    -0.00000000032,
	  -0.00000000940,    -0.00000000096,
	   0.00000000018,     0.00000002119,
	   0.00000000738,     0.00000003170,
	  -0.00000000084,     0.00000000020,
	   0.00000003311,    -0.00000000700,
	   0.00000000021,     0.00000000081,
	  -0.00000000089,    -0.00000000364,
	   0.00000000009,     0.00000000006,
	  -0.00000002246,     0.00000000604,
	   0.00000000030,    -0.00000000049,
	  -0.00000000713,     0.00000000156,
	   0.00000000010,     0.00000000006,
	   0.00000000132,    -0.00000000787,
	   0.00000000005,    -0.00000000013,
	  -0.00000000157,     0.00000000108,
	   0.00000000004,     0.00000000017,
	  -0.00000000186,    -0.00000000208,
	  -0.00000000019,     0.00000000005,
	   0.00000002580,     0.00000011594,
	  -0.00000000318,     0.00000000081,
	  -0.00000009641,     0.00000002141,
	  -0.00000000065,    -0.00000000245,
	   0.00000000008,    -0.00000000154,
	  -0.00000000100,     0.00000000144,
	   0.00000000154,     0.00000000113,
	  -0.00000000001,     0.00000000005,
	   0.00000000006,     0.00000000009,
	  -0.00000000009,     0.00000000006,
	  -0.00000000002,     0.00000000003,
	  -0.00000000003,    -0.00000000002,
	  -0.00000000035,     0.00000000134,
	   0.00000000021,    -0.00000000008,
	   0.00000000000,     0.00000000011,
	   0.00000000012,     0.00000000000,
	   0.00000000005,     0.00000000000,
	  -0.00000000001,    -0.00000000004,
	  -0.00000000006,    -0.00000000001,
	  -0.00000000005,    -0.00000000003,
	  -0.00000000003,     0.00000000005,
	  -0.00000000003,    -0.00000000002,
	  -0.00000000016,     0.00000000018,
	   0.00000000005,     0.00000000003,
	  -0.00000000018,     0.00000000007,
	   0.00000000002,     0.00000000003,
	   0.00000000008,     0.00000000019,
	   0.00000000003,    -0.00000000002,
	  -0.00000000012,     0.00000000005,
	   0.00000000001,     0.00000000002,
	   0.00000000020,     0.00000000083,
	   0.00000000015,    -0.00000000007,
	  -0.00000000016,     0.00000000051,
	   0.00000000007,     0.00000000001,
	   0.00000000058,     0.00000000013,
	   0.00000000000,    -0.00000000008,
	   0.00000000006,    -0.00000000046,
	  -0.00000000047,    -0.00000000005,
	  -0.00000000011,     0.00000000045,
	   0.00000000006,     0.00000000000,
	   0.00000000260,     0.00000000097,
	   0.00000000005,    -0.00000000035,
	   0.00000000063,     0.00000000101,
	   0.00000000006,    -0.00000000003,
	   0.00000000111,    -0.00000000093,
	  -0.00000000008,    -0.00000000007,
	  -0.00000000001,    -0.00000000078,
	  -0.00000000067,    -0.00000000025,
	  -0.00000000118,    -0.00000000041,
	  -0.00000000041,     0.00000000123,
	   0.00000000091,     0.00000000112,
	   0.00000000006,    -0.00000000007,
	   0.00000000639,    -0.00000000457,
	  -0.00000000037,    -0.00000000033,
	   0.00000000142,     0.00000000048,
	   0.00000000004,     0.00000000005,
	  -0.00000000006,    -0.00000000234,
	  -0.00000000004,     0.00000000001,
	  -0.00000000005,    -0.00000000001,
	   0.00000000002,    -0.00000000006,
	  -0.00000000273,     0.00000000018,
	   0.00000000012,     0.00000000032,
	  -0.00000000165,     0.00000000102,
	  -0.00000000299,     0.00000000528,
	   0.00000000538,     0.00000000305,
	   0.00000000317,    -0.00000000007,
	  -0.00000000043,    -0.00000001574,
	  -0.00000000026,     0.00000000211,
	  -0.00000000032,    -0.00000000031,
	  -0.00000000002,     0.00000000006,
	  -0.00000000007,     0.00000000009,
	  -0.00000000007,    -0.00000000009,
	  -0.00000000736,     0.00000002054,
	   0.00000000101,     0.00000000043,
	  -0.00000000381,     0.00000000269,
	   0.00000000787,     0.00000003515,
	  -0.00000000090,     0.00000000024,
	   0.00000003530,    -0.00000000810,
	   0.00000000022,     0.00000000090,
	  -0.00000000013,     0.00000000001,
	  -0.00000000001,     0.00000000063,
	  -0.00000000004,     0.00000000002,
	  -0.00000000015,    -0.00000000010,
	   0.00000000005,    -0.00000000012,
	  -0.00000000003,    -0.00000000002,
	   0.00000004597,     0.00000020628,
	  -0.00000000569,     0.00000000145,
	  -0.00000012341,     0.00000002731,
	  -0.00000000081,    -0.00000000315,
	  -0.00000000345,    -0.00000000232,
	   0.00000000045,    -0.00000000030,
	  -0.00000000550,     0.00000000234,
	  -0.00000000037,    -0.00000000029,
	  -0.00000000090,     0.00000000127,
	   0.00000000129,     0.00000000090,
	   0.00000000062,     0.00000000040,
	   0.00000000032,    -0.00000000055,
	  -0.00000000085,    -0.00000000117,
	   0.00000000117,    -0.00000000087,
	  -0.00000000080,     0.00000000113,
	  -0.00000000112,    -0.00000000080,
	   0.00000000002,     0.00000000001,
	   0.00000000009,    -0.00000000009,
	   0.00000000012,     0.00000000006,
	   0.00000000004,    -0.00000000013,
	   0.00000000001,    -0.00000000004,
	   0.00000000030,     0.00000000011,
	   0.00000000004,    -0.00000000003,
	   0.00000000083,    -0.00000000124,
	  -0.00000000010,    -0.00000000020,
	   0.00000000113,     0.00000000045,
	   0.00000000010,    -0.00000000006,
	   0.00000000020,    -0.00000000120,
	  -0.00000000009,    -0.00000000007,
	   0.00000000335,     0.00000000074,
	   0.00000000028,    -0.00000000030,
	  -0.00000000001,    -0.00000000002,
	   0.00000000593,    -0.00000001490,
	  -0.00000000125,    -0.00000000146,
	  -0.00000000006,     0.00000000004,
	   0.00000000821,     0.00000000310,
	   0.00000000051,    -0.00000000022,
	   0.00000000032,    -0.00000000892,
	  -0.00000000049,    -0.00000000022,
	  -0.00000000017,     0.00000000007,
	   0.00000000005,    -0.00000000009,
	   0.00000003183,     0.00000000309,
	   0.00000000113,    -0.00000000151,
	  -0.00000000005,    -0.00000000006,
	   0.00000002587,    -0.00000014608,
	  -0.00000000699,    -0.00000000559,
	  -0.00000000026,     0.00000000021,
	   0.00000003694,     0.00000002150,
	   0.00000000106,     0.00000000088,
	   0.00000000004,    -0.00000000004,
	  -0.00000000451,    -0.00000004304,
	  -0.00000000040,     0.00000000063,
	  -0.00000000101,     0.00000000052,
	  -0.00000000002,     0.00000000004,
	  -0.00000000038,    -0.00000000116,
	   0.00000000202,     0.00000000401,
	   0.00000000401,    -0.00000000202,
	   0.00000020727,    -0.00000000111,
	  -0.00000000012,    -0.00000000003,
	  -0.00000000558,    -0.00000096272,
	  -0.00000000013,     0.00000000051,
	  -0.00000000008,    -0.00000000001,
	  -0.00000000758,     0.00000013893,
	   0.00000000071,     0.00000000087,
	   0.00000000002,    -0.00000000004,
	  -0.00000002716,    -0.00000002953,
	  -0.00000000023,     0.00000000387,
	  -0.00000000588,     0.00000000498,
	  -0.00000000013,    -0.00000000014,
	  -0.00000000474,    -0.00000000593,
	   0.00000000013,    -0.00000000012,
	   0.00000002799,     0.00000005534,
	  -0.00000000384,     0.00000000199,
	   0.00000001339,     0.00000005981,
	  -0.00000000152,     0.00000000038,
	   0.00000005975,    -0.00000001335,
	   0.00000000038,     0.00000000153,
	   0.00000000004,     0.00000000000,
	   0.00000000004,    -0.00000000016,
	  -0.00000000005,    -0.00000000001,
	   0.00000000009,     0.00000000002,
	  -0.00000000001,    -0.00000000009,
	  -0.00000000003,    -0.00000000001,
	  -0.00000000005,     0.00000000012,
	  -0.00000000004,    -0.00000000003,
	   0.00000000000,     0.00000000005,
	   0.00000000002,     0.00000000001,
	   0.00000000005,    -0.00000000008,
	  -0.00000000501,    -0.00000000198,
	  -0.00000000008,    -0.00000000022,
	  -0.00000000990,     0.00000002337,
	  -0.00000000101,     0.00000000037,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000133,    -0.00000000358,
	   0.00000000012,    -0.00000000009,
	   0.00000000133,    -0.00000000184,
	   0.00000000003,    -0.00000000008,
	   0.00000000026,     0.00000000056,
	   0.00000000005,     0.00000000002,
	  -0.00000000070,     0.00000000017,
	  -0.00000000002,     0.00000000005,
	   0.00000027675,     0.00000123744,
	  -0.00000003405,     0.00000000872,
	  -0.00000023439,     0.00000005235,
	  -0.00000000155,    -0.00000000596,
	   0.00000000079,    -0.00000000311,
	  -0.00000000575,     0.00000000054,
	  -0.00000000148,     0.00000000301,
	   0.00000000300,     0.00000000148,
	   0.00000000288,     0.00000001446,
	   0.00000001180,     0.00000005294,
	   0.00000002760,     0.00000012316,
	   0.00000000027,    -0.00000000002,
	  -0.00000000002,    -0.00000000009,
	   0.00000000002,    -0.00000000126,
	  -0.00000000042,     0.00000000002,
	   0.00000000031,     0.00000000012,
	   0.00000000003,    -0.00000000010,
	  -0.00000000008,    -0.00000000032,
	  -0.00000000010,     0.00000000004,
	  -0.00000000011,    -0.00000000001,
	  -0.00000000009,     0.00000000053,
	   0.00000000003,     0.00000000003,
	   0.00000000000,    -0.00000000008,
	   0.00000000001,     0.00000000004,
	   0.00000000003,     0.00000000000,
	   0.00000000001,    -0.00000000015,
	   0.00000000001,     0.00000000005,
	   0.00000000117,    -0.00000000016,
	  -0.00000000009,    -0.00000000033,
	  -0.00000000077,    -0.00000000542,
	  -0.00000000154,     0.00000000044,
	   0.00000000002,     0.00000000081,
	   0.00000000022,    -0.00000000005,
	  -0.00000000014,    -0.00000000009,
	  -0.00000000004,     0.00000000006,
	  -0.00000000003,     0.00000000003,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000018,     0.00000000005,
	   0.00000000003,     0.00000000003,
	   0.00000000024,     0.00000000078,
	   0.00000000013,    -0.00000000012,
	  -0.00000000005,    -0.00000000036,
	  -0.00000000004,     0.00000000003,
	  -0.00000000020,     0.00000000005,
	  -0.00000000019,    -0.00000000164,
	  -0.00000000017,     0.00000000013,
	  -0.00000000729,     0.00000000096,
	   0.00000000061,     0.00000000079,
	   0.00000000003,    -0.00000000003,
	   0.00000000212,    -0.00000000007,
	  -0.00000000006,    -0.00000000011,
	  -0.00000000024,    -0.00000000074,
	   0.00000000006,     0.00000000001,
	   0.00000000003,     0.00000000005,
	  -0.00000000004,     0.00000000003,
	  -0.00000000356,    -0.00000001038,
	   0.00000000659,    -0.00000000186,
	  -0.00000000186,    -0.00000000659,
	   0.00000000986,    -0.00000000004,
	  -0.00000000017,    -0.00000004552,
	  -0.00000000025,     0.00000000660,
	   0.00000000004,     0.00000000005,
	  -0.00000000134,    -0.00000000148,
	   0.00000000000,     0.00000000016,
	  -0.00000000032,     0.00000000017,
	  -0.00000000017,    -0.00000000032,
	   0.00000016864,    -0.00000004790,
	  -0.00000001365,    -0.00000000932,
	   0.00000000183,     0.00000000651,
	   0.00000001796,     0.00000007984,
	  -0.00000000202,     0.00000000061,
	   0.00000007996,    -0.00000001800,
	   0.00000000060,     0.00000000201,
	   0.00000000001,    -0.00000000030,
	   0.00000000002,     0.00000000001,
	  -0.00000000140,    -0.00000000003,
	   0.00000000007,    -0.00000000010,
	   0.00000000010,     0.00000000003,
	  -0.00000000005,    -0.00000000007,
	   0.00000068945,     0.00000306393,
	  -0.00000008415,     0.00000002288,
	  -0.00000031860,     0.00000007149,
	  -0.00000000219,    -0.00000000809,
	   0.00000000893,    -0.00000000174,
	  -0.00000000034,     0.00000000068,
	  -0.00000000051,    -0.00000000454,
	  -0.00000000117,     0.00000000443,
	   0.00000000443,     0.00000000117,
	   0.00000000652,     0.00000002907,
	  -0.00000000003,     0.00000000000,
	   0.00000000000,     0.00000000014,
	  -0.00000000054,     0.00000002157,
	  -0.00000000078,    -0.00000000802,
	  -0.00000000802,     0.00000000078,
	   0.00000000001,    -0.00000000005,
	  -0.00000000048,    -0.00000000162,
	  -0.00000000163,     0.00000000048,
	   0.00000000018,     0.00000000000,
	   0.00000000000,    -0.00000000085,
	   0.00000000000,     0.00000000012,
	  -0.00000000002,    -0.00000000003,
	  -0.00000004074,    -0.00000041392,
	   0.00000000800,    -0.00000000078,
	   0.00000002519,     0.00000011312,
	  -0.00000000287,     0.00000000076,
	   0.00000011300,    -0.00000002520,
	   0.00000000076,     0.00000000287,
	  -0.00000001881,    -0.00000006623,
	   0.00000000323,    -0.00000000095,
	   0.00000194516,     0.00000872801,
	  -0.00000023961,     0.00000006227,
	  -0.00000045227,     0.00000010075,
	  -0.00000000323,    -0.00000001245,
	   0.00000000245,     0.00000000493,
	   0.00000001028,    -0.00000000297,
	  -0.00000000345,     0.00000000540,
	   0.00000000540,     0.00000000345,
	   0.00000000040,     0.00000000137,
	   0.00000000137,    -0.00000000040,
	   0.00000000025,     0.00000000162,
	   0.00000000162,    -0.00000000025,
	   0.00000002550,     0.00000008931,
	  -0.00000000275,     0.00000000081,
	   0.00000004545,     0.00000001819,
	   0.00000000103,    -0.00000000248,
	   0.00000000092,     0.00000000255,
	  -0.00000000256,     0.00000000096,
	  -0.00000000344,     0.00000000539,
	  -0.00000000538,    -0.00000000344,
	  -0.00000000022,    -0.00000000139,
	  -0.00000000139,     0.00000000022,
	  -0.00000001393,    -0.00000008438,
	   0.00000000276,    -0.00000000043,
	  -0.00000000108,     0.00000000024,
	   0.00000000171,     0.00000000096,
	   0.00000000096,    -0.00000000171,
	   0.00000000006,     0.00000000000,
	   0.00000000000,    -0.00000000026,
	   0.00000001056,     0.00000006428,
	  -0.00000000327,     0.00000000050,
	   0.00000013759,     0.00000007697,
	  -0.00000000096,     0.00000000171,
	   0.00000003185,     0.00000014190,
	  -0.00000000361,     0.00000000095,
	   0.00000014190,    -0.00000003185,
	   0.00000000095,     0.00000000361,
	   0.00000383909,     0.00001710374,
	  -0.00000047061,     0.00000012267,
	  -0.00000056617,     0.00000012680,
	  -0.00000000406,    -0.00000001559,
	   0.00000000170,    -0.00000000127,
	  -0.00000000191,    -0.00000000057,
	  -0.00000000320,     0.00000000833,
	   0.00000000833,     0.00000000320,
	   0.00000009341,     0.00000001335,
	   0.00000000069,    -0.00000000323,
	  -0.00000000320,     0.00000000831,
	  -0.00000000831,    -0.00000000320,
	   0.00000000116,     0.00000000220,
	  -0.00000000016,     0.00000000015,
	   0.00000000203,    -0.00000000086,
	   0.00000000018,     0.00000000015,
	   0.00000000958,    -0.00000000363,
	   0.00000000029,     0.00000000050,
	   0.00000000395,     0.00000001002,
	  -0.00000000053,     0.00000000033,
	  -0.00000000092,     0.00000000165,
	  -0.00000000161,    -0.00000000096,
	  -0.00000001401,     0.00000000666,
	  -0.00000000037,    -0.00000000071,
	  -0.00000000657,    -0.00000001399,
	   0.00000000071,    -0.00000000036,
	  -0.00000000045,     0.00000000009,
	  -0.00000001647,     0.00000000782,
	  -0.00000000043,    -0.00000000083,
	  -0.00000000761,    -0.00000001645,
	   0.00000000082,    -0.00000000042,
	   0.00000000237,     0.00000000206,
	  -0.00000000024,     0.00000000033,
	  -0.00000002029,     0.00000000958,
	  -0.00000000053,    -0.00000000103,
	  -0.00000000940,    -0.00000002024,
	   0.00000000102,    -0.00000000052,
	   0.00000000055,     0.00000000297,
	  -0.00000003749,     0.00000001779,
	  -0.00000000098,    -0.00000000190,
	  -0.00000001742,    -0.00000003750,
	   0.00000000188,    -0.00000000096,
	  -0.00000000433,     0.00000000178,
	  -0.00000005072,     0.00000002413,
	  -0.00000000135,    -0.00000000257,
	  -0.00000002371,    -0.00000005082,
	   0.00000000254,    -0.00000000132,
	  -0.00000000291,    -0.00000000468,
	  -0.00000007217,     0.00000003419,
	  -0.00000000189,    -0.00000000365,
	  -0.00000003341,    -0.00000007208,
	   0.00000000362,    -0.00000000185,
	  -0.00000000053,     0.00000000124,
	  -0.00000009014,     0.00000004292,
	  -0.00000000238,    -0.00000000456,
	  -0.00000004199,    -0.00000009034,
	   0.00000000453,    -0.00000000233,
	  -0.00000000003,    -0.00000000015,
	  -0.00000000002,     0.00000000004,
	   0.00000000004,    -0.00000000004,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000063,     0.00000000183,
	   0.00000000017,     0.00000000016,
	   0.00000000004,     0.00000000001,
	   0.00000000001,    -0.00000000001,
	  -0.00000000007,    -0.00000000007,
	  -0.00000000027,    -0.00000000013,
	  -0.00000000003,     0.00000000006,
	  -0.00000000014,     0.00000000027,
	   0.00000000006,     0.00000000003,
	  -0.00000000008,    -0.00000000013,
	  -0.00000000010,    -0.00000000005,
	  -0.00000000001,     0.00000000002,
	  -0.00000000018,     0.00000000036,
	   0.00000000008,     0.00000000004,
	  -0.00000000022,     0.00000000153,
	   0.00000000029,     0.00000000004,
	   0.00000000158,     0.00000000025,
	   0.00000000005,    -0.00000000030,
	  -0.00000000009,     0.00000000006,
	   0.00000000006,     0.00000000013,
	   0.00000000008,    -0.00000000004,
	  -0.00000000005,     0.00000000004,
	   0.00000000004,     0.00000000005,
	   0.00000000001,    -0.00000000001,
	  -0.00000000077,    -0.00000000091,
	  -0.00000000005,     0.00000000005,
	  -0.00000000006,    -0.00000000004,
	  -0.00000000004,     0.00000000007,
	  -0.00000000002,     0.00000000003,
	  -0.00000000012,     0.00000000075,
	   0.00000000014,     0.00000000002,
	  -0.00000000009,    -0.00000000003,
	   0.00000000928,    -0.00000000154,
	  -0.00000000023,    -0.00000000153,
	  -0.00000000009,     0.00000000001,
	  -0.00000000145,    -0.00000000967,
	  -0.00000000162,     0.00000000020,
	   0.00000000001,     0.00000000009,
	   0.00000000044,     0.00000000035,
	   0.00000000003,    -0.00000000005,
	   0.00000000059,    -0.00000000051,
	  -0.00000000007,    -0.00000000007,
	  -0.00000000080,     0.00000000013,
	   0.00000000011,     0.00000000083,
	   0.00000000002,     0.00000000004,
	  -0.00000000320,     0.00000000153,
	   0.00000000019,     0.00000000037,
	   0.00000000024,    -0.00000000023,
	  -0.00000000024,    -0.00000000026,
	   0.00000000001,    -0.00000000001,
	  -0.00000000032,    -0.00000000038,
	  -0.00000000012,    -0.00000000007,
	  -0.00000000007,     0.00000000011,
	  -0.00000000003,     0.00000000005,
	  -0.00000000016,     0.00000000008,
	   0.00000001173,    -0.00000000177,
	  -0.00000000026,    -0.00000000196,
	  -0.00000000014,     0.00000000002,
	   0.00000003981,     0.00000026747,
	   0.00000004464,    -0.00000000580,
	  -0.00000000040,    -0.00000000318,
	  -0.00000005460,    -0.00000010873,
	  -0.00000001437,     0.00000000678,
	   0.00000000038,     0.00000000080,
	  -0.00000011505,     0.00000005485,
	   0.00000000675,     0.00000001556,
	   0.00000000090,    -0.00000000038,
	   0.00000000211,    -0.00000000554,
	  -0.00000000043,    -0.00000000002,
	  -0.00000000735,    -0.00000000496,
	  -0.00000000044,     0.00000000079,
	  -0.00000000290,     0.00000000044,
	   0.00000000006,     0.00000000045,
	  -0.00000000193,    -0.00000001294,
	  -0.00000000202,     0.00000000025,
	   0.00000000470,     0.00000000952,
	   0.00000000118,    -0.00000000054,
	   0.00000001000,    -0.00000000466,
	  -0.00000000053,    -0.00000000127,
	   0.00000000032,     0.00000000025,
	   0.00000000015,     0.00000000016,
	   0.00000000007,     0.00000000004,
	   0.00000000005,    -0.00000000007,
	  -0.00000000002,    -0.00000000001,
	  -0.00000000012,     0.00000000019,
	  -0.00000000002,     0.00000000008,
	   0.00000000008,     0.00000000003,
	   0.00000000985,     0.00000002042,
	   0.00000000274,    -0.00000000123,
	  -0.00000000007,    -0.00000000016,
	   0.00000042419,    -0.00000020631,
	  -0.00000002571,    -0.00000005671,
	  -0.00000000320,     0.00000000145,
	   0.00000013314,    -0.00000012702,
	  -0.00000001183,    -0.00000001322,
	  -0.00000000054,     0.00000000051,
	  -0.00000013074,    -0.00000014498,
	  -0.00000001510,     0.00000001229,
	   0.00000000053,     0.00000000067,
	   0.00000000678,     0.00000000039,
	  -0.00000000015,    -0.00000000024,
	   0.00000000399,    -0.00000001085,
	  -0.00000000080,    -0.00000000022,
	  -0.00000000213,    -0.00000000442,
	  -0.00000000056,     0.00000000024,
	  -0.00000002143,     0.00000001042,
	   0.00000000120,     0.00000000269,
	  -0.00000001190,     0.00000001119,
	   0.00000000097,     0.00000000112,
	   0.00000001136,     0.00000001271,
	   0.00000000124,    -0.00000000100,
	  -0.00000000038,    -0.00000000012,
	  -0.00000000022,     0.00000000048,
	   0.00000000025,     0.00000000145,
	   0.00000000021,    -0.00000000003,
	   0.00000000004,     0.00000000007,
	   0.00000000007,    -0.00000000004,
	   0.00000000001,     0.00000000001,
	   0.00000000008,    -0.00000000014,
	   0.00000000001,    -0.00000000006,
	  -0.00000000007,    -0.00000000002,
	  -0.00000000001,     0.00000000002,
	   0.00000000019,     0.00000000005,
	   0.00000000001,    -0.00000000007,
	  -0.00000000006,     0.00000000018,
	   0.00000000004,    -0.00000000003,
	   0.00000002335,    -0.00000002146,
	  -0.00000000202,    -0.00000000238,
	  -0.00000000010,     0.00000000009,
	  -0.00000023991,    -0.00000025816,
	  -0.00000002617,     0.00000002249,
	   0.00000000096,     0.00000000110,
	  -0.00000016455,    -0.00000009330,
	  -0.00000000613,     0.00000001005,
	   0.00000000029,     0.00000000014,
	  -0.00000010864,     0.00000017430,
	   0.00000001113,     0.00000000811,
	   0.00000000025,    -0.00000000035,
	  -0.00000000120,    -0.00000000427,
	   0.00000000007,     0.00000000012,
	  -0.00000000992,    -0.00000000154,
	  -0.00000000004,     0.00000000045,
	  -0.00000000433,     0.00000000398,
	   0.00000000035,     0.00000000041,
	   0.00000001207,     0.00000001298,
	   0.00000000124,    -0.00000000105,
	   0.00000001486,     0.00000000862,
	   0.00000000055,    -0.00000000085,
	   0.00000000955,    -0.00000001536,
	  -0.00000000091,    -0.00000000066,
	   0.00000000043,     0.00000000012,
	   0.00000000010,    -0.00000000001,
	   0.00000000001,    -0.00000000002,
	  -0.00000000016,    -0.00000000004,
	   0.00000000000,     0.00000000005,
	   0.00000000002,     0.00000000000,
	   0.00000000000,    -0.00000000015,
	  -0.00000005334,    -0.00000003202,
	  -0.00000000226,     0.00000000335,
	   0.00000000010,     0.00000000006,
	  -0.00000025877,     0.00000043691,
	   0.00000002722,     0.00000001814,
	   0.00000000049,    -0.00000000080,
	  -0.00000005150,     0.00000023045,
	   0.00000000638,     0.00000000127,
	  -0.00000000001,    -0.00000000008,
	   0.00000025881,     0.00000007778,
	   0.00000000387,    -0.00000000883,
	  -0.00000000018,    -0.00000000007,
	  -0.00000000101,     0.00000000141,
	  -0.00000000002,    -0.00000000024,
	  -0.00000000055,     0.00000001075,
	   0.00000000027,     0.00000000000,
	   0.00000000824,     0.00000000495,
	   0.00000000033,    -0.00000000048,
	   0.00000001273,    -0.00000002151,
	  -0.00000000124,    -0.00000000084,
	   0.00000000530,    -0.00000002164,
	  -0.00000000059,    -0.00000000017,
	  -0.00000002298,    -0.00000000665,
	  -0.00000000029,     0.00000000071,
	   0.00000000013,    -0.00000000047,
	   0.00000000000,     0.00000000007,
	  -0.00000003003,     0.00000011251,
	   0.00000000351,     0.00000000120,
	   0.00000000001,    -0.00000000006,
	   0.00000072487,     0.00000019058,
	   0.00000000760,    -0.00000002237,
	  -0.00000000037,    -0.00000000006,
	   0.00000018236,    -0.00000002347,
	  -0.00000000149,     0.00000000242,
	   0.00000000009,     0.00000000003,
	   0.00000001668,    -0.00000025709,
	  -0.00000000198,    -0.00000000123,
	  -0.00000000002,     0.00000000008,
	  -0.00000000161,    -0.00000000435,
	  -0.00000000005,     0.00000000010,
	   0.00000001028,     0.00000000140,
	  -0.00000000004,    -0.00000000026,
	   0.00000000371,    -0.00000001391,
	  -0.00000000040,    -0.00000000014,
	  -0.00000003438,    -0.00000000901,
	  -0.00000000034,     0.00000000099,
	  -0.00000001935,     0.00000000103,
	  -0.00000000063,     0.00000002231,
	  -0.00000000046,    -0.00000000023,
	   0.00000000001,    -0.00000000013,
	   0.00000014650,    -0.00000000176,
	  -0.00000000006,     0.00000000012,
	  -0.00000000750,    -0.00000076027,
	   0.00000000050,     0.00000000012,
	  -0.00000000614,     0.00000013946,
	   0.00000000067,     0.00000000125,
	  -0.00000000001,    -0.00000000005,
	  -0.00000001716,    -0.00000003260,
	  -0.00000000011,     0.00000000398,
	  -0.00000000483,     0.00000000193,
	  -0.00000000005,    -0.00000000005,
	   0.00000000055,    -0.00000001017,
	  -0.00000000007,     0.00000000005,
	  -0.00000001358,     0.00000000016,
	   0.00000000038,     0.00000003383,
	  -0.00000000034,    -0.00000000689,
	  -0.00000000206,     0.00000000154,
	  -0.00000000018,     0.00000000049,
	   0.00000001135,     0.00000005140,
	  -0.00000000140,     0.00000000042,
	  -0.00000000001,    -0.00000000002,
	   0.00000016159,    -0.00000003394,
	   0.00000000135,     0.00000000427,
	  -0.00000000006,     0.00000000003,
	   0.00000008864,     0.00000000469,
	  -0.00000000030,    -0.00000000044,
	   0.00000000470,     0.00000009955,
	  -0.00000000043,     0.00000000016,
	  -0.00000000305,     0.00000000267,
	   0.00000000023,     0.00000000004,
	  -0.00000000370,    -0.00000000318,
	  -0.00000000002,     0.00000000022,
	  -0.00000000058,    -0.00000000313,
	  -0.00000000738,     0.00000000156,
	  -0.00000000801,     0.00000000272,
	   0.00000000271,     0.00000000400,
	   0.00000000137,     0.00000000037,
	   0.00000000264,    -0.00000000496,
	  -0.00000000015,     0.00000000010,
	  -0.00000000052,    -0.00000000308,
	   0.00000000007,     0.00000000000,
	   0.00000000330,    -0.00000000061,
	   0.00000000000,     0.00000000008,
	   0.00000000408,     0.00000000197,
	  -0.00000000008,    -0.00000000010,
	  -0.00000000191,     0.00000000416,
	   0.00000000009,    -0.00000000008,
	  -0.00000001533,     0.00000000718,
	  -0.00000000043,    -0.00000000083,
	  -0.00000000834,    -0.00000001723,
	   0.00000000089,    -0.00000000046,
	  -0.00000000016,    -0.00000000048,
	   0.00000000059,    -0.00000000011,
	  -0.00000000042,    -0.00000000010,
	  -0.00000000003,    -0.00000000002,
	  -0.00000000010,    -0.00000000006,
	  -0.00000000013,    -0.00000000002,
	  -0.00000000003,     0.00000000014,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000008,     0.00000000047,
	   0.00000000004,     0.00000000002,
	   0.00000000010,     0.00000000051,
	   0.00000000053,    -0.00000000009,
	   0.00000000001,    -0.00000000005,
	   0.00000000004,     0.00000000002,
	   0.00000000004,     0.00000000021,
	   0.00000000002,     0.00000000000,
	   0.00000000190,    -0.00000000040,
	   0.00000000001,    -0.00000000016,
	   0.00000000165,    -0.00000000105,
	  -0.00000000003,    -0.00000000012,
	  -0.00000000105,    -0.00000000177,
	  -0.00000000014,     0.00000000003,
	   0.00000000009,    -0.00000000002,
	   0.00000000000,    -0.00000000014,
	   0.00000000085,    -0.00000000051,
	  -0.00000000001,    -0.00000000006,
	  -0.00000000412,    -0.00000000644,
	  -0.00000000052,     0.00000000018,
	  -0.00000000538,    -0.00000000402,
	  -0.00000000024,     0.00000000018,
	  -0.00000000456,     0.00000000557,
	   0.00000000021,     0.00000000032,
	  -0.00000000014,    -0.00000000017,
	  -0.00000000039,     0.00000000011,
	   0.00000000046,     0.00000000036,
	   0.00000000037,    -0.00000000047,
	  -0.00000000334,    -0.00000000265,
	  -0.00000000018,     0.00000000012,
	  -0.00000001685,     0.00000002227,
	   0.00000000087,     0.00000000110,
	  -0.00000000518,     0.00000001805,
	   0.00000000036,     0.00000000021,
	   0.00000001972,     0.00000000725,
	   0.00000000041,    -0.00000000049,
	  -0.00000000001,     0.00000000026,
	   0.00000000039,     0.00000000077,
	   0.00000000049,     0.00000000039,
	   0.00000000057,    -0.00000000075,
	   0.00000000051,    -0.00000000161,
	  -0.00000000165,    -0.00000000057,
	  -0.00000000490,     0.00000001478,
	   0.00000000034,     0.00000000025,
	   0.00000008160,     0.00000002591,
	   0.00000000126,    -0.00000000194,
	   0.00000003010,    -0.00000000370,
	  -0.00000000034,     0.00000000014,
	   0.00000000255,    -0.00000003967,
	  -0.00000000023,    -0.00000000010,
	  -0.00000000067,    -0.00000000082,
	   0.00000000110,    -0.00000000032,
	   0.00000000004,     0.00000000001,
	   0.00000000057,    -0.00000000173,
	  -0.00000000263,    -0.00000000083,
	  -0.00000000301,     0.00000000010,
	  -0.00000000003,     0.00000000320,
	   0.00000003724,    -0.00000000053,
	  -0.00000000009,    -0.00000000004,
	  -0.00000000162,    -0.00000016838,
	  -0.00000000015,     0.00000000036,
	  -0.00000000181,     0.00000003572,
	   0.00000000002,     0.00000000040,
	  -0.00000000288,    -0.00000000919,
	  -0.00000000006,     0.00000000094,
	  -0.00000000105,     0.00000000146,
	  -0.00000000007,    -0.00000000005,
	  -0.00000000076,    -0.00000000162,
	   0.00000000003,    -0.00000000009,
	  -0.00000000326,     0.00000000004,
	   0.00000000006,     0.00000000505,
	  -0.00000000007,    -0.00000000131,
	  -0.00000000073,     0.00000000023,
	   0.00000000471,     0.00000002126,
	  -0.00000000059,     0.00000000019,
	   0.00000006460,    -0.00000001410,
	   0.00000000067,     0.00000000180,
	   0.00000003737,     0.00000000200,
	  -0.00000000008,    -0.00000000013,
	   0.00000000179,     0.00000004271,
	  -0.00000000011,     0.00000000000,
	  -0.00000000130,     0.00000000013,
	   0.00000000003,     0.00000000002,
	  -0.00000000021,    -0.00000000134,
	  -0.00000000002,     0.00000000004,
	   0.00000000001,    -0.00000000087,
	  -0.00000000210,     0.00000000051,
	  -0.00000000683,     0.00000000296,
	  -0.00000000017,    -0.00000000032,
	   0.00000000296,     0.00000000595,
	  -0.00000000032,     0.00000000017,
	   0.00000000040,     0.00000000030,
	   0.00000000003,     0.00000000003,
	   0.00000000139,    -0.00000000130,
	   0.00000000012,    -0.00000000015,
	  -0.00000000049,    -0.00000000147,
	   0.00000000003,     0.00000000003,
	   0.00000000158,    -0.00000000025,
	  -0.00000000001,     0.00000000004,
	   0.00000000104,     0.00000000117,
	   0.00000000004,    -0.00000000004,
	  -0.00000000115,     0.00000000101,
	   0.00000000004,     0.00000000004,
	  -0.00000002372,     0.00000001109,
	  -0.00000000066,    -0.00000000129,
	  -0.00000000991,    -0.00000002102,
	   0.00000000106,    -0.00000000054,
	  -0.00000000040,    -0.00000000020,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000005,     0.00000000006,
	  -0.00000000005,     0.00000000002,
	   0.00000000003,     0.00000000006,
	  -0.00000000005,     0.00000000002,
	   0.00000000007,     0.00000000025,
	   0.00000000005,    -0.00000000002,
	  -0.00000000006,     0.00000000012,
	   0.00000000015,     0.00000000003,
	  -0.00000000005,     0.00000000015,
	   0.00000000002,     0.00000000000,
	   0.00000000069,     0.00000000027,
	   0.00000000002,    -0.00000000009,
	   0.00000000007,     0.00000000024,
	   0.00000000023,    -0.00000000020,
	   0.00000000020,     0.00000000032,
	   0.00000000002,    -0.00000000001,
	   0.00000000144,    -0.00000000087,
	  -0.00000000006,    -0.00000000008,
	   0.00000000015,     0.00000000030,
	  -0.00000000007,    -0.00000000037,
	  -0.00000000031,    -0.00000000048,
	  -0.00000000035,     0.00000000020,
	  -0.00000000041,    -0.00000000017,
	  -0.00000000013,     0.00000000044,
	   0.00000000051,     0.00000000018,
	   0.00000000051,    -0.00000000221,
	   0.00000000026,     0.00000000080,
	  -0.00000000020,     0.00000000028,
	   0.00000000002,     0.00000000003,
	  -0.00000000098,    -0.00000000038,
	  -0.00000000011,     0.00000000046,
	  -0.00000000120,    -0.00000000027,
	  -0.00000000019,     0.00000000116,
	   0.00000000009,     0.00000000061,
	   0.00000000185,    -0.00000000020,
	   0.00000000000,     0.00000000005,
	   0.00000000098,    -0.00000000002,
	   0.00000000006,     0.00000000117,
	  -0.00000000466,    -0.00000000033,
	  -0.00000000045,    -0.00000000091,
	  -0.00000000727,     0.00000000337,
	  -0.00000000019,    -0.00000000036,
	   0.00000000341,     0.00000000712,
	  -0.00000000037,     0.00000000018,
	  -0.00000000001,    -0.00000000002,
	  -0.00000000006,     0.00000000003,
	  -0.00000000005,     0.00000000000,
	   0.00000000000,    -0.00000000005,
	  -0.00000004292,     0.00000002011,
	  -0.00000000119,    -0.00000000235,
	  -0.00000001239,    -0.00000002650,
	   0.00000000134,    -0.00000000068,
	   0.00000000035,    -0.00000000085,
	  -0.00000000080,    -0.00000000108,
	   0.00000000004,     0.00000000002,
	   0.00000000010,    -0.00000000015,
	   0.00000000011,     0.00000000005,
	   0.00000000003,    -0.00000000010,
	   0.00000000040,     0.00000000013,
	   0.00000000003,    -0.00000000002,
	   0.00000000064,    -0.00000000147,
	  -0.00000000009,    -0.00000000013,
	   0.00000000069,     0.00000000035,
	   0.00000000005,    -0.00000000002,
	   0.00000000012,    -0.00000000054,
	   0.00000000293,     0.00000000092,
	   0.00000000015,    -0.00000000010,
	   0.00000000352,    -0.00000001108,
	  -0.00000000041,    -0.00000000055,
	   0.00000000327,     0.00000000217,
	   0.00000000013,    -0.00000000002,
	   0.00000000048,    -0.00000000122,
	   0.00000000010,     0.00000000010,
	  -0.00000000010,     0.00000000004,
	  -0.00000000003,    -0.00000000010,
	   0.00000001412,     0.00000000637,
	   0.00000000016,     0.00000000018,
	   0.00000001817,    -0.00000005318,
	   0.00000000053,    -0.00000000045,
	  -0.00000000005,    -0.00000000003,
	   0.00000001122,     0.00000001002,
	   0.00000000028,    -0.00000000050,
	   0.00000000247,     0.00000001061,
	   0.00000000057,     0.00000000065,
	  -0.00000000047,     0.00000000020,
	  -0.00000000018,    -0.00000000047,
	  -0.00000000079,     0.00000000065,
	   0.00000000065,     0.00000000079,
	   0.00000000881,     0.00000004130,
	  -0.00000000115,     0.00000000026,
	   0.00000011824,    -0.00000002465,
	   0.00000000072,     0.00000000331,
	   0.00000006950,     0.00000000189,
	  -0.00000000019,    -0.00000000031,
	   0.00000000299,     0.00000008093,
	  -0.00000000028,     0.00000000007,
	  -0.00000000078,    -0.00000000059,
	   0.00000000004,    -0.00000000004,
	   0.00000000059,    -0.00000000077,
	   0.00000000004,     0.00000000004,
	  -0.00000001090,     0.00000000896,
	  -0.00000000064,    -0.00000000076,
	  -0.00000001261,     0.00000000593,
	   0.00000000591,     0.00000001260,
	   0.00000000003,     0.00000000000,
	   0.00000000002,    -0.00000000012,
	   0.00000000004,     0.00000000002,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000002,     0.00000000004,
	   0.00000000016,    -0.00000000096,
	   0.00000000007,    -0.00000000002,
	  -0.00000000272,    -0.00000000055,
	  -0.00000000005,    -0.00000000020,
	  -0.00000000174,    -0.00000000092,
	  -0.00000000001,    -0.00000000005,
	   0.00000000092,    -0.00000000197,
	   0.00000000008,    -0.00000000002,
	   0.00000000031,     0.00000000035,
	  -0.00000000035,     0.00000000029,
	  -0.00000026185,     0.00000012294,
	  -0.00000000729,    -0.00000001429,
	  -0.00000002339,    -0.00000004985,
	   0.00000000251,    -0.00000000129,
	  -0.00000000040,    -0.00000000125,
	  -0.00000002630,     0.00000001237,
	   0.00000000013,     0.00000000004,
	   0.00000000001,    -0.00000000004,
	   0.00000000009,    -0.00000000046,
	  -0.00000000014,    -0.00000000001,
	   0.00000000010,     0.00000000006,
	   0.00000000002,    -0.00000000003,
	   0.00000000003,     0.00000000008,
	   0.00000000000,    -0.00000000002,
	  -0.00000000007,     0.00000000002,
	   0.00000000001,    -0.00000000004,
	   0.00000000007,     0.00000000023,
	   0.00000000006,    -0.00000000003,
	   0.00000000067,    -0.00000000018,
	  -0.00000000009,    -0.00000000018,
	   0.00000000035,    -0.00000000006,
	  -0.00000000003,    -0.00000000011,
	   0.00000000006,     0.00000000042,
	   0.00000000013,    -0.00000000004,
	  -0.00000000002,    -0.00000000012,
	  -0.00000000001,     0.00000000001,
	  -0.00000000040,     0.00000000008,
	   0.00000000004,     0.00000000004,
	  -0.00000000003,    -0.00000000012,
	   0.00000000066,    -0.00000000011,
	  -0.00000000002,    -0.00000000002,
	  -0.00000000032,    -0.00000000221,
	  -0.00000000005,     0.00000000007,
	  -0.00000000002,    -0.00000000032,
	  -0.00000000005,     0.00000000004,
	   0.00000000071,    -0.00000000014,
	  -0.00000000004,    -0.00000000005,
	   0.00000000074,     0.00000000137,
	   0.00000000138,    -0.00000000074,
	   0.00000000045,     0.00000000196,
	  -0.00000000005,     0.00000000002,
	   0.00000000559,    -0.00000000129,
	   0.00000000005,     0.00000000014,
	   0.00000000333,     0.00000000011,
	   0.00000000014,     0.00000000386,
	  -0.00000000003,    -0.00000000004,
	   0.00000000004,    -0.00000000003,
	   0.00000001905,     0.00000003522,
	  -0.00000000137,     0.00000000073,
	  -0.00000001690,     0.00000000796,
	  -0.00000000046,    -0.00000000085,
	   0.00000000798,     0.00000001692,
	  -0.00000000084,     0.00000000045,
	   0.00000000006,    -0.00000000001,
	  -0.00000000002,    -0.00000000018,
	   0.00000000000,    -0.00000000011,
	   0.00000000013,     0.00000000000,
	  -0.00000064942,     0.00000030596,
	  -0.00000001836,    -0.00000003536,
	  -0.00000003183,    -0.00000006768,
	   0.00000000341,    -0.00000000177,
	   0.00000000083,     0.00000000191,
	   0.00000000099,    -0.00000000034,
	  -0.00000000105,    -0.00000000004,
	  -0.00000000004,     0.00000000105,
	   0.00000000175,    -0.00000000057,
	  -0.00000000057,    -0.00000000175,
	   0.00000000001,     0.00000000004,
	   0.00000000011,    -0.00000000002,
	   0.00000000006,     0.00000000000,
	   0.00000000000,     0.00000000007,
	   0.00000008994,    -0.00000002942,
	   0.00000000057,     0.00000000175,
	  -0.00000002400,     0.00000001124,
	  -0.00000000062,    -0.00000000121,
	   0.00000001124,     0.00000002397,
	  -0.00000000121,     0.00000000062,
	  -0.00000185249,     0.00000086809,
	  -0.00000005164,    -0.00000010086,
	  -0.00000004505,    -0.00000009616,
	   0.00000000484,    -0.00000000250,
	  -0.00000000098,     0.00000000079,
	   0.00000000117,     0.00000000215,
	  -0.00000000138,    -0.00000000050,
	  -0.00000000050,     0.00000000138,
	  -0.00000000138,    -0.00000000050,
	   0.00000000050,    -0.00000000137,
	  -0.00000001033,     0.00000003449,
	  -0.00000003010,     0.00000001416,
	  -0.00000000078,    -0.00000000152,
	   0.00000001416,     0.00000003011,
	  -0.00000000152,     0.00000000078,
	  -0.00000362969,     0.00000170763,
	  -0.00000010165,    -0.00000019798,
	  -0.00000005654,    -0.00000012033,
	   0.00000000606,    -0.00000000313,
	  -0.00000000202,    -0.00000000030,
	  -0.00000000030,     0.00000000202,
	  -0.00000000202,    -0.00000000030,
	   0.00000000030,    -0.00000000202,
	  -0.00000000049,     0.00000000043,
	  -0.00000000005,    -0.00000000004,
	   0.00000000017,     0.00000000037,
	   0.00000000139,     0.00000000231,
	  -0.00000000016,     0.00000000013,
	  -0.00000000237,     0.00000000149,
	  -0.00000000014,    -0.00000000016,
	  -0.00000000033,    -0.00000000005,
	   0.00000000005,    -0.00000000033,
	  -0.00000000229,    -0.00000000295,
	   0.00000000295,    -0.00000000228,
	  -0.00000000270,    -0.00000000347,
	   0.00000000347,    -0.00000000265,
	  -0.00000000036,     0.00000000066,
	  -0.00000000331,    -0.00000000427,
	   0.00000000032,    -0.00000000027,
	   0.00000000427,    -0.00000000327,
	   0.00000000026,     0.00000000032,
	  -0.00000000615,    -0.00000000789,
	   0.00000000059,    -0.00000000049,
	   0.00000000792,    -0.00000000607,
	   0.00000000049,     0.00000000059,
	  -0.00000000065,    -0.00000000093,
	  -0.00000000833,    -0.00000001067,
	   0.00000000080,    -0.00000000068,
	   0.00000001072,    -0.00000000825,
	   0.00000000067,     0.00000000080,
	   0.00000000095,    -0.00000000093,
	  -0.00000001182,    -0.00000001519,
	   0.00000000114,    -0.00000000095,
	   0.00000001522,    -0.00000001165,
	   0.00000000094,     0.00000000113,
	  -0.00000001481,    -0.00000001896,
	   0.00000000142,    -0.00000000120,
	   0.00000001907,    -0.00000001463,
	   0.00000000118,     0.00000000142,
	  -0.00000000042,     0.00000000088,
	   0.00000000007,     0.00000000006,
	  -0.00000000003,    -0.00000000003,
	   0.00000000004,    -0.00000000004,
	  -0.00000000003,    -0.00000000003,
	   0.00000000003,    -0.00000000002,
	   0.00000000009,    -0.00000000010,
	  -0.00000000010,    -0.00000000009,
	   0.00000000004,    -0.00000000002,
	   0.00000000004,    -0.00000000004,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000007,    -0.00000000006,
	  -0.00000000066,    -0.00000000030,
	  -0.00000000007,     0.00000000014,
	  -0.00000000032,     0.00000000068,
	   0.00000000015,     0.00000000007,
	  -0.00000000001,    -0.00000000004,
	  -0.00000000006,     0.00000000001,
	  -0.00000000047,    -0.00000000022,
	  -0.00000000005,     0.00000000010,
	   0.00000000133,    -0.00000000281,
	  -0.00000000065,    -0.00000000032,
	  -0.00000000003,     0.00000000006,
	  -0.00000000064,     0.00000000550,
	   0.00000000109,     0.00000000014,
	   0.00000000001,    -0.00000000008,
	   0.00000000575,     0.00000000080,
	   0.00000000019,    -0.00000000115,
	  -0.00000000008,    -0.00000000002,
	  -0.00000000026,     0.00000000019,
	   0.00000000003,     0.00000000003,
	   0.00000000018,     0.00000000041,
	   0.00000000006,    -0.00000000003,
	   0.00000000006,    -0.00000000048,
	  -0.00000000050,    -0.00000000007,
	   0.00000000092,    -0.00000000688,
	  -0.00000000137,    -0.00000000021,
	  -0.00000000002,     0.00000000012,
	  -0.00000035550,    -0.00000004729,
	  -0.00000001065,     0.00000007080,
	   0.00000000605,     0.00000000095,
	  -0.00000006242,     0.00000001174,
	   0.00000000170,     0.00000001025,
	   0.00000000072,    -0.00000000012,
	   0.00000001064,     0.00000006632,
	   0.00000001111,    -0.00000000141,
	  -0.00000000009,    -0.00000000080,
	  -0.00000000246,    -0.00000000183,
	  -0.00000000013,     0.00000000029,
	  -0.00000000357,     0.00000000295,
	   0.00000000042,     0.00000000046,
	  -0.00000000021,     0.00000000160,
	   0.00000000030,     0.00000000005,
	   0.00000001786,     0.00000000237,
	   0.00000000052,    -0.00000000332,
	   0.00000000551,    -0.00000000098,
	  -0.00000000013,    -0.00000000085,
	  -0.00000000088,    -0.00000000577,
	  -0.00000000090,     0.00000000011,
	  -0.00000000437,     0.00000000074,
	   0.00000000010,     0.00000000073,
	   0.00000000005,    -0.00000000001,
	   0.00000001031,     0.00000005979,
	   0.00000000992,    -0.00000000146,
	  -0.00000000010,    -0.00000000070,
	   0.00000001555,     0.00000002956,
	   0.00000000387,    -0.00000000190,
	  -0.00000000011,    -0.00000000021,
	   0.00000003224,    -0.00000001555,
	  -0.00000000188,    -0.00000000438,
	  -0.00000000026,     0.00000000010,
	  -0.00000000042,     0.00000000122,
	   0.00000000009,     0.00000000000,
	   0.00000000176,     0.00000000127,
	   0.00000000011,    -0.00000000018,
	   0.00000000091,    -0.00000000015,
	  -0.00000000053,    -0.00000000306,
	  -0.00000000047,     0.00000000007,
	  -0.00000000136,    -0.00000000266,
	  -0.00000000282,     0.00000000135,
	   0.00000000015,     0.00000000036,
	   0.00000000130,    -0.00000000364,
	  -0.00000000067,    -0.00000000030,
	  -0.00000000001,     0.00000000007,
	   0.00000000007,     0.00000000001,
	   0.00000000363,     0.00000000730,
	   0.00000000098,    -0.00000000044,
	  -0.00000000003,    -0.00000000006,
	   0.00000006921,    -0.00000003495,
	  -0.00000000427,    -0.00000000923,
	  -0.00000000052,     0.00000000024,
	   0.00000003428,    -0.00000003394,
	  -0.00000000312,    -0.00000000334,
	  -0.00000000013,     0.00000000013,
	  -0.00000003533,    -0.00000003927,
	  -0.00000000414,     0.00000000330,
	   0.00000000014,     0.00000000019,
	   0.00000000136,     0.00000000001,
	  -0.00000000004,    -0.00000000004,
	   0.00000000108,    -0.00000000254,
	  -0.00000000018,    -0.00000000007,
	  -0.00000000067,    -0.00000000136,
	  -0.00000000017,     0.00000000008,
	  -0.00000000353,     0.00000000178,
	   0.00000000020,     0.00000000044,
	  -0.00000000317,     0.00000000305,
	   0.00000000026,     0.00000000030,
	   0.00000000312,     0.00000000345,
	   0.00000000034,    -0.00000000027,
	   0.00000001257,    -0.00000001174,
	  -0.00000000109,    -0.00000000128,
	  -0.00000000005,     0.00000000005,
	  -0.00000008984,    -0.00000009489,
	  -0.00000000962,     0.00000000833,
	   0.00000000036,     0.00000000041,
	  -0.00000006477,    -0.00000003480,
	  -0.00000000214,     0.00000000387,
	   0.00000000011,     0.00000000004,
	  -0.00000004489,     0.00000007081,
	   0.00000000456,     0.00000000346,
	   0.00000000011,    -0.00000000015,
	  -0.00000000046,    -0.00000000109,
	   0.00000000005,     0.00000000004,
	  -0.00000000364,    -0.00000000084,
	  -0.00000000004,     0.00000000017,
	  -0.00000000204,     0.00000000191,
	   0.00000000016,     0.00000000020,
	   0.00000000451,     0.00000000477,
	   0.00000000045,    -0.00000000039,
	   0.00000000602,     0.00000000340,
	   0.00000000021,    -0.00000000034,
	   0.00000000391,    -0.00000000630,
	  -0.00000000037,    -0.00000000027,
	  -0.00000002999,    -0.00000001776,
	  -0.00000000125,     0.00000000187,
	   0.00000000006,     0.00000000003,
	  -0.00000011163,     0.00000019094,
	   0.00000001182,     0.00000000781,
	   0.00000000021,    -0.00000000035,
	  -0.00000001611,     0.00000008917,
	   0.00000000218,     0.00000000004,
	   0.00000010855,     0.00000003474,
	   0.00000000189,    -0.00000000389,
	  -0.00000000009,    -0.00000000004,
	   0.00000000031,     0.00000000044,
	  -0.00000000001,    -0.00000000010,
	  -0.00000000068,     0.00000000444,
	   0.00000000015,     0.00000000002,
	   0.00000000417,     0.00000000247,
	   0.00000000016,    -0.00000000024,
	   0.00000000547,    -0.00000000936,
	  -0.00000000054,    -0.00000000036,
	   0.00000000200,    -0.00000000879,
	  -0.00000000961,    -0.00000000282,
	  -0.00000001465,     0.00000005624,
	   0.00000000174,     0.00000000056,
	   0.00000000000,    -0.00000000003,
	   0.00000030319,     0.00000007812,
	   0.00000000303,    -0.00000000928,
	  -0.00000000015,    -0.00000000002,
	   0.00000004723,    -0.00000001577,
	  -0.00000000105,     0.00000000163,
	   0.00000000006,     0.00000000001,
	   0.00000001128,    -0.00000009635,
	  -0.00000000131,    -0.00000000079,
	  -0.00000000002,     0.00000000006,
	  -0.00000000069,    -0.00000000232,
	  -0.00000000002,     0.00000000003,
	   0.00000000450,     0.00000000100,
	   0.00000000000,    -0.00000000014,
	   0.00000000170,    -0.00000000652,
	  -0.00000000019,    -0.00000000006,
	  -0.00000001434,    -0.00000000367,
	  -0.00000000014,     0.00000000041,
	  -0.00000000616,     0.00000000066,
	  -0.00000000035,     0.00000000794,
	   0.00000005462,    -0.00000000139,
	  -0.00000000007,     0.00000000010,
	  -0.00000000540,    -0.00000025445,
	   0.00000000039,     0.00000000026,
	  -0.00000000252,     0.00000008453,
	   0.00000000027,     0.00000000076,
	  -0.00000000585,    -0.00000002001,
	  -0.00000000003,     0.00000000244,
	  -0.00000000213,     0.00000000031,
	  -0.00000000004,     0.00000000001,
	   0.00000000066,    -0.00000000413,
	  -0.00000000006,     0.00000000000,
	  -0.00000000506,     0.00000000013,
	   0.00000000027,     0.00000001130,
	  -0.00000000040,    -0.00000000455,
	  -0.00000000187,     0.00000000107,
	   0.00000000791,     0.00000003464,
	  -0.00000000097,     0.00000000029,
	  -0.00000000001,    -0.00000000002,
	   0.00000011179,    -0.00000002450,
	   0.00000000096,     0.00000000303,
	  -0.00000000003,     0.00000000002,
	   0.00000003429,     0.00000000396,
	  -0.00000000032,    -0.00000000041,
	   0.00000000527,     0.00000004892,
	  -0.00000000054,     0.00000000020,
	  -0.00000000187,     0.00000000124,
	   0.00000000014,     0.00000000001,
	  -0.00000000134,    -0.00000000184,
	  -0.00000000001,     0.00000000013,
	  -0.00000000055,    -0.00000000241,
	  -0.00000000516,     0.00000000112,
	  -0.00000000042,    -0.00000000029,
	  -0.00000000031,    -0.00000000146,
	  -0.00000000853,     0.00000000468,
	  -0.00000000028,    -0.00000000052,
	   0.00000001109,     0.00000001766,
	  -0.00000000119,     0.00000000064,
	   0.00000000552,     0.00000002688,
	  -0.00000000070,     0.00000000015,
	  -0.00000002808,     0.00000000690,
	  -0.00000000027,    -0.00000000083,
	   0.00000000174,     0.00000000070,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000067,     0.00000000173,
	   0.00000000003,    -0.00000000003,
	   0.00000000039,    -0.00000000019,
	  -0.00000000055,    -0.00000000086,
	  -0.00000000103,    -0.00000000167,
	  -0.00000000071,     0.00000000079,
	   0.00000000000,     0.00000000022,
	   0.00000000047,    -0.00000000009,
	   0.00000000068,    -0.00000000012,
	   0.00000000012,     0.00000000075,
	  -0.00000000015,     0.00000000047,
	  -0.00000000046,    -0.00000000017,
	  -0.00000000242,    -0.00000000313,
	   0.00000000023,    -0.00000000020,
	   0.00000000372,    -0.00000000289,
	   0.00000000023,     0.00000000028,
	  -0.00000000004,    -0.00000000002,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000001,     0.00000000006,
	  -0.00000000003,     0.00000000000,
	  -0.00000000003,     0.00000000020,
	   0.00000000005,     0.00000000021,
	   0.00000000023,    -0.00000000004,
	   0.00000000002,     0.00000000012,
	   0.00000000081,    -0.00000000018,
	   0.00000000000,    -0.00000000007,
	   0.00000000066,    -0.00000000043,
	  -0.00000000001,    -0.00000000005,
	  -0.00000000043,    -0.00000000073,
	  -0.00000000006,     0.00000000001,
	   0.00000000000,    -0.00000000005,
	   0.00000000043,    -0.00000000027,
	  -0.00000000001,    -0.00000000003,
	  -0.00000000172,    -0.00000000263,
	  -0.00000000020,     0.00000000006,
	  -0.00000000202,    -0.00000000144,
	  -0.00000000009,     0.00000000007,
	  -0.00000000176,     0.00000000213,
	   0.00000000007,     0.00000000012,
	  -0.00000000005,    -0.00000000004,
	  -0.00000000013,     0.00000000003,
	  -0.00000000152,    -0.00000000119,
	  -0.00000000008,     0.00000000005,
	  -0.00000000632,     0.00000000845,
	   0.00000000034,     0.00000000042,
	  -0.00000000142,     0.00000000581,
	   0.00000000012,     0.00000000004,
	   0.00000000669,     0.00000000258,
	   0.00000000014,    -0.00000000016,
	   0.00000000005,     0.00000000005,
	   0.00000000010,     0.00000000025,
	   0.00000000016,    -0.00000000054,
	  -0.00000000056,    -0.00000000019,
	  -0.00000000181,     0.00000000561,
	   0.00000000012,     0.00000000009,
	   0.00000002680,     0.00000000837,
	   0.00000000040,    -0.00000000066,
	   0.00000000665,    -0.00000000189,
	  -0.00000000016,     0.00000000006,
	   0.00000000119,    -0.00000001119,
	  -0.00000000011,    -0.00000000004,
	  -0.00000000025,    -0.00000000030,
	   0.00000000036,    -0.00000000007,
	   0.00000000020,    -0.00000000062,
	  -0.00000000086,    -0.00000000027,
	  -0.00000000078,     0.00000000005,
	   0.00000000000,     0.00000000086,
	   0.00000001037,    -0.00000000036,
	  -0.00000000006,    -0.00000000002,
	  -0.00000000111,    -0.00000004255,
	  -0.00000000008,     0.00000000020,
	  -0.00000000055,     0.00000001518,
	  -0.00000000001,     0.00000000016,
	  -0.00000000034,    -0.00000000398,
	  -0.00000000003,     0.00000000037,
	  -0.00000000029,     0.00000000036,
	  -0.00000000017,    -0.00000000045,
	  -0.00000000091,     0.00000000003,
	   0.00000000004,     0.00000000128,
	  -0.00000000010,    -0.00000000069,
	  -0.00000000047,     0.00000000017,
	   0.00000000231,     0.00000000992,
	  -0.00000000027,     0.00000000008,
	   0.00000002988,    -0.00000000677,
	   0.00000000028,     0.00000000083,
	   0.00000001036,     0.00000000103,
	  -0.00000000010,    -0.00000000012,
	   0.00000000161,     0.00000001485,
	  -0.00000000009,     0.00000000000,
	  -0.00000000060,     0.00000000001,
	   0.00000000001,    -0.00000000058,
	  -0.00000000015,    -0.00000000065,
	  -0.00000000094,     0.00000000021,
	  -0.00000000377,     0.00000000199,
	  -0.00000000010,    -0.00000000020,
	   0.00000000447,     0.00000000777,
	  -0.00000000040,     0.00000000019,
	   0.00000000224,     0.00000001147,
	  -0.00000000028,     0.00000000008,
	  -0.00000001205,     0.00000000295,
	  -0.00000000011,    -0.00000000032,
	   0.00000000032,     0.00000000025,
	  -0.00000000024,     0.00000000031,
	  -0.00000000102,    -0.00000000140,
	  -0.00000000120,     0.00000000097,
	  -0.00000000007,     0.00000000008,
	   0.00000000018,     0.00000000019,
	   0.00000000026,     0.00000000002,
	  -0.00000000006,     0.00000000028,
	  -0.00000000018,     0.00000000023,
	  -0.00000000022,    -0.00000000018,
	  -0.00000000378,    -0.00000000491,
	   0.00000000037,    -0.00000000030,
	   0.00000000448,    -0.00000000347,
	   0.00000000028,     0.00000000033,
	  -0.00000000002,     0.00000000000,
	   0.00000000055,     0.00000000396,
	   0.00000000060,    -0.00000000005,
	   0.00000000008,     0.00000000016,
	   0.00000000017,    -0.00000000008,
	   0.00000000004,    -0.00000000002,
	  -0.00000000003,     0.00000000005,
	   0.00000000007,     0.00000000002,
	  -0.00000000002,     0.00000000001,
	   0.00000000002,     0.00000000008,
	  -0.00000000002,     0.00000000004,
	   0.00000000018,     0.00000000008,
	  -0.00000000001,     0.00000000006,
	   0.00000000005,    -0.00000000005,
	   0.00000000003,     0.00000000008,
	   0.00000000033,    -0.00000000014,
	  -0.00000000001,     0.00000000010,
	  -0.00000000002,    -0.00000000007,
	   0.00000000006,     0.00000000007,
	   0.00000000021,    -0.00000000028,
	   0.00000000004,     0.00000000023,
	  -0.00000000007,     0.00000000007,
	  -0.00000000002,     0.00000000017,
	   0.00000000052,     0.00000000002,
	   0.00000000012,     0.00000000011,
	  -0.00000000009,     0.00000000022,
	  -0.00000000012,     0.00000000004,
	   0.00000000007,     0.00000000025,
	   0.00000000005,     0.00000000033,
	  -0.00000000036,     0.00000000006,
	  -0.00000000020,    -0.00000000108,
	  -0.00000000115,    -0.00000000151,
	  -0.00000000147,     0.00000000115,
	  -0.00000000691,    -0.00000000896,
	   0.00000000067,    -0.00000000056,
	   0.00000000562,    -0.00000000433,
	   0.00000000035,     0.00000000042,
	   0.00000000004,     0.00000000002,
	   0.00000000007,    -0.00000000013,
	   0.00000000006,     0.00000000005,
	   0.00000000023,     0.00000000014,
	   0.00000000044,    -0.00000000081,
	  -0.00000000001,    -0.00000000004,
	   0.00000000027,     0.00000000027,
	   0.00000000005,     0.00000000002,
	   0.00000000083,     0.00000000090,
	   0.00000000002,     0.00000000003,
	   0.00000000243,    -0.00000000294,
	   0.00000000007,    -0.00000000003,
	   0.00000000107,     0.00000000125,
	   0.00000000004,    -0.00000000002,
	  -0.00000000006,     0.00000000126,
	   0.00000000003,     0.00000000008,
	  -0.00000000040,     0.00000000437,
	  -0.00000000014,     0.00000000003,
	   0.00000001158,     0.00000000022,
	   0.00000000006,     0.00000000035,
	   0.00000000496,     0.00000000396,
	   0.00000000005,     0.00000000004,
	  -0.00000000341,     0.00000000690,
	  -0.00000000015,     0.00000000012,
	  -0.00000000007,    -0.00000000008,
	   0.00000000008,    -0.00000000007,
	  -0.00000000782,     0.00000000353,
	  -0.00000000020,    -0.00000000043,
	   0.00000000687,     0.00000001554,
	  -0.00000000086,     0.00000000040,
	   0.00000000470,     0.00000002321,
	  -0.00000000061,     0.00000000011,
	  -0.00000002463,     0.00000000571,
	  -0.00000000019,    -0.00000000072,
	   0.00000000008,    -0.00000000011,
	   0.00000000011,     0.00000000008,
	  -0.00000000205,    -0.00000000265,
	  -0.00000000265,     0.00000000204,
	   0.00000000018,    -0.00000000001,
	   0.00000000001,     0.00000000002,
	   0.00000000000,    -0.00000000036,
	   0.00000000004,    -0.00000000001,
	   0.00000000010,    -0.00000000057,
	   0.00000000060,     0.00000000010,
	   0.00000000001,     0.00000000004,
	  -0.00000000006,     0.00000000009,
	  -0.00000000009,    -0.00000000006,
	  -0.00000004258,    -0.00000005510,
	   0.00000000412,    -0.00000000343,
	   0.00000001052,    -0.00000000812,
	   0.00000000065,     0.00000000079,
	  -0.00000000004,     0.00000000002,
	   0.00000000001,     0.00000000001,
	   0.00000000003,     0.00000000008,
	   0.00000000004,     0.00000000011,
	   0.00000000003,    -0.00000000002,
	  -0.00000000012,     0.00000000004,
	   0.00000000002,     0.00000000004,
	   0.00000000002,    -0.00000000003,
	   0.00000000000,     0.00000000004,
	   0.00000000009,    -0.00000000001,
	   0.00000000004,     0.00000000002,
	  -0.00000000002,     0.00000000006,
	   0.00000000004,    -0.00000000001,
	  -0.00000000003,    -0.00000000012,
	   0.00000000006,    -0.00000000002,
	   0.00000000006,     0.00000000016,
	   0.00000000039,    -0.00000000013,
	   0.00000000030,    -0.00000000005,
	   0.00000000008,     0.00000000035,
	  -0.00000000037,     0.00000000018,
	  -0.00000000001,    -0.00000000002,
	   0.00000000035,     0.00000000073,
	  -0.00000000004,     0.00000000002,
	   0.00000000024,     0.00000000111,
	  -0.00000000117,     0.00000000029,
	  -0.00000000728,     0.00000000632,
	  -0.00000000275,    -0.00000000356,
	  -0.00000000356,     0.00000000276,
	  -0.00000010596,    -0.00000013674,
	   0.00000001103,    -0.00000000923,
	   0.00000001427,    -0.00000001104,
	   0.00000000089,     0.00000000106,
	   0.00000001163,     0.00000001962,
	  -0.00000000390,    -0.00000000506,
	  -0.00000000505,     0.00000000390,
	  -0.00000030127,    -0.00000039048,
	   0.00000003155,    -0.00000002615,
	   0.00000002028,    -0.00000001564,
	   0.00000000126,     0.00000000151,
	  -0.00000000491,    -0.00000000634,
	  -0.00000000634,     0.00000000491,
	  -0.00000059197,    -0.00000076483,
	   0.00000006182,    -0.00000005138,
	   0.00000002536,    -0.00000001961,
	   0.00000000158,     0.00000000189,
	  -0.00000000014,    -0.00000000010,
	   0.00000000001,    -0.00000000002,
	  -0.00000000003,     0.00000000006,
	  -0.00000000053,     0.00000000052,
	  -0.00000000006,    -0.00000000005,
	  -0.00000000055,    -0.00000000054,
	   0.00000000005,    -0.00000000007,
	   0.00000000000,    -0.00000000005,
	   0.00000000005,     0.00000000000,
	   0.00000000059,    -0.00000000072,
	   0.00000000071,     0.00000000059,
	   0.00000000069,    -0.00000000084,
	   0.00000000083,     0.00000000070,
	   0.00000000086,    -0.00000000103,
	   0.00000000102,     0.00000000086,
	   0.00000000158,    -0.00000000191,
	   0.00000000190,     0.00000000159,
	   0.00000000214,    -0.00000000259,
	   0.00000000258,     0.00000000216,
	   0.00000000304,    -0.00000000368,
	   0.00000000365,     0.00000000306,
	   0.00000000380,    -0.00000000461,
	   0.00000000458,     0.00000000384,
	  -0.00000003095,     0.00000006745,
	   0.00000000253,    -0.00000000529,
	  -0.00000000093,     0.00000000199,
	   0.00000000003,     0.00000000005,
	   0.00000000005,    -0.00000000003,
	   0.00000000002,     0.00000000003,
	  -0.00000000004,     0.00000000002,
	   0.00000000024,    -0.00000000028,
	  -0.00000000007,    -0.00000000006,
	  -0.00000000029,    -0.00000000025,
	  -0.00000000007,     0.00000000007,
	   0.00000000044,    -0.00000000050,
	  -0.00000000012,    -0.00000000011,
	  -0.00000000001,     0.00000000002,
	   0.00000001849,     0.00000001623,
	   0.00000000440,    -0.00000000489,
	  -0.00000000056,    -0.00000000051,
	  -0.00000000598,    -0.00000000250,
	  -0.00000000060,     0.00000000137,
	   0.00000000012,     0.00000000006,
	  -0.00000000281,     0.00000000624,
	   0.00000000144,     0.00000000069,
	   0.00000000007,    -0.00000000012,
	  -0.00000000012,    -0.00000000034,
	  -0.00000000005,     0.00000000003,
	  -0.00000000051,     0.00000000007,
	   0.00000000002,     0.00000000010,
	  -0.00000000090,    -0.00000000079,
	   0.00000000052,     0.00000000022,
	   0.00000000025,    -0.00000000054,
	   0.00000000065,     0.00000000029,
	   0.00000000007,    -0.00000000014,
	  -0.00000000001,    -0.00000000001,
	   0.00000000531,    -0.00000001209,
	  -0.00000000279,    -0.00000000128,
	  -0.00000000013,     0.00000000028,
	   0.00000000056,    -0.00000000598,
	  -0.00000000117,    -0.00000000013,
	  -0.00000000001,     0.00000000008,
	  -0.00000000635,    -0.00000000080,
	  -0.00000000020,     0.00000000126,
	   0.00000000009,     0.00000000002,
	   0.00000000023,    -0.00000000018,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000017,    -0.00000000040,
	  -0.00000000006,     0.00000000003,
	  -0.00000000027,     0.00000000062,
	  -0.00000000006,     0.00000000053,
	   0.00000000055,     0.00000000007,
	   0.00000000012,    -0.00000000106,
	  -0.00000000020,    -0.00000000003,
	   0.00000000000,     0.00000000002,
	  -0.00000001161,    -0.00000000130,
	  -0.00000000031,     0.00000000229,
	   0.00000000016,     0.00000000003,
	  -0.00000000749,     0.00000000156,
	   0.00000000022,     0.00000000122,
	   0.00000000007,    -0.00000000001,
	   0.00000000136,     0.00000000814,
	   0.00000000136,    -0.00000000017,
	   0.00000000000,    -0.00000000008,
	  -0.00000000025,    -0.00000000017,
	  -0.00000000040,     0.00000000031,
	   0.00000000004,     0.00000000005,
	   0.00000000060,     0.00000000007,
	   0.00000000067,    -0.00000000013,
	  -0.00000000012,    -0.00000000071,
	   0.00000000003,    -0.00000000003,
	  -0.00000000218,     0.00000000040,
	   0.00000000005,     0.00000000036,
	   0.00000000003,     0.00000000000,
	   0.00000000350,     0.00000001861,
	   0.00000000307,    -0.00000000048,
	  -0.00000000003,    -0.00000000022,
	   0.00000000628,     0.00000001141,
	   0.00000000148,    -0.00000000076,
	  -0.00000000003,    -0.00000000006,
	   0.00000001291,    -0.00000000626,
	  -0.00000000074,    -0.00000000176,
	  -0.00000000008,     0.00000000003,
	  -0.00000000012,     0.00000000039,
	   0.00000000062,     0.00000000048,
	   0.00000000005,    -0.00000000006,
	   0.00000000040,    -0.00000000007,
	  -0.00000000018,    -0.00000000096,
	  -0.00000000056,    -0.00000000105,
	  -0.00000000113,     0.00000000055,
	   0.00000000223,     0.00000000437,
	   0.00000000058,    -0.00000000027,
	  -0.00000000002,    -0.00000000003,
	   0.00000003126,    -0.00000001621,
	  -0.00000000196,    -0.00000000416,
	  -0.00000000024,     0.00000000011,
	   0.00000001556,    -0.00000001607,
	  -0.00000000146,    -0.00000000148,
	  -0.00000000004,     0.00000000004,
	  -0.00000001697,    -0.00000001899,
	  -0.00000000203,     0.00000000158,
	   0.00000000004,     0.00000000007,
	   0.00000000048,    -0.00000000003,
	   0.00000000054,    -0.00000000110,
	  -0.00000000008,    -0.00000000004,
	  -0.00000000037,    -0.00000000073,
	  -0.00000000159,     0.00000000083,
	  -0.00000000149,     0.00000000147,
	   0.00000000151,     0.00000000166,
	   0.00000000758,    -0.00000000720,
	  -0.00000000067,    -0.00000000077,
	  -0.00000000003,     0.00000000003,
	  -0.00000004508,    -0.00000004688,
	  -0.00000000474,     0.00000000415,
	   0.00000000018,     0.00000000020,
	  -0.00000003010,    -0.00000001503,
	  -0.00000000083,     0.00000000175,
	  -0.00000002221,     0.00000003430,
	   0.00000000223,     0.00000000176,
	   0.00000000005,    -0.00000000004,
	  -0.00000000023,    -0.00000000028,
	  -0.00000000165,    -0.00000000051,
	  -0.00000000003,     0.00000000009,
	  -0.00000000113,     0.00000000107,
	   0.00000000009,     0.00000000011,
	   0.00000000226,     0.00000000234,
	   0.00000000288,     0.00000000157,
	   0.00000000190,    -0.00000000306,
	  -0.00000001698,    -0.00000000990,
	  -0.00000000069,     0.00000000105,
	   0.00000000003,     0.00000000002,
	  -0.00000005355,     0.00000009291,
	   0.00000000572,     0.00000000372,
	   0.00000000010,    -0.00000000017,
	  -0.00000000406,     0.00000003567,
	   0.00000000069,    -0.00000000026,
	   0.00000004873,     0.00000001679,
	   0.00000000100,    -0.00000000186,
	  -0.00000000003,    -0.00000000002,
	   0.00000000043,     0.00000000017,
	   0.00000000000,    -0.00000000005,
	  -0.00000000051,     0.00000000202,
	   0.00000000008,     0.00000000002,
	   0.00000000220,     0.00000000128,
	   0.00000000008,    -0.00000000013,
	   0.00000000261,    -0.00000000454,
	   0.00000000075,    -0.00000000374,
	  -0.00000000425,    -0.00000000127,
	  -0.00000000684,     0.00000002724,
	   0.00000000083,     0.00000000025,
	   0.00000013133,     0.00000003280,
	   0.00000000120,    -0.00000000397,
	   0.00000000681,    -0.00000000974,
	  -0.00000000067,     0.00000000101,
	   0.00000000700,    -0.00000003703,
	  -0.00000000081,    -0.00000000047,
	  -0.00000000025,    -0.00000000119,
	   0.00000000203,     0.00000000064,
	   0.00000000001,    -0.00000000008,
	   0.00000000076,    -0.00000000303,
	  -0.00000000618,    -0.00000000153,
	  -0.00000000174,     0.00000000039,
	  -0.00000000019,     0.00000000278,
	   0.00000001847,    -0.00000000094,
	  -0.00000000006,     0.00000000007,
	  -0.00000000347,    -0.00000008146,
	   0.00000000026,     0.00000000023,
	  -0.00000000080,     0.00000004576,
	   0.00000000009,     0.00000000037,
	  -0.00000000172,    -0.00000001085,
	   0.00000000001,     0.00000000132,
	  -0.00000000092,    -0.00000000015,
	  -0.00000000003,     0.00000000002,
	   0.00000000050,    -0.00000000167,
	  -0.00000000004,    -0.00000000001,
	  -0.00000000171,     0.00000000009,
	   0.00000000017,     0.00000000356,
	  -0.00000000027,    -0.00000000259,
	  -0.00000000121,     0.00000000061,
	   0.00000000469,     0.00000002003,
	  -0.00000000057,     0.00000000017,
	   0.00000006458,    -0.00000001452,
	   0.00000000056,     0.00000000178,
	   0.00000000876,     0.00000000316,
	  -0.00000000027,    -0.00000000033,
	   0.00000000429,     0.00000002181,
	  -0.00000000042,     0.00000000016,
	  -0.00000000103,     0.00000000056,
	   0.00000000007,     0.00000000000,
	  -0.00000000046,    -0.00000000098,
	  -0.00000000001,     0.00000000007,
	  -0.00000000035,    -0.00000000149,
	  -0.00000000299,     0.00000000067,
	  -0.00000000029,    -0.00000000086,
	  -0.00000000722,     0.00000000385,
	  -0.00000000023,    -0.00000000043,
	   0.00000000942,     0.00000001663,
	  -0.00000000103,     0.00000000057,
	   0.00000000307,     0.00000001649,
	  -0.00000000037,     0.00000000004,
	  -0.00000001843,     0.00000000508,
	  -0.00000000023,    -0.00000000059,
	   0.00000000069,     0.00000000018,
	  -0.00000000017,     0.00000000069,
	   0.00000000040,    -0.00000000021,
	  -0.00000000046,    -0.00000000081,
	   0.00000000040,    -0.00000000014,
	  -0.00000000131,    -0.00000000145,
	   0.00000000012,    -0.00000000011,
	  -0.00000000214,     0.00000000211,
	  -0.00000000017,    -0.00000000019,
	  -0.00000000609,     0.00000000296,
	  -0.00000000016,    -0.00000000032,
	  -0.00000000322,    -0.00000000621,
	   0.00000000033,    -0.00000000019,
	  -0.00000000009,     0.00000000037,
	  -0.00000000037,    -0.00000000009,
	   0.00000000032,    -0.00000000032,
	  -0.00000000005,     0.00000000000,
	   0.00000000001,     0.00000000009,
	   0.00000000002,     0.00000000015,
	  -0.00000000016,     0.00000000002,
	  -0.00000000010,     0.00000000001,
	   0.00000000000,    -0.00000000010,
	   0.00000000062,    -0.00000000074,
	   0.00000000091,     0.00000000075,
	  -0.00000000001,     0.00000000010,
	   0.00000000002,     0.00000000010,
	   0.00000000010,    -0.00000000002,
	   0.00000000001,     0.00000000006,
	   0.00000000037,    -0.00000000009,
	   0.00000000027,    -0.00000000019,
	  -0.00000000019,    -0.00000000032,
	   0.00000000021,    -0.00000000013,
	   0.00000000000,    -0.00000000002,
	  -0.00000000075,    -0.00000000112,
	  -0.00000000009,     0.00000000003,
	  -0.00000000078,    -0.00000000052,
	  -0.00000000003,     0.00000000003,
	  -0.00000000070,     0.00000000084,
	   0.00000000003,     0.00000000005,
	  -0.00000000005,     0.00000000001,
	  -0.00000000066,    -0.00000000051,
	  -0.00000000003,     0.00000000002,
	  -0.00000000242,     0.00000000328,
	   0.00000000012,     0.00000000015,
	  -0.00000000034,     0.00000000187,
	   0.00000000231,     0.00000000093,
	   0.00000000005,    -0.00000000006,
	   0.00000000002,     0.00000000009,
	  -0.00000000063,     0.00000000205,
	   0.00000000005,     0.00000000003,
	   0.00000000891,     0.00000000269,
	   0.00000000012,    -0.00000000021,
	   0.00000000117,    -0.00000000087,
	  -0.00000000007,     0.00000000003,
	   0.00000000052,    -0.00000000320,
	  -0.00000000005,    -0.00000000002,
	  -0.00000000009,    -0.00000000011,
	   0.00000000012,    -0.00000000001,
	   0.00000000271,    -0.00000000020,
	  -0.00000000003,    -0.00000000001,
	  -0.00000000059,    -0.00000001053,
	  -0.00000000003,     0.00000000010,
	  -0.00000000012,     0.00000000593,
	  -0.00000000001,     0.00000000005,
	   0.00000000007,    -0.00000000156,
	  -0.00000000001,     0.00000000014,
	  -0.00000000007,     0.00000000007,
	  -0.00000000003,    -0.00000000012,
	   0.00000000099,     0.00000000408,
	  -0.00000000010,     0.00000000003,
	   0.00000001216,    -0.00000000285,
	   0.00000000009,     0.00000000031,
	   0.00000000208,     0.00000000056,
	  -0.00000000006,    -0.00000000008,
	   0.00000000095,     0.00000000481,
	  -0.00000000005,     0.00000000000,
	  -0.00000000025,     0.00000000000,
	   0.00000000003,    -0.00000000023,
	  -0.00000000221,     0.00000000116,
	  -0.00000000006,    -0.00000000011,
	   0.00000000266,     0.00000000490,
	  -0.00000000024,     0.00000000012,
	   0.00000000092,     0.00000000499,
	  -0.00000000011,     0.00000000002,
	  -0.00000000562,     0.00000000157,
	  -0.00000000005,    -0.00000000016,
	   0.00000000009,     0.00000000002,
	  -0.00000000002,     0.00000000010,
	  -0.00000000060,    -0.00000000066,
	   0.00000000005,    -0.00000000004,
	  -0.00000000097,     0.00000000097,
	  -0.00000000006,    -0.00000000007,
	  -0.00000000269,     0.00000000129,
	  -0.00000000007,    -0.00000000013,
	  -0.00000000143,    -0.00000000276,
	   0.00000000014,    -0.00000000007,
	  -0.00000000007,     0.00000000011,
	  -0.00000000010,    -0.00000000007,
	   0.00000000027,    -0.00000000031,
	  -0.00000000030,    -0.00000000024,
	  -0.00000000002,    -0.00000000002,
	  -0.00000000003,     0.00000000004,
	  -0.00000000003,     0.00000000006,
	  -0.00000000006,    -0.00000000003,
	  -0.00000000005,    -0.00000000002,
	   0.00000000002,    -0.00000000005,
	   0.00000000097,    -0.00000000117,
	   0.00000000109,     0.00000000091,
	   0.00000000004,     0.00000000003,
	   0.00000000000,     0.00000000002,
	   0.00000000007,    -0.00000000001,
	   0.00000000000,     0.00000000002,
	   0.00000000006,    -0.00000000002,
	   0.00000000000,     0.00000000006,
	  -0.00000000001,     0.00000000004,
	   0.00000000012,     0.00000000003,
	  -0.00000000004,     0.00000000003,
	  -0.00000000005,     0.00000000001,
	   0.00000000001,     0.00000000010,
	  -0.00000000002,     0.00000000009,
	  -0.00000000010,    -0.00000000001,
	  -0.00000000001,    -0.00000000002,
	  -0.00000000004,     0.00000000002,
	  -0.00000000008,     0.00000000003,
	  -0.00000000003,    -0.00000000009,
	   0.00000000030,    -0.00000000036,
	  -0.00000000035,    -0.00000000029,
	   0.00000000179,    -0.00000000214,
	   0.00000000023,     0.00000000018,
	   0.00000000136,     0.00000000113,
	   0.00000000002,     0.00000000002,
	   0.00000000005,    -0.00000000006,
	   0.00000000002,     0.00000000003,
	   0.00000000004,     0.00000000010,
	   0.00000000027,    -0.00000000015,
	   0.00000000007,     0.00000000014,
	  -0.00000000004,     0.00000000012,
	  -0.00000000015,     0.00000000038,
	   0.00000000100,     0.00000000026,
	   0.00000000020,     0.00000000054,
	  -0.00000000051,     0.00000000045,
	  -0.00000000107,     0.00000000018,
	  -0.00000000002,    -0.00000000006,
	   0.00000000050,     0.00000000212,
	  -0.00000000012,     0.00000000004,
	  -0.00000000050,     0.00000000245,
	  -0.00000000007,     0.00000000000,
	  -0.00000000276,    -0.00000000034,
	  -0.00000000002,    -0.00000000010,
	  -0.00000000108,    -0.00000000146,
	   0.00000000011,    -0.00000000009,
	  -0.00000000214,     0.00000000156,
	  -0.00000000012,    -0.00000000016,
	  -0.00000000568,     0.00000000252,
	  -0.00000000013,    -0.00000000028,
	  -0.00000000273,    -0.00000000587,
	   0.00000000030,    -0.00000000015,
	   0.00000000053,    -0.00000000064,
	  -0.00000000064,    -0.00000000053,
	   0.00000000001,     0.00000000004,
	   0.00000000005,    -0.00000000001,
	   0.00000000014,    -0.00000000001,
	   0.00000000001,     0.00000000014,
	   0.00000001105,    -0.00000001328,
	   0.00000000254,     0.00000000211,
	  -0.00000000003,     0.00000000002,
	   0.00000000004,     0.00000000006,
	   0.00000000004,     0.00000000010,
	  -0.00000000011,     0.00000000004,
	  -0.00000000005,    -0.00000000007,
	  -0.00000000010,     0.00000000008,
	  -0.00000000027,     0.00000000013,
	  -0.00000000014,    -0.00000000028,
	   0.00000000071,    -0.00000000086,
	  -0.00000000086,    -0.00000000071,
	   0.00000002742,    -0.00000003305,
	   0.00000000345,     0.00000000286,
	   0.00000000102,    -0.00000000122,
	  -0.00000000122,    -0.00000000101,
	   0.00000007830,    -0.00000009396,
	   0.00000000489,     0.00000000407,
	   0.00000000127,    -0.00000000153,
	  -0.00000000153,    -0.00000000127,
	   0.00000015348,    -0.00000018476,
	   0.00000001952,     0.00000001501,
	   0.00000000612,     0.00000000509,
	  -0.00000000050,     0.00000000065,
	   0.00000000001,    -0.00000000004,
	  -0.00000000018,    -0.00000000009,
	   0.00000000009,    -0.00000000019,
	   0.00000000076,     0.00000000039,
	  -0.00000000039,     0.00000000076,
	   0.00000000108,     0.00000000055,
	  -0.00000000056,     0.00000000107,
	   0.00000000135,     0.00000000068,
	  -0.00000000070,     0.00000000134,
	  -0.00000000002,     0.00000000004,
	   0.00000000003,    -0.00000000015,
	  -0.00000000002,     0.00000000001,
	  -0.00000000005,    -0.00000000018,
	  -0.00000000006,     0.00000000001,
	   0.00000000013,     0.00000000019,
	   0.00000000005,    -0.00000000003,
	   0.00000000020,    -0.00000000013,
	  -0.00000000004,    -0.00000000006,
	  -0.00000000009,    -0.00000000014,
	  -0.00000000004,     0.00000000002,
	  -0.00000000518,     0.00000000331,
	   0.00000000098,     0.00000000156,
	   0.00000000018,    -0.00000000011,
	  -0.00000000097,     0.00000000120,
	   0.00000000029,     0.00000000024,
	   0.00000000003,    -0.00000000003,
	   0.00000000124,     0.00000000106,
	   0.00000000027,    -0.00000000030,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000008,     0.00000000001,
	  -0.00000000002,     0.00000000012,
	  -0.00000000009,     0.00000000011,
	   0.00000000003,     0.00000000002,
	   0.00000000146,     0.00000000122,
	   0.00000000031,    -0.00000000036,
	  -0.00000000004,    -0.00000000003,
	   0.00000000109,     0.00000000043,
	   0.00000000010,    -0.00000000023,
	   0.00000000050,    -0.00000000115,
	  -0.00000000025,    -0.00000000012,
	   0.00000000002,     0.00000000005,
	   0.00000000008,    -0.00000000001,
	   0.00000000026,     0.00000000011,
	   0.00000000003,    -0.00000000006,
	   0.00000000102,    -0.00000000246,
	  -0.00000000056,    -0.00000000025,
	  -0.00000000002,     0.00000000005,
	   0.00000000014,    -0.00000000194,
	  -0.00000000035,    -0.00000000004,
	  -0.00000000209,    -0.00000000025,
	  -0.00000000006,     0.00000000039,
	   0.00000000006,    -0.00000000005,
	  -0.00000000005,    -0.00000000012,
	   0.00000000006,    -0.00000000062,
	  -0.00000000011,    -0.00000000002,
	  -0.00000000491,    -0.00000000047,
	  -0.00000000012,     0.00000000096,
	   0.00000000007,     0.00000000001,
	  -0.00000000356,     0.00000000081,
	   0.00000000012,     0.00000000057,
	   0.00000000068,     0.00000000398,
	   0.00000000067,    -0.00000000008,
	  -0.00000000010,    -0.00000000007,
	  -0.00000000018,     0.00000000014,
	  -0.00000000140,     0.00000000027,
	   0.00000000003,     0.00000000022,
	   0.00000000193,     0.00000000963,
	   0.00000000158,    -0.00000000026,
	  -0.00000000001,    -0.00000000009,
	   0.00000000340,     0.00000000588,
	   0.00000000075,    -0.00000000041,
	   0.00000000695,    -0.00000000337,
	  -0.00000000040,    -0.00000000096,
	  -0.00000000005,     0.00000000001,
	  -0.00000000004,     0.00000000017,
	   0.00000000030,     0.00000000025,
	   0.00000000003,    -0.00000000003,
	  -0.00000000010,    -0.00000000049,
	  -0.00000000031,    -0.00000000056,
	  -0.00000000061,     0.00000000030,
	   0.00000000146,     0.00000000280,
	   0.00000000037,    -0.00000000017,
	  -0.00000000001,    -0.00000000002,
	   0.00000001704,    -0.00000000904,
	  -0.00000000108,    -0.00000000226,
	  -0.00000000010,     0.00000000004,
	   0.00000000777,    -0.00000000844,
	  -0.00000000076,    -0.00000000071,
	  -0.00000000908,    -0.00000001025,
	  -0.00000000111,     0.00000000084,
	   0.00000000002,     0.00000000004,
	   0.00000000019,    -0.00000000004,
	   0.00000000030,    -0.00000000054,
	  -0.00000000004,    -0.00000000002,
	  -0.00000000023,    -0.00000000043,
	  -0.00000000086,     0.00000000046,
	  -0.00000000077,     0.00000000079,
	   0.00000000081,     0.00000000089,
	   0.00000000459,    -0.00000000442,
	  -0.00000000041,    -0.00000000046,
	  -0.00000000002,     0.00000000002,
	  -0.00000002433,    -0.00000002493,
	  -0.00000000251,     0.00000000223,
	   0.00000000010,     0.00000000011,
	  -0.00000001438,    -0.00000000646,
	  -0.00000000029,     0.00000000080,
	  -0.00000001149,     0.00000001730,
	   0.00000000114,     0.00000000094,
	   0.00000000003,    -0.00000000002,
	  -0.00000000012,    -0.00000000004,
	  -0.00000000080,    -0.00000000032,
	  -0.00000000002,     0.00000000005,
	  -0.00000000064,     0.00000000061,
	   0.00000000121,     0.00000000124,
	   0.00000000142,     0.00000000074,
	   0.00000000095,    -0.00000000154,
	  -0.00000000936,    -0.00000000535,
	  -0.00000000037,     0.00000000058,
	   0.00000000002,     0.00000000001,
	  -0.00000002620,     0.00000004625,
	   0.00000000283,     0.00000000180,
	   0.00000000004,    -0.00000000005,
	  -0.00000000002,     0.00000001363,
	   0.00000000014,    -0.00000000027,
	   0.00000002209,     0.00000000828,
	   0.00000000054,    -0.00000000091,
	   0.00000000032,     0.00000000008,
	  -0.00000000033,     0.00000000095,
	   0.00000000005,     0.00000000002,
	   0.00000000116,     0.00000000066,
	   0.00000000127,    -0.00000000225,
	   0.00000000026,    -0.00000000157,
	  -0.00000000188,    -0.00000000057,
	  -0.00000000299,     0.00000001259,
	   0.00000000037,     0.00000000010,
	   0.00000005635,     0.00000001342,
	   0.00000000044,    -0.00000000167,
	  -0.00000000354,    -0.00000000561,
	  -0.00000000039,     0.00000000059,
	   0.00000000406,    -0.00000001401,
	  -0.00000000047,    -0.00000000026,
	  -0.00000000006,    -0.00000000059,
	   0.00000000091,     0.00000000038,
	   0.00000000001,    -0.00000000004,
	   0.00000000032,    -0.00000000136,
	  -0.00000000264,    -0.00000000062,
	  -0.00000000031,     0.00000000022,
	  -0.00000000010,     0.00000000089,
	   0.00000000503,    -0.00000000057,
	  -0.00000000004,     0.00000000005,
	  -0.00000000204,    -0.00000002227,
	   0.00000000016,     0.00000000016,
	  -0.00000000009,     0.00000002277,
	   0.00000000002,     0.00000000017,
	  -0.00000000034,    -0.00000000538,
	   0.00000000002,     0.00000000066,
	  -0.00000000038,    -0.00000000021,
	   0.00000000031,    -0.00000000065,
	  -0.00000000047,     0.00000000005,
	   0.00000000010,     0.00000000093,
	  -0.00000000016,    -0.00000000133,
	  -0.00000000067,     0.00000000032,
	   0.00000000253,     0.00000001048,
	  -0.00000000031,     0.00000000009,
	   0.00000003366,    -0.00000000778,
	   0.00000000029,     0.00000000095,
	  -0.00000000051,     0.00000000223,
	  -0.00000000019,    -0.00000000024,
	   0.00000000302,     0.00000000909,
	  -0.00000000030,     0.00000000011,
	  -0.00000000053,     0.00000000024,
	  -0.00000000014,    -0.00000000049,
	  -0.00000000020,    -0.00000000081,
	  -0.00000000155,     0.00000000036,
	  -0.00000000022,    -0.00000000049,
	  -0.00000000518,     0.00000000272,
	  -0.00000000017,    -0.00000000030,
	   0.00000000686,     0.00000001265,
	  -0.00000000076,     0.00000000042,
	   0.00000000130,     0.00000000861,
	  -0.00000000017,    -0.00000000002,
	  -0.00000001070,     0.00000000333,
	  -0.00000000015,    -0.00000000035,
	   0.00000000025,     0.00000000000,
	   0.00000000001,     0.00000000027,
	   0.00000000032,    -0.00000000017,
	  -0.00000000033,    -0.00000000061,
	  -0.00000000126,    -0.00000000140,
	   0.00000000012,    -0.00000000010,
	  -0.00000000244,     0.00000000232,
	  -0.00000000019,    -0.00000000021,
	  -0.00000000466,     0.00000000221,
	  -0.00000000011,    -0.00000000024,
	  -0.00000000264,    -0.00000000490,
	   0.00000000027,    -0.00000000016,
	  -0.00000000004,     0.00000000023,
	  -0.00000000023,    -0.00000000004,
	   0.00000000023,    -0.00000000034,
	   0.00000000004,     0.00000000003,
	  -0.00000000041,    -0.00000000024,
	   0.00000000003,    -0.00000000005,
	  -0.00000000104,    -0.00000000124,
	   0.00000000010,    -0.00000000008,
	   0.00000000125,    -0.00000000109,
	   0.00000000009,     0.00000000010,
	  -0.00000000009,     0.00000000001,
	   0.00000000000,    -0.00000000009,
	  -0.00000000001,     0.00000000005,
	   0.00000000001,     0.00000000004,
	   0.00000000005,    -0.00000000001,
	   0.00000000001,     0.00000000003,
	   0.00000000017,    -0.00000000004,
	   0.00000000011,    -0.00000000008,
	  -0.00000000008,    -0.00000000014,
	   0.00000000010,    -0.00000000006,
	  -0.00000000032,    -0.00000000048,
	  -0.00000000004,     0.00000000001,
	  -0.00000000030,    -0.00000000018,
	  -0.00000000028,     0.00000000033,
	  -0.00000000028,    -0.00000000021,
	  -0.00000000001,     0.00000000001,
	  -0.00000000091,     0.00000000126,
	   0.00000000005,     0.00000000006,
	  -0.00000000005,     0.00000000058,
	   0.00000000079,     0.00000000034,
	  -0.00000000021,     0.00000000072,
	   0.00000000002,     0.00000000001,
	   0.00000000293,     0.00000000084,
	   0.00000000003,    -0.00000000007,
	   0.00000000004,    -0.00000000038,
	   0.00000000021,    -0.00000000090,
	  -0.00000000003,    -0.00000000004,
	   0.00000000062,    -0.00000000009,
	  -0.00000000028,    -0.00000000237,
	  -0.00000000001,     0.00000000004,
	   0.00000000000,     0.00000000217,
	   0.00000000008,    -0.00000000057,
	   0.00000000000,     0.00000000005,
	   0.00000000040,     0.00000000155,
	  -0.00000000004,     0.00000000001,
	   0.00000000458,    -0.00000000112,
	   0.00000000003,     0.00000000012,
	   0.00000000009,     0.00000000028,
	  -0.00000000003,    -0.00000000004,
	   0.00000000048,     0.00000000150,
	  -0.00000000009,     0.00000000000,
	   0.00000000001,    -0.00000000008,
	  -0.00000000111,     0.00000000058,
	  -0.00000000003,    -0.00000000005,
	   0.00000000138,     0.00000000259,
	  -0.00000000013,     0.00000000007,
	   0.00000000030,     0.00000000187,
	  -0.00000000233,     0.00000000074,
	  -0.00000000003,    -0.00000000007,
	  -0.00000000040,    -0.00000000045,
	   0.00000000003,    -0.00000000003,
	  -0.00000000076,     0.00000000072,
	  -0.00000000005,    -0.00000000005,
	  -0.00000000145,     0.00000000069,
	  -0.00000000003,    -0.00000000007,
	  -0.00000000083,    -0.00000000153,
	   0.00000000008,    -0.00000000004,
	  -0.00000000002,     0.00000000004,
	  -0.00000000004,    -0.00000000002,
	   0.00000000011,    -0.00000000016,
	   0.00000000001,     0.00000000001,
	  -0.00000000020,    -0.00000000011,
	  -0.00000000047,    -0.00000000056,
	   0.00000000004,    -0.00000000003,
	   0.00000000057,    -0.00000000050,
	   0.00000000004,     0.00000000004,
	   0.00000000034,     0.00000000018,
	   0.00000000063,     0.00000000032,
	  -0.00000000021,     0.00000000040,
	  -0.00000000002,     0.00000000003,
	   0.00000000008,     0.00000000005,
	   0.00000000000,     0.00000000006,
	  -0.00000000006,     0.00000000002,
	  -0.00000000012,    -0.00000000001,
	   0.00000000001,     0.00000000024,
	  -0.00000000013,     0.00000000020,
	  -0.00000000025,    -0.00000000011,
	  -0.00000000010,    -0.00000000024,
	   0.00000000002,    -0.00000000001,
	  -0.00000000037,     0.00000000018,
	  -0.00000000076,     0.00000000007,
	  -0.00000000001,    -0.00000000004,
	  -0.00000000012,    -0.00000000081,
	   0.00000000005,    -0.00000000001,
	   0.00000000026,    -0.00000000030,
	   0.00000000003,     0.00000000003,
	  -0.00000000033,    -0.00000000029,
	   0.00000000003,    -0.00000000003,
	  -0.00000000091,    -0.00000000124,
	   0.00000000009,    -0.00000000007,
	   0.00000000126,    -0.00000000096,
	   0.00000000008,     0.00000000010,
	   0.00000000389,     0.00000000200,
	  -0.00000000038,     0.00000000074,
	   0.00000000001,    -0.00000000001,
	  -0.00000000005,    -0.00000000006,
	   0.00000000006,    -0.00000000005,
	   0.00000000966,     0.00000000495,
	  -0.00000000052,     0.00000000101,
	   0.00000002752,     0.00000001418,
	  -0.00000000074,     0.00000000143,
	   0.00000005401,     0.00000002773,
	  -0.00000000092,     0.00000000179,
	   0.00000000002,    -0.00000000006,
	   0.00000000006,     0.00000000001,
	   0.00000000000,    -0.00000000005,
	   0.00000000355,     0.00000000007,
	   0.00000000004,    -0.00000000130,
	  -0.00000000020,    -0.00000000001,
	  -0.00000000042,     0.00000000013,
	   0.00000000004,     0.00000000013,
	   0.00000000013,     0.00000000045,
	   0.00000000014,    -0.00000000004,
	  -0.00000000002,     0.00000000003,
	   0.00000000002,    -0.00000000001,
	  -0.00000000011,    -0.00000000036,
	  -0.00000000011,     0.00000000003,
	  -0.00000000011,    -0.00000000016,
	  -0.00000000004,     0.00000000003,
	  -0.00000000017,     0.00000000011,
	   0.00000000003,     0.00000000005,
	  -0.00000000002,    -0.00000000003,
	  -0.00000000032,     0.00000000021,
	   0.00000000006,     0.00000000009,
	  -0.00000000017,     0.00000000022,
	   0.00000000005,     0.00000000004,
	   0.00000000023,     0.00000000019,
	   0.00000000005,    -0.00000000006,
	  -0.00000000005,     0.00000000006,
	   0.00000000001,     0.00000000001,
	   0.00000000052,     0.00000000042,
	   0.00000000011,    -0.00000000013,
	   0.00000000049,     0.00000000018,
	   0.00000000004,    -0.00000000010,
	   0.00000000022,    -0.00000000052,
	  -0.00000000011,    -0.00000000005,
	   0.00000000017,     0.00000000007,
	   0.00000000002,    -0.00000000004,
	   0.00000000049,    -0.00000000124,
	  -0.00000000026,    -0.00000000012,
	   0.00000000006,    -0.00000000105,
	  -0.00000000019,    -0.00000000002,
	  -0.00000000116,    -0.00000000013,
	  -0.00000000004,     0.00000000021,
	   0.00000000003,    -0.00000000002,
	  -0.00000000002,    -0.00000000006,
	   0.00000000004,    -0.00000000042,
	  -0.00000000008,    -0.00000000001,
	  -0.00000000280,    -0.00000000023,
	  -0.00000000006,     0.00000000051,
	  -0.00000000201,     0.00000000050,
	   0.00000000007,     0.00000000030,
	   0.00000000040,     0.00000000232,
	   0.00000000036,    -0.00000000004,
	  -0.00000000005,    -0.00000000003,
	  -0.00000000010,     0.00000000007,
	  -0.00000000094,     0.00000000019,
	   0.00000000002,     0.00000000015,
	   0.00000000119,     0.00000000564,
	   0.00000000093,    -0.00000000016,
	  -0.00000000001,    -0.00000000005,
	   0.00000000196,     0.00000000323,
	   0.00000000038,    -0.00000000022,
	   0.00000000402,    -0.00000000194,
	  -0.00000000023,    -0.00000000056,
	  -0.00000000001,     0.00000000008,
	   0.00000000016,     0.00000000014,
	  -0.00000000035,     0.00000000018,
	   0.00000000096,     0.00000000179,
	   0.00000000024,    -0.00000000011,
	  -0.00000000001,    -0.00000000001,
	   0.00000000976,    -0.00000000529,
	  -0.00000000063,    -0.00000000129,
	  -0.00000000006,     0.00000000002,
	   0.00000000391,    -0.00000000452,
	  -0.00000000040,    -0.00000000034,
	  -0.00000000497,    -0.00000000569,
	  -0.00000000063,     0.00000000046,
	   0.00000000007,    -0.00000000003,
	   0.00000000018,    -0.00000000028,
	  -0.00000000014,    -0.00000000026,
	  -0.00000000049,     0.00000000027,
	  -0.00000000041,     0.00000000043,
	   0.00000000045,     0.00000000049,
	   0.00000000270,    -0.00000000265,
	  -0.00000000024,    -0.00000000027,
	  -0.00000000001,     0.00000000001,
	  -0.00000001331,    -0.00000001342,
	  -0.00000000135,     0.00000000121,
	   0.00000000003,     0.00000000004,
	  -0.00000000677,    -0.00000000259,
	  -0.00000000006,     0.00000000033,
	  -0.00000000598,     0.00000000874,
	   0.00000000059,     0.00000000051,
	  -0.00000000007,     0.00000000003,
	  -0.00000000039,    -0.00000000019,
	  -0.00000000036,     0.00000000035,
	   0.00000000066,     0.00000000066,
	   0.00000000069,     0.00000000034,
	   0.00000000048,    -0.00000000077,
	  -0.00000000498,    -0.00000000278,
	  -0.00000000019,     0.00000000030,
	  -0.00000001267,     0.00000002285,
	   0.00000000139,     0.00000000085,
	   0.00000000103,     0.00000000462,
	  -0.00000000003,    -0.00000000021,
	   0.00000000988,     0.00000000408,
	   0.00000000029,    -0.00000000044,
	   0.00000000020,     0.00000000004,
	  -0.00000000020,     0.00000000045,
	   0.00000000059,     0.00000000033,
	   0.00000000061,    -0.00000000110,
	   0.00000000007,    -0.00000000062,
	  -0.00000000081,    -0.00000000025,
	  -0.00000000120,     0.00000000548,
	   0.00000000015,     0.00000000003,
	   0.00000002332,     0.00000000516,
	   0.00000000014,    -0.00000000067,
	  -0.00000000461,    -0.00000000303,
	  -0.00000000020,     0.00000000030,
	   0.00000000222,    -0.00000000505,
	  -0.00000000024,    -0.00000000013,
	   0.00000000001,    -0.00000000028,
	   0.00000000040,     0.00000000022,
	   0.00000000013,    -0.00000000058,
	  -0.00000000108,    -0.00000000023,
	   0.00000000058,    -0.00000000031,
	  -0.00000000003,     0.00000000003,
	  -0.00000000111,    -0.00000000348,
	   0.00000000009,     0.00000000010,
	   0.00000000014,     0.00000001046,
	  -0.00000000001,     0.00000000007,
	   0.00000000005,    -0.00000000245,
	   0.00000000002,     0.00000000028,
	  -0.00000000015,    -0.00000000017,
	   0.00000000018,    -0.00000000024,
	  -0.00000000009,    -0.00000000063,
	   0.00000000127,     0.00000000503,
	  -0.00000000014,     0.00000000004,
	   0.00000001615,    -0.00000000388,
	   0.00000000013,     0.00000000043,
	  -0.00000000272,     0.00000000145,
	  -0.00000000012,    -0.00000000015,
	   0.00000000192,     0.00000000353,
	  -0.00000000019,     0.00000000008,
	  -0.00000000025,     0.00000000010,
	  -0.00000000003,    -0.00000000023,
	  -0.00000000010,    -0.00000000040,
	  -0.00000000074,     0.00000000018,
	  -0.00000000333,     0.00000000175,
	  -0.00000000011,    -0.00000000020,
	   0.00000000449,     0.00000000845,
	  -0.00000000050,     0.00000000028,
	   0.00000000034,     0.00000000389,
	  -0.00000000006,    -0.00000000004,
	  -0.00000000572,     0.00000000206,
	  -0.00000000011,    -0.00000000021,
	   0.00000000008,    -0.00000000005,
	   0.00000000005,     0.00000000010,
	  -0.00000000022,    -0.00000000041,
	  -0.00000000103,    -0.00000000115,
	   0.00000000009,    -0.00000000009,
	  -0.00000000222,     0.00000000206,
	  -0.00000000017,    -0.00000000019,
	  -0.00000000307,     0.00000000139,
	  -0.00000000007,    -0.00000000015,
	  -0.00000000189,    -0.00000000337,
	   0.00000000019,    -0.00000000012,
	  -0.00000000001,     0.00000000013,
	  -0.00000000013,    -0.00000000001,
	   0.00000000025,    -0.00000000036,
	   0.00000000004,     0.00000000003,
	  -0.00000000052,    -0.00000000033,
	   0.00000000004,    -0.00000000006,
	  -0.00000000090,    -0.00000000109,
	   0.00000000009,    -0.00000000007,
	   0.00000000111,    -0.00000000099,
	   0.00000000008,     0.00000000009,
	  -0.00000000007,     0.00000000001,
	   0.00000000000,    -0.00000000007,
	   0.00000000009,     0.00000000003,
	   0.00000000002,    -0.00000000008,
	   0.00000000023,    -0.00000000031,
	   0.00000000003,     0.00000000002,
	   0.00000000032,     0.00000000023,
	  -0.00000000002,     0.00000000004,
	   0.00000000000,     0.00000000002,
	   0.00000000008,    -0.00000000002,
	   0.00000000004,    -0.00000000004,
	  -0.00000000003,    -0.00000000006,
	   0.00000000004,    -0.00000000003,
	  -0.00000000014,    -0.00000000020,
	  -0.00000000011,    -0.00000000006,
	  -0.00000000011,     0.00000000013,
	  -0.00000000011,    -0.00000000008,
	  -0.00000000034,     0.00000000048,
	   0.00000000001,     0.00000000017,
	   0.00000000027,     0.00000000012,
	  -0.00000000006,     0.00000000024,
	   0.00000000093,     0.00000000024,
	  -0.00000000011,    -0.00000000015,
	   0.00000000009,    -0.00000000024,
	   0.00000000010,    -0.00000000004,
	  -0.00000000012,    -0.00000000042,
	   0.00000000002,     0.00000000074,
	   0.00000000004,    -0.00000000020,
	   0.00000000015,     0.00000000055,
	   0.00000000162,    -0.00000000042,
	  -0.00000000021,     0.00000000013,
	   0.00000000022,     0.00000000045,
	  -0.00000000051,     0.00000000027,
	  -0.00000000001,    -0.00000000003,
	   0.00000000065,     0.00000000122,
	  -0.00000000006,     0.00000000003,
	   0.00000000007,     0.00000000062,
	  -0.00000000091,     0.00000000034,
	  -0.00000000023,    -0.00000000026,
	   0.00000000002,    -0.00000000002,
	  -0.00000000048,     0.00000000044,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000068,     0.00000000031,
	  -0.00000000043,    -0.00000000075,
	   0.00000000004,    -0.00000000002,
	   0.00000000008,    -0.00000000012,
	   0.00000000001,     0.00000000001,
	  -0.00000000017,    -0.00000000011,
	  -0.00000000029,    -0.00000000035,
	   0.00000000036,    -0.00000000032,
	   0.00000000002,     0.00000000003,
	   0.00000000004,     0.00000000002,
	   0.00000000011,    -0.00000000014,
	   0.00000000015,     0.00000000011,
	  -0.00000000001,    -0.00000000003,
	  -0.00000000005,     0.00000000002,
	  -0.00000000008,    -0.00000000001,
	   0.00000000001,    -0.00000000009,
	   0.00000000005,    -0.00000000004,
	  -0.00000000005,    -0.00000000006,
	  -0.00000000007,    -0.00000000020,
	   0.00000000021,    -0.00000000008,
	   0.00000000008,     0.00000000004,
	   0.00000000004,    -0.00000000007,
	   0.00000000025,    -0.00000000028,
	   0.00000000003,     0.00000000002,
	   0.00000000029,     0.00000000025,
	  -0.00000000002,     0.00000000003,
	  -0.00000000004,     0.00000000013,
	   0.00000000005,     0.00000000002,
	   0.00000000006,     0.00000000000,
	   0.00000000004,    -0.00000000001,
	  -0.00000000001,    -0.00000000004,
	  -0.00000000003,    -0.00000000009,
	  -0.00000000004,    -0.00000000006,
	  -0.00000000006,     0.00000000004,
	  -0.00000000001,    -0.00000000002,
	  -0.00000000014,     0.00000000010,
	   0.00000000003,     0.00000000004,
	  -0.00000000009,     0.00000000012,
	   0.00000000003,     0.00000000002,
	   0.00000000012,     0.00000000010,
	   0.00000000003,    -0.00000000003,
	  -0.00000000003,     0.00000000004,
	   0.00000000030,     0.00000000023,
	   0.00000000006,    -0.00000000007,
	   0.00000000029,     0.00000000010,
	   0.00000000002,    -0.00000000006,
	   0.00000000013,    -0.00000000032,
	  -0.00000000007,    -0.00000000003,
	   0.00000000012,     0.00000000005,
	   0.00000000001,    -0.00000000003,
	   0.00000000029,    -0.00000000076,
	  -0.00000000016,    -0.00000000007,
	   0.00000000002,    -0.00000000063,
	  -0.00000000011,    -0.00000000001,
	  -0.00000000072,    -0.00000000008,
	  -0.00000000002,     0.00000000013,
	   0.00000000002,    -0.00000000029,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000174,    -0.00000000012,
	  -0.00000000004,     0.00000000032,
	  -0.00000000118,     0.00000000032,
	   0.00000000004,     0.00000000017,
	   0.00000000025,     0.00000000142,
	   0.00000000022,    -0.00000000002,
	  -0.00000000006,     0.00000000004,
	  -0.00000000063,     0.00000000014,
	   0.00000000002,     0.00000000010,
	   0.00000000076,     0.00000000342,
	   0.00000000052,    -0.00000000009,
	   0.00000000115,     0.00000000178,
	   0.00000000020,    -0.00000000013,
	   0.00000000236,    -0.00000000113,
	  -0.00000000012,    -0.00000000031,
	   0.00000000008,     0.00000000008,
	   0.00000000061,     0.00000000112,
	   0.00000000014,    -0.00000000007,
	   0.00000000563,    -0.00000000311,
	  -0.00000000037,    -0.00000000074,
	   0.00000000191,    -0.00000000240,
	  -0.00000000020,    -0.00000000014,
	  -0.00000000272,    -0.00000000315,
	  -0.00000000033,     0.00000000023,
	   0.00000000010,    -0.00000000014,
	   0.00000000024,     0.00000000026,
	   0.00000000154,    -0.00000000154,
	  -0.00000000014,    -0.00000000015,
	  -0.00000000722,    -0.00000000715,
	  -0.00000000071,     0.00000000066,
	  -0.00000000306,    -0.00000000088,
	   0.00000000001,     0.00000000014,
	  -0.00000000308,     0.00000000435,
	   0.00000000028,     0.00000000025,
	  -0.00000000004,     0.00000000004,
	  -0.00000000019,    -0.00000000011,
	  -0.00000000020,     0.00000000020,
	   0.00000000036,     0.00000000035,
	   0.00000000023,    -0.00000000038,
	  -0.00000000254,    -0.00000000137,
	  -0.00000000008,     0.00000000014,
	  -0.00000000595,     0.00000001104,
	   0.00000000067,     0.00000000039,
	   0.00000000103,     0.00000000117,
	  -0.00000000006,    -0.00000000014,
	   0.00000000429,     0.00000000199,
	   0.00000000014,    -0.00000000020,
	   0.00000000011,     0.00000000003,
	  -0.00000000012,     0.00000000021,
	   0.00000000029,     0.00000000016,
	   0.00000000028,    -0.00000000053,
	  -0.00000000042,     0.00000000220,
	   0.00000000005,     0.00000000000,
	   0.00000000907,     0.00000000177,
	   0.00000000002,    -0.00000000023,
	  -0.00000000338,    -0.00000000154,
	  -0.00000000010,     0.00000000016,
	   0.00000000115,    -0.00000000167,
	  -0.00000000012,    -0.00000000006,
	   0.00000000002,    -0.00000000013,
	   0.00000000017,     0.00000000012,
	  -0.00000000056,    -0.00000000016,
	  -0.00000000001,     0.00000000001,
	  -0.00000000055,     0.00000000138,
	   0.00000000005,     0.00000000005,
	   0.00000000017,     0.00000000438,
	   0.00000000011,    -0.00000000101,
	   0.00000000001,     0.00000000012,
	  -0.00000000006,    -0.00000000011,
	   0.00000000010,    -0.00000000008,
	   0.00000000059,     0.00000000221,
	  -0.00000000007,     0.00000000002,
	   0.00000000712,    -0.00000000180,
	   0.00000000005,     0.00000000020,
	  -0.00000000247,     0.00000000087,
	  -0.00000000007,    -0.00000000009,
	   0.00000000112,     0.00000000125,
	  -0.00000000011,     0.00000000005,
	  -0.00000000011,     0.00000000004,
	   0.00000000000,    -0.00000000010,
	  -0.00000000198,     0.00000000104,
	  -0.00000000006,    -0.00000000011,
	   0.00000000272,     0.00000000514,
	  -0.00000000028,     0.00000000016,
	  -0.00000000008,     0.00000000146,
	  -0.00000000286,     0.00000000122,
	  -0.00000000007,    -0.00000000012,
	   0.00000000002,    -0.00000000005,
	   0.00000000005,     0.00000000003,
	  -0.00000000075,    -0.00000000085,
	   0.00000000007,    -0.00000000006,
	  -0.00000000175,     0.00000000160,
	  -0.00000000013,    -0.00000000014,
	  -0.00000000181,     0.00000000077,
	  -0.00000000003,    -0.00000000009,
	  -0.00000000125,    -0.00000000212,
	   0.00000000012,    -0.00000000008,
	   0.00000000000,     0.00000000006,
	  -0.00000000007,     0.00000000000,
	   0.00000000022,    -0.00000000033,
	   0.00000000004,     0.00000000002,
	  -0.00000000053,    -0.00000000034,
	   0.00000000004,    -0.00000000006,
	  -0.00000000067,    -0.00000000083,
	   0.00000000006,    -0.00000000005,
	   0.00000000086,    -0.00000000079,
	   0.00000000007,     0.00000000007,
	   0.00000000010,     0.00000000004,
	   0.00000000004,    -0.00000000011,
	   0.00000000022,    -0.00000000030,
	   0.00000000003,     0.00000000002,
	   0.00000000032,     0.00000000022,
	  -0.00000000002,     0.00000000004,
	   0.00000000000,     0.00000000002,
	   0.00000000009,     0.00000000004,
	  -0.00000000004,     0.00000000009,
	   0.00000000002,    -0.00000000001,
	  -0.00000000006,    -0.00000000008,
	  -0.00000000004,    -0.00000000002,
	  -0.00000000004,     0.00000000005,
	  -0.00000000004,    -0.00000000003,
	  -0.00000000012,     0.00000000018,
	   0.00000000001,     0.00000000004,
	   0.00000000009,     0.00000000004,
	  -0.00000000002,     0.00000000008,
	   0.00000000028,     0.00000000006,
	  -0.00000000008,    -0.00000000006,
	   0.00000000003,    -0.00000000006,
	  -0.00000000005,    -0.00000000001,
	   0.00000000001,     0.00000000024,
	   0.00000000002,    -0.00000000006,
	   0.00000000006,     0.00000000018,
	   0.00000000054,    -0.00000000015,
	  -0.00000000015,     0.00000000006,
	   0.00000000010,     0.00000000013,
	  -0.00000000022,     0.00000000012,
	   0.00000000029,     0.00000000054,
	   0.00000000000,     0.00000000018,
	  -0.00000000033,     0.00000000015,
	  -0.00000000012,    -0.00000000013,
	  -0.00000000027,     0.00000000024,
	  -0.00000000029,     0.00000000013,
	  -0.00000000020,    -0.00000000034,
	   0.00000000005,    -0.00000000007,
	  -0.00000000012,    -0.00000000008,
	  -0.00000000015,    -0.00000000019,
	   0.00000000020,    -0.00000000018,
	   0.00000000003,     0.00000000001,
	   0.00000000007,    -0.00000000010,
	   0.00000000010,     0.00000000007,
	   0.00000000004,     0.00000000002,
	  -0.00000000002,     0.00000000004,
	   0.00000000001,     0.00000000001,
	   0.00000000005,    -0.00000000003,
	   0.00000000003,     0.00000000005,
	  -0.00000000001,     0.00000000002,
	   0.00000000008,     0.00000000004,
	  -0.00000000004,     0.00000000008,
	  -0.00000000001,    -0.00000000001,
	   0.00000001232,    -0.00000000993,
	  -0.00000000454,    -0.00000000573,
	  -0.00000000167,     0.00000000166,
	  -0.00000000009,     0.00000000014,
	   0.00000000005,     0.00000000003,
	   0.00000000015,     0.00000000010,
	   0.00000000003,    -0.00000000005,
	  -0.00000000061,     0.00000000049,
	  -0.00000000002,    -0.00000000005,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000004,     0.00000000003,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000009,     0.00000000006,
	  -0.00000000005,     0.00000000007,
	   0.00000000008,     0.00000000006,
	  -0.00000000002,     0.00000000003,
	   0.00000000019,     0.00000000015,
	   0.00000000004,    -0.00000000005,
	   0.00000000019,     0.00000000006,
	   0.00000000001,    -0.00000000004,
	   0.00000000008,    -0.00000000021,
	  -0.00000000004,    -0.00000000002,
	   0.00000000009,     0.00000000003,
	   0.00000000001,    -0.00000000002,
	   0.00000000018,    -0.00000000050,
	  -0.00000000010,    -0.00000000004,
	   0.00000000001,    -0.00000000039,
	  -0.00000000007,     0.00000000000,
	  -0.00000000046,    -0.00000000005,
	  -0.00000000001,     0.00000000008,
	   0.00000000001,    -0.00000000020,
	  -0.00000000004,     0.00000000000,
	  -0.00000000110,    -0.00000000007,
	  -0.00000000002,     0.00000000020,
	  -0.00000000070,     0.00000000021,
	   0.00000000003,     0.00000000010,
	   0.00000000015,     0.00000000087,
	   0.00000000014,    -0.00000000001,
	  -0.00000000004,     0.00000000002,
	  -0.00000000041,     0.00000000009,
	   0.00000000001,     0.00000000006,
	   0.00000000048,     0.00000000208,
	   0.00000000032,    -0.00000000006,
	   0.00000000067,     0.00000000097,
	   0.00000000011,    -0.00000000007,
	   0.00000000138,    -0.00000000066,
	  -0.00000000007,    -0.00000000018,
	   0.00000000004,     0.00000000005,
	   0.00000000038,     0.00000000068,
	   0.00000000008,    -0.00000000004,
	   0.00000000321,    -0.00000000182,
	  -0.00000000020,    -0.00000000039,
	   0.00000000089,    -0.00000000124,
	  -0.00000000010,    -0.00000000006,
	  -0.00000000146,    -0.00000000173,
	  -0.00000000018,     0.00000000013,
	   0.00000000006,    -0.00000000007,
	   0.00000000085,    -0.00000000087,
	  -0.00000000007,    -0.00000000008,
	  -0.00000000385,    -0.00000000373,
	  -0.00000000037,     0.00000000035,
	  -0.00000000130,    -0.00000000019,
	   0.00000000003,     0.00000000005,
	  -0.00000000156,     0.00000000212,
	   0.00000000014,     0.00000000013,
	  -0.00000000002,     0.00000000003,
	  -0.00000000009,    -0.00000000007,
	  -0.00000000123,    -0.00000000064,
	  -0.00000000004,     0.00000000007,
	  -0.00000000268,     0.00000000516,
	   0.00000000029,     0.00000000016,
	   0.00000000075,     0.00000000000,
	  -0.00000000006,    -0.00000000008,
	   0.00000000179,     0.00000000095,
	   0.00000000007,    -0.00000000009,
	   0.00000000006,     0.00000000002,
	  -0.00000000007,     0.00000000009,
	  -0.00000000011,     0.00000000078,
	   0.00000000002,     0.00000000000,
	   0.00000000318,     0.00000000047,
	  -0.00000000001,    -0.00000000007,
	  -0.00000000204,    -0.00000000073,
	  -0.00000000005,     0.00000000008,
	   0.00000000056,    -0.00000000046,
	  -0.00000000006,    -0.00000000003,
	   0.00000000002,    -0.00000000005,
	   0.00000000007,     0.00000000006,
	  -0.00000000062,    -0.00000000007,
	  -0.00000000025,     0.00000000189,
	   0.00000000013,     0.00000000161,
	   0.00000000008,    -0.00000000036,
	   0.00000000001,     0.00000000004,
	  -0.00000000002,    -0.00000000006,
	   0.00000000005,    -0.00000000002,
	   0.00000000025,     0.00000000086,
	  -0.00000000003,     0.00000000001,
	   0.00000000283,    -0.00000000077,
	   0.00000000002,     0.00000000009,
	  -0.00000000167,     0.00000000049,
	  -0.00000000004,    -0.00000000005,
	   0.00000000061,     0.00000000038,
	  -0.00000000006,     0.00000000003,
	  -0.00000000004,     0.00000000002,
	  -0.00000000109,     0.00000000058,
	  -0.00000000003,    -0.00000000006,
	   0.00000000153,     0.00000000289,
	  -0.00000000016,     0.00000000009,
	  -0.00000000020,     0.00000000037,
	  -0.00000000134,     0.00000000069,
	  -0.00000000004,    -0.00000000007,
	  -0.00000000051,    -0.00000000057,
	   0.00000000005,    -0.00000000004,
	  -0.00000000124,     0.00000000113,
	  -0.00000000010,    -0.00000000010,
	  -0.00000000098,     0.00000000038,
	  -0.00000000001,    -0.00000000005,
	  -0.00000000078,    -0.00000000124,
	   0.00000000008,    -0.00000000006,
	   0.00000000018,    -0.00000000026,
	   0.00000000003,     0.00000000002,
	  -0.00000000047,    -0.00000000031,
	   0.00000000003,    -0.00000000005,
	  -0.00000000045,    -0.00000000057,
	   0.00000000004,    -0.00000000003,
	   0.00000000061,    -0.00000000057,
	   0.00000000005,     0.00000000005,
	   0.00000000009,     0.00000000004,
	   0.00000000004,    -0.00000000013,
	   0.00000000018,    -0.00000000025,
	   0.00000000027,     0.00000000019,
	  -0.00000000002,     0.00000000003,
	   0.00000000000,     0.00000000002,
	   0.00000000009,     0.00000000004,
	  -0.00000000004,     0.00000000009,
	  -0.00000000002,    -0.00000000003,
	  -0.00000000002,    -0.00000000001,
	  -0.00000000004,     0.00000000006,
	   0.00000000000,     0.00000000002,
	   0.00000000008,     0.00000000001,
	  -0.00000000004,    -0.00000000002,
	  -0.00000000002,     0.00000000004,
	   0.00000000001,     0.00000000007,
	   0.00000000002,     0.00000000006,
	   0.00000000017,    -0.00000000005,
	  -0.00000000008,     0.00000000003,
	   0.00000000004,     0.00000000004,
	  -0.00000000009,     0.00000000005,
	   0.00000000012,     0.00000000022,
	  -0.00000000012,     0.00000000006,
	  -0.00000000006,    -0.00000000006,
	  -0.00000000013,     0.00000000012,
	  -0.00000000011,     0.00000000005,
	  -0.00000000009,    -0.00000000014,
	   0.00000000003,    -0.00000000004,
	  -0.00000000007,    -0.00000000005,
	  -0.00000000007,    -0.00000000009,
	   0.00000000010,    -0.00000000009,
	   0.00000000002,     0.00000000001,
	   0.00000000004,    -0.00000000006,
	   0.00000000006,     0.00000000004,
	  -0.00000000006,     0.00000000004,
	  -0.00000000003,     0.00000000005,
	   0.00000000005,     0.00000000004,
	  -0.00000000002,     0.00000000002,
	   0.00000000013,     0.00000000010,
	   0.00000000002,    -0.00000000003,
	   0.00000000012,     0.00000000004,
	   0.00000000005,    -0.00000000014,
	   0.00000000006,     0.00000000002,
	   0.00000000012,    -0.00000000033,
	  -0.00000000007,    -0.00000000003,
	   0.00000000000,    -0.00000000024,
	  -0.00000000029,    -0.00000000003,
	  -0.00000000001,     0.00000000005,
	   0.00000000001,    -0.00000000014,
	  -0.00000000003,     0.00000000000,
	  -0.00000000070,    -0.00000000004,
	  -0.00000000001,     0.00000000013,
	  -0.00000000040,     0.00000000013,
	   0.00000000002,     0.00000000006,
	   0.00000000009,     0.00000000053,
	   0.00000000008,    -0.00000000001,
	  -0.00000000026,     0.00000000006,
	   0.00000000001,     0.00000000004,
	   0.00000000030,     0.00000000125,
	   0.00000000019,    -0.00000000004,
	   0.00000000038,     0.00000000051,
	   0.00000000005,    -0.00000000004,
	   0.00000000080,    -0.00000000037,
	  -0.00000000004,    -0.00000000011,
	   0.00000000002,     0.00000000003,
	   0.00000000023,     0.00000000040,
	   0.00000000005,    -0.00000000003,
	   0.00000000180,    -0.00000000104,
	  -0.00000000011,    -0.00000000022,
	   0.00000000038,    -0.00000000062,
	  -0.00000000005,    -0.00000000002,
	  -0.00000000077,    -0.00000000093,
	  -0.00000000010,     0.00000000007,
	   0.00000000003,    -0.00000000004,
	   0.00000000045,    -0.00000000047,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000200,    -0.00000000189,
	  -0.00000000017,     0.00000000017,
	  -0.00000000050,     0.00000000005,
	  -0.00000000077,     0.00000000100,
	   0.00000000007,     0.00000000007,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000057,    -0.00000000028,
	  -0.00000000001,     0.00000000003,
	  -0.00000000114,     0.00000000231,
	   0.00000000013,     0.00000000006,
	   0.00000000047,    -0.00000000027,
	  -0.00000000004,    -0.00000000005,
	   0.00000000071,     0.00000000044,
	   0.00000000003,    -0.00000000004,
	  -0.00000000004,     0.00000000004,
	   0.00000000000,     0.00000000021,
	   0.00000000091,     0.00000000004,
	  -0.00000000110,    -0.00000000032,
	  -0.00000000002,     0.00000000003,
	   0.00000000026,    -0.00000000007,
	   0.00000000003,     0.00000000003,
	  -0.00000000043,    -0.00000000003,
	  -0.00000000010,     0.00000000135,
	   0.00000000009,     0.00000000046,
	   0.00000000005,    -0.00000000010,
	   0.00000000010,     0.00000000028,
	   0.00000000095,    -0.00000000030,
	  -0.00000000097,     0.00000000027,
	   0.00000000031,     0.00000000008,
	  -0.00000000056,     0.00000000031,
	  -0.00000000002,    -0.00000000003,
	   0.00000000081,     0.00000000152,
	  -0.00000000008,     0.00000000005,
	  -0.00000000019,    -0.00000000003,
	  -0.00000000059,     0.00000000038,
	  -0.00000000003,    -0.00000000004,
	  -0.00000000032,    -0.00000000036,
	   0.00000000003,    -0.00000000003,
	  -0.00000000082,     0.00000000074,
	  -0.00000000006,    -0.00000000007,
	  -0.00000000048,     0.00000000015,
	  -0.00000000047,    -0.00000000068,
	   0.00000000004,    -0.00000000003,
	   0.00000000013,    -0.00000000020,
	   0.00000000002,     0.00000000001,
	  -0.00000000037,    -0.00000000025,
	   0.00000000003,    -0.00000000004,
	  -0.00000000027,    -0.00000000036,
	   0.00000000040,    -0.00000000039,
	   0.00000000004,     0.00000000003,
	   0.00000000008,     0.00000000003,
	   0.00000000004,    -0.00000000012,
	   0.00000000014,    -0.00000000018,
	   0.00000000021,     0.00000000014,
	   0.00000000000,     0.00000000003,
	   0.00000000008,     0.00000000003,
	  -0.00000000003,     0.00000000008,
	   0.00000000001,     0.00000000002,
	   0.00000000005,    -0.00000000002,
	  -0.00000000003,     0.00000000002,
	   0.00000000005,     0.00000000008,
	  -0.00000000004,     0.00000000003,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000006,     0.00000000006,
	  -0.00000000004,     0.00000000001,
	  -0.00000000004,    -0.00000000006,
	   0.00000000002,    -0.00000000002,
	  -0.00000000004,    -0.00000000003,
	  -0.00000000003,    -0.00000000004,
	   0.00000000005,    -0.00000000005,
	   0.00000000002,    -0.00000000003,
	   0.00000000004,     0.00000000002,
	  -0.00000000004,     0.00000000003,
	  -0.00000000002,     0.00000000003,
	   0.00000000004,     0.00000000003,
	  -0.00000000001,     0.00000000002,
	   0.00000000009,     0.00000000006,
	   0.00000000008,     0.00000000002,
	   0.00000000004,    -0.00000000009,
	   0.00000000004,     0.00000000001,
	   0.00000000007,    -0.00000000022,
	  -0.00000000005,    -0.00000000002,
	   0.00000000000,    -0.00000000015,
	  -0.00000000019,    -0.00000000002,
	   0.00000000000,    -0.00000000009,
	  -0.00000000044,    -0.00000000002,
	  -0.00000000001,     0.00000000008,
	  -0.00000000023,     0.00000000008,
	   0.00000000006,     0.00000000032,
	   0.00000000005,    -0.00000000001,
	  -0.00000000016,     0.00000000004,
	   0.00000000000,     0.00000000002,
	   0.00000000019,     0.00000000074,
	   0.00000000011,    -0.00000000002,
	   0.00000000021,     0.00000000026,
	   0.00000000003,    -0.00000000002,
	   0.00000000045,    -0.00000000021,
	  -0.00000000002,    -0.00000000006,
	   0.00000000013,     0.00000000023,
	   0.00000000003,    -0.00000000001,
	   0.00000000099,    -0.00000000059,
	  -0.00000000006,    -0.00000000012,
	   0.00000000014,    -0.00000000030,
	  -0.00000000039,    -0.00000000049,
	  -0.00000000005,     0.00000000003,
	   0.00000000022,    -0.00000000024,
	  -0.00000000002,    -0.00000000002,
	  -0.00000000101,    -0.00000000093,
	  -0.00000000008,     0.00000000008,
	  -0.00000000016,     0.00000000010,
	  -0.00000000037,     0.00000000046,
	   0.00000000003,     0.00000000003,
	  -0.00000000024,    -0.00000000011,
	  -0.00000000045,     0.00000000098,
	   0.00000000005,     0.00000000002,
	   0.00000000027,    -0.00000000026,
	  -0.00000000002,    -0.00000000003,
	   0.00000000026,     0.00000000020,
	   0.00000000002,     0.00000000002,
	   0.00000000012,    -0.00000000007,
	  -0.00000000053,    -0.00000000012,
	   0.00000000011,     0.00000000003,
	  -0.00000000024,    -0.00000000001,
	  -0.00000000003,     0.00000000078,
	   0.00000000005,     0.00000000005,
	   0.00000000003,     0.00000000005,
	   0.00000000022,    -0.00000000010,
	  -0.00000000051,     0.00000000013,
	   0.00000000015,     0.00000000000,
	  -0.00000000027,     0.00000000015,
	  -0.00000000001,    -0.00000000002,
	   0.00000000041,     0.00000000074,
	  -0.00000000004,     0.00000000002,
	  -0.00000000014,    -0.00000000014,
	  -0.00000000024,     0.00000000020,
	  -0.00000000019,    -0.00000000022,
	   0.00000000002,    -0.00000000002,
	  -0.00000000050,     0.00000000045,
	  -0.00000000004,    -0.00000000004,
	  -0.00000000021,     0.00000000004,
	  -0.00000000027,    -0.00000000036,
	   0.00000000009,    -0.00000000014,
	   0.00000000002,     0.00000000001,
	  -0.00000000027,    -0.00000000018,
	   0.00000000002,    -0.00000000003,
	  -0.00000000015,    -0.00000000021,
	   0.00000000024,    -0.00000000025,
	   0.00000000007,     0.00000000002,
	   0.00000000004,    -0.00000000011,
	   0.00000000010,    -0.00000000013,
	   0.00000000016,     0.00000000010,
	   0.00000000000,     0.00000000002,
	   0.00000000006,     0.00000000003,
	  -0.00000000003,     0.00000000007,
	  -0.00000000001,     0.00000000001,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000003,     0.00000000003,
	  -0.00000000001,     0.00000000001,
	   0.00000000006,     0.00000000004,
	   0.00000000005,     0.00000000001,
	   0.00000000002,    -0.00000000006,
	   0.00000000003,     0.00000000001,
	   0.00000000005,    -0.00000000014,
	  -0.00000000001,    -0.00000000009,
	  -0.00000000012,    -0.00000000001,
	   0.00000000000,    -0.00000000006,
	  -0.00000000027,    -0.00000000001,
	   0.00000000000,     0.00000000005,
	  -0.00000000013,     0.00000000005,
	   0.00000000003,     0.00000000019,
	  -0.00000000010,     0.00000000003,
	   0.00000000011,     0.00000000043,
	   0.00000000006,    -0.00000000001,
	   0.00000000012,     0.00000000012,
	   0.00000000025,    -0.00000000011,
	   0.00000000008,     0.00000000013,
	   0.00000000002,    -0.00000000001,
	   0.00000000052,    -0.00000000032,
	  -0.00000000003,    -0.00000000006,
	   0.00000000004,    -0.00000000014,
	  -0.00000000020,    -0.00000000025,
	   0.00000000011,    -0.00000000012,
	  -0.00000000001,    -0.00000000001,
	  -0.00000000049,    -0.00000000043,
	  -0.00000000004,     0.00000000004,
	  -0.00000000003,     0.00000000009,
	  -0.00000000017,     0.00000000020,
	  -0.00000000010,    -0.00000000004,
	  -0.00000000015,     0.00000000038,
	   0.00000000014,    -0.00000000018,
	   0.00000000008,     0.00000000008,
	   0.00000000002,    -0.00000000003,
	  -0.00000000009,    -0.00000000007,
	  -0.00000000023,    -0.00000000004,
	   0.00000000004,     0.00000000004,
	  -0.00000000012,     0.00000000000,
	   0.00000000000,     0.00000000040,
	   0.00000000002,    -0.00000000006,
	   0.00000000001,    -0.00000000002,
	  -0.00000000024,     0.00000000006,
	   0.00000000006,    -0.00000000002,
	  -0.00000000012,     0.00000000007,
	   0.00000000019,     0.00000000034,
	  -0.00000000009,    -0.00000000013,
	  -0.00000000009,     0.00000000010,
	  -0.00000000011,    -0.00000000012,
	   0.00000000001,    -0.00000000001,
	  -0.00000000029,     0.00000000026,
	  -0.00000000008,     0.00000000000,
	  -0.00000000015,    -0.00000000017,
	   0.00000000006,    -0.00000000009,
	  -0.00000000019,    -0.00000000012,
	  -0.00000000008,    -0.00000000012,
	   0.00000000014,    -0.00000000015,
	   0.00000000005,     0.00000000002,
	   0.00000000003,    -0.00000000009,
	   0.00000000007,    -0.00000000008,
	   0.00000000011,     0.00000000007,
	   0.00000000000,     0.00000000002,
	   0.00000000005,     0.00000000002,
	  -0.00000000002,     0.00000000006,
	   0.00000000004,     0.00000000003,
	   0.00000000001,    -0.00000000004,
	   0.00000000002,     0.00000000001,
	   0.00000000003,    -0.00000000009,
	   0.00000000000,    -0.00000000005,
	  -0.00000000007,    -0.00000000001,
	   0.00000000000,    -0.00000000004,
	  -0.00000000017,     0.00000000000,
	  -0.00000000007,     0.00000000003,
	   0.00000000002,     0.00000000011,
	  -0.00000000006,     0.00000000002,
	   0.00000000007,     0.00000000024,
	   0.00000000006,     0.00000000005,
	   0.00000000014,    -0.00000000006,
	   0.00000000004,     0.00000000007,
	   0.00000000027,    -0.00000000017,
	  -0.00000000002,    -0.00000000003,
	   0.00000000000,    -0.00000000006,
	  -0.00000000009,    -0.00000000012,
	   0.00000000005,    -0.00000000006,
	  -0.00000000023,    -0.00000000019,
	   0.00000000001,     0.00000000006,
	  -0.00000000008,     0.00000000008,
	  -0.00000000003,    -0.00000000001,
	  -0.00000000004,     0.00000000013,
	   0.00000000007,    -0.00000000011,
	   0.00000000002,     0.00000000003,
	   0.00000000001,    -0.00000000003,
	  -0.00000000010,    -0.00000000005,
	  -0.00000000009,    -0.00000000001,
	  -0.00000000005,     0.00000000000,
	   0.00000000000,     0.00000000018,
	   0.00000000001,    -0.00000000007,
	   0.00000000000,    -0.00000000003,
	  -0.00000000007,     0.00000000001,
	  -0.00000000010,     0.00000000003,
	  -0.00000000005,     0.00000000003,
	   0.00000000008,     0.00000000014,
	  -0.00000000006,    -0.00000000009,
	  -0.00000000003,     0.00000000005,
	  -0.00000000006,    -0.00000000006,
	  -0.00000000016,     0.00000000014,
	  -0.00000000008,    -0.00000000008,
	   0.00000000004,    -0.00000000006,
	  -0.00000000012,    -0.00000000008,
	  -0.00000000004,    -0.00000000006,
	   0.00000000008,    -0.00000000009,
	   0.00000000003,     0.00000000001,
	   0.00000000002,    -0.00000000006,
	   0.00000000004,    -0.00000000005,
	   0.00000000007,     0.00000000004,
	  -0.00000000001,     0.00000000004,
	   0.00000000002,    -0.00000000006,
	   0.00000000000,    -0.00000000002,
	  -0.00000000010,     0.00000000000,
	  -0.00000000003,     0.00000000002,
	   0.00000000001,     0.00000000006,
	  -0.00000000003,     0.00000000001,
	   0.00000000004,     0.00000000013,
	   0.00000000003,     0.00000000002,
	   0.00000000007,    -0.00000000003,
	   0.00000000002,     0.00000000003,
	   0.00000000013,    -0.00000000009,
	  -0.00000000004,    -0.00000000006,
	   0.00000000002,    -0.00000000003,
	  -0.00000000010,    -0.00000000008,
	   0.00000000002,     0.00000000004,
	  -0.00000000003,     0.00000000003,
	   0.00000000003,    -0.00000000006,
	   0.00000000001,    -0.00000000002,
	  -0.00000000008,    -0.00000000003,
	  -0.00000000002,     0.00000000000,
	   0.00000000000,     0.00000000007,
	   0.00000000000,    -0.00000000005,
	   0.00000000000,    -0.00000000002,
	  -0.00000000006,     0.00000000001,
	  -0.00000000001,     0.00000000001,
	   0.00000000003,     0.00000000005,
	  -0.00000000003,    -0.00000000005,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000008,     0.00000000008,
	  -0.00000000004,    -0.00000000003,
	   0.00000000002,    -0.00000000003,
	  -0.00000000007,    -0.00000000005,
	   0.00000000004,    -0.00000000005,
	   0.00000000002,     0.00000000001,
	   0.00000000002,    -0.00000000004,
	   0.00000000002,    -0.00000000003,
	   0.00000000005,     0.00000000003,
	  -0.00000000006,     0.00000000000,
	  -0.00000000002,     0.00000000001,
	   0.00000000002,     0.00000000007,
	   0.00000000004,    -0.00000000002,
	   0.00000000001,     0.00000000002,
	   0.00000000006,    -0.00000000004,
	  -0.00000000004,    -0.00000000003,
	  -0.00000000004,    -0.00000000001,
	  -0.00000000001,    -0.00000000002,
	  -0.00000000004,     0.00000000004,
	   0.00000000001,    -0.00000000002,
	  -0.00000000004,    -0.00000000003,
	   0.00000000002,     0.00000000001,
	   0.00000000003,    -0.00000000002,
	  -0.00000090259,     0.00000024787,
	  -0.00000001030,    -0.00000002831,
	   0.00000000040,    -0.00000000012,
	  -0.00000071575,     0.00000002818,
	  -0.00000000252,    -0.00000000265,
	   0.00000000009,     0.00000000001,
	   0.00000002641,    -0.00000066591,
	  -0.00000000237,     0.00000000059,
	   0.00000000146,     0.00000001219,
	   0.00000000064,     0.00000000088,
	   0.00000000002,    -0.00000000007,
	  -0.00000006714,    -0.00000000406,
	   0.00000000009,    -0.00000000043,
	   0.00000000005,    -0.00000000004,
	   0.00000001200,    -0.00000004702,
	  -0.00000000037,     0.00000000081,
	   0.00000013481,    -0.00000015004,
	   0.00000000555,     0.00000001500,
	  -0.00000000083,     0.00000000000,
	  -0.00000252407,     0.00000001767,
	   0.00000000306,     0.00000000547,
	   0.00000000050,    -0.00000000020,
	   0.00000001787,    -0.00000246150,
	   0.00000000546,    -0.00000000241,
	  -0.00000000022,    -0.00000000051,
	  -0.00000000309,     0.00000000241,
	   0.00000000026,    -0.00000000119,
	   0.00000000304,     0.00000000105,
	   0.00000000097,     0.00000000015,
	   0.00000003900,     0.00000003996,
	  -0.00000000256,    -0.00000000174,
	   0.00000483421,    -0.00000000660,
	  -0.00000000123,    -0.00000000251,
	  -0.00000000645,     0.00000480730,
	  -0.00000000188,     0.00000000092,
	   0.00000000227,    -0.00000000081,
	  -0.00000000008,     0.00000000084,
	  -0.00000000063,    -0.00000000332,
	  -0.00000000081,     0.00000000006,
	  -0.00000028112,    -0.00000063967,
	   0.00000004679,    -0.00000002861,
	   0.00000000119,     0.00000000187,
	   0.00000535145,     0.00000000430,
	  -0.00000000051,    -0.00000000046,
	  -0.00000000027,     0.00000535053,
	  -0.00000000025,    -0.00000000048,
	   0.00000000164,    -0.00000000855,
	  -0.00000000049,    -0.00000000074,
	  -0.00000000051,     0.00000000352,
	   0.00000000044,    -0.00000000042,
	   0.00000017738,    -0.00000069321,
	   0.00000003192,    -0.00000001656,
	   0.00000000097,     0.00000000099,
	   0.00000982940,    -0.00000000570,
	  -0.00000000118,    -0.00000000100,
	  -0.00000000035,     0.00000982483,
	  -0.00000000412,    -0.00000000817,
	  -0.00000000105,    -0.00000000209,
	  -0.00000001322,     0.00000001297,
	   0.00000110891,     0.00000005831,
	  -0.00000007438,     0.00000010486,
	  -0.00000000444,    -0.00000000371,
	   0.00001331586,    -0.00000001394,
	   0.00000000215,     0.00000000014,
	   0.00000000669,     0.00001332016,
	   0.00000000040,     0.00000000310,
	   0.00000000092,     0.00000000048,
	  -0.00000001151,    -0.00000000661,
	   0.00000000019,     0.00000000110,
	  -0.00000007255,    -0.00000000931,
	   0.00000015958,     0.00000130188,
	  -0.00000002125,    -0.00000000515,
	   0.00001890430,    -0.00000000373,
	  -0.00000000028,    -0.00000000171,
	  -0.00000000444,     0.00001888635,
	  -0.00000000076,     0.00000000078,
	   0.00000000432,     0.00000001944,
	   0.00000000129,    -0.00000000033,
	  -0.00000000053,    -0.00000000239,
	   0.00000023768,    -0.00000021313,
	   0.00000000271,    -0.00000000032,
	   0.00002367415,    -0.00000003166,
	  -0.00000000218,    -0.00000000137,
	   0.00000000388,     0.00002367379,
	  -0.00000000024,     0.00000000077,
	  -0.00000000243,    -0.00000000246,
	  -0.00000000271,    -0.00000000274,
	  -0.00000000306,     0.00000000260,
	  -0.00000000016,    -0.00000000025,
	   0.00000003290,     0.00000003965,
	  -0.00000000324,     0.00000000207,
	  -0.00000000002,    -0.00000000003,
	   0.00000001563,     0.00000004960,
	  -0.00000000167,     0.00000000071,
	  -0.00000004978,     0.00000001258,
	  -0.00000000044,    -0.00000000148,
	   0.00000001111,     0.00000000476,
	  -0.00000000016,    -0.00000000028,
	  -0.00000000432,     0.00000001407,
	   0.00000000012,    -0.00000000020,
	   0.00000000052,    -0.00000000043,
	  -0.00000000361,    -0.00000000417,
	   0.00000000033,    -0.00000000017,
	  -0.00000000092,    -0.00000000394,
	   0.00000000392,    -0.00000000083,
	   0.00000000174,     0.00000000090,
	  -0.00000000092,     0.00000000161,
	   0.00000000004,    -0.00000000004,
	  -0.00000000011,    -0.00000000007,
	   0.00000000016,    -0.00000000008,
	  -0.00000000001,     0.00000000001,
	  -0.00000000034,    -0.00000000173,
	   0.00000000017,     0.00000000010,
	   0.00000000029,    -0.00000000095,
	   0.00000000005,     0.00000000007,
	   0.00000000085,     0.00000000042,
	  -0.00000000007,     0.00000000003,
	   0.00000000017,    -0.00000000146,
	   0.00000000003,     0.00000000004,
	   0.00000000157,     0.00000000009,
	  -0.00000000003,     0.00000000004,
	  -0.00000000017,     0.00000000074,
	  -0.00000000074,    -0.00000000017,
	  -0.00000000005,     0.00000000007,
	   0.00000000001,    -0.00000000005,
	  -0.00000000002,     0.00000000003,
	  -0.00000000004,    -0.00000000003,
	   0.00000000334,    -0.00000000478,
	   0.00000000184,     0.00000000105,
	  -0.00000001103,     0.00000001607,
	  -0.00000000658,    -0.00000000391,
	   0.00000000107,     0.00000000074,
	  -0.00000000026,     0.00000000045,
	   0.00000006835,    -0.00000010030,
	   0.00000004093,     0.00000002369,
	   0.00000000072,     0.00000000112,
	  -0.00000000041,     0.00000000032,
	  -0.00000000110,     0.00000000034,
	  -0.00000000038,     0.00000000019,
	   0.00000000198,    -0.00000000086,
	   0.00000000041,     0.00000000061,
	   0.00000000082,     0.00000000004,
	  -0.00000000027,     0.00000000032,
	   0.00000000055,    -0.00000000133,
	  -0.00000000131,    -0.00000000053,
	  -0.00000000025,     0.00000000048,
	   0.00000000049,     0.00000000026,
	  -0.00000000054,     0.00000000130,
	   0.00000000129,     0.00000000054,
	  -0.00000000033,    -0.00000000018,
	   0.00000000034,     0.00000000022,
	   0.00000000020,    -0.00000000041,
	  -0.00000000368,    -0.00000000169,
	   0.00000000023,    -0.00000000026,
	   0.00000001953,     0.00000000737,
	  -0.00000000148,     0.00000000177,
	   0.00000000715,    -0.00000001928,
	   0.00000000173,     0.00000000142,
	  -0.00000000502,    -0.00000000086,
	  -0.00000000095,     0.00000000514,
	  -0.00000000069,     0.00000000166,
	   0.00000000263,     0.00000000119,
	  -0.00000000072,    -0.00000000016,
	  -0.00000001817,    -0.00000000763,
	   0.00000000136,    -0.00000000196,
	  -0.00000000758,     0.00000001810,
	  -0.00000000195,    -0.00000000134,
	   0.00000000343,     0.00000000059,
	   0.00000000065,    -0.00000000351,
	   0.00000000052,     0.00000000095,
	   0.00000000790,     0.00000000498,
	  -0.00000000052,     0.00000000113,
	  -0.00000000015,    -0.00000000005,
	   0.00000002503,    -0.00000005489,
	   0.00000000804,     0.00000000433,
	  -0.00000000032,     0.00000000088,
	   0.00000000224,     0.00000023510,
	   0.00000002013,    -0.00000000638,
	  -0.00000000040,    -0.00000000088,
	   0.00000023134,    -0.00000000381,
	  -0.00000000616,    -0.00000002042,
	  -0.00000000090,     0.00000000042,
	   0.00000002221,    -0.00000009611,
	   0.00000000838,     0.00000000153,
	  -0.00000009809,    -0.00000002372,
	   0.00000000186,    -0.00000000874,
	   0.00000000039,     0.00000000011,
	  -0.00000002705,    -0.00000001190,
	   0.00000000196,    -0.00000000280,
	   0.00000000043,     0.00000000011,
	  -0.00000001674,     0.00000003822,
	  -0.00000000549,    -0.00000000304,
	   0.00000000021,    -0.00000000060,
	   0.00000000857,    -0.00000015189,
	  -0.00000001477,     0.00000000357,
	   0.00000000027,     0.00000000065,
	  -0.00000015081,    -0.00000000821,
	   0.00000000350,     0.00000001485,
	   0.00000000064,    -0.00000000027,
	  -0.00000001524,     0.00000006575,
	  -0.00000000575,    -0.00000000106,
	   0.00000006699,     0.00000001613,
	  -0.00000000126,     0.00000000596,
	   0.00000000000,     0.00000000061,
	   0.00000000102,     0.00000000001,
	  -0.00000000003,     0.00000000207,
	   0.00000000079,     0.00000000171,
	  -0.00000000050,    -0.00000000108,
	   0.00000000028,     0.00000000062,
	   0.00000000011,     0.00000000000,
	   0.00000000009,     0.00000000000,
	   0.00000000000,    -0.00000000008,
	  -0.00000007038,     0.00000004731,
	   0.00000001625,     0.00000000237,
	  -0.00000000015,    -0.00000000081,
	   0.00000018950,    -0.00000043606,
	  -0.00000002754,     0.00000005927,
	   0.00000000290,    -0.00000000012,
	  -0.00001705724,    -0.00000003294,
	   0.00000000765,    -0.00000001009,
	   0.00000000119,     0.00000000080,
	   0.00000003965,     0.00001690123,
	   0.00000001346,     0.00000000482,
	  -0.00000000010,     0.00000000119,
	  -0.00000003934,    -0.00000000848,
	   0.00000000221,     0.00000000492,
	   0.00000000626,     0.00000000166,
	   0.00000000374,    -0.00000000129,
	   0.00000008520,    -0.00000029880,
	  -0.00000004136,     0.00000000355,
	   0.00000000061,     0.00000000194,
	  -0.00000012498,     0.00000031722,
	   0.00000002246,    -0.00000004963,
	  -0.00000000220,     0.00000000022,
	   0.00000823038,     0.00000000268,
	  -0.00000000267,     0.00000000168,
	  -0.00000000770,    -0.00000819544,
	  -0.00000000180,    -0.00000000025,
	   0.00000002823,     0.00000000570,
	  -0.00000000144,    -0.00000000340,
	  -0.00000000217,    -0.00000000081,
	  -0.00000000302,     0.00000000078,
	   0.00000000029,    -0.00000000057,
	  -0.00000000002,    -0.00000000101,
	   0.00000000045,     0.00000000023,
	  -0.00000000023,     0.00000000045,
	   0.00000177364,    -0.00000000058,
	  -0.00000000033,    -0.00000000001,
	  -0.00000000519,    -0.00001974219,
	  -0.00000000034,     0.00000000477,
	   0.00000003128,     0.00000010015,
	   0.00000000641,    -0.00000000193,
	  -0.00000000024,    -0.00000000075,
	  -0.00000012222,    -0.00000002241,
	   0.00000000457,     0.00000001086,
	  -0.00000000403,     0.00000044543,
	  -0.00000000157,    -0.00000000797,
	   0.00000000002,    -0.00000000167,
	  -0.00000001760,    -0.00000010540,
	   0.00000000031,    -0.00000003895,
	   0.00000760929,     0.00000000055,
	   0.00000000036,    -0.00000000061,
	   0.00000000357,     0.00001664099,
	   0.00000000042,    -0.00000000328,
	  -0.00000001591,    -0.00000018965,
	   0.00000000286,     0.00000000621,
	  -0.00000000001,     0.00000000065,
	  -0.00000000604,    -0.00000002016,
	  -0.00000000058,    -0.00000001257,
	   0.00000001288,    -0.00000023794,
	   0.00000000481,     0.00000000428,
	  -0.00000000005,     0.00000000089,
	   0.00000005480,     0.00000005629,
	  -0.00000000096,     0.00000002080,
	   0.00000004787,    -0.00000000004,
	  -0.00000000008,     0.00000000068,
	   0.00000000049,     0.00000000030,
	  -0.00000000238,     0.00000000107,
	   0.00000000813,    -0.00000000382,
	  -0.00000000067,    -0.00000000125,
	   0.00000000364,     0.00000000794,
	   0.00000000120,    -0.00000000061,
	  -0.00000000246,     0.00000000044,
	  -0.00000000049,    -0.00000000252,
	  -0.00000000017,    -0.00000000040,
	   0.00000000174,    -0.00000000077,
	  -0.00000000067,     0.00000000020,
	  -0.00000000795,     0.00000000385,
	   0.00000000064,     0.00000000127,
	  -0.00000000380,    -0.00000000788,
	  -0.00000000125,     0.00000000062,
	   0.00000000177,    -0.00000000030,
	   0.00000000033,     0.00000000181,
	   0.00000000208,     0.00000000095,
	   0.00000000023,    -0.00000000057,
	  -0.00000000006,    -0.00000000080,
	  -0.00000000080,     0.00000000006,
	   0.00000000051,    -0.00000000004,
	   0.00000000024,     0.00000000056,
	  -0.00000000054,     0.00000000023,
	  -0.00000000021,    -0.00000000033,
	   0.00000000034,    -0.00000000022,
	  -0.00000000024,    -0.00000000058,
	   0.00000000057,    -0.00000000024,
	   0.00000000035,     0.00000000048,
	   0.00000000039,     0.00000000018,
	   0.00000000079,     0.00000000027,
	   0.00000000021,    -0.00000000061,
	  -0.00000000656,    -0.00000000221,
	  -0.00000000190,     0.00000000499,
	  -0.00000000056,     0.00000000068,
	   0.00000000026,     0.00000000021,
	  -0.00000000054,     0.00000000240,
	   0.00000000072,     0.00000000018,
	   0.00000000240,     0.00000000054,
	   0.00000000018,    -0.00000000072,
	  -0.00000000064,    -0.00000000245,
	  -0.00000000057,     0.00000000012,
	  -0.00000000246,     0.00000000064,
	   0.00000000011,     0.00000000057,
	  -0.00000000151,     0.00000000641,
	   0.00000000193,     0.00000000047,
	   0.00000000009,    -0.00000000029,
	   0.00000000102,     0.00000000023,
	   0.00000000400,     0.00000001706,
	   0.00000000388,    -0.00000000081,
	  -0.00000000007,    -0.00000000045,
	   0.00000001709,    -0.00000000399,
	  -0.00000000081,    -0.00000000389,
	  -0.00000000045,     0.00000000007,
	  -0.00000000039,     0.00000000046,
	   0.00000000046,     0.00000000036,
	  -0.00000000007,    -0.00000000063,
	   0.00000000139,    -0.00000000003,
	  -0.00000001607,    -0.00000001903,
	  -0.00000000304,     0.00000000225,
	  -0.00000001914,     0.00000001602,
	   0.00000000224,     0.00000000307,
	   0.00000000020,    -0.00000000069,
	  -0.00000000066,    -0.00000000014,
	   0.00000001128,     0.00000005326,
	   0.00000001193,    -0.00000000251,
	  -0.00000000023,    -0.00000000138,
	  -0.00000000365,    -0.00000000075,
	   0.00000000015,     0.00000000059,
	   0.00000008336,     0.00000010501,
	   0.00000001582,    -0.00000001220,
	  -0.00000000089,    -0.00000000125,
	   0.00000010532,    -0.00000008342,
	  -0.00000001218,    -0.00000001591,
	  -0.00000000126,     0.00000000088,
	  -0.00000000106,     0.00000000359,
	   0.00000000348,     0.00000000082,
	  -0.00000000032,     0.00000000029,
	   0.00000000012,     0.00000000011,
	   0.00000000008,     0.00000000004,
	   0.00000000003,    -0.00000000007,
	   0.00000002793,     0.00000004248,
	   0.00000000537,    -0.00000000469,
	  -0.00000000035,    -0.00000000039,
	   0.00000488028,    -0.00000321911,
	  -0.00000054001,    -0.00000062030,
	  -0.00000004496,     0.00000003989,
	   0.00000151234,     0.00000069449,
	   0.00000006029,    -0.00000011089,
	  -0.00000000438,    -0.00000000230,
	   0.00000070632,    -0.00000151403,
	  -0.00000011157,    -0.00000006297,
	  -0.00000000265,     0.00000000441,
	   0.00000000143,     0.00000002341,
	  -0.00000000128,     0.00000000139,
	   0.00000001988,    -0.00000000443,
	   0.00000000109,     0.00000000145,
	  -0.00000078253,    -0.00000124810,
	  -0.00000015107,     0.00000013638,
	   0.00000001012,     0.00000001064,
	  -0.00002549814,     0.00001681596,
	   0.00000282143,     0.00000324010,
	   0.00000023495,    -0.00000020825,
	  -0.00000001020,    -0.00000001140,
	  -0.00000248561,    -0.00000135751,
	  -0.00000005980,     0.00000018540,
	   0.00000000669,     0.00000000151,
	  -0.00000139206,     0.00000250339,
	   0.00000018697,     0.00000006899,
	   0.00000000265,    -0.00000000672,
	  -0.00000000729,    -0.00000012194,
	   0.00000000669,    -0.00000000763,
	  -0.00000000014,     0.00000000034,
	  -0.00000010621,     0.00000001996,
	  -0.00000000616,    -0.00000000740,
	   0.00000000990,     0.00000000552,
	   0.00000000025,    -0.00000000074,
	   0.00000005623,    -0.00000010407,
	  -0.00000000771,    -0.00000000289,
	   0.00000025350,    -0.00000000153,
	  -0.00000000033,     0.00000000017,
	   0.00000000162,    -0.00000025594,
	  -0.00000000039,     0.00000000078,
	   0.00000130003,     0.00000055313,
	   0.00000006130,    -0.00000009486,
	  -0.00000000387,    -0.00000000259,
	  -0.00000031943,     0.00000060623,
	   0.00000004493,     0.00000001830,
	   0.00000000066,    -0.00000000166,
	   0.00000253235,     0.00000001090,
	   0.00000000026,    -0.00000000095,
	  -0.00000000581,    -0.00000251558,
	   0.00000000116,     0.00000000296,
	   0.00000000083,    -0.00000000215,
	   0.00000000212,     0.00000000021,
	   0.00000001579,    -0.00000000003,
	  -0.00000000019,    -0.00000012234,
	  -0.00000000916,    -0.00000000109,
	  -0.00000000041,     0.00000000015,
	   0.00000000402,    -0.00000000194,
	  -0.00000000066,    -0.00000000005,
	   0.00000000000,     0.00000000134,
	   0.00001412662,     0.00000000661,
	  -0.00000000139,    -0.00000000020,
	  -0.00000000053,     0.00000651923,
	  -0.00000019996,     0.00000019102,
	  -0.00000000846,    -0.00000003134,
	   0.00000000057,    -0.00000000079,
	   0.00000009043,     0.00000042967,
	  -0.00000001460,     0.00000001878,
	  -0.00000000035,    -0.00000000125,
	  -0.00000000845,     0.00000003197,
	   0.00000000281,     0.00000000129,
	   0.00000003853,     0.00000000714,
	   0.00000000159,    -0.00000000235,
	  -0.00000000088,    -0.00000000056,
	  -0.00000000285,     0.00000000130,
	  -0.00000000134,    -0.00000000283,
	  -0.00000000260,     0.00000000539,
	  -0.00000000062,    -0.00000000080,
	   0.00000001011,     0.00000000450,
	  -0.00000000150,     0.00000000119,
	  -0.00000004118,     0.00000001770,
	  -0.00000000191,    -0.00000000299,
	  -0.00000001765,    -0.00000004130,
	   0.00000000297,    -0.00000000190,
	  -0.00000000400,     0.00000001783,
	   0.00000000131,     0.00000000072,
	  -0.00000001787,    -0.00000000396,
	  -0.00000000072,     0.00000000131,
	  -0.00000000026,     0.00000000034,
	  -0.00000000034,    -0.00000000025,
	   0.00000000093,    -0.00000000005,
	   0.00000000034,    -0.00000000055,
	   0.00000000059,     0.00000000032,
	   0.00000000098,    -0.00000000131,
	  -0.00000000131,    -0.00000000098,
	  -0.00000000015,    -0.00000000085,
	   0.00000001257,    -0.00000001047,
	  -0.00000000004,    -0.00000000248,
	  -0.00000001048,    -0.00000001257,
	  -0.00000000248,     0.00000000004,
	   0.00000000088,    -0.00000000083,
	  -0.00000000083,    -0.00000000088,
	   0.00000000154,     0.00000000019,
	   0.00000000003,    -0.00000000018,
	   0.00000000050,    -0.00000000822,
	  -0.00000000104,    -0.00000000016,
	   0.00000013448,    -0.00000006702,
	   0.00000000323,    -0.00000001475,
	  -0.00000000068,    -0.00000000049,
	  -0.00000006714,    -0.00000013446,
	  -0.00000001478,    -0.00000000322,
	  -0.00000000049,     0.00000000068,
	  -0.00000000047,     0.00000000208,
	   0.00000000203,     0.00000000045,
	   0.00000000909,    -0.00000000853,
	   0.00000001620,    -0.00000000890,
	   0.00000000030,    -0.00000000148,
	  -0.00000000890,    -0.00000001620,
	  -0.00000000148,    -0.00000000030,
	   0.00000000033,    -0.00000000097,
	   0.00000001239,     0.00000000443,
	   0.00000000002,    -0.00000000104,
	   0.00000001851,    -0.00000006633,
	  -0.00000000582,    -0.00000000028,
	   0.00000114984,    -0.00000027045,
	   0.00000002529,    -0.00000005335,
	  -0.00000000170,    -0.00000000168,
	  -0.00000027177,    -0.00000115027,
	  -0.00000005363,    -0.00000002529,
	  -0.00000000170,     0.00000000167,
	  -0.00000000358,     0.00000000749,
	  -0.00000000067,    -0.00000000007,
	   0.00000000702,     0.00000000331,
	  -0.00000000009,     0.00000000066,
	   0.00000000043,     0.00000000060,
	   0.00000000064,    -0.00000000044,
	   0.00000018238,    -0.00000009998,
	   0.00000000467,    -0.00000002032,
	   0.00000000190,     0.00000000357,
	   0.00000026546,    -0.00000006808,
	   0.00000000621,    -0.00000001220,
	  -0.00000006797,    -0.00000026534,
	  -0.00000001218,    -0.00000000622,
	   0.00000000017,    -0.00000000051,
	  -0.00000000051,    -0.00000000016,
	  -0.00000000058,    -0.00000000211,
	   0.00000000043,    -0.00000000046,
	  -0.00000000046,    -0.00000000043,
	   0.00000000305,     0.00000001102,
	  -0.00000000078,     0.00000000073,
	   0.00000000074,     0.00000000079,
	   0.00000000020,    -0.00000000062,
	  -0.00000000061,    -0.00000000020,
	   0.00000000056,    -0.00000000172,
	   0.00000000079,     0.00000000026,
	   0.00000000021,     0.00000000032,
	   0.00000000033,    -0.00000000023,
	   0.00000007295,     0.00000003944,
	  -0.00000000224,    -0.00000000480,
	  -0.00000000009,     0.00000000012,
	   0.00000017410,    -0.00000040149,
	  -0.00000002537,     0.00000000940,
	   0.00000000050,     0.00000000050,
	   0.00000646057,     0.00000000052,
	  -0.00000000309,     0.00000000048,
	   0.00000000002,    -0.00000000064,
	  -0.00000001014,    -0.00000647289,
	  -0.00000000156,     0.00000000241,
	  -0.00000000067,     0.00000000000,
	  -0.00000000008,     0.00000000244,
	  -0.00000000065,    -0.00000000223,
	   0.00000353237,    -0.00000090393,
	   0.00000008354,    -0.00000016245,
	  -0.00000000518,    -0.00000000530,
	   0.00000005279,     0.00000020746,
	   0.00000000955,     0.00000000491,
	   0.00000359990,    -0.00000000199,
	  -0.00000000117,    -0.00000000033,
	   0.00000000005,    -0.00000359617,
	   0.00000000001,     0.00000000124,
	   0.00000000114,     0.00000000130,
	   0.00000000131,    -0.00000000114,
	   0.00000003654,    -0.00000000518,
	   0.00000013191,    -0.00000003359,
	   0.00000031599,    -0.00000008104,
	  -0.00000000080,     0.00000000008,
	   0.00000000063,     0.00000000098,
	   0.00000000096,    -0.00000000064,
	   0.00000000107,     0.00000000163,
	   0.00000000021,    -0.00000000018,
	   0.00000000209,    -0.00000000137,
	   0.00000000120,     0.00000000001,
	   0.00000000139,    -0.00000000098,
	  -0.00000000033,    -0.00000000050,
	  -0.00000000098,    -0.00000000139,
	  -0.00000000050,     0.00000000033,
	  -0.00000000102,    -0.00000000016,
	  -0.00000000016,     0.00000000102,
	   0.00000000058,     0.00000000012,
	   0.00000000012,    -0.00000000059,
	   0.00000000097,     0.00000000025,
	   0.00000000025,    -0.00000000097,
	   0.00000003520,     0.00000000924,
	  -0.00000000049,     0.00000000191,
	   0.00000000099,    -0.00000000025,
	  -0.00000000025,    -0.00000000099,
	   0.00000002995,     0.00000000113,
	   0.00000000101,    -0.00000000026,
	   0.00000000026,     0.00000000101,
	   0.00000020642,    -0.00000000221,
	  -0.00000001032,    -0.00000131647,
	  -0.00000024054,    -0.00000001331,
	  -0.00000000570,    -0.00000000168,
	  -0.00000006121,     0.00000004030,
	  -0.00000001096,     0.00000000116,
	  -0.00000000057,     0.00000001428,
	  -0.00000000136,    -0.00000000712,
	   0.00000000001,    -0.00000000136,
	   0.00007170005,    -0.00000001946,
	  -0.00000000715,    -0.00000000317,
	   0.00000000254,     0.00001277074,
	  -0.00000016184,    -0.00000008266,
	  -0.00000000383,    -0.00000001487,
	  -0.00000004124,     0.00000032382,
	  -0.00000000742,     0.00000000768,
	   0.00000003069,     0.00000006087,
	   0.00000000586,    -0.00000000058,
	   0.00000006085,    -0.00000003065,
	  -0.00000000058,    -0.00000000586,
	   0.00000080102,     0.00000002057,
	  -0.00000000063,     0.00000000397,
	  -0.00000000842,     0.00000000160,
	  -0.00000000051,    -0.00000000056,
	   0.00000000035,     0.00000000848,
	  -0.00000000056,     0.00000000051,
	   0.00000293427,    -0.00000000038,
	   0.00000000000,     0.00000000224,
	   0.00000000182,    -0.00000000001,
	   0.00000688153,    -0.00000000304,
	   0.00000000001,     0.00000000182,
	  -0.00000000022,    -0.00000000043,
	   0.00000000006,    -0.00000000053,
	   0.00000000929,    -0.00000000371,
	  -0.00000000131,    -0.00000000296,
	  -0.00000000372,    -0.00000000929,
	  -0.00000000296,     0.00000000132,
	   0.00000000195,    -0.00000000083,
	  -0.00000000083,    -0.00000000195,
	  -0.00000000362,    -0.00000000052,
	  -0.00000000043,     0.00000000354,
	  -0.00000000232,    -0.00000000038,
	  -0.00000000036,     0.00000000237,
	   0.00000000077,     0.00000000003,
	   0.00000000003,    -0.00000000077,
	   0.00000000125,     0.00000000002,
	   0.00000000002,    -0.00000000125,
	   0.00000000145,    -0.00000002977,
	   0.00000000762,     0.00000000121,
	   0.00000000121,    -0.00000000765,
	  -0.00000009296,    -0.00000001194,
	   0.00000001390,     0.00000000000,
	  -0.00000000001,    -0.00000001392,
	  -0.00000010240,     0.00000001360,
	   0.00000001541,     0.00000000000,
	   0.00000000000,     0.00000001545,
	   0.00000003426,    -0.00000003301,
	   0.00000001954,    -0.00000000002,
	  -0.00000000002,    -0.00000001954,
	   0.00000003079,     0.00000003366,
	   0.00000002078,    -0.00000000003,
	  -0.00000000001,     0.00000002076,
	   0.00000000044,     0.00000000016,
	   0.00000000063,    -0.00000000238,
	  -0.00000000081,    -0.00000000001,
	   0.00000003646,    -0.00000000437,
	  -0.00000000264,    -0.00000001061,
	  -0.00000000456,    -0.00000003654,
	  -0.00000001062,     0.00000000267,
	   0.00000001885,    -0.00000000802,
	  -0.00000000279,    -0.00000000600,
	   0.00000000044,     0.00000000102,
	   0.00000002000,    -0.00000000296,
	  -0.00000000160,    -0.00000000574,
	  -0.00000000291,    -0.00000001997,
	  -0.00000000574,     0.00000000160,
	   0.00000000035,     0.00000000214,
	   0.00000000214,    -0.00000000035,
	  -0.00000000793,     0.00000000115,
	   0.00000000117,     0.00000000146,
	   0.00000000115,     0.00000000793,
	   0.00000000146,    -0.00000000117,
	   0.00000000638,     0.00000004155,
	   0.00000001087,    -0.00000000958,
	  -0.00000002929,     0.00000000316,
	   0.00000000421,     0.00000000534,
	   0.00000000317,     0.00000002930,
	   0.00000000534,    -0.00000000421,
	   0.00000000029,    -0.00000000039,
	  -0.00000000179,    -0.00000000119,
	  -0.00000000321,    -0.00000005776,
	  -0.00000000554,     0.00000000385,
	  -0.00000005770,     0.00000000323,
	   0.00000000383,     0.00000000552,
	  -0.00000000063,    -0.00000000095,
	  -0.00000000095,     0.00000000063,
	  -0.00000062190,     0.00000006871,
	   0.00000009043,     0.00000011372,
	   0.00000000682,    -0.00000000960,
	  -0.00000000096,    -0.00000000895,
	  -0.00000000163,     0.00000000129,
	  -0.00000002133,    -0.00000039011,
	  -0.00000003681,     0.00000002575,
	   0.00000000130,     0.00000000153,
	  -0.00000039041,     0.00000002138,
	   0.00000002582,     0.00000003688,
	   0.00000000154,    -0.00000000130,
	   0.00000000700,     0.00000000464,
	   0.00000000183,     0.00000000124,
	  -0.00000000020,    -0.00000000010,
	   0.00000000410,    -0.00000000808,
	  -0.00000000038,     0.00000000103,
	   0.00000029010,    -0.00000000045,
	  -0.00000000050,    -0.00000028927,
	  -0.00000002512,    -0.00000000348,
	   0.00000000068,    -0.00000000438,
	  -0.00000000209,    -0.00000000002,
	   0.00000000002,     0.00000000200,
	  -0.00000055161,    -0.00000982542,
	  -0.00000092854,     0.00000065667,
	   0.00000003254,     0.00000003928,
	   0.00000035363,    -0.00000001923,
	  -0.00000002369,    -0.00000003341,
	  -0.00000000142,     0.00000000118,
	   0.00000459198,    -0.00000000318,
	   0.00000000492,     0.00000000060,
	  -0.00000000394,    -0.00000459906,
	  -0.00000000069,    -0.00000000389,
	   0.00000000104,    -0.00000000205,
	  -0.00000000205,    -0.00000000104,
	  -0.00000000153,    -0.00000003807,
	  -0.00000000682,    -0.00000008536,
	   0.00000000072,    -0.00000000031,
	   0.00000000192,    -0.00000001188,
	   0.00000000110,     0.00000000015,
	   0.00000000525,    -0.00000000008,
	  -0.00000000039,    -0.00000003295,
	   0.00000000072,    -0.00000000262,
	   0.00000000124,     0.00000000013,
	  -0.00000001321,    -0.00000000020,
	   0.00000000088,    -0.00000000019,
	   0.00000001014,     0.00000000019,
	  -0.00000000004,     0.00000000279,
	   0.00017342289,    -0.00000013377,
	   0.00000003360,    -0.00000000170,
	   0.00000001017,     0.00001756850,
	   0.00000000012,     0.00000000141,
	   0.00000001302,    -0.00000050282,
	   0.00000002368,     0.00000003357,
	  -0.00000000085,     0.00000000201,
	  -0.00000025148,    -0.00000002689,
	   0.00000001668,    -0.00000004753,
	   0.00000000100,     0.00000000169,
	   0.00000007053,     0.00000004051,
	   0.00000000259,    -0.00000000455,
	   0.00000004055,    -0.00000007055,
	  -0.00000000457,    -0.00000000259,
	   0.00000071936,     0.00000001767,
	  -0.00000000018,     0.00000000125,
	  -0.00000000027,    -0.00000000369,
	  -0.00000000366,     0.00000000075,
	   0.00000162402,    -0.00000000095,
	   0.00000000302,     0.00000000241,
	   0.00000000039,    -0.00000000079,
	  -0.00000001564,    -0.00000001114,
	  -0.00000000167,     0.00000000400,
	   0.00000000483,    -0.00000000001,
	  -0.00000000001,    -0.00000000483,
	   0.00000000548,    -0.00000000001,
	   0.00000000000,     0.00000000548,
	  -0.00000000157,    -0.00000000060,
	  -0.00000000060,     0.00000000157,
	   0.00000000173,     0.00000000017,
	   0.00000000017,    -0.00000000173,
	  -0.00000000130,    -0.00000000002,
	  -0.00000000002,     0.00000000129,
	  -0.00000006232,    -0.00000002357,
	   0.00000002686,     0.00000000669,
	   0.00000000669,    -0.00000002685,
	   0.00000008326,     0.00000000868,
	  -0.00000001084,     0.00000000050,
	   0.00000000051,     0.00000001081,
	   0.00000003050,     0.00000000042,
	  -0.00000005042,    -0.00000000413,
	   0.00000000006,    -0.00000000151,
	  -0.00000000341,    -0.00000000063,
	  -0.00000000063,     0.00000000373,
	  -0.00000000085,    -0.00000000010,
	  -0.00000000010,     0.00000000086,
	  -0.00000000148,    -0.00000001019,
	   0.00000000111,    -0.00000000015,
	   0.00000116896,     0.00000028798,
	  -0.00000000475,    -0.00000003937,
	  -0.00000000234,     0.00000000941,
	  -0.00000044201,    -0.00000005429,
	   0.00000000169,     0.00000000719,
	  -0.00000005420,     0.00000044179,
	   0.00000000718,    -0.00000000169,
	  -0.00000070466,     0.00000001989,
	  -0.00000000031,    -0.00000001449,
	  -0.00000009696,     0.00000000567,
	   0.00000000034,    -0.00000000134,
	   0.00000000561,     0.00000009747,
	  -0.00000000134,    -0.00000000033,
	  -0.00000014567,    -0.00000002693,
	   0.00000000135,    -0.00000000722,
	   0.00000000529,     0.00000000000,
	   0.00000000000,    -0.00000000530,
	  -0.00002269434,    -0.00000276043,
	   0.00000009059,     0.00000036817,
	   0.00000005242,    -0.00000042712,
	  -0.00000000696,     0.00000000166,
	   0.00000636503,     0.00000000095,
	  -0.00000000071,    -0.00000635838,
	  -0.00000000033,    -0.00000000337,
	  -0.00000000337,     0.00000000033,
	   0.00000002524,     0.00000000789,
	  -0.00000000933,    -0.00000000178,
	  -0.00000000178,     0.00000000932,
	  -0.00000003781,    -0.00000000016,
	   0.00000000000,    -0.00000000168,
	  -0.00000004549,    -0.00000000273,
	   0.00000000230,     0.00000000011,
	   0.00000000012,    -0.00000000238,
	  -0.00000376442,     0.00000021592,
	   0.00000001311,    -0.00000005236,
	  -0.00000001087,    -0.00000018990,
	   0.00000000264,     0.00000000066,
	  -0.00000000835,     0.00000000064,
	   0.00000000054,    -0.00000000205,
	  -0.00000000029,    -0.00000000100,
	  -0.00000000100,     0.00000000029,
	   0.00000017220,     0.00000000997,
	  -0.00000000015,     0.00000000259,
	   0.00000000303,     0.00000000045,
	   0.00000000045,    -0.00000000397,
	   0.00000022780,     0.00000003235,
	  -0.00000000091,     0.00000000704,
	   0.00048838076,     0.00000000985,
	  -0.00000000033,     0.00002508604,
	   0.00000029147,    -0.00000007158,
	  -0.00000000113,     0.00000000945,
	  -0.00000003578,    -0.00000058316,
	   0.00000000433,     0.00000000226,
	   0.00000003154,     0.00000014196,
	   0.00000000957,    -0.00000000182,
	   0.00000014188,    -0.00000003154,
	  -0.00000000182,    -0.00000000956,
	   0.00000081488,    -0.00000006729,
	   0.00000000079,     0.00000000792,
	   0.00000008121,    -0.00000000479,
	  -0.00000000028,     0.00000000113,
	  -0.00000000476,    -0.00000008122,
	   0.00000000113,     0.00000000028,
	  -0.00000002383,    -0.00000000424,
	   0.00000000349,     0.00000000042,
	   0.00000000042,    -0.00000000347,
	  -0.00000033147,    -0.00000006017,
	   0.00000000117,    -0.00000000608,
	   0.00000009352,     0.00000000524,
	  -0.00000000034,    -0.00000000134,
	   0.00000000521,    -0.00000009342,
	  -0.00000000134,     0.00000000034,
	   0.00000000829,    -0.00000000122,
	  -0.00000000122,    -0.00000000829,
	   0.00000505266,    -0.00000029366,
	  -0.00000001785,     0.00000007080,
	   0.00000000935,     0.00000016197,
	  -0.00000000224,    -0.00000000056,
	   0.00000000252,    -0.00000000049,
	  -0.00000000023,     0.00000000331,
	   0.00000000070,     0.00000000062,
	   0.00000000062,    -0.00000000070,
	  -0.00000000182,     0.00000000017,
	  -0.00000000017,    -0.00000000182,
	   0.00000000163,    -0.00000000014,
	   0.00000000014,     0.00000000163,
	  -0.00000000070,    -0.00000000062,
	   0.00000000062,    -0.00000000070,
	   0.00000010781,    -0.00000007196,
	  -0.00000001288,    -0.00000003527,
	  -0.00000000556,    -0.00000001040,
	  -0.00000000183,     0.00000000077,
	   0.00000014384,    -0.00000001763,
	  -0.00000000057,     0.00000000211,
	   0.00000001782,     0.00000014422,
	  -0.00000000210,    -0.00000000058,
	   0.00000003110,     0.00000013989,
	   0.00000000943,    -0.00000000180,
	  -0.00000013982,     0.00000003106,
	   0.00000000180,     0.00000000943,
	  -0.00000003134,     0.00000000113,
	  -0.00000006302,    -0.00000015402,
	   0.00000001282,     0.00000000806,
	   0.00000000428,    -0.00000000097,
	   0.00000000349,     0.00000000365,
	   0.00000000352,     0.00000000468,
	  -0.00000000110,     0.00000000111,
	   0.00000000111,     0.00000000110,
	   0.00000015392,    -0.00000002180,
	   0.00000000104,     0.00000000798,
	   0.00000000179,    -0.00000000016,
	  -0.00000000016,    -0.00000000189,
	  -0.00000005867,     0.00000006117,
	  -0.00000000072,    -0.00000000072,
	  -0.00000008027,    -0.00000000444,
	   0.00000000028,     0.00000000113,
	  -0.00000000444,     0.00000008027,
	   0.00000000113,    -0.00000000028,
	   0.00000002243,    -0.00000000170,
	   0.00000000009,     0.00000000133,
	  -0.00000465345,    -0.00000026259,
	   0.00000001651,     0.00000006527,
	   0.00000000892,    -0.00000015790,
	  -0.00000000224,     0.00000000056,
	  -0.00000000646,     0.00000000056,
	   0.00000000031,     0.00000000623,
	  -0.00000000061,    -0.00000000071,
	  -0.00000000071,     0.00000000061,
	   0.00000005326,     0.00000000002,
	   0.00000000013,     0.00000006159,
	  -0.00000000182,    -0.00000000017,
	   0.00000000017,    -0.00000000182,
	   0.00000011418,     0.00000000015,
	  -0.00000000014,    -0.00000002158,
	   0.00000000158,     0.00000000014,
	  -0.00000000014,     0.00000000158,
	  -0.00000000109,    -0.00000000013,
	   0.00000000012,    -0.00000000110,
	   0.00000000061,     0.00000000071,
	  -0.00000000070,     0.00000000061,
	  -0.00000000110,    -0.00000000310,
	   0.00000000310,    -0.00000000110,
	  -0.00000002494,     0.00000016723,
	  -0.00000001166,    -0.00000001670,
	  -0.00000000758,    -0.00000000108,
	   0.00000000077,    -0.00000000054,
	  -0.00000000341,     0.00000000045,
	   0.00000000045,     0.00000000341,
	  -0.00000017273,     0.00000003197,
	  -0.00000000087,    -0.00000000666,
	  -0.00000000227,     0.00000000016,
	   0.00000000016,     0.00000000227,
	   0.00000000037,     0.00000000498,
	  -0.00000003682,     0.00000000272,
	  -0.00000000048,    -0.00000000652,
	   0.00000002570,    -0.00000000002,
	  -0.00000006854,    -0.00000000017,
	   0.00000000559,     0.00000000005,
	  -0.00000000004,     0.00000000562,
	  -0.00000000016,    -0.00000000102,
	   0.00000000102,    -0.00000000016,
	   0.00000000464,    -0.00000000044,
	  -0.00000000044,    -0.00000000461,
	  -0.00000000014,    -0.00000000128,
	  -0.00000000128,     0.00000000014,
	  -0.00000003301,     0.00000000010,
	  -0.00000000930,    -0.00000008660,
	   0.00000007170,    -0.00000008013,
	  -0.00000008013,    -0.00000007170,
	   0.00000000163,     0.00000000000,
	   0.00000000000,    -0.00000000163,
	   0.00000356138,     0.00000020172,
	  -0.00000001259,    -0.00000005026,
	  -0.00000001057,     0.00000018638,
	   0.00000000264,    -0.00000000066,
	   0.00000002316,    -0.00000000046,
	  -0.00000000006,    -0.00000002531,
	   0.00000000016,     0.00000000103,
	   0.00000000103,    -0.00000000016,
	   0.00000574236,    -0.00000641495,
	   0.00000000890,    -0.00000007344,
	   0.00000007865,     0.00000007041,
	   0.00000794801,    -0.00000000613,
	  -0.00000000581,    -0.00000794805,
	   0.00000003729,    -0.00000000016,
	   0.00000000000,     0.00000000237,
	   0.00095530543,    -0.00000071699,
	  -0.00000002834,    -0.00000002281,
	   0.00000001769,     0.00003147352,
	   0.00000000056,    -0.00000000063,
	  -0.00000004752,    -0.00000010594,
	  -0.00000000006,    -0.00000000094,
	  -0.00000005295,     0.00000009501,
	   0.00000013563,     0.00000013707,
	   0.00000001095,    -0.00000000341,
	   0.00000013710,    -0.00000013559,
	  -0.00000000341,    -0.00000001095,
	   0.00000000828,    -0.00000056622,
	  -0.00000005890,    -0.00000003227,
	  -0.00000001902,    -0.00000000616,
	  -0.00000000140,     0.00000000182,
	  -0.00000002353,    -0.00000002622,
	   0.00000002623,    -0.00000002359,
	   0.00000013459,     0.00000013608,
	   0.00000001087,    -0.00000000338,
	  -0.00000013605,     0.00000013462,
	   0.00000000338,     0.00000001087,
	   0.00000000103,    -0.00000000020,
	   0.00000000020,     0.00000000103,
	   0.00000000029,     0.00000000099,
	  -0.00000000099,     0.00000000029,
	   0.00000000008,    -0.00000000475,
	   0.00000000475,     0.00000000008,
	   0.00000011808,     0.00000019927,
	  -0.00000001268,     0.00000000761,
	  -0.00000000015,    -0.00000000030,
	   0.00000011790,     0.00000048067,
	  -0.00000001398,     0.00000000441,
	  -0.00000000003,    -0.00000000019,
	  -0.00000048045,     0.00000011053,
	  -0.00000000376,    -0.00000001352,
	   0.00000000019,    -0.00000000004,
	   0.00000002476,     0.00000001145,
	  -0.00000000034,    -0.00000000075,
	  -0.00000001012,     0.00000003603,
	   0.00000000016,    -0.00000000047,
	  -0.00000000005,    -0.00000000001,
	  -0.00000001515,     0.00000000961,
	   0.00000000062,     0.00000000134,
	   0.00000000017,    -0.00000000007,
	   0.00000001733,     0.00000003216,
	   0.00000000809,    -0.00000000409,
	  -0.00000000028,    -0.00000000068,
	  -0.00000000968,    -0.00000004819,
	   0.00000000140,     0.00000000003,
	   0.00000004712,    -0.00000000927,
	   0.00000000009,     0.00000000155,
	   0.00000001967,     0.00000006724,
	   0.00000000603,    -0.00000000099,
	  -0.00000006795,     0.00000001982,
	   0.00000000113,     0.00000000619,
	  -0.00000001401,    -0.00000002675,
	  -0.00000000462,     0.00000000214,
	   0.00000000019,     0.00000000043,
	  -0.00000001881,     0.00000002751,
	   0.00000000098,    -0.00000000172,
	  -0.00000002668,    -0.00000001912,
	   0.00000000168,     0.00000000090,
	  -0.00000000782,    -0.00000003372,
	  -0.00000000292,     0.00000000055,
	   0.00000003425,    -0.00000000824,
	  -0.00000000066,    -0.00000000304,
	   0.00000000599,     0.00000000183,
	  -0.00000000058,     0.00000000036,
	  -0.00000002226,     0.00000002613,
	   0.00000000170,    -0.00000000179,
	  -0.00000002603,    -0.00000002226,
	   0.00000000179,     0.00000000172,
	   0.00000000043,    -0.00000000186,
	   0.00000000187,     0.00000000040,
	   0.00000000271,     0.00000000401,
	  -0.00000004413,     0.00000004983,
	   0.00000000307,    -0.00000000353,
	  -0.00000004978,    -0.00000004414,
	   0.00000000353,     0.00000000306,
	  -0.00000000528,     0.00000000536,
	   0.00000000019,    -0.00000000107,
	  -0.00000005975,     0.00000006754,
	   0.00000000414,    -0.00000000478,
	  -0.00000006752,    -0.00000005981,
	   0.00000000477,     0.00000000414,
	  -0.00000000732,    -0.00000000505,
	  -0.00000008491,     0.00000009581,
	   0.00000000590,    -0.00000000679,
	  -0.00000009568,    -0.00000008487,
	   0.00000000678,     0.00000000588,
	   0.00000000001,     0.00000000216,
	  -0.00000010620,     0.00000012010,
	   0.00000000739,    -0.00000000852,
	  -0.00000011997,    -0.00000010634,
	   0.00000000850,     0.00000000737,
	   0.00000000093,    -0.00000000034,
	   0.00000000027,     0.00000000071,
	  -0.00000000021,     0.00000000030,
	  -0.00000000034,     0.00000000017,
	  -0.00000000153,     0.00000000076,
	  -0.00000000024,    -0.00000000039,
	  -0.00000000031,    -0.00000000019,
	  -0.00000000397,    -0.00000000045,
	   0.00000000006,    -0.00000000097,
	   0.00000000613,     0.00000000067,
	  -0.00000000008,     0.00000000144,
	   0.00000000020,    -0.00000000169,
	   0.00000000041,     0.00000000003,
	  -0.00000002315,    -0.00000000292,
	   0.00000000039,    -0.00000000566,
	   0.00000000091,    -0.00000000152,
	   0.00000000145,     0.00000000095,
	   0.00000000034,     0.00000000042,
	  -0.00000000041,    -0.00000000074,
	  -0.00000001013,    -0.00000000717,
	   0.00000000103,    -0.00000000155,
	   0.00000001647,     0.00000001169,
	  -0.00000000170,     0.00000000256,
	   0.00000000042,    -0.00000000025,
	   0.00000000022,     0.00000000042,
	  -0.00000000263,     0.00000000354,
	  -0.00000000058,    -0.00000000038,
	  -0.00000007068,    -0.00000005197,
	   0.00000000758,    -0.00000001157,
	  -0.00000000369,     0.00000000172,
	  -0.00000000148,    -0.00000000369,
	  -0.00000000030,     0.00000000037,
	   0.00000000075,    -0.00000000191,
	  -0.00000000188,    -0.00000000073,
	  -0.00000000028,     0.00000000057,
	   0.00000000058,     0.00000000029,
	  -0.00000000072,     0.00000000184,
	   0.00000000183,     0.00000000072,
	   0.00000000019,    -0.00000000039,
	  -0.00000000040,    -0.00000000020,
	  -0.00000000092,    -0.00000000167,
	   0.00000000152,     0.00000000276,
	  -0.00000000194,     0.00000000086,
	  -0.00000000585,    -0.00000001278,
	   0.00000000097,    -0.00000000055,
	  -0.00000000157,    -0.00000000015,
	   0.00000000027,    -0.00000000150,
	   0.00000000047,    -0.00000000122,
	  -0.00000000392,    -0.00000000189,
	   0.00000000024,    -0.00000000028,
	   0.00000002937,     0.00000000959,
	  -0.00000000217,     0.00000000180,
	  -0.00000000044,    -0.00000000006,
	   0.00000000935,    -0.00000002906,
	   0.00000000175,     0.00000000210,
	  -0.00000000656,    -0.00000000114,
	  -0.00000000127,     0.00000000673,
	  -0.00000000110,     0.00000000288,
	  -0.00000000013,    -0.00000000018,
	   0.00000000282,     0.00000000134,
	  -0.00000000083,    -0.00000000020,
	  -0.00000002769,    -0.00000000951,
	   0.00000000205,    -0.00000000199,
	  -0.00000000947,     0.00000002762,
	  -0.00000000198,    -0.00000000203,
	   0.00000000449,     0.00000000078,
	   0.00000000086,    -0.00000000459,
	   0.00000000039,    -0.00000000120,
	  -0.00000000001,     0.00000000181,
	  -0.00000000152,    -0.00000000015,
	   0.00000000051,    -0.00000000691,
	   0.00000000023,     0.00000000042,
	   0.00000000052,    -0.00000000029,
	   0.00000003444,     0.00000001105,
	  -0.00000000251,     0.00000000202,
	  -0.00000000052,    -0.00000000006,
	   0.00000001018,     0.00000001414,
	   0.00000000642,    -0.00000000082,
	   0.00000000990,     0.00000051997,
	   0.00000004444,    -0.00000001432,
	  -0.00000000090,    -0.00000000199,
	   0.00000051409,    -0.00000001214,
	  -0.00000001395,    -0.00000004488,
	  -0.00000000196,     0.00000000092,
	   0.00000003252,    -0.00000014095,
	   0.00000001236,     0.00000000218,
	  -0.00000000010,     0.00000000048,
	  -0.00000014482,    -0.00000003517,
	   0.00000000277,    -0.00000001294,
	   0.00000000057,     0.00000000017,
	  -0.00000006521,    -0.00000002092,
	   0.00000000475,    -0.00000000383,
	   0.00000000098,     0.00000000011,
	  -0.00000000690,    -0.00000000985,
	  -0.00000000443,     0.00000000060,
	  -0.00000000805,    -0.00000044831,
	  -0.00000003881,     0.00000001215,
	   0.00000000079,     0.00000000172,
	  -0.00000044717,     0.00000000832,
	   0.00000001207,     0.00000003890,
	   0.00000000172,    -0.00000000079,
	  -0.00000002238,     0.00000009642,
	  -0.00000000851,    -0.00000000152,
	   0.00000009863,     0.00000002384,
	  -0.00000000185,     0.00000000883,
	  -0.00000000038,    -0.00000000011,
	   0.00000000015,     0.00000000003,
	   0.00000000011,     0.00000000000,
	   0.00000000000,    -0.00000000009,
	  -0.00000002452,    -0.00000103973,
	  -0.00000008937,     0.00000002857,
	   0.00000000183,     0.00000000394,
	  -0.00001609597,     0.00000023696,
	   0.00000043521,     0.00000140641,
	   0.00000006242,    -0.00000002843,
	   0.00002247399,     0.00000002556,
	  -0.00000000869,     0.00000000790,
	  -0.00000000119,    -0.00000000112,
	  -0.00000003667,    -0.00002230650,
	  -0.00000001508,    -0.00000000547,
	  -0.00000000033,    -0.00000000115,
	   0.00000007500,     0.00000001121,
	  -0.00000000371,    -0.00000000656,
	  -0.00000000041,     0.00000000016,
	  -0.00000001215,     0.00000000532,
	  -0.00000000531,     0.00000000182,
	   0.00000000022,     0.00000000042,
	   0.00000003482,     0.00000147617,
	   0.00000012689,    -0.00000004055,
	  -0.00000000259,    -0.00000000558,
	   0.00001089494,    -0.00000015977,
	  -0.00000029444,    -0.00000095091,
	  -0.00000004216,     0.00000001913,
	  -0.00001988852,     0.00000000540,
	   0.00000000192,     0.00000000053,
	   0.00000000009,     0.00000000068,
	   0.00000000751,     0.00001986929,
	   0.00000000242,     0.00000000003,
	   0.00000000066,     0.00000000009,
	  -0.00000005173,    -0.00000000484,
	   0.00000000272,     0.00000000548,
	   0.00000000039,    -0.00000000016,
	   0.00000000666,     0.00000000831,
	   0.00000000500,    -0.00000000169,
	  -0.00000000019,    -0.00000000039,
	   0.00000000000,     0.00000000028,
	   0.00000432219,    -0.00000000076,
	  -0.00000000015,    -0.00000000044,
	   0.00000000000,    -0.00000000010,
	  -0.00000000391,    -0.00002003673,
	  -0.00000000189,     0.00000000162,
	  -0.00000000116,     0.00000000003,
	   0.00000002551,     0.00000002965,
	   0.00000000398,    -0.00000000164,
	  -0.00000008445,     0.00000001134,
	   0.00000000329,    -0.00000000039,
	  -0.00000001009,     0.00000021472,
	  -0.00000000379,    -0.00000000383,
	   0.00000000004,    -0.00000000077,
	  -0.00000004297,    -0.00000005082,
	   0.00000000075,    -0.00000001879,
	  -0.00000408978,     0.00000000122,
	   0.00000000008,     0.00000000032,
	   0.00000000263,     0.00001268612,
	   0.00000000135,    -0.00000000116,
	  -0.00000002937,     0.00000003362,
	   0.00000000066,    -0.00000000168,
	   0.00000004426,     0.00000001859,
	  -0.00000000256,     0.00000000038,
	  -0.00000000706,    -0.00000014697,
	  -0.00000000256,     0.00000000262,
	   0.00000000002,     0.00000000053,
	  -0.00000002957,     0.00000003479,
	   0.00000000053,     0.00000001286,
	   0.00000000029,     0.00000000025,
	   0.00000000025,    -0.00000000029,
	   0.00000000568,    -0.00000000878,
	  -0.00000000002,     0.00000000049,
	   0.00000000112,    -0.00000002043,
	   0.00000000073,     0.00000000234,
	  -0.00000038651,     0.00000001063,
	   0.00000000186,     0.00000000370,
	   0.00000001066,    -0.00000034379,
	   0.00000000364,    -0.00000000159,
	   0.00000000019,     0.00000000077,
	   0.00000000001,    -0.00000000079,
	   0.00000000024,     0.00000000236,
	   0.00000000072,    -0.00000000006,
	  -0.00000003647,     0.00000004226,
	   0.00000000235,    -0.00000000293,
	   0.00000000005,     0.00000000015,
	  -0.00000002647,    -0.00000000855,
	   0.00000000154,     0.00000000045,
	  -0.00000004548,    -0.00000000455,
	  -0.00000000092,    -0.00000000167,
	  -0.00000000459,    -0.00000006555,
	  -0.00000000166,     0.00000000073,
	  -0.00000000047,    -0.00000000069,
	   0.00000000000,     0.00000000059,
	  -0.00000000039,    -0.00000000119,
	  -0.00000000052,     0.00000000027,
	  -0.00000000088,     0.00000000119,
	   0.00000000044,     0.00000000035,
	   0.00000000119,     0.00000000088,
	   0.00000000035,    -0.00000000044,
	   0.00000000071,     0.00000000050,
	   0.00000000029,    -0.00000000158,
	  -0.00000000048,    -0.00000000011,
	  -0.00000000158,    -0.00000000029,
	  -0.00000000012,     0.00000000048,
	  -0.00000000379,     0.00000000516,
	   0.00000000190,     0.00000000153,
	   0.00000000031,    -0.00000000035,
	  -0.00000000334,    -0.00000000235,
	  -0.00000000097,     0.00000000122,
	  -0.00000000286,     0.00000001512,
	   0.00000000455,     0.00000000110,
	   0.00000000021,    -0.00000000069,
	   0.00000001511,     0.00000000282,
	   0.00000000109,    -0.00000000455,
	  -0.00000000069,    -0.00000000021,
	  -0.00000000132,     0.00000000708,
	   0.00000000213,     0.00000000051,
	   0.00000000010,    -0.00000000032,
	   0.00000040420,     0.00000007556,
	   0.00000002944,    -0.00000012197,
	  -0.00000001848,    -0.00000000564,
	   0.00000001428,     0.00000005320,
	   0.00000001231,    -0.00000000250,
	  -0.00000000021,    -0.00000000144,
	   0.00000005326,    -0.00000001422,
	  -0.00000000248,    -0.00000001234,
	  -0.00000000145,     0.00000000020,
	  -0.00000000109,     0.00000000122,
	   0.00000000122,     0.00000000089,
	   0.00000004334,    -0.00000023368,
	  -0.00000007053,    -0.00000001698,
	  -0.00000000326,     0.00000001068,
	  -0.00000212481,    -0.00000039635,
	  -0.00000015456,     0.00000064184,
	   0.00000009717,     0.00000002967,
	   0.00000000360,    -0.00000000970,
	  -0.00000013630,    -0.00000051510,
	  -0.00000011966,     0.00000002411,
	   0.00000000197,     0.00000001401,
	  -0.00000051366,     0.00000013767,
	   0.00000002459,     0.00000011910,
	   0.00000001390,    -0.00000000207,
	   0.00000000571,    -0.00000000632,
	  -0.00000000020,    -0.00000000083,
	  -0.00000000632,    -0.00000000512,
	  -0.00000000070,     0.00000000023,
	   0.00000000012,     0.00000000056,
	   0.00000000101,     0.00000000379,
	   0.00000000088,    -0.00000000018,
	  -0.00000000001,    -0.00000000010,
	   0.00000002834,    -0.00000000743,
	  -0.00000000133,    -0.00000000654,
	  -0.00000000077,     0.00000000011,
	   0.00000001427,     0.00000001687,
	   0.00000000270,    -0.00000000199,
	   0.00000001691,    -0.00000001426,
	  -0.00000000199,    -0.00000000272,
	  -0.00000000015,     0.00000000041,
	  -0.00000002790,    -0.00000010429,
	  -0.00000002421,     0.00000000493,
	   0.00000000040,     0.00000000283,
	  -0.00000015136,     0.00000003972,
	   0.00000000716,     0.00000003502,
	   0.00000000409,    -0.00000000059,
	  -0.00000013994,    -0.00000016646,
	  -0.00000002684,     0.00000001961,
	   0.00000000142,     0.00000000216,
	  -0.00000016532,     0.00000014026,
	   0.00000001970,     0.00000002650,
	   0.00000000211,    -0.00000000143,
	   0.00000000081,    -0.00000000208,
	  -0.00000000196,    -0.00000000057,
	   0.00000000646,     0.00000000764,
	   0.00000000123,    -0.00000000090,
	  -0.00000000007,    -0.00000000010,
	   0.00000003602,    -0.00000003021,
	  -0.00000000423,    -0.00000000575,
	  -0.00000000046,     0.00000000031,
	   0.00000003326,     0.00000001535,
	   0.00000000133,    -0.00000000244,
	   0.00000001547,    -0.00000003332,
	  -0.00000000245,    -0.00000000137,
	  -0.00000014240,    -0.00000016843,
	  -0.00000002715,     0.00000001992,
	   0.00000000144,     0.00000000218,
	  -0.00000018789,     0.00000015756,
	   0.00000002210,     0.00000002998,
	   0.00000000241,    -0.00000000160,
	  -0.00000033461,    -0.00000015596,
	  -0.00000001384,     0.00000002466,
	   0.00000000098,     0.00000000058,
	  -0.00000015265,     0.00000033392,
	   0.00000002451,     0.00000001311,
	   0.00000000049,    -0.00000000097,
	   0.00000000034,    -0.00000000201,
	  -0.00000000160,     0.00000000000,
	   0.00000002544,     0.00000001175,
	   0.00000000104,    -0.00000000186,
	  -0.00000000007,    -0.00000000004,
	   0.00000004321,    -0.00000009304,
	  -0.00000000682,    -0.00000000376,
	   0.00000004913,    -0.00000000009,
	   0.00000000018,    -0.00000004951,
	  -0.00000042110,    -0.00000019408,
	  -0.00000001712,     0.00000003104,
	   0.00000000123,     0.00000000068,
	  -0.00000021479,     0.00000046238,
	   0.00000003391,     0.00000001866,
	   0.00000000075,    -0.00000000134,
	  -0.00000051569,    -0.00000000323,
	  -0.00000000004,     0.00000000069,
	   0.00000000548,     0.00000050879,
	  -0.00000000032,    -0.00000000127,
	   0.00000000108,    -0.00000000163,
	  -0.00000000052,    -0.00000000077,
	   0.00000006063,     0.00000000002,
	   0.00000000002,    -0.00000018760,
	  -0.00000000379,     0.00000000116,
	   0.00000000159,     0.00000000207,
	   0.00000000006,     0.00000000069,
	  -0.00000067567,     0.00000000356,
	   0.00000000102,     0.00000000047,
	  -0.00000000058,     0.00000086772,
	  -0.00000000207,    -0.00000000572,
	   0.00000000122,     0.00000000198,
	   0.00000000882,    -0.00000002835,
	  -0.00000000025,    -0.00000000238,
	   0.00000000050,    -0.00000000365,
	  -0.00000000178,    -0.00000000068,
	  -0.00000000157,     0.00000000066,
	  -0.00000000007,    -0.00000000011,
	   0.00000000139,     0.00000000344,
	  -0.00000000301,    -0.00000000008,
	  -0.00000000007,    -0.00000000302,
	  -0.00000004770,     0.00000005987,
	   0.00000000437,    -0.00000000389,
	   0.00000000004,     0.00000000025,
	  -0.00000003961,    -0.00000004578,
	   0.00000000352,     0.00000000119,
	  -0.00000003364,    -0.00000000119,
	  -0.00000000166,    -0.00000003450,
	   0.00000000010,    -0.00000000065,
	   0.00000000022,     0.00000000040,
	   0.00000000038,    -0.00000000051,
	  -0.00000000135,    -0.00000000103,
	   0.00000000220,    -0.00000000183,
	  -0.00000000183,    -0.00000000219,
	   0.00000000014,    -0.00000000042,
	   0.00000000512,    -0.00000000428,
	  -0.00000000002,    -0.00000000101,
	  -0.00000000007,    -0.00000000003,
	  -0.00000001104,    -0.00000001347,
	  -0.00000000264,     0.00000000003,
	   0.00000001975,    -0.00000000982,
	   0.00000000047,    -0.00000000216,
	  -0.00000000985,    -0.00000001966,
	  -0.00000000216,    -0.00000000047,
	   0.00000005698,    -0.00000002855,
	   0.00000000137,    -0.00000000626,
	  -0.00000000029,    -0.00000000021,
	  -0.00000007226,    -0.00000014685,
	  -0.00000001609,    -0.00000000349,
	  -0.00000000053,     0.00000000074,
	   0.00000013378,    -0.00000003113,
	   0.00000000292,    -0.00000000622,
	  -0.00000003155,    -0.00000013302,
	  -0.00000000618,    -0.00000000290,
	  -0.00000000026,     0.00000000101,
	  -0.00000000086,     0.00000000031,
	   0.00000000031,     0.00000000086,
	   0.00000050560,    -0.00000011974,
	   0.00000001116,    -0.00000002350,
	  -0.00000000075,    -0.00000000074,
	  -0.00000029778,    -0.00000127874,
	  -0.00000005956,    -0.00000002789,
	  -0.00000000186,     0.00000000189,
	   0.00000054257,     0.00000000390,
	  -0.00000000039,    -0.00000000026,
	  -0.00000000091,    -0.00000053763,
	  -0.00000000076,     0.00000000368,
	  -0.00000000351,    -0.00000000100,
	  -0.00000000551,     0.00000000252,
	   0.00000000023,     0.00000000113,
	  -0.00000000428,     0.00000000155,
	   0.00000000154,     0.00000000426,
	  -0.00000000959,     0.00000000636,
	   0.00000000396,    -0.00000000213,
	   0.00000000615,    -0.00000000368,
	  -0.00000000148,     0.00000000144,
	   0.00000000022,    -0.00000000072,
	  -0.00000000033,     0.00000000101,
	   0.00000000100,     0.00000000033,
	  -0.00000000015,     0.00000000049,
	   0.00000000029,    -0.00000000089,
	  -0.00000000089,    -0.00000000029,
	   0.00000000060,     0.00000000020,
	  -0.00000000038,    -0.00000000012,
	   0.00000293981,    -0.00000000212,
	  -0.00000000123,    -0.00000000025,
	   0.00000000000,    -0.00000000031,
	  -0.00000000528,    -0.00000731372,
	  -0.00000000057,     0.00000000303,
	  -0.00000000077,    -0.00000000001,
	  -0.00000002542,     0.00000002056,
	  -0.00000000101,    -0.00000000269,
	  -0.00000001266,     0.00000004216,
	  -0.00000000099,    -0.00000000113,
	  -0.00000000893,     0.00000001907,
	  -0.00000000170,    -0.00000000019,
	  -0.00000001801,    -0.00000000945,
	   0.00000000018,    -0.00000000180,
	  -0.00000003095,     0.00000002095,
	  -0.00000000136,     0.00000000531,
	  -0.00000001536,     0.00000001745,
	   0.00000000108,    -0.00000000123,
	   0.00000001738,     0.00000001517,
	  -0.00000000124,    -0.00000000108,
	  -0.00000000129,    -0.00000000014,
	   0.00000000059,    -0.00000000042,
	  -0.00000000014,    -0.00000000020,
	  -0.00000000106,    -0.00000000152,
	  -0.00000000053,     0.00000000036,
	   0.00000000144,    -0.00000000057,
	  -0.00000000020,    -0.00000000045,
	  -0.00000000057,    -0.00000000143,
	  -0.00000000045,     0.00000000020,
	  -0.00000000045,    -0.00000000006,
	  -0.00000000017,     0.00000000114,
	  -0.00000000050,    -0.00000000008,
	  -0.00000000008,     0.00000000049,
	   0.00000000013,    -0.00000000066,
	  -0.00000006633,    -0.00000001728,
	  -0.00000000160,    -0.00000000300,
	   0.00000000010,    -0.00000000009,
	  -0.00000004239,     0.00000016148,
	  -0.00000000730,     0.00000000393,
	  -0.00000003574,    -0.00000000016,
	   0.00000000096,    -0.00000003581,
	   0.00000000127,     0.00000000093,
	  -0.00000000089,     0.00000000124,
	  -0.00000031389,     0.00000035445,
	   0.00000002205,    -0.00000002514,
	  -0.00000006554,    -0.00000005826,
	   0.00000000466,     0.00000000403,
	   0.00000000065,    -0.00000000044,
	  -0.00000000142,    -0.00000000209,
	  -0.00000001342,     0.00000001513,
	  -0.00000003080,     0.00000003478,
	   0.00000000053,    -0.00000000014,
	  -0.00000000047,     0.00000000012,
	   0.00000000040,    -0.00000000104,
	   0.00000000408,    -0.00000000164,
	  -0.00000000058,    -0.00000000130,
	  -0.00000000410,    -0.00000001033,
	  -0.00000000329,     0.00000000146,
	   0.00000000454,    -0.00000000066,
	  -0.00000000034,    -0.00000000132,
	  -0.00000000070,    -0.00000000449,
	  -0.00000000130,     0.00000000035,
	  -0.00000000151,    -0.00000000015,
	  -0.00000000053,     0.00000000389,
	   0.00000000047,     0.00000000001,
	   0.00000000003,    -0.00000000116,
	   0.00000001659,    -0.00000000203,
	  -0.00000000121,    -0.00000000482,
	  -0.00000000506,    -0.00000004128,
	  -0.00000001199,     0.00000000298,
	  -0.00000000083,     0.00000000030,
	   0.00000000013,     0.00000000093,
	  -0.00000000365,     0.00000000053,
	   0.00000000054,     0.00000000067,
	   0.00000000004,    -0.00000000006,
	   0.00000000129,     0.00000000900,
	   0.00000000166,    -0.00000000133,
	  -0.00000000019,    -0.00000000378,
	  -0.00000000030,     0.00000000020,
	  -0.00000000374,     0.00000000016,
	   0.00000000019,     0.00000000030,
	  -0.00000000142,    -0.00000002679,
	  -0.00000000258,     0.00000000179,
	   0.00000000009,     0.00000000011,
	  -0.00000006597,     0.00000000342,
	   0.00000000439,     0.00000000634,
	   0.00000001366,    -0.00000000009,
	   0.00000000018,    -0.00000001335,
	   0.00000000162,     0.00000000160,
	   0.00000000160,    -0.00000000162,
	   0.00000013663,    -0.00000000023,
	  -0.00000000051,    -0.00000033399,
	   0.00000000026,     0.00000000060,
	  -0.00000000113,     0.00000000103,
	  -0.00000000074,     0.00000000043,
	  -0.00000000042,    -0.00000000075,
	   0.00000004846,     0.00000004053,
	  -0.00000000279,    -0.00000001027,
	  -0.00000000153,     0.00000000260,
	  -0.00000002020,     0.00000002285,
	   0.00000000138,    -0.00000000160,
	   0.00000002286,     0.00000002023,
	  -0.00000000160,    -0.00000000139,
	   0.00000000021,    -0.00000000377,
	   0.00000000035,     0.00000000025,
	  -0.00000000916,    -0.00000000052,
	   0.00000000061,    -0.00000000086,
	  -0.00000000087,     0.00000000000,
	   0.00000000004,    -0.00000000090,
	  -0.00000077053,     0.00000087024,
	   0.00000005379,    -0.00000006157,
	  -0.00000008961,    -0.00000007937,
	   0.00000000635,     0.00000000550,
	   0.00000000241,     0.00000000230,
	   0.00000000125,    -0.00000000120,
	  -0.00000000041,    -0.00000000005,
	  -0.00000000012,     0.00000000099,
	   0.00000000220,    -0.00000000197,
	  -0.00000000197,    -0.00000000220,
	   0.00000000253,     0.00000000000,
	   0.00000000000,    -0.00000000615,
	   0.00000012050,    -0.00000010178,
	   0.00000000195,     0.00000000226,
	  -0.00000002840,     0.00000003202,
	   0.00000000197,    -0.00000000227,
	   0.00000003200,     0.00000002837,
	  -0.00000000227,    -0.00000000197,
	   0.00000001571,    -0.00000001992,
	   0.00000000097,     0.00000000075,
	  -0.00000218643,     0.00000246532,
	   0.00000015194,    -0.00000017541,
	  -0.00000012748,    -0.00000011303,
	   0.00000000904,     0.00000000784,
	  -0.00000000095,     0.00000000179,
	   0.00000000310,     0.00000000243,
	  -0.00000000086,    -0.00000000048,
	  -0.00000000048,     0.00000000086,
	  -0.00000002115,     0.00000002681,
	  -0.00000000083,    -0.00000000065,
	  -0.00000000056,     0.00000000081,
	  -0.00000000081,    -0.00000000056,
	  -0.00000000085,    -0.00000000047,
	   0.00000000047,    -0.00000000085,
	   0.00000002213,    -0.00000002229,
	   0.00000000072,     0.00000000073,
	   0.00000000078,     0.00000000000,
	   0.00000000000,    -0.00000000189,
	  -0.00000001694,     0.00000001707,
	  -0.00000000086,    -0.00000000087,
	   0.00000002154,     0.00000005770,
	  -0.00000003555,     0.00000004016,
	   0.00000000247,    -0.00000000285,
	   0.00000004015,     0.00000003555,
	  -0.00000000285,    -0.00000000247,
	  -0.00000428023,     0.00000483344,
	   0.00000029806,    -0.00000034468,
	  -0.00000015988,    -0.00000014159,
	   0.00000001134,     0.00000000983,
	  -0.00000000130,     0.00000000007,
	   0.00000000007,     0.00000000130,
	  -0.00000000130,     0.00000000007,
	  -0.00000000007,    -0.00000000130,
	   0.00000000001,     0.00000000001,
	   0.00000002254,    -0.00000002813,
	   0.00000000279,     0.00000000241,
	  -0.00000000010,     0.00000000010,
	   0.00000006792,    -0.00000004341,
	   0.00000000299,     0.00000000445,
	  -0.00000000012,     0.00000000008,
	   0.00000004247,     0.00000006845,
	  -0.00000000443,     0.00000000285,
	  -0.00000000007,    -0.00000000012,
	   0.00000000115,    -0.00000000717,
	   0.00000000007,     0.00000000017,
	   0.00000000897,     0.00000000033,
	  -0.00000000014,     0.00000000024,
	   0.00000000078,     0.00000000044,
	  -0.00000000010,     0.00000000011,
	  -0.00000000253,     0.00000000207,
	  -0.00000000349,     0.00000000278,
	  -0.00000000035,    -0.00000000060,
	  -0.00000000300,    -0.00000000367,
	   0.00000000057,    -0.00000000032,
	  -0.00000000126,     0.00000000059,
	  -0.00000000067,    -0.00000000126,
	   0.00000000094,    -0.00000000038,
	  -0.00000000318,     0.00000000134,
	   0.00000000027,     0.00000000057,
	  -0.00000000128,    -0.00000000312,
	  -0.00000000055,     0.00000000025,
	   0.00000000080,    -0.00000000008,
	   0.00000000009,     0.00000000082,
	  -0.00000000015,    -0.00000000121,
	   0.00000000121,    -0.00000000015,
	  -0.00000000039,    -0.00000000015,
	  -0.00000000029,    -0.00000000133,
	   0.00000000055,     0.00000000101,
	  -0.00000000017,    -0.00000000462,
	   0.00000000050,    -0.00000000004,
	   0.00000000107,    -0.00000000047,
	  -0.00000000032,     0.00000000040,
	   0.00000000101,    -0.00000000272,
	  -0.00000000269,    -0.00000000098,
	  -0.00000000032,     0.00000000069,
	   0.00000000071,     0.00000000033,
	   0.00000000023,    -0.00000000030,
	  -0.00000000097,     0.00000000260,
	   0.00000000259,     0.00000000097,
	   0.00000000022,    -0.00000000047,
	  -0.00000000048,    -0.00000000023,
	   0.00000000106,     0.00000000067,
	   0.00000068483,    -0.00000108450,
	  -0.00000000650,    -0.00000000281,
	  -0.00000000961,     0.00000000618,
	  -0.00000000055,    -0.00000000072,
	   0.00000000617,     0.00000000952,
	  -0.00000000071,     0.00000000055,
	  -0.00000000235,    -0.00000000149,
	  -0.00000067541,     0.00000106616,
	   0.00000000619,     0.00000000293,
	   0.00000000829,    -0.00000000616,
	   0.00000000044,     0.00000000067,
	  -0.00000000479,    -0.00000000866,
	   0.00000000063,    -0.00000000057,
	   0.00000001571,     0.00000001003,
	   0.00000157712,    -0.00000247151,
	  -0.00000001361,    -0.00000000731,
	   0.00000000173,     0.00000000869,
	   0.00000000077,     0.00000000004,
	  -0.00000000915,     0.00000000048,
	   0.00000000002,     0.00000000071,
	   0.00000000099,    -0.00000000275,
	   0.00000000008,     0.00000000018,
	  -0.00000000188,    -0.00000000139,
	   0.00000004778,     0.00000001352,
	  -0.00000000345,     0.00000000174,
	  -0.00000000071,    -0.00000000004,
	   0.00000001322,    -0.00000004737,
	   0.00000000168,     0.00000000337,
	  -0.00000000003,     0.00000000070,
	  -0.00000000937,    -0.00000000164,
	  -0.00000000185,     0.00000000966,
	  -0.00000000188,     0.00000000521,
	  -0.00000000015,    -0.00000000033,
	   0.00000000149,     0.00000000102,
	  -0.00000000092,    -0.00000000032,
	  -0.00000004472,    -0.00000001332,
	   0.00000000324,    -0.00000000205,
	   0.00000000067,     0.00000000005,
	  -0.00000001330,     0.00000004466,
	  -0.00000000204,    -0.00000000322,
	   0.00000000005,    -0.00000000066,
	   0.00000000641,     0.00000000113,
	   0.00000000125,    -0.00000000657,
	   0.00000000000,    -0.00000000008,
	   0.00000027909,     0.00000007664,
	  -0.00000002006,     0.00000000905,
	  -0.00000000412,    -0.00000000017,
	  -0.00000177229,     0.00000678821,
	  -0.00000017676,    -0.00000048691,
	   0.00000000185,    -0.00000009924,
	   0.00000008132,     0.00000333344,
	   0.00000028441,    -0.00000009219,
	  -0.00000000581,    -0.00000001258,
	   0.00000330679,    -0.00000009136,
	  -0.00000009050,    -0.00000028660,
	  -0.00000001247,     0.00000000591,
	   0.00000015427,    -0.00000066914,
	   0.00000005921,     0.00000000998,
	  -0.00000000048,     0.00000000218,
	  -0.00000069282,    -0.00000016928,
	   0.00000001328,    -0.00000006213,
	   0.00000000274,     0.00000000086,
	  -0.00000044032,    -0.00000012093,
	   0.00000003164,    -0.00000001427,
	   0.00000000649,     0.00000000026,
	   0.00000121408,    -0.00000464908,
	   0.00000012079,     0.00000033366,
	  -0.00000000130,     0.00000006791,
	  -0.00000007178,    -0.00000294355,
	  -0.00000025352,     0.00000008071,
	   0.00000000516,     0.00000001111,
	  -0.00000294157,     0.00000007138,
	   0.00000008051,     0.00000025385,
	   0.00000001110,    -0.00000000515,
	  -0.00000010651,     0.00000045767,
	  -0.00000004085,    -0.00000000703,
	   0.00000000035,    -0.00000000152,
	   0.00000047038,     0.00000011434,
	  -0.00000000878,     0.00000004238,
	  -0.00000000180,    -0.00000000057,
	  -0.00000001094,    -0.00000038153,
	  -0.00000003255,     0.00000001058,
	   0.00000000067,     0.00000000142,
	  -0.00000215710,     0.00000002793,
	   0.00000005820,     0.00000018936,
	   0.00000000837,    -0.00000000380,
	   0.00000535428,     0.00000000405,
	  -0.00000000146,     0.00000000111,
	  -0.00000000019,    -0.00000000031,
	  -0.00000000681,    -0.00000532790,
	  -0.00000000359,    -0.00000000091,
	   0.00000002242,     0.00000000273,
	  -0.00000000106,    -0.00000000166,
	  -0.00000000383,     0.00000000211,
	  -0.00000000136,     0.00000000049,
	   0.00000001381,     0.00000048155,
	   0.00000004108,    -0.00000001333,
	  -0.00000000084,    -0.00000000180,
	   0.00000144597,    -0.00000001836,
	  -0.00000003889,    -0.00000012682,
	  -0.00000000562,     0.00000000254,
	  -0.00000483174,     0.00000000220,
	   0.00000000020,     0.00000000067,
	   0.00000000041,     0.00000483355,
	   0.00000000084,    -0.00000000016,
	  -0.00000001543,    -0.00000000077,
	   0.00000000081,     0.00000000152,
	   0.00000000230,     0.00000000323,
	   0.00000000141,    -0.00000000052,
	   0.00000000000,    -0.00000000012,
	   0.00000264045,    -0.00000000018,
	  -0.00000000010,    -0.00000000051,
	   0.00000000000,    -0.00000000009,
	  -0.00000000150,    -0.00000943109,
	  -0.00000000162,     0.00000000080,
	   0.00000000762,    -0.00000003977,
	   0.00000000080,     0.00000000060,
	  -0.00000001528,     0.00000000409,
	   0.00000000057,    -0.00000000507,
	  -0.00000000616,     0.00000011626,
	  -0.00000000232,    -0.00000000207,
	  -0.00000002619,    -0.00000002754,
	   0.00000000045,    -0.00000001020,
	  -0.00000249981,     0.00000000017,
	   0.00000000010,     0.00000000048,
	   0.00000000103,     0.00000603627,
	   0.00000000115,    -0.00000000057,
	  -0.00000000498,     0.00000003335,
	  -0.00000000060,    -0.00000000071,
	   0.00000001186,    -0.00000000064,
	  -0.00000000046,     0.00000000354,
	  -0.00000000431,    -0.00000007958,
	  -0.00000000155,     0.00000000142,
	  -0.00000001810,     0.00000001885,
	   0.00000000033,     0.00000000698,
	  -0.00000000370,    -0.00000000704,
	   0.00000000150,    -0.00000000006,
	  -0.00000001392,     0.00000000199,
	  -0.00000000004,    -0.00000000278,
	   0.00000037206,     0.00000000809,
	   0.00000000141,     0.00000000280,
	   0.00000000829,     0.00000040486,
	   0.00000000285,    -0.00000000124,
	   0.00000000140,     0.00000000018,
	  -0.00000000007,    -0.00000000058,
	   0.00000000032,     0.00000000244,
	   0.00000000055,    -0.00000000010,
	   0.00000000233,     0.00000000444,
	  -0.00000000094,     0.00000000004,
	   0.00000000892,    -0.00000000106,
	   0.00000000018,     0.00000000213,
	  -0.00000014782,    -0.00000000454,
	  -0.00000000075,    -0.00000000146,
	  -0.00000000450,    -0.00000016544,
	  -0.00000000151,     0.00000000066,
	  -0.00000000096,    -0.00000000009,
	  -0.00000000020,    -0.00000000153,
	  -0.00000000830,     0.00000000420,
	   0.00000000067,     0.00000000143,
	   0.00000000013,    -0.00000000006,
	   0.00000001595,     0.00000003197,
	   0.00000000555,    -0.00000000261,
	  -0.00000000022,    -0.00000000050,
	   0.00000000088,    -0.00000000678,
	   0.00000000023,     0.00000000028,
	   0.00000000577,     0.00000000127,
	  -0.00000000022,     0.00000000033,
	   0.00000000796,     0.00000003426,
	   0.00000000296,    -0.00000000057,
	  -0.00000003475,     0.00000000835,
	   0.00000000066,     0.00000000308,
	   0.00000000257,    -0.00000000168,
	  -0.00000000020,    -0.00000000040,
	  -0.00000001065,    -0.00000002190,
	  -0.00000000384,     0.00000000179,
	   0.00000000015,     0.00000000034,
	   0.00000000065,     0.00000000253,
	  -0.00000000192,     0.00000000041,
	  -0.00000000542,    -0.00000002346,
	  -0.00000000202,     0.00000000038,
	   0.00000002388,    -0.00000000577,
	  -0.00000000046,    -0.00000000213,
	  -0.00000000088,     0.00000000048,
	   0.00000000020,     0.00000000041,
	   0.00000000048,     0.00000000088,
	   0.00000000041,    -0.00000000020,
	  -0.00000000026,     0.00000000014,
	   0.00000000006,     0.00000000012,
	   0.00000000556,     0.00000001022,
	   0.00000000478,    -0.00000000233,
	  -0.00000000047,    -0.00000000113,
	  -0.00000000134,     0.00000000187,
	   0.00000000068,     0.00000000055,
	   0.00000000186,     0.00000000133,
	   0.00000000054,    -0.00000000068,
	   0.00000000873,    -0.00000000477,
	  -0.00000000199,    -0.00000000408,
	  -0.00000000097,     0.00000000040,
	  -0.00000002935,    -0.00000005396,
	  -0.00000002526,     0.00000001229,
	   0.00000000250,     0.00000000598,
	   0.00000001306,    -0.00000001807,
	  -0.00000000661,    -0.00000000533,
	  -0.00000000110,     0.00000000121,
	  -0.00000001808,    -0.00000001294,
	  -0.00000000526,     0.00000000662,
	   0.00000000121,     0.00000000108,
	   0.00000000131,     0.00000000095,
	   0.00000000039,    -0.00000000048,
	  -0.00000000025,     0.00000000141,
	   0.00000000042,     0.00000000010,
	   0.00000000140,     0.00000000025,
	   0.00000000010,    -0.00000000042,
	   0.00000000389,    -0.00000000544,
	  -0.00000000199,    -0.00000000159,
	  -0.00000000033,     0.00000000036,
	  -0.00000000718,    -0.00000000522,
	  -0.00000000211,     0.00000000263,
	   0.00000000048,     0.00000000043,
	   0.00000000252,    -0.00000001381,
	  -0.00000000416,    -0.00000000102,
	  -0.00000000020,     0.00000000063,
	  -0.00000001377,    -0.00000000243,
	  -0.00000000098,     0.00000000414,
	   0.00000000063,     0.00000000019,
	  -0.00000000010,     0.00000000059,
	   0.00000000018,     0.00000000004,
	   0.00000000269,     0.00000000050,
	   0.00000000020,    -0.00000000081,
	   0.00000000076,     0.00000000286,
	   0.00000000066,    -0.00000000013,
	   0.00000000283,    -0.00000000078,
	  -0.00000000014,    -0.00000000065,
	   0.00000000269,    -0.00000001509,
	  -0.00000000454,    -0.00000000110,
	  -0.00000000021,     0.00000000069,
	  -0.00000001474,    -0.00000000274,
	  -0.00000000107,     0.00000000443,
	   0.00000000067,     0.00000000020,
	  -0.00000000756,    -0.00000002839,
	  -0.00000000660,     0.00000000129,
	   0.00000000010,     0.00000000077,
	  -0.00000002818,     0.00000000773,
	   0.00000000136,     0.00000000652,
	   0.00000000076,    -0.00000000012,
	   0.00000000048,     0.00000000176,
	   0.00000000041,    -0.00000000008,
	   0.00000000638,    -0.00000000169,
	  -0.00000000030,    -0.00000000147,
	   0.00000000427,     0.00000000513,
	   0.00000000083,    -0.00000000059,
	   0.00000000499,    -0.00000000429,
	  -0.00000000060,    -0.00000000079,
	  -0.00000001050,    -0.00000003874,
	  -0.00000000899,     0.00000000180,
	   0.00000000015,     0.00000000105,
	  -0.00000003434,     0.00000000910,
	   0.00000000160,     0.00000000793,
	   0.00000000093,    -0.00000000013,
	  -0.00000004312,    -0.00000005153,
	  -0.00000000834,     0.00000000599,
	   0.00000000043,     0.00000000068,
	  -0.00000005062,     0.00000004331,
	   0.00000000606,     0.00000000807,
	   0.00000000064,    -0.00000000045,
	   0.00000000024,    -0.00000000046,
	  -0.00000000042,    -0.00000000016,
	   0.00000000352,     0.00000000416,
	   0.00000000067,    -0.00000000049,
	   0.00000001294,    -0.00000001087,
	  -0.00000000152,    -0.00000000207,
	   0.00000001174,     0.00000000569,
	   0.00000000054,    -0.00000000087,
	   0.00000000513,    -0.00000001160,
	  -0.00000000084,    -0.00000000041,
	  -0.00000006459,    -0.00000007630,
	  -0.00000001231,     0.00000000901,
	   0.00000000065,     0.00000000099,
	  -0.00000006742,     0.00000005666,
	   0.00000000792,     0.00000001078,
	   0.00000000086,    -0.00000000058,
	  -0.00000012045,    -0.00000005712,
	  -0.00000000520,     0.00000000890,
	   0.00000000036,     0.00000000023,
	  -0.00000005404,     0.00000011970,
	   0.00000000875,     0.00000000450,
	   0.00000000015,    -0.00000000034,
	   0.00000000024,    -0.00000000060,
	  -0.00000000043,    -0.00000000009,
	   0.00000001265,     0.00000000586,
	   0.00000000052,    -0.00000000093,
	   0.00000001626,    -0.00000003499,
	  -0.00000000257,    -0.00000000141,
	   0.00000001634,     0.00000000094,
	  -0.00000000087,    -0.00000001486,
	  -0.00000018561,    -0.00000008595,
	  -0.00000000758,     0.00000001364,
	   0.00000000054,     0.00000000030,
	  -0.00000008116,     0.00000017458,
	   0.00000001281,     0.00000000705,
	   0.00000000028,    -0.00000000051,
	  -0.00000016814,    -0.00000000414,
	  -0.00000000043,     0.00000000045,
	   0.00000000360,     0.00000016179,
	  -0.00000000045,    -0.00000000078,
	   0.00000000051,    -0.00000000071,
	  -0.00000000026,    -0.00000000035,
	   0.00000002325,     0.00000000005,
	   0.00000000009,    -0.00000005893,
	   0.00000000204,     0.00000000261,
	  -0.00000000095,     0.00000000550,
	  -0.00000025599,    -0.00000000061,
	  -0.00000000047,     0.00000027839,
	   0.00000000420,    -0.00000001330,
	   0.00000000013,     0.00000000204,
	  -0.00000000213,    -0.00000002790,
	   0.00000000030,    -0.00000000107,
	   0.00000000024,    -0.00000000135,
	  -0.00000000066,    -0.00000000020,
	  -0.00000000177,     0.00000000091,
	  -0.00000000006,    -0.00000000013,
	   0.00000000188,     0.00000000379,
	   0.00000001056,    -0.00000000006,
	  -0.00000000006,     0.00000001051,
	   0.00000001300,    -0.00000000677,
	   0.00000000040,     0.00000000095,
	  -0.00000000926,    -0.00000001872,
	   0.00000000136,    -0.00000000066,
	  -0.00000002177,     0.00000000031,
	   0.00000000041,    -0.00000002131,
	  -0.00000000044,     0.00000000019,
	  -0.00000000019,    -0.00000000044,
	   0.00000000093,     0.00000000005,
	   0.00000000084,    -0.00000000045,
	   0.00000000049,     0.00000000081,
	   0.00000000018,    -0.00000000082,
	   0.00000000082,     0.00000000018,
	  -0.00000000034,    -0.00000000026,
	   0.00000000044,    -0.00000000037,
	  -0.00000000035,    -0.00000000043,
	   0.00000000132,    -0.00000000111,
	   0.00000000000,    -0.00000000026,
	  -0.00000000239,    -0.00000000290,
	  -0.00000000047,     0.00000000002,
	   0.00000000338,    -0.00000000175,
	  -0.00000000153,    -0.00000000321,
	   0.00000001202,    -0.00000000599,
	   0.00000000029,    -0.00000000132,
	  -0.00000000006,    -0.00000000004,
	  -0.00000001281,    -0.00000002600,
	  -0.00000000285,    -0.00000000062,
	   0.00000001938,    -0.00000000514,
	   0.00000000039,    -0.00000000107,
	  -0.00000000333,    -0.00000001707,
	  -0.00000000062,    -0.00000000040,
	   0.00000008229,    -0.00000001918,
	   0.00000000182,    -0.00000000382,
	  -0.00000000012,    -0.00000000013,
	  -0.00000004074,    -0.00000017615,
	  -0.00000000819,    -0.00000000384,
	  -0.00000000027,     0.00000000025,
	   0.00000006966,    -0.00000000555,
	   0.00000000023,    -0.00000000140,
	   0.00000000658,    -0.00000004420,
	   0.00000000136,     0.00000000036,
	  -0.00000000012,     0.00000000059,
	  -0.00000000057,    -0.00000000016,
	   0.00000033621,     0.00000000261,
	  -0.00000000016,    -0.00000000011,
	   0.00000000378,    -0.00000071368,
	  -0.00000000018,     0.00000000043,
	   0.00000010705,    -0.00000002461,
	   0.00000000246,    -0.00000000560,
	   0.00000002671,     0.00000011873,
	   0.00000000495,     0.00000000238,
	  -0.00000000101,     0.00000000218,
	  -0.00000000207,    -0.00000000107,
	  -0.00000000047,    -0.00000000030,
	   0.00000000032,     0.00000000021,
	   0.00000000042,     0.00000000014,
	  -0.00000000021,    -0.00000000031,
	  -0.00000002851,     0.00000001060,
	   0.00000000054,    -0.00000000174,
	   0.00000001386,     0.00000005243,
	  -0.00000000306,    -0.00000000061,
	   0.00000065984,    -0.00000000056,
	   0.00000000052,     0.00000065963,
	   0.00000010491,     0.00000005234,
	   0.00000000089,    -0.00000000035,
	  -0.00000000012,    -0.00000000028,
	  -0.00000000074,    -0.00000000190,
	  -0.00000000060,     0.00000000026,
	   0.00000000070,    -0.00000000016,
	  -0.00000000039,    -0.00000000003,
	  -0.00000000008,     0.00000000081,
	   0.00000000030,    -0.00000000037,
	  -0.00000001519,    -0.00000000404,
	  -0.00000000037,    -0.00000000068,
	   0.00000000404,    -0.00000001518,
	   0.00000000068,    -0.00000000037,
	   0.00000000104,     0.00000000208,
	  -0.00000000208,     0.00000000104,
	   0.00000000107,    -0.00000000036,
	  -0.00000000030,    -0.00000000045,
	   0.00000000281,    -0.00000000041,
	  -0.00000000021,    -0.00000000081,
	  -0.00000000088,    -0.00000000597,
	  -0.00000000173,     0.00000000045,
	   0.00000000078,    -0.00000000029,
	   0.00000000037,     0.00000000089,
	  -0.00000000057,     0.00000000012,
	   0.00000000010,     0.00000000011,
	   0.00000000034,     0.00000000120,
	   0.00000000367,    -0.00000000076,
	  -0.00000000030,    -0.00000000107,
	   0.00000000019,     0.00000000370,
	   0.00000000107,    -0.00000000030,
	  -0.00000000010,    -0.00000000239,
	  -0.00000000023,     0.00000000016,
	  -0.00000000500,     0.00000000022,
	   0.00000000033,     0.00000000049,
	  -0.00000000006,    -0.00000000160,
	   0.00000000866,     0.00000000009,
	   0.00000000013,    -0.00000001803,
	  -0.00000000032,    -0.00000000604,
	  -0.00000000057,     0.00000000040,
	   0.00000000601,    -0.00000000023,
	  -0.00000000040,    -0.00000000059,
	  -0.00000000058,     0.00000000021,
	   0.00000000004,     0.00000000086,
	   0.00000003104,    -0.00000000005,
	   0.00000000005,     0.00000003104,
	   0.00000000005,    -0.00000000087,
	   0.00000000087,     0.00000000005,
	  -0.00000000108,    -0.00000000874,
	   0.00000000091,    -0.00000000011,
	   0.00000000058,     0.00000000000,
	   0.00000000000,     0.00000000058,
	  -0.00000000300,    -0.00000002486,
	   0.00000000129,    -0.00000000016,
	  -0.00000000592,    -0.00000004874,
	   0.00000000162,    -0.00000000020,
	  -0.00000000583,    -0.00000000193,
	   0.00000000033,    -0.00000000079,
	  -0.00000001101,    -0.00000000905,
	   0.00000000092,    -0.00000000111,
	   0.00000000003,     0.00000000002,
	   0.00000000920,    -0.00000001091,
	   0.00000000108,     0.00000000093,
	  -0.00000000002,     0.00000000003,
	  -0.00000000165,     0.00000000023,
	   0.00000000003,    -0.00000000008,
	  -0.00000000048,    -0.00000000192,
	   0.00000000012,     0.00000000000,
	   0.00000000090,     0.00000000077,
	  -0.00000000077,     0.00000000091,
	  -0.00000000022,     0.00000000061,
	   0.00000000065,    -0.00000000091,
	  -0.00000000122,     0.00000000413,
	  -0.00000000186,    -0.00000000044,
	  -0.00000000024,    -0.00000000014,
	  -0.00000000030,     0.00000000034,
	   0.00000000141,    -0.00000000405,
	  -0.00000000401,    -0.00000000139,
	  -0.00000000039,     0.00000000091,
	   0.00000000093,     0.00000000041,
	   0.00000000046,     0.00000000026,
	  -0.00000000136,     0.00000000384,
	   0.00000000384,     0.00000000136,
	   0.00000000027,    -0.00000000062,
	  -0.00000000063,    -0.00000000028,
	   0.00000000263,    -0.00000000773,
	   0.00000000012,     0.00000000051,
	   0.00000002931,     0.00000000827,
	  -0.00000000203,    -0.00000000008,
	   0.00000010763,     0.00000002653,
	  -0.00000000766,     0.00000000172,
	  -0.00000000158,     0.00000000001,
	   0.00000002603,    -0.00000010692,
	   0.00000000162,     0.00000000751,
	   0.00000000003,     0.00000000156,
	  -0.00000001877,    -0.00000000330,
	  -0.00000000376,     0.00000001942,
	  -0.00000000006,    -0.00000000046,
	  -0.00000000436,     0.00000001281,
	  -0.00000000020,    -0.00000000085,
	  -0.00000001964,    -0.00000000552,
	  -0.00000000017,    -0.00000000087,
	  -0.00000010013,    -0.00000002602,
	   0.00000000715,    -0.00000000240,
	   0.00000000148,     0.00000000002,
	  -0.00000002604,     0.00000010012,
	  -0.00000000239,    -0.00000000713,
	   0.00000000002,    -0.00000000148,
	   0.00000001283,     0.00000000228,
	   0.00000000253,    -0.00000001319,
	  -0.00000007939,    -0.00000001886,
	   0.00000000563,    -0.00000000093,
	   0.00000000116,    -0.00000000003,
	  -0.00000019403,     0.00000072899,
	  -0.00000001779,    -0.00000005171,
	   0.00000000021,    -0.00000001083,
	  -0.00000002234,    -0.00000080176,
	  -0.00000006822,     0.00000002223,
	   0.00000000139,     0.00000000299,
	  -0.00000079740,     0.00000002391,
	   0.00000002195,     0.00000006867,
	   0.00000000298,    -0.00000000141,
	  -0.00000002924,     0.00000012678,
	  -0.00000001134,    -0.00000000182,
	   0.00000000010,    -0.00000000041,
	   0.00000013248,     0.00000003259,
	  -0.00000000255,     0.00000001192,
	  -0.00000000052,    -0.00000000017,
	   0.00000011272,     0.00000002678,
	  -0.00000000798,     0.00000000137,
	  -0.00000000164,     0.00000000004,
	   0.00000013277,    -0.00000049891,
	   0.00000001223,     0.00000003530,
	  -0.00000000014,     0.00000000742,
	   0.00000002027,     0.00000071804,
	   0.00000006153,    -0.00000001978,
	  -0.00000000126,    -0.00000000268,
	   0.00000071862,    -0.00000001978,
	  -0.00000001979,    -0.00000006159,
	  -0.00000000269,     0.00000000125,
	   0.00000002027,    -0.00000008670,
	   0.00000000785,     0.00000000128,
	  -0.00000008960,    -0.00000002194,
	   0.00000000166,    -0.00000000814,
	  -0.00000000764,    -0.00000024273,
	  -0.00000002061,     0.00000000676,
	   0.00000000042,     0.00000000090,
	  -0.00000095536,     0.00000001419,
	   0.00000002576,     0.00000008380,
	   0.00000000368,    -0.00000000168,
	   0.00000251699,     0.00000000100,
	  -0.00000000042,     0.00000000022,
	  -0.00000000210,    -0.00000251069,
	  -0.00000000181,    -0.00000000029,
	   0.00000001269,     0.00000000133,
	  -0.00000000058,    -0.00000000084,
	  -0.00000000225,     0.00000000142,
	  -0.00000000070,     0.00000000025,
	   0.00000000904,     0.00000028722,
	   0.00000002439,    -0.00000000797,
	  -0.00000000050,    -0.00000000106,
	   0.00000063925,    -0.00000000931,
	  -0.00000001715,    -0.00000005605,
	  -0.00000000247,     0.00000000112,
	  -0.00000229665,     0.00000000144,
	  -0.00000000008,     0.00000000051,
	  -0.00000000034,     0.00000230089,
	   0.00000000058,    -0.00000000013,
	  -0.00000000872,    -0.00000000018,
	   0.00000000046,     0.00000000082,
	   0.00000000142,     0.00000000209,
	   0.00000000077,    -0.00000000030,
	   0.00000168309,     0.00000000003,
	  -0.00000000004,    -0.00000000047,
	  -0.00000000068,    -0.00000510584,
	  -0.00000000128,     0.00000000037,
	   0.00000000282,    -0.00000004778,
	   0.00000000013,     0.00000000086,
	   0.00000000040,     0.00000000355,
	  -0.00000000006,    -0.00000000555,
	  -0.00000000393,     0.00000006905,
	  -0.00000000149,    -0.00000000122,
	  -0.00000001665,    -0.00000001637,
	   0.00000000028,    -0.00000000607,
	  -0.00000159326,    -0.00000000003,
	   0.00000000004,     0.00000000045,
	   0.00000000046,     0.00000329412,
	   0.00000000090,    -0.00000000027,
	  -0.00000000148,     0.00000003545,
	  -0.00000000059,    -0.00000000073,
	   0.00000000518,    -0.00000000149,
	  -0.00000000010,     0.00000000383,
	  -0.00000000275,    -0.00000004727,
	  -0.00000000098,     0.00000000084,
	  -0.00000001157,     0.00000001121,
	   0.00000000021,     0.00000000416,
	  -0.00000000410,    -0.00000000986,
	   0.00000000186,    -0.00000000003,
	  -0.00000002386,     0.00000000446,
	   0.00000000009,    -0.00000000400,
	   0.00000033836,     0.00000000629,
	   0.00000000106,     0.00000000210,
	   0.00000000630,     0.00000036351,
	   0.00000000223,    -0.00000000097,
	   0.00000000176,    -0.00000000007,
	  -0.00000000009,    -0.00000000043,
	   0.00000000032,     0.00000000224,
	   0.00000000042,    -0.00000000011,
	   0.00000000291,     0.00000000700,
	  -0.00000000132,     0.00000000002,
	   0.00000001569,    -0.00000000279,
	   0.00000000004,     0.00000000286,
	  -0.00000014388,    -0.00000000377,
	  -0.00000000063,    -0.00000000124,
	  -0.00000000373,    -0.00000015889,
	  -0.00000000132,     0.00000000058,
	  -0.00000000120,     0.00000000009,
	  -0.00000000019,    -0.00000000136,
	  -0.00000000765,     0.00000000385,
	   0.00000000061,     0.00000000133,
	   0.00000000012,    -0.00000000005,
	   0.00000001254,     0.00000002511,
	   0.00000000439,    -0.00000000204,
	  -0.00000000017,    -0.00000000040,
	  -0.00000000167,    -0.00000000316,
	   0.00000000247,    -0.00000000143,
	   0.00000000000,     0.00000000049,
	   0.00000000549,     0.00000002368,
	   0.00000000204,    -0.00000000039,
	  -0.00000002404,     0.00000000579,
	   0.00000000046,     0.00000000214,
	   0.00000000362,    -0.00000000182,
	  -0.00000000029,    -0.00000000063,
	  -0.00000000858,    -0.00000001717,
	  -0.00000000300,     0.00000000140,
	   0.00000000071,     0.00000000161,
	  -0.00000000117,     0.00000000054,
	  -0.00000000374,    -0.00000001622,
	  -0.00000000139,     0.00000000026,
	   0.00000001655,    -0.00000000401,
	  -0.00000000033,    -0.00000000148,
	  -0.00000000094,     0.00000000035,
	   0.00000000071,    -0.00000000034,
	   0.00000000022,     0.00000000060,
	  -0.00000000073,     0.00000000004,
	  -0.00000000005,    -0.00000000075,
	   0.00000000066,    -0.00000000024,
	  -0.00000000182,     0.00000000091,
	  -0.00000000085,    -0.00000000176,
	   0.00000000050,    -0.00000000002,
	   0.00000000004,     0.00000000052,
	  -0.00000000016,     0.00000000038,
	   0.00000000083,    -0.00000000200,
	  -0.00000000120,    -0.00000000055,
	  -0.00000000019,     0.00000000036,
	   0.00000000103,    -0.00000000006,
	   0.00000000000,    -0.00000000055,
	  -0.00000000006,    -0.00000000102,
	  -0.00000000054,     0.00000000001,
	  -0.00000000003,    -0.00000000050,
	   0.00000000075,    -0.00000000041,
	  -0.00000000017,    -0.00000000035,
	  -0.00000000042,    -0.00000000074,
	  -0.00000000035,     0.00000000017,
	   0.00000000085,    -0.00000000048,
	  -0.00000000020,    -0.00000000040,
	  -0.00000000043,    -0.00000000078,
	  -0.00000000037,     0.00000000018,
	   0.00000000114,    -0.00000000160,
	  -0.00000000058,    -0.00000000047,
	  -0.00000000160,    -0.00000000112,
	  -0.00000000046,     0.00000000058,
	   0.00000000033,     0.00000000023,
	  -0.00000000009,     0.00000000051,
	   0.00000000051,     0.00000000008,
	   0.00000000160,    -0.00000000227,
	  -0.00000000083,    -0.00000000066,
	  -0.00000000014,     0.00000000015,
	  -0.00000000182,    -0.00000000131,
	  -0.00000000053,     0.00000000066,
	   0.00000000092,    -0.00000000510,
	  -0.00000000153,    -0.00000000038,
	  -0.00000000507,    -0.00000000086,
	  -0.00000000035,     0.00000000152,
	  -0.00000000006,     0.00000000036,
	   0.00000000111,     0.00000000020,
	   0.00000000034,     0.00000000129,
	   0.00000000126,    -0.00000000036,
	   0.00000000138,    -0.00000000793,
	  -0.00000000238,    -0.00000000058,
	  -0.00000000011,     0.00000000036,
	  -0.00000000610,    -0.00000000111,
	  -0.00000000044,     0.00000000183,
	  -0.00000000345,    -0.00000001302,
	  -0.00000000303,     0.00000000058,
	  -0.00000001285,     0.00000000359,
	   0.00000000063,     0.00000000297,
	   0.00000000030,     0.00000000110,
	   0.00000000025,    -0.00000000005,
	   0.00000000304,    -0.00000000081,
	  -0.00000000014,    -0.00000000070,
	   0.00000000194,     0.00000000238,
	   0.00000000039,    -0.00000000027,
	   0.00000000224,    -0.00000000197,
	  -0.00000000028,    -0.00000000035,
	  -0.00000000577,    -0.00000002114,
	  -0.00000000491,     0.00000000098,
	   0.00000000008,     0.00000000057,
	  -0.00000001631,     0.00000000437,
	   0.00000000076,     0.00000000377,
	   0.00000000044,    -0.00000000006,
	  -0.00000002001,    -0.00000002410,
	  -0.00000000393,     0.00000000277,
	   0.00000000020,     0.00000000032,
	  -0.00000002334,     0.00000002016,
	   0.00000000283,     0.00000000370,
	   0.00000000029,    -0.00000000021,
	   0.00000000204,     0.00000000240,
	   0.00000000039,    -0.00000000028,
	   0.00000000613,    -0.00000000516,
	  -0.00000000072,    -0.00000000098,
	   0.00000000499,     0.00000000256,
	   0.00000000026,    -0.00000000037,
	   0.00000000201,    -0.00000000484,
	  -0.00000003361,    -0.00000003969,
	  -0.00000000640,     0.00000000467,
	   0.00000000034,     0.00000000051,
	  -0.00000003191,     0.00000002686,
	   0.00000000375,     0.00000000511,
	   0.00000000041,    -0.00000000027,
	  -0.00000005171,    -0.00000002505,
	  -0.00000000234,     0.00000000384,
	  -0.00000002262,     0.00000005109,
	   0.00000000372,     0.00000000179,
	   0.00000000631,     0.00000000293,
	   0.00000000026,    -0.00000000046,
	   0.00000000698,    -0.00000001500,
	  -0.00000000110,    -0.00000000061,
	   0.00000000618,     0.00000000077,
	  -0.00000000072,    -0.00000000494,
	  -0.00000008678,    -0.00000004028,
	  -0.00000000354,     0.00000000636,
	   0.00000000025,     0.00000000014,
	  -0.00000003497,     0.00000007513,
	   0.00000000552,     0.00000000303,
	  -0.00000006194,    -0.00000000294,
	  -0.00000000034,     0.00000000031,
	   0.00000000253,     0.00000005739,
	  -0.00000000033,    -0.00000000052,
	   0.00000000025,    -0.00000000033,
	   0.00000000920,     0.00000000004,
	   0.00000000006,    -0.00000002073,
	   0.00000000154,     0.00000000161,
	  -0.00000000071,     0.00000000341,
	  -0.00000010129,    -0.00000000045,
	  -0.00000000033,     0.00000009910,
	   0.00000000189,    -0.00000000777,
	   0.00000000004,     0.00000000119,
	  -0.00000000102,    -0.00000001627,
	   0.00000000013,    -0.00000000062,
	   0.00000000012,    -0.00000000054,
	  -0.00000000117,     0.00000000060,
	   0.00000000118,     0.00000000237,
	   0.00000000491,    -0.00000000004,
	  -0.00000000007,     0.00000000486,
	   0.00000000966,    -0.00000000493,
	   0.00000000031,     0.00000000070,
	  -0.00000000585,    -0.00000001183,
	   0.00000000086,    -0.00000000041,
	  -0.00000001081,     0.00000000039,
	   0.00000000048,    -0.00000001033,
	  -0.00000000046,     0.00000000025,
	  -0.00000000025,    -0.00000000046,
	   0.00000000051,     0.00000000018,
	   0.00000000073,    -0.00000000040,
	   0.00000000040,     0.00000000072,
	   0.00000000030,    -0.00000000025,
	  -0.00000000049,    -0.00000000060,
	   0.00000000058,    -0.00000000031,
	  -0.00000000024,    -0.00000000052,
	   0.00000000231,    -0.00000000115,
	   0.00000000006,    -0.00000000025,
	  -0.00000000223,    -0.00000000453,
	  -0.00000000041,    -0.00000000008,
	   0.00000000292,    -0.00000000086,
	  -0.00000000032,    -0.00000000224,
	   0.00000001284,    -0.00000000294,
	   0.00000000028,    -0.00000000060,
	  -0.00000000572,    -0.00000002502,
	  -0.00000000116,    -0.00000000054,
	   0.00000000956,    -0.00000000135,
	   0.00000000160,    -0.00000000345,
	   0.00000004020,     0.00000000067,
	   0.00000000098,    -0.00000007799,
	   0.00000001994,    -0.00000000451,
	   0.00000000046,    -0.00000000103,
	   0.00000000490,     0.00000002182,
	   0.00000000092,     0.00000000045,
	  -0.00000000510,     0.00000000179,
	   0.00000000009,    -0.00000000031,
	   0.00000000236,     0.00000000885,
	  -0.00000000047,    -0.00000000014,
	   0.00000008536,     0.00000000089,
	  -0.00000000092,     0.00000008529,
	  -0.00000000842,     0.00000000396,
	   0.00000000023,    -0.00000000050,
	  -0.00000000396,    -0.00000000842,
	   0.00000000050,     0.00000000023,
	   0.00000000045,    -0.00000000006,
	  -0.00000000012,    -0.00000000080,
	   0.00000000065,    -0.00000000010,
	   0.00000000010,     0.00000000065,
	   0.00000000057,     0.00000000001,
	   0.00000000002,    -0.00000000109,
	  -0.00000000003,    -0.00000000062,
	   0.00000000061,    -0.00000000002,
	   0.00000000224,     0.00000000003,
	  -0.00000000003,     0.00000000224,
	   0.00000000006,     0.00000000110,
	  -0.00000000018,    -0.00000000001,
	  -0.00000000091,     0.00000000245,
	  -0.00000000031,    -0.00000000013,
	  -0.00000000245,    -0.00000000095,
	   0.00000000013,    -0.00000000031,
	   0.00000000016,     0.00000000033,
	  -0.00000000036,     0.00000000022,
	  -0.00000000001,    -0.00000000004,
	  -0.00000000044,    -0.00000000029,
	   0.00000000052,     0.00000000034,
	  -0.00000000085,    -0.00000000063,
	  -0.00000000037,    -0.00000000020,
	  -0.00000000020,     0.00000000037,
	   0.00000000035,     0.00000000019,
	   0.00000000019,    -0.00000000035,
	  -0.00000000050,    -0.00000000026,
	   0.00000000231,    -0.00000000703,
	   0.00000000004,     0.00000000048,
	  -0.00000000699,    -0.00000000227,
	   0.00000000047,    -0.00000000003,
	  -0.00000000057,     0.00000000141,
	   0.00000000145,     0.00000000061,
	   0.00000000085,     0.00000000045,
	  -0.00000000222,     0.00000000665,
	  -0.00000000007,    -0.00000000044,
	   0.00000000665,     0.00000000222,
	  -0.00000000044,     0.00000000007,
	   0.00000000039,    -0.00000000096,
	  -0.00000000098,    -0.00000000041,
	  -0.00000001098,     0.00000003430,
	  -0.00000000008,    -0.00000000232,
	  -0.00000000005,    -0.00000000033,
	   0.00000099460,     0.00000032529,
	  -0.00000006689,     0.00000000456,
	  -0.00000000948,     0.00000000112,
	  -0.00000040378,    -0.00000008716,
	   0.00000002836,     0.00000000084,
	   0.00000000588,    -0.00000000036,
	  -0.00000008582,     0.00000040182,
	   0.00000000114,    -0.00000002795,
	  -0.00000000042,    -0.00000000583,
	   0.00000006328,     0.00000001115,
	  -0.00000000124,    -0.00000000002,
	   0.00000001288,    -0.00000006581,
	   0.00000000018,     0.00000000157,
	   0.00000001665,    -0.00000005199,
	   0.00000000015,     0.00000000352,
	   0.00000000007,     0.00000000050,
	  -0.00000068293,    -0.00000022332,
	   0.00000005059,    -0.00000000024,
	   0.00000000640,    -0.00000000082,
	   0.00000037598,     0.00000008528,
	  -0.00000002645,     0.00000000181,
	  -0.00000000548,     0.00000000024,
	   0.00000008558,    -0.00000037630,
	   0.00000000179,     0.00000002643,
	   0.00000000024,     0.00000000549,
	  -0.00000004327,    -0.00000000774,
	   0.00000000087,    -0.00000000002,
	  -0.00000000863,     0.00000004459,
	  -0.00000000013,    -0.00000000104,
	  -0.00000000047,    -0.00000000006,
	  -0.00000003759,    -0.00000000779,
	   0.00000000263,     0.00000000017,
	   0.00000000054,    -0.00000000004,
	  -0.00000004836,     0.00000019419,
	  -0.00000000251,    -0.00000001358,
	  -0.00000000004,    -0.00000000289,
	  -0.00000001006,    -0.00000033147,
	  -0.00000002820,     0.00000000917,
	   0.00000000057,     0.00000000123,
	  -0.00000033044,     0.00000001043,
	   0.00000000910,     0.00000002837,
	   0.00000000123,    -0.00000000058,
	  -0.00000000994,     0.00000004302,
	  -0.00000000390,    -0.00000000059,
	   0.00000004543,     0.00000001126,
	  -0.00000000087,     0.00000000410,
	   0.00000004982,     0.00000001032,
	  -0.00000000349,    -0.00000000022,
	  -0.00000000072,     0.00000000006,
	   0.00000003308,    -0.00000013286,
	   0.00000000177,     0.00000000927,
	   0.00000000003,     0.00000000198,
	   0.00000000924,     0.00000029974,
	   0.00000002565,    -0.00000000824,
	  -0.00000000052,    -0.00000000111,
	   0.00000030038,    -0.00000000891,
	  -0.00000000828,    -0.00000002568,
	  -0.00000000112,     0.00000000052,
	   0.00000000692,    -0.00000002941,
	   0.00000000271,     0.00000000042,
	  -0.00000003060,    -0.00000000756,
	   0.00000000056,    -0.00000000281,
	  -0.00000000568,    -0.00000017073,
	  -0.00000001445,     0.00000000475,
	   0.00000000030,     0.00000000063,
	  -0.00000054774,     0.00000000941,
	   0.00000001478,     0.00000004791,
	   0.00000000210,    -0.00000000096,
	   0.00000140152,     0.00000000019,
	  -0.00000000055,    -0.00000140191,
	  -0.00000000116,    -0.00000000009,
	   0.00000000828,     0.00000000077,
	  -0.00000000037,    -0.00000000050,
	  -0.00000000150,     0.00000000103,
	  -0.00000000042,     0.00000000016,
	   0.00000000645,     0.00000019394,
	   0.00000001636,    -0.00000000539,
	  -0.00000000034,    -0.00000000071,
	   0.00000036661,    -0.00000000619,
	  -0.00000000986,    -0.00000003210,
	  -0.00000000141,     0.00000000064,
	  -0.00000128829,     0.00000000093,
	  -0.00000000016,     0.00000000038,
	  -0.00000000052,     0.00000129280,
	   0.00000000047,    -0.00000000010,
	  -0.00000000568,    -0.00000000001,
	   0.00000000030,     0.00000000052,
	   0.00000000098,     0.00000000148,
	   0.00000000049,    -0.00000000020,
	   0.00000004116,     0.00000023950,
	   0.00000003076,    -0.00000001764,
	  -0.00000000021,    -0.00000000063,
	  -0.00000000063,     0.00000000021,
	  -0.00000002043,    -0.00000012335,
	  -0.00000001571,     0.00000000833,
	   0.00000000019,     0.00000000060,
	   0.00000000060,    -0.00000000019,
	  -0.00000005731,    -0.00000032631,
	  -0.00000004119,     0.00000002623,
	   0.00000000081,    -0.00000000065,
	  -0.00000000065,    -0.00000000080,
	   0.00000109965,     0.00000000017,
	   0.00000000000,    -0.00000000042,
	  -0.00000000018,    -0.00000297815,
	  -0.00000000101,     0.00000000015,
	   0.00000000055,    -0.00000004544,
	  -0.00000000015,     0.00000000086,
	   0.00000000691,     0.00000000285,
	  -0.00000000033,    -0.00000000512,
	  -0.00000000258,     0.00000004303,
	  -0.00000000098,    -0.00000000076,
	  -0.00000001084,    -0.00000001022,
	   0.00000000018,    -0.00000000380,
	  -0.00000104096,    -0.00000000016,
	   0.00000000000,     0.00000000040,
	   0.00000000012,     0.00000193313,
	   0.00000000072,    -0.00000000011,
	   0.00000000011,     0.00000003206,
	  -0.00000000052,    -0.00000000064,
	   0.00000000179,    -0.00000000165,
	   0.00000000006,     0.00000000351,
	  -0.00000000179,    -0.00000002946,
	  -0.00000000064,     0.00000000052,
	  -0.00000000759,     0.00000000700,
	   0.00000000014,     0.00000000260,
	  -0.00000000383,    -0.00000001030,
	   0.00000000186,    -0.00000000001,
	  -0.00000000004,     0.00000000005,
	  -0.00000002471,     0.00000000486,
	   0.00000000011,    -0.00000000403,
	   0.00000026608,     0.00000000484,
	   0.00000000081,     0.00000000157,
	   0.00000000479,     0.00000028532,
	   0.00000000172,    -0.00000000074,
	   0.00000000172,    -0.00000000018,
	   0.00000000029,     0.00000000192,
	   0.00000000290,     0.00000000780,
	  -0.00000000141,     0.00000000001,
	   0.00000001637,    -0.00000000312,
	   0.00000000000,     0.00000000283,
	  -0.00000011661,    -0.00000000311,
	  -0.00000000051,    -0.00000000100,
	  -0.00000000306,    -0.00000012895,
	  -0.00000000109,     0.00000000048,
	  -0.00000000117,     0.00000000016,
	  -0.00000000017,    -0.00000000115,
	  -0.00000000661,     0.00000000334,
	   0.00000000053,     0.00000000115,
	   0.00000000010,    -0.00000000005,
	   0.00000000973,     0.00000001941,
	   0.00000000339,    -0.00000000157,
	  -0.00000000162,    -0.00000000285,
	   0.00000000240,    -0.00000000149,
	   0.00000000001,     0.00000000050,
	   0.00000000378,     0.00000001635,
	   0.00000000141,    -0.00000000027,
	  -0.00000001662,     0.00000000401,
	   0.00000000032,     0.00000000148,
	   0.00000000376,    -0.00000000190,
	  -0.00000000030,    -0.00000000065,
	  -0.00000000666,    -0.00000001328,
	  -0.00000000232,     0.00000000108,
	   0.00000000068,     0.00000000131,
	  -0.00000000100,     0.00000000058,
	  -0.00000000257,    -0.00000001120,
	  -0.00000000096,     0.00000000018,
	   0.00000001146,    -0.00000000278,
	  -0.00000000023,    -0.00000000103,
	  -0.00000000065,     0.00000000021,
	   0.00000000045,    -0.00000000015,
	  -0.00000000100,     0.00000000051,
	  -0.00000000045,    -0.00000000095,
	   0.00000000049,    -0.00000000028,
	  -0.00000000019,    -0.00000000035,
	   0.00000000059,    -0.00000000083,
	  -0.00000000030,    -0.00000000025,
	  -0.00000000083,    -0.00000000058,
	  -0.00000000024,     0.00000000030,
	   0.00000000098,    -0.00000000140,
	  -0.00000000051,    -0.00000000041,
	  -0.00000000097,    -0.00000000069,
	  -0.00000000028,     0.00000000035,
	   0.00000000051,    -0.00000000281,
	  -0.00000000085,    -0.00000000021,
	  -0.00000000278,    -0.00000000046,
	  -0.00000000019,     0.00000000084,
	   0.00000000062,     0.00000000011,
	   0.00000000017,     0.00000000069,
	   0.00000000066,    -0.00000000020,
	   0.00000000083,    -0.00000000483,
	  -0.00000000145,    -0.00000000035,
	  -0.00000000007,     0.00000000022,
	  -0.00000000340,    -0.00000000061,
	  -0.00000000025,     0.00000000102,
	  -0.00000000185,    -0.00000000703,
	  -0.00000000164,     0.00000000030,
	  -0.00000000689,     0.00000000196,
	   0.00000000035,     0.00000000159,
	   0.00000000019,     0.00000000069,
	   0.00000000016,    -0.00000000003,
	   0.00000000166,    -0.00000000045,
	   0.00000000096,     0.00000000121,
	   0.00000000108,    -0.00000000098,
	  -0.00000000334,    -0.00000001222,
	  -0.00000000284,     0.00000000057,
	   0.00000000005,     0.00000000033,
	  -0.00000000886,     0.00000000239,
	   0.00000000041,     0.00000000205,
	  -0.00000001002,    -0.00000001221,
	  -0.00000000200,     0.00000000138,
	  -0.00000001161,     0.00000001013,
	   0.00000000143,     0.00000000182,
	   0.00000000116,     0.00000000137,
	   0.00000000022,    -0.00000000016,
	   0.00000000310,    -0.00000000261,
	  -0.00000000036,    -0.00000000050,
	   0.00000000223,     0.00000000123,
	   0.00000000079,    -0.00000000212,
	  -0.00000001785,    -0.00000002110,
	  -0.00000000340,     0.00000000248,
	   0.00000000018,     0.00000000027,
	  -0.00000001612,     0.00000001357,
	   0.00000000189,     0.00000000258,
	  -0.00000002326,    -0.00000001158,
	  -0.00000000112,     0.00000000173,
	  -0.00000000984,     0.00000002280,
	   0.00000000166,     0.00000000072,
	   0.00000000310,     0.00000000144,
	   0.00000000013,    -0.00000000023,
	   0.00000000312,    -0.00000000670,
	  -0.00000000049,    -0.00000000027,
	   0.00000000250,     0.00000000053,
	  -0.00000000050,    -0.00000000163,
	  -0.00000004095,    -0.00000001908,
	  -0.00000000166,     0.00000000300,
	  -0.00000001570,     0.00000003365,
	   0.00000000247,     0.00000000135,
	  -0.00000002389,    -0.00000000188,
	   0.00000000161,     0.00000002098,
	  -0.00000000021,    -0.00000000033,
	   0.00000000367,     0.00000000003,
	   0.00000000004,    -0.00000000765,
	   0.00000000093,     0.00000000090,
	  -0.00000000043,     0.00000000190,
	  -0.00000004043,    -0.00000000029,
	  -0.00000000021,     0.00000003685,
	   0.00000000086,    -0.00000000420,
	   0.00000000001,     0.00000000064,
	  -0.00000000048,    -0.00000000878,
	  -0.00000000068,     0.00000000034,
	   0.00000000065,     0.00000000131,
	   0.00000000217,    -0.00000000003,
	  -0.00000000005,     0.00000000213,
	   0.00000000597,    -0.00000000302,
	   0.00000000019,     0.00000000043,
	  -0.00000000323,    -0.00000000657,
	   0.00000000048,    -0.00000000023,
	  -0.00000000499,     0.00000000030,
	   0.00000000037,    -0.00000000459,
	   0.00000000041,     0.00000000019,
	   0.00000000054,    -0.00000000030,
	   0.00000000028,     0.00000000053,
	   0.00000000042,    -0.00000000021,
	  -0.00000000038,    -0.00000000077,
	   0.00000000045,    -0.00000000015,
	   0.00000000195,    -0.00000000043,
	  -0.00000000080,    -0.00000000358,
	   0.00000000140,    -0.00000000028,
	   0.00000000492,     0.00000000014,
	   0.00000000021,    -0.00000000900,
	   0.00000000335,    -0.00000000074,
	   0.00000000081,     0.00000000364,
	  -0.00000000084,     0.00000000028,
	   0.00000000038,     0.00000000140,
	   0.00000001092,     0.00000000023,
	  -0.00000000024,     0.00000001091,
	  -0.00000000155,     0.00000000066,
	  -0.00000000066,    -0.00000000155,
	   0.00000000019,    -0.00000000009,
	   0.00000000001,     0.00000000004,
	   0.00000000049,     0.00000000001,
	  -0.00000000001,     0.00000000008,
	  -0.00000000001,     0.00000000049,
	  -0.00000000008,    -0.00000000001,
	   0.00000000006,    -0.00000000005,
	   0.00000000007,     0.00000000006,
	  -0.00000000143,    -0.00000000078,
	   0.00000000156,     0.00000000136,
	  -0.00000000325,    -0.00000000058,
	  -0.00000000068,     0.00000000005,
	  -0.00000000056,    -0.00000000028,
	  -0.00000000028,     0.00000000056,
	   0.00000000054,     0.00000000028,
	   0.00000000028,    -0.00000000054,
	  -0.00000000195,    -0.00000000096,
	   0.00000000024,    -0.00000000003,
	   0.00000000986,    -0.00000002125,
	   0.00000000015,     0.00000000258,
	  -0.00000000017,     0.00000000034,
	   0.00000000786,    -0.00000002491,
	  -0.00000000015,     0.00000000169,
	  -0.00000002376,    -0.00000000712,
	   0.00000000166,     0.00000000017,
	  -0.00000000169,     0.00000000441,
	  -0.00000000018,    -0.00000000042,
	   0.00000000455,     0.00000000182,
	  -0.00000000045,     0.00000000019,
	   0.00000000311,     0.00000000153,
	  -0.00000000039,     0.00000000005,
	  -0.00000000682,     0.00000001462,
	  -0.00000000027,    -0.00000000140,
	  -0.00000000752,     0.00000002346,
	   0.00000000004,    -0.00000000157,
	   0.00000002257,     0.00000000697,
	  -0.00000000157,    -0.00000000004,
	   0.00000000116,    -0.00000000301,
	  -0.00000000309,    -0.00000000123,
	  -0.00000000187,     0.00000000623,
	   0.00000000005,    -0.00000000043,
	   0.00000004229,     0.00000001382,
	  -0.00000000286,     0.00000000002,
	  -0.00000006409,    -0.00000001218,
	   0.00000000445,     0.00000000099,
	   0.00000000092,    -0.00000000010,
	  -0.00000001203,     0.00000006389,
	   0.00000000104,    -0.00000000440,
	  -0.00000000011,    -0.00000000092,
	   0.00000000908,     0.00000000160,
	   0.00000000188,    -0.00000000949,
	   0.00000000266,    -0.00000000884,
	  -0.00000000007,     0.00000000061,
	  -0.00000002919,    -0.00000000953,
	   0.00000000259,     0.00000000037,
	   0.00000005964,     0.00000001189,
	  -0.00000000415,    -0.00000000057,
	  -0.00000000086,     0.00000000008,
	   0.00000001197,    -0.00000005975,
	  -0.00000000058,     0.00000000415,
	   0.00000000008,     0.00000000086,
	  -0.00000000620,    -0.00000000112,
	  -0.00000000125,     0.00000000641,
	  -0.00000002429,    -0.00000000442,
	   0.00000000168,     0.00000000045,
	   0.00000000035,    -0.00000000004,
	  -0.00000002172,     0.00000009509,
	  -0.00000000003,    -0.00000000657,
	  -0.00000000007,    -0.00000000141,
	  -0.00000000615,    -0.00000019078,
	  -0.00000001615,     0.00000000527,
	   0.00000000033,     0.00000000070,
	  -0.00000019062,     0.00000000622,
	   0.00000000526,     0.00000001626,
	   0.00000000071,    -0.00000000033,
	  -0.00000000484,     0.00000002090,
	  -0.00000000193,    -0.00000000027,
	   0.00000002234,     0.00000000558,
	  -0.00000000043,     0.00000000202,
	   0.00000003065,     0.00000000557,
	  -0.00000000213,    -0.00000000057,
	  -0.00000000044,     0.00000000005,
	   0.00000001486,    -0.00000006505,
	   0.00000000003,     0.00000000448,
	   0.00000000005,     0.00000000096,
	   0.00000000568,     0.00000017374,
	   0.00000001471,    -0.00000000478,
	  -0.00000000029,    -0.00000000060,
	   0.00000017434,    -0.00000000543,
	  -0.00000000482,    -0.00000001473,
	  -0.00000000065,     0.00000000030,
	   0.00000000339,    -0.00000001428,
	   0.00000000134,     0.00000000019,
	  -0.00000001497,    -0.00000000374,
	   0.00000000027,    -0.00000000139,
	  -0.00000000427,    -0.00000012407,
	  -0.00000001050,     0.00000000345,
	   0.00000000021,     0.00000000046,
	  -0.00000034789,     0.00000000672,
	   0.00000000941,     0.00000003039,
	   0.00000000132,    -0.00000000061,
	   0.00000084190,    -0.00000000004,
	   0.00000000006,    -0.00000084482,
	  -0.00000000084,     0.00000000000,
	   0.00000000570,     0.00000000048,
	  -0.00000000025,    -0.00000000032,
	  -0.00000000105,     0.00000000077,
	   0.00000000472,     0.00000013702,
	   0.00000001154,    -0.00000000382,
	  -0.00000000024,    -0.00000000050,
	   0.00000023306,    -0.00000000444,
	  -0.00000000628,    -0.00000002018,
	  -0.00000000089,     0.00000000041,
	  -0.00000077808,     0.00000000058,
	  -0.00000000054,     0.00000078224,
	  -0.00000000390,     0.00000000005,
	   0.00000000020,     0.00000000035,
	   0.00000000070,     0.00000000108,
	   0.00000073026,     0.00000000025,
	   0.00000000002,    -0.00000000036,
	   0.00000000010,    -0.00000181822,
	  -0.00000000081,     0.00000000004,
	  -0.00000000047,    -0.00000003946,
	  -0.00000000025,     0.00000000076,
	   0.00000000902,     0.00000000221,
	  -0.00000000041,    -0.00000000439,
	  -0.00000000172,     0.00000002761,
	  -0.00000000066,    -0.00000000048,
	  -0.00000000716,    -0.00000000658,
	   0.00000000012,    -0.00000000245,
	  -0.00000069128,    -0.00000000023,
	  -0.00000000002,     0.00000000034,
	  -0.00000000007,     0.00000118606,
	   0.00000000057,    -0.00000000003,
	   0.00000000077,     0.00000002705,
	  -0.00000000045,    -0.00000000053,
	   0.00000000010,    -0.00000000152,
	   0.00000000013,     0.00000000300,
	  -0.00000000118,    -0.00000001890,
	  -0.00000000042,     0.00000000033,
	  -0.00000000506,     0.00000000450,
	   0.00000000010,     0.00000000168,
	  -0.00000000330,    -0.00000000953,
	   0.00000000170,    -0.00000000001,
	  -0.00000002208,     0.00000000444,
	   0.00000000009,    -0.00000000359,
	   0.00000019834,     0.00000000373,
	   0.00000000061,     0.00000000116,
	   0.00000000362,     0.00000021300,
	   0.00000000132,    -0.00000000056,
	   0.00000000152,    -0.00000000021,
	   0.00000000025,     0.00000000159,
	   0.00000000260,     0.00000000752,
	  -0.00000000134,     0.00000000001,
	   0.00000001469,    -0.00000000289,
	  -0.00000000001,     0.00000000250,
	  -0.00000008840,    -0.00000000252,
	  -0.00000000041,    -0.00000000079,
	  -0.00000000245,    -0.00000009832,
	  -0.00000000087,     0.00000000038,
	  -0.00000000104,     0.00000000018,
	  -0.00000000014,    -0.00000000093,
	  -0.00000000551,     0.00000000279,
	   0.00000000044,     0.00000000095,
	   0.00000000009,    -0.00000000004,
	   0.00000000747,     0.00000001486,
	   0.00000000258,    -0.00000000120,
	  -0.00000000142,    -0.00000000263,
	   0.00000000234,    -0.00000000137,
	   0.00000000261,     0.00000001130,
	   0.00000000097,    -0.00000000018,
	  -0.00000001150,     0.00000000278,
	   0.00000000023,     0.00000000103,
	   0.00000000348,    -0.00000000176,
	  -0.00000000028,    -0.00000000060,
	  -0.00000000511,    -0.00000001016,
	  -0.00000000176,     0.00000000082,
	   0.00000000060,     0.00000000116,
	  -0.00000000095,     0.00000000056,
	  -0.00000000177,    -0.00000000774,
	  -0.00000000066,     0.00000000012,
	   0.00000000794,    -0.00000000193,
	  -0.00000000016,    -0.00000000071,
	  -0.00000000044,     0.00000000012,
	  -0.00000000040,     0.00000000019,
	  -0.00000000029,    -0.00000000048,
	  -0.00000000051,     0.00000000026,
	  -0.00000000021,    -0.00000000047,
	   0.00000000036,    -0.00000000051,
	  -0.00000000051,    -0.00000000035,
	   0.00000000064,    -0.00000000092,
	  -0.00000000033,    -0.00000000027,
	  -0.00000000060,    -0.00000000042,
	   0.00000000030,    -0.00000000167,
	  -0.00000000050,    -0.00000000013,
	  -0.00000000165,    -0.00000000026,
	  -0.00000000011,     0.00000000049,
	   0.00000000051,    -0.00000000301,
	  -0.00000000090,    -0.00000000022,
	  -0.00000000203,    -0.00000000036,
	  -0.00000000015,     0.00000000061,
	  -0.00000000102,    -0.00000000394,
	  -0.00000000092,     0.00000000016,
	  -0.00000000382,     0.00000000110,
	   0.00000000020,     0.00000000088,
	   0.00000000012,     0.00000000043,
	   0.00000000093,    -0.00000000025,
	   0.00000000048,     0.00000000063,
	   0.00000000053,    -0.00000000050,
	  -0.00000000194,    -0.00000000709,
	  -0.00000000165,     0.00000000033,
	   0.00000000003,     0.00000000019,
	  -0.00000000497,     0.00000000134,
	   0.00000000023,     0.00000000115,
	  -0.00000000510,    -0.00000000630,
	  -0.00000000104,     0.00000000070,
	  -0.00000000586,     0.00000000518,
	   0.00000000073,     0.00000000091,
	   0.00000000064,     0.00000000076,
	   0.00000000012,    -0.00000000009,
	   0.00000000159,    -0.00000000134,
	   0.00000000102,     0.00000000062,
	   0.00000000030,    -0.00000000094,
	  -0.00000000943,    -0.00000001117,
	  -0.00000000180,     0.00000000131,
	   0.00000000010,     0.00000000014,
	  -0.00000000826,     0.00000000695,
	   0.00000000097,     0.00000000132,
	  -0.00000001060,    -0.00000000546,
	  -0.00000000055,     0.00000000080,
	  -0.00000000430,     0.00000001030,
	   0.00000000074,     0.00000000028,
	   0.00000000150,     0.00000000070,
	   0.00000000142,    -0.00000000303,
	   0.00000000105,     0.00000000033,
	  -0.00000000032,    -0.00000000050,
	  -0.00000001925,    -0.00000000901,
	  -0.00000000078,     0.00000000141,
	  -0.00000000714,     0.00000001525,
	   0.00000000112,     0.00000000061,
	  -0.00000000939,    -0.00000000113,
	   0.00000000096,     0.00000000765,
	   0.00000000146,     0.00000000002,
	   0.00000000002,    -0.00000000288,
	   0.00000000052,     0.00000000047,
	  -0.00000000024,     0.00000000100,
	  -0.00000001609,    -0.00000000018,
	  -0.00000000012,     0.00000001393,
	   0.00000000039,    -0.00000000216,
	  -0.00000000022,    -0.00000000452,
	  -0.00000000037,     0.00000000018,
	   0.00000000033,     0.00000000068,
	   0.00000000093,    -0.00000000002,
	  -0.00000000003,     0.00000000090,
	   0.00000000336,    -0.00000000168,
	  -0.00000000168,    -0.00000000343,
	  -0.00000000223,     0.00000000021,
	   0.00000000025,    -0.00000000194,
	   0.00000000034,    -0.00000000019,
	   0.00000000017,     0.00000000034,
	  -0.00000000011,    -0.00000000051,
	   0.00000000061,     0.00000000003,
	   0.00000000004,    -0.00000000107,
	   0.00000000053,    -0.00000000011,
	   0.00000000012,     0.00000000058,
	   0.00000000139,     0.00000000005,
	  -0.00000000005,     0.00000000139,
	  -0.00000000003,    -0.00000000003,
	  -0.00000000003,    -0.00000000009,
	   0.00000000009,    -0.00000000003,
	  -0.00000000111,    -0.00000000053,
	  -0.00000000053,     0.00000000111,
	   0.00000000106,     0.00000000052,
	   0.00000000052,    -0.00000000106,
	   0.00000000137,     0.00000000064,
	   0.00000000760,    -0.00000001555,
	   0.00000000012,     0.00000000189,
	  -0.00000000442,     0.00000001521,
	   0.00000000026,    -0.00000000107,
	   0.00000001516,     0.00000000438,
	  -0.00000000106,    -0.00000000026,
	   0.00000000092,    -0.00000000251,
	  -0.00000000260,    -0.00000000100,
	  -0.00000000204,    -0.00000000095,
	  -0.00000000524,     0.00000001074,
	   0.00000000001,    -0.00000000150,
	   0.00000000424,    -0.00000001432,
	  -0.00000000018,     0.00000000100,
	  -0.00000001434,    -0.00000000426,
	   0.00000000100,     0.00000000018,
	  -0.00000000063,     0.00000000172,
	   0.00000000176,     0.00000000067,
	  -0.00000000098,     0.00000000348,
	   0.00000000006,    -0.00000000025,
	   0.00000001593,     0.00000000506,
	  -0.00000000109,    -0.00000000012,
	  -0.00000003197,    -0.00000000537,
	   0.00000000220,     0.00000000089,
	   0.00000000046,    -0.00000000007,
	  -0.00000000533,     0.00000003192,
	   0.00000000091,    -0.00000000218,
	  -0.00000000007,    -0.00000000046,
	   0.00000000413,     0.00000000073,
	   0.00000000087,    -0.00000000434,
	   0.00000000133,    -0.00000000470,
	  -0.00000000009,     0.00000000033,
	  -0.00000001101,    -0.00000000349,
	   0.00000000101,     0.00000000024,
	   0.00000002975,     0.00000000524,
	  -0.00000000205,    -0.00000000067,
	   0.00000000529,    -0.00000002983,
	  -0.00000000068,     0.00000000206,
	  -0.00000000282,    -0.00000000051,
	  -0.00000000058,     0.00000000293,
	  -0.00000001725,    -0.00000000277,
	   0.00000000119,     0.00000000052,
	   0.00000000025,    -0.00000000004,
	  -0.00000001180,     0.00000005667,
	   0.00000000068,    -0.00000000388,
	  -0.00000000008,    -0.00000000084,
	  -0.00000000413,    -0.00000012240,
	  -0.00000001037,     0.00000000338,
	   0.00000000020,     0.00000000041,
	  -0.00000012257,     0.00000000409,
	   0.00000000339,     0.00000001045,
	   0.00000000042,    -0.00000000020,
	  -0.00000000269,     0.00000001155,
	  -0.00000000109,    -0.00000000014,
	   0.00000001252,     0.00000000315,
	  -0.00000000024,     0.00000000114,
	   0.00000002099,     0.00000000337,
	  -0.00000000145,    -0.00000000064,
	  -0.00000000030,     0.00000000005,
	   0.00000000807,    -0.00000003877,
	  -0.00000000046,     0.00000000264,
	   0.00000000005,     0.00000000057,
	   0.00000000383,     0.00000011207,
	   0.00000000949,    -0.00000000308,
	  -0.00000000019,    -0.00000000038,
	   0.00000011260,    -0.00000000362,
	  -0.00000000311,    -0.00000000951,
	  -0.00000000039,     0.00000000019,
	   0.00000000189,    -0.00000000789,
	   0.00000000076,     0.00000000010,
	  -0.00000000834,    -0.00000000211,
	   0.00000000015,    -0.00000000078,
	  -0.00000000322,    -0.00000009131,
	  -0.00000000770,     0.00000000254,
	   0.00000000016,     0.00000000033,
	  -0.00000023251,     0.00000000492,
	   0.00000000630,     0.00000002020,
	   0.00000000088,    -0.00000000041,
	   0.00000052756,    -0.00000000008,
	   0.00000000029,    -0.00000053130,
	  -0.00000000065,     0.00000000003,
	   0.00000000403,     0.00000000031,
	  -0.00000000075,     0.00000000058,
	   0.00000000349,     0.00000009879,
	   0.00000000832,    -0.00000000275,
	  -0.00000000017,    -0.00000000036,
	   0.00000015594,    -0.00000000327,
	  -0.00000000421,    -0.00000001349,
	  -0.00000000059,     0.00000000027,
	  -0.00000048964,     0.00000000035,
	  -0.00000000050,     0.00000049329,
	  -0.00000000276,     0.00000000007,
	   0.00000000051,     0.00000000080,
	   0.00000049057,     0.00000000028,
	   0.00000000003,    -0.00000000031,
	   0.00000000025,    -0.00000114451,
	  -0.00000000064,    -0.00000000002,
	  -0.00000000087,    -0.00000003268,
	  -0.00000000027,     0.00000000064,
	   0.00000000906,     0.00000000168,
	  -0.00000000041,    -0.00000000361,
	  -0.00000000116,     0.00000001806,
	  -0.00000000045,    -0.00000000031,
	  -0.00000000479,    -0.00000000431,
	   0.00000000007,    -0.00000000161,
	  -0.00000046439,    -0.00000000027,
	  -0.00000000003,     0.00000000029,
	  -0.00000000017,     0.00000074962,
	   0.00000000097,     0.00000002198,
	  -0.00000000037,    -0.00000000042,
	  -0.00000000068,    -0.00000000130,
	   0.00000000015,     0.00000000247,
	  -0.00000000079,    -0.00000001236,
	  -0.00000000028,     0.00000000021,
	  -0.00000000341,     0.00000000295,
	   0.00000000007,     0.00000000111,
	  -0.00000000272,    -0.00000000826,
	   0.00000000147,    -0.00000000001,
	  -0.00000001844,     0.00000000375,
	   0.00000000006,    -0.00000000302,
	   0.00000014421,     0.00000000286,
	   0.00000000046,     0.00000000086,
	   0.00000000271,     0.00000015533,
	   0.00000000101,    -0.00000000042,
	   0.00000000128,    -0.00000000020,
	   0.00000000021,     0.00000000128,
	   0.00000000221,     0.00000000670,
	  -0.00000000119,     0.00000000001,
	   0.00000001229,    -0.00000000245,
	  -0.00000000001,     0.00000000209,
	  -0.00000006495,    -0.00000000201,
	  -0.00000000032,    -0.00000000061,
	  -0.00000000192,    -0.00000007279,
	  -0.00000000069,     0.00000000030,
	  -0.00000000087,     0.00000000017,
	  -0.00000000012,    -0.00000000075,
	  -0.00000000447,     0.00000000227,
	   0.00000000035,     0.00000000076,
	   0.00000000007,    -0.00000000003,
	   0.00000000569,     0.00000001129,
	   0.00000000195,    -0.00000000091,
	  -0.00000000119,    -0.00000000235,
	   0.00000000217,    -0.00000000118,
	   0.00000000180,     0.00000000783,
	   0.00000000067,    -0.00000000013,
	  -0.00000000798,     0.00000000193,
	   0.00000000016,     0.00000000071,
	   0.00000000302,    -0.00000000154,
	  -0.00000000024,    -0.00000000052,
	  -0.00000000389,    -0.00000000772,
	  -0.00000000133,     0.00000000062,
	   0.00000000051,     0.00000000102,
	  -0.00000000089,     0.00000000050,
	  -0.00000000122,    -0.00000000536,
	  -0.00000000046,     0.00000000008,
	   0.00000000552,    -0.00000000135,
	  -0.00000000011,    -0.00000000050,
	  -0.00000000055,     0.00000000027,
	  -0.00000000035,    -0.00000000061,
	   0.00000000023,    -0.00000000033,
	  -0.00000000032,    -0.00000000022,
	   0.00000000042,    -0.00000000060,
	  -0.00000000022,    -0.00000000017,
	  -0.00000000038,    -0.00000000027,
	   0.00000000018,    -0.00000000100,
	  -0.00000000099,    -0.00000000015,
	   0.00000000032,    -0.00000000186,
	  -0.00000000056,    -0.00000000014,
	  -0.00000000122,    -0.00000000021,
	  -0.00000000056,    -0.00000000221,
	  -0.00000000052,     0.00000000009,
	  -0.00000000212,     0.00000000062,
	   0.00000000011,     0.00000000049,
	   0.00000000052,    -0.00000000014,
	   0.00000000024,     0.00000000033,
	   0.00000000025,    -0.00000000025,
	  -0.00000000111,    -0.00000000406,
	  -0.00000000094,     0.00000000019,
	  -0.00000000279,     0.00000000075,
	   0.00000000013,     0.00000000065,
	  -0.00000000259,    -0.00000000325,
	  -0.00000000054,     0.00000000035,
	  -0.00000000295,     0.00000000264,
	   0.00000000038,     0.00000000045,
	   0.00000000035,     0.00000000041,
	   0.00000000082,    -0.00000000069,
	   0.00000000047,     0.00000000031,
	   0.00000000010,    -0.00000000041,
	  -0.00000000492,    -0.00000000584,
	  -0.00000000094,     0.00000000068,
	  -0.00000000423,     0.00000000355,
	   0.00000000050,     0.00000000068,
	  -0.00000000484,    -0.00000000259,
	  -0.00000000027,     0.00000000037,
	  -0.00000000186,     0.00000000464,
	   0.00000000071,     0.00000000034,
	   0.00000000065,    -0.00000000138,
	   0.00000000045,     0.00000000020,
	  -0.00000000897,    -0.00000000422,
	  -0.00000000036,     0.00000000066,
	  -0.00000000325,     0.00000000692,
	   0.00000000051,     0.00000000028,
	  -0.00000000372,    -0.00000000064,
	   0.00000000055,     0.00000000272,
	   0.00000000058,     0.00000000001,
	   0.00000000001,    -0.00000000109,
	   0.00000000027,     0.00000000024,
	  -0.00000000013,     0.00000000050,
	  -0.00000000633,    -0.00000000010,
	  -0.00000000007,     0.00000000527,
	   0.00000000018,    -0.00000000108,
	  -0.00000000010,    -0.00000000226,
	   0.00000000017,     0.00000000034,
	   0.00000000179,    -0.00000000089,
	  -0.00000000084,    -0.00000000172,
	  -0.00000000097,     0.00000000013,
	   0.00000000016,    -0.00000000078,
	  -0.00000000034,    -0.00000000020,
	  -0.00000000055,    -0.00000000017,
	   0.00000000163,    -0.00000000132,
	  -0.00000000110,     0.00000000091,
	   0.00000000014,     0.00000000007,
	   0.00000000008,     0.00000000004,
	   0.00000000004,    -0.00000000007,
	   0.00000000870,    -0.00000001373,
	   0.00000000008,     0.00000000215,
	  -0.00000000016,     0.00000000025,
	  -0.00001109612,    -0.00000709634,
	   0.00000173774,    -0.00000007188,
	   0.00000020095,     0.00000012827,
	   0.00000015951,     0.00000007283,
	  -0.00000001846,    -0.00000000160,
	  -0.00000000262,    -0.00000000094,
	   0.00000007223,    -0.00000015897,
	  -0.00000000163,     0.00000001825,
	  -0.00000000091,     0.00000000259,
	  -0.00000002945,    -0.00000001434,
	   0.00000000319,    -0.00000000094,
	   0.00000000040,     0.00000000016,
	  -0.00000001540,     0.00000003037,
	  -0.00000000102,    -0.00000000347,
	   0.00000000018,    -0.00000000041,
	  -0.00000001338,     0.00000002112,
	  -0.00000000012,    -0.00000000331,
	   0.00000000024,    -0.00000000038,
	   0.00000759750,     0.00000485907,
	  -0.00000119205,     0.00000004765,
	  -0.00000013776,    -0.00000008780,
	  -0.00000015176,    -0.00000007034,
	   0.00000001769,     0.00000000073,
	   0.00000000241,     0.00000000098,
	  -0.00000007061,     0.00000015199,
	   0.00000000075,    -0.00000001774,
	   0.00000000103,    -0.00000000240,
	   0.00000002010,     0.00000000977,
	  -0.00000000220,     0.00000000066,
	   0.00000001031,    -0.00000002058,
	   0.00000000069,     0.00000000234,
	   0.00000000053,     0.00000000023,
	   0.00000000144,    -0.00000000299,
	  -0.00000000147,     0.00000000537,
	   0.00000000014,    -0.00000000039,
	   0.00000000536,     0.00000000146,
	  -0.00000000038,    -0.00000000015,
	   0.00000000028,    -0.00000000082,
	  -0.00000000085,    -0.00000000031,
	  -0.00000000076,    -0.00000000033,
	  -0.00000000100,     0.00000000208,
	   0.00000000141,    -0.00000000505,
	  -0.00000000506,    -0.00000000142,
	  -0.00000000020,     0.00000000056,
	   0.00000000057,     0.00000000021,
	  -0.00000000063,     0.00000000236,
	   0.00000000007,    -0.00000000017,
	   0.00000000870,     0.00000000266,
	  -0.00000000060,    -0.00000000014,
	  -0.00000001968,    -0.00000000293,
	   0.00000000134,     0.00000000075,
	  -0.00000000292,     0.00000001968,
	   0.00000000076,    -0.00000000134,
	   0.00000000233,     0.00000000041,
	   0.00000000050,    -0.00000000247,
	   0.00000000082,    -0.00000000307,
	  -0.00000000009,     0.00000000022,
	  -0.00000000602,    -0.00000000184,
	   0.00000000055,     0.00000000018,
	   0.00000001832,     0.00000000286,
	  -0.00000000125,    -0.00000000062,
	   0.00000000290,    -0.00000001839,
	  -0.00000000062,     0.00000000126,
	  -0.00000000159,    -0.00000000029,
	  -0.00000000033,     0.00000000166,
	  -0.00000001275,    -0.00000000181,
	   0.00000000087,     0.00000000052,
	   0.00000000018,    -0.00000000004,
	  -0.00000000700,     0.00000003700,
	   0.00000000085,    -0.00000000251,
	  -0.00000000007,    -0.00000000054,
	  -0.00000000288,    -0.00000008257,
	  -0.00000000697,     0.00000000227,
	  -0.00000008288,     0.00000000280,
	   0.00000000230,     0.00000000703,
	  -0.00000000159,     0.00000000681,
	  -0.00000000065,    -0.00000000008,
	   0.00000000750,     0.00000000191,
	  -0.00000000014,     0.00000000068,
	   0.00000001508,     0.00000000215,
	  -0.00000000103,    -0.00000000061,
	  -0.00000000021,     0.00000000004,
	   0.00000000479,    -0.00000002531,
	  -0.00000000058,     0.00000000171,
	   0.00000000268,     0.00000007593,
	   0.00000000643,    -0.00000000209,
	   0.00000007639,    -0.00000000252,
	  -0.00000000212,    -0.00000000645,
	   0.00000000113,    -0.00000000465,
	   0.00000000046,     0.00000000005,
	  -0.00000000496,    -0.00000000127,
	   0.00000000008,    -0.00000000047,
	  -0.00000000243,    -0.00000006756,
	  -0.00000000571,     0.00000000188,
	   0.00000000012,     0.00000000025,
	  -0.00000015993,     0.00000000364,
	   0.00000000434,     0.00000001389,
	   0.00000000060,    -0.00000000028,
	   0.00000033948,    -0.00000000006,
	   0.00000000036,    -0.00000034327,
	  -0.00000000051,     0.00000000005,
	   0.00000000289,     0.00000000021,
	  -0.00000000055,     0.00000000043,
	   0.00000000258,     0.00000007195,
	   0.00000000605,    -0.00000000200,
	  -0.00000000012,    -0.00000000026,
	   0.00000010738,    -0.00000000242,
	  -0.00000000290,    -0.00000000928,
	  -0.00000000037,     0.00000000018,
	  -0.00000031620,     0.00000000019,
	  -0.00000000044,     0.00000031929,
	  -0.00000000198,     0.00000000007,
	   0.00000000038,     0.00000000059,
	   0.00000033240,     0.00000000029,
	   0.00000000004,    -0.00000000026,
	   0.00000000031,    -0.00000073623,
	  -0.00000000051,    -0.00000000005,
	  -0.00000000095,    -0.00000002628,
	  -0.00000000025,     0.00000000051,
	   0.00000000818,     0.00000000126,
	  -0.00000000037,    -0.00000000290,
	  -0.00000000079,     0.00000001197,
	  -0.00000000031,    -0.00000000020,
	  -0.00000000322,    -0.00000000287,
	   0.00000000005,    -0.00000000108,
	  -0.00000031465,    -0.00000000027,
	  -0.00000000004,     0.00000000024,
	  -0.00000000021,     0.00000048385,
	   0.00000000096,     0.00000001744,
	  -0.00000000030,    -0.00000000032,
	  -0.00000000098,    -0.00000000105,
	   0.00000000015,     0.00000000198,
	  -0.00000000053,    -0.00000000820,
	  -0.00000000233,     0.00000000196,
	   0.00000000005,     0.00000000074,
	  -0.00000000217,    -0.00000000687,
	   0.00000000122,    -0.00000000001,
	  -0.00000001482,     0.00000000303,
	   0.00000000004,    -0.00000000246,
	   0.00000010350,     0.00000000219,
	   0.00000000035,     0.00000000063,
	   0.00000000203,     0.00000011191,
	   0.00000000076,    -0.00000000031,
	   0.00000000104,    -0.00000000018,
	   0.00000000017,     0.00000000101,
	   0.00000000180,     0.00000000569,
	  -0.00000000101,     0.00000000001,
	   0.00000000990,    -0.00000000199,
	   0.00000000000,     0.00000000170,
	  -0.00000004693,    -0.00000000158,
	  -0.00000000025,    -0.00000000047,
	  -0.00000000149,    -0.00000005306,
	  -0.00000000054,     0.00000000023,
	  -0.00000000071,     0.00000000015,
	  -0.00000000009,    -0.00000000059,
	  -0.00000000357,     0.00000000182,
	   0.00000000028,     0.00000000060,
	   0.00000000430,     0.00000000854,
	   0.00000000146,    -0.00000000068,
	  -0.00000000096,    -0.00000000204,
	   0.00000000193,    -0.00000000098,
	   0.00000000125,     0.00000000543,
	   0.00000000047,    -0.00000000009,
	  -0.00000000554,     0.00000000134,
	   0.00000000011,     0.00000000050,
	   0.00000000253,    -0.00000000129,
	  -0.00000000020,    -0.00000000043,
	  -0.00000000294,    -0.00000000584,
	  -0.00000000100,     0.00000000046,
	   0.00000000042,     0.00000000089,
	  -0.00000000080,     0.00000000042,
	  -0.00000000084,    -0.00000000372,
	   0.00000000384,    -0.00000000094,
	  -0.00000000057,     0.00000000028,
	  -0.00000000035,    -0.00000000063,
	   0.00000000011,    -0.00000000060,
	  -0.00000000059,    -0.00000000009,
	   0.00000000019,    -0.00000000113,
	  -0.00000000034,    -0.00000000008,
	  -0.00000000073,    -0.00000000013,
	  -0.00000000030,    -0.00000000123,
	  -0.00000000116,     0.00000000035,
	  -0.00000000062,    -0.00000000229,
	  -0.00000000053,     0.00000000011,
	  -0.00000000155,     0.00000000042,
	  -0.00000000130,    -0.00000000167,
	  -0.00000000147,     0.00000000134,
	   0.00000000018,     0.00000000022,
	   0.00000000041,    -0.00000000035,
	  -0.00000000253,    -0.00000000302,
	  -0.00000000048,     0.00000000035,
	  -0.00000000215,     0.00000000180,
	   0.00000000025,     0.00000000034,
	  -0.00000000220,    -0.00000000123,
	  -0.00000000078,     0.00000000208,
	   0.00000000033,     0.00000000016,
	   0.00000000029,    -0.00000000062,
	  -0.00000000414,    -0.00000000196,
	  -0.00000000017,     0.00000000030,
	  -0.00000000148,     0.00000000312,
	  -0.00000000147,    -0.00000000035,
	   0.00000000030,     0.00000000092,
	  -0.00000000244,    -0.00000000005,
	  -0.00000000004,     0.00000000197,
	   0.00000000008,    -0.00000000052,
	  -0.00000000004,    -0.00000000110,
	   0.00000000091,    -0.00000000045,
	  -0.00000000041,    -0.00000000084,
	   0.00000000041,     0.00000000034,
	  -0.00000000073,    -0.00000000046,
	   0.00000000101,     0.00000000043,
	   0.00000000043,    -0.00000000101,
	   0.00000000032,     0.00000000020,
	  -0.00000000096,    -0.00000000042,
	  -0.00000000042,     0.00000000096,
	   0.00000000033,     0.00000000014,
	   0.00000000064,    -0.00000000138,
	  -0.00000000078,     0.00000000304,
	   0.00000000304,     0.00000000078,
	   0.00000000014,    -0.00000000043,
	  -0.00000000045,    -0.00000000016,
	  -0.00000000045,    -0.00000000019,
	  -0.00000000044,     0.00000000096,
	   0.00000000075,    -0.00000000286,
	  -0.00000000286,    -0.00000000076,
	  -0.00000000043,     0.00000000172,
	   0.00000000006,    -0.00000000013,
	   0.00000000550,     0.00000000161,
	  -0.00000000038,    -0.00000000013,
	  -0.00000001320,    -0.00000000175,
	   0.00000000089,     0.00000000062,
	  -0.00000000175,     0.00000001322,
	   0.00000000063,    -0.00000000089,
	   0.00000000144,     0.00000000026,
	   0.00000000031,    -0.00000000154,
	   0.00000000054,    -0.00000000217,
	  -0.00000000380,    -0.00000000111,
	   0.00000000034,     0.00000000014,
	   0.00000001229,     0.00000000171,
	  -0.00000000083,    -0.00000000053,
	   0.00000000174,    -0.00000001235,
	  -0.00000000054,     0.00000000084,
	  -0.00000000098,    -0.00000000018,
	  -0.00000000021,     0.00000000103,
	  -0.00000000960,    -0.00000000122,
	   0.00000000065,     0.00000000047,
	   0.00000000014,    -0.00000000003,
	  -0.00000000436,     0.00000002539,
	   0.00000000084,    -0.00000000171,
	  -0.00000000205,    -0.00000005723,
	  -0.00000000484,     0.00000000157,
	  -0.00000005759,     0.00000000197,
	   0.00000000160,     0.00000000489,
	  -0.00000000099,     0.00000000418,
	   0.00000000468,     0.00000000120,
	  -0.00000000009,     0.00000000043,
	   0.00000001111,     0.00000000141,
	  -0.00000000075,    -0.00000000055,
	  -0.00000000016,     0.00000000004,
	   0.00000000298,    -0.00000001736,
	  -0.00000000057,     0.00000000116,
	   0.00000000191,     0.00000005282,
	   0.00000000448,    -0.00000000145,
	   0.00000005322,    -0.00000000178,
	  -0.00000000147,    -0.00000000450,
	   0.00000000070,    -0.00000000285,
	  -0.00000000307,    -0.00000000080,
	  -0.00000000182,    -0.00000005008,
	  -0.00000000424,     0.00000000139,
	   0.00000000009,     0.00000000018,
	  -0.00000011197,     0.00000000270,
	   0.00000000304,     0.00000000967,
	   0.00000000038,    -0.00000000019,
	   0.00000022244,    -0.00000000003,
	   0.00000000035,    -0.00000022594,
	   0.00000000209,     0.00000000014,
	  -0.00000000040,     0.00000000032,
	   0.00000000192,     0.00000005267,
	   0.00000000443,    -0.00000000146,
	  -0.00000000009,    -0.00000000019,
	   0.00000007525,    -0.00000000180,
	  -0.00000000204,    -0.00000000651,
	  -0.00000020783,     0.00000000009,
	  -0.00000000037,     0.00000021039,
	  -0.00000000143,     0.00000000006,
	   0.00000000028,     0.00000000044,
	   0.00000022672,     0.00000000027,
	   0.00000000004,    -0.00000000021,
	   0.00000000033,    -0.00000048126,
	  -0.00000000089,    -0.00000002073,
	  -0.00000000021,     0.00000000040,
	   0.00000000698,     0.00000000094,
	  -0.00000000032,    -0.00000000229,
	  -0.00000000055,     0.00000000802,
	  -0.00000000218,    -0.00000000193,
	   0.00000000003,    -0.00000000073,
	  -0.00000021462,    -0.00000000026,
	  -0.00000000022,     0.00000031720,
	   0.00000000085,     0.00000001362,
	  -0.00000000024,    -0.00000000024,
	  -0.00000000103,    -0.00000000083,
	   0.00000000014,     0.00000000156,
	  -0.00000000036,    -0.00000000549,
	  -0.00000000160,     0.00000000132,
	   0.00000000003,     0.00000000050,
	  -0.00000000170,    -0.00000000556,
	   0.00000000100,    -0.00000000001,
	  -0.00000001163,     0.00000000239,
	   0.00000000002,    -0.00000000195,
	   0.00000007373,     0.00000000167,
	   0.00000000027,     0.00000000046,
	   0.00000000151,     0.00000008007,
	   0.00000000058,    -0.00000000023,
	   0.00000000083,    -0.00000000015,
	   0.00000000013,     0.00000000079,
	   0.00000000143,     0.00000000468,
	  -0.00000000084,     0.00000000001,
	   0.00000000778,    -0.00000000158,
	   0.00000000001,     0.00000000135,
	  -0.00000003358,    -0.00000000123,
	  -0.00000000019,    -0.00000000035,
	  -0.00000000115,    -0.00000003832,
	  -0.00000000041,     0.00000000017,
	  -0.00000000056,     0.00000000012,
	  -0.00000000007,    -0.00000000045,
	  -0.00000000281,     0.00000000143,
	   0.00000000022,     0.00000000047,
	   0.00000000324,     0.00000000642,
	   0.00000000109,    -0.00000000051,
	  -0.00000000076,    -0.00000000171,
	   0.00000000166,    -0.00000000079,
	   0.00000000086,     0.00000000377,
	  -0.00000000386,     0.00000000093,
	   0.00000000207,    -0.00000000105,
	  -0.00000000016,    -0.00000000035,
	  -0.00000000222,    -0.00000000439,
	  -0.00000000074,     0.00000000035,
	   0.00000000033,     0.00000000075,
	  -0.00000000070,     0.00000000035,
	  -0.00000000058,    -0.00000000259,
	   0.00000000268,    -0.00000000066,
	  -0.00000000054,     0.00000000027,
	  -0.00000000032,    -0.00000000058,
	   0.00000000012,    -0.00000000068,
	  -0.00000000043,    -0.00000000008,
	  -0.00000000016,    -0.00000000068,
	  -0.00000000063,     0.00000000019,
	  -0.00000000035,    -0.00000000127,
	  -0.00000000085,     0.00000000023,
	  -0.00000000065,    -0.00000000085,
	  -0.00000000072,     0.00000000067,
	  -0.00000000129,    -0.00000000154,
	  -0.00000000025,     0.00000000018,
	  -0.00000000108,     0.00000000090,
	  -0.00000000099,    -0.00000000059,
	  -0.00000000032,     0.00000000092,
	  -0.00000000188,    -0.00000000090,
	  -0.00000000067,     0.00000000140,
	  -0.00000000057,    -0.00000000019,
	  -0.00000000091,    -0.00000000003,
	  -0.00000000002,     0.00000000072,
	  -0.00000000002,    -0.00000000052,
	  -0.00000000019,    -0.00000000040,
	   0.00000000022,    -0.00000000028,
	   0.00000000048,     0.00000000019,
	   0.00000000019,    -0.00000000047,
	  -0.00000000045,    -0.00000000019,
	  -0.00000000019,     0.00000000045,
	   0.00000000036,    -0.00000000081,
	  -0.00000000048,     0.00000000199,
	   0.00000000199,     0.00000000048,
	  -0.00000000025,     0.00000000057,
	   0.00000000046,    -0.00000000186,
	  -0.00000000187,    -0.00000000047,
	  -0.00000000031,     0.00000000130,
	   0.00000000374,     0.00000000104,
	  -0.00000000924,    -0.00000000109,
	   0.00000000062,     0.00000000051,
	  -0.00000000110,     0.00000000927,
	   0.00000000052,    -0.00000000062,
	   0.00000000093,     0.00000000017,
	   0.00000000021,    -0.00000000101,
	   0.00000000038,    -0.00000000160,
	  -0.00000000259,    -0.00000000072,
	   0.00000000861,     0.00000000107,
	  -0.00000000058,    -0.00000000045,
	   0.00000000109,    -0.00000000866,
	  -0.00000000045,     0.00000000059,
	  -0.00000000064,    -0.00000000012,
	  -0.00000000014,     0.00000000067,
	  -0.00000000730,    -0.00000000083,
	   0.00000000049,     0.00000000042,
	   0.00000000010,    -0.00000000003,
	  -0.00000000280,     0.00000001794,
	   0.00000000075,    -0.00000000120,
	  -0.00000000148,    -0.00000004032,
	  -0.00000000341,     0.00000000110,
	  -0.00000004067,     0.00000000140,
	   0.00000000113,     0.00000000346,
	  -0.00000000063,     0.00000000263,
	   0.00000000300,     0.00000000078,
	   0.00000000829,     0.00000000094,
	  -0.00000000056,    -0.00000000047,
	  -0.00000000012,     0.00000000003,
	   0.00000000192,    -0.00000001227,
	  -0.00000000052,     0.00000000082,
	   0.00000000137,     0.00000003732,
	   0.00000000317,    -0.00000000102,
	   0.00000003765,    -0.00000000128,
	  -0.00000000104,    -0.00000000319,
	   0.00000000045,    -0.00000000179,
	  -0.00000000195,    -0.00000000052,
	  -0.00000000136,    -0.00000003713,
	  -0.00000000313,     0.00000000103,
	   0.00000000006,     0.00000000014,
	  -0.00000007928,     0.00000000200,
	   0.00000000215,     0.00000000685,
	   0.00000014765,    -0.00000000001,
	   0.00000000031,    -0.00000015072,
	   0.00000000152,     0.00000000010,
	  -0.00000000029,     0.00000000024,
	   0.00000000142,     0.00000003867,
	   0.00000000326,    -0.00000000107,
	  -0.00000000007,    -0.00000000014,
	   0.00000005334,    -0.00000000134,
	  -0.00000000144,    -0.00000000461,
	  -0.00000013834,     0.00000000003,
	  -0.00000000031,     0.00000014044,
	  -0.00000000104,     0.00000000005,
	   0.00000000021,     0.00000000033,
	   0.00000015546,     0.00000000024,
	   0.00000000004,    -0.00000000017,
	   0.00000000031,    -0.00000031849,
	  -0.00000000077,    -0.00000001613,
	   0.00000000576,     0.00000000069,
	  -0.00000000026,    -0.00000000179,
	  -0.00000000038,     0.00000000541,
	  -0.00000000149,    -0.00000000131,
	   0.00000000002,    -0.00000000049,
	  -0.00000014716,    -0.00000000023,
	  -0.00000000021,     0.00000021044,
	   0.00000000071,     0.00000001051,
	  -0.00000000097,    -0.00000000065,
	   0.00000000012,     0.00000000122,
	  -0.00000000024,    -0.00000000371,
	  -0.00000000110,     0.00000000089,
	  -0.00000000132,    -0.00000000441,
	   0.00000000080,    -0.00000000001,
	  -0.00000000898,     0.00000000184,
	   0.00000000000,    -0.00000000153,
	   0.00000005230,     0.00000000128,
	   0.00000000020,     0.00000000033,
	   0.00000000112,     0.00000005707,
	   0.00000000044,    -0.00000000017,
	   0.00000000065,    -0.00000000012,
	   0.00000000010,     0.00000000061,
	   0.00000000112,     0.00000000376,
	  -0.00000000068,     0.00000000001,
	   0.00000000602,    -0.00000000122,
	   0.00000000001,     0.00000000105,
	  -0.00000002389,    -0.00000000095,
	  -0.00000000087,    -0.00000002753,
	  -0.00000000044,     0.00000000010,
	  -0.00000000219,     0.00000000112,
	   0.00000000017,     0.00000000036,
	   0.00000000243,     0.00000000482,
	   0.00000000081,    -0.00000000038,
	  -0.00000000059,    -0.00000000141,
	   0.00000000138,    -0.00000000063,
	   0.00000000060,     0.00000000263,
	  -0.00000000269,     0.00000000065,
	   0.00000000166,    -0.00000000085,
	  -0.00000000013,    -0.00000000027,
	  -0.00000000166,    -0.00000000330,
	  -0.00000000055,     0.00000000026,
	   0.00000000026,     0.00000000062,
	  -0.00000000060,     0.00000000028,
	  -0.00000000040,    -0.00000000180,
	   0.00000000187,    -0.00000000046,
	  -0.00000000047,     0.00000000023,
	  -0.00000000028,    -0.00000000051,
	   0.00000000521,    -0.00000000946,
	  -0.00000001389,    -0.00000000774,
	  -0.00000000019,    -0.00000000069,
	  -0.00000000046,     0.00000000012,
	  -0.00000000032,    -0.00000000043,
	  -0.00000000035,     0.00000000033,
	  -0.00000000064,    -0.00000000077,
	  -0.00000000054,     0.00000000045,
	  -0.00000000044,    -0.00000000028,
	  -0.00000000013,     0.00000000040,
	  -0.00000000085,    -0.00000000041,
	  -0.00000000030,     0.00000000062,
	   0.00000000023,    -0.00000000054,
	  -0.00000000032,     0.00000000139,
	   0.00000000139,     0.00000000032,
	  -0.00000000016,     0.00000000037,
	   0.00000000030,    -0.00000000130,
	  -0.00000000131,    -0.00000000031,
	  -0.00000000022,     0.00000000100,
	   0.00000000265,     0.00000000070,
	  -0.00000000663,    -0.00000000070,
	   0.00000000044,     0.00000000041,
	  -0.00000000071,     0.00000000667,
	   0.00000000042,    -0.00000000045,
	   0.00000000062,     0.00000000011,
	   0.00000000014,    -0.00000000068,
	   0.00000000027,    -0.00000000121,
	  -0.00000000183,    -0.00000000049,
	   0.00000000619,     0.00000000069,
	  -0.00000000042,    -0.00000000037,
	   0.00000000070,    -0.00000000623,
	  -0.00000000037,     0.00000000042,
	  -0.00000000043,    -0.00000000008,
	  -0.00000000009,     0.00000000045,
	  -0.00000000558,    -0.00000000056,
	   0.00000000038,     0.00000000036,
	   0.00000000008,    -0.00000000002,
	  -0.00000000184,     0.00000001292,
	   0.00000000065,    -0.00000000086,
	  -0.00000000107,    -0.00000002869,
	  -0.00000000243,     0.00000000078,
	  -0.00000002902,     0.00000000100,
	   0.00000000081,     0.00000000247,
	  -0.00000000040,     0.00000000168,
	   0.00000000196,     0.00000000051,
	   0.00000000624,     0.00000000063,
	  -0.00000000042,    -0.00000000040,
	   0.00000000126,    -0.00000000884,
	  -0.00000000044,     0.00000000058,
	   0.00000000100,     0.00000002663,
	   0.00000000226,    -0.00000000073,
	   0.00000002691,    -0.00000000092,
	  -0.00000000075,    -0.00000000228,
	   0.00000000029,    -0.00000000115,
	  -0.00000000127,    -0.00000000034,
	  -0.00000000102,    -0.00000002752,
	  -0.00000000232,     0.00000000076,
	   0.00000000005,     0.00000000010,
	  -0.00000005657,     0.00000000148,
	   0.00000000153,     0.00000000489,
	   0.00000009896,     0.00000000001,
	   0.00000000027,    -0.00000010157,
	   0.00000000110,     0.00000000007,
	   0.00000000105,     0.00000002842,
	   0.00000000240,    -0.00000000079,
	  -0.00000000005,    -0.00000000010,
	   0.00000003809,    -0.00000000099,
	  -0.00000000103,    -0.00000000330,
	  -0.00000009297,     0.00000000000,
	  -0.00000000025,     0.00000009466,
	  -0.00000000075,     0.00000000004,
	   0.00000010705,     0.00000000021,
	   0.00000000028,    -0.00000021283,
	  -0.00000000064,    -0.00000001242,
	   0.00000000464,     0.00000000051,
	  -0.00000000021,    -0.00000000138,
	  -0.00000000026,     0.00000000368,
	  -0.00000000101,    -0.00000000089,
	  -0.00000010134,    -0.00000000020,
	  -0.00000000019,     0.00000014092,
	   0.00000000058,     0.00000000804,
	  -0.00000000085,    -0.00000000050,
	   0.00000000010,     0.00000000094,
	  -0.00000000016,    -0.00000000252,
	  -0.00000000077,     0.00000000061,
	  -0.00000000100,    -0.00000000345,
	   0.00000000063,    -0.00000000001,
	  -0.00000000685,     0.00000000140,
	  -0.00000000001,    -0.00000000119,
	   0.00000003700,     0.00000000097,
	   0.00000000082,     0.00000004058,
	   0.00000000050,    -0.00000000010,
	   0.00000000008,     0.00000000046,
	   0.00000000086,     0.00000000297,
	  -0.00000000054,     0.00000000001,
	   0.00000000460,    -0.00000000093,
	   0.00000000001,     0.00000000082,
	  -0.00000001693,    -0.00000000073,
	  -0.00000000066,    -0.00000001971,
	  -0.00000000169,     0.00000000086,
	   0.00000000013,     0.00000000028,
	   0.00000000182,     0.00000000360,
	   0.00000000060,    -0.00000000028,
	  -0.00000000045,    -0.00000000113,
	   0.00000000113,    -0.00000000049,
	   0.00000000042,     0.00000000183,
	  -0.00000000188,     0.00000000045,
	   0.00000000131,    -0.00000000067,
	  -0.00000000010,    -0.00000000021,
	  -0.00000000125,    -0.00000000247,
	  -0.00000000041,     0.00000000019,
	   0.00000000020,     0.00000000050,
	  -0.00000000050,     0.00000000022,
	  -0.00000000028,    -0.00000000126,
	   0.00000000131,    -0.00000000032,
	  -0.00000000040,     0.00000000020,
	  -0.00000000023,    -0.00000000043,
	   0.00000000016,    -0.00000000038,
	  -0.00000000022,     0.00000000100,
	   0.00000000101,     0.00000000022,
	   0.00000000021,    -0.00000000094,
	  -0.00000000095,    -0.00000000021,
	  -0.00000000016,     0.00000000078,
	   0.00000000193,     0.00000000049,
	  -0.00000000484,    -0.00000000046,
	   0.00000000032,     0.00000000033,
	  -0.00000000047,     0.00000000487,
	   0.00000000034,    -0.00000000033,
	   0.00000000042,     0.00000000008,
	   0.00000000010,    -0.00000000046,
	   0.00000000019,    -0.00000000092,
	  -0.00000000133,    -0.00000000034,
	   0.00000000452,     0.00000000045,
	  -0.00000000030,    -0.00000000030,
	   0.00000000046,    -0.00000000455,
	  -0.00000000030,     0.00000000030,
	  -0.00000000427,    -0.00000000039,
	   0.00000000029,     0.00000000030,
	  -0.00000000122,     0.00000000943,
	   0.00000000054,    -0.00000000062,
	  -0.00000000078,    -0.00000002055,
	  -0.00000000175,     0.00000000056,
	  -0.00000002084,     0.00000000072,
	   0.00000000058,     0.00000000178,
	  -0.00000000027,     0.00000000109,
	   0.00000000130,     0.00000000034,
	   0.00000000471,     0.00000000043,
	  -0.00000000032,    -0.00000000033,
	   0.00000000083,    -0.00000000645,
	  -0.00000000037,     0.00000000042,
	   0.00000000072,     0.00000001912,
	   0.00000000163,    -0.00000000052,
	   0.00000001935,    -0.00000000066,
	  -0.00000000054,    -0.00000000164,
	   0.00000000019,    -0.00000000074,
	  -0.00000000083,    -0.00000000023,
	  -0.00000000076,    -0.00000002038,
	  -0.00000000173,     0.00000000056,
	   0.00000000003,     0.00000000007,
	  -0.00000004058,     0.00000000110,
	   0.00000000110,     0.00000000351,
	   0.00000006683,     0.00000000002,
	   0.00000000022,    -0.00000006899,
	   0.00000000080,     0.00000000005,
	   0.00000000077,     0.00000002090,
	   0.00000000177,    -0.00000000058,
	   0.00000002735,    -0.00000000074,
	  -0.00000000074,    -0.00000000237,
	  -0.00000006294,    -0.00000000002,
	  -0.00000000020,     0.00000006430,
	  -0.00000000055,     0.00000000003,
	   0.00000007398,     0.00000000018,
	   0.00000000024,    -0.00000014333,
	  -0.00000000051,    -0.00000000949,
	   0.00000000367,     0.00000000037,
	  -0.00000000017,    -0.00000000106,
	  -0.00000000018,     0.00000000251,
	  -0.00000000069,    -0.00000000061,
	  -0.00000007003,    -0.00000000017,
	  -0.00000000017,     0.00000009509,
	   0.00000000046,     0.00000000611,
	  -0.00000000071,    -0.00000000037,
	   0.00000000008,     0.00000000072,
	  -0.00000000011,    -0.00000000172,
	  -0.00000000053,     0.00000000042,
	  -0.00000000076,    -0.00000000267,
	   0.00000000049,    -0.00000000001,
	  -0.00000000518,     0.00000000106,
	  -0.00000000001,    -0.00000000091,
	   0.00000002613,     0.00000000074,
	   0.00000000061,     0.00000002881,
	   0.00000000066,     0.00000000232,
	  -0.00000000043,     0.00000000001,
	   0.00000000348,    -0.00000000070,
	   0.00000000001,     0.00000000063,
	  -0.00000001197,    -0.00000000056,
	  -0.00000000050,    -0.00000001408,
	  -0.00000000130,     0.00000000066,
	   0.00000000010,     0.00000000021,
	   0.00000000136,     0.00000000269,
	   0.00000000044,    -0.00000000021,
	  -0.00000000034,    -0.00000000090,
	   0.00000000090,    -0.00000000038,
	   0.00000000029,     0.00000000128,
	  -0.00000000131,     0.00000000032,
	   0.00000000102,    -0.00000000052,
	  -0.00000000093,    -0.00000000184,
	   0.00000000015,     0.00000000040,
	  -0.00000000040,     0.00000000018,
	  -0.00000000019,    -0.00000000088,
	   0.00000000092,    -0.00000000023,
	  -0.00000000019,    -0.00000000035,
	  -0.00000000015,     0.00000000074,
	   0.00000000074,     0.00000000015,
	   0.00000000014,    -0.00000000069,
	  -0.00000000070,    -0.00000000015,
	  -0.00000000012,     0.00000000061,
	   0.00000000143,     0.00000000034,
	  -0.00000000356,    -0.00000000030,
	   0.00000000024,     0.00000000026,
	  -0.00000000031,     0.00000000359,
	   0.00000000027,    -0.00000000024,
	   0.00000000014,    -0.00000000071,
	  -0.00000000099,    -0.00000000024,
	   0.00000000333,     0.00000000029,
	   0.00000000031,    -0.00000000336,
	  -0.00000000327,    -0.00000000027,
	   0.00000000022,     0.00000000025,
	  -0.00000000082,     0.00000000693,
	   0.00000000044,    -0.00000000046,
	  -0.00000000057,    -0.00000001479,
	  -0.00000000126,     0.00000000040,
	  -0.00000001504,     0.00000000052,
	   0.00000000042,     0.00000000129,
	  -0.00000000018,     0.00000000071,
	   0.00000000087,     0.00000000023,
	   0.00000000357,     0.00000000029,
	  -0.00000000024,    -0.00000000027,
	   0.00000000056,    -0.00000000474,
	  -0.00000000030,     0.00000000031,
	   0.00000000053,     0.00000001379,
	   0.00000000118,    -0.00000000037,
	   0.00000001398,    -0.00000000048,
	  -0.00000000039,    -0.00000000119,
	   0.00000000013,    -0.00000000049,
	  -0.00000000055,    -0.00000000015,
	  -0.00000000056,    -0.00000001508,
	  -0.00000000128,     0.00000000042,
	  -0.00000002922,     0.00000000081,
	   0.00000000079,     0.00000000253,
	   0.00000004539,     0.00000000003,
	   0.00000000018,    -0.00000004716,
	   0.00000000059,     0.00000000003,
	   0.00000000057,     0.00000001538,
	   0.00000000130,    -0.00000000042,
	   0.00000001970,    -0.00000000054,
	  -0.00000000053,    -0.00000000171,
	  -0.00000004286,    -0.00000000003,
	  -0.00000000016,     0.00000004394,
	   0.00000005128,     0.00000000015,
	   0.00000000021,    -0.00000009714,
	  -0.00000000040,    -0.00000000720,
	   0.00000000287,     0.00000000027,
	  -0.00000000013,    -0.00000000081,
	  -0.00000000013,     0.00000000172,
	  -0.00000000048,    -0.00000000042,
	  -0.00000004854,    -0.00000000014,
	  -0.00000000014,     0.00000006455,
	   0.00000000036,     0.00000000461,
	  -0.00000000059,    -0.00000000028,
	   0.00000000006,     0.00000000055,
	  -0.00000000008,    -0.00000000118,
	  -0.00000000037,     0.00000000029,
	  -0.00000000057,    -0.00000000205,
	   0.00000000038,    -0.00000000001,
	  -0.00000000390,     0.00000000079,
	  -0.00000000001,    -0.00000000070,
	   0.00000001844,     0.00000000056,
	   0.00000000045,     0.00000002044,
	   0.00000000050,     0.00000000179,
	  -0.00000000033,     0.00000000001,
	   0.00000000262,    -0.00000000053,
	   0.00000000001,     0.00000000048,
	  -0.00000000845,    -0.00000000043,
	  -0.00000000037,    -0.00000001005,
	  -0.00000000099,     0.00000000051,
	   0.00000000007,     0.00000000016,
	   0.00000000101,     0.00000000200,
	  -0.00000000026,    -0.00000000070,
	   0.00000000072,    -0.00000000029,
	   0.00000000020,     0.00000000089,
	  -0.00000000092,     0.00000000022,
	   0.00000000079,    -0.00000000041,
	  -0.00000000069,    -0.00000000137,
	  -0.00000000013,    -0.00000000061,
	   0.00000000064,    -0.00000000016,
	  -0.00000000011,     0.00000000055,
	   0.00000000056,     0.00000000011,
	   0.00000000010,    -0.00000000052,
	  -0.00000000052,    -0.00000000010,
	  -0.00000000009,     0.00000000048,
	   0.00000000107,     0.00000000024,
	  -0.00000000264,    -0.00000000020,
	  -0.00000000021,     0.00000000267,
	   0.00000000010,    -0.00000000055,
	  -0.00000000074,    -0.00000000017,
	   0.00000000247,     0.00000000020,
	   0.00000000021,    -0.00000000249,
	  -0.00000000250,    -0.00000000018,
	   0.00000000017,     0.00000000020,
	  -0.00000000055,     0.00000000513,
	   0.00000000036,    -0.00000000034,
	  -0.00000000041,    -0.00000001067,
	  -0.00000000091,     0.00000000029,
	  -0.00000001089,     0.00000000037,
	   0.00000000030,     0.00000000093,
	  -0.00000000012,     0.00000000047,
	   0.00000000059,     0.00000000016,
	   0.00000000271,     0.00000000020,
	  -0.00000000018,    -0.00000000022,
	   0.00000000038,    -0.00000000351,
	   0.00000000038,     0.00000000997,
	   0.00000000085,    -0.00000000027,
	   0.00000001012,    -0.00000000035,
	  -0.00000000028,    -0.00000000086,
	  -0.00000000041,    -0.00000001115,
	  -0.00000000095,     0.00000000031,
	  -0.00000002110,     0.00000000060,
	   0.00000000057,     0.00000000183,
	   0.00000003098,     0.00000000003,
	   0.00000000014,    -0.00000003241,
	   0.00000000042,     0.00000001131,
	   0.00000000096,    -0.00000000031,
	   0.00000001424,    -0.00000000040,
	  -0.00000000038,    -0.00000000124,
	  -0.00000002932,    -0.00000000003,
	  -0.00000000013,     0.00000003017,
	   0.00000003563,     0.00000000013,
	   0.00000000017,    -0.00000006619,
	  -0.00000000031,    -0.00000000544,
	   0.00000000223,     0.00000000019,
	  -0.00000000010,    -0.00000000061,
	  -0.00000000009,     0.00000000118,
	  -0.00000000033,    -0.00000000029,
	  -0.00000003373,    -0.00000000012,
	  -0.00000000012,     0.00000004405,
	   0.00000000027,     0.00000000347,
	  -0.00000000047,    -0.00000000021,
	  -0.00000000005,    -0.00000000081,
	  -0.00000000043,    -0.00000000156,
	   0.00000000029,    -0.00000000001,
	  -0.00000000291,     0.00000000059,
	  -0.00000000001,    -0.00000000053,
	   0.00000001301,     0.00000000042,
	   0.00000000033,     0.00000001450,
	   0.00000000037,     0.00000000137,
	  -0.00000000026,     0.00000000001,
	   0.00000000196,    -0.00000000039,
	  -0.00000000595,    -0.00000000033,
	  -0.00000000028,    -0.00000000716,
	  -0.00000000075,     0.00000000039,
	   0.00000000075,     0.00000000149,
	  -0.00000000019,    -0.00000000055,
	   0.00000000056,    -0.00000000022,
	   0.00000000014,     0.00000000063,
	  -0.00000000064,     0.00000000016,
	   0.00000000061,    -0.00000000031,
	  -0.00000000051,    -0.00000000102,
	  -0.00000000009,    -0.00000000043,
	   0.00000000045,    -0.00000000011,
	  -0.00000000007,     0.00000000037,
	   0.00000000081,     0.00000000018,
	  -0.00000000196,    -0.00000000013,
	  -0.00000000014,     0.00000000199,
	  -0.00000000056,    -0.00000000012,
	   0.00000000184,     0.00000000013,
	   0.00000000014,    -0.00000000186,
	  -0.00000000191,    -0.00000000012,
	   0.00000000013,     0.00000000016,
	  -0.00000000037,     0.00000000381,
	   0.00000000029,    -0.00000000025,
	  -0.00000000030,    -0.00000000772,
	  -0.00000000066,     0.00000000021,
	  -0.00000000790,     0.00000000027,
	   0.00000000022,     0.00000000068,
	   0.00000000040,     0.00000000011,
	   0.00000000205,     0.00000000013,
	  -0.00000000014,    -0.00000000017,
	   0.00000000025,    -0.00000000260,
	   0.00000000028,     0.00000000723,
	   0.00000000062,    -0.00000000019,
	   0.00000000735,    -0.00000000025,
	  -0.00000000020,    -0.00000000063,
	  -0.00000000031,    -0.00000000823,
	  -0.00000000070,     0.00000000023,
	  -0.00000001526,     0.00000000044,
	   0.00000000041,     0.00000000133,
	   0.00000002123,     0.00000000003,
	   0.00000000011,    -0.00000002237,
	   0.00000000031,     0.00000000831,
	   0.00000000071,    -0.00000000023,
	   0.00000001030,    -0.00000000030,
	  -0.00000000028,    -0.00000000090,
	  -0.00000002014,    -0.00000000003,
	  -0.00000000010,     0.00000002081,
	   0.00000002481,     0.00000000010,
	   0.00000000014,    -0.00000004530,
	  -0.00000000024,    -0.00000000409,
	   0.00000000171,     0.00000000014,
	  -0.00000000008,    -0.00000000046,
	  -0.00000000007,     0.00000000081,
	  -0.00000002349,    -0.00000000010,
	  -0.00000000010,     0.00000003019,
	   0.00000000021,     0.00000000260,
	  -0.00000000038,    -0.00000000015,
	  -0.00000000004,    -0.00000000056,
	  -0.00000000032,    -0.00000000118,
	   0.00000000023,    -0.00000000001,
	  -0.00000000217,     0.00000000044,
	   0.00000000917,     0.00000000032,
	   0.00000000024,     0.00000001028,
	   0.00000000028,     0.00000000104,
	   0.00000000146,    -0.00000000029,
	  -0.00000000420,    -0.00000000025,
	  -0.00000000021,    -0.00000000510,
	  -0.00000000057,     0.00000000029,
	   0.00000000056,     0.00000000111,
	  -0.00000000014,    -0.00000000042,
	   0.00000000043,    -0.00000000017,
	   0.00000000010,     0.00000000044,
	  -0.00000000045,     0.00000000011,
	   0.00000000047,    -0.00000000024,
	  -0.00000000038,    -0.00000000076,
	   0.00000000061,     0.00000000013,
	  -0.00000000146,    -0.00000000009,
	  -0.00000000009,     0.00000000148,
	  -0.00000000042,    -0.00000000009,
	   0.00000000137,     0.00000000009,
	   0.00000000009,    -0.00000000139,
	  -0.00000000146,    -0.00000000009,
	   0.00000000010,     0.00000000013,
	  -0.00000000025,     0.00000000283,
	  -0.00000000022,    -0.00000000559,
	  -0.00000000048,     0.00000000015,
	  -0.00000000574,     0.00000000019,
	   0.00000000016,     0.00000000050,
	   0.00000000156,     0.00000000009,
	   0.00000000017,    -0.00000000194,
	   0.00000000020,     0.00000000524,
	   0.00000000045,    -0.00000000014,
	   0.00000000534,    -0.00000000018,
	  -0.00000000015,    -0.00000000046,
	  -0.00000000022,    -0.00000000607,
	  -0.00000000052,     0.00000000017,
	  -0.00000001106,     0.00000000032,
	   0.00000000030,     0.00000000096,
	   0.00000001459,     0.00000000003,
	   0.00000000009,    -0.00000001550,
	   0.00000000023,     0.00000000611,
	   0.00000000052,    -0.00000000017,
	   0.00000000747,    -0.00000000022,
	  -0.00000000020,    -0.00000000065,
	  -0.00000001388,    -0.00000000003,
	  -0.00000000008,     0.00000001440,
	   0.00000001731,     0.00000000008,
	   0.00000000011,    -0.00000003112,
	  -0.00000000018,    -0.00000000306,
	   0.00000000131,     0.00000000010,
	  -0.00000000005,     0.00000000056,
	  -0.00000001639,    -0.00000000008,
	  -0.00000000008,     0.00000002076,
	   0.00000000016,     0.00000000194,
	  -0.00000000023,    -0.00000000089,
	  -0.00000000161,     0.00000000032,
	   0.00000000647,     0.00000000024,
	   0.00000000017,     0.00000000729,
	   0.00000000021,     0.00000000079,
	   0.00000000108,    -0.00000000021,
	  -0.00000000295,    -0.00000000019,
	  -0.00000000015,    -0.00000000364,
	  -0.00000000043,     0.00000000022,
	   0.00000000041,     0.00000000082,
	   0.00000000036,    -0.00000000018,
	  -0.00000000028,    -0.00000000056,
	   0.00000000046,     0.00000000009,
	  -0.00000000109,    -0.00000000006,
	  -0.00000000006,     0.00000000111,
	   0.00000000102,     0.00000000006,
	   0.00000000006,    -0.00000000104,
	  -0.00000000111,    -0.00000000006,
	  -0.00000000017,     0.00000000211,
	  -0.00000000016,    -0.00000000405,
	  -0.00000000418,     0.00000000014,
	   0.00000000118,     0.00000000006,
	   0.00000000012,    -0.00000000144,
	   0.00000000015,     0.00000000381,
	   0.00000000389,    -0.00000000013,
	  -0.00000000017,    -0.00000000447,
	  -0.00000000038,     0.00000000012,
	  -0.00000000802,     0.00000000024,
	   0.00000000022,     0.00000000070,
	   0.00000001006,     0.00000000003,
	   0.00000000007,    -0.00000001077,
	   0.00000000017,     0.00000000448,
	   0.00000000038,    -0.00000000012,
	   0.00000000542,    -0.00000000016,
	  -0.00000000015,    -0.00000000047,
	  -0.00000000959,    -0.00000000003,
	  -0.00000000006,     0.00000001000,
	   0.00000001210,     0.00000000007,
	   0.00000000009,    -0.00000002145,
	  -0.00000000014,    -0.00000000229,
	   0.00000000099,     0.00000000007,
	  -0.00000001145,    -0.00000000006,
	  -0.00000000006,     0.00000001433,
	   0.00000000012,     0.00000000144,
	  -0.00000000017,    -0.00000000066,
	  -0.00000000119,     0.00000000024,
	   0.00000000456,     0.00000000018,
	   0.00000000013,     0.00000000517,
	   0.00000000015,     0.00000000059,
	   0.00000000080,    -0.00000000016,
	  -0.00000000208,    -0.00000000014,
	  -0.00000000011,    -0.00000000259,
	  -0.00000000032,     0.00000000017,
	   0.00000000031,     0.00000000061,
	  -0.00000000021,    -0.00000000041,
	  -0.00000000082,    -0.00000000004,
	  -0.00000000004,     0.00000000083,
	   0.00000000077,     0.00000000004,
	   0.00000000004,    -0.00000000078,
	  -0.00000000085,    -0.00000000004,
	  -0.00000000012,     0.00000000158,
	  -0.00000000012,    -0.00000000294,
	  -0.00000000304,     0.00000000010,
	   0.00000000089,     0.00000000004,
	   0.00000000008,    -0.00000000108,
	   0.00000000011,     0.00000000277,
	   0.00000000283,    -0.00000000010,
	  -0.00000000012,    -0.00000000329,
	  -0.00000000028,     0.00000000009,
	  -0.00000000582,     0.00000000017,
	   0.00000000016,     0.00000000051,
	   0.00000000695,     0.00000000002,
	   0.00000000005,    -0.00000000750,
	   0.00000000012,     0.00000000329,
	   0.00000000028,    -0.00000000009,
	   0.00000000393,    -0.00000000012,
	  -0.00000000664,    -0.00000000002,
	  -0.00000000005,     0.00000000696,
	   0.00000000847,     0.00000000005,
	   0.00000000007,    -0.00000001483,
	  -0.00000000010,    -0.00000000170,
	   0.00000000075,     0.00000000005,
	  -0.00000000802,    -0.00000000005,
	  -0.00000000005,     0.00000000991,
	   0.00000000009,     0.00000000107,
	  -0.00000000013,    -0.00000000050,
	  -0.00000000088,     0.00000000017,
	   0.00000000321,     0.00000000013,
	   0.00000000009,     0.00000000367,
	   0.00000000011,     0.00000000044,
	   0.00000000059,    -0.00000000011,
	  -0.00000000146,    -0.00000000011,
	  -0.00000000008,    -0.00000000184,
	  -0.00000000024,     0.00000000012,
	   0.00000000023,     0.00000000045,
	  -0.00000000061,    -0.00000000003,
	  -0.00000000003,     0.00000000062,
	   0.00000000057,     0.00000000003,
	   0.00000000003,    -0.00000000058,
	  -0.00000000065,    -0.00000000003,
	  -0.00000000008,     0.00000000118,
	  -0.00000000009,    -0.00000000213,
	  -0.00000000222,     0.00000000007,
	   0.00000000068,     0.00000000003,
	   0.00000000005,    -0.00000000081,
	   0.00000000008,     0.00000000201,
	   0.00000000206,    -0.00000000007,
	  -0.00000000009,    -0.00000000242,
	  -0.00000000021,     0.00000000007,
	  -0.00000000422,     0.00000000013,
	   0.00000000481,     0.00000000002,
	   0.00000000004,    -0.00000000524,
	   0.00000000009,     0.00000000241,
	   0.00000000021,    -0.00000000007,
	   0.00000000286,    -0.00000000009,
	  -0.00000000461,    -0.00000000002,
	  -0.00000000004,     0.00000000485,
	   0.00000000594,     0.00000000004,
	   0.00000000006,    -0.00000001027,
	  -0.00000000008,    -0.00000000127,
	   0.00000000057,     0.00000000004,
	  -0.00000000562,    -0.00000000004,
	  -0.00000000004,     0.00000000687,
	   0.00000000006,     0.00000000079,
	  -0.00000000009,    -0.00000000037,
	  -0.00000000065,     0.00000000013,
	   0.00000000227,     0.00000000010,
	   0.00000000007,     0.00000000260,
	   0.00000000044,    -0.00000000008,
	  -0.00000000103,    -0.00000000008,
	  -0.00000000006,    -0.00000000131,
	  -0.00000000049,    -0.00000000002,
	  -0.00000000005,     0.00000000088,
	  -0.00000000006,    -0.00000000155,
	  -0.00000000162,     0.00000000005,
	   0.00000000051,     0.00000000002,
	   0.00000000004,    -0.00000000060,
	   0.00000000006,     0.00000000146,
	   0.00000000150,    -0.00000000005,
	  -0.00000000006,    -0.00000000178,
	  -0.00000000015,     0.00000000005,
	  -0.00000000307,     0.00000000009,
	   0.00000000333,     0.00000000002,
	   0.00000000003,    -0.00000000367,
	   0.00000000006,     0.00000000177,
	   0.00000000208,    -0.00000000006,
	  -0.00000000320,    -0.00000000002,
	  -0.00000000003,     0.00000000339,
	   0.00000000416,     0.00000000003,
	   0.00000000004,    -0.00000000713,
	  -0.00000000006,    -0.00000000094,
	  -0.00000000394,    -0.00000000003,
	  -0.00000000003,     0.00000000478,
	   0.00000000005,     0.00000000059,
	  -0.00000000047,     0.00000000009,
	   0.00000000160,     0.00000000008,
	   0.00000000005,     0.00000000185,
	  -0.00000000072,    -0.00000000006,
	  -0.00000000005,    -0.00000000094,
	  -0.00000000037,    -0.00000000001,
	  -0.00000000004,     0.00000000066,
	  -0.00000000005,    -0.00000000113,
	  -0.00000000118,     0.00000000004,
	   0.00000000004,     0.00000000106,
	   0.00000000110,    -0.00000000004,
	  -0.00000000005,    -0.00000000131,
	  -0.00000000223,     0.00000000007,
	   0.00000000231,     0.00000000001,
	   0.00000000002,    -0.00000000257,
	   0.00000000005,     0.00000000130,
	   0.00000000151,    -0.00000000005,
	  -0.00000000223,    -0.00000000001,
	  -0.00000000002,     0.00000000237,
	   0.00000000292,     0.00000000003,
	   0.00000000003,    -0.00000000496,
	  -0.00000000004,    -0.00000000069,
	  -0.00000000277,    -0.00000000002,
	  -0.00000000002,     0.00000000333,
	   0.00000000113,     0.00000000006,
	   0.00000000004,     0.00000000131,
	  -0.00000000051,    -0.00000000004,
	  -0.00000000003,    -0.00000000067,
	  -0.00000000003,     0.00000000049,
	  -0.00000000003,    -0.00000000082,
	  -0.00000000086,     0.00000000003,
	   0.00000000003,     0.00000000077,
	   0.00000000080,    -0.00000000003,
	  -0.00000000003,    -0.00000000096,
	  -0.00000000162,     0.00000000005,
	   0.00000000161,     0.00000000001,
	   0.00000000002,    -0.00000000181,
	   0.00000000003,     0.00000000095,
	   0.00000000110,    -0.00000000003,
	  -0.00000000156,    -0.00000000001,
	  -0.00000000002,     0.00000000166,
	   0.00000000206,     0.00000000002,
	   0.00000000003,    -0.00000000346,
	  -0.00000000003,    -0.00000000051,
	  -0.00000000195,    -0.00000000002,
	  -0.00000000002,     0.00000000232,
	   0.00000000080,     0.00000000004,
	   0.00000000003,     0.00000000093,
	  -0.00000000002,    -0.00000000059,
	  -0.00000000063,     0.00000000002,
	   0.00000000002,     0.00000000056,
	   0.00000000058,    -0.00000000002,
	  -0.00000000002,    -0.00000000070,
	  -0.00000000118,     0.00000000004,
	   0.00000000112,     0.00000000001,
	   0.00000000001,    -0.00000000127,
	   0.00000000002,     0.00000000069,
	   0.00000000080,    -0.00000000002,
	  -0.00000000109,    -0.00000000001,
	  -0.00000000001,     0.00000000117,
	   0.00000000145,     0.00000000001,
	   0.00000000002,    -0.00000000241,
	  -0.00000000137,    -0.00000000001,
	  -0.00000000001,     0.00000000162,
	   0.00000000056,     0.00000000003,
	   0.00000000002,     0.00000000066,
	  -0.00000000002,    -0.00000000052,
	  -0.00000000086,     0.00000000003,
	   0.00000000078,     0.00000000001,
	   0.00000000001,    -0.00000000090,
	   0.00000000002,     0.00000000051,
	   0.00000000058,    -0.00000000002,
	  -0.00000000076,    -0.00000000001,
	  -0.00000000001,     0.00000000082,
	   0.00000000102,     0.00000000001,
	   0.00000000002,    -0.00000000169,
	  -0.00000000096,    -0.00000000001,
	  -0.00000000001,     0.00000000113,
	  -0.00000000001,    -0.00000000038,
	  -0.00000000062,     0.00000000002,
	   0.00000000054,     0.00000000001,
	   0.00000000001,    -0.00000000063,
	  -0.00000000053,    -0.00000000001,
	  -0.00000000001,     0.00000000058,
	   0.00000000072,     0.00000000001,
	   0.00000000001,    -0.00000000118,
	  -0.00000000068,    -0.00000000001,
	  -0.00000000001,     0.00000000079,
	   0.00000000051,     0.00000000001,
	   0.00000000001,    -0.00000000083,
	  -0.00000000001,     0.00000000056,
	   0.00000000036,     0.00000000001,
	   0.00000000001,    -0.00000000058,
	  -0.00000032706,     0.00000010513,
	  -0.00000000336,    -0.00000000742,
	   0.00000000006,    -0.00000000016,
	  -0.00000031729,     0.00000001670,
	   0.00000000057,    -0.00000000015,
	  -0.00000000001,    -0.00000000004,
	   0.00000001172,    -0.00000030212,
	  -0.00000000010,     0.00000000002,
	  -0.00000000003,     0.00000000002,
	   0.00000000393,     0.00000000097,
	   0.00000000010,     0.00000000131,
	  -0.00000002424,    -0.00000000886,
	  -0.00000000187,     0.00000000030,
	   0.00000024930,    -0.00000001510,
	  -0.00000000600,     0.00000002377,
	  -0.00000000123,    -0.00000000041,
	  -0.00000239035,     0.00000001703,
	   0.00000000348,     0.00000000577,
	   0.00000000056,    -0.00000000025,
	   0.00000001800,    -0.00000231835,
	   0.00000000591,    -0.00000000227,
	  -0.00000000021,    -0.00000000056,
	  -0.00000001111,     0.00000000287,
	   0.00000000064,    -0.00000000184,
	   0.00000000143,     0.00000000091,
	   0.00000000155,     0.00000000033,
	   0.00000007946,    -0.00000005296,
	  -0.00000000115,     0.00000000468,
	  -0.00000000008,    -0.00000000012,
	  -0.00000047675,    -0.00000035113,
	   0.00000003164,    -0.00000004241,
	   0.00000000202,     0.00000000129,
	   0.00000074513,    -0.00000000781,
	  -0.00000000192,    -0.00000000053,
	  -0.00000000891,     0.00000073024,
	  -0.00000000043,    -0.00000000136,
	   0.00000000840,    -0.00000000811,
	  -0.00000000056,     0.00000000071,
	   0.00000000322,     0.00000000312,
	  -0.00000000040,    -0.00000000041,
	  -0.00000004843,    -0.00000031704,
	   0.00000002023,    -0.00000000849,
	   0.00000000050,     0.00000000095,
	   0.00000597350,     0.00000001556,
	  -0.00000000401,    -0.00000000140,
	   0.00000001818,     0.00000599392,
	  -0.00000000188,     0.00000000407,
	   0.00000001018,     0.00000001955,
	   0.00000000106,    -0.00000000063,
	  -0.00000001242,    -0.00000000874,
	   0.00000000017,     0.00000000084,
	   0.00000018763,    -0.00000073235,
	   0.00000003369,    -0.00000001743,
	   0.00000000103,     0.00000000105,
	   0.00001038475,     0.00000000064,
	   0.00000000065,     0.00001038160,
	  -0.00000000101,     0.00000000547,
	  -0.00000000026,     0.00000000139,
	  -0.00000001397,     0.00000001394,
	   0.00000117212,     0.00000006274,
	  -0.00000007855,     0.00000011076,
	  -0.00000000469,    -0.00000000392,
	   0.00001407001,     0.00000000511,
	   0.00000000373,    -0.00000000032,
	   0.00000000509,     0.00001406014,
	  -0.00000000154,     0.00000000231,
	   0.00000000036,    -0.00000000083,
	   0.00000000045,    -0.00000000124,
	  -0.00000000682,     0.00000001556,
	   0.00000000189,    -0.00000000044,
	  -0.00000007670,    -0.00000000965,
	   0.00000016896,     0.00000137675,
	  -0.00000002240,    -0.00000000534,
	   0.00001996913,    -0.00000000018,
	  -0.00000000018,     0.00001996633,
	  -0.00000000049,     0.00000000056,
	  -0.00000000171,    -0.00000000596,
	  -0.00000000092,     0.00000000022,
	   0.00000025109,    -0.00000022499,
	   0.00000000289,    -0.00000000031,
	   0.00002501595,     0.00000000631,
	   0.00000000125,    -0.00000000002,
	   0.00000000631,     0.00002501304,
	  -0.00000000123,     0.00000000033,
	  -0.00000000154,     0.00000000173,
	  -0.00000000172,     0.00000000193,
	  -0.00000000073,     0.00000000099,
	   0.00000001103,     0.00000000883,
	  -0.00000000027,    -0.00000000002,
	   0.00000000450,     0.00000001186,
	  -0.00000000024,     0.00000000012,
	  -0.00000001188,     0.00000000352,
	  -0.00000000015,    -0.00000000023,
	   0.00000000332,     0.00000000357,
	   0.00000000019,    -0.00000000012,
	  -0.00000000371,     0.00000000407,
	   0.00000000012,     0.00000000019,
	   0.00000000208,    -0.00000000229,
	  -0.00000000389,    -0.00000000346,
	  -0.00000000006,    -0.00000000172,
	   0.00000000173,    -0.00000000007,
	   0.00000000392,     0.00000000437,
	  -0.00000000436,     0.00000000389,
	   0.00000000002,    -0.00000000008,
	  -0.00000000532,    -0.00000000130,
	   0.00000000000,     0.00000000007,
	  -0.00000000053,     0.00000000000,
	   0.00000000000,     0.00000000055,
	   0.00000000005,    -0.00000000002,
	  -0.00000000010,    -0.00000000040,
	  -0.00000000001,    -0.00000000021,
	   0.00000000019,     0.00000000001,
	   0.00000000011,    -0.00000000029,
	   0.00000000030,     0.00000000010,
	   0.00000000056,     0.00000000024,
	   0.00000000029,    -0.00000000066,
	  -0.00000000083,     0.00000000117,
	  -0.00000000117,    -0.00000000083,
	   0.00000000023,     0.00000000025,
	  -0.00000000006,    -0.00000000003,
	  -0.00000000004,     0.00000000006,
	   0.00000000011,    -0.00000000019,
	   0.00000000001,    -0.00000000005,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000008,    -0.00000000002,
	   0.00000000000,     0.00000000006,
	  -0.00000000020,     0.00000000010,
	   0.00000000005,     0.00000000001,
	  -0.00000000452,     0.00000000226,
	   0.00000000036,     0.00000000074,
	   0.00000000007,    -0.00000000003,
	   0.00000002201,     0.00000004500,
	   0.00000000741,    -0.00000000361,
	  -0.00000000029,    -0.00000000071,
	  -0.00000000072,    -0.00000002601,
	   0.00000000206,     0.00000000073,
	   0.00000002399,     0.00000000015,
	  -0.00000000061,     0.00000000223,
	   0.00000001265,     0.00000005464,
	   0.00000000473,    -0.00000000089,
	  -0.00000005556,     0.00000001338,
	   0.00000000106,     0.00000000494,
	  -0.00000000247,     0.00000000131,
	   0.00000000019,     0.00000000040,
	  -0.00000001787,    -0.00000003688,
	  -0.00000000607,     0.00000000296,
	   0.00000000024,     0.00000000058,
	   0.00000000306,     0.00000000900,
	  -0.00000000107,    -0.00000000014,
	  -0.00000000806,     0.00000000268,
	   0.00000000008,    -0.00000000115,
	  -0.00000000487,    -0.00000002145,
	  -0.00000000185,     0.00000000033,
	   0.00000002211,    -0.00000000539,
	  -0.00000000045,    -0.00000000199,
	  -0.00000000051,    -0.00000000006,
	  -0.00000000115,    -0.00000000012,
	   0.00000000009,    -0.00000000071,
	   0.00000000861,     0.00000000148,
	   0.00000000014,    -0.00000000192,
	  -0.00000000065,    -0.00000000103,
	  -0.00000000109,     0.00000000063,
	   0.00000003201,    -0.00000000003,
	  -0.00000000012,    -0.00000000030,
	  -0.00000000183,     0.00000000079,
	   0.00000000469,    -0.00000000227,
	  -0.00000000040,    -0.00000000076,
	   0.00000000211,     0.00000000453,
	   0.00000000072,    -0.00000000035,
	  -0.00000000181,     0.00000000026,
	  -0.00000000029,    -0.00000000185,
	   0.00000000132,    -0.00000000054,
	  -0.00000000524,     0.00000000263,
	   0.00000000043,     0.00000000087,
	  -0.00000000257,    -0.00000000517,
	  -0.00000000086,     0.00000000041,
	   0.00000000106,    -0.00000000027,
	   0.00000000030,     0.00000000109,
	  -0.00000002631,    -0.00000007710,
	  -0.00000002873,     0.00000000856,
	  -0.00000000643,    -0.00000001770,
	  -0.00000000656,     0.00000000198,
	  -0.00000000020,     0.00000000055,
	   0.00000000055,     0.00000000021,
	   0.00000000243,    -0.00000000084,
	  -0.00000000029,    -0.00000000094,
	   0.00000018402,     0.00000053521,
	   0.00000020168,    -0.00000006179,
	   0.00000000303,    -0.00000000364,
	  -0.00000000105,    -0.00000000101,
	  -0.00000000368,    -0.00000000303,
	  -0.00000000097,     0.00000000107,
	   0.00000000025,     0.00000000063,
	  -0.00000000090,     0.00000000064,
	   0.00000000025,     0.00000000045,
	   0.00000000064,     0.00000000091,
	   0.00000000046,    -0.00000000025,
	   0.00000000032,    -0.00000000064,
	  -0.00000000065,    -0.00000000033,
	  -0.00000000200,     0.00000000136,
	   0.00000000052,     0.00000000098,
	   0.00000000020,    -0.00000000009,
	   0.00000000063,     0.00000000088,
	   0.00000000052,    -0.00000000026,
	  -0.00000000313,     0.00000000612,
	   0.00000000205,     0.00000000130,
	   0.00000000022,    -0.00000000031,
	   0.00000000615,     0.00000000317,
	   0.00000000133,    -0.00000000205,
	  -0.00000000031,    -0.00000000022,
	   0.00000000063,     0.00000000047,
	   0.00000000043,    -0.00000000064,
	  -0.00000000062,    -0.00000000035,
	  -0.00000000017,    -0.00000000443,
	  -0.00000000110,    -0.00000000004,
	  -0.00000000446,     0.00000000015,
	  -0.00000000006,     0.00000000111,
	  -0.00000000737,     0.00000001387,
	   0.00000000458,     0.00000000299,
	   0.00000000050,    -0.00000000069,
	   0.00000000606,     0.00000000321,
	   0.00000000153,    -0.00000000219,
	  -0.00000000033,    -0.00000000025,
	   0.00000000093,     0.00000004175,
	   0.00000001053,     0.00000000057,
	   0.00000000010,    -0.00000000120,
	   0.00000004201,    -0.00000000073,
	   0.00000000069,    -0.00000001063,
	  -0.00000000122,    -0.00000000012,
	   0.00000000320,     0.00000000047,
	   0.00000000023,    -0.00000000311,
	   0.00000000025,    -0.00000000141,
	  -0.00000000036,    -0.00000000008,
	  -0.00000000435,    -0.00000000007,
	  -0.00000000011,     0.00000000122,
	  -0.00000001443,    -0.00000002354,
	  -0.00000000391,     0.00000000208,
	  -0.00000002381,     0.00000001435,
	   0.00000000201,     0.00000000402,
	  -0.00000000150,     0.00000000053,
	   0.00000000067,     0.00000000134,
	   0.00000000035,     0.00000010209,
	   0.00000002562,     0.00000000177,
	   0.00000000030,    -0.00000000293,
	   0.00000004048,    -0.00000000055,
	   0.00000000097,    -0.00000001101,
	  -0.00000000121,    -0.00000000014,
	   0.00000012469,     0.00000021541,
	   0.00000003613,    -0.00000001816,
	  -0.00000000135,    -0.00000000275,
	   0.00000021767,    -0.00000012421,
	  -0.00000001785,    -0.00000003691,
	  -0.00000000286,     0.00000000129,
	   0.00000001153,    -0.00000000413,
	  -0.00000000512,    -0.00000001036,
	  -0.00000000399,    -0.00000001162,
	  -0.00000000191,     0.00000000065,
	   0.00000000005,     0.00000000014,
	  -0.00000001626,     0.00000001116,
	   0.00000000157,     0.00000000309,
	  -0.00000016464,    -0.00000009093,
	  -0.00000000762,     0.00000001250,
	   0.00000000050,     0.00000000031,
	  -0.00000009381,     0.00000016505,
	   0.00000001247,     0.00000000850,
	   0.00000000034,    -0.00000000050,
	  -0.00000000371,     0.00000000385,
	   0.00000000418,     0.00000000226,
	   0.00000033284,     0.00000061970,
	   0.00000010384,    -0.00000004860,
	  -0.00000000359,    -0.00000000798,
	   0.00000014402,    -0.00000010345,
	  -0.00000001462,    -0.00000002704,
	  -0.00000000190,     0.00000000101,
	   0.00000127464,     0.00000075805,
	   0.00000006251,    -0.00000009814,
	  -0.00000000392,    -0.00000000234,
	   0.00000077738,    -0.00000127986,
	  -0.00000009870,    -0.00000006756,
	  -0.00000000290,     0.00000000395,
	   0.00000002842,    -0.00000003046,
	   0.00000000141,     0.00000000146,
	  -0.00000000021,     0.00000000033,
	  -0.00000003237,    -0.00000001820,
	   0.00000000211,    -0.00000000123,
	   0.00000000033,     0.00000000017,
	  -0.00000033179,    -0.00000027534,
	  -0.00000002037,     0.00000002734,
	   0.00000000110,     0.00000000082,
	   0.00000556228,    -0.00000647254,
	  -0.00000053870,    -0.00000040635,
	  -0.00000001636,     0.00000002166,
	  -0.00000441068,     0.00000007640,
	   0.00000001147,    -0.00000000623,
	  -0.00000000045,    -0.00000000084,
	  -0.00000003944,     0.00000448918,
	   0.00000000511,     0.00000001104,
	   0.00000000062,    -0.00000000032,
	  -0.00000001689,     0.00000002937,
	   0.00000000282,    -0.00000000086,
	   0.00000001587,    -0.00000002530,
	  -0.00000000015,    -0.00000000290,
	   0.00000971790,     0.00000729223,
	   0.00000056361,    -0.00000078322,
	  -0.00000003135,    -0.00000002271,
	  -0.00004297154,     0.00004999277,
	   0.00000415956,     0.00000314064,
	   0.00000012658,    -0.00000016754,
	  -0.00000000450,    -0.00000000340,
	   0.00001710249,    -0.00000049113,
	  -0.00000004985,     0.00000004008,
	   0.00000000290,     0.00000000511,
	   0.00000015007,    -0.00001767582,
	  -0.00000003661,    -0.00000006572,
	  -0.00000000382,     0.00000000231,
	   0.00000011405,    -0.00000024480,
	  -0.00000002506,     0.00000000587,
	   0.00000000012,     0.00000000357,
	  -0.00000014157,     0.00000017501,
	   0.00000000160,     0.00000002624,
	   0.00000000302,    -0.00000000066,
	   0.00000013961,    -0.00000000115,
	  -0.00000000639,    -0.00000099878,
	   0.00000000010,    -0.00000000069,
	  -0.00000003960,    -0.00000002603,
	  -0.00000000165,     0.00000000316,
	   0.00000001712,    -0.00000003883,
	  -0.00000000280,    -0.00000000230,
	   0.00000000047,    -0.00000001000,
	  -0.00000000002,     0.00000000082,
	   0.00000000073,     0.00000000838,
	   0.00000000000,     0.00000000087,
	   0.00001580815,     0.00000001347,
	  -0.00000000216,     0.00000000036,
	   0.00000000001,     0.00000000020,
	   0.00000004895,     0.00001262890,
	  -0.00000000096,     0.00000000507,
	  -0.00000023346,     0.00000045347,
	  -0.00000001298,    -0.00000006853,
	   0.00000000070,    -0.00000000172,
	   0.00000015605,     0.00000091588,
	  -0.00000001872,     0.00000004357,
	  -0.00000000050,    -0.00000000261,
	  -0.00000002812,     0.00000004134,
	  -0.00000000290,    -0.00000000289,
	   0.00000000018,    -0.00000000035,
	  -0.00000003432,    -0.00000003411,
	   0.00000000276,    -0.00000000295,
	   0.00000000052,    -0.00000000101,
	   0.00000000021,     0.00000000008,
	  -0.00000000640,    -0.00000000359,
	   0.00000000056,    -0.00000000137,
	  -0.00000001203,     0.00000000679,
	  -0.00000000054,    -0.00000000093,
	  -0.00000000710,    -0.00000001210,
	   0.00000000091,    -0.00000000070,
	  -0.00000000143,    -0.00000000163,
	   0.00000000168,    -0.00000000120,
	   0.00000000248,    -0.00000000873,
	   0.00000000138,     0.00000000042,
	   0.00000005341,     0.00000003256,
	  -0.00000000511,     0.00000001205,
	  -0.00000000063,    -0.00000000032,
	   0.00000003977,    -0.00000003047,
	   0.00000000192,     0.00000000346,
	   0.00000003504,     0.00000004010,
	  -0.00000000332,     0.00000000341,
	   0.00000000179,     0.00000000166,
	  -0.00000000205,     0.00000000000,
	  -0.00000000091,    -0.00000000007,
	  -0.00000000115,     0.00000000186,
	  -0.00000000035,    -0.00000000018,
	  -0.00000000189,    -0.00000000115,
	   0.00000000016,    -0.00000000037,
	  -0.00000000061,    -0.00000000022,
	   0.00000000025,    -0.00000000058,
	   0.00000000013,    -0.00000000306,
	   0.00000000106,    -0.00000000013,
	   0.00000000745,     0.00000000068,
	   0.00000000030,     0.00000000268,
	   0.00000000874,    -0.00000001487,
	   0.00000000296,     0.00000000141,
	   0.00000001542,     0.00000000856,
	  -0.00000000125,     0.00000000321,
	   0.00000000476,     0.00000000175,
	  -0.00000000196,     0.00000000452,
	   0.00000000025,    -0.00000000017,
	   0.00000000090,    -0.00000000027,
	   0.00000000031,     0.00000000045,
	   0.00000000027,    -0.00000000298,
	   0.00000000099,    -0.00000000007,
	   0.00000000304,     0.00000000023,
	   0.00000000012,     0.00000000102,
	   0.00000000125,    -0.00000000017,
	   0.00000000011,     0.00000000123,
	  -0.00000000014,    -0.00000000044,
	   0.00000000044,    -0.00000000015,
	   0.00000000041,    -0.00000000046,
	  -0.00000000046,    -0.00000000041,
	   0.00000000017,    -0.00000000063,
	  -0.00000000063,    -0.00000000017,
	   0.00000000039,    -0.00000000085,
	   0.00000000458,    -0.00000000372,
	   0.00000000000,    -0.00000000129,
	  -0.00000000372,    -0.00000000458,
	  -0.00000000130,     0.00000000000,
	  -0.00000000027,    -0.00000000057,
	  -0.00000000057,     0.00000000028,
	  -0.00000000099,    -0.00000000011,
	  -0.00000000011,     0.00000000100,
	  -0.00000000025,     0.00000000027,
	   0.00000000027,     0.00000000025,
	   0.00000000105,     0.00000000035,
	   0.00000000035,    -0.00000000105,
	   0.00000000147,     0.00000000103,
	   0.00000000030,    -0.00000000020,
	   0.00000000447,    -0.00000000651,
	  -0.00000000100,    -0.00000000137,
	   0.00000004761,    -0.00000002696,
	   0.00000000152,    -0.00000000884,
	  -0.00000000055,    -0.00000000041,
	  -0.00000002699,    -0.00000004763,
	  -0.00000000885,    -0.00000000151,
	  -0.00000000041,     0.00000000055,
	  -0.00000000052,    -0.00000000084,
	  -0.00000000082,     0.00000000052,
	   0.00000000101,    -0.00000000105,
	  -0.00000000105,    -0.00000000101,
	   0.00000001098,     0.00000001116,
	   0.00000000209,    -0.00000000112,
	  -0.00000000004,    -0.00000000019,
	   0.00000004431,    -0.00000004593,
	  -0.00000000516,    -0.00000000879,
	  -0.00000000079,     0.00000000020,
	   0.00000044498,    -0.00000016089,
	   0.00000001711,    -0.00000004853,
	  -0.00000000220,    -0.00000000204,
	  -0.00000016120,    -0.00000044527,
	  -0.00000004863,    -0.00000001707,
	  -0.00000000204,     0.00000000221,
	  -0.00000000198,    -0.00000000519,
	  -0.00000000500,     0.00000000206,
	   0.00000001038,    -0.00000001029,
	   0.00000001874,    -0.00000001076,
	   0.00000000032,    -0.00000000171,
	  -0.00000001075,    -0.00000001874,
	  -0.00000000171,    -0.00000000032,
	   0.00000000046,     0.00000000035,
	   0.00000000034,    -0.00000000044,
	   0.00000000088,     0.00000000018,
	   0.00000000018,    -0.00000000088,
	   0.00000000034,    -0.00000000102,
	   0.00000006804,     0.00000009723,
	   0.00000001115,    -0.00000000609,
	  -0.00000000023,    -0.00000000077,
	   0.00000035970,    -0.00000027906,
	  -0.00000002573,    -0.00000004365,
	  -0.00000000303,     0.00000000097,
	   0.00000348726,    -0.00000061913,
	   0.00000009345,    -0.00000016686,
	  -0.00000000541,    -0.00000000576,
	  -0.00000062178,    -0.00000349111,
	  -0.00000016772,    -0.00000009337,
	  -0.00000000577,     0.00000000546,
	  -0.00000000350,    -0.00000002026,
	   0.00000000134,     0.00000000057,
	  -0.00000001884,     0.00000000425,
	   0.00000000057,    -0.00000000141,
	  -0.00000000042,     0.00000000010,
	  -0.00000000004,     0.00000000078,
	   0.00000000082,    -0.00000000003,
	   0.00000020777,    -0.00000011649,
	   0.00000000513,    -0.00000002316,
	   0.00000000095,     0.00000000305,
	   0.00000030337,    -0.00000007930,
	   0.00000000704,    -0.00000001388,
	  -0.00000007916,    -0.00000030324,
	  -0.00000001385,    -0.00000000704,
	  -0.00000000074,    -0.00000000071,
	  -0.00000000218,     0.00000000226,
	  -0.00000000069,    -0.00000000038,
	  -0.00000000036,     0.00000000069,
	   0.00000000078,     0.00000000139,
	   0.00000000150,    -0.00000000073,
	  -0.00000000038,     0.00000000042,
	   0.00000000047,     0.00000000047,
	   0.00000000054,     0.00000000056,
	   0.00000000060,     0.00000000026,
	   0.00000000004,     0.00000000053,
	   0.00000000051,     0.00000000017,
	   0.00000000056,    -0.00000000044,
	  -0.00000000044,    -0.00000000056,
	  -0.00000000039,    -0.00000000013,
	  -0.00000000013,     0.00000000039,
	   0.00000000037,     0.00000000032,
	   0.00000000032,    -0.00000000037,
	   0.00000031059,     0.00000056203,
	   0.00000003464,    -0.00000003121,
	  -0.00000000117,    -0.00000000146,
	   0.00000196611,    -0.00000133507,
	  -0.00000012227,    -0.00000012989,
	  -0.00000000556,     0.00000000450,
	   0.00001859231,    -0.00000000481,
	  -0.00000000698,     0.00000000383,
	   0.00000000014,    -0.00000000162,
	  -0.00000002478,    -0.00001864028,
	  -0.00000000218,     0.00000000604,
	  -0.00000000172,     0.00000000008,
	   0.00000000088,    -0.00000000632,
	   0.00000000248,     0.00000000348,
	   0.00000000412,     0.00000000350,
	   0.00000000026,    -0.00000000034,
	   0.00000000449,    -0.00000000538,
	  -0.00000000047,    -0.00000000035,
	   0.00000000084,    -0.00000000017,
	   0.00000000019,    -0.00000000100,
	   0.00000394891,    -0.00000101785,
	   0.00000009319,    -0.00000018108,
	  -0.00000000575,    -0.00000000586,
	   0.00000004933,     0.00000020481,
	   0.00000000949,     0.00000000500,
	   0.00000402497,    -0.00000000110,
	  -0.00000000115,    -0.00000000009,
	   0.00000000127,    -0.00000402081,
	   0.00000000029,     0.00000000122,
	  -0.00000000008,    -0.00000000111,
	  -0.00000000111,     0.00000000008,
	   0.00000003883,    -0.00000000512,
	   0.00000013983,    -0.00000003560,
	   0.00000033447,    -0.00000008553,
	   0.00000000026,     0.00000000059,
	  -0.00000000251,    -0.00000000510,
	  -0.00000000036,    -0.00000000090,
	  -0.00000000224,     0.00000000077,
	   0.00000000011,     0.00000000038,
	   0.00000000252,     0.00000000227,
	   0.00000000233,    -0.00000000244,
	   0.00000000333,     0.00000000011,
	   0.00000000006,    -0.00000000096,
	   0.00000000050,     0.00000000043,
	  -0.00000000043,     0.00000000049,
	   0.00000000038,    -0.00000000054,
	   0.00000000470,    -0.00000000256,
	  -0.00000000083,    -0.00000000172,
	  -0.00000000256,    -0.00000000470,
	  -0.00000000172,     0.00000000084,
	   0.00000000101,     0.00000000002,
	   0.00000000002,    -0.00000000101,
	  -0.00000000039,     0.00000000018,
	  -0.00000000243,    -0.00000000084,
	  -0.00000000021,     0.00000000029,
	  -0.00000000084,     0.00000000243,
	   0.00000000029,     0.00000000021,
	   0.00000000186,     0.00000000095,
	   0.00000000095,    -0.00000000187,
	   0.00000000103,     0.00000000027,
	   0.00000000026,    -0.00000000103,
	   0.00000003738,     0.00000000981,
	  -0.00000000052,     0.00000000202,
	   0.00000000113,    -0.00000000029,
	  -0.00000000029,    -0.00000000113,
	   0.00000003740,     0.00000000122,
	   0.00000000115,    -0.00000000029,
	   0.00000000029,     0.00000000115,
	   0.00000000000,     0.00000000008,
	   0.00000109757,    -0.00000002286,
	   0.00000000040,    -0.00000000017,
	  -0.00000007819,    -0.00000514214,
	  -0.00000000062,    -0.00000000213,
	  -0.00000066453,    -0.00000006314,
	  -0.00000001577,    -0.00000000334,
	   0.00000000094,    -0.00000000004,
	  -0.00000017342,     0.00000009595,
	  -0.00000003042,     0.00000000061,
	  -0.00000000092,    -0.00000000008,
	  -0.00000000055,    -0.00000003521,
	   0.00000000020,     0.00000000101,
	   0.00000000314,    -0.00000000633,
	  -0.00000000003,     0.00000000254,
	   0.00000000000,     0.00000000056,
	   0.00007808378,     0.00000000016,
	  -0.00000000474,     0.00000000195,
	   0.00000000011,     0.00001327642,
	  -0.00000017629,    -0.00000009021,
	  -0.00000000419,    -0.00000001622,
	  -0.00000004470,     0.00000035289,
	  -0.00000000811,     0.00000000837,
	   0.00000000775,    -0.00000004198,
	  -0.00000000307,     0.00000000127,
	  -0.00000004200,    -0.00000000776,
	   0.00000000127,     0.00000000307,
	   0.00000085242,     0.00000002308,
	  -0.00000000053,     0.00000000393,
	  -0.00000000909,     0.00000000176,
	  -0.00000000056,    -0.00000000061,
	   0.00000000039,     0.00000000916,
	  -0.00000000061,     0.00000000056,
	   0.00000311006,    -0.00000000024,
	   0.00000000000,     0.00000000213,
	   0.00000000205,    -0.00000000001,
	   0.00000728234,     0.00000000115,
	   0.00000000000,     0.00000000204,
	  -0.00000000053,     0.00000000000,
	   0.00000000040,     0.00000000054,
	   0.00000000098,    -0.00000000090,
	   0.00000000069,     0.00000000073,
	   0.00000000026,    -0.00000000029,
	   0.00000000266,    -0.00000000279,
	  -0.00000000114,    -0.00000000096,
	   0.00000002866,    -0.00000000966,
	  -0.00000000340,    -0.00000000920,
	  -0.00000000968,    -0.00000002869,
	  -0.00000000921,     0.00000000341,
	   0.00000000223,    -0.00000000096,
	  -0.00000000039,    -0.00000000068,
	  -0.00000000096,    -0.00000000223,
	  -0.00000000068,     0.00000000039,
	  -0.00000000018,     0.00000000036,
	   0.00000000036,     0.00000000018,
	   0.00000000037,     0.00000000043,
	   0.00000000052,    -0.00000000049,
	  -0.00000000013,    -0.00000000045,
	  -0.00000000162,     0.00000000059,
	  -0.00000001027,    -0.00000000158,
	  -0.00000000049,     0.00000000056,
	  -0.00000000141,     0.00000001026,
	   0.00000000056,     0.00000000049,
	  -0.00000000270,    -0.00000000039,
	  -0.00000000037,     0.00000000276,
	   0.00000000043,    -0.00000000029,
	   0.00000000281,     0.00000000043,
	   0.00000000044,    -0.00000000282,
	   0.00000000122,     0.00000000002,
	   0.00000000002,    -0.00000000122,
	   0.00000000228,    -0.00000003210,
	  -0.00000000098,     0.00000000004,
	   0.00000000846,     0.00000000134,
	   0.00000000134,    -0.00000000849,
	  -0.00000009786,    -0.00000001271,
	  -0.00000000012,     0.00000000135,
	   0.00000001400,     0.00000000001,
	  -0.00000000001,    -0.00000001395,
	  -0.00000010872,     0.00000001443,
	   0.00000001576,    -0.00000000001,
	  -0.00000000001,     0.00000001570,
	   0.00000003882,    -0.00000003513,
	   0.00000002073,     0.00000000000,
	   0.00000000000,    -0.00000002073,
	   0.00000003238,     0.00000003561,
	   0.00000002199,     0.00000000001,
	   0.00000000000,     0.00000002199,
	   0.00000000212,     0.00000000289,
	   0.00000000093,    -0.00000000091,
	   0.00000000988,    -0.00000000881,
	  -0.00000000367,    -0.00000000318,
	   0.00000010514,    -0.00000001294,
	  -0.00000000755,    -0.00000003060,
	  -0.00000001311,    -0.00000010540,
	  -0.00000003067,     0.00000000761,
	   0.00000002107,    -0.00000000900,
	  -0.00000000313,    -0.00000000670,
	   0.00000000042,     0.00000000101,
	   0.00000002237,    -0.00000000330,
	  -0.00000000179,    -0.00000000642,
	  -0.00000000325,    -0.00000002234,
	  -0.00000000642,     0.00000000178,
	   0.00000000039,     0.00000000240,
	   0.00000000240,    -0.00000000039,
	  -0.00000000021,    -0.00000000061,
	  -0.00000000201,     0.00000000068,
	   0.00000000041,     0.00000000036,
	  -0.00000002115,     0.00000000264,
	   0.00000000317,     0.00000000391,
	   0.00000000023,    -0.00000000032,
	   0.00000000264,     0.00000002114,
	   0.00000000392,    -0.00000000315,
	  -0.00000000032,    -0.00000000023,
	   0.00000000677,     0.00000004614,
	   0.00000001206,    -0.00000001062,
	  -0.00000003246,     0.00000000348,
	   0.00000000465,     0.00000000592,
	   0.00000000349,     0.00000003248,
	   0.00000000592,    -0.00000000466,
	   0.00000000445,    -0.00000000139,
	  -0.00000000059,    -0.00000000056,
	  -0.00000000463,    -0.00000001441,
	  -0.00000000178,     0.00000000189,
	  -0.00000000853,    -0.00000015629,
	  -0.00000001502,     0.00000001053,
	   0.00000000052,     0.00000000062,
	  -0.00000015610,     0.00000000807,
	   0.00000001050,     0.00000001499,
	   0.00000000062,    -0.00000000052,
	  -0.00000000034,    -0.00000000071,
	  -0.00000000065,     0.00000000029,
	  -0.00000000069,    -0.00000000103,
	  -0.00000000103,     0.00000000069,
	  -0.00000068159,     0.00000007485,
	   0.00000009899,     0.00000012467,
	   0.00000000748,    -0.00000001052,
	  -0.00000000091,    -0.00000000857,
	  -0.00000000156,     0.00000000124,
	  -0.00000002305,    -0.00000042733,
	  -0.00000004031,     0.00000002817,
	   0.00000000142,     0.00000000168,
	  -0.00000042766,     0.00000002310,
	   0.00000002824,     0.00000004040,
	   0.00000000168,    -0.00000000143,
	   0.00000000555,     0.00000002101,
	   0.00000000083,    -0.00000000062,
	   0.00000006499,    -0.00000001826,
	  -0.00000000171,    -0.00000000226,
	   0.00000079084,    -0.00000000018,
	   0.00000000066,    -0.00000000005,
	   0.00000000009,    -0.00000078833,
	   0.00000000026,    -0.00000000090,
	  -0.00000002722,    -0.00000000380,
	   0.00000000064,    -0.00000000415,
	  -0.00000000241,    -0.00000000002,
	  -0.00000000001,     0.00000000242,
	  -0.00000058863,    -0.00001063777,
	  -0.00000100530,     0.00000070994,
	   0.00000003526,     0.00000004251,
	   0.00000036320,    -0.00000001949,
	  -0.00000002427,    -0.00000003426,
	  -0.00000000146,     0.00000000122,
	   0.00000497112,     0.00000000042,
	   0.00000000547,     0.00000000079,
	  -0.00000000041,    -0.00000497881,
	  -0.00000000036,    -0.00000000438,
	  -0.00000000283,    -0.00000000106,
	  -0.00000000106,     0.00000000283,
	  -0.00000000161,    -0.00000004134,
	  -0.00000000721,    -0.00000009034,
	   0.00000002707,    -0.00000000020,
	  -0.00000000068,    -0.00000012341,
	   0.00000000199,    -0.00000000757,
	   0.00000000338,     0.00000000049,
	  -0.00000003558,    -0.00000000063,
	   0.00000000240,    -0.00000000070,
	  -0.00000000006,    -0.00000000150,
	   0.00000000016,    -0.00000000065,
	   0.00000001097,     0.00000000021,
	  -0.00000000004,     0.00000000277,
	   0.00018549188,     0.00000000069,
	   0.00000003914,     0.00000000816,
	   0.00000000008,     0.00001843741,
	  -0.00000000059,     0.00000000169,
	   0.00000001405,    -0.00000053802,
	   0.00000002540,     0.00000003592,
	  -0.00000000090,     0.00000000214,
	  -0.00000026887,    -0.00000002891,
	   0.00000001790,    -0.00000005084,
	   0.00000000107,     0.00000000180,
	   0.00000004231,    -0.00000009657,
	  -0.00000000943,    -0.00000000243,
	  -0.00000009661,    -0.00000004235,
	  -0.00000000242,     0.00000000946,
	   0.00000076240,     0.00000001893,
	  -0.00000000018,     0.00000000171,
	  -0.00000000029,    -0.00000000395,
	  -0.00000000392,     0.00000000080,
	   0.00000171862,     0.00000000037,
	   0.00000000519,     0.00000000000,
	   0.00000000000,    -0.00000000518,
	   0.00000000586,     0.00000000000,
	   0.00000000000,     0.00000000586,
	  -0.00000000169,    -0.00000000065,
	  -0.00000000065,     0.00000000169,
	   0.00000000187,     0.00000000019,
	   0.00000000018,    -0.00000000186,
	   0.00000001929,     0.00000000141,
	  -0.00000000139,    -0.00000000002,
	  -0.00000000002,     0.00000000139,
	  -0.00000006705,    -0.00000002537,
	   0.00000002889,     0.00000000720,
	  -0.00000000012,    -0.00000000090,
	   0.00000000720,    -0.00000002888,
	  -0.00000000090,     0.00000000012,
	   0.00000008990,     0.00000000931,
	  -0.00000001161,     0.00000000054,
	   0.00000000054,     0.00000001158,
	   0.00000003260,     0.00000000044,
	  -0.00000005363,    -0.00000000439,
	   0.00000000007,    -0.00000000163,
	  -0.00000000363,    -0.00000000067,
	  -0.00000000068,     0.00000000398,
	  -0.00000000229,    -0.00000000024,
	  -0.00000000024,     0.00000000229,
	  -0.00000000157,    -0.00000001091,
	   0.00000000116,    -0.00000000016,
	   0.00000125181,     0.00000030837,
	  -0.00000000501,    -0.00000004209,
	  -0.00000000240,     0.00000000966,
	  -0.00000047338,    -0.00000005814,
	   0.00000000181,     0.00000000768,
	  -0.00000005805,     0.00000047315,
	   0.00000000767,    -0.00000000181,
	  -0.00000075130,     0.00000002130,
	  -0.00000000033,    -0.00000001506,
	  -0.00000010345,     0.00000000605,
	   0.00000000036,    -0.00000000143,
	   0.00000000599,     0.00000010399,
	  -0.00000000143,    -0.00000000036,
	  -0.00000015469,    -0.00000002868,
	   0.00000000142,    -0.00000000761,
	   0.00000000007,     0.00000000046,
	   0.00000000149,    -0.00000000019,
	   0.00000001412,     0.00000000000,
	   0.00000000000,    -0.00000001416,
	  -0.00002419922,    -0.00000294324,
	   0.00000009665,     0.00000039161,
	   0.00000005487,    -0.00000044720,
	  -0.00000000727,     0.00000000174,
	   0.00000678722,     0.00000000088,
	  -0.00000000088,    -0.00000678013,
	   0.00000000017,     0.00000000105,
	   0.00000000105,    -0.00000000017,
	   0.00000002698,     0.00000000846,
	  -0.00000000999,    -0.00000000191,
	  -0.00000000191,     0.00000000999,
	  -0.00000004018,    -0.00000000017,
	   0.00000000000,    -0.00000000177,
	  -0.00000004848,    -0.00000000295,
	   0.00000000249,     0.00000000013,
	   0.00000000013,    -0.00000000249,
	  -0.00000399571,     0.00000022920,
	   0.00000001392,    -0.00000005558,
	  -0.00000001138,    -0.00000020020,
	   0.00000000278,     0.00000000070,
	  -0.00000000887,     0.00000000068,
	   0.00000000058,    -0.00000000218,
	   0.00000018275,     0.00000001074,
	  -0.00000000015,     0.00000000268,
	   0.00000000317,     0.00000000048,
	   0.00000000048,    -0.00000000417,
	   0.00000024133,     0.00000003454,
	  -0.00000000114,     0.00000000711,
	   0.00000000006,    -0.00000000111,
	   0.00000000054,    -0.00000000002,
	   0.00051844499,     0.00000000082,
	   0.00000000004,     0.00002645235,
	   0.00000030934,    -0.00000007598,
	  -0.00000000119,     0.00000001005,
	  -0.00000003796,    -0.00000061912,
	   0.00000000462,     0.00000000240,
	  -0.00000001254,    -0.00000004375,
	  -0.00000000682,     0.00000000147,
	  -0.00000004372,     0.00000001254,
	   0.00000000147,     0.00000000681,
	   0.00000086437,    -0.00000007080,
	   0.00000000082,     0.00000000831,
	   0.00000008621,    -0.00000000502,
	  -0.00000000030,     0.00000000120,
	  -0.00000000499,    -0.00000008625,
	   0.00000000120,     0.00000000030,
	  -0.00000002565,    -0.00000000471,
	   0.00000000375,     0.00000000045,
	   0.00000000045,    -0.00000000374,
	  -0.00000035348,    -0.00000006416,
	   0.00000000122,    -0.00000000637,
	   0.00000009985,     0.00000000559,
	  -0.00000000036,    -0.00000000143,
	   0.00000000556,    -0.00000009974,
	  -0.00000000143,     0.00000000036,
	   0.00000000882,    -0.00000000129,
	  -0.00000000129,    -0.00000000882,
	   0.00000535112,    -0.00000030704,
	  -0.00000001879,     0.00000007507,
	   0.00000000975,     0.00000017090,
	  -0.00000000237,    -0.00000000059,
	   0.00000000267,    -0.00000000052,
	  -0.00000000024,     0.00000000350,
	  -0.00000000193,     0.00000000018,
	  -0.00000000018,    -0.00000000193,
	   0.00000000176,    -0.00000000010,
	   0.00000000010,     0.00000000176,
	  -0.00000009180,     0.00000002921,
	   0.00000000096,     0.00000000218,
	   0.00000015116,    -0.00000001853,
	  -0.00000000059,     0.00000000225,
	   0.00000001858,     0.00000015134,
	  -0.00000000226,    -0.00000000059,
	  -0.00000001225,    -0.00000004271,
	  -0.00000000665,     0.00000000144,
	   0.00000004269,    -0.00000001224,
	  -0.00000000144,    -0.00000000665,
	  -0.00000003385,     0.00000000122,
	  -0.00000006716,    -0.00000016405,
	   0.00000001366,     0.00000000858,
	   0.00000000451,    -0.00000000101,
	   0.00000000374,     0.00000000387,
	   0.00000000381,     0.00000000497,
	  -0.00000000117,     0.00000000118,
	   0.00000000118,     0.00000000117,
	   0.00000016343,    -0.00000002317,
	   0.00000000110,     0.00000000842,
	   0.00000000191,    -0.00000000017,
	  -0.00000000017,    -0.00000000201,
	  -0.00000006232,     0.00000006486,
	  -0.00000000076,    -0.00000000075,
	  -0.00000008527,    -0.00000000478,
	   0.00000000030,     0.00000000120,
	  -0.00000000479,     0.00000008527,
	   0.00000000120,    -0.00000000030,
	   0.00000002376,    -0.00000000180,
	   0.00000000009,     0.00000000140,
	  -0.00000492873,    -0.00000028176,
	   0.00000001728,     0.00000006902,
	   0.00000000951,    -0.00000016675,
	  -0.00000000237,     0.00000000059,
	  -0.00000000685,     0.00000000059,
	   0.00000000033,     0.00000000660,
	   0.00000005629,     0.00000000002,
	   0.00000000014,     0.00000006515,
	  -0.00000000193,    -0.00000000018,
	   0.00000000018,    -0.00000000193,
	   0.00000012063,     0.00000000022,
	  -0.00000000013,    -0.00000002277,
	   0.00000000167,     0.00000000010,
	  -0.00000000010,     0.00000000167,
	  -0.00000000115,    -0.00000000014,
	   0.00000000013,    -0.00000000116,
	  -0.00000000292,     0.00000000078,
	  -0.00000000079,    -0.00000000293,
	   0.00000000040,     0.00000000093,
	  -0.00000000093,     0.00000000040,
	   0.00000000016,     0.00000000036,
	  -0.00000002688,     0.00000017743,
	  -0.00000001237,    -0.00000001772,
	  -0.00000000799,    -0.00000000114,
	   0.00000000076,    -0.00000000054,
	  -0.00000000367,     0.00000000048,
	   0.00000000048,     0.00000000367,
	  -0.00000018295,     0.00000003376,
	  -0.00000000109,    -0.00000000671,
	  -0.00000000240,     0.00000000017,
	   0.00000000017,     0.00000000241,
	   0.00000000039,     0.00000000521,
	  -0.00000003881,     0.00000000284,
	  -0.00000000050,    -0.00000000689,
	   0.00000002709,    -0.00000000002,
	  -0.00000007224,     0.00000000010,
	   0.00000000588,     0.00000000005,
	  -0.00000000005,     0.00000000591,
	  -0.00000000088,     0.00000000018,
	   0.00000000018,     0.00000000088,
	   0.00000000749,     0.00000000493,
	   0.00000000206,    -0.00000001270,
	   0.00000000115,     0.00000000016,
	  -0.00000003472,     0.00000000008,
	   0.00000000495,    -0.00000000047,
	  -0.00000000047,    -0.00000000492,
	  -0.00000000015,    -0.00000000137,
	  -0.00000000137,     0.00000000015,
	  -0.00000000984,    -0.00000009217,
	   0.00000007634,    -0.00000008520,
	  -0.00000008520,    -0.00000007635,
	   0.00000000046,    -0.00000000011,
	   0.00000000432,     0.00000000000,
	   0.00000000000,    -0.00000000432,
	   0.00000378084,     0.00000021402,
	  -0.00000001336,    -0.00000005336,
	  -0.00000001123,     0.00000019657,
	   0.00000000279,    -0.00000000070,
	   0.00000002459,    -0.00000000049,
	  -0.00000000006,    -0.00000002687,
	   0.00000610076,    -0.00000680529,
	   0.00000001020,    -0.00000007808,
	   0.00000008268,     0.00000007410,
	   0.00000843696,    -0.00000000017,
	   0.00000000017,    -0.00000843700,
	   0.00000003955,    -0.00000000017,
	   0.00000000000,     0.00000000250,
	   0.00101174992,     0.00000000018,
	   0.00000003201,     0.00000002429,
	   0.00000000000,     0.00003322163,
	  -0.00000000060,     0.00000000086,
	  -0.00000005031,    -0.00000011229,
	  -0.00000000007,    -0.00000000100,
	  -0.00000005613,     0.00000010063,
	   0.00000008633,    -0.00000009664,
	  -0.00000000951,     0.00000000064,
	  -0.00000009661,    -0.00000008635,
	   0.00000000064,     0.00000000951,
	   0.00000005934,     0.00000024191,
	   0.00000001835,    -0.00000002502,
	   0.00000000434,    -0.00000000152,
	  -0.00000000061,    -0.00000000043,
	  -0.00000002485,    -0.00000002773,
	   0.00000002772,    -0.00000002486,
	   0.00000008531,    -0.00000009545,
	  -0.00000000939,     0.00000000063,
	   0.00000009547,     0.00000008529,
	  -0.00000000063,    -0.00000000939,
	   0.00000000107,    -0.00000000021,
	   0.00000000021,     0.00000000107,
	   0.00000000050,     0.00000000191,
	  -0.00000000191,     0.00000000050,
	   0.00000000020,    -0.00000000088,
	   0.00000000101,     0.00000000023,
	  -0.00000000862,     0.00000000000,
	   0.00000000000,    -0.00000000863,
	   0.00000000330,     0.00000000000,
	   0.00000000000,     0.00000000330,
	   0.00000000058,     0.00000000000,
	   0.00000000000,     0.00000000058,
	   0.00000000124,     0.00000000000,
	   0.00000000000,     0.00000000124,
	   0.00000004753,     0.00000000000,
	   0.00000000000,    -0.00000000015,
	   0.00000000000,     0.00000004753,
	   0.00000000015,     0.00000000000,
	  -0.00000000515,     0.00000000055,
	   0.00000000081,     0.00000000000,
	   0.00000000000,     0.00000000081,
	  -0.00000000116,     0.00000000000,
	   0.00000000000,    -0.00000000116,
	   0.00000000082,     0.00000000000,
	   0.00000000000,     0.00000000082,
	   0.00000006464,     0.00000010152,
	  -0.00000000499,     0.00000000222,
	  -0.00000000013,    -0.00000000012,
	   0.00000007462,     0.00000030197,
	  -0.00000000814,     0.00000000223,
	  -0.00000000005,    -0.00000000008,
	  -0.00000030224,     0.00000007072,
	  -0.00000000234,    -0.00000000813,
	   0.00000000008,    -0.00000000004,
	   0.00000001421,     0.00000001685,
	   0.00000000082,    -0.00000000060,
	  -0.00000001863,     0.00000002015,
	   0.00000000055,     0.00000000085,
	   0.00000002506,     0.00000005357,
	   0.00000000831,    -0.00000000427,
	  -0.00000000033,    -0.00000000085,
	  -0.00000001567,    -0.00000003991,
	   0.00000000578,     0.00000000034,
	   0.00000003724,    -0.00000001451,
	  -0.00000000018,     0.00000000599,
	   0.00000001853,     0.00000007985,
	   0.00000000693,    -0.00000000130,
	  -0.00000008116,     0.00000001953,
	   0.00000000153,     0.00000000721,
	  -0.00000001820,     0.00000000670,
	   0.00000000113,     0.00000000236,
	   0.00000000024,    -0.00000000009,
	  -0.00000002442,    -0.00000003715,
	  -0.00000000432,     0.00000000206,
	   0.00000000023,     0.00000000059,
	  -0.00000000939,     0.00000003908,
	  -0.00000000591,    -0.00000000203,
	  -0.00000003810,    -0.00000000996,
	   0.00000000198,    -0.00000000605,
	  -0.00000000766,    -0.00000008972,
	  -0.00000000740,     0.00000000189,
	   0.00000009061,    -0.00000000829,
	  -0.00000000205,    -0.00000000757,
	   0.00000002866,     0.00000000817,
	  -0.00000000169,     0.00000000656,
	   0.00000000230,     0.00000007793,
	  -0.00000000353,    -0.00000000153,
	  -0.00000007636,     0.00000000258,
	   0.00000000160,    -0.00000000282,
	   0.00000000919,     0.00000001082,
	   0.00000000104,    -0.00000000090,
	  -0.00000001087,     0.00000000849,
	   0.00000000095,     0.00000000101,
	   0.00000001123,     0.00000000579,
	  -0.00000000049,     0.00000000098,
	  -0.00000003885,     0.00000016908,
	  -0.00000000842,    -0.00000000642,
	  -0.00000016904,    -0.00000003882,
	   0.00000000642,    -0.00000000843,
	  -0.00000000540,     0.00000001885,
	  -0.00000000242,    -0.00000000247,
	  -0.00000005271,     0.00000022909,
	  -0.00000001141,    -0.00000000864,
	  -0.00000022897,    -0.00000005251,
	   0.00000000866,    -0.00000001144,
	  -0.00000002307,    -0.00000000240,
	   0.00000000088,    -0.00000000154,
	  -0.00000007469,     0.00000032516,
	  -0.00000001620,    -0.00000001233,
	   0.00000000051,    -0.00000000064,
	  -0.00000032512,    -0.00000007469,
	   0.00000001233,    -0.00000001620,
	   0.00000000064,     0.00000000051,
	   0.00000000272,     0.00000000493,
	  -0.00000009367,     0.00000040732,
	  -0.00000002029,    -0.00000001544,
	   0.00000000064,    -0.00000000081,
	  -0.00000040733,    -0.00000009346,
	   0.00000001545,    -0.00000002031,
	   0.00000000081,     0.00000000064,
	  -0.00000000001,    -0.00000000009,
	   0.00000000002,    -0.00000000003,
	  -0.00000000004,    -0.00000000001,
	  -0.00000000012,    -0.00000000006,
	  -0.00000000001,     0.00000000003,
	  -0.00000028326,     0.00000063190,
	   0.00000013905,     0.00000006615,
	  -0.00000000011,     0.00000000116,
	   0.00000000016,    -0.00000000003,
	   0.00000000123,     0.00000000016,
	  -0.00000000003,    -0.00000000017,
	  -0.00000000003,     0.00000000002,
	   0.00000000003,     0.00000000007,
	   0.00000001537,    -0.00000003431,
	  -0.00000000742,    -0.00000000350,
	  -0.00000000096,     0.00000000215,
	   0.00000000046,     0.00000000022,
	  -0.00000000015,    -0.00000000036,
	   0.00000000015,     0.00000000042,
	  -0.00000000050,     0.00000000006,
	   0.00000000006,     0.00000000050,
	  -0.00000000117,     0.00000000013,
	   0.00000000000,     0.00000000063,
	  -0.00000000245,     0.00000000170,
	   0.00000000064,     0.00000000114,
	   0.00000000171,     0.00000000246,
	   0.00000000114,    -0.00000000064,
	   0.00000000077,    -0.00000000154,
	  -0.00000000049,    -0.00000000030,
	  -0.00000000154,    -0.00000000078,
	  -0.00000000030,     0.00000000049,
	  -0.00000000608,     0.00000000418,
	   0.00000000155,     0.00000000277,
	   0.00000000057,    -0.00000000028,
	   0.00000000121,     0.00000000192,
	   0.00000000100,    -0.00000000048,
	  -0.00000000786,     0.00000001567,
	   0.00000000503,     0.00000000308,
	   0.00000000052,    -0.00000000076,
	   0.00000001571,     0.00000000789,
	   0.00000000310,    -0.00000000505,
	  -0.00000000077,    -0.00000000052,
	   0.00000000096,     0.00000000073,
	   0.00000000063,    -0.00000000097,
	   0.00000000061,    -0.00000000121,
	  -0.00000000039,    -0.00000000024,
	  -0.00000000084,    -0.00000000055,
	  -0.00000000024,     0.00000000032,
	  -0.00000000042,    -0.00000001004,
	  -0.00000000245,    -0.00000000007,
	  -0.00000001009,     0.00000000040,
	  -0.00000000009,     0.00000000247,
	  -0.00000000062,    -0.00000000010,
	  -0.00000000003,     0.00000000059,
	  -0.00000002131,     0.00000004231,
	   0.00000001350,     0.00000000826,
	   0.00000000140,    -0.00000000205,
	   0.00000000865,     0.00000000530,
	   0.00000000231,    -0.00000000306,
	  -0.00000000046,    -0.00000000037,
	   0.00000000418,     0.00000010369,
	   0.00000002546,     0.00000000088,
	   0.00000000021,    -0.00000000296,
	   0.00000010395,    -0.00000000421,
	   0.00000000091,    -0.00000002556,
	  -0.00000000297,    -0.00000000022,
	   0.00000000476,     0.00000000074,
	   0.00000000024,    -0.00000000457,
	  -0.00000000049,    -0.00000001189,
	  -0.00000000291,    -0.00000000010,
	  -0.00000000002,     0.00000000034,
	   0.00000000541,    -0.00000000114,
	  -0.00000000017,    -0.00000000111,
	  -0.00000003386,    -0.00000005479,
	  -0.00000000903,     0.00000000483,
	   0.00000000036,     0.00000000071,
	  -0.00000005529,     0.00000003386,
	   0.00000000476,     0.00000000923,
	   0.00000000074,    -0.00000000035,
	  -0.00000000241,     0.00000000078,
	   0.00000000114,     0.00000000199,
	   0.00000001407,     0.00000034574,
	   0.00000008473,     0.00000000287,
	   0.00000000073,    -0.00000000985,
	  -0.00000003034,     0.00000000814,
	   0.00000000160,     0.00000000597,
	   0.00000000079,    -0.00000000010,
	   0.00000035280,     0.00000057543,
	   0.00000009589,    -0.00000005027,
	  -0.00000000371,    -0.00000000754,
	   0.00000057638,    -0.00000035416,
	  -0.00000005054,    -0.00000009623,
	  -0.00000000758,     0.00000000374,
	   0.00000001852,    -0.00000000647,
	  -0.00000000868,    -0.00000001587,
	  -0.00000014301,    -0.00000023249,
	  -0.00000003872,     0.00000002030,
	   0.00000000150,     0.00000000306,
	   0.00000236133,    -0.00000147105,
	  -0.00000020840,    -0.00000039296,
	  -0.00000003116,     0.00000001534,
	  -0.00000083790,    -0.00000046168,
	  -0.00000003908,     0.00000006351,
	   0.00000000254,     0.00000000147,
	  -0.00000047227,     0.00000084300,
	   0.00000006407,     0.00000004235,
	   0.00000000181,    -0.00000000258,
	  -0.00000001522,     0.00000001386,
	  -0.00000000039,    -0.00000000040,
	   0.00000001569,     0.00000000555,
	  -0.00000000101,     0.00000000023,
	   0.00000332593,     0.00000540750,
	   0.00000090183,    -0.00000047228,
	  -0.00000003477,    -0.00000007118,
	  -0.00001803251,     0.00001123127,
	   0.00000159028,     0.00000300061,
	   0.00000023794,    -0.00000011710,
	  -0.00000000570,    -0.00000001260,
	   0.00000893490,     0.00000498403,
	   0.00000043574,    -0.00000067881,
	  -0.00000002715,    -0.00000001753,
	   0.00000496790,    -0.00000896318,
	  -0.00000068405,    -0.00000043282,
	  -0.00000001713,     0.00000002765,
	   0.00000011132,    -0.00000011679,
	   0.00000000058,     0.00000000252,
	  -0.00000000098,     0.00000000167,
	  -0.00000012654,    -0.00000005491,
	   0.00000000632,     0.00000000031,
	   0.00000000164,     0.00000000073,
	   0.00000028052,     0.00000015593,
	   0.00000001366,    -0.00000002128,
	  -0.00000000086,    -0.00000000055,
	   0.00000081640,    -0.00000144852,
	  -0.00000011014,    -0.00000007115,
	  -0.00000000287,     0.00000000442,
	   0.00000053846,    -0.00000000708,
	  -0.00000000118,     0.00000000090,
	   0.00000000210,    -0.00000055026,
	  -0.00000000065,    -0.00000000081,
	   0.00000000353,    -0.00000000454,
	  -0.00000000050,     0.00000000013,
	  -0.00000000151,     0.00000000486,
	   0.00000000002,     0.00000000052,
	  -0.00000489816,    -0.00000271942,
	  -0.00000023875,     0.00000037212,
	   0.00000001496,     0.00000000963,
	  -0.00000607805,     0.00001078556,
	   0.00000082113,     0.00000053100,
	   0.00000002138,    -0.00000003289,
	  -0.00000596347,     0.00000002043,
	  -0.00000000083,    -0.00000000026,
	   0.00000007156,     0.00000596132,
	  -0.00000000134,    -0.00000000650,
	  -0.00000000057,     0.00000000020,
	  -0.00000001566,     0.00000004174,
	   0.00000000583,    -0.00000000103,
	  -0.00000000001,    -0.00000000063,
	   0.00000002498,    -0.00000002910,
	  -0.00000000076,    -0.00000000578,
	  -0.00000000051,     0.00000000016,
	   0.00000000001,    -0.00000000092,
	   0.00000036238,    -0.00000000134,
	  -0.00000000439,    -0.00000105932,
	  -0.00000002291,     0.00000000332,
	  -0.00000000089,    -0.00000000004,
	   0.00000000897,     0.00000000052,
	  -0.00000000158,     0.00000000005,
	   0.00000000105,    -0.00000000481,
	   0.00000000141,     0.00000000397,
	  -0.00000423084,     0.00000003738,
	   0.00000000132,    -0.00000000040,
	  -0.00000000004,    -0.00000000019,
	   0.00000003194,     0.00000738484,
	  -0.00000000106,     0.00000000001,
	   0.00000004138,    -0.00000001103,
	  -0.00000000169,     0.00000000721,
	   0.00000005228,    -0.00000011681,
	   0.00000000095,    -0.00000000265,
	   0.00000000648,     0.00000003683,
	   0.00000000144,    -0.00000000290,
	   0.00000000622,    -0.00000003054,
	  -0.00000000112,    -0.00000000293,
	  -0.00000000352,     0.00000000039,
	  -0.00000000007,    -0.00000000021,
	  -0.00000000550,    -0.00000000284,
	   0.00000000040,    -0.00000000048,
	  -0.00000002129,    -0.00000000051,
	  -0.00000000039,    -0.00000002202,
	  -0.00000000033,    -0.00000000114,
	   0.00000000097,     0.00000000023,
	  -0.00000003361,     0.00000023249,
	  -0.00000001134,    -0.00000000775,
	   0.00000000030,    -0.00000000042,
	  -0.00000006303,     0.00000000147,
	   0.00000000062,    -0.00000000161,
	  -0.00000008128,     0.00000000186,
	  -0.00000000074,    -0.00000000070,
	  -0.00000000043,    -0.00000007072,
	  -0.00000000082,     0.00000000125,
	   0.00000000295,     0.00000000846,
	   0.00000000069,    -0.00000000023,
	  -0.00000000791,    -0.00000000228,
	   0.00000000011,     0.00000000074,
	  -0.00000000036,    -0.00000000035,
	   0.00000000105,    -0.00000000087,
	  -0.00000000087,    -0.00000000104,
	  -0.00000000022,     0.00000000036,
	   0.00000000069,     0.00000000043,
	  -0.00000000067,    -0.00000000018,
	   0.00000000197,    -0.00000000165,
	  -0.00000000001,    -0.00000000056,
	  -0.00000000315,    -0.00000000421,
	  -0.00000000117,    -0.00000000004,
	   0.00000001012,    -0.00000000582,
	   0.00000000031,    -0.00000000188,
	  -0.00000000586,    -0.00000001007,
	  -0.00000000187,    -0.00000000030,
	  -0.00000000059,     0.00000000028,
	  -0.00000000055,    -0.00000000007,
	  -0.00000000013,     0.00000000105,
	   0.00000000029,     0.00000000027,
	   0.00000000065,     0.00000000021,
	   0.00000000039,    -0.00000000119,
	   0.00000002288,    -0.00000001333,
	   0.00000000069,    -0.00000000426,
	  -0.00000000027,    -0.00000000019,
	  -0.00000002451,    -0.00000004646,
	  -0.00000000856,    -0.00000000168,
	  -0.00000000041,     0.00000000053,
	   0.00000008319,    -0.00000003019,
	   0.00000000319,    -0.00000000905,
	  -0.00000000041,    -0.00000000039,
	  -0.00000003067,    -0.00000008275,
	  -0.00000000901,    -0.00000000307,
	  -0.00000000037,     0.00000000041,
	  -0.00000000029,    -0.00000000069,
	  -0.00000000055,     0.00000000020,
	   0.00000023380,    -0.00000008666,
	   0.00000000882,    -0.00000002553,
	  -0.00000000116,    -0.00000000106,
	  -0.00000015455,    -0.00000045583,
	  -0.00000004964,    -0.00000001827,
	  -0.00000000213,     0.00000000225,
	   0.00000053520,    -0.00000009200,
	   0.00000001450,    -0.00000002550,
	  -0.00000000081,    -0.00000000093,
	  -0.00000009726,    -0.00000053204,
	  -0.00000002532,    -0.00000001367,
	  -0.00000000087,     0.00000000083,
	  -0.00000000074,    -0.00000000267,
	  -0.00000000128,     0.00000000004,
	  -0.00000000343,     0.00000000094,
	   0.00000000094,     0.00000000342,
	   0.00000197366,    -0.00000035872,
	   0.00000005250,    -0.00000009441,
	  -0.00000000306,    -0.00000000323,
	  -0.00000062276,    -0.00000372125,
	  -0.00000017945,    -0.00000010123,
	  -0.00000000618,     0.00000000583,
	   0.00000211630,     0.00000003694,
	  -0.00000001006,    -0.00000210036,
	   0.00000000079,     0.00000000431,
	  -0.00000000206,    -0.00000000612,
	   0.00000000553,    -0.00000000190,
	   0.00000000026,     0.00000000033,
	  -0.00000000035,     0.00000000029,
	   0.00000000031,     0.00000000030,
	  -0.00000002066,     0.00000000717,
	   0.00000000073,     0.00000000486,
	  -0.00000001423,     0.00000000475,
	   0.00000000472,     0.00000001414,
	  -0.00000000206,     0.00000000049,
	  -0.00000000019,    -0.00000000050,
	  -0.00000000048,     0.00000000020,
	  -0.00000000034,     0.00000000034,
	   0.00000000040,     0.00000000012,
	  -0.00000000047,     0.00000000010,
	   0.00000000012,     0.00000000045,
	   0.00000000029,    -0.00000000023,
	  -0.00000000041,    -0.00000000054,
	   0.00000000110,    -0.00000000060,
	  -0.00000000021,    -0.00000000038,
	  -0.00000000060,    -0.00000000109,
	  -0.00000000038,     0.00000000021,
	  -0.00000000013,     0.00000000047,
	  -0.00000000068,    -0.00000000009,
	  -0.00000000008,     0.00000000068,
	   0.00001120472,    -0.00000000788,
	  -0.00000000376,     0.00000000049,
	   0.00000000002,    -0.00000000091,
	  -0.00000001742,    -0.00002056367,
	   0.00000000084,     0.00000000686,
	  -0.00000000166,    -0.00000000004,
	  -0.00000010382,     0.00000020427,
	  -0.00000000046,    -0.00000001190,
	   0.00000000011,    -0.00000000053,
	  -0.00000007471,     0.00000012430,
	  -0.00000000350,     0.00000001284,
	  -0.00000000006,    -0.00000000045,
	  -0.00000000581,    -0.00000003512,
	   0.00000000226,     0.00000000106,
	   0.00000003153,    -0.00000000645,
	  -0.00000000095,     0.00000000252,
	  -0.00000008052,     0.00000006329,
	  -0.00000000383,     0.00000002486,
	  -0.00000001379,     0.00000006105,
	  -0.00000000303,    -0.00000000229,
	   0.00000006088,     0.00000001307,
	  -0.00000000232,     0.00000000301,
	  -0.00000000096,     0.00000000006,
	   0.00000000102,     0.00000000167,
	   0.00000000167,    -0.00000000094,
	   0.00000000086,     0.00000000197,
	   0.00000000031,    -0.00000000016,
	   0.00000000238,    -0.00000000121,
	  -0.00000000019,    -0.00000000037,
	   0.00000000047,     0.00000000026,
	   0.00000000034,    -0.00000000062,
	   0.00000000099,     0.00000000055,
	   0.00000000055,    -0.00000000097,
	  -0.00000000019,     0.00000000035,
	   0.00000000246,    -0.00000000137,
	  -0.00000000044,    -0.00000000089,
	  -0.00000000250,    -0.00000000483,
	  -0.00000000176,     0.00000000081,
	   0.00000000581,    -0.00000000191,
	  -0.00000000068,    -0.00000000187,
	  -0.00000000196,    -0.00000000577,
	  -0.00000000185,     0.00000000072,
	   0.00000000058,     0.00000000001,
	   0.00000000002,    -0.00000000109,
	  -0.00000000154,    -0.00000000044,
	  -0.00000000011,     0.00000000017,
	  -0.00000000088,     0.00000000287,
	   0.00000000032,     0.00000000020,
	  -0.00000000175,    -0.00000000011,
	  -0.00000000040,     0.00000000175,
	   0.00000000121,     0.00000000052,
	   0.00000000098,    -0.00000000226,
	   0.00000000073,     0.00000000003,
	   0.00000000001,    -0.00000000073,
	  -0.00000024472,    -0.00000007125,
	  -0.00000000548,    -0.00000001099,
	   0.00000000034,    -0.00000000032,
	  -0.00000012991,     0.00000043104,
	  -0.00000001935,     0.00000000931,
	  -0.00000000055,    -0.00000000058,
	  -0.00000013629,    -0.00000000615,
	   0.00000000231,    -0.00000013792,
	   0.00000000027,    -0.00000000032,
	   0.00000000025,    -0.00000000190,
	   0.00000000176,     0.00000000034,
	  -0.00000027987,     0.00000122246,
	  -0.00000006113,    -0.00000004640,
	  -0.00000022065,    -0.00000005128,
	   0.00000000840,    -0.00000001101,
	   0.00000000023,    -0.00000000243,
	  -0.00000000536,    -0.00000000379,
	  -0.00000000356,     0.00000001413,
	  -0.00000001202,     0.00000005234,
	  -0.00000002721,     0.00000011835,
	  -0.00000000010,    -0.00000000055,
	   0.00000001606,    -0.00000000548,
	  -0.00000000195,    -0.00000000521,
	  -0.00000000990,    -0.00000003035,
	  -0.00000000987,     0.00000000353,
	   0.00000001797,    -0.00000000216,
	  -0.00000000129,    -0.00000000514,
	  -0.00000000261,    -0.00000001760,
	  -0.00000000507,     0.00000000139,
	   0.00000000035,    -0.00000000032,
	  -0.00000000022,    -0.00000000033,
	  -0.00000000032,     0.00000000023,
	  -0.00000000623,    -0.00000000082,
	  -0.00000000030,     0.00000000034,
	  -0.00000000161,     0.00000001135,
	   0.00000000063,     0.00000000054,
	  -0.00000000093,    -0.00000000013,
	  -0.00000000001,     0.00000000100,
	   0.00000000171,     0.00000000026,
	   0.00000000049,    -0.00000000312,
	  -0.00000000053,     0.00000000011,
	   0.00000000020,     0.00000000097,
	   0.00000006323,    -0.00000000786,
	  -0.00000000455,    -0.00000001841,
	  -0.00000001453,    -0.00000011605,
	  -0.00000003381,     0.00000000840,
	  -0.00000000313,     0.00000000213,
	   0.00000000086,     0.00000000053,
	   0.00000000059,     0.00000000336,
	   0.00000000071,    -0.00000000036,
	  -0.00000001308,     0.00000000164,
	   0.00000000195,     0.00000000242,
	   0.00000000014,    -0.00000000020,
	   0.00000000288,     0.00000002338,
	   0.00000000435,    -0.00000000349,
	  -0.00000000036,    -0.00000000026,
	  -0.00000000078,    -0.00000001415,
	  -0.00000000137,     0.00000000096,
	  -0.00000001382,     0.00000000067,
	   0.00000000089,     0.00000000130,
	  -0.00000000532,    -0.00000009867,
	  -0.00000000947,     0.00000000662,
	   0.00000000032,     0.00000000040,
	  -0.00000017598,     0.00000000925,
	   0.00000001185,     0.00000001695,
	   0.00000000069,    -0.00000000059,
	   0.00000005216,    -0.00000000021,
	   0.00000000048,    -0.00000004966,
	  -0.00000000049,     0.00000000023,
	  -0.00000000024,    -0.00000000046,
	   0.00000000518,     0.00000000117,
	   0.00000000117,    -0.00000000517,
	   0.00000050713,    -0.00000000004,
	   0.00000000051,     0.00000000005,
	  -0.00000000010,    -0.00000090341,
	   0.00000000009,    -0.00000000089,
	   0.00000000064,     0.00000000807,
	   0.00000000037,    -0.00000000026,
	  -0.00000000538,     0.00000000224,
	   0.00000000025,     0.00000000034,
	  -0.00000000111,    -0.00000000259,
	   0.00000000251,    -0.00000000115,
	   0.00000015477,     0.00000002922,
	  -0.00000001344,    -0.00000000971,
	  -0.00000000108,     0.00000000888,
	  -0.00000001801,     0.00000007850,
	  -0.00000000393,    -0.00000000292,
	   0.00000007854,     0.00000001803,
	  -0.00000000292,     0.00000000393,
	   0.00000000075,    -0.00000001395,
	   0.00000000132,     0.00000000093,
	  -0.00000002463,    -0.00000000136,
	   0.00000000164,    -0.00000000233,
	  -0.00000000318,    -0.00000000006,
	   0.00000000002,    -0.00000000327,
	  -0.00000068245,     0.00000297114,
	  -0.00000014889,    -0.00000011213,
	   0.00000000467,    -0.00000000590,
	  -0.00000030303,    -0.00000006962,
	   0.00000001147,    -0.00000001511,
	   0.00000000060,     0.00000000048,
	   0.00000000835,     0.00000000221,
	  -0.00000000087,     0.00000000065,
	   0.00000000145,    -0.00000000441,
	   0.00000000082,     0.00000000057,
	   0.00000000139,     0.00000000103,
	   0.00000000103,    -0.00000000139,
	  -0.00000000649,     0.00000002821,
	  -0.00000000150,    -0.00000000016,
	  -0.00000000026,     0.00000000265,
	  -0.00000000954,     0.00000001885,
	   0.00000000254,    -0.00000000736,
	  -0.00000000736,    -0.00000000254,
	   0.00000000053,     0.00000000011,
	   0.00000000020,    -0.00000000097,
	   0.00000000026,    -0.00000000159,
	  -0.00000000159,    -0.00000000026,
	   0.00000000931,     0.00000000000,
	   0.00000000000,    -0.00000001638,
	   0.00000014091,    -0.00000037837,
	   0.00000001137,     0.00000001723,
	   0.00000000718,     0.00000000283,
	  -0.00000002511,     0.00000010926,
	  -0.00000000544,    -0.00000000414,
	   0.00000010915,     0.00000002507,
	  -0.00000000413,     0.00000000544,
	   0.00000001111,    -0.00000006532,
	   0.00000000315,     0.00000000051,
	  -0.00000192802,     0.00000839283,
	  -0.00000042147,    -0.00000031891,
	   0.00000001323,    -0.00000001658,
	  -0.00000043204,    -0.00000009924,
	   0.00000001640,    -0.00000002155,
	   0.00000000086,     0.00000000068,
	   0.00000000006,     0.00000000529,
	   0.00000001016,     0.00000000167,
	  -0.00000000022,     0.00000000135,
	   0.00000000135,     0.00000000022,
	  -0.00000000047,     0.00000000155,
	   0.00000000154,     0.00000000046,
	  -0.00000001498,     0.00000008804,
	  -0.00000000271,    -0.00000000044,
	  -0.00000000027,     0.00000000255,
	  -0.00000000255,    -0.00000000026,
	   0.00000000039,    -0.00000000131,
	  -0.00000000131,    -0.00000000039,
	   0.00000002292,    -0.00000007898,
	   0.00000000256,     0.00000000077,
	   0.00000000106,     0.00000000155,
	   0.00000000155,    -0.00000000106,
	   0.00000000286,     0.00000000000,
	   0.00000000000,    -0.00000000502,
	  -0.00000001748,     0.00000006028,
	  -0.00000000306,    -0.00000000092,
	   0.00000010346,     0.00000012411,
	  -0.00000000153,     0.00000000112,
	  -0.00000003137,     0.00000013658,
	  -0.00000000681,    -0.00000000518,
	   0.00000013658,     0.00000003138,
	  -0.00000000518,     0.00000000681,
	  -0.00000377292,     0.00001642508,
	  -0.00000082507,    -0.00000062393,
	   0.00000002581,    -0.00000003247,
	  -0.00000054180,    -0.00000012446,
	   0.00000002056,    -0.00000002703,
	   0.00000000107,     0.00000000085,
	   0.00000000201,    -0.00000000040,
	  -0.00000000142,    -0.00000000129,
	   0.00000000125,     0.00000000176,
	   0.00000000176,    -0.00000000125,
	   0.00000000124,     0.00000000175,
	  -0.00000000175,     0.00000000124,
	   0.00000000017,    -0.00000000074,
	   0.00000000074,     0.00000000017,
	   0.00000000560,    -0.00000001015,
	   0.00000000057,     0.00000000033,
	   0.00000002154,    -0.00000001883,
	   0.00000000105,     0.00000000078,
	   0.00000001853,     0.00000002173,
	  -0.00000000078,     0.00000000106,
	   0.00000000155,    -0.00000000280,
	  -0.00000000004,    -0.00000000007,
	   0.00000000342,     0.00000000145,
	   0.00000000008,    -0.00000000003,
	  -0.00000000308,     0.00000000138,
	   0.00000001184,    -0.00000000613,
	  -0.00000000090,    -0.00000000170,
	   0.00000000593,     0.00000001162,
	   0.00000000165,    -0.00000000084,
	  -0.00000000386,     0.00000000064,
	  -0.00000000071,    -0.00000000394,
	  -0.00000000002,    -0.00000000082,
	   0.00000000182,    -0.00000000066,
	  -0.00000001474,     0.00000000702,
	   0.00000000092,     0.00000000176,
	  -0.00000000698,    -0.00000001468,
	  -0.00000000175,     0.00000000091,
	   0.00000000284,    -0.00000000051,
	   0.00000000055,     0.00000000290,
	   0.00000000054,     0.00000000061,
	   0.00000000002,     0.00000000050,
	  -0.00000000067,    -0.00000000186,
	   0.00000000056,     0.00000000004,
	   0.00000000190,    -0.00000000063,
	  -0.00000000001,     0.00000000061,
	   0.00000000154,     0.00000000066,
	  -0.00000000070,     0.00000000149,
	  -0.00000000293,    -0.00000000142,
	   0.00000000142,    -0.00000000293,
	  -0.00000000397,    -0.00000000193,
	   0.00000000193,    -0.00000000397,
	  -0.00000000564,    -0.00000000274,
	   0.00000000059,    -0.00000000049,
	   0.00000000274,    -0.00000000564,
	   0.00000000049,     0.00000000059,
	  -0.00000000707,    -0.00000000343,
	   0.00000000074,    -0.00000000061,
	   0.00000000343,    -0.00000000707,
	   0.00000000061,     0.00000000074,
	  -0.00000000015,     0.00000000027,
	  -0.00000000118,     0.00000000012,
	   0.00000000000,     0.00000000062,
	   0.00000000013,     0.00000000118,
	   0.00000000062,    -0.00000000001,
	   0.00000000053,    -0.00000000036,
	  -0.00000000037,    -0.00000000053,
	  -0.00000000299,     0.00000000030,
	   0.00000000001,     0.00000000155,
	   0.00000000037,     0.00000000002,
	   0.00000000005,     0.00000000080,
	   0.00000000046,     0.00000000003,
	  -0.00000000549,     0.00000000377,
	   0.00000000138,     0.00000000244,
	   0.00000000050,    -0.00000000025,
	   0.00000000379,     0.00000000548,
	   0.00000000244,    -0.00000000139,
	  -0.00000000025,    -0.00000000050,
	   0.00000000018,     0.00000000040,
	   0.00000000038,    -0.00000000020,
	   0.00000000049,    -0.00000000034,
	  -0.00000000012,    -0.00000000022,
	   0.00000000162,    -0.00000000323,
	  -0.00000000102,    -0.00000000061,
	  -0.00000000324,    -0.00000000162,
	  -0.00000000061,     0.00000000102,
	  -0.00000001516,     0.00000001041,
	   0.00000000381,     0.00000000669,
	   0.00000000137,    -0.00000000068,
	   0.00000000157,     0.00000000280,
	   0.00000000140,    -0.00000000061,
	  -0.00000001697,     0.00000003376,
	   0.00000001066,     0.00000000645,
	   0.00000000109,    -0.00000000162,
	   0.00000003384,     0.00000001683,
	   0.00000000639,    -0.00000001069,
	  -0.00000000163,    -0.00000000108,
	   0.00000000145,     0.00000000111,
	   0.00000000093,    -0.00000000148,
	   0.00000000208,    -0.00000000416,
	  -0.00000000131,    -0.00000000079,
	  -0.00000000013,     0.00000000020,
	   0.00000000221,     0.00000000077,
	   0.00000000026,    -0.00000000061,
	  -0.00000000096,    -0.00000002219,
	  -0.00000000536,    -0.00000000015,
	  -0.00000000004,     0.00000000063,
	  -0.00000002222,     0.00000000103,
	  -0.00000000014,     0.00000000538,
	   0.00000000063,     0.00000000004,
	  -0.00000000101,    -0.00000000019,
	  -0.00000000001,     0.00000000094,
	  -0.00000005644,     0.00000011291,
	   0.00000003558,     0.00000002132,
	   0.00000000362,    -0.00000000541,
	  -0.00000001177,    -0.00000000340,
	  -0.00000000098,     0.00000000321,
	   0.00000000050,     0.00000000020,
	   0.00000000966,     0.00000023479,
	   0.00000005713,     0.00000000182,
	   0.00000000049,    -0.00000000667,
	   0.00000023454,    -0.00000001107,
	   0.00000000128,    -0.00000005705,
	  -0.00000000665,    -0.00000000039,
	   0.00000000783,     0.00000000127,
	   0.00000000018,    -0.00000000068,
	   0.00000000019,    -0.00000000741,
	  -0.00000000061,     0.00000000008,
	  -0.00000000326,    -0.00000007290,
	  -0.00000001768,    -0.00000000048,
	  -0.00000000014,     0.00000000207,
	   0.00000046649,    -0.00000002479,
	   0.00000000224,    -0.00000011261,
	  -0.00000001320,    -0.00000000082,
	  -0.00000013397,    -0.00000021758,
	  -0.00000003596,     0.00000001900,
	   0.00000000140,     0.00000000286,
	  -0.00000021693,     0.00000013532,
	   0.00000001927,     0.00000003588,
	   0.00000000284,    -0.00000000144,
	  -0.00000000748,     0.00000000213,
	   0.00000000374,     0.00000000556,
	   0.00000007605,     0.00000169596,
	   0.00000041201,     0.00000001140,
	   0.00000000328,    -0.00000004808,
	  -0.00000351952,     0.00000018716,
	  -0.00000001656,     0.00000085094,
	   0.00000009955,     0.00000000616,
	   0.00000000080,    -0.00000000800,
	   0.00000143244,     0.00000233868,
	   0.00000038937,    -0.00000020235,
	  -0.00000001479,    -0.00000003103,
	   0.00000231966,    -0.00000145058,
	  -0.00000020821,    -0.00000038350,
	  -0.00000003010,     0.00000001572,
	   0.00000005742,    -0.00000001951,
	  -0.00000000067,    -0.00000000200,
	  -0.00000000050,     0.00000000031,
	  -0.00000002853,    -0.00000004630,
	  -0.00000000041,     0.00000000214,
	   0.00000000042,     0.00000000035,
	   0.00000007762,     0.00000012533,
	   0.00000002075,    -0.00000001100,
	  -0.00000000081,    -0.00000000165,
	   0.00000072857,    -0.00000044471,
	  -0.00000006318,    -0.00000012084,
	  -0.00000000957,     0.00000000468,
	   0.00000029218,     0.00000016430,
	   0.00000001446,    -0.00000002203,
	  -0.00000000088,    -0.00000000061,
	   0.00000015987,    -0.00000029364,
	  -0.00000002230,    -0.00000001360,
	  -0.00000000050,     0.00000000091,
	   0.00000000485,    -0.00000000385,
	  -0.00000000457,    -0.00000000071,
	  -0.00000150508,    -0.00000243003,
	  -0.00000040312,     0.00000021333,
	   0.00000001578,     0.00000003201,
	  -0.00000555601,     0.00000339233,
	   0.00000048236,     0.00000092299,
	   0.00000007298,    -0.00000003568,
	  -0.00000318842,    -0.00000180041,
	  -0.00000016107,     0.00000024137,
	   0.00000000963,     0.00000000696,
	  -0.00000173656,     0.00000319826,
	   0.00000024408,     0.00000014587,
	   0.00000000517,    -0.00000000996,
	  -0.00000003415,     0.00000003499,
	   0.00000000135,     0.00000000025,
	   0.00000000037,    -0.00000000063,
	   0.00000003854,     0.00000001183,
	  -0.00000000140,    -0.00000000166,
	  -0.00000000061,    -0.00000000023,
	  -0.00000000384,     0.00000000297,
	   0.00000000079,     0.00000000149,
	   0.00000002600,    -0.00000001940,
	  -0.00000000518,    -0.00000001025,
	   0.00000000067,     0.00000000031,
	   0.00000000030,    -0.00000000067,
	   0.00000014764,     0.00000008195,
	   0.00000000715,    -0.00000001119,
	  -0.00000000045,    -0.00000000029,
	   0.00000025087,    -0.00000044576,
	  -0.00000003377,    -0.00000002176,
	  -0.00000000087,     0.00000000136,
	   0.00000018414,     0.00000000389,
	   0.00000000054,    -0.00000000020,
	  -0.00000000520,    -0.00000018055,
	   0.00000000035,     0.00000000081,
	   0.00000000162,    -0.00000000186,
	  -0.00000000043,     0.00000000218,
	  -0.00000228921,    -0.00000127057,
	  -0.00000011125,     0.00000017371,
	   0.00000000699,     0.00000000446,
	  -0.00000185803,     0.00000330148,
	   0.00000025083,     0.00000016153,
	   0.00000000645,    -0.00000001007,
	  -0.00000206033,    -0.00000003499,
	  -0.00000000546,     0.00000000255,
	   0.00000000015,     0.00000000046,
	   0.00000005278,     0.00000201949,
	  -0.00000000358,    -0.00000000859,
	  -0.00000000066,     0.00000000033,
	  -0.00000000645,     0.00000001779,
	   0.00000000282,    -0.00000000036,
	   0.00000001030,    -0.00000001257,
	  -0.00000000048,    -0.00000000263,
	   0.00000019349,     0.00000000001,
	  -0.00000000105,    -0.00000044533,
	   0.00000000000,     0.00000001423,
	   0.00000000008,    -0.00000000172,
	  -0.00000000055,     0.00000002288,
	   0.00000000007,     0.00000000111,
	   0.00000000061,    -0.00000000247,
	   0.00000000087,     0.00000000199,
	  -0.00000225048,    -0.00000000010,
	   0.00000000062,    -0.00000000043,
	   0.00000000806,     0.00000314113,
	  -0.00000000088,    -0.00000000055,
	   0.00000003205,    -0.00000011133,
	   0.00000000107,     0.00000001392,
	  -0.00000000012,     0.00000000043,
	  -0.00000001479,    -0.00000018538,
	   0.00000000202,    -0.00000000891,
	   0.00000000011,     0.00000000062,
	   0.00000000311,     0.00000001894,
	   0.00000000099,    -0.00000000132,
	   0.00000000247,    -0.00000001528,
	  -0.00000000069,    -0.00000000119,
	  -0.00000000906,     0.00000000675,
	  -0.00000000048,    -0.00000000070,
	   0.00000000863,     0.00000001268,
	  -0.00000000092,     0.00000000054,
	   0.00000002994,    -0.00000000055,
	  -0.00000000020,     0.00000002943,
	  -0.00000000019,    -0.00000000075,
	   0.00000000069,     0.00000000004,
	   0.00000006985,    -0.00000005255,
	   0.00000000376,     0.00000000540,
	  -0.00000000025,     0.00000000020,
	  -0.00000006120,    -0.00000009057,
	   0.00000000638,    -0.00000000397,
	   0.00000000029,     0.00000000037,
	  -0.00000012153,     0.00000000372,
	  -0.00000000112,    -0.00000000049,
	   0.00000000412,    -0.00000011470,
	  -0.00000000058,     0.00000000133,
	   0.00000000109,     0.00000000599,
	   0.00000000076,    -0.00000000015,
	  -0.00000000567,    -0.00000000001,
	   0.00000000014,     0.00000000076,
	  -0.00000000079,    -0.00000000061,
	  -0.00000000195,     0.00000000086,
	  -0.00000000086,    -0.00000000198,
	  -0.00000000075,    -0.00000000088,
	   0.00000000089,    -0.00000000071,
	  -0.00000000449,    -0.00000000074,
	  -0.00000000009,    -0.00000000048,
	   0.00000000697,     0.00000000273,
	  -0.00000000073,     0.00000000284,
	   0.00000001040,    -0.00000000692,
	   0.00000000052,     0.00000000094,
	   0.00000000730,     0.00000001044,
	  -0.00000000086,     0.00000000086,
	   0.00000000576,     0.00000000673,
	   0.00000000067,    -0.00000000058,
	  -0.00000000677,     0.00000000541,
	   0.00000000061,     0.00000000066,
	   0.00000000032,    -0.00000000027,
	  -0.00000000026,    -0.00000000031,
	   0.00000000080,    -0.00000000068,
	  -0.00000000106,    -0.00000000137,
	   0.00000000269,    -0.00000000158,
	  -0.00000000153,    -0.00000000264,
	   0.00000000799,    -0.00000000468,
	   0.00000000024,    -0.00000000149,
	  -0.00000000009,    -0.00000000007,
	  -0.00000000717,    -0.00000001320,
	  -0.00000000243,    -0.00000000045,
	   0.00000001909,    -0.00000000707,
	   0.00000000071,    -0.00000000212,
	  -0.00000000668,    -0.00000001843,
	  -0.00000000195,    -0.00000000069,
	   0.00000006730,    -0.00000002484,
	   0.00000000253,    -0.00000000731,
	  -0.00000000033,    -0.00000000031,
	  -0.00000003750,    -0.00000010856,
	  -0.00000001176,    -0.00000000426,
	  -0.00000000051,     0.00000000054,
	   0.00000010315,    -0.00000001879,
	   0.00000000276,    -0.00000000535,
	  -0.00000001558,    -0.00000009585,
	  -0.00000000405,    -0.00000000243,
	  -0.00000000016,    -0.00000000047,
	   0.00000044229,    -0.00000007737,
	   0.00000001169,    -0.00000002093,
	  -0.00000000068,    -0.00000000075,
	  -0.00000011612,    -0.00000069884,
	  -0.00000003339,    -0.00000001877,
	  -0.00000000119,     0.00000000109,
	   0.00000034285,    -0.00000000482,
	   0.00000000099,    -0.00000000389,
	   0.00000001638,    -0.00000026948,
	   0.00000000404,     0.00000000222,
	  -0.00000000045,    -0.00000000134,
	   0.00000000124,    -0.00000000045,
	   0.00000000015,     0.00000000092,
	  -0.00000000214,    -0.00000000003,
	  -0.00000000004,     0.00000000211,
	   0.00000178050,     0.00000002908,
	  -0.00000000206,     0.00000000038,
	   0.00000000003,    -0.00000000028,
	   0.00000003135,    -0.00000277278,
	   0.00000000031,     0.00000000281,
	   0.00000028257,    -0.00000002534,
	   0.00000000699,    -0.00000001705,
	  -0.00000000041,    -0.00000000060,
	   0.00000006458,     0.00000033643,
	   0.00000001317,     0.00000001045,
	   0.00000000045,    -0.00000000056,
	  -0.00000000087,    -0.00000000559,
	   0.00000000035,     0.00000000017,
	   0.00000000508,    -0.00000000096,
	  -0.00000000016,     0.00000000039,
	   0.00000000027,     0.00000000029,
	  -0.00000001258,    -0.00000000021,
	  -0.00000000004,     0.00000000345,
	  -0.00000000216,    -0.00000000064,
	   0.00000000089,    -0.00000000049,
	  -0.00000000017,    -0.00000000031,
	  -0.00000000075,    -0.00000000143,
	  -0.00000000050,     0.00000000026,
	   0.00000000140,    -0.00000000047,
	  -0.00000000017,    -0.00000000045,
	  -0.00000000041,    -0.00000000130,
	  -0.00000000041,     0.00000000015,
	  -0.00000000056,    -0.00000000007,
	  -0.00000000012,     0.00000000088,
	  -0.00000000053,    -0.00000000005,
	   0.00000000008,    -0.00000000044,
	  -0.00000012077,     0.00000015362,
	  -0.00000001063,    -0.00000001041,
	   0.00000000041,    -0.00000000045,
	   0.00000016235,     0.00000016805,
	  -0.00000001381,     0.00000001148,
	  -0.00000000053,    -0.00000000047,
	   0.00000178132,    -0.00000000321,
	   0.00000000056,     0.00000178133,
	  -0.00000000003,    -0.00000000075,
	   0.00000000039,    -0.00000000054,
	   0.00000000053,     0.00000000039,
	  -0.00000000143,    -0.00000000050,
	  -0.00000000049,     0.00000000063,
	   0.00000000058,     0.00000000030,
	   0.00000000003,     0.00000000072,
	   0.00000000072,    -0.00000000004,
	   0.00000000046,    -0.00000000045,
	   0.00000000029,     0.00000000048,
	   0.00000000059,    -0.00000000036,
	   0.00000000480,    -0.00000000159,
	  -0.00000000057,    -0.00000000155,
	  -0.00000000244,    -0.00000000759,
	  -0.00000000246,     0.00000000088,
	   0.00000000379,    -0.00000000057,
	  -0.00000000031,    -0.00000000110,
	  -0.00000000022,    -0.00000000301,
	  -0.00000000088,     0.00000000018,
	  -0.00000000158,    -0.00000000023,
	  -0.00000000030,     0.00000000248,
	   0.00000000048,     0.00000000002,
	   0.00000000002,    -0.00000000075,
	   0.00000000184,    -0.00000000373,
	   0.00000000039,     0.00000000031,
	  -0.00000000409,    -0.00000000196,
	   0.00000000044,    -0.00000000039,
	  -0.00000004060,    -0.00000001250,
	  -0.00000000089,    -0.00000000181,
	   0.00000001251,    -0.00000004062,
	   0.00000000181,    -0.00000000088,
	   0.00000000095,    -0.00000000502,
	  -0.00000000037,     0.00000000015,
	   0.00000000502,     0.00000000095,
	  -0.00000000015,    -0.00000000037,
	  -0.00000002092,    -0.00000001014,
	   0.00000000188,    -0.00000000386,
	  -0.00000000043,    -0.00000000042,
	   0.00000001509,    -0.00000000182,
	  -0.00000000111,    -0.00000000431,
	  -0.00000000298,    -0.00000002344,
	  -0.00000000673,     0.00000000173,
	   0.00000000226,    -0.00000000042,
	  -0.00000000019,    -0.00000000077,
	   0.00000000111,     0.00000000280,
	   0.00000000087,    -0.00000000036,
	  -0.00000000024,    -0.00000000035,
	  -0.00000000054,     0.00000000037,
	  -0.00000000078,    -0.00000000009,
	  -0.00000000010,     0.00000000121,
	  -0.00000000093,    -0.00000000018,
	   0.00000000019,    -0.00000000091,
	  -0.00000000290,     0.00000000173,
	   0.00000000067,     0.00000000051,
	   0.00000000222,     0.00000000436,
	   0.00000000080,    -0.00000000092,
	   0.00000001001,    -0.00000000279,
	  -0.00000000079,    -0.00000000287,
	  -0.00000000013,     0.00000001014,
	   0.00000000302,    -0.00000000058,
	  -0.00000000061,    -0.00000001225,
	  -0.00000000119,     0.00000000083,
	  -0.00000001853,     0.00000000093,
	   0.00000000124,     0.00000000178,
	   0.00000000212,     0.00000000032,
	   0.00000000029,     0.00000000037,
	  -0.00000000025,    -0.00000000619,
	  -0.00000000038,     0.00000000029,
	   0.00000004565,     0.00000000028,
	   0.00000000031,    -0.00000006877,
	  -0.00000000089,    -0.00000001530,
	  -0.00000000150,     0.00000000105,
	   0.00000001589,    -0.00000000063,
	  -0.00000000105,    -0.00000000150,
	  -0.00000000174,     0.00000000570,
	  -0.00000000018,    -0.00000000014,
	   0.00000000524,     0.00000000186,
	   0.00000008297,    -0.00000000002,
	   0.00000000000,     0.00000008300,
	  -0.00000000137,    -0.00000000065,
	  -0.00000000065,     0.00000000132,
	   0.00000000013,    -0.00000000234,
	   0.00000000234,     0.00000000013,
	  -0.00000005125,    -0.00000002487,
	   0.00000000533,    -0.00000000445,
	   0.00000000256,    -0.00000000527,
	   0.00000000046,     0.00000000055,
	  -0.00000000003,    -0.00000000061,
	   0.00000000154,     0.00000000000,
	   0.00000000000,     0.00000000154,
	  -0.00000000189,    -0.00000000092,
	  -0.00000000091,     0.00000000189,
	  -0.00000014515,    -0.00000007040,
	   0.00000001513,    -0.00000001260,
	   0.00000000364,    -0.00000000751,
	   0.00000000065,     0.00000000078,
	  -0.00000028474,    -0.00000013818,
	   0.00000002964,    -0.00000002468,
	   0.00000000457,    -0.00000000942,
	   0.00000000082,     0.00000000098,
	  -0.00000000136,    -0.00000000017,
	   0.00000000002,    -0.00000000008,
	  -0.00000000297,    -0.00000000163,
	   0.00000000006,    -0.00000000017,
	   0.00000000166,    -0.00000000295,
	   0.00000000017,     0.00000000006,
	  -0.00000000044,    -0.00000000005,
	   0.00000000002,    -0.00000000050,
	  -0.00000000024,    -0.00000000028,
	   0.00000000040,     0.00000000087,
	  -0.00000000086,     0.00000000038,
	  -0.00000000023,    -0.00000000040,
	   0.00000000041,    -0.00000000024,
	  -0.00000000015,    -0.00000000078,
	   0.00000000078,    -0.00000000015,
	  -0.00000000042,    -0.00000000018,
	  -0.00000000018,     0.00000000042,
	  -0.00000000108,    -0.00000000046,
	  -0.00000000033,     0.00000000062,
	   0.00000000017,     0.00000000011,
	  -0.00000000246,     0.00000000024,
	   0.00000000001,     0.00000000126,
	   0.00000000025,     0.00000000246,
	   0.00000000125,    -0.00000000002,
	   0.00000000107,    -0.00000000073,
	  -0.00000000027,    -0.00000000046,
	  -0.00000000074,    -0.00000000106,
	  -0.00000000046,     0.00000000027,
	  -0.00000000687,     0.00000000068,
	   0.00000000005,     0.00000000347,
	   0.00000000083,     0.00000000004,
	   0.00000000001,     0.00000000109,
	   0.00000000062,     0.00000000006,
	  -0.00000001124,     0.00000000768,
	   0.00000000279,     0.00000000490,
	   0.00000000100,    -0.00000000050,
	   0.00000000775,     0.00000001117,
	   0.00000000486,    -0.00000000283,
	  -0.00000000051,    -0.00000000099,
	   0.00000000027,     0.00000000062,
	   0.00000000057,    -0.00000000031,
	   0.00000000142,    -0.00000000098,
	  -0.00000000035,    -0.00000000061,
	  -0.00000000013,     0.00000000006,
	   0.00000000053,     0.00000000060,
	   0.00000000344,    -0.00000000686,
	  -0.00000000214,    -0.00000000128,
	  -0.00000000022,     0.00000000033,
	  -0.00000000688,    -0.00000000339,
	  -0.00000000126,     0.00000000215,
	   0.00000000033,     0.00000000021,
	  -0.00000000030,    -0.00000000025,
	  -0.00000003710,     0.00000002554,
	   0.00000000928,     0.00000001607,
	   0.00000000328,    -0.00000000166,
	  -0.00000000270,    -0.00000000263,
	  -0.00000000090,     0.00000000092,
	  -0.00000003669,     0.00000007292,
	   0.00000002278,     0.00000001374,
	   0.00000000234,    -0.00000000348,
	   0.00000007306,     0.00000003589,
	   0.00000001336,    -0.00000002286,
	  -0.00000000350,    -0.00000000225,
	   0.00000000240,     0.00000000186,
	   0.00000000035,    -0.00000000037,
	   0.00000000147,    -0.00000000245,
	  -0.00000000040,    -0.00000000022,
	   0.00000000946,    -0.00000001905,
	  -0.00000000594,    -0.00000000352,
	  -0.00000000060,     0.00000000091,
	   0.00000008662,     0.00000004182,
	   0.00000001552,    -0.00000002679,
	  -0.00000000410,    -0.00000000265,
	  -0.00000000310,    -0.00000007440,
	  -0.00000001789,    -0.00000000053,
	  -0.00000000016,     0.00000000211,
	  -0.00000007415,     0.00000000393,
	  -0.00000000024,     0.00000001782,
	   0.00000000209,     0.00000000010,
	  -0.00000000269,    -0.00000000057,
	   0.00000000009,     0.00000000244,
	  -0.00000021996,     0.00000044298,
	   0.00000013861,     0.00000008227,
	   0.00000001394,    -0.00000002110,
	  -0.00000064376,    -0.00000031064,
	  -0.00000011557,     0.00000020005,
	   0.00000003049,     0.00000001971,
	   0.00000003244,     0.00000079985,
	   0.00000019359,     0.00000000641,
	   0.00000000180,    -0.00000002272,
	   0.00000079552,    -0.00000004270,
	   0.00000000219,    -0.00000019207,
	  -0.00000002244,    -0.00000000095,
	   0.00000002112,     0.00000000357,
	   0.00000000051,    -0.00000000212,
	  -0.00000000017,    -0.00000001962,
	  -0.00000000183,     0.00000000039,
	   0.00000000330,     0.00000006937,
	   0.00000001673,     0.00000000038,
	   0.00000000013,    -0.00000000196,
	   0.00000046719,    -0.00000001938,
	   0.00000000313,    -0.00000011296,
	  -0.00000001323,    -0.00000000090,
	   0.00000009290,     0.00000015257,
	   0.00000002523,    -0.00000001298,
	  -0.00000000094,    -0.00000000205,
	   0.00000014969,    -0.00000009523,
	  -0.00000001368,    -0.00000002441,
	  -0.00000000191,     0.00000000105,
	   0.00000000443,    -0.00000000108,
	  -0.00000000234,    -0.00000000288,
	  -0.00000006728,    -0.00000141255,
	  -0.00000034093,    -0.00000000786,
	  -0.00000000255,     0.00000003993,
	  -0.00000359641,     0.00000015035,
	  -0.00000002477,     0.00000087020,
	   0.00000010177,     0.00000000691,
	   0.00000000090,    -0.00000000800,
	  -0.00000101037,    -0.00000166226,
	  -0.00000027680,     0.00000014157,
	   0.00000001022,     0.00000002239,
	  -0.00000162822,     0.00000103431,
	   0.00000014978,     0.00000026619,
	   0.00000002075,    -0.00000001156,
	  -0.00000003399,     0.00000001122,
	   0.00000000074,     0.00000000189,
	   0.00000000040,    -0.00000000024,
	   0.00000001793,     0.00000002551,
	   0.00000000063,    -0.00000000185,
	  -0.00000000033,    -0.00000000027,
	   0.00000003870,     0.00000006226,
	   0.00000001026,    -0.00000000549,
	  -0.00000000041,    -0.00000000082,
	   0.00000019638,    -0.00000011974,
	  -0.00000001696,    -0.00000003236,
	  -0.00000000257,     0.00000000127,
	   0.00000010587,     0.00000006145,
	   0.00000000567,    -0.00000000795,
	  -0.00000000031,    -0.00000000027,
	   0.00000005592,    -0.00000010640,
	  -0.00000000811,    -0.00000000441,
	   0.00000000174,    -0.00000000120,
	  -0.00000000149,     0.00000000008,
	  -0.00000067305,    -0.00000108489,
	  -0.00000017943,     0.00000009564,
	   0.00000000711,     0.00000001429,
	  -0.00000149411,     0.00000090908,
	   0.00000012960,     0.00000024702,
	   0.00000001959,    -0.00000000964,
	  -0.00000117272,    -0.00000067281,
	  -0.00000006220,     0.00000008867,
	   0.00000000351,     0.00000000292,
	  -0.00000062017,     0.00000117572,
	   0.00000008997,     0.00000004965,
	   0.00000000144,    -0.00000000370,
	  -0.00000001183,     0.00000001185,
	   0.00000000096,     0.00000000044,
	   0.00000001320,     0.00000000247,
	  -0.00000000034,    -0.00000000107,
	   0.00000009225,     0.00000005122,
	   0.00000000445,    -0.00000000697,
	  -0.00000000028,    -0.00000000018,
	   0.00000012141,    -0.00000021620,
	  -0.00000001636,    -0.00000001048,
	  -0.00000000042,     0.00000000066,
	   0.00000008428,     0.00000000571,
	   0.00000000081,    -0.00000000038,
	  -0.00000000582,    -0.00000007838,
	   0.00000000048,     0.00000000101,
	   0.00000000096,    -0.00000000102,
	  -0.00000000015,     0.00000000127,
	  -0.00000133883,    -0.00000073853,
	  -0.00000006486,     0.00000010171,
	   0.00000000409,     0.00000000257,
	  -0.00000089232,     0.00000159793,
	   0.00000012147,     0.00000007762,
	   0.00000000307,    -0.00000000487,
	  -0.00000094673,    -0.00000004187,
	  -0.00000000593,     0.00000000300,
	   0.00000000018,     0.00000000052,
	   0.00000004590,     0.00000090063,
	  -0.00000000380,    -0.00000000827,
	  -0.00000000062,     0.00000000034,
	  -0.00000000363,     0.00000001000,
	   0.00000000172,    -0.00000000013,
	   0.00000000551,    -0.00000000717,
	  -0.00000000036,    -0.00000000149,
	   0.00000010618,     0.00000000039,
	  -0.00000000008,    -0.00000021104,
	   0.00000000317,     0.00000001314,
	   0.00000000020,    -0.00000000161,
	  -0.00000000172,     0.00000002145,
	   0.00000000028,     0.00000000104,
	   0.00000000037,    -0.00000000139,
	   0.00000000056,     0.00000000108,
	  -0.00000123422,    -0.00000000386,
	   0.00000000071,    -0.00000000041,
	   0.00000000107,     0.00000149860,
	  -0.00000000072,    -0.00000000075,
	   0.00000001948,    -0.00000009989,
	   0.00000000070,     0.00000001250,
	  -0.00000001388,    -0.00000016561,
	   0.00000000122,    -0.00000000804,
	   0.00000000009,     0.00000000055,
	   0.00000000146,     0.00000001067,
	   0.00000000071,    -0.00000000062,
	   0.00000000071,    -0.00000000830,
	  -0.00000000045,    -0.00000000044,
	  -0.00000000950,     0.00000000689,
	  -0.00000000050,    -0.00000000073,
	   0.00000000979,     0.00000001440,
	  -0.00000000106,     0.00000000066,
	   0.00000002184,    -0.00000000041,
	  -0.00000000046,     0.00000002137,
	  -0.00000000011,    -0.00000000051,
	   0.00000000048,    -0.00000000003,
	   0.00000008294,    -0.00000005998,
	   0.00000000434,     0.00000000634,
	  -0.00000000029,     0.00000000023,
	  -0.00000007110,    -0.00000010493,
	   0.00000000763,    -0.00000000492,
	   0.00000000031,     0.00000000040,
	  -0.00000009496,     0.00000000431,
	  -0.00000000112,    -0.00000000039,
	   0.00000000469,    -0.00000009029,
	  -0.00000000045,     0.00000000126,
	   0.00000000051,     0.00000000413,
	   0.00000000065,    -0.00000000010,
	  -0.00000000413,     0.00000000054,
	   0.00000000012,     0.00000000065,
	   0.00000000014,    -0.00000000040,
	  -0.00000000062,    -0.00000000036,
	  -0.00000000201,     0.00000000156,
	  -0.00000000154,    -0.00000000203,
	  -0.00000000046,    -0.00000000054,
	   0.00000000054,    -0.00000000044,
	  -0.00000000079,     0.00000000234,
	  -0.00000000075,    -0.00000000020,
	   0.00000000473,     0.00000000276,
	  -0.00000000059,     0.00000000193,
	   0.00000000786,    -0.00000000590,
	   0.00000000046,     0.00000000069,
	   0.00000000580,     0.00000000803,
	  -0.00000000068,     0.00000000059,
	   0.00000000352,     0.00000000414,
	   0.00000000042,    -0.00000000036,
	  -0.00000000416,     0.00000000335,
	   0.00000000038,     0.00000000041,
	   0.00000000032,    -0.00000000021,
	   0.00000000021,     0.00000000035,
	   0.00000000073,     0.00000000036,
	  -0.00000000037,     0.00000000071,
	   0.00000000029,    -0.00000000025,
	  -0.00000000035,    -0.00000000044,
	   0.00000000072,    -0.00000000042,
	  -0.00000000040,    -0.00000000069,
	   0.00000000250,    -0.00000000146,
	   0.00000000007,    -0.00000000046,
	  -0.00000000203,    -0.00000000369,
	  -0.00000000068,    -0.00000000012,
	   0.00000000447,    -0.00000000167,
	   0.00000000013,    -0.00000000042,
	  -0.00000000146,    -0.00000000417,
	   0.00000001779,    -0.00000000650,
	   0.00000000067,    -0.00000000192,
	  -0.00000000009,    -0.00000000008,
	  -0.00000000897,    -0.00000002579,
	  -0.00000000279,    -0.00000000100,
	   0.00000002083,    -0.00000000390,
	   0.00000000056,    -0.00000000117,
	  -0.00000000246,    -0.00000001790,
	  -0.00000000064,    -0.00000000044,
	   0.00000009533,    -0.00000001592,
	   0.00000000250,    -0.00000000446,
	  -0.00000000015,    -0.00000000017,
	  -0.00000002210,    -0.00000013642,
	  -0.00000000645,    -0.00000000362,
	   0.00000006060,    -0.00000000199,
	   0.00000000034,    -0.00000000129,
	   0.00000000565,    -0.00000003626,
	   0.00000000133,     0.00000000067,
	   0.00000029554,     0.00000001012,
	  -0.00000000066,     0.00000000011,
	   0.00000001082,    -0.00000041926,
	   0.00000000009,     0.00000000083,
	   0.00000007369,    -0.00000000703,
	   0.00000000180,    -0.00000000426,
	   0.00000001662,     0.00000008567,
	   0.00000000337,     0.00000000259,
	  -0.00000000013,    -0.00000000094,
	   0.00000000086,    -0.00000000015,
	  -0.00000000020,    -0.00000000037,
	  -0.00000003069,     0.00000003670,
	  -0.00000000255,    -0.00000000260,
	   0.00000000011,    -0.00000000011,
	   0.00000003842,     0.00000003974,
	  -0.00000000324,     0.00000000274,
	   0.00000032224,     0.00000000658,
	  -0.00000000757,     0.00000032228,
	   0.00000000098,     0.00000000100,
	   0.00000000040,    -0.00000000037,
	  -0.00000000791,    -0.00000000850,
	   0.00000000072,    -0.00000000139,
	   0.00000000031,    -0.00000000055,
	  -0.00000000055,    -0.00000000029,
	   0.00000000129,    -0.00000000041,
	  -0.00000000015,    -0.00000000041,
	  -0.00000000058,    -0.00000000185,
	  -0.00000000059,     0.00000000021,
	   0.00000000076,    -0.00000000013,
	  -0.00000000003,     0.00000000067,
	  -0.00000000155,    -0.00000000301,
	   0.00000000048,    -0.00000000009,
	  -0.00000000281,     0.00000000079,
	  -0.00000002471,     0.00000003894,
	  -0.00000000248,    -0.00000000231,
	  -0.00000003892,    -0.00000002474,
	   0.00000000233,    -0.00000000248,
	   0.00000000017,    -0.00000000085,
	   0.00000000085,     0.00000000017,
	   0.00000000067,     0.00000000097,
	   0.00000000040,    -0.00000000027,
	   0.00000000034,     0.00000000028,
	   0.00000000028,    -0.00000000035,
	   0.00000000029,    -0.00000000053,
	   0.00000000033,     0.00000000067,
	   0.00000000059,    -0.00000000025,
	   0.00000000332,    -0.00000000032,
	  -0.00000000022,    -0.00000000097,
	  -0.00000000050,    -0.00000000469,
	  -0.00000000136,     0.00000000032,
	   0.00000000072,    -0.00000000015,
	   0.00000000033,     0.00000000086,
	   0.00000000048,    -0.00000000092,
	   0.00000000093,     0.00000000048,
	  -0.00000000029,    -0.00000000038,
	   0.00000000032,    -0.00000000022,
	  -0.00000000023,    -0.00000000031,
	   0.00000000055,     0.00000000022,
	   0.00000000022,    -0.00000000057,
	   0.00000000097,     0.00000000036,
	   0.00000000029,    -0.00000000108,
	   0.00000000039,     0.00000000103,
	   0.00000000109,    -0.00000000039,
	   0.00000000081,     0.00000000201,
	   0.00000000192,    -0.00000000074,
	  -0.00000000028,     0.00000000049,
	   0.00000000054,     0.00000000035,
	   0.00000000270,    -0.00000000036,
	  -0.00000000019,    -0.00000000079,
	   0.00000000035,     0.00000000270,
	   0.00000000079,    -0.00000000019,
	  -0.00000000006,    -0.00000000145,
	  -0.00000000200,     0.00000000008,
	  -0.00000000025,    -0.00000000084,
	   0.00000000424,     0.00000000005,
	   0.00000000006,    -0.00000000580,
	  -0.00000000011,    -0.00000000218,
	   0.00000000227,    -0.00000000008,
	  -0.00000000024,     0.00000000075,
	   0.00000000069,     0.00000000025,
	   0.00000000848,     0.00000000007,
	  -0.00000000007,     0.00000000848,
	  -0.00000000044,     0.00000000156,
	  -0.00000000156,    -0.00000000044,
	   0.00000000005,     0.00000000016,
	  -0.00000000004,     0.00000000042,
	  -0.00000000042,    -0.00000000005,
	   0.00000000002,     0.00000000006,
	  -0.00000000006,     0.00000000002,
	  -0.00000000026,     0.00000000017,
	  -0.00000000084,    -0.00000000036,
	  -0.00000000026,     0.00000000047,
	  -0.00000000035,     0.00000000084,
	   0.00000000048,     0.00000000025,
	   0.00000000046,    -0.00000000004,
	  -0.00000000005,    -0.00000000046,
	  -0.00000000234,    -0.00000000100,
	  -0.00000000071,     0.00000000132,
	   0.00000000036,     0.00000000022,
	  -0.00000000018,     0.00000000034,
	  -0.00000000486,     0.00000000046,
	   0.00000000003,     0.00000000244,
	   0.00000000058,     0.00000000003,
	   0.00000000051,     0.00000000484,
	   0.00000000242,    -0.00000000006,
	   0.00000000002,    -0.00000000058,
	   0.00000000062,    -0.00000000006,
	  -0.00000000001,    -0.00000000031,
	   0.00000000220,    -0.00000000150,
	  -0.00000000054,    -0.00000000094,
	  -0.00000000152,    -0.00000000218,
	  -0.00000000093,     0.00000000055,
	  -0.00000001586,     0.00000000157,
	   0.00000000014,     0.00000000791,
	   0.00000000189,     0.00000000008,
	  -0.00000000034,    -0.00000000097,
	  -0.00000000038,     0.00000000015,
	  -0.00000002345,     0.00000001598,
	   0.00000000577,     0.00000001009,
	   0.00000000206,    -0.00000000103,
	   0.00000001619,     0.00000002316,
	   0.00000000993,    -0.00000000590,
	  -0.00000000107,    -0.00000000202,
	   0.00000000045,     0.00000000104,
	   0.00000000093,    -0.00000000053,
	   0.00000000536,    -0.00000000370,
	  -0.00000000134,    -0.00000000229,
	  -0.00000000047,     0.00000000024,
	   0.00000001285,     0.00000001805,
	   0.00000000766,    -0.00000000460,
	  -0.00000000083,    -0.00000000156,
	   0.00000001027,    -0.00000002037,
	  -0.00000000631,    -0.00000000379,
	  -0.00000000065,     0.00000000096,
	  -0.00000002042,    -0.00000000992,
	  -0.00000000363,     0.00000000634,
	   0.00000000097,     0.00000000061,
	  -0.00000000073,    -0.00000000062,
	  -0.00000000041,     0.00000000076,
	  -0.00000012461,     0.00000008608,
	   0.00000003120,     0.00000005344,
	   0.00000001089,    -0.00000000559,
	  -0.00000009400,    -0.00000013195,
	  -0.00000005596,     0.00000003385,
	   0.00000000608,     0.00000001143,
	  -0.00000011057,     0.00000021925,
	   0.00000006820,     0.00000004108,
	   0.00000000704,    -0.00000001040,
	   0.00000021954,     0.00000010645,
	   0.00000003917,    -0.00000006847,
	  -0.00000001048,    -0.00000000657,
	   0.00000000586,     0.00000000461,
	   0.00000000089,    -0.00000000096,
	   0.00000000341,    -0.00000000601,
	  -0.00000000104,    -0.00000000051,
	  -0.00000001518,     0.00000003071,
	   0.00000000953,     0.00000000560,
	   0.00000000095,    -0.00000000146,
	   0.00000025350,     0.00000012688,
	   0.00000004681,    -0.00000007882,
	  -0.00000001205,    -0.00000000796,
	   0.00000000355,     0.00000009422,
	   0.00000002260,     0.00000000081,
	   0.00000000023,    -0.00000000267,
	   0.00000009328,    -0.00000000564,
	   0.00000000000,    -0.00000002228,
	  -0.00000000261,    -0.00000000007,
	   0.00000000287,     0.00000000069,
	  -0.00000000024,    -0.00000000250,
	   0.00000031743,    -0.00000064239,
	  -0.00000019985,    -0.00000011750,
	  -0.00000001995,     0.00000003048,
	  -0.00000195554,    -0.00000097812,
	  -0.00000036239,     0.00000060972,
	   0.00000009299,     0.00000006141,
	   0.00000000680,    -0.00000000940,
	  -0.00000003927,    -0.00000102446,
	  -0.00000024709,    -0.00000000897,
	  -0.00000000253,     0.00000002913,
	  -0.00000101354,     0.00000006070,
	  -0.00000000010,     0.00000024318,
	   0.00000002842,     0.00000000073,
	  -0.00000002270,    -0.00000000400,
	  -0.00000000058,     0.00000000263,
	   0.00000000098,     0.00000002065,
	   0.00000000221,    -0.00000000063,
	  -0.00000000034,    -0.00000000165,
	   0.00000000031,    -0.00000000026,
	  -0.00000000005,    -0.00000000054,
	   0.00000000043,     0.00000000361,
	   0.00000000165,    -0.00000000004,
	  -0.00000000037,     0.00000000024,
	   0.00000000025,     0.00000000036,
	   0.00000000014,    -0.00000000062,
	   0.00000000152,     0.00000003109,
	   0.00000000744,     0.00000000015,
	   0.00000000005,    -0.00000000088,
	   0.00000010168,    -0.00000000398,
	   0.00000000069,    -0.00000002443,
	  -0.00000000287,    -0.00000000019,
	   0.00000003228,     0.00000005408,
	   0.00000000900,    -0.00000000444,
	  -0.00000000031,    -0.00000000074,
	   0.00000005186,    -0.00000003377,
	  -0.00000000493,    -0.00000000833,
	  -0.00000000064,     0.00000000039,
	   0.00000000140,    -0.00000000028,
	  -0.00000000078,    -0.00000000077,
	  -0.00000002835,    -0.00000057815,
	  -0.00000013896,    -0.00000000275,
	  -0.00000000098,     0.00000001631,
	  -0.00000078555,     0.00000003107,
	  -0.00000000533,     0.00000018921,
	   0.00000002219,     0.00000000148,
	  -0.00000035717,    -0.00000059406,
	  -0.00000009914,     0.00000004954,
	   0.00000000351,     0.00000000813,
	  -0.00000057288,     0.00000037047,
	   0.00000005418,     0.00000009256,
	   0.00000000712,    -0.00000000428,
	  -0.00000001071,     0.00000000342,
	   0.00000000034,     0.00000000084,
	   0.00000000598,     0.00000000740,
	   0.00000000032,    -0.00000000078,
	   0.00000002547,     0.00000004092,
	   0.00000000671,    -0.00000000360,
	  -0.00000000027,    -0.00000000054,
	   0.00000009854,    -0.00000006016,
	  -0.00000000853,    -0.00000001618,
	  -0.00000000129,     0.00000000064,
	   0.00000005416,     0.00000003294,
	   0.00000000323,    -0.00000000405,
	   0.00000002721,    -0.00000005439,
	  -0.00000000416,    -0.00000000189,
	   0.00000000093,    -0.00000000055,
	  -0.00000000072,     0.00000000020,
	  -0.00000041454,    -0.00000066604,
	  -0.00000010969,     0.00000005877,
	   0.00000000438,     0.00000000874,
	  -0.00000074897,     0.00000045744,
	   0.00000006511,     0.00000012322,
	   0.00000000979,    -0.00000000486,
	  -0.00000060726,    -0.00000035981,
	  -0.00000003430,     0.00000004581,
	   0.00000000179,     0.00000000176,
	  -0.00000031316,     0.00000060839,
	   0.00000004665,     0.00000002314,
	   0.00000000044,    -0.00000000193,
	  -0.00000000611,     0.00000000597,
	   0.00000000072,     0.00000000040,
	   0.00000000670,     0.00000000051,
	  -0.00000000013,    -0.00000000077,
	   0.00000005946,     0.00000003312,
	   0.00000000285,    -0.00000000449,
	  -0.00000000018,    -0.00000000011,
	   0.00000006713,    -0.00000011954,
	  -0.00000000904,    -0.00000000576,
	  -0.00000000023,     0.00000000036,
	   0.00000004265,     0.00000000578,
	   0.00000000082,    -0.00000000040,
	  -0.00000000542,    -0.00000003649,
	   0.00000000048,     0.00000000097,
	   0.00000000061,    -0.00000000062,
	  -0.00000000004,     0.00000000079,
	  -0.00000082976,    -0.00000046212,
	  -0.00000003992,     0.00000006287,
	   0.00000000253,     0.00000000156,
	  -0.00000049690,     0.00000088469,
	   0.00000006711,     0.00000004263,
	   0.00000000166,    -0.00000000268,
	  -0.00000047647,    -0.00000003967,
	  -0.00000000538,     0.00000000279,
	   0.00000000017,     0.00000000048,
	   0.00000003729,     0.00000043343,
	  -0.00000000342,    -0.00000000712,
	  -0.00000000052,     0.00000000030,
	  -0.00000000228,     0.00000000612,
	   0.00000000112,    -0.00000000002,
	   0.00000000315,    -0.00000000445,
	  -0.00000000029,    -0.00000000088,
	   0.00000005860,     0.00000000056,
	   0.00000000037,    -0.00000010543,
	   0.00000000365,     0.00000001043,
	   0.00000000020,    -0.00000000129,
	  -0.00000000182,     0.00000001715,
	   0.00000000030,     0.00000000083,
	   0.00000000023,    -0.00000000082,
	   0.00000000037,     0.00000000061,
	  -0.00000068168,    -0.00000000650,
	   0.00000000068,    -0.00000000038,
	  -0.00000000281,     0.00000075190,
	  -0.00000000058,    -0.00000000071,
	   0.00000001156,    -0.00000007924,
	   0.00000000043,     0.00000000978,
	  -0.00000000999,    -0.00000012966,
	   0.00000000074,    -0.00000000627,
	   0.00000000007,     0.00000000043,
	   0.00000000061,     0.00000000630,
	   0.00000000052,    -0.00000000028,
	  -0.00000000009,    -0.00000000468,
	  -0.00000000817,     0.00000000583,
	  -0.00000000042,    -0.00000000062,
	   0.00000000830,     0.00000001223,
	  -0.00000000091,     0.00000000057,
	   0.00000001425,    -0.00000000040,
	  -0.00000000056,     0.00000001380,
	   0.00000007597,    -0.00000005423,
	   0.00000000391,     0.00000000579,
	  -0.00000000027,     0.00000000021,
	  -0.00000006087,    -0.00000008979,
	   0.00000000657,    -0.00000000425,
	   0.00000000027,     0.00000000034,
	  -0.00000006467,     0.00000000435,
	  -0.00000000106,    -0.00000000038,
	   0.00000000532,    -0.00000006014,
	  -0.00000000041,     0.00000000117,
	   0.00000000022,     0.00000000283,
	   0.00000000050,    -0.00000000007,
	  -0.00000000293,     0.00000000063,
	   0.00000000009,     0.00000000051,
	   0.00000000016,    -0.00000000052,
	  -0.00000000068,    -0.00000000031,
	  -0.00000000183,     0.00000000142,
	  -0.00000000137,    -0.00000000185,
	  -0.00000000028,    -0.00000000033,
	   0.00000000033,    -0.00000000027,
	  -0.00000000111,     0.00000000361,
	  -0.00000000092,    -0.00000000025,
	   0.00000000515,     0.00000000239,
	  -0.00000000049,     0.00000000162,
	   0.00000000691,    -0.00000000537,
	   0.00000000044,     0.00000000058,
	   0.00000000507,     0.00000000708,
	  -0.00000000060,     0.00000000045,
	   0.00000000213,     0.00000000252,
	  -0.00000000254,     0.00000000204,
	   0.00000000023,     0.00000000026,
	   0.00000000072,    -0.00000000042,
	  -0.00000000055,    -0.00000000099,
	   0.00000000104,    -0.00000000039,
	  -0.00000000031,    -0.00000000093,
	   0.00000000444,    -0.00000000159,
	   0.00000000017,    -0.00000000048,
	  -0.00000000208,    -0.00000000602,
	  -0.00000000065,    -0.00000000023,
	   0.00000000431,    -0.00000000083,
	  -0.00000000033,    -0.00000000332,
	   0.00000002004,    -0.00000000312,
	   0.00000000052,    -0.00000000092,
	  -0.00000000414,    -0.00000002691,
	  -0.00000000126,    -0.00000000070,
	   0.00000001145,    -0.00000000061,
	   0.00000000163,    -0.00000000451,
	   0.00000005029,     0.00000000296,
	   0.00000000313,    -0.00000006715,
	   0.00000001721,    -0.00000000161,
	   0.00000000042,    -0.00000000097,
	   0.00000000376,     0.00000001979,
	   0.00000000077,     0.00000000059,
	  -0.00000000711,     0.00000000813,
	  -0.00000000057,    -0.00000000060,
	   0.00000000845,     0.00000000877,
	  -0.00000000066,     0.00000000057,
	   0.00000005746,     0.00000000232,
	  -0.00000000262,     0.00000005747,
	  -0.00000000039,    -0.00000000096,
	  -0.00000000091,     0.00000000020,
	  -0.00000000655,     0.00000000926,
	  -0.00000000058,    -0.00000000056,
	  -0.00000000925,    -0.00000000656,
	   0.00000000056,    -0.00000000058,
	  -0.00000000055,    -0.00000000083,
	   0.00000000083,    -0.00000000055,
	   0.00000000001,    -0.00000000053,
	  -0.00000000012,    -0.00000000040,
	   0.00000000071,    -0.00000000007,
	  -0.00000000010,    -0.00000000086,
	   0.00000000059,    -0.00000000007,
	   0.00000000007,     0.00000000059,
	   0.00000000085,     0.00000000001,
	  -0.00000000001,     0.00000000085,
	   0.00000000005,    -0.00000000002,
	   0.00000000001,     0.00000000005,
	  -0.00000000057,    -0.00000000073,
	  -0.00000000053,     0.00000000034,
	   0.00000000010,     0.00000000018,
	  -0.00000000160,    -0.00000000070,
	  -0.00000000048,     0.00000000090,
	  -0.00000000068,     0.00000000160,
	   0.00000000090,     0.00000000047,
	   0.00000000092,    -0.00000000008,
	  -0.00000000010,    -0.00000000092,
	  -0.00000000516,    -0.00000000222,
	  -0.00000000153,     0.00000000288,
	   0.00000000078,     0.00000000048,
	  -0.00000000985,     0.00000000091,
	   0.00000000006,     0.00000000488,
	   0.00000000117,     0.00000000006,
	   0.00000000104,     0.00000000978,
	   0.00000000484,    -0.00000000015,
	   0.00000000003,    -0.00000000116,
	   0.00000000205,    -0.00000000020,
	  -0.00000000002,    -0.00000000101,
	  -0.00000000024,    -0.00000000001,
	   0.00000000064,     0.00000000544,
	   0.00000000265,    -0.00000000010,
	   0.00000000001,    -0.00000000063,
	   0.00000000597,    -0.00000000405,
	  -0.00000000146,    -0.00000000254,
	  -0.00000000052,     0.00000000026,
	  -0.00000000413,    -0.00000000586,
	  -0.00000000248,     0.00000000150,
	   0.00000000027,     0.00000000050,
	  -0.00000004767,     0.00000000474,
	   0.00000000055,     0.00000002351,
	   0.00000000562,     0.00000000021,
	  -0.00000000460,    -0.00000003901,
	  -0.00000001904,     0.00000000080,
	  -0.00000000008,     0.00000000454,
	  -0.00000006433,     0.00000004371,
	   0.00000001570,     0.00000002745,
	   0.00000000562,    -0.00000000280,
	   0.00000004448,     0.00000006309,
	   0.00000002677,    -0.00000001619,
	  -0.00000000295,    -0.00000000543,
	   0.00000000101,     0.00000000238,
	   0.00000000062,    -0.00000000021,
	   0.00000000208,    -0.00000000123,
	  -0.00000000031,    -0.00000000050,
	  -0.00000001509,     0.00000001046,
	   0.00000000377,     0.00000000642,
	   0.00000000131,    -0.00000000068,
	   0.00000011611,     0.00000016894,
	   0.00000007195,    -0.00000004199,
	  -0.00000000754,    -0.00000001466,
	  -0.00000002397,     0.00000004715,
	   0.00000001454,     0.00000000881,
	   0.00000000152,    -0.00000000222,
	   0.00000004723,     0.00000002257,
	   0.00000000817,    -0.00000001461,
	  -0.00000000224,    -0.00000000137,
	   0.00000000143,     0.00000000126,
	   0.00000000073,    -0.00000000150,
	   0.00000032172,    -0.00000022288,
	  -0.00000008064,    -0.00000013715,
	  -0.00000002789,     0.00000001446,
	  -0.00000089512,    -0.00000130224,
	  -0.00000055609,     0.00000032425,
	   0.00000005816,     0.00000011310,
	   0.00000001530,    -0.00000000690,
	   0.00000025945,    -0.00000051196,
	  -0.00000015869,    -0.00000009601,
	  -0.00000001654,     0.00000002421,
	  -0.00000051231,    -0.00000024523,
	  -0.00000008924,     0.00000015929,
	   0.00000002443,     0.00000001489,
	  -0.00000001161,    -0.00000000925,
	  -0.00000000186,     0.00000000205,
	   0.00000000029,     0.00000000023,
	  -0.00000000636,     0.00000001195,
	   0.00000000222,     0.00000000094,
	   0.00000000065,    -0.00000000124,
	  -0.00000000079,    -0.00000000039,
	  -0.00000000417,     0.00000001048,
	   0.00000000589,     0.00000000296,
	   0.00000000056,    -0.00000000004,
	  -0.00000000005,    -0.00000000055,
	   0.00000000069,    -0.00000000089,
	  -0.00000000038,    -0.00000000028,
	   0.00000000142,    -0.00000000327,
	  -0.00000000580,     0.00000001176,
	   0.00000000363,     0.00000000212,
	   0.00000000036,    -0.00000000056,
	   0.00000004018,     0.00000002030,
	   0.00000000743,    -0.00000001246,
	  -0.00000000191,    -0.00000000126,
	   0.00000000093,     0.00000002966,
	   0.00000000711,     0.00000000032,
	   0.00000000009,    -0.00000000084,
	   0.00000002910,    -0.00000000201,
	  -0.00000000011,    -0.00000000691,
	  -0.00000000081,     0.00000000000,
	   0.00000000079,     0.00000000021,
	  -0.00000000011,    -0.00000000066,
	   0.00000011235,    -0.00000022799,
	  -0.00000007057,    -0.00000004114,
	  -0.00000000700,     0.00000001078,
	  -0.00000031338,    -0.00000015822,
	  -0.00000005796,     0.00000009734,
	   0.00000001487,     0.00000000982,
	  -0.00000001122,    -0.00000032529,
	  -0.00000007828,    -0.00000000324,
	  -0.00000000090,     0.00000000926,
	  -0.00000031981,     0.00000002110,
	   0.00000000088,     0.00000007630,
	   0.00000000891,     0.00000000007,
	  -0.00000000631,    -0.00000000116,
	  -0.00000000017,     0.00000000083,
	   0.00000000051,     0.00000000560,
	   0.00000000068,    -0.00000000024,
	   0.00000000103,     0.00000002073,
	   0.00000000495,     0.00000000009,
	   0.00000000003,    -0.00000000058,
	   0.00000005069,    -0.00000000198,
	   0.00000000033,    -0.00000001214,
	  -0.00000000143,    -0.00000000009,
	   0.00000001734,     0.00000002989,
	   0.00000000502,    -0.00000000234,
	  -0.00000000016,    -0.00000000042,
	   0.00000002780,    -0.00000001862,
	  -0.00000000277,    -0.00000000439,
	  -0.00000000033,     0.00000000023,
	   0.00000000071,    -0.00000000011,
	  -0.00000000042,    -0.00000000032,
	  -0.00000001797,    -0.00000036143,
	  -0.00000008650,    -0.00000000149,
	  -0.00000000059,     0.00000001018,
	  -0.00000039177,     0.00000001544,
	  -0.00000000246,     0.00000009407,
	   0.00000001104,     0.00000000071,
	  -0.00000019471,    -0.00000032946,
	  -0.00000005523,     0.00000002670,
	   0.00000000184,     0.00000000459,
	  -0.00000031174,     0.00000020520,
	   0.00000003039,     0.00000004974,
	   0.00000000375,    -0.00000000246,
	  -0.00000000546,     0.00000000169,
	   0.00000000023,     0.00000000055,
	   0.00000000321,     0.00000000344,
	   0.00000000021,    -0.00000000050,
	   0.00000001769,     0.00000002846,
	   0.00000000466,    -0.00000000251,
	  -0.00000000019,    -0.00000000037,
	   0.00000005834,    -0.00000003566,
	  -0.00000000506,    -0.00000000956,
	  -0.00000000076,     0.00000000038,
	   0.00000003053,     0.00000001974,
	   0.00000000207,    -0.00000000227,
	   0.00000001430,    -0.00000003060,
	  -0.00000000235,    -0.00000000079,
	   0.00000000056,    -0.00000000029,
	  -0.00000000040,     0.00000000019,
	  -0.00000027475,    -0.00000044192,
	  -0.00000007246,     0.00000003897,
	   0.00000000291,     0.00000000578,
	  -0.00000044357,     0.00000027111,
	   0.00000003862,     0.00000007272,
	   0.00000000577,    -0.00000000289,
	  -0.00000034533,    -0.00000021235,
	  -0.00000002101,     0.00000002591,
	   0.00000000100,     0.00000000118,
	  -0.00000017176,     0.00000034557,
	   0.00000002650,     0.00000001134,
	   0.00000000004,    -0.00000000110,
	  -0.00000000361,     0.00000000344,
	   0.00000000053,     0.00000000033,
	   0.00000000386,    -0.00000000010,
	  -0.00000000007,    -0.00000000055,
	   0.00000003840,     0.00000002152,
	   0.00000000184,    -0.00000000290,
	  -0.00000000012,    -0.00000000007,
	   0.00000003917,    -0.00000006958,
	  -0.00000000526,    -0.00000000333,
	   0.00000002260,     0.00000000513,
	   0.00000000073,    -0.00000000037,
	  -0.00000000462,    -0.00000001706,
	   0.00000000043,     0.00000000084,
	   0.00000000040,    -0.00000000039,
	   0.00000000000,     0.00000000051,
	  -0.00000052102,    -0.00000029191,
	  -0.00000002500,     0.00000003947,
	   0.00000000158,     0.00000000096,
	  -0.00000029003,     0.00000051487,
	   0.00000003904,     0.00000002466,
	   0.00000000094,    -0.00000000155,
	  -0.00000024859,    -0.00000003386,
	  -0.00000000450,     0.00000000235,
	   0.00000000014,     0.00000000041,
	   0.00000002925,     0.00000021241,
	  -0.00000000285,    -0.00000000576,
	  -0.00000000042,     0.00000000025,
	  -0.00000000152,     0.00000000388,
	   0.00000000074,     0.00000000003,
	   0.00000000183,    -0.00000000287,
	  -0.00000000023,    -0.00000000052,
	   0.00000003217,     0.00000000059,
	   0.00000000053,    -0.00000005385,
	   0.00000000317,     0.00000000769,
	   0.00000000017,    -0.00000000096,
	  -0.00000000155,     0.00000001269,
	   0.00000000025,     0.00000000061,
	   0.00000000014,    -0.00000000050,
	   0.00000000025,     0.00000000035,
	  -0.00000037425,    -0.00000000682,
	   0.00000000057,    -0.00000000033,
	  -0.00000000402,     0.00000038456,
	  -0.00000000046,    -0.00000000058,
	   0.00000000710,    -0.00000005812,
	   0.00000000025,     0.00000000715,
	  -0.00000000710,    -0.00000009475,
	   0.00000000045,    -0.00000000455,
	   0.00000000020,     0.00000000383,
	   0.00000000038,    -0.00000000012,
	  -0.00000000040,    -0.00000000269,
	  -0.00000000638,     0.00000000450,
	  -0.00000000032,    -0.00000000048,
	   0.00000000630,     0.00000000930,
	  -0.00000000069,     0.00000000043,
	   0.00000000881,    -0.00000000036,
	  -0.00000000058,     0.00000000839,
	   0.00000006186,    -0.00000004361,
	   0.00000000311,     0.00000000470,
	  -0.00000000022,     0.00000000017,
	  -0.00000004635,    -0.00000006852,
	   0.00000000503,    -0.00000000322,
	  -0.00000004122,     0.00000000421,
	  -0.00000000095,    -0.00000000035,
	   0.00000000535,    -0.00000003700,
	  -0.00000000037,     0.00000000105,
	   0.00000000009,     0.00000000192,
	  -0.00000000204,     0.00000000056,
	   0.00000000018,    -0.00000000057,
	  -0.00000000072,    -0.00000000030,
	  -0.00000000153,     0.00000000117,
	  -0.00000000112,    -0.00000000155,
	  -0.00000000137,     0.00000000442,
	  -0.00000000098,    -0.00000000028,
	   0.00000000545,     0.00000000226,
	  -0.00000000044,     0.00000000140,
	   0.00000000589,    -0.00000000464,
	   0.00000000040,     0.00000000048,
	   0.00000000420,     0.00000000606,
	  -0.00000000051,     0.00000000032,
	   0.00000000128,     0.00000000152,
	  -0.00000000153,     0.00000000122,
	   0.00000000107,    -0.00000000037,
	  -0.00000000047,    -0.00000000138,
	   0.00000000090,    -0.00000000018,
	  -0.00000000003,    -0.00000000060,
	   0.00000000414,    -0.00000000058,
	   0.00000000011,    -0.00000000019,
	  -0.00000000075,    -0.00000000532,
	   0.00000000225,    -0.00000000016,
	   0.00000000042,    -0.00000000044,
	   0.00000000867,     0.00000000078,
	   0.00000000082,    -0.00000001110,
	   0.00000000380,    -0.00000000032,
	   0.00000000078,     0.00000000435,
	  -0.00000000157,     0.00000000172,
	   0.00000000178,     0.00000000188,
	   0.00000001022,     0.00000000068,
	  -0.00000000076,     0.00000001022,
	  -0.00000000156,     0.00000000205,
	  -0.00000000204,    -0.00000000156,
	  -0.00000000038,    -0.00000000050,
	  -0.00000000035,     0.00000000023,
	  -0.00000000049,     0.00000000039,
	   0.00000000023,     0.00000000035,
	  -0.00000000122,    -0.00000000156,
	  -0.00000000110,     0.00000000072,
	   0.00000000021,     0.00000000037,
	  -0.00000000316,    -0.00000000139,
	  -0.00000000095,     0.00000000176,
	   0.00000000048,     0.00000000030,
	  -0.00000000133,     0.00000000316,
	   0.00000000176,     0.00000000090,
	   0.00000000028,    -0.00000000048,
	   0.00000000061,     0.00000000026,
	   0.00000000018,    -0.00000000034,
	  -0.00000000009,    -0.00000000006,
	  -0.00000000053,     0.00000000131,
	   0.00000000072,     0.00000000036,
	   0.00000000233,    -0.00000000021,
	  -0.00000000001,    -0.00000000114,
	  -0.00000000025,    -0.00000000231,
	  -0.00000000113,     0.00000000004,
	  -0.00000001423,    -0.00000000611,
	  -0.00000000417,     0.00000000792,
	   0.00000000213,     0.00000000130,
	   0.00000000373,    -0.00000000924,
	  -0.00000000506,    -0.00000000250,
	  -0.00000000078,     0.00000000136,
	  -0.00000002507,     0.00000000228,
	   0.00000000015,     0.00000001233,
	   0.00000000295,     0.00000000014,
	   0.00000000272,     0.00000002482,
	   0.00000001219,    -0.00000000045,
	   0.00000000004,    -0.00000000291,
	  -0.00000000009,     0.00000000089,
	   0.00000000084,    -0.00000000002,
	  -0.00000001182,     0.00000000119,
	   0.00000000014,     0.00000000581,
	   0.00000000139,     0.00000000005,
	   0.00000002120,     0.00000021575,
	   0.00000010625,    -0.00000000240,
	   0.00000000088,    -0.00000002534,
	  -0.00000000400,    -0.00000000040,
	  -0.00000002930,     0.00000001976,
	   0.00000000706,     0.00000001240,
	   0.00000000254,    -0.00000000125,
	   0.00000002028,     0.00000002846,
	   0.00000001195,    -0.00000000737,
	  -0.00000000134,    -0.00000000242,
	   0.00000000049,     0.00000000132,
	   0.00000000104,    -0.00000000070,
	   0.00000025517,    -0.00000002565,
	  -0.00000000309,    -0.00000012558,
	  -0.00000002994,    -0.00000000098,
	  -0.00000016311,    -0.00000165816,
	  -0.00000081682,     0.00000001828,
	  -0.00000000678,     0.00000019490,
	   0.00000003100,     0.00000000290,
	   0.00000000060,    -0.00000000370,
	  -0.00000000034,    -0.00000000007,
	   0.00000031700,    -0.00000021458,
	  -0.00000007710,    -0.00000013484,
	  -0.00000002761,     0.00000001369,
	  -0.00000021950,    -0.00000030848,
	  -0.00000013029,     0.00000008015,
	   0.00000001463,     0.00000002634,
	  -0.00000000426,    -0.00000001014,
	  -0.00000000271,     0.00000000092,
	   0.00000000015,     0.00000000041,
	  -0.00000000860,     0.00000000537,
	   0.00000000141,     0.00000000213,
	   0.00000000030,    -0.00000000025,
	  -0.00000001693,     0.00000000834,
	   0.00000000493,     0.00000000989,
	   0.00000000046,     0.00000000094,
	   0.00000000054,    -0.00000000027,
	   0.00000012754,    -0.00000006218,
	  -0.00000003754,    -0.00000007434,
	   0.00000000189,     0.00000000092,
	   0.00000000045,    -0.00000000084,
	   0.00000000087,    -0.00000000190,
	  -0.00000000085,    -0.00000000042,
	  -0.00000000454,     0.00000000315,
	   0.00000000113,     0.00000000191,
	   0.00000000039,    -0.00000000020,
	   0.00000001129,     0.00000001661,
	   0.00000000703,    -0.00000000408,
	  -0.00000000073,    -0.00000000143,
	  -0.00000000616,     0.00000001196,
	   0.00000000368,     0.00000000226,
	   0.00000000039,    -0.00000000056,
	   0.00000001197,     0.00000000562,
	   0.00000000201,    -0.00000000370,
	  -0.00000000057,    -0.00000000033,
	   0.00000000031,     0.00000000029,
	   0.00000009045,    -0.00000006275,
	  -0.00000002265,    -0.00000003822,
	  -0.00000000777,     0.00000000406,
	  -0.00000008851,    -0.00000013019,
	  -0.00000005521,     0.00000003203,
	   0.00000000574,     0.00000001122,
	   0.00000006701,    -0.00000013118,
	  -0.00000004051,    -0.00000002471,
	  -0.00000000427,     0.00000000617,
	  -0.00000013117,    -0.00000006201,
	  -0.00000002228,     0.00000004066,
	   0.00000000624,     0.00000000369,
	  -0.00000000260,    -0.00000000210,
	  -0.00000000044,     0.00000000049,
	  -0.00000000132,     0.00000000269,
	   0.00000000054,     0.00000000019,
	  -0.00000000384,     0.00000000780,
	   0.00000000240,     0.00000000140,
	   0.00000000024,    -0.00000000037,
	   0.00000001939,     0.00000000982,
	   0.00000000357,    -0.00000000600,
	  -0.00000000092,    -0.00000000060,
	   0.00000000038,     0.00000001668,
	   0.00000000400,     0.00000000023,
	   0.00000000006,    -0.00000000048,
	   0.00000001618,    -0.00000000127,
	  -0.00000000013,    -0.00000000382,
	   0.00000000040,     0.00000000012,
	   0.00000007016,    -0.00000014261,
	  -0.00000004402,    -0.00000002557,
	  -0.00000000435,     0.00000000673,
	  -0.00000015167,    -0.00000007675,
	  -0.00000002792,     0.00000004700,
	   0.00000000718,     0.00000000473,
	  -0.00000000535,    -0.00000018409,
	  -0.00000004425,    -0.00000000216,
	  -0.00000000058,     0.00000000525,
	  -0.00000017965,     0.00000001296,
	   0.00000000101,     0.00000004265,
	   0.00000000496,    -0.00000000006,
	  -0.00000000322,    -0.00000000062,
	  -0.00000000009,     0.00000000048,
	   0.00000000039,     0.00000000278,
	   0.00000000039,    -0.00000000016,
	   0.00000000075,     0.00000001506,
	   0.00000000359,     0.00000000006,
	   0.00000000002,    -0.00000000042,
	   0.00000003112,    -0.00000000122,
	   0.00000000019,    -0.00000000743,
	  -0.00000000087,    -0.00000000005,
	   0.00000001038,     0.00000001859,
	   0.00000000316,    -0.00000000136,
	   0.00000001663,    -0.00000001152,
	  -0.00000000175,    -0.00000000256,
	  -0.00000001241,    -0.00000024999,
	  -0.00000005968,    -0.00000000095,
	  -0.00000000039,     0.00000000702,
	  -0.00000024028,     0.00000000951,
	  -0.00000000140,     0.00000005753,
	   0.00000000675,     0.00000000042,
	  -0.00000011835,    -0.00000020480,
	  -0.00000003455,     0.00000001601,
	   0.00000000107,     0.00000000292,
	  -0.00000018944,     0.00000012711,
	   0.00000001910,     0.00000002979,
	   0.00000000219,    -0.00000000158,
	  -0.00000000322,     0.00000000096,
	   0.00000000016,     0.00000000040,
	   0.00000000199,     0.00000000183,
	   0.00000000015,    -0.00000000035,
	   0.00000001245,     0.00000002009,
	   0.00000000328,    -0.00000000176,
	  -0.00000000013,    -0.00000000026,
	   0.00000003693,    -0.00000002256,
	  -0.00000000320,    -0.00000000602,
	  -0.00000000048,     0.00000000024,
	   0.00000001784,     0.00000001245,
	   0.00000000140,    -0.00000000132,
	   0.00000000758,    -0.00000001784,
	  -0.00000000138,    -0.00000000026,
	   0.00000000036,    -0.00000000017,
	  -0.00000018615,    -0.00000030030,
	  -0.00000004910,     0.00000002644,
	   0.00000000198,     0.00000000391,
	  -0.00000027992,     0.00000017097,
	   0.00000002438,     0.00000004573,
	   0.00000000363,    -0.00000000183,
	  -0.00000020322,    -0.00000013084,
	  -0.00000001352,     0.00000001520,
	   0.00000000057,     0.00000000083,
	  -0.00000009662,     0.00000020305,
	   0.00000001562,     0.00000000538,
	  -0.00000000013,    -0.00000000065,
	  -0.00000000228,     0.00000000211,
	   0.00000000039,     0.00000000027,
	   0.00000000236,    -0.00000000028,
	   0.00000002459,     0.00000001384,
	   0.00000000118,    -0.00000000186,
	   0.00000002329,    -0.00000004133,
	  -0.00000000312,    -0.00000000197,
	   0.00000001225,     0.00000000422,
	   0.00000000060,    -0.00000000031,
	  -0.00000000372,    -0.00000000766,
	   0.00000000035,     0.00000000068,
	   0.00000000027,    -0.00000000025,
	  -0.00000032723,    -0.00000018495,
	  -0.00000001567,     0.00000002478,
	   0.00000000098,     0.00000000059,
	  -0.00000017331,     0.00000030596,
	   0.00000002311,     0.00000001454,
	   0.00000000055,    -0.00000000091,
	  -0.00000013139,    -0.00000002722,
	  -0.00000000357,     0.00000000186,
	   0.00000002225,     0.00000010264,
	  -0.00000000226,    -0.00000000446,
	  -0.00000000032,     0.00000000020,
	  -0.00000000104,     0.00000000250,
	   0.00000000050,     0.00000000006,
	   0.00000000105,    -0.00000000188,
	   0.00000001741,     0.00000000054,
	   0.00000000053,    -0.00000002760,
	   0.00000000244,     0.00000000543,
	   0.00000000013,    -0.00000000067,
	  -0.00000000121,     0.00000000896,
	   0.00000000019,     0.00000000043,
	  -0.00000020259,    -0.00000000621,
	   0.00000000046,    -0.00000000028,
	  -0.00000000403,     0.00000019703,
	  -0.00000000036,    -0.00000000044,
	   0.00000000442,    -0.00000004080,
	   0.00000000012,     0.00000000501,
	  -0.00000000476,    -0.00000006636,
	   0.00000000028,    -0.00000000316,
	   0.00000000000,     0.00000000238,
	  -0.00000000048,    -0.00000000156,
	  -0.00000000470,     0.00000000328,
	  -0.00000000023,    -0.00000000036,
	   0.00000000450,     0.00000000666,
	  -0.00000000049,     0.00000000031,
	   0.00000000526,    -0.00000000030,
	  -0.00000000054,     0.00000000489,
	   0.00000004689,    -0.00000003265,
	   0.00000000230,     0.00000000355,
	  -0.00000000017,     0.00000000013,
	  -0.00000003314,    -0.00000004921,
	   0.00000000361,    -0.00000000227,
	  -0.00000002527,     0.00000000379,
	  -0.00000000081,    -0.00000000031,
	   0.00000000493,    -0.00000002155,
	  -0.00000000032,     0.00000000089,
	   0.00000000003,     0.00000000128,
	  -0.00000000140,     0.00000000044,
	   0.00000000018,    -0.00000000056,
	  -0.00000000069,    -0.00000000027,
	  -0.00000000120,     0.00000000091,
	  -0.00000000086,    -0.00000000122,
	  -0.00000000148,     0.00000000463,
	  -0.00000000094,    -0.00000000029,
	   0.00000000526,     0.00000000208,
	  -0.00000000039,     0.00000000118,
	   0.00000000473,    -0.00000000378,
	   0.00000000034,     0.00000000037,
	   0.00000000324,     0.00000000490,
	  -0.00000000041,     0.00000000022,
	   0.00000000076,     0.00000000091,
	  -0.00000000092,     0.00000000071,
	   0.00000000084,    -0.00000000010,
	  -0.00000000013,    -0.00000000105,
	   0.00000000151,     0.00000000020,
	   0.00000000020,    -0.00000000187,
	   0.00000000081,    -0.00000000006,
	   0.00000000015,     0.00000000093,
	  -0.00000000034,     0.00000000036,
	   0.00000000037,     0.00000000039,
	   0.00000000182,     0.00000000018,
	  -0.00000000020,     0.00000000182,
	  -0.00000000035,     0.00000000043,
	  -0.00000000043,    -0.00000000035,
	  -0.00000000011,    -0.00000000069,
	  -0.00000000052,     0.00000000004,
	   0.00000000000,     0.00000000019,
	  -0.00000000073,    -0.00000000096,
	  -0.00000000067,     0.00000000043,
	  -0.00000000094,     0.00000000074,
	   0.00000000044,     0.00000000066,
	  -0.00000000029,     0.00000000024,
	   0.00000000070,     0.00000000031,
	   0.00000000021,    -0.00000000039,
	   0.00000000029,    -0.00000000070,
	  -0.00000000039,    -0.00000000020,
	  -0.00000000312,    -0.00000000402,
	  -0.00000000281,     0.00000000184,
	   0.00000000053,     0.00000000094,
	   0.00000000201,    -0.00000000165,
	  -0.00000000097,    -0.00000000138,
	  -0.00000000046,     0.00000000028,
	  -0.00000000758,    -0.00000000334,
	  -0.00000000226,     0.00000000418,
	   0.00000000113,     0.00000000071,
	  -0.00000000316,     0.00000000758,
	   0.00000000419,     0.00000000212,
	   0.00000000066,    -0.00000000113,
	  -0.00000001456,    -0.00000000624,
	  -0.00000000420,     0.00000000804,
	   0.00000000218,     0.00000000131,
	  -0.00000038499,     0.00000089705,
	   0.00000049590,     0.00000025963,
	   0.00000008140,    -0.00000013485,
	  -0.00000002440,    -0.00000001680,
	  -0.00000000260,     0.00000000330,
	   0.00000000040,     0.00000000030,
	  -0.00000004805,     0.00000000418,
	   0.00000000024,     0.00000002352,
	   0.00000000561,     0.00000000027,
	   0.00000000540,     0.00000004735,
	   0.00000002313,    -0.00000000102,
	   0.00000000003,    -0.00000000550,
	  -0.00000000030,     0.00000000208,
	   0.00000000067,     0.00000000016,
	   0.00000000188,    -0.00000000013,
	  -0.00000000004,    -0.00000000059,
	   0.00000031706,     0.00000013592,
	   0.00000009168,    -0.00000017535,
	  -0.00000004754,    -0.00000002865,
	   0.00000294204,    -0.00000685519,
	  -0.00000379283,    -0.00000198525,
	  -0.00000062276,     0.00000103187,
	   0.00000018640,     0.00000012870,
	   0.00000001970,    -0.00000002510,
	  -0.00000000269,    -0.00000000239,
	   0.00000051975,    -0.00000004638,
	  -0.00000000291,    -0.00000025490,
	  -0.00000006107,    -0.00000000304,
	  -0.00000000110,     0.00000000970,
	  -0.00000005813,    -0.00000051260,
	  -0.00000025078,     0.00000001088,
	  -0.00000000037,     0.00000005987,
	   0.00000000950,     0.00000000050,
	   0.00000000170,    -0.00000001622,
	  -0.00000000541,    -0.00000000099,
	  -0.00000000019,     0.00000000096,
	  -0.00000001514,     0.00000000061,
	   0.00000000018,     0.00000000496,
	   0.00000000087,    -0.00000000009,
	   0.00000000192,    -0.00000000004,
	  -0.00000000002,    -0.00000000134,
	  -0.00000000196,     0.00000000070,
	   0.00000000038,     0.00000000156,
	  -0.00000000232,     0.00000000023,
	   0.00000000003,     0.00000000113,
	   0.00000000027,     0.00000000001,
	   0.00000000083,     0.00000000906,
	   0.00000000443,    -0.00000000008,
	   0.00000000004,    -0.00000000106,
	  -0.00000000499,     0.00000000333,
	   0.00000000119,     0.00000000210,
	   0.00000000043,    -0.00000000021,
	   0.00000000345,     0.00000000478,
	   0.00000000200,    -0.00000000126,
	  -0.00000000023,    -0.00000000040,
	   0.00000004728,    -0.00000000477,
	  -0.00000000065,    -0.00000002308,
	  -0.00000000549,    -0.00000000016,
	  -0.00000000653,    -0.00000007118,
	  -0.00000003483,     0.00000000062,
	  -0.00000000032,     0.00000000830,
	   0.00000005438,    -0.00000003658,
	  -0.00000001304,    -0.00000002298,
	  -0.00000000471,     0.00000000231,
	  -0.00000003764,    -0.00000005246,
	  -0.00000002193,     0.00000001371,
	   0.00000000252,     0.00000000443,
	  -0.00000000063,    -0.00000000153,
	  -0.00000000042,     0.00000000014,
	  -0.00000000126,     0.00000000083,
	   0.00000000023,     0.00000000032,
	  -0.00000000295,     0.00000000205,
	   0.00000000074,     0.00000000124,
	   0.00000000025,    -0.00000000013,
	   0.00000000516,     0.00000000762,
	   0.00000000321,    -0.00000000186,
	  -0.00000000033,    -0.00000000065,
	  -0.00000000351,     0.00000000672,
	   0.00000000206,     0.00000000129,
	   0.00000000023,    -0.00000000031,
	   0.00000000672,     0.00000000309,
	   0.00000000109,    -0.00000000207,
	  -0.00000000032,    -0.00000000018,
	   0.00000005574,    -0.00000003872,
	  -0.00000001397,    -0.00000002344,
	  -0.00000000477,     0.00000000251,
	  -0.00000004068,    -0.00000006006,
	  -0.00000002530,     0.00000001466,
	   0.00000000264,     0.00000000514,
	   0.00000003826,    -0.00000007416,
	  -0.00000002278,    -0.00000001405,
	  -0.00000000245,     0.00000000348,
	  -0.00000007409,    -0.00000003457,
	  -0.00000001227,     0.00000002286,
	   0.00000000352,     0.00000000202,
	  -0.00000000132,    -0.00000000108,
	  -0.00000000024,     0.00000000027,
	  -0.00000000062,     0.00000000137,
	  -0.00000000015,     0.00000000025,
	  -0.00000000024,     0.00000000056,
	  -0.00000000285,     0.00000000580,
	   0.00000000178,     0.00000000103,
	   0.00000000018,    -0.00000000027,
	   0.00000001207,     0.00000000612,
	   0.00000000221,    -0.00000000372,
	  -0.00000000057,    -0.00000000037,
	   0.00000000012,     0.00000001075,
	   0.00000000258,     0.00000000019,
	   0.00000001028,    -0.00000000092,
	  -0.00000000013,    -0.00000000241,
	   0.00000004978,    -0.00000010120,
	  -0.00000003118,    -0.00000001805,
	  -0.00000000307,     0.00000000477,
	  -0.00000009445,    -0.00000004782,
	  -0.00000001727,     0.00000002912,
	   0.00000000446,     0.00000000292,
	  -0.00000000265,    -0.00000011911,
	  -0.00000002855,    -0.00000000167,
	  -0.00000000043,     0.00000000341,
	  -0.00000011525,     0.00000000907,
	   0.00000000099,     0.00000002716,
	   0.00000000316,    -0.00000000011,
	  -0.00000000193,    -0.00000000039,
	   0.00000000031,     0.00000000162,
	   0.00000000055,     0.00000001118,
	   0.00000000266,     0.00000000004,
	   0.00000000002,    -0.00000000031,
	   0.00000002065,    -0.00000000081,
	   0.00000000012,    -0.00000000492,
	  -0.00000000058,    -0.00000000003,
	   0.00000000644,     0.00000001210,
	   0.00000000209,    -0.00000000082,
	   0.00000001032,    -0.00000000745,
	  -0.00000000116,    -0.00000000154,
	  -0.00000000873,    -0.00000017862,
	  -0.00000004256,    -0.00000000066,
	  -0.00000000027,     0.00000000501,
	  -0.00000015933,     0.00000000628,
	  -0.00000000088,     0.00000003793,
	   0.00000000446,     0.00000000027,
	  -0.00000007469,    -0.00000013297,
	  -0.00000002252,     0.00000000990,
	   0.00000000063,     0.00000000194,
	  -0.00000011974,     0.00000008206,
	   0.00000001249,     0.00000001845,
	   0.00000000131,    -0.00000000107,
	  -0.00000000204,     0.00000000058,
	   0.00000000130,     0.00000000102,
	   0.00000000870,     0.00000001411,
	   0.00000000229,    -0.00000000123,
	  -0.00000000009,    -0.00000000018,
	   0.00000002396,    -0.00000001461,
	  -0.00000000208,    -0.00000000389,
	   0.00000001055,     0.00000000806,
	   0.00000000098,    -0.00000000077,
	   0.00000000390,    -0.00000001052,
	  -0.00000000082,     0.00000000000,
	  -0.00000012650,    -0.00000020506,
	  -0.00000003343,     0.00000001799,
	   0.00000000135,     0.00000000266,
	  -0.00000018135,     0.00000011051,
	   0.00000001573,     0.00000002946,
	   0.00000000234,    -0.00000000118,
	  -0.00000012097,    -0.00000008233,
	  -0.00000000892,     0.00000000901,
	   0.00000000033,     0.00000000059,
	  -0.00000005432,     0.00000012064,
	   0.00000000931,     0.00000000226,
	  -0.00000000019,    -0.00000000039,
	  -0.00000000150,     0.00000000133,
	   0.00000000028,     0.00000000021,
	   0.00000000148,    -0.00000000032,
	   0.00000001561,     0.00000000893,
	   0.00000000075,    -0.00000000118,
	   0.00000001413,    -0.00000002477,
	  -0.00000000187,    -0.00000000118,
	   0.00000000671,     0.00000000331,
	   0.00000000048,    -0.00000000024,
	  -0.00000000288,    -0.00000000310,
	   0.00000000028,     0.00000000053,
	  -0.00000020425,    -0.00000011682,
	  -0.00000000976,     0.00000001545,
	   0.00000000060,     0.00000000036,
	  -0.00000010455,     0.00000018302,
	   0.00000001381,     0.00000000866,
	   0.00000000032,    -0.00000000053,
	  -0.00000006938,    -0.00000002097,
	  -0.00000000274,     0.00000000142,
	   0.00000001651,     0.00000004746,
	  -0.00000000172,    -0.00000000334,
	  -0.00000000072,     0.00000000162,
	   0.00000000058,    -0.00000000125,
	   0.00000000921,     0.00000000045,
	   0.00000000046,    -0.00000001401,
	   0.00000000176,     0.00000000371,
	   0.00000000010,    -0.00000000046,
	  -0.00000000090,     0.00000000611,
	  -0.00000010717,    -0.00000000519,
	   0.00000000034,    -0.00000000022,
	  -0.00000000351,     0.00000009967,
	  -0.00000000028,    -0.00000000032,
	   0.00000000279,    -0.00000002774,
	   0.00000000005,     0.00000000340,
	  -0.00000000304,    -0.00000004505,
	   0.00000000017,    -0.00000000211,
	  -0.00000000008,     0.00000000149,
	  -0.00000000045,    -0.00000000091,
	  -0.00000000333,     0.00000000229,
	  -0.00000000016,    -0.00000000025,
	   0.00000000308,     0.00000000460,
	  -0.00000000034,     0.00000000021,
	   0.00000000304,    -0.00000000025,
	  -0.00000000046,     0.00000000274,
	   0.00000003387,    -0.00000002326,
	   0.00000000161,     0.00000000255,
	  -0.00000000012,     0.00000000009,
	  -0.00000002273,    -0.00000003397,
	   0.00000000249,    -0.00000000153,
	  -0.00000001504,     0.00000000321,
	  -0.00000000066,    -0.00000000026,
	   0.00000000425,    -0.00000001191,
	  -0.00000000026,     0.00000000073,
	   0.00000000000,     0.00000000085,
	  -0.00000000094,     0.00000000032,
	   0.00000000017,    -0.00000000050,
	  -0.00000000062,    -0.00000000024,
	  -0.00000000089,     0.00000000068,
	  -0.00000000062,    -0.00000000091,
	  -0.00000000144,     0.00000000437,
	  -0.00000000084,    -0.00000000027,
	   0.00000000468,     0.00000000182,
	  -0.00000000033,     0.00000000096,
	   0.00000000360,    -0.00000000293,
	   0.00000000028,     0.00000000027,
	   0.00000000235,     0.00000000377,
	   0.00000000045,     0.00000000053,
	  -0.00000000055,     0.00000000041,
	  -0.00000000009,     0.00000000044,
	  -0.00000000043,    -0.00000000011,
	  -0.00000000026,    -0.00000000168,
	  -0.00000000126,     0.00000000009,
	   0.00000000000,     0.00000000046,
	   0.00000000068,    -0.00000000013,
	  -0.00000000006,    -0.00000000050,
	  -0.00000000167,    -0.00000000220,
	  -0.00000000153,     0.00000000098,
	   0.00000000028,     0.00000000051,
	  -0.00000000214,     0.00000000170,
	   0.00000000101,     0.00000000148,
	   0.00000000049,    -0.00000000029,
	   0.00000000234,     0.00000000302,
	   0.00000000209,    -0.00000000138,
	  -0.00000000040,    -0.00000000070,
	  -0.00000011387,     0.00000008858,
	   0.00000005214,     0.00000007889,
	   0.00000002621,    -0.00000001503,
	  -0.00000000280,    -0.00000000570,
	   0.00000001079,     0.00000000482,
	   0.00000000320,    -0.00000000591,
	  -0.00000000160,    -0.00000000100,
	   0.00000000446,    -0.00000001079,
	  -0.00000000592,    -0.00000000296,
	  -0.00000000092,     0.00000000161,
	   0.00000000033,    -0.00000000044,
	  -0.00000000045,    -0.00000000022,
	  -0.00000005135,    -0.00000006612,
	  -0.00000004587,     0.00000003025,
	   0.00000000876,     0.00000001532,
	   0.00000086298,    -0.00000067138,
	  -0.00000039570,    -0.00000059940,
	  -0.00000019914,     0.00000011425,
	   0.00000002170,     0.00000004390,
	   0.00000000720,    -0.00000000300,
	  -0.00000000033,    -0.00000000095,
	  -0.00000011686,    -0.00000005199,
	  -0.00000003473,     0.00000006428,
	   0.00000001734,     0.00000001085,
	  -0.00000004853,     0.00000011671,
	   0.00000006434,     0.00000003219,
	   0.00000000992,    -0.00000001742,
	  -0.00000000242,     0.00000000349,
	   0.00000000137,     0.00000000112,
	   0.00000000025,    -0.00000000028,
	   0.00000000353,     0.00000000181,
	   0.00000000077,    -0.00000000142,
	  -0.00000000092,    -0.00000000039,
	  -0.00000000026,     0.00000000050,
	   0.00000000014,     0.00000000008,
	  -0.00000000169,     0.00000000385,
	   0.00000000212,     0.00000000113,
	   0.00000000035,    -0.00000000057,
	  -0.00000000265,     0.00000000022,
	   0.00000000001,     0.00000000129,
	   0.00000000031,     0.00000000260,
	   0.00000000126,    -0.00000000007,
	   0.00000001892,     0.00000000812,
	   0.00000000542,    -0.00000001040,
	  -0.00000000280,    -0.00000000168,
	   0.00000001331,    -0.00000003031,
	  -0.00000001667,    -0.00000000886,
	  -0.00000000275,     0.00000000451,
	   0.00000002893,    -0.00000000250,
	  -0.00000000014,    -0.00000001409,
	  -0.00000000336,    -0.00000000017,
	  -0.00000000331,    -0.00000002842,
	  -0.00000001380,     0.00000000069,
	   0.00000000001,     0.00000000328,
	   0.00000000009,    -0.00000000080,
	  -0.00000000074,     0.00000000004,
	  -0.00000000146,     0.00000000015,
	   0.00000000002,     0.00000000071,
	   0.00000000017,     0.00000000000,
	   0.00000000034,     0.00000000386,
	   0.00000000188,    -0.00000000003,
	  -0.00000000278,     0.00000000184,
	   0.00000000065,     0.00000000117,
	   0.00000000192,     0.00000000263,
	   0.00000000109,    -0.00000000070,
	   0.00000002838,    -0.00000000287,
	  -0.00000000040,    -0.00000001378,
	  -0.00000000328,    -0.00000000009,
	  -0.00000000273,    -0.00000003062,
	  -0.00000001492,     0.00000000026,
	  -0.00000000013,     0.00000000355,
	   0.00000003040,    -0.00000002031,
	  -0.00000000721,    -0.00000001281,
	  -0.00000000263,     0.00000000128,
	  -0.00000002103,    -0.00000002905,
	  -0.00000001207,     0.00000000767,
	   0.00000000141,     0.00000000243,
	  -0.00000000032,    -0.00000000077,
	  -0.00000000061,     0.00000000043,
	  -0.00000000222,     0.00000000154,
	   0.00000000055,     0.00000000093,
	   0.00000000019,    -0.00000000010,
	   0.00000000321,     0.00000000475,
	   0.00000000199,    -0.00000000116,
	  -0.00000000021,    -0.00000000040,
	  -0.00000000237,     0.00000000443,
	   0.00000000136,     0.00000000087,
	   0.00000000443,     0.00000000199,
	   0.00000000069,    -0.00000000136,
	   0.00000004014,    -0.00000002789,
	  -0.00000001006,    -0.00000001681,
	  -0.00000000342,     0.00000000181,
	  -0.00000002537,    -0.00000003750,
	  -0.00000001573,     0.00000000913,
	   0.00000000165,     0.00000000319,
	   0.00000002572,    -0.00000004923,
	  -0.00000001509,    -0.00000000944,
	  -0.00000000165,     0.00000000230,
	  -0.00000004913,    -0.00000002261,
	  -0.00000000794,     0.00000001514,
	   0.00000000233,     0.00000000129,
	  -0.00000000081,    -0.00000000067,
	  -0.00000000034,     0.00000000084,
	  -0.00000000220,     0.00000000446,
	   0.00000000137,     0.00000000079,
	   0.00000000013,    -0.00000000021,
	   0.00000000826,     0.00000000419,
	   0.00000000151,    -0.00000000254,
	  -0.00000000039,    -0.00000000025,
	  -0.00000000002,     0.00000000729,
	   0.00000000175,     0.00000000017,
	   0.00000000685,    -0.00000000070,
	  -0.00000000013,    -0.00000000160,
	   0.00000003688,    -0.00000007490,
	  -0.00000002303,    -0.00000001331,
	  -0.00000000226,     0.00000000352,
	  -0.00000006457,    -0.00000003270,
	  -0.00000001175,     0.00000001987,
	   0.00000000305,     0.00000000199,
	  -0.00000000113,    -0.00000008093,
	  -0.00000001940,    -0.00000000136,
	  -0.00000000033,     0.00000000232,
	  -0.00000007754,     0.00000000664,
	   0.00000000092,     0.00000001819,
	   0.00000000210,    -0.00000000013,
	  -0.00000000124,    -0.00000000026,
	   0.00000000025,     0.00000000101,
	   0.00000000039,     0.00000000831,
	   0.00000000197,     0.00000000003,
	   0.00000000001,    -0.00000000023,
	   0.00000001416,    -0.00000000055,
	   0.00000000008,    -0.00000000336,
	   0.00000000403,     0.00000000804,
	   0.00000000141,    -0.00000000049,
	   0.00000000647,    -0.00000000490,
	  -0.00000000079,    -0.00000000093,
	  -0.00000000612,    -0.00000012873,
	  -0.00000003062,    -0.00000000047,
	  -0.00000000019,     0.00000000360,
	  -0.00000010904,     0.00000000424,
	  -0.00000000058,     0.00000002590,
	   0.00000000305,     0.00000000018,
	  -0.00000004764,    -0.00000008780,
	  -0.00000001500,     0.00000000618,
	   0.00000000037,     0.00000000131,
	  -0.00000007662,     0.00000005377,
	   0.00000000834,     0.00000001156,
	   0.00000000078,    -0.00000000073,
	  -0.00000000133,     0.00000000036,
	   0.00000000088,     0.00000000059,
	   0.00000000602,     0.00000000983,
	   0.00000000159,    -0.00000000085,
	  -0.00000000006,    -0.00000000013,
	   0.00000001570,    -0.00000000953,
	  -0.00000000136,    -0.00000000254,
	   0.00000000625,     0.00000000530,
	   0.00000000069,    -0.00000000045,
	   0.00000000187,    -0.00000000620,
	  -0.00000000049,     0.00000000012,
	  -0.00000008553,    -0.00000013959,
	  -0.00000002268,     0.00000001219,
	   0.00000000091,     0.00000000180,
	  -0.00000011871,     0.00000007202,
	   0.00000001026,     0.00000001920,
	   0.00000000152,    -0.00000000077,
	  -0.00000007202,    -0.00000005235,
	  -0.00000000596,     0.00000000534,
	   0.00000000018,     0.00000000043,
	  -0.00000003003,     0.00000007166,
	   0.00000000556,     0.00000000066,
	  -0.00000000100,     0.00000000086,
	   0.00000000094,    -0.00000000029,
	   0.00000000976,     0.00000000567,
	   0.00000000047,    -0.00000000074,
	   0.00000000855,    -0.00000001481,
	  -0.00000000112,    -0.00000000070,
	   0.00000000369,     0.00000000251,
	   0.00000000036,    -0.00000000018,
	  -0.00000000216,    -0.00000000096,
	   0.00000000021,     0.00000000039,
	  -0.00000012617,    -0.00000007327,
	  -0.00000000603,     0.00000000954,
	   0.00000000036,     0.00000000022,
	  -0.00000006319,     0.00000010931,
	   0.00000000823,     0.00000000515,
	   0.00000000018,    -0.00000000031,
	  -0.00000003623,    -0.00000001563,
	  -0.00000000203,     0.00000000104,
	   0.00000001201,     0.00000002003,
	  -0.00000000128,    -0.00000000244,
	  -0.00000000051,     0.00000000105,
	   0.00000000031,    -0.00000000083,
	   0.00000000471,     0.00000000035,
	   0.00000000037,    -0.00000000693,
	   0.00000000121,     0.00000000247,
	  -0.00000000064,     0.00000000406,
	  -0.00000005474,    -0.00000000409,
	   0.00000000025,    -0.00000000018,
	  -0.00000000282,     0.00000004904,
	   0.00000000178,    -0.00000001838,
	   0.00000000001,     0.00000000225,
	  -0.00000000184,    -0.00000002981,
	   0.00000000011,    -0.00000000138,
	  -0.00000000010,     0.00000000094,
	  -0.00000000038,    -0.00000000054,
	  -0.00000000228,     0.00000000154,
	  -0.00000000010,    -0.00000000017,
	   0.00000000205,     0.00000000308,
	   0.00000000170,    -0.00000000019,
	  -0.00000000038,     0.00000000147,
	   0.00000002360,    -0.00000001596,
	   0.00000000109,     0.00000000177,
	  -0.00000001510,    -0.00000002278,
	   0.00000000167,    -0.00000000100,
	  -0.00000000871,     0.00000000259,
	  -0.00000000052,    -0.00000000021,
	   0.00000000347,    -0.00000000619,
	  -0.00000000021,     0.00000000057,
	  -0.00000000001,     0.00000000055,
	  -0.00000000062,     0.00000000022,
	   0.00000000014,    -0.00000000042,
	  -0.00000000052,    -0.00000000020,
	  -0.00000000064,     0.00000000049,
	  -0.00000000043,    -0.00000000066,
	  -0.00000000130,     0.00000000383,
	  -0.00000000070,    -0.00000000024,
	   0.00000000392,     0.00000000152,
	  -0.00000000027,     0.00000000076,
	   0.00000000263,    -0.00000000219,
	   0.00000000162,     0.00000000278,
	   0.00000000026,     0.00000000031,
	  -0.00000000032,     0.00000000023,
	  -0.00000000009,     0.00000000041,
	  -0.00000000040,    -0.00000000012,
	  -0.00000000043,    -0.00000000020,
	  -0.00000000009,     0.00000000017,
	  -0.00000000013,    -0.00000000092,
	  -0.00000000069,     0.00000000004,
	  -0.00000000091,     0.00000000015,
	   0.00000000006,     0.00000000068,
	   0.00000000008,     0.00000000054,
	   0.00000000040,    -0.00000000003,
	   0.00000000000,    -0.00000000014,
	  -0.00000000724,     0.00000000115,
	   0.00000000043,     0.00000000539,
	   0.00000000196,    -0.00000000003,
	   0.00000000102,     0.00000000136,
	   0.00000000093,    -0.00000000060,
	   0.00000000131,    -0.00000000104,
	  -0.00000000061,    -0.00000000090,
	  -0.00000000183,    -0.00000001172,
	  -0.00000000873,     0.00000000067,
	   0.00000000004,     0.00000000320,
	   0.00000005409,    -0.00000000860,
	  -0.00000000324,    -0.00000004030,
	  -0.00000001474,     0.00000000022,
	  -0.00000001099,    -0.00000001453,
	  -0.00000001004,     0.00000000642,
	   0.00000000186,     0.00000000338,
	  -0.00000001408,     0.00000001121,
	   0.00000000663,     0.00000000968,
	   0.00000000324,    -0.00000000196,
	  -0.00000000058,     0.00000000029,
	   0.00000000033,     0.00000000050,
	  -0.00000000026,    -0.00000000034,
	  -0.00000000023,     0.00000000015,
	  -0.00000000159,     0.00000000122,
	   0.00000000072,     0.00000000110,
	   0.00000000037,    -0.00000000021,
	  -0.00000000108,    -0.00000000049,
	  -0.00000000032,     0.00000000059,
	  -0.00000000044,     0.00000000108,
	   0.00000000059,     0.00000000029,
	   0.00000000552,     0.00000000712,
	   0.00000000487,    -0.00000000322,
	  -0.00000000094,    -0.00000000163,
	   0.00000001253,    -0.00000000957,
	  -0.00000000562,    -0.00000000864,
	  -0.00000000288,     0.00000000163,
	   0.00000001180,     0.00000000527,
	   0.00000000350,    -0.00000000645,
	  -0.00000000174,    -0.00000000109,
	   0.00000000484,    -0.00000001178,
	  -0.00000000646,    -0.00000000319,
	  -0.00000000098,     0.00000000175,
	   0.00000000022,    -0.00000000031,
	  -0.00000000055,    -0.00000000024,
	  -0.00000000016,     0.00000000030,
	   0.00000000008,     0.00000000005,
	  -0.00000000066,     0.00000000149,
	   0.00000000082,     0.00000000044,
	  -0.00000000143,     0.00000000011,
	   0.00000000000,     0.00000000069,
	   0.00000000017,     0.00000000139,
	   0.00000000067,    -0.00000000004,
	   0.00000001091,     0.00000000468,
	   0.00000000309,    -0.00000000596,
	  -0.00000000161,    -0.00000000096,
	   0.00000000526,    -0.00000001189,
	  -0.00000000652,    -0.00000000348,
	  -0.00000000107,     0.00000000176,
	   0.00000001564,    -0.00000000130,
	  -0.00000000005,    -0.00000000760,
	  -0.00000000181,    -0.00000000010,
	  -0.00000000184,    -0.00000001530,
	  -0.00000000740,     0.00000000041,
	   0.00000000002,     0.00000000175,
	  -0.00000000111,     0.00000000011,
	   0.00000000002,     0.00000000053,
	   0.00000000013,     0.00000000000,
	   0.00000000021,     0.00000000239,
	   0.00000000116,    -0.00000000002,
	  -0.00000000188,     0.00000000122,
	   0.00000000043,     0.00000000079,
	   0.00000000130,     0.00000000175,
	   0.00000000072,    -0.00000000047,
	   0.00000002056,    -0.00000000208,
	  -0.00000000030,    -0.00000000995,
	  -0.00000000237,    -0.00000000006,
	  -0.00000000167,    -0.00000001896,
	  -0.00000000921,     0.00000000016,
	  -0.00000000008,     0.00000000219,
	   0.00000002063,    -0.00000001366,
	  -0.00000000483,    -0.00000000867,
	  -0.00000000178,     0.00000000085,
	  -0.00000001424,    -0.00000001950,
	  -0.00000000806,     0.00000000521,
	   0.00000000096,     0.00000000162,
	  -0.00000000019,    -0.00000000048,
	  -0.00000000037,     0.00000000027,
	  -0.00000000175,     0.00000000121,
	   0.00000000044,     0.00000000073,
	   0.00000000015,    -0.00000000008,
	   0.00000000224,     0.00000000332,
	   0.00000000139,    -0.00000000081,
	  -0.00000000170,     0.00000000310,
	   0.00000000095,     0.00000000063,
	   0.00000000309,     0.00000000136,
	   0.00000000046,    -0.00000000095,
	   0.00000003047,    -0.00000002116,
	  -0.00000000762,    -0.00000001272,
	  -0.00000000258,     0.00000000137,
	  -0.00000001768,    -0.00000002615,
	  -0.00000001093,     0.00000000636,
	   0.00000000115,     0.00000000222,
	   0.00000001835,    -0.00000003460,
	  -0.00000001059,    -0.00000000673,
	  -0.00000000118,     0.00000000162,
	  -0.00000003449,    -0.00000001565,
	  -0.00000000543,     0.00000001061,
	   0.00000000164,     0.00000000087,
	  -0.00000000053,    -0.00000000045,
	  -0.00000000020,     0.00000000055,
	  -0.00000000170,     0.00000000345,
	   0.00000000106,     0.00000000061,
	   0.00000000010,    -0.00000000016,
	   0.00000000589,     0.00000000299,
	   0.00000000107,    -0.00000000181,
	  -0.00000000009,     0.00000000504,
	   0.00000000122,     0.00000000014,
	   0.00000000465,    -0.00000000055,
	  -0.00000000012,    -0.00000000108,
	   0.00000002773,    -0.00000005617,
	  -0.00000001725,    -0.00000000994,
	  -0.00000000169,     0.00000000264,
	  -0.00000004593,    -0.00000002328,
	  -0.00000000832,     0.00000001411,
	   0.00000000216,     0.00000000141,
	  -0.00000000023,    -0.00000005604,
	  -0.00000001345,    -0.00000000112,
	  -0.00000000027,     0.00000000162,
	  -0.00000005309,     0.00000000495,
	   0.00000000083,     0.00000001239,
	   0.00000000143,    -0.00000000013,
	  -0.00000000083,    -0.00000000018,
	   0.00000000020,     0.00000000065,
	   0.00000000028,     0.00000000613,
	   0.00000000145,     0.00000000002,
	   0.00000000001,    -0.00000000017,
	   0.00000000983,    -0.00000000037,
	   0.00000000005,    -0.00000000233,
	   0.00000000251,     0.00000000539,
	   0.00000000096,    -0.00000000028,
	   0.00000000405,    -0.00000000325,
	  -0.00000000054,    -0.00000000055,
	  -0.00000000421,    -0.00000009265,
	  -0.00000002200,    -0.00000000035,
	  -0.00000000014,     0.00000000259,
	  -0.00000007557,     0.00000000286,
	  -0.00000000039,     0.00000001791,
	   0.00000000211,     0.00000000012,
	  -0.00000003036,    -0.00000005832,
	  -0.00000001006,     0.00000000383,
	   0.00000000021,     0.00000000090,
	  -0.00000004906,     0.00000003537,
	   0.00000000560,     0.00000000722,
	   0.00000000046,    -0.00000000051,
	  -0.00000000089,     0.00000000023,
	   0.00000000060,     0.00000000034,
	   0.00000000411,     0.00000000677,
	   0.00000000109,    -0.00000000058,
	  -0.00000000004,    -0.00000000009,
	   0.00000001031,    -0.00000000622,
	  -0.00000000089,    -0.00000000166,
	   0.00000000368,     0.00000000351,
	   0.00000000049,    -0.00000000026,
	   0.00000000078,    -0.00000000363,
	  -0.00000005732,    -0.00000009437,
	  -0.00000001528,     0.00000000818,
	   0.00000000061,     0.00000000120,
	  -0.00000007779,     0.00000004691,
	   0.00000000670,     0.00000001253,
	   0.00000000099,    -0.00000000050,
	  -0.00000004259,    -0.00000003345,
	  -0.00000000400,     0.00000000313,
	  -0.00000001607,     0.00000004228,
	   0.00000000329,    -0.00000000011,
	  -0.00000000068,     0.00000000056,
	   0.00000000060,    -0.00000000024,
	   0.00000000601,     0.00000000356,
	   0.00000000029,    -0.00000000045,
	   0.00000000516,    -0.00000000880,
	  -0.00000000066,    -0.00000000042,
	   0.00000000202,     0.00000000184,
	  -0.00000000158,    -0.00000000002,
	  -0.00000007691,    -0.00000004553,
	  -0.00000000368,     0.00000000579,
	   0.00000000021,     0.00000000013,
	  -0.00000003808,     0.00000006484,
	   0.00000000487,     0.00000000304,
	  -0.00000001851,    -0.00000001135,
	  -0.00000000148,     0.00000000075,
	   0.00000000857,     0.00000000685,
	  -0.00000000092,    -0.00000000174,
	  -0.00000000036,     0.00000000068,
	   0.00000000015,    -0.00000000055,
	   0.00000000228,     0.00000000026,
	   0.00000000028,    -0.00000000328,
	   0.00000000080,     0.00000000160,
	  -0.00000000045,     0.00000000263,
	  -0.00000002652,    -0.00000000307,
	  -0.00000000214,     0.00000002296,
	   0.00000000115,    -0.00000001190,
	  -0.00000000001,     0.00000000145,
	  -0.00000000105,    -0.00000001929,
	   0.00000000007,    -0.00000000087,
	  -0.00000000010,     0.00000000060,
	  -0.00000000030,    -0.00000000031,
	  -0.00000000153,     0.00000000101,
	   0.00000000132,     0.00000000202,
	   0.00000000092,    -0.00000000015,
	  -0.00000000029,     0.00000000074,
	   0.00000001597,    -0.00000001061,
	   0.00000000070,     0.00000000120,
	  -0.00000000976,    -0.00000001492,
	   0.00000000109,    -0.00000000063,
	  -0.00000000491,     0.00000000202,
	  -0.00000000040,    -0.00000000017,
	   0.00000000271,    -0.00000000294,
	  -0.00000000016,     0.00000000043,
	  -0.00000000041,     0.00000000015,
	  -0.00000000041,    -0.00000000016,
	  -0.00000000044,     0.00000000034,
	  -0.00000000029,    -0.00000000046,
	  -0.00000000110,     0.00000000317,
	  -0.00000000056,    -0.00000000020,
	   0.00000000313,     0.00000000122,
	  -0.00000000021,     0.00000000058,
	   0.00000000184,    -0.00000000159,
	   0.00000000105,     0.00000000199,
	  -0.00000000093,    -0.00000000033,
	  -0.00000000033,     0.00000000074,
	   0.00000000095,    -0.00000000260,
	  -0.00000000204,    -0.00000000093,
	  -0.00000000044,     0.00000000081,
	   0.00000000693,     0.00000000249,
	   0.00000000244,    -0.00000000542,
	  -0.00000000215,    -0.00000000115,
	  -0.00000000061,    -0.00000000424,
	  -0.00000000315,     0.00000000020,
	   0.00000000000,     0.00000000114,
	  -0.00000000417,     0.00000000070,
	   0.00000000029,     0.00000000310,
	   0.00000000112,    -0.00000000004,
	  -0.00000000099,     0.00000000015,
	   0.00000000005,     0.00000000073,
	  -0.00000000032,    -0.00000000043,
	  -0.00000000041,     0.00000000033,
	   0.00000000062,     0.00000000396,
	   0.00000000291,    -0.00000000023,
	  -0.00000000002,    -0.00000000106,
	   0.00000000773,    -0.00000000115,
	  -0.00000000041,    -0.00000000575,
	  -0.00000000209,     0.00000000001,
	   0.00000000351,     0.00000000466,
	   0.00000000320,    -0.00000000204,
	  -0.00000000059,    -0.00000000107,
	   0.00000000449,    -0.00000000359,
	  -0.00000000212,    -0.00000000307,
	  -0.00000000101,     0.00000000062,
	  -0.00000000055,     0.00000000042,
	   0.00000000024,     0.00000000038,
	  -0.00000000055,    -0.00000000025,
	  -0.00000000022,     0.00000000055,
	   0.00000000301,     0.00000000388,
	   0.00000000264,    -0.00000000175,
	  -0.00000000051,    -0.00000000088,
	   0.00000000439,    -0.00000000332,
	  -0.00000000195,    -0.00000000301,
	  -0.00000000100,     0.00000000056,
	   0.00000000607,     0.00000000273,
	   0.00000000180,    -0.00000000331,
	  -0.00000000089,    -0.00000000056,
	   0.00000000247,    -0.00000000605,
	  -0.00000000331,    -0.00000000161,
	  -0.00000000049,     0.00000000089,
	  -0.00000000042,    -0.00000000018,
	  -0.00000000012,     0.00000000023,
	  -0.00000000040,     0.00000000091,
	   0.00000000050,     0.00000000026,
	  -0.00000000097,     0.00000000007,
	   0.00000000012,     0.00000000094,
	   0.00000000791,     0.00000000339,
	   0.00000000223,    -0.00000000431,
	  -0.00000000116,    -0.00000000069,
	   0.00000000322,    -0.00000000724,
	  -0.00000000396,    -0.00000000211,
	  -0.00000000065,     0.00000000107,
	   0.00000001067,    -0.00000000085,
	  -0.00000000002,    -0.00000000517,
	  -0.00000000123,    -0.00000000007,
	  -0.00000000128,    -0.00000001038,
	  -0.00000000500,     0.00000000031,
	   0.00000000002,     0.00000000118,
	  -0.00000000088,     0.00000000009,
	   0.00000000001,     0.00000000043,
	   0.00000000015,     0.00000000168,
	   0.00000000081,    -0.00000000001,
	  -0.00000000137,     0.00000000087,
	   0.00000000031,     0.00000000057,
	   0.00000000094,     0.00000000124,
	   0.00000000051,    -0.00000000034,
	   0.00000001589,    -0.00000000161,
	  -0.00000000024,    -0.00000000767,
	  -0.00000000182,    -0.00000000004,
	  -0.00000000117,    -0.00000001337,
	  -0.00000000647,     0.00000000012,
	  -0.00000000005,     0.00000000154,
	   0.00000001499,    -0.00000000982,
	  -0.00000000346,    -0.00000000629,
	  -0.00000000129,     0.00000000061,
	  -0.00000001032,    -0.00000001400,
	  -0.00000000576,     0.00000000378,
	   0.00000000070,     0.00000000115,
	  -0.00000000139,     0.00000000097,
	   0.00000000035,     0.00000000058,
	   0.00000000012,    -0.00000000006,
	   0.00000000164,     0.00000000243,
	   0.00000000101,    -0.00000000059,
	  -0.00000000125,     0.00000000222,
	   0.00000000068,     0.00000000046,
	   0.00000000221,     0.00000000094,
	   0.00000000032,    -0.00000000068,
	   0.00000002358,    -0.00000001635,
	  -0.00000000589,    -0.00000000982,
	  -0.00000000199,     0.00000000106,
	  -0.00000001293,    -0.00000001913,
	  -0.00000000796,     0.00000000465,
	   0.00000000084,     0.00000000162,
	   0.00000001342,    -0.00000002487,
	  -0.00000000759,    -0.00000000493,
	  -0.00000000087,     0.00000000116,
	  -0.00000002475,    -0.00000001107,
	  -0.00000000380,     0.00000000761,
	   0.00000000118,     0.00000000060,
	  -0.00000000036,    -0.00000000031,
	  -0.00000000132,     0.00000000266,
	   0.00000000081,     0.00000000047,
	   0.00000000008,    -0.00000000012,
	   0.00000000426,     0.00000000217,
	   0.00000000077,    -0.00000000131,
	  -0.00000000013,     0.00000000352,
	   0.00000000085,     0.00000000012,
	   0.00000000317,    -0.00000000043,
	  -0.00000000010,    -0.00000000073,
	   0.00000002089,    -0.00000004217,
	  -0.00000001291,    -0.00000000746,
	  -0.00000000126,     0.00000000198,
	  -0.00000003320,    -0.00000001685,
	  -0.00000000600,     0.00000001018,
	   0.00000000156,     0.00000000101,
	   0.00000000028,    -0.00000003903,
	  -0.00000000938,    -0.00000000093,
	  -0.00000000021,     0.00000000113,
	  -0.00000003652,     0.00000000370,
	   0.00000000072,     0.00000000848,
	   0.00000000097,    -0.00000000012,
	  -0.00000000056,    -0.00000000013,
	   0.00000000016,     0.00000000042,
	   0.00000000019,     0.00000000448,
	   0.00000000106,     0.00000000002,
	   0.00000000001,    -0.00000000012,
	   0.00000000685,    -0.00000000025,
	   0.00000000004,    -0.00000000162,
	   0.00000000155,     0.00000000362,
	   0.00000000066,    -0.00000000016,
	   0.00000000250,    -0.00000000215,
	  -0.00000000037,    -0.00000000032,
	  -0.00000000284,    -0.00000006628,
	  -0.00000001571,    -0.00000000027,
	  -0.00000000010,     0.00000000184,
	  -0.00000005252,     0.00000000190,
	  -0.00000000027,     0.00000001242,
	   0.00000000146,     0.00000000008,
	  -0.00000001919,    -0.00000003874,
	  -0.00000000675,     0.00000000234,
	   0.00000000011,     0.00000000061,
	  -0.00000003123,     0.00000002323,
	   0.00000000376,     0.00000000445,
	   0.00000000026,    -0.00000000035,
	  -0.00000000061,     0.00000000014,
	   0.00000000042,     0.00000000019,
	   0.00000000276,     0.00000000460,
	   0.00000000074,    -0.00000000039,
	   0.00000000674,    -0.00000000404,
	  -0.00000000058,    -0.00000000108,
	   0.00000000214,     0.00000000234,
	   0.00000000035,    -0.00000000015,
	   0.00000000021,    -0.00000000210,
	  -0.00000003800,    -0.00000006326,
	  -0.00000001019,     0.00000000544,
	   0.00000000041,     0.00000000080,
	  -0.00000005082,     0.00000003039,
	   0.00000000435,     0.00000000815,
	   0.00000000064,    -0.00000000033,
	  -0.00000002490,    -0.00000002141,
	  -0.00000000270,     0.00000000181,
	  -0.00000000816,     0.00000002465,
	   0.00000000193,    -0.00000000044,
	  -0.00000000047,     0.00000000036,
	   0.00000000038,    -0.00000000019,
	   0.00000000364,     0.00000000221,
	   0.00000000017,    -0.00000000027,
	   0.00000000309,    -0.00000000518,
	  -0.00000000039,    -0.00000000024,
	   0.00000000110,     0.00000000132,
	  -0.00000000113,     0.00000000033,
	  -0.00000004618,    -0.00000002799,
	  -0.00000000221,     0.00000000347,
	   0.00000000012,     0.00000000008,
	  -0.00000002280,     0.00000003805,
	   0.00000000285,     0.00000000178,
	  -0.00000000912,    -0.00000000805,
	  -0.00000000105,     0.00000000052,
	   0.00000000602,     0.00000000093,
	  -0.00000000065,    -0.00000000122,
	  -0.00000000025,     0.00000000044,
	   0.00000000101,     0.00000000019,
	   0.00000000021,    -0.00000000144,
	   0.00000000052,     0.00000000102,
	  -0.00000000031,     0.00000000167,
	  -0.00000001176,    -0.00000000223,
	  -0.00000000156,     0.00000000984,
	   0.00000000075,    -0.00000000754,
	  -0.00000000002,     0.00000000092,
	  -0.00000000056,    -0.00000001222,
	   0.00000000005,    -0.00000000054,
	  -0.00000000100,     0.00000000065,
	   0.00000000084,     0.00000000130,
	   0.00000000048,    -0.00000000011,
	  -0.00000000022,     0.00000000034,
	   0.00000001054,    -0.00000000685,
	   0.00000000044,     0.00000000079,
	  -0.00000000616,    -0.00000000957,
	   0.00000000070,    -0.00000000038,
	  -0.00000000269,     0.00000000152,
	   0.00000000205,    -0.00000000119,
	  -0.00000000030,     0.00000000023,
	  -0.00000000090,     0.00000000251,
	  -0.00000000043,    -0.00000000016,
	   0.00000000241,     0.00000000095,
	  -0.00000000016,     0.00000000043,
	   0.00000000126,    -0.00000000113,
	   0.00000000065,     0.00000000138,
	   0.00000000057,    -0.00000000049,
	  -0.00000000040,    -0.00000000055,
	  -0.00000000026,     0.00000000016,
	   0.00000000089,     0.00000000101,
	   0.00000000097,    -0.00000000073,
	  -0.00000000029,    -0.00000000045,
	   0.00000000041,    -0.00000000109,
	  -0.00000000086,    -0.00000000041,
	  -0.00000000109,    -0.00000000038,
	  -0.00000000038,     0.00000000086,
	  -0.00000000049,    -0.00000000018,
	  -0.00000000018,     0.00000000039,
	  -0.00000000063,     0.00000000172,
	   0.00000000136,     0.00000000062,
	   0.00000000029,    -0.00000000053,
	   0.00000000385,     0.00000000143,
	   0.00000000142,    -0.00000000305,
	  -0.00000000119,    -0.00000000065,
	   0.00000000038,     0.00000000267,
	   0.00000000197,    -0.00000000012,
	   0.00000000000,    -0.00000000072,
	   0.00000000262,    -0.00000000045,
	  -0.00000000019,    -0.00000000193,
	  -0.00000000070,     0.00000000003,
	   0.00000000031,     0.00000000201,
	   0.00000000148,    -0.00000000012,
	  -0.00000000001,    -0.00000000054,
	   0.00000000232,    -0.00000000033,
	  -0.00000000012,    -0.00000000172,
	  -0.00000000062,     0.00000000000,
	   0.00000000168,     0.00000000224,
	   0.00000000153,    -0.00000000098,
	  -0.00000000028,    -0.00000000051,
	   0.00000000215,    -0.00000000173,
	  -0.00000000102,    -0.00000000146,
	  -0.00000000048,     0.00000000030,
	  -0.00000000033,     0.00000000025,
	  -0.00000000038,    -0.00000000017,
	  -0.00000000015,     0.00000000037,
	   0.00000000217,     0.00000000280,
	   0.00000000191,    -0.00000000127,
	  -0.00000000037,    -0.00000000063,
	   0.00000000261,    -0.00000000197,
	  -0.00000000115,    -0.00000000179,
	  -0.00000000059,     0.00000000033,
	   0.00000000414,     0.00000000187,
	   0.00000000123,    -0.00000000225,
	  -0.00000000060,    -0.00000000038,
	   0.00000000167,    -0.00000000412,
	  -0.00000000225,    -0.00000000108,
	  -0.00000000033,     0.00000000061,
	  -0.00000000009,     0.00000000018,
	  -0.00000000029,     0.00000000064,
	   0.00000000035,     0.00000000019,
	  -0.00000000071,     0.00000000005,
	   0.00000000009,     0.00000000068,
	   0.00000000618,     0.00000000265,
	   0.00000000173,    -0.00000000336,
	  -0.00000000091,    -0.00000000053,
	   0.00000000228,    -0.00000000513,
	  -0.00000000280,    -0.00000000149,
	  -0.00000000046,     0.00000000075,
	   0.00000000788,    -0.00000000060,
	   0.00000000000,    -0.00000000381,
	  -0.00000000091,    -0.00000000006,
	  -0.00000000097,    -0.00000000763,
	  -0.00000000366,     0.00000000025,
	   0.00000000002,     0.00000000087,
	  -0.00000000072,     0.00000000007,
	   0.00000000001,     0.00000000035,
	   0.00000000011,     0.00000000126,
	   0.00000000061,    -0.00000000001,
	  -0.00000000102,     0.00000000064,
	   0.00000000022,     0.00000000043,
	   0.00000000070,     0.00000000091,
	   0.00000000037,    -0.00000000026,
	   0.00000001258,    -0.00000000126,
	  -0.00000000019,    -0.00000000606,
	  -0.00000000144,    -0.00000000003,
	  -0.00000000087,    -0.00000000998,
	  -0.00000000482,     0.00000000009,
	  -0.00000000004,     0.00000000114,
	   0.00000001120,    -0.00000000725,
	  -0.00000000255,    -0.00000000470,
	  -0.00000000097,     0.00000000045,
	  -0.00000000768,    -0.00000001033,
	  -0.00000000422,     0.00000000282,
	   0.00000000053,     0.00000000084,
	  -0.00000000111,     0.00000000077,
	   0.00000000028,     0.00000000046,
	   0.00000000009,    -0.00000000005,
	   0.00000000123,     0.00000000182,
	   0.00000000075,    -0.00000000044,
	  -0.00000000093,     0.00000000160,
	   0.00000000049,     0.00000000035,
	   0.00000000159,     0.00000000065,
	   0.00000000021,    -0.00000000049,
	   0.00000001833,    -0.00000001268,
	  -0.00000000455,    -0.00000000760,
	  -0.00000000154,     0.00000000082,
	  -0.00000000964,    -0.00000001429,
	  -0.00000000593,     0.00000000347,
	   0.00000000063,     0.00000000120,
	   0.00000000991,    -0.00000001800,
	  -0.00000000549,    -0.00000000364,
	  -0.00000000065,     0.00000000084,
	  -0.00000001789,    -0.00000000788,
	  -0.00000000267,     0.00000000550,
	   0.00000000085,     0.00000000042,
	  -0.00000000101,     0.00000000203,
	   0.00000000062,     0.00000000036,
	   0.00000000006,    -0.00000000010,
	   0.00000000310,     0.00000000158,
	   0.00000000056,    -0.00000000095,
	  -0.00000000014,     0.00000000245,
	   0.00000000060,     0.00000000011,
	   0.00000000215,    -0.00000000033,
	  -0.00000000009,    -0.00000000049,
	   0.00000001569,    -0.00000003151,
	  -0.00000000963,    -0.00000000558,
	  -0.00000000094,     0.00000000148,
	  -0.00000002411,    -0.00000001228,
	  -0.00000000435,     0.00000000739,
	   0.00000000113,     0.00000000073,
	   0.00000000056,    -0.00000002717,
	  -0.00000000654,    -0.00000000076,
	  -0.00000000017,     0.00000000079,
	  -0.00000002506,     0.00000000276,
	   0.00000000061,     0.00000000578,
	   0.00000000065,    -0.00000000011,
	   0.00000000013,     0.00000000324,
	   0.00000000076,     0.00000000001,
	   0.00000000476,    -0.00000000016,
	   0.00000000003,    -0.00000000112,
	   0.00000000093,     0.00000000243,
	   0.00000000045,    -0.00000000008,
	   0.00000000152,    -0.00000000142,
	  -0.00000000185,    -0.00000004705,
	  -0.00000001112,    -0.00000000020,
	  -0.00000000007,     0.00000000130,
	  -0.00000003641,     0.00000000123,
	  -0.00000000019,     0.00000000859,
	   0.00000000101,     0.00000000005,
	  -0.00000001198,    -0.00000002566,
	  -0.00000000453,     0.00000000140,
	  -0.00000001968,     0.00000001518,
	   0.00000000252,     0.00000000270,
	  -0.00000000041,     0.00000000009,
	   0.00000000183,     0.00000000309,
	   0.00000000049,    -0.00000000026,
	   0.00000000439,    -0.00000000260,
	  -0.00000000037,    -0.00000000070,
	   0.00000000122,     0.00000000156,
	  -0.00000000006,    -0.00000000120,
	  -0.00000002487,    -0.00000004196,
	  -0.00000000672,     0.00000000355,
	   0.00000000027,     0.00000000052,
	  -0.00000003301,     0.00000001953,
	   0.00000000280,     0.00000000527,
	   0.00000000041,    -0.00000000021,
	  -0.00000001432,    -0.00000001369,
	  -0.00000000182,     0.00000000103,
	  -0.00000000379,     0.00000001414,
	   0.00000000111,    -0.00000000052,
	  -0.00000000032,     0.00000000024,
	   0.00000000216,     0.00000000135,
	   0.00000000010,    -0.00000000016,
	   0.00000000184,    -0.00000000300,
	   0.00000000059,     0.00000000093,
	  -0.00000000080,     0.00000000041,
	  -0.00000002723,    -0.00000001700,
	  -0.00000000131,     0.00000000204,
	  -0.00000001352,     0.00000002199,
	   0.00000000164,     0.00000000103,
	  -0.00000000424,    -0.00000000559,
	  -0.00000000073,     0.00000000036,
	   0.00000000417,    -0.00000000139,
	  -0.00000000045,    -0.00000000084,
	   0.00000000038,     0.00000000013,
	   0.00000000015,    -0.00000000054,
	   0.00000000032,     0.00000000064,
	  -0.00000000021,     0.00000000103,
	  -0.00000000436,    -0.00000000156,
	  -0.00000000110,     0.00000000349,
	   0.00000000049,    -0.00000000468,
	  -0.00000000002,     0.00000000057,
	  -0.00000000026,    -0.00000000759,
	  -0.00000000064,     0.00000000040,
	   0.00000000052,     0.00000000082,
	   0.00000000680,    -0.00000000430,
	   0.00000000027,     0.00000000051,
	  -0.00000000379,    -0.00000000601,
	   0.00000000044,    -0.00000000023,
	  -0.00000000141,     0.00000000112,
	   0.00000000150,    -0.00000000031,
	  -0.00000000070,     0.00000000192,
	  -0.00000000033,    -0.00000000012,
	   0.00000000179,     0.00000000071,
	   0.00000000083,    -0.00000000078,
	   0.00000000037,     0.00000000093,
	  -0.00000000066,     0.00000000057,
	   0.00000000047,     0.00000000063,
	   0.00000000029,    -0.00000000019,
	   0.00000000153,     0.00000000178,
	   0.00000000171,    -0.00000000125,
	  -0.00000000051,    -0.00000000080,
	  -0.00000000046,     0.00000000121,
	   0.00000000096,     0.00000000046,
	   0.00000000021,    -0.00000000037,
	   0.00000000121,     0.00000000042,
	   0.00000000041,    -0.00000000095,
	  -0.00000000037,    -0.00000000019,
	  -0.00000000029,     0.00000000079,
	   0.00000000062,     0.00000000028,
	   0.00000000013,    -0.00000000024,
	   0.00000000094,     0.00000000036,
	   0.00000000035,    -0.00000000074,
	   0.00000000016,     0.00000000117,
	   0.00000000086,    -0.00000000005,
	   0.00000000114,    -0.00000000020,
	  -0.00000000009,    -0.00000000084,
	   0.00000000022,     0.00000000143,
	   0.00000000105,    -0.00000000008,
	  -0.00000000001,    -0.00000000038,
	   0.00000000134,    -0.00000000019,
	  -0.00000000007,    -0.00000000099,
	   0.00000000113,     0.00000000152,
	   0.00000000104,    -0.00000000066,
	  -0.00000000019,    -0.00000000035,
	   0.00000000145,    -0.00000000117,
	  -0.00000000069,    -0.00000000098,
	  -0.00000000032,     0.00000000020,
	   0.00000000171,     0.00000000221,
	   0.00000000150,    -0.00000000100,
	  -0.00000000029,    -0.00000000049,
	   0.00000000185,    -0.00000000139,
	  -0.00000000081,    -0.00000000126,
	  -0.00000000042,     0.00000000024,
	   0.00000000309,     0.00000000141,
	   0.00000000093,    -0.00000000168,
	  -0.00000000045,    -0.00000000029,
	   0.00000000123,    -0.00000000307,
	  -0.00000000167,    -0.00000000079,
	  -0.00000000024,     0.00000000045,
	  -0.00000000022,     0.00000000048,
	  -0.00000000054,     0.00000000003,
	   0.00000000007,     0.00000000052,
	   0.00000000498,     0.00000000214,
	   0.00000000139,    -0.00000000270,
	  -0.00000000073,    -0.00000000043,
	   0.00000000173,    -0.00000000388,
	  -0.00000000211,    -0.00000000112,
	  -0.00000000034,     0.00000000057,
	   0.00000000601,    -0.00000000043,
	   0.00000000002,    -0.00000000290,
	  -0.00000000069,    -0.00000000005,
	  -0.00000000076,    -0.00000000579,
	  -0.00000000277,     0.00000000021,
	   0.00000000002,     0.00000000065,
	  -0.00000000059,     0.00000000006,
	   0.00000000001,     0.00000000028,
	   0.00000000008,     0.00000000096,
	  -0.00000000077,     0.00000000047,
	   0.00000000016,     0.00000000033,
	   0.00000000052,     0.00000000067,
	   0.00000001003,    -0.00000000100,
	  -0.00000000015,    -0.00000000482,
	  -0.00000000114,    -0.00000000002,
	  -0.00000000066,    -0.00000000764,
	  -0.00000000368,     0.00000000007,
	  -0.00000000003,     0.00000000087,
	   0.00000000846,    -0.00000000540,
	  -0.00000000189,    -0.00000000355,
	  -0.00000000073,     0.00000000033,
	  -0.00000000577,    -0.00000000769,
	  -0.00000000313,     0.00000000213,
	   0.00000000040,     0.00000000062,
	  -0.00000000088,     0.00000000061,
	   0.00000000022,     0.00000000037,
	   0.00000000092,     0.00000000137,
	   0.00000000057,    -0.00000000033,
	  -0.00000000069,     0.00000000116,
	   0.00000000035,     0.00000000026,
	   0.00000000114,     0.00000000045,
	   0.00000000014,    -0.00000000035,
	   0.00000001421,    -0.00000000980,
	  -0.00000000351,    -0.00000000588,
	  -0.00000000119,     0.00000000064,
	  -0.00000000725,    -0.00000001076,
	  -0.00000000445,     0.00000000260,
	   0.00000000047,     0.00000000090,
	   0.00000000734,    -0.00000001303,
	  -0.00000000397,    -0.00000000270,
	  -0.00000000048,     0.00000000060,
	  -0.00000001293,    -0.00000000560,
	  -0.00000000186,     0.00000000397,
	   0.00000000061,     0.00000000028,
	  -0.00000000077,     0.00000000154,
	   0.00000000047,     0.00000000027,
	   0.00000000226,     0.00000000115,
	   0.00000000041,    -0.00000000069,
	  -0.00000000014,     0.00000000170,
	   0.00000000042,     0.00000000009,
	   0.00000000145,    -0.00000000026,
	   0.00000001170,    -0.00000002336,
	  -0.00000000714,    -0.00000000414,
	  -0.00000000070,     0.00000000109,
	  -0.00000001749,    -0.00000000894,
	  -0.00000000315,     0.00000000535,
	   0.00000000082,     0.00000000053,
	   0.00000000067,    -0.00000001883,
	  -0.00000000454,    -0.00000000062,
	  -0.00000000013,     0.00000000055,
	  -0.00000001709,     0.00000000206,
	   0.00000000050,     0.00000000392,
	   0.00000000044,    -0.00000000009,
	   0.00000000008,     0.00000000231,
	   0.00000000054,     0.00000000001,
	   0.00000000329,    -0.00000000010,
	   0.00000000002,    -0.00000000077,
	   0.00000000055,     0.00000000163,
	   0.00000000090,    -0.00000000094,
	  -0.00000000117,    -0.00000003305,
	  -0.00000000778,    -0.00000000016,
	  -0.00000000005,     0.00000000091,
	  -0.00000002511,     0.00000000077,
	  -0.00000000014,     0.00000000591,
	   0.00000000069,     0.00000000004,
	  -0.00000000735,    -0.00000001691,
	  -0.00000000302,     0.00000000081,
	  -0.00000001224,     0.00000000985,
	   0.00000000168,     0.00000000159,
	   0.00000000120,     0.00000000205,
	   0.00000000033,    -0.00000000017,
	   0.00000000283,    -0.00000000166,
	  -0.00000000024,    -0.00000000045,
	   0.00000000068,     0.00000000104,
	  -0.00000000017,    -0.00000000066,
	  -0.00000001606,    -0.00000002753,
	  -0.00000000438,     0.00000000230,
	   0.00000000017,     0.00000000034,
	  -0.00000002127,     0.00000001242,
	   0.00000000178,     0.00000000338,
	  -0.00000000806,    -0.00000000873,
	  -0.00000000122,     0.00000000057,
	  -0.00000000146,     0.00000000793,
	   0.00000000063,    -0.00000000050,
	   0.00000000125,     0.00000000081,
	   0.00000000108,    -0.00000000171,
	   0.00000000031,     0.00000000064,
	  -0.00000000055,     0.00000000037,
	  -0.00000001571,    -0.00000001018,
	  -0.00000000076,     0.00000000117,
	  -0.00000000792,     0.00000001247,
	   0.00000000092,     0.00000000058,
	  -0.00000000178,    -0.00000000381,
	  -0.00000000050,     0.00000000024,
	   0.00000000285,    -0.00000000202,
	  -0.00000000031,    -0.00000000056,
	   0.00000000019,     0.00000000039,
	  -0.00000000014,     0.00000000063,
	  -0.00000000089,    -0.00000000106,
	  -0.00000000074,     0.00000000062,
	   0.00000000033,    -0.00000000284,
	  -0.00000000009,    -0.00000000461,
	  -0.00000000040,     0.00000000024,
	   0.00000000031,     0.00000000050,
	   0.00000000429,    -0.00000000263,
	   0.00000000016,     0.00000000032,
	  -0.00000000228,    -0.00000000371,
	  -0.00000000071,     0.00000000080,
	   0.00000000107,     0.00000000009,
	  -0.00000000054,     0.00000000142,
	   0.00000000130,     0.00000000052,
	   0.00000000053,    -0.00000000054,
	   0.00000000020,     0.00000000062,
	   0.00000000006,     0.00000000044,
	   0.00000000021,    -0.00000000001,
	   0.00000000032,     0.00000000151,
	   0.00000000152,    -0.00000000019,
	  -0.00000000005,    -0.00000000074,
	  -0.00000000051,     0.00000000043,
	   0.00000000035,     0.00000000049,
	   0.00000000044,     0.00000000049,
	   0.00000000047,    -0.00000000036,
	   0.00000000019,     0.00000000025,
	   0.00000000012,    -0.00000000007,
	   0.00000000028,     0.00000000033,
	   0.00000000032,    -0.00000000023,
	  -0.00000000018,     0.00000000046,
	   0.00000000036,     0.00000000017,
	   0.00000000046,     0.00000000016,
	   0.00000000016,    -0.00000000036,
	   0.00000000043,     0.00000000020,
	   0.00000000009,    -0.00000000017,
	   0.00000000052,     0.00000000020,
	   0.00000000019,    -0.00000000041,
	   0.00000000011,     0.00000000078,
	   0.00000000057,    -0.00000000003,
	   0.00000000076,    -0.00000000013,
	  -0.00000000006,    -0.00000000056,
	   0.00000000018,     0.00000000113,
	   0.00000000083,    -0.00000000007,
	  -0.00000000001,    -0.00000000030,
	   0.00000000094,    -0.00000000013,
	  -0.00000000005,    -0.00000000069,
	   0.00000000085,     0.00000000115,
	   0.00000000078,    -0.00000000049,
	   0.00000000109,    -0.00000000088,
	  -0.00000000052,    -0.00000000073,
	   0.00000000140,     0.00000000180,
	   0.00000000122,    -0.00000000081,
	  -0.00000000024,    -0.00000000040,
	   0.00000000142,    -0.00000000106,
	  -0.00000000062,    -0.00000000096,
	  -0.00000000032,     0.00000000018,
	   0.00000000240,     0.00000000111,
	   0.00000000072,    -0.00000000130,
	  -0.00000000035,    -0.00000000023,
	   0.00000000095,    -0.00000000238,
	  -0.00000000129,    -0.00000000061,
	  -0.00000000018,     0.00000000035,
	  -0.00000000017,     0.00000000038,
	   0.00000000406,     0.00000000175,
	   0.00000000113,    -0.00000000220,
	  -0.00000000059,    -0.00000000035,
	   0.00000000135,    -0.00000000302,
	  -0.00000000164,    -0.00000000087,
	  -0.00000000027,     0.00000000044,
	   0.00000000465,    -0.00000000031,
	   0.00000000002,    -0.00000000224,
	  -0.00000000053,    -0.00000000004,
	  -0.00000000060,    -0.00000000445,
	  -0.00000000212,     0.00000000017,
	   0.00000000002,     0.00000000050,
	  -0.00000000048,     0.00000000005,
	   0.00000000006,     0.00000000075,
	  -0.00000000059,     0.00000000035,
	   0.00000000039,     0.00000000049,
	   0.00000000800,    -0.00000000079,
	  -0.00000000012,    -0.00000000384,
	  -0.00000000091,    -0.00000000002,
	  -0.00000000051,    -0.00000000591,
	  -0.00000000284,     0.00000000006,
	  -0.00000000002,     0.00000000067,
	   0.00000000641,    -0.00000000402,
	  -0.00000000140,    -0.00000000269,
	  -0.00000000056,     0.00000000024,
	  -0.00000000435,    -0.00000000573,
	  -0.00000000232,     0.00000000161,
	   0.00000000030,     0.00000000046,
	  -0.00000000069,     0.00000000048,
	   0.00000000017,     0.00000000029,
	   0.00000000070,     0.00000000103,
	   0.00000000043,    -0.00000000025,
	  -0.00000000052,     0.00000000083,
	   0.00000000082,     0.00000000031,
	   0.00000001096,    -0.00000000752,
	  -0.00000000270,    -0.00000000452,
	  -0.00000000092,     0.00000000049,
	  -0.00000000545,    -0.00000000811,
	  -0.00000000335,     0.00000000196,
	   0.00000000035,     0.00000000068,
	   0.00000000542,    -0.00000000939,
	  -0.00000000285,    -0.00000000200,
	  -0.00000000036,     0.00000000043,
	  -0.00000000930,    -0.00000000395,
	  -0.00000000129,     0.00000000286,
	   0.00000000044,     0.00000000019,
	  -0.00000000058,     0.00000000115,
	   0.00000000035,     0.00000000020,
	   0.00000000163,     0.00000000084,
	   0.00000000029,    -0.00000000050,
	  -0.00000000013,     0.00000000118,
	   0.00000000097,    -0.00000000020,
	   0.00000000866,    -0.00000001716,
	  -0.00000000524,    -0.00000000305,
	  -0.00000000051,     0.00000000080,
	  -0.00000001263,    -0.00000000649,
	  -0.00000000228,     0.00000000386,
	   0.00000000059,     0.00000000038,
	   0.00000000068,    -0.00000001298,
	  -0.00000000314,    -0.00000000050,
	  -0.00000000011,     0.00000000038,
	  -0.00000001156,     0.00000000152,
	   0.00000000041,     0.00000000263,
	   0.00000000005,     0.00000000163,
	   0.00000000038,     0.00000000001,
	   0.00000000225,    -0.00000000006,
	   0.00000000001,    -0.00000000053,
	   0.00000000031,     0.00000000109,
	   0.00000000052,    -0.00000000061,
	  -0.00000000070,    -0.00000002298,
	  -0.00000000540,    -0.00000000013,
	  -0.00000000004,     0.00000000063,
	  -0.00000001719,     0.00000000047,
	  -0.00000000010,     0.00000000404,
	   0.00000000047,     0.00000000003,
	  -0.00000000442,    -0.00000001107,
	  -0.00000000201,     0.00000000045,
	  -0.00000000748,     0.00000000634,
	   0.00000000112,     0.00000000091,
	   0.00000000077,     0.00000000134,
	   0.00000000021,    -0.00000000011,
	   0.00000000181,    -0.00000000104,
	   0.00000000037,     0.00000000069,
	  -0.00000000019,    -0.00000000036,
	  -0.00000001022,    -0.00000001786,
	  -0.00000000283,     0.00000000146,
	   0.00000000011,     0.00000000022,
	  -0.00000001358,     0.00000000780,
	   0.00000000112,     0.00000000214,
	  -0.00000000441,    -0.00000000555,
	  -0.00000000082,     0.00000000030,
	  -0.00000000029,     0.00000000433,
	   0.00000000035,    -0.00000000042,
	   0.00000000071,     0.00000000048,
	   0.00000000063,    -0.00000000095,
	   0.00000000016,     0.00000000043,
	  -0.00000000037,     0.00000000030,
	  -0.00000000883,    -0.00000000599,
	  -0.00000000043,     0.00000000065,
	  -0.00000000457,     0.00000000690,
	   0.00000000050,     0.00000000032,
	  -0.00000000059,    -0.00000000255,
	  -0.00000000034,     0.00000000016,
	   0.00000000192,    -0.00000000192,
	  -0.00000000020,    -0.00000000037,
	   0.00000000055,    -0.00000000070,
	  -0.00000000049,    -0.00000000052,
	   0.00000000022,    -0.00000000168,
	  -0.00000000001,    -0.00000000273,
	   0.00000000264,    -0.00000000156,
	  -0.00000000133,    -0.00000000224,
	  -0.00000000033,     0.00000000056,
	   0.00000000075,     0.00000000024,
	  -0.00000000040,     0.00000000103,
	   0.00000000092,     0.00000000038,
	   0.00000000033,    -0.00000000036,
	   0.00000000013,     0.00000000006,
	  -0.00000000039,     0.00000000128,
	   0.00000000134,     0.00000000053,
	   0.00000000032,    -0.00000000068,
	   0.00000000034,     0.00000000016,
	   0.00000000007,    -0.00000000013,
	   0.00000000036,     0.00000000014,
	   0.00000000008,     0.00000000059,
	   0.00000000057,    -0.00000000010,
	   0.00000000014,     0.00000000093,
	   0.00000000068,    -0.00000000006,
	  -0.00000000001,    -0.00000000025,
	   0.00000000072,    -0.00000000010,
	  -0.00000000004,    -0.00000000053,
	   0.00000000067,     0.00000000091,
	   0.00000000062,    -0.00000000039,
	   0.00000000085,    -0.00000000070,
	  -0.00000000041,    -0.00000000057,
	   0.00000000116,     0.00000000150,
	   0.00000000101,    -0.00000000067,
	  -0.00000000019,    -0.00000000033,
	   0.00000000112,    -0.00000000084,
	  -0.00000000049,    -0.00000000076,
	   0.00000000189,     0.00000000088,
	   0.00000000058,    -0.00000000102,
	   0.00000000074,    -0.00000000188,
	  -0.00000000102,    -0.00000000047,
	   0.00000000331,     0.00000000143,
	   0.00000000092,    -0.00000000179,
	  -0.00000000048,    -0.00000000028,
	   0.00000000107,    -0.00000000239,
	  -0.00000000130,    -0.00000000069,
	  -0.00000000021,     0.00000000035,
	   0.00000000361,    -0.00000000022,
	   0.00000000003,    -0.00000000174,
	  -0.00000000047,    -0.00000000343,
	  -0.00000000163,     0.00000000014,
	   0.00000000005,     0.00000000058,
	  -0.00000000044,     0.00000000026,
	   0.00000000030,     0.00000000036,
	   0.00000000634,    -0.00000000061,
	  -0.00000000009,    -0.00000000304,
	  -0.00000000072,    -0.00000000001,
	  -0.00000000039,    -0.00000000458,
	  -0.00000000220,     0.00000000004,
	  -0.00000000002,     0.00000000052,
	   0.00000000484,    -0.00000000298,
	  -0.00000000103,    -0.00000000203,
	  -0.00000000042,     0.00000000018,
	  -0.00000000326,    -0.00000000426,
	  -0.00000000172,     0.00000000121,
	   0.00000000023,     0.00000000034,
	  -0.00000000054,     0.00000000037,
	   0.00000000013,     0.00000000022,
	   0.00000000052,     0.00000000078,
	   0.00000000032,    -0.00000000019,
	  -0.00000000039,     0.00000000059,
	   0.00000000058,     0.00000000021,
	   0.00000000838,    -0.00000000573,
	  -0.00000000205,    -0.00000000345,
	  -0.00000000070,     0.00000000037,
	  -0.00000000408,    -0.00000000609,
	  -0.00000000251,     0.00000000146,
	   0.00000000027,     0.00000000051,
	   0.00000000399,    -0.00000000672,
	  -0.00000000204,    -0.00000000147,
	  -0.00000000027,     0.00000000031,
	  -0.00000000665,    -0.00000000277,
	  -0.00000000089,     0.00000000204,
	  -0.00000000043,     0.00000000085,
	   0.00000000026,     0.00000000015,
	   0.00000000117,     0.00000000061,
	   0.00000000021,    -0.00000000036,
	  -0.00000000011,     0.00000000081,
	   0.00000000064,    -0.00000000015,
	   0.00000000636,    -0.00000001249,
	  -0.00000000381,    -0.00000000223,
	  -0.00000000037,     0.00000000058,
	  -0.00000000906,    -0.00000000468,
	  -0.00000000164,     0.00000000277,
	   0.00000000042,     0.00000000027,
	   0.00000000064,    -0.00000000887,
	  -0.00000000215,    -0.00000000040,
	  -0.00000000775,     0.00000000112,
	   0.00000000032,     0.00000000175,
	   0.00000000003,     0.00000000113,
	   0.00000000027,     0.00000000001,
	   0.00000000153,    -0.00000000004,
	   0.00000000017,     0.00000000072,
	   0.00000000029,    -0.00000000040,
	  -0.00000000040,    -0.00000001581,
	  -0.00000000371,    -0.00000000010,
	  -0.00000000003,     0.00000000043,
	  -0.00000001167,     0.00000000026,
	  -0.00000000008,     0.00000000274,
	  -0.00000000258,    -0.00000000720,
	  -0.00000000133,     0.00000000023,
	  -0.00000000449,     0.00000000404,
	   0.00000000074,     0.00000000050,
	   0.00000000049,     0.00000000087,
	   0.00000000115,    -0.00000000065,
	   0.00000000019,     0.00000000046,
	  -0.00000000640,    -0.00000001144,
	  -0.00000000180,     0.00000000092,
	   0.00000000007,     0.00000000014,
	  -0.00000000858,     0.00000000483,
	   0.00000000070,     0.00000000134,
	  -0.00000000232,    -0.00000000351,
	  -0.00000000054,     0.00000000015,
	   0.00000000024,     0.00000000228,
	   0.00000000019,    -0.00000000034,
	   0.00000000039,     0.00000000028,
	   0.00000000036,    -0.00000000051,
	  -0.00000000479,    -0.00000000346,
	  -0.00000000024,     0.00000000035,
	  -0.00000000259,     0.00000000369,
	  -0.00000000006,    -0.00000000168,
	   0.00000000128,    -0.00000000157,
	   0.00000000100,    -0.00000000045,
	  -0.00000000031,    -0.00000000085,
	   0.00000000014,    -0.00000000097,
	   0.00000000003,    -0.00000000158,
	   0.00000000159,    -0.00000000089,
	  -0.00000000075,    -0.00000000132,
	  -0.00000000013,     0.00000000039,
	   0.00000000051,     0.00000000026,
	  -0.00000000029,     0.00000000073,
	   0.00000000064,     0.00000000027,
	  -0.00000000024,    -0.00000000028,
	   0.00000000009,     0.00000000012,
	  -0.00000000178,     0.00000000172,
	   0.00000000170,     0.00000000210,
	   0.00000000130,    -0.00000000097,
	   0.00000000028,     0.00000000013,
	   0.00000000006,     0.00000000047,
	   0.00000000046,    -0.00000000008,
	   0.00000000012,     0.00000000079,
	   0.00000000057,    -0.00000000005,
	   0.00000000000,    -0.00000000021,
	   0.00000000058,    -0.00000000008,
	   0.00000000054,     0.00000000074,
	   0.00000000050,    -0.00000000031,
	   0.00000000068,    -0.00000000056,
	  -0.00000000033,    -0.00000000046,
	   0.00000000096,     0.00000000124,
	   0.00000000084,    -0.00000000056,
	  -0.00000000016,    -0.00000000028,
	   0.00000000090,    -0.00000000068,
	  -0.00000000039,    -0.00000000061,
	   0.00000000150,     0.00000000071,
	   0.00000000046,    -0.00000000081,
	   0.00000000058,    -0.00000000149,
	  -0.00000000081,    -0.00000000037,
	   0.00000000269,     0.00000000117,
	   0.00000000075,    -0.00000000145,
	  -0.00000000039,    -0.00000000023,
	   0.00000000085,    -0.00000000190,
	  -0.00000000103,    -0.00000000055,
	   0.00000000280,    -0.00000000015,
	   0.00000000003,    -0.00000000135,
	  -0.00000000038,    -0.00000000264,
	  -0.00000000125,     0.00000000012,
	  -0.00000000034,     0.00000000019,
	   0.00000000500,    -0.00000000047,
	  -0.00000000007,    -0.00000000239,
	  -0.00000000057,    -0.00000000001,
	  -0.00000000030,    -0.00000000354,
	  -0.00000000170,     0.00000000003,
	   0.00000000364,    -0.00000000220,
	  -0.00000000076,    -0.00000000153,
	  -0.00000000244,    -0.00000000315,
	  -0.00000000126,     0.00000000091,
	  -0.00000000042,     0.00000000028,
	   0.00000000010,     0.00000000017,
	   0.00000000039,     0.00000000058,
	  -0.00000000029,     0.00000000042,
	   0.00000000041,     0.00000000014,
	   0.00000000636,    -0.00000000432,
	  -0.00000000155,    -0.00000000261,
	  -0.00000000053,     0.00000000028,
	  -0.00000000303,    -0.00000000455,
	  -0.00000000187,     0.00000000109,
	   0.00000000020,     0.00000000038,
	   0.00000000292,    -0.00000000478,
	  -0.00000000145,    -0.00000000108,
	  -0.00000000472,    -0.00000000192,
	  -0.00000000060,     0.00000000145,
	  -0.00000000032,     0.00000000062,
	   0.00000000019,     0.00000000011,
	   0.00000000084,     0.00000000044,
	  -0.00000000010,     0.00000000055,
	   0.00000000042,    -0.00000000012,
	   0.00000000462,    -0.00000000899,
	  -0.00000000274,    -0.00000000161,
	  -0.00000000027,     0.00000000042,
	  -0.00000000645,    -0.00000000336,
	  -0.00000000117,     0.00000000197,
	   0.00000000030,     0.00000000019,
	   0.00000000056,    -0.00000000602,
	  -0.00000000146,    -0.00000000031,
	  -0.00000000513,     0.00000000082,
	   0.00000000025,     0.00000000115,
	   0.00000000001,     0.00000000078,
	   0.00000000103,    -0.00000000002,
	   0.00000000008,     0.00000000048,
	  -0.00000000020,    -0.00000001076,
	  -0.00000000252,    -0.00000000008,
	  -0.00000000002,     0.00000000029,
	  -0.00000000785,     0.00000000013,
	  -0.00000000006,     0.00000000184,
	  -0.00000000146,    -0.00000000465,
	  -0.00000000087,     0.00000000010,
	  -0.00000000262,     0.00000000255,
	   0.00000000048,     0.00000000025,
	   0.00000000030,     0.00000000055,
	   0.00000000072,    -0.00000000040,
	  -0.00000000393,    -0.00000000724,
	  -0.00000000113,     0.00000000057,
	  -0.00000000536,     0.00000000294,
	   0.00000000042,     0.00000000083,
	  -0.00000000115,    -0.00000000221,
	   0.00000000042,     0.00000000113,
	  -0.00000000248,    -0.00000000195,
	  -0.00000000143,     0.00000000189,
	   0.00000000014,    -0.00000000109,
	   0.00000000084,    -0.00000000118,
	   0.00000000101,    -0.00000000028,
	  -0.00000000019,    -0.00000000083,
	   0.00000000009,    -0.00000000054,
	   0.00000000004,    -0.00000000088,
	   0.00000000093,    -0.00000000049,
	  -0.00000000041,    -0.00000000076,
	   0.00000000034,     0.00000000023,
	   0.00000000043,     0.00000000019,
	   0.00000000140,    -0.00000000038,
	  -0.00000000033,    -0.00000000176,
	  -0.00000000101,     0.00000000014,
	   0.00000000036,    -0.00000000007,
	  -0.00000000003,    -0.00000000021,
	  -0.00000001026,     0.00000000278,
	   0.00000000237,     0.00000001278,
	   0.00000000789,    -0.00000000105,
	   0.00000000031,     0.00000000033,
	   0.00000000037,    -0.00000000031,
	   0.00000000032,    -0.00000000032,
	  -0.00000000031,    -0.00000000037,
	   0.00000000010,     0.00000000066,
	   0.00000000048,    -0.00000000004,
	   0.00000000047,    -0.00000000007,
	   0.00000000043,     0.00000000060,
	   0.00000000040,    -0.00000000025,
	   0.00000000055,    -0.00000000045,
	  -0.00000000027,    -0.00000000037,
	   0.00000000080,     0.00000000103,
	   0.00000000069,    -0.00000000046,
	  -0.00000000013,    -0.00000000023,
	   0.00000000073,    -0.00000000055,
	  -0.00000000032,    -0.00000000049,
	   0.00000000119,     0.00000000057,
	   0.00000000037,    -0.00000000064,
	   0.00000000045,    -0.00000000117,
	  -0.00000000064,    -0.00000000029,
	   0.00000000217,     0.00000000095,
	   0.00000000061,    -0.00000000117,
	  -0.00000000031,    -0.00000000018,
	   0.00000000068,    -0.00000000151,
	  -0.00000000081,    -0.00000000043,
	   0.00000000216,    -0.00000000010,
	   0.00000000003,    -0.00000000104,
	  -0.00000000030,    -0.00000000202,
	  -0.00000000096,     0.00000000010,
	   0.00000000390,    -0.00000000036,
	  -0.00000000005,    -0.00000000186,
	  -0.00000000044,    -0.00000000001,
	  -0.00000000022,    -0.00000000273,
	  -0.00000000130,     0.00000000003,
	   0.00000000272,    -0.00000000161,
	  -0.00000000055,    -0.00000000114,
	  -0.00000000181,    -0.00000000231,
	  -0.00000000092,     0.00000000068,
	  -0.00000000032,     0.00000000021,
	   0.00000000029,     0.00000000043,
	  -0.00000000021,     0.00000000030,
	   0.00000000478,    -0.00000000322,
	  -0.00000000115,    -0.00000000196,
	  -0.00000000039,     0.00000000021,
	  -0.00000000224,    -0.00000000338,
	  -0.00000000138,     0.00000000080,
	   0.00000000213,    -0.00000000337,
	  -0.00000000102,    -0.00000000079,
	  -0.00000000331,    -0.00000000132,
	  -0.00000000040,     0.00000000102,
	  -0.00000000023,     0.00000000045,
	   0.00000000059,     0.00000000031,
	   0.00000000333,    -0.00000000641,
	  -0.00000000195,    -0.00000000116,
	  -0.00000000019,     0.00000000030,
	  -0.00000000455,    -0.00000000239,
	  -0.00000000083,     0.00000000139,
	   0.00000000047,    -0.00000000405,
	  -0.00000000099,    -0.00000000024,
	  -0.00000000336,     0.00000000059,
	   0.00000000020,     0.00000000074,
	   0.00000000001,     0.00000000053,
	   0.00000000069,    -0.00000000001,
	  -0.00000000008,    -0.00000000724,
	  -0.00000000169,    -0.00000000006,
	  -0.00000000001,     0.00000000020,
	  -0.00000000523,     0.00000000006,
	  -0.00000000004,     0.00000000122,
	  -0.00000000079,    -0.00000000297,
	  -0.00000000057,     0.00000000004,
	  -0.00000000149,     0.00000000159,
	   0.00000000018,     0.00000000035,
	   0.00000000044,    -0.00000000024,
	  -0.00000000237,    -0.00000000451,
	  -0.00000000070,     0.00000000034,
	  -0.00000000330,     0.00000000176,
	   0.00000000025,     0.00000000051,
	  -0.00000000052,    -0.00000000138,
	   0.00000000044,     0.00000000052,
	  -0.00000000120,    -0.00000000106,
	  -0.00000000076,     0.00000000090,
	   0.00000000019,    -0.00000000069,
	   0.00000000055,    -0.00000000084,
	   0.00000000084,    -0.00000000016,
	  -0.00000000012,    -0.00000000068,
	   0.00000000004,    -0.00000000047,
	   0.00000000053,    -0.00000000025,
	  -0.00000000021,    -0.00000000042,
	   0.00000000041,    -0.00000000003,
	   0.00000000035,     0.00000000049,
	   0.00000000033,    -0.00000000020,
	   0.00000000044,    -0.00000000037,
	  -0.00000000022,    -0.00000000029,
	   0.00000000066,     0.00000000086,
	   0.00000000057,    -0.00000000038,
	  -0.00000000011,    -0.00000000019,
	   0.00000000059,    -0.00000000044,
	  -0.00000000026,    -0.00000000040,
	   0.00000000094,     0.00000000046,
	   0.00000000030,    -0.00000000050,
	   0.00000000035,    -0.00000000093,
	  -0.00000000050,    -0.00000000022,
	   0.00000000174,     0.00000000076,
	   0.00000000049,    -0.00000000094,
	  -0.00000000025,    -0.00000000015,
	   0.00000000054,    -0.00000000119,
	  -0.00000000064,    -0.00000000034,
	   0.00000000165,    -0.00000000006,
	   0.00000000003,    -0.00000000079,
	  -0.00000000023,    -0.00000000153,
	  -0.00000000073,     0.00000000008,
	   0.00000000302,    -0.00000000027,
	  -0.00000000004,    -0.00000000144,
	  -0.00000000034,    -0.00000000001,
	  -0.00000000017,    -0.00000000209,
	  -0.00000000100,     0.00000000002,
	   0.00000000202,    -0.00000000116,
	  -0.00000000040,    -0.00000000085,
	  -0.00000000133,    -0.00000000168,
	  -0.00000000066,     0.00000000050,
	   0.00000000021,     0.00000000032,
	   0.00000000355,    -0.00000000238,
	  -0.00000000085,    -0.00000000145,
	  -0.00000000029,     0.00000000015,
	  -0.00000000164,    -0.00000000249,
	  -0.00000000102,     0.00000000059,
	   0.00000000154,    -0.00000000235,
	  -0.00000000071,    -0.00000000057,
	  -0.00000000231,    -0.00000000089,
	  -0.00000000026,     0.00000000071,
	   0.00000000041,     0.00000000022,
	   0.00000000238,    -0.00000000452,
	  -0.00000000137,    -0.00000000082,
	  -0.00000000014,     0.00000000021,
	  -0.00000000318,    -0.00000000169,
	  -0.00000000058,     0.00000000097,
	   0.00000000039,    -0.00000000270,
	  -0.00000000066,    -0.00000000019,
	  -0.00000000217,     0.00000000043,
	   0.00000000015,     0.00000000047,
	  -0.00000000001,    -0.00000000482,
	  -0.00000000112,    -0.00000000005,
	  -0.00000000345,     0.00000000001,
	  -0.00000000003,     0.00000000080,
	  -0.00000000039,    -0.00000000189,
	  -0.00000000081,     0.00000000098,
	  -0.00000000140,    -0.00000000277,
	  -0.00000000042,     0.00000000020,
	  -0.00000000201,     0.00000000103,
	  -0.00000000019,    -0.00000000085,
	   0.00000000039,     0.00000000020,
	  -0.00000000051,    -0.00000000056,
	  -0.00000000039,     0.00000000038,
	   0.00000000018,    -0.00000000043,
	   0.00000000035,    -0.00000000057,
	  -0.00000000007,    -0.00000000051,
	   0.00000000028,     0.00000000040,
	   0.00000000036,    -0.00000000030,
	   0.00000000054,     0.00000000070,
	   0.00000000047,    -0.00000000031,
	  -0.00000000009,    -0.00000000015,
	   0.00000000048,    -0.00000000036,
	  -0.00000000021,    -0.00000000032,
	   0.00000000073,     0.00000000036,
	   0.00000000024,    -0.00000000039,
	   0.00000000027,    -0.00000000073,
	  -0.00000000039,    -0.00000000017,
	   0.00000000138,     0.00000000061,
	   0.00000000039,    -0.00000000074,
	  -0.00000000020,    -0.00000000012,
	   0.00000000042,    -0.00000000093,
	  -0.00000000050,    -0.00000000027,
	   0.00000000126,    -0.00000000004,
	   0.00000000003,    -0.00000000060,
	  -0.00000000018,    -0.00000000116,
	  -0.00000000055,     0.00000000006,
	   0.00000000232,    -0.00000000020,
	  -0.00000000003,    -0.00000000110,
	  -0.00000000026,    -0.00000000001,
	  -0.00000000012,    -0.00000000159,
	  -0.00000000076,     0.00000000001,
	   0.00000000149,    -0.00000000083,
	  -0.00000000028,    -0.00000000063,
	  -0.00000000097,    -0.00000000121,
	  -0.00000000047,     0.00000000037,
	   0.00000000262,    -0.00000000174,
	  -0.00000000062,    -0.00000000107,
	  -0.00000000021,     0.00000000011,
	  -0.00000000119,    -0.00000000182,
	  -0.00000000074,     0.00000000043,
	   0.00000000111,    -0.00000000162,
	  -0.00000000049,    -0.00000000041,
	  -0.00000000159,    -0.00000000060,
	  -0.00000000017,     0.00000000049,
	   0.00000000168,    -0.00000000315,
	  -0.00000000096,    -0.00000000058,
	  -0.00000000010,     0.00000000015,
	  -0.00000000220,    -0.00000000119,
	  -0.00000000041,     0.00000000067,
	   0.00000000031,    -0.00000000178,
	  -0.00000000044,    -0.00000000014,
	  -0.00000000139,     0.00000000031,
	   0.00000000002,    -0.00000000317,
	  -0.00000000073,    -0.00000000004,
	  -0.00000000225,    -0.00000000001,
	  -0.00000000002,     0.00000000052,
	  -0.00000000017,    -0.00000000118,
	  -0.00000000041,     0.00000000060,
	  -0.00000000080,    -0.00000000167,
	  -0.00000000120,     0.00000000059,
	  -0.00000000004,    -0.00000000052,
	   0.00000000022,    -0.00000000038,
	   0.00000000022,     0.00000000032,
	   0.00000000028,    -0.00000000024,
	   0.00000000044,     0.00000000057,
	   0.00000000038,    -0.00000000025,
	  -0.00000000007,    -0.00000000013,
	   0.00000000039,    -0.00000000029,
	   0.00000000057,     0.00000000029,
	   0.00000000019,    -0.00000000031,
	   0.00000000021,    -0.00000000056,
	   0.00000000109,     0.00000000048,
	   0.00000000031,    -0.00000000059,
	  -0.00000000016,    -0.00000000009,
	   0.00000000033,    -0.00000000073,
	  -0.00000000039,    -0.00000000021,
	   0.00000000095,    -0.00000000002,
	   0.00000000003,    -0.00000000046,
	  -0.00000000014,    -0.00000000087,
	   0.00000000176,    -0.00000000015,
	  -0.00000000002,    -0.00000000084,
	  -0.00000000020,    -0.00000000001,
	  -0.00000000009,    -0.00000000120,
	  -0.00000000057,     0.00000000001,
	   0.00000000109,    -0.00000000059,
	  -0.00000000020,    -0.00000000046,
	  -0.00000000070,    -0.00000000086,
	  -0.00000000033,     0.00000000027,
	   0.00000000191,    -0.00000000126,
	  -0.00000000045,    -0.00000000078,
	  -0.00000000016,     0.00000000008,
	  -0.00000000085,    -0.00000000132,
	  -0.00000000054,     0.00000000031,
	   0.00000000079,    -0.00000000111,
	  -0.00000000033,    -0.00000000030,
	  -0.00000000109,    -0.00000000039,
	   0.00000000118,    -0.00000000217,
	  -0.00000000066,    -0.00000000040,
	  -0.00000000151,    -0.00000000082,
	  -0.00000000028,     0.00000000046,
	   0.00000000024,    -0.00000000116,
	  -0.00000000087,     0.00000000022,
	   0.00000000004,    -0.00000000206,
	  -0.00000000048,    -0.00000000003,
	  -0.00000000145,    -0.00000000002,
	  -0.00000000006,    -0.00000000074,
	  -0.00000000019,     0.00000000036,
	  -0.00000000044,    -0.00000000099,
	  -0.00000000070,     0.00000000032,
	   0.00000000035,     0.00000000046,
	   0.00000000031,    -0.00000000020,
	   0.00000000031,    -0.00000000023,
	   0.00000000044,     0.00000000023,
	   0.00000000016,    -0.00000000044,
	   0.00000000085,     0.00000000038,
	   0.00000000024,    -0.00000000046,
	  -0.00000000012,    -0.00000000007,
	   0.00000000026,    -0.00000000056,
	   0.00000000071,    -0.00000000001,
	  -0.00000000011,    -0.00000000064,
	   0.00000000133,    -0.00000000011,
	  -0.00000000001,    -0.00000000063,
	  -0.00000000006,    -0.00000000089,
	   0.00000000079,    -0.00000000041,
	  -0.00000000050,    -0.00000000061,
	   0.00000000139,    -0.00000000090,
	  -0.00000000032,    -0.00000000056,
	  -0.00000000061,    -0.00000000095,
	  -0.00000000038,     0.00000000022,
	   0.00000000056,    -0.00000000075,
	  -0.00000000073,    -0.00000000025,
	   0.00000000082,    -0.00000000148,
	  -0.00000000045,    -0.00000000028,
	  -0.00000000102,    -0.00000000057,
	  -0.00000000019,     0.00000000031,
	   0.00000000019,    -0.00000000075,
	  -0.00000000054,     0.00000000015,
	   0.00000000004,    -0.00000000132,
	  -0.00000000092,    -0.00000000003,
	  -0.00000000023,    -0.00000000057,
	  -0.00000000040,     0.00000000017,
	   0.00000000025,    -0.00000000016,
	   0.00000000034,     0.00000000018,
	   0.00000000066,     0.00000000030,
	   0.00000000019,    -0.00000000035,
	   0.00000000020,    -0.00000000043,
	   0.00000000053,     0.00000000000,
	  -0.00000000008,    -0.00000000047,
	   0.00000000099,    -0.00000000007,
	  -0.00000000001,    -0.00000000047,
	  -0.00000000005,    -0.00000000066,
	   0.00000000057,    -0.00000000029,
	  -0.00000000036,    -0.00000000042,
	   0.00000000099,    -0.00000000064,
	  -0.00000000023,    -0.00000000040,
	  -0.00000000043,    -0.00000000068,
	   0.00000000040,    -0.00000000050,
	  -0.00000000049,    -0.00000000016,
	   0.00000000057,    -0.00000000100,
	  -0.00000000030,    -0.00000000019,
	  -0.00000000069,    -0.00000000039,
	   0.00000000014,    -0.00000000048,
	   0.00000000004,    -0.00000000083,
	  -0.00000000058,    -0.00000000002,
	   0.00000000014,    -0.00000000027,
	   0.00000000073,    -0.00000000005,
	  -0.00000000003,    -0.00000000049,
	   0.00000000041,    -0.00000000020,
	  -0.00000000025,    -0.00000000029,
	   0.00000000071,    -0.00000000045,
	  -0.00000000016,    -0.00000000029,
	  -0.00000000030,    -0.00000000048,
	   0.00000000028,    -0.00000000033,
	   0.00000000039,    -0.00000000067,
	  -0.00000000046,    -0.00000000026,
	   0.00000000050,    -0.00000000031,
	  -0.00000000021,    -0.00000000033,
	  -0.00000001806,    -0.00000001040,
	   0.00000000086,    -0.00000000086,
	   0.00000000003,     0.00000000004,
	  -0.00000001174,    -0.00000000306,
	   0.00000000008,    -0.00000000012,
	   0.00000000174,    -0.00000000992,
	  -0.00000000003,    -0.00000000011,
	   0.00000000025,     0.00000000029,
	  -0.00000000002,     0.00000000003,
	  -0.00000000069,    -0.00000000060,
	  -0.00000002184,    -0.00000004643,
	   0.00000000340,    -0.00000000184,
	  -0.00000005966,    -0.00000000110,
	  -0.00000000094,    -0.00000006092,
	   0.00000000035,     0.00000000083,
	  -0.00000008344,    -0.00000014007,
	   0.00000001077,    -0.00000000736,
	   0.00000000029,     0.00000000041,
	  -0.00000017970,    -0.00000000604,
	   0.00000000097,     0.00000000049,
	  -0.00000000418,    -0.00000018578,
	   0.00000000045,    -0.00000000124,
	  -0.00000000165,    -0.00000000359,
	   0.00000000227,     0.00000000239,
	  -0.00000108962,     0.00000053133,
	  -0.00000005123,    -0.00000008549,
	   0.00000000370,    -0.00000000182,
	   0.00000468021,     0.00000790415,
	  -0.00000061937,     0.00000038886,
	  -0.00000001497,    -0.00000002527,
	  -0.00000590672,     0.00000004912,
	  -0.00000000377,    -0.00000000970,
	   0.00000000024,    -0.00000000086,
	   0.00000005206,    -0.00000583999,
	  -0.00000001000,     0.00000001146,
	  -0.00000000093,    -0.00000000026,
	  -0.00000006083,    -0.00000001919,
	  -0.00000000766,     0.00000001075,
	   0.00000000039,     0.00000000073,
	   0.00000005078,    -0.00000004193,
	  -0.00000001110,    -0.00000000609,
	  -0.00000000075,     0.00000000041,
	   0.00000001531,    -0.00000006389,
	   0.00000000297,    -0.00000000123,
	   0.00000088874,     0.00000000046,
	   0.00000000094,     0.00000089030,
	   0.00000010016,     0.00000000526,
	  -0.00000000672,     0.00000000948,
	   0.00000120316,     0.00000000058,
	   0.00000000209,     0.00000120568,
	  -0.00000000128,     0.00000000051,
	   0.00000001455,     0.00000011807,
	  -0.00000000177,    -0.00000000045,
	   0.00000170832,     0.00000000107,
	   0.00000000138,     0.00000171098,
	   0.00000000068,     0.00000000046,
	   0.00000002145,    -0.00000001928,
	   0.00000213898,     0.00000000062,
	   0.00000000273,     0.00000214398,
	  -0.00000000146,     0.00000000090,
	   0.00000000012,     0.00000000011,
	   0.00000000028,    -0.00000000077,
	   0.00000000079,     0.00000000027,
	  -0.00000000017,    -0.00000000045,
	   0.00000000045,    -0.00000000017,
	   0.00000000013,    -0.00000000042,
	  -0.00000000032,     0.00000000046,
	  -0.00000000046,    -0.00000000033,
	  -0.00000000039,    -0.00000000015,
	   0.00000000017,    -0.00000000038,
	   0.00000000219,     0.00000000058,
	   0.00000000012,     0.00000000113,
	   0.00000000263,    -0.00000000511,
	   0.00000000119,     0.00000000048,
	   0.00000000529,     0.00000000262,
	  -0.00000000041,     0.00000000130,
	   0.00000000334,     0.00000000101,
	  -0.00000000110,     0.00000000323,
	   0.00000000014,     0.00000000083,
	  -0.00000000030,    -0.00000000021,
	   0.00000000034,     0.00000000792,
	   0.00000000155,     0.00000000026,
	  -0.00000000031,     0.00000000022,
	   0.00000000004,    -0.00000000070,
	   0.00000000181,    -0.00000000004,
	   0.00000000019,     0.00000000078,
	  -0.00000000041,    -0.00000000076,
	   0.00000000532,     0.00000000431,
	  -0.00000000117,     0.00000000108,
	  -0.00000000067,    -0.00000000024,
	  -0.00000000023,     0.00000000067,
	  -0.00000000109,     0.00000000026,
	  -0.00000002277,    -0.00000009668,
	   0.00000000277,     0.00000000169,
	   0.00000000243,    -0.00000000293,
	   0.00000000018,     0.00000000036,
	  -0.00000000289,    -0.00000000234,
	   0.00000000035,    -0.00000000018,
	   0.00000000009,    -0.00000000176,
	  -0.00000000040,     0.00000000085,
	   0.00000000304,    -0.00000000023,
	  -0.00000000019,     0.00000000031,
	  -0.00000000036,    -0.00000000025,
	  -0.00000000024,     0.00000000036,
	  -0.00000000291,     0.00000000698,
	   0.00000000071,     0.00000000044,
	  -0.00000000114,     0.00000000058,
	   0.00000000060,     0.00000000113,
	  -0.00000002474,    -0.00000001604,
	  -0.00000000074,    -0.00000000108,
	  -0.00000005494,     0.00000003811,
	   0.00000000418,     0.00000000235,
	   0.00000000540,     0.00000000174,
	   0.00000000182,    -0.00000000556,
	   0.00000000009,    -0.00000000050,
	  -0.00000000146,    -0.00000000388,
	  -0.00000000062,     0.00000000102,
	   0.00000000102,     0.00000000060,
	   0.00000000080,    -0.00000000013,
	  -0.00000000035,    -0.00000000044,
	  -0.00000000432,     0.00000000342,
	   0.00000000036,     0.00000000025,
	   0.00000000240,     0.00000000074,
	   0.00000000073,    -0.00000000263,
	  -0.00000000153,    -0.00000000278,
	  -0.00000000061,     0.00000000131,
	   0.00000000131,     0.00000000059,
	   0.00000000063,    -0.00000000022,
	   0.00000000064,    -0.00000000023,
	  -0.00000000038,    -0.00000000024,
	  -0.00000000023,     0.00000000038,
	   0.00000000106,    -0.00000000003,
	  -0.00000000079,    -0.00000000056,
	  -0.00000000054,     0.00000000080,
	   0.00000000456,     0.00000000003,
	   0.00000000092,    -0.00000000093,
	  -0.00000000019,    -0.00000000085,
	  -0.00000000087,     0.00000000018,
	  -0.00000000046,    -0.00000000307,
	  -0.00000000156,     0.00000000156,
	   0.00000000157,     0.00000000153,
	   0.00000000039,    -0.00000000110,
	  -0.00000000066,     0.00000000053,
	   0.00000000057,     0.00000000042,
	  -0.00000000020,    -0.00000000048,
	   0.00000000022,     0.00000000066,
	   0.00000000044,    -0.00000000054,
	  -0.00000000054,    -0.00000000041,
	  -0.00000000058,     0.00000000086,
	   0.00000000264,     0.00000000179,
	   0.00000000004,    -0.00000000432,
	  -0.00000000429,     0.00000000002,
	   0.00000000038,    -0.00000000078,
	  -0.00000001471,     0.00000000937,
	   0.00000000123,     0.00000000159,
	   0.00000000099,    -0.00000000190,
	  -0.00000000488,     0.00000001770,
	   0.00000000217,     0.00000000351,
	   0.00000000044,     0.00000000002,
	   0.00000036798,     0.00000009667,
	   0.00000007267,    -0.00000004508,
	   0.00000000045,    -0.00000000911,
	  -0.00000002619,     0.00000002482,
	   0.00000000145,     0.00000000004,
	   0.00000002550,     0.00000002670,
	   0.00000000026,    -0.00000000153,
	   0.00000000203,     0.00000000191,
	   0.00000000197,    -0.00000000206,
	   0.00000000019,     0.00000000408,
	   0.00000000214,     0.00000000062,
	  -0.00000000081,    -0.00000000186,
	   0.00000000036,    -0.00000000020,
	  -0.00000000184,     0.00000000070,
	  -0.00000000021,    -0.00000000034,
	   0.00000000067,     0.00000000033,
	   0.00000000116,    -0.00000000212,
	  -0.00000000025,    -0.00000000027,
	  -0.00000000343,    -0.00000000044,
	  -0.00000000007,     0.00000000048,
	  -0.00000000032,     0.00000000345,
	   0.00000000047,     0.00000000007,
	  -0.00000000053,    -0.00000000115,
	  -0.00000000132,     0.00000000141,
	   0.00000000142,     0.00000000131,
	  -0.00000000088,    -0.00000000117,
	  -0.00000000336,     0.00000000232,
	   0.00000000408,     0.00000000152,
	   0.00000000141,    -0.00000000403,
	  -0.00000003656,     0.00000005234,
	   0.00000000339,     0.00000001050,
	   0.00000000090,     0.00000000024,
	   0.00000029596,     0.00000018257,
	   0.00000005512,    -0.00000001966,
	   0.00000000134,    -0.00000000476,
	  -0.00000014020,    -0.00000003765,
	   0.00000000141,     0.00000000312,
	  -0.00000000031,    -0.00000000023,
	  -0.00000003599,     0.00000014274,
	   0.00000000383,    -0.00000000148,
	   0.00000000025,     0.00000000794,
	  -0.00000000044,     0.00000000043,
	   0.00000000830,    -0.00000000027,
	   0.00000000047,     0.00000000044,
	   0.00000005384,    -0.00000006527,
	   0.00000000563,     0.00000000313,
	  -0.00000000104,     0.00000000052,
	  -0.00000000058,    -0.00000000018,
	   0.00000000014,    -0.00000000043,
	   0.00000000000,     0.00000000068,
	  -0.00000000046,    -0.00000000012,
	  -0.00000000043,     0.00000000073,
	   0.00000000076,    -0.00000000012,
	  -0.00000000013,    -0.00000000075,
	   0.00000000031,     0.00000000101,
	  -0.00000000092,    -0.00000000044,
	  -0.00000000030,     0.00000000101,
	   0.00000000046,     0.00000000046,
	   0.00000000036,    -0.00000000086,
	  -0.00000041836,     0.00000025212,
	   0.00000000260,     0.00000006551,
	   0.00000000386,     0.00000000182,
	   0.00000101623,     0.00000142941,
	   0.00000022221,    -0.00000002519,
	   0.00000000556,    -0.00000001255,
	  -0.00000038613,    -0.00000121593,
	  -0.00000001139,     0.00000000978,
	  -0.00000000032,    -0.00000000185,
	  -0.00000121244,     0.00000040956,
	   0.00000001440,     0.00000001238,
	  -0.00000000163,    -0.00000000008,
	  -0.00000002911,     0.00000003093,
	  -0.00000000323,    -0.00000000057,
	   0.00000003383,     0.00000003101,
	  -0.00000000032,     0.00000000330,
	   0.00000000357,    -0.00000000119,
	  -0.00000000119,    -0.00000000357,
	   0.00000000685,     0.00000000078,
	   0.00000000083,    -0.00000000287,
	  -0.00000000036,     0.00000000047,
	   0.00000000048,     0.00000000037,
	   0.00000000039,     0.00000000045,
	  -0.00000000070,     0.00000000039,
	   0.00000000054,     0.00000000026,
	   0.00000000025,    -0.00000000054,
	  -0.00000000082,    -0.00000000062,
	  -0.00000000162,     0.00000000211,
	   0.00000000393,     0.00000000085,
	   0.00000000079,    -0.00000000390,
	  -0.00000000040,     0.00000000071,
	   0.00000000063,     0.00000000001,
	   0.00000000000,    -0.00000000063,
	   0.00000000012,    -0.00000000042,
	  -0.00000382434,     0.00000023302,
	  -0.00000010219,     0.00000038485,
	   0.00000001691,     0.00000001078,
	   0.00000122987,     0.00001117396,
	   0.00000110637,     0.00000020868,
	   0.00000002423,    -0.00000004658,
	   0.00000722998,    -0.00000925166,
	  -0.00000004192,    -0.00000004738,
	   0.00000000323,    -0.00000000747,
	  -0.00000931747,    -0.00000705137,
	  -0.00000001913,     0.00000005947,
	  -0.00000000550,    -0.00000000534,
	  -0.00000016700,     0.00000000332,
	  -0.00000000540,    -0.00000001278,
	   0.00000000040,    -0.00000000048,
	   0.00000001193,     0.00000019684,
	  -0.00000001175,     0.00000000666,
	  -0.00000000045,    -0.00000000038,
	   0.00000002826,    -0.00000001198,
	  -0.00000000021,    -0.00000000202,
	   0.00000003598,    -0.00000000507,
	   0.00000000081,    -0.00000000158,
	  -0.00000000504,    -0.00000003596,
	  -0.00000000157,    -0.00000000081,
	  -0.00000000044,     0.00000000040,
	   0.00000000040,     0.00000000043,
	  -0.00000000040,     0.00000000082,
	   0.00000000031,     0.00000000019,
	   0.00000000463,     0.00000000196,
	   0.00000000093,    -0.00000000175,
	  -0.00000000208,    -0.00000000024,
	   0.00000000010,     0.00000000066,
	  -0.00000000021,     0.00000000211,
	   0.00000000067,    -0.00000000011,
	   0.00000000030,     0.00000000158,
	   0.00000000067,    -0.00000000110,
	  -0.00000000111,    -0.00000000065,
	   0.00000000004,    -0.00000000062,
	   0.00000000049,     0.00000000030,
	   0.00000000030,    -0.00000000050,
	  -0.00000000150,     0.00000000036,
	   0.00000000077,     0.00000000093,
	   0.00000000090,    -0.00000000077,
	   0.00000000019,    -0.00000000078,
	  -0.00000000061,     0.00000000000,
	   0.00000000001,     0.00000000061,
	  -0.00001962728,    -0.00000997777,
	  -0.00000089784,     0.00000148864,
	   0.00000005925,     0.00000003857,
	  -0.00002697858,     0.00005072656,
	   0.00000389175,     0.00000235831,
	   0.00000010068,    -0.00000015543,
	  -0.00000000410,    -0.00000000280,
	   0.00008228335,     0.00000075920,
	   0.00000003608,    -0.00000005207,
	  -0.00000000321,    -0.00000001510,
	  -0.00000016314,    -0.00008158375,
	   0.00000004600,     0.00000010337,
	  -0.00000000328,    -0.00000000339,
	   0.00000013445,     0.00000001437,
	   0.00000000698,     0.00000000535,
	  -0.00000000031,     0.00000000057,
	  -0.00000007893,     0.00000003686,
	   0.00000000432,    -0.00000000082,
	   0.00000000053,     0.00000000031,
	   0.00000040592,    -0.00000008511,
	   0.00000001011,    -0.00000001937,
	   0.00000000828,     0.00000000561,
	   0.00000038637,    -0.00000000043,
	  -0.00000000013,    -0.00000038580,
	   0.00000002863,    -0.00000000733,
	  -0.00000000428,     0.00000000355,
	   0.00000000137,     0.00000000169,
	   0.00000001397,     0.00000001443,
	   0.00000000557,    -0.00000000535,
	  -0.00000000644,    -0.00000001309,
	  -0.00000000352,     0.00000000280,
	  -0.00000001302,     0.00000000670,
	   0.00000000292,     0.00000000349,
	  -0.00000000025,     0.00000000036,
	   0.00000000040,     0.00000000027,
	  -0.00000000124,    -0.00000000056,
	  -0.00000000185,     0.00000000404,
	   0.00000000544,    -0.00000000051,
	  -0.00000000057,    -0.00000000539,
	   0.00000000197,     0.00000000110,
	   0.00000000030,    -0.00000000038,
	   0.00000000269,    -0.00000000549,
	  -0.00000000110,    -0.00000000072,
	  -0.00000000426,     0.00000000129,
	  -0.00000000003,     0.00000000051,
	   0.00000000148,     0.00000000395,
	   0.00000000050,    -0.00000000001,
	  -0.00000000159,    -0.00000000168,
	  -0.00000000035,     0.00000000015,
	  -0.00000000447,     0.00000000388,
	   0.00000000039,     0.00000000094,
	   0.00000000656,     0.00000000312,
	   0.00000000051,    -0.00000000034,
	   0.00000000320,    -0.00000000664,
	  -0.00000000040,    -0.00000000049,
	   0.00001038213,     0.00000047210,
	   0.00000001010,    -0.00000000358,
	  -0.00000000011,    -0.00000000159,
	   0.00000111717,    -0.00003319998,
	  -0.00000000853,    -0.00000002166,
	  -0.00000000425,     0.00000000023,
	  -0.00000274393,     0.00000049397,
	  -0.00000006950,    -0.00000010351,
	   0.00000000416,    -0.00000000225,
	  -0.00000058523,     0.00000149999,
	  -0.00000012988,     0.00000006075,
	  -0.00000000382,    -0.00000000402,
	  -0.00000002703,     0.00000002706,
	  -0.00000000038,    -0.00000001699,
	   0.00000000010,    -0.00000000093,
	  -0.00000000014,    -0.00000025545,
	   0.00000000093,    -0.00000000848,
	   0.00000000004,     0.00000000054,
	   0.00000713818,    -0.00000000233,
	   0.00000000001,     0.00000109752,
	  -0.00000001524,    -0.00000000825,
	  -0.00000000026,    -0.00000000124,
	  -0.00000000450,     0.00000003247,
	  -0.00000000055,     0.00000000060,
	   0.00000000430,     0.00000000038,
	   0.00000000038,    -0.00000000426,
	   0.00000007415,     0.00000000190,
	   0.00000026752,    -0.00000000005,
	   0.00000062540,    -0.00000000021,
	  -0.00000000025,    -0.00000000077,
	  -0.00000000037,     0.00000000076,
	   0.00000000076,     0.00000000036,
	  -0.00000003215,     0.00000000690,
	   0.00000000308,     0.00000001203,
	   0.00000002492,     0.00000009351,
	   0.00000003464,    -0.00000001109,
	   0.00000004949,    -0.00000008826,
	  -0.00000002841,    -0.00000001047,
	  -0.00000008858,    -0.00000004789,
	  -0.00000000976,     0.00000002853,
	  -0.00000000140,     0.00000000024,
	   0.00000000035,     0.00000000164,
	  -0.00000000071,    -0.00000000067,
	  -0.00000000034,     0.00000000076,
	   0.00000000076,     0.00000000031,
	   0.00000000038,    -0.00000000109,
	  -0.00000000027,    -0.00000000014,
	  -0.00000000314,    -0.00000000124,
	  -0.00000000040,     0.00000000076,
	   0.00000000213,     0.00000000464,
	   0.00000000080,    -0.00000000012,
	   0.00000000450,    -0.00000000221,
	  -0.00000000014,    -0.00000000086,
	   0.00000000993,     0.00000000536,
	   0.00000000130,    -0.00000000101,
	   0.00000001337,    -0.00000002498,
	  -0.00000000254,    -0.00000000328,
	  -0.00000003983,    -0.00000000385,
	  -0.00000000199,     0.00000000222,
	  -0.00000000343,     0.00000003948,
	   0.00000000214,     0.00000000184,
	  -0.00000000196,    -0.00000000169,
	  -0.00000000383,     0.00000000443,
	   0.00000000034,     0.00000000025,
	   0.00000001080,     0.00000000323,
	   0.00000000332,    -0.00000001068,
	   0.00000000143,     0.00000000000,
	   0.00000000000,    -0.00000000143,
	   0.00000000154,     0.00000000000,
	   0.00000000000,     0.00000000154,
	   0.00000000211,     0.00000000000,
	   0.00000000000,    -0.00000000211,
	   0.00000000219,     0.00000000000,
	   0.00000000000,     0.00000000220,
	   0.00000000070,     0.00000000140,
	   0.00000000050,    -0.00000000052,
	   0.00000000097,    -0.00000000246,
	  -0.00000000124,     0.00000000001,
	  -0.00000000246,    -0.00000000094,
	   0.00000000002,     0.00000000124,
	   0.00000000103,     0.00000000028,
	   0.00000000078,    -0.00000000266,
	  -0.00000000387,     0.00000000076,
	   0.00000000080,     0.00000000383,
	  -0.00000012018,    -0.00000004435,
	  -0.00000001258,     0.00000004562,
	   0.00000000019,     0.00000000021,
	  -0.00000012216,     0.00000031324,
	   0.00000011946,     0.00000003485,
	   0.00000000057,    -0.00000000056,
	   0.00000048300,    -0.00000005344,
	  -0.00000003349,    -0.00000014106,
	  -0.00000002106,     0.00000000747,
	  -0.00000005828,    -0.00000047830,
	  -0.00000013887,     0.00000003542,
	   0.00000000789,     0.00000002065,
	   0.00000000105,    -0.00000000004,
	  -0.00000000064,    -0.00000000019,
	   0.00000000197,    -0.00000000031,
	  -0.00000000031,    -0.00000000197,
	   0.00000003154,     0.00000000128,
	  -0.00000000254,    -0.00000000931,
	  -0.00000000105,     0.00000000048,
	   0.00000000004,    -0.00000008171,
	  -0.00000002399,     0.00000000724,
	   0.00000000131,     0.00000000270,
	  -0.00000010838,     0.00000007321,
	   0.00000002546,     0.00000001742,
	   0.00000000099,    -0.00000000237,
	   0.00000007372,     0.00000010700,
	   0.00000001684,    -0.00000002554,
	  -0.00000000237,    -0.00000000091,
	  -0.00000000049,     0.00000000152,
	   0.00000000169,     0.00000000002,
	  -0.00000000303,     0.00000000018,
	   0.00000000018,     0.00000000303,
	   0.00000000054,     0.00000000000,
	   0.00000000000,    -0.00000000053,
	   0.00000000050,     0.00000000029,
	   0.00000000028,    -0.00000000049,
	  -0.00000005043,     0.00000019248,
	   0.00000003757,     0.00000000124,
	  -0.00000000014,    -0.00000000309,
	   0.00000047166,     0.00000011591,
	   0.00000000262,    -0.00000009233,
	  -0.00000000762,     0.00000000038,
	  -0.00000020915,    -0.00000071653,
	  -0.00000006921,     0.00000005437,
	   0.00000000251,     0.00000000299,
	  -0.00000070846,     0.00000021340,
	   0.00000005523,     0.00000006697,
	   0.00000000273,    -0.00000000259,
	  -0.00000000354,    -0.00000000325,
	  -0.00000000083,     0.00000000530,
	  -0.00000000032,    -0.00000000035,
	  -0.00000006240,     0.00000000514,
	   0.00000000877,     0.00000001146,
	  -0.00000000170,    -0.00000003931,
	  -0.00000000371,     0.00000000258,
	  -0.00000003934,     0.00000000170,
	   0.00000000259,     0.00000000372,
	  -0.00000078110,    -0.00000038939,
	  -0.00000003927,     0.00000005946,
	   0.00000000239,     0.00000000167,
	  -0.00000093096,     0.00000179793,
	   0.00000013907,     0.00000009366,
	   0.00000000398,    -0.00000000561,
	   0.00000299233,     0.00000001963,
	   0.00000000376,    -0.00000000344,
	  -0.00000000409,    -0.00000295539,
	   0.00000000224,    -0.00000000060,
	   0.00000000543,     0.00000000458,
	  -0.00000000011,     0.00000000049,
	  -0.00000000572,     0.00000000261,
	   0.00000000042,     0.00000000009,
	  -0.00000004967,    -0.00000096006,
	  -0.00000009044,     0.00000006386,
	   0.00000002958,    -0.00000000232,
	  -0.00000000201,    -0.00000000279,
	   0.00000044953,    -0.00000000029,
	  -0.00000000033,    -0.00000045022,
	   0.00000023157,     0.00000003300,
	  -0.00000000006,    -0.00000000208,
	   0.00000007303,    -0.00000070680,
	  -0.00000000461,     0.00000000027,
	   0.00000000330,    -0.00000001011,
	   0.00000001197,    -0.00000000042,
	  -0.00000012738,     0.00000002608,
	   0.00000000855,    -0.00000000093,
	   0.00000000050,    -0.00000000001,
	  -0.00000000036,    -0.00000000288,
	   0.00000000021,    -0.00000000081,
	   0.00000000002,    -0.00000000815,
	   0.00000000009,     0.00000000045,
	   0.00001634104,    -0.00000001044,
	   0.00000000068,     0.00000155503,
	   0.00000000132,    -0.00000004739,
	   0.00000000186,     0.00000000317,
	  -0.00000002371,    -0.00000000249,
	   0.00000000126,    -0.00000000448,
	   0.00000000820,    -0.00000000325,
	  -0.00000000325,    -0.00000000820,
	   0.00000006545,     0.00000000155,
	   0.00000014726,    -0.00000000005,
	  -0.00000000051,     0.00000000058,
	   0.00000000128,     0.00000000045,
	   0.00000000044,    -0.00000000127,
	   0.00000000256,     0.00000000064,
	   0.00000000064,    -0.00000000256,
	   0.00000000225,     0.00000000141,
	   0.00000000319,    -0.00000000506,
	  -0.00000000046,    -0.00000000034,
	  -0.00000000976,    -0.00000000169,
	  -0.00000000158,     0.00000000970,
	   0.00000011009,     0.00000002714,
	  -0.00000004173,    -0.00000000511,
	  -0.00000000510,     0.00000004171,
	  -0.00000001356,    -0.00000000591,
	  -0.00000000058,     0.00000000097,
	  -0.00000001295,     0.00000002988,
	   0.00000000212,     0.00000000127,
	   0.00000005075,     0.00000000021,
	  -0.00000000028,    -0.00000005042,
	  -0.00000211341,    -0.00000025652,
	   0.00000000832,     0.00000003411,
	   0.00000000463,    -0.00000003762,
	   0.00000059316,     0.00000000002,
	  -0.00000000013,    -0.00000059254,
	   0.00000000197,    -0.00000000016,
	  -0.00000000035,    -0.00000000595,
	   0.00000000188,     0.00000000006,
	   0.00004484929,    -0.00000000392,
	   0.00000000016,     0.00000225295,
	   0.00000002676,    -0.00000000657,
	  -0.00000000328,    -0.00000005354,
	   0.00000000502,     0.00000000339,
	   0.00000000339,    -0.00000000502,
	   0.00000007481,    -0.00000000611,
	   0.00000000709,    -0.00000000048,
	  -0.00000000048,    -0.00000000709,
	  -0.00000000021,     0.00000000042,
	   0.00000000073,     0.00000000005,
	   0.00000000004,    -0.00000000072,
	  -0.00000003070,    -0.00000000561,
	   0.00000000852,     0.00000000057,
	   0.00000000056,    -0.00000000851,
	   0.00000046051,    -0.00000002661,
	   0.00000000084,     0.00000001459,
	  -0.00000000028,    -0.00000000045,
	   0.00000000089,    -0.00000000015,
	   0.00000000016,     0.00000000089,
	  -0.00000004444,     0.00000003339,
	   0.00000000165,     0.00000000208,
	   0.00000001278,    -0.00000000156,
	   0.00000000154,     0.00000001277,
	   0.00000000480,     0.00000000324,
	  -0.00000000324,     0.00000000480,
	  -0.00000000710,    -0.00000000047,
	  -0.00000000047,     0.00000000710,
	  -0.00000042431,    -0.00000002393,
	   0.00000000081,    -0.00000001424,
	   0.00000000001,     0.00000000542,
	  -0.00000000001,    -0.00000000205,
	   0.00000000006,    -0.00000000048,
	  -0.00000000048,    -0.00000000006,
	   0.00000000664,    -0.00000000741,
	  -0.00000000741,    -0.00000000664,
	  -0.00000000400,    -0.00000000178,
	  -0.00000000018,     0.00000000029,
	  -0.00000000385,     0.00000000863,
	   0.00000000063,     0.00000000038,
	   0.00000001534,     0.00000000007,
	  -0.00000000009,    -0.00000001521,
	   0.00000032736,     0.00000001847,
	  -0.00000000097,     0.00000001695,
	   0.00000000198,    -0.00000000004,
	   0.00000000000,    -0.00000000217,
	   0.00000052757,    -0.00000058887,
	   0.00000000701,     0.00000000626,
	   0.00000073000,    -0.00000000038,
	  -0.00000000035,    -0.00000073001,
	   0.00000000007,    -0.00000000118,
	   0.00008707312,    -0.00000004306,
	   0.00000000105,     0.00000283649,
	  -0.00000000433,    -0.00000000967,
	  -0.00000000483,     0.00000000866,
	   0.00000001498,     0.00000000056,
	   0.00000000057,    -0.00000001498,
	  -0.00000009915,     0.00000006566,
	   0.00000000191,     0.00000000304,
	  -0.00000000212,    -0.00000000237,
	   0.00000000237,    -0.00000000211,
	   0.00000001464,     0.00000000055,
	  -0.00000000055,     0.00000001464,
	  -0.00000000081,     0.00000000053,
	  -0.00000000053,    -0.00000000081,
	   0.00000000016,    -0.00000000044,
	  -0.00000000073,     0.00000000005,
	   0.00000000005,     0.00000000072,
	  -0.00000006529,     0.00000000188,
	  -0.00000000003,    -0.00000000130,
	  -0.00000000851,     0.00000000057,
	   0.00000000057,     0.00000000850,
	  -0.00000034526,     0.00000001987,
	  -0.00000000096,    -0.00000001690,
	   0.00000000031,     0.00000000548,
	  -0.00000000028,    -0.00000000014,
	   0.00000000186,     0.00000001636,
	  -0.00000000045,    -0.00000000003,
	  -0.00000001633,     0.00000000197,
	  -0.00000000001,    -0.00000000046,
	   0.00000000052,     0.00000000060,
	  -0.00000000077,     0.00000000065,
	  -0.00000000353,    -0.00000000269,
	   0.00000000042,    -0.00000000052,
	  -0.00000000939,     0.00000000483,
	  -0.00000000027,    -0.00000000069,
	  -0.00000000502,    -0.00000000938,
	   0.00000000070,    -0.00000000031,
	  -0.00000000017,     0.00000000112,
	  -0.00000000105,    -0.00000000022,
	  -0.00000001524,    -0.00000000871,
	   0.00000000129,    -0.00000000289,
	  -0.00000003016,     0.00000002098,
	  -0.00000000153,    -0.00000000242,
	  -0.00000002199,    -0.00000003028,
	   0.00000000238,    -0.00000000189,
	  -0.00000000244,    -0.00000000271,
	   0.00000000283,    -0.00000000189,
	   0.00000010267,    -0.00000018939,
	   0.00000003267,     0.00000001071,
	  -0.00000000121,     0.00000000212,
	   0.00000020147,     0.00000012960,
	  -0.00000002447,     0.00000003490,
	  -0.00000000286,    -0.00000000126,
	   0.00000057433,    -0.00000037861,
	   0.00000002751,     0.00000004572,
	  -0.00000000184,     0.00000000095,
	   0.00000039249,     0.00000057581,
	  -0.00000004597,     0.00000003114,
	  -0.00000000137,    -0.00000000183,
	   0.00000015968,     0.00000002224,
	   0.00000000589,    -0.00000001129,
	  -0.00000000040,    -0.00000000056,
	  -0.00000002321,     0.00000015623,
	   0.00000001151,     0.00000000584,
	   0.00000000056,    -0.00000000040,
	  -0.00000000102,    -0.00000000596,
	   0.00000007567,    -0.00000003357,
	   0.00000000330,     0.00000000552,
	   0.00000003369,     0.00000007574,
	  -0.00000000552,     0.00000000333,
	   0.00000000874,    -0.00000000333,
	   0.00000000018,     0.00000000152,
	   0.00000010252,    -0.00000004549,
	   0.00000000450,     0.00000000747,
	   0.00000004573,     0.00000010260,
	  -0.00000000748,     0.00000000453,
	   0.00000000570,     0.00000000951,
	  -0.00000000085,     0.00000000056,
	   0.00000014557,    -0.00000006457,
	   0.00000000636,     0.00000001062,
	   0.00000006477,     0.00000014567,
	  -0.00000001062,     0.00000000641,
	   0.00000000110,    -0.00000000245,
	   0.00000018224,    -0.00000008091,
	   0.00000000797,     0.00000001330,
	   0.00000008124,     0.00000018250,
	  -0.00000001331,     0.00000000804,
	  -0.00000000001,     0.00000000386,
	   0.00000000001,    -0.00000000265,
	   0.00000001072,    -0.00000000057,
	  -0.00000000018,    -0.00000000087,
	   0.00000000246,     0.00000000001,
	   0.00000000001,    -0.00000000244,
	  -0.00000000757,     0.00000000061,
	   0.00000000012,     0.00000000066,
	  -0.00000000218,    -0.00000000001,
	  -0.00000000001,     0.00000000217,
	   0.00000000001,    -0.00000000079,
	   0.00000000780,     0.00000000000,
	  -0.00000000018,    -0.00000000065,
	   0.00000000016,    -0.00000000079,
	   0.00000000081,     0.00000000016,
	   0.00000000069,    -0.00000000008,
	   0.00000000006,     0.00000000068,
	  -0.00000000078,     0.00000000037,
	   0.00000000006,     0.00000000045,
	   0.00000000089,    -0.00000000087,
	  -0.00000000026,    -0.00000000036,
	   0.00000000132,    -0.00000000208,
	  -0.00000000085,    -0.00000000130,
	   0.00000000038,     0.00000000024,
	   0.00000000023,    -0.00000000045,
	   0.00000000056,     0.00000000008,
	  -0.00000000036,    -0.00000000042,
	  -0.00000000060,     0.00000000051,
	  -0.00000000034,     0.00000000062,
	   0.00000000009,    -0.00000000094,
	  -0.00000000098,    -0.00000000007,
	   0.00000000037,    -0.00000000026,
	  -0.00000000168,     0.00000000111,
	   0.00000000110,     0.00000000168,
	  -0.00000000050,     0.00000000045,
	   0.00000000071,     0.00000000059,
	  -0.00000000106,    -0.00000000007,
	  -0.00000000006,     0.00000000112,
	   0.00000000020,     0.00000000046,
	  -0.00000000027,     0.00000000034,
	   0.00000000032,     0.00000000034,
	  -0.00000000049,    -0.00000000039,
	   0.00000000005,    -0.00000000290,
	  -0.00000000403,     0.00000000007,
	   0.00000000117,     0.00000000050,
	   0.00000000027,    -0.00000000128,
	  -0.00000000293,     0.00000000190,
	   0.00000000553,     0.00000000254,
	  -0.00000000009,    -0.00000000040,
	  -0.00000002250,    -0.00000000906,
	  -0.00000000008,     0.00000000045,
	  -0.00000000928,     0.00000002259,
	   0.00000000045,     0.00000000011,
	   0.00000000005,     0.00000000084,
	   0.00000000087,    -0.00000000006,
	  -0.00000000208,    -0.00000000014,
	  -0.00000000018,     0.00000000278,
	  -0.00000000003,     0.00000000057,
	  -0.00000000094,     0.00000000099,
	   0.00000000131,     0.00000000125,
	   0.00000000329,     0.00000000118,
	   0.00000000150,    -0.00000000418,
	  -0.00000004742,    -0.00000001938,
	  -0.00000000025,     0.00000000113,
	   0.00000000613,     0.00000007849,
	   0.00000000267,    -0.00000000286,
	  -0.00000006129,    -0.00000025477,
	  -0.00000000276,     0.00000000061,
	  -0.00000025916,     0.00000006125,
	   0.00000000020,     0.00000000310,
	  -0.00000000375,     0.00000000416,
	  -0.00000000039,    -0.00000000012,
	   0.00000000443,     0.00000000404,
	  -0.00000000013,     0.00000000038,
	  -0.00000000069,    -0.00000000032,
	  -0.00000000041,     0.00000000088,
	  -0.00000015563,    -0.00000067236,
	  -0.00000000861,     0.00000000156,
	  -0.00000000020,    -0.00000000079,
	  -0.00000081043,     0.00000051101,
	   0.00000002832,     0.00000000338,
	  -0.00000000159,    -0.00000000052,
	   0.00000146854,    -0.00000179162,
	  -0.00000000427,    -0.00000001012,
	   0.00000000065,    -0.00000000147,
	  -0.00000184622,    -0.00000150769,
	  -0.00000001644,     0.00000000721,
	  -0.00000000151,    -0.00000000036,
	  -0.00000002174,     0.00000000174,
	  -0.00000000087,    -0.00000000156,
	  -0.00000000001,     0.00000002547,
	  -0.00000000156,     0.00000000074,
	  -0.00000000072,     0.00000000089,
	   0.00000000089,     0.00000000072,
	   0.00000000078,     0.00000000000,
	   0.00000000001,    -0.00000000109,
	   0.00000519865,    -0.00000616688,
	  -0.00000002103,    -0.00000004675,
	   0.00000000189,    -0.00000000508,
	  -0.00000902252,    -0.00000527209,
	   0.00000006129,     0.00000010218,
	  -0.00000000343,    -0.00000000740,
	   0.00001300576,    -0.00000003050,
	   0.00000000781,     0.00000003675,
	   0.00000000111,    -0.00000000155,
	  -0.00000025243,    -0.00001375873,
	  -0.00000003472,    -0.00000000865,
	  -0.00000000213,     0.00000000171,
	   0.00000000312,     0.00000001497,
	  -0.00000000076,     0.00000000033,
	  -0.00000002347,    -0.00000000966,
	   0.00000000052,    -0.00000000139,
	  -0.00000000373,     0.00000000428,
	   0.00000000157,     0.00000000090,
	  -0.00000000575,    -0.00000000158,
	  -0.00000000158,     0.00000000578,
	  -0.00000000078,     0.00000000143,
	  -0.00000000071,    -0.00000000017,
	   0.00000000023,     0.00000000100,
	   0.00000000033,    -0.00000000019,
	  -0.00000000141,    -0.00000000345,
	  -0.00000000095,     0.00000000063,
	  -0.00000000351,     0.00000000141,
	   0.00000000063,     0.00000000097,
	  -0.00000000073,    -0.00000000025,
	   0.00000000116,    -0.00000000014,
	  -0.00000000016,    -0.00000000121,
	   0.00000000022,    -0.00000000060,
	  -0.00000000133,     0.00000000086,
	   0.00000000086,     0.00000000136,
	   0.00000000047,     0.00000000064,
	   0.00000000076,    -0.00000000044,
	   0.00000000173,     0.00000000013,
	   0.00000000024,    -0.00000000174,
	   0.00006601665,     0.00000020968,
	  -0.00000003916,    -0.00000000215,
	   0.00000000019,    -0.00000000781,
	   0.00000033019,    -0.00008395476,
	  -0.00000000317,     0.00000004126,
	  -0.00000001007,    -0.00000000014,
	  -0.00000159441,    -0.00000205443,
	  -0.00000005685,     0.00000030315,
	   0.00000000345,     0.00000000759,
	   0.00000024603,    -0.00000398491,
	  -0.00000009868,    -0.00000018183,
	  -0.00000000308,     0.00000001229,
	  -0.00000013815,     0.00000001540,
	  -0.00000000506,    -0.00000001164,
	   0.00000000027,    -0.00000000054,
	  -0.00000001144,    -0.00000017699,
	   0.00000000901,    -0.00000000661,
	   0.00000000041,     0.00000000034,
	  -0.00000001588,    -0.00000002013,
	   0.00000000099,     0.00000001465,
	   0.00000002943,    -0.00000001277,
	   0.00000000128,     0.00000000213,
	  -0.00000001299,    -0.00000002940,
	   0.00000000215,    -0.00000000127,
	  -0.00000000289,    -0.00000000730,
	  -0.00000000203,     0.00000000130,
	  -0.00000000827,     0.00000000713,
	   0.00000000287,     0.00000000200,
	   0.00000001354,    -0.00000002281,
	  -0.00000000732,    -0.00000000297,
	  -0.00000002349,    -0.00000001389,
	  -0.00000000306,     0.00000000757,
	   0.00000000352,    -0.00000000045,
	  -0.00000000059,    -0.00000000476,
	   0.00000000016,     0.00000000095,
	   0.00000000106,    -0.00000000051,
	  -0.00000000333,     0.00000000087,
	  -0.00000000003,     0.00000000042,
	   0.00000000188,     0.00000000318,
	   0.00000000042,    -0.00000000011,
	  -0.00000001052,    -0.00000000054,
	  -0.00000000048,     0.00000000052,
	  -0.00000000063,     0.00000001099,
	   0.00000000065,     0.00000000048,
	   0.00000000481,     0.00000000198,
	   0.00000000036,    -0.00000000031,
	   0.00000000233,    -0.00000000568,
	  -0.00000000040,    -0.00000000045,
	   0.00000000398,     0.00000000004,
	   0.00000000018,    -0.00000000433,
	  -0.00000175805,    -0.00000013708,
	  -0.00000005146,    -0.00000009241,
	   0.00000000315,    -0.00000000248,
	  -0.00000008473,     0.00000221058,
	  -0.00000011962,     0.00000006717,
	  -0.00000000315,    -0.00000000417,
	  -0.00000081785,     0.00000006845,
	   0.00000000005,    -0.00000000639,
	   0.00000000021,    -0.00000000045,
	  -0.00000003560,    -0.00000073433,
	  -0.00000000562,     0.00000000649,
	  -0.00000000033,    -0.00000000029,
	  -0.00000000547,    -0.00000001310,
	  -0.00000000149,     0.00000000179,
	   0.00000001563,    -0.00000000036,
	  -0.00000000175,    -0.00000000129,
	   0.00000056764,    -0.00000025202,
	   0.00000002483,     0.00000004139,
	   0.00000004311,     0.00000009664,
	  -0.00000000706,     0.00000000424,
	  -0.00000000240,    -0.00000000009,
	   0.00000000081,     0.00000000187,
	   0.00000002432,    -0.00000001080,
	   0.00000005298,    -0.00000002354,
	  -0.00000000028,     0.00000000051,
	   0.00000000072,     0.00000000024,
	  -0.00000000092,     0.00000000019,
	   0.00000000022,     0.00000000097,
	   0.00000003608,    -0.00000005915,
	  -0.00000001911,    -0.00000000802,
	  -0.00000008365,    -0.00000003302,
	  -0.00000000506,     0.00000002682,
	   0.00000011061,    -0.00000001647,
	  -0.00000000858,    -0.00000003143,
	  -0.00000001932,    -0.00000011671,
	  -0.00000003360,     0.00000000977,
	  -0.00000000013,     0.00000000066,
	   0.00000000072,     0.00000000007,
	  -0.00000000032,     0.00000000086,
	   0.00000000092,     0.00000000033,
	   0.00000000138,     0.00000000353,
	   0.00000000064,    -0.00000000001,
	   0.00000000493,    -0.00000000191,
	  -0.00000000003,    -0.00000000091,
	  -0.00000000144,    -0.00000000240,
	  -0.00000000221,     0.00000000150,
	  -0.00000003287,    -0.00000000298,
	  -0.00000000153,     0.00000000178,
	  -0.00000000330,     0.00000004086,
	   0.00000000219,     0.00000000192,
	  -0.00000000350,     0.00000000143,
	  -0.00000000018,     0.00000000607,
	   0.00000000957,     0.00000000289,
	   0.00000000359,    -0.00000001185,
	  -0.00000000137,    -0.00000000004,
	   0.00000000046,     0.00000000028,
	   0.00000000022,    -0.00000000050,
	  -0.00000000051,    -0.00000000021,
	   0.00000000073,    -0.00000000184,
	  -0.00000000093,    -0.00000000002,
	   0.00000000004,     0.00000000015,
	  -0.00000000274,    -0.00000000078,
	   0.00000000012,     0.00000000133,
	   0.00000000263,     0.00000000231,
	   0.00000000039,    -0.00000000119,
	   0.00000000222,    -0.00000000275,
	  -0.00000000124,    -0.00000000033,
	  -0.00000000313,     0.00000000063,
	   0.00000000080,     0.00000000397,
	   0.00000038598,    -0.00000004483,
	  -0.00000002770,    -0.00000011236,
	  -0.00000000067,    -0.00000000003,
	  -0.00000005785,    -0.00000049431,
	  -0.00000014388,     0.00000003562,
	   0.00000000002,     0.00000000094,
	  -0.00000002964,     0.00000000440,
	   0.00000000194,     0.00000000820,
	   0.00000000018,    -0.00000000035,
	   0.00000001387,    -0.00000000425,
	  -0.00000000442,    -0.00000000449,
	  -0.00000000040,    -0.00000000012,
	  -0.00000000076,     0.00000000031,
	   0.00000000002,    -0.00000000091,
	  -0.00000009158,     0.00000005996,
	   0.00000002124,     0.00000001460,
	   0.00000000081,    -0.00000000198,
	   0.00000008722,     0.00000011504,
	   0.00000001796,    -0.00000002874,
	  -0.00000000266,    -0.00000000098,
	  -0.00000002283,    -0.00000008906,
	  -0.00000000873,     0.00000000559,
	   0.00000000018,     0.00000000044,
	  -0.00000008804,     0.00000003205,
	   0.00000000820,     0.00000000768,
	   0.00000000027,    -0.00000000047,
	   0.00000000000,     0.00000000080,
	  -0.00000018192,    -0.00000063429,
	  -0.00000006052,     0.00000004866,
	   0.00000000227,     0.00000000254,
	  -0.00000078593,     0.00000025642,
	   0.00000006161,     0.00000007515,
	   0.00000000316,    -0.00000000285,
	   0.00000026440,     0.00000001428,
	   0.00000000587,     0.00000000063,
	  -0.00000004230,    -0.00000027446,
	   0.00000000106,     0.00000000475,
	   0.00000000046,    -0.00000000004,
	  -0.00000000001,     0.00000000243,
	  -0.00000000257,    -0.00000000003,
	  -0.00000000228,    -0.00000000303,
	  -0.00000000302,     0.00000000228,
	   0.00000277534,     0.00000000598,
	   0.00000000155,    -0.00000000053,
	   0.00000000974,    -0.00000331140,
	  -0.00000000078,    -0.00000000198,
	  -0.00000003738,    -0.00000009732,
	  -0.00000000005,     0.00000001479,
	  -0.00000000086,    -0.00000019298,
	  -0.00000000158,    -0.00000000973,
	  -0.00000000001,     0.00000000057,
	  -0.00000000874,    -0.00000000360,
	   0.00000000035,    -0.00000000083,
	   0.00000000332,    -0.00000000950,
	   0.00000000077,     0.00000000037,
	  -0.00000004659,    -0.00000007546,
	   0.00000000260,    -0.00000000005,
	   0.00000003613,    -0.00000001600,
	   0.00000000162,     0.00000000262,
	  -0.00000001608,    -0.00000003616,
	   0.00000000262,    -0.00000000161,
	  -0.00000000602,    -0.00000006943,
	   0.00000000651,     0.00000000433,
	  -0.00000000021,     0.00000000027,
	  -0.00000007926,     0.00000001000,
	   0.00000000481,    -0.00000000739,
	   0.00000000030,     0.00000000024,
	  -0.00000001993,     0.00000000180,
	   0.00000000038,    -0.00000000030,
	  -0.00000000631,    -0.00000001826,
	  -0.00000000121,    -0.00000000049,
	   0.00000000065,    -0.00000000108,
	   0.00000135059,    -0.00000060078,
	   0.00000005938,     0.00000009857,
	   0.00000005992,     0.00000013472,
	  -0.00000000982,     0.00000000592,
	  -0.00000000173,    -0.00000000396,
	  -0.00000000205,     0.00000000056,
	   0.00000000056,    -0.00000000057,
	  -0.00000000057,    -0.00000000056,
	  -0.00000000015,    -0.00000000061,
	   0.00000000060,     0.00000000025,
	   0.00000000036,    -0.00000000101,
	  -0.00000000077,     0.00000000062,
	   0.00000000096,     0.00000000087,
	  -0.00000000020,    -0.00000000040,
	  -0.00000000042,     0.00000000022,
	  -0.00000000048,    -0.00000000102,
	  -0.00000000142,     0.00000000071,
	   0.00000000010,    -0.00000000033,
	  -0.00000000043,    -0.00000000013,
	  -0.00000000017,    -0.00000000061,
	   0.00000000093,     0.00000000019,
	   0.00000000018,    -0.00000000098,
	   0.00000000313,     0.00000000065,
	   0.00000000083,    -0.00000000398,
	   0.00000000120,     0.00000000041,
	   0.00000000054,    -0.00000000149,
	  -0.00000000066,    -0.00000000015,
	  -0.00000000008,     0.00000000058,
	  -0.00000000937,    -0.00000000156,
	  -0.00000000196,     0.00000001129,
	   0.00000000252,     0.00000000030,
	  -0.00000000016,    -0.00000000181,
	  -0.00000000369,     0.00000000111,
	   0.00000000111,     0.00000000369,
	  -0.00000000074,     0.00000000004,
	   0.00000000006,     0.00000000083,
	   0.00000004965,    -0.00000000003,
	  -0.00000000004,    -0.00000005784,
	  -0.00000000056,    -0.00000000156,
	   0.00000000029,    -0.00000000358,
	  -0.00000018705,     0.00000005683,
	  -0.00000000105,    -0.00000000335,
	   0.00000004944,    -0.00000002195,
	   0.00000000217,     0.00000000360,
	  -0.00000002194,    -0.00000004938,
	   0.00000000360,    -0.00000000217,
	  -0.00000002831,     0.00000001454,
	  -0.00000000071,    -0.00000000135,
	   0.00000000105,    -0.00000000011,
	  -0.00000000011,    -0.00000000119,
	   0.00000378020,    -0.00000167945,
	   0.00000016594,     0.00000027614,
	   0.00000008578,     0.00000019319,
	  -0.00000001409,     0.00000000847,
	   0.00000000200,    -0.00000000155,
	  -0.00000000228,    -0.00000000440,
	   0.00000000075,     0.00000000004,
	   0.00000000005,    -0.00000000083,
	   0.00000003790,    -0.00000001951,
	   0.00000000060,     0.00000000114,
	   0.00000000104,    -0.00000000062,
	   0.00000000062,     0.00000000104,
	  -0.00000003677,     0.00000001388,
	  -0.00000000045,    -0.00000000121,
	  -0.00000000057,    -0.00000000002,
	  -0.00000000003,    -0.00000000049,
	   0.00000000027,    -0.00000000087,
	  -0.00000000087,    -0.00000000027,
	   0.00000001517,    -0.00000000001,
	  -0.00000000001,    -0.00000001758,
	  -0.00000000022,    -0.00000000048,
	   0.00000000009,    -0.00000000107,
	   0.00000002828,    -0.00000001067,
	   0.00000000052,     0.00000000143,
	   0.00000002212,    -0.00000006946,
	   0.00000000084,     0.00000000029,
	   0.00000006147,    -0.00000002733,
	   0.00000000270,     0.00000000448,
	  -0.00000002733,    -0.00000006147,
	   0.00000000448,    -0.00000000270,
	   0.00000737700,    -0.00000328098,
	   0.00000032445,     0.00000053985,
	  -0.00000002158,     0.00000001339,
	   0.00000010778,     0.00000024251,
	  -0.00000001769,     0.00000001064,
	  -0.00000000044,    -0.00000000070,
	  -0.00000000073,    -0.00000000066,
	   0.00000000129,    -0.00000000052,
	  -0.00000000052,    -0.00000000129,
	   0.00000000128,    -0.00000000051,
	   0.00000000051,     0.00000000128,
	   0.00000000111,     0.00000000072,
	  -0.00000000011,     0.00000000012,
	   0.00000000309,     0.00000000251,
	  -0.00000000028,     0.00000000028,
	  -0.00000000251,     0.00000000309,
	  -0.00000000028,    -0.00000000027,
	   0.00000000021,     0.00000000001,
	  -0.00000000001,     0.00000000026,
	  -0.00000000049,    -0.00000000007,
	  -0.00000000098,     0.00000000139,
	  -0.00000000140,    -0.00000000097,
	  -0.00000000231,    -0.00000000007,
	  -0.00000000004,    -0.00000000071,
	  -0.00000000281,     0.00000000611,
	  -0.00000000103,    -0.00000000044,
	  -0.00000000621,    -0.00000000278,
	   0.00000000041,    -0.00000000108,
	  -0.00000000105,    -0.00000000039,
	   0.00000000045,    -0.00000000098,
	   0.00000000133,    -0.00000003566,
	   0.00000000926,    -0.00000000076,
	   0.00000000009,     0.00000000101,
	   0.00000002511,     0.00000000056,
	   0.00000000021,     0.00000000709,
	  -0.00000000076,     0.00000000005,
	   0.00000006115,    -0.00000010400,
	   0.00000001752,     0.00000000885,
	  -0.00000000069,     0.00000000126,
	   0.00000010559,     0.00000006059,
	  -0.00000000856,     0.00000001808,
	  -0.00000000134,    -0.00000000064,
	   0.00000001611,    -0.00000000044,
	   0.00000000047,    -0.00000000022,
	  -0.00000000004,     0.00000001563,
	   0.00000000029,     0.00000000039,
	   0.00000000582,    -0.00000000644,
	   0.00000000110,     0.00000000078,
	   0.00000000645,     0.00000000582,
	  -0.00000000078,     0.00000000111,
	   0.00000000070,    -0.00000000069,
	   0.00000000789,    -0.00000000872,
	   0.00000000150,     0.00000000105,
	   0.00000000875,     0.00000000789,
	  -0.00000000105,     0.00000000150,
	   0.00000000095,     0.00000000067,
	   0.00000001120,    -0.00000001238,
	   0.00000000213,     0.00000000149,
	   0.00000001240,     0.00000001120,
	  -0.00000000149,     0.00000000213,
	   0.00000001402,    -0.00000001551,
	   0.00000000266,     0.00000000187,
	   0.00000001555,     0.00000001403,
	  -0.00000000187,     0.00000000267,
	  -0.00000000059,     0.00000000001,
	  -0.00000000061,     0.00000000001,
	  -0.00000000020,     0.00000000042,
	  -0.00000000070,     0.00000000036,
	   0.00000000037,     0.00000000070,
	   0.00000000042,     0.00000000015,
	   0.00000000008,    -0.00000000111,
	  -0.00000000125,    -0.00000000006,
	   0.00000000013,    -0.00000000043,
	  -0.00000000176,     0.00000000086,
	   0.00000000196,     0.00000000134,
	  -0.00000000790,    -0.00000000386,
	  -0.00000000389,     0.00000000799,
	  -0.00000000083,    -0.00000000001,
	  -0.00000000005,     0.00000000119,
	  -0.00000000037,     0.00000000040,
	   0.00000000042,     0.00000000038,
	   0.00000000144,     0.00000000035,
	   0.00000000044,    -0.00000000156,
	  -0.00000002272,    -0.00000001180,
	  -0.00000000035,     0.00000000036,
	  -0.00000000222,     0.00000002902,
	   0.00000000083,    -0.00000000063,
	  -0.00000001675,    -0.00000008307,
	  -0.00000000099,    -0.00000000029,
	  -0.00000008427,     0.00000001708,
	  -0.00000000024,     0.00000000110,
	  -0.00000000084,     0.00000000099,
	   0.00000000105,     0.00000000097,
	   0.00000000009,     0.00000000062,
	  -0.00000005131,    -0.00000029088,
	  -0.00000000379,    -0.00000000136,
	  -0.00000000016,    -0.00000000034,
	  -0.00000028849,     0.00000013767,
	   0.00000000590,     0.00000000207,
	  -0.00000000048,    -0.00000000006,
	   0.00000040645,    -0.00000049146,
	  -0.00000000020,    -0.00000000449,
	   0.00000000006,    -0.00000000046,
	  -0.00000050147,    -0.00000041712,
	  -0.00000000511,     0.00000000128,
	  -0.00000000041,    -0.00000000008,
	  -0.00000000423,     0.00000000068,
	  -0.00000000021,    -0.00000000031,
	  -0.00000000028,     0.00000000533,
	   0.00000179425,    -0.00000209856,
	  -0.00000000162,    -0.00000002293,
	   0.00000000032,    -0.00000000185,
	  -0.00000244390,    -0.00000159345,
	   0.00000000299,     0.00000001887,
	  -0.00000000128,    -0.00000000142,
	   0.00000286834,    -0.00000013592,
	   0.00000000787,     0.00000000597,
	  -0.00000000003,    -0.00000000056,
	  -0.00000007471,    -0.00000301036,
	  -0.00000000451,    -0.00000000638,
	  -0.00000000026,     0.00000000034,
	  -0.00000000099,     0.00000000523,
	  -0.00000000670,    -0.00000000312,
	  -0.00000000174,     0.00000000004,
	   0.00000000003,     0.00000000175,
	  -0.00000000049,    -0.00000000136,
	  -0.00000000038,     0.00000000019,
	  -0.00000000138,     0.00000000050,
	   0.00000000019,     0.00000000038,
	  -0.00000000058,     0.00000000050,
	   0.00000000049,     0.00000000058,
	   0.00000000046,    -0.00000000017,
	  -0.00000000010,    -0.00000000042,
	   0.00001639012,    -0.00000053314,
	   0.00000003699,     0.00000000427,
	  -0.00000000085,    -0.00000000161,
	  -0.00000036940,    -0.00001733481,
	   0.00000000290,    -0.00000002588,
	  -0.00000000211,     0.00000000066,
	   0.00000071000,    -0.00000110928,
	   0.00000001271,     0.00000006836,
	  -0.00000000088,     0.00000000134,
	   0.00000032264,    -0.00000044608,
	   0.00000002609,    -0.00000004724,
	   0.00000000090,     0.00000000319,
	  -0.00000003381,     0.00000000423,
	  -0.00000000135,    -0.00000000272,
	  -0.00000000357,    -0.00000004237,
	   0.00000000217,    -0.00000000172,
	  -0.00000000980,     0.00000000016,
	   0.00000000007,     0.00000000284,
	  -0.00000000136,    -0.00000000400,
	  -0.00000000112,     0.00000000062,
	  -0.00000000376,     0.00000000256,
	   0.00000000105,     0.00000000096,
	   0.00000000467,    -0.00000000774,
	  -0.00000000249,    -0.00000000106,
	  -0.00000000790,    -0.00000000480,
	  -0.00000000108,     0.00000000257,
	   0.00000000137,    -0.00000000019,
	  -0.00000000023,    -0.00000000150,
	  -0.00000000185,     0.00000000080,
	   0.00000000117,     0.00000000146,
	  -0.00000000338,    -0.00000000010,
	  -0.00000000017,     0.00000000350,
	   0.00000000207,     0.00000000044,
	   0.00000000023,    -0.00000000204,
	   0.00000000136,    -0.00000000002,
	  -0.00000000004,    -0.00000000143,
	   0.00000441293,    -0.00000242623,
	   0.00000020433,     0.00000034289,
	  -0.00000001430,     0.00000000764,
	  -0.00000186684,    -0.00000312528,
	   0.00000024838,    -0.00000014894,
	   0.00000000552,     0.00000001046,
	   0.00000636710,    -0.00000002663,
	   0.00000000270,     0.00000000381,
	  -0.00000009205,     0.00000631301,
	   0.00000000439,    -0.00000001642,
	   0.00000000155,     0.00000000045,
	  -0.00000000608,    -0.00000000030,
	  -0.00000000128,    -0.00000000050,
	   0.00000000045,    -0.00000000580,
	   0.00000000050,    -0.00000000127,
	   0.00000000048,     0.00000000061,
	   0.00000000186,    -0.00000000237,
	  -0.00000000237,    -0.00000000244,
	   0.00000001667,    -0.00000002682,
	  -0.00000000863,    -0.00000000377,
	  -0.00000003043,    -0.00000001381,
	  -0.00000000250,     0.00000000972,
	   0.00000003228,    -0.00000000620,
	  -0.00000000285,    -0.00000000912,
	  -0.00000000575,    -0.00000003400,
	  -0.00000000976,     0.00000000284,
	   0.00000000039,     0.00000000013,
	   0.00000000054,     0.00000000108,
	   0.00000000133,    -0.00000000055,
	  -0.00000000025,    -0.00000000088,
	  -0.00000000090,     0.00000000075,
	  -0.00000001331,    -0.00000000047,
	  -0.00000000059,     0.00000000073,
	  -0.00000000058,     0.00000001368,
	   0.00000000073,     0.00000000064,
	  -0.00000000233,     0.00000000064,
	  -0.00000000004,     0.00000000225,
	   0.00000000559,     0.00000000032,
	   0.00000000013,    -0.00000000550,
	   0.00000000044,    -0.00000000018,
	  -0.00000013500,     0.00000004659,
	  -0.00000001082,    -0.00000001674,
	   0.00000000081,    -0.00000000106,
	   0.00000003768,     0.00000009926,
	  -0.00000001279,     0.00000000832,
	  -0.00000000084,    -0.00000000061,
	  -0.00000020355,    -0.00000000814,
	  -0.00000000636,    -0.00000001109,
	   0.00000000040,    -0.00000000033,
	   0.00000001113,    -0.00000020069,
	   0.00000001049,    -0.00000000565,
	   0.00000000024,     0.00000000036,
	   0.00000003323,     0.00000000236,
	   0.00000000129,    -0.00000000220,
	  -0.00000000224,     0.00000003338,
	   0.00000000219,     0.00000000131,
	   0.00000004268,    -0.00000004726,
	   0.00000000808,     0.00000000567,
	   0.00000000836,     0.00000000755,
	  -0.00000000101,     0.00000000144,
	  -0.00000000116,     0.00000000028,
	   0.00000000028,     0.00000000123,
	   0.00000013864,    -0.00000002494,
	  -0.00000001188,    -0.00000003950,
	  -0.00000002489,    -0.00000014711,
	  -0.00000004199,     0.00000001225,
	   0.00000000395,    -0.00000000887,
	  -0.00000000271,    -0.00000000027,
	   0.00000000354,    -0.00000000353,
	  -0.00000000112,    -0.00000000124,
	  -0.00000000038,     0.00000000112,
	   0.00000000115,     0.00000000040,
	  -0.00000000203,    -0.00000000287,
	  -0.00000000032,     0.00000000020,
	  -0.00000000293,     0.00000000205,
	  -0.00000000049,     0.00000000021,
	  -0.00000000019,     0.00000000065,
	  -0.00000000777,     0.00000000139,
	   0.00000000108,     0.00000000722,
	  -0.00000000334,     0.00000000000,
	   0.00000000047,    -0.00000000262,
	   0.00000000009,     0.00000000097,
	   0.00000000105,     0.00000000020,
	  -0.00000000015,     0.00000000111,
	   0.00000000027,    -0.00000000072,
	  -0.00000000071,    -0.00000000035,
	   0.00000000055,     0.00000000049,
	   0.00000000048,    -0.00000000062,
	   0.00000000325,     0.00000000276,
	   0.00000000043,    -0.00000000147,
	  -0.00000000019,    -0.00000000001,
	   0.00000000283,    -0.00000000390,
	  -0.00000000169,    -0.00000000040,
	  -0.00000000299,     0.00000000181,
	   0.00000000060,     0.00000000049,
	   0.00000000228,     0.00000000289,
	   0.00000000043,    -0.00000000084,
	  -0.00000000005,     0.00000000152,
	   0.00000000141,    -0.00000000091,
	   0.00000000017,    -0.00000000046,
	   0.00000000834,     0.00000000817,
	   0.00000000064,    -0.00000000309,
	  -0.00000000051,    -0.00000000018,
	   0.00000003328,    -0.00000001734,
	  -0.00000000390,    -0.00000000995,
	  -0.00000000855,     0.00000004218,
	   0.00000001200,    -0.00000000159,
	  -0.00000003729,    -0.00000010909,
	  -0.00000000968,     0.00000000885,
	   0.00000000041,     0.00000000041,
	  -0.00000011517,     0.00000004081,
	   0.00000000931,     0.00000001044,
	   0.00000000045,    -0.00000000043,
	   0.00000002007,     0.00000000427,
	   0.00000000278,     0.00000000170,
	  -0.00000001340,    -0.00000003924,
	  -0.00000000114,     0.00000000250,
	   0.00000033085,    -0.00000004355,
	   0.00000000069,     0.00000000269,
	  -0.00000003124,    -0.00000034353,
	   0.00000000193,    -0.00000000068,
	  -0.00000000889,    -0.00000007894,
	  -0.00000000533,     0.00000000692,
	   0.00000005655,    -0.00000004335,
	  -0.00000000404,    -0.00000000755,
	  -0.00000000020,     0.00000000029,
	  -0.00000000111,    -0.00000000032,
	   0.00000000028,    -0.00000000120,
	   0.00000023030,    -0.00000012139,
	   0.00000001203,     0.00000001804,
	  -0.00000000073,     0.00000000050,
	  -0.00000009370,    -0.00000016797,
	   0.00000001345,    -0.00000000929,
	   0.00000000038,     0.00000000055,
	   0.00000028652,    -0.00000000303,
	   0.00000000064,     0.00000000028,
	  -0.00000000521,     0.00000028173,
	   0.00000000038,    -0.00000000076,
	  -0.00000000082,    -0.00000000011,
	   0.00000000011,    -0.00000000082,
	  -0.00000000717,    -0.00000000523,
	   0.00000000271,    -0.00000000301,
	  -0.00000000302,    -0.00000000274,
	  -0.00000000275,    -0.00000000627,
	   0.00000000113,    -0.00000000023,
	  -0.00000000452,     0.00000000202,
	  -0.00000000020,    -0.00000000079,
	  -0.00000000115,    -0.00000000718,
	   0.00000000069,     0.00000000041,
	   0.00000000699,    -0.00000000098,
	  -0.00000000045,     0.00000000065,
	   0.00000000110,    -0.00000000047,
	   0.00000000048,     0.00000000111,
	   0.00000010304,    -0.00000011421,
	   0.00000001958,     0.00000001369,
	   0.00000001153,     0.00000001042,
	  -0.00000000139,     0.00000000198,
	  -0.00000000076,    -0.00000000016,
	  -0.00000000016,     0.00000000081,
	   0.00000000243,     0.00000000022,
	   0.00000000015,    -0.00000000263,
	  -0.00000000089,    -0.00000000026,
	   0.00000000013,    -0.00000000121,
	   0.00000000435,    -0.00000000189,
	   0.00000000018,     0.00000000031,
	  -0.00000000136,    -0.00000000316,
	   0.00000000527,    -0.00000000007,
	  -0.00000000006,     0.00000000515,
	  -0.00000001527,     0.00000001319,
	   0.00000000378,    -0.00000000418,
	   0.00000000072,     0.00000000050,
	  -0.00000000417,    -0.00000000377,
	   0.00000000050,    -0.00000000072,
	   0.00000029041,    -0.00000032157,
	   0.00000005494,     0.00000003850,
	   0.00000001647,     0.00000001489,
	  -0.00000000198,     0.00000000283,
	  -0.00000000003,    -0.00000000063,
	   0.00000000129,    -0.00000000058,
	  -0.00000000042,    -0.00000000092,
	   0.00000000162,    -0.00000000002,
	  -0.00000000002,     0.00000000159,
	   0.00000000471,    -0.00000000521,
	   0.00000000090,     0.00000000063,
	  -0.00000000521,    -0.00000000471,
	   0.00000000063,    -0.00000000090,
	   0.00000056761,    -0.00000062896,
	   0.00000010820,     0.00000007588,
	   0.00000002067,     0.00000001867,
	  -0.00000000249,     0.00000000355,
	   0.00000000024,    -0.00000000007,
	   0.00000000001,     0.00000000005,
	   0.00000000075,    -0.00000000008,
	   0.00000000000,     0.00000000013,
	   0.00000000008,     0.00000000075,
	  -0.00000000013,     0.00000000000,
	   0.00000000003,    -0.00000000003,
	   0.00000000004,     0.00000000004,
	   0.00000000008,     0.00000000115,
	  -0.00000000116,     0.00000000008,
	  -0.00000000222,    -0.00000000472,
	   0.00000000164,    -0.00000000102,
	   0.00000000017,     0.00000000024,
	   0.00000000299,    -0.00000000143,
	   0.00000000077,     0.00000000115,
	   0.00000000089,    -0.00000001834,
	   0.00000000477,    -0.00000000018,
	   0.00000000002,     0.00000000055,
	   0.00000001849,     0.00000000074,
	   0.00000000027,     0.00000000483,
	  -0.00000000056,     0.00000000004,
	   0.00000000245,    -0.00000000087,
	   0.00000000075,     0.00000000241,
	   0.00000000030,    -0.00000000091,
	   0.00000000091,     0.00000000030,
	   0.00000000041,    -0.00000000123,
	   0.00000000124,     0.00000000040,
	   0.00000000058,    -0.00000000175,
	   0.00000000175,     0.00000000058,
	   0.00000000072,    -0.00000000219,
	   0.00000000220,     0.00000000072,
	  -0.00000000096,     0.00000000039,
	   0.00000000078,     0.00000000070,
	  -0.00000000301,    -0.00000000161,
	  -0.00000000163,     0.00000000305,
	   0.00000000012,    -0.00000000053,
	  -0.00000001033,    -0.00000000589,
	  -0.00000000207,     0.00000001144,
	  -0.00000000535,    -0.00000002841,
	  -0.00000000035,    -0.00000000019,
	  -0.00000002902,     0.00000000534,
	  -0.00000000017,     0.00000000040,
	   0.00000000028,     0.00000000027,
	  -0.00000001852,    -0.00000011604,
	  -0.00000000154,    -0.00000000093,
	  -0.00000000008,    -0.00000000013,
	  -0.00000010398,     0.00000004156,
	   0.00000000131,     0.00000000092,
	   0.00000011668,    -0.00000014523,
	   0.00000000022,    -0.00000000157,
	  -0.00000014791,    -0.00000012264,
	  -0.00000000185,     0.00000000015,
	  -0.00000000094,     0.00000000027,
	  -0.00000000015,     0.00000000129,
	   0.00000058383,    -0.00000069382,
	   0.00000000057,    -0.00000000891,
	   0.00000000003,    -0.00000000061,
	  -0.00000070801,    -0.00000048214,
	  -0.00000000164,     0.00000000379,
	  -0.00000000042,    -0.00000000029,
	   0.00000069096,    -0.00000007487,
	   0.00000000377,     0.00000000186,
	  -0.00000003074,    -0.00000073959,
	  -0.00000000122,    -0.00000000366,
	  -0.00000000063,     0.00000000174,
	  -0.00000000200,    -0.00000000098,
	  -0.00000000017,    -0.00000000050,
	  -0.00000000051,     0.00000000018,
	   0.00000421912,    -0.00000029388,
	   0.00000002110,     0.00000000179,
	  -0.00000000043,    -0.00000000029,
	  -0.00000020488,    -0.00000401196,
	   0.00000000134,    -0.00000001467,
	  -0.00000000045,     0.00000000033,
	   0.00000032620,    -0.00000041538,
	   0.00000000787,     0.00000002137,
	  -0.00000000048,     0.00000000044,
	   0.00000012001,    -0.00000011222,
	   0.00000001366,    -0.00000001579,
	   0.00000000049,     0.00000000106,
	  -0.00000000864,     0.00000000127,
	  -0.00000000039,    -0.00000000067,
	  -0.00000000116,    -0.00000001071,
	   0.00000000054,    -0.00000000048,
	  -0.00000000061,    -0.00000000191,
	  -0.00000000054,     0.00000000028,
	  -0.00000000165,     0.00000000097,
	   0.00000000040,     0.00000000043,
	   0.00000000160,    -0.00000000273,
	  -0.00000000085,    -0.00000000037,
	  -0.00000000279,    -0.00000000170,
	  -0.00000000040,     0.00000000087,
	  -0.00000000013,    -0.00000000037,
	  -0.00000000072,     0.00000000051,
	   0.00000000064,     0.00000000061,
	  -0.00000000109,     0.00000000001,
	  -0.00000000006,     0.00000000115,
	   0.00000000083,    -0.00000000002,
	  -0.00000000014,    -0.00000000066,
	   0.00000000050,    -0.00000000003,
	  -0.00000000002,    -0.00000000054,
	   0.00000164888,    -0.00000097009,
	   0.00000008465,     0.00000012680,
	  -0.00000000534,     0.00000000337,
	  -0.00000071248,    -0.00000115502,
	   0.00000009085,    -0.00000005889,
	   0.00000000227,     0.00000000386,
	   0.00000184951,    -0.00000012048,
	   0.00000001171,     0.00000000379,
	  -0.00000000040,     0.00000000037,
	   0.00000004066,     0.00000180850,
	   0.00000000241,    -0.00000000110,
	   0.00000000066,     0.00000000015,
	  -0.00000000214,     0.00000000035,
	  -0.00000000049,    -0.00000000029,
	  -0.00000000043,    -0.00000000230,
	   0.00000000029,    -0.00000000050,
	   0.00000000672,    -0.00000001094,
	  -0.00000000352,    -0.00000000154,
	  -0.00000001095,    -0.00000000528,
	  -0.00000000102,     0.00000000351,
	   0.00000000953,    -0.00000000240,
	  -0.00000000100,    -0.00000000268,
	  -0.00000000189,    -0.00000001031,
	  -0.00000000298,     0.00000000087,
	  -0.00000000031,     0.00000000038,
	  -0.00000000472,    -0.00000000003,
	  -0.00000000022,     0.00000000025,
	  -0.00000000003,     0.00000000437,
	  -0.00000000101,     0.00000000044,
	  -0.00000000011,     0.00000000073,
	   0.00000000216,    -0.00000000006,
	  -0.00000000007,    -0.00000000178,
	   0.00000000035,    -0.00000000018,
	   0.00000024772,    -0.00000035347,
	   0.00000005842,     0.00000003501,
	  -0.00000000278,     0.00000000470,
	  -0.00000017718,    -0.00000010962,
	   0.00000001583,    -0.00000002890,
	   0.00000000230,     0.00000000132,
	   0.00000071040,    -0.00000037297,
	   0.00000003285,     0.00000005440,
	  -0.00000000226,     0.00000000130,
	   0.00000036512,     0.00000071029,
	  -0.00000005448,     0.00000003100,
	  -0.00000000108,    -0.00000000227,
	   0.00000000841,     0.00000000081,
	   0.00000000024,    -0.00000000061,
	  -0.00000000079,     0.00000000844,
	   0.00000000061,     0.00000000024,
	   0.00000004729,    -0.00000001017,
	  -0.00000000443,    -0.00000001340,
	  -0.00000000888,    -0.00000004519,
	  -0.00000001285,     0.00000000404,
	   0.00000000276,    -0.00000000475,
	  -0.00000000144,    -0.00000000040,
	   0.00000000163,    -0.00000000126,
	  -0.00000000036,    -0.00000000059,
	   0.00000000047,     0.00000000010,
	  -0.00000000071,    -0.00000000106,
	  -0.00000000107,     0.00000000071,
	  -0.00000000353,     0.00000000062,
	   0.00000000051,     0.00000000329,
	  -0.00000000159,     0.00000000007,
	   0.00000000012,    -0.00000000125,
	   0.00000000064,    -0.00000000003,
	  -0.00000000009,     0.00000000067,
	  -0.00000000900,     0.00000000829,
	  -0.00000000213,    -0.00000000164,
	   0.00000000011,    -0.00000000026,
	   0.00000000434,     0.00000000439,
	  -0.00000000084,     0.00000000106,
	  -0.00000002247,     0.00000000766,
	  -0.00000000185,    -0.00000000269,
	  -0.00000000744,    -0.00000002239,
	   0.00000000267,    -0.00000000178,
	   0.00000000316,    -0.00000000095,
	   0.00000000096,     0.00000000316,
	   0.00000000216,    -0.00000000658,
	   0.00000000119,     0.00000000039,
	   0.00000001193,    -0.00000000811,
	  -0.00000000219,    -0.00000000233,
	  -0.00000000555,    -0.00000000803,
	  -0.00000000155,     0.00000000151,
	   0.00000001561,    -0.00000000320,
	  -0.00000000141,    -0.00000000442,
	   0.00000000277,     0.00000001533,
	   0.00000000436,    -0.00000000135,
	   0.00000000041,    -0.00000000017,
	  -0.00000000095,    -0.00000000009,
	  -0.00000000008,     0.00000000069,
	  -0.00000000034,    -0.00000000030,
	  -0.00000000113,     0.00000000070,
	   0.00000000044,     0.00000000074,
	  -0.00000000132,     0.00000000020,
	  -0.00000000015,    -0.00000000129,
	   0.00000000088,     0.00000000066,
	   0.00000000010,    -0.00000000035,
	   0.00000000063,    -0.00000000087,
	  -0.00000000052,     0.00000000031,
	   0.00000000049,     0.00000000056,
	  -0.00000000421,     0.00000000304,
	   0.00000000104,     0.00000000062,
	   0.00000000311,     0.00000000406,
	   0.00000000060,    -0.00000000102,
	  -0.00000000034,    -0.00000000162,
	  -0.00000000220,     0.00000000133,
	  -0.00000000637,    -0.00000001942,
	  -0.00000000172,     0.00000000142,
	  -0.00000001803,     0.00000000666,
	   0.00000000142,     0.00000000157,
	   0.00000000434,    -0.00000000111,
	  -0.00000000113,    -0.00000000232,
	   0.00000003985,    -0.00000001159,
	   0.00000000025,     0.00000000070,
	  -0.00000000825,    -0.00000003843,
	   0.00000000050,    -0.00000000019,
	  -0.00000000258,    -0.00000001509,
	  -0.00000000088,     0.00000000138,
	   0.00000001067,    -0.00000000875,
	  -0.00000000085,    -0.00000000134,
	   0.00000004164,    -0.00000002688,
	   0.00000000271,     0.00000000342,
	  -0.00000000014,     0.00000000013,
	  -0.00000001938,    -0.00000003049,
	   0.00000000251,    -0.00000000195,
	   0.00000003763,    -0.00000000811,
	   0.00000000030,     0.00000000053,
	   0.00000000538,     0.00000003608,
	  -0.00000000031,    -0.00000000018,
	   0.00000001457,    -0.00000001984,
	   0.00000000346,     0.00000000199,
	  -0.00000000015,     0.00000000029,
	  -0.00000001045,    -0.00000000706,
	   0.00000000097,    -0.00000000179,
	   0.00000003633,    -0.00000001865,
	   0.00000000185,     0.00000000278,
	   0.00000001803,     0.00000003629,
	  -0.00000000278,     0.00000000170,
	  -0.00000000046,    -0.00000000046,
	  -0.00000000046,    -0.00000000097,
	   0.00000000096,    -0.00000000045,
	   0.00000000524,    -0.00000001599,
	   0.00000000164,     0.00000000054,
	   0.00000000069,    -0.00000000031,
	   0.00000000030,     0.00000000069,
	   0.00000001483,    -0.00000004518,
	   0.00000000233,     0.00000000077,
	   0.00000002899,    -0.00000008843,
	   0.00000000292,     0.00000000096,
	   0.00000000002,    -0.00000000004,
	   0.00000000008,    -0.00000000010,
	   0.00000000010,     0.00000000008,
	  -0.00000000057,    -0.00000000046,
	   0.00000000019,    -0.00000000032,
	   0.00000000029,    -0.00000000033,
	  -0.00000000112,    -0.00000000245,
	   0.00000000089,    -0.00000000052,
	   0.00000000246,    -0.00000000114,
	   0.00000000054,     0.00000000089,
	   0.00000000037,    -0.00000000035,
	   0.00000000033,     0.00000000038,
	   0.00000000031,     0.00000000034,
	  -0.00000000115,    -0.00000000064,
	  -0.00000000066,     0.00000000117,
	  -0.00000000445,    -0.00000000265,
	  -0.00000000114,     0.00000000448,
	  -0.00000000185,    -0.00000000973,
	  -0.00000001002,     0.00000000177,
	  -0.00000000707,    -0.00000004398,
	  -0.00000000061,    -0.00000000046,
	  -0.00000003691,     0.00000001330,
	   0.00000000025,     0.00000000039,
	   0.00000003360,    -0.00000004429,
	   0.00000000014,    -0.00000000056,
	  -0.00000004490,    -0.00000003652,
	  -0.00000000067,    -0.00000000003,
	   0.00000018393,    -0.00000022670,
	   0.00000000060,    -0.00000000334,
	  -0.00000000001,    -0.00000000019,
	  -0.00000021175,    -0.00000014503,
	  -0.00000000115,     0.00000000063,
	   0.00000017458,    -0.00000003355,
	   0.00000000158,     0.00000000053,
	  -0.00000001203,    -0.00000019136,
	  -0.00000000033,    -0.00000000156,
	  -0.00000000025,     0.00000000057,
	  -0.00000000061,    -0.00000000030,
	   0.00000111844,    -0.00000013302,
	   0.00000000969,     0.00000000063,
	  -0.00000000019,    -0.00000000001,
	  -0.00000009210,    -0.00000099062,
	   0.00000000051,    -0.00000000667,
	   0.00000012143,    -0.00000014518,
	   0.00000000348,     0.00000000653,
	   0.00000004045,    -0.00000003032,
	   0.00000000536,    -0.00000000527,
	   0.00000000020,     0.00000000034,
	  -0.00000000227,     0.00000000041,
	  -0.00000000040,    -0.00000000280,
	   0.00000056367,    -0.00000035099,
	   0.00000003130,     0.00000004285,
	  -0.00000000182,     0.00000000130,
	  -0.00000025000,    -0.00000039098,
	   0.00000003043,    -0.00000002120,
	   0.00000000085,     0.00000000130,
	   0.00000051878,    -0.00000006488,
	   0.00000000636,     0.00000000182,
	   0.00000002503,     0.00000049803,
	   0.00000000128,    -0.00000000008,
	  -0.00000000072,     0.00000000021,
	  -0.00000000026,    -0.00000000082,
	  -0.00000000005,    -0.00000000057,
	   0.00000010997,    -0.00000016954,
	   0.00000002800,     0.00000001541,
	  -0.00000000121,     0.00000000229,
	  -0.00000008990,    -0.00000005330,
	   0.00000000771,    -0.00000001463,
	   0.00000000119,     0.00000000063,
	   0.00000026417,    -0.00000015384,
	   0.00000001433,     0.00000001997,
	  -0.00000000084,     0.00000000064,
	   0.00000014721,     0.00000026407,
	  -0.00000002004,     0.00000001276,
	  -0.00000000045,    -0.00000000084,
	   0.00000000218,     0.00000000025,
	  -0.00000000025,     0.00000000219,
	  -0.00000000026,     0.00000000035,
	   0.00000000713,    -0.00000003937,
	   0.00000000939,     0.00000000086,
	  -0.00000000005,     0.00000000113,
	  -0.00000001372,    -0.00000000159,
	   0.00000000009,    -0.00000000329,
	   0.00000005227,    -0.00000007081,
	   0.00000001186,     0.00000000735,
	  -0.00000000056,     0.00000000096,
	   0.00000007031,     0.00000005251,
	  -0.00000000744,     0.00000001170,
	  -0.00000000094,    -0.00000000058,
	   0.00000000112,    -0.00000000037,
	   0.00000000037,     0.00000000112,
	  -0.00000000045,     0.00000000104,
	  -0.00000000032,    -0.00000000009,
	   0.00000000038,     0.00000000015,
	  -0.00000000188,     0.00000000170,
	  -0.00000000042,    -0.00000000033,
	  -0.00000000168,    -0.00000000189,
	   0.00000000033,    -0.00000000041,
	  -0.00000000079,     0.00000000064,
	   0.00000000060,     0.00000000072,
	  -0.00000000035,     0.00000000028,
	  -0.00000000147,    -0.00000000277,
	  -0.00000000019,     0.00000000026,
	  -0.00000000255,     0.00000000127,
	  -0.00000000070,    -0.00000000087,
	   0.00000000446,    -0.00000000277,
	  -0.00000000184,    -0.00000000423,
	  -0.00000000041,    -0.00000000301,
	   0.00000000217,    -0.00000000141,
	  -0.00000000027,    -0.00000000084,
	  -0.00000000063,     0.00000000034,
	   0.00000000053,    -0.00000000097,
	  -0.00000000099,    -0.00000000059,
	   0.00000000253,    -0.00000000427,
	  -0.00000000136,    -0.00000000058,
	  -0.00000000393,    -0.00000000191,
	  -0.00000000038,     0.00000000124,
	   0.00000000286,    -0.00000000097,
	  -0.00000000035,    -0.00000000078,
	  -0.00000000068,    -0.00000000325,
	  -0.00000000091,     0.00000000030,
	   0.00000001556,    -0.00000000410,
	  -0.00000000162,    -0.00000000438,
	  -0.00000000326,    -0.00000001376,
	  -0.00000000392,     0.00000000137,
	   0.00000000134,    -0.00000000214,
	  -0.00000000063,    -0.00000000022,
	   0.00000000061,    -0.00000000041,
	   0.00000000542,    -0.00000000413,
	  -0.00000000108,    -0.00000000107,
	  -0.00000000281,    -0.00000000369,
	  -0.00000000072,     0.00000000076,
	   0.00000000572,    -0.00000000150,
	  -0.00000000059,    -0.00000000162,
	   0.00000000116,     0.00000000554,
	   0.00000000159,    -0.00000000053,
	   0.00000000073,    -0.00000000120,
	  -0.00000000051,    -0.00000000032,
	   0.00000000193,    -0.00000000137,
	  -0.00000000036,    -0.00000000038,
	   0.00000000134,     0.00000000192,
	   0.00000000038,    -0.00000000035,
	   0.00000000677,    -0.00000000521,
	   0.00000000055,     0.00000000059,
	  -0.00000000365,    -0.00000000500,
	   0.00000000041,    -0.00000000037,
	   0.00000000471,    -0.00000000212,
	   0.00000000143,     0.00000000434,
	   0.00000000308,    -0.00000000501,
	   0.00000000087,     0.00000000042,
	  -0.00000000278,    -0.00000000167,
	   0.00000000023,    -0.00000000048,
	   0.00000000636,    -0.00000000431,
	   0.00000000044,     0.00000000050,
	   0.00000000405,     0.00000000634,
	  -0.00000000050,     0.00000000038,
	   0.00000000046,    -0.00000000235,
	   0.00000000057,     0.00000000005,
	  -0.00000000090,    -0.00000000013,
	   0.00000000293,    -0.00000000386,
	   0.00000000067,     0.00000000040,
	   0.00000000382,     0.00000000295,
	  -0.00000000040,     0.00000000065,
	   0.00000000037,     0.00000000028,
	  -0.00000000163,     0.00000000010,
	   0.00000000002,     0.00000000137,
	  -0.00000000031,     0.00000000019,
	  -0.00000000156,     0.00000000034,
	   0.00000000027,     0.00000000129,
	  -0.00000000068,     0.00000000003,
	   0.00000000003,    -0.00000000054,
	  -0.00000000049,     0.00000000034,
	  -0.00000000058,     0.00000000013,
	  -0.00000000010,    -0.00000000056,
	  -0.00000000030,    -0.00000000024,
	   0.00000000025,    -0.00000000030,
	  -0.00000000044,    -0.00000000025,
	  -0.00000000026,     0.00000000044,
	  -0.00000000183,    -0.00000000111,
	  -0.00000000053,     0.00000000172,
	  -0.00000000067,    -0.00000000331,
	  -0.00000000343,     0.00000000061,
	  -0.00000000273,    -0.00000001603,
	  -0.00000000023,    -0.00000000020,
	  -0.00000001288,     0.00000000435,
	   0.00000000961,    -0.00000001374,
	  -0.00000001381,    -0.00000001091,
	   0.00000005647,    -0.00000007352,
	   0.00000000032,    -0.00000000125,
	  -0.00000006449,    -0.00000004321,
	  -0.00000000055,     0.00000000005,
	   0.00000004540,    -0.00000001362,
	   0.00000000062,     0.00000000014,
	  -0.00000000451,    -0.00000005104,
	  -0.00000000009,    -0.00000000065,
	   0.00000030239,    -0.00000005464,
	   0.00000000401,     0.00000000014,
	  -0.00000003748,    -0.00000025425,
	   0.00000000014,    -0.00000000273,
	   0.00000004141,    -0.00000004932,
	   0.00000000139,     0.00000000192,
	   0.00000001316,    -0.00000000859,
	   0.00000000190,    -0.00000000176,
	  -0.00000000061,     0.00000000014,
	  -0.00000000014,    -0.00000000075,
	   0.00000018446,    -0.00000012271,
	   0.00000001126,     0.00000001380,
	  -0.00000000059,     0.00000000049,
	  -0.00000008522,    -0.00000012691,
	   0.00000000974,    -0.00000000744,
	   0.00000000031,     0.00000000042,
	   0.00000014552,    -0.00000002916,
	   0.00000000287,     0.00000000072,
	   0.00000001179,     0.00000013669,
	   0.00000000056,     0.00000000006,
	   0.00000004339,    -0.00000007127,
	   0.00000001178,     0.00000000604,
	  -0.00000000047,     0.00000000097,
	  -0.00000003923,    -0.00000002226,
	   0.00000000320,    -0.00000000639,
	   0.00000000052,     0.00000000026,
	   0.00000008971,    -0.00000005685,
	   0.00000000551,     0.00000000671,
	  -0.00000000028,     0.00000000027,
	   0.00000005291,     0.00000008967,
	  -0.00000000674,     0.00000000458,
	   0.00000000057,     0.00000000008,
	  -0.00000000008,     0.00000000057,
	   0.00000000274,    -0.00000002105,
	   0.00000000500,     0.00000000023,
	   0.00000000000,     0.00000000061,
	  -0.00000000836,    -0.00000000063,
	   0.00000000001,    -0.00000000201,
	   0.00000002202,    -0.00000003287,
	   0.00000000555,     0.00000000305,
	  -0.00000000023,     0.00000000046,
	   0.00000003238,     0.00000002224,
	  -0.00000000313,     0.00000000540,
	  -0.00000000043,    -0.00000000024,
	   0.00000000038,    -0.00000000013,
	   0.00000000013,     0.00000000038,
	  -0.00000000098,    -0.00000000378,
	   0.00000000116,    -0.00000000042,
	   0.00000000008,     0.00000000018,
	  -0.00000000094,     0.00000000033,
	   0.00000000186,    -0.00000000929,
	   0.00000000223,     0.00000000024,
	   0.00000000926,     0.00000000189,
	  -0.00000000025,     0.00000000222,
	  -0.00000000036,     0.00000000023,
	   0.00000000043,    -0.00000000051,
	  -0.00000000037,    -0.00000000043,
	  -0.00000000015,    -0.00000000042,
	   0.00000000026,    -0.00000000030,
	   0.00000000101,    -0.00000000098,
	  -0.00000000067,    -0.00000000076,
	   0.00000000053,    -0.00000000047,
	   0.00000000031,     0.00000000046,
	   0.00000000090,    -0.00000000160,
	  -0.00000000050,    -0.00000000021,
	  -0.00000000139,    -0.00000000066,
	  -0.00000000014,     0.00000000043,
	   0.00000000078,    -0.00000000036,
	  -0.00000000022,    -0.00000000090,
	   0.00000000495,    -0.00000000162,
	  -0.00000000060,    -0.00000000140,
	  -0.00000000122,    -0.00000000420,
	  -0.00000000120,     0.00000000047,
	   0.00000000056,    -0.00000000088,
	   0.00000000223,    -0.00000000184,
	  -0.00000000047,    -0.00000000043,
	  -0.00000000125,    -0.00000000152,
	  -0.00000000029,     0.00000000032,
	   0.00000000199,    -0.00000000067,
	  -0.00000000027,    -0.00000000055,
	   0.00000000047,     0.00000000189,
	   0.00000000053,    -0.00000000020,
	   0.00000000038,    -0.00000000071,
	  -0.00000000041,    -0.00000000017,
	   0.00000000091,    -0.00000000071,
	   0.00000000067,     0.00000000091,
	   0.00000000058,    -0.00000000111,
	  -0.00000000064,    -0.00000000034,
	   0.00000000102,    -0.00000000086,
	   0.00000000078,     0.00000000102,
	   0.00000000058,    -0.00000000095,
	   0.00000000093,     0.00000000059,
	   0.00000000012,    -0.00000000054,
	   0.00000000053,     0.00000000012,
	   0.00000000008,     0.00000000052,
	  -0.00000000062,     0.00000000018,
	   0.00000000012,     0.00000000038,
	  -0.00000000073,    -0.00000000044,
	  -0.00000000022,     0.00000000065,
	  -0.00000000025,    -0.00000000111,
	  -0.00000000116,     0.00000000022,
	  -0.00000000106,    -0.00000000569,
	  -0.00000000442,     0.00000000146,
	   0.00000000271,    -0.00000000430,
	  -0.00000000428,    -0.00000000325,
	   0.00000001697,    -0.00000002378,
	   0.00000000014,    -0.00000000045,
	  -0.00000001984,    -0.00000001268,
	   0.00000001199,    -0.00000000520,
	  -0.00000000164,    -0.00000001392,
	   0.00000008271,    -0.00000002110,
	   0.00000000155,     0.00000000000,
	  -0.00000001436,    -0.00000006690,
	   0.00000000002,    -0.00000000105,
	   0.00000001345,    -0.00000001649,
	   0.00000000053,     0.00000000055,
	   0.00000000418,    -0.00000000252,
	   0.00000000064,    -0.00000000059,
	   0.00000005863,    -0.00000004211,
	   0.00000000398,     0.00000000429,
	  -0.00000000018,     0.00000000019,
	  -0.00000002865,    -0.00000004009,
	   0.00000000301,    -0.00000000259,
	   0.00000004102,    -0.00000001194,
	   0.00000000118,     0.00000000026,
	   0.00000000494,     0.00000003761,
	   0.00000001596,    -0.00000002805,
	   0.00000000464,     0.00000000219,
	  -0.00000000017,     0.00000000039,
	  -0.00000001580,    -0.00000000852,
	   0.00000000123,    -0.00000000264,
	   0.00000002924,    -0.00000002034,
	   0.00000000206,     0.00000000213,
	   0.00000001836,     0.00000002925,
	  -0.00000000223,     0.00000000163,
	   0.00000000093,    -0.00000000980,
	   0.00000000233,     0.00000000003,
	   0.00000000001,     0.00000000028,
	  -0.00000000424,    -0.00000000021,
	  -0.00000000002,    -0.00000000102,
	   0.00000000835,    -0.00000001349,
	   0.00000000230,     0.00000000114,
	   0.00000001317,     0.00000000850,
	  -0.00000000120,     0.00000000220,
	  -0.00000000068,    -0.00000000215,
	   0.00000000066,    -0.00000000028,
	  -0.00000000065,     0.00000000026,
	   0.00000000070,    -0.00000000471,
	   0.00000000113,     0.00000000006,
	   0.00000000468,     0.00000000073,
	  -0.00000000008,     0.00000000112,
	  -0.00000000024,    -0.00000000100,
	   0.00000000099,    -0.00000000023,
	   0.00000000030,    -0.00000000059,
	  -0.00000000045,    -0.00000000020,
	   0.00000000156,    -0.00000000063,
	  -0.00000000021,    -0.00000000043,
	  -0.00000000046,    -0.00000000128,
	  -0.00000000035,     0.00000000018,
	   0.00000000019,    -0.00000000032,
	   0.00000000089,    -0.00000000078,
	  -0.00000000052,    -0.00000000055,
	   0.00000000061,    -0.00000000022,
	   0.00000000022,     0.00000000056,
	   0.00000000033,    -0.00000000032,
	   0.00000000029,     0.00000000034,
	  -0.00000000041,    -0.00000000197,
	  -0.00000000149,     0.00000000050,
	   0.00000000075,    -0.00000000136,
	  -0.00000000133,    -0.00000000096,
	   0.00000000501,    -0.00000000766,
	  -0.00000000614,    -0.00000000368,
	   0.00000000319,    -0.00000000191,
	  -0.00000000058,    -0.00000000385,
	   0.00000002279,    -0.00000000782,
	   0.00000000058,    -0.00000000002,
	  -0.00000000528,    -0.00000001790,
	   0.00000000422,    -0.00000000546,
	   0.00000000131,    -0.00000000076,
	   0.00000001824,    -0.00000001429,
	   0.00000000139,     0.00000000129,
	  -0.00000000956,    -0.00000001242,
	   0.00000000095,    -0.00000000093,
	   0.00000001160,    -0.00000000461,
	   0.00000000047,     0.00000000013,
	   0.00000000193,     0.00000001037,
	   0.00000000558,    -0.00000001058,
	   0.00000000177,     0.00000000074,
	  -0.00000000006,     0.00000000015,
	  -0.00000000605,    -0.00000000307,
	   0.00000000044,    -0.00000000101,
	   0.00000000925,    -0.00000000714,
	   0.00000000078,     0.00000000068,
	   0.00000000624,     0.00000000927,
	  -0.00000000070,     0.00000000056,
	  -0.00000000016,    -0.00000000035,
	   0.00000000026,    -0.00000000422,
	   0.00000000102,    -0.00000000002,
	  -0.00000000194,    -0.00000000005,
	  -0.00000000002,    -0.00000000047,
	   0.00000000297,    -0.00000000523,
	   0.00000000090,     0.00000000040,
	   0.00000000505,     0.00000000306,
	  -0.00000000043,     0.00000000084,
	  -0.00000000039,    -0.00000000107,
	   0.00000000033,    -0.00000000015,
	  -0.00000000037,     0.00000000016,
	   0.00000000023,    -0.00000000210,
	   0.00000000051,     0.00000000001,
	   0.00000000208,     0.00000000025,
	  -0.00000000002,     0.00000000050,
	  -0.00000000016,    -0.00000000053,
	   0.00000000053,    -0.00000000015,
	  -0.00000000016,    -0.00000000067,
	  -0.00000000050,     0.00000000017,
	   0.00000000020,    -0.00000000043,
	  -0.00000000042,    -0.00000000028,
	   0.00000000145,    -0.00000000246,
	  -0.00000000191,    -0.00000000105,
	   0.00000000085,    -0.00000000068,
	  -0.00000000020,    -0.00000000108,
	   0.00000000631,    -0.00000000281,
	  -0.00000000188,    -0.00000000484,
	   0.00000000129,    -0.00000000180,
	   0.00000000040,    -0.00000000024,
	   0.00000000558,    -0.00000000481,
	   0.00000000049,     0.00000000039,
	  -0.00000000317,    -0.00000000379,
	   0.00000000028,    -0.00000000032,
	   0.00000000328,    -0.00000000171,
	   0.00000000072,     0.00000000286,
	   0.00000000187,    -0.00000000387,
	   0.00000000066,     0.00000000025,
	  -0.00000000224,    -0.00000000106,
	   0.00000000015,    -0.00000000038,
	   0.00000000286,    -0.00000000247,
	   0.00000000028,     0.00000000020,
	   0.00000000209,     0.00000000288,
	   0.00000000005,    -0.00000000172,
	   0.00000000042,    -0.00000000002,
	  -0.00000000083,     0.00000000000,
	   0.00000000101,    -0.00000000195,
	   0.00000000187,     0.00000000105,
	   0.00000000006,    -0.00000000088,
	   0.00000000087,     0.00000000008,
	   0.00000000041,    -0.00000000079,
	  -0.00000000060,    -0.00000000029,
	   0.00000000175,    -0.00000000099,
	  -0.00000000066,    -0.00000000132,
	   0.00000000038,    -0.00000000059,
	   0.00000000168,    -0.00000000161,
	  -0.00000000105,    -0.00000000114,
	   0.00000000093,    -0.00000000062,
	   0.00000000026,     0.00000000079,
	   0.00000000061,    -0.00000000138,
	  -0.00000000081,    -0.00000000035,
	   0.00000000087,    -0.00000000085,
	   0.00000000070,     0.00000000088,
	   0.00000000033,    -0.00000000071,
	   0.00000000067,     0.00000000035,
	   0.00000000048,    -0.00000000034,
	  -0.00000000023,    -0.00000000036,
	   0.00000000050,    -0.00000000054,
	  -0.00000000035,    -0.00000000034,
	   0.00000000026,    -0.00000000029,
	  -0.00000085202,    -0.00000258727,
	   0.00000012190,    -0.00000011320,
	   0.00000000474,     0.00000000400,
	  -0.00000145785,    -0.00000067437,
	   0.00000001093,    -0.00000002236,
	   0.00000000047,     0.00000000091,
	   0.00000033880,    -0.00000140246,
	   0.00000000574,    -0.00000001730,
	  -0.00000000006,    -0.00000000064,
	  -0.00000002150,     0.00000006922,
	  -0.00000000329,     0.00000000403,
	   0.00000000000,    -0.00000000014,
	  -0.00000006423,    -0.00000014744,
	   0.00000000033,    -0.00000000679,
	   0.00000000022,     0.00000000011,
	   0.00000166317,    -0.00000740629,
	   0.00000034623,    -0.00000016102,
	   0.00000000986,     0.00000001075,
	  -0.00000653094,    -0.00000003346,
	   0.00000000095,     0.00000000603,
	   0.00000005753,    -0.00000658243,
	   0.00000000498,    -0.00000000261,
	  -0.00000003388,     0.00000009079,
	  -0.00000000654,     0.00000000164,
	  -0.00000000002,    -0.00000000053,
	   0.00000002160,    -0.00000006350,
	   0.00000000400,    -0.00000001279,
	   0.00000173739,    -0.00001251515,
	   0.00000061248,    -0.00000036454,
	   0.00000002059,     0.00000001981,
	  -0.00001497222,    -0.00000025523,
	   0.00000000288,     0.00000000818,
	   0.00000014566,    -0.00001510907,
	   0.00000001091,    -0.00000001517,
	   0.00000000088,     0.00000000028,
	   0.00000002161,    -0.00000009633,
	   0.00000000609,    -0.00000000122,
	  -0.00000000006,     0.00000000050,
	  -0.00000001306,    -0.00000000904,
	   0.00000000136,     0.00000000831,
	  -0.00000000109,    -0.00000000083,
	   0.00001661638,    -0.00000288424,
	  -0.00000047152,     0.00000041009,
	  -0.00000000628,    -0.00000002852,
	  -0.00004629930,     0.00000132824,
	  -0.00000003925,    -0.00000007681,
	   0.00000000260,    -0.00000000693,
	  -0.00000133848,    -0.00004514523,
	  -0.00000005651,    -0.00000001916,
	   0.00000000324,    -0.00000000193,
	  -0.00000022876,    -0.00000007195,
	  -0.00000000773,     0.00000002288,
	   0.00000000124,     0.00000000266,
	   0.00000028283,    -0.00000014632,
	  -0.00000002366,    -0.00000001278,
	  -0.00000000296,     0.00000000105,
	  -0.00001980506,     0.00000803192,
	  -0.00000156484,    -0.00000190713,
	   0.00000013674,    -0.00000010442,
	   0.00000000319,     0.00000000700,
	   0.00000738864,     0.00001668416,
	  -0.00000157595,     0.00000141386,
	  -0.00000009761,    -0.00000010834,
	   0.00000000539,    -0.00000000331,
	  -0.00002955053,    -0.00000167795,
	   0.00000044260,    -0.00000006986,
	   0.00000000176,     0.00000005913,
	  -0.00000000572,    -0.00000000063,
	  -0.00000155854,    -0.00002838458,
	  -0.00000007342,    -0.00000040437,
	   0.00000006875,    -0.00000000208,
	  -0.00000000079,     0.00000000554,
	  -0.00000004362,     0.00000019800,
	   0.00000001470,     0.00000004685,
	   0.00000000135,    -0.00000000104,
	  -0.00000006497,    -0.00000000900,
	  -0.00000004325,     0.00000000606,
	   0.00000000288,     0.00000000038,
	   0.00003726944,    -0.00002189390,
	   0.00000290759,     0.00000487997,
	  -0.00000039375,     0.00000012344,
	   0.00000000400,    -0.00000002122,
	   0.00014340344,    -0.00002986817,
	  -0.00000724800,     0.00001208562,
	  -0.00000070090,    -0.00000062225,
	   0.00000003188,    -0.00000003157,
	   0.00197267636,     0.00000666684,
	  -0.00000160045,     0.00000030172,
	  -0.00000000898,     0.00000001620,
	   0.00000002275,     0.00000000384,
	   0.00000660261,     0.00196886512,
	   0.00000018228,     0.00000204169,
	  -0.00000057013,     0.00000000105,
	   0.00000000429,    -0.00000002372,
	   0.00000015541,    -0.00000056136,
	   0.00000002656,    -0.00000020416,
	  -0.00000001937,    -0.00000000023,
	   0.00000000049,     0.00000000260,
	  -0.00000056425,     0.00000098506,
	   0.00000027088,     0.00000001022,
	  -0.00000000514,    -0.00000002092,
	  -0.00000000294,    -0.00000000023,
	   0.00000927275,     0.00000382185,
	   0.00000065308,     0.00000082103,
	  -0.00000005360,     0.00000005275,
	   0.00002355019,     0.00018719456,
	  -0.00000301110,    -0.00000080670,
	   0.00000002539,     0.00000001041,
	  -0.00000000178,     0.00000000161,
	   0.00274532741,    -0.00000017282,
	  -0.00000020643,    -0.00000007682,
	   0.00000000626,     0.00000040469,
	  -0.00000040413,     0.00274676146,
	  -0.00000008068,    -0.00000015382,
	  -0.00000041175,    -0.00000000521,
	  -0.00000050054,     0.00000060786,
	  -0.00000002215,    -0.00000001699,
	  -0.00000000186,     0.00000000228,
	   0.00000005141,    -0.00000007253,
	  -0.00000000559,     0.00000001169,
	   0.00004794660,     0.00001167738,
	   0.00000128875,     0.00000226145,
	  -0.00000011869,     0.00000011382,
	   0.00003456218,    -0.00003125715,
	   0.00000041534,    -0.00000004997,
	   0.00000000989,     0.00000001234,
	   0.00343810366,    -0.00000119588,
	  -0.00000025921,    -0.00000004221,
	   0.00000001157,     0.00000050330,
	   0.00000026002,     0.00344034783,
	  -0.00000012926,    -0.00000024898,
	  -0.00000051722,    -0.00000000399,
	  -0.00000016857,     0.00000000606,
	   0.00000000620,     0.00000000514,
	  -0.00000018831,     0.00000000821,
	   0.00000000523,     0.00000000606,
	  -0.00000000038,    -0.00000000185,
	   0.00000000014,    -0.00000000009,
	  -0.00000001485,     0.00000000374,
	  -0.00000000080,    -0.00000000115,
	   0.00000000002,    -0.00000000004,
	  -0.00000001172,     0.00000000295,
	  -0.00000000046,    -0.00000000055,
	  -0.00000000221,    -0.00000001181,
	   0.00000000057,    -0.00000000046,
	   0.00000000109,     0.00000000152,
	  -0.00000000192,     0.00000000097,
	   0.00000002460,    -0.00000003270,
	  -0.00000000664,    -0.00000000530,
	  -0.00000000685,    -0.00000000163,
	   0.00000000157,    -0.00000000695,
	   0.00000001247,     0.00000000996,
	  -0.00000000995,     0.00000001247,
	   0.00000000000,     0.00000000002,
	  -0.00000000046,    -0.00000000004,
	   0.00000000017,    -0.00000000003,
	  -0.00000000003,    -0.00000000018,
	   0.00000000013,     0.00000000016,
	   0.00000000008,     0.00000000002,
	   0.00000000051,    -0.00000000069,
	  -0.00000000004,    -0.00000000001,
	   0.00000000005,    -0.00000000014,
	  -0.00000000014,    -0.00000000005,
	  -0.00000000021,    -0.00000000005,
	  -0.00000000007,     0.00000000000,
	   0.00000000000,     0.00000000008,
	   0.00000000011,     0.00000000014,
	   0.00000000334,    -0.00000000001,
	  -0.00000000001,     0.00000000332,
	   0.00000000011,     0.00000000005,
	   0.00000000018,    -0.00000000045,
	   0.00000000004,    -0.00000000003,
	  -0.00000000014,    -0.00000000068,
	   0.00000000003,    -0.00000000002,
	   0.00000000069,    -0.00000000011,
	   0.00000000002,     0.00000000003,
	   0.00000000036,     0.00000000036,
	  -0.00000000036,     0.00000000035,
	   0.00000000630,     0.00000000170,
	   0.00000000041,    -0.00000000128,
	   0.00000000003,    -0.00000000144,
	   0.00000000146,     0.00000000001,
	  -0.00000000145,     0.00000000295,
	  -0.00000000294,    -0.00000000145,
	  -0.00000000059,    -0.00000000013,
	   0.00000000004,     0.00000000002,
	   0.00000000110,    -0.00000000257,
	  -0.00000000014,    -0.00000000002,
	   0.00000000002,    -0.00000000026,
	  -0.00000000028,    -0.00000000003,
	  -0.00000000020,    -0.00000000004,
	   0.00000000000,     0.00000000010,
	  -0.00000000001,     0.00000000002,
	   0.00000000004,     0.00000000003,
	   0.00000000007,     0.00000000001,
	  -0.00000000001,     0.00000000007,
	  -0.00000000004,     0.00000000006,
	  -0.00000000006,    -0.00000000004,
	  -0.00000000012,     0.00000000006,
	   0.00000000004,     0.00000000005,
	  -0.00000000001,    -0.00000000007,
	   0.00000000102,     0.00000000013,
	   0.00000000004,     0.00000000016,
	   0.00000000142,    -0.00000000540,
	   0.00000000087,    -0.00000000022,
	  -0.00000009107,    -0.00000002070,
	  -0.00000000201,    -0.00000000417,
	   0.00000002117,    -0.00000009059,
	   0.00000000428,    -0.00000000201,
	   0.00000000346,     0.00000000708,
	   0.00000000067,    -0.00000000006,
	  -0.00000000701,     0.00000000343,
	   0.00000000007,     0.00000000067,
	  -0.00000000164,    -0.00000002903,
	  -0.00000000277,    -0.00000000559,
	  -0.00000000556,    -0.00000000260,
	  -0.00000000102,     0.00000000052,
	  -0.00000007298,    -0.00000001853,
	  -0.00000000172,    -0.00000000333,
	   0.00000001856,    -0.00000007317,
	   0.00000000334,    -0.00000000172,
	   0.00000002764,     0.00000005488,
	   0.00000000528,    -0.00000000052,
	  -0.00000005484,     0.00000002764,
	   0.00000000052,     0.00000000528,
	   0.00000000144,    -0.00000000020,
	   0.00000000020,     0.00000000144,
	   0.00000000000,    -0.00000000080,
	   0.00000000046,    -0.00000000032,
	   0.00000000097,    -0.00000000220,
	  -0.00000000078,     0.00000000001,
	   0.00000000002,     0.00000000078,
	  -0.00000000140,     0.00000000003,
	  -0.00000004447,    -0.00000000290,
	   0.00000005977,    -0.00000006541,
	   0.00000003758,    -0.00000000003,
	   0.00000000002,     0.00000003754,
	   0.00000000032,     0.00000000141,
	  -0.00000000140,     0.00000000032,
	  -0.00000000044,    -0.00000000015,
	   0.00000000071,     0.00000000001,
	   0.00000000001,    -0.00000000071,
	  -0.00000000062,    -0.00000000001,
	  -0.00000000001,     0.00000000062,
	  -0.00000000072,    -0.00000000001,
	  -0.00000000014,     0.00000000842,
	   0.00000000097,     0.00000000002,
	   0.00000000009,    -0.00000000554,
	   0.00000000065,    -0.00000000019,
	   0.00000000221,     0.00000000246,
	   0.00000000009,    -0.00000000070,
	   0.00000005904,     0.00000000747,
	  -0.00000000132,    -0.00000000483,
	   0.00000000984,     0.00000000051,
	   0.00000000047,    -0.00000000976,
	  -0.00000000015,     0.00000000110,
	  -0.00000004174,    -0.00000000528,
	   0.00000000095,     0.00000000346,
	  -0.00000000891,    -0.00000000044,
	  -0.00000000044,     0.00000000890,
	  -0.00000000003,     0.00000000179,
	   0.00000000053,     0.00000000001,
	   0.00000000002,    -0.00000000154,
	  -0.00000000083,    -0.00000000001,
	  -0.00000000001,     0.00000000083,
	   0.00000000074,     0.00000000001,
	   0.00000000001,    -0.00000000074,
	  -0.00000000001,     0.00000000108,
	   0.00000000014,    -0.00000000057,
	   0.00000000545,    -0.00000000621,
	   0.00000000084,     0.00000000068,
	  -0.00000001895,    -0.00000002015,
	   0.00000000259,    -0.00000000291,
	  -0.00000024210,    -0.00000003919,
	  -0.00000000677,    -0.00000001167,
	   0.00000000038,    -0.00000000039,
	   0.00000003884,    -0.00000024174,
	   0.00000001176,    -0.00000000679,
	   0.00000000039,     0.00000000038,
	   0.00000000312,    -0.00000001623,
	  -0.00000000117,     0.00000000045,
	   0.00000001607,     0.00000000320,
	  -0.00000000045,    -0.00000000118,
	  -0.00000000697,    -0.00000000531,
	  -0.00000000052,     0.00000000069,
	  -0.00000007439,    -0.00000001910,
	  -0.00000000176,    -0.00000000341,
	   0.00000001917,    -0.00000007445,
	   0.00000000342,    -0.00000000176,
	   0.00000000656,    -0.00000003547,
	  -0.00000000259,     0.00000000107,
	   0.00000003545,     0.00000000654,
	  -0.00000000107,    -0.00000000259,
	   0.00000000149,    -0.00000000021,
	   0.00000000021,     0.00000000149,
	  -0.00000000097,    -0.00000000061,
	   0.00000000055,    -0.00000000062,
	  -0.00000000115,     0.00000000004,
	   0.00000000002,     0.00000000118,
	   0.00000000309,     0.00000001140,
	   0.00000000244,    -0.00000000084,
	  -0.00000002381,    -0.00000009055,
	  -0.00000000296,    -0.00000000341,
	  -0.00000000016,    -0.00000000490,
	   0.00000006357,    -0.00000006943,
	   0.00000003975,     0.00000000000,
	   0.00000000002,     0.00000003973,
	   0.00000000009,    -0.00000000101,
	   0.00000000100,     0.00000000009,
	   0.00000000088,    -0.00000000210,
	   0.00000000210,     0.00000000088,
	   0.00000000062,    -0.00000000119,
	   0.00000000120,     0.00000000062,
	  -0.00000000062,    -0.00000000032,
	  -0.00000000032,     0.00000000062,
	   0.00000000071,     0.00000000032,
	  -0.00000001087,     0.00000002385,
	   0.00000000180,     0.00000000096,
	   0.00000000151,    -0.00000000008,
	  -0.00000000004,    -0.00000000155,
	  -0.00000001664,    -0.00000000768,
	  -0.00000000067,     0.00000000124,
	   0.00000009258,    -0.00000020053,
	  -0.00000001485,    -0.00000000808,
	  -0.00000001422,     0.00000000223,
	   0.00000000099,     0.00000001549,
	   0.00000000188,    -0.00000000009,
	  -0.00000000018,    -0.00000000373,
	  -0.00000000219,     0.00000000154,
	   0.00000000020,     0.00000000032,
	   0.00000000036,     0.00000000019,
	   0.00000000019,    -0.00000000036,
	  -0.00000000277,    -0.00000000368,
	  -0.00000000061,     0.00000000039,
	   0.00000001667,    -0.00000001263,
	  -0.00000000180,    -0.00000000279,
	  -0.00000000427,    -0.00000000192,
	  -0.00000000186,     0.00000000429,
	   0.00000000035,     0.00000000015,
	  -0.00000000017,     0.00000000033,
	   0.00000000174,     0.00000000088,
	   0.00000000173,    -0.00000000342,
	   0.00000000155,    -0.00000000002,
	  -0.00000000009,    -0.00000000152,
	   0.00000000105,    -0.00000000003,
	  -0.00000000005,    -0.00000000146,
	  -0.00000000051,     0.00000000004,
	  -0.00000000019,    -0.00000000142,
	  -0.00000000036,     0.00000000003,
	   0.00000000356,    -0.00000000055,
	  -0.00000000010,    -0.00000000094,
	  -0.00000000089,    -0.00000000134,
	  -0.00000000132,     0.00000000091,
	   0.00000000122,    -0.00000000163,
	  -0.00000000462,    -0.00000000302,
	  -0.00000000025,    -0.00000000040,
	   0.00000000461,     0.00000001083,
	   0.00000001064,    -0.00000000470,
	   0.00000000612,     0.00000001658,
	   0.00000002111,    -0.00000000779,
	   0.00000000089,    -0.00000000054,
	   0.00000000095,    -0.00000000075,
	   0.00000000203,     0.00000000131,
	   0.00000000090,    -0.00000000178,
	   0.00000000077,     0.00000000232,
	  -0.00000000232,     0.00000000072,
	   0.00000000029,     0.00000000029,
	  -0.00000000029,     0.00000000029,
	   0.00000000116,     0.00000000053,
	  -0.00000000004,    -0.00000000060,
	  -0.00000000059,     0.00000000005,
	   0.00000000009,     0.00000000112,
	   0.00000000253,    -0.00000000019,
	  -0.00000000003,    -0.00000000054,
	   0.00000000066,     0.00000000102,
	   0.00000000098,    -0.00000000068,
	   0.00000000039,     0.00000000058,
	   0.00000000075,    -0.00000000049,
	   0.00000000047,     0.00000000026,
	   0.00000000022,    -0.00000000047,
	   0.00000000057,     0.00000000030,
	   0.00000000032,    -0.00000000062,
	  -0.00000000029,     0.00000000063,
	   0.00000000139,     0.00000000064,
	   0.00000000022,    -0.00000000046,
	   0.00000000004,     0.00000000066,
	   0.00000000065,    -0.00000000006,
	   0.00000000020,     0.00000000032,
	   0.00000000030,    -0.00000000022,
	  -0.00000000062,     0.00000000020,
	   0.00000000019,    -0.00000000037,
	   0.00000000079,     0.00000000106,
	   0.00000000042,    -0.00000000030,
	  -0.00000000019,     0.00000000040,
	   0.00000000040,     0.00000000017,
	   0.00000000019,     0.00000000146,
	   0.00000000072,    -0.00000000010,
	  -0.00000000098,     0.00000000315,
	   0.00000000170,     0.00000000071,
	   0.00000000104,    -0.00000000086,
	  -0.00000000049,    -0.00000000058,
	  -0.00000000666,     0.00000000652,
	   0.00000000369,     0.00000000466,
	  -0.00000015636,    -0.00000001613,
	  -0.00000000208,    -0.00000001680,
	   0.00000000061,    -0.00000000036,
	  -0.00000006056,     0.00000029511,
	  -0.00000003184,    -0.00000000184,
	  -0.00000000031,    -0.00000000096,
	  -0.00000023794,    -0.00000049352,
	   0.00000000744,     0.00000000563,
	  -0.00000000059,    -0.00000000010,
	   0.00000049481,    -0.00000023898,
	  -0.00000000567,     0.00000000723,
	   0.00000000005,    -0.00000000056,
	   0.00000009789,     0.00000000453,
	   0.00000000329,    -0.00000000649,
	  -0.00000000583,     0.00000009958,
	   0.00000000644,     0.00000000327,
	   0.00000000029,    -0.00000000021,
	  -0.00000000607,     0.00000000334,
	   0.00000000084,     0.00000000127,
	  -0.00000000608,    -0.00000000136,
	   0.00000000137,    -0.00000000607,
	   0.00000000311,     0.00000000028,
	  -0.00000000028,     0.00000000311,
	   0.00000000296,     0.00000000000,
	   0.00000000000,     0.00000000296,
	  -0.00000000370,     0.00000000247,
	  -0.00000000038,    -0.00000000078,
	   0.00000000197,     0.00000000341,
	  -0.00000000071,     0.00000000023,
	  -0.00000001510,    -0.00000000192,
	  -0.00000000055,    -0.00000000137,
	   0.00000000192,    -0.00000001514,
	   0.00000000137,    -0.00000000056,
	   0.00000000639,     0.00000000428,
	   0.00000000059,    -0.00000000007,
	  -0.00000000429,     0.00000000641,
	   0.00000000007,     0.00000000059,
	  -0.00000000071,     0.00000000035,
	  -0.00000000035,    -0.00000000071,
	   0.00000000049,     0.00000000010,
	  -0.00000000010,     0.00000000049,
	   0.00000000001,     0.00000000005,
	   0.00000000005,    -0.00000000001,
	  -0.00000000017,    -0.00000000047,
	  -0.00000000017,     0.00000000049,
	   0.00000000049,     0.00000000016,
	   0.00000000043,     0.00000000014,
	  -0.00000000054,     0.00000000018,
	   0.00000000020,     0.00000000057,
	  -0.00000000067,     0.00000000023,
	   0.00000000025,     0.00000000072,
	   0.00000002447,     0.00000000255,
	  -0.00000002901,     0.00000003553,
	  -0.00000000219,    -0.00000000124,
	  -0.00000000046,     0.00000000121,
	   0.00000001003,     0.00000000165,
	  -0.00000000034,     0.00000000141,
	  -0.00000008966,    -0.00000002321,
	   0.00000000163,    -0.00000000614,
	  -0.00000000037,    -0.00000000071,
	  -0.00000000055,     0.00000000194,
	  -0.00000000096,    -0.00000000122,
	   0.00000000068,    -0.00000000052,
	   0.00000003306,     0.00000004578,
	  -0.00000000313,     0.00000000249,
	  -0.00000000405,    -0.00000000122,
	   0.00000000085,    -0.00000000417,
	   0.00000000793,    -0.00000001729,
	   0.00000000130,     0.00000000021,
	   0.00000000161,     0.00000000209,
	  -0.00000000206,     0.00000000172,
	  -0.00000000039,    -0.00000000064,
	   0.00000000111,     0.00000000094,
	   0.00000000056,    -0.00000000105,
	  -0.00000000002,    -0.00000000008,
	  -0.00000000007,     0.00000000002,
	   0.00000004481,    -0.00000001198,
	  -0.00000001431,    -0.00000003428,
	  -0.00000001304,     0.00000000758,
	   0.00000000249,     0.00000000325,
	   0.00000000488,     0.00000001695,
	   0.00000001289,    -0.00000000570,
	  -0.00000000291,    -0.00000000493,
	  -0.00000000121,     0.00000000094,
	  -0.00000020346,     0.00000005655,
	   0.00000006631,     0.00000015458,
	   0.00000005837,    -0.00000003480,
	  -0.00000001146,    -0.00000001450,
	  -0.00000001112,    -0.00000003841,
	  -0.00000002916,     0.00000001293,
	   0.00000000671,     0.00000001109,
	   0.00000000269,    -0.00000000221,
	  -0.00000000410,     0.00000000369,
	   0.00000000266,     0.00000000207,
	   0.00000000060,    -0.00000000094,
	   0.00000000385,     0.00000000245,
	   0.00000000055,    -0.00000000278,
	  -0.00000000050,    -0.00000000068,
	   0.00000000045,    -0.00000000087,
	  -0.00000000087,    -0.00000000044,
	   0.00000000056,    -0.00000000111,
	  -0.00000000111,    -0.00000000055,
	   0.00000000016,    -0.00000000041,
	  -0.00000000045,    -0.00000000019,
	  -0.00000000046,    -0.00000000015,
	   0.00000000314,    -0.00000000913,
	   0.00000001384,    -0.00000002498,
	  -0.00000000117,    -0.00000000058,
	   0.00000000994,     0.00000004985,
	   0.00000002338,    -0.00000001038,
	   0.00000000358,     0.00000001803,
	   0.00000000865,    -0.00000000473,
	  -0.00000000790,     0.00000000128,
	   0.00000000183,     0.00000000388,
	   0.00000000342,    -0.00000000343,
	  -0.00000000254,    -0.00000000168,
	   0.00000000294,     0.00000000332,
	   0.00000000174,    -0.00000000257,
	  -0.00000002586,    -0.00000011303,
	  -0.00000005396,     0.00000003060,
	   0.00000001016,     0.00000000960,
	   0.00000001879,    -0.00000000331,
	  -0.00000000457,    -0.00000000931,
	  -0.00000000167,     0.00000000157,
	  -0.00000001357,     0.00000001471,
	   0.00000001129,     0.00000000691,
	   0.00000000135,    -0.00000000376,
	  -0.00000001295,    -0.00000001542,
	  -0.00000000783,     0.00000001091,
	   0.00000000381,     0.00000000154,
	   0.00000010011,    -0.00000001434,
	  -0.00000001237,    -0.00000003676,
	  -0.00000000039,     0.00000000096,
	  -0.00000000026,     0.00000000116,
	   0.00000000118,     0.00000000033,
	   0.00000000518,    -0.00000001550,
	   0.00000000220,     0.00000000081,
	   0.00000000267,     0.00000000042,
	   0.00000000049,    -0.00000000279,
	  -0.00000009461,     0.00000017278,
	   0.00000003537,     0.00000002147,
	  -0.00000001013,    -0.00000000450,
	  -0.00000000033,     0.00000000155,
	  -0.00000000556,    -0.00000000076,
	  -0.00000000145,     0.00000000684,
	   0.00000000062,     0.00000000050,
	   0.00000007506,     0.00000000437,
	  -0.00000000185,     0.00000001294,
	   0.00000000087,     0.00000000093,
	   0.00000000010,    -0.00000000148,
	  -0.00000068774,    -0.00000012844,
	  -0.00000006400,     0.00000003700,
	   0.00000000992,    -0.00000005414,
	  -0.00000000380,    -0.00000000430,
	  -0.00000000216,     0.00000000819,
	   0.00000000107,     0.00000000005,
	  -0.00000000390,    -0.00000000369,
	  -0.00000000043,     0.00000000084,
	   0.00000000426,    -0.00000001700,
	   0.00000000408,    -0.00000000226,
	   0.00000000387,     0.00000000070,
	  -0.00000000048,     0.00000000422,
	   0.00000005123,     0.00000023716,
	   0.00000001670,    -0.00000002011,
	  -0.00000001886,     0.00000001325,
	   0.00000000181,     0.00000000103,
	  -0.00000003503,    -0.00000000608,
	  -0.00000000278,     0.00000000247,
	   0.00000000528,    -0.00000003620,
	  -0.00000000230,    -0.00000000260,
	  -0.00000001228,    -0.00000000109,
	  -0.00000000096,    -0.00000000091,
	  -0.00000000048,    -0.00000000131,
	   0.00000000138,    -0.00000000058,
	   0.00000012228,    -0.00000002640,
	   0.00000000514,     0.00000000260,
	  -0.00000000069,    -0.00000000074,
	   0.00000000514,     0.00000001177,
	   0.00000000073,    -0.00000000126,
	  -0.00000001197,     0.00000000557,
	   0.00000000128,     0.00000000063,
	  -0.00000000037,     0.00000000065,
	  -0.00000004449,    -0.00000002236,
	   0.00000000070,    -0.00000000227,
	   0.00000000387,    -0.00000000224,
	  -0.00000000060,     0.00000000048,
	   0.00000000237,     0.00000000382,
	  -0.00000000049,    -0.00000000060,
	  -0.00000000179,    -0.00000000083,
	   0.00000000079,    -0.00000000182,
	   0.00000002625,    -0.00000004727,
	  -0.00000002417,    -0.00000001029,
	  -0.00000000144,    -0.00000000073,
	  -0.00000000029,     0.00000000072,
	  -0.00000004367,    -0.00000000297,
	   0.00000000023,    -0.00000000188,
	  -0.00000000123,    -0.00000000012,
	   0.00000000014,    -0.00000000123,
	  -0.00000002745,     0.00000007656,
	   0.00000005472,     0.00000001038,
	   0.00000000054,    -0.00000001918,
	  -0.00000004057,    -0.00000001079,
	  -0.00000000319,     0.00000002773,
	   0.00000000946,    -0.00000000017,
	  -0.00000000038,    -0.00000000216,
	   0.00000003441,     0.00000001844,
	   0.00000000574,    -0.00000002139,
	  -0.00000000687,    -0.00000000018,
	   0.00000002500,    -0.00000001253,
	  -0.00000000482,    -0.00000001333,
	  -0.00000000417,     0.00000000066,
	   0.00000000071,     0.00000000187,
	   0.00000000180,    -0.00000000083,
	   0.00000010801,    -0.00000036189,
	  -0.00000025790,    -0.00000003658,
	   0.00000000216,     0.00000008901,
	   0.00000002010,    -0.00000000401,
	   0.00000009764,     0.00000002605,
	   0.00000000778,    -0.00000006634,
	  -0.00000002250,     0.00000000060,
	   0.00000000090,     0.00000000517,
	  -0.00000017379,    -0.00000013140,
	  -0.00000004565,     0.00000010884,
	   0.00000003497,     0.00000000550,
	  -0.00000000088,    -0.00000000760,
	  -0.00000016056,     0.00000007871,
	   0.00000003681,     0.00000007869,
	   0.00000002254,    -0.00000000776,
	  -0.00000000083,    -0.00000000468,
	  -0.00000001347,    -0.00000001601,
	  -0.00000000346,     0.00000000455,
	  -0.00000001588,     0.00000001397,
	   0.00000000480,     0.00000000333,
	   0.00000000366,    -0.00000000571,
	   0.00000000268,     0.00000000171,
	  -0.00000001567,     0.00000002606,
	  -0.00000000588,    -0.00000000373,
	  -0.00000000368,     0.00000000041,
	   0.00000000023,     0.00000000104,
	   0.00000000042,     0.00000000370,
	   0.00000000104,    -0.00000000026,
	  -0.00000000023,    -0.00000000092,
	  -0.00000000057,     0.00000000287,
	   0.00000000287,     0.00000000058,
	  -0.00000033558,     0.00000004713,
	   0.00000003644,     0.00000013242,
	   0.00000002628,    -0.00000001146,
	  -0.00000000042,    -0.00000000248,
	  -0.00000000564,     0.00000000796,
	   0.00000000193,     0.00000000142,
	   0.00000000800,     0.00000000610,
	   0.00000000141,    -0.00000000224,
	   0.00000000001,    -0.00000000006,
	   0.00000000003,    -0.00000000002,
	   0.00000000107,    -0.00000000016,
	  -0.00000000016,    -0.00000000105,
	  -0.00000000641,    -0.00000000207,
	   0.00000000105,    -0.00000000300,
	  -0.00000000126,    -0.00000000009,
	   0.00000000322,     0.00000000301,
	   0.00000000123,    -0.00000000141,
	  -0.00000000393,    -0.00000000174,
	   0.00000000048,     0.00000000218,
	   0.00000006162,     0.00000000240,
	  -0.00000000379,    -0.00000002503,
	  -0.00000000812,     0.00000000248,
	   0.00000000213,     0.00000000254,
	  -0.00000004815,    -0.00000000499,
	   0.00000000104,     0.00000001360,
	   0.00000000239,    -0.00000000060,
	   0.00000002433,     0.00000004175,
	   0.00000000565,    -0.00000001520,
	  -0.00000000311,     0.00000000034,
	  -0.00000010077,     0.00000035897,
	   0.00000007642,     0.00000001059,
	   0.00000005280,     0.00000004276,
	   0.00000001193,    -0.00000001741,
	  -0.00000000300,    -0.00000000153,
	  -0.00000007652,     0.00000000859,
	   0.00000000982,     0.00000001378,
	   0.00000000135,    -0.00000000249,
	   0.00000000763,     0.00000007686,
	   0.00000001385,    -0.00000000967,
	  -0.00000000247,    -0.00000000136,
	  -0.00000000096,    -0.00000000062,
	  -0.00000007891,     0.00000001239,
	   0.00000001268,     0.00000001553,
	   0.00000000160,    -0.00000000301,
	   0.00000001242,     0.00000007895,
	   0.00000001553,    -0.00000001269,
	  -0.00000000301,    -0.00000000161,
	   0.00000000014,     0.00000000079,
	  -0.00000340052,     0.00000053264,
	   0.00000054783,     0.00000067010,
	   0.00000006916,    -0.00000012977,
	   0.00000001588,     0.00000010135,
	   0.00000001995,    -0.00000001631,
	  -0.00000000386,    -0.00000000206,
	   0.00000013902,     0.00000000072,
	   0.00000000723,    -0.00000000830,
	  -0.00000000445,     0.00000002662,
	   0.00000000185,     0.00000000177,
	   0.00000000255,    -0.00000000108,
	   0.00000000097,    -0.00000000219,
	   0.00000219594,    -0.00000106601,
	  -0.00000070316,    -0.00000072642,
	  -0.00000008602,     0.00000009329,
	   0.00000002385,     0.00000001037,
	  -0.00000001848,    -0.00000027690,
	  -0.00000004480,     0.00000001863,
	   0.00000000424,     0.00000000425,
	   0.00000000046,    -0.00000000107,
	  -0.00000001759,     0.00000003895,
	   0.00000000890,     0.00000000346,
	   0.00000000046,    -0.00000000111,
	  -0.00000003146,    -0.00000001624,
	  -0.00000000367,     0.00000000815,
	   0.00000000105,     0.00000000042,
	  -0.00000000075,     0.00000000403,
	  -0.00000000394,    -0.00000000089,
	  -0.00000003525,     0.00000037676,
	   0.00000001955,     0.00000001382,
	   0.00000001134,     0.00000000109,
	   0.00000000042,    -0.00000000060,
	   0.00000002989,    -0.00000002335,
	   0.00000000758,    -0.00000000337,
	  -0.00000000076,    -0.00000000028,
	   0.00000000737,     0.00000000024,
	   0.00000000055,    -0.00000000058,
	  -0.00000000221,     0.00000000937,
	   0.00000000055,     0.00000000051,
	  -0.00000041566,     0.00000058126,
	   0.00000011475,     0.00000003743,
	   0.00000000421,    -0.00000001798,
	  -0.00000003199,     0.00000001983,
	   0.00000000485,     0.00000000042,
	   0.00000006844,    -0.00000004431,
	  -0.00000002893,    -0.00000002589,
	  -0.00000000341,     0.00000000392,
	   0.00000000080,     0.00000000035,
	   0.00000004361,     0.00000006596,
	   0.00000002608,    -0.00000002860,
	  -0.00000000392,    -0.00000000341,
	  -0.00000000035,     0.00000000080,
	  -0.00000000060,     0.00000000245,
	   0.00000000245,     0.00000000060,
	  -0.00000000086,     0.00000000355,
	   0.00000000355,     0.00000000086,
	  -0.00000000104,     0.00000000433,
	   0.00000000434,     0.00000000104,
	  -0.00000011513,     0.00000036965,
	   0.00000001113,     0.00000000347,
	  -0.00000003905,    -0.00000001660,
	  -0.00000000222,    -0.00000000091,
	  -0.00000000010,    -0.00000000244,
	   0.00000000256,    -0.00000000023,
	   0.00000025383,    -0.00000004744,
	  -0.00000003278,     0.00000000887,
	   0.00000000587,     0.00000000921,
	  -0.00000000112,    -0.00000000158,
	  -0.00000000782,     0.00000002778,
	   0.00000000449,     0.00000000038,
	  -0.00000002829,    -0.00000000712,
	  -0.00000000032,     0.00000000434,
	  -0.00000000040,     0.00000000105,
	   0.00000000106,     0.00000000040,
	  -0.00000000056,     0.00000000148,
	   0.00000000148,     0.00000000056,
	  -0.00000000071,     0.00000000189,
	   0.00000000189,     0.00000000071,
	  -0.00000007862,     0.00000022505,
	   0.00000000666,     0.00000000233,
	   0.00000010573,    -0.00000029757,
	  -0.00000001284,    -0.00000000451,
	  -0.00000000112,     0.00000000325,
	  -0.00000000325,    -0.00000000112,
	   0.00000000681,     0.00000000715,
	  -0.00000000084,     0.00000000127,
	  -0.00000000139,     0.00000000016,
	  -0.00000000065,    -0.00000000084,
	  -0.00000007994,    -0.00000005169,
	   0.00000000179,    -0.00000000411,
	  -0.00000000026,     0.00000000099,
	   0.00000000887,    -0.00000000415,
	  -0.00000000130,     0.00000000075,
	   0.00000000442,     0.00000000885,
	  -0.00000000078,    -0.00000000129,
	  -0.00000000067,     0.00000000103,
	   0.00000000104,     0.00000000067,
	  -0.00000000095,     0.00000000147,
	   0.00000000147,     0.00000000095,
	  -0.00000000118,     0.00000000184,
	   0.00000000184,     0.00000000119,
	  -0.00000005215,     0.00000008267,
	   0.00000000246,     0.00000000155,
	   0.00000005537,    -0.00000016748,
	  -0.00000000703,    -0.00000000232,
	  -0.00000000049,     0.00000000079,
	  -0.00000000079,    -0.00000000049,
	  -0.00000000964,     0.00000004790,
	   0.00000000339,    -0.00000001013,
	   0.00000001011,     0.00000000339,
	   0.00000000080,    -0.00000000023,
	   0.00000001200,     0.00000002905,
	  -0.00000000269,     0.00000000103,
	  -0.00000000357,    -0.00000000168,
	   0.00000000077,     0.00000000027,
	   0.00000000162,    -0.00000000364,
	  -0.00000000034,     0.00000000077,
	  -0.00000002712,     0.00000004229,
	   0.00000000180,     0.00000000115,
	   0.00000000180,    -0.00000000536,
	   0.00000000535,     0.00000000180,
	  -0.00000000031,     0.00000000149,
	  -0.00000000149,    -0.00000000031,
	   0.00000000073,     0.00000000220,
	  -0.00000000222,     0.00000000073,
	   0.00000000770,     0.00000000410,
	  -0.00000001110,    -0.00000000640,
	  -0.00000002706,     0.00000002946,
	  -0.00000003216,    -0.00000002245,
	   0.00000002910,     0.00000001310,
	  -0.00000000330,    -0.00000000900,
	   0.00000000820,    -0.00000000280,
	   0.00000000131,    -0.00000000041,
	  -0.00000000553,     0.00000000085,
	   0.00000000044,     0.00000000152,
	   0.00000000084,     0.00000000553,
	   0.00000000152,    -0.00000000044,
	  -0.00000000088,    -0.00000000041,
	   0.00000000301,    -0.00000001185,
	   0.00000000190,     0.00000000090,
	  -0.00000002025,     0.00000004667,
	  -0.00000000148,     0.00000000015,
	   0.00000001223,    -0.00000000028,
	  -0.00000000020,     0.00000000205,
	  -0.00000012575,    -0.00000001013,
	   0.00000000080,    -0.00000000586,
	  -0.00000000003,     0.00000000102,
	  -0.00000000086,     0.00000000031,
	  -0.00000003921,     0.00000001200,
	  -0.00000000056,    -0.00000000124,
	  -0.00000000374,    -0.00000000041,
	   0.00000000045,    -0.00000000374,
	  -0.00000000103,     0.00000000035,
	  -0.00000000035,    -0.00000000103,
	  -0.00000000080,     0.00000000841,
	   0.00000000276,     0.00000000013,
	  -0.00000000200,     0.00000000430,
	   0.00000000123,     0.00000000054,
	   0.00000000332,     0.00000000198,
	   0.00000000051,    -0.00000000088,
	  -0.00000000004,    -0.00000000002,
	   0.00000000006,     0.00000000040,
	   0.00000000012,    -0.00000000002,
	   0.00000000822,     0.00000002035,
	   0.00000000644,    -0.00000000288,
	  -0.00000001857,     0.00000000294,
	   0.00000000154,     0.00000000528,
	   0.00000000322,     0.00000001855,
	   0.00000000531,    -0.00000000157,
	   0.00000001083,     0.00000003483,
	   0.00000001128,    -0.00000000380,
	  -0.00000004169,     0.00000000799,
	   0.00000000375,     0.00000001188,
	   0.00000000776,     0.00000004214,
	   0.00000001209,    -0.00000000368,
	   0.00000004849,    -0.00000000066,
	  -0.00000000398,    -0.00000001519,
	  -0.00000013923,     0.00000002279,
	   0.00000001133,     0.00000004010,
	   0.00000002222,     0.00000013594,
	   0.00000003885,    -0.00000001103,
	  -0.00000000061,     0.00000000047,
	   0.00000000096,     0.00000000031,
	   0.00000003610,    -0.00000002765,
	  -0.00000002725,    -0.00000000210,
	   0.00000000395,     0.00000000723,
	   0.00000006035,    -0.00000012304,
	  -0.00000006542,    -0.00000002672,
	  -0.00000000597,     0.00000001837,
	   0.00000000340,     0.00000000070,
	  -0.00000060252,     0.00000014774,
	   0.00000009256,     0.00000023149,
	   0.00000004598,    -0.00000002726,
	  -0.00000000511,    -0.00000000558,
	   0.00000009692,     0.00000058840,
	   0.00000022771,    -0.00000005797,
	  -0.00000001548,    -0.00000004647,
	  -0.00000000607,     0.00000000257,
	  -0.00000003346,     0.00000000138,
	   0.00000000156,     0.00000000432,
	   0.00000000261,     0.00000003293,
	   0.00000000406,    -0.00000000195,
	  -0.00000195244,    -0.00000133275,
	  -0.00000050835,     0.00000098424,
	   0.00000025842,     0.00000011221,
	   0.00000001633,    -0.00000004641,
	   0.00000028405,     0.00000020985,
	   0.00000006551,    -0.00000013698,
	  -0.00000003247,    -0.00000000962,
	  -0.00000000042,     0.00000000505,
	   0.00000766512,    -0.00000177884,
	  -0.00000106818,    -0.00000290321,
	  -0.00000056498,     0.00000029758,
	   0.00000005348,     0.00000007053,
	   0.00000000617,    -0.00000000698,
	  -0.00000156717,    -0.00000761124,
	  -0.00000288911,     0.00000092365,
	   0.00000024836,     0.00000056738,
	   0.00000007267,    -0.00000004225,
	  -0.00000000520,    -0.00000000675,
	   0.00000009877,    -0.00000000689,
	  -0.00000000461,    -0.00000001257,
	  -0.00000001244,    -0.00000010045,
	  -0.00000001273,     0.00000000672,
	   0.00000002720,    -0.00000001606,
	  -0.00000001491,    -0.00000054266,
	  -0.00000022212,     0.00000003777,
	   0.00000001484,     0.00000004580,
	   0.00000000611,    -0.00000000315,
	  -0.00000000046,    -0.00000000059,
	   0.00000779617,    -0.00000119997,
	  -0.00000088144,    -0.00000302300,
	  -0.00000059425,     0.00000026340,
	   0.00000004798,     0.00000007537,
	   0.00000000678,    -0.00000000619,
	  -0.00000120240,    -0.00000779997,
	  -0.00000302485,     0.00000088249,
	   0.00000026365,     0.00000059473,
	   0.00000007545,    -0.00000004802,
	  -0.00000000619,    -0.00000000680,
	  -0.00000000169,    -0.00000000147,
	  -0.00000000055,     0.00000000077,
	   0.00000013508,    -0.00000005694,
	  -0.00000002756,    -0.00000005736,
	   0.00000011217,     0.00000007408,
	   0.00000002469,    -0.00000004826,
	  -0.00000001057,    -0.00000000398,
	  -0.00000000035,     0.00000000152,
	   0.00000976393,    -0.00000149996,
	  -0.00000110281,    -0.00000378641,
	  -0.00000074438,     0.00000032970,
	   0.00000006009,     0.00000009445,
	   0.00000000850,    -0.00000000777,
	  -0.00000000077,    -0.00000000043,
	  -0.00000150374,    -0.00000976991,
	  -0.00000378906,     0.00000110466,
	   0.00000033015,     0.00000074501,
	   0.00000009456,    -0.00000006016,
	  -0.00000000777,    -0.00000000852,
	  -0.00000000043,     0.00000000076,
	   0.00000000000,    -0.00000000003,
	  -0.00000000029,    -0.00000000009,
	  -0.00000000006,     0.00000000007,
	  -0.00000000015,     0.00000000013,
	   0.00000000003,     0.00000000004,
	   0.00000000012,     0.00000000010,
	   0.00000001729,    -0.00000000262,
	  -0.00000000138,    -0.00000000495,
	   0.00000000048,     0.00000000299,
	   0.00000000094,    -0.00000000026,
	  -0.00000000003,     0.00000000003,
	   0.00000000014,     0.00000000014,
	   0.00000000057,    -0.00000000009,
	  -0.00000000005,    -0.00000000016,
	  -0.00000000059,    -0.00000000366,
	  -0.00000000107,     0.00000000031,
	  -0.00000000101,     0.00000000091,
	   0.00000000029,     0.00000000027,
	   0.00000000070,     0.00000000051,
	   0.00000019702,    -0.00000002962,
	  -0.00000001558,    -0.00000005635,
	   0.00000000544,     0.00000003546,
	   0.00000001020,    -0.00000000284,
	  -0.00000000122,     0.00000000156,
	   0.00000000173,     0.00000000162,
	  -0.00000000010,    -0.00000000166,
	  -0.00000000163,     0.00000000012,
	  -0.00000000042,     0.00000000046,
	   0.00000000011,     0.00000000009,
	   0.00000000109,     0.00000000095,
	   0.00000000023,    -0.00000000027,
	   0.00000000299,    -0.00000000060,
	  -0.00000000028,    -0.00000000089,
	  -0.00000000275,    -0.00000001443,
	  -0.00000000419,     0.00000000131,
	  -0.00000000331,     0.00000000288,
	   0.00000000072,     0.00000000073,
	   0.00000000231,     0.00000000176,
	   0.00000000025,    -0.00000000047,
	   0.00000021479,    -0.00000003220,
	  -0.00000001696,    -0.00000006139,
	   0.00000000567,     0.00000003691,
	   0.00000001061,    -0.00000000296,
	  -0.00000000133,     0.00000000170,
	   0.00000000189,     0.00000000177,
	  -0.00000000012,    -0.00000000191,
	  -0.00000000187,     0.00000000014,
	  -0.00000000163,     0.00000000168,
	   0.00000000038,     0.00000000032,
	   0.00000000296,     0.00000000288,
	   0.00000000058,    -0.00000000069,
	  -0.00000000024,     0.00000000027,
	  -0.00000000027,    -0.00000000024,
	   0.00000000066,    -0.00000000054,
	   0.00000003277,    -0.00000000533,
	  -0.00000000264,    -0.00000000937,
	  -0.00000001660,    -0.00000010224,
	  -0.00000002933,     0.00000000832,
	  -0.00000001313,     0.00000001157,
	   0.00000000293,     0.00000000272,
	   0.00000000759,     0.00000000983,
	   0.00000000190,    -0.00000000169,
	  -0.00000000010,    -0.00000000065,
	   0.00000001992,    -0.00000000306,
	  -0.00000000159,    -0.00000000570,
	   0.00000000044,     0.00000000280,
	   0.00000000088,    -0.00000000024,
	  -0.00000001005,     0.00000000862,
	   0.00000000204,     0.00000000204,
	   0.00000001022,     0.00000001217,
	   0.00000000247,    -0.00000000245,
	  -0.00000000149,     0.00000000071,
	   0.00000000020,     0.00000000053,
	   0.00000000030,    -0.00000000213,
	  -0.00000000058,     0.00000000005,
	   0.00000000014,     0.00000000153,
	   0.00000000112,    -0.00000000021,
	  -0.00000000139,     0.00000000088,
	   0.00000000028,     0.00000000023,
	  -0.00000000090,    -0.00000000081,
	  -0.00000000024,     0.00000000027,
	  -0.00000000128,     0.00000000014,
	   0.00000000014,     0.00000000128,
	  -0.00000002992,     0.00000000461,
	  -0.00000000011,    -0.00000000188,
	   0.00000000020,     0.00000000268,
	   0.00000000101,    -0.00000000022,
	  -0.00000007796,    -0.00000000104,
	   0.00000000346,     0.00000002842,
	  -0.00000000003,     0.00000000251,
	   0.00000000090,    -0.00000000011,
	  -0.00000000102,     0.00000000007,
	  -0.00000000007,    -0.00000000102,
	  -0.00000000142,    -0.00000000007,
	   0.00000000007,    -0.00000000142,
	  -0.00000000154,     0.00000000062,
	   0.00000000076,    -0.00000000116,
	   0.00000000116,     0.00000000075,
	  -0.00000000803,    -0.00000001804,
	   0.00000000389,    -0.00000000155,
	  -0.00000000310,     0.00000000503,
	  -0.00000000496,    -0.00000000321,
	  -0.00000008469,     0.00000002137,
	   0.00000001235,     0.00000003897,
	  -0.00000000156,    -0.00000000467,
	  -0.00000000217,     0.00000000081,
	   0.00000005133,    -0.00000000120,
	  -0.00000000349,    -0.00000002102,
	  -0.00000000433,     0.00000000138,
	  -0.00000000117,    -0.00000005136,
	  -0.00000002103,     0.00000000349,
	   0.00000000138,     0.00000000433,
	  -0.00000001007,    -0.00000000902,
	  -0.00000000343,     0.00000000483,
	   0.00000000114,     0.00000000061,
	  -0.00000000902,     0.00000001006,
	   0.00000000483,     0.00000000343,
	   0.00000000061,    -0.00000000114,
	  -0.00000205144,     0.00000046911,
	   0.00000029313,     0.00000075121,
	   0.00000013927,    -0.00000007749,
	   0.00000001446,     0.00000006349,
	   0.00000002324,    -0.00000000905,
	  -0.00000000239,    -0.00000000431,
	  -0.00000000310,     0.00000000020,
	   0.00000000025,     0.00000000121,
	  -0.00000000030,    -0.00000000298,
	  -0.00000000116,     0.00000000028,
	   0.00000007245,     0.00000000089,
	  -0.00000000456,    -0.00000002687,
	   0.00000000004,    -0.00000000326,
	  -0.00000000125,     0.00000000022,
	  -0.00000003460,    -0.00000002120,
	  -0.00000003755,     0.00000000820,
	   0.00000000525,     0.00000001379,
	   0.00000000257,    -0.00000000142,
	  -0.00000000820,    -0.00000003755,
	  -0.00000001379,     0.00000000525,
	   0.00000000143,     0.00000000257,
	  -0.00000000076,    -0.00000000038,
	   0.00000000038,    -0.00000000075,
	   0.00000000041,     0.00000000280,
	   0.00000000108,    -0.00000000031,
	   0.00000000016,    -0.00000000186,
	  -0.00000000186,    -0.00000000015,
	   0.00022765928,    -0.00003506189,
	  -0.00002574652,    -0.00008828540,
	  -0.00001734471,     0.00000768642,
	   0.00000140135,     0.00000220090,
	   0.00000019843,    -0.00000018136,
	  -0.00000001787,    -0.00000000998,
	  -0.00000149242,    -0.00000969008,
	  -0.00000375789,     0.00000109596,
	   0.00000032760,     0.00000073877,
	   0.00000009375,    -0.00000005971,
	  -0.00000000772,    -0.00000000844,
	  -0.00000000044,     0.00000000078,
	   0.00000014624,     0.00000000818,
	  -0.00000000532,    -0.00000006248,
	  -0.00000001339,     0.00000000310,
	   0.00000000076,     0.00000000188,
	   0.00000002220,     0.00000027295,
	   0.00000010941,    -0.00000002475,
	  -0.00000000851,    -0.00000002208,
	  -0.00000000289,     0.00000000168,
	  -0.00000001296,    -0.00000001130,
	  -0.00000000452,     0.00000000641,
	   0.00000000151,     0.00000000081,
	   0.00000001196,    -0.00000001332,
	  -0.00000000638,    -0.00000000456,
	  -0.00000000081,     0.00000000151,
	   0.00000038058,    -0.00000002847,
	  -0.00000003066,    -0.00000014940,
	  -0.00000002968,     0.00000001021,
	  -0.00000000002,    -0.00000000262,
	  -0.00000000105,     0.00000000016,
	   0.00000003828,    -0.00000000375,
	  -0.00000000373,    -0.00000001553,
	  -0.00000000317,     0.00000000126,
	   0.00000000360,     0.00000003824,
	   0.00000001554,    -0.00000000371,
	  -0.00000000126,    -0.00000000317,
	   0.00000223441,    -0.00000021631,
	  -0.00000021809,    -0.00000090861,
	  -0.00000018572,     0.00000007399,
	   0.00000001465,     0.00000002439,
	  -0.00000000627,    -0.00000006467,
	  -0.00000002628,     0.00000000631,
	   0.00000000214,     0.00000000537,
	   0.00000000070,    -0.00000000042,
	   0.00000000121,     0.00000000004,
	  -0.00000000034,    -0.00000000150,
	   0.00000000452,    -0.00000000014,
	  -0.00000000027,    -0.00000000179,
	   0.00000000014,     0.00000000452,
	   0.00000000179,    -0.00000000027,
	  -0.00000001015,     0.00000000732,
	  -0.00000000752,    -0.00000000702,
	  -0.00000000191,     0.00000000221,
	   0.00000001168,     0.00000000422,
	  -0.00000000028,    -0.00000000366,
	   0.00000000633,     0.00000000383,
	   0.00000000229,    -0.00000000144,
	  -0.00000000224,     0.00000002315,
	   0.00000000371,     0.00000000039,
	  -0.00000000837,    -0.00000001332,
	  -0.00000000191,     0.00000000210,
	  -0.00000001331,     0.00000000754,
	   0.00000000204,     0.00000000190,
	  -0.00001074115,     0.00000246166,
	   0.00000165112,     0.00000398349,
	   0.00000073796,    -0.00000046100,
	  -0.00000007828,    -0.00000008627,
	   0.00000009727,     0.00000019795,
	   0.00000006669,    -0.00000004169,
	  -0.00000000911,    -0.00000001142,
	  -0.00000000127,     0.00000000130,
	   0.00000327897,    -0.00000050975,
	  -0.00000037355,    -0.00000127661,
	  -0.00000025121,     0.00000011139,
	   0.00000002029,     0.00000003185,
	   0.00000000287,    -0.00000000262,
	   0.00000050613,     0.00000330999,
	   0.00000127838,    -0.00000037146,
	  -0.00000011131,    -0.00000025111,
	  -0.00000003185,     0.00000002028,
	   0.00000000261,     0.00000000287,
	   0.00000009740,    -0.00000002969,
	  -0.00000001827,    -0.00000003982,
	  -0.00000000083,    -0.00000000270,
	  -0.00000000110,     0.00000000051,
	  -0.00000001870,     0.00000000300,
	   0.00000000118,    -0.00000000024,
	   0.00000000025,     0.00000000122,
	  -0.00000001371,    -0.00000000499,
	  -0.00000000086,    -0.00000002076,
	  -0.00000000421,     0.00000000291,
	  -0.00000000728,     0.00000001302,
	   0.00000000209,     0.00000000086,
	   0.00000001193,    -0.00000000042,
	  -0.00000000257,    -0.00000000115,
	  -0.00000301324,     0.00000060321,
	   0.00000056144,     0.00000063768,
	   0.00000006186,    -0.00000011197,
	   0.00000003015,     0.00000030495,
	   0.00000005410,    -0.00000003652,
	  -0.00000000881,    -0.00000000504,
	   0.00000001014,    -0.00000004862,
	  -0.00000000779,     0.00000000154,
	   0.00000000054,     0.00000000105,
	  -0.00000003007,     0.00000000412,
	   0.00000000478,     0.00000000154,
	  -0.00000000035,    -0.00000000077,
	  -0.00000236953,    -0.00000028237,
	  -0.00000021444,     0.00000004397,
	  -0.00000001533,     0.00000002599,
	   0.00000001225,    -0.00000027482,
	  -0.00000002360,    -0.00000000905,
	   0.00000000048,     0.00000000193,
	  -0.00000020842,     0.00000003441,
	   0.00000002798,     0.00000007764,
	   0.00000001474,    -0.00000000853,
	  -0.00000000154,    -0.00000000172,
	  -0.00000002589,    -0.00000020547,
	  -0.00000007847,     0.00000002778,
	   0.00000000854,     0.00000001475,
	   0.00000000173,    -0.00000000154,
	   0.00000000020,     0.00000000104,
	  -0.00000000064,     0.00000000074,
	   0.00000000276,    -0.00000000024,
	   0.00000000107,    -0.00000000137,
	   0.00000012086,    -0.00000002516,
	   0.00000001518,    -0.00000000150,
	  -0.00000000152,    -0.00000000041,
	   0.00000001309,     0.00000000166,
	   0.00000000112,    -0.00000000125,
	  -0.00000000355,     0.00000002336,
	   0.00000000124,     0.00000000106,
	  -0.00000026227,     0.00000063714,
	   0.00000002378,    -0.00000008383,
	  -0.00000006202,     0.00000000929,
	   0.00000000807,     0.00000000160,
	   0.00000000075,    -0.00000000049,
	  -0.00000015575,    -0.00000001057,
	  -0.00000000883,     0.00000000961,
	   0.00000000076,     0.00000000038,
	   0.00000001101,    -0.00000016067,
	  -0.00000000942,    -0.00000000833,
	  -0.00000000039,     0.00000000072,
	  -0.00000000093,    -0.00000000116,
	  -0.00000000095,     0.00000000103,
	  -0.00000006738,    -0.00000003667,
	  -0.00000000081,    -0.00000000843,
	   0.00000000010,     0.00000000172,
	   0.00000000289,    -0.00000000251,
	   0.00000000797,    -0.00000000194,
	   0.00000055082,     0.00000005003,
	  -0.00000004937,     0.00000002330,
	   0.00000000453,     0.00000003241,
	  -0.00000000246,    -0.00000000375,
	   0.00000000212,     0.00000004015,
	   0.00000000146,    -0.00000000559,
	  -0.00000004155,     0.00000000331,
	   0.00000000573,     0.00000000122,
	  -0.00000000112,    -0.00000000030,
	  -0.00000000045,    -0.00000000137,
	  -0.00000000124,    -0.00000000022,
	   0.00000002305,     0.00000000535,
	  -0.00000000110,     0.00000000381,
	   0.00000000021,    -0.00000000175,
	  -0.00000000424,     0.00000000273,
	   0.00000000254,    -0.00000000418,
	  -0.00000020309,    -0.00000015975,
	   0.00000003083,     0.00000001302,
	   0.00000001267,    -0.00000001831,
	  -0.00000000086,     0.00000000312,
	   0.00000002936,    -0.00000000210,
	  -0.00000000305,     0.00000000198,
	   0.00000000259,     0.00000002940,
	  -0.00000000203,    -0.00000000303,
	  -0.00000002726,     0.00000007244,
	   0.00000000556,     0.00000000201,
	  -0.00000000565,    -0.00000001433,
	   0.00000000266,     0.00000000833,
	   0.00000003116,    -0.00000001505,
	  -0.00000002087,     0.00000000665,
	   0.00000000738,     0.00000000762,
	  -0.00000000720,     0.00000000730,
	   0.00000009211,     0.00000023498,
	  -0.00000002306,    -0.00000004827,
	  -0.00000010464,     0.00000004344,
	   0.00000001904,    -0.00000000995,
	  -0.00000000194,     0.00000000272,
	  -0.00000004360,    -0.00000002682,
	   0.00000000732,     0.00000000248,
	   0.00000002669,    -0.00000004404,
	  -0.00000000335,     0.00000000711,
	  -0.00000001198,     0.00000001859,
	   0.00000000141,     0.00000000088,
	  -0.00000000077,    -0.00000000031,
	  -0.00000000079,    -0.00000000185,
	   0.00000000189,    -0.00000000076,
	   0.00000000683,     0.00000001232,
	  -0.00000000274,    -0.00000000070,
	  -0.00000006391,     0.00000002265,
	   0.00000001339,     0.00000002626,
	   0.00000000092,     0.00000000259,
	   0.00000000101,    -0.00000000052,
	  -0.00000002562,     0.00000000661,
	  -0.00000000156,     0.00000000063,
	   0.00000000038,     0.00000000068,
	  -0.00000000063,    -0.00000000173,
	  -0.00000000076,     0.00000000040,
	  -0.00000000126,    -0.00000000026,
	  -0.00000004285,     0.00000017120,
	   0.00000001343,     0.00000000333,
	  -0.00000011028,     0.00000007301,
	   0.00000003569,     0.00000004878,
	  -0.00000000319,    -0.00000000352,
	  -0.00000000156,     0.00000000145,
	  -0.00000000734,     0.00000001152,
	   0.00000000495,     0.00000000241,
	   0.00000000036,    -0.00000000108,
	   0.00000001151,     0.00000000734,
	   0.00000000241,    -0.00000000495,
	  -0.00000000108,    -0.00000000036,
	   0.00000002543,    -0.00000000266,
	  -0.00000000321,    -0.00000000892,
	  -0.00000000160,     0.00000000099,
	  -0.00000000265,    -0.00000002543,
	  -0.00000000892,     0.00000000321,
	   0.00000000099,     0.00000000160,
	   0.00042044816,    -0.00006465355,
	  -0.00004751361,    -0.00016305561,
	  -0.00003203640,     0.00001418380,
	   0.00000258471,     0.00000406633,
	   0.00000036672,    -0.00000033398,
	  -0.00000003294,    -0.00000001846,
	  -0.00000193044,    -0.00001254911,
	  -0.00000486662,     0.00000141838,
	   0.00000042340,     0.00000095617,
	   0.00000012144,    -0.00000007721,
	  -0.00000000997,    -0.00000001094,
	  -0.00000000054,     0.00000000097,
	  -0.00000001239,     0.00000004862,
	   0.00000002011,     0.00000000294,
	   0.00000000016,    -0.00000000425,
	  -0.00000003074,    -0.00000003857,
	  -0.00000001386,     0.00000001402,
	   0.00000000321,     0.00000000250,
	   0.00000002933,    -0.00000000306,
	  -0.00000000370,    -0.00000001029,
	  -0.00000000184,     0.00000000114,
	   0.00000000306,     0.00000002931,
	   0.00000001028,    -0.00000000370,
	  -0.00000000114,    -0.00000000184,
	   0.00000003645,     0.00000000444,
	  -0.00000000204,     0.00000000741,
	   0.00000000122,    -0.00000000167,
	   0.00000000173,     0.00000000032,
	  -0.00000037621,    -0.00000000057,
	   0.00000000279,    -0.00000001874,
	  -0.00000000134,    -0.00000000119,
	   0.00000004785,     0.00000002890,
	   0.00000000937,    -0.00000001948,
	  -0.00000000411,    -0.00000000158,
	  -0.00000002844,     0.00000004873,
	   0.00000001948,     0.00000000937,
	   0.00000000158,    -0.00000000411,
	   0.00000001560,    -0.00000000205,
	   0.00000000054,     0.00000000235,
	   0.00000000127,     0.00000000012,
	  -0.00000000015,     0.00000000127,
	   0.00000000233,    -0.00000000004,
	  -0.00000000018,    -0.00000000093,
	   0.00000000003,     0.00000000231,
	   0.00000000093,    -0.00000000018,
	  -0.00000012040,     0.00000003192,
	  -0.00000000148,    -0.00000000409,
	  -0.00000001150,    -0.00000000137,
	  -0.00000000072,     0.00000000081,
	   0.00000000148,    -0.00000001149,
	  -0.00000000082,    -0.00000000070,
	  -0.00000000343,     0.00000000092,
	  -0.00000000092,    -0.00000000344,
	   0.00000000039,    -0.00000000038,
	  -0.00000000006,    -0.00000000005,
	   0.00000000102,    -0.00000000127,
	  -0.00000000016,    -0.00000000017,
	  -0.00000000127,    -0.00000000102,
	  -0.00000000015,     0.00000000015,
	   0.00000000008,    -0.00000000002,
	  -0.00000000001,    -0.00000000009,
	  -0.00000000018,    -0.00000000033,
	  -0.00000000030,    -0.00000000057,
	   0.00000000031,    -0.00000000058,
	  -0.00000000052,    -0.00000000037,
	  -0.00000000156,    -0.00000000118,
	   0.00000000407,     0.00000000536,
	   0.00000000105,    -0.00000000055,
	   0.00000000535,    -0.00000000399,
	  -0.00000000053,    -0.00000000108,
	   0.00000000044,    -0.00000000028,
	  -0.00000001848,     0.00000131659,
	   0.00000035079,    -0.00000022729,
	  -0.00000006049,    -0.00000003613,
	  -0.00000000090,     0.00000000867,
	   0.00000053523,     0.00000214361,
	   0.00000086999,    -0.00000031173,
	  -0.00000008737,    -0.00000017524,
	  -0.00000002230,     0.00000001559,
	   0.00000000206,     0.00000000198,
	   0.00000265660,    -0.00000647364,
	  -0.00000180447,    -0.00000049883,
	  -0.00000003216,     0.00000025844,
	   0.00000002390,    -0.00000000174,
	  -0.00000646403,    -0.00000276842,
	  -0.00000055204,     0.00000180639,
	   0.00000025967,     0.00000004546,
	   0.00000000040,    -0.00000002449,
	   0.00000011831,    -0.00000020775,
	   0.00000000373,     0.00000000352,
	   0.00000000020,    -0.00000000166,
	  -0.00000022071,    -0.00000009247,
	   0.00000001016,    -0.00000000120,
	  -0.00000000142,    -0.00000000115,
	   0.00037209830,    -0.00006993652,
	  -0.00004538284,    -0.00014238841,
	  -0.00002789200,     0.00001276757,
	   0.00000224930,     0.00000354808,
	   0.00000032574,    -0.00000028398,
	  -0.00000002534,    -0.00000002001,
	  -0.00000440350,    -0.00002558829,
	  -0.00001002883,     0.00000305256,
	   0.00000089147,     0.00000198404,
	   0.00000025340,    -0.00000015967,
	  -0.00000002015,    -0.00000002319,
	  -0.00000000138,     0.00000000166,
	  -0.00000320162,     0.00002580001,
	   0.00000656715,     0.00000043405,
	  -0.00000006463,    -0.00000094408,
	  -0.00000009035,     0.00000002847,
	   0.00000000445,     0.00000000667,
	   0.00002401002,     0.00000397341,
	   0.00000101700,    -0.00000573383,
	  -0.00000075285,    -0.00000013030,
	  -0.00000001211,     0.00000006259,
	   0.00000000397,     0.00000000119,
	  -0.00000021717,     0.00000057286,
	   0.00000000330,    -0.00000003117,
	  -0.00000000369,     0.00000000299,
	   0.00000047388,     0.00000030878,
	  -0.00000000001,     0.00000001796,
	   0.00000000529,    -0.00000000166,
	   0.00000109957,    -0.00000017685,
	  -0.00000013153,    -0.00000042624,
	  -0.00000008290,     0.00000003879,
	  -0.00000000243,     0.00000000218,
	  -0.00000006143,    -0.00000000352,
	   0.00000001110,     0.00000001187,
	   0.00000000081,    -0.00000000234,
	  -0.00000001570,     0.00000006126,
	   0.00000001344,    -0.00000000512,
	  -0.00000000086,    -0.00000000164,
	   0.00000000048,     0.00000000101,
	   0.00000000097,    -0.00000000051,
	   0.00000240625,    -0.00000032880,
	  -0.00000026017,    -0.00000094128,
	  -0.00000018564,     0.00000007895,
	   0.00000001449,     0.00000002394,
	  -0.00000000087,    -0.00000000191,
	  -0.00000007656,    -0.00000001304,
	   0.00000000995,     0.00000001603,
	   0.00000000159,    -0.00000000199,
	  -0.00000001310,     0.00000007657,
	   0.00000001607,    -0.00000000992,
	  -0.00000000198,    -0.00000000161,
	   0.00000000007,     0.00000000002,
	   0.00000000004,     0.00000000002,
	   0.00000000002,    -0.00000000004,
	   0.00000000001,    -0.00000000005,
	   0.00000000035,    -0.00000000025,
	  -0.00000000025,    -0.00000000034,
	  -0.00000001103,    -0.00000001389,
	   0.00000000158,    -0.00000000061,
	   0.00000000891,     0.00000000137,
	   0.00000000050,    -0.00000000055,
	   0.00000000128,    -0.00000000892,
	  -0.00000000055,    -0.00000000050,
	   0.00000000018,    -0.00000000034,
	   0.00000000086,     0.00000000055,
	   0.00000000055,    -0.00000000085,
	  -0.00000001188,    -0.00000001541,
	   0.00000000165,    -0.00000000061,
	   0.00000000959,     0.00000000148,
	   0.00000000048,    -0.00000000053,
	   0.00000000138,    -0.00000000960,
	  -0.00000000054,    -0.00000000048,
	   0.00000000058,     0.00000000039,
	   0.00000000069,    -0.00000000102,
	  -0.00000000071,    -0.00000000093,
	  -0.00000000210,     0.00000000166,
	   0.00000000023,     0.00000000034,
	   0.00000000355,     0.00000000182,
	   0.00000000025,    -0.00000000025,
	   0.00000000186,    -0.00000000370,
	  -0.00000000025,    -0.00000000024,
	   0.00000000361,     0.00000000155,
	   0.00000000022,    -0.00000000022,
	   0.00000000129,    -0.00000000396,
	  -0.00000000026,    -0.00000000026,
	  -0.00000000045,    -0.00000000092,
	  -0.00000000099,     0.00000000043,
	  -0.00000004978,    -0.00000016074,
	  -0.00000007112,     0.00000005127,
	   0.00000001957,     0.00000001420,
	  -0.00000000572,     0.00000000186,
	   0.00000000185,     0.00000000254,
	   0.00000000049,    -0.00000000068,
	   0.00000000020,    -0.00000000080,
	   0.00000000043,     0.00000000091,
	  -0.00000000099,     0.00000000040,
	   0.00000000899,     0.00000000136,
	  -0.00000000062,     0.00000000294,
	  -0.00000000196,    -0.00000000391,
	   0.00000000421,    -0.00000000165,
	  -0.00000006472,     0.00000023050,
	   0.00000011546,    -0.00000000468,
	  -0.00000000968,    -0.00000002784,
	   0.00000000512,     0.00000000078,
	  -0.00000000079,    -0.00000000281,
	  -0.00000000068,     0.00000000038,
	   0.00000000466,    -0.00000000479,
	  -0.00000000239,    -0.00000000160,
	   0.00000000239,    -0.00000000733,
	  -0.00000000412,    -0.00000000075,
	  -0.00000000009,     0.00000000107,
	  -0.00000000296,    -0.00000000400,
	  -0.00000000397,     0.00000000300,
	   0.00000000761,    -0.00000002558,
	  -0.00000000167,    -0.00000000019,
	   0.00000000841,     0.00000000830,
	   0.00000000089,    -0.00000000119,
	   0.00000000842,    -0.00000000748,
	  -0.00000000095,    -0.00000000123,
	  -0.00000198114,    -0.00000036652,
	   0.00000024792,     0.00000041863,
	   0.00000004275,    -0.00000005148,
	  -0.00000000193,     0.00000006866,
	   0.00000001419,    -0.00000001118,
	  -0.00000000219,    -0.00000000125,
	  -0.00000001199,    -0.00000000473,
	  -0.00000000189,    -0.00000000054,
	  -0.00000000066,     0.00000000038,
	  -0.00000000143,     0.00000001964,
	   0.00000000275,     0.00000000059,
	  -0.00000000076,    -0.00000000073,
	  -0.00000000043,    -0.00000000061,
	   0.00000000070,     0.00000000036,
	  -0.00000000733,     0.00000001722,
	   0.00000002487,     0.00000000335,
	   0.00000000140,     0.00000001042,
	  -0.00000004974,     0.00000000391,
	   0.00000000419,     0.00000004930,
	   0.00000009333,    -0.00000025975,
	  -0.00000001654,     0.00000001327,
	  -0.00000003192,     0.00000012278,
	   0.00000001022,     0.00000000811,
	   0.00000011278,    -0.00000001545,
	  -0.00000000108,     0.00000000016,
	  -0.00000001153,    -0.00000010939,
	  -0.00000525572,    -0.00000081844,
	  -0.00000035355,     0.00000037093,
	   0.00000002429,     0.00000001664,
	   0.00000011126,    -0.00000064505,
	  -0.00000004740,    -0.00000004059,
	  -0.00000000154,     0.00000000282,
	  -0.00000004439,    -0.00000000534,
	   0.00000000267,     0.00000000639,
	   0.00000000074,    -0.00000000057,
	   0.00000001790,    -0.00000002818,
	  -0.00000000715,     0.00000000233,
	   0.00000000055,     0.00000000073,
	   0.00000000034,     0.00000000227,
	  -0.00000000129,     0.00000000160,
	  -0.00000002541,     0.00000000710,
	   0.00000000019,     0.00000000094,
	  -0.00000000071,     0.00000000222,
	   0.00000008456,     0.00000004889,
	  -0.00000000015,    -0.00000001230,
	  -0.00000004148,     0.00000014037,
	   0.00000001877,    -0.00000000555,
	  -0.00000000060,    -0.00000000192,
	  -0.00000021175,    -0.00000006038,
	   0.00000002400,     0.00000002724,
	   0.00000000218,    -0.00000000326,
	  -0.00000010203,    -0.00000001910,
	  -0.00000001890,     0.00000001409,
	   0.00000000410,     0.00000000219,
	   0.00000000108,    -0.00000000052,
	  -0.00000050935,    -0.00000128106,
	  -0.00000008543,     0.00000023540,
	   0.00000002398,    -0.00000000113,
	   0.00000014464,    -0.00000031890,
	  -0.00000004938,     0.00000001174,
	   0.00000000297,     0.00000000323,
	   0.00000011726,     0.00000020891,
	   0.00000001136,     0.00000000854,
	   0.00000000212,    -0.00000000445,
	   0.00000015236,    -0.00000023286,
	  -0.00000002879,     0.00000003320,
	   0.00000000326,     0.00000000165,
	  -0.00000000271,     0.00000000084,
	   0.00000000090,     0.00000000140,
	  -0.00000161295,     0.00000159623,
	   0.00000008569,    -0.00000018050,
	  -0.00000001161,    -0.00000001859,
	  -0.00000021791,    -0.00000010646,
	   0.00000002211,     0.00000001035,
	   0.00000000268,    -0.00000000140,
	  -0.00000044336,    -0.00000007161,
	  -0.00000002938,     0.00000003244,
	   0.00000000204,     0.00000000113,
	   0.00000007545,    -0.00000045276,
	  -0.00000003235,    -0.00000002828,
	  -0.00000000123,     0.00000000195,
	   0.00000001337,    -0.00000000147,
	   0.00000001098,     0.00000007258,
	  -0.00000001018,    -0.00000001689,
	   0.00000001150,     0.00000001792,
	   0.00000001660,    -0.00000000851,
	  -0.00000039868,    -0.00000004623,
	   0.00000003574,    -0.00000000977,
	  -0.00000000669,    -0.00000036822,
	   0.00000001456,     0.00000003528,
	  -0.00000000272,    -0.00000000299,
	   0.00000000629,    -0.00000005447,
	  -0.00000000105,     0.00000000412,
	   0.00000001412,     0.00000002724,
	  -0.00000000343,    -0.00000000157,
	   0.00000330952,     0.00000036189,
	  -0.00000030046,     0.00000010045,
	  -0.00000006295,     0.00000089196,
	  -0.00000003196,    -0.00000008444,
	   0.00000000061,     0.00000000278,
	  -0.00000014651,     0.00000029238,
	   0.00000001664,    -0.00000003231,
	  -0.00000000179,    -0.00000000329,
	  -0.00000030132,    -0.00000014216,
	   0.00000003349,     0.00000001574,
	   0.00000000318,    -0.00000000207,
	  -0.00000000428,     0.00000000322,
	  -0.00000000381,    -0.00000000471,
	   0.00000002691,    -0.00000000936,
	  -0.00000000033,    -0.00000000093,
	   0.00000000895,    -0.00000001084,
	   0.00000000026,     0.00000000271,
	  -0.00000000188,     0.00000001558,
	  -0.00000002443,     0.00000002920,
	   0.00000000158,    -0.00000000348,
	   0.00000000721,    -0.00000000027,
	   0.00000000033,     0.00000000675,
	  -0.00000000200,     0.00000000097,
	   0.00000017926,     0.00000010357,
	  -0.00000002874,    -0.00000000861,
	   0.00000000933,    -0.00000001660,
	  -0.00000000071,     0.00000000218,
	  -0.00000005584,    -0.00000000207,
	   0.00000000540,    -0.00000000205,
	   0.00000000114,    -0.00000005616,
	   0.00000000211,     0.00000000552,
	   0.00000000441,     0.00000000112,
	  -0.00000000169,     0.00000000591,
	  -0.00000000579,    -0.00000000121,
	  -0.00000002784,     0.00000002008,
	  -0.00000001321,    -0.00000000198,
	  -0.00000000088,    -0.00000000124,
	  -0.00000000131,     0.00000000586,
	  -0.00000000583,    -0.00000000178,
	   0.00000000107,    -0.00000000034,
	   0.00000000034,     0.00000000106,
	  -0.00000000262,     0.00000000556,
	   0.00000000134,    -0.00000000005,
	   0.00000000022,     0.00000001392,
	  -0.00000000602,     0.00000000005,
	   0.00000000070,    -0.00000000045,
	   0.00000000375,     0.00000000238,
	  -0.00000000244,     0.00000000373,
	   0.00000000197,     0.00000000055,
	  -0.00000000094,     0.00000000227,
	  -0.00000000234,    -0.00000000068,
	  -0.00000001307,     0.00000000684,
	  -0.00000000627,    -0.00000000077,
	  -0.00000000093,     0.00000000246,
	  -0.00000000250,    -0.00000000110,
	   0.00000000080,    -0.00000000091,
	   0.00000001731,    -0.00000000611,
	  -0.00000000330,    -0.00000000934,
	   0.00000000107,     0.00000000083,
	   0.00000000090,     0.00000000102,
	   0.00000000102,    -0.00000000090,
	   0.00000005010,     0.00000005669,
	  -0.00000000170,     0.00000000150,
	  -0.00000000113,     0.00000000228,
	   0.00000000228,     0.00000000113,
	  -0.00000003513,     0.00000007557,
	  -0.00000000111,    -0.00000000042,
	   0.00000000757,    -0.00000002264,
	   0.00000000105,     0.00000000061,
	  -0.00000002261,    -0.00000000756,
	   0.00000000061,    -0.00000000105,
	   0.00000026120,    -0.00000078183,
	   0.00000003548,     0.00000002033,
	   0.00000003317,     0.00000001108,
	  -0.00000000086,     0.00000000151,
	  -0.00000000100,    -0.00000000023,
	   0.00000001113,    -0.00000002348,
	   0.00000000818,    -0.00000000121,
	  -0.00000000092,    -0.00000000317,
	  -0.00000000084,     0.00000000038,
	  -0.00000000121,    -0.00000000818,
	  -0.00000000317,     0.00000000092,
	   0.00000000038,     0.00000000084,
	  -0.00000000052,    -0.00000000072,
	  -0.00000000077,     0.00000000050,
	   0.00000000202,     0.00000000175,
	   0.00000000178,    -0.00000000186,
	  -0.00000342243,    -0.00000058289,
	   0.00000044986,     0.00000071378,
	   0.00000007003,    -0.00000009007,
	  -0.00000001589,     0.00000009628,
	   0.00000002017,    -0.00000001255,
	  -0.00000000251,    -0.00000000200,
	   0.00000000438,    -0.00000000200,
	  -0.00000000114,    -0.00000000274,
	  -0.00000000091,     0.00000000045,
	   0.00000000052,     0.00000001122,
	   0.00000000321,    -0.00000000066,
	  -0.00000000045,    -0.00000000093,
	   0.00000005189,    -0.00000000326,
	   0.00000000124,     0.00000000434,
	   0.00000000501,     0.00000000199,
	  -0.00000000157,     0.00000000523,
	  -0.00000042426,     0.00000007733,
	  -0.00000000427,    -0.00000001489,
	  -0.00000003939,    -0.00000000647,
	  -0.00000000255,     0.00000000253,
	   0.00000000809,    -0.00000003884,
	  -0.00000000268,    -0.00000000234,
	   0.00000000123,     0.00000000066,
	   0.00000000195,    -0.00000000027,
	   0.00000000026,     0.00000000193,
	  -0.00000003169,     0.00000008282,
	  -0.00000001205,     0.00000000267,
	  -0.00000000265,    -0.00000001208,
	  -0.00000000076,     0.00000000216,
	  -0.00000000216,    -0.00000000076,
	  -0.00000000367,     0.00000000287,
	   0.00000000032,     0.00000000046,
	  -0.00000000183,     0.00000000347,
	   0.00000000005,     0.00000000012,
	   0.00000000332,     0.00000000136,
	   0.00000000008,    -0.00000000006,
	   0.00000000001,     0.00000000018,
	   0.00000000011,     0.00000000020,
	  -0.00000000693,     0.00000000693,
	   0.00000000079,     0.00000000115,
	  -0.00000000209,    -0.00000000455,
	  -0.00000000043,     0.00000000030,
	  -0.00000000402,     0.00000000259,
	   0.00000000031,     0.00000000043,
	   0.00000000008,     0.00000000047,
	   0.00000000051,    -0.00000000003,
	  -0.00000001234,     0.00000001169,
	   0.00000000125,     0.00000000212,
	  -0.00000000522,    -0.00000000785,
	  -0.00000000086,     0.00000000067,
	  -0.00000000783,     0.00000000640,
	   0.00000000074,     0.00000000085,
	   0.00000000038,    -0.00000000025,
	  -0.00000000638,     0.00000002185,
	   0.00000000223,     0.00000000065,
	  -0.00000002866,    -0.00000003484,
	  -0.00000000368,     0.00000000332,
	  -0.00000003247,     0.00000003237,
	   0.00000000330,     0.00000000330,
	   0.00000000000,     0.00000000084,
	   0.00000000099,     0.00000000014,
	  -0.00002665750,    -0.00004802018,
	  -0.00000814970,     0.00000536732,
	   0.00000061750,     0.00000092608,
	   0.00000006995,    -0.00000005993,
	  -0.00000000543,    -0.00000000421,
	   0.00003776099,    -0.00003320646,
	  -0.00000719739,    -0.00000491632,
	  -0.00000043206,     0.00000088002,
	   0.00000008303,     0.00000002268,
	   0.00000000072,    -0.00000000714,
	   0.00008128460,     0.00010802139,
	   0.00001252649,    -0.00001530856,
	  -0.00000174045,    -0.00000045172,
	   0.00000003660,     0.00000015731,
	   0.00000001141,    -0.00000000732,
	   0.00011128760,    -0.00006090816,
	  -0.00000751593,    -0.00001487050,
	  -0.00000112780,     0.00000021173,
	  -0.00000003736,     0.00000008205,
	   0.00000000721,     0.00000000654,
	   0.00000112943,     0.00000189529,
	  -0.00000026655,     0.00000021537,
	  -0.00000000759,    -0.00000000744,
	   0.00000000116,    -0.00000000164,
	   0.00000169772,    -0.00000137853,
	   0.00000018623,     0.00000028063,
	  -0.00000000655,     0.00000000986,
	  -0.00000000158,    -0.00000000118,
	   0.00011679772,     0.00080983754,
	   0.00017716666,    -0.00002967631,
	  -0.00000530057,    -0.00002306892,
	  -0.00000196617,     0.00000080045,
	   0.00000008975,     0.00000012777,
	  -0.00009299940,     0.00008319766,
	   0.00001787085,     0.00001186112,
	   0.00000102095,    -0.00000215559,
	  -0.00000020135,    -0.00000005244,
	  -0.00000000137,     0.00000001709,
	  -0.00026024173,    -0.00017377845,
	  -0.00003074529,     0.00002336010,
	   0.00000121809,     0.00000200582,
	   0.00000011416,    -0.00000001603,
	   0.00000000464,    -0.00000000898,
	  -0.00016900676,     0.00028321911,
	   0.00003226683,     0.00002790797,
	   0.00000123945,    -0.00000298199,
	  -0.00000024435,     0.00000001770,
	   0.00000000877,     0.00000001672,
	  -0.00000267543,    -0.00000450142,
	   0.00000066886,    -0.00000057403,
	   0.00000000944,     0.00000001495,
	  -0.00000000356,     0.00000000485,
	  -0.00000433975,     0.00000319584,
	  -0.00000050561,    -0.00000068285,
	   0.00000001661,    -0.00000001390,
	   0.00000000484,     0.00000000313,
	  -0.00000040242,     0.00000027739,
	   0.00000012083,     0.00000006234,
	   0.00000000271,    -0.00000001953,
	   0.00000003183,    -0.00000001737,
	  -0.00000000215,    -0.00000000579,
	  -0.00000000091,    -0.00000000011,
	   0.00000034806,    -0.00000007256,
	   0.00000000946,    -0.00000001865,
	  -0.00000000103,    -0.00000000020,
	  -0.00000007199,    -0.00000033905,
	  -0.00000001528,    -0.00000000997,
	  -0.00000092436,     0.00000066146,
	   0.00000027826,     0.00000014545,
	   0.00000000545,    -0.00000004394,
	   0.00000000958,     0.00000000108,
	   0.00000040629,    -0.00000009432,
	   0.00000000981,    -0.00000002140,
	  -0.00000000127,    -0.00000000015,
	  -0.00000009163,    -0.00000039456,
	  -0.00000001707,    -0.00000001128,
	  -0.00000000006,    -0.00000000001,
	   0.00000001458,    -0.00000000506,
	  -0.00000000037,     0.00000000179,
	  -0.00000000370,    -0.00000000611,
	   0.00000000239,    -0.00000000158,
	   0.00000016366,    -0.00000005653,
	  -0.00000000425,     0.00000001978,
	   0.00000000121,     0.00000000114,
	   0.00000000108,    -0.00000000016,
	  -0.00000000029,    -0.00000000093,
	   0.00000000041,    -0.00000000025,
	  -0.00000000107,     0.00000000000,
	   0.00000000001,     0.00000000105,
	  -0.00000000398,    -0.00000000661,
	   0.00000000248,    -0.00000000165,
	   0.00000017450,    -0.00000006052,
	  -0.00000000444,     0.00000002082,
	   0.00000000127,     0.00000000120,
	   0.00000000107,    -0.00000000014,
	  -0.00000000029,    -0.00000000091,
	  -0.00000000077,     0.00000000000,
	   0.00000000000,     0.00000000135,
	   0.00000000134,     0.00000000157,
	   0.00000000469,    -0.00000000416,
	  -0.00000000049,    -0.00000000046,
	  -0.00000000312,    -0.00000000021,
	   0.00000000028,     0.00000000291,
	   0.00000001502,    -0.00000000499,
	  -0.00000000057,     0.00000000159,
	  -0.00000000331,     0.00000000007,
	   0.00000000005,     0.00000000382,
	  -0.00000000189,    -0.00000000030,
	  -0.00000000035,     0.00000000186,
	   0.00000000667,    -0.00000000003,
	  -0.00000000087,    -0.00000000209,
	   0.00000000012,    -0.00000000683,
	  -0.00000000216,     0.00000000077,
	  -0.00000000877,     0.00000001563,
	   0.00000000095,    -0.00000000029,
	  -0.00000000088,    -0.00000000087,
	  -0.00000000211,     0.00000000032,
	   0.00000000046,     0.00000000130,
	  -0.00000000059,    -0.00000000069,
	  -0.00000000045,     0.00000000073,
	   0.00000003735,    -0.00000002393,
	  -0.00000001383,    -0.00000001240,
	   0.00000000039,    -0.00000000076,
	  -0.00000000219,     0.00000000008,
	   0.00000000027,     0.00000000090,
	  -0.00000000016,     0.00000000198,
	   0.00000000088,    -0.00000000015,
	  -0.00000000369,     0.00000000401,
	   0.00000008553,     0.00000007870,
	   0.00000003795,    -0.00000004219,
	   0.00000000889,     0.00000001789,
	  -0.00000020257,    -0.00000018862,
	   0.00000008344,    -0.00000004147,
	  -0.00000003171,    -0.00000000630,
	   0.00000000819,    -0.00000003081,
	  -0.00000000735,     0.00000000326,
	   0.00000000019,     0.00000000221,
	   0.00000000134,    -0.00000000045,
	  -0.00000000148,     0.00000000065,
	   0.00000000051,     0.00000000118,
	  -0.00000004228,    -0.00000000534,
	   0.00000000100,     0.00000001895,
	   0.00000000014,     0.00000000691,
	   0.00000000258,    -0.00000000060,
	  -0.00000000216,     0.00000000613,
	   0.00000000121,     0.00000000062,
	   0.00000000623,     0.00000000236,
	   0.00000000052,    -0.00000000111,
	  -0.00000010575,     0.00000003154,
	   0.00000000067,     0.00000000260,
	  -0.00000000055,    -0.00000000439,
	   0.00000000119,    -0.00000000147,
	   0.00000002630,    -0.00000000678,
	   0.00000000098,     0.00000000258,
	  -0.00000000192,     0.00000000075,
	  -0.00000000063,    -0.00000000190,
	  -0.00000001070,    -0.00000000070,
	   0.00000000688,     0.00000000086,
	  -0.00000000674,     0.00000000028,
	  -0.00000000043,    -0.00000000683,
	  -0.00000005562,    -0.00000000299,
	  -0.00000000248,     0.00000000328,
	   0.00000000692,    -0.00000021516,
	  -0.00000001413,    -0.00000001070,
	   0.00000011056,    -0.00000000304,
	  -0.00000000307,    -0.00000010974,
	   0.00000083357,     0.00000017049,
	   0.00000005381,    -0.00000006308,
	  -0.00000003827,     0.00000075557,
	   0.00000005071,     0.00000003874,
	   0.00000000059,    -0.00000000108,
	  -0.00000011675,     0.00000000750,
	  -0.00000000108,     0.00000011797,
	   0.00001129697,    -0.00000325824,
	   0.00000023754,    -0.00000049895,
	  -0.00000001847,    -0.00000000774,
	   0.00000001261,    -0.00000126262,
	  -0.00000007991,    -0.00000005836,
	  -0.00000000218,     0.00000000465,
	   0.00000000198,     0.00000000074,
	  -0.00000002960,    -0.00000002242,
	  -0.00000000405,     0.00000000097,
	   0.00000003245,     0.00000005740,
	   0.00000000123,    -0.00000000272,
	  -0.00000000275,     0.00000000374,
	   0.00000000011,     0.00000000331,
	  -0.00000000033,    -0.00000000241,
	   0.00000000204,    -0.00000000060,
	   0.00000000051,     0.00000000194,
	   0.00000011581,    -0.00000002043,
	  -0.00000000029,    -0.00000000231,
	  -0.00000002920,    -0.00000005510,
	  -0.00000002909,     0.00000000842,
	   0.00000010505,     0.00000036359,
	  -0.00000000850,    -0.00000001990,
	   0.00000008192,    -0.00000005266,
	  -0.00000003712,    -0.00000005796,
	   0.00000001491,     0.00000000122,
	  -0.00000000153,     0.00000001488,
	   0.00000016331,    -0.00000003516,
	  -0.00000015265,    -0.00000075249,
	   0.00000000687,    -0.00000000300,
	   0.00000001985,     0.00000009800,
	  -0.00000000777,    -0.00000000648,
	   0.00000006863,    -0.00000000026,
	  -0.00000000530,     0.00000000906,
	  -0.00000000488,     0.00000035524,
	  -0.00000001858,    -0.00000001140,
	   0.00000039308,     0.00000190114,
	  -0.00000001583,     0.00000000365,
	  -0.00000000400,    -0.00000000006,
	  -0.00000007428,    -0.00000007696,
	  -0.00000000231,     0.00000001357,
	  -0.00000001046,    -0.00000015042,
	  -0.00000000278,    -0.00000001378,
	  -0.00000000002,     0.00000000388,
	   0.00000000068,     0.00000000264,
	   0.00000376881,    -0.00000139244,
	   0.00000002462,     0.00000010379,
	   0.00000000457,     0.00000001746,
	  -0.00000008719,    -0.00000039471,
	   0.00000000228,    -0.00000000403,
	   0.00000043361,    -0.00000005080,
	   0.00000001719,    -0.00000002404,
	  -0.00000000076,    -0.00000000067,
	   0.00000003615,     0.00000044702,
	   0.00000002490,     0.00000001513,
	   0.00000000066,    -0.00000000077,
	  -0.00000000086,    -0.00000000120,
	  -0.00000000140,    -0.00000000130,
	   0.00000000027,     0.00000000095,
	  -0.00000000111,     0.00000000027,
	   0.00000000027,     0.00000000110,
	  -0.00000002460,    -0.00000002370,
	   0.00000009260,     0.00000011149,
	  -0.00000004802,    -0.00000004363,
	  -0.00000001898,    -0.00000002211,
	   0.00000000930,     0.00000000280,
	   0.00000008160,     0.00000008272,
	  -0.00000000785,    -0.00000000435,
	   0.00000016680,    -0.00000016414,
	  -0.00000000971,     0.00000001459,
	   0.00000000242,    -0.00000005171,
	   0.00000000932,     0.00000000677,
	  -0.00000009598,    -0.00000002226,
	   0.00000001221,    -0.00000000193,
	   0.00000106274,     0.00000043077,
	  -0.00000002853,    -0.00000001950,
	  -0.00000041004,     0.00000041342,
	   0.00000002320,    -0.00000003551,
	   0.00000000225,     0.00000000252,
	   0.00000009039,    -0.00000013443,
	  -0.00000000202,     0.00000001459,
	  -0.00000000162,     0.00000000040,
	  -0.00000007139,     0.00000001802,
	   0.00000001721,    -0.00000001581,
	  -0.00000000080,     0.00000000107,
	   0.00000000039,     0.00000000140,
	   0.00000019845,     0.00000017936,
	  -0.00000001017,    -0.00000001957,
	   0.00000001582,    -0.00000001981,
	  -0.00000000063,     0.00000000188,
	   0.00000005553,    -0.00000002073,
	   0.00000000014,     0.00000000224,
	   0.00000002146,     0.00000005584,
	  -0.00000000221,     0.00000000008,
	   0.00000000092,    -0.00000000080,
	   0.00000000090,     0.00000000110,
	   0.00000000046,    -0.00000000072,
	  -0.00000000084,     0.00000000073,
	   0.00000005110,     0.00000013210,
	  -0.00000034460,    -0.00000039870,
	   0.00000009520,    -0.00000002249,
	   0.00000053260,     0.00000215783,
	  -0.00000014060,    -0.00000001370,
	   0.00000010020,    -0.00000102650,
	  -0.00000000288,     0.00000000120,
	  -0.00000003078,    -0.00000004821,
	   0.00000000465,     0.00000000594,
	   0.00000000955,    -0.00000000393,
	  -0.00000000151,     0.00000000119,
	  -0.00000000158,    -0.00000000117,
	   0.00000000062,    -0.00000000048,
	  -0.00000000051,     0.00000000070,
	  -0.00000009701,    -0.00000015396,
	   0.00000001490,     0.00000001928,
	  -0.00000000484,     0.00000000162,
	  -0.00000000682,    -0.00000000067,
	   0.00000000100,    -0.00000000697,
	  -0.00000000055,    -0.00000000193,
	   0.00000000045,     0.00000000107,
	   0.00000000112,    -0.00000000028,
	   0.00000000028,     0.00000000112,
	   0.00000000101,     0.00000002000,
	  -0.00000000253,    -0.00000000016,
	   0.00000000108,    -0.00000000027,
	   0.00000000074,     0.00000000123,
	  -0.00000000124,     0.00000000057,
	   0.00000000632,     0.00000005602,
	   0.00000000164,     0.00000000021,
	   0.00000000038,     0.00000000068,
	   0.00000000092,     0.00000000121,
	  -0.00000000117,     0.00000000104,
	   0.00000000926,     0.00000000210,
	   0.00000000101,     0.00000000089,
	  -0.00000000131,    -0.00000000417,
	   0.00000000369,    -0.00000000068,
	   0.00000000518,    -0.00000000813,
	   0.00000000640,    -0.00000001955,
	  -0.00000000108,    -0.00000000041,
	  -0.00000000053,     0.00000000048,
	  -0.00000000036,    -0.00000000127,
	   0.00000000177,     0.00000000020,
	   0.00000013410,    -0.00000002177,
	  -0.00000001588,    -0.00000004998,
	   0.00000000190,     0.00000000859,
	   0.00000000312,    -0.00000000106,
	  -0.00000000265,     0.00000000321,
	   0.00000000098,     0.00000000044,
	   0.00000000324,     0.00000000264,
	   0.00000000043,    -0.00000000098,
	   0.00000000011,    -0.00000000127,
	  -0.00000000127,    -0.00000000011,
	  -0.00000000650,    -0.00000000027,
	  -0.00000000040,    -0.00000001131,
	  -0.00000000080,    -0.00000000055,
	   0.00000001262,     0.00000000009,
	   0.00000000020,    -0.00000001246,
	   0.00000009210,     0.00000003260,
	   0.00000000714,    -0.00000000747,
	  -0.00000000076,     0.00000003951,
	   0.00000000222,     0.00000000180,
	  -0.00000001794,    -0.00000000030,
	  -0.00000000035,     0.00000001708,
	   0.00002131145,    -0.00000503704,
	   0.00000055406,    -0.00000101406,
	  -0.00000004480,    -0.00000001920,
	  -0.00000009917,    -0.00000047259,
	  -0.00000002335,    -0.00000001329,
	  -0.00000000054,     0.00000000108,
	  -0.00000000675,     0.00000000364,
	   0.00000000066,     0.00000000074,
	  -0.00000000127,    -0.00000000248,
	  -0.00000000073,     0.00000000055,
	   0.00000000024,    -0.00000000252,
	   0.00000000269,     0.00000000022,
	   0.00000000555,    -0.00000001474,
	  -0.00000056352,    -0.00000021346,
	   0.00000003250,    -0.00000005870,
	  -0.00000007053,     0.00000019386,
	  -0.00000001587,    -0.00000002123,
	   0.00000170747,     0.00000067106,
	  -0.00000017445,     0.00000013400,
	  -0.00000006508,     0.00000001421,
	  -0.00000001037,    -0.00000006648,
	  -0.00000001152,     0.00000002975,
	   0.00000004129,     0.00000001599,
	   0.00000052683,    -0.00000169762,
	   0.00000021877,     0.00000011053,
	  -0.00000072566,    -0.00000024201,
	   0.00000004731,    -0.00000009267,
	   0.00000000591,     0.00000000300,
	   0.00000060162,    -0.00000011977,
	   0.00000000710,     0.00000000127,
	   0.00000011946,     0.00000060310,
	  -0.00000000161,     0.00000000767,
	   0.00000000083,     0.00000000120,
	  -0.00000000048,     0.00000000144,
	  -0.00000000144,    -0.00000000049,
	   0.00000000112,    -0.00000000414,
	   0.00000000112,     0.00000000074,
	   0.00000000413,     0.00000000115,
	  -0.00000000074,     0.00000000112,
	   0.00000000575,    -0.00000002316,
	  -0.00000000129,    -0.00000000120,
	   0.00000000391,    -0.00000000324,
	  -0.00000000017,    -0.00000000013,
	  -0.00000000022,    -0.00000000286,
	   0.00000000004,    -0.00000000003,
	  -0.00000000008,     0.00000000065,
	   0.00000000019,    -0.00000000091,
	  -0.00000000004,    -0.00000000003,
	   0.00000000419,    -0.00000006281,
	  -0.00000000337,    -0.00000000269,
	   0.00000001848,     0.00000000050,
	  -0.00000000014,    -0.00000001970,
	  -0.00000000007,     0.00000000067,
	   0.00000001020,    -0.00000010769,
	  -0.00000000583,    -0.00000000484,
	   0.00000004419,     0.00000000048,
	  -0.00000000052,    -0.00000004712,
	   0.00000000006,    -0.00000000057,
	  -0.00000000039,    -0.00000000013,
	  -0.00000002380,    -0.00000015513,
	  -0.00000000657,    -0.00000000639,
	   0.00000014248,     0.00000000935,
	   0.00000000046,    -0.00000000048,
	  -0.00000000339,    -0.00000013623,
	   0.00000000042,     0.00000000090,
	   0.00000000095,     0.00000000038,
	  -0.00000000136,    -0.00000000150,
	  -0.00032143485,    -0.00002877728,
	  -0.00001795333,     0.00002208978,
	   0.00000136434,     0.00000098000,
	   0.00000003090,    -0.00000007958,
	  -0.00009023546,     0.00061651695,
	   0.00004439093,     0.00003795126,
	   0.00000212804,    -0.00000281588,
	  -0.00000016558,    -0.00000007053,
	  -0.00000000035,     0.00000000766,
	   0.00065285562,    -0.00000434708,
	  -0.00000219775,    -0.00000082612,
	  -0.00000005261,     0.00000090653,
	   0.00000003320,    -0.00000000176,
	  -0.00000000050,    -0.00000000230,
	   0.00001479520,    -0.00064261110,
	   0.00000072372,    -0.00000281199,
	   0.00000016957,    -0.00000003415,
	   0.00000000302,     0.00000003462,
	   0.00000000248,    -0.00000000080,
	  -0.00000034453,     0.00000111939,
	  -0.00000007951,     0.00000020398,
	   0.00000001137,     0.00000000206,
	   0.00000000101,    -0.00000000150,
	  -0.00000039212,     0.00000057997,
	   0.00000016206,     0.00000000688,
	  -0.00000001400,    -0.00000001962,
	  -0.00000000206,     0.00000000159,
	   0.00275615018,    -0.00222937739,
	  -0.00007588378,    -0.00002995472,
	   0.00000384125,     0.00000542839,
	   0.00000014906,    -0.00000021108,
	  -0.00000000898,    -0.00000000259,
	   0.00022957813,    -0.00148093026,
	  -0.00010747843,    -0.00009236368,
	  -0.00000518255,     0.00000684342,
	   0.00000040270,     0.00000017113,
	   0.00000000050,    -0.00000001880,
	   0.00065045580,    -0.00000771755,
	   0.00000543625,     0.00000402878,
	   0.00000040616,     0.00000007643,
	  -0.00000006669,    -0.00000003164,
	  -0.00000000356,     0.00000000348,
	  -0.00003136834,    -0.00068657275,
	  -0.00000331713,     0.00000278843,
	   0.00000135570,     0.00000040184,
	   0.00000002818,    -0.00000005976,
	  -0.00000000321,    -0.00000000145,
	   0.00000156956,    -0.00000304994,
	   0.00000003851,    -0.00000046625,
	  -0.00000003822,     0.00000000500,
	  -0.00000000326,     0.00000000528,
	  -0.00000055815,    -0.00000102480,
	  -0.00000049827,     0.00000009636,
	   0.00000004630,     0.00000004852,
	   0.00000000574,    -0.00000000462,
	  -0.00000006718,    -0.00000577886,
	  -0.00000055490,     0.00000039383,
	   0.00000003775,     0.00000003340,
	  -0.00000002410,     0.00000012847,
	   0.00000001083,     0.00000000912,
	   0.00000000064,    -0.00000000096,
	   0.00000028461,     0.00000004063,
	   0.00000000670,    -0.00000000541,
	  -0.00000000069,    -0.00000000044,
	  -0.00000003735,    -0.00000024051,
	   0.00000000536,     0.00000000605,
	   0.00000000042,    -0.00000000075,
	   0.00000000016,    -0.00000000156,
	   0.00000000063,    -0.00000000099,
	  -0.00000074303,    -0.00001295637,
	  -0.00000123168,     0.00000088550,
	   0.00000008438,     0.00000007311,
	   0.00000000121,     0.00000002434,
	   0.00000000153,     0.00000000108,
	   0.00000036327,     0.00000004852,
	   0.00000000802,    -0.00000000677,
	  -0.00000000094,    -0.00000000062,
	  -0.00000004434,    -0.00000030421,
	   0.00000000673,     0.00000000779,
	   0.00000000051,    -0.00000000098,
	   0.00000005065,    -0.00000000020,
	   0.00000000229,     0.00000001008,
	   0.00000000000,    -0.00000000054,
	   0.00000001943,     0.00000000013,
	   0.00000000005,    -0.00000000720,
	   0.00000057150,    -0.00000000146,
	  -0.00000000016,    -0.00000000726,
	   0.00000000160,    -0.00000000027,
	   0.00000000053,     0.00000000152,
	   0.00000000001,    -0.00000000148,
	   0.00000002099,     0.00000000015,
	   0.00000000005,    -0.00000000773,
	   0.00000060975,    -0.00000000106,
	  -0.00000000017,    -0.00000000839,
	   0.00000000168,    -0.00000000028,
	   0.00000000055,     0.00000000159,
	  -0.00000000218,     0.00000000957,
	   0.00000000382,     0.00000000031,
	   0.00000000078,    -0.00000001297,
	  -0.00000000157,     0.00000000020,
	   0.00000000032,    -0.00000000114,
	   0.00000005333,    -0.00000000015,
	  -0.00000000087,     0.00000000000,
	  -0.00000000005,    -0.00000000086,
	   0.00000000340,    -0.00000001150,
	   0.00000000920,     0.00000000270,
	  -0.00000000295,     0.00000000673,
	  -0.00000000830,     0.00000000293,
	  -0.00000000070,    -0.00000000468,
	  -0.00000000101,     0.00000000063,
	   0.00000001904,    -0.00000001545,
	  -0.00000000589,    -0.00000000224,
	  -0.00000001671,    -0.00000001830,
	  -0.00000000195,     0.00000000628,
	   0.00000016271,    -0.00000004219,
	  -0.00000003200,    -0.00000004884,
	  -0.00000000752,     0.00000000852,
	   0.00000000207,     0.00000001131,
	   0.00000000064,    -0.00000000059,
	  -0.00000002753,     0.00000005504,
	   0.00000001464,     0.00000000085,
	  -0.00000000143,    -0.00000000111,
	   0.00000005274,     0.00000002883,
	   0.00000000173,    -0.00000001369,
	  -0.00000000084,     0.00000000064,
	   0.00000000076,     0.00000000072,
	   0.00000002110,    -0.00000000736,
	   0.00000000044,    -0.00000000067,
	  -0.00000000253,    -0.00000000255,
	  -0.00000000263,     0.00000000235,
	   0.00000001024,    -0.00000000039,
	   0.00000000134,     0.00000003390,
	   0.00000001110,    -0.00000000303,
	  -0.00000001191,     0.00000000268,
	   0.00000000109,     0.00000000183,
	   0.00000000581,     0.00000001243,
	   0.00000000140,    -0.00000000172,
	  -0.00000006572,    -0.00000000971,
	   0.00000000097,     0.00000001926,
	  -0.00000000071,    -0.00000008271,
	  -0.00000002755,     0.00000000517,
	   0.00000000283,     0.00000000612,
	   0.00000000941,    -0.00000003114,
	  -0.00000000566,    -0.00000000033,
	  -0.00000003245,    -0.00000000763,
	  -0.00000000033,     0.00000000430,
	  -0.00000012271,    -0.00000008892,
	  -0.00000000521,    -0.00000000036,
	   0.00000000157,     0.00000000158,
	   0.00000001546,     0.00000004951,
	   0.00000000835,    -0.00000000603,
	  -0.00000000026,    -0.00000000097,
	   0.00000004968,    -0.00000001526,
	  -0.00000000609,    -0.00000000807,
	  -0.00000000100,     0.00000000037,
	   0.00000000121,     0.00000000195,
	   0.00000000212,    -0.00000000118,
	  -0.00000000307,    -0.00000000130,
	  -0.00000000537,     0.00000000954,
	   0.00000005099,     0.00000002877,
	   0.00000000565,    -0.00000001359,
	   0.00000000697,    -0.00000001903,
	  -0.00000001843,     0.00000000035,
	   0.00000004697,    -0.00000009944,
	  -0.00000001488,    -0.00000000560,
	  -0.00000009400,    -0.00000007510,
	  -0.00000001118,     0.00000001631,
	   0.00000003446,     0.00000000162,
	  -0.00000000088,    -0.00000003969,
	  -0.00000000185,    -0.00000000113,
	   0.00000101024,     0.00000145848,
	   0.00000024761,    -0.00000021661,
	  -0.00000002675,    -0.00000002256,
	  -0.00000019597,     0.00000000620,
	   0.00000001749,     0.00000002881,
	   0.00000000476,    -0.00000000334,
	   0.00000000022,     0.00000000209,
	  -0.00000013056,    -0.00000005305,
	  -0.00000001178,     0.00000001203,
	  -0.00000004711,     0.00000012990,
	   0.00000001141,     0.00000000981,
	  -0.00000000106,    -0.00000000150,
	  -0.00000000064,     0.00000000207,
	  -0.00000000977,     0.00000000003,
	   0.00000000030,     0.00000002036,
	  -0.00000000057,    -0.00000000123,
	  -0.00000064669,     0.00000001737,
	  -0.00000000229,    -0.00000006885,
	  -0.00000000887,     0.00000000251,
	  -0.00000000047,     0.00000000283,
	  -0.00000331314,     0.00000015196,
	   0.00000001713,    -0.00000001167,
	   0.00000000754,    -0.00000037766,
	   0.00000002679,    -0.00000002452,
	  -0.00000000201,     0.00000000048,
	   0.00000000059,     0.00000000043,
	   0.00000003074,     0.00000001365,
	  -0.00000000067,    -0.00000000136,
	  -0.00000000108,     0.00000000034,
	   0.00000000034,     0.00000000108,
	   0.00000005404,    -0.00000000577,
	   0.00000000005,    -0.00000000217,
	  -0.00000000673,     0.00000001149,
	   0.00000001458,     0.00000000549,
	  -0.00000000161,     0.00000000185,
	  -0.00000000208,    -0.00000000078,
	  -0.00000000138,    -0.00000000112,
	   0.00000020610,     0.00000049816,
	  -0.00000004902,    -0.00000002716,
	  -0.00000007002,    -0.00000000675,
	   0.00000000647,    -0.00000000841,
	   0.00000000098,     0.00000000089,
	   0.00000003591,     0.00000000460,
	  -0.00000000167,     0.00000000078,
	   0.00000000476,     0.00000002725,
	   0.00000000057,     0.00000000153,
	   0.00000229288,     0.00000101769,
	  -0.00000012752,    -0.00000004575,
	   0.00000002376,    -0.00000000112,
	  -0.00000000198,     0.00000000277,
	  -0.00000012419,    -0.00000000505,
	  -0.00000000365,    -0.00000011486,
	   0.00000000047,    -0.00000000082,
	  -0.00000002696,     0.00000000921,
	  -0.00000000034,    -0.00000000091,
	   0.00000003729,    -0.00000000635,
	   0.00000000018,     0.00000000100,
	  -0.00000000387,    -0.00000001109,
	  -0.00000001228,     0.00000000345,
	   0.00000000069,    -0.00000000148,
	  -0.00000000522,    -0.00000000496,
	   0.00000000090,     0.00000000063,
	   0.00000000299,    -0.00000000561,
	   0.00000047766,    -0.00000230428,
	   0.00000017555,     0.00000031314,
	  -0.00000002884,    -0.00000000324,
	   0.00000016468,     0.00000001596,
	  -0.00000001964,     0.00000001378,
	   0.00000000008,    -0.00000000150,
	   0.00000002030,     0.00000002175,
	  -0.00000000139,    -0.00000000299,
	  -0.00000001690,     0.00000003351,
	  -0.00000000023,    -0.00000000200,
	  -0.00000056066,    -0.00000069771,
	   0.00000007908,     0.00000007374,
	  -0.00000000658,    -0.00000000107,
	   0.00000000171,    -0.00000000087,
	   0.00000003326,    -0.00000000336,
	  -0.00000000093,     0.00000000310,
	  -0.00000002946,     0.00000003363,
	   0.00000000369,    -0.00000000197,
	   0.00000000835,    -0.00000054056,
	   0.00000001619,     0.00000011429,
	  -0.00000000996,    -0.00000000991,
	   0.00000001444,     0.00000000048,
	  -0.00000000366,     0.00000000058,
	  -0.00000000695,    -0.00000000560,
	   0.00000000127,     0.00000000056,
	   0.00000000964,    -0.00000000377,
	  -0.00000000189,     0.00000000053,
	  -0.00000006415,     0.00000011883,
	   0.00000001264,    -0.00000003637,
	  -0.00000000453,    -0.00000000230,
	   0.00000000112,     0.00000000035,
	  -0.00000000034,    -0.00000000124,
	   0.00000000140,    -0.00000000027,
	  -0.00000000824,    -0.00000000465,
	   0.00000000686,     0.00000000911,
	  -0.00000002693,     0.00000002028,
	  -0.00000000219,    -0.00000000042,
	  -0.00000000021,     0.00000000108,
	   0.00000000076,     0.00000000366,
	   0.00000000064,    -0.00000000286,
	   0.00000000363,    -0.00000000078,
	  -0.00000000286,    -0.00000000064,
	   0.00000000231,    -0.00000000035,
	  -0.00000000059,    -0.00000000139,
	  -0.00000000134,     0.00000000075,
	  -0.00000000230,    -0.00000000784,
	  -0.00000000324,     0.00000000055,
	   0.00000000242,    -0.00000000111,
	  -0.00000000117,    -0.00000000291,
	   0.00000150134,     0.00000243344,
	   0.00000042484,    -0.00000035313,
	  -0.00000004770,    -0.00000004939,
	  -0.00000005497,     0.00000003511,
	   0.00000000839,     0.00000000942,
	   0.00000000110,    -0.00000000113,
	  -0.00000001083,    -0.00000004115,
	  -0.00000000440,     0.00000000326,
	  -0.00000004107,     0.00000001110,
	   0.00000000339,     0.00000000431,
	   0.00000000126,     0.00000000026,
	   0.00000000027,    -0.00000000125,
	  -0.00000000022,     0.00000000500,
	  -0.00000015077,    -0.00000000062,
	   0.00000000022,    -0.00000001681,
	  -0.00000000059,     0.00000000080,
	   0.00000746721,    -0.00000003221,
	   0.00000000365,    -0.00000050660,
	   0.00000000167,    -0.00000003963,
	  -0.00000000347,     0.00000000249,
	   0.00000003867,     0.00000000030,
	  -0.00000000236,    -0.00000000364,
	   0.00000000070,    -0.00000000182,
	   0.00000000180,     0.00000000073,
	   0.00000000111,    -0.00000000036,
	   0.00000000035,     0.00000000110,
	  -0.00000000088,     0.00000003222,
	  -0.00000002737,    -0.00000000075,
	   0.00000000248,    -0.00000000033,
	   0.00000000773,    -0.00000001793,
	  -0.00000003447,     0.00000000202,
	   0.00000000011,     0.00000000248,
	   0.00000000029,     0.00000000072,
	  -0.00000000063,     0.00000001704,
	   0.00000000004,     0.00000000247,
	  -0.00000000011,    -0.00000000037,
	   0.00000000001,    -0.00000000036,
	  -0.00000000001,     0.00000000061,
	  -0.00000000237,     0.00000004308,
	   0.00000000053,     0.00000000007,
	  -0.00000000008,     0.00000000053,
	   0.00000000000,     0.00000000050,
	  -0.00000000381,     0.00000007194,
	   0.00000000172,     0.00000000052,
	  -0.00000000060,     0.00000000225,
	  -0.00000000803,     0.00000014334,
	   0.00000000444,    -0.00000000515,
	   0.00000000024,     0.00000000043,
	   0.00000000003,    -0.00000000278,
	   0.00000000029,    -0.00000000025,
	  -0.00000000001,     0.00000000166,
	   0.00020577646,     0.00000563936,
	  -0.00000004946,    -0.00000007307,
	   0.00000000005,     0.00000006877,
	   0.00000478257,    -0.00023786377,
	  -0.00000007144,     0.00000001308,
	   0.00000009154,     0.00000000287,
	  -0.00000076476,     0.00000316508,
	   0.00000083609,    -0.00000075580,
	  -0.00000004547,    -0.00000004052,
	  -0.00000000194,     0.00000000333,
	  -0.00000910427,     0.00000790299,
	   0.00000052757,     0.00000061041,
	   0.00000004545,    -0.00000005899,
	  -0.00000000273,    -0.00000000052,
	  -0.00000002429,    -0.00000138227,
	   0.00000001567,    -0.00000015354,
	  -0.00000000057,     0.00000000934,
	   0.00000009154,    -0.00000101673,
	   0.00000001502,     0.00000018780,
	   0.00000000033,     0.00000000555,
	   0.03363446980,    -0.00003436390,
	   0.00000455602,     0.00000164427,
	  -0.00000005740,     0.00001756000,
	  -0.00000001058,    -0.00000001604,
	  -0.00001166001,     0.00259781931,
	   0.00000013279,    -0.00000012452,
	  -0.00000126412,    -0.00000000824,
	   0.00002518229,    -0.00012217352,
	   0.00000523135,     0.00000931792,
	  -0.00000029027,     0.00000075946,
	  -0.00000001572,    -0.00000003667,
	  -0.00004522399,    -0.00002069197,
	   0.00000463524,    -0.00001223248,
	   0.00000032828,     0.00000073342,
	  -0.00000001169,     0.00000003159,
	   0.00000574731,    -0.00000447757,
	  -0.00000098997,    -0.00000037064,
	  -0.00000004416,     0.00000004518,
	   0.00000000282,    -0.00000000092,
	  -0.00000768129,    -0.00000350556,
	  -0.00000074629,     0.00000054728,
	   0.00000006515,     0.00000003454,
	   0.00000000166,    -0.00000000116,
	   0.00011329540,     0.00000329550,
	  -0.00000021719,    -0.00000029746,
	   0.00000001743,     0.00000005023,
	  -0.00000003075,     0.00000015317,
	  -0.00000000127,    -0.00000000549,
	  -0.00000077148,    -0.00000088501,
	   0.00000002394,     0.00000010732,
	  -0.00000000085,     0.00000000663,
	  -0.00000058829,    -0.00000056413,
	   0.00000000107,    -0.00000011759,
	   0.00000000082,     0.00000000778,
	   0.00000000234,    -0.00000000040,
	  -0.00000000230,     0.00000000023,
	   0.00024649447,    -0.00000001095,
	   0.00000002829,     0.00000001127,
	  -0.00000000029,     0.00000012673,
	  -0.00000001073,     0.00000010941,
	  -0.00000000009,     0.00000000116,
	   0.00000000108,     0.00000000001,
	  -0.00000087495,    -0.00000019012,
	  -0.00000005773,     0.00000006758,
	   0.00000000429,     0.00000000361,
	   0.00000017238,    -0.00000087800,
	  -0.00000006641,    -0.00000005900,
	  -0.00000000350,     0.00000000436,
	  -0.00000000218,     0.00000000194,
	  -0.00000000182,     0.00000000157,
	   0.00000000004,    -0.00000000002,
	   0.00000000131,     0.00000000000,
	  -0.00000000001,     0.00000000130,
	  -0.00000000139,    -0.00000000015,
	   0.00000001412,     0.00000000010,
	  -0.00000000012,     0.00000001416,
	  -0.00000000144,    -0.00000000020,
	   0.00000001466,     0.00000000002,
	  -0.00000000003,     0.00000001470,
	   0.00000000022,    -0.00000000034,
	   0.00000000051,    -0.00000000028,
	  -0.00000000093,    -0.00000000146,
	   0.00000000304,     0.00000000006,
	  -0.00000000005,     0.00000000304,
	   0.00000000133,     0.00000000000,
	   0.00000000000,     0.00000000133,
	  -0.00000000045,     0.00000000214,
	   0.00000000085,     0.00000000054,
	   0.00000000054,    -0.00000000085,
	  -0.00000000234,    -0.00000000112,
	   0.00000000111,    -0.00000000103,
	  -0.00000000118,    -0.00000000019,
	  -0.00000000081,    -0.00000000057,
	   0.00000000127,     0.00000000056,
	   0.00000000047,    -0.00000000127,
	  -0.00000000645,    -0.00000001919,
	  -0.00000001670,     0.00000000469,
	   0.00000001153,     0.00000000913,
	   0.00000000457,     0.00000002805,
	   0.00000001631,    -0.00000001994,
	  -0.00000000607,    -0.00000000290,
	  -0.00000000480,    -0.00000000098,
	  -0.00000000408,     0.00000001150,
	  -0.00000007497,     0.00000004407,
	   0.00000001664,    -0.00000002398,
	   0.00000001965,     0.00000003176,
	  -0.00000000857,    -0.00000000797,
	   0.00000000085,     0.00000000316,
	   0.00000004055,    -0.00000000574,
	  -0.00000000821,    -0.00000000391,
	  -0.00000000588,    -0.00000004046,
	  -0.00000000372,     0.00000000797,
	  -0.00000000012,     0.00000004752,
	   0.00000000814,    -0.00000000328,
	   0.00000010417,     0.00000000537,
	  -0.00000000626,    -0.00000001869,
	  -0.00000000140,     0.00000000126,
	  -0.00000001346,    -0.00000009567,
	  -0.00000000685,     0.00000001276,
	  -0.00000010084,     0.00000000762,
	   0.00000001092,     0.00000000905,
	  -0.00000030339,    -0.00000034021,
	  -0.00000000009,     0.00000007294,
	   0.00000000493,    -0.00000000499,
	  -0.00000025202,    -0.00000000969,
	   0.00000001534,     0.00000004576,
	   0.00000000566,    -0.00000000406,
	   0.00000000568,    -0.00000005254,
	  -0.00000000862,     0.00000000282,
	  -0.00000004325,     0.00000000186,
	   0.00000000531,     0.00000000374,
	   0.00000008946,    -0.00000005220,
	  -0.00000003288,    -0.00000000268,
	  -0.00000000338,    -0.00000002310,
	  -0.00000000244,     0.00000000425,
	  -0.00000001286,    -0.00000000566,
	   0.00000000087,     0.00000000652,
	   0.00000000089,    -0.00000000035,
	  -0.00000000593,     0.00000001306,
	   0.00000000652,    -0.00000000090,
	  -0.00000000032,    -0.00000000079,
	   0.00000000187,    -0.00000000530,
	  -0.00000000618,    -0.00000000178,
	  -0.00000000405,     0.00000001064,
	   0.00000001051,     0.00000000092,
	  -0.00000000111,    -0.00000000076,
	   0.00000010256,     0.00000012056,
	   0.00000000780,    -0.00000002524,
	   0.00000001674,    -0.00000000805,
	  -0.00000000242,    -0.00000000199,
	  -0.00000001331,     0.00000004225,
	   0.00000000354,    -0.00000000336,
	   0.00000004200,     0.00000002118,
	  -0.00000000101,    -0.00000000417,
	   0.00000089923,     0.00000029296,
	   0.00000008474,    -0.00000000923,
	  -0.00000002461,     0.00000006106,
	   0.00000001310,     0.00000000164,
	  -0.00000000009,    -0.00000000163,
	  -0.00000035120,    -0.00000007629,
	  -0.00000002272,     0.00000002697,
	   0.00000000144,     0.00000000114,
	  -0.00000007533,     0.00000035149,
	   0.00000002687,     0.00000002231,
	   0.00000000114,    -0.00000000141,
	   0.00000000131,     0.00000000155,
	   0.00000000168,    -0.00000000129,
	  -0.00000000095,    -0.00000000007,
	   0.00000000373,     0.00000000196,
	   0.00000000152,    -0.00000000385,
	   0.00000007131,    -0.00000011916,
	  -0.00000001182,     0.00000000644,
	   0.00000000356,     0.00000000174,
	   0.00000003630,    -0.00000000032,
	   0.00000000160,    -0.00000003618,
	  -0.00002609903,    -0.00000546301,
	  -0.00000144765,     0.00000178162,
	   0.00000010800,     0.00000008622,
	   0.00000017669,    -0.00000078575,
	  -0.00000006193,    -0.00000005379,
	  -0.00000000354,     0.00000000398,
	   0.00000056393,     0.00000007984,
	  -0.00000000614,    -0.00000000663,
	   0.00000007544,    -0.00000055371,
	  -0.00000000611,     0.00000000719,
	   0.00000000452,    -0.00000000345,
	  -0.00000000030,    -0.00000000074,
	  -0.00000000350,    -0.00000000437,
	  -0.00000000074,     0.00000000031,
	  -0.00000003562,    -0.00000000808,
	  -0.00000000371,    -0.00000000021,
	  -0.00000000029,     0.00000000366,
	  -0.00000003969,    -0.00000003916,
	   0.00000000084,    -0.00000000626,
	   0.00000000399,    -0.00000000024,
	  -0.00000000018,    -0.00000000417,
	  -0.00000000413,     0.00000000023,
	  -0.00000000023,    -0.00000000414,
	  -0.00000000275,    -0.00000000097,
	   0.00000000111,     0.00000000152,
	   0.00000000164,     0.00000000141,
	  -0.00000003224,    -0.00000003048,
	   0.00000000568,     0.00000000024,
	  -0.00000000062,     0.00000000071,
	  -0.00000000607,    -0.00000000108,
	  -0.00000000102,    -0.00000000504,
	  -0.00001066470,    -0.00002826123,
	   0.00000283399,     0.00000199540,
	  -0.00000016822,     0.00000014904,
	   0.00000051559,    -0.00000014426,
	  -0.00000003499,     0.00000005082,
	  -0.00000000339,    -0.00000000330,
	   0.00000052007,     0.00000067920,
	  -0.00000005237,    -0.00000008979,
	   0.00000000864,     0.00000000122,
	   0.00000065962,     0.00000077628,
	  -0.00000008816,     0.00000005150,
	   0.00000000047,    -0.00000000854,
	   0.00000000388,    -0.00000000162,
	   0.00000000302,     0.00000000172,
	  -0.00000000221,     0.00000000131,
	   0.00000000082,    -0.00000000076,
	   0.00000000068,    -0.00000000071,
	   0.00000001118,     0.00000002842,
	  -0.00000000863,     0.00000000135,
	   0.00000000497,    -0.00000000306,
	   0.00000000053,     0.00000000145,
	  -0.00000000363,    -0.00000000282,
	   0.00000000057,    -0.00000000106,
	   0.00000000302,     0.00000000300,
	  -0.00000000153,     0.00000000014,
	  -0.00000427208,     0.00002724471,
	  -0.00000217934,    -0.00000353569,
	   0.00000034391,     0.00000002383,
	  -0.00000001380,     0.00000001907,
	  -0.00000107785,    -0.00000017529,
	   0.00000013927,    -0.00000008664,
	  -0.00000000083,     0.00000001353,
	  -0.00000000067,    -0.00000000048,
	  -0.00000005255,    -0.00000008192,
	   0.00000000847,     0.00000000431,
	   0.00000012567,    -0.00000004921,
	  -0.00000000996,     0.00000001303,
	  -0.00000000055,    -0.00000000092,
	  -0.00000000032,    -0.00000000304,
	  -0.00000000013,     0.00000000269,
	   0.00000000153,    -0.00000000446,
	  -0.00000000243,    -0.00000000072,
	   0.00000000111,     0.00000000003,
	  -0.00000001165,     0.00000003148,
	  -0.00000000731,    -0.00000000703,
	   0.00000000650,     0.00000000224,
	  -0.00000000137,     0.00000000144,
	  -0.00000000049,    -0.00000000686,
	   0.00000000145,     0.00000000035,
	   0.00000000146,     0.00000000240,
	  -0.00000000098,    -0.00000000084,
	   0.00000003457,    -0.00000010128,
	   0.00000000316,     0.00000002100,
	  -0.00000000244,    -0.00000000227,
	  -0.00000001052,     0.00000003527,
	  -0.00000000212,    -0.00000000530,
	  -0.00000003532,    -0.00000001059,
	   0.00000000530,    -0.00000000213,
	  -0.00000000262,    -0.00000000107,
	   0.00000000105,    -0.00000000259,
	   0.00000000088,    -0.00000000018,
	   0.00000000019,     0.00000000089,
	   0.00000000018,    -0.00000000540,
	   0.00000000062,     0.00000000072,
	   0.00000000541,     0.00000000017,
	  -0.00000000069,     0.00000000059,
	   0.00000000079,     0.00000000098,
	  -0.00000000098,     0.00000000079,
	   0.00000000074,     0.00000000079,
	   0.00000000082,    -0.00000000081,
	   0.00000002619,     0.00000002707,
	  -0.00000000104,     0.00000000093,
	  -0.00000000081,    -0.00000000096,
	  -0.00000000096,     0.00000000081,
	  -0.00000005379,    -0.00000005745,
	   0.00000000157,    -0.00000000141,
	  -0.00000002033,    -0.00000001018,
	   0.00000000341,     0.00000000064,
	   0.00000000064,    -0.00000000341,
	  -0.00000000092,    -0.00000000034,
	  -0.00000000035,     0.00000000092,
	  -0.00000004820,     0.00000000140,
	   0.00000000285,     0.00000000461,
	   0.00000000452,    -0.00000000328,
	   0.00000012112,     0.00000015541,
	  -0.00000001605,    -0.00000000783,
	  -0.00000000603,     0.00000000434,
	  -0.00000000078,    -0.00000000311,
	  -0.00000000312,     0.00000000078,
	   0.00000000112,    -0.00000000030,
	  -0.00000000125,     0.00000000032,
	  -0.00000000084,     0.00000000130,
	   0.00000000125,     0.00000000084,
	  -0.00000000699,     0.00000000234,
	   0.00000000006,     0.00000000123,
	   0.00000000231,     0.00000000704,
	   0.00000000123,    -0.00000000007,
	   0.00000018432,     0.00000005774,
	   0.00000001364,    -0.00000001713,
	  -0.00000000105,     0.00000000511,
	  -0.00000000369,    -0.00000000018,
	  -0.00000000017,     0.00000000370,
	   0.00000003189,    -0.00000000145,
	  -0.00000004778,    -0.00000019317,
	   0.00000002351,     0.00000001262,
	   0.00000000550,    -0.00000000137,
	  -0.00000000036,     0.00000000067,
	  -0.00000000361,    -0.00000002291,
	   0.00000000069,    -0.00000000093,
	   0.00000000652,    -0.00000000013,
	   0.00000000004,    -0.00000000647,
	  -0.00003806857,    -0.00000967540,
	  -0.00000262362,     0.00000299690,
	   0.00000019500,     0.00000016074,
	   0.00000022643,    -0.00000109628,
	  -0.00000008392,    -0.00000007298,
	  -0.00000000443,     0.00000000540,
	   0.00000077127,     0.00000000426,
	   0.00000000271,    -0.00000077313,
	   0.00000000053,    -0.00000000374,
	  -0.00000000370,    -0.00000000055,
	   0.00000017285,     0.00000001091,
	  -0.00000000007,     0.00000000114,
	   0.00000000428,     0.00000000022,
	  -0.00000000029,     0.00000000430,
	   0.00000003558,    -0.00000001622,
	   0.00000000056,     0.00000000106,
	   0.00000000381,    -0.00000000763,
	   0.00000000155,     0.00000000120,
	  -0.00000000153,    -0.00000000029,
	  -0.00000000023,    -0.00000000133,
	   0.00000150416,     0.00000190612,
	  -0.00000003369,     0.00000000005,
	  -0.00000000356,    -0.00000000307,
	   0.00000083058,     0.00000000097,
	  -0.00000000128,     0.00000083107,
	   0.00000000045,    -0.00000000294,
	   0.00000000295,     0.00000000042,
	   0.00000000013,     0.00000000040,
	   0.00000000004,    -0.00000000001,
	   0.00000000067,     0.00000000141,
	  -0.00000000140,     0.00000000069,
	   0.00000000006,     0.00000000006,
	  -0.00000000007,     0.00000000008,
	  -0.00000000037,     0.00000000015,
	  -0.00000000083,    -0.00000000025,
	  -0.00000000054,     0.00000000064,
	  -0.00000000071,    -0.00000000060,
	  -0.00000000146,    -0.00000000059,
	   0.00000000335,    -0.00000000289,
	   0.00000000272,     0.00000000334,
	  -0.00000288855,    -0.00000868060,
	   0.00000236144,    -0.00000038114,
	   0.00000000534,     0.00000033865,
	  -0.00000002995,    -0.00000000532,
	  -0.00000426333,     0.00000132337,
	  -0.00000019303,    -0.00000112297,
	   0.00000016382,    -0.00000000952,
	  -0.00000000152,     0.00000001429,
	   0.00000300587,    -0.00000197942,
	   0.00000013191,     0.00000075107,
	  -0.00000011798,    -0.00000002416,
	   0.00000000643,    -0.00000001381,
	   0.00000239362,     0.00000039929,
	   0.00000025216,     0.00000042893,
	  -0.00000005922,     0.00000008040,
	  -0.00000001180,    -0.00000000783,
	   0.00000021405,    -0.00000031736,
	  -0.00000004416,    -0.00000003397,
	  -0.00000000127,     0.00000000194,
	   0.00000030706,     0.00000022984,
	   0.00000003185,    -0.00000004506,
	  -0.00000000192,    -0.00000000153,
	   0.00002011092,     0.00004112347,
	  -0.00001289900,     0.00000299312,
	  -0.00000010224,    -0.00000197387,
	   0.00000017118,     0.00000002953,
	  -0.00000000444,     0.00000001139,
	   0.00001002688,    -0.00000338571,
	   0.00000053982,     0.00000274966,
	  -0.00000042425,     0.00000003463,
	   0.00000000340,    -0.00000003571,
	   0.00000000254,     0.00000000055,
	  -0.00001064184,    -0.00000871279,
	   0.00000114884,    -0.00000198926,
	   0.00000040465,     0.00000020878,
	  -0.00000003208,     0.00000005401,
	  -0.00000000511,    -0.00000000364,
	   0.00000683737,     0.00000062961,
	  -0.00000236653,    -0.00000016149,
	   0.00000015612,    -0.00000045432,
	   0.00000005684,     0.00000002994,
	  -0.00000000369,     0.00000000542,
	   0.00000204123,    -0.00000256001,
	  -0.00000032521,    -0.00000023675,
	  -0.00000001977,     0.00000002216,
	   0.00000259096,     0.00000198015,
	   0.00000024430,    -0.00000032142,
	  -0.00000002231,    -0.00000001890,
	  -0.00000002188,     0.00000000835,
	   0.00000000593,     0.00000000535,
	  -0.00000000067,     0.00000000070,
	   0.00000014652,    -0.00000008313,
	   0.00000001012,     0.00000001249,
	  -0.00000000064,     0.00000000053,
	   0.00000008333,     0.00000014698,
	  -0.00000001269,     0.00000001013,
	  -0.00000000052,    -0.00000000069,
	   0.00000000258,    -0.00000000313,
	   0.00000000316,     0.00000000256,
	   0.00000000047,    -0.00000000152,
	   0.00000010975,    -0.00000010601,
	   0.00000001274,     0.00000001431,
	  -0.00000000079,     0.00000000068,
	   0.00000010617,     0.00000011040,
	  -0.00000001455,     0.00000001277,
	  -0.00000000066,    -0.00000000086,
	  -0.00000000261,    -0.00000000256,
	   0.00000000255,    -0.00000000260,
	  -0.00000000041,    -0.00000000416,
	   0.00000000032,     0.00000000273,
	   0.00000000052,     0.00000000203,
	  -0.00000002500,    -0.00000000940,
	  -0.00000000990,     0.00000000300,
	   0.00000000112,    -0.00000000032,
	  -0.00000000295,     0.00000000497,
	   0.00000000075,    -0.00000000036,
	   0.00000000500,     0.00000000282,
	  -0.00000000036,    -0.00000000075,
	   0.00000000089,    -0.00000000062,
	  -0.00000000013,     0.00000000111,
	   0.00000000109,     0.00000000008,
	  -0.00000006180,     0.00000018088,
	   0.00000002919,    -0.00000001817,
	  -0.00000000339,     0.00000000218,
	   0.00000000068,     0.00000000058,
	   0.00000000931,    -0.00000008002,
	  -0.00000000986,     0.00000000844,
	   0.00000000122,     0.00000000018,
	  -0.00000007999,    -0.00000000932,
	   0.00000000847,     0.00000000980,
	   0.00000000017,    -0.00000000120,
	  -0.00000000097,     0.00000000030,
	   0.00000000024,     0.00000000221,
	   0.00000000224,    -0.00000000023,
	  -0.00000000768,     0.00000002841,
	  -0.00000000039,     0.00000000170,
	   0.00000000202,     0.00000000092,
	   0.00000000089,    -0.00000000198,
	   0.00000015604,    -0.00000236521,
	  -0.00000028740,     0.00000025233,
	   0.00000003473,     0.00000000965,
	   0.00000003342,    -0.00000001215,
	  -0.00000000541,    -0.00000000286,
	   0.00000006613,     0.00000074384,
	   0.00000006273,    -0.00000008843,
	  -0.00000000915,     0.00000000005,
	   0.00000074307,    -0.00000006641,
	  -0.00000008834,    -0.00000006257,
	   0.00000000007,     0.00000000914,
	   0.00000003908,    -0.00000004203,
	   0.00000000144,     0.00000000136,
	   0.00000007193,    -0.00000004646,
	   0.00000000367,    -0.00000000536,
	  -0.00000000100,     0.00000000010,
	  -0.00000000375,    -0.00000000119,
	  -0.00000000117,     0.00000000349,
	   0.00000309535,     0.00002169914,
	   0.00000178742,    -0.00000262838,
	  -0.00000025982,     0.00000000339,
	   0.00000001009,     0.00000001491,
	  -0.00000098260,     0.00000017833,
	   0.00000012948,     0.00000008003,
	  -0.00000000053,    -0.00000001249,
	  -0.00000000080,     0.00000000058,
	   0.00000019500,    -0.00000056224,
	  -0.00000005647,     0.00000003235,
	   0.00000000311,     0.00000000368,
	  -0.00000054792,    -0.00000019281,
	   0.00000003098,     0.00000005446,
	   0.00000000359,    -0.00000000290,
	  -0.00000000586,    -0.00000000657,
	  -0.00000000657,     0.00000000586,
	   0.00000000075,    -0.00000000302,
	  -0.00000000301,    -0.00000000075,
	   0.00000003647,    -0.00000014647,
	   0.00000000483,     0.00000000120,
	   0.00000001380,    -0.00000001138,
	  -0.00000000885,    -0.00000001148,
	   0.00000000088,     0.00000000139,
	   0.00000000309,     0.00000000790,
	  -0.00000000100,    -0.00000000111,
	   0.00000000669,    -0.00000000196,
	  -0.00000000079,     0.00000000112,
	  -0.00000035670,     0.00000014406,
	   0.00000002041,    -0.00000000736,
	  -0.00000006331,    -0.00000009620,
	   0.00000000314,     0.00000000733,
	  -0.00000000876,    -0.00000002800,
	   0.00000000448,     0.00000000372,
	  -0.00000003461,     0.00000001163,
	   0.00000000456,    -0.00000000416,
	  -0.00000614219,    -0.00001003602,
	  -0.00000081341,     0.00000066409,
	   0.00000004534,     0.00000004979,
	   0.00000134699,     0.00000030297,
	  -0.00000009120,    -0.00000014130,
	  -0.00000000795,     0.00000000728,
	  -0.00000005332,    -0.00000002320,
	  -0.00000000179,     0.00000000457,
	   0.00000002428,     0.00000002401,
	  -0.00000000439,    -0.00000000058,
	   0.00000000111,     0.00000000142,
	   0.00000000196,    -0.00000000115,
	  -0.00000001984,    -0.00000001501,
	   0.00000001203,     0.00000000032,
	   0.00000000021,    -0.00000000863,
	   0.00000086254,    -0.00000000814,
	  -0.00000000185,    -0.00000008010,
	  -0.00000000390,     0.00000000167,
	  -0.00000000474,    -0.00000000491,
	   0.00008139242,     0.00000024852,
	   0.00000002524,    -0.00000002688,
	  -0.00000000055,    -0.00000002040,
	   0.00000001058,    -0.00000071149,
	  -0.00000000026,    -0.00000000122,
	   0.00000003773,    -0.00000016575,
	  -0.00000000897,     0.00000001375,
	   0.00000000052,     0.00000000099,
	   0.00000011052,    -0.00000002946,
	  -0.00000000484,    -0.00000001688,
	  -0.00000000056,     0.00000000106,
	   0.00000000187,    -0.00000000796,
	  -0.00000000120,    -0.00000000534,
	   0.00000007212,     0.00000000280,
	   0.00000001209,    -0.00000000903,
	   0.00000000246,     0.00000000026,
	   0.00000000010,     0.00000000234,
	   0.00000272541,    -0.00000191927,
	   0.00000026853,     0.00000031624,
	  -0.00000002439,     0.00000001619,
	   0.00000008511,     0.00000003809,
	  -0.00000001336,     0.00000001330,
	  -0.00000000072,    -0.00000000086,
	   0.00000094573,     0.00000000437,
	  -0.00000000884,     0.00000094139,
	  -0.00000000013,    -0.00000000103,
	   0.00000000102,    -0.00000000059,
	   0.00000182917,    -0.00000010665,
	  -0.00000000748,     0.00000002902,
	  -0.00000000068,    -0.00000001255,
	   0.00000000080,    -0.00000000031,
	   0.00000031659,    -0.00000005672,
	   0.00000002665,    -0.00000002211,
	   0.00000000042,     0.00000000074,
	   0.00000000684,    -0.00000000040,
	   0.00000000040,     0.00000000685,
	   0.00000000010,    -0.00000000101,
	  -0.00000003874,     0.00000005705,
	  -0.00000000659,    -0.00000000033,
	   0.00000000039,    -0.00000000652,
	  -0.00000006018,     0.00000001454,
	   0.00000000106,     0.00000000046,
	   0.00000005594,    -0.00000000832,
	   0.00000000823,    -0.00000010655,
	   0.00000000372,    -0.00000000188,
	  -0.00000000186,    -0.00000000373,
	   0.00000000026,     0.00000000130,
	   0.00000000131,    -0.00000000026,
	   0.00000000627,     0.00000002442,
	  -0.00000000132,     0.00000000029,
	  -0.00000000829,    -0.00000001295,
	   0.00000000147,     0.00000000033,
	  -0.00000173997,    -0.00000009677,
	   0.00000000754,     0.00000002738,
	  -0.00000000069,     0.00000001231,
	   0.00000000082,    -0.00000000030,
	  -0.00000001145,    -0.00000000218,
	  -0.00000000127,     0.00000000243,
	   0.00000243746,    -0.00000367879,
	  -0.00000009266,     0.00000003244,
	  -0.00000001431,    -0.00000001792,
	  -0.00000001551,    -0.00000000017,
	  -0.00000000013,     0.00000001553,
	   0.00000518509,    -0.00000388431,
	   0.00000053441,     0.00000061435,
	  -0.00000004737,     0.00000003182,
	   0.00000010451,     0.00000017176,
	  -0.00000001904,     0.00000001653,
	  -0.00000000087,    -0.00000000106,
	   0.00000130964,    -0.00000000061,
	   0.00000000048,     0.00000131093,
	   0.00000000057,    -0.00000000112,
	  -0.00000000111,    -0.00000000056,
	   0.00000001900,    -0.00000004617,
	  -0.00000000284,     0.00000000276,
	   0.00000000268,     0.00000000283,
	  -0.00000008387,     0.00000010147,
	  -0.00000000476,    -0.00000000444,
	   0.00000000144,    -0.00000000124,
	  -0.00000000157,    -0.00000000134,
	  -0.00000000130,     0.00000000089,
	  -0.00000004292,    -0.00000000950,
	   0.00000005520,     0.00000001580,
	  -0.00000000069,     0.00000000055,
	   0.00000000056,     0.00000000065,
	  -0.00000001954,     0.00000001986,
	  -0.00000000093,    -0.00000000099,
	   0.00000000065,    -0.00000000056,
	  -0.00000000083,    -0.00000000044,
	  -0.00000000080,    -0.00000000121,
	   0.00000000010,    -0.00000000019,
	  -0.00000000145,    -0.00000000422,
	   0.00000000027,    -0.00000000029,
	   0.00000000422,    -0.00000000144,
	   0.00000000030,     0.00000000030,
	  -0.00000000019,    -0.00000000014,
	   0.00000000014,    -0.00000000023,
	   0.00000000058,    -0.00000000039,
	   0.00000000039,     0.00000000058,
	   0.00000000050,    -0.00000000177,
	   0.00000000177,     0.00000000050,
	   0.00000000179,     0.00000000105,
	  -0.00000000017,     0.00000000044,
	  -0.00000001350,     0.00000000732,
	  -0.00000000178,    -0.00000000136,
	  -0.00000000726,    -0.00000001360,
	   0.00000000135,    -0.00000000176,
	  -0.00000000059,     0.00000000006,
	   0.00000000014,    -0.00000000069,
	   0.00000880151,     0.00000130148,
	  -0.00000097946,     0.00000340387,
	  -0.00000067089,    -0.00000028235,
	   0.00000004919,    -0.00000008628,
	   0.00000000809,     0.00000000607,
	   0.00000055583,    -0.00000335451,
	   0.00000129041,     0.00000039020,
	  -0.00000011028,     0.00000025424,
	  -0.00000003262,    -0.00000001905,
	   0.00000000234,    -0.00000000304,
	  -0.00000002208,     0.00000000011,
	   0.00000000952,     0.00000001411,
	  -0.00000000633,     0.00000000177,
	  -0.00000004723,    -0.00000012943,
	   0.00000004290,    -0.00000001423,
	   0.00000000391,     0.00000000911,
	  -0.00000000165,     0.00000000055,
	   0.00000002000,     0.00000005397,
	   0.00000000353,    -0.00000000121,
	  -0.00000005796,     0.00000001447,
	   0.00000000279,     0.00000000274,
	  -0.00000000099,     0.00000000054,
	  -0.00003924689,    -0.00000560014,
	   0.00000433560,    -0.00001534188,
	   0.00000302464,     0.00000126202,
	  -0.00000022122,     0.00000038922,
	  -0.00000003670,    -0.00000002718,
	  -0.00000126142,     0.00000758797,
	  -0.00000291547,    -0.00000088286,
	   0.00000024929,    -0.00000057592,
	   0.00000007434,     0.00000004325,
	  -0.00000000530,     0.00000000699,
	   0.00000007685,    -0.00000039775,
	   0.00000000590,    -0.00000004191,
	   0.00000002240,    -0.00000000353,
	   0.00000000130,     0.00000000461,
	   0.00000055931,     0.00000043632,
	  -0.00000015195,     0.00000009031,
	  -0.00000001765,    -0.00000003100,
	   0.00000000529,    -0.00000000215,
	  -0.00000003436,    -0.00000011134,
	  -0.00000000591,    -0.00000000422,
	   0.00000000027,    -0.00000000127,
	   0.00000013690,    -0.00000000442,
	  -0.00000000491,    -0.00000000063,
	   0.00000000075,    -0.00000000115,
	  -0.00000000273,    -0.00000000409,
	   0.00000000044,    -0.00000000126,
	  -0.00000006038,     0.00000003717,
	  -0.00000001731,    -0.00000000750,
	   0.00000000061,    -0.00000000241,
	  -0.00000003724,    -0.00000006030,
	   0.00000000747,    -0.00000001734,
	   0.00000000241,     0.00000000059,
	  -0.00000000042,     0.00000000111,
	  -0.00000007510,     0.00000004249,
	  -0.00000002217,    -0.00000000880,
	   0.00000000074,    -0.00000000301,
	  -0.00000004256,    -0.00000007503,
	   0.00000000876,    -0.00000002221,
	   0.00000000302,     0.00000000073,
	  -0.00000000006,    -0.00000000077,
	  -0.00000001020,     0.00000001440,
	   0.00000000106,     0.00000000094,
	   0.00000000018,     0.00000000501,
	  -0.00000000003,    -0.00000000106,
	   0.00000000500,    -0.00000000024,
	  -0.00000000106,     0.00000000003,
	   0.00000000633,     0.00000012334,
	   0.00000000267,    -0.00000002868,
	  -0.00000000378,     0.00000000240,
	   0.00000000137,    -0.00000000029,
	   0.00000000436,    -0.00000001650,
	  -0.00000000059,     0.00000000287,
	  -0.00000001642,    -0.00000000438,
	   0.00000000283,     0.00000000059,
	  -0.00000000672,     0.00000000727,
	  -0.00000000044,     0.00000000115,
	   0.00000000170,    -0.00000000024,
	  -0.00000000019,    -0.00000000170,
	   0.00000012201,    -0.00000047548,
	  -0.00000003305,     0.00000007745,
	   0.00000002682,    -0.00000000393,
	  -0.00000000600,    -0.00000000011,
	  -0.00000001231,     0.00000000001,
	   0.00000000030,     0.00000000170,
	  -0.00000000026,     0.00000001180,
	   0.00000000173,    -0.00000000024,
	  -0.00000000090,    -0.00000000067,
	   0.00000000045,     0.00000000131,
	   0.00000000131,    -0.00000000051,
	   0.00000004183,    -0.00000001800,
	  -0.00000000330,    -0.00000000678,
	  -0.00000000316,    -0.00000000007,
	  -0.00000000036,     0.00000000284,
	  -0.00000089756,     0.00000094176,
	   0.00000009793,    -0.00000007054,
	   0.00000002198,     0.00000003149,
	   0.00000000027,    -0.00000000229,
	   0.00000002946,    -0.00000000499,
	   0.00000000085,    -0.00000000073,
	   0.00000000104,    -0.00000002937,
	  -0.00000000155,    -0.00000000141,
	   0.00000000069,     0.00000000064,
	   0.00000000965,    -0.00000000969,
	  -0.00000000170,    -0.00000000156,
	   0.00000000069,     0.00000000314,
	   0.00000000315,    -0.00000000085,
	  -0.00000014767,     0.00000003682,
	   0.00000000118,     0.00000001328,
	   0.00000000060,     0.00000000048,
	   0.00000000162,    -0.00000000066,
	   0.00000364597,    -0.00000147889,
	  -0.00000017038,     0.00000004075,
	  -0.00000000692,    -0.00000005502,
	  -0.00000000190,    -0.00000000111,
	  -0.00000002847,     0.00000000275,
	   0.00000000249,     0.00000002758,
	   0.00000000835,     0.00000003369,
	  -0.00000000460,    -0.00000000464,
	   0.00000001516,    -0.00000000418,
	  -0.00000000187,     0.00000000217,
	  -0.00000001605,    -0.00000000138,
	   0.00000000249,    -0.00000000278,
	  -0.00000000391,     0.00000001146,
	  -0.00000000268,    -0.00000000218,
	   0.00000023601,    -0.00000021615,
	   0.00000003008,     0.00000002898,
	  -0.00000003888,     0.00000000527,
	   0.00000000473,    -0.00000000548,
	   0.00000005146,     0.00000001479,
	  -0.00000000975,     0.00000001153,
	  -0.00000000113,    -0.00000000201,
	   0.00000000765,    -0.00000006749,
	   0.00000001203,     0.00000001053,
	  -0.00000000185,     0.00000000104,
	  -0.00000000045,     0.00000000056,
	  -0.00000853681,    -0.00000042659,
	   0.00000001555,     0.00000003482,
	   0.00000000179,     0.00000000958,
	   0.00000001689,    -0.00000000431,
	   0.00000000117,     0.00000000136,
	   0.00000000048,    -0.00000000843,
	   0.00000000113,    -0.00000000142,
	  -0.00000000760,     0.00000000162,
	   0.00000000105,     0.00000000336,
	  -0.00000000153,    -0.00000000005,
	   0.00000000024,    -0.00000000149,
	   0.00000000808,     0.00000001332,
	  -0.00000000320,    -0.00000000138,
	   0.00000000036,    -0.00000000067,
	  -0.00000007749,     0.00000420213,
	  -0.00000037180,    -0.00000026385,
	   0.00000002419,    -0.00000002067,
	   0.00000004207,    -0.00000001816,
	  -0.00000000146,     0.00000000304,
	  -0.00000003519,     0.00000001230,
	  -0.00000000654,    -0.00000000276,
	   0.00000000023,    -0.00000000094,
	   0.00000001390,     0.00000001051,
	  -0.00000000284,     0.00000000653,
	  -0.00000000095,    -0.00000000024,
	  -0.00000167065,     0.00000094675,
	  -0.00000048934,    -0.00000019560,
	   0.00000001595,    -0.00000006918,
	  -0.00000003962,    -0.00000007798,
	   0.00000000883,    -0.00000002217,
	   0.00000000306,     0.00000000074,
	  -0.00000000323,     0.00000004844,
	  -0.00000000487,    -0.00000000327,
	  -0.00000004639,    -0.00000000048,
	   0.00000000296,    -0.00000000390,
	  -0.00000000367,     0.00000009669,
	  -0.00000003160,     0.00000001865,
	   0.00000003250,    -0.00000000026,
	   0.00000001159,    -0.00000008998,
	  -0.00000000050,     0.00000000090,
	   0.00000000100,     0.00000000041,
	   0.00000000141,     0.00000000005,
	   0.00000000005,    -0.00000000142,
	  -0.00000004866,    -0.00000015880,
	  -0.00000002253,     0.00000001577,
	   0.00000000031,    -0.00000000234,
	  -0.00000000623,     0.00000000032,
	   0.00000000031,     0.00000000623,
	   0.00000004240,     0.00000000035,
	  -0.00000206360,     0.00000014316,
	   0.00000000119,    -0.00000000385,
	   0.00000000254,    -0.00000000012,
	   0.00000000034,    -0.00000000268,
	  -0.00000316988,     0.00000180452,
	  -0.00000092873,    -0.00000037177,
	   0.00000003047,    -0.00000013077,
	  -0.00000005697,    -0.00000009986,
	   0.00000001173,    -0.00000002901,
	   0.00000000394,     0.00000000097,
	  -0.00000000463,     0.00000007001,
	  -0.00000000673,    -0.00000000466,
	  -0.00000006974,    -0.00000000542,
	   0.00000000488,    -0.00000000680,
	   0.00000000008,    -0.00000000003,
	   0.00000000019,     0.00000000013,
	  -0.00000000013,     0.00000000019,
	  -0.00000000071,    -0.00000000120,
	   0.00000000124,    -0.00000000063,
	   0.00000042563,     0.00000001500,
	  -0.00000000352,     0.00000020148,
	  -0.00000004993,    -0.00000000034,
	   0.00000000001,    -0.00000000844,
	  -0.00000000534,    -0.00000008794,
	   0.00000004338,    -0.00000000430,
	   0.00000000115,     0.00000001101,
	  -0.00000000191,     0.00000000023,
	   0.00000029942,     0.00000003108,
	  -0.00000002526,     0.00000011718,
	  -0.00000002318,    -0.00000000695,
	   0.00000000101,    -0.00000000304,
	  -0.00000005900,     0.00000030407,
	  -0.00000011755,    -0.00000004372,
	   0.00000001315,    -0.00000002250,
	   0.00000000270,     0.00000000233,
	  -0.00000001136,    -0.00000000174,
	   0.00000000058,    -0.00000000141,
	   0.00000000206,    -0.00000001120,
	   0.00000000134,     0.00000000068,
	  -0.00000100925,    -0.00000035319,
	   0.00000013267,    -0.00000046071,
	   0.00000011121,     0.00000002336,
	  -0.00000000248,     0.00000001844,
	   0.00000001973,     0.00000019494,
	  -0.00000009665,     0.00000001318,
	  -0.00000000355,    -0.00000002424,
	   0.00000000421,    -0.00000000049,
	  -0.00000019568,     0.00000008369,
	  -0.00000003290,    -0.00000008501,
	   0.00000001671,    -0.00000000909,
	   0.00000000208,     0.00000000241,
	   0.00000009809,    -0.00000030080,
	   0.00000012834,     0.00000007456,
	  -0.00000002399,     0.00000002449,
	  -0.00000000292,    -0.00000000484,
	   0.00000002881,     0.00000000285,
	  -0.00000000148,     0.00000000349,
	  -0.00000000306,     0.00000002887,
	  -0.00000000346,    -0.00000000143,
	   0.00000000019,     0.00000000217,
	   0.00000003130,     0.00000000106,
	  -0.00000000253,     0.00000001127,
	  -0.00000000216,    -0.00000000081,
	  -0.00000000107,     0.00000003133,
	  -0.00000001128,    -0.00000000255,
	   0.00000000081,    -0.00000000216,
	   0.00000003933,     0.00000000134,
	  -0.00000000320,     0.00000001414,
	  -0.00000000271,    -0.00000000101,
	  -0.00000000136,     0.00000003937,
	  -0.00000001415,    -0.00000000321,
	   0.00000000102,    -0.00000000271,
	   0.00000000210,     0.00000000140,
	  -0.00000000684,     0.00000001234,
	   0.00000000090,    -0.00000000173,
	  -0.00000000241,     0.00000003386,
	   0.00000000089,     0.00000000050,
	   0.00000000271,    -0.00000000169,
	  -0.00000000165,    -0.00000000272,
	   0.00000000053,     0.00000000078,
	   0.00000000102,    -0.00000000020,
	  -0.00000000015,    -0.00000000100,
	   0.00000007981,    -0.00000012751,
	  -0.00000001368,     0.00000001254,
	  -0.00000000383,    -0.00000000397,
	  -0.00000000992,     0.00000000276,
	   0.00000000022,     0.00000000098,
	   0.00000000265,     0.00000000986,
	   0.00000000101,    -0.00000000017,
	   0.00000002485,    -0.00000001133,
	  -0.00000000065,    -0.00000000307,
	  -0.00000000174,     0.00000000005,
	  -0.00000000019,     0.00000000147,
	  -0.00000046511,     0.00000035793,
	   0.00000003732,    -0.00000001365,
	   0.00000000392,     0.00000001417,
	   0.00000000146,    -0.00000000034,
	   0.00000001976,    -0.00000000236,
	   0.00000000068,    -0.00000000084,
	  -0.00000000161,    -0.00000001912,
	  -0.00000000080,    -0.00000000083,
	  -0.00000000076,     0.00000000028,
	   0.00000000349,     0.00000000917,
	   0.00000000169,    -0.00000000063,
	  -0.00000007704,     0.00000001818,
	  -0.00000000011,     0.00000000594,
	   0.00000000090,    -0.00000000051,
	   0.00000169181,    -0.00000064060,
	  -0.00000006140,     0.00000001237,
	   0.00000000004,    -0.00000002478,
	  -0.00000000132,    -0.00000000124,
	  -0.00000001721,     0.00000000477,
	   0.00000000293,     0.00000001403,
	  -0.00000000121,    -0.00000000478,
	  -0.00000000181,     0.00000000044,
	   0.00000000554,     0.00000002186,
	   0.00000000410,    -0.00000000106,
	   0.00000012465,    -0.00000000972,
	  -0.00000000073,    -0.00000000155,
	  -0.00000000158,    -0.00000000004,
	  -0.00000000007,    -0.00000000167,
	  -0.00000342242,     0.00000011013,
	  -0.00000001737,    -0.00000000711,
	   0.00000000625,     0.00000000342,
	   0.00000000527,    -0.00000000586,
	  -0.00000000262,     0.00000000417,
	  -0.00000009215,    -0.00000001509,
	   0.00000001521,    -0.00000001837,
	  -0.00000000587,     0.00000003474,
	  -0.00000000682,    -0.00000000584,
	   0.00000000113,    -0.00000000064,
	  -0.00000000064,     0.00000000075,
	   0.00000000041,     0.00000000157,
	   0.00000041709,     0.00000008522,
	  -0.00000007034,     0.00000008167,
	  -0.00000000796,    -0.00000001389,
	   0.00000001474,    -0.00000007833,
	   0.00000001549,     0.00000001325,
	  -0.00000000263,     0.00000000149,
	   0.00000000410,    -0.00000000291,
	   0.00000000036,     0.00000000184,
	  -0.00000000165,    -0.00000000414,
	   0.00000000181,    -0.00000000008,
	  -0.00000001854,    -0.00000026742,
	   0.00000002572,     0.00000002498,
	  -0.00000000578,    -0.00000000336,
	   0.00000000073,    -0.00000000081,
	  -0.00000000959,     0.00000000033,
	  -0.00000000077,    -0.00000000750,
	  -0.00000028892,    -0.00000003857,
	   0.00000004276,    -0.00000005922,
	  -0.00000000013,     0.00000000222,
	   0.00000001222,    -0.00000000044,
	  -0.00000000086,     0.00000000433,
	  -0.00000000082,    -0.00000000031,
	   0.00000000125,    -0.00000001132,
	   0.00000000415,     0.00000000106,
	  -0.00000000031,     0.00000000082,
	   0.00000085028,     0.00000003398,
	  -0.00000007040,     0.00000030496,
	  -0.00000005909,    -0.00000002212,
	  -0.00000000136,     0.00000004056,
	  -0.00000001456,    -0.00000000330,
	   0.00000000103,    -0.00000000276,
	  -0.00000000231,    -0.00000000043,
	   0.00000000031,    -0.00000000384,
	  -0.00000000385,     0.00000000794,
	   0.00000000122,     0.00000000053,
	  -0.00000000083,    -0.00000000133,
	  -0.00000000131,     0.00000000091,
	  -0.00000001324,    -0.00000004576,
	  -0.00000000099,     0.00000000018,
	   0.00000000017,     0.00000000099,
	   0.00000001141,    -0.00000000077,
	  -0.00000060746,     0.00000000620,
	   0.00000000660,    -0.00000006504,
	  -0.00000000060,    -0.00000000060,
	   0.00000161862,     0.00000006381,
	  -0.00000013366,     0.00000058054,
	  -0.00000011110,    -0.00000004189,
	  -0.00000000171,     0.00000005151,
	  -0.00000001853,    -0.00000000418,
	   0.00000000133,    -0.00000000354,
	  -0.00000000425,    -0.00000000069,
	   0.00000000040,    -0.00000000403,
	   0.00000000006,    -0.00000000003,
	   0.00000000003,     0.00000000006,
	  -0.00000002252,    -0.00000008972,
	   0.00000005910,    -0.00000000545,
	  -0.00000000108,     0.00000001975,
	  -0.00000000437,    -0.00000000089,
	  -0.00000002934,     0.00000000764,
	  -0.00000000200,    -0.00000001926,
	   0.00000000645,     0.00000000022,
	   0.00000000586,    -0.00000000388,
	   0.00000000051,     0.00000000506,
	  -0.00000000203,    -0.00000000048,
	   0.00000000699,    -0.00000000701,
	   0.00000000471,     0.00000000439,
	  -0.00000000163,     0.00000000169,
	   0.00000000253,    -0.00000000278,
	   0.00000000056,     0.00000000079,
	   0.00000000273,     0.00000000262,
	  -0.00000000083,     0.00000000053,
	   0.00000105159,     0.00000115891,
	  -0.00000062466,     0.00000048278,
	  -0.00000011088,    -0.00000017683,
	   0.00000003429,    -0.00000001598,
	   0.00000000853,     0.00000006090,
	  -0.00000003309,     0.00000001847,
	  -0.00000000908,    -0.00000001029,
	   0.00000000232,    -0.00000000246,
	  -0.00000004308,    -0.00000000943,
	   0.00000001083,    -0.00000002784,
	   0.00000000967,     0.00000000515,
	  -0.00000000166,     0.00000000234,
	  -0.00000000917,     0.00000001078,
	  -0.00000001354,    -0.00000000904,
	   0.00000000486,    -0.00000000616,
	   0.00000000167,     0.00000000157,
	  -0.00000000569,     0.00000000703,
	  -0.00000000149,    -0.00000000184,
	  -0.00000000703,    -0.00000000675,
	   0.00000000227,    -0.00000000142,
	  -0.00000000075,    -0.00000000102,
	   0.00000000099,    -0.00000000077,
	  -0.00000000095,    -0.00000000126,
	   0.00000000126,    -0.00000000095,
	  -0.00000000090,     0.00000000102,
	   0.00000000102,     0.00000000090,
	  -0.00000004982,     0.00000005640,
	  -0.00000000170,    -0.00000000150,
	  -0.00000000423,     0.00000001919,
	   0.00000000175,    -0.00000000121,
	  -0.00000000117,    -0.00000000175,
	   0.00000005093,    -0.00000007180,
	  -0.00000000178,    -0.00000000238,
	  -0.00000000557,     0.00000000148,
	   0.00000000129,     0.00000000551,
	   0.00000001559,    -0.00000000680,
	  -0.00000000045,    -0.00000000179,
	  -0.00000000094,     0.00000000008,
	  -0.00000025638,     0.00000018796,
	   0.00000001888,    -0.00000000450,
	   0.00000000201,     0.00000000789,
	   0.00000000083,    -0.00000000020,
	   0.00000001011,    -0.00000000127,
	  -0.00000000063,    -0.00000000959,
	  -0.00000003815,     0.00000000858,
	   0.00000000003,     0.00000000295,
	   0.00000081346,    -0.00000030385,
	  -0.00000002557,     0.00000000424,
	   0.00000000045,    -0.00000001169,
	  -0.00000000066,    -0.00000000070,
	  -0.00000000667,     0.00000000235,
	   0.00000000103,     0.00000000439,
	   0.00000005147,    -0.00000000723,
	  -0.00000000060,     0.00000000064,
	  -0.00000000006,    -0.00000000096,
	  -0.00000138798,     0.00000007110,
	   0.00000000253,    -0.00000000060,
	   0.00000000168,    -0.00000000056,
	   0.00000000054,     0.00000000424,
	   0.00000000433,     0.00000000829,
	  -0.00000008289,    -0.00000014881,
	   0.00000001717,     0.00000000636,
	  -0.00000000390,     0.00000000092,
	   0.00000000015,    -0.00000000416,
	  -0.00000000757,     0.00000000149,
	   0.00000000084,     0.00000000204,
	  -0.00000000287,    -0.00000000157,
	   0.00000000101,    -0.00000000036,
	  -0.00000000043,    -0.00000000334,
	   0.00000003052,    -0.00000000823,
	  -0.00000000115,     0.00000001215,
	  -0.00000000199,    -0.00000000481,
	   0.00000000196,    -0.00000000007,
	   0.00000000172,     0.00000000447,
	  -0.00000000252,    -0.00000000067,
	   0.00000000353,     0.00000000466,
	  -0.00000000202,     0.00000000145,
	   0.00000000104,    -0.00000000030,
	  -0.00000002055,    -0.00000002527,
	   0.00000000965,    -0.00000001017,
	   0.00000000147,    -0.00000000100,
	   0.00000000046,     0.00000000060,
	   0.00000000080,    -0.00000000053,
	  -0.00000000742,    -0.00000001095,
	  -0.00000000181,     0.00000000121,
	  -0.00000016367,     0.00000000160,
	   0.00000000205,    -0.00000003218,
	  -0.00000003870,    -0.00000005298,
	   0.00000002140,    -0.00000001860,
	   0.00000000166,    -0.00000000125,
	   0.00000000061,     0.00000000066,
	   0.00000000047,     0.00000000250,
	   0.00000000250,    -0.00000000047,
	   0.00000001724,     0.00000008122,
	  -0.00000000114,     0.00000000034,
	  -0.00000000756,    -0.00000002264,
	  -0.00000000105,     0.00000000061,
	  -0.00000002261,     0.00000000755,
	   0.00000000061,     0.00000000105,
	  -0.00000026082,    -0.00000078063,
	  -0.00000003550,     0.00000002034,
	   0.00000003319,    -0.00000001108,
	  -0.00000000086,    -0.00000000151,
	  -0.00000000093,     0.00000000041,
	   0.00000000054,     0.00000000193,
	  -0.00000000072,     0.00000000018,
	   0.00000000002,     0.00000000639,
	  -0.00000000223,    -0.00000000006,
	  -0.00000000640,    -0.00000000002,
	   0.00000000007,    -0.00000000224,
	   0.00000000020,     0.00000000024,
	  -0.00000000008,     0.00000000006,
	  -0.00000000029,     0.00000000029,
	  -0.00000000007,    -0.00000000010,
	  -0.00000000069,     0.00000000006,
	  -0.00000000006,    -0.00000000069,
	  -0.00000000188,     0.00000000168,
	  -0.00000000059,    -0.00000000076,
	  -0.00000000168,    -0.00000000188,
	   0.00000000076,    -0.00000000059,
	  -0.00000000046,    -0.00000000256,
	   0.00000000115,    -0.00000000021,
	   0.00000001858,     0.00000000437,
	  -0.00000000198,     0.00000000694,
	  -0.00000000438,     0.00000001859,
	  -0.00000000694,    -0.00000000198,
	   0.00000000032,     0.00000000044,
	  -0.00000000044,     0.00000000030,
	   0.00000004697,     0.00000001041,
	  -0.00000001352,     0.00000003585,
	  -0.00000001365,    -0.00000000736,
	   0.00000000244,    -0.00000000341,
	   0.00000000363,    -0.00000001427,
	   0.00000001082,     0.00000000444,
	  -0.00000000235,     0.00000000409,
	  -0.00000000043,    -0.00000000290,
	   0.00000000200,     0.00000000019,
	   0.00000000271,    -0.00000000176,
	   0.00000000102,     0.00000000190,
	  -0.00000021582,    -0.00000004809,
	   0.00000006234,    -0.00000016516,
	   0.00000006294,     0.00000003398,
	  -0.00000001134,     0.00000001575,
	  -0.00000000544,     0.00000003524,
	  -0.00000002640,    -0.00000000862,
	   0.00000000496,    -0.00000000995,
	   0.00000000246,     0.00000000169,
	   0.00000003373,     0.00000003091,
	  -0.00000001501,     0.00000001508,
	  -0.00000000325,    -0.00000000378,
	  -0.00000003015,     0.00000003903,
	  -0.00000001991,    -0.00000001462,
	   0.00000000373,    -0.00000000549,
	  -0.00000000223,     0.00000000374,
	  -0.00000000184,    -0.00000000105,
	   0.00000004959,     0.00000003850,
	  -0.00000001737,     0.00000002389,
	  -0.00000000609,    -0.00000000403,
	   0.00000000062,    -0.00000000107,
	  -0.00000003851,     0.00000004960,
	  -0.00000002389,    -0.00000001738,
	   0.00000000403,    -0.00000000609,
	   0.00000000107,     0.00000000062,
	   0.00000000106,    -0.00000000008,
	   0.00000006202,     0.00000004815,
	  -0.00000002173,     0.00000002988,
	  -0.00000000762,    -0.00000000504,
	   0.00000000078,    -0.00000000134,
	  -0.00000004818,     0.00000006203,
	  -0.00000002989,    -0.00000002174,
	   0.00000000504,    -0.00000000763,
	   0.00000000135,     0.00000000078,
	  -0.00000000118,     0.00000000027,
	   0.00000000081,    -0.00000000021,
	   0.00000024425,    -0.00000003943,
	  -0.00000000034,    -0.00000000208,
	  -0.00000190606,     0.00000030904,
	  -0.00000000086,    -0.00000000189,
	  -0.00000000093,     0.00000000017,
	   0.00000000110,    -0.00000000082,
	  -0.00000000078,    -0.00000000110,
	   0.00000003201,    -0.00000004422,
	  -0.00000000117,    -0.00000000148,
	  -0.00000000321,     0.00000000099,
	   0.00000000084,     0.00000000316,
	   0.00000000913,    -0.00000000425,
	  -0.00000000029,    -0.00000000102,
	  -0.00000014297,     0.00000010590,
	   0.00000000134,     0.00000000453,
	   0.00000000458,    -0.00000000055,
	  -0.00000000014,    -0.00000000419,
	  -0.00000002016,     0.00000000555,
	   0.00000000006,     0.00000000147,
	   0.00000039846,    -0.00000015778,
	  -0.00000000005,    -0.00000000556,
	  -0.00000000218,     0.00000000211,
	   0.00000000084,     0.00000000039,
	   0.00000002161,    -0.00000000480,
	  -0.00000057124,     0.00000006521,
	   0.00000000231,    -0.00000000164,
	  -0.00000000235,    -0.00000000256,
	   0.00000000068,    -0.00000000105,
	  -0.00000000151,     0.00000000557,
	  -0.00000000106,    -0.00000000071,
	  -0.00000012507,    -0.00000013542,
	   0.00000002590,    -0.00000002022,
	  -0.00000000262,     0.00000000467,
	  -0.00000000138,    -0.00000000090,
	   0.00000001085,     0.00000000471,
	  -0.00000000207,     0.00000000443,
	  -0.00000000080,    -0.00000000048,
	   0.00000000396,    -0.00000001434,
	   0.00000000437,     0.00000000200,
	  -0.00000000048,     0.00000000079,
	  -0.00000000509,    -0.00000000177,
	  -0.00000000061,     0.00000000169,
	   0.00000029927,     0.00000009714,
	  -0.00000004761,     0.00000010393,
	  -0.00000001848,    -0.00000001117,
	   0.00000000650,    -0.00000001823,
	   0.00000000633,     0.00000000295,
	  -0.00000000068,     0.00000000113,
	  -0.00000002826,    -0.00000000390,
	   0.00000000302,    -0.00000001090,
	   0.00000000214,     0.00000000092,
	  -0.00000000310,     0.00000002713,
	  -0.00000001059,    -0.00000000280,
	   0.00000000088,    -0.00000000209,
	   0.00000001620,    -0.00000000567,
	   0.00000000207,     0.00000000773,
	  -0.00000000186,    -0.00000000501,
	   0.00000000239,    -0.00000000071,
	   0.00000000084,     0.00000000102,
	   0.00000000069,    -0.00000000101,
	   0.00000000056,     0.00000000072,
	  -0.00000001766,     0.00000003564,
	  -0.00000001773,    -0.00000001367,
	   0.00000000644,     0.00000000055,
	  -0.00000000138,     0.00000000308,
	  -0.00000000372,    -0.00000000395,
	   0.00000000306,    -0.00000000193,
	  -0.00000000366,     0.00000000439,
	  -0.00000000220,    -0.00000000306,
	  -0.00000063199,    -0.00000008395,
	   0.00000006776,    -0.00000024503,
	   0.00000004814,     0.00000002070,
	  -0.00000000613,     0.00000004572,
	  -0.00000001775,    -0.00000000494,
	   0.00000000149,    -0.00000000347,
	  -0.00000000459,    -0.00000000206,
	   0.00000000107,    -0.00000000213,
	  -0.00000000357,     0.00000000869,
	  -0.00000000355,    -0.00000000174,
	   0.00000000043,    -0.00000000076,
	   0.00000000027,    -0.00000000080,
	   0.00000000198,     0.00000000029,
	  -0.00000000028,     0.00000000195,
	  -0.00000003506,    -0.00000003962,
	   0.00000001822,    -0.00000001686,
	  -0.00000000104,     0.00000000562,
	  -0.00000000231,    -0.00000000064,
	   0.00000001282,     0.00000001325,
	  -0.00000000574,     0.00000000665,
	  -0.00000000182,    -0.00000000129,
	   0.00000001461,    -0.00000002278,
	   0.00000001052,     0.00000000682,
	  -0.00000000162,     0.00000000258,
	   0.00000132874,     0.00000103330,
	  -0.00000046618,     0.00000064014,
	  -0.00000016333,    -0.00000010804,
	   0.00000001676,    -0.00000002881,
	  -0.00000005006,     0.00000006444,
	  -0.00000003105,    -0.00000002259,
	   0.00000000524,    -0.00000000793,
	   0.00000000140,     0.00000000082,
	   0.00000000182,     0.00000000083,
	  -0.00000000040,     0.00000000085,
	   0.00000000074,    -0.00000000080,
	  -0.00000004560,     0.00000000057,
	  -0.00000000348,    -0.00000000050,
	   0.00000000038,    -0.00000000135,
	  -0.00000000048,     0.00000000348,
	  -0.00000000135,    -0.00000000038,
	  -0.00000011531,    -0.00000001918,
	   0.00000001410,    -0.00000004450,
	  -0.00000000080,     0.00000000552,
	  -0.00000000214,    -0.00000000061,
	   0.00000255364,     0.00000198392,
	  -0.00000089518,     0.00000123025,
	  -0.00000031390,    -0.00000020745,
	   0.00000003220,    -0.00000005539,
	  -0.00000006346,     0.00000008165,
	  -0.00000003933,    -0.00000002863,
	   0.00000000663,    -0.00000001004,
	   0.00000000177,     0.00000000103,
	   0.00000000213,     0.00000000050,
	  -0.00000000024,     0.00000000090,
	  -0.00000000121,     0.00000000217,
	  -0.00000000094,    -0.00000000058,
	   0.00000000485,     0.00000000036,
	   0.00000000001,    -0.00000000112,
	   0.00000000199,     0.00000000033,
	  -0.00000000044,     0.00000000153,
	  -0.00000000056,     0.00000000196,
	  -0.00000000147,    -0.00000000068,
	  -0.00000001656,    -0.00000000234,
	   0.00000000283,    -0.00000001412,
	  -0.00000000001,     0.00000000262,
	  -0.00000000232,    -0.00000000012,
	  -0.00000000232,    -0.00000000005,
	   0.00000000018,    -0.00000000188,
	   0.00000000106,    -0.00000000222,
	   0.00000000164,     0.00000000123,
	  -0.00000000050,     0.00000000126,
	  -0.00000000052,     0.00000000121,
	   0.00000000020,    -0.00000000136,
	  -0.00000000112,     0.00000000003,
	  -0.00000000003,    -0.00000000107,
	  -0.00000000038,     0.00000000255,
	  -0.00000000258,     0.00000000004,
	  -0.00000000001,    -0.00000000249,
	  -0.00000000007,     0.00000000215,
	  -0.00000000122,    -0.00000000002,
	  -0.00000001252,     0.00000001072,
	  -0.00000000010,    -0.00000000261,
	  -0.00000000214,     0.00000000051,
	   0.00000000024,     0.00000000215,
	   0.00000003019,    -0.00000000041,
	  -0.00000000109,     0.00000000002,
	  -0.00000000001,    -0.00000000109,
	   0.00000000067,    -0.00000000053,
	   0.00000001174,    -0.00000001681,
	  -0.00000000100,     0.00000000039,
	   0.00000000032,     0.00000000097,
	  -0.00000002352,     0.00000001914,
	   0.00000002328,    -0.00000001221,
	   0.00000000030,    -0.00000000114,
	   0.00000000080,     0.00000000126,
	   0.00000005058,    -0.00000000105,
	  -0.00000003651,     0.00000000068,
	   0.00000002287,     0.00000000341,
	   0.00000001953,    -0.00000002741,
	  -0.00000000075,    -0.00000000090,
	  -0.00000000181,     0.00000000064,
	   0.00000000053,     0.00000000177,
	  -0.00000004353,     0.00000003392,
	   0.00000000049,     0.00000000137,
	   0.00000000118,    -0.00000000028,
	   0.00000004791,    -0.00000002284,
	  -0.00000001998,     0.00000000772,
	  -0.00000000066,     0.00000000119,
	  -0.00000000016,     0.00000000143,
	  -0.00000002347,    -0.00000000161,
	   0.00000008626,    -0.00000000146,
	  -0.00000000002,    -0.00000000132,
	  -0.00000006120,     0.00000000084,
	   0.00000003639,     0.00000000539,
	  -0.00000003327,    -0.00000000450,
	  -0.00000007903,     0.00000006001,
	   0.00000000082,     0.00000000251,
	   0.00000000233,    -0.00000000041,
	  -0.00000000013,    -0.00000000208,
	   0.00000009770,    -0.00000004284,
	  -0.00000000019,    -0.00000000148,
	  -0.00000004672,     0.00000001333,
	  -0.00000003733,    -0.00000000264,
	   0.00000014801,    -0.00000000196,
	  -0.00000000003,    -0.00000000205,
	  -0.00000010268,     0.00000000105,
	   0.00000000001,     0.00000000099,
	   0.00000005809,     0.00000000842,
	   0.00000000127,     0.00000000002,
	  -0.00000005210,    -0.00000000691,
	  -0.00000000014,     0.00000000110,
	   0.00000000024,    -0.00000000100,
	   0.00000000126,     0.00000000017,
	  -0.00000000095,    -0.00000000011,
	   0.00000000011,    -0.00000000095,
	   0.00000000248,     0.00000000011,
	   0.00000000017,    -0.00000000252,
	  -0.00000001017,     0.00000000314,
	   0.00000019620,    -0.00000008205,
	  -0.00000000022,    -0.00000000306,
	  -0.00000000080,     0.00000000093,
	  -0.00000010845,     0.00000002225,
	  -0.00000000882,    -0.00000001549,
	  -0.00000000092,     0.00000000032,
	  -0.00000005972,    -0.00000000396,
	   0.00000025704,    -0.00000000274,
	  -0.00000000003,    -0.00000000343,
	  -0.00000017369,     0.00000000132,
	   0.00000000001,     0.00000000169,
	   0.00000009136,     0.00000001234,
	   0.00000000015,    -0.00000000158,
	   0.00000000254,     0.00000000016,
	   0.00000000016,     0.00000000146,
	  -0.00000008196,    -0.00000001059,
	  -0.00000000019,     0.00000000159,
	  -0.00000000158,     0.00000000000,
	   0.00000000000,    -0.00000000157,
	   0.00000002003,     0.00000000488,
	   0.00000000027,    -0.00000000122,
	   0.00000000184,     0.00000000026,
	  -0.00000000012,     0.00000000140,
	  -0.00000000132,    -0.00000000015,
	   0.00000000015,    -0.00000000131,
	   0.00000000470,    -0.00000007101,
	  -0.00000000880,    -0.00000000240,
	  -0.00000000930,    -0.00000000130,
	  -0.00000000130,     0.00000000930,
	   0.00000000824,     0.00000000328,
	   0.00000001761,    -0.00000004425,
	  -0.00000079280,    -0.00000004775,
	  -0.00000004551,     0.00000013288,
	  -0.00000004156,     0.00000075565,
	   0.00000012435,     0.00000004259,
	   0.00000026146,     0.00000000176,
	   0.00000000659,    -0.00000003031,
	   0.00000000146,    -0.00000026024,
	  -0.00000003009,    -0.00000000673,
	   0.00000000900,    -0.00000000290,
	  -0.00000024477,     0.00000003811,
	   0.00000000099,    -0.00000000101,
	  -0.00000000004,     0.00000000197,
	  -0.00000001550,    -0.00000002923,
	   0.00000000034,     0.00000000095,
	  -0.00000000278,    -0.00000000159,
	  -0.00000000159,     0.00000000282,
	  -0.00000009469,    -0.00000000706,
	   0.00000000177,    -0.00000000040,
	  -0.00000000043,    -0.00000000163,
	   0.00000002998,     0.00000000312,
	   0.00000000011,    -0.00000000155,
	   0.00000043963,    -0.00000001144,
	  -0.00000000005,    -0.00000000643,
	   0.00000000395,     0.00000000100,
	   0.00000000101,    -0.00000000557,
	  -0.00000029570,     0.00000000136,
	   0.00000000000,     0.00000000297,
	   0.00000014967,     0.00000001925,
	   0.00000000023,    -0.00000000236,
	   0.00000000483,     0.00000000034,
	   0.00000000032,     0.00000000215,
	  -0.00000013063,    -0.00000001628,
	  -0.00000000012,     0.00000000126,
	  -0.00000000273,     0.00000000000,
	   0.00000000000,    -0.00000000271,
	   0.00000005174,     0.00000001339,
	   0.00000000030,    -0.00000000139,
	  -0.00000000058,     0.00000000355,
	  -0.00000003351,    -0.00000000763,
	  -0.00000000187,    -0.00000000020,
	   0.00000000020,    -0.00000000186,
	  -0.00000000009,     0.00000000478,
	   0.00000000645,     0.00000000075,
	   0.00000000076,    -0.00000000650,
	   0.00000000011,    -0.00000000111,
	   0.00000048910,    -0.00000002219,
	   0.00000001711,    -0.00000005809,
	   0.00000000010,    -0.00000005806,
	  -0.00000000734,    -0.00000000135,
	  -0.00000014500,     0.00000001899,
	  -0.00000000366,     0.00000001508,
	   0.00000000106,     0.00000000051,
	   0.00000001885,     0.00000014509,
	   0.00000001526,     0.00000000373,
	   0.00000000051,    -0.00000000106,
	   0.00000000053,     0.00000000083,
	   0.00000000083,    -0.00000000053,
	  -0.00000003886,    -0.00000005698,
	  -0.00000000035,     0.00000000096,
	   0.00000002450,     0.00000001556,
	   0.00000000047,     0.00000000077,
	  -0.00000000683,    -0.00000000199,
	  -0.00000000197,     0.00000000682,
	  -0.00000030465,    -0.00000006786,
	  -0.00000000067,    -0.00000000252,
	   0.00000004140,     0.00000000579,
	   0.00000000572,    -0.00000004136,
	   0.00000003719,     0.00000000501,
	   0.00000000014,    -0.00000000152,
	   0.00000080837,    -0.00000001906,
	  -0.00000000008,    -0.00000001104,
	   0.00000000963,     0.00000000155,
	   0.00000000156,    -0.00000001147,
	  -0.00000050816,     0.00000000156,
	   0.00000000000,     0.00000000525,
	   0.00000043699,     0.00000007399,
	   0.00000000023,    -0.00000000255,
	  -0.00000000787,    -0.00000000252,
	  -0.00000000250,     0.00000002027,
	  -0.00000021132,    -0.00000002533,
	  -0.00000000019,     0.00000000205,
	  -0.00000000481,    -0.00000000002,
	   0.00000000000,    -0.00000000473,
	   0.00000010588,     0.00000002361,
	   0.00000000028,    -0.00000000148,
	   0.00000000126,    -0.00000000004,
	  -0.00000000055,     0.00000000350,
	  -0.00000005342,    -0.00000001143,
	  -0.00000000020,     0.00000000111,
	  -0.00000000274,    -0.00000000028,
	   0.00000000027,    -0.00000000270,
	  -0.00000006678,    -0.00000001699,
	   0.00000000034,    -0.00000000130,
	  -0.00000000104,    -0.00000000043,
	  -0.00000000073,     0.00000000265,
	   0.00000001037,    -0.00000000055,
	  -0.00000000062,    -0.00000001455,
	  -0.00000000146,    -0.00000000035,
	  -0.00000002846,    -0.00000000259,
	  -0.00000000037,     0.00000000199,
	  -0.00000000264,     0.00000002842,
	   0.00000000208,     0.00000000039,
	   0.00000000044,    -0.00000000103,
	  -0.00000000087,     0.00000000164,
	   0.00000000185,     0.00000000097,
	  -0.00000138541,     0.00000050442,
	  -0.00000004313,     0.00000015347,
	   0.00000001024,     0.00000001030,
	   0.00000001186,     0.00000017274,
	   0.00000001790,     0.00000000406,
	   0.00000000065,    -0.00000000125,
	   0.00000026364,    -0.00000020176,
	   0.00000001185,    -0.00000003181,
	  -0.00000000258,    -0.00000000240,
	  -0.00000020146,    -0.00000026139,
	  -0.00000003141,    -0.00000001178,
	  -0.00000000240,     0.00000000255,
	  -0.00000000189,    -0.00000000289,
	  -0.00000000284,     0.00000000185,
	  -0.00000000143,    -0.00000000096,
	  -0.00000000096,     0.00000000141,
	  -0.00000052344,    -0.00000008321,
	  -0.00000000090,    -0.00000000201,
	   0.00000007017,     0.00000000292,
	   0.00000000282,    -0.00000007002,
	   0.00000004131,     0.00000000843,
	   0.00000000019,    -0.00000000139,
	   0.00000000928,     0.00000000059,
	   0.00000000050,     0.00000000067,
	  -0.00000000117,    -0.00000000032,
	  -0.00000000021,     0.00000000121,
	   0.00000326597,     0.00000025121,
	   0.00000000009,    -0.00000000922,
	  -0.00000016355,    -0.00000001183,
	  -0.00000000046,    -0.00000000270,
	  -0.00000001157,     0.00000016097,
	  -0.00000000276,     0.00000000046,
	  -0.00000088723,     0.00000000175,
	   0.00000000000,     0.00000000934,
	   0.00000083652,     0.00000011129,
	   0.00000000007,    -0.00000000269,
	   0.00000000123,    -0.00000000193,
	  -0.00000000189,     0.00000002139,
	  -0.00000035424,    -0.00000003999,
	  -0.00000000030,     0.00000000346,
	  -0.00000000860,    -0.00000000004,
	  -0.00000000001,    -0.00000000833,
	  -0.00000075188,    -0.00000013212,
	   0.00000000584,    -0.00000002320,
	   0.00000000214,    -0.00000001187,
	  -0.00000002474,    -0.00000000704,
	   0.00000000057,    -0.00000000118,
	  -0.00000000812,     0.00000003418,
	  -0.00000000133,    -0.00000000058,
	  -0.00000009393,    -0.00000001858,
	  -0.00000000027,     0.00000000161,
	  -0.00000000321,    -0.00000000033,
	   0.00000000026,    -0.00000000302,
	  -0.00000003904,    -0.00000000914,
	   0.00000000047,    -0.00000000199,
	   0.00000000138,     0.00000000024,
	  -0.00000000027,     0.00000000153,
	  -0.00000002531,    -0.00000000714,
	   0.00000000027,    -0.00000000136,
	  -0.00000007782,    -0.00000002377,
	   0.00000000093,    -0.00000000300,
	  -0.00000006143,     0.00000000571,
	  -0.00000000130,     0.00000000496,
	   0.00000000633,     0.00000006592,
	   0.00000000535,     0.00000000138,
	   0.00000014930,     0.00000000943,
	   0.00000000104,    -0.00000000704,
	   0.00000000964,    -0.00000014907,
	  -0.00000000701,    -0.00000000105,
	  -0.00000000066,    -0.00000000091,
	  -0.00000000083,     0.00000000060,
	  -0.00000001290,    -0.00000000657,
	   0.00000000063,     0.00000000302,
	   0.00000000593,    -0.00000000364,
	  -0.00000000059,     0.00000000069,
	  -0.00000000370,    -0.00000000627,
	  -0.00000325666,    -0.00000617591,
	   0.00000019772,    -0.00000011360,
	  -0.00000003284,    -0.00000004488,
	  -0.00000009873,    -0.00000074278,
	  -0.00000006250,    -0.00000001457,
	  -0.00000000246,     0.00000000378,
	   0.00000335148,     0.00000184777,
	  -0.00000007464,    -0.00000004084,
	   0.00000000616,     0.00000001056,
	   0.00000000055,    -0.00000000048,
	   0.00000184483,    -0.00000336027,
	  -0.00000004186,     0.00000007445,
	   0.00000001050,    -0.00000000609,
	  -0.00000000051,    -0.00000000057,
	   0.00000000748,     0.00000001031,
	   0.00000001006,    -0.00000000730,
	  -0.00000008189,    -0.00000002897,
	  -0.00000000034,    -0.00000000156,
	   0.00000002591,     0.00000000421,
	   0.00000000419,    -0.00000002589,
	   0.00000561117,     0.00000009245,
	  -0.00000000038,    -0.00000001318,
	  -0.00000009835,    -0.00000000848,
	   0.00000000032,    -0.00000000154,
	  -0.00000000816,     0.00000009499,
	  -0.00000000160,    -0.00000000032,
	  -0.00000160205,     0.00000000293,
	   0.00000000000,     0.00000001725,
	  -0.00000000005,     0.00000000144,
	  -0.00000000140,    -0.00000000032,
	  -0.00000000029,     0.00000000136,
	  -0.00000899697,    -0.00000074015,
	  -0.00000000233,    -0.00000014892,
	   0.00000001119,    -0.00000012233,
	   0.00000000240,     0.00000000029,
	  -0.00000057403,    -0.00000013030,
	   0.00000000642,    -0.00000001765,
	  -0.00000013203,     0.00000062793,
	  -0.00000001767,    -0.00000000648,
	  -0.00000064702,    -0.00000006712,
	  -0.00000000045,     0.00000000588,
	  -0.00000001625,    -0.00000000024,
	  -0.00000000018,    -0.00000001489,
	  -0.00000033489,    -0.00000005615,
	   0.00000000236,    -0.00000001449,
	   0.00000000883,     0.00000000085,
	  -0.00000000100,     0.00000000999,
	  -0.00000020166,    -0.00000004146,
	  -0.00000000033,     0.00000000236,
	  -0.00000000154,     0.00000000040,
	   0.00000000133,    -0.00000000966,
	  -0.00000122047,    -0.00000029551,
	   0.00000002354,    -0.00000005258,
	   0.00000001213,    -0.00000004969,
	   0.00000000206,     0.00000000094,
	  -0.00000000516,    -0.00000000090,
	   0.00000000066,    -0.00000000303,
	   0.00000023680,     0.00000005165,
	  -0.00000000081,     0.00000000369,
	   0.00000000089,    -0.00000000409,
	   0.00000013575,     0.00000003856,
	  -0.00000000102,     0.00000000353,
	   0.00000035012,    -0.00000007234,
	   0.00000000611,    -0.00000001902,
	  -0.00000006915,    -0.00000031081,
	  -0.00000001639,    -0.00000000513,
	  -0.00000000066,     0.00000000101,
	  -0.00000075256,    -0.00000002622,
	  -0.00000000192,     0.00000001760,
	  -0.00000002508,     0.00000075220,
	   0.00000001745,     0.00000000191,
	   0.00000000187,     0.00000000236,
	   0.00000000198,    -0.00000000145,
	  -0.00000021916,    -0.00000196369,
	  -0.00000017099,     0.00000023620,
	   0.00000002445,     0.00000000088,
	   0.00000017986,    -0.00000004547,
	  -0.00000002571,    -0.00000001343,
	   0.00000000015,     0.00000000271,
	  -0.00000010268,     0.00000005573,
	   0.00000000975,    -0.00000000375,
	   0.00000004988,     0.00000009851,
	  -0.00000000340,    -0.00000000704,
	   0.00019067135,     0.00006490653,
	  -0.00000188050,    -0.00000518837,
	   0.00000007908,     0.00000028874,
	   0.00000001364,    -0.00000001256,
	   0.00000047772,     0.00000385739,
	   0.00000023722,     0.00000006963,
	   0.00000000798,    -0.00000001237,
	  -0.00000000057,    -0.00000000047,
	  -0.00008161648,    -0.00001250408,
	   0.00000051966,     0.00000112911,
	  -0.00000001551,    -0.00000004745,
	  -0.00000000166,     0.00000000162,
	  -0.00001247361,     0.00008163282,
	   0.00000113234,    -0.00000051859,
	  -0.00000004711,     0.00000001521,
	   0.00000000160,     0.00000000167,
	  -0.00000002466,    -0.00000002518,
	  -0.00000000096,     0.00000000037,
	  -0.00000002367,     0.00000002353,
	   0.00000000028,     0.00000000080,
	   0.00000006047,     0.00000000090,
	  -0.00000000126,    -0.00000000015,
	  -0.00000000015,     0.00000000127,
	  -0.00000019322,    -0.00000002567,
	  -0.00000000018,     0.00000000175,
	  -0.00000020545,    -0.00000002728,
	  -0.00000000019,     0.00000000188,
	   0.00000000000,    -0.00000000005,
	   0.00000000005,     0.00000000000,
	   0.00000000838,     0.00000000750,
	  -0.00000000608,     0.00000000429,
	   0.00000000231,    -0.00000000250,
	   0.00000000126,     0.00000000187,
	  -0.00000003852,    -0.00000003454,
	   0.00000002808,    -0.00000001970,
	   0.00000000396,     0.00000000933,
	  -0.00000000536,     0.00000000576,
	  -0.00000000294,    -0.00000000430,
	   0.00000000142,    -0.00000000060,
	  -0.00000000094,     0.00000000015,
	  -0.00000001868,    -0.00000001625,
	   0.00000000052,    -0.00000000060,
	  -0.00000000034,     0.00000000077,
	  -0.00000000064,    -0.00000000037,
	   0.00000000063,    -0.00000000048,
	   0.00000000406,     0.00000000088,
	   0.00000000088,    -0.00000000404,
	   0.00000108447,     0.00000014222,
	  -0.00000000598,    -0.00000001631,
	   0.00000000018,     0.00000000824,
	  -0.00000019861,    -0.00000000123,
	  -0.00000000112,     0.00000019841,
	  -0.00000002667,     0.00000002489,
	   0.00000000015,     0.00000000098,
	  -0.00000000356,     0.00000000006,
	   0.00000000009,     0.00000000303,
	  -0.00000298337,    -0.00000022981,
	   0.00000000981,    -0.00000004705,
	   0.00000000870,    -0.00000012114,
	   0.00000000231,     0.00000000046,
	   0.00000005035,     0.00000000039,
	  -0.00000000041,     0.00000005974,
	  -0.00000143702,    -0.00000018363,
	  -0.00000000043,     0.00000000974,
	   0.00000001033,     0.00000000543,
	  -0.00000000037,     0.00000000126,
	   0.00000000554,    -0.00000007184,
	   0.00000000126,     0.00000000038,
	  -0.00002341903,    -0.00000439715,
	   0.00000024613,    -0.00000069329,
	   0.00000018310,    -0.00000096757,
	   0.00000002799,     0.00000001002,
	  -0.00000007828,    -0.00000000686,
	   0.00000000037,    -0.00000000187,
	   0.00000000411,    -0.00000003664,
	   0.00000000134,    -0.00000000122,
	  -0.00000000098,    -0.00000000102,
	   0.00000254397,     0.00000035998,
	  -0.00000002347,     0.00000007742,
	  -0.00000000485,     0.00000003387,
	  -0.00000000110,    -0.00000000034,
	   0.00000002297,     0.00000000589,
	  -0.00000000060,     0.00000000136,
	   0.00000000782,    -0.00000004702,
	   0.00000000178,     0.00000000069,
	   0.00000000151,     0.00000000009,
	  -0.00000000009,     0.00000000152,
	   0.00000201260,     0.00000042749,
	  -0.00000003736,     0.00000008809,
	  -0.00000001199,     0.00000005589,
	  -0.00000000237,    -0.00000000101,
	   0.00000000637,     0.00000000097,
	  -0.00000000132,     0.00000000661,
	  -0.00000000174,    -0.00000000022,
	   0.00000000023,    -0.00000000174,
	   0.00000000159,     0.00000000021,
	  -0.00000000021,     0.00000000159,
	  -0.00000000001,    -0.00000000008,
	  -0.00000000005,    -0.00000000075,
	  -0.00000157388,     0.00000032700,
	  -0.00000003265,     0.00000006694,
	   0.00000000317,     0.00000000263,
	   0.00000024066,     0.00000123656,
	   0.00000005124,     0.00000002443,
	   0.00000000198,    -0.00000000240,
	   0.00000281947,     0.00000000030,
	   0.00000000660,    -0.00000282064,
	   0.00000000050,     0.00000000054,
	  -0.00000000079,    -0.00000000152,
	   0.00000000029,    -0.00000000119,
	  -0.00000028197,     0.00000065245,
	   0.00000006021,    -0.00000003431,
	  -0.00000004773,     0.00000001739,
	   0.00000000496,     0.00000000618,
	  -0.00000003019,     0.00000000084,
	  -0.00000000175,     0.00000003066,
	  -0.00402884328,    -0.00053443547,
	   0.00001983726,     0.00006213859,
	  -0.00000028677,    -0.00000188448,
	  -0.00000006080,     0.00000005337,
	   0.00000299329,    -0.00005851850,
	  -0.00000129089,    -0.00000008168,
	  -0.00000000321,     0.00000002543,
	   0.00000000077,     0.00000000035,
	   0.00116379909,     0.00000012915,
	  -0.00000001991,    -0.00000001801,
	  -0.00000000152,     0.00000015376,
	  -0.00000025193,    -0.00116288286,
	   0.00000000092,     0.00000000816,
	   0.00000015183,     0.00000000241,
	   0.00000011760,    -0.00000009293,
	   0.00000000233,     0.00000000281,
	  -0.00000010106,    -0.00000011111,
	   0.00000000309,    -0.00000000176,
	  -0.00000148181,    -0.00000008742,
	   0.00000000035,     0.00000000167,
	  -0.00000001724,    -0.00000000782,
	  -0.00000000778,     0.00000001739,
	   0.00000018326,    -0.00000000007,
	   0.00000000000,    -0.00000000217,
	   0.00000000803,     0.00000003604,
	   0.00000203793,     0.00000000009,
	   0.00000000000,    -0.00000002386,
	   0.00000216261,     0.00000000011,
	   0.00000000000,    -0.00000002524,
	  -0.00000000775,     0.00000003374,
	   0.00000018652,    -0.00000000001,
	   0.00000000000,    -0.00000000220,
	   0.00000001470,    -0.00000000653,
	  -0.00000000027,    -0.00000000128,
	   0.00000000585,     0.00000000257,
	   0.00000000256,    -0.00000000585,
	   0.00000015441,     0.00000002354,
	  -0.00000004063,    -0.00000000226,
	  -0.00000000224,     0.00000004057,
	  -0.00000000476,    -0.00000000001,
	  -0.00000000001,     0.00000000477,
	  -0.00000665209,    -0.00000003193,
	   0.00000000110,    -0.00000022055,
	   0.00000001095,     0.00000000220,
	   0.00000000088,     0.00000000040,
	   0.00000000086,    -0.00000000072,
	  -0.00000000062,    -0.00000000110,
	  -0.00000716438,    -0.00000048348,
	   0.00000000116,     0.00000005382,
	   0.00000041646,     0.00000002038,
	  -0.00000000111,     0.00000000685,
	   0.00000002160,    -0.00000042917,
	   0.00000000661,     0.00000000118,
	  -0.00000006776,    -0.00000000656,
	   0.00000000870,    -0.00000000025,
	   0.00000000023,     0.00000000875,
	   0.00003507387,     0.00000504568,
	  -0.00000035068,     0.00000104994,
	  -0.00000014499,     0.00000099788,
	  -0.00000002934,    -0.00000000985,
	   0.00000008475,     0.00000000386,
	  -0.00000000015,     0.00000000127,
	  -0.00000000998,     0.00000008949,
	  -0.00000000145,    -0.00000000038,
	   0.00000000279,     0.00000000024,
	   0.00000000015,    -0.00000000210,
	  -0.00000002102,    -0.00000000132,
	   0.00000000134,    -0.00000002103,
	  -0.00000000093,     0.00000000093,
	  -0.00000000091,    -0.00000000089,
	   0.00000003551,     0.00000000739,
	   0.00000000041,    -0.00000000170,
	   0.00000001882,     0.00000000122,
	  -0.00000000123,     0.00000001887,
	  -0.00000000258,    -0.00000000007,
	   0.00000000007,    -0.00000000257,
	   0.00000000057,     0.00000000085,
	  -0.00000000085,     0.00000000056,
	  -0.00000000156,    -0.00000000027,
	   0.00000000027,    -0.00000000156,
	   0.00000000000,     0.00000000014,
	   0.00000000000,     0.00000000066,
	   0.00000000000,     0.00000000087,
	  -0.00000000001,     0.00000000118,
	   0.00000112354,     0.00000001766,
	   0.00000001212,    -0.00000104959,
	   0.00000000095,    -0.00000000022,
	   0.00000009448,    -0.00000000725,
	  -0.00000000043,    -0.00000000093,
	  -0.00000001200,     0.00000000660,
	   0.00000000135,     0.00000000061,
	   0.00000000015,     0.00000000318,
	  -0.00000000035,     0.00000000254,
	   0.00000041973,     0.00000001001,
	  -0.00000000061,     0.00000004604,
	  -0.00000000153,    -0.00000000101,
	   0.08030476237,     0.00000227945,
	  -0.00000528673,    -0.00000004972,
	   0.00000001768,     0.00001126661,
	  -0.00000019098,     0.00341045476,
	  -0.00000001337,    -0.00000024232,
	  -0.00000047835,     0.00000000104,
	   0.00004902137,    -0.00001179678,
	  -0.00000016584,     0.00000156940,
	  -0.00000000015,    -0.00000001866,
	   0.00000000016,     0.00000000089,
	  -0.00000561309,    -0.00009620973,
	   0.00000083426,     0.00000039151,
	   0.00000000329,    -0.00000000265,
	   0.00000000028,    -0.00000000087,
	  -0.00000409462,     0.00000486953,
	  -0.00000019661,    -0.00000012136,
	  -0.00000001591,     0.00000001778,
	   0.00000000075,     0.00000000044,
	   0.00000490329,     0.00000406461,
	  -0.00000012191,     0.00000019540,
	   0.00000001790,     0.00000001580,
	   0.00000000044,    -0.00000000075,
	   0.00013196740,    -0.00001107697,
	   0.00000011569,     0.00000006286,
	   0.00000009574,     0.00000104974,
	  -0.00000000118,     0.00000000062,
	   0.00001337101,    -0.00000076725,
	  -0.00000006130,     0.00000020997,
	   0.00000000076,    -0.00000000197,
	  -0.00000076253,    -0.00001337864,
	   0.00000020981,     0.00000006133,
	  -0.00000000197,    -0.00000000075,
	   0.00000000290,    -0.00000000034,
	  -0.00000000030,    -0.00000000298,
	   0.00000000221,    -0.00000000001,
	  -0.00000000001,     0.00000000219,
	  -0.00000000025,    -0.00000000226,
	   0.00000002484,    -0.00000000001,
	   0.00000000000,     0.00000002479,
	   0.00000004690,    -0.00000000312,
	  -0.00000000025,    -0.00000000239,
	   0.00000002630,     0.00000000000,
	  -0.00000000001,     0.00000002622,
	   0.00000004973,    -0.00000000326,
	   0.00000000197,     0.00000000000,
	   0.00000000000,     0.00000000196,
	   0.00000022765,     0.00000005161,
	   0.00000000102,     0.00000000460,
	  -0.00000009529,    -0.00000000433,
	   0.00000000121,     0.00000000427,
	  -0.00000000428,     0.00000009533,
	   0.00000000424,    -0.00000000122,
	   0.00000002914,     0.00000000719,
	  -0.00000001174,    -0.00000000097,
	  -0.00000000096,     0.00000001173,
	   0.00000000141,    -0.00000000016,
	  -0.00000000016,    -0.00000000141,
	  -0.00000136475,    -0.00000005245,
	   0.00000000555,     0.00000002172,
	   0.00000000021,    -0.00000003002,
	   0.00000018810,    -0.00000000029,
	  -0.00000000044,    -0.00000018703,
	   0.00000125278,    -0.00000189390,
	   0.00000000208,    -0.00000000011,
	   0.00000152384,    -0.00000022217,
	   0.00000000261,     0.00000000100,
	  -0.00000022205,    -0.00000152439,
	   0.00000000098,    -0.00000000260,
	   0.00000035144,     0.00000001364,
	  -0.00000000118,     0.00000002817,
	   0.00078267799,    -0.00004400186,
	  -0.00000357265,     0.00001228523,
	   0.00000004304,    -0.00000011470,
	   0.00000128132,     0.00002278238,
	  -0.00000035738,    -0.00000010431,
	   0.00000000334,     0.00000000126,
	   0.00000040996,    -0.00000007918,
	   0.00000000133,    -0.00000000123,
	  -0.00000003876,     0.00000053106,
	  -0.00000000150,    -0.00000000100,
	   0.00000005395,    -0.00000000580,
	  -0.00000000229,    -0.00000000070,
	  -0.00000000583,    -0.00000005380,
	  -0.00000000070,     0.00000000229,
	   0.00000021095,     0.00000008106,
	   0.00000000399,    -0.00000000708,
	   0.00000001780,     0.00000001746,
	  -0.00000001744,     0.00000001780,
	  -0.00000004184,     0.00000000351,
	   0.00000000191,     0.00000000061,
	  -0.00000000352,    -0.00000004184,
	  -0.00000000061,     0.00000000191,
	   0.00000000578,     0.00000000003,
	  -0.00000000003,     0.00000000580,
	  -0.00000000141,     0.00000000114,
	  -0.00000000114,    -0.00000000141,
	   0.00000000331,     0.00000000139,
	  -0.00000000139,     0.00000000331,
	   0.00000002092,     0.00000000350,
	   0.00000000165,    -0.00000001427,
	   0.00000000088,    -0.00000000027,
	   0.00000004170,    -0.00000000085,
	   0.00000000013,     0.00000000101,
	   0.00000000086,     0.00000004185,
	  -0.00000000102,     0.00000000014,
	  -0.00000000105,     0.00000000131,
	  -0.00000000128,    -0.00000000102,
	  -0.00000000089,     0.00000000040,
	   0.00000000259,     0.00000000031,
	  -0.00003018966,    -0.00000217794,
	  -0.00000051754,    -0.00000222651,
	   0.00000012964,    -0.00000006653,
	  -0.00000024665,     0.00000169720,
	  -0.00000013844,     0.00000003970,
	  -0.00000000489,    -0.00000000894,
	   0.00001764172,    -0.00000230167,
	  -0.00000007777,     0.00000028014,
	   0.00000000129,    -0.00000000245,
	   0.00000231158,     0.00001765222,
	  -0.00000028002,    -0.00000007834,
	   0.00000000252,     0.00000000136,
	  -0.00000307052,     0.00000367741,
	  -0.00000014758,    -0.00000009161,
	  -0.00000001200,     0.00000001338,
	  -0.00000367534,    -0.00000306985,
	   0.00000009154,    -0.00000014748,
	  -0.00000001337,    -0.00000001200,
	  -0.00000007846,    -0.00000001079,
	  -0.00000000174,    -0.00000000483,
	   0.00000000483,    -0.00000000173,
	   0.00000000246,     0.00000000021,
	  -0.00000000021,     0.00000000246,
	  -0.00000017148,     0.00000001178,
	  -0.00000000038,    -0.00000000267,
	   0.00000004678,    -0.00000000962,
	  -0.00000000087,    -0.00000000206,
	  -0.00000000963,    -0.00000004674,
	  -0.00000000202,     0.00000000086,
	   0.00000000034,     0.00000000550,
	   0.00000000550,    -0.00000000034,
	  -0.00000005068,     0.00000000025,
	   0.00000001468,    -0.00000000199,
	  -0.00000000199,    -0.00000001465,
	   0.00000002826,     0.00000024414,
	  -0.00000021724,     0.00000020709,
	   0.00000000351,     0.00000000535,
	   0.00000020709,     0.00000021725,
	   0.00000000535,    -0.00000000351,
	  -0.00000000046,    -0.00000000252,
	  -0.00000000758,    -0.00000000042,
	  -0.00000000042,     0.00000000758,
	   0.00002541682,    -0.00000362337,
	  -0.00000025697,    -0.00000076059,
	  -0.00000000603,     0.00000001826,
	   0.00000015646,     0.00000111527,
	   0.00000003412,    -0.00000001148,
	  -0.00000000083,    -0.00000000028,
	   0.00000030191,    -0.00000002922,
	  -0.00000000121,    -0.00000000442,
	  -0.00000002937,    -0.00000031795,
	  -0.00000000512,     0.00000000141,
	  -0.00000000591,    -0.00000000030,
	  -0.00000000028,     0.00000000588,
	  -0.00001008134,     0.00001018562,
	   0.00000017798,     0.00000023089,
	  -0.00000009183,    -0.00000007587,
	  -0.00000000105,     0.00000000215,
	  -0.00001329581,    -0.00000072292,
	   0.00000006105,     0.00000020815,
	  -0.00000000053,    -0.00000000595,
	  -0.00000072351,     0.00001329594,
	   0.00000020817,    -0.00000006104,
	  -0.00000000595,     0.00000000053,
	  -0.00000004715,    -0.00000000310,
	  -0.00000000007,     0.00000000093,
	   0.00000363069,    -0.00000028826,
	  -0.00000001171,    -0.00000005757,
	   0.00000001324,     0.00000018854,
	   0.00000000270,    -0.00000000057,
	  -0.00000002647,    -0.00000000043,
	  -0.00000000036,     0.00000002259,
	  -0.00072442666,    -0.00004022516,
	   0.00000333836,     0.00001133539,
	  -0.00000002930,    -0.00000032376,
	   0.00000122541,    -0.00002216464,
	  -0.00000034706,     0.00000010185,
	   0.00000000998,    -0.00000000089,
	  -0.00000107643,     0.00000009236,
	   0.00000000144,    -0.00000000012,
	   0.00000005218,     0.00000103859,
	  -0.00000000094,    -0.00000000074,
	  -0.00000005225,     0.00000000114,
	   0.00000000215,     0.00000000265,
	   0.00000000110,     0.00000005229,
	   0.00000000265,    -0.00000000215,
	   0.00000019642,    -0.00000002093,
	  -0.00000000065,    -0.00000000632,
	   0.00000002259,    -0.00000000010,
	   0.00000000009,     0.00000002241,
	  -0.00000066713,    -0.00000019728,
	  -0.00000000913,     0.00000002067,
	  -0.00000014953,    -0.00000001751,
	   0.00000001736,    -0.00000014926,
	   0.00000004417,     0.00000000230,
	  -0.00000000186,    -0.00000000212,
	  -0.00000000230,     0.00000004399,
	   0.00000000212,    -0.00000000186,
	  -0.00000000456,    -0.00000000031,
	   0.00000000029,    -0.00000000458,
	  -0.00000002582,     0.00000000023,
	   0.00000000176,    -0.00000001026,
	   0.00000000009,     0.00000000413,
	  -0.00000000165,    -0.00000000028,
	  -0.00000000042,    -0.00000000065,
	   0.00000086077,    -0.00000000369,
	   0.00000002025,     0.00000008113,
	   0.00000000353,    -0.00000004219,
	   0.00000000407,    -0.00000000115,
	  -0.00000044216,     0.00000002538,
	  -0.00000000368,    -0.00000002640,
	   0.00000000126,    -0.00000000051,
	  -0.00000002553,    -0.00000044214,
	   0.00000002639,    -0.00000000366,
	   0.00000000049,     0.00000000124,
	   0.00000004770,    -0.00000007498,
	   0.00000000372,     0.00000000252,
	   0.00000007498,     0.00000004773,
	  -0.00000000252,     0.00000000373,
	   0.00000000304,    -0.00000000087,
	  -0.00000000087,    -0.00000000302,
	   0.00000000184,    -0.00000000038,
	  -0.00000000038,    -0.00000000185,
	  -0.00000000474,     0.00000000881,
	   0.00000000881,     0.00000000474,
	   0.00000137933,    -0.00000029898,
	  -0.00000002579,    -0.00000005980,
	   0.00000001315,     0.00000006187,
	   0.00000000277,    -0.00000000119,
	   0.00000002649,    -0.00000000456,
	  -0.00000000028,    -0.00000000080,
	  -0.00000000463,    -0.00000002738,
	  -0.00000000085,     0.00000000030,
	  -0.00000020544,     0.00000044011,
	  -0.00000000402,    -0.00000000180,
	  -0.00000047468,     0.00000009999,
	   0.00000000510,     0.00000001398,
	   0.00000009998,     0.00000047470,
	   0.00000001398,    -0.00000000510,
	   0.00000046494,    -0.00000007369,
	   0.00000000355,     0.00000002392,
	  -0.00000000535,     0.00000000050,
	   0.00000000047,     0.00000000484,
	  -0.00002653091,     0.00000495816,
	   0.00000027904,     0.00000078545,
	  -0.00000015279,    -0.00000083474,
	  -0.00000002516,     0.00000000890,
	  -0.00000035219,     0.00000003140,
	   0.00000000128,     0.00000000555,
	   0.00000002959,     0.00000035159,
	   0.00000000553,    -0.00000000122,
	   0.00000000183,     0.00000000212,
	   0.00000000212,    -0.00000000183,
	   0.00000119231,    -0.00000013000,
	  -0.00000000356,    -0.00000001908,
	   0.00000006186,     0.00000065766,
	   0.00000001023,    -0.00000000210,
	  -0.00000001891,     0.00000000152,
	  -0.00000000166,    -0.00000002334,
	  -0.00000000140,     0.00000000085,
	   0.00000000120,     0.00000000076,
	  -0.00000564229,     0.00000042605,
	   0.00000001859,     0.00000008889,
	  -0.00000007455,    -0.00000094271,
	  -0.00000001462,     0.00000000314,
	   0.00000001700,    -0.00000000087,
	   0.00000000123,     0.00000001714,
	  -0.00000000244,     0.00000000022,
	   0.00000000014,     0.00000000246,
	   0.00000421395,    -0.00000000567,
	  -0.00000000031,    -0.00000014694,
	   0.00000001997,    -0.00000000097,
	   0.00000000051,     0.00000001649,
	  -0.00001051232,     0.00000001086,
	  -0.00000000043,     0.00000011332,
	  -0.00000010148,     0.00000000682,
	   0.00000000033,     0.00000000160,
	  -0.00000000581,    -0.00000010116,
	  -0.00000000162,     0.00000000033,
	   0.00000000586,     0.00000000098,
	  -0.00000000123,     0.00000000452,
	  -0.00000000224,     0.00000000027,
	  -0.00000000027,    -0.00000000223,
	  -0.00000000667,     0.00000000084,
	  -0.00000000084,    -0.00000000668,
	   0.00000000247,     0.00000000313,
	   0.00000000136,    -0.00000000101,
	  -0.00000001307,    -0.00000001876,
	   0.00000000865,    -0.00000000344,
	  -0.00000000320,     0.00000000245,
	  -0.00000000065,    -0.00000000151,
	  -0.00000000003,     0.00000000101,
	   0.00000000148,     0.00000000109,
	  -0.00000001784,     0.00000000496,
	  -0.00000000008,     0.00000000204,
	   0.00000001115,    -0.00000000161,
	   0.00000000021,     0.00000000094,
	   0.00000000160,     0.00000001117,
	  -0.00000000094,     0.00000000021,
	  -0.00000000075,     0.00000000188,
	  -0.00000000188,    -0.00000000074,
	   0.00000000088,    -0.00000000073,
	  -0.00000000084,    -0.00000000083,
	  -0.00000000034,    -0.00000000072,
	  -0.00000000095,     0.00000000035,
	   0.00000000122,     0.00000000086,
	   0.00000000038,    -0.00000000098,
	   0.00000002332,    -0.00000002134,
	  -0.00000001723,    -0.00000001184,
	  -0.00000000235,     0.00000000571,
	   0.00000000810,     0.00000000870,
	   0.00000000440,    -0.00000000652,
	  -0.00000000215,    -0.00000000087,
	  -0.00000010673,     0.00000009790,
	   0.00000007891,     0.00000005415,
	   0.00000001085,    -0.00000002631,
	  -0.00000001839,    -0.00000001975,
	  -0.00000001000,     0.00000001480,
	   0.00000000490,     0.00000000197,
	  -0.00000000067,    -0.00000000082,
	  -0.00000000102,    -0.00000000080,
	   0.00000008595,    -0.00000002520,
	   0.00000000119,     0.00000000416,
	   0.00000000240,    -0.00000000059,
	  -0.00000000060,    -0.00000000247,
	  -0.00000002361,     0.00000000633,
	   0.00000000049,     0.00000000105,
	   0.00000000633,     0.00000002361,
	   0.00000000105,    -0.00000000049,
	   0.00000005766,    -0.00000001324,
	   0.00000000056,     0.00000000261,
	  -0.00000130518,     0.00000032855,
	   0.00000002573,     0.00000005663,
	  -0.00000001035,    -0.00000004253,
	  -0.00000000192,     0.00000000086,
	  -0.00000002898,     0.00000000532,
	   0.00000000030,     0.00000000088,
	   0.00000000524,     0.00000002899,
	   0.00000000088,    -0.00000000030,
	   0.00000014834,    -0.00000002850,
	   0.00000000974,     0.00000005596,
	   0.00000000168,    -0.00000000055,
	  -0.00000000190,     0.00000000027,
	  -0.00000000025,    -0.00000000163,
	  -0.00000068306,     0.00000012474,
	  -0.00000001348,    -0.00000007942,
	  -0.00000000236,     0.00000000077,
	   0.00000000241,    -0.00000000027,
	   0.00000062871,    -0.00000007790,
	  -0.00000000267,    -0.00000002440,
	   0.00000000609,    -0.00000000037,
	   0.00000000000,    -0.00000000175,
	  -0.00000181603,     0.00000020930,
	   0.00000000529,     0.00000002864,
	   0.00000000207,     0.00000001937,
	  -0.00000001972,     0.00000000145,
	  -0.00000000123,     0.00000000178,
	   0.00000208094,     0.00000001910,
	   0.00000000085,    -0.00000002852,
	   0.00000005357,    -0.00000000469,
	   0.00000000456,     0.00000005241,
	  -0.00000000291,    -0.00000000281,
	   0.00000000272,    -0.00000000294,
	  -0.00000505841,     0.00000001463,
	   0.00000000012,     0.00000002015,
	   0.00000000051,     0.00000000051,
	  -0.00000003956,    -0.00000000526,
	  -0.00000000027,    -0.00000000143,
	  -0.00000000707,     0.00000000016,
	  -0.00000000020,    -0.00000000710,
	  -0.00000000388,     0.00000000002,
	   0.00000000000,    -0.00000000385,
	   0.00000006902,    -0.00000000411,
	  -0.00000000653,    -0.00000002564,
	   0.00000000087,     0.00000000033,
	  -0.00000000148,     0.00000000051,
	   0.00000000051,     0.00000000148,
	  -0.00000007787,     0.00000002566,
	  -0.00000000087,    -0.00000000279,
	  -0.00000000276,     0.00000000069,
	   0.00000000068,     0.00000000275,
	   0.00000001762,    -0.00000000475,
	   0.00000000122,     0.00000000493,
	  -0.00000008336,     0.00000002136,
	  -0.00000000174,    -0.00000000722,
	   0.00000007814,    -0.00000001701,
	  -0.00000000075,    -0.00000000369,
	  -0.00000024183,     0.00000005060,
	   0.00000000065,     0.00000000323,
	  -0.00000000214,     0.00000000037,
	   0.00000035290,    -0.00000004607,
	  -0.00000000050,    -0.00000000478,
	   0.00000000733,    -0.00000000083,
	   0.00000000076,     0.00000000207,
	  -0.00000093826,     0.00000012093,
	   0.00000000046,     0.00000000353,
	  -0.00000000704,     0.00000000002,
	   0.00000000010,     0.00000000704,
	   0.00000121198,    -0.00000000318,
	  -0.00000000012,    -0.00000001183,
	  -0.00000000030,    -0.00000000144,
	  -0.00000265960,     0.00000000773,
	   0.00000000005,     0.00000000584,
	  -0.00000005863,    -0.00000000227,
	   0.00000006646,     0.00000000343,
	  -0.00000000338,     0.00000000002,
	  -0.00000000001,    -0.00000000336,
	   0.00000004211,     0.00000000126,
	   0.00000000439,    -0.00000001062,
	   0.00000000141,     0.00000000061,
	   0.00000000147,     0.00000000025,
	   0.00000000032,    -0.00000000157,
	  -0.00000006772,     0.00000010172,
	   0.00000001985,     0.00000001628,
	  -0.00000000617,    -0.00000000287,
	  -0.00000000032,     0.00000000100,
	  -0.00000000292,    -0.00000000037,
	  -0.00000000100,     0.00000000398,
	  -0.00000002923,     0.00000000860,
	   0.00000004582,    -0.00000001083,
	  -0.00000012860,     0.00000002984,
	  -0.00000000097,     0.00000000013,
	   0.00000000015,     0.00000000098,
	   0.00000022295,    -0.00000003181,
	  -0.00000000023,    -0.00000000176,
	  -0.00000054038,     0.00000007385,
	   0.00000000015,     0.00000000099,
	  -0.00000000431,     0.00000000004,
	   0.00000000002,     0.00000000404,
	   0.00000068211,    -0.00000000099,
	  -0.00000000006,    -0.00000000477,
	  -0.00000147016,     0.00000000323,
	   0.00000000002,     0.00000000129,
	  -0.00000005824,    -0.00000000001,
	   0.00000000231,    -0.00000000003,
	   0.00000000002,     0.00000000231,
	   0.00000007277,     0.00000000134,
	  -0.00000000150,     0.00000000001,
	  -0.00000000001,    -0.00000000148,
	   0.00000000322,    -0.00000000689,
	   0.00000000085,     0.00000000041,
	   0.00000000020,    -0.00000000085,
	  -0.00000004514,     0.00000006117,
	   0.00000001167,     0.00000001105,
	  -0.00000000374,    -0.00000000195,
	  -0.00000000146,    -0.00000000015,
	  -0.00000000069,     0.00000000223,
	   0.00000003917,     0.00000000376,
	  -0.00000000106,     0.00000000619,
	  -0.00000036471,    -0.00000006972,
	  -0.00000003354,     0.00000002038,
	   0.00000000529,    -0.00000002669,
	  -0.00000000179,    -0.00000000232,
	  -0.00000000140,     0.00000000531,
	  -0.00000000262,    -0.00000000278,
	   0.00000003013,    -0.00000000771,
	  -0.00000007754,     0.00000001921,
	   0.00000013871,    -0.00000002048,
	  -0.00000032652,     0.00000004638,
	   0.00000000016,     0.00000000102,
	  -0.00000000171,     0.00000000002,
	   0.00000000000,     0.00000000155,
	   0.00000039076,     0.00000000013,
	  -0.00000000002,    -0.00000000211,
	  -0.00000083386,     0.00000000106,
	  -0.00000004561,     0.00000000023,
	   0.00000006437,     0.00000000034,
	   0.00000001994,     0.00000000265,
	  -0.00000000060,     0.00000000297,
	  -0.00000018275,    -0.00000004023,
	  -0.00000001905,     0.00000000916,
	   0.00000000293,    -0.00000001286,
	  -0.00000000083,    -0.00000000128,
	  -0.00000000089,     0.00000000327,
	  -0.00000000163,    -0.00000000190,
	  -0.00000000238,    -0.00000001093,
	   0.00000000221,    -0.00000000120,
	   0.00000000188,     0.00000000044,
	  -0.00000000023,     0.00000000207,
	   0.00000006954,     0.00000013869,
	   0.00000000908,    -0.00000001302,
	  -0.00000001018,     0.00000000677,
	   0.00000000096,     0.00000000063,
	  -0.00000001715,    -0.00000000353,
	  -0.00000000155,     0.00000000120,
	   0.00000000283,    -0.00000001772,
	  -0.00000000107,    -0.00000000142,
	   0.00000001978,    -0.00000000531,
	  -0.00000004932,     0.00000001284,
	   0.00000008748,    -0.00000001322,
	  -0.00000020181,     0.00000002950,
	   0.00000022698,     0.00000000051,
	  -0.00000048056,    -0.00000000009,
	   0.00000000000,     0.00000000103,
	  -0.00000003367,     0.00000000025,
	   0.00000005115,    -0.00000000003,
	  -0.00000001803,     0.00000002012,
	  -0.00000000124,    -0.00000000077,
	  -0.00000000309,    -0.00000000659,
	   0.00000000122,    -0.00000000084,
	   0.00000000091,     0.00000000028,
	  -0.00000000011,     0.00000000101,
	   0.00000005120,     0.00000008021,
	  -0.00000000565,     0.00000000423,
	  -0.00000000837,    -0.00000000208,
	  -0.00000000087,     0.00000000057,
	   0.00000000155,    -0.00000000864,
	  -0.00000000049,    -0.00000000080,
	  -0.00000000055,    -0.00000000059,
	  -0.00000000040,    -0.00000000073,
	   0.00000000076,    -0.00000000048,
	   0.00000004568,    -0.00000003174,
	   0.00000000301,     0.00000000168,
	   0.00000000402,     0.00000000661,
	   0.00000000045,    -0.00000000068,
	  -0.00000000666,     0.00000000432,
	   0.00000000068,     0.00000000039,
	  -0.00000003212,     0.00000000868,
	   0.00000005563,    -0.00000000854,
	  -0.00000012637,     0.00000001885,
	   0.00000013294,     0.00000000059,
	  -0.00000027995,    -0.00000000060,
	  -0.00000002405,     0.00000000020,
	   0.00000003832,    -0.00000000015,
	  -0.00000001086,     0.00000001102,
	  -0.00000004293,    -0.00000001333,
	   0.00000000092,    -0.00000000291,
	  -0.00000000034,     0.00000000112,
	  -0.00000000055,    -0.00000000075,
	   0.00000001934,    -0.00000002465,
	   0.00000000203,     0.00000000061,
	   0.00000000265,     0.00000000372,
	  -0.00000000371,     0.00000000284,
	  -0.00000002398,    -0.00000000990,
	   0.00000000151,    -0.00000000179,
	   0.00000000187,     0.00000000146,
	   0.00000003543,    -0.00000000549,
	  -0.00000007981,     0.00000001209,
	   0.00000007823,     0.00000000056,
	  -0.00000016428,    -0.00000000074,
	  -0.00000002016,    -0.00000000757,
	   0.00000000052,    -0.00000000136,
	   0.00000001985,     0.00000002577,
	  -0.00000000172,     0.00000000141,
	  -0.00000000193,    -0.00000000072,
	   0.00000000047,    -0.00000000199,
	   0.00000000058,    -0.00000000127,
	   0.00000000132,     0.00000000055,
	   0.00000002268,    -0.00000000353,
	  -0.00000005054,     0.00000000773,
	   0.00000004626,     0.00000000047,
	  -0.00000009691,    -0.00000000071,
	   0.00000001102,     0.00000001422,
	  -0.00000000094,     0.00000000077,
	  -0.00000000092,    -0.00000000041,
	   0.00000000093,     0.00000000117,
	  -0.00000000113,     0.00000000100,
	  -0.00000003209,     0.00000000494,
	   0.00000002742,     0.00000000039,
	  -0.00000005742,    -0.00000000062,
	  -0.00000003405,    -0.00000000050,
	  -0.00000000593,     0.00000000021,
	   0.00000000021,     0.00000000590,
	  -0.00000000155,    -0.00000000006,
	  -0.00000000007,     0.00000000155,
	  -0.00000000284,    -0.00000000191,
	  -0.00000000191,     0.00000000284,
	   0.00000000027,     0.00000000090,
	   0.00000000204,    -0.00000000025,
	  -0.00000000025,    -0.00000000205,
	  -0.00000289818,    -0.00000002874,
	   0.00000003621,     0.00000013259,
	  -0.00000000299,    -0.00000004266,
	  -0.00000000232,     0.00000000042,
	   0.00000081378,    -0.00000010246,
	  -0.00000000805,    -0.00000002451,
	  -0.00000010266,    -0.00000081316,
	  -0.00000002445,     0.00000000805,
	  -0.00000015783,    -0.00000010980,
	  -0.00000002720,    -0.00000026700,
	  -0.00000000425,    -0.00000000321,
	  -0.00000026700,     0.00000002720,
	  -0.00000000321,     0.00000000425,
	   0.00000000047,     0.00000000718,
	   0.00000000507,    -0.00000000090,
	  -0.00000000874,    -0.00000001193,
	  -0.00000000058,     0.00000000094,
	  -0.00000001192,     0.00000000873,
	   0.00000000094,     0.00000000058,
	  -0.00000000190,     0.00000000778,
	   0.00000000078,     0.00000000054,
	  -0.00000000168,    -0.00000000176,
	  -0.00000000179,     0.00000000173,
	  -0.00000040207,    -0.00000002021,
	   0.00000000020,    -0.00000000504,
	   0.00000010870,    -0.00000000695,
	  -0.00000000036,    -0.00000000172,
	  -0.00000000698,    -0.00000010857,
	  -0.00000000171,     0.00000000036,
	  -0.00000168329,    -0.00001616382,
	  -0.00000021196,    -0.00000019643,
	   0.00000000041,     0.00000000399,
	   0.00000000094,     0.00000000171,
	   0.00001351141,    -0.00001422599,
	   0.00000004201,    -0.00000020860,
	  -0.00000000267,    -0.00000000175,
	  -0.00001422581,    -0.00001351177,
	  -0.00000020859,    -0.00000004202,
	  -0.00000000175,     0.00000000267,
	   0.00000000410,    -0.00000000023,
	  -0.00000000023,    -0.00000000410,
	  -0.00000033809,     0.00000008560,
	  -0.00000000850,     0.00000001611,
	   0.00000005757,     0.00000022633,
	   0.00000001093,     0.00000000570,
	   0.00000000048,    -0.00000000054,
	   0.00000071822,    -0.00000000076,
	   0.00000000041,    -0.00000071510,
	  -0.00000002475,     0.00000004523,
	  -0.00000000643,     0.00000000729,
	  -0.00000000019,     0.00000000084,
	   0.00058751896,     0.00003239962,
	  -0.00000274776,    -0.00000918829,
	   0.00000003252,     0.00000027860,
	   0.00000001367,    -0.00000000815,
	  -0.00000140987,     0.00002533360,
	   0.00000039596,    -0.00000011872,
	  -0.00000001214,     0.00000000142,
	   0.00000384682,    -0.00000007531,
	  -0.00000000536,     0.00000000638,
	  -0.00000000856,    -0.00000419306,
	  -0.00000000488,     0.00000000756,
	  -0.00000003229,     0.00000003261,
	  -0.00000000073,    -0.00000000084,
	   0.00000003297,     0.00000003194,
	  -0.00000000084,     0.00000000073,
	   0.00097919295,    -0.00106537829,
	   0.00000223461,    -0.00001378576,
	  -0.00000010800,    -0.00000005385,
	   0.00000942573,     0.00000712491,
	   0.00000003516,    -0.00000002936,
	  -0.00000000345,     0.00000000362,
	   0.00131042157,    -0.00000031181,
	  -0.00000009910,     0.00000001649,
	   0.00000000141,     0.00000019713,
	  -0.00000025533,    -0.00131043133,
	   0.00000001676,     0.00000009824,
	   0.00000019709,    -0.00000000138,
	   0.00000003171,    -0.00000003841,
	  -0.00000000236,    -0.00000000033,
	  -0.00000003835,    -0.00000003178,
	  -0.00000000035,     0.00000000236,
	   0.00000042428,    -0.00000000088,
	   0.00000000000,    -0.00000000331,
	   0.00000001868,     0.00000008316,
	   0.00000470006,    -0.00000000450,
	  -0.00000000002,    -0.00000003689,
	  -0.00000002100,     0.00000002373,
	   0.00000497719,    -0.00000000101,
	   0.00000000000,    -0.00000003901,
	  -0.00000001850,     0.00000008061,
	   0.00000042827,    -0.00000000030,
	   0.00000000000,    -0.00000000312,
	   0.00000003618,    -0.00000001609,
	  -0.00000000018,     0.00000000124,
	   0.00000002790,     0.00000000112,
	  -0.00000000030,     0.00000000211,
	   0.00000001456,    -0.00000000738,
	   0.00000000064,     0.00000000083,
	   0.00000000162,     0.00000000021,
	  -0.00000000028,     0.00000000169,
	   0.00000000000,     0.00000000417,
	   0.00000000433,    -0.00000000054,
	  -0.00000000166,    -0.00000000120,
	   0.00000000037,     0.00000000590,
	   0.00000000591,    -0.00000000039,
	   0.00000000046,     0.00000000712,
	   0.00000000712,    -0.00000000046,
	   0.00000005320,    -0.00000032419,
	  -0.00000006790,    -0.00000000915,
	  -0.00000000319,     0.00000001760,
	  -0.00000001530,     0.00000000308,
	  -0.00000000025,     0.00000000313,
	   0.00000000072,    -0.00000000127,
	   0.00000000148,     0.00000000069,
	  -0.00000000167,     0.00000000494,
	  -0.00000000494,    -0.00000000165,
	   0.00000002433,     0.00000003443,
	   0.00000000094,     0.00000000197,
	   0.00000000162,    -0.00000001190,
	  -0.00000000190,     0.00000000014,
	   0.00000001180,     0.00000000169,
	  -0.00000000015,    -0.00000000189,
	  -0.00000000887,    -0.00000001393,
	   0.00000000064,    -0.00000000081,
	   0.00000000107,     0.00000000076,
	  -0.00000000074,     0.00000000112,
	  -0.00000000850,    -0.00000000230,
	  -0.00000000085,     0.00000000061,
	   0.00000000061,     0.00000000085,
	  -0.00000176985,     0.00000017217,
	   0.00000017288,     0.00000071789,
	   0.00000014647,    -0.00000005861,
	  -0.00000001165,    -0.00000001926,
	   0.00000000718,     0.00000007362,
	   0.00000002979,    -0.00000000718,
	  -0.00000000243,    -0.00000000608,
	  -0.00000000082,     0.00000000049,
	  -0.00000000417,     0.00000000033,
	   0.00000000036,     0.00000000169,
	   0.00000000039,     0.00000000089,
	   0.00000007948,    -0.00000001711,
	  -0.00000001130,    -0.00000003181,
	  -0.00000000021,    -0.00000000100,
	   0.00000000151,    -0.00000000046,
	   0.00000000053,     0.00000000196,
	   0.00000000080,    -0.00000000034,
	  -0.00000037960,     0.00000005645,
	   0.00000003949,     0.00000014687,
	   0.00000002889,    -0.00000001131,
	  -0.00000000043,     0.00000000400,
	   0.00000000166,    -0.00000000015,
	  -0.00000005083,     0.00000000494,
	   0.00000000495,     0.00000002060,
	   0.00000000421,    -0.00000000168,
	  -0.00000000495,    -0.00000005107,
	  -0.00000002068,     0.00000000497,
	   0.00000000169,     0.00000000421,
	  -0.00000000173,     0.00000000016,
	   0.00000001314,     0.00000024037,
	   0.00000005094,    -0.00000000395,
	   0.00000001902,    -0.00000000282,
	  -0.00000000037,    -0.00000000415,
	  -0.00000000182,    -0.00000000014,
	  -0.00000000059,     0.00000000074,
	   0.00000010284,     0.00000000272,
	  -0.00000000176,    -0.00000002091,
	  -0.00000000092,     0.00000000554,
	  -0.00000000727,     0.00000000165,
	   0.00000000080,     0.00000000273,
	  -0.00000000167,    -0.00000000728,
	  -0.00000000274,     0.00000000081,
	  -0.00000000032,    -0.00000000168,
	   0.00000006139,    -0.00000001571,
	   0.00000000134,     0.00000000502,
	   0.00000000572,     0.00000000059,
	  -0.00000000074,     0.00000000576,
	  -0.00000001358,    -0.00000001974,
	   0.00000000197,    -0.00000000126,
	   0.00000000390,    -0.00000000124,
	   0.00000000125,     0.00000000400,
	  -0.00000000100,    -0.00000000081,
	  -0.00000000122,    -0.00000000168,
	   0.00000000175,    -0.00000000126,
	   0.00000000476,    -0.00000000752,
	   0.00000002197,     0.00000000319,
	  -0.00000000085,     0.00000000806,
	  -0.00000000278,     0.00000000166,
	  -0.00000000164,    -0.00000000282,
	   0.00000000019,    -0.00000000231,
	  -0.00000000178,     0.00000000001,
	  -0.00000000009,     0.00000000173,
	   0.00000008188,     0.00000001813,
	  -0.00000000192,     0.00000000908,
	   0.00000000077,     0.00000000064,
	   0.00000000195,    -0.00000000384,
	   0.00000000693,     0.00000000179,
	  -0.00000000276,     0.00000000908,
	   0.00000000169,    -0.00000000031,
	  -0.00000000709,     0.00000000385,
	   0.00000000000,     0.00000000213,
	  -0.00000006707,     0.00000003291,
	   0.00000000574,     0.00000000743,
	  -0.00000001812,    -0.00000000626,
	  -0.00000000012,     0.00000000317,
	   0.00000000623,     0.00000000693,
	   0.00000000220,    -0.00000000006,
	  -0.00000000852,    -0.00000000752,
	   0.00000000032,     0.00000000180,
	   0.00000014738,    -0.00000001628,
	   0.00000000233,     0.00000001634,
	   0.00000000996,     0.00000000169,
	   0.00000000046,    -0.00000000074,
	  -0.00000000192,     0.00000000984,
	   0.00000000066,     0.00000000058,
	   0.00000000473,    -0.00000000429,
	   0.00000000303,     0.00000001390,
	  -0.00000001652,     0.00000000542,
	   0.00000000166,    -0.00000000201,
	  -0.00000000455,     0.00000000023,
	  -0.00000000009,    -0.00000000376,
	  -0.00000003254,    -0.00000010657,
	   0.00000002982,    -0.00000001141,
	  -0.00000000213,     0.00000000113,
	   0.00000002267,    -0.00000000526,
	   0.00000000485,     0.00000002324,
	   0.00000000131,     0.00000000236,
	  -0.00000000228,     0.00000000143,
	   0.00000000062,    -0.00000000043,
	   0.00000000115,    -0.00000000463,
	  -0.00000009071,     0.00000002201,
	  -0.00000000121,     0.00000000732,
	   0.00000000091,     0.00000000108,
	   0.00000000248,     0.00000001835,
	   0.00000000910,    -0.00000000696,
	  -0.00000000465,    -0.00000003872,
	   0.00000000340,    -0.00000000111,
	   0.00000000172,     0.00000000069,
	  -0.00000000014,     0.00000000209,
	  -0.00000013265,     0.00000002465,
	   0.00000000131,     0.00000000602,
	   0.00000000054,     0.00000000055,
	  -0.00000000711,     0.00000000000,
	  -0.00000000080,     0.00000000055,
	  -0.00000000012,    -0.00000000682,
	  -0.00000000062,    -0.00000000074,
	  -0.00000000087,    -0.00000000641,
	  -0.00000000004,    -0.00000000158,
	  -0.00000000376,     0.00000000304,
	   0.00000002996,    -0.00000002762,
	   0.00000000181,     0.00000001625,
	  -0.00000000382,    -0.00000000802,
	   0.00000000031,    -0.00000000093,
	  -0.00000000018,    -0.00000000137,
	  -0.00000000282,     0.00000000062,
	  -0.00000000057,    -0.00000000293,
	   0.00000000035,    -0.00000000134,
	  -0.00000000037,     0.00000000149,
	   0.00000000320,     0.00000000999,
	   0.00000002136,    -0.00000000511,
	  -0.00000000307,    -0.00000001289,
	  -0.00000000573,    -0.00000002255,
	  -0.00000001436,     0.00000000334,
	   0.00000000140,     0.00000000310,
	   0.00000000320,     0.00000000387,
	   0.00000000383,    -0.00000000320,
	  -0.00000000041,    -0.00000000064,
	   0.00000001877,    -0.00000004329,
	  -0.00000000618,     0.00000000097,
	   0.00000000169,     0.00000000184,
	   0.00000001414,     0.00000002280,
	   0.00000000396,    -0.00000000314,
	  -0.00000000074,    -0.00000000093,
	   0.00000002258,    -0.00000001402,
	  -0.00000000314,    -0.00000000381,
	  -0.00000000097,     0.00000000072,
	  -0.00000000024,    -0.00000000104,
	   0.00000000022,     0.00000000141,
	  -0.00000000050,     0.00000000063,
	   0.00000000063,     0.00000000057,
	  -0.00000000013,     0.00000000091,
	   0.00000001700,     0.00000000940,
	  -0.00000000029,     0.00000000242,
	   0.00000000554,    -0.00000000745,
	   0.00000000150,     0.00000000115,
	  -0.00000000101,    -0.00000000014,
	   0.00000000002,    -0.00000000099,
	   0.00000007347,    -0.00000001637,
	   0.00000000140,     0.00000000021,
	  -0.00000000013,     0.00000000205,
	  -0.00000004699,    -0.00000008698,
	   0.00000001332,     0.00000000111,
	   0.00000000570,    -0.00000000354,
	   0.00000000108,    -0.00000000036,
	   0.00000000055,     0.00000000124,
	  -0.00000005546,    -0.00000001216,
	   0.00000000018,    -0.00000000214,
	  -0.00000000095,     0.00000000241,
	  -0.00000003672,    -0.00000004726,
	   0.00000000144,    -0.00000000115,
	   0.00000000065,    -0.00000000071,
	   0.00000000370,     0.00000002267,
	   0.00000001697,     0.00000000736,
	   0.00000000046,    -0.00000000180,
	  -0.00000000083,     0.00000000436,
	   0.00000000429,     0.00000000138,
	  -0.00000019096,    -0.00000005222,
	  -0.00000001102,     0.00000001580,
	   0.00000000168,    -0.00000000589,
	   0.00000000432,     0.00000000093,
	   0.00000000095,    -0.00000000422,
	  -0.00000036357,     0.00000019467,
	  -0.00000000193,     0.00000005622,
	  -0.00000000350,     0.00000000212,
	   0.00000000104,    -0.00000000005,
	  -0.00000035683,    -0.00000008021,
	  -0.00000002408,     0.00000002759,
	   0.00000000148,     0.00000000124,
	  -0.00000008015,     0.00000035680,
	   0.00000002759,     0.00000002406,
	   0.00000000125,    -0.00000000150,
	  -0.00000000038,     0.00000000213,
	   0.00000000213,     0.00000000038,
	   0.00000000177,     0.00000000290,
	   0.00000000136,     0.00000000013,
	  -0.00000000011,    -0.00000000153,
	  -0.00000000165,    -0.00000000002,
	  -0.00000000520,    -0.00000000570,
	  -0.00000000428,    -0.00000000042,
	  -0.00000000086,     0.00000000096,
	   0.00000000096,     0.00000000086,
	  -0.00000000046,     0.00000000111,
	  -0.00000000520,    -0.00000000147,
	  -0.00000000149,     0.00000000532,
	  -0.00000001260,     0.00000000741,
	  -0.00000000009,    -0.00000000102,
	  -0.00000000224,     0.00000000003,
	  -0.00000000003,     0.00000000225,
	   0.00000002379,     0.00000001038,
	   0.00000000044,    -0.00000000130,
	  -0.00000000863,    -0.00000000297,
	  -0.00000000296,     0.00000000862,
	   0.00000005879,     0.00000000160,
	  -0.00000000011,     0.00000000100,
	  -0.00000059749,     0.00000013702,
	  -0.00000000808,    -0.00000001206,
	  -0.00000000272,    -0.00000000845,
	   0.00000000752,     0.00000003869,
	  -0.00000000440,    -0.00000000170,
	   0.00000003934,    -0.00000001756,
	  -0.00000000190,     0.00000000448,
	   0.00000057902,     0.00000133659,
	  -0.00000016203,    -0.00000004386,
	  -0.00000005368,     0.00000002227,
	   0.00000000169,    -0.00000000607,
	  -0.00000000207,     0.00000000372,
	   0.00000000065,    -0.00000000274,
	   0.00000000074,     0.00000000137,
	  -0.00000000138,     0.00000000074,
	   0.00000018528,    -0.00000000378,
	  -0.00000000052,    -0.00000000829,
	  -0.00000000099,    -0.00000000008,
	   0.00000000003,    -0.00000000100,
	   0.00000003654,    -0.00000001338,
	   0.00000000061,    -0.00000000380,
	   0.00000000716,     0.00000000061,
	  -0.00000000080,     0.00000000680,
	   0.00017526505,    -0.00000011320,
	   0.00000002734,    -0.00000000356,
	  -0.00000000028,    -0.00000003746,
	   0.00000000139,    -0.00000122359,
	   0.00000004959,    -0.00000004001,
	   0.00000000461,     0.00000000528,
	  -0.00000002817,    -0.00000003928,
	   0.00000000537,    -0.00000000469,
	  -0.00000000360,    -0.00000000289,
	  -0.00000000296,     0.00000000358,
	   0.00000000029,    -0.00000000311,
	  -0.00000000311,    -0.00000000030,
	   0.00000001021,    -0.00000007628,
	   0.00000000155,    -0.00000000005,
	   0.00000000141,     0.00000002429,
	   0.00000000261,    -0.00000000303,
	   0.00000002426,    -0.00000000143,
	  -0.00000000301,    -0.00000000258,
	   0.00000004249,     0.00000053972,
	   0.00000005656,    -0.00000006567,
	  -0.00000002475,     0.00000000306,
	   0.00000000348,     0.00000000283,
	   0.00000000671,    -0.00000001486,
	  -0.00000000195,     0.00000000083,
	  -0.00000001450,    -0.00000000659,
	   0.00000000077,     0.00000000187,
	  -0.00000000755,     0.00000000218,
	  -0.00000000113,    -0.00000000236,
	  -0.00000012030,    -0.00000024288,
	  -0.00000002282,     0.00000001747,
	   0.00000002810,     0.00000000881,
	  -0.00000000154,    -0.00000000336,
	   0.00000001304,     0.00000000078,
	   0.00000000007,    -0.00000000139,
	   0.00000119418,     0.00000007568,
	  -0.00000000443,    -0.00000001960,
	   0.00000000097,    -0.00000001026,
	   0.00000000045,    -0.00000000236,
	   0.00000000184,    -0.00000000027,
	  -0.00000000066,    -0.00000000049,
	   0.00000000169,    -0.00000000003,
	   0.00000000003,     0.00000000169,
	  -0.00000060914,     0.00000910300,
	  -0.00000088046,    -0.00000061520,
	   0.00000005532,    -0.00000005354,
	   0.00000006612,     0.00000000050,
	  -0.00000000435,     0.00000000612,
	  -0.00000003055,     0.00000001580,
	  -0.00000000775,    -0.00000000333,
	   0.00000000027,    -0.00000000109,
	   0.00000001517,     0.00000002401,
	  -0.00000000334,     0.00000000770,
	  -0.00000000109,    -0.00000000027,
	   0.00000000653,    -0.00000002182,
	   0.00000000122,     0.00000000010,
	  -0.00000003587,     0.00000003355,
	   0.00000000091,     0.00000000059,
	   0.00000000110,     0.00000000011,
	   0.00000011207,    -0.00000003747,
	  -0.00000000033,    -0.00000000231,
	  -0.00000019020,    -0.00000002293,
	  -0.00000001155,     0.00000006208,
	   0.00000000074,    -0.00000000026,
	  -0.00000052692,    -0.00000007315,
	   0.00000008277,    -0.00000009432,
	  -0.00000000030,     0.00000000423,
	   0.00000001400,     0.00000000035,
	  -0.00000000112,     0.00000000504,
	  -0.00000000097,    -0.00000000036,
	   0.00000000059,    -0.00000001393,
	   0.00000000502,     0.00000000115,
	  -0.00000000036,     0.00000000097,
	  -0.00000002181,     0.00000001473,
	   0.00000006432,    -0.00000001972,
	  -0.00000010073,    -0.00000000402,
	   0.00000000019,    -0.00000000086,
	   0.00000000309,    -0.00000003758,
	  -0.00000001396,     0.00000000895,
	   0.00000003693,    -0.00000001101,
	  -0.00000005044,    -0.00000000137,
	   0.00000027769,     0.00000010179,
	  -0.00000004842,     0.00000011884,
	  -0.00000002651,    -0.00000001134,
	   0.00000000064,    -0.00000000095,
	   0.00000002102,     0.00000001674,
	  -0.00000000752,     0.00000001019,
	  -0.00000000261,    -0.00000000174,
	   0.00000001693,    -0.00000002230,
	   0.00000001069,     0.00000000767,
	  -0.00000000179,     0.00000000271,
	   0.00000002098,    -0.00000000661,
	  -0.00000002463,     0.00000000076,
	  -0.00000005713,    -0.00000001180,
	  -0.00000001450,     0.00000007022,
	   0.00000000850,     0.00000000200,
	   0.00000001442,     0.00000000011,
	   0.00000000012,    -0.00000001441,
	   0.00000002279,    -0.00000000059,
	   0.00000000010,    -0.00000000273,
	  -0.00000000648,     0.00000000046,
	   0.00000000048,     0.00000000637,
	  -0.00000000107,    -0.00000000015,
	  -0.00000000015,     0.00000000107,
	  -0.00000005412,     0.00000001551,
	   0.00000000001,     0.00000000657,
	   0.00000001023,    -0.00000000685,
	   0.00000000039,    -0.00000000110,
	  -0.00000000684,    -0.00000001009,
	  -0.00000000113,    -0.00000000040,
	   0.00000000007,     0.00000000197,
	   0.00000000448,     0.00000000053,
	   0.00000000055,    -0.00000000454,
	  -0.00000008132,    -0.00000018922,
	  -0.00000000149,    -0.00000002232,
	  -0.00000000210,    -0.00000000046,
	   0.00000009551,     0.00000006046,
	  -0.00000000174,    -0.00000000333,
	   0.00000006046,    -0.00000009577,
	  -0.00000000331,     0.00000000176,
	   0.00000000811,    -0.00000000108,
	  -0.00000000063,    -0.00000000721,
	  -0.00000001692,    -0.00000000149,
	  -0.00000000155,     0.00000001692,
	  -0.00000000131,    -0.00000003414,
	   0.00000000361,    -0.00000000038,
	  -0.00000000195,     0.00000000092,
	   0.00000000091,     0.00000000189,
	   0.00000413314,     0.00000168571,
	  -0.00000003185,    -0.00000018996,
	   0.00000000535,     0.00000008852,
	   0.00000000651,     0.00000000134,
	  -0.00000179639,    -0.00000037945,
	   0.00000001397,     0.00000005553,
	   0.00000000002,    -0.00000000201,
	  -0.00000037878,     0.00000179690,
	   0.00000005562,    -0.00000001394,
	  -0.00000000201,    -0.00000000002,
	  -0.00000000058,    -0.00000000060,
	  -0.00000000056,     0.00000000055,
	  -0.00000002407,     0.00000000360,
	   0.00000000258,     0.00000001896,
	   0.00000000101,     0.00000000028,
	   0.00000004237,     0.00000000242,
	   0.00000000252,    -0.00000004241,
	  -0.00000000491,     0.00000001017,
	  -0.00005894913,    -0.00001128562,
	   0.00000038742,     0.00000190222,
	   0.00000000926,    -0.00000005759,
	   0.00000009419,    -0.00000087316,
	  -0.00000003350,     0.00000000106,
	   0.00001715821,     0.00000093627,
	  -0.00000007906,    -0.00000026882,
	   0.00000000088,     0.00000000798,
	   0.00000092981,    -0.00001714504,
	  -0.00000026832,     0.00000007892,
	   0.00000000793,    -0.00000000089,
	   0.00000000139,    -0.00000000144,
	  -0.00000000157,    -0.00000000129,
	  -0.00000002967,    -0.00000004154,
	   0.00000002206,    -0.00000002955,
	  -0.00000002955,    -0.00000002207,
	   0.00000002743,     0.00000000183,
	   0.00000002859,     0.00000000192,
	  -0.00000000002,     0.00000000208,
	   0.00000000011,    -0.00000000319,
	   0.00000000074,    -0.00000000031,
	   0.00000852844,    -0.00000001907,
	   0.00000001893,     0.00000892049,
	  -0.00000000013,    -0.00000000126,
	  -0.00000000139,     0.00000000000,
	  -0.00000026823,    -0.00000002485,
	   0.00000000110,     0.00000000438,
	   0.00000002348,    -0.00000027467,
	  -0.00000000430,     0.00000000116,
	  -0.00000001205,     0.00000001373,
	   0.00000001422,     0.00000001161,
	   0.00001749732,     0.00000003329,
	  -0.00000001727,    -0.00000313387,
	   0.00000000015,     0.00000000086,
	   0.00000022773,     0.00000001945,
	  -0.00000000098,    -0.00000000359,
	  -0.00000001885,     0.00000022469,
	   0.00000000364,    -0.00000000097,
	  -0.00000000825,     0.00000000056,
	   0.00000000030,     0.00000000893,
	   0.00000000111,     0.00000000000,
	   0.00000000001,     0.00000000113,
	  -0.00000123270,     0.00000021964,
	   0.00000000856,     0.00000005156,
	   0.00000072156,     0.00000000847,
	   0.00000000148,    -0.00000000008,
	  -0.00000000767,     0.00000072379,
	   0.00000000004,     0.00000000146,
	   0.00000002507,    -0.00000002810,
	   0.00000002828,     0.00000002521,
	  -0.00000121686,     0.00000014982,
	   0.00000000121,     0.00000000686,
	   0.00000000449,    -0.00000000067,
	   0.00000000065,     0.00000000482,
	   0.00000000099,    -0.00000000015,
	   0.00000000011,     0.00000000090,
	   0.00000006338,    -0.00000000623,
	   0.00000000008,    -0.00000000267,
	  -0.00000002316,     0.00000000458,
	  -0.00000000460,    -0.00000002318,
	   0.00000000190,    -0.00000000221,
	   0.00000000220,     0.00000000190,
	   0.00000004160,     0.00000000039,
	   0.00000000000,     0.00000000068,
	   0.00000019918,     0.00000000135,
	   0.00000000087,    -0.00000017827,
	  -0.00000000374,    -0.00000000154,
	  -0.00000000377,     0.00000000428,
	   0.00000005183,     0.00000000007,
	   0.00000000011,     0.00000001068,
	   0.00000596929,    -0.00000002114,
	   0.00000000110,     0.00000034601,
	  -0.00000000111,    -0.00000000077,
	   0.00000000001,    -0.00000000678,
	  -0.00000000111,     0.00000000063,
	   0.00000000080,     0.00000000074,
	   0.14818171781,    -0.00003166756,
	  -0.00001089408,     0.00000187707,
	   0.00000016265,     0.00002216235,
	   0.00000002305,    -0.00000002299,
	   0.00000070450,     0.00441710230,
	  -0.00000004095,    -0.00000032360,
	  -0.00000065982,     0.00000000381,
	   0.00000000064,     0.00000000069,
	  -0.00000706534,    -0.00001642288,
	  -0.00000000079,    -0.00000018640,
	   0.00000000310,    -0.00000000282,
	  -0.00000816026,     0.00001465203,
	  -0.00000008010,     0.00000001760,
	  -0.00000000241,    -0.00000000391,
	   0.00001009225,    -0.00000041300,
	  -0.00000038425,    -0.00000031896,
	  -0.00000002024,     0.00000002689,
	   0.00000000098,     0.00000000055,
	  -0.00000041066,    -0.00001008508,
	  -0.00000031924,     0.00000038392,
	   0.00000002690,     0.00000002023,
	   0.00000000055,    -0.00000000098,
	   0.00000000102,    -0.00000000076,
	   0.00000000075,     0.00000000101,
	  -0.00004152784,    -0.00001846775,
	  -0.00000017206,    -0.00000319571,
	   0.00000029008,    -0.00000025663,
	  -0.00000087840,     0.00000137525,
	  -0.00000011706,     0.00000002020,
	  -0.00000000868,    -0.00000001093,
	  -0.00000312644,    -0.00000356683,
	  -0.00000000121,    -0.00000003785,
	   0.00000000098,    -0.00000000066,
	   0.00000356356,    -0.00000312742,
	   0.00000003756,    -0.00000000132,
	   0.00000000066,     0.00000000095,
	   0.00000873391,    -0.00000035552,
	  -0.00000033248,    -0.00000027629,
	  -0.00000001752,     0.00000002327,
	   0.00000000085,     0.00000000048,
	   0.00000035777,     0.00000873359,
	   0.00000027621,    -0.00000033254,
	  -0.00000002327,    -0.00000001752,
	  -0.00000000048,     0.00000000085,
	  -0.00000021909,    -0.00000000052,
	  -0.00000000355,    -0.00000001924,
	  -0.00000000091,     0.00000001271,
	  -0.00000000123,     0.00000000028,
	   0.00000012735,    -0.00000002489,
	  -0.00000000080,     0.00000000410,
	   0.00000002496,     0.00000012742,
	  -0.00000000412,    -0.00000000080,
	  -0.00000002432,     0.00000002989,
	  -0.00000000144,    -0.00000000112,
	  -0.00000002987,    -0.00000002431,
	   0.00000000112,    -0.00000000144,
	  -0.00000013141,    -0.00000036324,
	   0.00000001965,    -0.00000002392,
	  -0.00000000576,     0.00000000063,
	  -0.00000031678,    -0.00000015320,
	  -0.00000000118,    -0.00000002465,
	   0.00000000223,    -0.00000000196,
	   0.00000015320,    -0.00000031679,
	   0.00000002465,    -0.00000000118,
	   0.00000000196,     0.00000000222,
	   0.00000002538,     0.00000002596,
	  -0.00000000002,    -0.00000000148,
	  -0.00000002595,     0.00000002538,
	   0.00000000148,    -0.00000000002,
	   0.00000000013,    -0.00000000121,
	   0.00000002241,     0.00000010028,
	   0.00000004722,    -0.00000002254,
	  -0.00000002655,    -0.00000000243,
	   0.00000000019,    -0.00000000212,
	  -0.00000000081,     0.00000000052,
	  -0.00000000161,    -0.00000000013,
	   0.00000000008,    -0.00000000167,
	  -0.00000073858,     0.00000011310,
	   0.00000008315,     0.00000028650,
	   0.00000005627,    -0.00000002513,
	  -0.00000000077,    -0.00000000513,
	  -0.00000000202,     0.00000000058,
	   0.00000000129,     0.00000000110,
	   0.00000002522,    -0.00000002664,
	  -0.00000001236,    -0.00000001065,
	  -0.00000000085,    -0.00000000689,
	  -0.00000000065,     0.00000000051,
	  -0.00000002616,    -0.00000002174,
	  -0.00000003010,     0.00000000470,
	   0.00000000485,     0.00000000593,
	   0.00000000062,    -0.00000000117,
	  -0.00000000470,    -0.00000003010,
	  -0.00000000593,     0.00000000485,
	   0.00000000117,     0.00000000062,
	  -0.00000000906,     0.00000002114,
	  -0.00000000128,     0.00000000050,
	   0.00000000092,    -0.00000000138,
	  -0.00000000066,    -0.00000000072,
	   0.00000000133,     0.00000000080,
	   0.00000000072,    -0.00000000066,
	   0.00000000020,     0.00000000098,
	  -0.00000000102,     0.00000000022,
	   0.00000003420,     0.00000003530,
	  -0.00000005070,    -0.00000004630,
	   0.00000000350,    -0.00000001240,
	   0.00000001250,     0.00000000340,
	  -0.00000000170,    -0.00000000149,
	   0.00000000197,    -0.00000000031,
	   0.00000000028,     0.00000000196,
	   0.00000000101,    -0.00000000029,
	   0.00000000062,    -0.00000000097,
	  -0.00000000100,    -0.00000000058,
	   0.00000164257,    -0.00000032520,
	  -0.00000022093,    -0.00000060771,
	  -0.00000011299,     0.00000006291,
	   0.00000001088,     0.00000001353,
	  -0.00000001423,    -0.00000007177,
	  -0.00000002655,     0.00000000967,
	   0.00000000274,     0.00000000494,
	   0.00000000062,    -0.00000000050,
	   0.00000001090,    -0.00000000155,
	  -0.00000000119,    -0.00000000433,
	  -0.00000000085,     0.00000000037,
	   0.00000000168,     0.00000001189,
	   0.00000000460,    -0.00000000133,
	  -0.00000000041,    -0.00000000091,
	   0.00000338134,     0.00000235649,
	   0.00000079662,    -0.00000140662,
	  -0.00000030138,    -0.00000013194,
	  -0.00000001213,     0.00000004282,
	   0.00000003315,    -0.00000001821,
	  -0.00000000976,    -0.00000001157,
	  -0.00000000185,     0.00000000233,
	   0.00000371349,    -0.00000057149,
	  -0.00000041994,    -0.00000144074,
	  -0.00000028329,     0.00000012547,
	   0.00000002285,     0.00000003595,
	   0.00000000324,    -0.00000000295,
	   0.00000057106,     0.00000371720,
	   0.00000144101,    -0.00000041978,
	  -0.00000012548,    -0.00000028330,
	  -0.00000003595,     0.00000002286,
	   0.00000000295,     0.00000000324,
	   0.00000000209,    -0.00000000035,
	  -0.00000000024,    -0.00000000081,
	  -0.00000000035,    -0.00000000209,
	  -0.00000000081,     0.00000000024,
	   0.00000002453,    -0.00000000377,
	  -0.00000000381,    -0.00000002526,
	  -0.00000000981,     0.00000000283,
	   0.00000000085,     0.00000000193,
	  -0.00000000103,     0.00000000094,
	   0.00000000094,     0.00000000104,
	   0.00000004962,    -0.00000000773,
	   0.00000000134,     0.00000000913,
	   0.00000000354,    -0.00000000101,
	  -0.00000000031,    -0.00000000070,
	   0.00000000029,     0.00000000079,
	   0.00000000080,    -0.00000000029,
	  -0.00000015877,     0.00000004243,
	   0.00000002696,     0.00000005507,
	   0.00000000181,     0.00000000300,
	   0.00000000095,    -0.00000000072,
	   0.00000004812,    -0.00000000987,
	  -0.00000000656,    -0.00000001776,
	  -0.00000000329,     0.00000000184,
	   0.00000000990,     0.00000004810,
	   0.00000001778,    -0.00000000658,
	  -0.00000000183,    -0.00000000329,
	  -0.00000002985,     0.00000000670,
	   0.00000000889,     0.00000000623,
	   0.00000000054,     0.00000000424,
	  -0.00000005515,    -0.00000000221,
	  -0.00000000023,    -0.00000000644,
	  -0.00000000450,     0.00000000064,
	   0.00000000071,     0.00000000161,
	  -0.00000000064,    -0.00000000448,
	  -0.00000000160,     0.00000000069,
	  -0.00000000698,     0.00000002011,
	  -0.00000000211,    -0.00000000024,
	  -0.00000000492,    -0.00000000028,
	   0.00000000026,    -0.00000000504,
	   0.00000000024,    -0.00000000080,
	   0.00000002126,     0.00000000006,
	   0.00000000012,     0.00000000205,
	  -0.00000000058,     0.00000000178,
	  -0.00000000184,    -0.00000000055,
	  -0.00000000059,     0.00000000052,
	   0.00000000206,     0.00000000001,
	  -0.00000000020,     0.00000000211,
	   0.00000000511,     0.00000001566,
	  -0.00000000769,     0.00000000251,
	  -0.00000000263,    -0.00000000288,
	   0.00000000290,    -0.00000000264,
	  -0.00000000354,     0.00000000023,
	   0.00000000019,     0.00000000347,
	   0.00000006489,    -0.00000002547,
	  -0.00000000467,     0.00000002195,
	   0.00000000160,     0.00000000128,
	   0.00000000949,    -0.00000000138,
	  -0.00000000037,    -0.00000000865,
	  -0.00000110404,    -0.00000021123,
	  -0.00000007252,     0.00000008705,
	   0.00000001177,    -0.00000006537,
	  -0.00000000465,    -0.00000000397,
	  -0.00000003266,    -0.00000000526,
	   0.00000000404,     0.00000000654,
	   0.00000000068,    -0.00000000080,
	   0.00000000622,    -0.00000002982,
	  -0.00000000656,     0.00000000408,
	   0.00000000080,     0.00000000068,
	  -0.00000001212,     0.00000003506,
	   0.00000000935,     0.00000000155,
	   0.00000000232,     0.00000000081,
	  -0.00000000081,    -0.00000000051,
	  -0.00000000048,     0.00000000054,
	   0.00000000015,     0.00000000239,
	   0.00000000170,    -0.00000000034,
	  -0.00000000027,    -0.00000000171,
	  -0.00000008545,    -0.00000000644,
	   0.00000000057,    -0.00000001011,
	  -0.00000000058,    -0.00000000048,
	  -0.00000000163,     0.00000000217,
	  -0.00000000311,    -0.00000000121,
	  -0.00000000169,     0.00000000097,
	  -0.00000000555,    -0.00000002469,
	   0.00000000351,    -0.00000000417,
	  -0.00000000053,     0.00000000073,
	   0.00000000396,     0.00000000368,
	   0.00000000291,    -0.00000000388,
	  -0.00000000109,     0.00000000121,
	  -0.00000003533,     0.00000003928,
	  -0.00000000529,    -0.00000000230,
	  -0.00000001056,    -0.00000000059,
	   0.00000000064,    -0.00000001079,
	  -0.00000000062,    -0.00000000050,
	  -0.00000001389,    -0.00000000140,
	   0.00000000056,    -0.00000001739,
	  -0.00000000069,     0.00000000323,
	   0.00000000227,    -0.00000000101,
	   0.00000010968,     0.00000000506,
	   0.00000000062,     0.00000003143,
	  -0.00000000081,    -0.00000000292,
	  -0.00000000527,     0.00000000949,
	  -0.00000000988,    -0.00000000542,
	  -0.00000000047,    -0.00000000058,
	   0.00000000058,    -0.00000000047,
	   0.00000000044,    -0.00000000085,
	  -0.00000000230,     0.00000000007,
	   0.00000000020,    -0.00000000238,
	  -0.00000001961,     0.00000000503,
	  -0.00000002080,    -0.00000007499,
	   0.00000000269,    -0.00000001790,
	  -0.00000001117,    -0.00000000569,
	   0.00000053859,    -0.00000007269,
	   0.00000006845,     0.00000028004,
	  -0.00000000047,     0.00000000269,
	   0.00000002126,     0.00000002446,
	   0.00000000194,    -0.00000000241,
	   0.00000001169,     0.00000004865,
	   0.00000000233,     0.00000000214,
	   0.00000008091,    -0.00000002806,
	  -0.00000000105,    -0.00000001135,
	   0.00000000115,    -0.00000000053,
	   0.00000000058,     0.00000000145,
	  -0.00000260317,     0.00000063441,
	  -0.00000005386,    -0.00000026732,
	   0.00000000118,    -0.00000000303,
	   0.00000000112,     0.00000000002,
	   0.00000020177,    -0.00000005375,
	   0.00000000454,    -0.00000000925,
	   0.00000005504,     0.00000020163,
	   0.00000000906,     0.00000000464,
	   0.00000000168,     0.00000000103,
	  -0.00000000293,     0.00000000098,
	  -0.00000000055,     0.00000000242,
	  -0.00000002583,    -0.00000000688,
	  -0.00000000469,    -0.00000000258,
	   0.00000000400,     0.00000000079,
	   0.00000000137,     0.00000000027,
	  -0.00000000150,    -0.00000000503,
	  -0.00000000027,     0.00000000137,
	  -0.00000000463,    -0.00000001176,
	   0.00000000934,     0.00000002921,
	  -0.00000000195,    -0.00000000017,
	   0.00000004912,    -0.00000002157,
	  -0.00000000128,    -0.00000000514,
	   0.00000000674,    -0.00000000103,
	   0.00000000087,     0.00000000691,
	   0.00000000280,    -0.00000000305,
	  -0.00000000004,    -0.00000000098,
	  -0.00000000127,    -0.00000000024,
	   0.00000002274,     0.00000000794,
	  -0.00000000734,     0.00000000878,
	   0.00000000037,    -0.00000000087,
	   0.00000000168,    -0.00000000207,
	   0.00000000075,     0.00000000084,
	  -0.00000000131,     0.00000000079,
	   0.00000000142,    -0.00000000055,
	   0.00000000062,     0.00000000144,
	   0.00000000348,     0.00000000369,
	   0.00000000145,     0.00000000001,
	  -0.00000000001,     0.00000000145,
	   0.00000001025,     0.00000005958,
	  -0.00000001173,    -0.00000000931,
	   0.00000000194,    -0.00000000224,
	   0.00000000370,     0.00000000094,
	   0.00000000062,     0.00000000270,
	  -0.00000003315,     0.00000000037,
	  -0.00000000008,    -0.00000000278,
	   0.00000003497,     0.00000005738,
	   0.00000000554,     0.00000000139,
	  -0.00000000083,     0.00000000095,
	   0.00000001595,    -0.00000000017,
	   0.00000000016,     0.00000001596,
	   0.00000000100,    -0.00000000018,
	  -0.00000000013,    -0.00000000102,
	  -0.00000000238,     0.00000000137,
	   0.00000000101,     0.00000000231,
	  -0.00000000097,    -0.00000000050,
	   0.00000000244,    -0.00000000585,
	   0.00000000190,    -0.00000000006,
	  -0.00000000031,    -0.00000000138,
	   0.00000000116,    -0.00000000005,
	  -0.00000000032,    -0.00000000249,
	   0.00000000075,     0.00000000051,
	   0.00000005481,    -0.00000000181,
	   0.00000000078,     0.00000000714,
	   0.00000000049,    -0.00000000139,
	   0.00000000099,    -0.00000000081,
	  -0.00000000019,    -0.00000000239,
	   0.00000000370,     0.00000000774,
	  -0.00000000163,     0.00000000012,
	   0.00000000116,    -0.00000000004,
	   0.00000000011,     0.00000000101,
	   0.00000003782,     0.00000001583,
	   0.00000000062,    -0.00000000083,
	  -0.00000000179,     0.00000000015,
	  -0.00000000009,    -0.00000000161,
	   0.00000000535,    -0.00000004093,
	   0.00000000409,     0.00000000561,
	   0.00000000246,    -0.00000000002,
	  -0.00000001416,    -0.00000001253,
	   0.00000000131,     0.00000000010,
	  -0.00000000088,     0.00000000137,
	   0.00000000095,    -0.00000000046,
	  -0.00000006225,    -0.00000026738,
	   0.00000002870,     0.00000002422,
	   0.00000000505,    -0.00000000115,
	  -0.00000000047,     0.00000000065,
	   0.00000000469,     0.00000000166,
	   0.00000000105,     0.00000000507,
	  -0.00000002883,     0.00000003410,
	   0.00000000076,    -0.00000000056,
	   0.00000000454,     0.00000000937,
	  -0.00000000079,    -0.00000000041,
	  -0.00000000941,     0.00000000450,
	   0.00000000043,    -0.00000000079,
	  -0.00000000262,     0.00000000007,
	  -0.00000000007,    -0.00000000262,
	   0.00000000326,     0.00000000285,
	   0.00000000203,    -0.00000000356,
	  -0.00000000352,    -0.00000000228,
	  -0.00000000154,    -0.00000001909,
	  -0.00000000712,    -0.00000000781,
	  -0.00000000148,     0.00000000170,
	   0.00000000105,    -0.00000000176,
	  -0.00000000181,    -0.00000000104,
	   0.00000000014,     0.00000000217,
	   0.00000000064,    -0.00000000078,
	   0.00000000118,     0.00000000009,
	   0.00000000009,    -0.00000000117,
	  -0.00000000045,    -0.00000000066,
	  -0.00000000064,     0.00000000052,
	   0.00000006026,     0.00000001166,
	  -0.00000000008,    -0.00000000146,
	   0.00000000470,     0.00000000019,
	   0.00000000019,    -0.00000000481,
	   0.00000001598,     0.00000000557,
	   0.00000001066,    -0.00000000895,
	  -0.00000000063,     0.00000000712,
	  -0.00000000332,     0.00000000427,
	   0.00000000409,     0.00000000374,
	  -0.00000002776,    -0.00000000290,
	   0.00000001327,     0.00000000257,
	  -0.00000000056,     0.00000000072,
	   0.00000000101,     0.00000000010,
	   0.00000000967,     0.00000016353,
	  -0.00000001511,    -0.00000001218,
	  -0.00000000107,     0.00000000081,
	   0.00000000295,    -0.00000000238,
	  -0.00000000226,     0.00000000139,
	   0.00000006175,    -0.00000000094,
	  -0.00000002390,     0.00000027693,
	  -0.00000002859,    -0.00000003633,
	  -0.00000001000,    -0.00000000101,
	   0.00000000131,    -0.00000000106,
	  -0.00000000068,    -0.00000000115,
	   0.00000000158,    -0.00000000068,
	  -0.00000000871,     0.00000001913,
	   0.00000000181,    -0.00000000502,
	  -0.00000000503,    -0.00000000180,
	   0.00000005606,    -0.00000015541,
	  -0.00000001931,     0.00000000699,
	   0.00000000288,     0.00000000102,
	  -0.00000001850,     0.00000001946,
	   0.00000000336,     0.00000000096,
	   0.00000001938,     0.00000001847,
	   0.00000000095,    -0.00000000333,
	  -0.00000046680,     0.00000076102,
	   0.00000010941,     0.00000000434,
	  -0.00000003455,    -0.00000002382,
	  -0.00000000039,     0.00000000545,
	   0.00000000409,     0.00000001949,
	   0.00000000156,    -0.00000000149,
	   0.00000002037,    -0.00000000368,
	  -0.00000000152,    -0.00000000169,
	  -0.00000001197,     0.00000004364,
	   0.00000000082,    -0.00000000100,
	  -0.00000000094,    -0.00000000083,
	  -0.00000000873,    -0.00000000584,
	   0.00000000145,    -0.00000000281,
	   0.00000000219,    -0.00000000086,
	  -0.00000000125,    -0.00000000239,
	  -0.00000015997,     0.00000021386,
	   0.00000001260,    -0.00000001448,
	  -0.00000003463,     0.00000001790,
	   0.00000000261,     0.00000000268,
	   0.00000000140,    -0.00000000117,
	   0.00000000118,    -0.00000000029,
	  -0.00000001276,     0.00000000090,
	   0.00000000009,     0.00000000128,
	  -0.00000125792,     0.00000006759,
	   0.00000000509,    -0.00000001965,
	   0.00000000033,     0.00000001125,
	   0.00000000041,     0.00000000238,
	  -0.00000000174,     0.00000000136,
	  -0.00000002011,     0.00000001609,
	  -0.00000000731,     0.00000000044,
	  -0.00000000040,    -0.00000000728,
	   0.00000008640,     0.00000001041,
	  -0.00000000840,     0.00000001634,
	   0.00000000097,    -0.00000000084,
	  -0.00000000082,    -0.00000000095,
	   0.00000003289,    -0.00000002527,
	   0.00000000189,     0.00000000193,
	  -0.00000005980,     0.00000000647,
	   0.00000000025,     0.00000000155,
	   0.00000004505,     0.00000005433,
	   0.00000000055,     0.00000000109,
	   0.00000000001,    -0.00000000104,
	  -0.00000000096,    -0.00000000014,
	   0.00000000826,    -0.00000000679,
	  -0.00000000136,    -0.00000000237,
	  -0.00000000058,     0.00000000425,
	   0.00000000447,     0.00000000017,
	   0.00000019095,    -0.00000002198,
	   0.00000000017,     0.00000000114,
	   0.00000000145,    -0.00000006640,
	   0.00000001295,    -0.00000000774,
	  -0.00000002045,    -0.00000000205,
	   0.00000000489,     0.00000002551,
	   0.00000010294,    -0.00000000523,
	   0.00000000053,    -0.00000000678,
	  -0.00000000256,    -0.00000000023,
	  -0.00000000249,     0.00000003033,
	   0.00000000576,     0.00000000048,
	  -0.00000000011,     0.00000000122,
	  -0.00000010503,    -0.00000000854,
	  -0.00000000645,     0.00000007936,
	   0.00000002158,    -0.00000000105,
	  -0.00000000105,    -0.00000002116,
	   0.00000005035,    -0.00000000629,
	  -0.00000000019,    -0.00000000645,
	  -0.00000000905,     0.00000000230,
	   0.00000000229,     0.00000000907,
	   0.00000002823,    -0.00000000151,
	  -0.00000000190,    -0.00000000015,
	  -0.00000000016,     0.00000000199,
	  -0.00000005621,     0.00000006177,
	   0.00000000148,     0.00000001368,
	   0.00000000111,     0.00000000036,
	  -0.00000001210,    -0.00000001313,
	  -0.00000001306,     0.00000001233,
	   0.00000005326,    -0.00000000291,
	   0.00000000046,     0.00000000335,
	   0.00000000614,     0.00000000031,
	   0.00000000034,    -0.00000000612,
	  -0.00000101988,    -0.00000043661,
	   0.00000001598,     0.00000001868,
	  -0.00000000648,    -0.00000003513,
	  -0.00000000221,    -0.00000000096,
	   0.00000035359,     0.00000004272,
	  -0.00000000085,    -0.00000000481,
	   0.00000004243,    -0.00000035408,
	  -0.00000000485,     0.00000000084,
	   0.00000000809,    -0.00000000218,
	  -0.00000000196,    -0.00000000726,
	  -0.00000001005,    -0.00000000043,
	  -0.00000000048,     0.00000001014,
	   0.00000004159,    -0.00000006983,
	  -0.00000001051,     0.00000000073,
	   0.00000000672,     0.00000000374,
	  -0.00000000358,    -0.00000000213,
	  -0.00000000188,     0.00000000335,
	   0.00001602878,     0.00000193045,
	  -0.00000004048,    -0.00000022917,
	   0.00000000983,     0.00000009886,
	   0.00000000308,     0.00000000181,
	  -0.00000233145,     0.00000016929,
	  -0.00000002577,     0.00000000267,
	   0.00000000112,    -0.00000000012,
	   0.00000017128,     0.00000232872,
	   0.00000000266,     0.00000002585,
	  -0.00000000013,    -0.00000000109,
	   0.00000003877,     0.00000001402,
	   0.00000000027,    -0.00000000103,
	   0.00000001404,    -0.00000000629,
	  -0.00000000470,    -0.00000000903,
	  -0.00000004230,     0.00000000237,
	   0.00000000232,     0.00000004150,
	  -0.00000000535,    -0.00000000979,
	  -0.00013070739,     0.00000425429,
	  -0.00000073855,    -0.00000000426,
	   0.00000002851,    -0.00000001607,
	   0.00000000926,    -0.00000149529,
	   0.00000000579,    -0.00000000424,
	  -0.00001776005,     0.00000101233,
	   0.00000008183,    -0.00000027938,
	  -0.00000000118,     0.00000000358,
	   0.00000099918,     0.00001785380,
	  -0.00000027807,    -0.00000008228,
	   0.00000000352,     0.00000000120,
	   0.00000000387,    -0.00000000457,
	  -0.00000000467,    -0.00000000392,
	  -0.00000316686,     0.00000000850,
	  -0.00000000001,     0.00000003299,
	  -0.00000000416,    -0.00000000123,
	  -0.00000000119,     0.00000000480,
	  -0.00000002850,     0.00000000190,
	  -0.00000002930,     0.00000000193,
	  -0.00000000686,     0.00000000055,
	   0.00000000047,     0.00000000657,
	   0.00000000127,     0.00000000008,
	   0.00000000007,     0.00000000181,
	  -0.00061824399,     0.00003456915,
	   0.00000287998,    -0.00000967896,
	  -0.00000004278,     0.00000011825,
	  -0.00000144282,    -0.00002588154,
	   0.00000040484,     0.00000012132,
	  -0.00000000496,    -0.00000000182,
	  -0.00000144627,     0.00000010621,
	   0.00000000122,    -0.00000001835,
	   0.00000008439,    -0.00000033649,
	  -0.00000001825,    -0.00000000530,
	   0.00000002482,    -0.00000003677,
	   0.00000000199,     0.00000000146,
	  -0.00000003708,    -0.00000002478,
	   0.00000000147,    -0.00000000199,
	   0.00002841345,     0.00000165942,
	  -0.00000008254,     0.00000045062,
	  -0.00000002037,     0.00000033808,
	  -0.00000000561,    -0.00000000108,
	   0.00000054288,     0.00000007612,
	  -0.00000000599,     0.00000001840,
	   0.00000007812,    -0.00000068150,
	   0.00000001840,     0.00000000604,
	   0.00000000113,     0.00000000008,
	   0.00000000003,    -0.00000000102,
	   0.00000000186,    -0.00000002270,
	  -0.00000027145,     0.00000002464,
	   0.00000000116,    -0.00000000431,
	  -0.00000002433,    -0.00000027149,
	   0.00000000434,     0.00000000117,
	  -0.00000001183,     0.00000001398,
	  -0.00000001375,    -0.00000001142,
	   0.00000023526,     0.00000002277,
	  -0.00000000026,    -0.00000000685,
	   0.00000023639,    -0.00000001971,
	  -0.00000000102,     0.00000000376,
	   0.00000001974,     0.00000023674,
	  -0.00000000377,    -0.00000000103,
	  -0.00000000888,     0.00000000049,
	  -0.00000000051,    -0.00000000882,
	  -0.00000000646,     0.00000000079,
	  -0.00000000079,    -0.00000000645,
	   0.00000000069,    -0.00000000118,
	   0.00000000118,     0.00000000069,
	  -0.00000000143,    -0.00000000420,
	   0.00000000420,    -0.00000000143,
	   0.00000104352,     0.00000196894,
	  -0.00000010903,     0.00000004069,
	  -0.00000000119,    -0.00000000259,
	   0.00000149540,     0.00000705217,
	  -0.00000019722,     0.00000004026,
	  -0.00000000106,    -0.00000000239,
	  -0.00000707661,     0.00000146249,
	  -0.00000004201,    -0.00000019846,
	   0.00000000243,    -0.00000000114,
	   0.00000029419,     0.00000026642,
	   0.00000000764,    -0.00000000919,
	   0.00000000003,    -0.00000000019,
	  -0.00000028764,     0.00000037243,
	   0.00000000699,     0.00000000685,
	   0.00000000026,    -0.00000000003,
	   0.00000015054,    -0.00000023605,
	   0.00000003516,    -0.00000001053,
	   0.00000000063,     0.00000000060,
	  -0.00000088513,     0.00000035686,
	   0.00000001884,    -0.00000005490,
	   0.00000000112,     0.00000000099,
	  -0.00000035443,    -0.00000088583,
	   0.00000005558,     0.00000001873,
	  -0.00000000099,     0.00000000111,
	   0.00000016809,     0.00000034128,
	   0.00000003197,    -0.00000000327,
	   0.00000000007,    -0.00000000159,
	  -0.00000033678,     0.00000016786,
	   0.00000000361,     0.00000003205,
	   0.00000000160,     0.00000000006,
	   0.00000008930,    -0.00000036456,
	   0.00000004861,    -0.00000002736,
	   0.00000000241,     0.00000000169,
	  -0.00000164641,     0.00000224569,
	  -0.00000015227,    -0.00000014580,
	   0.00000000533,    -0.00000000659,
	  -0.00000224892,    -0.00000165098,
	   0.00000014680,    -0.00000015315,
	   0.00000000666,     0.00000000537,
	   0.00000006807,    -0.00000036399,
	  -0.00000002602,     0.00000001087,
	   0.00000000096,     0.00000000088,
	   0.00000036041,     0.00000006684,
	  -0.00000001089,    -0.00000002624,
	  -0.00000000086,     0.00000000094,
	  -0.00000252652,    -0.00000211648,
	   0.00000028970,    -0.00000048484,
	   0.00000003967,     0.00000002284,
	   0.00002273842,    -0.00001240093,
	   0.00000106641,     0.00000175561,
	  -0.00000007029,     0.00000004502,
	   0.00001238631,     0.00002277210,
	  -0.00000175946,     0.00000106556,
	  -0.00000004513,    -0.00000007055,
	   0.00000085966,     0.00000005255,
	   0.00000003323,    -0.00000005678,
	  -0.00000000173,    -0.00000000245,
	  -0.00000007460,     0.00000084544,
	   0.00000005746,     0.00000003028,
	   0.00000000258,    -0.00000000173,
	  -0.00000212973,    -0.00000532872,
	   0.00000141350,    -0.00000025992,
	   0.00000000593,     0.00000021095,
	  -0.00000001794,    -0.00000000322,
	  -0.00000205958,     0.00000084938,
	  -0.00000011091,    -0.00000052849,
	   0.00000008013,    -0.00000000590,
	  -0.00000000075,     0.00000000671,
	   0.00000086047,    -0.00000018099,
	  -0.00000004153,     0.00000029184,
	  -0.00000005411,    -0.00000001887,
	   0.00000000346,    -0.00000000686,
	   0.00000036732,    -0.00000050990,
	   0.00000023681,     0.00000010514,
	  -0.00000002257,     0.00000005068,
	  -0.00000000673,    -0.00000000362,
	   0.00000021432,    -0.00000029418,
	  -0.00000004010,    -0.00000002985,
	  -0.00000000145,     0.00000000225,
	   0.00000029096,     0.00000022139,
	   0.00000002892,    -0.00000004048,
	  -0.00000000223,    -0.00000000160,
	   0.00001208759,     0.00002787314,
	  -0.00000791765,     0.00000155130,
	  -0.00000002160,    -0.00000112436,
	   0.00000010067,     0.00000001795,
	   0.00001238609,     0.00000031176,
	  -0.00000027085,     0.00000221119,
	  -0.00000028997,    -0.00000002820,
	   0.00000000405,    -0.00000002421,
	   0.00008705486,     0.00002324658,
	   0.00000244653,     0.00000295819,
	   0.00000001806,     0.00000030372,
	  -0.00000002491,     0.00000002093,
	  -0.00000000251,    -0.00000000200,
	  -0.00002412000,     0.00009312439,
	  -0.00000529732,     0.00000178456,
	  -0.00000012024,    -0.00000044398,
	   0.00000003904,     0.00000000616,
	  -0.00000000158,     0.00000000327,
	  -0.00000052786,     0.00000073883,
	   0.00000010065,     0.00000006926,
	   0.00000000330,    -0.00000000633,
	  -0.00000077494,    -0.00000052663,
	  -0.00000006399,     0.00000010120,
	   0.00000000635,     0.00000000354,
	   0.00000035886,     0.00000032726,
	   0.00000002257,     0.00000007096,
	  -0.00000117541,     0.00000916940,
	  -0.00000052013,     0.00000019073,
	  -0.00000002335,    -0.00000002554,
	   0.00000000118,    -0.00000000112,
	   0.00012898692,     0.00003288876,
	   0.00000308734,     0.00000595344,
	  -0.00000030968,     0.00000030802,
	  -0.00000001343,    -0.00000001319,
	  -0.00003291435,     0.00012902526,
	  -0.00000596102,     0.00000308827,
	  -0.00000030839,    -0.00000031042,
	   0.00000001323,    -0.00000001348,
	  -0.00000001030,    -0.00000000217,
	  -0.00000000170,    -0.00000000087,
	   0.00000002773,     0.00000001732,
	  -0.00000000075,     0.00000000148,
	   0.00000207013,     0.00000111977,
	   0.00000006551,     0.00000024101,
	   0.00000199271,    -0.00000104035,
	   0.00000012602,     0.00000004257,
	   0.00000000027,     0.00000000856,
	   0.00016147141,     0.00004115275,
	   0.00000387034,     0.00000745837,
	  -0.00000038781,     0.00000038598,
	  -0.00000001683,    -0.00000001652,
	   0.00000000060,    -0.00000000041,
	  -0.00004120135,     0.00016154183,
	  -0.00000746762,     0.00000386934,
	  -0.00000038655,    -0.00000038895,
	   0.00000001658,    -0.00000001690,
	   0.00000000042,     0.00000000060,
	  -0.00000002547,    -0.00000000103,
	   0.00000000068,     0.00000000051,
	  -0.00000000969,    -0.00000001931,
	  -0.00000000061,     0.00000000061,
	   0.00000000057,     0.00000000022,
	  -0.00000000002,     0.00000000001,
	   0.00000000143,    -0.00000000380,
	   0.00000000007,     0.00000000015,
	   0.00000000839,    -0.00000000581,
	   0.00000000012,     0.00000000049,
	   0.00000000563,     0.00000000832,
	  -0.00000000047,     0.00000000010,
	   0.00000000158,    -0.00000000270,
	   0.00000000275,     0.00000000157,
	   0.00000000108,    -0.00000000157,
	   0.00000000157,     0.00000000108,
	  -0.00000000002,     0.00000000000,
	  -0.00000000009,    -0.00000000043,
	   0.00000000002,     0.00000000011,
	   0.00000000012,    -0.00000000002,
	   0.00000000000,    -0.00000000002,
	  -0.00000000048,     0.00000000010,
	   0.00000000001,    -0.00000000004,
	  -0.00000000004,    -0.00000000001,
	   0.00000000000,     0.00000000002,
	   0.00000000131,     0.00000000026,
	   0.00000000000,    -0.00000000007,
	   0.00000000015,     0.00000000000,
	   0.00000000000,    -0.00000000016,
	   0.00000000000,    -0.00000000005,
	  -0.00000000005,    -0.00000000001,
	   0.00000000000,     0.00000000004,
	   0.00000000011,     0.00000000000,
	   0.00000000026,     0.00000000016,
	  -0.00000000016,     0.00000000026,
	   0.00000000009,     0.00000000007,
	  -0.00000000007,     0.00000000009,
	   0.00000000001,    -0.00000000005,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000001,     0.00000000005,
	   0.00000000255,     0.00000000055,
	   0.00000000001,    -0.00000000009,
	   0.00000000016,    -0.00000000003,
	   0.00000000003,    -0.00000000028,
	   0.00000000001,    -0.00000000027,
	  -0.00000000003,     0.00000000005,
	  -0.00000000023,    -0.00000000022,
	  -0.00000000002,     0.00000000004,
	   0.00000000002,    -0.00000000003,
	  -0.00000000008,     0.00000000013,
	  -0.00000000001,     0.00000000004,
	   0.00000000005,     0.00000000001,
	   0.00000000010,     0.00000000003,
	   0.00000000005,    -0.00000000002,
	  -0.00000000005,    -0.00000000001,
	  -0.00000000017,     0.00000000010,
	   0.00000000003,     0.00000000002,
	   0.00000000032,    -0.00000000022,
	  -0.00000000509,    -0.00000000399,
	  -0.00000000028,    -0.00000000087,
	   0.00000000401,    -0.00000000505,
	   0.00000000087,    -0.00000000028,
	   0.00000000047,     0.00000000113,
	  -0.00000000113,     0.00000000047,
	  -0.00000000083,    -0.00000000173,
	   0.00000000173,    -0.00000000083,
	   0.00000000030,     0.00000000137,
	  -0.00000000137,     0.00000000030,
	   0.00000000000,    -0.00000000133,
	  -0.00000000001,    -0.00000000141,
	   0.00000000009,    -0.00000000051,
	   0.00000000176,     0.00000000000,
	   0.00000000000,     0.00000000176,
	  -0.00000000042,     0.00000000011,
	  -0.00000000148,     0.00000000000,
	   0.00000000000,    -0.00000000147,
	   0.00000000155,    -0.00000000013,
	  -0.00000000116,    -0.00000000174,
	  -0.00000000022,     0.00000000019,
	   0.00000000221,    -0.00000000147,
	  -0.00000000025,    -0.00000000028,
	   0.00000000113,     0.00000000060,
	  -0.00000000126,     0.00000000229,
	  -0.00000000131,    -0.00000000115,
	   0.00000000114,    -0.00000000021,
	   0.00000000084,    -0.00000000004,
	  -0.00000000005,     0.00000000220,
	  -0.00000000039,    -0.00000000026,
	   0.00000000025,    -0.00000000083,
	   0.00000000027,     0.00000000051,
	   0.00000008948,     0.00000002298,
	   0.00000000027,    -0.00000000104,
	   0.00000000103,     0.00000000026,
	  -0.00000000026,     0.00000000102,
	   0.00000000157,     0.00000000040,
	  -0.00000000040,     0.00000000157,
	   0.00000000000,    -0.00000000136,
	   0.00000000086,     0.00000000000,
	   0.00000000000,     0.00000000322,
	   0.00000000111,     0.00000000080,
	   0.00000000084,     0.00000000000,
	   0.00000000000,     0.00000000084,
	  -0.00000000057,    -0.00000000042,
	  -0.00000000124,     0.00000000000,
	   0.00000000000,    -0.00000000124,
	   0.00000000029,    -0.00000000024,
	  -0.00000000121,     0.00000000103,
	  -0.00000000058,    -0.00000000027,
	  -0.00000000026,     0.00000000057,
	  -0.00000000065,     0.00000000000,
	   0.00000000000,     0.00000000064,
	   0.00000000057,     0.00000000000,
	   0.00000000000,    -0.00000000057,
	   0.00000000385,     0.00000000007,
	   0.00000000498,    -0.00000029223,
	  -0.00000000029,     0.00000000037,
	  -0.00000000106,     0.00000000320,
	   0.00000000086,     0.00000000111,
	  -0.00000000003,     0.00000000065,
	  -0.00000000603,    -0.00000000011,
	  -0.00000000366,     0.00000020239,
	   0.00000000083,    -0.00000000360,
	   0.00000000030,    -0.00000000092,
	  -0.00000000078,     0.00000000000,
	   0.00000000000,     0.00000000078,
	   0.00000000081,    -0.00000000002,
	   0.00000000071,     0.00000000000,
	   0.00000000000,    -0.00000000071,
	   0.00000000000,    -0.00000000206,
	   0.00000000000,     0.00000000114,
	  -0.00000000075,     0.00000000004,
	   0.00000000080,     0.00000000000,
	   0.00000000000,    -0.00000000080,
	   0.00000000082,    -0.00000000003,
	  -0.00000000074,     0.00000000000,
	   0.00000000000,     0.00000000074,
	   0.00000000000,    -0.00000000117,
	   0.00000000000,     0.00000000113,
	  -0.00000000024,     0.00000000229,
	   0.00000000002,     0.00000000068,
	   0.00000000067,    -0.00000000002,
	   0.00000000028,    -0.00000000162,
	  -0.00000000002,    -0.00000000061,
	  -0.00000000061,     0.00000000002,
	   0.00000000054,     0.00000000000,
	   0.00000000000,    -0.00000000054,
	   0.00000000037,    -0.00000000033,
	  -0.00000000101,    -0.00000000123,
	   0.00000000288,    -0.00000000182,
	  -0.00000001395,    -0.00000000443,
	  -0.00000000083,    -0.00000000186,
	   0.00000000441,    -0.00000001393,
	   0.00000000186,    -0.00000000080,
	   0.00000000008,    -0.00000000242,
	   0.00000000241,     0.00000000009,
	  -0.00000000104,    -0.00000000065,
	   0.00000000065,    -0.00000000104,
	   0.00000000033,    -0.00000000072,
	   0.00000000072,     0.00000000033,
	  -0.00000000198,    -0.00000000190,
	   0.00000000311,    -0.00000000365,
	  -0.00000000122,     0.00000000019,
	  -0.00000000048,    -0.00000000835,
	  -0.00000000079,    -0.00000000157,
	   0.00000000089,    -0.00000000201,
	  -0.00000000060,    -0.00000000135,
	  -0.00000000110,     0.00000000000,
	   0.00000000000,    -0.00000000111,
	  -0.00000000148,     0.00000000107,
	   0.00000000917,     0.00000001409,
	  -0.00000000102,     0.00000000068,
	   0.00000000885,    -0.00000000002,
	   0.00000000019,     0.00000000889,
	   0.00000009508,     0.00000002439,
	   0.00000000028,    -0.00000000107,
	   0.00000000103,     0.00000000026,
	  -0.00000000026,     0.00000000102,
	   0.00000000157,     0.00000000040,
	  -0.00000000040,     0.00000000157,
	   0.00000000090,    -0.00000000163,
	   0.00000000134,    -0.00000000083,
	  -0.00000000161,    -0.00000000088,
	   0.00000000275,    -0.00000000498,
	  -0.00000000040,    -0.00000000024,
	   0.00000000182,    -0.00000000038,
	   0.00000000036,    -0.00000000229,
	   0.00000000191,    -0.00000000002,
	  -0.00000000069,    -0.00000007059,
	   0.00000000066,    -0.00000000096,
	  -0.00000000036,    -0.00000000176,
	  -0.00000004293,     0.00000000040,
	   0.00000000462,     0.00000055402,
	  -0.00000000035,     0.00000000186,
	   0.00000000481,     0.00000001682,
	   0.00000000021,    -0.00000000230,
	  -0.00000000193,     0.00000002950,
	   0.00000000034,     0.00000000144,
	  -0.00000000123,     0.00000000068,
	   0.00000000144,     0.00000000266,
	  -0.00000000053,     0.00000000001,
	  -0.00000000001,    -0.00000000053,
	   0.00000000020,     0.00000000032,
	   0.00000000032,    -0.00000000020,
	   0.00000000143,    -0.00000000088,
	   0.00000000080,     0.00000000045,
	   0.00000000043,    -0.00000000080,
	  -0.00000000224,    -0.00000000123,
	  -0.00000000011,     0.00000000016,
	   0.00000008423,    -0.00000015319,
	  -0.00000001130,    -0.00000000783,
	  -0.00000000352,     0.00000000000,
	  -0.00000000001,     0.00000000355,
	   0.00000005254,     0.00000002891,
	   0.00000000269,    -0.00000000389,
	  -0.00000069325,     0.00000126118,
	   0.00000009325,     0.00000006447,
	   0.00000003563,    -0.00000001109,
	  -0.00000000160,     0.00000000106,
	   0.00000000998,    -0.00000004944,
	  -0.00000000084,    -0.00000000188,
	   0.00000000021,    -0.00000000051,
	  -0.00000000027,     0.00000000038,
	   0.00000000000,    -0.00000000067,
	  -0.00000000300,    -0.00000000001,
	  -0.00000000002,     0.00000000599,
	  -0.00000000122,     0.00000000029,
	   0.00000000071,     0.00000000029,
	  -0.00000000071,     0.00000000039,
	   0.00000000055,     0.00000000100,
	   0.00000000028,     0.00000000046,
	   0.00000000045,    -0.00000000029,
	   0.00000000488,    -0.00000000300,
	  -0.00000000046,    -0.00000000086,
	  -0.00000000039,    -0.00000000022,
	  -0.00000000020,     0.00000000039,
	   0.00000000459,     0.00000000736,
	   0.00000000122,    -0.00000000063,
	  -0.00000004294,     0.00000002692,
	   0.00000000365,     0.00000000710,
	   0.00000000698,     0.00000000253,
	   0.00000000005,    -0.00000000049,
	   0.00000000502,    -0.00000000711,
	  -0.00000000044,    -0.00000000063,
	   0.00000000023,    -0.00000000043,
	  -0.00000000182,     0.00000000008,
	   0.00000000192,     0.00000000270,
	   0.00000000036,     0.00000000026,
	  -0.00000000206,    -0.00000000038,
	  -0.00000000013,     0.00000000181,
	  -0.00000000215,    -0.00000000044,
	  -0.00000000055,     0.00000000248,
	   0.00000000082,    -0.00000000005,
	   0.00000000017,     0.00000000256,
	   0.00000000061,     0.00000000002,
	  -0.00000000865,     0.00000000062,
	  -0.00000000005,     0.00000000200,
	   0.00000000132,     0.00000000181,
	   0.00000000214,    -0.00000000116,
	  -0.00000000012,    -0.00000000041,
	   0.00000000033,    -0.00000000020,
	  -0.00000000097,    -0.00000000154,
	  -0.00000000283,     0.00000000177,
	   0.00000000025,     0.00000000052,
	  -0.00000000153,    -0.00000000090,
	  -0.00000000079,     0.00000000153,
	  -0.00000000137,    -0.00000000076,
	  -0.00000000080,     0.00000000144,
	  -0.00000000096,    -0.00000000006,
	   0.00000000007,     0.00000000098,
	  -0.00000000119,    -0.00000000001,
	   0.00000000000,     0.00000000130,
	   0.00000000034,     0.00000000017,
	  -0.00000000035,     0.00000000072,
	   0.00000000025,     0.00000000015,
	  -0.00000000139,    -0.00000000066,
	  -0.00000000037,     0.00000000059,
	   0.00000000003,     0.00000000087,
	   0.00000000086,    -0.00000000006,
	  -0.00000000006,    -0.00000000122,
	  -0.00000000273,     0.00000000013,
	   0.00000000000,     0.00000000062,
	  -0.00000000052,    -0.00000000088,
	  -0.00000000083,     0.00000000055,
	  -0.00000000046,    -0.00000000073,
	  -0.00000000092,     0.00000000057,
	  -0.00000000060,    -0.00000000037,
	  -0.00000000029,     0.00000000060,
	  -0.00000000083,    -0.00000000046,
	  -0.00000000041,     0.00000000074,
	  -0.00000000086,    -0.00000000001,
	  -0.00000000001,     0.00000000080,
	  -0.00000000030,    -0.00000000043,
	  -0.00000000022,     0.00000000044,
	   0.00000000044,     0.00000000021,
	   0.00000000032,    -0.00000000065,
	  -0.00000000171,    -0.00000000084,
	  -0.00000000028,     0.00000000045,
	  -0.00000000002,    -0.00000000075,
	  -0.00000000073,     0.00000000006,
	  -0.00000000004,    -0.00000000074,
	  -0.00000000049,     0.00000000003,
	  -0.00000000021,    -0.00000000036,
	  -0.00000000033,     0.00000000023,
	  -0.00000000059,     0.00000000036,
	  -0.00000000038,    -0.00000000025,
	  -0.00000000017,     0.00000000038,
	  -0.00000000056,    -0.00000000032,
	  -0.00000000023,     0.00000000042,
	   0.00000000014,    -0.00000000026,
	  -0.00000000026,     0.00000000061,
	   0.00000000033,     0.00000000017,
	  -0.00000000078,    -0.00000000111,
	  -0.00000000050,     0.00000000032,
	   0.00000000023,    -0.00000000044,
	  -0.00000000044,    -0.00000000020,
	  -0.00000000036,     0.00000000022,
	  -0.00000000013,    -0.00000000133,
	  -0.00000000068,     0.00000000002,
	  -0.00000000016,     0.00000000037,
	   0.00000000071,    -0.00000000168,
	  -0.00000000105,    -0.00000000053,
	   0.00000000047,    -0.00000000004,
	  -0.00000000006,    -0.00000000046,
	  -0.00000003151,     0.00000002496,
	   0.00000001598,     0.00000002419,
	  -0.00000000035,    -0.00000000016,
	   0.00000000123,     0.00000000156,
	   0.00000000115,    -0.00000000076,
	   0.00000024423,    -0.00000019344,
	  -0.00000012364,    -0.00000018711,
	   0.00000000238,     0.00000000108,
	   0.00000000067,    -0.00000000137,
	   0.00000000098,    -0.00000000237,
	  -0.00000000140,    -0.00000000072,
	  -0.00000000991,     0.00000000570,
	  -0.00000000210,    -0.00000000128,
	   0.00000000008,    -0.00000000029,
	   0.00000000726,     0.00000001403,
	  -0.00000000175,     0.00000000290,
	  -0.00000000045,    -0.00000000010,
	  -0.00000006064,     0.00000005656,
	  -0.00000001369,    -0.00000000773,
	   0.00000000068,    -0.00000000108,
	  -0.00000005685,    -0.00000006062,
	   0.00000000770,    -0.00000001381,
	   0.00000000109,     0.00000000067,
	  -0.00000000855,     0.00000001151,
	  -0.00000001153,    -0.00000000853,
	  -0.00000000131,     0.00000000103,
	  -0.00000000037,    -0.00000000015,
	  -0.00000000104,    -0.00000000131,
	   0.00000000015,    -0.00000000037,
	   0.00000000009,     0.00000000052,
	  -0.00000000052,     0.00000000009,
	  -0.00000001791,    -0.00000000716,
	   0.00000000041,    -0.00000000102,
	   0.00000000745,    -0.00000001765,
	   0.00000000106,     0.00000000048,
	   0.00000002797,     0.00000001065,
	  -0.00000000057,     0.00000000168,
	   0.00000000075,     0.00000000029,
	   0.00000000060,     0.00000000071,
	  -0.00000003431,    -0.00000001157,
	   0.00000000066,    -0.00000000198,
	  -0.00000000085,    -0.00000000019,
	   0.00000000131,     0.00000000055,
	  -0.00000000029,     0.00000000096,
	   0.00000001841,     0.00000001173,
	  -0.00000000068,     0.00000000100,
	  -0.00000000147,    -0.00000000054,
	   0.00000000039,    -0.00000000137,
	   0.00000000077,     0.00000000051,
	  -0.00000000045,     0.00000000075,
	   0.00000001206,    -0.00000003190,
	   0.00000000196,     0.00000000080,
	   0.00000000016,    -0.00000000101,
	   0.00000000038,    -0.00000000095,
	   0.00000005817,     0.00000001611,
	   0.00000000756,    -0.00000002553,
	  -0.00000000086,     0.00000000355,
	   0.00000000154,     0.00000000041,
	  -0.00000000008,    -0.00000000152,
	   0.00000000112,     0.00000000125,
	   0.00000000041,    -0.00000000064,
	  -0.00000000023,     0.00000000085,
	  -0.00000006484,    -0.00000001811,
	  -0.00000000429,     0.00000002776,
	   0.00000000105,    -0.00000000378,
	  -0.00000000161,    -0.00000000025,
	   0.00000000270,     0.00000000084,
	   0.00000000035,    -0.00000000119,
	  -0.00000000043,     0.00000000209,
	   0.00000000090,     0.00000000025,
	   0.00000003274,     0.00000001886,
	   0.00000000430,    -0.00000001516,
	  -0.00000000111,     0.00000000180,
	   0.00000000084,     0.00000000025,
	  -0.00000000278,    -0.00000000084,
	  -0.00000000020,     0.00000000120,
	   0.00000000062,    -0.00000000261,
	  -0.00000000110,    -0.00000000014,
	  -0.00000000999,    -0.00000001092,
	   0.00000000137,     0.00000000082,
	  -0.00000000074,     0.00000000134,
	  -0.00000000079,    -0.00000000028,
	   0.00000001911,    -0.00000005636,
	  -0.00000002904,    -0.00000000247,
	   0.00000000352,     0.00000000131,
	   0.00000000020,    -0.00000000181,
	   0.00000000055,    -0.00000000177,
	  -0.00000000088,    -0.00000000017,
	  -0.00000001279,    -0.00000000245,
	   0.00000000025,    -0.00000000169,
	   0.00000011896,     0.00000002267,
	   0.00000000937,    -0.00000005119,
	  -0.00000000118,     0.00000000737,
	   0.00000000314,     0.00000000049,
	  -0.00000000023,    -0.00000000266,
	  -0.00000000128,     0.00000000035,
	   0.00000000206,     0.00000000219,
	   0.00000000068,    -0.00000000116,
	   0.00000001181,     0.00000000259,
	  -0.00000000035,     0.00000000159,
	  -0.00000012075,    -0.00000002706,
	  -0.00000000472,     0.00000005111,
	   0.00000000162,    -0.00000000714,
	  -0.00000000301,    -0.00000000028,
	   0.00000000546,     0.00000000121,
	   0.00000000045,    -0.00000000237,
	  -0.00000000057,     0.00000000442,
	   0.00000000188,     0.00000000030,
	   0.00000000038,    -0.00000000069,
	   0.00000005722,     0.00000002952,
	   0.00000000601,    -0.00000002605,
	  -0.00000000178,     0.00000000318,
	   0.00000000146,     0.00000000038,
	  -0.00000000520,    -0.00000000127,
	  -0.00000000023,     0.00000000222,
	   0.00000000093,    -0.00000000493,
	  -0.00000000206,    -0.00000000014,
	  -0.00000001683,    -0.00000001669,
	   0.00000000095,    -0.00000000086,
	   0.00000000241,     0.00000000130,
	   0.00000000027,    -0.00000000111,
	  -0.00000000117,     0.00000000236,
	   0.00000000107,     0.00000000024,
	  -0.00000000069,    -0.00000000072,
	   0.00000000068,    -0.00000000069,
	  -0.00000001741,    -0.00000000900,
	   0.00000000068,    -0.00000000107,
	  -0.00000000110,    -0.00000000032,
	  -0.00000000358,     0.00000001174,
	  -0.00000000139,    -0.00000000046,
	  -0.00000000110,    -0.00000000004,
	  -0.00000000016,     0.00000000127,
	   0.00000002955,    -0.00000009702,
	  -0.00000004954,    -0.00000000209,
	   0.00000000618,     0.00000000213,
	   0.00000000023,    -0.00000000315,
	   0.00000000186,    -0.00000000029,
	   0.00000000074,    -0.00000000326,
	  -0.00000000156,    -0.00000000018,
	  -0.00000002574,    -0.00000000306,
	  -0.00000000096,     0.00000001086,
	   0.00000000028,    -0.00000000347,
	  -0.00000000145,    -0.00000000006,
	   0.00000000070,     0.00000000064,
	  -0.00000000030,    -0.00000000106,
	   0.00000023954,     0.00000002827,
	   0.00000000875,    -0.00000010108,
	  -0.00000002264,    -0.00000000030,
	  -0.00000000139,     0.00000001513,
	   0.00000000635,     0.00000000038,
	  -0.00000000001,    -0.00000000141,
	  -0.00000000053,    -0.00000000454,
	  -0.00000000216,     0.00000000069,
	   0.00000000370,     0.00000000374,
	   0.00000000113,    -0.00000000206,
	   0.00000002144,     0.00000000354,
	  -0.00000000050,     0.00000000296,
	   0.00000000124,     0.00000000003,
	  -0.00000000141,    -0.00000000031,
	  -0.00000022146,    -0.00000003769,
	  -0.00000000315,     0.00000009257,
	   0.00000001948,    -0.00000000229,
	   0.00000000232,    -0.00000001327,
	  -0.00000000555,    -0.00000000019,
	   0.00000000013,     0.00000000115,
	   0.00000001094,     0.00000000157,
	   0.00000000043,    -0.00000000465,
	  -0.00000000103,     0.00000000000,
	  -0.00000000061,     0.00000000921,
	   0.00000000385,     0.00000000024,
	  -0.00000000846,    -0.00000000387,
	   0.00000000060,    -0.00000000120,
	   0.00000000111,     0.00000000027,
	  -0.00000000009,     0.00000000096,
	   0.00000009829,     0.00000004484,
	   0.00000000786,    -0.00000004391,
	  -0.00000000277,     0.00000000552,
	   0.00000000249,     0.00000000053,
	  -0.00000000960,    -0.00000000179,
	  -0.00000000018,     0.00000000404,
	   0.00000000130,    -0.00000000917,
	  -0.00000000380,    -0.00000000005,
	  -0.00000002793,    -0.00000002494,
	  -0.00000000574,     0.00000001422,
	   0.00000000146,    -0.00000000145,
	  -0.00000000076,    -0.00000000035,
	   0.00000000415,     0.00000000199,
	   0.00000000036,    -0.00000000188,
	  -0.00000000180,     0.00000000409,
	   0.00000000183,     0.00000000032,
	  -0.00000000115,    -0.00000000108,
	   0.00000000102,    -0.00000000114,
	  -0.00000000017,     0.00000000089,
	   0.00000000090,     0.00000000019,
	  -0.00000002471,    -0.00000001176,
	   0.00000000093,    -0.00000000157,
	  -0.00000000106,    -0.00000000018,
	   0.00000000025,    -0.00000000159,
	  -0.00000000175,    -0.00000000044,
	  -0.00000000546,     0.00000001990,
	   0.00000001008,     0.00000000004,
	  -0.00000000236,    -0.00000000074,
	  -0.00000000002,     0.00000000119,
	  -0.00000000217,     0.00000000002,
	  -0.00000000016,     0.00000000242,
	   0.00000000101,    -0.00000000002,
	   0.00000004434,    -0.00000016190,
	  -0.00000008197,    -0.00000000036,
	   0.00000000550,     0.00000002099,
	   0.00000001054,     0.00000000339,
	   0.00000000022,    -0.00000000534,
	  -0.00000000137,     0.00000000031,
	   0.00000000391,    -0.00000000057,
	  -0.00000000022,    -0.00000000133,
	   0.00000000088,    -0.00000000591,
	  -0.00000000272,    -0.00000000012,
	  -0.00000005095,    -0.00000000293,
	  -0.00000000009,     0.00000002113,
	   0.00000000018,    -0.00000000704,
	  -0.00000000290,     0.00000000010,
	   0.00000000122,     0.00000000103,
	  -0.00000000058,    -0.00000000182,
	  -0.00000000066,     0.00000000042,
	   0.00000047434,     0.00000002687,
	   0.00000000056,    -0.00000019671,
	  -0.00000004287,     0.00000000372,
	  -0.00000000107,     0.00000003070,
	   0.00000001265,    -0.00000000026,
	  -0.00000000030,    -0.00000000273,
	  -0.00000000112,    -0.00000000752,
	  -0.00000000356,     0.00000000127,
	   0.00000000051,     0.00000000086,
	   0.00000000644,     0.00000000631,
	   0.00000000184,    -0.00000000356,
	  -0.00000000096,    -0.00000000014,
	   0.00000003819,     0.00000000421,
	  -0.00000000041,    -0.00000001572,
	  -0.00000000064,     0.00000000545,
	   0.00000000225,    -0.00000000007,
	  -0.00000000270,    -0.00000000040,
	  -0.00000000006,     0.00000000115,
	  -0.00000000012,    -0.00000000172,
	  -0.00000039946,    -0.00000004629,
	   0.00000000362,     0.00000016475,
	   0.00000003397,    -0.00000000611,
	   0.00000000298,    -0.00000002438,
	  -0.00000001007,     0.00000000019,
	   0.00000000037,     0.00000000207,
	   0.00000002168,     0.00000000166,
	   0.00000000009,    -0.00000000903,
	  -0.00000000196,     0.00000000018,
	  -0.00000000027,     0.00000001889,
	   0.00000000777,    -0.00000000016,
	  -0.00000000016,    -0.00000000169,
	  -0.00000001387,    -0.00000000549,
	   0.00000000091,    -0.00000000205,
	  -0.00000000091,    -0.00000000014,
	   0.00000000200,     0.00000000034,
	  -0.00000000011,     0.00000000179,
	   0.00000016603,     0.00000006544,
	   0.00000000929,    -0.00000007245,
	  -0.00000000419,     0.00000000946,
	   0.00000000418,     0.00000000068,
	  -0.00000001750,    -0.00000000225,
	   0.00000000011,     0.00000000725,
	   0.00000000150,    -0.00000000028,
	   0.00000000154,    -0.00000001682,
	  -0.00000000689,     0.00000000026,
	   0.00000000027,     0.00000000141,
	  -0.00000000081,    -0.00000000036,
	   0.00000000029,    -0.00000000077,
	  -0.00000004576,    -0.00000003629,
	  -0.00000000762,     0.00000002209,
	   0.00000000218,    -0.00000000241,
	  -0.00000000119,    -0.00000000049,
	   0.00000000709,     0.00000000294,
	   0.00000000044,    -0.00000000313,
	  -0.00000000268,     0.00000000698,
	   0.00000000305,     0.00000000038,
	   0.00000000928,     0.00000001372,
	  -0.00000000191,    -0.00000000158,
	  -0.00000000033,     0.00000000095,
	   0.00000000150,    -0.00000000189,
	  -0.00000000093,    -0.00000000032,
	  -0.00000000023,     0.00000000141,
	   0.00000000143,     0.00000000026,
	  -0.00000003285,    -0.00000001418,
	  -0.00000000111,     0.00000002128,
	   0.00000000121,    -0.00000000216,
	  -0.00000000145,    -0.00000000022,
	   0.00000000034,    -0.00000000248,
	  -0.00000000120,     0.00000000016,
	  -0.00000000265,    -0.00000000055,
	   0.00000000008,     0.00000000136,
	  -0.00000000822,     0.00000003058,
	   0.00000001636,    -0.00000000048,
	  -0.00000000391,    -0.00000000116,
	   0.00000000000,     0.00000000196,
	  -0.00000000418,     0.00000000019,
	   0.00000000020,     0.00000000165,
	  -0.00000000004,     0.00000000451,
	   0.00000000187,    -0.00000000015,
	   0.00000006391,    -0.00000025948,
	  -0.00000013032,     0.00000000388,
	   0.00000001000,     0.00000003286,
	   0.00000001740,     0.00000000526,
	   0.00000000014,    -0.00000000877,
	  -0.00000000222,     0.00000000059,
	   0.00000000784,    -0.00000000111,
	  -0.00000000057,    -0.00000000279,
	   0.00000000083,    -0.00000001054,
	  -0.00000000466,     0.00000000012,
	   0.00000000019,     0.00000000109,
	  -0.00000009915,    -0.00000000057,
	   0.00000000277,     0.00000004048,
	   0.00000000860,    -0.00000000150,
	  -0.00000000029,    -0.00000001417,
	  -0.00000000574,     0.00000000058,
	   0.00000000027,     0.00000000120,
	   0.00000000206,     0.00000000156,
	   0.00000000061,    -0.00000000099,
	  -0.00000000110,    -0.00000000303,
	  -0.00000000108,     0.00000000074,
	   0.00000092349,     0.00000000443,
	  -0.00000002623,    -0.00000037696,
	  -0.00000008009,     0.00000001407,
	   0.00000000082,     0.00000006159,
	   0.00000002499,    -0.00000000225,
	  -0.00000000105,    -0.00000000528,
	  -0.00000000215,    -0.00000001195,
	  -0.00000000565,     0.00000000222,
	   0.00000000086,     0.00000000135,
	   0.00000001083,     0.00000001038,
	   0.00000000295,    -0.00000000591,
	  -0.00000000157,    -0.00000000020,
	   0.00000006656,     0.00000000347,
	  -0.00000000222,    -0.00000002700,
	  -0.00000000060,     0.00000000988,
	   0.00000000402,    -0.00000000033,
	  -0.00000000021,    -0.00000000081,
	  -0.00000000515,    -0.00000000040,
	   0.00000000005,     0.00000000212,
	  -0.00000000031,    -0.00000000366,
	  -0.00000000146,     0.00000000016,
	  -0.00000070728,    -0.00000004127,
	   0.00000002236,     0.00000028774,
	   0.00000005816,    -0.00000001392,
	   0.00000000290,    -0.00000004418,
	  -0.00000001800,     0.00000000132,
	   0.00000000085,     0.00000000363,
	   0.00000004249,     0.00000000085,
	  -0.00000000110,    -0.00000001737,
	  -0.00000000369,     0.00000000066,
	   0.00000000109,     0.00000003807,
	   0.00000001545,    -0.00000000139,
	  -0.00000000061,    -0.00000000328,
	  -0.00000002214,    -0.00000000731,
	  -0.00000000076,     0.00000000954,
	   0.00000000131,    -0.00000000344,
	  -0.00000000150,    -0.00000000016,
	   0.00000000358,     0.00000000036,
	  -0.00000000007,    -0.00000000148,
	  -0.00000000005,     0.00000000327,
	   0.00000000132,    -0.00000000013,
	   0.00000027531,     0.00000009020,
	   0.00000000871,    -0.00000011687,
	  -0.00000002360,     0.00000000377,
	  -0.00000000607,     0.00000001599,
	   0.00000000689,     0.00000000076,
	  -0.00000000018,    -0.00000000139,
	  -0.00000003144,    -0.00000000216,
	   0.00000000092,     0.00000001282,
	   0.00000000260,    -0.00000000063,
	   0.00000000117,    -0.00000003038,
	  -0.00000001230,     0.00000000113,
	   0.00000000062,     0.00000000248,
	  -0.00000000066,     0.00000000084,
	  -0.00000000136,    -0.00000000051,
	   0.00000000040,    -0.00000000131,
	  -0.00000007423,    -0.00000005115,
	  -0.00000000943,     0.00000003352,
	   0.00000000317,    -0.00000000401,
	  -0.00000000185,    -0.00000000065,
	   0.00000001192,     0.00000000416,
	   0.00000000044,    -0.00000000512,
	  -0.00000000104,     0.00000000016,
	  -0.00000000378,     0.00000001172,
	   0.00000000500,     0.00000000037,
	  -0.00000000016,    -0.00000000102,
	   0.00000001552,     0.00000001981,
	  -0.00000000116,     0.00000000079,
	  -0.00000000313,    -0.00000000227,
	  -0.00000000042,     0.00000000145,
	   0.00000000215,    -0.00000000312,
	  -0.00000000142,    -0.00000000041,
	   0.00000000066,     0.00000000087,
	  -0.00000000084,     0.00000000066,
	  -0.00000001848,    -0.00000002332,
	  -0.00000000069,     0.00000000054,
	   0.00000000015,     0.00000000099,
	   0.00000000092,    -0.00000000138,
	  -0.00000000093,    -0.00000000039,
	  -0.00000000171,    -0.00000000122,
	  -0.00000000064,     0.00000000136,
	   0.00000000156,    -0.00000000220,
	  -0.00000000164,    -0.00000000080,
	  -0.00000000220,    -0.00000000156,
	  -0.00000000081,     0.00000000164,
	   0.00000000196,    -0.00000000276,
	  -0.00000000206,    -0.00000000101,
	  -0.00000000276,    -0.00000000197,
	  -0.00000000101,     0.00000000206,
	   0.00000008157,    -0.00000011644,
	  -0.00000008806,    -0.00000004175,
	  -0.00000000906,     0.00000002678,
	  -0.00000000366,    -0.00000000257,
	  -0.00000000131,     0.00000000276,
	   0.00000000084,     0.00000000028,
	  -0.00000000029,     0.00000000213,
	   0.00000000103,    -0.00000000016,
	   0.00000000214,     0.00000000031,
	  -0.00000000015,    -0.00000000106,
	  -0.00000000598,    -0.00000005895,
	  -0.00000003365,     0.00000000813,
	  -0.00000000063,    -0.00000000433,
	  -0.00000000265,     0.00000000134,
	   0.00000000041,    -0.00000000360,
	  -0.00000000175,     0.00000000029,
	  -0.00000000376,    -0.00000000063,
	   0.00000000020,     0.00000000189,
	  -0.00000001127,     0.00000005085,
	   0.00000002536,    -0.00000000152,
	  -0.00000000618,    -0.00000000174,
	   0.00000000005,     0.00000000309,
	   0.00000000077,    -0.00000000025,
	  -0.00000000777,     0.00000000060,
	   0.00000000054,     0.00000000304,
	   0.00000000031,     0.00000000819,
	   0.00000000333,    -0.00000000047,
	   0.00000008464,    -0.00000039149,
	  -0.00000019463,     0.00000001298,
	   0.00000001674,     0.00000004885,
	   0.00000002743,     0.00000000789,
	  -0.00000000008,    -0.00000001375,
	  -0.00000000344,     0.00000000100,
	   0.00000001500,    -0.00000000211,
	  -0.00000000129,    -0.00000000551,
	  -0.00000000103,     0.00000000033,
	   0.00000000030,    -0.00000001831,
	  -0.00000000783,     0.00000000071,
	   0.00000000042,     0.00000000175,
	  -0.00000018873,     0.00000000760,
	   0.00000000994,     0.00000007620,
	   0.00000001585,    -0.00000000399,
	  -0.00000000168,    -0.00000002825,
	  -0.00000001130,     0.00000000177,
	   0.00000000068,     0.00000000233,
	   0.00000000334,     0.00000000222,
	   0.00000000088,    -0.00000000161,
	  -0.00000000198,    -0.00000000483,
	  -0.00000000171,     0.00000000125,
	   0.00000176495,    -0.00000006908,
	  -0.00000009330,    -0.00000071003,
	  -0.00000014750,     0.00000003744,
	   0.00000000846,     0.00000002025,
	   0.00000000652,     0.00000012226,
	   0.00000004895,    -0.00000000726,
	  -0.00000000277,    -0.00000001011,
	  -0.00000000139,     0.00000000060,
	  -0.00000000383,    -0.00000001798,
	  -0.00000000851,     0.00000000367,
	   0.00000000138,     0.00000000202,
	   0.00000001745,     0.00000001657,
	   0.00000000461,    -0.00000000939,
	  -0.00000000246,    -0.00000000028,
	   0.00000011304,    -0.00000000144,
	  -0.00000000636,    -0.00000004512,
	  -0.00000000894,     0.00000000268,
	   0.00000000004,     0.00000001770,
	   0.00000000709,    -0.00000000098,
	  -0.00000000043,    -0.00000000140,
	  -0.00000000978,    -0.00000000017,
	   0.00000000036,     0.00000000395,
	   0.00000000083,    -0.00000000020,
	  -0.00000000074,    -0.00000000760,
	  -0.00000000301,     0.00000000049,
	  -0.00000122635,     0.00000000714,
	   0.00000006664,     0.00000049111,
	   0.00000009735,    -0.00000002905,
	   0.00000000011,    -0.00000007901,
	  -0.00000003170,     0.00000000411,
	   0.00000000184,     0.00000000629,
	   0.00000000080,    -0.00000000042,
	   0.00000008237,    -0.00000000229,
	  -0.00000000422,    -0.00000003314,
	  -0.00000000688,     0.00000000175,
	   0.00000000041,     0.00000000093,
	   0.00000000484,     0.00000007556,
	   0.00000003030,    -0.00000000450,
	  -0.00000000166,    -0.00000000630,
	  -0.00000000086,     0.00000000037,
	  -0.00000003421,    -0.00000000912,
	  -0.00000000033,     0.00000001436,
	   0.00000000178,    -0.00000000574,
	  -0.00000000241,    -0.00000000013,
	   0.00000000635,     0.00000000017,
	  -0.00000000028,    -0.00000000256,
	   0.00000000024,     0.00000000589,
	   0.00000000236,    -0.00000000035,
	   0.00000044866,     0.00000011390,
	   0.00000000273,    -0.00000018409,
	  -0.00000003623,     0.00000000773,
	  -0.00000000825,     0.00000002675,
	   0.00000001113,     0.00000000061,
	  -0.00000000039,    -0.00000000220,
	  -0.00000005572,    -0.00000000014,
	   0.00000000293,     0.00000002231,
	   0.00000000444,    -0.00000000131,
	  -0.00000000121,    -0.00000005406,
	  -0.00000002158,     0.00000000317,
	   0.00000000130,     0.00000000428,
	   0.00000000796,     0.00000000461,
	  -0.00000000094,     0.00000000140,
	  -0.00000000226,    -0.00000000066,
	   0.00000000052,    -0.00000000218,
	  -0.00000012024,    -0.00000006989,
	  -0.00000001046,     0.00000004985,
	   0.00000000454,    -0.00000000675,
	  -0.00000000284,    -0.00000000080,
	   0.00000001979,     0.00000000545,
	   0.00000000024,    -0.00000000822,
	  -0.00000000163,     0.00000000034,
	  -0.00000000492,     0.00000001945,
	   0.00000000806,     0.00000000015,
	  -0.00000000034,    -0.00000000159,
	   0.00000002646,     0.00000002894,
	  -0.00000000179,     0.00000000144,
	  -0.00000000519,    -0.00000000319,
	  -0.00000000050,     0.00000000221,
	   0.00000000300,    -0.00000000515,
	  -0.00000000216,    -0.00000000048,
	   0.00000000117,     0.00000000132,
	  -0.00000000127,     0.00000000117,
	  -0.00000000647,    -0.00000002661,
	   0.00000000109,    -0.00000000027,
	  -0.00000000015,    -0.00000000103,
	   0.00000007377,    -0.00000001130,
	  -0.00000000805,    -0.00000002867,
	   0.00000000045,     0.00000000300,
	   0.00000000117,    -0.00000000032,
	   0.00000000201,    -0.00000000030,
	   0.00000000031,     0.00000000200,
	  -0.00000000002,     0.00000000010,
	   0.00000000000,     0.00000000020,
	   0.00000000020,     0.00000000000,
	  -0.00000000071,    -0.00000000015,
	  -0.00000000014,     0.00000000071,
	  -0.00000000157,     0.00000000258,
	   0.00000000224,     0.00000000105,
	   0.00000000252,     0.00000000143,
	   0.00000000091,    -0.00000000215,
	  -0.00000000413,     0.00000000267,
	   0.00000000251,     0.00000000325,
	   0.00000000130,    -0.00000000117,
	   0.00000000267,     0.00000000413,
	   0.00000000325,    -0.00000000251,
	  -0.00000000117,    -0.00000000130,
	  -0.00000000517,     0.00000000334,
	   0.00000000314,     0.00000000407,
	   0.00000000163,    -0.00000000147,
	   0.00000000335,     0.00000000518,
	   0.00000000407,    -0.00000000314,
	  -0.00000000147,    -0.00000000163,
	  -0.00000000006,     0.00000000001,
	  -0.00000000004,     0.00000000001,
	   0.00000000001,     0.00000000004,
	   0.00000000001,     0.00000000004,
	  -0.00000000063,     0.00000000021,
	   0.00000000022,     0.00000000063,
	   0.00000000023,     0.00000000067,
	   0.00000000066,     0.00000000024,
	   0.00000000066,    -0.00000000176,
	  -0.00000000285,     0.00000000041,
	   0.00000000042,     0.00000000282,
	  -0.00000000226,     0.00000000028,
	   0.00000000041,     0.00000000298,
	   0.00000000066,    -0.00000000046,
	  -0.00000000053,    -0.00000000040,
	   0.00000000055,    -0.00000000056,
	  -0.00000000035,    -0.00000000025,
	  -0.00000000061,    -0.00000000061,
	  -0.00000000023,     0.00000000037,
	  -0.00000000004,     0.00000000047,
	   0.00000000039,    -0.00000000050,
	   0.00000000034,     0.00000000062,
	   0.00000000052,    -0.00000000031,
	  -0.00000012187,     0.00000007655,
	   0.00000007395,     0.00000009485,
	   0.00000003734,    -0.00000003510,
	  -0.00000001100,    -0.00000000958,
	   0.00000000343,     0.00000000532,
	   0.00000000418,    -0.00000000322,
	  -0.00000000151,    -0.00000000168,
	  -0.00000000159,     0.00000000103,
	   0.00000000097,     0.00000000125,
	  -0.00000000098,    -0.00000000152,
	  -0.00000000119,     0.00000000092,
	   0.00000004646,    -0.00000005332,
	  -0.00000004262,    -0.00000002497,
	  -0.00000000607,     0.00000001443,
	  -0.00000000416,    -0.00000000184,
	  -0.00000000128,     0.00000000285,
	  -0.00000000031,     0.00000000294,
	   0.00000000143,    -0.00000000025,
	   0.00000000366,     0.00000000080,
	  -0.00000000024,    -0.00000000145,
	  -0.00000004581,    -0.00000001003,
	   0.00000000356,     0.00000002916,
	   0.00000000145,    -0.00000000304,
	  -0.00000000202,    -0.00000000023,
	   0.00000000045,    -0.00000000470,
	  -0.00000000229,     0.00000000042,
	  -0.00000000481,    -0.00000000063,
	   0.00000000034,     0.00000000239,
	  -0.00000000062,    -0.00000000062,
	  -0.00000000063,     0.00000000062,
	  -0.00000001472,     0.00000007440,
	   0.00000003688,    -0.00000000323,
	  -0.00000000341,    -0.00000000907,
	  -0.00000000918,    -0.00000000249,
	   0.00000000014,     0.00000000457,
	   0.00000000113,    -0.00000000038,
	  -0.00000001385,     0.00000000143,
	   0.00000000119,     0.00000000540,
	   0.00000000107,    -0.00000000038,
	   0.00000000109,     0.00000001432,
	   0.00000000573,    -0.00000000110,
	  -0.00000000039,    -0.00000000115,
	   0.00000011124,    -0.00000055307,
	  -0.00000027462,     0.00000002252,
	   0.00000002504,     0.00000006750,
	   0.00000004055,     0.00000001121,
	  -0.00000000047,    -0.00000002023,
	  -0.00000000502,     0.00000000156,
	   0.00000000053,     0.00000000080,
	   0.00000002710,    -0.00000000387,
	  -0.00000000261,    -0.00000001018,
	  -0.00000000193,     0.00000000074,
	  -0.00000000115,    -0.00000003066,
	  -0.00000001269,     0.00000000190,
	   0.00000000082,     0.00000000272,
	  -0.00000035325,     0.00000002617,
	   0.00000002562,     0.00000014048,
	   0.00000002865,    -0.00000000914,
	  -0.00000000509,    -0.00000005587,
	  -0.00000002210,     0.00000000450,
	   0.00000000155,     0.00000000448,
	   0.00000000509,     0.00000000282,
	   0.00000000115,    -0.00000000241,
	  -0.00000000343,    -0.00000000734,
	  -0.00000000255,     0.00000000199,
	   0.00000329392,    -0.00000024718,
	  -0.00000024009,    -0.00000130971,
	  -0.00000026706,     0.00000008553,
	   0.00000001796,     0.00000003559,
	   0.00000002068,     0.00000024021,
	   0.00000009513,    -0.00000001872,
	  -0.00000000650,    -0.00000001930,
	  -0.00000000257,     0.00000000132,
	  -0.00000000626,    -0.00000002484,
	  -0.00000001189,     0.00000000558,
	   0.00000000205,     0.00000000283,
	   0.00000002654,     0.00000002541,
	   0.00000000705,    -0.00000001403,
	  -0.00000000361,    -0.00000000045,
	  -0.00000000061,    -0.00000000111,
	   0.00000000037,    -0.00000000083,
	   0.00000018586,    -0.00000001691,
	  -0.00000001509,    -0.00000007290,
	  -0.00000001415,     0.00000000515,
	   0.00000000251,     0.00000003132,
	   0.00000001233,    -0.00000000247,
	  -0.00000000087,    -0.00000000239,
	  -0.00000001841,     0.00000000062,
	   0.00000000112,     0.00000000735,
	   0.00000000150,    -0.00000000046,
	  -0.00000000171,    -0.00000001536,
	  -0.00000000609,     0.00000000123,
	   0.00000000038,     0.00000000123,
	  -0.00000207697,     0.00000017116,
	   0.00000016382,     0.00000081647,
	   0.00000015861,    -0.00000005713,
	  -0.00000001174,    -0.00000001979,
	  -0.00000001074,    -0.00000013956,
	  -0.00000005496,     0.00000001068,
	   0.00000000378,     0.00000001068,
	   0.00000000134,    -0.00000000077,
	   0.00000015782,    -0.00000001065,
	  -0.00000001136,    -0.00000006264,
	  -0.00000001275,     0.00000000410,
	   0.00000000088,     0.00000000168,
	   0.00000001369,     0.00000014759,
	   0.00000005862,    -0.00000001149,
	  -0.00000000394,    -0.00000001197,
	  -0.00000000158,     0.00000000082,
	  -0.00000005134,    -0.00000000951,
	   0.00000000095,     0.00000002075,
	   0.00000000216,    -0.00000000953,
	  -0.00000000383,     0.00000000006,
	   0.00000001114,    -0.00000000063,
	  -0.00000000080,    -0.00000000437,
	  -0.00000000085,     0.00000000029,
	   0.00000000115,     0.00000001045,
	   0.00000000411,    -0.00000000088,
	  -0.00000000030,    -0.00000000082,
	   0.00000072185,     0.00000012242,
	  -0.00000001614,    -0.00000028293,
	  -0.00000005399,     0.00000001496,
	  -0.00000001010,     0.00000004475,
	   0.00000001777,    -0.00000000023,
	  -0.00000000080,    -0.00000000342,
	  -0.00000009747,     0.00000000735,
	   0.00000000756,     0.00000003825,
	   0.00000000745,    -0.00000000266,
	  -0.00000000056,    -0.00000000092,
	  -0.00000000917,    -0.00000009485,
	  -0.00000003726,     0.00000000781,
	   0.00000000265,     0.00000000724,
	   0.00000000090,    -0.00000000053,
	   0.00000001228,     0.00000000565,
	  -0.00000000132,     0.00000000243,
	   0.00000000092,     0.00000000017,
	  -0.00000000377,    -0.00000000076,
	   0.00000000005,     0.00000000150,
	   0.00000000055,    -0.00000000362,
	  -0.00000000150,     0.00000000007,
	  -0.00000020038,    -0.00000009558,
	  -0.00000000907,     0.00000007342,
	   0.00000000647,    -0.00000001178,
	  -0.00000000437,    -0.00000000086,
	   0.00000003271,     0.00000000627,
	  -0.00000000053,    -0.00000001302,
	  -0.00000000250,     0.00000000069,
	  -0.00000000547,     0.00000003214,
	   0.00000001277,    -0.00000000062,
	  -0.00000000067,    -0.00000000245,
	   0.00000000056,    -0.00000000054,
	   0.00000000103,     0.00000000051,
	  -0.00000000046,     0.00000000101,
	   0.00000004739,     0.00000004452,
	   0.00000000428,    -0.00000001671,
	  -0.00000000297,     0.00000000280,
	   0.00000000095,     0.00000000033,
	  -0.00000000886,    -0.00000000442,
	  -0.00000000049,     0.00000000335,
	   0.00000000412,    -0.00000000879,
	  -0.00000000328,    -0.00000000047,
	  -0.00000000819,    -0.00000001749,
	   0.00000000117,    -0.00000000048,
	   0.00000000219,     0.00000000212,
	   0.00000000023,    -0.00000000077,
	  -0.00000000203,     0.00000000220,
	  -0.00000000040,    -0.00000000087,
	   0.00000000088,    -0.00000000040,
	  -0.00000023175,     0.00000014543,
	   0.00000014052,     0.00000018043,
	   0.00000007098,    -0.00000006665,
	  -0.00000002105,    -0.00000001829,
	   0.00000000438,     0.00000000677,
	   0.00000000532,    -0.00000000411,
	  -0.00000000191,    -0.00000000213,
	  -0.00000000056,     0.00000000060,
	  -0.00000000086,     0.00000000022,
	  -0.00000000145,     0.00000000020,
	   0.00000000022,     0.00000000151,
	  -0.00000001433,    -0.00000005930,
	  -0.00000002800,     0.00000001378,
	   0.00000000255,    -0.00000000064,
	  -0.00000000060,    -0.00000000121,
	   0.00000000110,    -0.00000000012,
	  -0.00000000027,    -0.00000000152,
	  -0.00000002154,     0.00000000323,
	   0.00000000235,     0.00000000837,
	  -0.00000000046,    -0.00000000311,
	  -0.00000000120,     0.00000000034,
	   0.00000021284,    -0.00000003202,
	  -0.00000002329,    -0.00000008269,
	   0.00000000134,     0.00000000899,
	   0.00000000349,    -0.00000000098,
	  -0.00000000045,    -0.00000000162,
	  -0.00000000076,     0.00000000041,
	   0.00000000163,    -0.00000000039,
	  -0.00000000037,    -0.00000000077,
	   0.00000000592,    -0.00000000086,
	  -0.00000000064,    -0.00000000229,
	   0.00000000091,     0.00000000589,
	   0.00000000228,    -0.00000000065,
	   0.00000000001,    -0.00000000007,
	  -0.00000000002,    -0.00000000024,
	  -0.00000000012,     0.00000000006,
	  -0.00000000024,     0.00000000002,
	   0.00000000006,     0.00000000012,
	   0.00000000143,    -0.00000000019,
	  -0.00000000022,    -0.00000000072,
	  -0.00000000019,    -0.00000000143,
	  -0.00000000072,     0.00000000022,
	   0.00000000281,    -0.00000000378,
	  -0.00000000292,    -0.00000000167,
	  -0.00000000047,     0.00000000111,
	  -0.00000000391,    -0.00000000288,
	  -0.00000000166,     0.00000000312,
	   0.00000000116,     0.00000000051,
	  -0.00000003020,     0.00000003731,
	   0.00000003273,     0.00000002165,
	   0.00000000769,    -0.00000001443,
	   0.00000000219,     0.00000000168,
	   0.00000000130,    -0.00000000189,
	  -0.00000001088,     0.00000000657,
	   0.00000000576,     0.00000000781,
	   0.00000000293,    -0.00000000255,
	   0.00000000753,     0.00000001079,
	   0.00000000760,    -0.00000000675,
	  -0.00000000308,    -0.00000000275,
	  -0.00000000111,     0.00000000027,
	   0.00000000029,     0.00000000110,
	  -0.00000000120,    -0.00000000377,
	  -0.00000000232,     0.00000000173,
	   0.00000000089,     0.00000000064,
	  -0.00000000377,     0.00000000120,
	   0.00000000173,     0.00000000232,
	   0.00000000064,    -0.00000000088,
	  -0.00000000150,    -0.00000000472,
	  -0.00000000291,     0.00000000217,
	   0.00000000111,     0.00000000080,
	  -0.00000000472,     0.00000000150,
	   0.00000000217,     0.00000000291,
	   0.00000000080,    -0.00000000111,
	   0.00000000052,    -0.00000000013,
	  -0.00000000013,    -0.00000000051,
	   0.00000000081,    -0.00000000021,
	  -0.00000000021,    -0.00000000081,
	  -0.00000000014,    -0.00000000057,
	   0.00000000046,    -0.00000000009,
	  -0.00000000088,     0.00000000010,
	   0.00000000013,     0.00000000044,
	   0.00000000036,     0.00000000227,
	   0.00000000114,    -0.00000000038,
	   0.00000000270,    -0.00000000249,
	  -0.00000000139,    -0.00000000098,
	  -0.00000000250,    -0.00000000267,
	  -0.00000000096,     0.00000000139,
	   0.00000000229,    -0.00000000205,
	  -0.00000000113,    -0.00000000083,
	  -0.00000000291,    -0.00000000282,
	  -0.00000000100,     0.00000000156,
	   0.00000000101,     0.00000000238,
	   0.00000000084,    -0.00000000053,
	   0.00000000233,    -0.00000000126,
	  -0.00000000066,    -0.00000000078,
	   0.00000000151,     0.00000000290,
	   0.00000000099,    -0.00000000077,
	   0.00000000304,    -0.00000000162,
	  -0.00000000082,    -0.00000000104,
	  -0.00000000055,    -0.00000000002,
	   0.00000000052,     0.00000000105,
	   0.00000000031,    -0.00000000025,
	  -0.00000000110,     0.00000000048,
	   0.00000000017,     0.00000000029,
	   0.00000000036,     0.00000000097,
	  -0.00000000025,     0.00000000026,
	  -0.00000003434,    -0.00000011099,
	  -0.00000006858,     0.00000004892,
	   0.00000002501,     0.00000001920,
	  -0.00000000476,     0.00000000145,
	   0.00000000214,     0.00000000296,
	   0.00000000080,    -0.00000000111,
	  -0.00000000025,     0.00000000354,
	   0.00000000172,    -0.00000000035,
	   0.00000000355,     0.00000000027,
	  -0.00000000035,    -0.00000000173,
	  -0.00000002922,    -0.00000000427,
	   0.00000000366,     0.00000001712,
	   0.00000000123,    -0.00000000274,
	  -0.00000000183,    -0.00000000023,
	  -0.00000000016,    -0.00000000672,
	  -0.00000000346,     0.00000000124,
	   0.00000000064,     0.00000000085,
	  -0.00000000370,    -0.00000000095,
	  -0.00000000021,     0.00000000163,
	  -0.00000000111,    -0.00000000106,
	  -0.00000000109,     0.00000000111,
	   0.00000003522,    -0.00000003262,
	  -0.00000002625,    -0.00000001783,
	  -0.00000000355,     0.00000000873,
	   0.00000001525,     0.00000001637,
	   0.00000000832,    -0.00000001228,
	  -0.00000000410,    -0.00000000165,
	  -0.00000000032,     0.00000000080,
	  -0.00000016801,     0.00000025024,
	   0.00000016820,     0.00000006945,
	   0.00000000985,    -0.00000005126,
	  -0.00000004580,    -0.00000003936,
	  -0.00000001808,     0.00000003314,
	   0.00000001052,     0.00000000310,
	  -0.00000002089,     0.00000000062,
	   0.00000000031,     0.00000000786,
	   0.00000000177,    -0.00000000072,
	   0.00000000671,     0.00000002462,
	   0.00000000954,    -0.00000000499,
	  -0.00000000071,    -0.00000000185,
	   0.00000011931,    -0.00000068499,
	  -0.00000033758,     0.00000003875,
	   0.00000003359,     0.00000008223,
	   0.00000001268,    -0.00000000966,
	   0.00000005390,     0.00000001467,
	  -0.00000000084,    -0.00000002681,
	  -0.00000000660,     0.00000000214,
	   0.00000000071,     0.00000000103,
	   0.00000004487,    -0.00000000608,
	  -0.00000000437,    -0.00000001718,
	  -0.00000000335,     0.00000000132,
	  -0.00000000363,    -0.00000004781,
	  -0.00000001927,     0.00000000369,
	   0.00000000137,     0.00000000400,
	  -0.00000001691,     0.00000001645,
	   0.00000000058,     0.00000000058,
	  -0.00000063964,     0.00000006624,
	   0.00000005648,     0.00000025170,
	   0.00000005053,    -0.00000001886,
	  -0.00000000378,    -0.00000000656,
	  -0.00000001271,    -0.00000010960,
	  -0.00000004298,     0.00000001033,
	   0.00000000339,     0.00000000858,
	   0.00000000108,    -0.00000000069,
	   0.00000000711,     0.00000000287,
	   0.00000000130,    -0.00000000328,
	  -0.00000000073,    -0.00000000027,
	  -0.00000000561,    -0.00000001041,
	  -0.00000000354,     0.00000000297,
	   0.00000000077,     0.00000000051,
	   0.00000595575,    -0.00000061341,
	  -0.00000052165,    -0.00000234607,
	  -0.00000047138,     0.00000017375,
	   0.00000003494,     0.00000006139,
	   0.00000005297,     0.00000046770,
	   0.00000018351,    -0.00000004351,
	  -0.00000001429,    -0.00000003667,
	  -0.00000000476,     0.00000000279,
	  -0.00000000930,    -0.00000002967,
	  -0.00000001464,     0.00000000755,
	   0.00000000269,     0.00000000353,
	   0.00000000053,    -0.00000000058,
	   0.00000003713,     0.00000003670,
	   0.00000001034,    -0.00000001912,
	  -0.00000000484,    -0.00000000078,
	  -0.00000000115,    -0.00000000197,
	  -0.00000000064,     0.00000000045,
	   0.00000000067,    -0.00000000155,
	   0.00000029433,    -0.00000005555,
	  -0.00000003231,    -0.00000011258,
	  -0.00000002139,     0.00000000935,
	   0.00000001014,     0.00000005510,
	   0.00000002116,    -0.00000000596,
	  -0.00000000174,    -0.00000000401,
	  -0.00000003453,     0.00000000261,
	   0.00000000277,     0.00000001357,
	   0.00000000271,    -0.00000000100,
	  -0.00000000377,    -0.00000003041,
	  -0.00000001201,     0.00000000280,
	   0.00000000086,     0.00000000239,
	  -0.00000342630,     0.00000062013,
	   0.00000036855,     0.00000131556,
	   0.00000025007,    -0.00000010773,
	  -0.00000002034,    -0.00000003045,
	  -0.00000004430,    -0.00000024495,
	  -0.00000009410,     0.00000002596,
	   0.00000000761,     0.00000001788,
	   0.00000000218,    -0.00000000141,
	   0.00000029853,    -0.00000002953,
	  -0.00000002627,    -0.00000011717,
	  -0.00000002348,     0.00000000881,
	   0.00000000179,     0.00000000303,
	   0.00000003271,     0.00000028341,
	   0.00000011174,    -0.00000002598,
	  -0.00000000853,    -0.00000002249,
	  -0.00000000290,     0.00000000170,
	   0.00000000065,     0.00000000096,
	  -0.00000000026,     0.00000000092,
	  -0.00000007506,    -0.00000000674,
	   0.00000000394,     0.00000002868,
	   0.00000000199,    -0.00000001618,
	  -0.00000000609,     0.00000000064,
	   0.00000000038,     0.00000000113,
	   0.00000001949,    -0.00000000312,
	  -0.00000000200,    -0.00000000744,
	  -0.00000000142,     0.00000000060,
	   0.00000000381,     0.00000001842,
	   0.00000000712,    -0.00000000206,
	  -0.00000000061,    -0.00000000137,
	   0.00000116364,     0.00000007942,
	  -0.00000006409,    -0.00000042729,
	  -0.00000007811,     0.00000002829,
	  -0.00000000965,     0.00000007672,
	   0.00000002851,    -0.00000000291,
	  -0.00000000166,    -0.00000000528,
	  -0.00000016935,     0.00000002972,
	   0.00000001806,     0.00000006480,
	   0.00000001232,    -0.00000000531,
	  -0.00000000102,    -0.00000000148,
	  -0.00000003226,    -0.00000016512,
	  -0.00000006346,     0.00000001828,
	   0.00000000527,     0.00000001207,
	   0.00000000146,    -0.00000000097,
	   0.00000000026,    -0.00000000097,
	   0.00000002124,     0.00000000825,
	  -0.00000000187,     0.00000000456,
	   0.00000000150,     0.00000000011,
	  -0.00000000644,    -0.00000000065,
	   0.00000000032,     0.00000000240,
	   0.00000000032,    -0.00000000618,
	  -0.00000000237,     0.00000000036,
	  -0.00000034281,    -0.00000012597,
	  -0.00000000215,     0.00000011032,
	   0.00000001923,    -0.00000000592,
	   0.00000000958,    -0.00000002257,
	  -0.00000000712,    -0.00000000062,
	   0.00000000035,     0.00000000124,
	   0.00000005529,     0.00000000515,
	  -0.00000000271,    -0.00000002070,
	  -0.00000000381,     0.00000000137,
	  -0.00000000384,     0.00000005427,
	   0.00000002032,    -0.00000000278,
	  -0.00000000133,    -0.00000000375,
	  -0.00000000552,    -0.00000000468,
	   0.00000000106,    -0.00000000115,
	   0.00000000191,     0.00000000075,
	  -0.00000000065,     0.00000000191,
	   0.00000009178,     0.00000007676,
	   0.00000000285,    -0.00000002711,
	  -0.00000000580,     0.00000000627,
	   0.00000000173,     0.00000000030,
	  -0.00000001660,    -0.00000000634,
	  -0.00000000024,     0.00000000540,
	   0.00000000098,    -0.00000000031,
	   0.00000000580,    -0.00000001646,
	  -0.00000000528,    -0.00000000022,
	   0.00000000031,     0.00000000099,
	  -0.00000000057,    -0.00000000046,
	   0.00000000054,    -0.00000000058,
	  -0.00000001840,    -0.00000003617,
	   0.00000000290,    -0.00000000128,
	   0.00000000487,     0.00000000413,
	   0.00000000019,    -0.00000000141,
	  -0.00000000395,     0.00000000489,
	   0.00000000142,     0.00000000017,
	  -0.00000000128,    -0.00000000008,
	  -0.00000000112,    -0.00000000231,
	   0.00000000224,    -0.00000000112,
	   0.00000000072,     0.00000000062,
	  -0.00000000014,     0.00000000142,
	  -0.00000000142,    -0.00000000014,
	   0.00000000880,    -0.00000000690,
	  -0.00000002150,     0.00000001675,
	   0.00000000062,    -0.00000000235,
	  -0.00000006310,    -0.00000020910,
	  -0.00000012975,     0.00000009120,
	   0.00000004691,     0.00000003648,
	  -0.00000000614,     0.00000000196,
	   0.00000000282,     0.00000000378,
	   0.00000000104,    -0.00000000144,
	   0.00000000384,     0.00000001591,
	   0.00000000751,    -0.00000000372,
	  -0.00000000185,     0.00000000047,
	   0.00000000044,     0.00000000087,
	  -0.00000000391,     0.00000000056,
	   0.00000000042,     0.00000000150,
	   0.00000000057,     0.00000000398,
	   0.00000000155,    -0.00000000044,
	  -0.00000002833,    -0.00000011822,
	  -0.00000005583,     0.00000002744,
	   0.00000000544,    -0.00000000137,
	  -0.00000000129,    -0.00000000257,
	  -0.00000000061,     0.00000000048,
	   0.00000000312,    -0.00000000041,
	  -0.00000000027,    -0.00000000116,
	  -0.00000000058,    -0.00000000367,
	  -0.00000000147,     0.00000000046,
	  -0.00000006047,     0.00000000900,
	   0.00000000663,     0.00000002348,
	  -0.00000000138,    -0.00000000934,
	  -0.00000000362,     0.00000000102,
	   0.00000000032,     0.00000000071,
	   0.00000059807,    -0.00000008920,
	  -0.00000006571,    -0.00000023224,
	  -0.00000004565,     0.00000002064,
	   0.00000000395,     0.00000002665,
	   0.00000001035,    -0.00000000292,
	  -0.00000000091,    -0.00000000203,
	  -0.00000000101,    -0.00000000323,
	  -0.00000000154,     0.00000000087,
	   0.00000000346,    -0.00000000075,
	  -0.00000000076,    -0.00000000162,
	  -0.00000000183,     0.00000000022,
	  -0.00000000031,    -0.00000000177,
	  -0.00000001305,     0.00000002559,
	  -0.00000000096,    -0.00000000075,
	   0.00000001710,    -0.00000000248,
	  -0.00000000186,    -0.00000000663,
	  -0.00000000129,     0.00000000058,
	   0.00000000261,     0.00000001701,
	   0.00000000661,    -0.00000000188,
	  -0.00000000058,    -0.00000000129,
	  -0.00000000038,     0.00000000070,
	  -0.00000000071,    -0.00000000039,
	   0.00000000065,     0.00000000017,
	   0.00000000001,    -0.00000000028,
	   0.00000000219,    -0.00000000005,
	  -0.00000000019,    -0.00000000082,
	  -0.00000000003,    -0.00000000216,
	  -0.00000000082,     0.00000000019,
	   0.00000000007,     0.00000000007,
	   0.00000000009,    -0.00000000008,
	  -0.00000000003,    -0.00000000003,
	   0.00000000054,    -0.00000000026,
	  -0.00000000026,    -0.00000000054,
	  -0.00000000110,    -0.00000000095,
	  -0.00000000044,     0.00000000063,
	  -0.00000000109,     0.00000001001,
	   0.00000000436,    -0.00000000014,
	   0.00000000999,     0.00000000109,
	  -0.00000000013,    -0.00000000435,
	   0.00000000613,    -0.00000000039,
	  -0.00000000104,    -0.00000000480,
	  -0.00000000213,     0.00000000297,
	   0.00000000221,     0.00000000111,
	   0.00000001863,     0.00000002631,
	   0.00000001414,    -0.00000001195,
	  -0.00000000376,    -0.00000000409,
	   0.00000002631,    -0.00000001855,
	  -0.00000001200,    -0.00000001415,
	  -0.00000000417,     0.00000000385,
	  -0.00000000062,     0.00000000239,
	   0.00000000239,     0.00000000056,
	  -0.00000014340,     0.00000008560,
	   0.00000007717,     0.00000010310,
	   0.00000003752,    -0.00000003467,
	  -0.00000001031,    -0.00000000910,
	   0.00000000748,    -0.00000000187,
	  -0.00000000211,    -0.00000000490,
	  -0.00000000160,     0.00000000100,
	   0.00000000098,    -0.00000011159,
	  -0.00000007288,     0.00000000536,
	   0.00000000409,     0.00000002425,
	   0.00000000526,    -0.00000000152,
	  -0.00000011083,     0.00000000052,
	   0.00000000658,     0.00000007214,
	   0.00000002386,    -0.00000000459,
	  -0.00000000158,    -0.00000000524,
	   0.00000000146,    -0.00000000582,
	  -0.00000000241,    -0.00000000019,
	  -0.00000000581,    -0.00000000135,
	  -0.00000000014,     0.00000000241,
	  -0.00000000036,    -0.00000000316,
	  -0.00000000180,     0.00000000081,
	   0.00000004289,    -0.00000001220,
	  -0.00000001453,    -0.00000002385,
	  -0.00000000618,     0.00000000653,
	   0.00000000173,     0.00000000095,
	  -0.00000001216,    -0.00000004288,
	  -0.00000002386,     0.00000001449,
	   0.00000000652,     0.00000000617,
	   0.00000000095,    -0.00000000172,
	   0.00000000068,     0.00000000035,
	   0.00000005383,    -0.00000001516,
	  -0.00000001819,    -0.00000002991,
	  -0.00000000774,     0.00000000818,
	   0.00000000217,     0.00000000119,
	  -0.00000001517,    -0.00000005381,
	  -0.00000002989,     0.00000001818,
	   0.00000000817,     0.00000000773,
	   0.00000000119,    -0.00000000216,
	  -0.00000000002,     0.00000000000,
	   0.00000000000,     0.00000000019,
	   0.00000000006,    -0.00000000001,
	   0.00000000003,     0.00000000012,
	   0.00000000004,    -0.00000000002,
	   0.00000000013,    -0.00000000003,
	  -0.00000000001,    -0.00000000004,
	   0.00000000001,     0.00000000003,
	   0.00000000013,    -0.00000000004,
	  -0.00000000002,    -0.00000000004,
	   0.00000000001,     0.00000000004,
	   0.00000000021,     0.00000000107,
	   0.00000000041,    -0.00000000018,
	   0.00000000107,    -0.00000000021,
	  -0.00000000018,    -0.00000000041,
	   0.00000001247,    -0.00000000327,
	   0.00000000162,     0.00000000803,
	   0.00000000279,    -0.00000000123,
	   0.00000000804,    -0.00000000162,
	  -0.00000000123,    -0.00000000279,
	   0.00000000011,     0.00000000056,
	   0.00000000019,    -0.00000000008,
	   0.00000000135,    -0.00000000026,
	  -0.00000000020,    -0.00000000047,
	   0.00000000065,     0.00000000321,
	   0.00000000113,    -0.00000000049,
	   0.00000000320,    -0.00000000065,
	  -0.00000000049,    -0.00000000113,
	   0.00000001370,    -0.00000000351,
	   0.00000000176,     0.00000000881,
	   0.00000000305,    -0.00000000134,
	   0.00000000881,    -0.00000000177,
	  -0.00000000134,    -0.00000000306,
	   0.00000000040,     0.00000000201,
	   0.00000000070,    -0.00000000031,
	   0.00000000359,    -0.00000000071,
	  -0.00000000054,    -0.00000000125,
	  -0.00000000098,     0.00000000016,
	   0.00000000014,     0.00000000093,
	  -0.00000000093,     0.00000000014,
	   0.00000000007,     0.00000000027,
	   0.00000000021,     0.00000000140,
	   0.00000000040,    -0.00000000011,
	   0.00000000046,    -0.00000000415,
	  -0.00000000187,     0.00000000007,
	  -0.00000001018,    -0.00000000095,
	   0.00000000021,     0.00000000459,
	   0.00000000678,     0.00000001465,
	   0.00000000493,    -0.00000000347,
	   0.00000001448,    -0.00000000684,
	  -0.00000000348,    -0.00000000482,
	   0.00000000586,     0.00000001297,
	   0.00000000430,    -0.00000000299,
	   0.00000001599,    -0.00000000796,
	  -0.00000000395,    -0.00000000529,
	  -0.00000000564,     0.00000000052,
	   0.00000000026,     0.00000000167,
	   0.00000000173,     0.00000000570,
	   0.00000000161,    -0.00000000079,
	  -0.00000000705,     0.00000000198,
	   0.00000000080,     0.00000000195,
	   0.00000000174,     0.00000000728,
	   0.00000000207,    -0.00000000077,
	   0.00000000044,     0.00000000152,
	   0.00000000049,    -0.00000000030,
	  -0.00000000109,     0.00000000104,
	   0.00000000042,     0.00000000038,
	  -0.00000000079,     0.00000000058,
	   0.00000000043,     0.00000000052,
	  -0.00000000071,     0.00000000026,
	  -0.00000000022,    -0.00000000069,
	   0.00000000175,    -0.00000000267,
	  -0.00000000267,    -0.00000000175,
	   0.00000000248,    -0.00000000380,
	  -0.00000000380,    -0.00000000248,
	   0.00000000311,    -0.00000000476,
	  -0.00000000476,    -0.00000000311,
	  -0.00000002068,    -0.00000005899,
	  -0.00000000177,     0.00000000062,
	  -0.00000000159,     0.00000000079,
	  -0.00000000079,    -0.00000000159,
	  -0.00000002522,     0.00000000533,
	  -0.00000000025,    -0.00000000123,
	  -0.00000000100,     0.00000000021,
	  -0.00000000021,    -0.00000000100,
	   0.00000013506,    -0.00000016270,
	  -0.00000000691,    -0.00000000574,
	  -0.00000000084,    -0.00000000031,
	  -0.00000000032,     0.00000000086,
	   0.00000123006,    -0.00000035793,
	  -0.00000042970,    -0.00000066906,
	  -0.00000017202,     0.00000019006,
	   0.00000004986,     0.00000002615,
	  -0.00000001403,    -0.00000005357,
	  -0.00000003001,     0.00000001735,
	   0.00000000795,     0.00000000783,
	   0.00000000123,    -0.00000000211,
	   0.00000000108,    -0.00000000402,
	  -0.00000000211,    -0.00000000008,
	  -0.00000000368,     0.00000000117,
	   0.00000000123,     0.00000000147,
	  -0.00000000210,    -0.00000000190,
	  -0.00000000051,     0.00000000083,
	  -0.00000000156,     0.00000000162,
	   0.00000000009,     0.00000000116,
	  -0.00000001559,     0.00000002993,
	   0.00000000127,     0.00000000066,
	  -0.00000001524,     0.00000010899,
	   0.00000005333,    -0.00000000793,
	  -0.00000000570,    -0.00000001285,
	  -0.00000001350,    -0.00000000356,
	   0.00000000028,     0.00000000668,
	   0.00000000162,    -0.00000000056,
	  -0.00000003461,     0.00000000517,
	   0.00000000388,     0.00000001339,
	   0.00000000261,    -0.00000000116,
	   0.00000000494,     0.00000003491,
	   0.00000001359,    -0.00000000377,
	  -0.00000000115,    -0.00000000266,
	   0.00000003295,    -0.00000062425,
	  -0.00000029254,     0.00000007667,
	   0.00000004103,     0.00000006629,
	   0.00000000902,    -0.00000001019,
	   0.00000005783,     0.00000001671,
	  -0.00000000050,    -0.00000002886,
	  -0.00000000711,     0.00000000227,
	   0.00000000075,     0.00000000111,
	   0.00000008361,    -0.00000001450,
	  -0.00000001337,    -0.00000003520,
	  -0.00000000754,     0.00000000496,
	   0.00000000117,     0.00000000105,
	  -0.00000000234,    -0.00000004749,
	  -0.00000001592,    -0.00000000013,
	  -0.00000000076,     0.00000000265,
	   0.00000000072,     0.00000000057,
	   0.00000000050,    -0.00000000092,
	   0.00000000001,    -0.00000000004,
	   0.00000000000,    -0.00000000013,
	  -0.00000000013,     0.00000000000,
	   0.00000000050,     0.00000000014,
	   0.00000000014,    -0.00000000049,
	   0.00000000441,     0.00000002722,
	   0.00000001323,    -0.00000000655,
	  -0.00000001700,     0.00000000235,
	   0.00000000376,     0.00000000842,
	   0.00000000152,    -0.00000000124,
	   0.00000000958,    -0.00000000721,
	  -0.00000000562,    -0.00000000432,
	  -0.00000000080,     0.00000000196,
	   0.00000000626,     0.00000000472,
	   0.00000000296,    -0.00000000520,
	  -0.00000000184,    -0.00000000072,
	  -0.00000112464,    -0.00000002962,
	   0.00000002820,     0.00000046911,
	   0.00000009902,    -0.00000002042,
	  -0.00000000748,    -0.00000001163,
	   0.00000001091,    -0.00000022156,
	  -0.00000009247,     0.00000000253,
	   0.00000000323,     0.00000001969,
	   0.00000000206,    -0.00000000138,
	  -0.00000003374,     0.00000002578,
	   0.00000002365,     0.00000001667,
	   0.00000000343,    -0.00000000822,
	  -0.00000004239,    -0.00000003027,
	  -0.00000001388,     0.00000002782,
	   0.00000000868,     0.00000000240,
	   0.00001033950,    -0.00000132208,
	  -0.00000104416,    -0.00000403942,
	  -0.00000080141,     0.00000033341,
	   0.00000006439,     0.00000010220,
	   0.00000011997,     0.00000089975,
	   0.00000035089,    -0.00000009317,
	  -0.00000002944,    -0.00000006938,
	  -0.00000000888,     0.00000000564,
	   0.00000000078,     0.00000000079,
	  -0.00000001636,    -0.00000002836,
	  -0.00000001411,     0.00000001095,
	   0.00000000343,     0.00000000329,
	   0.00000000048,    -0.00000000067,
	   0.00000004096,     0.00000004964,
	   0.00000001531,    -0.00000002065,
	  -0.00000000518,    -0.00000000170,
	  -0.00000000209,    -0.00000000342,
	  -0.00000000112,     0.00000000080,
	   0.00000000115,    -0.00000000277,
	  -0.00000000104,    -0.00000000011,
	  -0.00000000354,    -0.00000000484,
	  -0.00000000126,     0.00000000235,
	  -0.00000000483,     0.00000000354,
	   0.00000000235,     0.00000000126,
	   0.00000000045,    -0.00000000009,
	  -0.00000000010,    -0.00000000044,
	  -0.00000000011,    -0.00000000049,
	  -0.00000016133,    -0.00000020996,
	  -0.00000005406,     0.00000010480,
	  -0.00000000612,     0.00000000450,
	   0.00000000298,     0.00000000160,
	  -0.00000000143,     0.00000000019,
	  -0.00000000019,    -0.00000000143,
	   0.00000044308,    -0.00000014541,
	  -0.00000006505,    -0.00000016403,
	  -0.00000003043,     0.00000001625,
	   0.00000003300,     0.00000009836,
	   0.00000003642,    -0.00000001458,
	  -0.00000000356,    -0.00000000671,
	  -0.00000000078,     0.00000000055,
	  -0.00000006551,     0.00000000580,
	   0.00000000628,     0.00000002526,
	   0.00000000498,    -0.00000000208,
	  -0.00000000040,    -0.00000000062,
	  -0.00000000909,    -0.00000005816,
	  -0.00000002316,     0.00000000588,
	   0.00000000181,     0.00000000459,
	  -0.00000564042,     0.00000160481,
	   0.00000075743,     0.00000212624,
	   0.00000039654,    -0.00000019521,
	  -0.00000003398,    -0.00000004749,
	  -0.00000015209,    -0.00000043172,
	  -0.00000015854,     0.00000006579,
	   0.00000001584,     0.00000002904,
	   0.00000000348,    -0.00000000261,
	   0.00000056050,    -0.00000006921,
	  -0.00000005644,    -0.00000021792,
	  -0.00000004308,     0.00000001803,
	   0.00000000348,     0.00000000547,
	   0.00000007207,     0.00000053744,
	   0.00000021077,    -0.00000005516,
	  -0.00000001755,    -0.00000004193,
	  -0.00000000532,     0.00000000337,
	   0.00000000138,     0.00000000153,
	  -0.00000000021,     0.00000000167,
	  -0.00000011215,    -0.00000000038,
	   0.00000000902,     0.00000003894,
	   0.00000000671,    -0.00000000314,
	  -0.00000000025,    -0.00000003030,
	  -0.00000001033,     0.00000000249,
	   0.00000000083,     0.00000000182,
	   0.00000003567,    -0.00000000998,
	  -0.00000000497,    -0.00000001284,
	  -0.00000000240,     0.00000000129,
	   0.00000001229,     0.00000003233,
	   0.00000001240,    -0.00000000501,
	  -0.00000000126,    -0.00000000232,
	   0.00000198985,    -0.00000008672,
	  -0.00000018369,    -0.00000066400,
	  -0.00000011365,     0.00000005525,
	   0.00000000981,     0.00000001213,
	  -0.00000000082,     0.00000014572,
	   0.00000004888,    -0.00000001139,
	  -0.00000000371,    -0.00000000847,
	  -0.00000000088,     0.00000000065,
	  -0.00000030196,     0.00000009121,
	   0.00000004231,     0.00000011221,
	   0.00000002070,    -0.00000001071,
	  -0.00000000186,    -0.00000000240,
	  -0.00000009512,    -0.00000029438,
	  -0.00000011025,     0.00000004240,
	   0.00000001060,     0.00000002041,
	   0.00000000236,    -0.00000000180,
	   0.00000000049,    -0.00000000191,
	  -0.00000000083,    -0.00000000018,
	   0.00000000152,     0.00000000023,
	  -0.00000000063,     0.00000000054,
	   0.00000003946,     0.00000001205,
	  -0.00000000417,     0.00000001250,
	   0.00000000300,    -0.00000000028,
	  -0.00000001223,     0.00000000024,
	   0.00000000109,     0.00000000417,
	   0.00000000079,    -0.00000000040,
	  -0.00000000131,    -0.00000001126,
	  -0.00000000413,     0.00000000112,
	   0.00000000041,     0.00000000085,
	  -0.00000069761,    -0.00000018959,
	   0.00000002136,     0.00000018449,
	   0.00000002851,    -0.00000001366,
	   0.00000001731,    -0.00000005481,
	  -0.00000001419,     0.00000000080,
	   0.00000000096,     0.00000000217,
	   0.00000010453,    -0.00000000199,
	  -0.00000000908,    -0.00000003564,
	  -0.00000000616,     0.00000000296,
	   0.00000000060,     0.00000000068,
	   0.00000000482,     0.00000010217,
	   0.00000003503,    -0.00000000911,
	  -0.00000000293,    -0.00000000604,
	  -0.00000000070,     0.00000000062,
	  -0.00000000035,     0.00000000137,
	  -0.00000000129,    -0.00000000021,
	  -0.00000000061,     0.00000000058,
	  -0.00000001624,    -0.00000001334,
	   0.00000000545,    -0.00000000636,
	   0.00000000488,     0.00000000134,
	  -0.00000000017,    -0.00000000125,
	  -0.00000000117,     0.00000000491,
	   0.00000000145,    -0.00000000016,
	   0.00000025476,     0.00000019360,
	  -0.00000000436,    -0.00000005916,
	  -0.00000001854,     0.00000002215,
	   0.00000000523,    -0.00000000016,
	  -0.00000000030,    -0.00000000073,
	  -0.00000004232,    -0.00000001176,
	   0.00000000101,     0.00000001108,
	   0.00000000176,    -0.00000000088,
	   0.00000001056,    -0.00000004204,
	  -0.00000001082,     0.00000000103,
	   0.00000000089,     0.00000000178,
	  -0.00000000216,    -0.00000000027,
	   0.00000000203,    -0.00000000051,
	   0.00000000510,     0.00000001211,
	  -0.00000000989,     0.00000000408,
	  -0.00000000263,    -0.00000000186,
	   0.00000000220,    -0.00000000260,
	  -0.00000008634,    -0.00000015830,
	  -0.00000000069,     0.00000003314,
	   0.00000002740,    -0.00000001403,
	  -0.00000000549,    -0.00000000017,
	   0.00000002421,     0.00000001850,
	  -0.00000000033,    -0.00000000539,
	  -0.00000001788,     0.00000002433,
	   0.00000000545,    -0.00000000039,
	  -0.00000000103,    -0.00000000030,
	   0.00000000074,     0.00000000058,
	  -0.00000000031,     0.00000000167,
	  -0.00000000169,    -0.00000000032,
	   0.00000000802,    -0.00000000083,
	  -0.00000000058,    -0.00000006834,
	  -0.00000000678,     0.00000001513,
	  -0.00000001201,     0.00000000028,
	   0.00000000338,     0.00000000152,
	   0.00000000544,     0.00000001144,
	   0.00000000008,    -0.00000000234,
	  -0.00000001123,     0.00000000571,
	   0.00000000232,     0.00000000007,
	   0.00000229177,    -0.00000064533,
	  -0.00000078802,    -0.00000124994,
	  -0.00000032228,     0.00000035066,
	   0.00000009249,     0.00000004929,
	  -0.00000001960,    -0.00000006951,
	  -0.00000003791,     0.00000002391,
	   0.00000001056,     0.00000000998,
	   0.00000000153,    -0.00000000278,
	  -0.00000016284,     0.00000002428,
	   0.00000001799,     0.00000006319,
	   0.00000001240,    -0.00000000558,
	  -0.00000000416,    -0.00000002783,
	  -0.00000001081,     0.00000000308,
	   0.00000000094,     0.00000000210,
	  -0.00000000035,     0.00000000068,
	  -0.00000000049,     0.00000000096,
	   0.00000000096,     0.00000000049,
	   0.00000161126,    -0.00000023968,
	  -0.00000017760,    -0.00000062527,
	  -0.00000012277,     0.00000005524,
	   0.00000001164,     0.00000007814,
	   0.00000003032,    -0.00000000863,
	  -0.00000000268,    -0.00000000594,
	  -0.00000000075,     0.00000000051,
	  -0.00000000243,    -0.00000000383,
	  -0.00000000248,     0.00000000142,
	   0.00000000049,     0.00000000060,
	   0.00000000738,    -0.00000000026,
	  -0.00000000108,    -0.00000000283,
	  -0.00000000066,     0.00000000044,
	   0.00000000503,    -0.00000001023,
	   0.00000000187,     0.00000000115,
	  -0.00000000523,     0.00000000065,
	   0.00000000056,     0.00000000200,
	  -0.00000000087,    -0.00000000504,
	  -0.00000000198,     0.00000000057,
	  -0.00000007217,     0.00000015328,
	   0.00000004328,     0.00000002183,
	  -0.00000000469,    -0.00000000308,
	  -0.00000000114,     0.00000000163,
	   0.00000004828,    -0.00000000704,
	  -0.00000000531,    -0.00000001871,
	  -0.00000000366,     0.00000000165,
	   0.00000000740,     0.00000004801,
	   0.00000001866,    -0.00000000534,
	  -0.00000000165,    -0.00000000366,
	   0.00000002036,     0.00000003134,
	  -0.00000000138,     0.00000000097,
	  -0.00000000189,     0.00000000370,
	   0.00000000112,     0.00000000061,
	  -0.00000000371,    -0.00000000190,
	  -0.00000000060,     0.00000000113,
	   0.00000000060,     0.00000000091,
	  -0.00000000090,     0.00000000060,
	   0.00000000286,    -0.00000000311,
	   0.00000000310,     0.00000000286,
	  -0.00000000124,     0.00000000373,
	   0.00000000132,     0.00000000028,
	  -0.00000000091,     0.00000001226,
	   0.00000000387,    -0.00000000011,
	   0.00000001227,     0.00000000087,
	  -0.00000000015,    -0.00000000385,
	  -0.00000000053,     0.00000000043,
	   0.00000000014,     0.00000000013,
	   0.00000000045,     0.00000000066,
	   0.00000000017,    -0.00000000015,
	   0.00000000009,     0.00000000045,
	   0.00000000064,     0.00000000018,
	   0.00000000018,    -0.00000000064,
	  -0.00000000039,     0.00000000031,
	   0.00000000031,     0.00000000039,
	   0.00000000041,     0.00000000106,
	   0.00000000037,    -0.00000000025,
	   0.00000000124,     0.00000000282,
	   0.00000000089,    -0.00000000059,
	   0.00000000282,    -0.00000000125,
	  -0.00000000059,    -0.00000000089,
	  -0.00000000058,    -0.00000000090,
	  -0.00000000092,     0.00000000059,
	   0.00000000668,    -0.00000000312,
	  -0.00000000157,    -0.00000000295,
	  -0.00000004506,    -0.00000001559,
	  -0.00000000444,     0.00000001689,
	  -0.00000001562,     0.00000004492,
	   0.00000001681,     0.00000000448,
	  -0.00000000199,    -0.00000000051,
	  -0.00000000039,     0.00000000199,
	  -0.00000000631,     0.00000001433,
	   0.00000001097,     0.00000000215,
	  -0.00000001105,    -0.00000001303,
	  -0.00000000611,     0.00000000681,
	   0.00000000208,     0.00000000143,
	  -0.00000011951,     0.00000006867,
	   0.00000002991,     0.00000004645,
	   0.00000000869,    -0.00000000635,
	   0.00000007400,     0.00000013937,
	   0.00000006158,    -0.00000003639,
	  -0.00000000991,    -0.00000001437,
	  -0.00000000236,     0.00000000191,
	  -0.00000000544,    -0.00000000383,
	  -0.00000000085,     0.00000000145,
	  -0.00000000352,     0.00000000545,
	   0.00000000148,     0.00000000068,
	  -0.00000001815,    -0.00000121196,
	  -0.00000079083,     0.00000008332,
	   0.00000005460,     0.00000026072,
	   0.00000005717,    -0.00000001884,
	  -0.00000000433,    -0.00000000945,
	  -0.00000001072,     0.00000005414,
	   0.00000002934,     0.00000000116,
	  -0.00000000074,    -0.00000000788,
	   0.00000056546,     0.00000047155,
	   0.00000023374,    -0.00000031529,
	  -0.00000008788,    -0.00000005684,
	  -0.00000000929,     0.00000001589,
	   0.00000000217,     0.00000000096,
	   0.00000043998,    -0.00000064972,
	  -0.00000037891,    -0.00000020037,
	  -0.00000004024,     0.00000011196,
	   0.00000002202,     0.00000000424,
	  -0.00000000014,    -0.00000000315,
	   0.00000001370,     0.00000001002,
	   0.00000000208,    -0.00000000341,
	   0.00000000952,    -0.00000001403,
	  -0.00000000353,    -0.00000000181,
	   0.00000003387,    -0.00000000333,
	  -0.00000000562,    -0.00000001736,
	  -0.00000000426,     0.00000000258,
	   0.00000000064,     0.00000000065,
	   0.00000010790,     0.00000046382,
	   0.00000021814,    -0.00000010608,
	  -0.00000003964,    -0.00000005065,
	  -0.00000000759,     0.00000000884,
	   0.00000000139,     0.00000000076,
	   0.00000046357,    -0.00000010760,
	  -0.00000010589,    -0.00000021802,
	  -0.00000005060,     0.00000003954,
	   0.00000000881,     0.00000000760,
	   0.00000000076,    -0.00000000138,
	  -0.00000000254,    -0.00000000276,
	  -0.00000000082,     0.00000000095,
	  -0.00000000251,     0.00000000280,
	   0.00000000102,     0.00000000067,
	  -0.00000000407,     0.00000000710,
	   0.00000000400,     0.00000000127,
	   0.00000000013,    -0.00000000110,
	   0.00000013347,     0.00000058377,
	   0.00000027469,    -0.00000013257,
	  -0.00000004968,    -0.00000006380,
	  -0.00000000952,     0.00000001107,
	   0.00000000175,     0.00000000095,
	   0.00000058337,    -0.00000013340,
	  -0.00000013245,    -0.00000027447,
	  -0.00000006377,     0.00000004962,
	   0.00000001104,     0.00000000951,
	   0.00000000095,    -0.00000000174,
	   0.00000000001,    -0.00000000009,
	  -0.00000000003,     0.00000000000,
	  -0.00000000079,    -0.00000000005,
	   0.00000000001,     0.00000000023,
	  -0.00000000055,     0.00000000010,
	   0.00000000005,     0.00000000015,
	   0.00000000009,     0.00000000059,
	   0.00000000016,    -0.00000000004,
	   0.00000000237,     0.00000001163,
	  -0.00000000561,     0.00000000082,
	   0.00000000045,     0.00000000159,
	   0.00000000083,     0.00000000560,
	   0.00000000159,    -0.00000000045,
	  -0.00000000014,     0.00000000002,
	   0.00000000001,     0.00000000004,
	   0.00000000010,     0.00000000063,
	   0.00000000018,    -0.00000000005,
	  -0.00000000001,    -0.00000000008,
	  -0.00000000038,    -0.00000000098,
	  -0.00000000098,     0.00000000038,
	  -0.00000000001,    -0.00000000002,
	  -0.00000000007,     0.00000000003,
	  -0.00000000001,    -0.00000000005,
	  -0.00000000398,     0.00000000062,
	   0.00000000033,     0.00000000117,
	   0.00000000061,     0.00000000397,
	   0.00000000117,    -0.00000000033,
	   0.00000002674,     0.00000013231,
	   0.00000004568,    -0.00000002016,
	  -0.00000000483,     0.00000000098,
	   0.00000000075,     0.00000000168,
	  -0.00000006361,     0.00000000929,
	   0.00000000493,     0.00000001810,
	   0.00000000931,     0.00000006370,
	   0.00000001809,    -0.00000000495,
	  -0.00000000189,     0.00000000029,
	   0.00000000015,     0.00000000055,
	   0.00000000071,     0.00000000458,
	   0.00000000135,    -0.00000000038,
	  -0.00000000079,     0.00000000036,
	  -0.00000001124,     0.00000000174,
	   0.00000000089,     0.00000000323,
	   0.00000000165,     0.00000001138,
	   0.00000000323,    -0.00000000088,
	   0.00000002886,     0.00000014355,
	   0.00000004952,    -0.00000002183,
	  -0.00000000497,     0.00000000101,
	   0.00000000077,     0.00000000173,
	  -0.00000006889,     0.00000001001,
	   0.00000000532,     0.00000001961,
	   0.00000001003,     0.00000006900,
	   0.00000001959,    -0.00000000534,
	  -0.00000000715,     0.00000000110,
	   0.00000000057,     0.00000000207,
	   0.00000000197,     0.00000001277,
	   0.00000000369,    -0.00000000101,
	   0.00000000007,    -0.00000000102,
	  -0.00000000102,    -0.00000000007,
	  -0.00000000104,     0.00000000016,
	  -0.00000000016,    -0.00000000104,
	   0.00000001209,     0.00000000394,
	   0.00000000107,    -0.00000000443,
	   0.00000000957,    -0.00000002802,
	  -0.00000001028,    -0.00000000261,
	  -0.00000004342,     0.00000000618,
	   0.00000000328,     0.00000001246,
	   0.00000000634,     0.00000004289,
	   0.00000001217,    -0.00000000337,
	   0.00000000254,     0.00000001290,
	  -0.00000000617,     0.00000000095,
	   0.00000000049,     0.00000000176,
	   0.00000000095,     0.00000000618,
	   0.00000000177,    -0.00000000049,
	  -0.00000003988,     0.00000000580,
	   0.00000000309,     0.00000001146,
	   0.00000000693,     0.00000004764,
	   0.00000001365,    -0.00000000368,
	   0.00000000081,     0.00000000104,
	   0.00000000026,    -0.00000000046,
	   0.00000000018,     0.00000000260,
	   0.00000000082,    -0.00000000004,
	  -0.00000000277,     0.00000000171,
	   0.00000000046,     0.00000000059,
	   0.00000000119,     0.00000000196,
	   0.00000000041,    -0.00000000034,
	  -0.00000000392,     0.00000000064,
	   0.00000000033,     0.00000000117,
	  -0.00000000052,    -0.00000000387,
	  -0.00000000116,     0.00000000030,
	  -0.00000000042,     0.00000000031,
	  -0.00000000030,    -0.00000000042,
	   0.00000000101,     0.00000000061,
	   0.00000009068,    -0.00000013850,
	  -0.00000001070,    -0.00000000693,
	   0.00000000016,     0.00000000310,
	   0.00000000164,    -0.00000000048,
	   0.00000000312,    -0.00000000017,
	  -0.00000000049,    -0.00000000164,
	   0.00000000174,    -0.00000000160,
	  -0.00000000089,    -0.00000000053,
	  -0.00000000160,    -0.00000000174,
	  -0.00000000053,     0.00000000089,
	  -0.00000003895,    -0.00000012396,
	  -0.00000005500,     0.00000003300,
	  -0.00000000381,     0.00000000103,
	   0.00000000094,     0.00000000169,
	   0.00000000019,     0.00000000087,
	  -0.00000003752,     0.00000000627,
	  -0.00000000051,    -0.00000000235,
	  -0.00000000087,     0.00000000032,
	  -0.00000000069,    -0.00000000236,
	  -0.00000000108,     0.00000000060,
	   0.00000000231,    -0.00000000073,
	  -0.00000000060,    -0.00000000108,
	  -0.00000000204,     0.00000000039,
	   0.00000000027,     0.00000000075,
	  -0.00000000040,    -0.00000000202,
	  -0.00000000075,     0.00000000027,
	  -0.00000003071,    -0.00000001377,
	  -0.00000000511,     0.00000001461,
	   0.00000000441,    -0.00000000491,
	  -0.00000000266,    -0.00000000186,
	  -0.00000000040,     0.00000000072,
	   0.00000000684,    -0.00000000110,
	  -0.00000000065,    -0.00000000266,
	  -0.00000000122,    -0.00000000680,
	  -0.00000000262,     0.00000000078,
	   0.00000333262,     0.00001409960,
	   0.00000662802,    -0.00000324693,
	  -0.00000120910,    -0.00000153820,
	  -0.00000022553,     0.00000027091,
	   0.00000004220,     0.00000002267,
	   0.00000054747,    -0.00000010897,
	  -0.00000011755,    -0.00000025848,
	  -0.00000006028,     0.00000004516,
	   0.00000001018,     0.00000000904,
	   0.00000000085,    -0.00000000155,
	   0.00000006130,     0.00000000007,
	  -0.00000000211,    -0.00000002481,
	  -0.00000000525,     0.00000000083,
	  -0.00000002495,    -0.00000005914,
	  -0.00000002081,     0.00000001448,
	   0.00000000398,     0.00000000347,
	   0.00000000367,    -0.00000000208,
	  -0.00000000120,    -0.00000000106,
	   0.00000000309,     0.00000000070,
	   0.00000000021,    -0.00000000150,
	   0.00000003945,     0.00000002101,
	   0.00000000035,     0.00000000214,
	   0.00000000085,    -0.00000000026,
	   0.00000000057,     0.00000000238,
	   0.00000000119,    -0.00000000056,
	  -0.00000000246,     0.00000000014,
	   0.00000000041,     0.00000000124,
	   0.00000002327,     0.00000013650,
	   0.00000006715,    -0.00000002815,
	   0.00000000388,    -0.00000000058,
	  -0.00000000075,    -0.00000000188,
	   0.00000000196,     0.00000000012,
	  -0.00000000010,     0.00000000196,
	  -0.00000000053,    -0.00000000108,
	   0.00000000122,     0.00000000000,
	   0.00000000090,    -0.00000000218,
	  -0.00000000219,    -0.00000000086,
	  -0.00000173797,     0.00000026072,
	   0.00000019394,     0.00000067406,
	   0.00000013231,    -0.00000005957,
	  -0.00000001137,    -0.00000001682,
	  -0.00000006474,    -0.00000042115,
	  -0.00000016318,     0.00000004770,
	   0.00000001441,     0.00000003161,
	   0.00000000392,    -0.00000000270,
	  -0.00000000160,     0.00000000727,
	   0.00000000295,    -0.00000000040,
	  -0.00000000027,    -0.00000000384,
	  -0.00000000182,     0.00000000083,
	  -0.00000000016,     0.00000000133,
	   0.00000000081,     0.00000000077,
	   0.00001599560,    -0.00000318540,
	  -0.00000214102,    -0.00000609011,
	  -0.00000116430,     0.00000062730,
	   0.00000011406,     0.00000014068,
	   0.00000001148,    -0.00000001465,
	   0.00000025569,     0.00000171705,
	   0.00000066686,    -0.00000019096,
	  -0.00000005870,    -0.00000013068,
	  -0.00000001653,     0.00000001102,
	   0.00000000150,     0.00000000140,
	   0.00000004095,     0.00000023888,
	   0.00000010783,    -0.00000004797,
	  -0.00000001826,    -0.00000002477,
	  -0.00000000358,     0.00000000418,
	   0.00000000069,     0.00000000038,
	  -0.00000019349,     0.00000010740,
	   0.00000007072,     0.00000009281,
	   0.00000002194,    -0.00000002224,
	  -0.00000000460,    -0.00000000316,
	  -0.00000000038,     0.00000000069,
	  -0.00000000359,    -0.00000000561,
	  -0.00000000187,     0.00000000131,
	   0.00000000169,    -0.00000000462,
	  -0.00000000173,    -0.00000000014,
	  -0.00000000098,     0.00000000050,
	  -0.00000000046,    -0.00000000106,
	  -0.00000001321,    -0.00000000759,
	  -0.00000000067,     0.00000000621,
	   0.00000000760,    -0.00000001585,
	  -0.00000000709,    -0.00000000092,
	   0.00000000139,     0.00000000899,
	   0.00000000461,    -0.00000000225,
	  -0.00000000090,    -0.00000000079,
	  -0.00000000964,     0.00000000220,
	   0.00000000252,     0.00000000468,
	   0.00000000097,    -0.00000000088,
	   0.00000062345,    -0.00000031945,
	  -0.00000012725,    -0.00000022152,
	  -0.00000003698,     0.00000002847,
	   0.00000009649,     0.00000023101,
	   0.00000008359,    -0.00000003989,
	  -0.00000000913,    -0.00000001407,
	  -0.00000000129,     0.00000000109,
	  -0.00000006115,    -0.00000003239,
	  -0.00000001687,     0.00000004273,
	   0.00000001125,     0.00000000180,
	  -0.00000000074,    -0.00000000116,
	   0.00000001250,    -0.00000019159,
	  -0.00000006956,     0.00000000463,
	   0.00000000277,     0.00000001395,
	   0.00000000111,    -0.00000000077,
	  -0.00000000028,    -0.00000000077,
	  -0.00000890681,     0.00000506145,
	   0.00000187262,     0.00000309276,
	   0.00000054097,    -0.00000038956,
	  -0.00000005770,    -0.00000006149,
	  -0.00000048542,    -0.00000083746,
	  -0.00000029044,     0.00000017635,
	   0.00000003623,     0.00000005082,
	   0.00000000583,    -0.00000000534,
	  -0.00000000068,    -0.00000000047,
	   0.00000109085,    -0.00000017687,
	  -0.00000013192,    -0.00000041099,
	  -0.00000007883,     0.00000003924,
	   0.00000000707,     0.00000000974,
	   0.00000000086,    -0.00000000087,
	   0.00000016578,     0.00000096928,
	   0.00000038414,    -0.00000011500,
	  -0.00000003553,    -0.00000007589,
	  -0.00000000950,     0.00000000676,
	   0.00000000089,     0.00000000089,
	   0.00000000320,     0.00000000241,
	   0.00000000078,    -0.00000000095,
	   0.00000000033,     0.00000000333,
	   0.00000000104,    -0.00000000024,
	   0.00000000067,     0.00000000034,
	   0.00000005432,    -0.00000000845,
	  -0.00000000874,    -0.00000001116,
	  -0.00000000109,     0.00000000181,
	  -0.00000000839,    -0.00000005428,
	  -0.00000001114,     0.00000000870,
	   0.00000000180,     0.00000000110,
	   0.00000001318,    -0.00000000287,
	   0.00000000029,     0.00000000131,
	   0.00000001410,    -0.00000000306,
	   0.00000000030,     0.00000000138,
	   0.00000257743,    -0.00000039922,
	  -0.00000041386,    -0.00000052934,
	  -0.00000005175,     0.00000008543,
	  -0.00000001024,    -0.00000006630,
	  -0.00000001362,     0.00000001065,
	   0.00000000220,     0.00000000132,
	   0.00000000023,     0.00000000108,
	  -0.00000000108,     0.00000000023,
	  -0.00000000318,     0.00000000036,
	  -0.00000000168,    -0.00000000130,
	  -0.00000000130,     0.00000000180,
	  -0.00000025019,     0.00000000408,
	   0.00000002765,     0.00000006963,
	   0.00000000984,    -0.00000000800,
	  -0.00000000527,    -0.00000010383,
	  -0.00000002848,     0.00000001174,
	   0.00000000303,     0.00000000402,
	   0.00000008013,    -0.00000003396,
	  -0.00000001472,    -0.00000002508,
	  -0.00000000444,     0.00000000319,
	   0.00000004587,     0.00000006126,
	   0.00000002446,    -0.00000001482,
	  -0.00000000306,    -0.00000000440,
	  -0.00000000058,     0.00000000050,
	  -0.00000000043,     0.00000000096,
	   0.00000754931,    -0.00000129836,
	  -0.00000111080,    -0.00000191550,
	  -0.00000025635,     0.00000023625,
	   0.00000002947,     0.00000002204,
	   0.00000004867,     0.00000038114,
	   0.00000011092,    -0.00000004743,
	  -0.00000001113,    -0.00000001694,
	  -0.00000000156,     0.00000000159,
	  -0.00000061390,     0.00000034870,
	   0.00000012871,     0.00000021278,
	   0.00000003724,    -0.00000002674,
	  -0.00000000395,    -0.00000000424,
	  -0.00000035577,    -0.00000059794,
	  -0.00000020931,     0.00000012840,
	   0.00000002634,     0.00000003682,
	   0.00000000419,    -0.00000000387,
	   0.00000000042,    -0.00000000499,
	  -0.00000000192,    -0.00000000021,
	   0.00000000396,    -0.00000000010,
	   0.00000000010,    -0.00000000159,
	  -0.00000000012,    -0.00000000136,
	   0.00000000138,    -0.00000000004,
	  -0.00000000980,    -0.00000016200,
	  -0.00000005189,     0.00000000358,
	  -0.00000000414,     0.00000000028,
	   0.00000000009,     0.00000000134,
	  -0.00000000505,    -0.00000000382,
	   0.00000000902,    -0.00000001170,
	  -0.00000000065,    -0.00000000217,
	   0.00000000064,     0.00000000207,
	   0.00000000218,    -0.00000000107,
	   0.00000017920,     0.00000005973,
	   0.00000000102,    -0.00000002519,
	  -0.00000003867,     0.00000012332,
	   0.00000001900,    -0.00000000046,
	  -0.00000000142,    -0.00000000154,
	  -0.00000004590,    -0.00000000306,
	   0.00000000573,     0.00000001235,
	   0.00000000218,    -0.00000000168,
	  -0.00000001794,    -0.00000003662,
	  -0.00000001230,     0.00000000590,
	   0.00000000180,     0.00000000234,
	   0.00000000021,    -0.00000000124,
	  -0.00000306133,    -0.00000037653,
	   0.00000023778,     0.00000062582,
	   0.00000007630,    -0.00000006819,
	   0.00000007729,    -0.00000043379,
	  -0.00000008692,     0.00000002627,
	   0.00000000903,     0.00000001074,
	   0.00000000103,    -0.00000000157,
	   0.00000050763,    -0.00000008247,
	  -0.00000007184,    -0.00000013751,
	  -0.00000001963,     0.00000001595,
	   0.00000000247,     0.00000000193,
	   0.00000009098,     0.00000050094,
	   0.00000013571,    -0.00000007167,
	  -0.00000001589,    -0.00000001935,
	  -0.00000000197,     0.00000000260,
	  -0.00000000039,     0.00000000569,
	   0.00000000222,     0.00000000026,
	  -0.00000000536,     0.00000000015,
	  -0.00000000018,     0.00000000210,
	   0.00000000114,    -0.00000000481,
	  -0.00000000472,    -0.00000000132,
	  -0.00000000007,    -0.00000000213,
	  -0.00000000262,    -0.00000000128,
	   0.00000000074,    -0.00000000291,
	  -0.00000000290,    -0.00000000074,
	   0.00000001839,    -0.00000009451,
	  -0.00000000240,    -0.00000000047,
	  -0.00000001361,    -0.00000001254,
	  -0.00000013147,     0.00000014355,
	   0.00000024233,     0.00000020109,
	  -0.00000000877,    -0.00000003587,
	   0.00000044338,    -0.00000053060,
	  -0.00000007999,     0.00000001955,
	  -0.00000006477,    -0.00000001130,
	   0.00000000300,     0.00000000949,
	   0.00000000983,    -0.00000003520,
	  -0.00000001102,     0.00000000313,
	  -0.00000237041,    -0.00000163842,
	   0.00000011220,     0.00000043076,
	   0.00000004359,    -0.00000003305,
	  -0.00000053511,     0.00000079722,
	   0.00000014521,    -0.00000003937,
	  -0.00000001284,    -0.00000001694,
	   0.00000044647,     0.00000006899,
	  -0.00000002858,    -0.00000008893,
	  -0.00000001150,     0.00000001014,
	  -0.00000005852,     0.00000044504,
	   0.00000008687,    -0.00000002827,
	  -0.00000001074,    -0.00000001198,
	  -0.00000000220,     0.00000000579,
	  -0.00000000572,    -0.00000000152,
	   0.00000000068,    -0.00000000190,
	  -0.00000000196,    -0.00000000078,
	   0.00000000037,    -0.00000000098,
	  -0.00000000098,    -0.00000000037,
	   0.00000000046,    -0.00000000122,
	  -0.00000000122,    -0.00000000046,
	   0.00000001032,    -0.00000002412,
	   0.00000006317,    -0.00000018642,
	  -0.00000000625,    -0.00000000114,
	  -0.00000000041,    -0.00000000087,
	   0.00000000133,    -0.00000000042,
	  -0.00000000467,    -0.00000001230,
	  -0.00000000367,     0.00000000144,
	   0.00000000178,     0.00000000119,
	  -0.00000000135,     0.00000000172,
	   0.00000005066,     0.00000009488,
	  -0.00000000156,    -0.00000001772,
	   0.00000000157,    -0.00000000149,
	  -0.00000001526,    -0.00000001075,
	   0.00000000062,     0.00000000276,
	   0.00000001046,    -0.00000001533,
	  -0.00000000280,     0.00000000065,
	   0.00000003184,    -0.00000008752,
	  -0.00000000306,    -0.00000000100,
	  -0.00000000044,     0.00000002898,
	  -0.00000000070,     0.00000000129,
	   0.00000000178,    -0.00000000438,
	   0.00000000432,     0.00000000167,
	   0.00000000030,     0.00000000266,
	   0.00000000089,     0.00000000198,
	  -0.00000000194,     0.00000000094,
	  -0.00000000030,     0.00000000119,
	   0.00000000075,    -0.00000000185,
	   0.00000000186,     0.00000000057,
	  -0.00000000501,     0.00000001833,
	   0.00000000888,     0.00000000243,
	  -0.00000000246,    -0.00000000276,
	   0.00000000278,    -0.00000000246,
	   0.00000000004,    -0.00000000119,
	  -0.00000000072,    -0.00000000042,
	  -0.00000000042,     0.00000000072,
	   0.00000000157,    -0.00000000002,
	  -0.00000000002,    -0.00000000157,
	   0.00000000087,    -0.00000000015,
	  -0.00000000014,    -0.00000000088,
	   0.00000583578,     0.00002554545,
	   0.00001201946,    -0.00000579774,
	  -0.00000217228,    -0.00000279179,
	  -0.00000040980,     0.00000048804,
	   0.00000007629,     0.00000004142,
	   0.00000074124,    -0.00000017012,
	  -0.00000016862,    -0.00000034879,
	  -0.00000008101,     0.00000006315,
	   0.00000001405,     0.00000001208,
	   0.00000000120,    -0.00000000221,
	   0.00000000842,    -0.00000000241,
	  -0.00000000130,    -0.00000000286,
	   0.00000000058,    -0.00000001350,
	  -0.00000000570,     0.00000000034,
	   0.00000000020,     0.00000000124,
	   0.00000000190,     0.00000000000,
	   0.00000000006,     0.00000000183,
	  -0.00000000463,     0.00000000830,
	   0.00000001285,     0.00000000676,
	   0.00000000144,    -0.00000000273,
	  -0.00000001461,     0.00000000185,
	   0.00000000157,     0.00000000559,
	   0.00000000109,    -0.00000000049,
	  -0.00000000242,    -0.00000001410,
	  -0.00000000548,     0.00000000162,
	   0.00000000049,     0.00000000109,
	  -0.00000027848,     0.00000055946,
	   0.00000016266,     0.00000007321,
	   0.00000000832,    -0.00000002541,
	  -0.00000002752,    -0.00000001517,
	  -0.00000000414,     0.00000000797,
	   0.00000000123,     0.00000000051,
	   0.00000012985,    -0.00000001656,
	  -0.00000001299,    -0.00000005037,
	  -0.00000000992,     0.00000000405,
	   0.00000000078,     0.00000000125,
	   0.00000001759,     0.00000012898,
	   0.00000005021,    -0.00000001308,
	  -0.00000000403,    -0.00000000990,
	  -0.00000000125,     0.00000000078,
	  -0.00000000534,    -0.00000000625,
	   0.00000000147,    -0.00000000111,
	   0.00000000096,    -0.00000000195,
	   0.00000000197,     0.00000000093,
	  -0.00000000002,     0.00000000126,
	   0.00000006778,     0.00000010151,
	  -0.00000000488,     0.00000000358,
	   0.00000000065,     0.00000000045,
	  -0.00000000870,     0.00000001758,
	   0.00000000512,     0.00000000226,
	   0.00000000025,    -0.00000000080,
	  -0.00000001762,    -0.00000000863,
	  -0.00000000225,     0.00000000514,
	   0.00000000080,     0.00000000025,
	   0.00000000215,     0.00000000316,
	  -0.00000000313,     0.00000000216,
	  -0.00000000225,     0.00000000031,
	   0.00000000034,     0.00000000078,
	  -0.00000000058,    -0.00000000083,
	  -0.00000000017,     0.00000000015,
	  -0.00000000088,     0.00000000021,
	   0.00000000003,     0.00000000021,
	   0.00000000004,    -0.00000000007,
	  -0.00000000014,     0.00000000000,
	  -0.00000000692,     0.00000000134,
	   0.00000000105,     0.00000000241,
	   0.00000000306,    -0.00000000049,
	  -0.00000000025,    -0.00000000085,
	  -0.00000000052,    -0.00000000306,
	  -0.00000000084,     0.00000000025,
	  -0.00000001087,     0.00000000209,
	   0.00000000160,     0.00000000375,
	   0.00000000636,    -0.00000000122,
	  -0.00000000058,    -0.00000000186,
	  -0.00000000122,    -0.00000000643,
	  -0.00000000183,     0.00000000060,
	  -0.00000002495,     0.00000001537,
	   0.00000000732,     0.00000000831,
	   0.00000002418,    -0.00000000602,
	  -0.00000000263,    -0.00000000694,
	  -0.00000000415,    -0.00000002390,
	  -0.00000000695,     0.00000000175,
	   0.00000053222,     0.00000057698,
	   0.00000026522,    -0.00000031174,
	  -0.00000009252,    -0.00000006197,
	  -0.00000000911,     0.00000001818,
	  -0.00000040573,     0.00000029119,
	   0.00000018555,     0.00000019256,
	   0.00000004491,    -0.00000005717,
	  -0.00000001166,    -0.00000000684,
	  -0.00000122987,     0.00000019234,
	   0.00000014925,     0.00000048142,
	   0.00000009496,    -0.00000004735,
	  -0.00000000930,    -0.00000001167,
	   0.00000012989,     0.00000119970,
	   0.00000046951,    -0.00000010419,
	  -0.00000003144,    -0.00000009351,
	  -0.00000001201,     0.00000000565,
	  -0.00000007168,     0.00000000680,
	   0.00000000477,     0.00000000999,
	   0.00000000077,    -0.00000000080,
	   0.00000000618,     0.00000007127,
	   0.00000000981,    -0.00000000441,
	  -0.00000000083,    -0.00000000076,
	   0.00000038067,    -0.00000194750,
	  -0.00000085087,    -0.00000007285,
	   0.00000002056,     0.00000021693,
	   0.00000003620,    -0.00000001078,
	   0.00000058797,    -0.00000082333,
	  -0.00000046026,    -0.00000028184,
	  -0.00000006562,     0.00000013024,
	   0.00000002457,     0.00000000896,
	   0.00000000089,    -0.00000000341,
	  -0.00000157010,     0.00000007913,
	   0.00000009175,     0.00000061391,
	   0.00000011936,    -0.00000002508,
	  -0.00000000316,    -0.00000001631,
	   0.00000036028,     0.00000165266,
	   0.00000063905,    -0.00000028611,
	  -0.00000009184,    -0.00000011772,
	  -0.00000001367,     0.00000001883,
	   0.00000000230,     0.00000000141,
	   0.00000017554,    -0.00000001960,
	  -0.00000001325,    -0.00000002385,
	  -0.00000000169,     0.00000000219,
	  -0.00000001548,    -0.00000017536,
	  -0.00000002395,     0.00000001109,
	   0.00000000156,     0.00000000176,
	   0.00000003115,     0.00000002482,
	   0.00000001074,    -0.00000001696,
	  -0.00000003916,     0.00000029376,
	   0.00000012679,     0.00000000232,
	  -0.00000000283,    -0.00000002789,
	  -0.00000000405,     0.00000000098,
	  -0.00000434331,     0.00000067550,
	   0.00000049198,     0.00000168334,
	   0.00000033075,    -0.00000014880,
	  -0.00000002759,    -0.00000004179,
	  -0.00000000372,     0.00000000360,
	   0.00000067482,     0.00000433898,
	   0.00000168072,    -0.00000049140,
	  -0.00000014830,    -0.00000032998,
	  -0.00000004165,     0.00000002745,
	   0.00000000354,     0.00000000373,
	   0.00000000571,     0.00000000226,
	   0.00000000056,    -0.00000000177,
	  -0.00000000013,    -0.00000000289,
	  -0.00000006818,    -0.00000003858,
	  -0.00000001179,     0.00000002960,
	   0.00000000654,     0.00000000153,
	   0.00000000004,    -0.00000000099,
	  -0.00000539355,     0.00000082852,
	   0.00000060799,     0.00000209098,
	   0.00000041043,    -0.00000018424,
	  -0.00000003429,    -0.00000005197,
	  -0.00000000466,     0.00000000449,
	   0.00000082762,     0.00000538863,
	   0.00000208857,    -0.00000060673,
	  -0.00000018364,    -0.00000040983,
	  -0.00000005187,     0.00000003411,
	   0.00000000445,     0.00000000466,
	  -0.00000010353,     0.00000001569,
	   0.00000000821,     0.00000002945,
	  -0.00000000167,    -0.00000001089,
	  -0.00000000310,     0.00000000087,
	   0.00000000042,    -0.00000000060,
	  -0.00000000074,    -0.00000000039,
	  -0.00000000766,    -0.00000001976,
	   0.00000000190,    -0.00000000075,
	  -0.00000115929,     0.00000017363,
	   0.00000009097,     0.00000033039,
	  -0.00000001819,    -0.00000011977,
	  -0.00000003415,     0.00000000948,
	   0.00000000472,    -0.00000000677,
	  -0.00000000123,    -0.00000000095,
	  -0.00000000835,    -0.00000000444,
	  -0.00000000079,     0.00000000172,
	   0.00000000427,    -0.00000000657,
	   0.00000000064,     0.00000000041,
	   0.00000000013,     0.00000000077,
	   0.00000000018,    -0.00000000044,
	  -0.00000124037,     0.00000018494,
	   0.00000009688,     0.00000035355,
	  -0.00000001906,    -0.00000012578,
	  -0.00000003580,     0.00000000997,
	   0.00000000503,    -0.00000000717,
	  -0.00000000132,    -0.00000000102,
	  -0.00000000912,    -0.00000000497,
	  -0.00000000085,     0.00000000184,
	  -0.00000000060,    -0.00000000025,
	   0.00000000159,    -0.00000002050,
	   0.00000000197,     0.00000000014,
	  -0.00000000209,     0.00000000051,
	   0.00000000019,     0.00000000062,
	   0.00000000123,     0.00000000603,
	   0.00000000179,    -0.00000000055,
	   0.00000000097,    -0.00000000205,
	  -0.00000000052,    -0.00000000016,
	  -0.00000000128,    -0.00000000122,
	  -0.00000000033,     0.00000000022,
	  -0.00000010916,     0.00000001641,
	   0.00000000862,     0.00000003092,
	  -0.00000000165,    -0.00000001072,
	  -0.00000000306,     0.00000000085,
	  -0.00000000086,    -0.00000000038,
	   0.00000000108,    -0.00000000155,
	  -0.00000000037,    -0.00000000020,
	  -0.00000000193,    -0.00000000130,
	  -0.00000000024,     0.00000000039,
	  -0.00000000835,     0.00000000535,
	  -0.00000000051,    -0.00000000079,
	  -0.00000001992,     0.00000000377,
	  -0.00000000029,    -0.00000000153,
	   0.00000000018,     0.00000000097,
	  -0.00000002989,     0.00000000570,
	  -0.00000000046,    -0.00000000240,
	   0.00000003178,    -0.00000000608,
	   0.00000000028,     0.00000000152,
	  -0.00000000102,     0.00000000019,
	   0.00000000101,    -0.00000000019,
	   0.00000000018,     0.00000000098,
	  -0.00000004426,     0.00000000849,
	  -0.00000000073,    -0.00000000375,
	  -0.00000000085,     0.00000000061,
	   0.00000004810,    -0.00000000907,
	   0.00000000045,     0.00000000236,
	  -0.00000000015,    -0.00000000166,
	  -0.00000000155,     0.00000000031,
	  -0.00000000027,    -0.00000000142,
	   0.00000000009,     0.00000000107,
	   0.00000000158,    -0.00000000030,
	   0.00000000029,     0.00000000151,
	   0.00000000019,     0.00000000104,
	   0.00000000104,    -0.00000000018,
	  -0.00000000011,    -0.00000000145,
	  -0.00000006443,     0.00000001253,
	   0.00000001018,     0.00000001409,
	  -0.00000000116,    -0.00000000587,
	  -0.00000000133,     0.00000000096,
	   0.00000011607,    -0.00000001333,
	  -0.00000001282,    -0.00000003217,
	   0.00000000074,     0.00000000233,
	   0.00000000081,    -0.00000000058,
	  -0.00000002527,     0.00000000151,
	  -0.00000000025,    -0.00000000245,
	  -0.00000000238,     0.00000000048,
	  -0.00000000043,    -0.00000000223,
	   0.00000003067,    -0.00000000270,
	   0.00000000014,     0.00000000158,
	   0.00000000347,    -0.00000000043,
	   0.00000000043,     0.00000000328,
	  -0.00000000447,    -0.00000000237,
	   0.00000000296,    -0.00000000440,
	   0.00000000448,     0.00000000280,
	   0.00000002738,    -0.00000000918,
	   0.00000001135,     0.00000000484,
	   0.00000000034,     0.00000000121,
	   0.00000000314,    -0.00000000436,
	   0.00000000455,     0.00000000305,
	  -0.00000000008,    -0.00000000113,
	   0.00000000106,    -0.00000000010,
	   0.00000000008,     0.00000000104,
	  -0.00000000128,     0.00000000122,
	   0.00000000066,     0.00000000038,
	   0.00000000122,     0.00000000129,
	   0.00000000035,    -0.00000000066,
	  -0.00000001542,     0.00000003328,
	   0.00000001680,     0.00000000770,
	   0.00000000018,    -0.00000000249,
	  -0.00000000188,     0.00000000000,
	  -0.00000001947,    -0.00000000785,
	  -0.00000000267,     0.00000000911,
	   0.00000000222,     0.00000000048,
	  -0.00000000781,     0.00000001982,
	   0.00000000931,     0.00000000257,
	   0.00000000040,    -0.00000000225,
	   0.00000001039,     0.00000001007,
	   0.00000000274,    -0.00000000398,
	  -0.00000000079,    -0.00000000037,
	   0.00000001002,    -0.00000001041,
	  -0.00000000398,    -0.00000000273,
	  -0.00000000037,     0.00000000079,
	  -0.00000000107,     0.00000000032,
	   0.00000123814,    -0.00000028667,
	  -0.00000017501,    -0.00000045409,
	  -0.00000008424,     0.00000004734,
	  -0.00000000756,    -0.00000003305,
	  -0.00000001244,     0.00000000479,
	   0.00000000130,     0.00000000230,
	   0.00000000188,    -0.00000000017,
	   0.00000000016,     0.00000000175,
	  -0.00000013854,     0.00000001820,
	   0.00000001757,     0.00000003733,
	  -0.00000000196,    -0.00000000737,
	  -0.00000000209,     0.00000000152,
	   0.00000013267,    -0.00000003060,
	  -0.00000001757,    -0.00000003330,
	   0.00000000305,     0.00000000654,
	   0.00000000127,    -0.00000000091,
	   0.00000002431,    -0.00000000537,
	  -0.00000000339,    -0.00000000895,
	  -0.00000000165,     0.00000000093,
	   0.00000000534,     0.00000002435,
	   0.00000000894,    -0.00000000338,
	  -0.00000000093,    -0.00000000165,
	  -0.00000002918,     0.00000000284,
	  -0.00000000044,    -0.00000000373,
	  -0.00000000080,     0.00000000053,
	  -0.00000000371,     0.00000000077,
	   0.00000000061,     0.00000000083,
	  -0.00000000070,    -0.00000000353,
	  -0.00000000082,     0.00000000060,
	   0.00000003425,    -0.00000001005,
	   0.00000000023,     0.00000000240,
	   0.00000000513,    -0.00000000204,
	  -0.00000000060,    -0.00000000083,
	   0.00000000201,     0.00000000502,
	   0.00000000081,    -0.00000000059,
	  -0.00000000008,    -0.00000000118,
	  -0.00000000168,     0.00000000015,
	  -0.00000000015,    -0.00000000181,
	   0.00000000167,    -0.00000000018,
	   0.00000000015,     0.00000000165,
	  -0.00000000005,     0.00000000106,
	  -0.00000000090,     0.00000000232,
	   0.00000000232,     0.00000000098,
	  -0.00000021887,     0.00000003816,
	   0.00000002758,     0.00000008404,
	   0.00000001623,    -0.00000000831,
	  -0.00000002418,    -0.00000012647,
	  -0.00000004897,     0.00000001665,
	   0.00000000459,     0.00000000902,
	   0.00000000100,    -0.00000000079,
	  -0.00000000565,    -0.00000000420,
	  -0.00000000106,     0.00000000277,
	   0.00000000097,    -0.00000000027,
	   0.00000000042,     0.00000000119,
	   0.00000000040,     0.00000000063,
	  -0.00014589156,     0.00002252466,
	   0.00001645578,     0.00005654364,
	   0.00001109676,    -0.00000497909,
	  -0.00000092404,    -0.00000140272,
	  -0.00000012645,     0.00000012163,
	   0.00000083166,     0.00000526410,
	   0.00000203896,    -0.00000060319,
	  -0.00000018183,    -0.00000039969,
	  -0.00000005057,     0.00000003359,
	   0.00000000438,     0.00000000445,
	  -0.00000007963,     0.00000001478,
	   0.00000001056,     0.00000003398,
	   0.00000000705,    -0.00000000376,
	  -0.00000000088,    -0.00000000095,
	  -0.00000003232,    -0.00000019498,
	  -0.00000007327,     0.00000002731,
	   0.00000000836,     0.00000001372,
	   0.00000000161,    -0.00000000141,
	   0.00000002194,     0.00000001721,
	   0.00000000414,    -0.00000000841,
	  -0.00000000164,    -0.00000000043,
	  -0.00000002366,     0.00000002101,
	   0.00000000788,     0.00000000694,
	   0.00000000107,    -0.00000000155,
	  -0.00000025169,     0.00000002913,
	   0.00000002533,     0.00000009824,
	  -0.00000002327,     0.00000000099,
	   0.00000000240,     0.00000001000,
	   0.00000000204,    -0.00000000081,
	  -0.00000000352,    -0.00000002606,
	  -0.00000001001,     0.00000000238,
	   0.00000000081,     0.00000000204,
	  -0.00000000097,     0.00000000025,
	   0.00000000025,     0.00000000097,
	  -0.00000000103,     0.00000000026,
	   0.00000000026,     0.00000000103,
	  -0.00000134651,     0.00000012745,
	   0.00000013067,     0.00000054655,
	   0.00000011171,    -0.00000004509,
	   0.00000000332,     0.00000003441,
	   0.00000001359,    -0.00000000324,
	  -0.00000000110,    -0.00000000277,
	   0.00000000021,     0.00000000092,
	  -0.00000000870,     0.00000001952,
	  -0.00000000257,    -0.00000000150,
	  -0.00000000049,     0.00000000071,
	   0.00000007683,    -0.00000007000,
	  -0.00000002312,    -0.00000001870,
	  -0.00000000096,    -0.00000000010,
	  -0.00000000404,     0.00000000142,
	   0.00000000057,     0.00000000150,
	  -0.00000000142,    -0.00000000403,
	  -0.00000000150,     0.00000000057,
	  -0.00000005277,     0.00000000836,
	  -0.00000000257,    -0.00000001476,
	  -0.00000000293,     0.00000000222,
	  -0.00000001180,     0.00000000266,
	   0.00000000204,     0.00000000266,
	  -0.00000000251,    -0.00000001189,
	  -0.00000000276,     0.00000000206,
	   0.00000008551,    -0.00000001071,
	   0.00000000115,     0.00000000958,
	   0.00000000204,    -0.00000000138,
	   0.00000001196,    -0.00000000266,
	  -0.00000000189,    -0.00000000257,
	   0.00000000259,     0.00000001184,
	   0.00000000259,    -0.00000000190,
	   0.00000000020,     0.00000001240,
	  -0.00000000260,    -0.00000004130,
	  -0.00000006291,     0.00000000617,
	   0.00000000545,     0.00000005540,
	   0.00000002106,    -0.00000000992,
	  -0.00000000202,    -0.00000000290,
	   0.00000000929,     0.00000002445,
	   0.00000000290,    -0.00000000202,
	  -0.00000005090,     0.00000000224,
	   0.00000000017,     0.00000001066,
	   0.00000000303,    -0.00000000213,
	  -0.00000001082,     0.00000000140,
	   0.00000000185,     0.00000000263,
	  -0.00000000092,    -0.00000001045,
	  -0.00000000263,     0.00000000184,
	   0.00000001557,    -0.00000003862,
	  -0.00000001069,    -0.00000000246,
	   0.00000007077,     0.00000003222,
	   0.00000000508,    -0.00000001997,
	  -0.00000000302,     0.00000000023,
	   0.00000002489,     0.00000003526,
	   0.00000000395,    -0.00000000414,
	   0.00000003388,    -0.00000002500,
	  -0.00000000442,    -0.00000000385,
	   0.00000046374,    -0.00000052277,
	  -0.00000015062,    -0.00000014303,
	  -0.00000002297,     0.00000002441,
	   0.00000049463,     0.00000038401,
	   0.00000011319,    -0.00000014154,
	  -0.00000002106,    -0.00000001647,
	  -0.00000000103,     0.00000000207,
	  -0.00000038767,    -0.00000010318,
	   0.00000001435,     0.00000012741,
	   0.00000002198,    -0.00000001019,
	  -0.00000000154,    -0.00000000265,
	  -0.00000018571,    -0.00000018168,
	  -0.00000009207,     0.00000004869,
	   0.00000000973,     0.00000002148,
	   0.00000000274,    -0.00000000188,
	  -0.00000000230,    -0.00000000302,
	  -0.00000000306,     0.00000000034,
	  -0.00000254426,     0.00001409012,
	   0.00000328462,    -0.00000009666,
	  -0.00000015635,    -0.00000033973,
	  -0.00000001196,     0.00000002907,
	  -0.00000298415,    -0.00000206509,
	  -0.00000056113,     0.00000085771,
	   0.00000013096,     0.00000007637,
	   0.00000000693,    -0.00000001383,
	  -0.00000000121,    -0.00000000031,
	  -0.00000215160,     0.00000034767,
	   0.00000024584,     0.00000082252,
	   0.00000016052,    -0.00000007234,
	  -0.00000001297,    -0.00000002010,
	  -0.00000000193,     0.00000000174,
	  -0.00000029340,    -0.00000201726,
	  -0.00000079237,     0.00000021801,
	   0.00000006768,     0.00000015664,
	   0.00000002022,    -0.00000001307,
	  -0.00000000168,    -0.00000000180,
	   0.00000001016,     0.00000000425,
	   0.00000000140,    -0.00000000267,
	   0.00000000541,     0.00000000775,
	   0.00000000183,    -0.00000000175,
	   0.00000001203,    -0.00000002024,
	   0.00000000281,     0.00000000163,
	  -0.00000000609,     0.00000000060,
	   0.00000000092,     0.00000000129,
	   0.00000000181,     0.00000000630,
	   0.00000000122,    -0.00000000091,
	  -0.00000003916,     0.00000000991,
	  -0.00000000049,    -0.00000000191,
	  -0.00000004143,     0.00000001048,
	  -0.00000000052,    -0.00000000201,
	  -0.00000005841,     0.00000001783,
	   0.00000001091,     0.00000002391,
	   0.00000000041,     0.00000000139,
	  -0.00000000176,    -0.00000000151,
	   0.00000001638,    -0.00000001445,
	   0.00000000095,     0.00000000005,
	  -0.00000000084,     0.00000000020,
	  -0.00000000023,    -0.00000000089,
	  -0.00000004166,     0.00000001502,
	  -0.00000000513,    -0.00000001470,
	  -0.00000000351,     0.00000000289,
	  -0.00000000101,     0.00000000158,
	   0.00000000125,     0.00000000072,
	  -0.00000000130,    -0.00000000151,
	  -0.00000000056,     0.00000000086,
	  -0.00000030974,     0.00000005344,
	   0.00000005010,     0.00000006977,
	   0.00000000459,     0.00000001387,
	   0.00000000303,    -0.00000000229,
	   0.00000000119,    -0.00000000214,
	   0.00000000205,     0.00000000114,
	  -0.00000000090,     0.00000000018,
	  -0.00000000060,    -0.00000000143,
	  -0.00000000005,    -0.00000000049,
	  -0.00000000019,    -0.00000000005,
	  -0.00000000189,    -0.00000000331,
	   0.00000000027,    -0.00000000103,
	  -0.00000000089,    -0.00000000021,
	  -0.00000000327,    -0.00000000587,
	   0.00000000065,    -0.00000000225,
	  -0.00000000209,    -0.00000000049,
	  -0.00000000294,    -0.00000000871,
	   0.00000000225,    -0.00000000673,
	  -0.00000000623,    -0.00000000106,
	  -0.00000123265,     0.00000022888,
	   0.00000021001,     0.00000024313,
	   0.00000002394,    -0.00000004485,
	   0.00000715974,     0.00004591314,
	   0.00000903064,    -0.00000733246,
	  -0.00000174197,    -0.00000092995,
	   0.00000043326,    -0.00000100587,
	  -0.00000015297,    -0.00000002386,
	  -0.00000107643,    -0.00000020576,
	   0.00000013056,     0.00000015154,
	   0.00000001850,    -0.00000000989,
	  -0.00000002758,     0.00000000273,
	   0.00001779589,    -0.00000344001,
	  -0.00000304355,    -0.00000361979,
	  -0.00000034234,     0.00000057043,
	   0.00000002686,     0.00000001184,
	  -0.00002352879,    -0.00014410756,
	  -0.00002939355,     0.00002355185,
	   0.00000470232,     0.00000283645,
	   0.00000010171,    -0.00000022786,
	  -0.00000363963,     0.00000596391,
	   0.00000118701,     0.00000054015,
	   0.00000009557,    -0.00000016462,
	  -0.00000001260,    -0.00000001236,
	   0.00000256470,    -0.00000094307,
	  -0.00000102057,    -0.00000000272,
	   0.00000008633,     0.00000012973,
	   0.00000001237,    -0.00000001258,
	  -0.00000000923,    -0.00000000368,
	   0.00000003238,     0.00000000267,
	  -0.00010764343,     0.00002360911,
	   0.00001778971,     0.00002366959,
	   0.00000264395,    -0.00000328290,
	  -0.00000043946,    -0.00000019755,
	   0.00002768911,     0.00014277808,
	   0.00003130602,    -0.00002291044,
	  -0.00000412347,    -0.00000346618,
	  -0.00000027873,     0.00000061790,
	   0.00000996990,    -0.00001393331,
	  -0.00000402559,    -0.00000269784,
	  -0.00000036439,     0.00000061056,
	   0.00000007337,     0.00000003762,
	   0.00001418015,     0.00000954471,
	   0.00000263770,    -0.00000403768,
	  -0.00000060721,    -0.00000035970,
	  -0.00000003618,     0.00000007196,
	  -0.00000001182,     0.00000011474,
	   0.00000005440,     0.00000000831,
	  -0.00000007269,     0.00000000638,
	  -0.00000000663,     0.00000004107,
	  -0.00000000831,    -0.00000001031,
	  -0.00000000272,     0.00000000241,
	  -0.00000000557,     0.00000000865,
	  -0.00000000894,    -0.00000000480,
	   0.00000004126,    -0.00000001307,
	  -0.00000000850,    -0.00000001672,
	  -0.00000000044,    -0.00000000134,
	  -0.00000000441,    -0.00000000158,
	  -0.00000000114,     0.00000000189,
	   0.00000000144,    -0.00000000024,
	  -0.00000000085,    -0.00000000057,
	  -0.00000002458,     0.00000007060,
	   0.00000000421,     0.00000000198,
	   0.00000000057,    -0.00000000091,
	   0.00000000133,     0.00000000066,
	   0.00000001249,    -0.00000002149,
	   0.00000001897,     0.00000001124,
	   0.00000002450,    -0.00000004192,
	  -0.00000000308,    -0.00000000176,
	  -0.00000000606,    -0.00000000075,
	  -0.00000000073,     0.00000000540,
	  -0.00000025897,    -0.00000013593,
	  -0.00000000939,     0.00000002536,
	  -0.00000005914,     0.00000010624,
	   0.00000000919,     0.00000000546,
	   0.00000005897,    -0.00000000458,
	  -0.00000000864,    -0.00000000825,
	  -0.00000000108,     0.00000000157,
	   0.00000001337,     0.00000000949,
	   0.00000000835,    -0.00000000409,
	  -0.00000000166,    -0.00000000116,
	   0.00000000009,     0.00000000107,
	  -0.00000000095,     0.00000000032,
	   0.00000183187,     0.00000049085,
	  -0.00000007461,    -0.00000027098,
	  -0.00000002664,     0.00000003059,
	   0.00000000035,    -0.00000002324,
	  -0.00000000409,     0.00000000313,
	   0.00000000065,     0.00000000057,
	  -0.00000017064,     0.00000004316,
	   0.00000003013,     0.00000003898,
	   0.00000000450,    -0.00000000594,
	  -0.00000000126,    -0.00000000062,
	  -0.00000004995,    -0.00000016564,
	  -0.00000003803,     0.00000002990,
	   0.00000000584,     0.00000000441,
	   0.00000000062,    -0.00000000126,
	  -0.00000000089,    -0.00000000484,
	  -0.00000000164,     0.00000000028,
	   0.00000000447,    -0.00000000135,
	  -0.00000000034,    -0.00000000155,
	   0.00000000622,    -0.00000000119,
	  -0.00000000097,    -0.00000000132,
	   0.00000000123,     0.00000000629,
	   0.00000000132,    -0.00000000098,
	   0.00000001797,    -0.00000001946,
	  -0.00000000092,     0.00000000512,
	  -0.00000000045,    -0.00000000079,
	   0.00000000601,     0.00000000306,
	   0.00000000091,    -0.00000000049,
	  -0.00000000041,     0.00000000098,
	   0.00000000103,     0.00000000041,
	   0.00000000176,    -0.00000000438,
	  -0.00000000465,    -0.00000000174,
	  -0.00000000032,     0.00000000085,
	  -0.00000001581,     0.00000004720,
	   0.00000000145,    -0.00000000015,
	  -0.00000000164,     0.00000000316,
	   0.00000000084,     0.00000000041,
	   0.00000000390,     0.00000000171,
	   0.00000000039,    -0.00000000082,
	   0.00000002574,    -0.00000000280,
	  -0.00000000043,    -0.00000000740,
	  -0.00000000107,     0.00000000055,
	  -0.00000000074,    -0.00000000051,
	   0.00000033391,    -0.00000007292,
	  -0.00000005648,    -0.00000007502,
	   0.00000000123,     0.00000001013,
	   0.00000000218,    -0.00000000154,
	  -0.00000000287,    -0.00000000517,
	  -0.00000000644,     0.00000000357,
	   0.00000000114,     0.00000000121,
	   0.00000000093,    -0.00000000089,
	   0.00000003592,     0.00000005588,
	   0.00000001474,    -0.00000000728,
	  -0.00000000098,    -0.00000000056,
	  -0.00000001028,    -0.00000000598,
	   0.00000000112,     0.00000000125,
	  -0.00000000394,    -0.00000000122,
	  -0.00000000086,     0.00000000039,
	  -0.00000022846,    -0.00000019825,
	   0.00000000751,     0.00000003042,
	   0.00000000474,    -0.00000000323,
	   0.00000003252,     0.00000001124,
	  -0.00000000055,    -0.00000000428,
	  -0.00000000061,     0.00000000081,
	  -0.00000001047,     0.00000003246,
	   0.00000000416,    -0.00000000051,
	  -0.00000000087,    -0.00000000063,
	  -0.00000000136,     0.00000000371,
	   0.00000000375,     0.00000000129,
	   0.00000000074,    -0.00000000195,
	  -0.00000000210,    -0.00000000075,
	  -0.00000000380,     0.00000001600,
	   0.00000254170,     0.00000061520,
	  -0.00000000870,    -0.00000001200,
	  -0.00000001190,     0.00000000870,
	   0.00000005590,    -0.00000022030,
	  -0.00000765002,    -0.00000193740,
	   0.00000002750,     0.00000004230,
	   0.00000005430,    -0.00000004530,
	  -0.00000019415,     0.00000098102,
	   0.00000018565,     0.00000018303,
	   0.00000483909,     0.00000004725,
	   0.00000110285,    -0.00000112443,
	  -0.00000003708,     0.00000014157,
	   0.00000007004,     0.00000001031,
	   0.00000047198,    -0.00000123395,
	  -0.00000248378,    -0.00000095240,
	   0.00000002391,    -0.00000011895,
	  -0.00000011721,    -0.00000002272,
	  -0.00000000849,     0.00000005466,
	   0.00000001530,     0.00000000586,
	   0.00000001502,     0.00000000268,
	   0.00000000157,    -0.00000000410,
	   0.00000000794,    -0.00000000007,
	  -0.00000000139,    -0.00000000185,
	  -0.00000000289,    -0.00000000896,
	  -0.00000000194,     0.00000000141,
	   0.00000002388,    -0.00000014062,
	  -0.00000002843,    -0.00000000983,
	  -0.00000000928,    -0.00000000250,
	  -0.00000000094,     0.00000000231,
	  -0.00000000866,     0.00000000248,
	   0.00000000128,     0.00000000178,
	   0.00000000050,     0.00000000801,
	   0.00000000187,    -0.00000000140,
	  -0.00000002937,     0.00000001155,
	   0.00000000019,    -0.00000000103,
	  -0.00000001506,    -0.00000000455,
	  -0.00000000071,     0.00000000397,
	   0.00000000066,    -0.00000000189,
	  -0.00000000272,     0.00000000052,
	   0.00000001874,     0.00000004062,
	  -0.00000000560,    -0.00000000532,
	   0.00000000035,     0.00000000093,
	   0.00000000525,    -0.00000000562,
	  -0.00000000096,     0.00000000035,
	   0.00000000030,    -0.00000000089,
	  -0.00000000089,    -0.00000000030,
	   0.00000109110,     0.00000041150,
	  -0.00000001870,     0.00000004990,
	  -0.00000321530,    -0.00000120700,
	  -0.00000001360,    -0.00000001180,
	  -0.00000001170,     0.00000001360,
	   0.00000016160,    -0.00000047390,
	   0.00000528904,     0.00000180825,
	   0.00000002267,    -0.00000007237,
	  -0.00000006982,    -0.00000002321,
	  -0.00000030751,     0.00000044443,
	   0.00000012784,     0.00000009072,
	  -0.00000250682,    -0.00000175029,
	  -0.00000032973,     0.00000046466,
	  -0.00000001908,     0.00000007071,
	   0.00000007259,     0.00000002315,
	   0.00000000154,     0.00000000042,
	   0.00000000055,    -0.00000000068,
	  -0.00000000036,     0.00000000314,
	   0.00000000150,    -0.00000000026,
	   0.00000001522,    -0.00000004762,
	  -0.00000000119,    -0.00000000058,
	  -0.00000000004,    -0.00000000146,
	  -0.00000000261,    -0.00000000017,
	  -0.00000000559,     0.00000003803,
	   0.00000000421,     0.00000000005,
	   0.00000000028,    -0.00000000107,
	   0.00000000663,    -0.00000000633,
	  -0.00000000079,    -0.00000000107,
	   0.00000000449,    -0.00000000316,
	  -0.00000000111,     0.00000000080,
	  -0.00000000048,    -0.00000003415,
	  -0.00000000237,    -0.00000000003,
	  -0.00000000471,     0.00000000037,
	   0.00000000077,     0.00000000106,
	   0.00000000157,     0.00000000515,
	   0.00000000110,    -0.00000000083,
	   0.00000010536,    -0.00000002112,
	  -0.00000001702,    -0.00000002303,
	  -0.00000000231,    -0.00000001201,
	  -0.00000000258,     0.00000000190,
	  -0.00000011283,     0.00000002421,
	   0.00000001832,     0.00000002461,
	   0.00000000140,     0.00000000750,
	   0.00000000165,    -0.00000000123,
	   0.00000000043,     0.00000000103,
	  -0.00000000101,     0.00000000045,
	   0.00000000940,     0.00000000640,
	  -0.00000002770,    -0.00000001740,
	   0.00000000939,    -0.00000001827,
	   0.00000005329,     0.00000002730,
	  -0.00000000816,     0.00000002722,
	  -0.00000002575,    -0.00000000775,
	   0.00000000086,     0.00000000030,
	   0.00000000130,    -0.00000000224,
	   0.00000000352,     0.00000000123,
	  -0.00000000006,    -0.00000000114,
	   0.00000000165,    -0.00000000061,
	   0.00000000299,    -0.00000000005,
	  -0.00000000051,    -0.00000000069,
	  -0.00000000120,    -0.00000000331,
	  -0.00000000071,     0.00000000052,
	  -0.00000000094,     0.00000000038,
	  -0.00000000317,     0.00000000055,
	   0.00000000050,     0.00000000069,
	   0.00000000073,     0.00000000324,
	   0.00000000072,    -0.00000000053,
	   0.00000007939,    -0.00000001785,
	  -0.00000001305,    -0.00000001752,
	  -0.00000000157,    -0.00000000792,
	  -0.00000000172,     0.00000000129,
	  -0.00000008509,     0.00000001673,
	   0.00000001385,     0.00000001865,
	   0.00000000098,     0.00000000498,
	   0.00000000109,    -0.00000000082,
	  -0.00000000113,    -0.00000000040,
	   0.00000000083,     0.00000000028,
	   0.00000000073,    -0.00000000067,
	   0.00000000201,    -0.00000000012,
	  -0.00000000073,    -0.00000000214,
	  -0.00000000212,     0.00000000040,
	   0.00000000046,     0.00000000213,
	   0.00000005764,    -0.00000001171,
	  -0.00000000952,    -0.00000001270,
	  -0.00000000106,    -0.00000000521,
	  -0.00000000113,     0.00000000084,
	  -0.00000006144,     0.00000001215,
	   0.00000000066,     0.00000000329,
	   0.00000000072,    -0.00000000055,
	   0.0000000013