/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Wed May 27 18:50:23 2015

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_38 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 26775, "epsg", 26775,
        "NAD27 / Iowa North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.26666666666667 +lat_2=42.06666666666");
    add_proj4text (p, 1,
        "667 +lat_0=41.5 +lon_0=-93.5 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa North\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",43.26666666666667],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",42.06666666666667],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",41.5],PARAMETER[\"central_meridian\",-9");
    add_srs_wkt (p, 11,
        "3.5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26775\"]]");
    p = add_epsg_def_ex (filter, first, last, 26776, "epsg", 26776,
        "NAD27 / Iowa South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.78333333333333 +lat_2=40.61666666666");
    add_proj4text (p, 1,
        "667 +lat_0=40 +lon_0=-93.5 +x_0=609601.2192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Iowa South\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 8,
        "\"standard_parallel_1\",41.78333333333333],PARAMETER[\"s");
    add_srs_wkt (p, 9,
        "tandard_parallel_2\",40.61666666666667],PARAMETER[\"lati");
    add_srs_wkt (p, 10,
        "tude_of_origin\",40],PARAMETER[\"central_meridian\",-93.");
    add_srs_wkt (p, 11,
        "5],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_northing\",0],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 13,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26776\"]]");
    p = add_epsg_def_ex (filter, first, last, 26777, "epsg", 26777,
        "NAD27 / Kansas North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=39.78333333333333 +lat_2=38.71666666666");
    add_proj4text (p, 1,
        "667 +lat_0=38.33333333333334 +lon_0=-98 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas North\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",39.78333333333333],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",38.71666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",38.33333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-98],PARAMETER[\"false_easting\",2000000],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26777\"]]");
    p = add_epsg_def_ex (filter, first, last, 26778, "epsg", 26778,
        "NAD27 / Kansas South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.56666666666667 +lat_2=37.26666666666");
    add_proj4text (p, 1,
        "667 +lat_0=36.66666666666666 +lon_0=-98.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kansas South\",GEOGCS[\"NAD27\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637");
    add_srs_wkt (p, 2,
        "8206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519");
    add_srs_wkt (p, 5,
        "9433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NOR");
    add_srs_wkt (p, 6,
        "TH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"");
    add_srs_wkt (p, 7,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 8,
        "[\"standard_parallel_1\",38.56666666666667],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_2\",37.26666666666667],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",36.66666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-98.5],PARAMETER[\"false_easting\",2000000],");
    add_srs_wkt (p, 12,
        "PARAMETER[\"false_northing\",0],UNIT[\"US survey foot\",");
    add_srs_wkt (p, 13,
        "0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"");
    add_srs_wkt (p, 14,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26778\"");
    add_srs_wkt (p, 15,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26779, "epsg", 26779,
        "NAD27 / Kentucky North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=37.96666666666667 +lat_2=38.96666666666");
    add_proj4text (p, 1,
        "667 +lat_0=37.5 +lon_0=-84.25 +x_0=609601.2192024384 +y_");
    add_proj4text (p, 2,
        "0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky North\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",37.96666666666667],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",38.96666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",37.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-84.25],PARAMETER[\"false_easting\",2000000],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26779\"]]");
    p = add_epsg_def_ex (filter, first, last, 26780, "epsg", 26780,
        "NAD27 / Kentucky South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=36.73333333333333 +lat_2=37.93333333333");
    add_proj4text (p, 1,
        "333 +lat_0=36.33333333333334 +lon_0=-85.75 +x_0=609601.2");
    add_proj4text (p, 2,
        "192024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Kentucky South\",GEOGCS[\"NAD27\",DATUM");
    add_srs_wkt (p, 1,
        "[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",");
    add_srs_wkt (p, 2,
        "6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]");
    add_srs_wkt (p, 3,
        "],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 4,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 5,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 6,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"426");
    add_srs_wkt (p, 7,
        "7\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAME");
    add_srs_wkt (p, 8,
        "TER[\"standard_parallel_1\",36.73333333333333],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",37.93333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",36.33333333333334],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-85.75],PARAMETER[\"false_easting\",20000");
    add_srs_wkt (p, 12,
        "00],PARAMETER[\"false_northing\",0],UNIT[\"US survey foo");
    add_srs_wkt (p, 13,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 14,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"267");
    add_srs_wkt (p, 15,
        "80\"]]");
    p = add_epsg_def_ex (filter, first, last, 26781, "epsg", 26781,
        "NAD27 / Louisiana North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=31.16666666666667 +lat_2=32.66666666666");
    add_proj4text (p, 1,
        "666 +lat_0=30.66666666666667 +lon_0=-92.5 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",31.16666666666667],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",32.66666666666666],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",30.66666666666667],PARAMETER[\"cent");
    add_srs_wkt (p, 11,
        "ral_meridian\",-92.5],PARAMETER[\"false_easting\",200000");
    add_srs_wkt (p, 12,
        "0],PARAMETER[\"false_northing\",0],UNIT[\"US survey foot");
    add_srs_wkt (p, 13,
        "\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS");
    add_srs_wkt (p, 14,
        "[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2678");
    add_srs_wkt (p, 15,
        "1\"]]");
    p = add_epsg_def_ex (filter, first, last, 26782, "epsg", 26782,
        "NAD27 / Louisiana South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=29.3 +lat_2=30.7 +lat_0=28.666666666666");
    add_proj4text (p, 1,
        "67 +lon_0=-91.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Louisiana South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",29.3],PARAMETER[\"standard_");
    add_srs_wkt (p, 9,
        "parallel_2\",30.7],PARAMETER[\"latitude_of_origin\",28.6");
    add_srs_wkt (p, 10,
        "6666666666667],PARAMETER[\"central_meridian\",-91.333333");
    add_srs_wkt (p, 11,
        "33333333],PARAMETER[\"false_easting\",2000000],PARAMETER");
    add_srs_wkt (p, 12,
        "[\"false_northing\",0],UNIT[\"US survey foot\",0.3048006");
    add_srs_wkt (p, 13,
        "096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST]");
    add_srs_wkt (p, 14,
        ",AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26782\"]]");
    p = add_epsg_def_ex (filter, first, last, 26783, "epsg", 26783,
        "NAD27 / Maine East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.83333333333334 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +units=us");
    add_proj4text (p, 2,
        "-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine East\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",43.83333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],PARAM");
    add_srs_wkt (p, 10,
        "ETER[\"false_easting\",500000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 11,
        "g\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 13,
        "H],AUTHORITY[\"EPSG\",\"26783\"]]");
    p = add_epsg_def_ex (filter, first, last, 26784, "epsg", 26784,
        "NAD27 / Maine West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=152400.3048006096 +y_0=0 +dat");
    add_proj4text (p, 2,
        "um=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maine West\",GEOGCS[\"NAD27\",DATUM[\"N");
    add_srs_wkt (p, 1,
        "orth_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6378");
    add_srs_wkt (p, 2,
        "206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AU");
    add_srs_wkt (p, 3,
        "THORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 4,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 5,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 6,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]");
    add_srs_wkt (p, 7,
        "],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latitu");
    add_srs_wkt (p, 8,
        "de_of_origin\",42.83333333333334],PARAMETER[\"central_me");
    add_srs_wkt (p, 9,
        "ridian\",-70.16666666666667],PARAMETER[\"scale_factor\",");
    add_srs_wkt (p, 10,
        "0.999966667],PARAMETER[\"false_easting\",500000],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 12,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 13,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26784\"]]");
    p = add_epsg_def_ex (filter, first, last, 26785, "epsg", 26785,
        "NAD27 / Maryland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.3 +lat_2=39.45 +lat_0=37.83333333333");
    add_proj4text (p, 1,
        "334 +lon_0=-77 +x_0=243840.4876809754 +y_0=0 +datum=NAD2");
    add_proj4text (p, 2,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Maryland\",GEOGCS[\"NAD27\",DATUM[\"Nor");
    add_srs_wkt (p, 1,
        "th_American_Datum_1927\",SPHEROID[\"Clarke 1866\",637820");
    add_srs_wkt (p, 2,
        "6.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]],AUTH");
    add_srs_wkt (p, 3,
        "ORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 4,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 5,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 6,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267\"]],");
    add_srs_wkt (p, 7,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 8,
        "standard_parallel_1\",38.3],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 9,
        "l_2\",39.45],PARAMETER[\"latitude_of_origin\",37.8333333");
    add_srs_wkt (p, 10,
        "3333334],PARAMETER[\"central_meridian\",-77],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "false_easting\",800000.0000000002],PARAMETER[\"false_nor");
    add_srs_wkt (p, 12,
        "thing\",0],UNIT[\"US survey foot\",0.3048006096012192,AU");
    add_srs_wkt (p, 13,
        "THORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",");
    add_srs_wkt (p, 14,
        "NORTH],AUTHORITY[\"EPSG\",\"26785\"]]");
    p = add_epsg_def_ex (filter, first, last, 26786, "epsg", 26786,
        "NAD27 / Massachusetts Mainland", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.71666666666667 +lat_2=42.68333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-71.5 +x_0=182880.3657607315 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Mainland\",GEOGCS[\"NAD27");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke");
    add_srs_wkt (p, 2,
        " 1866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 4,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 5,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 6,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",41.71666666666667],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",42.68333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",41],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-71.5],PARAMETER[\"false_easting\",600000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26786\"]]");
    p = add_epsg_def_ex (filter, first, last, 26787, "epsg", 26787,
        "NAD27 / Massachusetts Island", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=41.28333333333333 +lat_2=41.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=41 +lon_0=-70.5 +x_0=60960.12192024384 +y_0=0");
    add_proj4text (p, 2,
        " +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Massachusetts Island\",GEOGCS[\"NAD27\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1");
    add_srs_wkt (p, 2,
        "866\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7");
    add_srs_wkt (p, 3,
        "008\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich");
    add_srs_wkt (p, 4,
        "\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017");
    add_srs_wkt (p, 5,
        "4532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latit");
    add_srs_wkt (p, 6,
        "ude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 7,
        ",\"4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 8,
        "PARAMETER[\"standard_parallel_1\",41.28333333333333],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_2\",41.48333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"latitude_of_origin\",41],PARAMETER[\"central_merid");
    add_srs_wkt (p, 11,
        "ian\",-70.5],PARAMETER[\"false_easting\",200000],PARAMET");
    add_srs_wkt (p, 12,
        "ER[\"false_northing\",0],UNIT[\"US survey foot\",0.30480");
    add_srs_wkt (p, 13,
        "06096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAS");
    add_srs_wkt (p, 14,
        "T],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26787\"]]");
    p = add_epsg_def_ex (filter, first, last, 26791, "epsg", 26791,
        "NAD27 / Minnesota North", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.03333333333333 +lat_2=48.63333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota North\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",47.03333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",48.63333333333333],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",46.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-93.1],PARAMETER[\"false_easting\",2000000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26791\"]]");
    p = add_epsg_def_ex (filter, first, last, 26792, "epsg", 26792,
        "NAD27 / Minnesota Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.61666666666667 +lat_2=47.05 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=609601.2192024384 +y_0=0 +datum=NAD");
    add_proj4text (p, 2,
        "27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota Central\",GEOGCS[\"NAD27\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866");
    add_srs_wkt (p, 2,
        "\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008");
    add_srs_wkt (p, 3,
        "\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 4,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 5,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 6,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",45.61666666666667],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",47.05],PARAMETER[\"latitude_");
    add_srs_wkt (p, 10,
        "of_origin\",45],PARAMETER[\"central_meridian\",-94.25],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26792\"]]");
    p = add_epsg_def_ex (filter, first, last, 26793, "epsg", 26793,
        "NAD27 / Minnesota South", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43.78333333333333 +lat_2=45.21666666666");
    add_proj4text (p, 1,
        "667 +lat_0=43 +lon_0=-94 +x_0=609601.2192024384 +y_0=0 +");
    add_proj4text (p, 2,
        "datum=NAD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Minnesota South\",GEOGCS[\"NAD27\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAM");
    add_srs_wkt (p, 8,
        "ETER[\"standard_parallel_1\",43.78333333333333],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"standard_parallel_2\",45.21666666666667],PARAMETER[\"");
    add_srs_wkt (p, 10,
        "latitude_of_origin\",43],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-94],PARAMETER[\"false_easting\",2000000],PARAMETER[\"fa");
    add_srs_wkt (p, 12,
        "lse_northing\",0],UNIT[\"US survey foot\",0.304800609601");
    add_srs_wkt (p, 13,
        "2192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 14,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26793\"]]");
    p = add_epsg_def_ex (filter, first, last, 26794, "epsg", 26794,
        "NAD27 / Mississippi East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=29.66666666666667 +lon_0=-88.83333333");
    add_proj4text (p, 1,
        "333333 +k=0.99996 +x_0=152400.3048006096 +y_0=0 +datum=N");
    add_proj4text (p, 2,
        "AD27 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi East\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",29.66666666666667],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-88.83333333333333],PARAMETER[\"scale_fact");
    add_srs_wkt (p, 10,
        "or\",0.99996],PARAMETER[\"false_easting\",500000],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 12,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 13,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26794\"]]");
    p = add_epsg_def_ex (filter, first, last, 26795, "epsg", 26795,
        "NAD27 / Mississippi West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=30.5 +lon_0=-90.33333333333333 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Mississippi West\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",30.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 9,
        ",-90.33333333333333],PARAMETER[\"scale_factor\",0.999941");
    add_srs_wkt (p, 10,
        "177],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26795\"]]");
    p = add_epsg_def_ex (filter, first, last, 26796, "epsg", 26796,
        "NAD27 / Missouri East", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-90.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri East\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",35.83333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-90.5],PARAMETER[\"scale_factor\",0.99993333");
    add_srs_wkt (p, 10,
        "3],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26796\"]]");
    p = add_epsg_def_ex (filter, first, last, 26797, "epsg", 26797,
        "NAD27 / Missouri Central", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=35.83333333333334 +lon_0=-92.5 +k=0.9");
    add_proj4text (p, 1,
        "99933333 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri Central\",GEOGCS[\"NAD27\",DAT");
    add_srs_wkt (p, 1,
        "UM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\"");
    add_srs_wkt (p, 2,
        ",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"");
    add_srs_wkt (p, 3,
        "]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329");
    add_srs_wkt (p, 5,
        "25199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\"");
    add_srs_wkt (p, 6,
        ",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"42");
    add_srs_wkt (p, 7,
        "67\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"l");
    add_srs_wkt (p, 8,
        "atitude_of_origin\",35.83333333333334],PARAMETER[\"centr");
    add_srs_wkt (p, 9,
        "al_meridian\",-92.5],PARAMETER[\"scale_factor\",0.999933");
    add_srs_wkt (p, 10,
        "333],PARAMETER[\"false_easting\",500000],PARAMETER[\"fal");
    add_srs_wkt (p, 11,
        "se_northing\",0],UNIT[\"US survey foot\",0.3048006096012");
    add_srs_wkt (p, 12,
        "192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[");
    add_srs_wkt (p, 13,
        "\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26797\"]]");
    p = add_epsg_def_ex (filter, first, last, 26798, "epsg", 26798,
        "NAD27 / Missouri West", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=36.16666666666666 +lon_0=-94.5 +k=0.9");
    add_proj4text (p, 1,
        "99941177 +x_0=152400.3048006096 +y_0=0 +datum=NAD27 +uni");
    add_proj4text (p, 2,
        "ts=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / Missouri West\",GEOGCS[\"NAD27\",DATUM[");
    add_srs_wkt (p, 1,
        "\"North_American_Datum_1927\",SPHEROID[\"Clarke 1866\",6");
    add_srs_wkt (p, 2,
        "378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"7008\"]]");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\",0,AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925");
    add_srs_wkt (p, 5,
        "199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",N");
    add_srs_wkt (p, 6,
        "ORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4267");
    add_srs_wkt (p, 7,
        "\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"lat");
    add_srs_wkt (p, 8,
        "itude_of_origin\",36.16666666666666],PARAMETER[\"central");
    add_srs_wkt (p, 9,
        "_meridian\",-94.5],PARAMETER[\"scale_factor\",0.99994117");
    add_srs_wkt (p, 10,
        "7],PARAMETER[\"false_easting\",500000],PARAMETER[\"false");
    add_srs_wkt (p, 11,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 12,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26798\"]]");
    p = add_epsg_def_ex (filter, first, last, 26799, "epsg", 26799,
        "NAD27 / California zone VII", 0, 0,
        "Clarke 1866", "Greenwich",
        "North_American_Datum_1927", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=34.41666666666666 +lat_2=33.86666666666");
    add_proj4text (p, 1,
        "667 +lat_0=34.13333333333333 +lon_0=-118.3333333333333 +");
    add_proj4text (p, 2,
        "x_0=1276106.450596901 +y_0=1268253.006858014 +datum=NAD2");
    add_proj4text (p, 3,
        "7 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD27 / California zone VII\",GEOGCS[\"NAD27\",");
    add_srs_wkt (p, 1,
        "DATUM[\"North_American_Datum_1927\",SPHEROID[\"Clarke 18");
    add_srs_wkt (p, 2,
        "66\",6378206.4,294.9786982138982,AUTHORITY[\"EPSG\",\"70");
    add_srs_wkt (p, 3,
        "08\"]],AUTHORITY[\"EPSG\",\"6267\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 4,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 5,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 6,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 7,
        "4267\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"standard_parallel_1\",34.41666666666666],PARAME");
    add_srs_wkt (p, 9,
        "TER[\"standard_parallel_2\",33.86666666666667],PARAMETER");
    add_srs_wkt (p, 10,
        "[\"latitude_of_origin\",34.13333333333333],PARAMETER[\"c");
    add_srs_wkt (p, 11,
        "entral_meridian\",-118.3333333333333],PARAMETER[\"false_");
    add_srs_wkt (p, 12,
        "easting\",4186692.58],PARAMETER[\"false_northing\",41609");
    add_srs_wkt (p, 13,
        "26.74],UNIT[\"US survey foot\",0.3048006096012192,AUTHOR");
    add_srs_wkt (p, 14,
        "ITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORT");
    add_srs_wkt (p, 15,
        "H],AUTHORITY[\"EPSG\",\"26799\"]]");
    p = add_epsg_def_ex (filter, first, last, 26801, "epsg", 26801,
        "NAD Michigan / Michigan East (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-83.66666666666667 +k=0.9");
    add_proj4text (p, 1,
        "99942857 +x_0=152400.3048006096 +y_0=0 +a=6378450.047548");
    add_proj4text (p, 2,
        "896 +b=6356826.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan East (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866 Michigan\",6378450.047548896,294.97869716");
    add_srs_wkt (p, 3,
        "46772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-83.66666666666667],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"scale_factor\",0.999942857],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",500000],PARAMETER[\"false_northing\",0],UNIT[\"");
    add_srs_wkt (p, 12,
        "US survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 13,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"26801\"]]");
    p = add_epsg_def_ex (filter, first, last, 26802, "epsg", 26802,
        "NAD Michigan / Michigan Old Central (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-85.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan Old Central (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",S");
    add_srs_wkt (p, 2,
        "PHEROID[\"Clarke 1866 Michigan\",6378450.047548896,294.9");
    add_srs_wkt (p, 3,
        "786971646772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"E");
    add_srs_wkt (p, 4,
        "PSG\",\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 5,
        "\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORI");
    add_srs_wkt (p, 6,
        "TY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"L");
    add_srs_wkt (p, 7,
        "ongitude\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTIO");
    add_srs_wkt (p, 8,
        "N[\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 9,
        "n\",41.5],PARAMETER[\"central_meridian\",-85.75],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",0.999909091],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",500000],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 12,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 13,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"26802\"]]");
    p = add_epsg_def_ex (filter, first, last, 26803, "epsg", 26803,
        "NAD Michigan / Michigan West (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=41.5 +lon_0=-88.75 +k=0.999909091 +x_");
    add_proj4text (p, 1,
        "0=152400.3048006096 +y_0=0 +a=6378450.047548896 +b=63568");
    add_proj4text (p, 2,
        "26.621488444 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan West (deprecated)\",GEO");
    add_srs_wkt (p, 1,
        "GCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROID");
    add_srs_wkt (p, 2,
        "[\"Clarke 1866 Michigan\",6378450.047548896,294.97869716");
    add_srs_wkt (p, 3,
        "46772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 4,
        "6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"890");
    add_srs_wkt (p, 5,
        "1\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPS");
    add_srs_wkt (p, 6,
        "G\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude");
    add_srs_wkt (p, 7,
        "\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[\"Tran");
    add_srs_wkt (p, 8,
        "sverse_Mercator\"],PARAMETER[\"latitude_of_origin\",41.5");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-88.75],PARAMETER[\"sca");
    add_srs_wkt (p, 10,
        "le_factor\",0.999909091],PARAMETER[\"false_easting\",500");
    add_srs_wkt (p, 11,
        "000],PARAMETER[\"false_northing\",0],UNIT[\"US survey fo");
    add_srs_wkt (p, 12,
        "ot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AX");
    add_srs_wkt (p, 13,
        "IS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26");
    add_srs_wkt (p, 14,
        "803\"]]");
    p = add_epsg_def_ex (filter, first, last, 26811, "epsg", 26811,
        "NAD Michigan / Michigan North (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.48333333333333 +lat_2=47.08333333333");
    add_proj4text (p, 1,
        "334 +lat_0=44.78333333333333 +lon_0=-87 +x_0=609601.2192");
    add_proj4text (p, 2,
        "024384 +y_0=0 +a=6378450.047548896 +b=6356826.621488444 ");
    add_proj4text (p, 3,
        "+units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan North (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866 Michigan\",6378450.047548896,294.9786971");
    add_srs_wkt (p, 3,
        "646772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",45.48333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",47.08333333333334],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 11,
        "44.78333333333333],PARAMETER[\"central_meridian\",-87],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_easting\",2000000],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"26811\"]]");
    p = add_epsg_def_ex (filter, first, last, 26812, "epsg", 26812,
        "NAD Michigan / Michigan Central (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=44.18333333333333 +lat_2=45.7 +lat_0=43");
    add_proj4text (p, 1,
        ".31666666666667 +lon_0=-84.33333333333333 +x_0=609601.21");
    add_proj4text (p, 2,
        "92024384 +y_0=0 +a=6378450.047548896 +b=6356826.62148844");
    add_proj4text (p, 3,
        "4 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan Central (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHER");
    add_srs_wkt (p, 2,
        "OID[\"Clarke 1866 Michigan\",6378450.047548896,294.97869");
    add_srs_wkt (p, 3,
        "71646772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",44.18333333333333],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",45.7],PARAMETER[\"latitude_of_origin\",43.316666666");
    add_srs_wkt (p, 11,
        "66667],PARAMETER[\"central_meridian\",-84.33333333333333");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",2000000],PARAMETER[\"false");
    add_srs_wkt (p, 13,
        "_northing\",0],UNIT[\"US survey foot\",0.304800609601219");
    add_srs_wkt (p, 14,
        "2,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26812\"]]");
    p = add_epsg_def_ex (filter, first, last, 26813, "epsg", 26813,
        "NAD Michigan / Michigan South (deprecated)", 0, 0,
        "Clarke 1866 Michigan", "Greenwich",
        "NAD27_Michigan", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=42.1 +lat_2=43.66666666666666 +lat_0=41");
    add_proj4text (p, 1,
        ".5 +lon_0=-84.33333333333333 +x_0=609601.2192024384 +y_0");
    add_proj4text (p, 2,
        "=0 +a=6378450.047548896 +b=6356826.621488444 +units=us-f");
    add_proj4text (p, 3,
        "t +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD Michigan / Michigan South (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD27 Michigan\",DATUM[\"NAD27_Michigan\",SPHEROI");
    add_srs_wkt (p, 2,
        "D[\"Clarke 1866 Michigan\",6378450.047548896,294.9786971");
    add_srs_wkt (p, 3,
        "646772,AUTHORITY[\"EPSG\",\"7009\"]],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6268\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4268\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",42.1],PARAMETER[\"standard_parallel_2\",43.666666");
    add_srs_wkt (p, 10,
        "66666666],PARAMETER[\"latitude_of_origin\",41.5],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",-84.33333333333333],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",2000000],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 13,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"26813\"]]");
    p = add_epsg_def_ex (filter, first, last, 26814, "epsg", 26814,
        "NAD83 / Maine East (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS) (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",43.6666");
    add_srs_wkt (p, 9,
        "6666666666],PARAMETER[\"central_meridian\",-68.5],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"scale_factor\",0.9999],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 11,
        ",300000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 12,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 13,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26814\"]]");
    p = add_epsg_def_ex (filter, first, last, 26815, "epsg", 26815,
        "NAD83 / Maine West (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS) (deprecated)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[");
    add_srs_wkt (p, 2,
        "\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 3,
        "7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"626");
    add_srs_wkt (p, 4,
        "9\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"");
    add_srs_wkt (p, 5,
        "]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 6,
        ",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",");
    add_srs_wkt (p, 7,
        "EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Transve");
    add_srs_wkt (p, 8,
        "rse_Mercator\"],PARAMETER[\"latitude_of_origin\",42.8333");
    add_srs_wkt (p, 9,
        "3333333334],PARAMETER[\"central_meridian\",-70.166666666");
    add_srs_wkt (p, 10,
        "66667],PARAMETER[\"scale_factor\",0.999966667],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"false_easting\",900000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 12,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 13,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26815\"");
    add_srs_wkt (p, 14,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26819, "epsg", 26819,
        "NAD83 / Minnesota North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS) (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",48.63333333333333],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",47.03333333333333],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 11,
        "46.5],PARAMETER[\"central_meridian\",-93.1],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",800000.0000101601],PARAMETER[\"false_nor");
    add_srs_wkt (p, 13,
        "thing\",99999.99998984],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"26819\"]]");
    p = add_epsg_def_ex (filter, first, last, 26820, "epsg", 26820,
        "NAD83 / Minnesota Central (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS) (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"L");
    add_srs_wkt (p, 8,
        "ambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 9,
        "lel_1\",47.05],PARAMETER[\"standard_parallel_2\",45.6166");
    add_srs_wkt (p, 10,
        "6666666667],PARAMETER[\"latitude_of_origin\",45],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",-94.25],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",800000.0000101601],PARAMETER[\"false_northing\",9999");
    add_srs_wkt (p, 13,
        "9.99998984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"");
    add_srs_wkt (p, 14,
        "]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 15,
        ",\"26820\"]]");
    p = add_epsg_def_ex (filter, first, last, 26821, "epsg", 26821,
        "NAD83 / Minnesota South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS) (deprecated)\",G");
    add_srs_wkt (p, 1,
        "EOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",SPHE");
    add_srs_wkt (p, 2,
        "ROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 4,
        "\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8");
    add_srs_wkt (p, 5,
        "901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"E");
    add_srs_wkt (p, 6,
        "PSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitu");
    add_srs_wkt (p, 7,
        "de\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"La");
    add_srs_wkt (p, 8,
        "mbert_Conformal_Conic_2SP\"],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 9,
        "el_1\",45.21666666666667],PARAMETER[\"standard_parallel_");
    add_srs_wkt (p, 10,
        "2\",43.78333333333333],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 11,
        "43],PARAMETER[\"central_meridian\",-94],PARAMETER[\"fals");
    add_srs_wkt (p, 12,
        "e_easting\",800000.0000101601],PARAMETER[\"false_northin");
    add_srs_wkt (p, 13,
        "g\",99999.99998984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 14,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 15,
        "\"EPSG\",\"26821\"]]");
    p = add_epsg_def_ex (filter, first, last, 26822, "epsg", 26822,
        "NAD83 / Nebraska (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS) (deprecated)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"G");
    add_srs_wkt (p, 2,
        "RS 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"701");
    add_srs_wkt (p, 3,
        "9\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"");
    add_srs_wkt (p, 4,
        "]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],");
    add_srs_wkt (p, 5,
        "UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 6,
        "9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAS");
    add_srs_wkt (p, 7,
        "T],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Co");
    add_srs_wkt (p, 8,
        "nformal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",4");
    add_srs_wkt (p, 9,
        "3],PARAMETER[\"standard_parallel_2\",40],PARAMETER[\"lat");
    add_srs_wkt (p, 10,
        "itude_of_origin\",39.83333333333334],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-100],PARAMETER[\"false_easting\",500000.000");
    add_srs_wkt (p, 12,
        "0101601],PARAMETER[\"false_northing\",0],UNIT[\"metre\",");
    add_srs_wkt (p, 13,
        "1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 14,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26822\"]]");
    p = add_epsg_def_ex (filter, first, last, 26823, "epsg", 26823,
        "NAD83 / West Virginia North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North (ftUS) (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",40.25],PARAMETER[\"standard_parallel_2\",39],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",38.5],PARAMETER[\"centr");
    add_srs_wkt (p, 11,
        "al_meridian\",-79.5],PARAMETER[\"false_easting\",1968500");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHO");
    add_srs_wkt (p, 13,
        "RITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NOR");
    add_srs_wkt (p, 14,
        "TH],AUTHORITY[\"EPSG\",\"26823\"]]");
    p = add_epsg_def_ex (filter, first, last, 26824, "epsg", 26824,
        "NAD83 / West Virginia South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South (ftUS) (deprecated)");
    add_srs_wkt (p, 1,
        "\",GEOGCS[\"NAD83\",DATUM[\"North_American_Datum_1983\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6269\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",38.88333333333333],PARAMETER[\"standard_paral");
    add_srs_wkt (p, 10,
        "lel_2\",37.48333333333333],PARAMETER[\"latitude_of_origi");
    add_srs_wkt (p, 11,
        "n\",37],PARAMETER[\"central_meridian\",-81],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 13,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26824\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26825, "epsg", 26825,
        "NAD83(HARN) / Maine East (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East (ftUS) (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",43.66666666666666],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],PARA");
    add_srs_wkt (p, 11,
        "METER[\"false_easting\",300000],PARAMETER[\"false_northi");
    add_srs_wkt (p, 12,
        "ng\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6825\"]]");
    p = add_epsg_def_ex (filter, first, last, 26826, "epsg", 26826,
        "NAD83(HARN) / Maine West (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West (ftUS) (deprecated)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Refer");
    add_srs_wkt (p, 2,
        "ence_Network\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"latit");
    add_srs_wkt (p, 9,
        "ude_of_origin\",42.83333333333334],PARAMETER[\"central_m");
    add_srs_wkt (p, 10,
        "eridian\",-70.16666666666667],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.999966667],PARAMETER[\"false_easting\",900000],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"26826\"]]");
    p = add_epsg_def_ex (filter, first, last, 26830, "epsg", 26830,
        "NAD83(HARN) / Minnesota North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North (ftUS) (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",48.63333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",47.03333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",46.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 12,
        "an\",-93.1],PARAMETER[\"false_easting\",800000.000010160");
    add_srs_wkt (p, 13,
        "1],PARAMETER[\"false_northing\",99999.99998984],UNIT[\"m");
    add_srs_wkt (p, 14,
        "etre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 15,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26830\"]]");
    p = add_epsg_def_ex (filter, first, last, 26831, "epsg", 26831,
        "NAD83(HARN) / Minnesota Central (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central (ftUS) (depreca");
    add_srs_wkt (p, 1,
        "ted)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accurac");
    add_srs_wkt (p, 2,
        "y_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",47.05],PARAMETER[\"standa");
    add_srs_wkt (p, 10,
        "rd_parallel_2\",45.61666666666667],PARAMETER[\"latitude_");
    add_srs_wkt (p, 11,
        "of_origin\",45],PARAMETER[\"central_meridian\",-94.25],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_easting\",800000.0000101601],PARAMETER[");
    add_srs_wkt (p, 13,
        "\"false_northing\",99999.99998984],UNIT[\"metre\",1,AUTH");
    add_srs_wkt (p, 14,
        "ORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NO");
    add_srs_wkt (p, 15,
        "RTH],AUTHORITY[\"EPSG\",\"26831\"]]");
    p = add_epsg_def_ex (filter, first, last, 26832, "epsg", 26832,
        "NAD83(HARN) / Minnesota South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South (ftUS) (deprecate");
    add_srs_wkt (p, 1,
        "d)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_");
    add_srs_wkt (p, 2,
        "Reference_Network\",SPHEROID[\"GRS 1980\",6378137,298.25");
    add_srs_wkt (p, 3,
        "7222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",");
    add_srs_wkt (p, 5,
        "0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453");
    add_srs_wkt (p, 6,
        "2925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude");
    add_srs_wkt (p, 7,
        "\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",45.21666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",43.78333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",43],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-94],PARAMETER[\"false_easting\",800000.0000101601],P");
    add_srs_wkt (p, 13,
        "ARAMETER[\"false_northing\",99999.99998984],UNIT[\"metre");
    add_srs_wkt (p, 14,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS");
    add_srs_wkt (p, 15,
        "[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26832\"]]");
    p = add_epsg_def_ex (filter, first, last, 26833, "epsg", 26833,
        "NAD83(HARN) / Nebraska (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska (ftUS) (deprecated)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Referen");
    add_srs_wkt (p, 2,
        "ce_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101");
    add_srs_wkt (p, 3,
        ",AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AU");
    add_srs_wkt (p, 4,
        "THORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHO");
    add_srs_wkt (p, 5,
        "RITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199");
    add_srs_wkt (p, 6,
        "433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORT");
    add_srs_wkt (p, 7,
        "H],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]");
    add_srs_wkt (p, 8,
        "],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[");
    add_srs_wkt (p, 9,
        "\"standard_parallel_1\",43],PARAMETER[\"standard_paralle");
    add_srs_wkt (p, 10,
        "l_2\",40],PARAMETER[\"latitude_of_origin\",39.8333333333");
    add_srs_wkt (p, 11,
        "3334],PARAMETER[\"central_meridian\",-100],PARAMETER[\"f");
    add_srs_wkt (p, 12,
        "alse_easting\",500000.0000101601],PARAMETER[\"false_nort");
    add_srs_wkt (p, 13,
        "hing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]]");
    add_srs_wkt (p, 14,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 15,
        "26833\"]]");
    p = add_epsg_def_ex (filter, first, last, 26834, "epsg", 26834,
        "NAD83(HARN) / West Virginia North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accur");
    add_srs_wkt (p, 2,
        "acy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",40.25],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",39],PARAMETER[\"latitude_of_origin\",");
    add_srs_wkt (p, 11,
        "38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 13,
        ",UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X");
    add_srs_wkt (p, 14,
        "\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26834\"]");
    add_srs_wkt (p, 15,
        "]");
    p = add_epsg_def_ex (filter, first, last, 26835, "epsg", 26835,
        "NAD83(HARN) / West Virginia South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accur");
    add_srs_wkt (p, 2,
        "acy_Reference_Network\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4152\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",38.88333333333333],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"standard_parallel_2\",37.48333333333333],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"latitude_of_origin\",37],PARAMETER[\"central_merid");
    add_srs_wkt (p, 12,
        "ian\",-81],PARAMETER[\"false_easting\",1968500],PARAMETE");
    add_srs_wkt (p, 13,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"26835\"]]");
    p = add_epsg_def_ex (filter, first, last, 26836, "epsg", 26836,
        "NAD83(NSRS2007) / Maine East (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0");
    add_proj4text (p, 2,
        ",0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine East (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",43.66666666666666],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-68.5],PARAMETER[\"scale_factor\"");
    add_srs_wkt (p, 11,
        ",0.9999],PARAMETER[\"false_easting\",300000],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",");
    add_srs_wkt (p, 13,
        "\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[");
    add_srs_wkt (p, 14,
        "\"EPSG\",\"26836\"]]");
    p = add_epsg_def_ex (filter, first, last, 26837, "epsg", 26837,
        "NAD83(NSRS2007) / Maine West (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine West (ftUS) (deprecated");
    add_srs_wkt (p, 1,
        ")\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Sp");
    add_srs_wkt (p, 2,
        "atial_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378");
    add_srs_wkt (p, 3,
        "137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[");
    add_srs_wkt (p, 4,
        "0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Gr");
    add_srs_wkt (p, 5,
        "eenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 6,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 7,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 8,
        "PSG\",\"4759\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"latitude_of_origin\",42.83333333333334],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"central_meridian\",-70.16666666666667],PARAMETER[\"");
    add_srs_wkt (p, 11,
        "scale_factor\",0.999966667],PARAMETER[\"false_easting\",");
    add_srs_wkt (p, 12,
        "900000],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1");
    add_srs_wkt (p, 13,
        ",AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y");
    add_srs_wkt (p, 14,
        "\",NORTH],AUTHORITY[\"EPSG\",\"26837\"]]");
    p = add_epsg_def_ex (filter, first, last, 26841, "epsg", 26841,
        "NAD83(NSRS2007) / Minnesota North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101601 +y_0=99999.99998984 +ellps=GRS80 +towgs84=0,0,0");
    add_proj4text (p, 3,
        ",0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota North (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nation");
    add_srs_wkt (p, 2,
        "al_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 4,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM");
    add_srs_wkt (p, 5,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 6,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 7,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 8,
        "ITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 9,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",48.6333333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"standard_parallel_2\",47.0333333333");
    add_srs_wkt (p, 11,
        "3333],PARAMETER[\"latitude_of_origin\",46.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "central_meridian\",-93.1],PARAMETER[\"false_easting\",80");
    add_srs_wkt (p, 13,
        "0000.0000101601],PARAMETER[\"false_northing\",99999.9999");
    add_srs_wkt (p, 14,
        "8984],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 15,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"268");
    add_srs_wkt (p, 16,
        "41\"]]");
    p = add_epsg_def_ex (filter, first, last, 26842, "epsg", 26842,
        "NAD83(NSRS2007) / Minnesota Central (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101601 +y_0=99999.999989");
    add_proj4text (p, 2,
        "84 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota Central (ftUS) (dep");
    add_srs_wkt (p, 1,
        "recated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nati");
    add_srs_wkt (p, 2,
        "onal_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980");
    add_srs_wkt (p, 3,
        "\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],T");
    add_srs_wkt (p, 4,
        "OWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIM");
    add_srs_wkt (p, 5,
        "EM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"");
    add_srs_wkt (p, 6,
        "degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]");
    add_srs_wkt (p, 7,
        "],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTH");
    add_srs_wkt (p, 8,
        "ORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal");
    add_srs_wkt (p, 9,
        "_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47.05],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",45.61666666666667],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",45],PARAMETER[\"central_mer");
    add_srs_wkt (p, 12,
        "idian\",-94.25],PARAMETER[\"false_easting\",800000.00001");
    add_srs_wkt (p, 13,
        "01601],PARAMETER[\"false_northing\",99999.99998984],UNIT");
    add_srs_wkt (p, 14,
        "[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 15,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26842\"]]");
    p = add_epsg_def_ex (filter, first, last, 26843, "epsg", 26843,
        "NAD83(NSRS2007) / Minnesota South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101601 +y_0=999");
    add_proj4text (p, 2,
        "99.99998984 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m");
    add_proj4text (p, 3,
        " +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota South (ftUS) (depre");
    add_srs_wkt (p, 1,
        "cated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Nation");
    add_srs_wkt (p, 2,
        "al_Spatial_Reference_System_2007\",SPHEROID[\"GRS 1980\"");
    add_srs_wkt (p, 3,
        ",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOW");
    add_srs_wkt (p, 4,
        "GS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM");
    add_srs_wkt (p, 5,
        "[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"de");
    add_srs_wkt (p, 6,
        "gree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],");
    add_srs_wkt (p, 7,
        "AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHOR");
    add_srs_wkt (p, 8,
        "ITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_C");
    add_srs_wkt (p, 9,
        "onic_2SP\"],PARAMETER[\"standard_parallel_1\",45.2166666");
    add_srs_wkt (p, 10,
        "6666667],PARAMETER[\"standard_parallel_2\",43.7833333333");
    add_srs_wkt (p, 11,
        "3333],PARAMETER[\"latitude_of_origin\",43],PARAMETER[\"c");
    add_srs_wkt (p, 12,
        "entral_meridian\",-94],PARAMETER[\"false_easting\",80000");
    add_srs_wkt (p, 13,
        "0.0000101601],PARAMETER[\"false_northing\",99999.9999898");
    add_srs_wkt (p, 14,
        "4],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 15,
        "X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26843\"");
    add_srs_wkt (p, 16,
        "]]");
    p = add_epsg_def_ex (filter, first, last, 26844, "epsg", 26844,
        "NAD83(NSRS2007) / Nebraska (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.0000101601 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Nebraska (ftUS) (deprecated)\"");
    add_srs_wkt (p, 1,
        ",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spati");
    add_srs_wkt (p, 2,
        "al_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137");
    add_srs_wkt (p, 3,
        ",298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0");
    add_srs_wkt (p, 4,
        ",0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 5,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 6,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"L");
    add_srs_wkt (p, 7,
        "atitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EP");
    add_srs_wkt (p, 8,
        "SG\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP");
    add_srs_wkt (p, 9,
        "\"],PARAMETER[\"standard_parallel_1\",43],PARAMETER[\"st");
    add_srs_wkt (p, 10,
        "andard_parallel_2\",40],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",39.83333333333334],PARAMETER[\"central_meridian\",-100]");
    add_srs_wkt (p, 12,
        ",PARAMETER[\"false_easting\",500000.0000101601],PARAMETE");
    add_srs_wkt (p, 13,
        "R[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"26844\"]]");
    p = add_epsg_def_ex (filter, first, last, 26845, "epsg", 26845,
        "NAD83(NSRS2007) / West Virginia North (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=1968500 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,");
    add_proj4text (p, 2,
        "0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia North (ftUS) (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2007\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 9,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40.25],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"standard_parallel_2\",39],PARAMETER[\"latitu");
    add_srs_wkt (p, 11,
        "de_of_origin\",38.5],PARAMETER[\"central_meridian\",-79.");
    add_srs_wkt (p, 12,
        "5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 14,
        "01\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 15,
        "SG\",\"26845\"]]");
    p = add_epsg_def_ex (filter, first, last, 26846, "epsg", 26846,
        "NAD83(NSRS2007) / West Virginia South (ftUS) (deprecated)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "metre",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=1968500 +y_0=0 +ellps=GRS8");
    add_proj4text (p, 2,
        "0 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia South (ftUS) (d");
    add_srs_wkt (p, 1,
        "eprecated)\",GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_Na");
    add_srs_wkt (p, 2,
        "tional_Spatial_Reference_System_2007\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 3,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 4,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PR");
    add_srs_wkt (p, 5,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 6,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 7,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 8,
        "HORITY[\"EPSG\",\"4759\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 9,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38.8833");
    add_srs_wkt (p, 10,
        "3333333333],PARAMETER[\"standard_parallel_2\",37.4833333");
    add_srs_wkt (p, 11,
        "3333333],PARAMETER[\"latitude_of_origin\",37],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"central_meridian\",-81],PARAMETER[\"false_easting\",19");
    add_srs_wkt (p, 13,
        "68500],PARAMETER[\"false_northing\",0],UNIT[\"metre\",1,");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"26846\"]]");
    p = add_epsg_def_ex (filter, first, last, 26847, "epsg", 26847,
        "NAD83 / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine East (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",43.66666666666666],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-68.5],PARAMETER[\"scale_fa");
    add_srs_wkt (p, 10,
        "ctor\",0.9999],PARAMETER[\"false_easting\",984250.000000");
    add_srs_wkt (p, 11,
        "0002],PARAMETER[\"false_northing\",0],UNIT[\"US survey f");
    add_srs_wkt (p, 12,
        "oot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],A");
    add_srs_wkt (p, 13,
        "XIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"2");
    add_srs_wkt (p, 14,
        "6847\"]]");
    p = add_epsg_def_ex (filter, first, last, 26848, "epsg", 26848,
        "NAD83 / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Maine West (ftUS)\",GEOGCS[\"NAD83\",DA");
    add_srs_wkt (p, 1,
        "TUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",");
    add_srs_wkt (p, 2,
        "6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWG");
    add_srs_wkt (p, 3,
        "S84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[");
    add_srs_wkt (p, 4,
        "\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"deg");
    add_srs_wkt (p, 5,
        "ree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],A");
    add_srs_wkt (p, 6,
        "XIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORI");
    add_srs_wkt (p, 7,
        "TY[\"EPSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 8,
        "],PARAMETER[\"latitude_of_origin\",42.83333333333334],PA");
    add_srs_wkt (p, 9,
        "RAMETER[\"central_meridian\",-70.16666666666667],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"scale_factor\",0.999966667],PARAMETER[\"false_easti");
    add_srs_wkt (p, 11,
        "ng\",2952750],PARAMETER[\"false_northing\",0],UNIT[\"US ");
    add_srs_wkt (p, 12,
        "survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"90");
    add_srs_wkt (p, 13,
        "03\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EP");
    add_srs_wkt (p, 14,
        "SG\",\"26848\"]]");
    p = add_epsg_def_ex (filter, first, last, 26849, "epsg", 26849,
        "NAD83 / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota North (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",48.6333");
    add_srs_wkt (p, 9,
        "3333333333],PARAMETER[\"standard_parallel_2\",47.0333333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"latitude_of_origin\",46.5],PARAMETE");
    add_srs_wkt (p, 11,
        "R[\"central_meridian\",-93.1],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",2624666.6667],PARAMETER[\"false_northing\",328083.3333]");
    add_srs_wkt (p, 13,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"26849\"]]");
    p = add_epsg_def_ex (filter, first, last, 26850, "epsg", 26850,
        "NAD83 / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota Central (ftUS)\",GEOGCS[\"NAD");
    add_srs_wkt (p, 1,
        "83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS ");
    add_srs_wkt (p, 2,
        "1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"");
    add_srs_wkt (p, 3,
        "]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],");
    add_srs_wkt (p, 4,
        "PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNI");
    add_srs_wkt (p, 5,
        "T[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"912");
    add_srs_wkt (p, 6,
        "2\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],");
    add_srs_wkt (p, 7,
        "AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Confo");
    add_srs_wkt (p, 8,
        "rmal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",47.0");
    add_srs_wkt (p, 9,
        "5],PARAMETER[\"standard_parallel_2\",45.61666666666667],");
    add_srs_wkt (p, 10,
        "PARAMETER[\"latitude_of_origin\",45],PARAMETER[\"central");
    add_srs_wkt (p, 11,
        "_meridian\",-94.25],PARAMETER[\"false_easting\",2624666.");
    add_srs_wkt (p, 12,
        "6667],PARAMETER[\"false_northing\",328083.3333],UNIT[\"U");
    add_srs_wkt (p, 13,
        "S survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 14,
        "9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"");
    add_srs_wkt (p, 15,
        "EPSG\",\"26850\"]]");
    p = add_epsg_def_ex (filter, first, last, 26851, "epsg", 26851,
        "NAD83 / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Minnesota South (ftUS)\",GEOGCS[\"NAD83");
    add_srs_wkt (p, 1,
        "\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GRS 19");
    add_srs_wkt (p, 2,
        "80\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]]");
    add_srs_wkt (p, 3,
        ",TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PR");
    add_srs_wkt (p, 4,
        "IMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[");
    add_srs_wkt (p, 5,
        "\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"");
    add_srs_wkt (p, 6,
        "]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUT");
    add_srs_wkt (p, 7,
        "HORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conforma");
    add_srs_wkt (p, 8,
        "l_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",45.2166");
    add_srs_wkt (p, 9,
        "6666666667],PARAMETER[\"standard_parallel_2\",43.7833333");
    add_srs_wkt (p, 10,
        "3333333],PARAMETER[\"latitude_of_origin\",43],PARAMETER[");
    add_srs_wkt (p, 11,
        "\"central_meridian\",-94],PARAMETER[\"false_easting\",26");
    add_srs_wkt (p, 12,
        "24666.6667],PARAMETER[\"false_northing\",328083.3333],UN");
    add_srs_wkt (p, 13,
        "IT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"EPS");
    add_srs_wkt (p, 14,
        "G\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHOR");
    add_srs_wkt (p, 15,
        "ITY[\"EPSG\",\"26851\"]]");
    p = add_epsg_def_ex (filter, first, last, 26852, "epsg", 26852,
        "NAD83 / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / Nebraska (ftUS)\",GEOGCS[\"NAD83\",DATU");
    add_srs_wkt (p, 1,
        "M[\"North_American_Datum_1983\",SPHEROID[\"GRS 1980\",63");
    add_srs_wkt (p, 2,
        "78137,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS8");
    add_srs_wkt (p, 3,
        "4[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"");
    add_srs_wkt (p, 4,
        "Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degre");
    add_srs_wkt (p, 5,
        "e\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXI");
    add_srs_wkt (p, 6,
        "S[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY");
    add_srs_wkt (p, 7,
        "[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Conformal_Coni");
    add_srs_wkt (p, 8,
        "c_2SP\"],PARAMETER[\"standard_parallel_1\",43],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_2\",40],PARAMETER[\"latitude_of_ori");
    add_srs_wkt (p, 10,
        "gin\",39.83333333333334],PARAMETER[\"central_meridian\",");
    add_srs_wkt (p, 11,
        "-100],PARAMETER[\"false_easting\",1640416.6667],PARAMETE");
    add_srs_wkt (p, 12,
        "R[\"false_northing\",0],UNIT[\"US survey foot\",0.304800");
    add_srs_wkt (p, 13,
        "6096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST");
    add_srs_wkt (p, 14,
        "],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26852\"]]");
    p = add_epsg_def_ex (filter, first, last, 26853, "epsg", 26853,
        "NAD83 / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia North (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",40");
    add_srs_wkt (p, 9,
        ".25],PARAMETER[\"standard_parallel_2\",39],PARAMETER[\"l");
    add_srs_wkt (p, 10,
        "atitude_of_origin\",38.5],PARAMETER[\"central_meridian\"");
    add_srs_wkt (p, 11,
        ",-79.5],PARAMETER[\"false_easting\",1968500],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_northing\",0],UNIT[\"US survey foot\",0.3048006096");
    add_srs_wkt (p, 13,
        "012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AX");
    add_srs_wkt (p, 14,
        "IS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26853\"]]");
    p = add_epsg_def_ex (filter, first, last, 26854, "epsg", 26854,
        "NAD83 / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / West Virginia South (ftUS)\",GEOGCS[\"N");
    add_srs_wkt (p, 1,
        "AD83\",DATUM[\"North_American_Datum_1983\",SPHEROID[\"GR");
    add_srs_wkt (p, 2,
        "S 1980\",6378137,298.257222101,AUTHORITY[\"EPSG\",\"7019");
    add_srs_wkt (p, 3,
        "\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]");
    add_srs_wkt (p, 4,
        "],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],U");
    add_srs_wkt (p, 5,
        "NIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 6,
        "122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longitude\",EAST");
    add_srs_wkt (p, 7,
        "],AUTHORITY[\"EPSG\",\"4269\"]],PROJECTION[\"Lambert_Con");
    add_srs_wkt (p, 8,
        "formal_Conic_2SP\"],PARAMETER[\"standard_parallel_1\",38");
    add_srs_wkt (p, 9,
        ".88333333333333],PARAMETER[\"standard_parallel_2\",37.48");
    add_srs_wkt (p, 10,
        "333333333333],PARAMETER[\"latitude_of_origin\",37],PARAM");
    add_srs_wkt (p, 11,
        "ETER[\"central_meridian\",-81],PARAMETER[\"false_easting");
    add_srs_wkt (p, 12,
        "\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US su");
    add_srs_wkt (p, 13,
        "rvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003");
    add_srs_wkt (p, 14,
        "\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG");
    add_srs_wkt (p, 15,
        "\",\"26854\"]]");
    p = add_epsg_def_ex (filter, first, last, 26855, "epsg", 26855,
        "NAD83(HARN) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine East (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",43.66666666666666],PARAMETER[\"central_meridian\",-68.5");
    add_srs_wkt (p, 10,
        "],PARAMETER[\"scale_factor\",0.9999],PARAMETER[\"false_e");
    add_srs_wkt (p, 11,
        "asting\",984250.0000000002],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 12,
        ",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY");
    add_srs_wkt (p, 13,
        "[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],");
    add_srs_wkt (p, 14,
        "AUTHORITY[\"EPSG\",\"26855\"]]");
    p = add_epsg_def_ex (filter, first, last, 26856, "epsg", 26856,
        "NAD83(HARN) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Maine West (ftUS)\",GEOGCS[\"NAD8");
    add_srs_wkt (p, 1,
        "3(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\"");
    add_srs_wkt (p, 2,
        ",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Transverse_Mercator\"],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 9,
        ",42.83333333333334],PARAMETER[\"central_meridian\",-70.1");
    add_srs_wkt (p, 10,
        "6666666666667],PARAMETER[\"scale_factor\",0.999966667],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",2952750],PARAMETER[\"false_no");
    add_srs_wkt (p, 12,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 13,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 14,
        ",NORTH],AUTHORITY[\"EPSG\",\"26856\"]]");
    p = add_epsg_def_ex (filter, first, last, 26857, "epsg", 26857,
        "NAD83(HARN) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota North (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",48.63333333333333],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",47.03333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 11,
        "_origin\",46.5],PARAMETER[\"central_meridian\",-93.1],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_easting\",2624666.6667],PARAMETER[\"fals");
    add_srs_wkt (p, 13,
        "e_northing\",328083.3333],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 14,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 15,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26857\"]]");
    p = add_epsg_def_ex (filter, first, last, 26858, "epsg", 26858,
        "NAD83(HARN) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota Central (ftUS)\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_N");
    add_srs_wkt (p, 2,
        "etwork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUT");
    add_srs_wkt (p, 3,
        "HORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHOR");
    add_srs_wkt (p, 4,
        "ITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY");
    add_srs_wkt (p, 5,
        "[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,");
    add_srs_wkt (p, 6,
        "AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],A");
    add_srs_wkt (p, 7,
        "XIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PR");
    add_srs_wkt (p, 8,
        "OJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"st");
    add_srs_wkt (p, 9,
        "andard_parallel_1\",47.05],PARAMETER[\"standard_parallel");
    add_srs_wkt (p, 10,
        "_2\",45.61666666666667],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",45],PARAMETER[\"central_meridian\",-94.25],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",2624666.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 13,
        "\",328083.3333],UNIT[\"US survey foot\",0.30480060960121");
    add_srs_wkt (p, 14,
        "92,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"");
    add_srs_wkt (p, 15,
        "Y\",NORTH],AUTHORITY[\"EPSG\",\"26858\"]]");
    p = add_epsg_def_ex (filter, first, last, 26859, "epsg", 26859,
        "NAD83(HARN) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Minnesota South (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Netw");
    add_srs_wkt (p, 2,
        "ork\",SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHOR");
    add_srs_wkt (p, 3,
        "ITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY");
    add_srs_wkt (p, 4,
        "[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"");
    add_srs_wkt (p, 5,
        "EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUT");
    add_srs_wkt (p, 6,
        "HORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS");
    add_srs_wkt (p, 7,
        "[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJE");
    add_srs_wkt (p, 8,
        "CTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"stand");
    add_srs_wkt (p, 9,
        "ard_parallel_1\",45.21666666666667],PARAMETER[\"standard");
    add_srs_wkt (p, 10,
        "_parallel_2\",43.78333333333333],PARAMETER[\"latitude_of");
    add_srs_wkt (p, 11,
        "_origin\",43],PARAMETER[\"central_meridian\",-94],PARAME");
    add_srs_wkt (p, 12,
        "TER[\"false_easting\",2624666.6667],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",328083.3333],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 14,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 15,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26859\"]]");
    p = add_epsg_def_ex (filter, first, last, 26860, "epsg", 26860,
        "NAD83(HARN) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / Nebraska (ftUS)\",GEOGCS[\"NAD83(");
    add_srs_wkt (p, 1,
        "HARN)\",DATUM[\"NAD83_High_Accuracy_Reference_Network\",");
    add_srs_wkt (p, 2,
        "SPHEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"");
    add_srs_wkt (p, 3,
        "EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPS");
    add_srs_wkt (p, 4,
        "G\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 5,
        ",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY");
    add_srs_wkt (p, 6,
        "[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Lon");
    add_srs_wkt (p, 7,
        "gitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],PROJECTION[");
    add_srs_wkt (p, 8,
        "\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"standard_pa");
    add_srs_wkt (p, 9,
        "rallel_1\",43],PARAMETER[\"standard_parallel_2\",40],PAR");
    add_srs_wkt (p, 10,
        "AMETER[\"latitude_of_origin\",39.83333333333334],PARAMET");
    add_srs_wkt (p, 11,
        "ER[\"central_meridian\",-100],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 12,
        ",1640416.6667],PARAMETER[\"false_northing\",0],UNIT[\"US");
    add_srs_wkt (p, 13,
        " survey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9");
    add_srs_wkt (p, 14,
        "003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 15,
        "PSG\",\"26860\"]]");
    p = add_epsg_def_ex (filter, first, last, 26861, "epsg", 26861,
        "NAD83(HARN) / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",40.25],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",39],PARAMETER[\"latitude_of_origin\",38.5],PARAME");
    add_srs_wkt (p, 11,
        "TER[\"central_meridian\",-79.5],PARAMETER[\"false_eastin");
    add_srs_wkt (p, 12,
        "g\",1968500],PARAMETER[\"false_northing\",0],UNIT[\"US s");
    add_srs_wkt (p, 13,
        "urvey foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"900");
    add_srs_wkt (p, 14,
        "3\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPS");
    add_srs_wkt (p, 15,
        "G\",\"26861\"]]");
    p = add_epsg_def_ex (filter, first, last, 26862, "epsg", 26862,
        "NAD83(HARN) / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_High_Accuracy_Reference_Network", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(HARN) / West Virginia South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(HARN)\",DATUM[\"NAD83_High_Accuracy_Reference");
    add_srs_wkt (p, 2,
        "_Network\",SPHEROID[\"GRS 1980\",6378137,298.257222101,A");
    add_srs_wkt (p, 3,
        "UTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTH");
    add_srs_wkt (p, 4,
        "ORITY[\"EPSG\",\"6152\"]],PRIMEM[\"Greenwich\",0,AUTHORI");
    add_srs_wkt (p, 5,
        "TY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292519943");
    add_srs_wkt (p, 6,
        "3,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH]");
    add_srs_wkt (p, 7,
        ",AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4152\"]],");
    add_srs_wkt (p, 8,
        "PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER[\"");
    add_srs_wkt (p, 9,
        "standard_parallel_1\",38.88333333333333],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",37.48333333333333],PARAMETER[\"latitu");
    add_srs_wkt (p, 11,
        "de_of_origin\",37],PARAMETER[\"central_meridian\",-81],P");
    add_srs_wkt (p, 12,
        "ARAMETER[\"false_easting\",1968500],PARAMETER[\"false_no");
    add_srs_wkt (p, 13,
        "rthing\",0],UNIT[\"US survey foot\",0.3048006096012192,A");
    add_srs_wkt (p, 14,
        "UTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\"");
    add_srs_wkt (p, 15,
        ",NORTH],AUTHORITY[\"EPSG\",\"26862\"]]");
    p = add_epsg_def_ex (filter, first, last, 26863, "epsg", 26863,
        "NAD83(NSRS2007) / Maine East (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=43.66666666666666 +lon_0=-68.5 +k=0.9");
    add_proj4text (p, 1,
        "999 +x_0=300000.0000000001 +y_0=0 +ellps=GRS80 +towgs84=");
    add_proj4text (p, 2,
        "0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine East (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",43.66666666666666],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-68.5],PARAMETER[\"scale_factor\",0.9999],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_easting\",984250.0000000002],PARAMETER[");
    add_srs_wkt (p, 12,
        "\"false_northing\",0],UNIT[\"US survey foot\",0.30480060");
    add_srs_wkt (p, 13,
        "96012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],");
    add_srs_wkt (p, 14,
        "AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26863\"]]");
    p = add_epsg_def_ex (filter, first, last, 26864, "epsg", 26864,
        "NAD83(NSRS2007) / Maine West (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Transverse_Mercator", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=42.83333333333334 +lon_0=-70.16666666");
    add_proj4text (p, 1,
        "666667 +k=0.999966667 +x_0=900000 +y_0=0 +ellps=GRS80 +t");
    add_proj4text (p, 2,
        "owgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Maine West (ftUS)\",GEOGCS[\"");
    add_srs_wkt (p, 1,
        "NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Referen");
    add_srs_wkt (p, 2,
        "ce_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.25722");
    add_srs_wkt (p, 3,
        "2101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0");
    add_srs_wkt (p, 4,
        "],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,A");
    add_srs_wkt (p, 5,
        "UTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.017453292");
    add_srs_wkt (p, 6,
        "5199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",");
    add_srs_wkt (p, 7,
        "NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"475");
    add_srs_wkt (p, 8,
        "9\"]],PROJECTION[\"Transverse_Mercator\"],PARAMETER[\"la");
    add_srs_wkt (p, 9,
        "titude_of_origin\",42.83333333333334],PARAMETER[\"centra");
    add_srs_wkt (p, 10,
        "l_meridian\",-70.16666666666667],PARAMETER[\"scale_facto");
    add_srs_wkt (p, 11,
        "r\",0.999966667],PARAMETER[\"false_easting\",2952750],PA");
    add_srs_wkt (p, 12,
        "RAMETER[\"false_northing\",0],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 13,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 14,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26864\"]]");
    p = add_epsg_def_ex (filter, first, last, 26865, "epsg", 26865,
        "NAD83(NSRS2007) / Minnesota North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=48.63333333333333 +lat_2=47.03333333333");
    add_proj4text (p, 1,
        "333 +lat_0=46.5 +lon_0=-93.09999999999999 +x_0=800000.00");
    add_proj4text (p, 2,
        "00101599 +y_0=99999.99998983997 +ellps=GRS80 +towgs84=0,");
    add_proj4text (p, 3,
        "0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota North (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",48.63333333333333],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",47.03333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",46.5],PARAMETER[\"central_meridi");
    add_srs_wkt (p, 12,
        "an\",-93.1],PARAMETER[\"false_easting\",2624666.6667],PA");
    add_srs_wkt (p, 13,
        "RAMETER[\"false_northing\",328083.3333],UNIT[\"US survey");
    add_srs_wkt (p, 14,
        " foot\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]]");
    add_srs_wkt (p, 15,
        ",AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 16,
        "26865\"]]");
    p = add_epsg_def_ex (filter, first, last, 26866, "epsg", 26866,
        "NAD83(NSRS2007) / Minnesota Central (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=47.05 +lat_2=45.61666666666667 +lat_0=4");
    add_proj4text (p, 1,
        "5 +lon_0=-94.25 +x_0=800000.0000101599 +y_0=99999.999989");
    add_proj4text (p, 2,
        "83997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=us-ft +");
    add_proj4text (p, 3,
        "no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota Central (ftUS)\",GE");
    add_srs_wkt (p, 1,
        "OGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_");
    add_srs_wkt (p, 2,
        "Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,29");
    add_srs_wkt (p, 3,
        "8.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwic");
    add_srs_wkt (p, 5,
        "h\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01");
    add_srs_wkt (p, 6,
        "74532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Lati");
    add_srs_wkt (p, 7,
        "tude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 8,
        ",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],");
    add_srs_wkt (p, 9,
        "PARAMETER[\"standard_parallel_1\",47.05],PARAMETER[\"sta");
    add_srs_wkt (p, 10,
        "ndard_parallel_2\",45.61666666666667],PARAMETER[\"latitu");
    add_srs_wkt (p, 11,
        "de_of_origin\",45],PARAMETER[\"central_meridian\",-94.25");
    add_srs_wkt (p, 12,
        "],PARAMETER[\"false_easting\",2624666.6667],PARAMETER[\"");
    add_srs_wkt (p, 13,
        "false_northing\",328083.3333],UNIT[\"US survey foot\",0.");
    add_srs_wkt (p, 14,
        "3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\"");
    add_srs_wkt (p, 15,
        ",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26866\"]]");
    p = add_epsg_def_ex (filter, first, last, 26867, "epsg", 26867,
        "NAD83(NSRS2007) / Minnesota South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=45.21666666666667 +lat_2=43.78333333333");
    add_proj4text (p, 1,
        "333 +lat_0=43 +lon_0=-94 +x_0=800000.0000101599 +y_0=999");
    add_proj4text (p, 2,
        "99.99998983997 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +unit");
    add_proj4text (p, 3,
        "s=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Minnesota South (ftUS)\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Re");
    add_srs_wkt (p, 2,
        "ference_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.");
    add_srs_wkt (p, 3,
        "257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,");
    add_srs_wkt (p, 4,
        "0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\"");
    add_srs_wkt (p, 5,
        ",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745");
    add_srs_wkt (p, 6,
        "32925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitud");
    add_srs_wkt (p, 7,
        "e\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 8,
        "4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PAR");
    add_srs_wkt (p, 9,
        "AMETER[\"standard_parallel_1\",45.21666666666667],PARAME");
    add_srs_wkt (p, 10,
        "TER[\"standard_parallel_2\",43.78333333333333],PARAMETER");
    add_srs_wkt (p, 11,
        "[\"latitude_of_origin\",43],PARAMETER[\"central_meridian");
    add_srs_wkt (p, 12,
        "\",-94],PARAMETER[\"false_easting\",2624666.6667],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",328083.3333],UNIT[\"US survey foo");
    add_srs_wkt (p, 14,
        "t\",0.3048006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXI");
    add_srs_wkt (p, 15,
        "S[\"X\",EAST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"268");
    add_srs_wkt (p, 16,
        "67\"]]");
    p = add_epsg_def_ex (filter, first, last, 26868, "epsg", 26868,
        "NAD83(NSRS2007) / Nebraska (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=43 +lat_2=40 +lat_0=39.83333333333334 +");
    add_proj4text (p, 1,
        "lon_0=-100 +x_0=500000.00001016 +y_0=0 +ellps=GRS80 +tow");
    add_proj4text (p, 2,
        "gs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / Nebraska (ftUS)\",GEOGCS[\"NA");
    add_srs_wkt (p, 1,
        "D83(NSRS2007)\",DATUM[\"NAD83_National_Spatial_Reference");
    add_srs_wkt (p, 2,
        "_System_2007\",SPHEROID[\"GRS 1980\",6378137,298.2572221");
    add_srs_wkt (p, 3,
        "01,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],");
    add_srs_wkt (p, 4,
        "AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenwich\",0,AUT");
    add_srs_wkt (p, 5,
        "HORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.01745329251");
    add_srs_wkt (p, 6,
        "99433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"Latitude\",NO");
    add_srs_wkt (p, 7,
        "RTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPSG\",\"4759\"");
    add_srs_wkt (p, 8,
        "]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"standard_parallel_1\",43],PARAMETER[\"standard_parall");
    add_srs_wkt (p, 10,
        "el_2\",40],PARAMETER[\"latitude_of_origin\",39.833333333");
    add_srs_wkt (p, 11,
        "33334],PARAMETER[\"central_meridian\",-100],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",1640416.6667],PARAMETER[\"false_northing");
    add_srs_wkt (p, 13,
        "\",0],UNIT[\"US survey foot\",0.3048006096012192,AUTHORI");
    add_srs_wkt (p, 14,
        "TY[\"EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH");
    add_srs_wkt (p, 15,
        "],AUTHORITY[\"EPSG\",\"26868\"]]");
    p = add_epsg_def_ex (filter, first, last, 26869, "epsg", 26869,
        "NAD83(NSRS2007) / West Virginia North (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=40.25 +lat_2=39 +lat_0=38.5 +lon_0=-79.");
    add_proj4text (p, 1,
        "5 +x_0=600000 +y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0");
    add_proj4text (p, 2,
        " +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia North (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",40.25],PARAMETER[\"s");
    add_srs_wkt (p, 10,
        "tandard_parallel_2\",39],PARAMETER[\"latitude_of_origin\"");
    add_srs_wkt (p, 11,
        ",38.5],PARAMETER[\"central_meridian\",-79.5],PARAMETER[\"");
    add_srs_wkt (p, 12,
        "false_easting\",1968500],PARAMETER[\"false_northing\",0]");
    add_srs_wkt (p, 13,
        ",UNIT[\"US survey foot\",0.3048006096012192,AUTHORITY[\"");
    add_srs_wkt (p, 14,
        "EPSG\",\"9003\"]],AXIS[\"X\",EAST],AXIS[\"Y\",NORTH],AUT");
    add_srs_wkt (p, 15,
        "HORITY[\"EPSG\",\"26869\"]]");
    p = add_epsg_def_ex (filter, first, last, 26870, "epsg", 26870,
        "NAD83(NSRS2007) / West Virginia South (ftUS)", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_National_Spatial_Reference_System_2007", "Lambert_Conformal_Conic_2SP", "US survey foot",
        "X", "East", "Y", "North");
    add_proj4text (p, 0,
        "+proj=lcc +lat_1=38.88333333333333 +lat_2=37.48333333333");
    add_proj4text (p, 1,
        "333 +lat_0=37 +lon_0=-81 +x_0=600000 +y_0=0 +ellps=GRS80");
    add_proj4text (p, 2,
        " +towgs84=0,0,0,0,0,0,0 +units=us-ft +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(NSRS2007) / West Virginia South (ftUS)\",");
    add_srs_wkt (p, 1,
        "GEOGCS[\"NAD83(NSRS2007)\",DATUM[\"NAD83_National_Spatia");
    add_srs_wkt (p, 2,
        "l_Reference_System_2007\",SPHEROID[\"GRS 1980\",6378137,");
    add_srs_wkt (p, 3,
        "298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,0,");
    add_srs_wkt (p, 4,
        "0,0,0,0,0],AUTHORITY[\"EPSG\",\"6759\"]],PRIMEM[\"Greenw");
    add_srs_wkt (p, 5,
        "ich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.");
    add_srs_wkt (p, 6,
        "0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"La");
    add_srs_wkt (p, 7,
        "titude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 8,
        "G\",\"4759\"]],PROJECTION[\"Lambert_Conformal_Conic_2SP\"");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"standard_parallel_1\",38.88333333333333],P");
    add_srs_wkt (p, 10,
        "ARAMETER[\"standard_parallel_2\",37.48333333333333],PARA");
    add_srs_wkt (p, 11,
        "METER[\"latitude_of_origin\",37],PARAMETER[\"central_mer");
    add_srs_wkt (p, 12,
        "idian\",-81],PARAMETER[\"false_easting\",1968500],PARAME");
    add_srs_wkt (p, 13,
        "TER[\"false_northing\",0],UNIT[\"US survey foot\",0.3048");
    add_srs_wkt (p, 14,
        "006096012192,AUTHORITY[\"EPSG\",\"9003\"]],AXIS[\"X\",EA");
    add_srs_wkt (p, 15,
        "ST],AXIS[\"Y\",NORTH],AUTHORITY[\"EPSG\",\"26870\"]]");
    p = add_epsg_def_ex (filter, first, last, 26891, "epsg", 26891,
        "NAD83(CSRS) / MTM zone 11", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-82.5 +k=0.9999 +x_0=304800 ");
    add_proj4text (p, 1,
        "+y_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_");
    add_proj4text (p, 2,
        "defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 11\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-82.5],PARAMETER[\"scal");
    add_srs_wkt (p, 10,
        "e_factor\",0.9999],PARAMETER[\"false_easting\",304800],P");
    add_srs_wkt (p, 11,
        "ARAMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORIT");
    add_srs_wkt (p, 12,
        "Y[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Nort");
    add_srs_wkt (p, 13,
        "hing\",NORTH],AUTHORITY[\"EPSG\",\"26891\"]]");
    p = add_epsg_def_ex (filter, first, last, 26892, "epsg", 26892,
        "NAD83(CSRS) / MTM zone 12", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-81 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 12\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-81],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26892\"]]");
    p = add_epsg_def_ex (filter, first, last, 26893, "epsg", 26893,
        "NAD83(CSRS) / MTM zone 13", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-84 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 13\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-84],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26893\"]]");
    p = add_epsg_def_ex (filter, first, last, 26894, "epsg", 26894,
        "NAD83(CSRS) / MTM zone 14", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-87 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 14\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-87],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26894\"]]");
    p = add_epsg_def_ex (filter, first, last, 26895, "epsg", 26895,
        "NAD83(CSRS) / MTM zone 15", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-90 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 15\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-90],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26895\"]]");
    p = add_epsg_def_ex (filter, first, last, 26896, "epsg", 26896,
        "NAD83(CSRS) / MTM zone 16", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-93 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 16\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-93],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26896\"]]");
    p = add_epsg_def_ex (filter, first, last, 26897, "epsg", 26897,
        "NAD83(CSRS) / MTM zone 17", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-96 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 17\",GEOGCS[\"NAD83(CSRS");
    add_srs_wkt (p, 1,
        ")\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SP");
    add_srs_wkt (p, 2,
        "HEROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EP");
    add_srs_wkt (p, 3,
        "SG\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-96],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST],AXIS[\"Northi");
    add_srs_wkt (p, 13,
        "ng\",NORTH],AUTHORITY[\"EPSG\",\"26897\"]]");
    p = add_epsg_def_ex (filter, first, last, 26898, "epsg", 26898,
        "NAD83(CSRS) / MTM zone 1", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "E(X)", "East", "N(Y)", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-53 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 1\",GEOGCS[\"NAD83(CSRS)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-53],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"26898\"]]");
    p = add_epsg_def_ex (filter, first, last, 26899, "epsg", 26899,
        "NAD83(CSRS) / MTM zone 2", 0, 0,
        "GRS 1980", "Greenwich",
        "NAD83_Canadian_Spatial_Reference_System", "Transverse_Mercator", "metre",
        "E(X)", "East", "N(Y)", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-56 +k=0.9999 +x_0=304800 +y");
    add_proj4text (p, 1,
        "_0=0 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83(CSRS) / MTM zone 2\",GEOGCS[\"NAD83(CSRS)");
    add_srs_wkt (p, 1,
        "\",DATUM[\"NAD83_Canadian_Spatial_Reference_System\",SPH");
    add_srs_wkt (p, 2,
        "EROID[\"GRS 1980\",6378137,298.257222101,AUTHORITY[\"EPS");
    add_srs_wkt (p, 3,
        "G\",\"7019\"]],TOWGS84[0,0,0,0,0,0,0],AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 4,
        ",\"6140\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"");
    add_srs_wkt (p, 5,
        "8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"");
    add_srs_wkt (p, 6,
        "EPSG\",\"9122\"]],AXIS[\"Latitude\",NORTH],AXIS[\"Longit");
    add_srs_wkt (p, 7,
        "ude\",EAST],AUTHORITY[\"EPSG\",\"4617\"]],PROJECTION[\"T");
    add_srs_wkt (p, 8,
        "ransverse_Mercator\"],PARAMETER[\"latitude_of_origin\",0");
    add_srs_wkt (p, 9,
        "],PARAMETER[\"central_meridian\",-56],PARAMETER[\"scale_");
    add_srs_wkt (p, 10,
        "factor\",0.9999],PARAMETER[\"false_easting\",304800],PAR");
    add_srs_wkt (p, 11,
        "AMETER[\"false_northing\",0],UNIT[\"metre\",1,AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"9001\"]],AXIS[\"E(X)\",EAST],AXIS[\"N(Y)\",NO");
    add_srs_wkt (p, 13,
        "RTH],AUTHORITY[\"EPSG\",\"26899\"]]");
    p = add_epsg_def_ex (filter, first, last, 26901, "epsg", 26901,
        "NAD83 / UTM zone 1N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=1 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 1N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-177],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26901\"]]");
    p = add_epsg_def_ex (filter, first, last, 26902, "epsg", 26902,
        "NAD83 / UTM zone 2N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=2 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 2N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-171],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26902\"]]");
    p = add_epsg_def_ex (filter, first, last, 26903, "epsg", 26903,
        "NAD83 / UTM zone 3N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=3 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 3N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-165],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26903\"]]");
    p = add_epsg_def_ex (filter, first, last, 26904, "epsg", 26904,
        "NAD83 / UTM zone 4N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=4 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 4N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-159],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26904\"]]");
    p = add_epsg_def_ex (filter, first, last, 26905, "epsg", 26905,
        "NAD83 / UTM zone 5N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=5 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 5N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-153],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26905\"]]");
    p = add_epsg_def_ex (filter, first, last, 26906, "epsg", 26906,
        "NAD83 / UTM zone 6N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=6 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 6N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-147],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26906\"]]");
    p = add_epsg_def_ex (filter, first, last, 26907, "epsg", 26907,
        "NAD83 / UTM zone 7N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=7 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 7N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-141],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26907\"]]");
    p = add_epsg_def_ex (filter, first, last, 26908, "epsg", 26908,
        "NAD83 / UTM zone 8N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=8 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 8N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-135],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26908\"]]");
    p = add_epsg_def_ex (filter, first, last, 26909, "epsg", 26909,
        "NAD83 / UTM zone 9N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=9 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +u");
    add_proj4text (p, 1,
        "nits=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 9N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-129],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26909\"]]");
    p = add_epsg_def_ex (filter, first, last, 26910, "epsg", 26910,
        "NAD83 / UTM zone 10N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=10 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 10N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-123],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26910\"]]");
    p = add_epsg_def_ex (filter, first, last, 26911, "epsg", 26911,
        "NAD83 / UTM zone 11N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=11 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 11N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-117],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26911\"]]");
    p = add_epsg_def_ex (filter, first, last, 26912, "epsg", 26912,
        "NAD83 / UTM zone 12N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=12 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 12N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-111],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26912\"]]");
    p = add_epsg_def_ex (filter, first, last, 26913, "epsg", 26913,
        "NAD83 / UTM zone 13N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=13 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 13N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-105],PARAMETER[\"scale_factor\",0.9996],PARAMET");
    add_srs_wkt (p, 10,
        "ER[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26913\"]]");
    p = add_epsg_def_ex (filter, first, last, 26914, "epsg", 26914,
        "NAD83 / UTM zone 14N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=14 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 14N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-99],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26914\"]]");
    p = add_epsg_def_ex (filter, first, last, 26915, "epsg", 26915,
        "NAD83 / UTM zone 15N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=15 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 15N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-93],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26915\"]]");
    p = add_epsg_def_ex (filter, first, last, 26916, "epsg", 26916,
        "NAD83 / UTM zone 16N", 0, 0,
        "GRS 1980", "Greenwich",
        "North_American_Datum_1983", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=utm +zone=16 +ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +");
    add_proj4text (p, 1,
        "units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"NAD83 / UTM zone 16N\",GEOGCS[\"NAD83\",DATUM[\"");
    add_srs_wkt (p, 1,
        "North_American_Datum_1983\",SPHEROID[\"GRS 1980\",637813");
    add_srs_wkt (p, 2,
        "7,298.257222101,AUTHORITY[\"EPSG\",\"7019\"]],TOWGS84[0,");
    add_srs_wkt (p, 3,
        "0,0,0,0,0,0],AUTHORITY[\"EPSG\",\"6269\"]],PRIMEM[\"Gree");
    add_srs_wkt (p, 4,
        "nwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",");
    add_srs_wkt (p, 5,
        "0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AXIS[\"");
    add_srs_wkt (p, 6,
        "Latitude\",NORTH],AXIS[\"Longitude\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 7,
        "PSG\",\"4269\"]],PROJECTION[\"Transverse_Mercator\"],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"latitude_of_origin\",0],PARAMETER[\"central_mer");
    add_srs_wkt (p, 9,
        "idian\",-87],PARAMETER[\"scale_factor\",0.9996],PARAMETE");
    add_srs_wkt (p, 10,
        "R[\"false_easting\",500000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 11,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 12,
        "\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHORITY[\"E");
    add_srs_wkt (p, 13,
        "PSG\",\"26916\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

