"""
Copyright (c) 2009 Barry Schwartz

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
"""

#--------------------------------------------------------------------------

import fontforge
import psMat
import unicodedata
import sys
from math import pi
from . import spacing_by_anchors

#--------------------------------------------------------------------------

# aglfn generated by: awk -F\; "/^[0-9A-F]/ {print \"    0x\"\$1 \":'\" \$2 \"', '\" \$2 \"':0x\" \$1 \",\"}" < aglfn.txt
aglfn = {
    0x0041:'A', 'A':0x0041,
    0x00C6:'AE', 'AE':0x00C6,
    0x01FC:'AEacute', 'AEacute':0x01FC,
    0x00C1:'Aacute', 'Aacute':0x00C1,
    0x0102:'Abreve', 'Abreve':0x0102,
    0x00C2:'Acircumflex', 'Acircumflex':0x00C2,
    0x00C4:'Adieresis', 'Adieresis':0x00C4,
    0x00C0:'Agrave', 'Agrave':0x00C0,
    0x0391:'Alpha', 'Alpha':0x0391,
    0x0386:'Alphatonos', 'Alphatonos':0x0386,
    0x0100:'Amacron', 'Amacron':0x0100,
    0x0104:'Aogonek', 'Aogonek':0x0104,
    0x00C5:'Aring', 'Aring':0x00C5,
    0x01FA:'Aringacute', 'Aringacute':0x01FA,
    0x00C3:'Atilde', 'Atilde':0x00C3,
    0x0042:'B', 'B':0x0042,
    0x0392:'Beta', 'Beta':0x0392,
    0x0043:'C', 'C':0x0043,
    0x0106:'Cacute', 'Cacute':0x0106,
    0x010C:'Ccaron', 'Ccaron':0x010C,
    0x00C7:'Ccedilla', 'Ccedilla':0x00C7,
    0x0108:'Ccircumflex', 'Ccircumflex':0x0108,
    0x010A:'Cdotaccent', 'Cdotaccent':0x010A,
    0x03A7:'Chi', 'Chi':0x03A7,
    0x0044:'D', 'D':0x0044,
    0x010E:'Dcaron', 'Dcaron':0x010E,
    0x0110:'Dcroat', 'Dcroat':0x0110,
    0x0394:'Delta', 'Delta':0x0394,
    0x0045:'E', 'E':0x0045,
    0x00C9:'Eacute', 'Eacute':0x00C9,
    0x0114:'Ebreve', 'Ebreve':0x0114,
    0x011A:'Ecaron', 'Ecaron':0x011A,
    0x00CA:'Ecircumflex', 'Ecircumflex':0x00CA,
    0x00CB:'Edieresis', 'Edieresis':0x00CB,
    0x0116:'Edotaccent', 'Edotaccent':0x0116,
    0x00C8:'Egrave', 'Egrave':0x00C8,
    0x0112:'Emacron', 'Emacron':0x0112,
    0x014A:'Eng', 'Eng':0x014A,
    0x0118:'Eogonek', 'Eogonek':0x0118,
    0x0395:'Epsilon', 'Epsilon':0x0395,
    0x0388:'Epsilontonos', 'Epsilontonos':0x0388,
    0x0397:'Eta', 'Eta':0x0397,
    0x0389:'Etatonos', 'Etatonos':0x0389,
    0x00D0:'Eth', 'Eth':0x00D0,
    0x20AC:'Euro', 'Euro':0x20AC,
    0x0046:'F', 'F':0x0046,
    0x0047:'G', 'G':0x0047,
    0x0393:'Gamma', 'Gamma':0x0393,
    0x011E:'Gbreve', 'Gbreve':0x011E,
    0x01E6:'Gcaron', 'Gcaron':0x01E6,
    0x011C:'Gcircumflex', 'Gcircumflex':0x011C,
    0x0122:'Gcommaaccent', 'Gcommaaccent':0x0122,
    0x0120:'Gdotaccent', 'Gdotaccent':0x0120,
    0x0048:'H', 'H':0x0048,
    0x25CF:'H18533', 'H18533':0x25CF,
    0x25AA:'H18543', 'H18543':0x25AA,
    0x25AB:'H18551', 'H18551':0x25AB,
    0x25A1:'H22073', 'H22073':0x25A1,
    0x0126:'Hbar', 'Hbar':0x0126,
    0x0124:'Hcircumflex', 'Hcircumflex':0x0124,
    0x0049:'I', 'I':0x0049,
    0x0132:'IJ', 'IJ':0x0132,
    0x00CD:'Iacute', 'Iacute':0x00CD,
    0x012C:'Ibreve', 'Ibreve':0x012C,
    0x00CE:'Icircumflex', 'Icircumflex':0x00CE,
    0x00CF:'Idieresis', 'Idieresis':0x00CF,
    0x0130:'Idotaccent', 'Idotaccent':0x0130,
    0x2111:'Ifraktur', 'Ifraktur':0x2111,
    0x00CC:'Igrave', 'Igrave':0x00CC,
    0x012A:'Imacron', 'Imacron':0x012A,
    0x012E:'Iogonek', 'Iogonek':0x012E,
    0x0399:'Iota', 'Iota':0x0399,
    0x03AA:'Iotadieresis', 'Iotadieresis':0x03AA,
    0x038A:'Iotatonos', 'Iotatonos':0x038A,
    0x0128:'Itilde', 'Itilde':0x0128,
    0x004A:'J', 'J':0x004A,
    0x0134:'Jcircumflex', 'Jcircumflex':0x0134,
    0x004B:'K', 'K':0x004B,
    0x039A:'Kappa', 'Kappa':0x039A,
    0x0136:'Kcommaaccent', 'Kcommaaccent':0x0136,
    0x004C:'L', 'L':0x004C,
    0x0139:'Lacute', 'Lacute':0x0139,
    0x039B:'Lambda', 'Lambda':0x039B,
    0x013D:'Lcaron', 'Lcaron':0x013D,
    0x013B:'Lcommaaccent', 'Lcommaaccent':0x013B,
    0x013F:'Ldot', 'Ldot':0x013F,
    0x0141:'Lslash', 'Lslash':0x0141,
    0x004D:'M', 'M':0x004D,
    0x039C:'Mu', 'Mu':0x039C,
    0x004E:'N', 'N':0x004E,
    0x0143:'Nacute', 'Nacute':0x0143,
    0x0147:'Ncaron', 'Ncaron':0x0147,
    0x0145:'Ncommaaccent', 'Ncommaaccent':0x0145,
    0x00D1:'Ntilde', 'Ntilde':0x00D1,
    0x039D:'Nu', 'Nu':0x039D,
    0x004F:'O', 'O':0x004F,
    0x0152:'OE', 'OE':0x0152,
    0x00D3:'Oacute', 'Oacute':0x00D3,
    0x014E:'Obreve', 'Obreve':0x014E,
    0x00D4:'Ocircumflex', 'Ocircumflex':0x00D4,
    0x00D6:'Odieresis', 'Odieresis':0x00D6,
    0x00D2:'Ograve', 'Ograve':0x00D2,
    0x01A0:'Ohorn', 'Ohorn':0x01A0,
    0x0150:'Ohungarumlaut', 'Ohungarumlaut':0x0150,
    0x014C:'Omacron', 'Omacron':0x014C,
    0x03A9:'Omega', 'Omega':0x03A9,
    0x038F:'Omegatonos', 'Omegatonos':0x038F,
    0x039F:'Omicron', 'Omicron':0x039F,
    0x038C:'Omicrontonos', 'Omicrontonos':0x038C,
    0x00D8:'Oslash', 'Oslash':0x00D8,
    0x01FE:'Oslashacute', 'Oslashacute':0x01FE,
    0x00D5:'Otilde', 'Otilde':0x00D5,
    0x0050:'P', 'P':0x0050,
    0x03A6:'Phi', 'Phi':0x03A6,
    0x03A0:'Pi', 'Pi':0x03A0,
    0x03A8:'Psi', 'Psi':0x03A8,
    0x0051:'Q', 'Q':0x0051,
    0x0052:'R', 'R':0x0052,
    0x0154:'Racute', 'Racute':0x0154,
    0x0158:'Rcaron', 'Rcaron':0x0158,
    0x0156:'Rcommaaccent', 'Rcommaaccent':0x0156,
    0x211C:'Rfraktur', 'Rfraktur':0x211C,
    0x03A1:'Rho', 'Rho':0x03A1,
    0x0053:'S', 'S':0x0053,
    0x250C:'SF010000', 'SF010000':0x250C,
    0x2514:'SF020000', 'SF020000':0x2514,
    0x2510:'SF030000', 'SF030000':0x2510,
    0x2518:'SF040000', 'SF040000':0x2518,
    0x253C:'SF050000', 'SF050000':0x253C,
    0x252C:'SF060000', 'SF060000':0x252C,
    0x2534:'SF070000', 'SF070000':0x2534,
    0x251C:'SF080000', 'SF080000':0x251C,
    0x2524:'SF090000', 'SF090000':0x2524,
    0x2500:'SF100000', 'SF100000':0x2500,
    0x2502:'SF110000', 'SF110000':0x2502,
    0x2561:'SF190000', 'SF190000':0x2561,
    0x2562:'SF200000', 'SF200000':0x2562,
    0x2556:'SF210000', 'SF210000':0x2556,
    0x2555:'SF220000', 'SF220000':0x2555,
    0x2563:'SF230000', 'SF230000':0x2563,
    0x2551:'SF240000', 'SF240000':0x2551,
    0x2557:'SF250000', 'SF250000':0x2557,
    0x255D:'SF260000', 'SF260000':0x255D,
    0x255C:'SF270000', 'SF270000':0x255C,
    0x255B:'SF280000', 'SF280000':0x255B,
    0x255E:'SF360000', 'SF360000':0x255E,
    0x255F:'SF370000', 'SF370000':0x255F,
    0x255A:'SF380000', 'SF380000':0x255A,
    0x2554:'SF390000', 'SF390000':0x2554,
    0x2569:'SF400000', 'SF400000':0x2569,
    0x2566:'SF410000', 'SF410000':0x2566,
    0x2560:'SF420000', 'SF420000':0x2560,
    0x2550:'SF430000', 'SF430000':0x2550,
    0x256C:'SF440000', 'SF440000':0x256C,
    0x2567:'SF450000', 'SF450000':0x2567,
    0x2568:'SF460000', 'SF460000':0x2568,
    0x2564:'SF470000', 'SF470000':0x2564,
    0x2565:'SF480000', 'SF480000':0x2565,
    0x2559:'SF490000', 'SF490000':0x2559,
    0x2558:'SF500000', 'SF500000':0x2558,
    0x2552:'SF510000', 'SF510000':0x2552,
    0x2553:'SF520000', 'SF520000':0x2553,
    0x256B:'SF530000', 'SF530000':0x256B,
    0x256A:'SF540000', 'SF540000':0x256A,
    0x015A:'Sacute', 'Sacute':0x015A,
    0x0160:'Scaron', 'Scaron':0x0160,
    0x015E:'Scedilla', 'Scedilla':0x015E,
    0x015C:'Scircumflex', 'Scircumflex':0x015C,
    0x0218:'Scommaaccent', 'Scommaaccent':0x0218,
    0x03A3:'Sigma', 'Sigma':0x03A3,
    0x0054:'T', 'T':0x0054,
    0x03A4:'Tau', 'Tau':0x03A4,
    0x0166:'Tbar', 'Tbar':0x0166,
    0x0164:'Tcaron', 'Tcaron':0x0164,
    0x0162:'Tcommaaccent', 'Tcommaaccent':0x0162,
    0x0398:'Theta', 'Theta':0x0398,
    0x00DE:'Thorn', 'Thorn':0x00DE,
    0x0055:'U', 'U':0x0055,
    0x00DA:'Uacute', 'Uacute':0x00DA,
    0x016C:'Ubreve', 'Ubreve':0x016C,
    0x00DB:'Ucircumflex', 'Ucircumflex':0x00DB,
    0x00DC:'Udieresis', 'Udieresis':0x00DC,
    0x00D9:'Ugrave', 'Ugrave':0x00D9,
    0x01AF:'Uhorn', 'Uhorn':0x01AF,
    0x0170:'Uhungarumlaut', 'Uhungarumlaut':0x0170,
    0x016A:'Umacron', 'Umacron':0x016A,
    0x0172:'Uogonek', 'Uogonek':0x0172,
    0x03A5:'Upsilon', 'Upsilon':0x03A5,
    0x03D2:'Upsilon1', 'Upsilon1':0x03D2,
    0x03AB:'Upsilondieresis', 'Upsilondieresis':0x03AB,
    0x038E:'Upsilontonos', 'Upsilontonos':0x038E,
    0x016E:'Uring', 'Uring':0x016E,
    0x0168:'Utilde', 'Utilde':0x0168,
    0x0056:'V', 'V':0x0056,
    0x0057:'W', 'W':0x0057,
    0x1E82:'Wacute', 'Wacute':0x1E82,
    0x0174:'Wcircumflex', 'Wcircumflex':0x0174,
    0x1E84:'Wdieresis', 'Wdieresis':0x1E84,
    0x1E80:'Wgrave', 'Wgrave':0x1E80,
    0x0058:'X', 'X':0x0058,
    0x039E:'Xi', 'Xi':0x039E,
    0x0059:'Y', 'Y':0x0059,
    0x00DD:'Yacute', 'Yacute':0x00DD,
    0x0176:'Ycircumflex', 'Ycircumflex':0x0176,
    0x0178:'Ydieresis', 'Ydieresis':0x0178,
    0x1EF2:'Ygrave', 'Ygrave':0x1EF2,
    0x005A:'Z', 'Z':0x005A,
    0x0179:'Zacute', 'Zacute':0x0179,
    0x017D:'Zcaron', 'Zcaron':0x017D,
    0x017B:'Zdotaccent', 'Zdotaccent':0x017B,
    0x0396:'Zeta', 'Zeta':0x0396,
    0x0061:'a', 'a':0x0061,
    0x00E1:'aacute', 'aacute':0x00E1,
    0x0103:'abreve', 'abreve':0x0103,
    0x00E2:'acircumflex', 'acircumflex':0x00E2,
    0x00B4:'acute', 'acute':0x00B4,
    0x0301:'acutecomb', 'acutecomb':0x0301,
    0x00E4:'adieresis', 'adieresis':0x00E4,
    0x00E6:'ae', 'ae':0x00E6,
    0x01FD:'aeacute', 'aeacute':0x01FD,
    0x2015:'afii00208', 'afii00208':0x2015,
    0x0410:'afii10017', 'afii10017':0x0410,
    0x0411:'afii10018', 'afii10018':0x0411,
    0x0412:'afii10019', 'afii10019':0x0412,
    0x0413:'afii10020', 'afii10020':0x0413,
    0x0414:'afii10021', 'afii10021':0x0414,
    0x0415:'afii10022', 'afii10022':0x0415,
    0x0401:'afii10023', 'afii10023':0x0401,
    0x0416:'afii10024', 'afii10024':0x0416,
    0x0417:'afii10025', 'afii10025':0x0417,
    0x0418:'afii10026', 'afii10026':0x0418,
    0x0419:'afii10027', 'afii10027':0x0419,
    0x041A:'afii10028', 'afii10028':0x041A,
    0x041B:'afii10029', 'afii10029':0x041B,
    0x041C:'afii10030', 'afii10030':0x041C,
    0x041D:'afii10031', 'afii10031':0x041D,
    0x041E:'afii10032', 'afii10032':0x041E,
    0x041F:'afii10033', 'afii10033':0x041F,
    0x0420:'afii10034', 'afii10034':0x0420,
    0x0421:'afii10035', 'afii10035':0x0421,
    0x0422:'afii10036', 'afii10036':0x0422,
    0x0423:'afii10037', 'afii10037':0x0423,
    0x0424:'afii10038', 'afii10038':0x0424,
    0x0425:'afii10039', 'afii10039':0x0425,
    0x0426:'afii10040', 'afii10040':0x0426,
    0x0427:'afii10041', 'afii10041':0x0427,
    0x0428:'afii10042', 'afii10042':0x0428,
    0x0429:'afii10043', 'afii10043':0x0429,
    0x042A:'afii10044', 'afii10044':0x042A,
    0x042B:'afii10045', 'afii10045':0x042B,
    0x042C:'afii10046', 'afii10046':0x042C,
    0x042D:'afii10047', 'afii10047':0x042D,
    0x042E:'afii10048', 'afii10048':0x042E,
    0x042F:'afii10049', 'afii10049':0x042F,
    0x0490:'afii10050', 'afii10050':0x0490,
    0x0402:'afii10051', 'afii10051':0x0402,
    0x0403:'afii10052', 'afii10052':0x0403,
    0x0404:'afii10053', 'afii10053':0x0404,
    0x0405:'afii10054', 'afii10054':0x0405,
    0x0406:'afii10055', 'afii10055':0x0406,
    0x0407:'afii10056', 'afii10056':0x0407,
    0x0408:'afii10057', 'afii10057':0x0408,
    0x0409:'afii10058', 'afii10058':0x0409,
    0x040A:'afii10059', 'afii10059':0x040A,
    0x040B:'afii10060', 'afii10060':0x040B,
    0x040C:'afii10061', 'afii10061':0x040C,
    0x040E:'afii10062', 'afii10062':0x040E,
    0x0430:'afii10065', 'afii10065':0x0430,
    0x0431:'afii10066', 'afii10066':0x0431,
    0x0432:'afii10067', 'afii10067':0x0432,
    0x0433:'afii10068', 'afii10068':0x0433,
    0x0434:'afii10069', 'afii10069':0x0434,
    0x0435:'afii10070', 'afii10070':0x0435,
    0x0451:'afii10071', 'afii10071':0x0451,
    0x0436:'afii10072', 'afii10072':0x0436,
    0x0437:'afii10073', 'afii10073':0x0437,
    0x0438:'afii10074', 'afii10074':0x0438,
    0x0439:'afii10075', 'afii10075':0x0439,
    0x043A:'afii10076', 'afii10076':0x043A,
    0x043B:'afii10077', 'afii10077':0x043B,
    0x043C:'afii10078', 'afii10078':0x043C,
    0x043D:'afii10079', 'afii10079':0x043D,
    0x043E:'afii10080', 'afii10080':0x043E,
    0x043F:'afii10081', 'afii10081':0x043F,
    0x0440:'afii10082', 'afii10082':0x0440,
    0x0441:'afii10083', 'afii10083':0x0441,
    0x0442:'afii10084', 'afii10084':0x0442,
    0x0443:'afii10085', 'afii10085':0x0443,
    0x0444:'afii10086', 'afii10086':0x0444,
    0x0445:'afii10087', 'afii10087':0x0445,
    0x0446:'afii10088', 'afii10088':0x0446,
    0x0447:'afii10089', 'afii10089':0x0447,
    0x0448:'afii10090', 'afii10090':0x0448,
    0x0449:'afii10091', 'afii10091':0x0449,
    0x044A:'afii10092', 'afii10092':0x044A,
    0x044B:'afii10093', 'afii10093':0x044B,
    0x044C:'afii10094', 'afii10094':0x044C,
    0x044D:'afii10095', 'afii10095':0x044D,
    0x044E:'afii10096', 'afii10096':0x044E,
    0x044F:'afii10097', 'afii10097':0x044F,
    0x0491:'afii10098', 'afii10098':0x0491,
    0x0452:'afii10099', 'afii10099':0x0452,
    0x0453:'afii10100', 'afii10100':0x0453,
    0x0454:'afii10101', 'afii10101':0x0454,
    0x0455:'afii10102', 'afii10102':0x0455,
    0x0456:'afii10103', 'afii10103':0x0456,
    0x0457:'afii10104', 'afii10104':0x0457,
    0x0458:'afii10105', 'afii10105':0x0458,
    0x0459:'afii10106', 'afii10106':0x0459,
    0x045A:'afii10107', 'afii10107':0x045A,
    0x045B:'afii10108', 'afii10108':0x045B,
    0x045C:'afii10109', 'afii10109':0x045C,
    0x045E:'afii10110', 'afii10110':0x045E,
    0x040F:'afii10145', 'afii10145':0x040F,
    0x0462:'afii10146', 'afii10146':0x0462,
    0x0472:'afii10147', 'afii10147':0x0472,
    0x0474:'afii10148', 'afii10148':0x0474,
    0x045F:'afii10193', 'afii10193':0x045F,
    0x0463:'afii10194', 'afii10194':0x0463,
    0x0473:'afii10195', 'afii10195':0x0473,
    0x0475:'afii10196', 'afii10196':0x0475,
    0x04D9:'afii10846', 'afii10846':0x04D9,
    0x200E:'afii299', 'afii299':0x200E,
    0x200F:'afii300', 'afii300':0x200F,
    0x200D:'afii301', 'afii301':0x200D,
    0x066A:'afii57381', 'afii57381':0x066A,
    0x060C:'afii57388', 'afii57388':0x060C,
    0x0660:'afii57392', 'afii57392':0x0660,
    0x0661:'afii57393', 'afii57393':0x0661,
    0x0662:'afii57394', 'afii57394':0x0662,
    0x0663:'afii57395', 'afii57395':0x0663,
    0x0664:'afii57396', 'afii57396':0x0664,
    0x0665:'afii57397', 'afii57397':0x0665,
    0x0666:'afii57398', 'afii57398':0x0666,
    0x0667:'afii57399', 'afii57399':0x0667,
    0x0668:'afii57400', 'afii57400':0x0668,
    0x0669:'afii57401', 'afii57401':0x0669,
    0x061B:'afii57403', 'afii57403':0x061B,
    0x061F:'afii57407', 'afii57407':0x061F,
    0x0621:'afii57409', 'afii57409':0x0621,
    0x0622:'afii57410', 'afii57410':0x0622,
    0x0623:'afii57411', 'afii57411':0x0623,
    0x0624:'afii57412', 'afii57412':0x0624,
    0x0625:'afii57413', 'afii57413':0x0625,
    0x0626:'afii57414', 'afii57414':0x0626,
    0x0627:'afii57415', 'afii57415':0x0627,
    0x0628:'afii57416', 'afii57416':0x0628,
    0x0629:'afii57417', 'afii57417':0x0629,
    0x062A:'afii57418', 'afii57418':0x062A,
    0x062B:'afii57419', 'afii57419':0x062B,
    0x062C:'afii57420', 'afii57420':0x062C,
    0x062D:'afii57421', 'afii57421':0x062D,
    0x062E:'afii57422', 'afii57422':0x062E,
    0x062F:'afii57423', 'afii57423':0x062F,
    0x0630:'afii57424', 'afii57424':0x0630,
    0x0631:'afii57425', 'afii57425':0x0631,
    0x0632:'afii57426', 'afii57426':0x0632,
    0x0633:'afii57427', 'afii57427':0x0633,
    0x0634:'afii57428', 'afii57428':0x0634,
    0x0635:'afii57429', 'afii57429':0x0635,
    0x0636:'afii57430', 'afii57430':0x0636,
    0x0637:'afii57431', 'afii57431':0x0637,
    0x0638:'afii57432', 'afii57432':0x0638,
    0x0639:'afii57433', 'afii57433':0x0639,
    0x063A:'afii57434', 'afii57434':0x063A,
    0x0640:'afii57440', 'afii57440':0x0640,
    0x0641:'afii57441', 'afii57441':0x0641,
    0x0642:'afii57442', 'afii57442':0x0642,
    0x0643:'afii57443', 'afii57443':0x0643,
    0x0644:'afii57444', 'afii57444':0x0644,
    0x0645:'afii57445', 'afii57445':0x0645,
    0x0646:'afii57446', 'afii57446':0x0646,
    0x0648:'afii57448', 'afii57448':0x0648,
    0x0649:'afii57449', 'afii57449':0x0649,
    0x064A:'afii57450', 'afii57450':0x064A,
    0x064B:'afii57451', 'afii57451':0x064B,
    0x064C:'afii57452', 'afii57452':0x064C,
    0x064D:'afii57453', 'afii57453':0x064D,
    0x064E:'afii57454', 'afii57454':0x064E,
    0x064F:'afii57455', 'afii57455':0x064F,
    0x0650:'afii57456', 'afii57456':0x0650,
    0x0651:'afii57457', 'afii57457':0x0651,
    0x0652:'afii57458', 'afii57458':0x0652,
    0x0647:'afii57470', 'afii57470':0x0647,
    0x06A4:'afii57505', 'afii57505':0x06A4,
    0x067E:'afii57506', 'afii57506':0x067E,
    0x0686:'afii57507', 'afii57507':0x0686,
    0x0698:'afii57508', 'afii57508':0x0698,
    0x06AF:'afii57509', 'afii57509':0x06AF,
    0x0679:'afii57511', 'afii57511':0x0679,
    0x0688:'afii57512', 'afii57512':0x0688,
    0x0691:'afii57513', 'afii57513':0x0691,
    0x06BA:'afii57514', 'afii57514':0x06BA,
    0x06D2:'afii57519', 'afii57519':0x06D2,
    0x06D5:'afii57534', 'afii57534':0x06D5,
    0x20AA:'afii57636', 'afii57636':0x20AA,
    0x05BE:'afii57645', 'afii57645':0x05BE,
    0x05C3:'afii57658', 'afii57658':0x05C3,
    0x05D0:'afii57664', 'afii57664':0x05D0,
    0x05D1:'afii57665', 'afii57665':0x05D1,
    0x05D2:'afii57666', 'afii57666':0x05D2,
    0x05D3:'afii57667', 'afii57667':0x05D3,
    0x05D4:'afii57668', 'afii57668':0x05D4,
    0x05D5:'afii57669', 'afii57669':0x05D5,
    0x05D6:'afii57670', 'afii57670':0x05D6,
    0x05D7:'afii57671', 'afii57671':0x05D7,
    0x05D8:'afii57672', 'afii57672':0x05D8,
    0x05D9:'afii57673', 'afii57673':0x05D9,
    0x05DA:'afii57674', 'afii57674':0x05DA,
    0x05DB:'afii57675', 'afii57675':0x05DB,
    0x05DC:'afii57676', 'afii57676':0x05DC,
    0x05DD:'afii57677', 'afii57677':0x05DD,
    0x05DE:'afii57678', 'afii57678':0x05DE,
    0x05DF:'afii57679', 'afii57679':0x05DF,
    0x05E0:'afii57680', 'afii57680':0x05E0,
    0x05E1:'afii57681', 'afii57681':0x05E1,
    0x05E2:'afii57682', 'afii57682':0x05E2,
    0x05E3:'afii57683', 'afii57683':0x05E3,
    0x05E4:'afii57684', 'afii57684':0x05E4,
    0x05E5:'afii57685', 'afii57685':0x05E5,
    0x05E6:'afii57686', 'afii57686':0x05E6,
    0x05E7:'afii57687', 'afii57687':0x05E7,
    0x05E8:'afii57688', 'afii57688':0x05E8,
    0x05E9:'afii57689', 'afii57689':0x05E9,
    0x05EA:'afii57690', 'afii57690':0x05EA,
    0x05F0:'afii57716', 'afii57716':0x05F0,
    0x05F1:'afii57717', 'afii57717':0x05F1,
    0x05F2:'afii57718', 'afii57718':0x05F2,
    0x05B4:'afii57793', 'afii57793':0x05B4,
    0x05B5:'afii57794', 'afii57794':0x05B5,
    0x05B6:'afii57795', 'afii57795':0x05B6,
    0x05BB:'afii57796', 'afii57796':0x05BB,
    0x05B8:'afii57797', 'afii57797':0x05B8,
    0x05B7:'afii57798', 'afii57798':0x05B7,
    0x05B0:'afii57799', 'afii57799':0x05B0,
    0x05B2:'afii57800', 'afii57800':0x05B2,
    0x05B1:'afii57801', 'afii57801':0x05B1,
    0x05B3:'afii57802', 'afii57802':0x05B3,
    0x05C2:'afii57803', 'afii57803':0x05C2,
    0x05C1:'afii57804', 'afii57804':0x05C1,
    0x05B9:'afii57806', 'afii57806':0x05B9,
    0x05BC:'afii57807', 'afii57807':0x05BC,
    0x05BD:'afii57839', 'afii57839':0x05BD,
    0x05BF:'afii57841', 'afii57841':0x05BF,
    0x05C0:'afii57842', 'afii57842':0x05C0,
    0x02BC:'afii57929', 'afii57929':0x02BC,
    0x2105:'afii61248', 'afii61248':0x2105,
    0x2113:'afii61289', 'afii61289':0x2113,
    0x2116:'afii61352', 'afii61352':0x2116,
    0x202C:'afii61573', 'afii61573':0x202C,
    0x202D:'afii61574', 'afii61574':0x202D,
    0x202E:'afii61575', 'afii61575':0x202E,
    0x200C:'afii61664', 'afii61664':0x200C,
    0x066D:'afii63167', 'afii63167':0x066D,
    0x02BD:'afii64937', 'afii64937':0x02BD,
    0x00E0:'agrave', 'agrave':0x00E0,
    0x2135:'aleph', 'aleph':0x2135,
    0x03B1:'alpha', 'alpha':0x03B1,
    0x03AC:'alphatonos', 'alphatonos':0x03AC,
    0x0101:'amacron', 'amacron':0x0101,
    0x0026:'ampersand', 'ampersand':0x0026,
    0x2220:'angle', 'angle':0x2220,
    0x2329:'angleleft', 'angleleft':0x2329,
    0x232A:'angleright', 'angleright':0x232A,
    0x0387:'anoteleia', 'anoteleia':0x0387,
    0x0105:'aogonek', 'aogonek':0x0105,
    0x2248:'approxequal', 'approxequal':0x2248,
    0x00E5:'aring', 'aring':0x00E5,
    0x01FB:'aringacute', 'aringacute':0x01FB,
    0x2194:'arrowboth', 'arrowboth':0x2194,
    0x21D4:'arrowdblboth', 'arrowdblboth':0x21D4,
    0x21D3:'arrowdbldown', 'arrowdbldown':0x21D3,
    0x21D0:'arrowdblleft', 'arrowdblleft':0x21D0,
    0x21D2:'arrowdblright', 'arrowdblright':0x21D2,
    0x21D1:'arrowdblup', 'arrowdblup':0x21D1,
    0x2193:'arrowdown', 'arrowdown':0x2193,
    0x2190:'arrowleft', 'arrowleft':0x2190,
    0x2192:'arrowright', 'arrowright':0x2192,
    0x2191:'arrowup', 'arrowup':0x2191,
    0x2195:'arrowupdn', 'arrowupdn':0x2195,
    0x21A8:'arrowupdnbse', 'arrowupdnbse':0x21A8,
    0x005E:'asciicircum', 'asciicircum':0x005E,
    0x007E:'asciitilde', 'asciitilde':0x007E,
    0x002A:'asterisk', 'asterisk':0x002A,
    0x2217:'asteriskmath', 'asteriskmath':0x2217,
    0x0040:'at', 'at':0x0040,
    0x00E3:'atilde', 'atilde':0x00E3,
    0x0062:'b', 'b':0x0062,
    0x005C:'backslash', 'backslash':0x005C,
    0x007C:'bar', 'bar':0x007C,
    0x03B2:'beta', 'beta':0x03B2,
    0x2588:'block', 'block':0x2588,
    0x007B:'braceleft', 'braceleft':0x007B,
    0x007D:'braceright', 'braceright':0x007D,
    0x005B:'bracketleft', 'bracketleft':0x005B,
    0x005D:'bracketright', 'bracketright':0x005D,
    0x02D8:'breve', 'breve':0x02D8,
    0x00A6:'brokenbar', 'brokenbar':0x00A6,
    0x2022:'bullet', 'bullet':0x2022,
    0x0063:'c', 'c':0x0063,
    0x0107:'cacute', 'cacute':0x0107,
    0x02C7:'caron', 'caron':0x02C7,
    0x21B5:'carriagereturn', 'carriagereturn':0x21B5,
    0x010D:'ccaron', 'ccaron':0x010D,
    0x00E7:'ccedilla', 'ccedilla':0x00E7,
    0x0109:'ccircumflex', 'ccircumflex':0x0109,
    0x010B:'cdotaccent', 'cdotaccent':0x010B,
    0x00B8:'cedilla', 'cedilla':0x00B8,
    0x00A2:'cent', 'cent':0x00A2,
    0x03C7:'chi', 'chi':0x03C7,
    0x25CB:'circle', 'circle':0x25CB,
    0x2297:'circlemultiply', 'circlemultiply':0x2297,
    0x2295:'circleplus', 'circleplus':0x2295,
    0x02C6:'circumflex', 'circumflex':0x02C6,
    0x2663:'club', 'club':0x2663,
    0x003A:'colon', 'colon':0x003A,
    0x20A1:'colonmonetary', 'colonmonetary':0x20A1,
    0x002C:'comma', 'comma':0x002C,
    0x2245:'congruent', 'congruent':0x2245,
    0x00A9:'copyright', 'copyright':0x00A9,
    0x00A4:'currency', 'currency':0x00A4,
    0x0064:'d', 'd':0x0064,
    0x2020:'dagger', 'dagger':0x2020,
    0x2021:'daggerdbl', 'daggerdbl':0x2021,
    0x010F:'dcaron', 'dcaron':0x010F,
    0x0111:'dcroat', 'dcroat':0x0111,
    0x00B0:'degree', 'degree':0x00B0,
    0x03B4:'delta', 'delta':0x03B4,
    0x2666:'diamond', 'diamond':0x2666,
    0x00A8:'dieresis', 'dieresis':0x00A8,
    0x0385:'dieresistonos', 'dieresistonos':0x0385,
    0x00F7:'divide', 'divide':0x00F7,
    0x2593:'dkshade', 'dkshade':0x2593,
    0x2584:'dnblock', 'dnblock':0x2584,
    0x0024:'dollar', 'dollar':0x0024,
    0x20AB:'dong', 'dong':0x20AB,
    0x02D9:'dotaccent', 'dotaccent':0x02D9,
    0x0323:'dotbelowcomb', 'dotbelowcomb':0x0323,
    0x0131:'dotlessi', 'dotlessi':0x0131,
    0x22C5:'dotmath', 'dotmath':0x22C5,
    0x0065:'e', 'e':0x0065,
    0x00E9:'eacute', 'eacute':0x00E9,
    0x0115:'ebreve', 'ebreve':0x0115,
    0x011B:'ecaron', 'ecaron':0x011B,
    0x00EA:'ecircumflex', 'ecircumflex':0x00EA,
    0x00EB:'edieresis', 'edieresis':0x00EB,
    0x0117:'edotaccent', 'edotaccent':0x0117,
    0x00E8:'egrave', 'egrave':0x00E8,
    0x0038:'eight', 'eight':0x0038,
    0x2208:'element', 'element':0x2208,
    0x2026:'ellipsis', 'ellipsis':0x2026,
    0x0113:'emacron', 'emacron':0x0113,
    0x2014:'emdash', 'emdash':0x2014,
    0x2205:'emptyset', 'emptyset':0x2205,
    0x2013:'endash', 'endash':0x2013,
    0x014B:'eng', 'eng':0x014B,
    0x0119:'eogonek', 'eogonek':0x0119,
    0x03B5:'epsilon', 'epsilon':0x03B5,
    0x03AD:'epsilontonos', 'epsilontonos':0x03AD,
    0x003D:'equal', 'equal':0x003D,
    0x2261:'equivalence', 'equivalence':0x2261,
    0x212E:'estimated', 'estimated':0x212E,
    0x03B7:'eta', 'eta':0x03B7,
    0x03AE:'etatonos', 'etatonos':0x03AE,
    0x00F0:'eth', 'eth':0x00F0,
    0x0021:'exclam', 'exclam':0x0021,
    0x203C:'exclamdbl', 'exclamdbl':0x203C,
    0x00A1:'exclamdown', 'exclamdown':0x00A1,
    0x2203:'existential', 'existential':0x2203,
    0x0066:'f', 'f':0x0066,
    0x2640:'female', 'female':0x2640,
    0x2012:'figuredash', 'figuredash':0x2012,
    0x25A0:'filledbox', 'filledbox':0x25A0,
    0x25AC:'filledrect', 'filledrect':0x25AC,
    0x0035:'five', 'five':0x0035,
    0x215D:'fiveeighths', 'fiveeighths':0x215D,
    0x0192:'florin', 'florin':0x0192,
    0x0034:'four', 'four':0x0034,
    0x2044:'fraction', 'fraction':0x2044,
    0x20A3:'franc', 'franc':0x20A3,
    0x0067:'g', 'g':0x0067,
    0x03B3:'gamma', 'gamma':0x03B3,
    0x011F:'gbreve', 'gbreve':0x011F,
    0x01E7:'gcaron', 'gcaron':0x01E7,
    0x011D:'gcircumflex', 'gcircumflex':0x011D,
    0x0123:'gcommaaccent', 'gcommaaccent':0x0123,
    0x0121:'gdotaccent', 'gdotaccent':0x0121,
    0x00DF:'germandbls', 'germandbls':0x00DF,
    0x2207:'gradient', 'gradient':0x2207,
    0x0060:'grave', 'grave':0x0060,
    0x0300:'gravecomb', 'gravecomb':0x0300,
    0x003E:'greater', 'greater':0x003E,
    0x2265:'greaterequal', 'greaterequal':0x2265,
    0x00AB:'guillemotleft', 'guillemotleft':0x00AB,
    0x00BB:'guillemotright', 'guillemotright':0x00BB,
    0x2039:'guilsinglleft', 'guilsinglleft':0x2039,
    0x203A:'guilsinglright', 'guilsinglright':0x203A,
    0x0068:'h', 'h':0x0068,
    0x0127:'hbar', 'hbar':0x0127,
    0x0125:'hcircumflex', 'hcircumflex':0x0125,
    0x2665:'heart', 'heart':0x2665,
    0x0309:'hookabovecomb', 'hookabovecomb':0x0309,
    0x2302:'house', 'house':0x2302,
    0x02DD:'hungarumlaut', 'hungarumlaut':0x02DD,
    0x002D:'hyphen', 'hyphen':0x002D,
    0x0069:'i', 'i':0x0069,
    0x00ED:'iacute', 'iacute':0x00ED,
    0x012D:'ibreve', 'ibreve':0x012D,
    0x00EE:'icircumflex', 'icircumflex':0x00EE,
    0x00EF:'idieresis', 'idieresis':0x00EF,
    0x00EC:'igrave', 'igrave':0x00EC,
    0x0133:'ij', 'ij':0x0133,
    0x012B:'imacron', 'imacron':0x012B,
    0x221E:'infinity', 'infinity':0x221E,
    0x222B:'integral', 'integral':0x222B,
    0x2321:'integralbt', 'integralbt':0x2321,
    0x2320:'integraltp', 'integraltp':0x2320,
    0x2229:'intersection', 'intersection':0x2229,
    0x25D8:'invbullet', 'invbullet':0x25D8,
    0x25D9:'invcircle', 'invcircle':0x25D9,
    0x263B:'invsmileface', 'invsmileface':0x263B,
    0x012F:'iogonek', 'iogonek':0x012F,
    0x03B9:'iota', 'iota':0x03B9,
    0x03CA:'iotadieresis', 'iotadieresis':0x03CA,
    0x0390:'iotadieresistonos', 'iotadieresistonos':0x0390,
    0x03AF:'iotatonos', 'iotatonos':0x03AF,
    0x0129:'itilde', 'itilde':0x0129,
    0x006A:'j', 'j':0x006A,
    0x0135:'jcircumflex', 'jcircumflex':0x0135,
    0x006B:'k', 'k':0x006B,
    0x03BA:'kappa', 'kappa':0x03BA,
    0x0137:'kcommaaccent', 'kcommaaccent':0x0137,
    0x0138:'kgreenlandic', 'kgreenlandic':0x0138,
    0x006C:'l', 'l':0x006C,
    0x013A:'lacute', 'lacute':0x013A,
    0x03BB:'lambda', 'lambda':0x03BB,
    0x013E:'lcaron', 'lcaron':0x013E,
    0x013C:'lcommaaccent', 'lcommaaccent':0x013C,
    0x0140:'ldot', 'ldot':0x0140,
    0x003C:'less', 'less':0x003C,
    0x2264:'lessequal', 'lessequal':0x2264,
    0x258C:'lfblock', 'lfblock':0x258C,
    0x20A4:'lira', 'lira':0x20A4,
    0x2227:'logicaland', 'logicaland':0x2227,
    0x00AC:'logicalnot', 'logicalnot':0x00AC,
    0x2228:'logicalor', 'logicalor':0x2228,
    0x017F:'longs', 'longs':0x017F,
    0x25CA:'lozenge', 'lozenge':0x25CA,
    0x0142:'lslash', 'lslash':0x0142,
    0x2591:'ltshade', 'ltshade':0x2591,
    0x006D:'m', 'm':0x006D,
    0x00AF:'macron', 'macron':0x00AF,
    0x2642:'male', 'male':0x2642,
    0x2212:'minus', 'minus':0x2212,
    0x2032:'minute', 'minute':0x2032,
    0x03BC:'mu', 'mu':0x03BC,
    0x00D7:'multiply', 'multiply':0x00D7,
    0x266A:'musicalnote', 'musicalnote':0x266A,
    0x266B:'musicalnotedbl', 'musicalnotedbl':0x266B,
    0x006E:'n', 'n':0x006E,
    0x0144:'nacute', 'nacute':0x0144,
    0x0149:'napostrophe', 'napostrophe':0x0149,
    0x0148:'ncaron', 'ncaron':0x0148,
    0x0146:'ncommaaccent', 'ncommaaccent':0x0146,
    0x0039:'nine', 'nine':0x0039,
    0x2209:'notelement', 'notelement':0x2209,
    0x2260:'notequal', 'notequal':0x2260,
    0x2284:'notsubset', 'notsubset':0x2284,
    0x00F1:'ntilde', 'ntilde':0x00F1,
    0x03BD:'nu', 'nu':0x03BD,
    0x0023:'numbersign', 'numbersign':0x0023,
    0x006F:'o', 'o':0x006F,
    0x00F3:'oacute', 'oacute':0x00F3,
    0x014F:'obreve', 'obreve':0x014F,
    0x00F4:'ocircumflex', 'ocircumflex':0x00F4,
    0x00F6:'odieresis', 'odieresis':0x00F6,
    0x0153:'oe', 'oe':0x0153,
    0x02DB:'ogonek', 'ogonek':0x02DB,
    0x00F2:'ograve', 'ograve':0x00F2,
    0x01A1:'ohorn', 'ohorn':0x01A1,
    0x0151:'ohungarumlaut', 'ohungarumlaut':0x0151,
    0x014D:'omacron', 'omacron':0x014D,
    0x03C9:'omega', 'omega':0x03C9,
    0x03D6:'omega1', 'omega1':0x03D6,
    0x03CE:'omegatonos', 'omegatonos':0x03CE,
    0x03BF:'omicron', 'omicron':0x03BF,
    0x03CC:'omicrontonos', 'omicrontonos':0x03CC,
    0x0031:'one', 'one':0x0031,
    0x2024:'onedotenleader', 'onedotenleader':0x2024,
    0x215B:'oneeighth', 'oneeighth':0x215B,
    0x00BD:'onehalf', 'onehalf':0x00BD,
    0x00BC:'onequarter', 'onequarter':0x00BC,
    0x2153:'onethird', 'onethird':0x2153,
    0x25E6:'openbullet', 'openbullet':0x25E6,
    0x00AA:'ordfeminine', 'ordfeminine':0x00AA,
    0x00BA:'ordmasculine', 'ordmasculine':0x00BA,
    0x221F:'orthogonal', 'orthogonal':0x221F,
    0x00F8:'oslash', 'oslash':0x00F8,
    0x01FF:'oslashacute', 'oslashacute':0x01FF,
    0x00F5:'otilde', 'otilde':0x00F5,
    0x0070:'p', 'p':0x0070,
    0x00B6:'paragraph', 'paragraph':0x00B6,
    0x0028:'parenleft', 'parenleft':0x0028,
    0x0029:'parenright', 'parenright':0x0029,
    0x2202:'partialdiff', 'partialdiff':0x2202,
    0x0025:'percent', 'percent':0x0025,
    0x002E:'period', 'period':0x002E,
    0x00B7:'periodcentered', 'periodcentered':0x00B7,
    0x22A5:'perpendicular', 'perpendicular':0x22A5,
    0x2030:'perthousand', 'perthousand':0x2030,
    0x20A7:'peseta', 'peseta':0x20A7,
    0x03C6:'phi', 'phi':0x03C6,
    0x03D5:'phi1', 'phi1':0x03D5,
    0x03C0:'pi', 'pi':0x03C0,
    0x002B:'plus', 'plus':0x002B,
    0x00B1:'plusminus', 'plusminus':0x00B1,
    0x211E:'prescription', 'prescription':0x211E,
    0x220F:'product', 'product':0x220F,
    0x2282:'propersubset', 'propersubset':0x2282,
    0x2283:'propersuperset', 'propersuperset':0x2283,
    0x221D:'proportional', 'proportional':0x221D,
    0x03C8:'psi', 'psi':0x03C8,
    0x0071:'q', 'q':0x0071,
    0x003F:'question', 'question':0x003F,
    0x00BF:'questiondown', 'questiondown':0x00BF,
    0x0022:'quotedbl', 'quotedbl':0x0022,
    0x201E:'quotedblbase', 'quotedblbase':0x201E,
    0x201C:'quotedblleft', 'quotedblleft':0x201C,
    0x201D:'quotedblright', 'quotedblright':0x201D,
    0x2018:'quoteleft', 'quoteleft':0x2018,
    0x201B:'quotereversed', 'quotereversed':0x201B,
    0x2019:'quoteright', 'quoteright':0x2019,
    0x201A:'quotesinglbase', 'quotesinglbase':0x201A,
    0x0027:'quotesingle', 'quotesingle':0x0027,
    0x0072:'r', 'r':0x0072,
    0x0155:'racute', 'racute':0x0155,
    0x221A:'radical', 'radical':0x221A,
    0x0159:'rcaron', 'rcaron':0x0159,
    0x0157:'rcommaaccent', 'rcommaaccent':0x0157,
    0x2286:'reflexsubset', 'reflexsubset':0x2286,
    0x2287:'reflexsuperset', 'reflexsuperset':0x2287,
    0x00AE:'registered', 'registered':0x00AE,
    0x2310:'revlogicalnot', 'revlogicalnot':0x2310,
    0x03C1:'rho', 'rho':0x03C1,
    0x02DA:'ring', 'ring':0x02DA,
    0x2590:'rtblock', 'rtblock':0x2590,
    0x0073:'s', 's':0x0073,
    0x015B:'sacute', 'sacute':0x015B,
    0x0161:'scaron', 'scaron':0x0161,
    0x015F:'scedilla', 'scedilla':0x015F,
    0x015D:'scircumflex', 'scircumflex':0x015D,
    0x0219:'scommaaccent', 'scommaaccent':0x0219,
    0x2033:'second', 'second':0x2033,
    0x00A7:'section', 'section':0x00A7,
    0x003B:'semicolon', 'semicolon':0x003B,
    0x0037:'seven', 'seven':0x0037,
    0x215E:'seveneighths', 'seveneighths':0x215E,
    0x2592:'shade', 'shade':0x2592,
    0x03C3:'sigma', 'sigma':0x03C3,
    0x03C2:'sigma1', 'sigma1':0x03C2,
    0x223C:'similar', 'similar':0x223C,
    0x0036:'six', 'six':0x0036,
    0x002F:'slash', 'slash':0x002F,
    0x263A:'smileface', 'smileface':0x263A,
    0x0020:'space', 'space':0x0020,
    0x2660:'spade', 'spade':0x2660,
    0x00A3:'sterling', 'sterling':0x00A3,
    0x220B:'suchthat', 'suchthat':0x220B,
    0x2211:'summation', 'summation':0x2211,
    0x263C:'sun', 'sun':0x263C,
    0x0074:'t', 't':0x0074,
    0x03C4:'tau', 'tau':0x03C4,
    0x0167:'tbar', 'tbar':0x0167,
    0x0165:'tcaron', 'tcaron':0x0165,
    0x0163:'tcommaaccent', 'tcommaaccent':0x0163,
    0x2234:'therefore', 'therefore':0x2234,
    0x03B8:'theta', 'theta':0x03B8,
    0x03D1:'theta1', 'theta1':0x03D1,
    0x00FE:'thorn', 'thorn':0x00FE,
    0x0033:'three', 'three':0x0033,
    0x215C:'threeeighths', 'threeeighths':0x215C,
    0x00BE:'threequarters', 'threequarters':0x00BE,
    0x02DC:'tilde', 'tilde':0x02DC,
    0x0303:'tildecomb', 'tildecomb':0x0303,
    0x0384:'tonos', 'tonos':0x0384,
    0x2122:'trademark', 'trademark':0x2122,
    0x25BC:'triagdn', 'triagdn':0x25BC,
    0x25C4:'triaglf', 'triaglf':0x25C4,
    0x25BA:'triagrt', 'triagrt':0x25BA,
    0x25B2:'triagup', 'triagup':0x25B2,
    0x0032:'two', 'two':0x0032,
    0x2025:'twodotenleader', 'twodotenleader':0x2025,
    0x2154:'twothirds', 'twothirds':0x2154,
    0x0075:'u', 'u':0x0075,
    0x00FA:'uacute', 'uacute':0x00FA,
    0x016D:'ubreve', 'ubreve':0x016D,
    0x00FB:'ucircumflex', 'ucircumflex':0x00FB,
    0x00FC:'udieresis', 'udieresis':0x00FC,
    0x00F9:'ugrave', 'ugrave':0x00F9,
    0x01B0:'uhorn', 'uhorn':0x01B0,
    0x0171:'uhungarumlaut', 'uhungarumlaut':0x0171,
    0x016B:'umacron', 'umacron':0x016B,
    0x005F:'underscore', 'underscore':0x005F,
    0x2017:'underscoredbl', 'underscoredbl':0x2017,
    0x222A:'union', 'union':0x222A,
    0x2200:'universal', 'universal':0x2200,
    0x0173:'uogonek', 'uogonek':0x0173,
    0x2580:'upblock', 'upblock':0x2580,
    0x03C5:'upsilon', 'upsilon':0x03C5,
    0x03CB:'upsilondieresis', 'upsilondieresis':0x03CB,
    0x03B0:'upsilondieresistonos', 'upsilondieresistonos':0x03B0,
    0x03CD:'upsilontonos', 'upsilontonos':0x03CD,
    0x016F:'uring', 'uring':0x016F,
    0x0169:'utilde', 'utilde':0x0169,
    0x0076:'v', 'v':0x0076,
    0x0077:'w', 'w':0x0077,
    0x1E83:'wacute', 'wacute':0x1E83,
    0x0175:'wcircumflex', 'wcircumflex':0x0175,
    0x1E85:'wdieresis', 'wdieresis':0x1E85,
    0x2118:'weierstrass', 'weierstrass':0x2118,
    0x1E81:'wgrave', 'wgrave':0x1E81,
    0x0078:'x', 'x':0x0078,
    0x03BE:'xi', 'xi':0x03BE,
    0x0079:'y', 'y':0x0079,
    0x00FD:'yacute', 'yacute':0x00FD,
    0x0177:'ycircumflex', 'ycircumflex':0x0177,
    0x00FF:'ydieresis', 'ydieresis':0x00FF,
    0x00A5:'yen', 'yen':0x00A5,
    0x1EF3:'ygrave', 'ygrave':0x1EF3,
    0x007A:'z', 'z':0x007A,
    0x017A:'zacute', 'zacute':0x017A,
    0x017E:'zcaron', 'zcaron':0x017E,
    0x017C:'zdotaccent', 'zdotaccent':0x017C,
    0x0030:'zero', 'zero':0x0030,
    0x03B6:'zeta', 'zeta':0x03B6,
}

def name_from_unicode(u):
    if u in aglfn:
        return aglfn[u]
    else:
        return "uni" + "%04X" % u

def unicode_from_name(n):
    if n in aglfn:
        return aglfn[n]
    elif n[:3] == "uni":
        return int(n[3:], 16)
    elif n[0] == "u":
        return int(n[1:], 16)

#--------------------------------------------------------------------------

glyph_components = {
    0x00A8:(0x0020,0x0308,),
    0x00AF:(0x0020,0x0304,),
    0x00B4:(0x0020,0x0301,),
    0x00B5:(0x03BC,),
    0x00B8:(0x0020,0x0327,),
    0x00C0:(0x0041,0x0300,),
    0x00C1:(0x0041,0x0301,),
    0x00C2:(0x0041,0x0302,),
    0x00C3:(0x0041,0x0303,),
    0x00C4:(0x0041,0x0308,),
    0x00C5:(0x0041,0x030A,),
    0x00C7:(0x0043,0x0327,),
    0x00C8:(0x0045,0x0300,),
    0x00C9:(0x0045,0x0301,),
    0x00CA:(0x0045,0x0302,),
    0x00CB:(0x0045,0x0308,),
    0x00CC:(0x0049,0x0300,),
    0x00CD:(0x0049,0x0301,),
    0x00CE:(0x0049,0x0302,),
    0x00CF:(0x0049,0x0308,),
    0x00D1:(0x004E,0x0303,),
    0x00D2:(0x004F,0x0300,),
    0x00D3:(0x004F,0x0301,),
    0x00D4:(0x004F,0x0302,),
    0x00D5:(0x004F,0x0303,),
    0x00D6:(0x004F,0x0308,),
    0x00D9:(0x0055,0x0300,),
    0x00DA:(0x0055,0x0301,),
    0x00DB:(0x0055,0x0302,),
    0x00DC:(0x0055,0x0308,),
    0x00DD:(0x0059,0x0301,),
    0x00E0:(0x0061,0x0300,),
    0x00E1:(0x0061,0x0301,),
    0x00E2:(0x0061,0x0302,),
    0x00E3:(0x0061,0x0303,),
    0x00E4:(0x0061,0x0308,),
    0x00E5:(0x0061,0x030A,),
    0x00E7:(0x0063,0x0327,),
    0x00E8:(0x0065,0x0300,),
    0x00E9:(0x0065,0x0301,),
    0x00EA:(0x0065,0x0302,),
    0x00EB:(0x0065,0x0308,),
    0x00EC:(0x0069,0x0300,),
    0x00ED:(0x0069,0x0301,),
    0x00EE:(0x0069,0x0302,),
    0x00EF:(0x0069,0x0308,),
    0x00F1:(0x006E,0x0303,),
    0x00F2:(0x006F,0x0300,),
    0x00F3:(0x006F,0x0301,),
    0x00F4:(0x006F,0x0302,),
    0x00F5:(0x006F,0x0303,),
    0x00F6:(0x006F,0x0308,),
    0x00F9:(0x0075,0x0300,),
    0x00FA:(0x0075,0x0301,),
    0x00FB:(0x0075,0x0302,),
    0x00FC:(0x0075,0x0308,),
    0x00FD:(0x0079,0x0301,),
    0x00FF:(0x0079,0x0308,),
    0x0100:(0x0041,0x0304,),
    0x0101:(0x0061,0x0304,),
    0x0102:(0x0041,0x0306,),
    0x0103:(0x0061,0x0306,),
    0x0104:(0x0041,0x0328,),
    0x0105:(0x0061,0x0328,),
    0x0106:(0x0043,0x0301,),
    0x0107:(0x0063,0x0301,),
    0x0108:(0x0043,0x0302,),
    0x0109:(0x0063,0x0302,),
    0x010A:(0x0043,0x0307,),
    0x010B:(0x0063,0x0307,),
    0x010C:(0x0043,0x030C,),
    0x010D:(0x0063,0x030C,),
    0x010E:(0x0044,0x030C,),
    0x010F:(0x0064,0x030C,),
    0x0112:(0x0045,0x0304,),
    0x0113:(0x0065,0x0304,),
    0x0114:(0x0045,0x0306,),
    0x0115:(0x0065,0x0306,),
    0x0116:(0x0045,0x0307,),
    0x0117:(0x0065,0x0307,),
    0x0118:(0x0045,0x0328,),
    0x0119:(0x0065,0x0328,),
    0x011A:(0x0045,0x030C,),
    0x011B:(0x0065,0x030C,),
    0x011C:(0x0047,0x0302,),
    0x011D:(0x0067,0x0302,),
    0x011E:(0x0047,0x0306,),
    0x011F:(0x0067,0x0306,),
    0x0120:(0x0047,0x0307,),
    0x0121:(0x0067,0x0307,),
    0x0122:(0x0047,0x0327,),
    0x0123:(0x0067,0x0327,),
    0x0124:(0x0048,0x0302,),
    0x0125:(0x0068,0x0302,),
    0x0128:(0x0049,0x0303,),
    0x0129:(0x0069,0x0303,),
    0x012A:(0x0049,0x0304,),
    0x012B:(0x0069,0x0304,),
    0x012C:(0x0049,0x0306,),
    0x012D:(0x0069,0x0306,),
    0x012E:(0x0049,0x0328,),
    0x012F:(0x0069,0x0328,),
    0x0130:(0x0049,0x0307,),
    0x0132:(0x0049,0x004A,),
    0x0133:(0x0069,0x006A,),
    0x0134:(0x004A,0x0302,),
    0x0135:(0x006A,0x0302,),
    0x0136:(0x004B,0x0327,),
    0x0137:(0x006B,0x0327,),
    0x0139:(0x004C,0x0301,),
    0x013A:(0x006C,0x0301,),
    0x013B:(0x004C,0x0327,),
    0x013C:(0x006C,0x0327,),
    0x013D:(0x004C,0x030C,),
    0x013E:(0x006C,0x030C,),
    0x013F:(0x004C,0x00B7,),
    0x0140:(0x006C,0x00B7,),
    0x0143:(0x004E,0x0301,),
    0x0144:(0x006E,0x0301,),
    0x0145:(0x004E,0x0327,),
    0x0146:(0x006E,0x0327,),
    0x0147:(0x004E,0x030C,),
    0x0148:(0x006E,0x030C,),
    0x0149:(0x02BC,0x006E,),
    0x014C:(0x004F,0x0304,),
    0x014D:(0x006F,0x0304,),
    0x014E:(0x004F,0x0306,),
    0x014F:(0x006F,0x0306,),
    0x0150:(0x004F,0x030B,),
    0x0151:(0x006F,0x030B,),
    0x0154:(0x0052,0x0301,),
    0x0155:(0x0072,0x0301,),
    0x0156:(0x0052,0x0327,),
    0x0157:(0x0072,0x0327,),
    0x0158:(0x0052,0x030C,),
    0x0159:(0x0072,0x030C,),
    0x015A:(0x0053,0x0301,),
    0x015B:(0x0073,0x0301,),
    0x015C:(0x0053,0x0302,),
    0x015D:(0x0073,0x0302,),
    0x015E:(0x0053,0x0327,),
    0x015F:(0x0073,0x0327,),
    0x0160:(0x0053,0x030C,),
    0x0161:(0x0073,0x030C,),
    0x0162:(0x0054,0x0327,),
    0x0163:(0x0074,0x0327,),
    0x0164:(0x0054,0x030C,),
    0x0165:(0x0074,0x030C,),
    0x0168:(0x0055,0x0303,),
    0x0169:(0x0075,0x0303,),
    0x016A:(0x0055,0x0304,),
    0x016B:(0x0075,0x0304,),
    0x016C:(0x0055,0x0306,),
    0x016D:(0x0075,0x0306,),
    0x016E:(0x0055,0x030A,),
    0x016F:(0x0075,0x030A,),
    0x0170:(0x0055,0x030B,),
    0x0171:(0x0075,0x030B,),
    0x0172:(0x0055,0x0328,),
    0x0173:(0x0075,0x0328,),
    0x0174:(0x0057,0x0302,),
    0x0175:(0x0077,0x0302,),
    0x0176:(0x0059,0x0302,),
    0x0177:(0x0079,0x0302,),
    0x0178:(0x0059,0x0308,),
    0x0179:(0x005A,0x0301,),
    0x017A:(0x007A,0x0301,),
    0x017B:(0x005A,0x0307,),
    0x017C:(0x007A,0x0307,),
    0x017D:(0x005A,0x030C,),
    0x017E:(0x007A,0x030C,),
    0x017F:(0x0073,),
    0x01A0:(0x004F,0x031B,),
    0x01A1:(0x006F,0x031B,),
    0x01AF:(0x0055,0x031B,),
    0x01B0:(0x0075,0x031B,),
    0x01C4:(0x0044,0x017D,),
    0x01C5:(0x0044,0x017E,),
    0x01C6:(0x0064,0x017E,),
    0x01C7:(0x004C,0x004A,),
    0x01C8:(0x004C,0x006A,),
    0x01C9:(0x006C,0x006A,),
    0x01CA:(0x004E,0x004A,),
    0x01CB:(0x004E,0x006A,),
    0x01CC:(0x006E,0x006A,),
    0x01CD:(0x0041,0x030C,),
    0x01CE:(0x0061,0x030C,),
    0x01CF:(0x0049,0x030C,),
    0x01D0:(0x0069,0x030C,),
    0x01D1:(0x004F,0x030C,),
    0x01D2:(0x006F,0x030C,),
    0x01D3:(0x0055,0x030C,),
    0x01D4:(0x0075,0x030C,),
    0x01D5:(0x00DC,0x0304,),
    0x01D6:(0x00FC,0x0304,),
    0x01D7:(0x00DC,0x0301,),
    0x01D8:(0x00FC,0x0301,),
    0x01D9:(0x00DC,0x030C,),
    0x01DA:(0x00FC,0x030C,),
    0x01DB:(0x00DC,0x0300,),
    0x01DC:(0x00FC,0x0300,),
    0x01DE:(0x00C4,0x0304,),
    0x01DF:(0x00E4,0x0304,),
    0x01E0:(0x0226,0x0304,),
    0x01E1:(0x0227,0x0304,),
    0x01E2:(0x00C6,0x0304,),
    0x01E3:(0x00E6,0x0304,),
    0x01E6:(0x0047,0x030C,),
    0x01E7:(0x0067,0x030C,),
    0x01E8:(0x004B,0x030C,),
    0x01E9:(0x006B,0x030C,),
    0x01EA:(0x004F,0x0328,),
    0x01EB:(0x006F,0x0328,),
    0x01EC:(0x01EA,0x0304,),
    0x01ED:(0x01EB,0x0304,),
    0x01EE:(0x01B7,0x030C,),
    0x01EF:(0x0292,0x030C,),
    0x01F0:(0x006A,0x030C,),
    0x01F1:(0x0044,0x005A,),
    0x01F2:(0x0044,0x007A,),
    0x01F3:(0x0064,0x007A,),
    0x01F4:(0x0047,0x0301,),
    0x01F5:(0x0067,0x0301,),
    0x01F8:(0x004E,0x0300,),
    0x01F9:(0x006E,0x0300,),
    0x01FA:(0x00C5,0x0301,),
    0x01FB:(0x00E5,0x0301,),
    0x01FC:(0x00C6,0x0301,),
    0x01FD:(0x00E6,0x0301,),
    0x01FE:(0x00D8,0x0301,),
    0x01FF:(0x00F8,0x0301,),
    0x0200:(0x0041,0x030F,),
    0x0201:(0x0061,0x030F,),
    0x0202:(0x0041,0x0311,),
    0x0203:(0x0061,0x0311,),
    0x0204:(0x0045,0x030F,),
    0x0205:(0x0065,0x030F,),
    0x0206:(0x0045,0x0311,),
    0x0207:(0x0065,0x0311,),
    0x0208:(0x0049,0x030F,),
    0x0209:(0x0069,0x030F,),
    0x020A:(0x0049,0x0311,),
    0x020B:(0x0069,0x0311,),
    0x020C:(0x004F,0x030F,),
    0x020D:(0x006F,0x030F,),
    0x020E:(0x004F,0x0311,),
    0x020F:(0x006F,0x0311,),
    0x0210:(0x0052,0x030F,),
    0x0211:(0x0072,0x030F,),
    0x0212:(0x0052,0x0311,),
    0x0213:(0x0072,0x0311,),
    0x0214:(0x0055,0x030F,),
    0x0215:(0x0075,0x030F,),
    0x0216:(0x0055,0x0311,),
    0x0217:(0x0075,0x0311,),
    0x0218:(0x0053,0x0326,),
    0x0219:(0x0073,0x0326,),
    0x021A:(0x0054,0x0326,),
    0x021B:(0x0074,0x0326,),
    0x021E:(0x0048,0x030C,),
    0x021F:(0x0068,0x030C,),
    0x0226:(0x0041,0x0307,),
    0x0227:(0x0061,0x0307,),
    0x0228:(0x0045,0x0327,),
    0x0229:(0x0065,0x0327,),
    0x022A:(0x00D6,0x0304,),
    0x022B:(0x00F6,0x0304,),
    0x022C:(0x00D5,0x0304,),
    0x022D:(0x00F5,0x0304,),
    0x022E:(0x004F,0x0307,),
    0x022F:(0x006F,0x0307,),
    0x0230:(0x022E,0x0304,),
    0x0231:(0x022F,0x0304,),
    0x0232:(0x0059,0x0304,),
    0x0233:(0x0079,0x0304,),
    0x02D8:(0x0020,0x0306,),
    0x02D9:(0x0020,0x0307,),
    0x02DA:(0x0020,0x030A,),
    0x02DB:(0x0020,0x0328,),
    0x02DC:(0x0020,0x0303,),
    0x02DD:(0x0020,0x030B,),
    0x0340:(0x0300,),
    0x0341:(0x0301,),
    0x0343:(0x0313,),
    0x0344:(0x0308,0x0301,),
    0x0374:(0x02B9,),
    0x037A:(0x0020,0x0345,),
    0x037E:(0x003B,),
    0x0384:(0x0020,0x0301,),
    0x0385:(0x00A8,0x0301,),
    0x0386:(0x0391,0x0301,),
    0x0387:(0x00B7,),
    0x0388:(0x0395,0x0301,),
    0x0389:(0x0397,0x0301,),
    0x038A:(0x0399,0x0301,),
    0x038C:(0x039F,0x0301,),
    0x038E:(0x03A5,0x0301,),
    0x038F:(0x03A9,0x0301,),
    0x0390:(0x03CA,0x0301,),
    0x03AA:(0x0399,0x0308,),
    0x03AB:(0x03A5,0x0308,),
    0x03AC:(0x03B1,0x0301,),
    0x03AD:(0x03B5,0x0301,),
    0x03AE:(0x03B7,0x0301,),
    0x03AF:(0x03B9,0x0301,),
    0x03B0:(0x03CB,0x0301,),
    0x03CA:(0x03B9,0x0308,),
    0x03CB:(0x03C5,0x0308,),
    0x03CC:(0x03BF,0x0301,),
    0x03CD:(0x03C5,0x0301,),
    0x03CE:(0x03C9,0x0301,),
    0x03D0:(0x03B2,),
    0x03D1:(0x03B8,),
    0x03D2:(0x03A5,),
    0x03D3:(0x03D2,0x0301,),
    0x03D4:(0x03D2,0x0308,),
    0x03D5:(0x03C6,),
    0x03D6:(0x03C0,),
    0x03F0:(0x03BA,),
    0x03F1:(0x03C1,),
    0x03F2:(0x03C2,),
    0x03F4:(0x0398,),
    0x03F5:(0x03B5,),
    0x03F9:(0x03A3,),
    0x0400:(0x0415,0x0300,),
    0x0401:(0x0415,0x0308,),
    0x0403:(0x0413,0x0301,),
    0x0407:(0x0406,0x0308,),
    0x040C:(0x041A,0x0301,),
    0x040D:(0x0418,0x0300,),
    0x040E:(0x0423,0x0306,),
    0x0419:(0x0418,0x0306,),
    0x0439:(0x0438,0x0306,),
    0x0450:(0x0435,0x0300,),
    0x0451:(0x0435,0x0308,),
    0x0453:(0x0433,0x0301,),
    0x0457:(0x0456,0x0308,),
    0x045C:(0x043A,0x0301,),
    0x045D:(0x0438,0x0300,),
    0x045E:(0x0443,0x0306,),
    0x0476:(0x0474,0x030F,),
    0x0477:(0x0475,0x030F,),
    0x04C1:(0x0416,0x0306,),
    0x04C2:(0x0436,0x0306,),
    0x04D0:(0x0410,0x0306,),
    0x04D1:(0x0430,0x0306,),
    0x04D2:(0x0410,0x0308,),
    0x04D3:(0x0430,0x0308,),
    0x04D6:(0x0415,0x0306,),
    0x04D7:(0x0435,0x0306,),
    0x04DA:(0x04D8,0x0308,),
    0x04DB:(0x04D9,0x0308,),
    0x04DC:(0x0416,0x0308,),
    0x04DD:(0x0436,0x0308,),
    0x04DE:(0x0417,0x0308,),
    0x04DF:(0x0437,0x0308,),
    0x04E2:(0x0418,0x0304,),
    0x04E3:(0x0438,0x0304,),
    0x04E4:(0x0418,0x0308,),
    0x04E5:(0x0438,0x0308,),
    0x04E6:(0x041E,0x0308,),
    0x04E7:(0x043E,0x0308,),
    0x04EA:(0x04E8,0x0308,),
    0x04EB:(0x04E9,0x0308,),
    0x04EC:(0x042D,0x0308,),
    0x04ED:(0x044D,0x0308,),
    0x04EE:(0x0423,0x0304,),
    0x04EF:(0x0443,0x0304,),
    0x04F0:(0x0423,0x0308,),
    0x04F1:(0x0443,0x0308,),
    0x04F2:(0x0423,0x030B,),
    0x04F3:(0x0443,0x030B,),
    0x04F4:(0x0427,0x0308,),
    0x04F5:(0x0447,0x0308,),
    0x04F8:(0x042B,0x0308,),
    0x04F9:(0x044B,0x0308,),
    0x0587:(0x0565,0x0582,),
    0x0622:(0x0627,0x0653,),
    0x0623:(0x0627,0x0654,),
    0x0624:(0x0648,0x0654,),
    0x0625:(0x0627,0x0655,),
    0x0626:(0x064A,0x0654,),
    0x0675:(0x0627,0x0674,),
    0x0676:(0x0648,0x0674,),
    0x0677:(0x06C7,0x0674,),
    0x0678:(0x064A,0x0674,),
    0x06C0:(0x06D5,0x0654,),
    0x06C2:(0x06C1,0x0654,),
    0x06D3:(0x06D2,0x0654,),
    0x0929:(0x0928,0x093C,),
    0x0931:(0x0930,0x093C,),
    0x0934:(0x0933,0x093C,),
    0x0958:(0x0915,0x093C,),
    0x0959:(0x0916,0x093C,),
    0x095A:(0x0917,0x093C,),
    0x095B:(0x091C,0x093C,),
    0x095C:(0x0921,0x093C,),
    0x095D:(0x0922,0x093C,),
    0x095E:(0x092B,0x093C,),
    0x095F:(0x092F,0x093C,),
    0x09CB:(0x09C7,0x09BE,),
    0x09CC:(0x09C7,0x09D7,),
    0x09DC:(0x09A1,0x09BC,),
    0x09DD:(0x09A2,0x09BC,),
    0x09DF:(0x09AF,0x09BC,),
    0x0A33:(0x0A32,0x0A3C,),
    0x0A36:(0x0A38,0x0A3C,),
    0x0A59:(0x0A16,0x0A3C,),
    0x0A5A:(0x0A17,0x0A3C,),
    0x0A5B:(0x0A1C,0x0A3C,),
    0x0A5E:(0x0A2B,0x0A3C,),
    0x0B48:(0x0B47,0x0B56,),
    0x0B4B:(0x0B47,0x0B3E,),
    0x0B4C:(0x0B47,0x0B57,),
    0x0B5C:(0x0B21,0x0B3C,),
    0x0B5D:(0x0B22,0x0B3C,),
    0x0B94:(0x0B92,0x0BD7,),
    0x0BCA:(0x0BC6,0x0BBE,),
    0x0BCB:(0x0BC7,0x0BBE,),
    0x0BCC:(0x0BC6,0x0BD7,),
    0x0C48:(0x0C46,0x0C56,),
    0x0CC0:(0x0CBF,0x0CD5,),
    0x0CC7:(0x0CC6,0x0CD5,),
    0x0CC8:(0x0CC6,0x0CD6,),
    0x0CCA:(0x0CC6,0x0CC2,),
    0x0CCB:(0x0CCA,0x0CD5,),
    0x0D4A:(0x0D46,0x0D3E,),
    0x0D4B:(0x0D47,0x0D3E,),
    0x0D4C:(0x0D46,0x0D57,),
    0x0DDA:(0x0DD9,0x0DCA,),
    0x0DDC:(0x0DD9,0x0DCF,),
    0x0DDD:(0x0DDC,0x0DCA,),
    0x0DDE:(0x0DD9,0x0DDF,),
    0x0E33:(0x0E4D,0x0E32,),
    0x0EB3:(0x0ECD,0x0EB2,),
    0x0EDC:(0x0EAB,0x0E99,),
    0x0EDD:(0x0EAB,0x0EA1,),
    0x0F43:(0x0F42,0x0FB7,),
    0x0F4D:(0x0F4C,0x0FB7,),
    0x0F52:(0x0F51,0x0FB7,),
    0x0F57:(0x0F56,0x0FB7,),
    0x0F5C:(0x0F5B,0x0FB7,),
    0x0F69:(0x0F40,0x0FB5,),
    0x0F73:(0x0F71,0x0F72,),
    0x0F75:(0x0F71,0x0F74,),
    0x0F76:(0x0FB2,0x0F80,),
    0x0F77:(0x0FB2,0x0F81,),
    0x0F78:(0x0FB3,0x0F80,),
    0x0F79:(0x0FB3,0x0F81,),
    0x0F81:(0x0F71,0x0F80,),
    0x0F93:(0x0F92,0x0FB7,),
    0x0F9D:(0x0F9C,0x0FB7,),
    0x0FA2:(0x0FA1,0x0FB7,),
    0x0FA7:(0x0FA6,0x0FB7,),
    0x0FAC:(0x0FAB,0x0FB7,),
    0x0FB9:(0x0F90,0x0FB5,),
    0x1026:(0x1025,0x102E,),
    0x1B06:(0x1B05,0x1B35,),
    0x1B08:(0x1B07,0x1B35,),
    0x1B0A:(0x1B09,0x1B35,),
    0x1B0C:(0x1B0B,0x1B35,),
    0x1B0E:(0x1B0D,0x1B35,),
    0x1B12:(0x1B11,0x1B35,),
    0x1B3B:(0x1B3A,0x1B35,),
    0x1B3D:(0x1B3C,0x1B35,),
    0x1B40:(0x1B3E,0x1B35,),
    0x1B41:(0x1B3F,0x1B35,),
    0x1B43:(0x1B42,0x1B35,),
    0x1E00:(0x0041,0x0325,),
    0x1E01:(0x0061,0x0325,),
    0x1E02:(0x0042,0x0307,),
    0x1E03:(0x0062,0x0307,),
    0x1E04:(0x0042,0x0323,),
    0x1E05:(0x0062,0x0323,),
    0x1E06:(0x0042,0x0331,),
    0x1E07:(0x0062,0x0331,),
    0x1E08:(0x00C7,0x0301,),
    0x1E09:(0x00E7,0x0301,),
    0x1E0A:(0x0044,0x0307,),
    0x1E0B:(0x0064,0x0307,),
    0x1E0C:(0x0044,0x0323,),
    0x1E0D:(0x0064,0x0323,),
    0x1E0E:(0x0044,0x0331,),
    0x1E0F:(0x0064,0x0331,),
    0x1E10:(0x0044,0x0327,),
    0x1E11:(0x0064,0x0327,),
    0x1E12:(0x0044,0x032D,),
    0x1E13:(0x0064,0x032D,),
    0x1E14:(0x0112,0x0300,),
    0x1E15:(0x0113,0x0300,),
    0x1E16:(0x0112,0x0301,),
    0x1E17:(0x0113,0x0301,),
    0x1E18:(0x0045,0x032D,),
    0x1E19:(0x0065,0x032D,),
    0x1E1A:(0x0045,0x0330,),
    0x1E1B:(0x0065,0x0330,),
    0x1E1C:(0x0228,0x0306,),
    0x1E1D:(0x0229,0x0306,),
    0x1E1E:(0x0046,0x0307,),
    0x1E1F:(0x0066,0x0307,),
    0x1E20:(0x0047,0x0304,),
    0x1E21:(0x0067,0x0304,),
    0x1E22:(0x0048,0x0307,),
    0x1E23:(0x0068,0x0307,),
    0x1E24:(0x0048,0x0323,),
    0x1E25:(0x0068,0x0323,),
    0x1E26:(0x0048,0x0308,),
    0x1E27:(0x0068,0x0308,),
    0x1E28:(0x0048,0x0327,),
    0x1E29:(0x0068,0x0327,),
    0x1E2A:(0x0048,0x032E,),
    0x1E2B:(0x0068,0x032E,),
    0x1E2C:(0x0049,0x0330,),
    0x1E2D:(0x0069,0x0330,),
    0x1E2E:(0x00CF,0x0301,),
    0x1E2F:(0x00EF,0x0301,),
    0x1E30:(0x004B,0x0301,),
    0x1E31:(0x006B,0x0301,),
    0x1E32:(0x004B,0x0323,),
    0x1E33:(0x006B,0x0323,),
    0x1E34:(0x004B,0x0331,),
    0x1E35:(0x006B,0x0331,),
    0x1E36:(0x004C,0x0323,),
    0x1E37:(0x006C,0x0323,),
    0x1E38:(0x1E36,0x0304,),
    0x1E39:(0x1E37,0x0304,),
    0x1E3A:(0x004C,0x0331,),
    0x1E3B:(0x006C,0x0331,),
    0x1E3C:(0x004C,0x032D,),
    0x1E3D:(0x006C,0x032D,),
    0x1E3E:(0x004D,0x0301,),
    0x1E3F:(0x006D,0x0301,),
    0x1E40:(0x004D,0x0307,),
    0x1E41:(0x006D,0x0307,),
    0x1E42:(0x004D,0x0323,),
    0x1E43:(0x006D,0x0323,),
    0x1E44:(0x004E,0x0307,),
    0x1E45:(0x006E,0x0307,),
    0x1E46:(0x004E,0x0323,),
    0x1E47:(0x006E,0x0323,),
    0x1E48:(0x004E,0x0331,),
    0x1E49:(0x006E,0x0331,),
    0x1E4A:(0x004E,0x032D,),
    0x1E4B:(0x006E,0x032D,),
    0x1E4C:(0x00D5,0x0301,),
    0x1E4D:(0x00F5,0x0301,),
    0x1E4E:(0x00D5,0x0308,),
    0x1E4F:(0x00F5,0x0308,),
    0x1E50:(0x014C,0x0300,),
    0x1E51:(0x014D,0x0300,),
    0x1E52:(0x014C,0x0301,),
    0x1E53:(0x014D,0x0301,),
    0x1E54:(0x0050,0x0301,),
    0x1E55:(0x0070,0x0301,),
    0x1E56:(0x0050,0x0307,),
    0x1E57:(0x0070,0x0307,),
    0x1E58:(0x0052,0x0307,),
    0x1E59:(0x0072,0x0307,),
    0x1E5A:(0x0052,0x0323,),
    0x1E5B:(0x0072,0x0323,),
    0x1E5C:(0x1E5A,0x0304,),
    0x1E5D:(0x1E5B,0x0304,),
    0x1E5E:(0x0052,0x0331,),
    0x1E5F:(0x0072,0x0331,),
    0x1E60:(0x0053,0x0307,),
    0x1E61:(0x0073,0x0307,),
    0x1E62:(0x0053,0x0323,),
    0x1E63:(0x0073,0x0323,),
    0x1E64:(0x015A,0x0307,),
    0x1E65:(0x015B,0x0307,),
    0x1E66:(0x0160,0x0307,),
    0x1E67:(0x0161,0x0307,),
    0x1E68:(0x1E62,0x0307,),
    0x1E69:(0x1E63,0x0307,),
    0x1E6A:(0x0054,0x0307,),
    0x1E6B:(0x0074,0x0307,),
    0x1E6C:(0x0054,0x0323,),
    0x1E6D:(0x0074,0x0323,),
    0x1E6E:(0x0054,0x0331,),
    0x1E6F:(0x0074,0x0331,),
    0x1E70:(0x0054,0x032D,),
    0x1E71:(0x0074,0x032D,),
    0x1E72:(0x0055,0x0324,),
    0x1E73:(0x0075,0x0324,),
    0x1E74:(0x0055,0x0330,),
    0x1E75:(0x0075,0x0330,),
    0x1E76:(0x0055,0x032D,),
    0x1E77:(0x0075,0x032D,),
    0x1E78:(0x0168,0x0301,),
    0x1E79:(0x0169,0x0301,),
    0x1E7A:(0x016A,0x0308,),
    0x1E7B:(0x016B,0x0308,),
    0x1E7C:(0x0056,0x0303,),
    0x1E7D:(0x0076,0x0303,),
    0x1E7E:(0x0056,0x0323,),
    0x1E7F:(0x0076,0x0323,),
    0x1E80:(0x0057,0x0300,),
    0x1E81:(0x0077,0x0300,),
    0x1E82:(0x0057,0x0301,),
    0x1E83:(0x0077,0x0301,),
    0x1E84:(0x0057,0x0308,),
    0x1E85:(0x0077,0x0308,),
    0x1E86:(0x0057,0x0307,),
    0x1E87:(0x0077,0x0307,),
    0x1E88:(0x0057,0x0323,),
    0x1E89:(0x0077,0x0323,),
    0x1E8A:(0x0058,0x0307,),
    0x1E8B:(0x0078,0x0307,),
    0x1E8C:(0x0058,0x0308,),
    0x1E8D:(0x0078,0x0308,),
    0x1E8E:(0x0059,0x0307,),
    0x1E8F:(0x0079,0x0307,),
    0x1E90:(0x005A,0x0302,),
    0x1E91:(0x007A,0x0302,),
    0x1E92:(0x005A,0x0323,),
    0x1E93:(0x007A,0x0323,),
    0x1E94:(0x005A,0x0331,),
    0x1E95:(0x007A,0x0331,),
    0x1E96:(0x0068,0x0331,),
    0x1E97:(0x0074,0x0308,),
    0x1E98:(0x0077,0x030A,),
    0x1E99:(0x0079,0x030A,),
    0x1E9A:(0x0061,0x02BE,),
    0x1E9B:(0x017F,0x0307,),
    0x1EA0:(0x0041,0x0323,),
    0x1EA1:(0x0061,0x0323,),
    0x1EA2:(0x0041,0x0309,),
    0x1EA3:(0x0061,0x0309,),
    0x1EA4:(0x00C2,0x0301,),
    0x1EA5:(0x00E2,0x0301,),
    0x1EA6:(0x00C2,0x0300,),
    0x1EA7:(0x00E2,0x0300,),
    0x1EA8:(0x00C2,0x0309,),
    0x1EA9:(0x00E2,0x0309,),
    0x1EAA:(0x00C2,0x0303,),
    0x1EAB:(0x00E2,0x0303,),
    0x1EAC:(0x1EA0,0x0302,),
    0x1EAD:(0x1EA1,0x0302,),
    0x1EAE:(0x0102,0x0301,),
    0x1EAF:(0x0103,0x0301,),
    0x1EB0:(0x0102,0x0300,),
    0x1EB1:(0x0103,0x0300,),
    0x1EB2:(0x0102,0x0309,),
    0x1EB3:(0x0103,0x0309,),
    0x1EB4:(0x0102,0x0303,),
    0x1EB5:(0x0103,0x0303,),
    0x1EB6:(0x1EA0,0x0306,),
    0x1EB7:(0x1EA1,0x0306,),
    0x1EB8:(0x0045,0x0323,),
    0x1EB9:(0x0065,0x0323,),
    0x1EBA:(0x0045,0x0309,),
    0x1EBB:(0x0065,0x0309,),
    0x1EBC:(0x0045,0x0303,),
    0x1EBD:(0x0065,0x0303,),
    0x1EBE:(0x00CA,0x0301,),
    0x1EBF:(0x00EA,0x0301,),
    0x1EC0:(0x00CA,0x0300,),
    0x1EC1:(0x00EA,0x0300,),
    0x1EC2:(0x00CA,0x0309,),
    0x1EC3:(0x00EA,0x0309,),
    0x1EC4:(0x00CA,0x0303,),
    0x1EC5:(0x00EA,0x0303,),
    0x1EC6:(0x1EB8,0x0302,),
    0x1EC7:(0x1EB9,0x0302,),
    0x1EC8:(0x0049,0x0309,),
    0x1EC9:(0x0069,0x0309,),
    0x1ECA:(0x0049,0x0323,),
    0x1ECB:(0x0069,0x0323,),
    0x1ECC:(0x004F,0x0323,),
    0x1ECD:(0x006F,0x0323,),
    0x1ECE:(0x004F,0x0309,),
    0x1ECF:(0x006F,0x0309,),
    0x1ED0:(0x00D4,0x0301,),
    0x1ED1:(0x00F4,0x0301,),
    0x1ED2:(0x00D4,0x0300,),
    0x1ED3:(0x00F4,0x0300,),
    0x1ED4:(0x00D4,0x0309,),
    0x1ED5:(0x00F4,0x0309,),
    0x1ED6:(0x00D4,0x0303,),
    0x1ED7:(0x00F4,0x0303,),
    0x1ED8:(0x1ECC,0x0302,),
    0x1ED9:(0x1ECD,0x0302,),
    0x1EDA:(0x01A0,0x0301,),
    0x1EDB:(0x01A1,0x0301,),
    0x1EDC:(0x01A0,0x0300,),
    0x1EDD:(0x01A1,0x0300,),
    0x1EDE:(0x01A0,0x0309,),
    0x1EDF:(0x01A1,0x0309,),
    0x1EE0:(0x01A0,0x0303,),
    0x1EE1:(0x01A1,0x0303,),
    0x1EE2:(0x01A0,0x0323,),
    0x1EE3:(0x01A1,0x0323,),
    0x1EE4:(0x0055,0x0323,),
    0x1EE5:(0x0075,0x0323,),
    0x1EE6:(0x0055,0x0309,),
    0x1EE7:(0x0075,0x0309,),
    0x1EE8:(0x01AF,0x0301,),
    0x1EE9:(0x01B0,0x0301,),
    0x1EEA:(0x01AF,0x0300,),
    0x1EEB:(0x01B0,0x0300,),
    0x1EEC:(0x01AF,0x0309,),
    0x1EED:(0x01B0,0x0309,),
    0x1EEE:(0x01AF,0x0303,),
    0x1EEF:(0x01B0,0x0303,),
    0x1EF0:(0x01AF,0x0323,),
    0x1EF1:(0x01B0,0x0323,),
    0x1EF2:(0x0059,0x0300,),
    0x1EF3:(0x0079,0x0300,),
    0x1EF4:(0x0059,0x0323,),
    0x1EF5:(0x0079,0x0323,),
    0x1EF6:(0x0059,0x0309,),
    0x1EF7:(0x0079,0x0309,),
    0x1EF8:(0x0059,0x0303,),
    0x1EF9:(0x0079,0x0303,),
    0x1F00:(0x03B1,0x0313,),
    0x1F01:(0x03B1,0x0314,),
    0x1F02:(0x1F00,0x0300,),
    0x1F03:(0x1F01,0x0300,),
    0x1F04:(0x1F00,0x0301,),
    0x1F05:(0x1F01,0x0301,),
    0x1F06:(0x1F00,0x0342,),
    0x1F07:(0x1F01,0x0342,),
    0x1F08:(0x0391,0x0313,),
    0x1F09:(0x0391,0x0314,),
    0x1F0A:(0x1F08,0x0300,),
    0x1F0B:(0x1F09,0x0300,),
    0x1F0C:(0x1F08,0x0301,),
    0x1F0D:(0x1F09,0x0301,),
    0x1F0E:(0x1F08,0x0342,),
    0x1F0F:(0x1F09,0x0342,),
    0x1F10:(0x03B5,0x0313,),
    0x1F11:(0x03B5,0x0314,),
    0x1F12:(0x1F10,0x0300,),
    0x1F13:(0x1F11,0x0300,),
    0x1F14:(0x1F10,0x0301,),
    0x1F15:(0x1F11,0x0301,),
    0x1F18:(0x0395,0x0313,),
    0x1F19:(0x0395,0x0314,),
    0x1F1A:(0x1F18,0x0300,),
    0x1F1B:(0x1F19,0x0300,),
    0x1F1C:(0x1F18,0x0301,),
    0x1F1D:(0x1F19,0x0301,),
    0x1F20:(0x03B7,0x0313,),
    0x1F21:(0x03B7,0x0314,),
    0x1F22:(0x1F20,0x0300,),
    0x1F23:(0x1F21,0x0300,),
    0x1F24:(0x1F20,0x0301,),
    0x1F25:(0x1F21,0x0301,),
    0x1F26:(0x1F20,0x0342,),
    0x1F27:(0x1F21,0x0342,),
    0x1F28:(0x0397,0x0313,),
    0x1F29:(0x0397,0x0314,),
    0x1F2A:(0x1F28,0x0300,),
    0x1F2B:(0x1F29,0x0300,),
    0x1F2C:(0x1F28,0x0301,),
    0x1F2D:(0x1F29,0x0301,),
    0x1F2E:(0x1F28,0x0342,),
    0x1F2F:(0x1F29,0x0342,),
    0x1F30:(0x03B9,0x0313,),
    0x1F31:(0x03B9,0x0314,),
    0x1F32:(0x1F30,0x0300,),
    0x1F33:(0x1F31,0x0300,),
    0x1F34:(0x1F30,0x0301,),
    0x1F35:(0x1F31,0x0301,),
    0x1F36:(0x1F30,0x0342,),
    0x1F37:(0x1F31,0x0342,),
    0x1F38:(0x0399,0x0313,),
    0x1F39:(0x0399,0x0314,),
    0x1F3A:(0x1F38,0x0300,),
    0x1F3B:(0x1F39,0x0300,),
    0x1F3C:(0x1F38,0x0301,),
    0x1F3D:(0x1F39,0x0301,),
    0x1F3E:(0x1F38,0x0342,),
    0x1F3F:(0x1F39,0x0342,),
    0x1F40:(0x03BF,0x0313,),
    0x1F41:(0x03BF,0x0314,),
    0x1F42:(0x1F40,0x0300,),
    0x1F43:(0x1F41,0x0300,),
    0x1F44:(0x1F40,0x0301,),
    0x1F45:(0x1F41,0x0301,),
    0x1F48:(0x039F,0x0313,),
    0x1F49:(0x039F,0x0314,),
    0x1F4A:(0x1F48,0x0300,),
    0x1F4B:(0x1F49,0x0300,),
    0x1F4C:(0x1F48,0x0301,),
    0x1F4D:(0x1F49,0x0301,),
    0x1F50:(0x03C5,0x0313,),
    0x1F51:(0x03C5,0x0314,),
    0x1F52:(0x1F50,0x0300,),
    0x1F53:(0x1F51,0x0300,),
    0x1F54:(0x1F50,0x0301,),
    0x1F55:(0x1F51,0x0301,),
    0x1F56:(0x1F50,0x0342,),
    0x1F57:(0x1F51,0x0342,),
    0x1F59:(0x03A5,0x0314,),
    0x1F5B:(0x1F59,0x0300,),
    0x1F5D:(0x1F59,0x0301,),
    0x1F5F:(0x1F59,0x0342,),
    0x1F60:(0x03C9,0x0313,),
    0x1F61:(0x03C9,0x0314,),
    0x1F62:(0x1F60,0x0300,),
    0x1F63:(0x1F61,0x0300,),
    0x1F64:(0x1F60,0x0301,),
    0x1F65:(0x1F61,0x0301,),
    0x1F66:(0x1F60,0x0342,),
    0x1F67:(0x1F61,0x0342,),
    0x1F68:(0x03A9,0x0313,),
    0x1F69:(0x03A9,0x0314,),
    0x1F6A:(0x1F68,0x0300,),
    0x1F6B:(0x1F69,0x0300,),
    0x1F6C:(0x1F68,0x0301,),
    0x1F6D:(0x1F69,0x0301,),
    0x1F6E:(0x1F68,0x0342,),
    0x1F6F:(0x1F69,0x0342,),
    0x1F70:(0x03B1,0x0300,),
    0x1F71:(0x03AC,),
    0x1F72:(0x03B5,0x0300,),
    0x1F73:(0x03AD,),
    0x1F74:(0x03B7,0x0300,),
    0x1F75:(0x03AE,),
    0x1F76:(0x03B9,0x0300,),
    0x1F77:(0x03AF,),
    0x1F78:(0x03BF,0x0300,),
    0x1F79:(0x03CC,),
    0x1F7A:(0x03C5,0x0300,),
    0x1F7B:(0x03CD,),
    0x1F7C:(0x03C9,0x0300,),
    0x1F7D:(0x03CE,),
    0x1F80:(0x1F00,0x0345,),
    0x1F81:(0x1F01,0x0345,),
    0x1F82:(0x1F02,0x0345,),
    0x1F83:(0x1F03,0x0345,),
    0x1F84:(0x1F04,0x0345,),
    0x1F85:(0x1F05,0x0345,),
    0x1F86:(0x1F06,0x0345,),
    0x1F87:(0x1F07,0x0345,),
    0x1F88:(0x1F08,0x0345,),
    0x1F89:(0x1F09,0x0345,),
    0x1F8A:(0x1F0A,0x0345,),
    0x1F8B:(0x1F0B,0x0345,),
    0x1F8C:(0x1F0C,0x0345,),
    0x1F8D:(0x1F0D,0x0345,),
    0x1F8E:(0x1F0E,0x0345,),
    0x1F8F:(0x1F0F,0x0345,),
    0x1F90:(0x1F20,0x0345,),
    0x1F91:(0x1F21,0x0345,),
    0x1F92:(0x1F22,0x0345,),
    0x1F93:(0x1F23,0x0345,),
    0x1F94:(0x1F24,0x0345,),
    0x1F95:(0x1F25,0x0345,),
    0x1F96:(0x1F26,0x0345,),
    0x1F97:(0x1F27,0x0345,),
    0x1F98:(0x1F28,0x0345,),
    0x1F99:(0x1F29,0x0345,),
    0x1F9A:(0x1F2A,0x0345,),
    0x1F9B:(0x1F2B,0x0345,),
    0x1F9C:(0x1F2C,0x0345,),
    0x1F9D:(0x1F2D,0x0345,),
    0x1F9E:(0x1F2E,0x0345,),
    0x1F9F:(0x1F2F,0x0345,),
    0x1FA0:(0x1F60,0x0345,),
    0x1FA1:(0x1F61,0x0345,),
    0x1FA2:(0x1F62,0x0345,),
    0x1FA3:(0x1F63,0x0345,),
    0x1FA4:(0x1F64,0x0345,),
    0x1FA5:(0x1F65,0x0345,),
    0x1FA6:(0x1F66,0x0345,),
    0x1FA7:(0x1F67,0x0345,),
    0x1FA8:(0x1F68,0x0345,),
    0x1FA9:(0x1F69,0x0345,),
    0x1FAA:(0x1F6A,0x0345,),
    0x1FAB:(0x1F6B,0x0345,),
    0x1FAC:(0x1F6C,0x0345,),
    0x1FAD:(0x1F6D,0x0345,),
    0x1FAE:(0x1F6E,0x0345,),
    0x1FAF:(0x1F6F,0x0345,),
    0x1FB0:(0x03B1,0x0306,),
    0x1FB1:(0x03B1,0x0304,),
    0x1FB2:(0x1F70,0x0345,),
    0x1FB3:(0x03B1,0x0345,),
    0x1FB4:(0x03AC,0x0345,),
    0x1FB6:(0x03B1,0x0342,),
    0x1FB7:(0x1FB6,0x0345,),
    0x1FB8:(0x0391,0x0306,),
    0x1FB9:(0x0391,0x0304,),
    0x1FBA:(0x0391,0x0300,),
    0x1FBB:(0x0386,),
    0x1FBC:(0x0391,0x0345,),
    0x1FBD:(0x0020,0x0313,),
    0x1FBE:(0x03B9,),
    0x1FBF:(0x0020,0x0313,),
    0x1FC0:(0x0020,0x0342,),
    0x1FC1:(0x00A8,0x0342,),
    0x1FC2:(0x1F74,0x0345,),
    0x1FC3:(0x03B7,0x0345,),
    0x1FC4:(0x03AE,0x0345,),
    0x1FC6:(0x03B7,0x0342,),
    0x1FC7:(0x1FC6,0x0345,),
    0x1FC8:(0x0395,0x0300,),
    0x1FC9:(0x0388,),
    0x1FCA:(0x0397,0x0300,),
    0x1FCB:(0x0389,),
    0x1FCC:(0x0397,0x0345,),
    0x1FCD:(0x1FBF,0x0300,),
    0x1FCE:(0x1FBF,0x0301,),
    0x1FCF:(0x1FBF,0x0342,),
    0x1FD0:(0x03B9,0x0306,),
    0x1FD1:(0x03B9,0x0304,),
    0x1FD2:(0x03CA,0x0300,),
    0x1FD3:(0x0390,),
    0x1FD6:(0x03B9,0x0342,),
    0x1FD7:(0x03CA,0x0342,),
    0x1FD8:(0x0399,0x0306,),
    0x1FD9:(0x0399,0x0304,),
    0x1FDA:(0x0399,0x0300,),
    0x1FDB:(0x038A,),
    0x1FDD:(0x1FFE,0x0300,),
    0x1FDE:(0x1FFE,0x0301,),
    0x1FDF:(0x1FFE,0x0342,),
    0x1FE0:(0x03C5,0x0306,),
    0x1FE1:(0x03C5,0x0304,),
    0x1FE2:(0x03CB,0x0300,),
    0x1FE3:(0x03B0,),
    0x1FE4:(0x03C1,0x0313,),
    0x1FE5:(0x03C1,0x0314,),
    0x1FE6:(0x03C5,0x0342,),
    0x1FE7:(0x03CB,0x0342,),
    0x1FE8:(0x03A5,0x0306,),
    0x1FE9:(0x03A5,0x0304,),
    0x1FEA:(0x03A5,0x0300,),
    0x1FEB:(0x038E,),
    0x1FEC:(0x03A1,0x0314,),
    0x1FED:(0x00A8,0x0300,),
    0x1FEE:(0x0385,),
    0x1FEF:(0x0060,),
    0x1FF2:(0x1F7C,0x0345,),
    0x1FF3:(0x03C9,0x0345,),
    0x1FF4:(0x03CE,0x0345,),
    0x1FF6:(0x03C9,0x0342,),
    0x1FF7:(0x1FF6,0x0345,),
    0x1FF8:(0x039F,0x0300,),
    0x1FF9:(0x038C,),
    0x1FFA:(0x03A9,0x0300,),
    0x1FFB:(0x038F,),
    0x1FFC:(0x03A9,0x0345,),
    0x1FFD:(0x00B4,),
    0x1FFE:(0x0020,0x0314,),
    0x2000:(0x2002,),
    0x2001:(0x2003,),
    0x2002:(0x0020,),
    0x2003:(0x0020,),
    0x2004:(0x0020,),
    0x2005:(0x0020,),
    0x2006:(0x0020,),
    0x2008:(0x0020,),
    0x2009:(0x0020,),
    0x200A:(0x0020,),
    0x2017:(0x0020,0x0333,),
    0x2024:(0x002E,),
    0x2025:(0x002E,0x002E,),
    0x2026:(0x002E,0x002E,0x002E,),
    0x2033:(0x2032,0x2032,),
    0x2034:(0x2032,0x2032,0x2032,),
    0x2036:(0x2035,0x2035,),
    0x2037:(0x2035,0x2035,0x2035,),
    0x203C:(0x0021,0x0021,),
    0x203E:(0x0020,0x0305,),
    0x2047:(0x003F,0x003F,),
    0x2048:(0x003F,0x0021,),
    0x2049:(0x0021,0x003F,),
    0x2057:(0x2032,0x2032,0x2032,0x2032,),
    0x205F:(0x0020,),
    0x20A8:(0x0052,0x0073,),
    0x2100:(0x0061,0x002F,0x0063,),
    0x2101:(0x0061,0x002F,0x0073,),
    0x2103:(0x00B0,0x0043,),
    0x2105:(0x0063,0x002F,0x006F,),
    0x2106:(0x0063,0x002F,0x0075,),
    0x2107:(0x0190,),
    0x2109:(0x00B0,0x0046,),
    0x2116:(0x004E,0x006F,),
    0x2121:(0x0054,0x0045,0x004C,),
    0x2126:(0x03A9,),
    0x212A:(0x004B,),
    0x212B:(0x00C5,),
    0x2135:(0x05D0,),
    0x2136:(0x05D1,),
    0x2137:(0x05D2,),
    0x2138:(0x05D3,),
    0x213B:(0x0046,0x0041,0x0058,),
    0x2160:(0x0049,),
    0x2161:(0x0049,0x0049,),
    0x2162:(0x0049,0x0049,0x0049,),
    0x2163:(0x0049,0x0056,),
    0x2164:(0x0056,),
    0x2165:(0x0056,0x0049,),
    0x2166:(0x0056,0x0049,0x0049,),
    0x2167:(0x0056,0x0049,0x0049,0x0049,),
    0x2168:(0x0049,0x0058,),
    0x2169:(0x0058,),
    0x216A:(0x0058,0x0049,),
    0x216B:(0x0058,0x0049,0x0049,),
    0x216C:(0x004C,),
    0x216D:(0x0043,),
    0x216E:(0x0044,),
    0x216F:(0x004D,),
    0x2170:(0x0069,),
    0x2171:(0x0069,0x0069,),
    0x2172:(0x0069,0x0069,0x0069,),
    0x2173:(0x0069,0x0076,),
    0x2174:(0x0076,),
    0x2175:(0x0076,0x0069,),
    0x2176:(0x0076,0x0069,0x0069,),
    0x2177:(0x0076,0x0069,0x0069,0x0069,),
    0x2178:(0x0069,0x0078,),
    0x2179:(0x0078,),
    0x217A:(0x0078,0x0069,),
    0x217B:(0x0078,0x0069,0x0069,),
    0x217C:(0x006C,),
    0x217D:(0x0063,),
    0x217E:(0x0064,),
    0x217F:(0x006D,),
    0x219A:(0x2190,0x0338,),
    0x219B:(0x2192,0x0338,),
    0x21AE:(0x2194,0x0338,),
    0x21CD:(0x21D0,0x0338,),
    0x21CE:(0x21D4,0x0338,),
    0x21CF:(0x21D2,0x0338,),
    0x2204:(0x2203,0x0338,),
    0x2209:(0x2208,0x0338,),
    0x220C:(0x220B,0x0338,),
    0x2224:(0x2223,0x0338,),
    0x2226:(0x2225,0x0338,),
    0x222C:(0x222B,0x222B,),
    0x222D:(0x222B,0x222B,0x222B,),
    0x222F:(0x222E,0x222E,),
    0x2230:(0x222E,0x222E,0x222E,),
    0x2241:(0x223C,0x0338,),
    0x2244:(0x2243,0x0338,),
    0x2247:(0x2245,0x0338,),
    0x2249:(0x2248,0x0338,),
    0x2260:(0x003D,0x0338,),
    0x2262:(0x2261,0x0338,),
    0x226D:(0x224D,0x0338,),
    0x226E:(0x003C,0x0338,),
    0x226F:(0x003E,0x0338,),
    0x2270:(0x2264,0x0338,),
    0x2271:(0x2265,0x0338,),
    0x2274:(0x2272,0x0338,),
    0x2275:(0x2273,0x0338,),
    0x2278:(0x2276,0x0338,),
    0x2279:(0x2277,0x0338,),
    0x2280:(0x227A,0x0338,),
    0x2281:(0x227B,0x0338,),
    0x2284:(0x2282,0x0338,),
    0x2285:(0x2283,0x0338,),
    0x2288:(0x2286,0x0338,),
    0x2289:(0x2287,0x0338,),
    0x22AC:(0x22A2,0x0338,),
    0x22AD:(0x22A8,0x0338,),
    0x22AE:(0x22A9,0x0338,),
    0x22AF:(0x22AB,0x0338,),
    0x22E0:(0x227C,0x0338,),
    0x22E1:(0x227D,0x0338,),
    0x22E2:(0x2291,0x0338,),
    0x22E3:(0x2292,0x0338,),
    0x22EA:(0x22B2,0x0338,),
    0x22EB:(0x22B3,0x0338,),
    0x22EC:(0x22B4,0x0338,),
    0x22ED:(0x22B5,0x0338,),
    0x2329:(0x3008,),
    0x232A:(0x3009,),
    0x2474:(0x0028,0x0031,0x0029,),
    0x2475:(0x0028,0x0032,0x0029,),
    0x2476:(0x0028,0x0033,0x0029,),
    0x2477:(0x0028,0x0034,0x0029,),
    0x2478:(0x0028,0x0035,0x0029,),
    0x2479:(0x0028,0x0036,0x0029,),
    0x247A:(0x0028,0x0037,0x0029,),
    0x247B:(0x0028,0x0038,0x0029,),
    0x247C:(0x0028,0x0039,0x0029,),
    0x247D:(0x0028,0x0031,0x0030,0x0029,),
    0x247E:(0x0028,0x0031,0x0031,0x0029,),
    0x247F:(0x0028,0x0031,0x0032,0x0029,),
    0x2480:(0x0028,0x0031,0x0033,0x0029,),
    0x2481:(0x0028,0x0031,0x0034,0x0029,),
    0x2482:(0x0028,0x0031,0x0035,0x0029,),
    0x2483:(0x0028,0x0031,0x0036,0x0029,),
    0x2484:(0x0028,0x0031,0x0037,0x0029,),
    0x2485:(0x0028,0x0031,0x0038,0x0029,),
    0x2486:(0x0028,0x0031,0x0039,0x0029,),
    0x2487:(0x0028,0x0032,0x0030,0x0029,),
    0x2488:(0x0031,0x002E,),
    0x2489:(0x0032,0x002E,),
    0x248A:(0x0033,0x002E,),
    0x248B:(0x0034,0x002E,),
    0x248C:(0x0035,0x002E,),
    0x248D:(0x0036,0x002E,),
    0x248E:(0x0037,0x002E,),
    0x248F:(0x0038,0x002E,),
    0x2490:(0x0039,0x002E,),
    0x2491:(0x0031,0x0030,0x002E,),
    0x2492:(0x0031,0x0031,0x002E,),
    0x2493:(0x0031,0x0032,0x002E,),
    0x2494:(0x0031,0x0033,0x002E,),
    0x2495:(0x0031,0x0034,0x002E,),
    0x2496:(0x0031,0x0035,0x002E,),
    0x2497:(0x0031,0x0036,0x002E,),
    0x2498:(0x0031,0x0037,0x002E,),
    0x2499:(0x0031,0x0038,0x002E,),
    0x249A:(0x0031,0x0039,0x002E,),
    0x249B:(0x0032,0x0030,0x002E,),
    0x249C:(0x0028,0x0061,0x0029,),
    0x249D:(0x0028,0x0062,0x0029,),
    0x249E:(0x0028,0x0063,0x0029,),
    0x249F:(0x0028,0x0064,0x0029,),
    0x24A0:(0x0028,0x0065,0x0029,),
    0x24A1:(0x0028,0x0066,0x0029,),
    0x24A2:(0x0028,0x0067,0x0029,),
    0x24A3:(0x0028,0x0068,0x0029,),
    0x24A4:(0x0028,0x0069,0x0029,),
    0x24A5:(0x0028,0x006A,0x0029,),
    0x24A6:(0x0028,0x006B,0x0029,),
    0x24A7:(0x0028,0x006C,0x0029,),
    0x24A8:(0x0028,0x006D,0x0029,),
    0x24A9:(0x0028,0x006E,0x0029,),
    0x24AA:(0x0028,0x006F,0x0029,),
    0x24AB:(0x0028,0x0070,0x0029,),
    0x24AC:(0x0028,0x0071,0x0029,),
    0x24AD:(0x0028,0x0072,0x0029,),
    0x24AE:(0x0028,0x0073,0x0029,),
    0x24AF:(0x0028,0x0074,0x0029,),
    0x24B0:(0x0028,0x0075,0x0029,),
    0x24B1:(0x0028,0x0076,0x0029,),
    0x24B2:(0x0028,0x0077,0x0029,),
    0x24B3:(0x0028,0x0078,0x0029,),
    0x24B4:(0x0028,0x0079,0x0029,),
    0x24B5:(0x0028,0x007A,0x0029,),
    0x2A0C:(0x222B,0x222B,0x222B,0x222B,),
    0x2A74:(0x003A,0x003A,0x003D,),
    0x2A75:(0x003D,0x003D,),
    0x2A76:(0x003D,0x003D,0x003D,),
    0x2ADC:(0x2ADD,0x0338,),
    0x2E9F:(0x6BCD,),
    0x2EF3:(0x9F9F,),
    0x2F00:(0x4E00,),
    0x2F01:(0x4E28,),
    0x2F02:(0x4E36,),
    0x2F03:(0x4E3F,),
    0x2F04:(0x4E59,),
    0x2F05:(0x4E85,),
    0x2F06:(0x4E8C,),
    0x2F07:(0x4EA0,),
    0x2F08:(0x4EBA,),
    0x2F09:(0x513F,),
    0x2F0A:(0x5165,),
    0x2F0B:(0x516B,),
    0x2F0C:(0x5182,),
    0x2F0D:(0x5196,),
    0x2F0E:(0x51AB,),
    0x2F0F:(0x51E0,),
    0x2F10:(0x51F5,),
    0x2F11:(0x5200,),
    0x2F12:(0x529B,),
    0x2F13:(0x52F9,),
    0x2F14:(0x5315,),
    0x2F15:(0x531A,),
    0x2F16:(0x5338,),
    0x2F17:(0x5341,),
    0x2F18:(0x535C,),
    0x2F19:(0x5369,),
    0x2F1A:(0x5382,),
    0x2F1B:(0x53B6,),
    0x2F1C:(0x53C8,),
    0x2F1D:(0x53E3,),
    0x2F1E:(0x56D7,),
    0x2F1F:(0x571F,),
    0x2F20:(0x58EB,),
    0x2F21:(0x5902,),
    0x2F22:(0x590A,),
    0x2F23:(0x5915,),
    0x2F24:(0x5927,),
    0x2F25:(0x5973,),
    0x2F26:(0x5B50,),
    0x2F27:(0x5B80,),
    0x2F28:(0x5BF8,),
    0x2F29:(0x5C0F,),
    0x2F2A:(0x5C22,),
    0x2F2B:(0x5C38,),
    0x2F2C:(0x5C6E,),
    0x2F2D:(0x5C71,),
    0x2F2E:(0x5DDB,),
    0x2F2F:(0x5DE5,),
    0x2F30:(0x5DF1,),
    0x2F31:(0x5DFE,),
    0x2F32:(0x5E72,),
    0x2F33:(0x5E7A,),
    0x2F34:(0x5E7F,),
    0x2F35:(0x5EF4,),
    0x2F36:(0x5EFE,),
    0x2F37:(0x5F0B,),
    0x2F38:(0x5F13,),
    0x2F39:(0x5F50,),
    0x2F3A:(0x5F61,),
    0x2F3B:(0x5F73,),
    0x2F3C:(0x5FC3,),
    0x2F3D:(0x6208,),
    0x2F3E:(0x6236,),
    0x2F3F:(0x624B,),
    0x2F40:(0x652F,),
    0x2F41:(0x6534,),
    0x2F42:(0x6587,),
    0x2F43:(0x6597,),
    0x2F44:(0x65A4,),
    0x2F45:(0x65B9,),
    0x2F46:(0x65E0,),
    0x2F47:(0x65E5,),
    0x2F48:(0x66F0,),
    0x2F49:(0x6708,),
    0x2F4A:(0x6728,),
    0x2F4B:(0x6B20,),
    0x2F4C:(0x6B62,),
    0x2F4D:(0x6B79,),
    0x2F4E:(0x6BB3,),
    0x2F4F:(0x6BCB,),
    0x2F50:(0x6BD4,),
    0x2F51:(0x6BDB,),
    0x2F52:(0x6C0F,),
    0x2F53:(0x6C14,),
    0x2F54:(0x6C34,),
    0x2F55:(0x706B,),
    0x2F56:(0x722A,),
    0x2F57:(0x7236,),
    0x2F58:(0x723B,),
    0x2F59:(0x723F,),
    0x2F5A:(0x7247,),
    0x2F5B:(0x7259,),
    0x2F5C:(0x725B,),
    0x2F5D:(0x72AC,),
    0x2F5E:(0x7384,),
    0x2F5F:(0x7389,),
    0x2F60:(0x74DC,),
    0x2F61:(0x74E6,),
    0x2F62:(0x7518,),
    0x2F63:(0x751F,),
    0x2F64:(0x7528,),
    0x2F65:(0x7530,),
    0x2F66:(0x758B,),
    0x2F67:(0x7592,),
    0x2F68:(0x7676,),
    0x2F69:(0x767D,),
    0x2F6A:(0x76AE,),
    0x2F6B:(0x76BF,),
    0x2F6C:(0x76EE,),
    0x2F6D:(0x77DB,),
    0x2F6E:(0x77E2,),
    0x2F6F:(0x77F3,),
    0x2F70:(0x793A,),
    0x2F71:(0x79B8,),
    0x2F72:(0x79BE,),
    0x2F73:(0x7A74,),
    0x2F74:(0x7ACB,),
    0x2F75:(0x7AF9,),
    0x2F76:(0x7C73,),
    0x2F77:(0x7CF8,),
    0x2F78:(0x7F36,),
    0x2F79:(0x7F51,),
    0x2F7A:(0x7F8A,),
    0x2F7B:(0x7FBD,),
    0x2F7C:(0x8001,),
    0x2F7D:(0x800C,),
    0x2F7E:(0x8012,),
    0x2F7F:(0x8033,),
    0x2F80:(0x807F,),
    0x2F81:(0x8089,),
    0x2F82:(0x81E3,),
    0x2F83:(0x81EA,),
    0x2F84:(0x81F3,),
    0x2F85:(0x81FC,),
    0x2F86:(0x820C,),
    0x2F87:(0x821B,),
    0x2F88:(0x821F,),
    0x2F89:(0x826E,),
    0x2F8A:(0x8272,),
    0x2F8B:(0x8278,),
    0x2F8C:(0x864D,),
    0x2F8D:(0x866B,),
    0x2F8E:(0x8840,),
    0x2F8F:(0x884C,),
    0x2F90:(0x8863,),
    0x2F91:(0x897E,),
    0x2F92:(0x898B,),
    0x2F93:(0x89D2,),
    0x2F94:(0x8A00,),
    0x2F95:(0x8C37,),
    0x2F96:(0x8C46,),
    0x2F97:(0x8C55,),
    0x2F98:(0x8C78,),
    0x2F99:(0x8C9D,),
    0x2F9A:(0x8D64,),
    0x2F9B:(0x8D70,),
    0x2F9C:(0x8DB3,),
    0x2F9D:(0x8EAB,),
    0x2F9E:(0x8ECA,),
    0x2F9F:(0x8F9B,),
    0x2FA0:(0x8FB0,),
    0x2FA1:(0x8FB5,),
    0x2FA2:(0x9091,),
    0x2FA3:(0x9149,),
    0x2FA4:(0x91C6,),
    0x2FA5:(0x91CC,),
    0x2FA6:(0x91D1,),
    0x2FA7:(0x9577,),
    0x2FA8:(0x9580,),
    0x2FA9:(0x961C,),
    0x2FAA:(0x96B6,),
    0x2FAB:(0x96B9,),
    0x2FAC:(0x96E8,),
    0x2FAD:(0x9751,),
    0x2FAE:(0x975E,),
    0x2FAF:(0x9762,),
    0x2FB0:(0x9769,),
    0x2FB1:(0x97CB,),
    0x2FB2:(0x97ED,),
    0x2FB3:(0x97F3,),
    0x2FB4:(0x9801,),
    0x2FB5:(0x98A8,),
    0x2FB6:(0x98DB,),
    0x2FB7:(0x98DF,),
    0x2FB8:(0x9996,),
    0x2FB9:(0x9999,),
    0x2FBA:(0x99AC,),
    0x2FBB:(0x9AA8,),
    0x2FBC:(0x9AD8,),
    0x2FBD:(0x9ADF,),
    0x2FBE:(0x9B25,),
    0x2FBF:(0x9B2F,),
    0x2FC0:(0x9B32,),
    0x2FC1:(0x9B3C,),
    0x2FC2:(0x9B5A,),
    0x2FC3:(0x9CE5,),
    0x2FC4:(0x9E75,),
    0x2FC5:(0x9E7F,),
    0x2FC6:(0x9EA5,),
    0x2FC7:(0x9EBB,),
    0x2FC8:(0x9EC3,),
    0x2FC9:(0x9ECD,),
    0x2FCA:(0x9ED1,),
    0x2FCB:(0x9EF9,),
    0x2FCC:(0x9EFD,),
    0x2FCD:(0x9F0E,),
    0x2FCE:(0x9F13,),
    0x2FCF:(0x9F20,),
    0x2FD0:(0x9F3B,),
    0x2FD1:(0x9F4A,),
    0x2FD2:(0x9F52,),
    0x2FD3:(0x9F8D,),
    0x2FD4:(0x9F9C,),
    0x2FD5:(0x9FA0,),
    0x3036:(0x3012,),
    0x3038:(0x5341,),
    0x3039:(0x5344,),
    0x303A:(0x5345,),
    0x304C:(0x304B,0x3099,),
    0x304E:(0x304D,0x3099,),
    0x3050:(0x304F,0x3099,),
    0x3052:(0x3051,0x3099,),
    0x3054:(0x3053,0x3099,),
    0x3056:(0x3055,0x3099,),
    0x3058:(0x3057,0x3099,),
    0x305A:(0x3059,0x3099,),
    0x305C:(0x305B,0x3099,),
    0x305E:(0x305D,0x3099,),
    0x3060:(0x305F,0x3099,),
    0x3062:(0x3061,0x3099,),
    0x3065:(0x3064,0x3099,),
    0x3067:(0x3066,0x3099,),
    0x3069:(0x3068,0x3099,),
    0x3070:(0x306F,0x3099,),
    0x3071:(0x306F,0x309A,),
    0x3073:(0x3072,0x3099,),
    0x3074:(0x3072,0x309A,),
    0x3076:(0x3075,0x3099,),
    0x3077:(0x3075,0x309A,),
    0x3079:(0x3078,0x3099,),
    0x307A:(0x3078,0x309A,),
    0x307C:(0x307B,0x3099,),
    0x307D:(0x307B,0x309A,),
    0x3094:(0x3046,0x3099,),
    0x309B:(0x0020,0x3099,),
    0x309C:(0x0020,0x309A,),
    0x309E:(0x309D,0x3099,),
    0x30AC:(0x30AB,0x3099,),
    0x30AE:(0x30AD,0x3099,),
    0x30B0:(0x30AF,0x3099,),
    0x30B2:(0x30B1,0x3099,),
    0x30B4:(0x30B3,0x3099,),
    0x30B6:(0x30B5,0x3099,),
    0x30B8:(0x30B7,0x3099,),
    0x30BA:(0x30B9,0x3099,),
    0x30BC:(0x30BB,0x3099,),
    0x30BE:(0x30BD,0x3099,),
    0x30C0:(0x30BF,0x3099,),
    0x30C2:(0x30C1,0x3099,),
    0x30C5:(0x30C4,0x3099,),
    0x30C7:(0x30C6,0x3099,),
    0x30C9:(0x30C8,0x3099,),
    0x30D0:(0x30CF,0x3099,),
    0x30D1:(0x30CF,0x309A,),
    0x30D3:(0x30D2,0x3099,),
    0x30D4:(0x30D2,0x309A,),
    0x30D6:(0x30D5,0x3099,),
    0x30D7:(0x30D5,0x309A,),
    0x30D9:(0x30D8,0x3099,),
    0x30DA:(0x30D8,0x309A,),
    0x30DC:(0x30DB,0x3099,),
    0x30DD:(0x30DB,0x309A,),
    0x30F4:(0x30A6,0x3099,),
    0x30F7:(0x30EF,0x3099,),
    0x30F8:(0x30F0,0x3099,),
    0x30F9:(0x30F1,0x3099,),
    0x30FA:(0x30F2,0x3099,),
    0x30FE:(0x30FD,0x3099,),
    0x3131:(0x1100,),
    0x3132:(0x1101,),
    0x3133:(0x11AA,),
    0x3134:(0x1102,),
    0x3135:(0x11AC,),
    0x3136:(0x11AD,),
    0x3137:(0x1103,),
    0x3138:(0x1104,),
    0x3139:(0x1105,),
    0x313A:(0x11B0,),
    0x313B:(0x11B1,),
    0x313C:(0x11B2,),
    0x313D:(0x11B3,),
    0x313E:(0x11B4,),
    0x313F:(0x11B5,),
    0x3140:(0x111A,),
    0x3141:(0x1106,),
    0x3142:(0x1107,),
    0x3143:(0x1108,),
    0x3144:(0x1121,),
    0x3145:(0x1109,),
    0x3146:(0x110A,),
    0x3147:(0x110B,),
    0x3148:(0x110C,),
    0x3149:(0x110D,),
    0x314A:(0x110E,),
    0x314B:(0x110F,),
    0x314C:(0x1110,),
    0x314D:(0x1111,),
    0x314E:(0x1112,),
    0x314F:(0x1161,),
    0x3150:(0x1162,),
    0x3151:(0x1163,),
    0x3152:(0x1164,),
    0x3153:(0x1165,),
    0x3154:(0x1166,),
    0x3155:(0x1167,),
    0x3156:(0x1168,),
    0x3157:(0x1169,),
    0x3158:(0x116A,),
    0x3159:(0x116B,),
    0x315A:(0x116C,),
    0x315B:(0x116D,),
    0x315C:(0x116E,),
    0x315D:(0x116F,),
    0x315E:(0x1170,),
    0x315F:(0x1171,),
    0x3160:(0x1172,),
    0x3161:(0x1173,),
    0x3162:(0x1174,),
    0x3163:(0x1175,),
    0x3164:(0x1160,),
    0x3165:(0x1114,),
    0x3166:(0x1115,),
    0x3167:(0x11C7,),
    0x3168:(0x11C8,),
    0x3169:(0x11CC,),
    0x316A:(0x11CE,),
    0x316B:(0x11D3,),
    0x316C:(0x11D7,),
    0x316D:(0x11D9,),
    0x316E:(0x111C,),
    0x316F:(0x11DD,),
    0x3170:(0x11DF,),
    0x3171:(0x111D,),
    0x3172:(0x111E,),
    0x3173:(0x1120,),
    0x3174:(0x1122,),
    0x3175:(0x1123,),
    0x3176:(0x1127,),
    0x3177:(0x1129,),
    0x3178:(0x112B,),
    0x3179:(0x112C,),
    0x317A:(0x112D,),
    0x317B:(0x112E,),
    0x317C:(0x112F,),
    0x317D:(0x1132,),
    0x317E:(0x1136,),
    0x317F:(0x1140,),
    0x3180:(0x1147,),
    0x3181:(0x114C,),
    0x3182:(0x11F1,),
    0x3183:(0x11F2,),
    0x3184:(0x1157,),
    0x3185:(0x1158,),
    0x3186:(0x1159,),
    0x3187:(0x1184,),
    0x3188:(0x1185,),
    0x3189:(0x1188,),
    0x318A:(0x1191,),
    0x318B:(0x1192,),
    0x318C:(0x1194,),
    0x318D:(0x119E,),
    0x318E:(0x11A1,),
    0x3200:(0x0028,0x1100,0x0029,),
    0x3201:(0x0028,0x1102,0x0029,),
    0x3202:(0x0028,0x1103,0x0029,),
    0x3203:(0x0028,0x1105,0x0029,),
    0x3204:(0x0028,0x1106,0x0029,),
    0x3205:(0x0028,0x1107,0x0029,),
    0x3206:(0x0028,0x1109,0x0029,),
    0x3207:(0x0028,0x110B,0x0029,),
    0x3208:(0x0028,0x110C,0x0029,),
    0x3209:(0x0028,0x110E,0x0029,),
    0x320A:(0x0028,0x110F,0x0029,),
    0x320B:(0x0028,0x1110,0x0029,),
    0x320C:(0x0028,0x1111,0x0029,),
    0x320D:(0x0028,0x1112,0x0029,),
    0x320E:(0x0028,0x1100,0x1161,0x0029,),
    0x320F:(0x0028,0x1102,0x1161,0x0029,),
    0x3210:(0x0028,0x1103,0x1161,0x0029,),
    0x3211:(0x0028,0x1105,0x1161,0x0029,),
    0x3212:(0x0028,0x1106,0x1161,0x0029,),
    0x3213:(0x0028,0x1107,0x1161,0x0029,),
    0x3214:(0x0028,0x1109,0x1161,0x0029,),
    0x3215:(0x0028,0x110B,0x1161,0x0029,),
    0x3216:(0x0028,0x110C,0x1161,0x0029,),
    0x3217:(0x0028,0x110E,0x1161,0x0029,),
    0x3218:(0x0028,0x110F,0x1161,0x0029,),
    0x3219:(0x0028,0x1110,0x1161,0x0029,),
    0x321A:(0x0028,0x1111,0x1161,0x0029,),
    0x321B:(0x0028,0x1112,0x1161,0x0029,),
    0x321C:(0x0028,0x110C,0x116E,0x0029,),
    0x321D:(0x0028,0x110B,0x1169,0x110C,0x1165,0x11AB,0x0029,),
    0x321E:(0x0028,0x110B,0x1169,0x1112,0x116E,0x0029,),
    0x3220:(0x0028,0x4E00,0x0029,),
    0x3221:(0x0028,0x4E8C,0x0029,),
    0x3222:(0x0028,0x4E09,0x0029,),
    0x3223:(0x0028,0x56DB,0x0029,),
    0x3224:(0x0028,0x4E94,0x0029,),
    0x3225:(0x0028,0x516D,0x0029,),
    0x3226:(0x0028,0x4E03,0x0029,),
    0x3227:(0x0028,0x516B,0x0029,),
    0x3228:(0x0028,0x4E5D,0x0029,),
    0x3229:(0x0028,0x5341,0x0029,),
    0x322A:(0x0028,0x6708,0x0029,),
    0x322B:(0x0028,0x706B,0x0029,),
    0x322C:(0x0028,0x6C34,0x0029,),
    0x322D:(0x0028,0x6728,0x0029,),
    0x322E:(0x0028,0x91D1,0x0029,),
    0x322F:(0x0028,0x571F,0x0029,),
    0x3230:(0x0028,0x65E5,0x0029,),
    0x3231:(0x0028,0x682A,0x0029,),
    0x3232:(0x0028,0x6709,0x0029,),
    0x3233:(0x0028,0x793E,0x0029,),
    0x3234:(0x0028,0x540D,0x0029,),
    0x3235:(0x0028,0x7279,0x0029,),
    0x3236:(0x0028,0x8CA1,0x0029,),
    0x3237:(0x0028,0x795D,0x0029,),
    0x3238:(0x0028,0x52B4,0x0029,),
    0x3239:(0x0028,0x4EE3,0x0029,),
    0x323A:(0x0028,0x547C,0x0029,),
    0x323B:(0x0028,0x5B66,0x0029,),
    0x323C:(0x0028,0x76E3,0x0029,),
    0x323D:(0x0028,0x4F01,0x0029,),
    0x323E:(0x0028,0x8CC7,0x0029,),
    0x323F:(0x0028,0x5354,0x0029,),
    0x3240:(0x0028,0x796D,0x0029,),
    0x3241:(0x0028,0x4F11,0x0029,),
    0x3242:(0x0028,0x81EA,0x0029,),
    0x3243:(0x0028,0x81F3,0x0029,),
    0x32C0:(0x0031,0x6708,),
    0x32C1:(0x0032,0x6708,),
    0x32C2:(0x0033,0x6708,),
    0x32C3:(0x0034,0x6708,),
    0x32C4:(0x0035,0x6708,),
    0x32C5:(0x0036,0x6708,),
    0x32C6:(0x0037,0x6708,),
    0x32C7:(0x0038,0x6708,),
    0x32C8:(0x0039,0x6708,),
    0x32C9:(0x0031,0x0030,0x6708,),
    0x32CA:(0x0031,0x0031,0x6708,),
    0x32CB:(0x0031,0x0032,0x6708,),
    0x3358:(0x0030,0x70B9,),
    0x3359:(0x0031,0x70B9,),
    0x335A:(0x0032,0x70B9,),
    0x335B:(0x0033,0x70B9,),
    0x335C:(0x0034,0x70B9,),
    0x335D:(0x0035,0x70B9,),
    0x335E:(0x0036,0x70B9,),
    0x335F:(0x0037,0x70B9,),
    0x3360:(0x0038,0x70B9,),
    0x3361:(0x0039,0x70B9,),
    0x3362:(0x0031,0x0030,0x70B9,),
    0x3363:(0x0031,0x0031,0x70B9,),
    0x3364:(0x0031,0x0032,0x70B9,),
    0x3365:(0x0031,0x0033,0x70B9,),
    0x3366:(0x0031,0x0034,0x70B9,),
    0x3367:(0x0031,0x0035,0x70B9,),
    0x3368:(0x0031,0x0036,0x70B9,),
    0x3369:(0x0031,0x0037,0x70B9,),
    0x336A:(0x0031,0x0038,0x70B9,),
    0x336B:(0x0031,0x0039,0x70B9,),
    0x336C:(0x0032,0x0030,0x70B9,),
    0x336D:(0x0032,0x0031,0x70B9,),
    0x336E:(0x0032,0x0032,0x70B9,),
    0x336F:(0x0032,0x0033,0x70B9,),
    0x3370:(0x0032,0x0034,0x70B9,),
    0x33E0:(0x0031,0x65E5,),
    0x33E1:(0x0032,0x65E5,),
    0x33E2:(0x0033,0x65E5,),
    0x33E3:(0x0034,0x65E5,),
    0x33E4:(0x0035,0x65E5,),
    0x33E5:(0x0036,0x65E5,),
    0x33E6:(0x0037,0x65E5,),
    0x33E7:(0x0038,0x65E5,),
    0x33E8:(0x0039,0x65E5,),
    0x33E9:(0x0031,0x0030,0x65E5,),
    0x33EA:(0x0031,0x0031,0x65E5,),
    0x33EB:(0x0031,0x0032,0x65E5,),
    0x33EC:(0x0031,0x0033,0x65E5,),
    0x33ED:(0x0031,0x0034,0x65E5,),
    0x33EE:(0x0031,0x0035,0x65E5,),
    0x33EF:(0x0031,0x0036,0x65E5,),
    0x33F0:(0x0031,0x0037,0x65E5,),
    0x33F1:(0x0031,0x0038,0x65E5,),
    0x33F2:(0x0031,0x0039,0x65E5,),
    0x33F3:(0x0032,0x0030,0x65E5,),
    0x33F4:(0x0032,0x0031,0x65E5,),
    0x33F5:(0x0032,0x0032,0x65E5,),
    0x33F6:(0x0032,0x0033,0x65E5,),
    0x33F7:(0x0032,0x0034,0x65E5,),
    0x33F8:(0x0032,0x0035,0x65E5,),
    0x33F9:(0x0032,0x0036,0x65E5,),
    0x33FA:(0x0032,0x0037,0x65E5,),
    0x33FB:(0x0032,0x0038,0x65E5,),
    0x33FC:(0x0032,0x0039,0x65E5,),
    0x33FD:(0x0033,0x0030,0x65E5,),
    0x33FE:(0x0033,0x0031,0x65E5,),
    0xF900:(0x8C48,),
    0xF901:(0x66F4,),
    0xF902:(0x8ECA,),
    0xF903:(0x8CC8,),
    0xF904:(0x6ED1,),
    0xF905:(0x4E32,),
    0xF906:(0x53E5,),
    0xF907:(0x9F9C,),
    0xF908:(0x9F9C,),
    0xF909:(0x5951,),
    0xF90A:(0x91D1,),
    0xF90B:(0x5587,),
    0xF90C:(0x5948,),
    0xF90D:(0x61F6,),
    0xF90E:(0x7669,),
    0xF90F:(0x7F85,),
    0xF910:(0x863F,),
    0xF911:(0x87BA,),
    0xF912:(0x88F8,),
    0xF913:(0x908F,),
    0xF914:(0x6A02,),
    0xF915:(0x6D1B,),
    0xF916:(0x70D9,),
    0xF917:(0x73DE,),
    0xF918:(0x843D,),
    0xF919:(0x916A,),
    0xF91A:(0x99F1,),
    0xF91B:(0x4E82,),
    0xF91C:(0x5375,),
    0xF91D:(0x6B04,),
    0xF91E:(0x721B,),
    0xF91F:(0x862D,),
    0xF920:(0x9E1E,),
    0xF921:(0x5D50,),
    0xF922:(0x6FEB,),
    0xF923:(0x85CD,),
    0xF924:(0x8964,),
    0xF925:(0x62C9,),
    0xF926:(0x81D8,),
    0xF927:(0x881F,),
    0xF928:(0x5ECA,),
    0xF929:(0x6717,),
    0xF92A:(0x6D6A,),
    0xF92B:(0x72FC,),
    0xF92C:(0x90CE,),
    0xF92D:(0x4F86,),
    0xF92E:(0x51B7,),
    0xF92F:(0x52DE,),
    0xF930:(0x64C4,),
    0xF931:(0x6AD3,),
    0xF932:(0x7210,),
    0xF933:(0x76E7,),
    0xF934:(0x8001,),
    0xF935:(0x8606,),
    0xF936:(0x865C,),
    0xF937:(0x8DEF,),
    0xF938:(0x9732,),
    0xF939:(0x9B6F,),
    0xF93A:(0x9DFA,),
    0xF93B:(0x788C,),
    0xF93C:(0x797F,),
    0xF93D:(0x7DA0,),
    0xF93E:(0x83C9,),
    0xF93F:(0x9304,),
    0xF940:(0x9E7F,),
    0xF941:(0x8AD6,),
    0xF942:(0x58DF,),
    0xF943:(0x5F04,),
    0xF944:(0x7C60,),
    0xF945:(0x807E,),
    0xF946:(0x7262,),
    0xF947:(0x78CA,),
    0xF948:(0x8CC2,),
    0xF949:(0x96F7,),
    0xF94A:(0x58D8,),
    0xF94B:(0x5C62,),
    0xF94C:(0x6A13,),
    0xF94D:(0x6DDA,),
    0xF94E:(0x6F0F,),
    0xF94F:(0x7D2F,),
    0xF950:(0x7E37,),
    0xF951:(0x964B,),
    0xF952:(0x52D2,),
    0xF953:(0x808B,),
    0xF954:(0x51DC,),
    0xF955:(0x51CC,),
    0xF956:(0x7A1C,),
    0xF957:(0x7DBE,),
    0xF958:(0x83F1,),
    0xF959:(0x9675,),
    0xF95A:(0x8B80,),
    0xF95B:(0x62CF,),
    0xF95C:(0x6A02,),
    0xF95D:(0x8AFE,),
    0xF95E:(0x4E39,),
    0xF95F:(0x5BE7,),
    0xF960:(0x6012,),
    0xF961:(0x7387,),
    0xF962:(0x7570,),
    0xF963:(0x5317,),
    0xF964:(0x78FB,),
    0xF965:(0x4FBF,),
    0xF966:(0x5FA9,),
    0xF967:(0x4E0D,),
    0xF968:(0x6CCC,),
    0xF969:(0x6578,),
    0xF96A:(0x7D22,),
    0xF96B:(0x53C3,),
    0xF96C:(0x585E,),
    0xF96D:(0x7701,),
    0xF96E:(0x8449,),
    0xF96F:(0x8AAA,),
    0xF970:(0x6BBA,),
    0xF971:(0x8FB0,),
    0xF972:(0x6C88,),
    0xF973:(0x62FE,),
    0xF974:(0x82E5,),
    0xF975:(0x63A0,),
    0xF976:(0x7565,),
    0xF977:(0x4EAE,),
    0xF978:(0x5169,),
    0xF979:(0x51C9,),
    0xF97A:(0x6881,),
    0xF97B:(0x7CE7,),
    0xF97C:(0x826F,),
    0xF97D:(0x8AD2,),
    0xF97E:(0x91CF,),
    0xF97F:(0x52F5,),
    0xF980:(0x5442,),
    0xF981:(0x5973,),
    0xF982:(0x5EEC,),
    0xF983:(0x65C5,),
    0xF984:(0x6FFE,),
    0xF985:(0x792A,),
    0xF986:(0x95AD,),
    0xF987:(0x9A6A,),
    0xF988:(0x9E97,),
    0xF989:(0x9ECE,),
    0xF98A:(0x529B,),
    0xF98B:(0x66C6,),
    0xF98C:(0x6B77,),
    0xF98D:(0x8F62,),
    0xF98E:(0x5E74,),
    0xF98F:(0x6190,),
    0xF990:(0x6200,),
    0xF991:(0x649A,),
    0xF992:(0x6F23,),
    0xF993:(0x7149,),
    0xF994:(0x7489,),
    0xF995:(0x79CA,),
    0xF996:(0x7DF4,),
    0xF997:(0x806F,),
    0xF998:(0x8F26,),
    0xF999:(0x84EE,),
    0xF99A:(0x9023,),
    0xF99B:(0x934A,),
    0xF99C:(0x5217,),
    0xF99D:(0x52A3,),
    0xF99E:(0x54BD,),
    0xF99F:(0x70C8,),
    0xF9A0:(0x88C2,),
    0xF9A1:(0x8AAA,),
    0xF9A2:(0x5EC9,),
    0xF9A3:(0x5FF5,),
    0xF9A4:(0x637B,),
    0xF9A5:(0x6BAE,),
    0xF9A6:(0x7C3E,),
    0xF9A7:(0x7375,),
    0xF9A8:(0x4EE4,),
    0xF9A9:(0x56F9,),
    0xF9AA:(0x5BE7,),
    0xF9AB:(0x5DBA,),
    0xF9AC:(0x601C,),
    0xF9AD:(0x73B2,),
    0xF9AE:(0x7469,),
    0xF9AF:(0x7F9A,),
    0xF9B0:(0x8046,),
    0xF9B1:(0x9234,),
    0xF9B2:(0x96F6,),
    0xF9B3:(0x9748,),
    0xF9B4:(0x9818,),
    0xF9B5:(0x4F8B,),
    0xF9B6:(0x79AE,),
    0xF9B7:(0x91B4,),
    0xF9B8:(0x96B8,),
    0xF9B9:(0x60E1,),
    0xF9BA:(0x4E86,),
    0xF9BB:(0x50DA,),
    0xF9BC:(0x5BEE,),
    0xF9BD:(0x5C3F,),
    0xF9BE:(0x6599,),
    0xF9BF:(0x6A02,),
    0xF9C0:(0x71CE,),
    0xF9C1:(0x7642,),
    0xF9C2:(0x84FC,),
    0xF9C3:(0x907C,),
    0xF9C4:(0x9F8D,),
    0xF9C5:(0x6688,),
    0xF9C6:(0x962E,),
    0xF9C7:(0x5289,),
    0xF9C8:(0x677B,),
    0xF9C9:(0x67F3,),
    0xF9CA:(0x6D41,),
    0xF9CB:(0x6E9C,),
    0xF9CC:(0x7409,),
    0xF9CD:(0x7559,),
    0xF9CE:(0x786B,),
    0xF9CF:(0x7D10,),
    0xF9D0:(0x985E,),
    0xF9D1:(0x516D,),
    0xF9D2:(0x622E,),
    0xF9D3:(0x9678,),
    0xF9D4:(0x502B,),
    0xF9D5:(0x5D19,),
    0xF9D6:(0x6DEA,),
    0xF9D7:(0x8F2A,),
    0xF9D8:(0x5F8B,),
    0xF9D9:(0x6144,),
    0xF9DA:(0x6817,),
    0xF9DB:(0x7387,),
    0xF9DC:(0x9686,),
    0xF9DD:(0x5229,),
    0xF9DE:(0x540F,),
    0xF9DF:(0x5C65,),
    0xF9E0:(0x6613,),
    0xF9E1:(0x674E,),
    0xF9E2:(0x68A8,),
    0xF9E3:(0x6CE5,),
    0xF9E4:(0x7406,),
    0xF9E5:(0x75E2,),
    0xF9E6:(0x7F79,),
    0xF9E7:(0x88CF,),
    0xF9E8:(0x88E1,),
    0xF9E9:(0x91CC,),
    0xF9EA:(0x96E2,),
    0xF9EB:(0x533F,),
    0xF9EC:(0x6EBA,),
    0xF9ED:(0x541D,),
    0xF9EE:(0x71D0,),
    0xF9EF:(0x7498,),
    0xF9F0:(0x85FA,),
    0xF9F1:(0x96A3,),
    0xF9F2:(0x9C57,),
    0xF9F3:(0x9E9F,),
    0xF9F4:(0x6797,),
    0xF9F5:(0x6DCB,),
    0xF9F6:(0x81E8,),
    0xF9F7:(0x7ACB,),
    0xF9F8:(0x7B20,),
    0xF9F9:(0x7C92,),
    0xF9FA:(0x72C0,),
    0xF9FB:(0x7099,),
    0xF9FC:(0x8B58,),
    0xF9FD:(0x4EC0,),
    0xF9FE:(0x8336,),
    0xF9FF:(0x523A,),
    0xFA00:(0x5207,),
    0xFA01:(0x5EA6,),
    0xFA02:(0x62D3,),
    0xFA03:(0x7CD6,),
    0xFA04:(0x5B85,),
    0xFA05:(0x6D1E,),
    0xFA06:(0x66B4,),
    0xFA07:(0x8F3B,),
    0xFA08:(0x884C,),
    0xFA09:(0x964D,),
    0xFA0A:(0x898B,),
    0xFA0B:(0x5ED3,),
    0xFA0C:(0x5140,),
    0xFA0D:(0x55C0,),
    0xFA10:(0x585A,),
    0xFA12:(0x6674,),
    0xFA15:(0x51DE,),
    0xFA16:(0x732A,),
    0xFA17:(0x76CA,),
    0xFA18:(0x793C,),
    0xFA19:(0x795E,),
    0xFA1A:(0x7965,),
    0xFA1B:(0x798F,),
    0xFA1C:(0x9756,),
    0xFA1D:(0x7CBE,),
    0xFA1E:(0x7FBD,),
    0xFA20:(0x8612,),
    0xFA22:(0x8AF8,),
    0xFA25:(0x9038,),
    0xFA26:(0x90FD,),
    0xFA2A:(0x98EF,),
    0xFA2B:(0x98FC,),
    0xFA2C:(0x9928,),
    0xFA2D:(0x9DB4,),
    0xFA30:(0x4FAE,),
    0xFA31:(0x50E7,),
    0xFA32:(0x514D,),
    0xFA33:(0x52C9,),
    0xFA34:(0x52E4,),
    0xFA35:(0x5351,),
    0xFA36:(0x559D,),
    0xFA37:(0x5606,),
    0xFA38:(0x5668,),
    0xFA39:(0x5840,),
    0xFA3A:(0x58A8,),
    0xFA3B:(0x5C64,),
    0xFA3C:(0x5C6E,),
    0xFA3D:(0x6094,),
    0xFA3E:(0x6168,),
    0xFA3F:(0x618E,),
    0xFA40:(0x61F2,),
    0xFA41:(0x654F,),
    0xFA42:(0x65E2,),
    0xFA43:(0x6691,),
    0xFA44:(0x6885,),
    0xFA45:(0x6D77,),
    0xFA46:(0x6E1A,),
    0xFA47:(0x6F22,),
    0xFA48:(0x716E,),
    0xFA49:(0x722B,),
    0xFA4A:(0x7422,),
    0xFA4B:(0x7891,),
    0xFA4C:(0x793E,),
    0xFA4D:(0x7949,),
    0xFA4E:(0x7948,),
    0xFA4F:(0x7950,),
    0xFA50:(0x7956,),
    0xFA51:(0x795D,),
    0xFA52:(0x798D,),
    0xFA53:(0x798E,),
    0xFA54:(0x7A40,),
    0xFA55:(0x7A81,),
    0xFA56:(0x7BC0,),
    0xFA57:(0x7DF4,),
    0xFA58:(0x7E09,),
    0xFA59:(0x7E41,),
    0xFA5A:(0x7F72,),
    0xFA5B:(0x8005,),
    0xFA5C:(0x81ED,),
    0xFA5D:(0x8279,),
    0xFA5E:(0x8279,),
    0xFA5F:(0x8457,),
    0xFA60:(0x8910,),
    0xFA61:(0x8996,),
    0xFA62:(0x8B01,),
    0xFA63:(0x8B39,),
    0xFA64:(0x8CD3,),
    0xFA65:(0x8D08,),
    0xFA66:(0x8FB6,),
    0xFA67:(0x9038,),
    0xFA68:(0x96E3,),
    0xFA69:(0x97FF,),
    0xFA6A:(0x983B,),
    0xFA70:(0x4E26,),
    0xFA71:(0x51B5,),
    0xFA72:(0x5168,),
    0xFA73:(0x4F80,),
    0xFA74:(0x5145,),
    0xFA75:(0x5180,),
    0xFA76:(0x52C7,),
    0xFA77:(0x52FA,),
    0xFA78:(0x559D,),
    0xFA79:(0x5555,),
    0xFA7A:(0x5599,),
    0xFA7B:(0x55E2,),
    0xFA7C:(0x585A,),
    0xFA7D:(0x58B3,),
    0xFA7E:(0x5944,),
    0xFA7F:(0x5954,),
    0xFA80:(0x5A62,),
    0xFA81:(0x5B28,),
    0xFA82:(0x5ED2,),
    0xFA83:(0x5ED9,),
    0xFA84:(0x5F69,),
    0xFA85:(0x5FAD,),
    0xFA86:(0x60D8,),
    0xFA87:(0x614E,),
    0xFA88:(0x6108,),
    0xFA89:(0x618E,),
    0xFA8A:(0x6160,),
    0xFA8B:(0x61F2,),
    0xFA8C:(0x6234,),
    0xFA8D:(0x63C4,),
    0xFA8E:(0x641C,),
    0xFA8F:(0x6452,),
    0xFA90:(0x6556,),
    0xFA91:(0x6674,),
    0xFA92:(0x6717,),
    0xFA93:(0x671B,),
    0xFA94:(0x6756,),
    0xFA95:(0x6B79,),
    0xFA96:(0x6BBA,),
    0xFA97:(0x6D41,),
    0xFA98:(0x6EDB,),
    0xFA99:(0x6ECB,),
    0xFA9A:(0x6F22,),
    0xFA9B:(0x701E,),
    0xFA9C:(0x716E,),
    0xFA9D:(0x77A7,),
    0xFA9E:(0x7235,),
    0xFA9F:(0x72AF,),
    0xFAA0:(0x732A,),
    0xFAA1:(0x7471,),
    0xFAA2:(0x7506,),
    0xFAA3:(0x753B,),
    0xFAA4:(0x761D,),
    0xFAA5:(0x761F,),
    0xFAA6:(0x76CA,),
    0xFAA7:(0x76DB,),
    0xFAA8:(0x76F4,),
    0xFAA9:(0x774A,),
    0xFAAA:(0x7740,),
    0xFAAB:(0x78CC,),
    0xFAAC:(0x7AB1,),
    0xFAAD:(0x7BC0,),
    0xFAAE:(0x7C7B,),
    0xFAAF:(0x7D5B,),
    0xFAB0:(0x7DF4,),
    0xFAB1:(0x7F3E,),
    0xFAB2:(0x8005,),
    0xFAB3:(0x8352,),
    0xFAB4:(0x83EF,),
    0xFAB5:(0x8779,),
    0xFAB6:(0x8941,),
    0xFAB7:(0x8986,),
    0xFAB8:(0x8996,),
    0xFAB9:(0x8ABF,),
    0xFABA:(0x8AF8,),
    0xFABB:(0x8ACB,),
    0xFABC:(0x8B01,),
    0xFABD:(0x8AFE,),
    0xFABE:(0x8AED,),
    0xFABF:(0x8B39,),
    0xFAC0:(0x8B8A,),
    0xFAC1:(0x8D08,),
    0xFAC2:(0x8F38,),
    0xFAC3:(0x9072,),
    0xFAC4:(0x9199,),
    0xFAC5:(0x9276,),
    0xFAC6:(0x967C,),
    0xFAC7:(0x96E3,),
    0xFAC8:(0x9756,),
    0xFAC9:(0x97DB,),
    0xFACA:(0x97FF,),
    0xFACB:(0x980B,),
    0xFACC:(0x983B,),
    0xFACD:(0x9B12,),
    0xFACE:(0x9F9C,),
    0xFACF:(0x2284A,),
    0xFAD0:(0x22844,),
    0xFAD1:(0x233D5,),
    0xFAD2:(0x3B9D,),
    0xFAD3:(0x4018,),
    0xFAD4:(0x4039,),
    0xFAD5:(0x25249,),
    0xFAD6:(0x25CD0,),
    0xFAD7:(0x27ED3,),
    0xFAD8:(0x9F43,),
    0xFAD9:(0x9F8E,),
    0xFB00:(0x0066,0x0066,),
    0xFB01:(0x0066,0x0069,),
    0xFB02:(0x0066,0x006C,),
    0xFB03:(0x0066,0x0066,0x0069,),
    0xFB04:(0x0066,0x0066,0x006C,),
    0xFB05:(0x017F,0x0074,),
    0xFB06:(0x0073,0x0074,),
    0xFB13:(0x0574,0x0576,),
    0xFB14:(0x0574,0x0565,),
    0xFB15:(0x0574,0x056B,),
    0xFB16:(0x057E,0x0576,),
    0xFB17:(0x0574,0x056D,),
    0xFB1D:(0x05D9,0x05B4,),
    0xFB1F:(0x05F2,0x05B7,),
    0xFB2A:(0x05E9,0x05C1,),
    0xFB2B:(0x05E9,0x05C2,),
    0xFB2C:(0xFB49,0x05C1,),
    0xFB2D:(0xFB49,0x05C2,),
    0xFB2E:(0x05D0,0x05B7,),
    0xFB2F:(0x05D0,0x05B8,),
    0xFB30:(0x05D0,0x05BC,),
    0xFB31:(0x05D1,0x05BC,),
    0xFB32:(0x05D2,0x05BC,),
    0xFB33:(0x05D3,0x05BC,),
    0xFB34:(0x05D4,0x05BC,),
    0xFB35:(0x05D5,0x05BC,),
    0xFB36:(0x05D6,0x05BC,),
    0xFB38:(0x05D8,0x05BC,),
    0xFB39:(0x05D9,0x05BC,),
    0xFB3A:(0x05DA,0x05BC,),
    0xFB3B:(0x05DB,0x05BC,),
    0xFB3C:(0x05DC,0x05BC,),
    0xFB3E:(0x05DE,0x05BC,),
    0xFB40:(0x05E0,0x05BC,),
    0xFB41:(0x05E1,0x05BC,),
    0xFB43:(0x05E3,0x05BC,),
    0xFB44:(0x05E4,0x05BC,),
    0xFB46:(0x05E6,0x05BC,),
    0xFB47:(0x05E7,0x05BC,),
    0xFB48:(0x05E8,0x05BC,),
    0xFB49:(0x05E9,0x05BC,),
    0xFB4A:(0x05EA,0x05BC,),
    0xFB4B:(0x05D5,0x05B9,),
    0xFB4C:(0x05D1,0x05BF,),
    0xFB4D:(0x05DB,0x05BF,),
    0xFB4E:(0x05E4,0x05BF,),
    0xFB4F:(0x05D0,0x05DC,),
    0xFE49:(0x203E,),
    0xFE4A:(0x203E,),
    0xFE4B:(0x203E,),
    0xFE4C:(0x203E,),
    0xFE4D:(0x005F,),
    0xFE4E:(0x005F,),
    0xFE4F:(0x005F,),
}


def composites_with_appended(accent):
    if isinstance(accent, str):
        accent = unicode_from_name(accent)
    composites = {}
    for k in glyph_components.keys():
        components = glyph_components[k]
        if len(components) == 2 and components[1] == accent:
            composites[k] = components
    return composites


#--------------------------------------------------------------------------

GRAVE = "gravecomb"
ACUTE = "acutecomb"
CIRCUMFLEX = "uni0302"
TILDE = "tildecomb"
MACRON = "uni0304"
OVERLINE = "uni0305"
BREVE = "uni0306"
DOTACCENT = "uni0307"
DIERESIS = "uni0308"
HOOK_ABOVE = HOOKABOVE = "hookabovecomb"
RING = "uni030A"
HUNGARUMLAUT = "uni030B"
CARON = "uni030C"
VERTICAL_LINE_ABOVE = "uni030D"
DOUBLE_VERTICAL_LINE_ABOVE = "uni030E"
DOUBLE_GRAVE = "uni030F"
CANDRABINDU = CHANDRABINDU = "uni0310"
INVERTED_BREVE = "uni0311"
TURNED_COMMA_ABOVE = "uni0312"
COMMA_ABOVE = "uni0313"
REVERSED_COMMA_ABOVE = "uni0314"
COMMA_ABOVE_RIGHT = "uni0315"
GRAVE_BELOW = "uni0316"
ACUTE_BELOW = "uni0317"
HORN = "uni031B"
DOT_BELOW = DOTBELOW = "dotbelowcomb"
DIERESIS_BELOW = "uni0324"
RING_BELOW = "uni0325"
COMMA_BELOW = COMMAACCENT = "uni0326"
CEDILLA = "uni0327"
OGONEK = "uni0328"
CARON_BELOW = "uni032C"
CIRCUMFLEX_BELOW = "uni032D"
BREVE_BELOW = "uni032E"
TILDE_BELOW = "uni0330"
MACRON_BELOW = "uni0331"
PERIOD_CENTERED = PERIODCENTERED = "periodcentered"

spacing_marks_lookup = {
    GRAVE: "grave",
    ACUTE: "acute",
    "acutecomb.PLK": "acute.PLK", # Kreska
    CIRCUMFLEX: "circumflex",
    TILDE: "tilde",
    MACRON: "macron",
    OVERLINE: "uni203E",
    BREVE: "breve",
    DOTACCENT: "dotaccent",
    DIERESIS: "dieresis",
    HOOK_ABOVE: "uni02C0",
    RING: "ring",
    HUNGARUMLAUT: "hungarumlaut",
    CARON: "caron",
    VERTICAL_LINE_ABOVE: "uni02C8",
    DOUBLE_VERTICAL_LINE_ABOVE: None,
    DOUBLE_GRAVE: None,
    INVERTED_BREVE: None,
    TURNED_COMMA_ABOVE: "uni02BB",
    COMMA_ABOVE: None,
    REVERSED_COMMA_ABOVE: None,
    GRAVE_BELOW: None,
    ACUTE_BELOW: None,
    DOT_BELOW: None,
    DIERESIS_BELOW: None,
    RING_BELOW: None,
    COMMA_BELOW: None,
    CEDILLA: "cedilla",
    OGONEK: "ogonek",
    CARON_BELOW: None,
    CIRCUMFLEX_BELOW: None,
    BREVE_BELOW: None,
    TILDE_BELOW: None,
    MACRON_BELOW: None,
    COMMA_ABOVE_RIGHT: "afii57929",
    HORN: None }

def is_variant(name, name_to_test):
    return name_to_test[:len(name) + 1] == name + "."

def variant_extension(variant_name):
    for i in range(0, len(variant_name) - 1):
        if variant_name[i] == ".":
            return variant_name[i + 1:]
    return None

def variant_root(variant_name):
    for i in range(0, len(variant_name) - 1):
        if variant_name[i] == ".":
            return variant_name[:i]
    return variant_name

def first_name(name):
    for i in range(0, len(name) - 1):
        if name[i] == "_":
            return name[:i]
    return name

def last_name(name):
    for i in range(len(name) - 1, -1, -1):
        if name[i] == "_":
            return name[i + 1:]
    return name

def unicode_category(glyph_name, ligature_picker = None):

    # [Cc]	Other, Control
    # [Cf]	Other, Format
    # [Cn]	Other, Not Assigned (no characters in the file have this property)
    # [Co]	Other, Private Use
    # [Cs]	Other, Surrogate
    # [Ll]	Letter, Lowercase
    # [Lm]	Letter, Modifier
    # [Lo]	Letter, Other
    # [Lt]	Letter, Titlecase
    # [Lu]	Letter, Uppercase
    # [Mc]	Mark, Spacing Combining
    # [Me]	Mark, Enclosing
    # [Mn]	Mark, Nonspacing
    # [Nd]	Number, Decimal Digit
    # [Nl]	Number, Letter
    # [No]	Number, Other
    # [Pc]	Punctuation, Connector
    # [Pd]	Punctuation, Dash
    # [Pe]	Punctuation, Close
    # [Pf]	Punctuation, Final quote (may behave like Ps or Pe depending on usage)
    # [Pi]	Punctuation, Initial quote (may behave like Ps or Pe depending on usage)
    # [Po]	Punctuation, Other
    # [Ps]	Punctuation, Open
    # [Sc]	Symbol, Currency
    # [Sk]	Symbol, Modifier
    # [Sm]	Symbol, Math
    # [So]	Symbol, Other
    # [Zl]	Separator, Line
    # [Zp]	Separator, Paragraph
    # [Zs]	Separator, Space

    root = variant_root(glyph_name)
    if ligature_picker != None:
        picked = ligature_picker(root)
    else:
        picked = root
    uni = preferred_unicode(picked)
    if uni < 0:
        cat = '  '
    elif sys.version_info[0] <= 2:
        cat = unicodedata.category(unichr(uni))
    else:
        cat = unicodedata.category(chr(uni))
    return cat

def is_mark(name, ligature_picker = None):
    return unicode_category(name)[1] == 'M'

def is_letter(name, ligature_picker = None):
    return unicode_category(name)[1] == 'L'

def is_uppercase(name, ligature_picker = None):
    return unicode_category(name) == 'Lu'
    
def is_lowercase(name, ligature_picker = None):
    return unicode_category(name) == 'Ll'

def separate_strings(glyph_names, predicates):
    bins = []
    remaining = glyph_names
    for p in predicates:
        good = []
        bad = []
        for g in remaining:
            if p(g):
                good.append(g)
            else:
                bad.append(g)
        bins.append(set(good))
        remaining = bad
    bins.append(set(remaining))
    return bins

def propagate_hyphens(font, suffix = ""):
    if "hyphen" + suffix in font:
        make_glyph_reference("uni00AD" + suffix, font["hyphen" + suffix]) # soft hyphen
        make_glyph_reference("uni2010" + suffix, font["hyphen" + suffix]) # hyphen
        make_glyph_reference("uni2011" + suffix, font["hyphen" + suffix]) # non-breaking hyphen

def build_space_glyph(font, glyph_id, width):
    if type(glyph_id) == type(""):
        name = glyph_id
        unicode = preferred_unicode(name)
    else:
        name = name_from_unicode(glyph_id)
        unicode = glyph_id        
    new_glyph = font.createChar(unicode, name)
    new_glyph.glyphname = name
    new_glyph.clear()
    new_glyph.width = width

def build_several_space_glyphs(font, emsize, spacesize,
                               ensize = None,
                               thinspacesize = None,
                               narrownobreaksize = None,
                               hairspacesize = None,
                               punctwidth = None,
                               tabwidth = None):

    # See http://www.cs.tut.fi/~jkorpela/chars/spaces.html

    if ensize == None:
        ensize = emsize / 2
    if thinspacesize == None:
        thinspacesize = emsize / 5   # emsize/6 would be another
                                     # common value.
    if narrownobreaksize == None:
        narrownobreaksize = thinspacesize
    if hairspacesize == None:
        hairspacesize = emsize / 10
    if punctwidth == None:
        punctwidth = font["period"].width
    build_space_glyph(font, "space", spacesize)
    build_space_glyph(font, "uni00A0", spacesize) # non-breaking space
    build_space_glyph(font, "uni2000", ensize)    # en quad
    build_space_glyph(font, "uni2001", emsize)    # em quad
    build_space_glyph(font, "uni2002", ensize)    # en space
    build_space_glyph(font, "uni2003", emsize)    # em space
    build_space_glyph(font, "uni2004", emsize/3)  # 3 per em space
    build_space_glyph(font, "uni2005", emsize/4)  # 4 per em space
    build_space_glyph(font, "uni2006", emsize/6)  # 6 per em space
    if tabwidth != None:
        build_space_glyph(font, "uni2007", tabwidth) # figure space
    build_space_glyph(font, "uni2008", punctwidth)   # punctuation space
    build_space_glyph(font, "uni2009", thinspacesize) # thin space
    build_space_glyph(font, "uni200A", hairspacesize) # hair space
    build_space_glyph(font, "uni200B", 0)             # zero-width space
    build_space_glyph(font, 0x200C, 0)                # zero-width non-joiner
    build_space_glyph(font, 0x200D, 0)                # zero-width joiner
    build_space_glyph(font, 0x200E, 0)                # left-to-right mark
    build_space_glyph(font, 0x200F, 0)                # right-to-left mark
    build_space_glyph(font, "uni202F", narrownobreaksize) # narrow non-breaking space
    build_space_glyph(font, "uni205F", (4*emsize)/18) # medium mathematical space
    build_space_glyph(font, "uni2060", 0)             # word joiner
    build_space_glyph(font, "uniFEFF", 0) # zero-width non-breaking space

def build_spacing_marks(font, width):
    transformation = (1, 0, 0, 1, width, 0)
    for combining_mark in spacing_marks_lookup:
        if combining_mark in font and font[combining_mark].isWorthOutputting:
            spacing_mark = spacing_marks_lookup[combining_mark]
            if spacing_mark != None:
                new_glyph = font.createChar(preferred_unicode(spacing_mark), spacing_mark)
                new_glyph.glyphname = spacing_mark
                new_glyph.clear()
                new_glyph.addReference(combining_mark, transformation)
                new_glyph.width = width

def build_accented_glyph_no_spacing(glyphname, base, mark, width = None, rsb = None):
    assert not (width != None and rsb != None)
    new_glyph = base.font.createChar(preferred_unicode(glyphname), glyphname)
    new_glyph.glyphname = glyphname
    new_glyph.clear()
    new_glyph.addReference(base.glyphname)
    new_glyph.appendAccent(name=mark.glyphname)
    if width != None:
        new_glyph.width = width
    elif rsb != None:
        # Try not to disturb the left side bearing
        # significantly. If it is integral, we want it to
        # stay that way, at least very closely.
        glyph_extent = new_glyph.width - new_glyph.right_side_bearing
        exact_width = glyph_extent + rsb
        new_glyph.width = round(exact_width, 0)

def build_accented_glyph(glyphname, base, mark, width = None, rsb = None):
    build_accented_glyph_no_spacing(glyphname, base, mark, width = width, rsb = rsb)
    glyph = base.font[glyphname]
    if spacing_by_anchors.glyph_has_spacing_anchors(None, base):
        spacing_by_anchors.copy_spacing_anchors(glyph)
        spacing_by_anchors.space_glyph_by_anchors(None, glyph)
    else:
        glyph.width = base.width

# A clunky alternative to build_accented_glyph. Useful, for instance,
# as a workaround for bugs in FontForge's built-in accent-placement
# code.
def build_mark_to_base(glyphname, base, mark, anchor_name):
    if glyphname in base.font:
        new_glyph = base.font[glyphname]
    else:
        new_glyph = base.font.createChar(preferred_unicode(glyphname), glyphname)
    new_glyph.glyphname = glyphname
    for base_anchor in base.anchorPoints:
        if base_anchor[0] == anchor_name:
            break;
    for mark_anchor in mark.anchorPoints:
        if mark_anchor[0] == anchor_name:
            break;
    assert base_anchor[1] == "base"
    assert mark_anchor[1] == "mark"
    dx, dy = base_anchor[2] - mark_anchor[2], base_anchor[3] - mark_anchor[3]
    pen = new_glyph.glyphPen()
    pen.addComponent(base.glyphname, (1, 0, 0, 1, 0, 0))
    pen.addComponent(mark.glyphname, (1, 0, 0, 1, dx, dy))

def remove_anchor_point(glyph, anchor_name):
    new_points = []
    for point in glyph.anchorPoints:
        if point[0] != anchor_name:
            new_points += [point]
    glyph.anchorPoints = new_points

def copy_anchor_point(dest_glyph, src_glyph, anchor_name, new_name=None, translation=(0, 0)):
    if new_name == None:
        new_name = anchor_name
    remove_anchor_point(dest_glyph, new_name)
    for point in src_glyph.anchorPoints:
        if point[0] == anchor_name:
            new_point = (new_name, point[1], point[2] + translation[0], point[3] + translation[1])
            dest_glyph.anchorPoints += (new_point,)
            break

#--------------------------------------------------------------------------

def noop_mark_builder(glyphname, base, mark):
    return                      # No operation.

class mark_builder:

    def __init__(self, mark, included_variants = (), post_processor = None):
        self.mark = mark
        self.builders = { 'space' : noop_mark_builder }
        self.post_processor = post_processor

        self.included_variants = []
        for e in included_variants:
            if e[:1] == ".":
                # Remove a leading period.
                self.included_variants += [e[1:]]
            else:
                self.included_variants += [e]

        f = self.mark.font
        unicode = self.mark.unicode

        if unicode == unicode_from_name(CEDILLA) and COMMA_BELOW in f:
            self.build_with("T", mark = f[COMMA_BELOW])
            self.build_with("t", mark = f[COMMA_BELOW])

    def build(self, glyphname, base):
        f = self.mark.font
        if isinstance(base, str) or isinstance(base, int):
            base = f[base]
        if base.glyphname in self.builders.keys():
            (self.builders[base.glyphname])(glyphname, base, self.mark)
        elif (self.mark.glyphname == CARON
              and variant_root(base.glyphname) in ("d", "L", "l", "t")
              and COMMA_ABOVE_RIGHT in f):
            if variant_extension(base.glyphname):
                build_accented_glyph_no_spacing(glyphname, base, f[COMMA_ABOVE_RIGHT])
            else:
                new_glyph = self.mark.font.createChar(preferred_unicode(glyphname), glyphname)
                new_glyph.glyphname = glyphname
                new_glyph.clear()
                new_glyph.build()
        elif has_ascender(base) and self.mark.glyphname + ".cap" in f:
            build_accented_glyph_no_spacing(glyphname, base, f[self.mark.glyphname + ".cap"])
        else:
            new_glyph = self.mark.font.createChar(preferred_unicode(glyphname), glyphname)
            new_glyph.glyphname = glyphname
            new_glyph.clear()
            new_glyph.build()
        if glyphname in f:
            glyph = f[glyphname]
            for (ref_name, _) in f[glyphname].references:
                glyph.useRefsMetrics(ref_name, False)
            if self.post_processor != None:
                self.post_processor(glyph)
            spacing_by_anchors.copy_spacing_anchors(glyph)
            spacing_by_anchors.space_glyph_by_anchors(None, glyph)

    def build_glyphs(self):
        f = self.mark.font
        composites = composites_with_appended(self.mark.unicode)
        for k in composites.keys():
            n = name_from_unicode(k)
            base = name_from_unicode(composites[k][0])
            if base in f:
                self.build(n, base)
            for b in f:
                if is_variant(base, b):
                    ext = variant_extension(b)
                    if ext in self.included_variants:
                        n_variant = n + "." + ext
                        self.build(n_variant, b)

    def new_builder(self, basename, builder):
        self.builders[basename] = builder

    def build_with(self, basename, base = None, mark = None, width = None, rsb = None):
        assert not (width != None and rsb != None)
        if base != None and mark != None:
            self.new_builder(basename, lambda glyphname, b, m: build_accented_glyph_no_spacing(glyphname, base, mark,
                                                                                               width = width, rsb = rsb))
        elif base != None:
            self.new_builder(basename, lambda glyphname, b, m: build_accented_glyph_no_spacing(glyphname, base, m,
                                                                                               width = width, rsb = rsb))
        elif mark != None:
            self.new_builder(basename, lambda glyphname, b, m: build_accented_glyph_no_spacing(glyphname, b, mark,
                                                                                               width = width, rsb = rsb))
        else:
            self.new_builder(basename, lambda glyphname, b, m: build_accented_glyph_no_spacing(glyphname, b, m,
                                                                                               width = width, rsb = rsb))

    def do_not_build(self, basename):
        self.new_builder(basename, noop_mark_builder)

    def builtin_builder(self, basename):
        del self.builders[basename]


class mark_builder_bunch:

    def __init__(self, font, mark_names = (), included_variants = (), post_processor = None):
        self.mark_builders = {}
        for m in mark_names:
            if m in font:
                self.mark_builders[m] = mark_builder(font[m], included_variants, post_processor)
            else:
                print("Warning: mark " + m + " is not present in the font.")

    def __getitem__(self, mark):
        return self.mark_builders[mark]

    def build_glyphs(self):
        for builder in self.mark_builders.values():
            builder.build_glyphs()

#--------------------------------------------------------------------------

def remove_overlap(glyph):        
    if glyph.selfIntersects():
        glyph.unlinkRef()
        glyph.removeOverlap()
        glyph.round()
        glyph.autoHint()

def build_multigraph(glyphname, components,
                     tolerance = None,
                     rounding_function = round,
                     copy_spacing_anchors = True):
    assert len(components) != 0

    if tolerance == None:
        tolerance = spacing_by_anchors.anchor_tolerance

    f = components[0].font
    new_glyph = f.createChar(preferred_unicode(glyphname), glyphname)
    new_glyph.glyphname = glyphname
    new_glyph.clear()
    new_glyph.addReference(components[0].glyphname)

    offset = 0
    for i in range(1, len(components)):
        offset += components[i - 1].width
        sig1 = spacing_by_anchors.right_signature(components[i - 1], tolerance)
        sig2 = spacing_by_anchors.left_signature(components[i], tolerance)
        kerning = spacing_by_anchors.calculate_kerning(sig1, sig2, tolerance = tolerance,
                                                       rounding_function = rounding_function)
        if kerning != None:
            offset += kerning
        new_glyph.addReference(components[i].glyphname, psMat.translate(offset, 0))

    if copy_spacing_anchors:
        spacing_by_anchors.copy_spacing_anchors(new_glyph)
    if spacing_by_anchors.glyph_has_spacing_anchors(None, new_glyph):
        spacing_by_anchors.space_glyph_by_anchors(None, new_glyph)
    else:
        new_glyph.width = offset + components[-1].width

    remove_overlap(new_glyph)

#--------------------------------------------------------------------------

def make_glyph_reference(glyphname, original, transformation = None, copy_spacing_anchors = True):
    f = original.font
    new_glyph = f.createChar(preferred_unicode(glyphname), glyphname)
    new_glyph.glyphname = glyphname
    new_glyph.clear()
    if transformation != None:
        new_glyph.addReference(original.glyphname, transformation)
    else:
        new_glyph.addReference(original.glyphname)
    if copy_spacing_anchors and spacing_by_anchors.glyph_has_spacing_anchors(None, original):
        spacing_by_anchors.copy_spacing_anchors(new_glyph)
        spacing_by_anchors.space_glyph_by_anchors(None, new_glyph)
    else:
        new_glyph.width = original.width

def make_turned_glyph(glyphname, original):
    f = original.font

    new_glyph = f.createChar(preferred_unicode(glyphname), glyphname)
    new_glyph.glyphname = glyphname
    new_glyph.clear()

    (xmin, ymin, xmax, ymax) = original.boundingBox()
    matrix = psMat.translate(-0.5*(xmin + xmax), -0.5*(ymin + ymax))
    matrix = psMat.compose(matrix, psMat.rotate(pi))
    matrix = psMat.compose(matrix, psMat.translate(0.5*(xmin + xmax), 0.5*(ymin + ymax)))

    new_glyph.addReference(original.glyphname, matrix)
    new_glyph.unlinkRef()
    new_glyph.left_side_bearing = original.right_side_bearing
    new_glyph.width = original.width

#--------------------------------------------------------------------------

def preferred_unicode(glyphname):
    if '_' in glyphname:
        uni = -1
    else:
        uni = fontforge.unicodeFromName(glyphname)
    return uni

#--------------------------------------------------------------------------
