#!/bin/bash
# bbou@ac-toulouse.fr
# 2007-05-22 16:31:22 
# _test-smb.sh

### P A R A M S

MYVERBOSE=
if [ "$1" = "-v" ]; then
	MYVERBOSE="True"
	shift
fi
MYSERVER="$1"
MYSHARE="$2"
MYDOMAIN="$3"
MYUSER="$4"
MYUSERPWD="$5"
#echo "server=${MYSERVER}"
#echo "share=${MYSHARE}"
#echo "domain=${MYDOMAIN}"
#echo "user=${MYUSER}"
#echo "password=${MYUSERPWD}"

### I N C L U D E

. ./_include.sh

### O T H E R

share="//${MYSERVER}/${MYSHARE}"

### S T A R T
guest=`testparm -sv 2> /dev/null | grep 'guest account' | awk '{print $4}'`

echo "--------------------------------------------------------------------------------"
echo "SMB TEST"
echo "--------------------------------------------------------------------------------"

if ! type smbstatus > /dev/null; then
	exit 1
fi
if ! type smbclient > /dev/null; then
	exit 1
fi

echo "+STATUS"
if ! smbstatus >/dev/null 2>/dev/null; then
	echo 'status failed' >&2
else
	smbstatus  2>&1 | grep -v "^$"
fi

echo "+BROWSE"
echo "+browse localhost anonymously"
#smbclient -L localhost -U%
if smbclient -L localhost -U% > /dev/null 2> /dev/null; then
	echo 'ok'
else
	echo 'fail'
	echo "browse localhost anonymously failed" >&2
fi
echo "+browse localhost as guest ${guest}"
#smbclient -L localhost -U ${guest}%
if smbclient -L localhost -U ${guest}% > /dev/null 2> /dev/null; then
	echo 'ok'
else
	echo 'fail'
	echo "browse localhost as guest ${guest} failed" >&2
fi

if [ ! "${MYUSER}" = "" ]; then
	echo "+browse localhost as ${MYUSER} with password ${MYUSERPWD}"
	e="smbclient -L localhost -U '${MYUSER}%${MYUSERPWD}'"
	if eval $e > /dev/null 2> /dev/null; then
		echo 'ok'
	else
		echo 'fail'
		echo "browse localhost as ${MYUSER} with password ${MYUSERPWD} failed" >&2
	fi
fi

echo "+CONNECT"
echo "+connect anonymously to ${share}"
#smbclient ${share} -U% -c "exit"
if smbclient ${share} -U% -c "exit" > /dev/null 2> /dev/null; then
	echo "ok"
else
	echo 'fail'
	echo "connect anonymously to ${share} failed" >&2
fi

echo "+connect as guest (${guest}) to ${share}"
#smbclient ${share} -U ${guest}% -c "exit"
if smbclient ${share} -U ${guest}% -c "exit" > /dev/null 2> /dev/null; then
	echo "ok"
else
	echo 'fail'
	echo "connect as guest ${guest} to ${share} failed" >&2
fi

if [ ! "${MYUSER}" = "" ]; then
	echo "+connect as ${MYUSER} with password ${MYUSERPWD} to ${share}"
	e="smbclient ${share} -U '${MYUSER}%${MYUSERPWD}' -c 'exit'"
	if eval $e > /dev/null 2> /dev/null; then
		echo "ok"
	else
		echo 'fail'
		echo "connect as ${MYUSER} with password ${MYUSERPWD} to ${share} failed" >&2
	fi
fi
exit 0
