# The Rustc Book

- [What is rustc?](what-is-rustc.md)
- [Command-line Arguments](command-line-arguments.md)
    - [Codegen Options](codegen-options/index.md)
- [Lints](lints/index.md)
    - [Lint Levels](lints/levels.md)
    - [Lint Groups](lints/groups.md)
    - [Lint Listing](lints/listing/index.md)
        - [Allowed-by-default Lints](lints/listing/allowed-by-default.md)
        - [Warn-by-default Lints](lints/listing/warn-by-default.md)
        - [Deny-by-default Lints](lints/listing/deny-by-default.md)
- [JSON Output](json.md)
- [Tests](tests/index.md)
- [Platform Support](platform-support.md)
    - [Target Tier Policy](target-tier-policy.md)
    - [Template for Target-specific Documentation](platform-support/TEMPLATE.md)
    - [aarch64-apple-ios-sim](platform-support/aarch64-apple-ios-sim.md)
    - [\*-apple-watchos\*](platform-support/apple-watchos.md)
    - [aarch64-nintendo-switch-freestanding](platform-support/aarch64-nintendo-switch-freestanding.md)
    - [armeb-unknown-linux-gnueabi](platform-support/armeb-unknown-linux-gnueabi.md)
    - [armv4t-none-eabi](platform-support/armv4t-none-eabi.md)
    - [armv6k-nintendo-3ds](platform-support/armv6k-nintendo-3ds.md)
    - [armv7-unknown-linux-uclibceabi](platform-support/armv7-unknown-linux-uclibceabi.md)
    - [armv7-unknown-linux-uclibceabihf](platform-support/armv7-unknown-linux-uclibceabihf.md)
    - [\*-fuchsia](platform-support/fuchsia.md)
    - [\*-kmc-solid_\*](platform-support/kmc-solid.md)
    - [m68k-unknown-linux-gnu](platform-support/m68k-unknown-linux-gnu.md)
    - [mips64-openwrt-linux-musl](platform-support/mips64-openwrt-linux-musl.md)
    - [nvptx64-nvidia-cuda](platform-support/nvptx64-nvidia-cuda.md)
    - [riscv32imac-unknown-xous-elf](platform-support/riscv32imac-unknown-xous-elf.md)
    - [*-pc-windows-gnullvm](platform-support/pc-windows-gnullvm.md)
    - [*-unknown-openbsd](platform-support/openbsd.md)
    - [\*-unknown-uefi](platform-support/unknown-uefi.md)
    - [wasm64-unknown-unknown](platform-support/wasm64-unknown-unknown.md)
    - [x86_64-unknown-none](platform-support/x86_64-unknown-none.md)
- [Targets](targets/index.md)
    - [Built-in Targets](targets/built-in.md)
    - [Custom Targets](targets/custom.md)
    - [Known Issues](targets/known-issues.md)
- [Profile-guided Optimization](profile-guided-optimization.md)
- [Instrumentation-based Code Coverage](instrument-coverage.md)
- [Linker-plugin-based LTO](linker-plugin-lto.md)
- [Exploit Mitigations](exploit-mitigations.md)
- [Contributing to `rustc`](contributing.md)
