# -*- encoding:utf-8; warn-indent:false; frozen_string_literal: true  -*-

# line 1 "lib/parser/lexer.rl"

# line 3 "lib/parser/lexer.rl"
#
# === BEFORE YOU START ===
#
# Read the Ruby Hacking Guide chapter 11, available in English at
# http://whitequark.org/blog/2013/04/01/ruby-hacking-guide-ch-11-finite-state-lexer/
#
# Remember two things about Ragel scanners:
#
#   1) Longest match wins.
#
#   2) If two matches have the same length, the first
#      in source code wins.
#
# General rules of making Ragel and Bison happy:
#
#  * `p` (position) and `@te` contain the index of the character
#    they're pointing to ("current"), plus one. `@ts` contains the index
#    of the corresponding character. The code for extracting matched token is:
#
#       @source_buffer.slice(@ts...@te)
#
#  * If your input is `foooooooobar` and the rule is:
#
#       'f' 'o'+
#
#    the result will be:
#
#       foooooooobar
#       ^ ts=0   ^ p=te=9
#
#  * A Ragel lexer action should not emit more than one token, unless
#    you know what you are doing.
#
#  * All Ragel commands (fnext, fgoto, ...) end with a semicolon.
#
#  * If an action emits the token and transitions to another state, use
#    these Ragel commands:
#
#       emit($whatever)
#       fnext $next_state; fbreak;
#
#    If you perform `fgoto` in an action which does not emit a token nor
#    rewinds the stream pointer, the parser's side-effectful,
#    context-sensitive lookahead actions will break in a hard to detect
#    and debug way.
#
#  * If an action does not emit a token:
#
#       fgoto $next_state;
#
#  * If an action features lookbehind, i.e. matches characters with the
#    intent of passing them to another action:
#
#       p = @ts - 1
#       fgoto $next_state;
#
#    or, if the lookbehind consists of a single character:
#
#       fhold; fgoto $next_state;
#
#  * Ragel merges actions. So, if you have `e_lparen = '(' %act` and
#    `c_lparen = '('` and a lexer action `e_lparen | c_lparen`, the result
#    _will_ invoke the action `act`.
#
#    e_something stands for "something with **e**mbedded action".
#
#  * EOF is explicit and is matched by `c_eof`. If you want to introspect
#    the state of the lexer, add this rule to the state:
#
#       c_eof => do_eof;
#
#  * If you proceed past EOF, the lexer will complain:
#
#       NoMethodError: undefined method `ord' for nil:NilClass
#

class Parser::Lexer

  
# line 85 "lib/parser/lexer.rb"
class << self
	attr_accessor :_lex_trans_keys
	private :_lex_trans_keys, :_lex_trans_keys=
end
self._lex_trans_keys = [
	0, 0, 101, 101, 103, 103, 
	105, 105, 110, 110, 69, 
	69, 78, 78, 68, 68, 
	95, 95, 95, 95, 0, 26, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 45, 
	0, 77, 0, 77, 0, 92, 
	0, 26, 0, 26, 0, 
	45, 0, 99, 0, 26, 
	67, 99, 45, 45, 0, 92, 
	0, 77, 0, 102, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 45, 0, 77, 
	0, 77, 0, 92, 0, 
	26, 0, 26, 0, 45, 
	0, 99, 0, 26, 67, 99, 
	45, 45, 0, 92, 0, 
	77, 0, 102, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 26, 0, 
	127, 58, 58, 58, 58, 
	0, 127, 58, 58, 60, 60, 
	62, 62, 10, 10, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 115, 115, 
	99, 99, 117, 117, 101, 101, 
	108, 116, 101, 101, 115, 
	115, 115, 115, 105, 105, 
	108, 108, 105, 105, 108, 108, 
	58, 58, 0, 127, 10, 
	10, 0, 127, 58, 58, 
	98, 98, 101, 101, 103, 103, 
	105, 105, 110, 110, 0, 
	122, 61, 61, 9, 92, 
	9, 92, 9, 92, 9, 92, 
	9, 92, 10, 10, 0, 
	127, 0, 127, 61, 126, 
	0, 127, 0, 127, 93, 93, 
	0, 127, 0, 127, 10, 
	10, 10, 34, 10, 10, 
	10, 39, 0, 127, 10, 96, 
	0, 45, 0, 77, 0, 
	77, 0, 92, 0, 26, 
	0, 26, 0, 45, 0, 99, 
	0, 26, 67, 99, 45, 
	45, 0, 92, 0, 77, 
	0, 102, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 58, 58, 
	58, 58, 0, 127, 43, 57, 
	48, 57, 48, 57, 48, 
	57, 48, 57, 0, 127, 
	58, 58, 9, 92, 9, 92, 
	9, 92, 9, 92, 9, 
	92, 9, 92, 60, 60, 
	10, 10, 9, 46, 46, 46, 
	0, 95, 9, 32, 0, 
	0, 10, 10, 10, 10, 
	98, 98, 9, 32, 10, 10, 
	95, 95, 0, 92, 9, 
	32, 36, 123, 0, 127, 
	48, 57, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 10, 10, 0, 92, 
	0, 123, 0, 26, 0, 
	26, 0, 26, 0, 0, 
	0, 102, 0, 102, 0, 102, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 26, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 0, 
	48, 102, 0, 0, 0, 
	92, 36, 123, 0, 127, 
	48, 57, 0, 120, 0, 0, 
	0, 0, 48, 55, 48, 
	55, 0, 0, 0, 0, 
	0, 92, 0, 0, 0, 0, 
	0, 0, 0, 92, 45, 
	45, 0, 0, 0, 0, 
	0, 0, 0, 92, 0, 45, 
	0, 92, 0, 92, 0, 
	0, 0, 0, 0, 92, 
	0, 45, 10, 10, 0, 92, 
	0, 123, 0, 26, 0, 
	26, 0, 26, 0, 0, 
	0, 102, 0, 102, 0, 102, 
	0, 0, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 125, 
	0, 125, 0, 0, 0, 
	125, 0, 26, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 0, 
	48, 102, 0, 0, 0, 
	92, 9, 32, 0, 26, 
	0, 92, 0, 26, 0, 35, 
	36, 123, 0, 127, 48, 
	57, 0, 26, 0, 35, 
	9, 32, 36, 123, 0, 127, 
	48, 57, 0, 32, 9, 
	32, 65, 122, 65, 122, 
	36, 64, 0, 127, 48, 57, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 61, 126, 10, 10, 
	10, 10, 0, 127, 0, 
	127, 48, 57, 115, 115, 
	38, 38, 42, 42, 64, 64, 
	58, 58, 60, 61, 62, 
	62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	93, 93, 10, 10, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 124, 
	124, 0, 127, 0, 127, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 38, 38, 42, 42, 
	64, 64, 60, 61, 62, 62, 
	61, 126, 61, 61, 61, 
	62, 0, 127, 93, 93, 
	10, 10, 124, 124, 0, 126, 
	0, 127, 0, 61, 9, 
	61, 9, 61, 0, 0, 
	9, 61, 9, 62, 46, 46, 
	46, 46, 58, 58, 9, 
	32, 0, 0, 0, 127, 
	0, 0, 9, 124, 0, 0, 
	10, 10, 10, 10, 0, 
	0, 9, 61, 58, 58, 
	60, 60, 62, 62, 9, 32, 
	10, 10, 0, 127, 102, 
	102, 101, 101, 110, 110, 
	104, 104, 0, 127, 0, 127, 
	0, 127, 0, 0, 0, 
	127, 10, 10, 0, 123, 
	9, 32, 10, 10, 10, 10, 
	10, 10, 0, 0, 111, 
	111, 0, 0, 0, 127, 
	0, 127, 9, 32, 0, 0, 
	10, 10, 10, 10, 10, 
	10, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 58, 61, 0, 0, 
	61, 126, 61, 61, 0, 
	0, 0, 0, 0, 0, 
	9, 32, 61, 61, 9, 32, 
	61, 126, 10, 10, 10, 
	10, 65, 122, 0, 122, 
	38, 61, 0, 0, 42, 61, 
	61, 61, 9, 92, 9, 
	92, 9, 92, 46, 46, 
	46, 46, 0, 26, 0, 127, 
	0, 127, 61, 61, 0, 
	0, 61, 126, 61, 62, 
	0, 0, 0, 0, 0, 0, 
	0, 0, 61, 126, 0, 
	127, 48, 57, 38, 38, 
	42, 42, 64, 64, 60, 61, 
	62, 62, 61, 61, 61, 
	62, 124, 124, 60, 61, 
	0, 0, 62, 62, 61, 126, 
	61, 62, 0, 122, 0, 
	0, 0, 127, 0, 127, 
	0, 120, 0, 0, 0, 0, 
	48, 55, 48, 55, 0, 
	0, 0, 0, 0, 92, 
	0, 0, 0, 0, 0, 0, 
	0, 92, 45, 45, 0, 
	0, 0, 0, 0, 0, 
	0, 92, 0, 45, 0, 92, 
	0, 92, 0, 0, 0, 
	0, 0, 92, 0, 45, 
	10, 10, 0, 92, 0, 123, 
	0, 26, 0, 26, 0, 
	26, 0, 0, 0, 102, 
	0, 102, 0, 102, 0, 0, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 125, 
	0, 0, 0, 125, 0, 
	26, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 
	125, 0, 125, 0, 125, 
	0, 125, 0, 125, 0, 125, 
	0, 125, 0, 0, 0, 
	0, 48, 102, 0, 0, 
	0, 127, 0, 127, 0, 127, 
	0, 0, 10, 10, 0, 
	0, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 61, 126, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 0, 61, 
	124, 0, 92, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 9, 32, 
	0, 0, 10, 10, 10, 10, 
	10, 10, 0, 0, 0, 
	127, 0, 127, 61, 61, 
	0, 0, 9, 32, 0, 0, 
	61, 126, 10, 10, 10, 
	10, 0, 127, 0, 127, 
	48, 57, 61, 61, 38, 61, 
	0, 0, 0, 0, 42, 
	61, 61, 62, 46, 57, 
	46, 46, 48, 101, 48, 95, 
	46, 120, 48, 114, 43, 
	57, 48, 105, 0, 0, 
	105, 105, 0, 0, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 105, 114, 0, 0, 
	105, 105, 0, 0, 48, 114, 
	48, 114, 48, 114, 48, 
	114, 48, 114, 48, 114, 
	48, 114, 48, 114, 46, 114, 
	48, 114, 46, 114, 48, 
	114, 58, 58, 60, 61, 
	62, 62, 61, 126, 61, 61, 
	61, 62, 0, 127, 0, 
	127, 0, 0, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	0, 10, 10, 0, 0, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 9, 
	92, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 127, 
	0, 127, 0, 127, 0, 
	127, 0, 127, 0, 0, 
	61, 124, 0, 0, 9, 46, 
	9, 46, 46, 46, 10, 
	61, 10, 10, 10, 101, 
	10, 110, 10, 100, 10, 10, 
	0
]

class << self
	attr_accessor :_lex_key_spans
	private :_lex_key_spans, :_lex_key_spans=
end
self._lex_key_spans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 27, 128, 128, 128, 128, 46, 
	78, 78, 93, 27, 27, 46, 100, 27, 
	33, 1, 93, 78, 103, 128, 128, 128, 
	128, 46, 78, 78, 93, 27, 27, 46, 
	100, 27, 33, 1, 93, 78, 103, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 27, 128, 1, 1, 
	128, 1, 1, 1, 1, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 1, 
	1, 1, 1, 9, 1, 1, 1, 1, 
	1, 1, 1, 1, 128, 1, 128, 1, 
	1, 1, 1, 1, 1, 123, 1, 84, 
	84, 84, 84, 84, 1, 128, 128, 66, 
	128, 128, 1, 128, 128, 1, 25, 1, 
	30, 128, 87, 46, 78, 78, 93, 27, 
	27, 46, 100, 27, 33, 1, 93, 78, 
	103, 128, 128, 128, 128, 128, 128, 1, 
	1, 128, 15, 10, 10, 10, 10, 128, 
	1, 84, 84, 84, 84, 84, 84, 1, 
	1, 38, 1, 96, 24, 0, 1, 1, 
	1, 24, 1, 1, 93, 24, 88, 128, 
	10, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 46, 93, 93, 0, 0, 93, 
	46, 1, 93, 124, 27, 27, 27, 0, 
	103, 103, 103, 0, 126, 126, 126, 126, 
	126, 0, 126, 126, 0, 126, 27, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	0, 126, 0, 55, 0, 93, 88, 128, 
	10, 121, 0, 0, 8, 8, 0, 0, 
	93, 0, 0, 0, 93, 1, 0, 0, 
	0, 93, 46, 93, 93, 0, 0, 93, 
	46, 1, 93, 124, 27, 27, 27, 0, 
	103, 103, 103, 0, 126, 126, 126, 126, 
	126, 0, 126, 126, 0, 126, 27, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	0, 126, 0, 55, 0, 93, 24, 27, 
	93, 27, 36, 88, 128, 10, 27, 36, 
	24, 88, 128, 10, 33, 24, 58, 58, 
	29, 128, 10, 128, 128, 128, 128, 24, 
	0, 66, 1, 1, 128, 128, 10, 1, 
	1, 1, 1, 1, 2, 1, 66, 1, 
	2, 128, 128, 128, 128, 128, 128, 128, 
	1, 1, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 1, 128, 128, 
	24, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 1, 1, 
	1, 2, 1, 66, 1, 2, 128, 1, 
	1, 1, 127, 128, 62, 53, 53, 0, 
	53, 54, 1, 1, 1, 24, 0, 128, 
	0, 116, 0, 1, 1, 0, 53, 1, 
	1, 1, 24, 1, 128, 1, 1, 1, 
	1, 128, 128, 128, 0, 128, 1, 124, 
	24, 1, 1, 1, 0, 1, 0, 128, 
	128, 24, 0, 1, 1, 1, 0, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 4, 0, 66, 1, 0, 0, 0, 
	24, 1, 24, 66, 1, 1, 58, 123, 
	24, 0, 20, 1, 84, 84, 84, 1, 
	1, 27, 128, 128, 1, 0, 66, 2, 
	0, 0, 0, 0, 66, 128, 10, 1, 
	1, 1, 2, 1, 1, 2, 1, 2, 
	0, 1, 66, 2, 123, 0, 128, 128, 
	121, 0, 0, 8, 8, 0, 0, 93, 
	0, 0, 0, 93, 1, 0, 0, 0, 
	93, 46, 93, 93, 0, 0, 93, 46, 
	1, 93, 124, 27, 27, 27, 0, 103, 
	103, 103, 0, 126, 126, 126, 126, 126, 
	0, 126, 126, 0, 126, 27, 126, 126, 
	126, 126, 126, 126, 126, 126, 126, 126, 
	126, 126, 126, 126, 0, 0, 55, 0, 
	128, 128, 128, 0, 1, 0, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 66, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 0, 64, 93, 24, 
	0, 1, 1, 1, 0, 128, 128, 24, 
	0, 1, 1, 1, 0, 128, 128, 1, 
	0, 24, 0, 66, 1, 1, 128, 128, 
	10, 1, 24, 0, 0, 20, 2, 12, 
	1, 54, 48, 75, 67, 15, 58, 0, 
	1, 0, 67, 67, 67, 67, 10, 0, 
	1, 0, 67, 67, 67, 67, 67, 67, 
	67, 67, 69, 67, 69, 67, 1, 2, 
	1, 66, 1, 2, 128, 128, 0, 128, 
	128, 128, 128, 128, 128, 0, 1, 0, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 84, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 128, 
	128, 128, 128, 128, 128, 128, 128, 0, 
	64, 0, 38, 38, 1, 52, 1, 92, 
	101, 91, 1
]

class << self
	attr_accessor :_lex_index_offsets
	private :_lex_index_offsets, :_lex_index_offsets=
end
self._lex_index_offsets = [
	0, 0, 2, 4, 6, 8, 10, 12, 
	14, 16, 18, 46, 175, 304, 433, 562, 
	609, 688, 767, 861, 889, 917, 964, 1065, 
	1093, 1127, 1129, 1223, 1302, 1406, 1535, 1664, 
	1793, 1922, 1969, 2048, 2127, 2221, 2249, 2277, 
	2324, 2425, 2453, 2487, 2489, 2583, 2662, 2766, 
	2895, 3024, 3153, 3282, 3411, 3540, 3669, 3798, 
	3927, 4056, 4185, 4314, 4443, 4471, 4600, 4602, 
	4604, 4733, 4735, 4737, 4739, 4741, 4870, 4999, 
	5128, 5257, 5386, 5515, 5644, 5773, 5902, 6031, 
	6160, 6289, 6418, 6547, 6676, 6805, 6934, 7063, 
	7065, 7067, 7069, 7071, 7081, 7083, 7085, 7087, 
	7089, 7091, 7093, 7095, 7097, 7226, 7228, 7357, 
	7359, 7361, 7363, 7365, 7367, 7369, 7493, 7495, 
	7580, 7665, 7750, 7835, 7920, 7922, 8051, 8180, 
	8247, 8376, 8505, 8507, 8636, 8765, 8767, 8793, 
	8795, 8826, 8955, 9043, 9090, 9169, 9248, 9342, 
	9370, 9398, 9445, 9546, 9574, 9608, 9610, 9704, 
	9783, 9887, 10016, 10145, 10274, 10403, 10532, 10661, 
	10663, 10665, 10794, 10810, 10821, 10832, 10843, 10854, 
	10983, 10985, 11070, 11155, 11240, 11325, 11410, 11495, 
	11497, 11499, 11538, 11540, 11637, 11662, 11663, 11665, 
	11667, 11669, 11694, 11696, 11698, 11792, 11817, 11906, 
	12035, 12046, 12168, 12169, 12170, 12179, 12188, 12189, 
	12190, 12284, 12285, 12286, 12287, 12381, 12383, 12384, 
	12385, 12386, 12480, 12527, 12621, 12715, 12716, 12717, 
	12811, 12858, 12860, 12954, 13079, 13107, 13135, 13163, 
	13164, 13268, 13372, 13476, 13477, 13604, 13731, 13858, 
	13985, 14112, 14113, 14240, 14367, 14368, 14495, 14523, 
	14650, 14777, 14904, 15031, 15158, 15285, 15412, 15539, 
	15666, 15667, 15794, 15795, 15851, 15852, 15946, 16035, 
	16164, 16175, 16297, 16298, 16299, 16308, 16317, 16318, 
	16319, 16413, 16414, 16415, 16416, 16510, 16512, 16513, 
	16514, 16515, 16609, 16656, 16750, 16844, 16845, 16846, 
	16940, 16987, 16989, 17083, 17208, 17236, 17264, 17292, 
	17293, 17397, 17501, 17605, 17606, 17733, 17860, 17987, 
	18114, 18241, 18242, 18369, 18496, 18497, 18624, 18652, 
	18779, 18906, 19033, 19160, 19287, 19414, 19541, 19668, 
	19795, 19796, 19923, 19924, 19980, 19981, 20075, 20100, 
	20128, 20222, 20250, 20287, 20376, 20505, 20516, 20544, 
	20581, 20606, 20695, 20824, 20835, 20869, 20894, 20953, 
	21012, 21042, 21171, 21182, 21311, 21440, 21569, 21698, 
	21723, 21724, 21791, 21793, 21795, 21924, 22053, 22064, 
	22066, 22068, 22070, 22072, 22074, 22077, 22079, 22146, 
	22148, 22151, 22280, 22409, 22538, 22667, 22796, 22925, 
	23054, 23056, 23058, 23187, 23316, 23445, 23574, 23703, 
	23832, 23961, 24090, 24219, 24348, 24477, 24606, 24735, 
	24864, 24993, 25122, 25251, 25380, 25509, 25638, 25767, 
	25896, 26025, 26154, 26283, 26412, 26541, 26670, 26799, 
	26928, 27057, 27186, 27315, 27444, 27573, 27702, 27831, 
	27960, 28089, 28218, 28347, 28476, 28605, 28734, 28863, 
	28992, 29121, 29250, 29379, 29508, 29637, 29766, 29895, 
	30024, 30153, 30282, 30411, 30540, 30669, 30798, 30927, 
	31056, 31185, 31314, 31443, 31572, 31701, 31830, 31959, 
	32088, 32217, 32346, 32475, 32604, 32733, 32862, 32991, 
	33120, 33249, 33378, 33507, 33636, 33765, 33767, 33896, 
	34025, 34050, 34052, 34054, 34056, 34057, 34186, 34315, 
	34317, 34318, 34343, 34344, 34411, 34413, 34415, 34417, 
	34419, 34421, 34424, 34426, 34493, 34495, 34498, 34627, 
	34629, 34631, 34633, 34761, 34890, 34953, 35007, 35061, 
	35062, 35116, 35171, 35173, 35175, 35177, 35202, 35203, 
	35332, 35333, 35450, 35451, 35453, 35455, 35456, 35510, 
	35512, 35514, 35516, 35541, 35543, 35672, 35674, 35676, 
	35678, 35680, 35809, 35938, 36067, 36068, 36197, 36199, 
	36324, 36349, 36351, 36353, 36355, 36356, 36358, 36359, 
	36488, 36617, 36642, 36643, 36645, 36647, 36649, 36650, 
	36779, 36908, 37037, 37166, 37295, 37424, 37553, 37682, 
	37811, 37940, 38069, 38198, 38327, 38456, 38585, 38714, 
	38843, 38972, 38977, 38978, 39045, 39047, 39048, 39049, 
	39050, 39075, 39077, 39102, 39169, 39171, 39173, 39232, 
	39356, 39381, 39382, 39403, 39405, 39490, 39575, 39660, 
	39662, 39664, 39692, 39821, 39950, 39952, 39953, 40020, 
	40023, 40024, 40025, 40026, 40027, 40094, 40223, 40234, 
	40236, 40238, 40240, 40243, 40245, 40247, 40250, 40252, 
	40255, 40256, 40258, 40325, 40328, 40452, 40453, 40582, 
	40711, 40833, 40834, 40835, 40844, 40853, 40854, 40855, 
	40949, 40950, 40951, 40952, 41046, 41048, 41049, 41050, 
	41051, 41145, 41192, 41286, 41380, 41381, 41382, 41476, 
	41523, 41525, 41619, 41744, 41772, 41800, 41828, 41829, 
	41933, 42037, 42141, 42142, 42269, 42396, 42523, 42650, 
	42777, 42778, 42905, 43032, 43033, 43160, 43188, 43315, 
	43442, 43569, 43696, 43823, 43950, 44077, 44204, 44331, 
	44458, 44585, 44712, 44839, 44966, 44967, 44968, 45024, 
	45025, 45154, 45283, 45412, 45413, 45415, 45416, 45545, 
	45674, 45803, 45932, 46061, 46190, 46319, 46448, 46577, 
	46706, 46835, 46964, 47093, 47222, 47351, 47480, 47609, 
	47738, 47867, 47996, 48125, 48254, 48383, 48512, 48641, 
	48770, 48899, 49028, 49157, 49286, 49415, 49544, 49673, 
	49802, 49931, 50060, 50189, 50318, 50447, 50576, 50705, 
	50834, 50963, 51092, 51221, 51350, 51479, 51608, 51737, 
	51866, 51995, 52124, 52253, 52382, 52511, 52640, 52769, 
	52898, 53027, 53156, 53223, 53352, 53481, 53610, 53739, 
	53868, 53997, 54126, 54255, 54384, 54513, 54642, 54771, 
	54900, 55029, 55158, 55287, 55416, 55545, 55674, 55803, 
	55932, 56061, 56190, 56319, 56448, 56449, 56514, 56608, 
	56633, 56634, 56636, 56638, 56640, 56641, 56770, 56899, 
	56924, 56925, 56927, 56929, 56931, 56932, 57061, 57190, 
	57192, 57193, 57218, 57219, 57286, 57288, 57290, 57419, 
	57548, 57559, 57561, 57586, 57587, 57588, 57609, 57612, 
	57625, 57627, 57682, 57731, 57807, 57875, 57891, 57950, 
	57951, 57953, 57954, 58022, 58090, 58158, 58226, 58237, 
	58238, 58240, 58241, 58309, 58377, 58445, 58513, 58581, 
	58649, 58717, 58785, 58855, 58923, 58993, 59061, 59063, 
	59066, 59068, 59135, 59137, 59140, 59269, 59398, 59399, 
	59528, 59657, 59786, 59915, 60044, 60173, 60174, 60176, 
	60177, 60306, 60435, 60564, 60693, 60822, 60951, 61080, 
	61209, 61338, 61467, 61596, 61725, 61854, 61983, 62112, 
	62241, 62370, 62499, 62628, 62757, 62886, 63015, 63144, 
	63273, 63402, 63531, 63660, 63789, 63918, 64047, 64176, 
	64305, 64434, 64563, 64692, 64821, 64950, 65035, 65164, 
	65293, 65422, 65551, 65680, 65809, 65938, 66067, 66196, 
	66325, 66454, 66583, 66712, 66841, 66970, 67099, 67228, 
	67357, 67486, 67615, 67744, 67873, 68002, 68131, 68260, 
	68389, 68518, 68647, 68776, 68905, 69034, 69163, 69292, 
	69421, 69550, 69679, 69808, 69937, 70066, 70195, 70324, 
	70453, 70582, 70711, 70840, 70969, 71098, 71227, 71356, 
	71485, 71614, 71743, 71872, 72001, 72130, 72259, 72388, 
	72517, 72646, 72775, 72904, 73033, 73162, 73291, 73420, 
	73421, 73486, 73487, 73526, 73565, 73567, 73620, 73622, 
	73715, 73817, 73909
]

class << self
	attr_accessor :_lex_indicies
	private :_lex_indicies, :_lex_indicies=
end
self._lex_indicies = [
	1, 0, 2, 0, 3, 0, 4, 0, 
	5, 0, 6, 0, 7, 0, 8, 0, 
	9, 0, 10, 0, 0, 0, 10, 0, 
	0, 0, 0, 0, 11, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 10, 0, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 12, 14, 12, 14, 14, 12, 12, 
	14, 14, 14, 15, 14, 14, 16, 16, 
	16, 16, 16, 16, 16, 16, 16, 16, 
	14, 14, 14, 14, 14, 14, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 14, 12, 12, 13, 14, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 12, 12, 12, 14, 12, 13, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 12, 12, 12, 12, 12, 12, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 14, 12, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 14, 14, 14, 14, 14, 14, 
	14, 14, 12, 12, 12, 12, 12, 14, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 12, 12, 12, 12, 12, 12, 
	17, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 13, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	13, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 12, 12, 12, 12, 12, 12, 12, 
	12, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 12, 12, 12, 12, 12, 
	12, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	13, 12, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 12, 12, 12, 12, 
	12, 13, 18, 19, 19, 19, 18, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 18, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 20, 
	19, 18, 21, 21, 21, 18, 21, 21, 
	21, 21, 21, 22, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 23, 21, 
	18, 21, 21, 21, 18, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 18, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 24, 21, 18, 
	25, 25, 25, 18, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 18, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 27, 25, 18, 28, 28, 
	28, 18, 28, 28, 28, 28, 28, 29, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 18, 
	28, 18, 28, 28, 28, 18, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 28, 28, 28, 28, 28, 
	28, 28, 28, 18, 28, 18, 19, 19, 
	19, 18, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 18, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 30, 19, 18, 31, 31, 31, 
	18, 31, 31, 31, 31, 31, 32, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 18, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 33, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	34, 31, 31, 31, 31, 31, 31, 35, 
	31, 18, 31, 31, 31, 18, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 31, 31, 31, 31, 31, 
	31, 31, 31, 18, 31, 36, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 18, 18, 18, 
	18, 18, 18, 18, 18, 37, 18, 37, 
	18, 18, 38, 38, 38, 18, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 18, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	39, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 40, 38, 18, 
	21, 21, 21, 18, 21, 21, 21, 21, 
	21, 22, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 18, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 21, 21, 21, 21, 
	21, 21, 21, 21, 24, 21, 18, 41, 
	41, 41, 18, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	18, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 42, 42, 
	42, 42, 42, 42, 42, 42, 42, 42, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 41, 
	41, 41, 41, 41, 41, 41, 41, 42, 
	42, 42, 42, 42, 42, 41, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 43, 45, 43, 45, 45, 43, 43, 
	45, 45, 45, 46, 45, 45, 47, 47, 
	47, 47, 47, 47, 47, 47, 47, 47, 
	45, 45, 45, 45, 45, 45, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 45, 43, 43, 44, 45, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 43, 43, 43, 45, 43, 44, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 43, 43, 43, 43, 43, 43, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 45, 43, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 45, 45, 45, 45, 45, 45, 
	45, 45, 43, 43, 43, 43, 43, 45, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 43, 43, 43, 43, 43, 43, 
	48, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 44, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	44, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 43, 43, 43, 43, 43, 43, 43, 
	43, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 43, 43, 43, 43, 43, 
	43, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	44, 43, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 43, 43, 43, 43, 
	43, 44, 49, 50, 50, 50, 49, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 49, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 51, 
	50, 49, 52, 52, 52, 49, 52, 52, 
	52, 52, 52, 53, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 54, 52, 
	49, 52, 52, 52, 49, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 49, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 55, 52, 49, 
	56, 56, 56, 49, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 49, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 57, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 58, 56, 49, 59, 59, 
	59, 49, 59, 59, 59, 59, 59, 60, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 49, 
	59, 49, 59, 59, 59, 49, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 59, 59, 59, 59, 59, 
	59, 59, 59, 49, 59, 49, 50, 50, 
	50, 49, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 49, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 61, 50, 49, 62, 62, 62, 
	49, 62, 62, 62, 62, 62, 63, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 49, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 64, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	65, 62, 62, 62, 62, 62, 62, 66, 
	62, 49, 62, 62, 62, 49, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 62, 62, 62, 62, 62, 
	62, 62, 62, 49, 62, 67, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 49, 49, 49, 
	49, 49, 49, 49, 49, 68, 49, 68, 
	49, 49, 69, 69, 69, 49, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 49, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	70, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 71, 69, 49, 
	52, 52, 52, 49, 52, 52, 52, 52, 
	52, 53, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 49, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 52, 52, 52, 52, 
	52, 52, 52, 52, 55, 52, 49, 72, 
	72, 72, 49, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	49, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 73, 73, 
	73, 73, 73, 73, 73, 73, 73, 73, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 72, 
	72, 72, 72, 72, 72, 72, 72, 73, 
	73, 73, 73, 73, 73, 72, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 74, 76, 74, 76, 76, 74, 74, 
	76, 76, 76, 77, 76, 76, 78, 78, 
	78, 78, 78, 78, 78, 78, 78, 78, 
	76, 76, 76, 76, 76, 76, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 76, 74, 74, 75, 76, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 74, 74, 74, 76, 74, 75, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 74, 74, 74, 74, 74, 74, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 76, 74, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 76, 76, 76, 76, 76, 76, 
	76, 76, 74, 74, 74, 74, 74, 76, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 74, 74, 74, 74, 74, 74, 
	79, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 75, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	75, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 74, 74, 74, 74, 74, 74, 74, 
	74, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 74, 74, 74, 74, 74, 
	74, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	75, 74, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 74, 74, 74, 74, 
	74, 75, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 80, 82, 80, 
	82, 82, 80, 80, 82, 82, 82, 83, 
	82, 82, 84, 84, 84, 84, 84, 84, 
	84, 84, 84, 84, 82, 82, 82, 82, 
	82, 82, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 82, 80, 
	80, 81, 82, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 80, 80, 80, 
	82, 80, 81, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 80, 80, 80, 
	80, 80, 80, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 82, 80, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 82, 82, 
	82, 82, 82, 82, 82, 82, 80, 80, 
	80, 80, 80, 82, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 80, 80, 
	80, 80, 80, 80, 85, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 81, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 81, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 80, 80, 80, 
	80, 80, 80, 80, 80, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 80, 
	80, 80, 80, 80, 80, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 81, 80, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	80, 80, 80, 80, 80, 81, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 88, 87, 88, 87, 87, 88, 88, 
	87, 87, 87, 89, 87, 87, 90, 90, 
	90, 90, 90, 90, 90, 90, 90, 90, 
	87, 87, 87, 87, 87, 87, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 87, 88, 88, 86, 87, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 88, 88, 88, 87, 88, 86, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 88, 88, 88, 88, 88, 88, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 87, 88, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 87, 87, 87, 87, 87, 87, 
	87, 87, 88, 88, 88, 88, 88, 87, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 88, 88, 88, 88, 88, 88, 
	92, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 91, 
	88, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 88, 88, 88, 88, 88, 
	91, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 88, 88, 88, 88, 88, 
	88, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	93, 88, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 88, 88, 88, 88, 
	88, 93, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 94, 94, 94, 94, 94, 94, 
	94, 94, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 94, 94, 94, 94, 
	94, 94, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 95, 94, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 95, 95, 95, 
	95, 95, 95, 95, 95, 94, 94, 94, 
	94, 94, 95, 96, 97, 97, 97, 96, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 97, 97, 97, 
	97, 97, 97, 97, 97, 96, 97, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 98, 
	100, 98, 98, 98, 98, 98, 98, 98, 
	98, 98, 98, 98, 98, 98, 98, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 101, 98, 98, 98, 98, 100, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 99, 98, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 98, 98, 98, 98, 98, 99, 
	101, 98, 98, 102, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 105, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 103, 
	103, 103, 103, 105, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 104, 103, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 103, 
	103, 103, 103, 103, 104, 106, 103, 108, 
	107, 109, 107, 110, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 112, 107, 
	112, 112, 112, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 112, 107, 107, 
	107, 107, 113, 114, 107, 115, 107, 116, 
	117, 118, 119, 120, 113, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 121, 
	107, 122, 118, 123, 124, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	125, 126, 118, 127, 111, 107, 111, 111, 
	111, 111, 111, 111, 111, 111, 128, 111, 
	111, 111, 111, 111, 111, 111, 111, 129, 
	111, 111, 130, 111, 131, 111, 111, 111, 
	132, 133, 107, 127, 107, 111, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 134, 
	107, 134, 134, 134, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 134, 107, 
	107, 107, 107, 135, 136, 107, 137, 107, 
	138, 139, 140, 141, 142, 135, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	143, 107, 144, 140, 145, 146, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 147, 148, 140, 109, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 149, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	150, 104, 104, 151, 104, 152, 104, 104, 
	104, 153, 154, 107, 109, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 104, 155, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 156, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 157, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 158, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	159, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 155, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 160, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 161, 104, 104, 104, 104, 104, 
	104, 104, 162, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	105, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 106, 107, 107, 107, 107, 105, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 104, 107, 
	104, 104, 104, 104, 163, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 107, 107, 107, 107, 107, 104, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 105, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 106, 107, 107, 107, 107, 105, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 104, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 164, 104, 104, 104, 104, 
	104, 104, 104, 107, 107, 107, 107, 107, 
	104, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 105, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 106, 107, 107, 107, 107, 
	105, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	104, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 155, 104, 104, 104, 
	104, 104, 104, 104, 107, 107, 107, 107, 
	107, 104, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 105, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 106, 107, 107, 107, 
	107, 105, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 104, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 165, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 107, 107, 107, 
	107, 107, 104, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 105, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 107, 107, 
	107, 107, 105, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 104, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 155, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 107, 107, 
	107, 107, 107, 104, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 105, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 106, 107, 
	107, 107, 107, 105, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 104, 107, 104, 104, 104, 
	104, 104, 104, 104, 166, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 107, 
	107, 107, 107, 107, 104, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 105, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 106, 
	107, 107, 107, 107, 105, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 104, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 167, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	107, 107, 107, 107, 107, 104, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 107, 105, 
	107, 107, 107, 107, 107, 107, 107, 107, 
	107, 107, 107, 107, 107, 107, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	106, 107, 107, 107, 107, 105, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 104, 107, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 159, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 107, 107, 107, 107, 107, 104, 169, 
	168, 170, 168, 171, 168, 140, 168, 172, 
	168, 168, 168, 168, 168, 168, 168, 173, 
	168, 174, 168, 175, 168, 140, 168, 176, 
	168, 140, 168, 177, 168, 171, 168, 179, 
	178, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 182, 180, 182, 182, 182, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 182, 180, 180, 180, 180, 180, 180, 
	180, 183, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 184, 180, 180, 
	181, 180, 181, 181, 181, 185, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 180, 180, 180, 180, 
	180, 181, 186, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 188, 180, 188, 
	188, 188, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 188, 180, 180, 180, 
	180, 180, 180, 180, 189, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 180, 180, 180, 
	180, 180, 180, 180, 180, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	190, 180, 180, 187, 180, 187, 187, 187, 
	191, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 187, 
	187, 187, 187, 187, 187, 187, 187, 180, 
	180, 180, 180, 180, 187, 192, 193, 195, 
	194, 196, 194, 197, 194, 198, 194, 199, 
	194, 200, 201, 201, 201, 200, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 200, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 201, 201, 201, 201, 
	201, 201, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 201, 203, 192, 204, 
	205, 204, 204, 204, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 204, 192, 
	192, 206, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 207, 207, 
	207, 207, 207, 207, 207, 207, 207, 207, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 208, 192, 209, 210, 209, 209, 
	209, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 209, 192, 192, 211, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 212, 212, 212, 212, 212, 
	212, 212, 212, 212, 212, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 213, 
	192, 215, 216, 215, 215, 215, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	215, 214, 214, 217, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	218, 218, 218, 218, 218, 218, 218, 218, 
	218, 218, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 214, 214, 214, 214, 
	214, 214, 214, 214, 219, 214, 221, 222, 
	221, 221, 221, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 221, 220, 220, 
	223, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 224, 224, 224, 
	224, 224, 224, 224, 224, 224, 224, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 225, 220, 221, 226, 221, 221, 221, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 221, 220, 220, 223, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 224, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 225, 220, 
	205, 192, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 229, 229, 227, 229, 227, 
	229, 229, 227, 227, 229, 229, 229, 230, 
	229, 229, 231, 231, 231, 231, 231, 231, 
	231, 231, 231, 231, 229, 229, 229, 229, 
	229, 229, 229, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 227, 229, 227, 
	227, 228, 229, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 227, 227, 227, 
	229, 227, 228, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 227, 227, 227, 
	227, 227, 227, 227, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 227, 227, 
	227, 227, 229, 227, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 229, 229, 
	229, 229, 229, 229, 229, 229, 227, 227, 
	227, 227, 227, 229, 232, 229, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 229, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 233, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 227, 227, 227, 227, 228, 227, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 227, 227, 227, 227, 227, 228, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 227, 227, 227, 227, 228, 
	227, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 227, 227, 227, 227, 227, 
	228, 232, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 235, 227, 227, 
	227, 227, 236, 227, 227, 227, 227, 227, 
	237, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	203, 227, 227, 227, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 227, 227, 
	227, 227, 234, 238, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 227, 227, 
	227, 237, 227, 234, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 241, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 240, 240, 240, 240, 
	240, 240, 240, 240, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 240, 240, 
	240, 240, 240, 240, 240, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 240, 
	240, 240, 240, 239, 240, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 239, 
	239, 239, 239, 239, 239, 239, 239, 240, 
	240, 240, 240, 240, 239, 243, 242, 227, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 235, 
	235, 235, 235, 235, 235, 235, 235, 244, 
	235, 241, 240, 227, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	236, 236, 236, 236, 236, 236, 236, 236, 
	244, 236, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 235, 227, 227, 227, 
	227, 236, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 227, 227, 227, 
	227, 234, 238, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 234, 234, 234, 
	234, 234, 234, 234, 234, 227, 227, 227, 
	227, 227, 234, 227, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 238, 238, 238, 238, 238, 238, 238, 
	238, 244, 238, 245, 246, 246, 246, 245, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 245, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	247, 246, 245, 248, 248, 248, 245, 248, 
	248, 248, 248, 248, 249, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 245, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 250, 
	248, 245, 248, 248, 248, 245, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 245, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 251, 248, 
	245, 252, 252, 252, 245, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 245, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 253, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 254, 252, 245, 255, 
	255, 255, 245, 255, 255, 255, 255, 255, 
	256, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	245, 255, 245, 255, 255, 255, 245, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 255, 255, 255, 255, 
	255, 255, 255, 255, 245, 255, 245, 246, 
	246, 246, 245, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	245, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 257, 246, 245, 258, 258, 
	258, 245, 258, 258, 258, 258, 258, 259, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 245, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	260, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 261, 258, 258, 258, 258, 258, 258, 
	262, 258, 245, 258, 258, 258, 245, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 258, 258, 258, 258, 
	258, 258, 258, 258, 245, 258, 263, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 245, 245, 
	245, 245, 245, 245, 245, 245, 264, 245, 
	264, 245, 245, 265, 265, 265, 245, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 245, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 266, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 267, 265, 
	245, 248, 248, 248, 245, 248, 248, 248, 
	248, 248, 249, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 245, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 248, 248, 248, 
	248, 248, 248, 248, 248, 251, 248, 245, 
	268, 268, 268, 245, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 245, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 269, 
	269, 269, 269, 269, 269, 269, 269, 269, 
	269, 268, 268, 268, 268, 268, 268, 268, 
	269, 269, 269, 269, 269, 269, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	268, 268, 268, 268, 268, 268, 268, 268, 
	269, 269, 269, 269, 269, 269, 268, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	271, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 272, 192, 192, 273, 192, 271, 192, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 192, 192, 192, 192, 270, 192, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 192, 192, 192, 192, 192, 270, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 271, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 272, 227, 227, 273, 227, 271, 
	227, 270, 270, 270, 270, 270, 270, 274, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 227, 227, 227, 227, 270, 
	227, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 227, 227, 227, 227, 227, 
	270, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 271, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 272, 227, 227, 273, 227, 
	271, 227, 270, 270, 270, 270, 270, 270, 
	270, 270, 275, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 227, 227, 227, 227, 
	270, 227, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 227, 227, 227, 227, 
	227, 270, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 271, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 272, 227, 227, 273, 
	227, 271, 227, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	276, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 227, 227, 227, 
	227, 270, 227, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 227, 227, 227, 
	227, 227, 270, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 227, 271, 227, 227, 227, 
	227, 227, 227, 227, 227, 227, 227, 227, 
	227, 227, 227, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 272, 227, 227, 
	273, 227, 271, 227, 270, 270, 270, 276, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 227, 227, 
	227, 227, 270, 227, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 227, 227, 
	227, 227, 227, 270, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 277, 279, 277, 277, 
	277, 277, 277, 277, 277, 277, 277, 277, 
	277, 277, 277, 277, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 280, 277, 
	277, 277, 277, 279, 277, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 277, 
	277, 277, 277, 278, 277, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 277, 
	277, 277, 277, 277, 278, 280, 277, 277, 
	281, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 282, 282, 282, 282, 282, 
	282, 282, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 282, 282, 282, 282, 
	283, 282, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 283, 283, 283, 283, 
	283, 283, 283, 283, 282, 282, 282, 282, 
	282, 283, 285, 284, 285, 284, 284, 286, 
	286, 286, 286, 286, 286, 286, 286, 286, 
	286, 284, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 284, 287, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 284, 
	289, 289, 289, 289, 289, 289, 289, 289, 
	289, 289, 288, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 288, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 282, 282, 
	282, 282, 282, 282, 282, 282, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	282, 282, 282, 282, 282, 282, 282, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 282, 282, 282, 282, 291, 282, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 282, 282, 282, 282, 282, 291, 292, 
	288, 293, 294, 293, 293, 293, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	293, 288, 288, 295, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 296, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 297, 288, 298, 299, 
	298, 298, 298, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 298, 288, 288, 
	300, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 301, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 302, 288, 304, 305, 304, 304, 304, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 304, 303, 303, 306, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 307, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 303, 303, 
	303, 303, 303, 303, 303, 303, 308, 303, 
	310, 311, 310, 310, 310, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 310, 
	309, 309, 312, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 313, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 314, 309, 310, 311, 310, 
	310, 310, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 310, 309, 309, 312, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	315, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	314, 309, 310, 316, 310, 310, 310, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 310, 309, 309, 312, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 313, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 314, 309, 317, 
	288, 294, 288, 319, 318, 319, 319, 319, 
	318, 318, 318, 318, 318, 318, 318, 318, 
	318, 318, 318, 318, 318, 318, 318, 318, 
	318, 318, 319, 318, 318, 318, 318, 318, 
	320, 318, 318, 318, 318, 318, 318, 318, 
	321, 318, 322, 318, 324, 323, 323, 323, 
	324, 323, 323, 323, 323, 325, 326, 325, 
	325, 325, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 324, 323, 
	323, 323, 323, 323, 325, 323, 323, 327, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	323, 328, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	323, 323, 323, 323, 323, 323, 323, 323, 
	329, 323, 323, 330, 323, 325, 331, 325, 
	325, 325, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 331, 331, 331, 331, 
	331, 331, 331, 331, 325, 331, 332, 333, 
	334, 335, 336, 338, 337, 340, 341, 340, 
	340, 340, 339, 339, 339, 339, 339, 339, 
	339, 339, 339, 339, 339, 339, 339, 339, 
	339, 339, 339, 339, 340, 339, 326, 337, 
	342, 337, 344, 343, 343, 343, 344, 343, 
	343, 343, 343, 345, 346, 345, 345, 345, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 344, 343, 343, 343, 
	343, 343, 345, 343, 343, 347, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 343, 343, 
	343, 343, 343, 343, 343, 343, 348, 343, 
	345, 349, 345, 345, 345, 349, 349, 349, 
	349, 349, 349, 349, 349, 349, 349, 349, 
	349, 349, 349, 349, 349, 349, 349, 345, 
	349, 351, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 352, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	350, 350, 350, 350, 350, 350, 350, 350, 
	353, 350, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 354, 354, 354, 354, 354, 354, 
	354, 354, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 354, 354, 354, 354, 
	354, 354, 354, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 354, 354, 354, 
	354, 13, 354, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 13, 13, 13, 
	13, 13, 13, 13, 13, 354, 354, 354, 
	354, 354, 13, 16, 16, 16, 16, 16, 
	16, 16, 16, 16, 16, 354, 357, 356, 
	356, 356, 357, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	357, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 358, 358, 
	358, 358, 358, 358, 358, 358, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 359, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 360, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 361, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 356, 356, 356, 356, 356, 
	356, 356, 356, 362, 356, 356, 363, 356, 
	364, 365, 367, 367, 367, 367, 367, 367, 
	367, 367, 366, 368, 368, 368, 368, 368, 
	368, 368, 368, 366, 366, 369, 369, 38, 
	38, 38, 369, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	369, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 39, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 370, 38, 371, 372, 373, 373, 
	38, 38, 38, 373, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 373, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 39, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 38, 38, 38, 38, 38, 
	38, 38, 38, 374, 38, 37, 373, 375, 
	376, 377, 377, 25, 25, 25, 377, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 377, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 26, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 378, 25, 
	373, 19, 19, 19, 373, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 373, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 379, 19, 369, 
	25, 25, 25, 369, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 369, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 26, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 27, 25, 369, 380, 380, 
	380, 369, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 369, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 381, 380, 382, 383, 383, 380, 380, 
	380, 383, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 383, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 380, 380, 380, 380, 380, 380, 380, 
	380, 384, 380, 383, 19, 19, 19, 383, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 383, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	379, 19, 385, 383, 383, 25, 25, 25, 
	383, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 383, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 26, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	25, 25, 25, 25, 25, 25, 25, 25, 
	27, 25, 386, 387, 387, 387, 386, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 386, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 388, 388, 388, 388, 388, 388, 
	388, 388, 388, 388, 387, 387, 387, 387, 
	387, 387, 387, 388, 388, 388, 388, 388, 
	388, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 388, 388, 388, 388, 388, 
	388, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 387, 387, 387, 
	387, 387, 387, 387, 387, 389, 387, 386, 
	390, 390, 390, 386, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 386, 390, 386, 391, 391, 391, 386, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 386, 391, 386, 
	392, 392, 392, 386, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 386, 392, 386, 386, 390, 390, 390, 
	386, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 386, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 393, 393, 393, 393, 
	393, 393, 393, 393, 393, 393, 390, 390, 
	390, 390, 390, 390, 390, 393, 393, 393, 
	393, 393, 393, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 390, 390, 390, 
	390, 390, 390, 390, 390, 393, 393, 393, 
	393, 393, 393, 390, 386, 391, 391, 391, 
	386, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 386, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 394, 394, 394, 394, 
	394, 394, 394, 394, 394, 394, 391, 391, 
	391, 391, 391, 391, 391, 394, 394, 394, 
	394, 394, 394, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 391, 391, 391, 
	391, 391, 391, 391, 391, 394, 394, 394, 
	394, 394, 394, 391, 386, 392, 392, 392, 
	386, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 386, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 395, 395, 395, 395, 
	395, 395, 395, 395, 395, 395, 392, 392, 
	392, 392, 392, 392, 392, 395, 395, 395, 
	395, 395, 395, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 395, 395, 395, 
	395, 395, 395, 392, 396, 399, 398, 398, 
	398, 399, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 399, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 400, 400, 400, 
	400, 400, 400, 400, 400, 400, 400, 398, 
	398, 398, 398, 398, 398, 398, 400, 400, 
	400, 400, 400, 400, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 400, 400, 
	400, 400, 400, 400, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 398, 398, 398, 398, 398, 398, 
	398, 398, 390, 398, 399, 401, 401, 401, 
	399, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 399, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 402, 402, 402, 402, 
	402, 402, 402, 402, 402, 402, 401, 401, 
	401, 401, 401, 401, 401, 402, 402, 402, 
	402, 402, 402, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 402, 402, 402, 
	402, 402, 402, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 403, 401, 399, 404, 404, 404, 399, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 399, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 404, 404, 404, 
	404, 404, 404, 404, 405, 405, 405, 405, 
	405, 405, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 405, 405, 405, 405, 
	405, 405, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	406, 404, 399, 407, 407, 407, 399, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 399, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 407, 407, 407, 407, 
	407, 407, 407, 408, 408, 408, 408, 408, 
	408, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 408, 408, 408, 408, 408, 
	408, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 399, 
	407, 399, 407, 407, 407, 399, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 399, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 407, 407, 407, 407, 407, 
	407, 407, 408, 408, 408, 408, 408, 408, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 408, 408, 408, 408, 408, 408, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 399, 407, 
	409, 399, 408, 408, 408, 399, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 399, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 409, 408, 
	399, 408, 408, 408, 399, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 399, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 408, 408, 408, 
	408, 408, 408, 408, 408, 397, 408, 397, 
	399, 405, 405, 405, 399, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 399, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 405, 405, 405, 
	405, 405, 405, 405, 405, 392, 405, 397, 
	392, 392, 392, 397, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 392, 392, 392, 392, 392, 392, 392, 
	392, 397, 392, 399, 401, 401, 401, 399, 
	401, 401, 401, 401, 410, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 399, 401, 401, 
	401, 401, 401, 410, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 411, 411, 411, 411, 411, 
	411, 411, 411, 411, 411, 401, 401, 401, 
	401, 401, 401, 401, 411, 411, 411, 411, 
	411, 411, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 411, 411, 411, 411, 
	411, 411, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	401, 401, 401, 401, 401, 401, 401, 401, 
	412, 401, 399, 407, 407, 407, 399, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 399, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 413, 413, 413, 413, 413, 413, 
	413, 413, 413, 413, 407, 407, 407, 407, 
	407, 407, 407, 413, 413, 413, 413, 413, 
	413, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 413, 413, 413, 413, 413, 
	413, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 399, 
	407, 399, 407, 407, 407, 399, 407, 407, 
	407, 407, 410, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 399, 407, 407, 407, 407, 
	407, 410, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 414, 414, 414, 414, 414, 414, 414, 
	414, 414, 414, 407, 407, 407, 407, 407, 
	407, 407, 414, 414, 414, 414, 414, 414, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 414, 414, 414, 414, 414, 414, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 412, 407, 
	399, 407, 407, 407, 399, 407, 407, 407, 
	407, 410, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 399, 407, 407, 407, 407, 407, 
	410, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	415, 415, 415, 415, 415, 415, 415, 415, 
	415, 415, 407, 407, 407, 407, 407, 407, 
	407, 415, 415, 415, 415, 415, 415, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 415, 415, 415, 415, 415, 415, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 412, 407, 399, 
	407, 407, 407, 399, 407, 407, 407, 407, 
	410, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 399, 407, 407, 407, 407, 407, 410, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 416, 
	416, 416, 416, 416, 416, 416, 416, 416, 
	416, 407, 407, 407, 407, 407, 407, 407, 
	416, 416, 416, 416, 416, 416, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	416, 416, 416, 416, 416, 416, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 412, 407, 399, 407, 
	407, 407, 399, 407, 407, 407, 407, 410, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	399, 407, 407, 407, 407, 407, 410, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 417, 417, 
	417, 417, 417, 417, 417, 417, 417, 417, 
	407, 407, 407, 407, 407, 407, 407, 417, 
	417, 417, 417, 417, 417, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 417, 
	417, 417, 417, 417, 417, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 412, 407, 399, 407, 407, 
	407, 399, 407, 407, 407, 407, 410, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 399, 
	407, 407, 407, 407, 407, 410, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 418, 418, 418, 
	418, 418, 418, 418, 418, 418, 418, 407, 
	407, 407, 407, 407, 407, 407, 418, 418, 
	418, 418, 418, 418, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 418, 418, 
	418, 418, 418, 418, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 412, 407, 399, 407, 407, 407, 
	399, 407, 407, 407, 407, 410, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 399, 407, 
	407, 407, 407, 407, 410, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 419, 407, 407, 
	407, 407, 407, 407, 407, 419, 419, 419, 
	419, 419, 419, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 419, 419, 419, 
	419, 419, 419, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 412, 407, 399, 407, 407, 407, 399, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 399, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 419, 419, 419, 419, 419, 
	419, 419, 419, 419, 419, 407, 407, 407, 
	407, 407, 407, 407, 419, 419, 419, 419, 
	419, 419, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 419, 419, 419, 419, 
	419, 419, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	407, 407, 407, 407, 407, 407, 407, 407, 
	409, 407, 420, 399, 404, 404, 404, 399, 
	404, 404, 404, 404, 410, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 399, 404, 404, 
	404, 404, 404, 410, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 415, 415, 415, 415, 415, 
	415, 415, 415, 415, 415, 404, 404, 404, 
	404, 404, 404, 404, 415, 415, 415, 415, 
	415, 415, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 415, 415, 415, 415, 
	415, 415, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	404, 404, 404, 404, 404, 404, 404, 404, 
	412, 404, 421, 423, 423, 423, 423, 423, 
	423, 423, 423, 423, 423, 422, 422, 422, 
	422, 422, 422, 422, 423, 423, 423, 423, 
	423, 423, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 422, 422, 422, 422, 
	422, 422, 422, 422, 423, 423, 423, 423, 
	423, 423, 422, 422, 425, 424, 424, 424, 
	425, 424, 424, 424, 424, 424, 426, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 425, 424, 
	424, 424, 424, 424, 424, 424, 424, 427, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	424, 424, 424, 424, 424, 424, 424, 424, 
	428, 424, 430, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 431, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 429, 429, 429, 429, 429, 429, 429, 
	429, 432, 429, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 433, 433, 433, 433, 433, 
	433, 433, 433, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 433, 433, 433, 
	433, 433, 433, 433, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 433, 433, 
	433, 433, 44, 433, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 44, 44, 
	44, 44, 44, 44, 44, 44, 433, 433, 
	433, 433, 433, 44, 47, 47, 47, 47, 
	47, 47, 47, 47, 47, 47, 433, 436, 
	435, 435, 435, 436, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 436, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 437, 
	437, 437, 437, 437, 437, 437, 437, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 438, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 439, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 440, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 435, 435, 435, 435, 
	435, 435, 435, 435, 441, 435, 435, 442, 
	435, 443, 444, 446, 446, 446, 446, 446, 
	446, 446, 446, 445, 447, 447, 447, 447, 
	447, 447, 447, 447, 445, 445, 448, 448, 
	69, 69, 69, 448, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 448, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 70, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 449, 69, 450, 451, 452, 
	452, 69, 69, 69, 452, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 452, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 70, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 69, 69, 69, 69, 
	69, 69, 69, 69, 453, 69, 68, 452, 
	454, 455, 456, 456, 56, 56, 56, 456, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 456, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 57, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 457, 
	56, 452, 50, 50, 50, 452, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 452, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 458, 50, 
	448, 56, 56, 56, 448, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 448, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 57, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 58, 56, 448, 459, 
	459, 459, 448, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	448, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 460, 459, 461, 462, 462, 459, 
	459, 459, 462, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	462, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 459, 459, 459, 459, 459, 459, 
	459, 459, 463, 459, 462, 50, 50, 50, 
	462, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 462, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 50, 
	50, 458, 50, 464, 462, 462, 56, 56, 
	56, 462, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 462, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 57, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 56, 56, 56, 56, 56, 56, 56, 
	56, 58, 56, 465, 466, 466, 466, 465, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 465, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 467, 467, 467, 467, 467, 
	467, 467, 467, 467, 467, 466, 466, 466, 
	466, 466, 466, 466, 467, 467, 467, 467, 
	467, 467, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 467, 467, 467, 467, 
	467, 467, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 466, 466, 
	466, 466, 466, 466, 466, 466, 468, 466, 
	465, 469, 469, 469, 465, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 465, 469, 465, 470, 470, 470, 
	465, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 465, 470, 
	465, 471, 471, 471, 465, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 465, 471, 465, 465, 469, 469, 
	469, 465, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 465, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 472, 472, 472, 
	472, 472, 472, 472, 472, 472, 472, 469, 
	469, 469, 469, 469, 469, 469, 472, 472, 
	472, 472, 472, 472, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 469, 469, 
	469, 469, 469, 469, 469, 469, 472, 472, 
	472, 472, 472, 472, 469, 465, 470, 470, 
	470, 465, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 465, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 473, 473, 473, 
	473, 473, 473, 473, 473, 473, 473, 470, 
	470, 470, 470, 470, 470, 470, 473, 473, 
	473, 473, 473, 473, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 470, 470, 
	470, 470, 470, 470, 470, 470, 473, 473, 
	473, 473, 473, 473, 470, 465, 471, 471, 
	471, 465, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 465, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 474, 474, 474, 
	474, 474, 474, 474, 474, 474, 474, 471, 
	471, 471, 471, 471, 471, 471, 474, 474, 
	474, 474, 474, 474, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 474, 474, 
	474, 474, 474, 474, 471, 475, 478, 477, 
	477, 477, 478, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	478, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 479, 479, 
	479, 479, 479, 479, 479, 479, 479, 479, 
	477, 477, 477, 477, 477, 477, 477, 479, 
	479, 479, 479, 479, 479, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 479, 
	479, 479, 479, 479, 479, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 477, 477, 477, 477, 477, 
	477, 477, 477, 469, 477, 478, 480, 480, 
	480, 478, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 478, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 481, 481, 481, 
	481, 481, 481, 481, 481, 481, 481, 480, 
	480, 480, 480, 480, 480, 480, 481, 481, 
	481, 481, 481, 481, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 481, 481, 
	481, 481, 481, 481, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 482, 480, 478, 483, 483, 483, 
	478, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 478, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 483, 483, 
	483, 483, 483, 483, 483, 484, 484, 484, 
	484, 484, 484, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 484, 484, 484, 
	484, 484, 484, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 485, 483, 478, 486, 486, 486, 478, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 478, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 486, 486, 486, 
	486, 486, 486, 486, 487, 487, 487, 487, 
	487, 487, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 487, 487, 487, 487, 
	487, 487, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	478, 486, 478, 486, 486, 486, 478, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 478, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 486, 486, 486, 486, 
	486, 486, 486, 487, 487, 487, 487, 487, 
	487, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 487, 487, 487, 487, 487, 
	487, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 478, 
	486, 488, 478, 487, 487, 487, 478, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 478, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 488, 
	487, 478, 487, 487, 487, 478, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 478, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 487, 487, 
	487, 487, 487, 487, 487, 487, 476, 487, 
	476, 478, 484, 484, 484, 478, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 478, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 484, 484, 
	484, 484, 484, 484, 484, 484, 471, 484, 
	476, 471, 471, 471, 476, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 471, 471, 471, 471, 471, 471, 
	471, 471, 476, 471, 478, 480, 480, 480, 
	478, 480, 480, 480, 480, 489, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 478, 480, 
	480, 480, 480, 480, 489, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 490, 490, 490, 490, 
	490, 490, 490, 490, 490, 490, 480, 480, 
	480, 480, 480, 480, 480, 490, 490, 490, 
	490, 490, 490, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 490, 490, 490, 
	490, 490, 490, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 480, 480, 480, 480, 480, 480, 480, 
	480, 491, 480, 478, 486, 486, 486, 478, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 478, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 492, 492, 492, 492, 492, 
	492, 492, 492, 492, 492, 486, 486, 486, 
	486, 486, 486, 486, 492, 492, 492, 492, 
	492, 492, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 492, 492, 492, 492, 
	492, 492, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	478, 486, 478, 486, 486, 486, 478, 486, 
	486, 486, 486, 489, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 478, 486, 486, 486, 
	486, 486, 489, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 493, 493, 493, 493, 493, 493, 
	493, 493, 493, 493, 486, 486, 486, 486, 
	486, 486, 486, 493, 493, 493, 493, 493, 
	493, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 493, 493, 493, 493, 493, 
	493, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 491, 
	486, 478, 486, 486, 486, 478, 486, 486, 
	486, 486, 489, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 478, 486, 486, 486, 486, 
	486, 489, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 494, 494, 494, 494, 494, 494, 494, 
	494, 494, 494, 486, 486, 486, 486, 486, 
	486, 486, 494, 494, 494, 494, 494, 494, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 494, 494, 494, 494, 494, 494, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 491, 486, 
	478, 486, 486, 486, 478, 486, 486, 486, 
	486, 489, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 478, 486, 486, 486, 486, 486, 
	489, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	495, 495, 495, 495, 495, 495, 495, 495, 
	495, 495, 486, 486, 486, 486, 486, 486, 
	486, 495, 495, 495, 495, 495, 495, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 495, 495, 495, 495, 495, 495, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 491, 486, 478, 
	486, 486, 486, 478, 486, 486, 486, 486, 
	489, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 478, 486, 486, 486, 486, 486, 489, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 496, 
	496, 496, 496, 496, 496, 496, 496, 496, 
	496, 486, 486, 486, 486, 486, 486, 486, 
	496, 496, 496, 496, 496, 496, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	496, 496, 496, 496, 496, 496, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 491, 486, 478, 486, 
	486, 486, 478, 486, 486, 486, 486, 489, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	478, 486, 486, 486, 486, 486, 489, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 497, 497, 
	497, 497, 497, 497, 497, 497, 497, 497, 
	486, 486, 486, 486, 486, 486, 486, 497, 
	497, 497, 497, 497, 497, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 497, 
	497, 497, 497, 497, 497, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 491, 486, 478, 486, 486, 
	486, 478, 486, 486, 486, 486, 489, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 478, 
	486, 486, 486, 486, 486, 489, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 498, 486, 
	486, 486, 486, 486, 486, 486, 498, 498, 
	498, 498, 498, 498, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 498, 498, 
	498, 498, 498, 498, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 491, 486, 478, 486, 486, 486, 
	478, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 478, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 498, 498, 498, 498, 
	498, 498, 498, 498, 498, 498, 486, 486, 
	486, 486, 486, 486, 486, 498, 498, 498, 
	498, 498, 498, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 498, 498, 498, 
	498, 498, 498, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 486, 486, 486, 486, 486, 486, 486, 
	486, 488, 486, 499, 478, 483, 483, 483, 
	478, 483, 483, 483, 483, 489, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 478, 483, 
	483, 483, 483, 483, 489, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 494, 494, 494, 494, 
	494, 494, 494, 494, 494, 494, 483, 483, 
	483, 483, 483, 483, 483, 494, 494, 494, 
	494, 494, 494, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 494, 494, 494, 
	494, 494, 494, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 483, 483, 483, 483, 483, 483, 483, 
	483, 491, 483, 500, 502, 502, 502, 502, 
	502, 502, 502, 502, 502, 502, 501, 501, 
	501, 501, 501, 501, 501, 502, 502, 502, 
	502, 502, 502, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 501, 501, 501, 
	501, 501, 501, 501, 501, 502, 502, 502, 
	502, 502, 502, 501, 501, 504, 503, 503, 
	503, 504, 503, 503, 503, 503, 505, 506, 
	505, 505, 505, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 504, 
	503, 503, 503, 503, 503, 505, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 503, 503, 503, 503, 503, 503, 503, 
	503, 507, 503, 505, 508, 505, 505, 505, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 508, 508, 508, 508, 508, 508, 
	508, 508, 505, 508, 509, 510, 510, 510, 
	509, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 510, 510, 
	510, 510, 510, 510, 510, 510, 509, 510, 
	512, 511, 511, 511, 512, 511, 511, 511, 
	511, 511, 513, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 512, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 511, 511, 511, 511, 
	511, 511, 511, 511, 514, 511, 515, 516, 
	516, 516, 515, 516, 516, 516, 516, 516, 
	517, 516, 516, 516, 516, 516, 516, 516, 
	516, 516, 516, 516, 516, 516, 516, 516, 
	515, 516, 519, 518, 518, 518, 519, 518, 
	518, 518, 518, 518, 520, 518, 518, 518, 
	518, 518, 518, 518, 518, 518, 518, 518, 
	518, 518, 518, 518, 519, 518, 518, 518, 
	518, 518, 518, 518, 518, 521, 518, 523, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 524, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 522, 522, 
	522, 522, 522, 522, 522, 522, 525, 522, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	526, 526, 526, 526, 526, 526, 526, 526, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 526, 526, 526, 526, 526, 526, 
	526, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 526, 526, 526, 526, 75, 
	526, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 75, 75, 75, 75, 75, 
	75, 75, 75, 526, 526, 526, 526, 526, 
	75, 78, 78, 78, 78, 78, 78, 78, 
	78, 78, 78, 526, 528, 527, 527, 527, 
	528, 527, 527, 527, 527, 527, 529, 527, 
	527, 527, 527, 527, 527, 527, 527, 527, 
	527, 527, 527, 527, 527, 527, 528, 527, 
	531, 530, 530, 530, 531, 530, 530, 530, 
	530, 532, 533, 532, 532, 532, 530, 530, 
	530, 530, 530, 530, 530, 530, 530, 530, 
	530, 530, 531, 530, 530, 530, 530, 530, 
	532, 530, 530, 534, 530, 532, 535, 532, 
	532, 532, 535, 535, 535, 535, 535, 535, 
	535, 535, 535, 535, 535, 535, 535, 535, 
	535, 535, 535, 535, 532, 535, 537, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 538, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 536, 536, 536, 
	536, 536, 536, 536, 536, 539, 536, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 540, 
	540, 540, 540, 540, 540, 540, 540, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 540, 540, 540, 540, 540, 540, 540, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 540, 540, 540, 540, 81, 540, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 81, 81, 81, 81, 81, 81, 
	81, 81, 540, 540, 540, 540, 540, 81, 
	84, 84, 84, 84, 84, 84, 84, 84, 
	84, 84, 540, 542, 541, 541, 541, 542, 
	541, 541, 541, 541, 543, 544, 543, 543, 
	543, 541, 541, 541, 541, 541, 541, 541, 
	541, 541, 541, 541, 541, 542, 541, 541, 
	541, 541, 541, 543, 541, 543, 545, 543, 
	543, 543, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 545, 545, 545, 545, 
	545, 545, 545, 545, 543, 545, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	546, 546, 546, 546, 546, 546, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	546, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 548, 548, 548, 548, 548, 
	548, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 547, 547, 547, 547, 547, 
	547, 547, 547, 548, 549, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	88, 88, 88, 88, 88, 88, 88, 88, 
	550, 88, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 551, 551, 551, 551, 551, 551, 
	551, 551, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 551, 551, 551, 551, 
	551, 551, 551, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 551, 551, 551, 
	551, 86, 551, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 86, 86, 86, 
	86, 86, 86, 86, 86, 551, 551, 551, 
	551, 551, 86, 90, 90, 90, 90, 90, 
	90, 90, 90, 90, 90, 551, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 552, 552, 
	552, 552, 552, 552, 552, 552, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	552, 552, 552, 552, 552, 552, 552, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 552, 552, 552, 552, 91, 552, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 91, 91, 91, 91, 91, 91, 91, 
	91, 552, 552, 552, 552, 552, 91, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 553, 
	553, 553, 553, 553, 553, 553, 553, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 553, 553, 553, 553, 553, 553, 553, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 553, 553, 553, 553, 93, 553, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 93, 93, 93, 93, 93, 93, 
	93, 93, 553, 553, 553, 553, 553, 93, 
	555, 556, 556, 556, 555, 556, 556, 556, 
	556, 557, 558, 557, 557, 557, 556, 556, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 555, 556, 556, 556, 556, 556, 
	557, 559, 556, 560, 561, 562, 563, 556, 
	556, 556, 564, 565, 556, 565, 556, 566, 
	556, 556, 556, 556, 556, 556, 556, 556, 
	556, 556, 567, 556, 568, 569, 570, 556, 
	556, 571, 572, 571, 571, 573, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 574, 575, 556, 566, 576, 
	566, 577, 578, 579, 580, 581, 582, 554, 
	554, 583, 554, 554, 554, 584, 585, 586, 
	554, 554, 587, 588, 589, 590, 554, 591, 
	554, 592, 554, 556, 593, 556, 565, 556, 
	554, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 595, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 594, 594, 594, 595, 594, 
	595, 594, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 594, 594, 594, 594, 
	554, 594, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 594, 594, 594, 594, 
	594, 554, 557, 596, 557, 557, 557, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 596, 596, 596, 596, 596, 596, 596, 
	596, 557, 596, 597, 566, 598, 598, 566, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 598, 598, 598, 
	598, 598, 598, 598, 598, 566, 598, 599, 
	600, 601, 602, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 95, 95, 603, 95, 
	603, 95, 95, 603, 603, 95, 95, 95, 
	605, 95, 95, 606, 606, 606, 606, 606, 
	606, 606, 606, 606, 606, 95, 95, 95, 
	95, 95, 95, 95, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 603, 95, 
	603, 603, 604, 95, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 603, 603, 
	603, 95, 603, 604, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 607, 607, 607, 607, 
	607, 607, 607, 607, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 607, 607, 
	607, 607, 607, 607, 607, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 607, 
	607, 607, 607, 604, 607, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 604, 
	604, 604, 604, 604, 604, 604, 604, 607, 
	607, 607, 607, 607, 604, 606, 606, 606, 
	606, 606, 606, 606, 606, 606, 606, 607, 
	608, 598, 566, 598, 566, 598, 566, 598, 
	610, 609, 566, 611, 598, 566, 598, 612, 
	566, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	603, 603, 603, 603, 603, 603, 603, 603, 
	566, 603, 566, 598, 566, 566, 598, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 594, 
	595, 594, 594, 594, 594, 594, 594, 594, 
	594, 594, 594, 594, 594, 594, 594, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 594, 594, 594, 595, 594, 595, 594, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 594, 594, 594, 594, 571, 594, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 594, 594, 594, 594, 594, 571, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 595, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 613, 613, 613, 595, 613, 595, 
	613, 571, 571, 571, 571, 614, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 613, 613, 613, 613, 571, 
	613, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 613, 613, 613, 613, 613, 
	571, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 595, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 613, 613, 613, 595, 613, 
	595, 613, 571, 571, 571, 571, 571, 571, 
	615, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 613, 613, 613, 613, 
	571, 613, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 613, 613, 613, 613, 
	613, 571, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 595, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 613, 613, 613, 595, 
	613, 595, 613, 571, 571, 571, 571, 571, 
	571, 571, 571, 616, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 613, 613, 613, 
	613, 571, 613, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 613, 613, 613, 
	613, 613, 571, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 595, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 613, 613, 613, 
	595, 613, 595, 613, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 617, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 613, 613, 
	613, 613, 571, 613, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 613, 613, 
	613, 613, 613, 571, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 595, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 613, 613, 
	613, 595, 613, 595, 613, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 618, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 613, 
	613, 613, 613, 571, 613, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 613, 
	613, 613, 613, 613, 571, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 613, 595, 613, 
	613, 613, 613, 613, 613, 613, 613, 613, 
	613, 613, 613, 613, 613, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 613, 
	613, 613, 595, 613, 595, 613, 571, 571, 
	571, 617, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	613, 613, 613, 613, 571, 613, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	571, 571, 571, 571, 571, 571, 571, 571, 
	613, 613, 613, 613, 613, 571, 612, 603, 
	558, 603, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 620, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	621, 622, 554, 554, 554, 554, 554, 623, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 624, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	625, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 626, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 627, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 628, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 629, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 630, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 631, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 632, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 633, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 634, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 630, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 635, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 634, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 636, 554, 
	637, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 638, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 639, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	632, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 632, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 640, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 641, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 642, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 643, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	632, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	644, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 645, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	632, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 646, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 647, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 648, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 632, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 649, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 639, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	650, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 632, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 651, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 652, 652, 652, 
	652, 652, 652, 652, 652, 652, 652, 652, 
	652, 652, 652, 652, 652, 652, 652, 652, 
	652, 652, 652, 652, 652, 652, 652, 652, 
	652, 652, 652, 652, 652, 652, 595, 652, 
	652, 652, 652, 652, 652, 652, 652, 652, 
	652, 652, 652, 652, 652, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 652, 
	652, 652, 595, 652, 595, 652, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	652, 652, 652, 652, 554, 652, 554, 554, 
	554, 554, 554, 554, 554, 554, 653, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	652, 652, 652, 652, 652, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 654, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 655, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 656, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	657, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 658, 554, 
	659, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 660, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 632, 554, 554, 554, 661, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 632, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 632, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 662, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 663, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 648, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 664, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	586, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 646, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 632, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 632, 554, 554, 554, 554, 554, 
	554, 554, 632, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 665, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 666, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 667, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 648, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 668, 554, 
	554, 554, 669, 554, 554, 554, 554, 554, 
	670, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 670, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 632, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	632, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 671, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 672, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 673, 674, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 632, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 675, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 648, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 676, 554, 554, 677, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 632, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 643, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 678, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 679, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 661, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 680, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 586, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 554, 554, 
	554, 681, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 675, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 643, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 682, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	683, 554, 554, 554, 554, 554, 554, 554, 
	684, 554, 554, 554, 554, 554, 554, 554, 
	685, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 595, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 595, 619, 595, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 554, 619, 554, 554, 
	554, 554, 661, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 619, 619, 554, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 595, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	619, 619, 619, 595, 619, 595, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 554, 619, 554, 
	554, 554, 554, 649, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 619, 619, 554, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	595, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 619, 619, 619, 595, 619, 595, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 554, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	669, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 619, 619, 554, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 595, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 619, 619, 619, 595, 619, 595, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 554, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	686, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 619, 619, 
	554, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 595, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 619, 619, 619, 595, 619, 
	595, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	554, 619, 554, 554, 554, 554, 643, 554, 
	554, 554, 667, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 619, 
	619, 554, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 595, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 619, 619, 619, 595, 
	619, 595, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 554, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 687, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	619, 619, 554, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 595, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 619, 619, 619, 
	595, 619, 595, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 554, 619, 554, 554, 554, 554, 
	688, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 619, 619, 554, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 619, 595, 619, 619, 
	619, 619, 619, 619, 619, 619, 619, 619, 
	619, 619, 619, 619, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 619, 619, 
	619, 595, 619, 595, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 554, 619, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 554, 
	637, 554, 554, 554, 554, 554, 554, 554, 
	554, 554, 554, 554, 554, 554, 554, 619, 
	619, 619, 619, 619, 554, 566, 598, 690, 
	691, 691, 691, 690, 691, 691, 691, 691, 
	692, 691, 692, 692, 692, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 690, 691, 691, 691, 691, 691, 692, 
	691, 691, 693, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	691, 691, 691, 691, 691, 691, 691, 691, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 691, 694, 691, 691, 689, 691, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 689, 689, 689, 689, 689, 689, 
	689, 689, 691, 691, 691, 691, 691, 689, 
	695, 695, 695, 695, 695, 695, 695, 695, 
	695, 695, 695, 695, 695, 695, 695, 695, 
	695, 695, 695, 695, 695, 695, 695, 695, 
	695, 695, 695, 695, 695, 695, 695, 695, 
	695, 100, 695, 695, 695, 695, 695, 695, 
	695, 695, 695, 695, 695, 695, 695, 695, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 101, 695, 695, 695, 695, 100, 
	695, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 695, 695, 695, 695, 99, 
	695, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 99, 99, 99, 99, 99, 
	99, 99, 99, 695, 695, 695, 695, 695, 
	99, 692, 696, 692, 692, 692, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	696, 696, 696, 696, 696, 696, 696, 696, 
	692, 696, 697, 698, 699, 700, 701, 695, 
	702, 704, 705, 705, 705, 704, 705, 705, 
	705, 705, 706, 707, 706, 706, 706, 705, 
	705, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 704, 705, 705, 705, 705, 
	705, 706, 708, 705, 709, 705, 710, 711, 
	705, 705, 705, 712, 713, 705, 713, 705, 
	710, 705, 705, 705, 705, 705, 705, 705, 
	705, 705, 705, 705, 705, 714, 715, 716, 
	705, 705, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 718, 719, 705, 710, 
	703, 710, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 705, 720, 705, 713, 
	705, 703, 721, 721, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 721, 721, 
	721, 721, 721, 722, 721, 721, 721, 721, 
	721, 721, 721, 721, 721, 721, 721, 721, 
	721, 721, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 721, 721, 721, 721, 
	721, 722, 721, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 721, 721, 721, 
	721, 703, 721, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 703, 703, 703, 
	703, 703, 703, 703, 703, 721, 721, 721, 
	721, 721, 703, 724, 723, 725, 706, 726, 
	706, 706, 706, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 726, 726, 726, 
	726, 726, 726, 726, 726, 706, 726, 727, 
	710, 728, 728, 710, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 728, 728, 728, 728, 728, 728, 728, 
	728, 710, 728, 729, 730, 731, 732, 710, 
	728, 710, 728, 710, 728, 710, 733, 728, 
	710, 728, 735, 710, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 734, 734, 734, 734, 734, 
	734, 734, 734, 710, 734, 710, 728, 710, 
	710, 728, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 736, 722, 736, 736, 736, 736, 
	736, 736, 736, 736, 736, 736, 736, 736, 
	736, 736, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 736, 736, 736, 736, 
	736, 722, 736, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 736, 736, 736, 
	736, 717, 736, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 717, 717, 717, 
	717, 717, 717, 717, 717, 736, 736, 736, 
	736, 736, 717, 735, 734, 707, 734, 710, 
	728, 738, 737, 737, 737, 738, 737, 737, 
	737, 737, 739, 740, 739, 739, 739, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 738, 737, 737, 737, 737, 
	737, 739, 737, 737, 741, 737, 109, 742, 
	737, 743, 737, 744, 109, 140, 745, 142, 
	109, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 746, 737, 747, 140, 748, 
	749, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 737, 737, 140, 750, 140, 109, 
	737, 737, 737, 737, 737, 737, 737, 737, 
	737, 737, 751, 737, 737, 737, 737, 737, 
	737, 737, 737, 752, 737, 737, 753, 737, 
	754, 737, 737, 737, 153, 154, 737, 109, 
	737, 755, 755, 755, 755, 755, 755, 755, 
	755, 755, 739, 755, 739, 739, 739, 755, 
	755, 755, 755, 755, 755, 755, 755, 755, 
	755, 755, 755, 755, 755, 755, 755, 755, 
	755, 739, 755, 755, 755, 755, 135, 136, 
	755, 137, 755, 138, 139, 140, 141, 142, 
	135, 755, 755, 755, 755, 755, 755, 755, 
	755, 755, 755, 143, 755, 144, 140, 145, 
	146, 755, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 147, 148, 140, 109, 
	104, 755, 104, 104, 104, 104, 104, 104, 
	104, 104, 149, 104, 104, 104, 104, 104, 
	104, 104, 104, 150, 104, 104, 151, 104, 
	152, 104, 104, 104, 153, 154, 755, 109, 
	755, 104, 756, 757, 757, 757, 756, 757, 
	757, 757, 757, 140, 758, 140, 140, 140, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 756, 757, 757, 757, 
	757, 757, 140, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 757, 
	757, 757, 757, 757, 757, 757, 757, 140, 
	757, 140, 758, 140, 140, 140, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	140, 103, 103, 103, 103, 103, 109, 103, 
	103, 103, 103, 103, 103, 103, 140, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 140, 103, 140, 
	758, 140, 140, 140, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 140, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 140, 103, 759, 140, 758, 
	140, 140, 140, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 140, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 761, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 760, 760, 760, 760, 760, 760, 760, 
	760, 760, 140, 760, 140, 758, 140, 140, 
	140, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 140, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	103, 103, 103, 103, 103, 103, 103, 103, 
	140, 140, 103, 762, 756, 140, 756, 764, 
	763, 766, 767, 766, 766, 766, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	766, 765, 768, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 105, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 106, 756, 756, 
	756, 756, 105, 756, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 756, 756, 
	756, 756, 104, 756, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 104, 104, 
	104, 104, 104, 104, 104, 104, 756, 756, 
	756, 756, 756, 104, 769, 140, 758, 140, 
	140, 140, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 140, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 140, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	109, 756, 770, 771, 772, 773, 774, 775, 
	140, 758, 140, 140, 140, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 140, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 109, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 756, 756, 756, 756, 
	756, 756, 756, 756, 140, 756, 140, 763, 
	109, 776, 109, 776, 777, 778, 777, 777, 
	777, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 765, 765, 765, 765, 765, 
	765, 765, 765, 777, 765, 779, 776, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	112, 780, 112, 112, 112, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 780, 780, 780, 780, 780, 780, 112, 
	780, 780, 780, 780, 113, 114, 780, 115, 
	780, 116, 117, 118, 119, 120, 113, 780, 
	780, 780, 780, 780, 780, 780, 780, 780, 
	780, 121, 780, 122, 118, 123, 124, 780, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	111, 111, 125, 126, 118, 127, 111, 780, 
	111, 111, 111, 111, 111, 111, 111, 111, 
	128, 111, 111, 111, 111, 111, 111, 111, 
	111, 129, 111, 111, 130, 111, 131, 111, 
	111, 111, 132, 133, 780, 127, 780, 111, 
	140, 776, 781, 776, 782, 776, 783, 776, 
	784, 179, 179, 179, 784, 179, 179, 179, 
	179, 785, 179, 785, 785, 785, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 784, 179, 179, 179, 179, 179, 
	785, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 179, 179, 179, 179, 179, 179, 179, 
	179, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 179, 786, 179, 179, 181, 
	179, 181, 181, 181, 185, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 179, 179, 179, 179, 179, 
	181, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 178, 787, 178, 178, 178, 178, 178, 
	178, 178, 178, 178, 178, 178, 178, 178, 
	178, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 179, 178, 178, 178, 178, 
	787, 178, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 178, 178, 178, 178, 
	181, 178, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 178, 178, 178, 178, 
	178, 181, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 182, 788, 182, 182, 182, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 182, 788, 788, 788, 788, 788, 
	788, 788, 183, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 788, 184, 788, 
	788, 181, 788, 181, 181, 181, 185, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 788, 788, 788, 
	788, 788, 181, 789, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 788, 787, 788, 788, 
	788, 788, 788, 788, 788, 788, 788, 788, 
	788, 788, 788, 788, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 179, 788, 
	788, 788, 788, 787, 788, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 788, 
	788, 788, 788, 181, 788, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 181, 
	181, 181, 181, 790, 181, 181, 181, 181, 
	181, 181, 181, 181, 181, 181, 181, 788, 
	788, 788, 788, 788, 181, 186, 788, 792, 
	791, 791, 791, 792, 791, 791, 791, 791, 
	793, 791, 793, 793, 793, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 792, 791, 791, 791, 791, 791, 793, 
	791, 791, 794, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 795, 791, 791, 791, 791, 
	791, 791, 791, 796, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 791, 791, 791, 791, 791, 791, 
	791, 791, 797, 791, 793, 798, 793, 793, 
	793, 798, 798, 798, 798, 798, 798, 798, 
	798, 798, 798, 798, 798, 798, 798, 798, 
	798, 798, 798, 793, 798, 799, 800, 801, 
	802, 804, 803, 805, 806, 803, 807, 809, 
	810, 810, 810, 809, 810, 810, 810, 810, 
	811, 812, 811, 811, 811, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 809, 810, 810, 810, 810, 810, 811, 
	810, 810, 813, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	810, 810, 810, 810, 810, 810, 810, 810, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 810, 814, 810, 810, 808, 810, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	815, 808, 808, 808, 808, 808, 808, 808, 
	808, 816, 808, 808, 817, 808, 818, 808, 
	808, 808, 810, 810, 810, 810, 810, 808, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	819, 819, 819, 819, 819, 819, 819, 819, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 819, 819, 819, 819, 819, 819, 
	819, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 819, 819, 819, 819, 808, 
	819, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 819, 819, 819, 819, 819, 
	808, 811, 820, 811, 811, 811, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	820, 820, 820, 820, 820, 820, 820, 820, 
	811, 820, 821, 822, 823, 824, 825, 827, 
	826, 828, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	829, 829, 829, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 808, 829, 808, 808, 808, 808, 808, 
	830, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 829, 808, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 829, 829, 829, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 808, 829, 808, 808, 808, 808, 
	831, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 829, 808, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 829, 829, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 808, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 832, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 829, 808, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 829, 829, 829, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 808, 829, 808, 808, 
	833, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 829, 808, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 829, 829, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 808, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 834, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 829, 808, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 829, 829, 829, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 808, 829, 
	808, 808, 808, 808, 830, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 829, 808, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 829, 829, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 808, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 835, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 829, 
	808, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 829, 
	829, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	808, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 836, 808, 808, 
	808, 808, 808, 808, 808, 837, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	829, 808, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	829, 829, 829, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 808, 829, 808, 808, 808, 808, 838, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 829, 808, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 829, 829, 829, 
	829, 829, 829, 829, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 808, 829, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 839, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 829, 808, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 829, 829, 
	829, 829, 829, 829, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 808, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 830, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 829, 808, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 829, 
	829, 829, 829, 829, 829, 829, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 808, 829, 808, 808, 
	808, 808, 808, 808, 808, 808, 840, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 829, 808, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	829, 829, 829, 829, 829, 829, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 808, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 830, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 829, 808, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 829, 829, 829, 829, 829, 829, 829, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 808, 829, 
	808, 808, 808, 808, 808, 808, 808, 841, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 829, 808, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 829, 829, 829, 829, 829, 829, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 808, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 842, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 829, 
	808, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 829, 829, 829, 829, 829, 829, 829, 
	829, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 829, 829, 829, 829, 829, 
	829, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	808, 829, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 808, 834, 808, 808, 
	808, 808, 808, 808, 808, 808, 808, 808, 
	808, 808, 808, 808, 829, 829, 829, 829, 
	829, 808, 844, 203, 203, 203, 844, 203, 
	203, 203, 203, 845, 846, 845, 845, 845, 
	203, 203, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 844, 203, 203, 203, 
	203, 203, 845, 847, 203, 848, 203, 849, 
	850, 203, 851, 203, 852, 853, 203, 854, 
	855, 856, 203, 203, 203, 203, 203, 203, 
	203, 203, 203, 203, 857, 203, 858, 859, 
	860, 861, 203, 862, 863, 862, 862, 864, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 862, 862, 862, 
	862, 862, 862, 862, 862, 865, 866, 203, 
	867, 868, 203, 869, 870, 871, 872, 873, 
	874, 843, 843, 875, 843, 843, 843, 876, 
	877, 878, 843, 843, 879, 880, 881, 882, 
	843, 883, 843, 884, 843, 885, 886, 203, 
	867, 203, 843, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 271, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 192, 192, 
	273, 192, 271, 192, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 192, 192, 
	192, 192, 843, 192, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 192, 192, 
	192, 192, 192, 843, 888, 887, 887, 889, 
	887, 890, 892, 893, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 894, 891, 896, 895, 897, 
	898, 899, 845, 900, 845, 845, 845, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 900, 900, 900, 900, 900, 900, 900, 
	900, 845, 900, 902, 901, 904, 905, 904, 
	904, 904, 903, 903, 903, 903, 903, 903, 
	903, 903, 903, 903, 903, 903, 903, 903, 
	903, 903, 903, 903, 904, 903, 203, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 203, 
	906, 907, 908, 909, 910, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 912, 
	912, 912, 912, 912, 912, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 913, 
	913, 913, 913, 913, 913, 913, 913, 912, 
	914, 201, 201, 201, 914, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 914, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 201, 201, 201, 201, 201, 201, 201, 
	201, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 201, 201, 201, 201, 201, 
	201, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 202, 202, 202, 202, 202, 
	202, 202, 202, 201, 916, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 203, 915, 917, 919, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 918, 918, 918, 918, 918, 918, 918, 
	918, 203, 918, 203, 192, 204, 205, 204, 
	204, 204, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 204, 915, 915, 206, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 207, 207, 207, 207, 
	207, 207, 207, 207, 207, 207, 915, 915, 
	915, 203, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	208, 915, 221, 222, 221, 221, 221, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 221, 220, 220, 223, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 224, 224, 224, 224, 224, 224, 224, 
	224, 224, 224, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 220, 220, 220, 
	220, 220, 220, 220, 220, 225, 220, 204, 
	205, 204, 204, 204, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 204, 915, 
	915, 206, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 207, 207, 
	207, 207, 207, 207, 207, 207, 207, 207, 
	915, 915, 915, 203, 203, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 915, 915, 915, 915, 915, 915, 
	915, 915, 208, 915, 921, 906, 203, 906, 
	906, 922, 922, 922, 906, 922, 922, 922, 
	922, 922, 922, 922, 922, 922, 922, 922, 
	922, 922, 922, 922, 922, 922, 922, 922, 
	922, 922, 906, 922, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 924, 925, 906, 
	926, 229, 927, 925, 906, 906, 928, 929, 
	906, 929, 906, 229, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 930, 906, 
	931, 932, 933, 906, 934, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 935, 
	906, 906, 229, 923, 229, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 906, 
	936, 906, 929, 906, 923, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 938, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 937, 
	937, 937, 939, 937, 938, 937, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	937, 937, 937, 937, 923, 937, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	923, 923, 923, 923, 923, 923, 923, 923, 
	937, 937, 937, 937, 937, 923, 941, 940, 
	942, 944, 945, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 943, 943, 943, 943, 943, 943, 
	943, 943, 946, 943, 948, 949, 947, 950, 
	951, 952, 953, 229, 937, 937, 229, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 229, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 937, 937, 
	937, 937, 937, 937, 937, 937, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	937, 937, 937, 937, 937, 937, 937, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 937, 937, 937, 937, 228, 937, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 937, 937, 937, 937, 937, 228, 231, 
	231, 231, 231, 231, 231, 231, 231, 231, 
	231, 937, 229, 937, 229, 937, 229, 937, 
	229, 954, 937, 229, 937, 229, 937, 229, 
	229, 937, 229, 937, 955, 956, 906, 957, 
	203, 906, 867, 203, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 203, 906, 203, 916, 906, 
	960, 959, 959, 959, 960, 959, 959, 959, 
	959, 961, 962, 961, 961, 961, 959, 959, 
	959, 959, 959, 959, 959, 959, 959, 959, 
	959, 959, 960, 959, 959, 959, 959, 959, 
	961, 959, 959, 959, 959, 959, 959, 959, 
	959, 959, 959, 959, 959, 959, 959, 959, 
	959, 959, 959, 959, 959, 959, 959, 959, 
	959, 959, 959, 959, 959, 959, 959, 959, 
	959, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 959, 964, 959, 959, 963, 
	959, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 963, 963, 963, 963, 963, 
	963, 963, 963, 959, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 965, 965, 
	965, 965, 965, 965, 965, 965, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	965, 965, 965, 965, 966, 965, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	966, 966, 966, 966, 966, 966, 966, 966, 
	965, 965, 965, 965, 965, 966, 967, 967, 
	967, 967, 967, 967, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 967, 967, 
	967, 967, 967, 967, 967, 967, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	967, 967, 967, 967, 967, 967, 967, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 967, 967, 967, 967, 968, 967, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 968, 968, 968, 968, 968, 968, 968, 
	968, 967, 967, 967, 967, 967, 968, 971, 
	970, 970, 970, 971, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 971, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 972, 
	972, 972, 972, 972, 972, 972, 972, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 973, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 974, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 975, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 970, 970, 970, 970, 
	970, 970, 970, 970, 976, 970, 970, 977, 
	970, 978, 979, 981, 981, 981, 981, 981, 
	981, 981, 981, 980, 982, 982, 982, 982, 
	982, 982, 982, 982, 980, 980, 983, 983, 
	265, 265, 265, 983, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 983, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 266, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 984, 265, 985, 986, 987, 
	987, 265, 265, 265, 987, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 987, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 266, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 265, 265, 265, 265, 
	265, 265, 265, 265, 988, 265, 264, 987, 
	989, 990, 991, 991, 252, 252, 252, 991, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 991, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 253, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 992, 
	252, 987, 246, 246, 246, 987, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 987, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 993, 246, 
	983, 252, 252, 252, 983, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 983, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 253, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 254, 252, 983, 994, 
	994, 994, 983, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	983, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 995, 994, 996, 997, 997, 994, 
	994, 994, 997, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	997, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 994, 994, 994, 994, 994, 994, 
	994, 994, 998, 994, 997, 246, 246, 246, 
	997, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 997, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 993, 246, 999, 997, 997, 252, 252, 
	252, 997, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 997, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 253, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 252, 252, 252, 252, 252, 252, 252, 
	252, 254, 252, 1000, 1001, 1001, 1001, 1000, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1000, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1002, 1002, 1002, 1002, 1002, 
	1002, 1002, 1002, 1002, 1002, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1002, 1002, 1002, 1002, 
	1002, 1002, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1002, 1002, 1002, 1002, 
	1002, 1002, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1001, 1001, 1001, 1001, 1003, 1001, 
	1000, 1004, 1004, 1004, 1000, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1000, 1004, 1000, 1005, 1005, 1005, 
	1000, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1000, 1005, 
	1000, 1006, 1006, 1006, 1000, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1000, 1006, 1000, 1000, 1004, 1004, 
	1004, 1000, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1000, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1007, 1007, 1007, 
	1007, 1007, 1007, 1007, 1007, 1007, 1007, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1007, 1007, 
	1007, 1007, 1007, 1007, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1004, 1004, 
	1004, 1004, 1004, 1004, 1004, 1004, 1007, 1007, 
	1007, 1007, 1007, 1007, 1004, 1000, 1005, 1005, 
	1005, 1000, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1000, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1008, 1008, 1008, 
	1008, 1008, 1008, 1008, 1008, 1008, 1008, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1008, 1008, 
	1008, 1008, 1008, 1008, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1005, 1005, 
	1005, 1005, 1005, 1005, 1005, 1005, 1008, 1008, 
	1008, 1008, 1008, 1008, 1005, 1000, 1006, 1006, 
	1006, 1000, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1000, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1009, 1009, 1009, 
	1009, 1009, 1009, 1009, 1009, 1009, 1009, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1009, 1009, 
	1009, 1009, 1009, 1009, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1009, 1009, 
	1009, 1009, 1009, 1009, 1006, 1010, 1013, 1012, 
	1012, 1012, 1013, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1013, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1014, 1014, 
	1014, 1014, 1014, 1014, 1014, 1014, 1014, 1014, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1014, 
	1014, 1014, 1014, 1014, 1014, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1014, 
	1014, 1014, 1014, 1014, 1014, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1012, 1012, 1012, 1012, 1012, 
	1012, 1012, 1012, 1004, 1012, 1013, 1015, 1015, 
	1015, 1013, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1013, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1016, 1016, 1016, 
	1016, 1016, 1016, 1016, 1016, 1016, 1016, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1016, 1016, 
	1016, 1016, 1016, 1016, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1016, 1016, 
	1016, 1016, 1016, 1016, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1017, 1015, 1013, 1018, 1018, 1018, 
	1013, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1013, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1019, 1019, 1019, 
	1019, 1019, 1019, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1019, 1019, 1019, 
	1019, 1019, 1019, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1020, 1018, 1013, 1021, 1021, 1021, 1013, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1013, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022, 
	1022, 1022, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1022, 1022, 1022, 1022, 
	1022, 1022, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1013, 1021, 1013, 1021, 1021, 1021, 1013, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1013, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022, 
	1022, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1022, 1022, 1022, 1022, 1022, 
	1022, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1013, 
	1021, 1023, 1013, 1022, 1022, 1022, 1013, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1013, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1023, 
	1022, 1013, 1022, 1022, 1022, 1013, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1013, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1022, 1022, 
	1022, 1022, 1022, 1022, 1022, 1022, 1011, 1022, 
	1011, 1013, 1019, 1019, 1019, 1013, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1013, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1019, 1019, 
	1019, 1019, 1019, 1019, 1019, 1019, 1006, 1019, 
	1011, 1006, 1006, 1006, 1011, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1006, 1006, 1006, 1006, 1006, 1006, 
	1006, 1006, 1011, 1006, 1013, 1015, 1015, 1015, 
	1013, 1015, 1015, 1015, 1015, 1024, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1013, 1015, 
	1015, 1015, 1015, 1015, 1024, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1025, 1025, 1025, 1025, 
	1025, 1025, 1025, 1025, 1025, 1025, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1025, 1025, 1025, 
	1025, 1025, 1025, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1025, 1025, 1025, 
	1025, 1025, 1025, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1015, 1015, 1015, 1015, 1015, 1015, 1015, 
	1015, 1026, 1015, 1013, 1021, 1021, 1021, 1013, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1013, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1027, 1027, 1027, 1027, 1027, 
	1027, 1027, 1027, 1027, 1027, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1027, 1027, 1027, 1027, 
	1027, 1027, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1027, 1027, 1027, 1027, 
	1027, 1027, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1013, 1021, 1013, 1021, 1021, 1021, 1013, 1021, 
	1021, 1021, 1021, 1024, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1013, 1021, 1021, 1021, 
	1021, 1021, 1024, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1028, 1028, 1028, 1028, 1028, 1028, 
	1028, 1028, 1028, 1028, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1028, 1028, 1028, 1028, 1028, 
	1028, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1028, 1028, 1028, 1028, 1028, 
	1028, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1023, 
	1021, 1013, 1021, 1021, 1021, 1013, 1021, 1021, 
	1021, 1021, 1024, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1013, 1021, 1021, 1021, 1021, 
	1021, 1024, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1029, 1029, 1029, 1029, 1029, 1029, 1029, 
	1029, 1029, 1029, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1029, 1029, 1029, 1029, 1029, 1029, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1029, 1029, 1029, 1029, 1029, 1029, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1023, 1021, 
	1013, 1021, 1021, 1021, 1013, 1021, 1021, 1021, 
	1021, 1024, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1013, 1021, 1021, 1021, 1021, 1021, 
	1024, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1030, 1030, 1030, 1030, 1030, 1030, 1030, 1030, 
	1030, 1030, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1030, 1030, 1030, 1030, 1030, 1030, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1030, 1030, 1030, 1030, 1030, 1030, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1023, 1021, 1013, 
	1021, 1021, 1021, 1013, 1021, 1021, 1021, 1021, 
	1024, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1013, 1021, 1021, 1021, 1021, 1021, 1024, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1031, 
	1031, 1031, 1031, 1031, 1031, 1031, 1031, 1031, 
	1031, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1031, 1031, 1031, 1031, 1031, 1031, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1031, 1031, 1031, 1031, 1031, 1031, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1023, 1021, 1013, 1021, 
	1021, 1021, 1013, 1021, 1021, 1021, 1021, 1024, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1013, 1021, 1021, 1021, 1021, 1021, 1024, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1032, 1032, 
	1032, 1032, 1032, 1032, 1032, 1032, 1032, 1032, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1032, 
	1032, 1032, 1032, 1032, 1032, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1032, 
	1032, 1032, 1032, 1032, 1032, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1023, 1021, 1013, 1021, 1021, 
	1021, 1013, 1021, 1021, 1021, 1021, 1024, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1013, 
	1021, 1021, 1021, 1021, 1021, 1024, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1033, 1033, 
	1033, 1033, 1033, 1033, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1033, 1033, 
	1033, 1033, 1033, 1033, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1023, 1021, 1013, 1021, 1021, 1021, 
	1013, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1013, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1033, 1033, 1033, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1033, 1033, 1033, 
	1033, 1033, 1033, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1033, 1033, 1033, 
	1033, 1033, 1033, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1023, 1021, 1013, 1018, 1018, 1018, 1013, 
	1018, 1018, 1018, 1018, 1024, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1013, 1018, 1018, 
	1018, 1018, 1018, 1024, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1034, 1034, 1034, 1034, 1034, 
	1034, 1034, 1034, 1034, 1034, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1034, 1034, 1034, 1034, 
	1034, 1034, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1034, 1034, 1034, 1034, 
	1034, 1034, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1018, 1018, 1018, 1018, 1018, 1018, 1018, 1018, 
	1026, 1018, 1013, 1021, 1021, 1021, 1013, 1021, 
	1021, 1021, 1021, 1024, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1013, 1021, 1021, 1021, 
	1021, 1021, 1024, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1035, 1035, 1035, 1035, 1035, 1035, 
	1035, 1035, 1035, 1035, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1035, 1035, 1035, 1035, 1035, 
	1035, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1035, 1035, 1035, 1035, 1035, 
	1035, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1026, 
	1021, 1013, 1021, 1021, 1021, 1013, 1021, 1021, 
	1021, 1021, 1024, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1013, 1021, 1021, 1021, 1021, 
	1021, 1024, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1036, 1036, 1036, 1036, 1036, 1036, 1036, 
	1036, 1036, 1036, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1036, 1036, 1036, 1036, 1036, 1036, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1036, 1036, 1036, 1036, 1036, 1036, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1026, 1021, 
	1013, 1021, 1021, 1021, 1013, 1021, 1021, 1021, 
	1021, 1024, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1013, 1021, 1021, 1021, 1021, 1021, 
	1024, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1037, 1037, 1037, 1037, 1037, 1037, 1037, 1037, 
	1037, 1037, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1037, 1037, 1037, 1037, 1037, 1037, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1037, 1037, 1037, 1037, 1037, 1037, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1026, 1021, 1013, 
	1021, 1021, 1021, 1013, 1021, 1021, 1021, 1021, 
	1024, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1013, 1021, 1021, 1021, 1021, 1021, 1024, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1033, 
	1033, 1033, 1033, 1033, 1033, 1033, 1033, 1033, 
	1033, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1033, 1033, 1033, 1033, 1033, 1033, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1033, 1033, 1033, 1033, 1033, 1033, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1021, 1021, 1021, 1021, 
	1021, 1021, 1021, 1021, 1026, 1021, 1038, 1039, 
	1041, 1041, 1041, 1041, 1041, 1041, 1041, 1041, 
	1041, 1041, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1041, 1041, 1041, 1041, 1041, 1041, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1040, 1040, 1040, 1040, 1040, 1040, 1040, 
	1040, 1041, 1041, 1041, 1041, 1041, 1041, 1040, 
	1040, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 192, 271, 192, 192, 192, 192, 192, 
	192, 192, 192, 192, 192, 192, 192, 192, 
	192, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 272, 192, 192, 273, 192, 
	271, 192, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 192, 192, 192, 192, 
	270, 192, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 192, 192, 192, 192, 
	192, 270, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 271, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 272, 906, 906, 273, 
	906, 271, 906, 270, 270, 270, 270, 1042, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 906, 906, 906, 
	906, 270, 906, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 906, 906, 906, 
	906, 906, 270, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 271, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 272, 906, 906, 
	273, 906, 271, 906, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 1043, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 906, 906, 
	906, 906, 270, 906, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 270, 270, 
	270, 270, 270, 270, 270, 270, 906, 906, 
	906, 906, 906, 270, 1044, 1045, 906, 901, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1047, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 1048, 1049, 
	843, 843, 843, 843, 843, 1050, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1051, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 1052, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1053, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 1054, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 1055, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1056, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 1057, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1058, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1059, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 1060, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1061, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 1057, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 1062, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1061, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1063, 843, 1064, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 1065, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 1066, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1059, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	1059, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 1067, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1068, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 843, 843, 1069, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1070, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1059, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 1071, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 1072, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1059, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 1073, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1074, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1075, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 1059, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	1076, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1066, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 1077, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1059, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 843, 
	1059, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1078, 
	843, 1079, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1080, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 1059, 843, 843, 843, 1077, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 1059, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1081, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1082, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1075, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 1083, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	878, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1073, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1059, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 1084, 843, 843, 843, 843, 843, 
	843, 843, 1059, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1085, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 1086, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1087, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1075, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 1088, 843, 
	843, 843, 1089, 843, 843, 843, 843, 843, 
	1090, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1090, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1059, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1059, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 1091, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 1092, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1093, 1094, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1059, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 1095, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1096, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 1097, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1100, 1098, 1098, 1098, 
	1098, 1098, 1098, 1098, 1098, 1098, 1098, 1098, 
	1098, 1098, 1098, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1101, 1098, 1098, 
	1102, 1098, 1100, 1098, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1098, 1098, 
	1098, 1098, 1099, 1098, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1099, 1099, 
	1099, 1099, 1099, 1099, 1099, 1099, 1098, 1098, 
	1098, 1098, 1098, 1099, 892, 1103, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 891, 891, 891, 
	891, 891, 891, 891, 891, 894, 891, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1104, 843, 843, 1105, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1059, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1070, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 1106, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1107, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1077, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1108, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 878, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 843, 843, 843, 1109, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1110, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 1070, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1075, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1111, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 1112, 843, 
	843, 843, 843, 843, 843, 843, 1113, 843, 
	843, 843, 843, 843, 843, 843, 1114, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	1077, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 1115, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1116, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1084, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1117, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 271, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 272, 1046, 1046, 273, 1046, 271, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 843, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1084, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1046, 1046, 1046, 1046, 1046, 
	843, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 271, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 272, 1046, 1046, 273, 1046, 
	271, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	843, 1046, 843, 843, 843, 843, 843, 843, 
	843, 1118, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 1046, 1046, 1046, 1046, 
	1046, 843, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 271, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 272, 1046, 1046, 273, 
	1046, 271, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 843, 1046, 843, 843, 843, 843, 1070, 
	843, 843, 843, 1119, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 1046, 1046, 1046, 
	1046, 1046, 843, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 271, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 272, 1046, 1046, 
	273, 1046, 271, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 843, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1120, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 1046, 1046, 
	1046, 1046, 1046, 843, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 271, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 272, 1046, 
	1046, 273, 1046, 271, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 843, 1046, 843, 843, 843, 
	843, 1084, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 1046, 
	1046, 1046, 1046, 1046, 843, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 271, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 272, 
	1046, 1046, 273, 1046, 271, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 843, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 1121, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	1046, 1046, 1046, 1046, 1046, 843, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 271, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	272, 1046, 1046, 273, 1046, 271, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 843, 1046, 843, 
	843, 843, 843, 1122, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 1046, 1046, 1046, 1046, 1046, 843, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	271, 1046, 1046, 1046, 1046, 1046, 1046, 1046, 
	1046, 1046, 1046, 1046, 1046, 1046, 1046, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 272, 1046, 1046, 273, 1046, 271, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 843, 1046, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 843, 1064, 843, 843, 843, 843, 
	843, 843, 843, 843, 843, 843, 843, 843, 
	843, 843, 1046, 1046, 1046, 1046, 1046, 843, 
	1123, 203, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	906, 906, 906, 906, 906, 906, 906, 906, 
	916, 906, 1125, 1124, 1124, 1124, 1125, 1124, 
	1124, 1124, 1124, 1126, 1127, 1126, 1126, 1126, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1125, 1124, 1124, 1124, 
	1124, 1124, 1126, 1124, 1124, 1128, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1124, 1124, 
	1124, 1124, 1124, 1124, 1124, 1124, 1129, 1124, 
	1126, 1130, 1126, 1126, 1126, 1130, 1130, 1130, 
	1130, 1130, 1130, 1130, 1130, 1130, 1130, 1130, 
	1130, 1130, 1130, 1130, 1130, 1130, 1130, 1126, 
	1130, 1131, 1132, 1133, 1134, 1135, 1137, 1136, 
	1138, 1140, 1141, 1141, 1141, 1140, 1141, 1141, 
	1141, 1141, 1142, 1143, 1142, 1142, 1142, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1140, 1141, 1141, 1141, 1141, 
	1141, 1142, 1141, 1144, 1145, 1141, 1141, 1141, 
	1144, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1141, 1141, 1141, 1141, 1141, 1141, 
	1141, 1141, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1141, 1146, 1141, 1141, 
	1139, 1141, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1139, 1139, 1139, 1139, 
	1139, 1139, 1139, 1139, 1141, 1141, 1141, 1141, 
	1141, 1139, 1147, 1147, 1147, 1147, 1147, 1147, 
	1147, 1147, 1147, 1147, 1147, 1147, 1147, 1147, 
	1147, 1147, 1147, 1147, 1147, 1147, 1147, 1147, 
	1147, 1147, 1147, 1147, 1147, 1147, 1147, 1147, 
	1147, 1147, 1147, 279, 1147, 1147, 1147, 1147, 
	1147, 1147, 1147, 1147, 1147, 1147, 1147, 1147, 
	1147, 1147, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 280, 1147, 1147, 1147, 
	1147, 279, 1147, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 1147, 1147, 1147, 
	1147, 278, 1147, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 1147, 1147, 1147, 
	1147, 1147, 278, 1142, 1148, 1142, 1142, 1142, 
	1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1148, 1148, 1148, 1148, 1148, 1148, 
	1148, 1148, 1142, 1148, 1149, 1150, 1151, 1152, 
	1153, 1154, 1147, 1155, 1157, 1158, 1158, 1158, 
	1157, 1158, 1158, 1158, 1158, 1159, 1160, 1159, 
	1159, 1159, 1158, 1158, 1158, 1158, 1158, 1158, 
	1158, 1158, 1158, 1158, 1158, 1158, 1157, 1158, 
	1158, 1158, 1158, 1158, 1159, 1161, 1162, 1163, 
	1164, 1165, 1166, 1162, 1167, 1168, 1169, 1165, 
	1170, 1171, 1172, 1165, 1173, 1174, 1174, 1174, 
	1174, 1174, 1174, 1174, 1174, 1174, 1175, 1176, 
	1177, 1178, 1179, 1180, 1181, 1182, 1183, 1182, 
	1182, 1184, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1185, 
	1186, 1187, 1165, 1188, 1162, 1189, 1190, 1191, 
	1192, 1193, 1194, 1156, 1156, 1195, 1156, 1156, 
	1156, 1196, 1197, 1198, 1156, 1156, 1199, 1200, 
	1201, 1202, 1156, 1203, 1156, 1204, 1156, 1205, 
	1206, 1207, 1165, 1158, 1156, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 1208, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 288, 
	288, 288, 288, 288, 1208, 288, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	288, 288, 288, 288, 1156, 288, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	288, 288, 288, 288, 288, 1156, 1210, 1209, 
	1211, 1159, 1212, 1159, 1159, 1159, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1212, 1212, 1212, 1212, 1212, 1212, 1212, 1212, 
	1159, 1212, 1213, 1215, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1215, 1214, 1216, 1217, 
	1218, 1219, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 283, 283, 1220, 283, 1220, 
	283, 283, 1220, 1220, 283, 283, 283, 1221, 
	283, 283, 1222, 1222, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 283, 283, 283, 283, 
	283, 283, 283, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 1220, 283, 1220, 
	1220, 291, 283, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 1220, 1220, 1220, 
	283, 1220, 291, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 1223, 1223, 1223, 1223, 
	1223, 1223, 1223, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 1223, 1223, 1223, 
	1223, 1223, 1223, 1223, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 1223, 1223, 
	1223, 1223, 291, 1223, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 1223, 1223, 
	1223, 1223, 1223, 291, 1222, 1222, 1222, 1222, 
	1222, 1222, 1222, 1222, 1222, 1222, 1223, 1224, 
	1214, 1165, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1225, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1224, 1214, 1226, 1227, 1165, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1224, 
	1214, 1224, 1228, 1214, 1230, 1229, 287, 287, 
	287, 287, 287, 287, 287, 287, 287, 287, 
	1229, 1170, 1231, 287, 287, 287, 287, 287, 
	287, 287, 287, 287, 287, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1233, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1234, 1232, 1232, 1232, 1232, 1232, 
	1233, 1232, 286, 286, 286, 286, 286, 286, 
	286, 286, 286, 286, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 1232, 1232, 1232, 1232, 1232, 1232, 1232, 
	1232, 285, 1232, 1236, 1235, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1237, 1237, 1237, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1238, 
	1235, 1239, 1240, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1241, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1242, 1235, 1235, 
	1235, 1235, 1235, 1235, 1243, 1235, 1235, 1238, 
	1235, 1239, 1240, 1235, 1235, 1235, 1244, 1235, 
	1235, 1235, 1235, 1235, 1241, 1235, 1235, 1245, 
	1235, 1235, 1235, 1235, 1235, 1242, 1235, 289, 
	289, 289, 289, 289, 289, 289, 289, 289, 
	289, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1247, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1246, 1246, 1246, 1246, 1246, 1248, 1246, 
	1246, 1246, 1246, 1246, 1247, 1246, 1246, 1246, 
	1249, 1246, 1246, 1246, 1246, 1246, 1246, 1246, 
	1246, 1250, 1246, 1251, 288, 1251, 288, 288, 
	290, 290, 290, 290, 290, 290, 290, 290, 
	290, 290, 288, 290, 290, 290, 290, 290, 
	290, 290, 290, 290, 290, 1252, 1252, 1252, 
	1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 
	1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 
	1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 
	1252, 1252, 1252, 1252, 1252, 1252, 1252, 1252, 
	1252, 1252, 1251, 1252, 1252, 1252, 1252, 1252, 
	1252, 1252, 1252, 1252, 1253, 1252, 1254, 1256, 
	1255, 1257, 1237, 1237, 1237, 1237, 1237, 1237, 
	1237, 1237, 1237, 1237, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1243, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1244, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1245, 1235, 1258, 1258, 
	1258, 1258, 1258, 1258, 1258, 1258, 1258, 1258, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1259, 1235, 1235, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1244, 
	1235, 1235, 1235, 1235, 1235, 1235, 1235, 1235, 
	1245, 1235, 1261, 1261, 1261, 1261, 1261, 1261, 
	1261, 1261, 1261, 1261, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1262, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1263, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1264, 1260, 1261, 1261, 
	1261, 1261, 1261, 1261, 1261, 1261, 1261, 1261, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1265, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1263, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1264, 1260, 1263, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1264, 1260, 1266, 1268, 1267, 
	1269, 1271, 1271, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1272, 1270, 1270, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1273, 1270, 1270, 1270, 1270, 1270, 
	1270, 1270, 1270, 1274, 1270, 1275, 1275, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1276, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1263, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1264, 
	1260, 1275, 1275, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1265, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1263, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1264, 1260, 1278, 1278, 1278, 
	1278, 1278, 1278, 1278, 1278, 1278, 1278, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1279, 1277, 1277, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1280, 1277, 
	1277, 1277, 1277, 1277, 1277, 1277, 1277, 1281, 
	1277, 1283, 1283, 1283, 1283, 1283, 1283, 1283, 
	1283, 1283, 1283, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1284, 1282, 1282, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1285, 1282, 1282, 1282, 1282, 1282, 
	1282, 1282, 1282, 1286, 1282, 1288, 1288, 1288, 
	1288, 1288, 1288, 1288, 1288, 1288, 1288, 1287, 
	1287, 1287, 1287, 1287, 1287, 1287, 1288, 1288, 
	1288, 1288, 1288, 1288, 1287, 1287, 1287, 1287, 
	1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 
	1287, 1287, 1287, 1287, 1287, 1287, 1287, 1287, 
	1287, 1287, 1287, 1287, 1289, 1287, 1288, 1288, 
	1288, 1288, 1288, 1288, 1287, 1287, 1290, 1287, 
	1287, 1287, 1287, 1287, 1287, 1287, 1287, 1291, 
	1287, 1292, 1292, 1292, 1292, 1292, 1292, 1292, 
	1292, 1292, 1292, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1292, 1292, 1292, 1292, 1292, 1292, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1293, 1260, 1292, 1292, 1292, 1292, 1292, 1292, 
	1260, 1260, 1263, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1264, 1260, 1292, 1292, 1292, 
	1292, 1292, 1292, 1292, 1292, 1292, 1292, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1292, 1292, 
	1292, 1292, 1292, 1292, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1265, 1260, 1292, 1292, 
	1292, 1292, 1292, 1292, 1260, 1260, 1263, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1264, 
	1260, 1295, 1294, 1296, 1296, 1296, 1296, 1296, 
	1296, 1296, 1296, 1296, 1296, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1297, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1298, 1294, 1294, 1294, 1294, 1294, 
	1297, 1294, 1294, 1294, 1299, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1300, 1294, 1301, 
	1301, 1301, 1301, 1301, 1301, 1301, 1301, 1301, 
	1301, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1302, 1294, 
	1294, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1299, 1294, 1294, 1294, 1294, 1294, 1294, 1294, 
	1294, 1300, 1294, 1303, 1260, 1304, 1304, 1304, 
	1304, 1304, 1304, 1304, 1304, 1304, 1304, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1305, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1306, 1260, 1260, 1260, 
	1260, 1260, 1305, 1260, 1260, 1260, 1263, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1264, 
	1260, 1304, 1304, 1304, 1304, 1304, 1304, 1304, 
	1304, 1304, 1304, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1265, 1260, 1260, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1263, 1260, 1260, 1260, 1260, 1260, 
	1260, 1260, 1260, 1264, 1260, 1225, 1231, 1165, 
	1307, 1214, 1215, 1214, 1308, 1215, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1231, 1231, 1231, 
	1231, 1231, 1231, 1231, 1231, 1215, 1231, 1215, 
	1214, 1215, 1165, 1214, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 1220, 1220, 1220, 1220, 
	1220, 1220, 1220, 1220, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 1220, 1220, 
	1220, 1220, 1220, 1220, 1309, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 1220, 
	1220, 1220, 1220, 291, 1220, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 291, 
	291, 291, 291, 291, 291, 291, 291, 1220, 
	1220, 1220, 1220, 1220, 291, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 288, 1208, 288, 
	288, 288, 288, 288, 288, 288, 288, 288, 
	288, 288, 288, 288, 288, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1310, 
	288, 288, 288, 288, 1208, 288, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	288, 288, 288, 288, 1182, 288, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	288, 288, 288, 288, 288, 1182, 1311, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1208, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1310, 1312, 1312, 1312, 1312, 1208, 1312, 
	1182, 1182, 1182, 1182, 1313, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1312, 1312, 1312, 1312, 1182, 1312, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1312, 1312, 1312, 1312, 1312, 1182, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1208, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1310, 1312, 1312, 1312, 1312, 1208, 
	1312, 1182, 1182, 1182, 1182, 1182, 1182, 1314, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1312, 1312, 1312, 1312, 1182, 
	1312, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1312, 1312, 1312, 1312, 1312, 
	1182, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1208, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1310, 1312, 1312, 1312, 1312, 
	1208, 1312, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1315, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1312, 1312, 1312, 1312, 
	1182, 1312, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1312, 1312, 1312, 1312, 
	1312, 1182, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1208, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1310, 1312, 1312, 1312, 
	1312, 1208, 1312, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1316, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1312, 1312, 1312, 
	1312, 1182, 1312, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1312, 1312, 1312, 
	1312, 1312, 1182, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1208, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1310, 1312, 1312, 
	1312, 1312, 1208, 1312, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1317, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1312, 1312, 
	1312, 1312, 1182, 1312, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1312, 1312, 
	1312, 1312, 1312, 1182, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1208, 1312, 1312, 
	1312, 1312, 1312, 1312, 1312, 1312, 1312, 1312, 
	1312, 1312, 1312, 1312, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1310, 1312, 
	1312, 1312, 1312, 1208, 1312, 1182, 1182, 1182, 
	1316, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1312, 
	1312, 1312, 1312, 1182, 1312, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1182, 
	1182, 1182, 1182, 1182, 1182, 1182, 1182, 1312, 
	1312, 1312, 1312, 1312, 1182, 1318, 1320, 1319, 
	1321, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1323, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1324, 
	1325, 1156, 1156, 1156, 1156, 1156, 1326, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1327, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1328, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1329, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1330, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1331, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1332, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1333, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1334, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1335, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1336, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1337, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1338, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1339, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1340, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1341, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1337, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1342, 
	1156, 1343, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1344, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1345, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1346, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1347, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1348, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1349, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1350, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1351, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1347, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1352, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1353, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1354, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1355, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1356, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1357, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1347, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1358, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1359, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1360, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1361, 1361, 1361, 
	1361, 1361, 1361, 1361, 1361, 1361, 293, 294, 
	293, 293, 293, 1361, 1361, 1361, 1361, 1361, 
	1361, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 
	1361, 1361, 1361, 1361, 1361, 293, 1208, 1361, 
	295, 1361, 1361, 1361, 1361, 1361, 1361, 1361, 
	1361, 1361, 1361, 1361, 1361, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1361, 
	1361, 296, 1361, 1361, 1208, 1361, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1361, 297, 1361, 1361, 1156, 1361, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1361, 1361, 1361, 1361, 1361, 1156, 310, 311, 
	310, 310, 310, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 310, 309, 309, 
	312, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 315, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 309, 309, 309, 309, 309, 309, 309, 
	309, 314, 309, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1363, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1364, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1365, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1366, 1366, 1366, 
	1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 
	1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 
	1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 
	1366, 1366, 1366, 1366, 1366, 1366, 1208, 1366, 
	1366, 1366, 1366, 1366, 1366, 1366, 1366, 1366, 
	1366, 1366, 1366, 1366, 1366, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1366, 
	1366, 1366, 1366, 1366, 1208, 1366, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1366, 1366, 1366, 1366, 1156, 1366, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1367, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1366, 1366, 1366, 1366, 1366, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1368, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1369, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1370, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1371, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1372, 1156, 
	1373, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1374, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1347, 1156, 1156, 1156, 1375, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1347, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1340, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1376, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1377, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1357, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1378, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1198, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1379, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1380, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1340, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1347, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1381, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1347, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1382, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1383, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1384, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1357, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1385, 1156, 1156, 1156, 1386, 1156, 1156, 1156, 
	1156, 1156, 1387, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1388, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1354, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1340, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1389, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1390, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1391, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1392, 1393, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1340, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1394, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1395, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1381, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1396, 1156, 1156, 1397, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1340, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1398, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1354, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1399, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1400, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1401, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1340, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1402, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1403, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1389, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1404, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1405, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1351, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1380, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1406, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1407, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1408, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1409, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1410, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1346, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1411, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1412, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1381, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1413, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1381, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1156, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1414, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1156, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1156, 1322, 1156, 1156, 
	1156, 1156, 1351, 1156, 1156, 1156, 1415, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1156, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1322, 1322, 1322, 1322, 1322, 1208, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1156, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1416, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1156, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1322, 1322, 1322, 1322, 1322, 1208, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1156, 1322, 
	1156, 1156, 1156, 1156, 1381, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1156, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1322, 1322, 1322, 1322, 1322, 1208, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1156, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1417, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1156, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1322, 1322, 1322, 1322, 1322, 
	1208, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1156, 1322, 1156, 1156, 1156, 1156, 1418, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1156, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1208, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1322, 1322, 1322, 1322, 
	1322, 1208, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1156, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1419, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1156, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1208, 1322, 1322, 1322, 
	1322, 1322, 1322, 1322, 1322, 1322, 1322, 1322, 
	1322, 1322, 1322, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1322, 1322, 1322, 
	1322, 1322, 1208, 1322, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1156, 1322, 1156, 1156, 1156, 1389, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1156, 1156, 
	1156, 1156, 1156, 1156, 1156, 1156, 1322, 1322, 
	1322, 1322, 1322, 1156, 1420, 1224, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1214, 1214, 1214, 1214, 
	1214, 1214, 1214, 1214, 1165, 1214, 1421, 1423, 
	1422, 1423, 1423, 1423, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 1422, 1422, 1423, 1422, 
	1422, 1422, 1422, 1422, 1424, 1422, 1422, 1422, 
	1422, 1422, 1422, 1422, 321, 1422, 319, 1425, 
	319, 319, 319, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 1425, 1425, 319, 1425, 1425, 
	1425, 1425, 1425, 320, 1425, 1425, 1425, 1425, 
	1425, 1425, 1425, 321, 1425, 322, 1425, 1427, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1428, 1426, 1427, 1426, 1427, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1430, 1426, 1427, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1431, 
	1426, 1427, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1426, 1426, 1426, 1426, 1426, 
	1426, 1426, 1426, 1432, 1426, 1434, 1432, 0
]

class << self
	attr_accessor :_lex_trans_targs
	private :_lex_trans_targs, :_lex_trans_targs=
end
self._lex_trans_targs = [
	171, 2, 3, 4, 177, 6, 7, 8, 
	9, 10, 171, 171, 180, 183, 180, 12, 
	184, 14, 180, 191, 192, 195, 196, 202, 
	197, 198, 199, 19, 200, 201, 204, 206, 
	207, 208, 209, 210, 25, 18, 193, 194, 
	27, 242, 243, 245, 247, 245, 30, 248, 
	32, 245, 255, 256, 259, 260, 266, 261, 
	262, 263, 37, 264, 265, 268, 270, 271, 
	272, 273, 274, 43, 36, 257, 258, 45, 
	306, 307, 314, 316, 314, 48, 317, 50, 
	319, 322, 319, 52, 323, 54, 329, 328, 
	0, 56, 330, 331, 58, 332, 333, 333, 
	333, 333, 446, 61, 62, 63, 446, 474, 
	64, 65, 474, 474, 478, 478, 69, 64, 
	70, 476, 477, 479, 480, 478, 474, 481, 
	482, 484, 66, 67, 485, 486, 68, 478, 
	71, 72, 77, 84, 488, 489, 70, 476, 
	477, 479, 480, 478, 474, 481, 482, 484, 
	66, 67, 485, 486, 68, 71, 72, 77, 
	84, 488, 489, 487, 73, 74, 75, 76, 
	78, 79, 82, 80, 81, 83, 85, 86, 
	474, 88, 89, 90, 92, 95, 93, 94, 
	96, 98, 505, 505, 505, 506, 100, 508, 
	101, 509, 102, 506, 100, 508, 101, 509, 
	543, 543, 543, 105, 106, 107, 108, 554, 
	543, 543, 559, 543, 111, 112, 113, 543, 
	116, 111, 112, 113, 543, 116, 114, 114, 
	112, 113, 565, 115, 114, 114, 112, 113, 
	565, 115, 112, 543, 581, 543, 118, 582, 
	588, 121, 124, 126, 128, 129, 130, 124, 
	125, 592, 125, 592, 127, 543, 606, 607, 
	610, 611, 617, 612, 613, 614, 135, 615, 
	616, 619, 621, 622, 623, 624, 625, 141, 
	134, 608, 609, 143, 661, 662, 145, 545, 
	103, 547, 147, 148, 664, 765, 150, 151, 
	152, 765, 773, 773, 773, 155, 794, 793, 
	773, 796, 798, 783, 830, 161, 162, 163, 
	167, 168, 161, 162, 163, 167, 168, 164, 
	164, 162, 163, 165, 166, 164, 164, 162, 
	163, 165, 166, 877, 162, 773, 946, 169, 
	170, 946, 946, 171, 171, 172, 173, 174, 
	176, 178, 179, 171, 171, 171, 175, 171, 
	175, 171, 1, 171, 171, 171, 5, 180, 
	180, 181, 180, 182, 185, 180, 180, 11, 
	13, 180, 180, 180, 186, 187, 188, 15, 
	21, 26, 211, 28, 180, 180, 180, 189, 
	190, 180, 16, 180, 180, 180, 17, 180, 
	180, 180, 20, 203, 205, 22, 180, 180, 
	23, 24, 180, 212, 216, 220, 213, 214, 
	215, 217, 218, 219, 180, 180, 221, 225, 
	231, 222, 229, 230, 223, 227, 228, 224, 
	226, 180, 232, 241, 240, 233, 234, 235, 
	236, 237, 238, 239, 180, 180, 180, 244, 
	245, 245, 245, 246, 249, 245, 29, 31, 
	245, 245, 245, 250, 251, 252, 33, 39, 
	44, 275, 46, 245, 245, 245, 253, 254, 
	245, 34, 245, 245, 245, 35, 245, 245, 
	245, 38, 267, 269, 40, 245, 245, 41, 
	42, 245, 276, 280, 284, 277, 278, 279, 
	281, 282, 283, 245, 245, 285, 289, 295, 
	286, 293, 294, 287, 291, 292, 288, 290, 
	245, 296, 305, 304, 297, 298, 299, 300, 
	301, 302, 303, 245, 245, 245, 308, 309, 
	309, 310, 309, 311, 309, 309, 309, 312, 
	312, 312, 313, 312, 312, 312, 314, 314, 
	314, 315, 314, 47, 49, 314, 314, 318, 
	318, 318, 319, 319, 320, 319, 321, 319, 
	319, 51, 53, 319, 319, 324, 324, 325, 
	324, 324, 326, 327, 326, 55, 57, 328, 
	328, 328, 334, 333, 333, 335, 336, 337, 
	338, 340, 343, 344, 345, 346, 333, 347, 
	348, 350, 352, 353, 354, 358, 360, 361, 
	362, 378, 383, 390, 395, 402, 409, 412, 
	413, 417, 411, 421, 429, 433, 435, 440, 
	442, 445, 333, 333, 333, 333, 333, 333, 
	339, 333, 339, 333, 341, 59, 342, 333, 
	60, 333, 333, 349, 351, 333, 355, 356, 
	357, 353, 359, 333, 363, 364, 373, 376, 
	365, 366, 367, 368, 369, 370, 371, 372, 
	334, 374, 375, 377, 379, 382, 380, 381, 
	384, 387, 385, 386, 388, 389, 391, 393, 
	392, 394, 396, 397, 333, 398, 399, 400, 
	401, 333, 403, 406, 404, 405, 407, 408, 
	410, 414, 415, 416, 418, 420, 419, 422, 
	423, 424, 426, 425, 427, 428, 430, 431, 
	432, 434, 436, 437, 438, 439, 441, 443, 
	444, 447, 446, 446, 448, 449, 451, 446, 
	446, 446, 450, 446, 450, 452, 446, 454, 
	453, 453, 457, 458, 459, 460, 453, 462, 
	463, 464, 465, 467, 469, 470, 471, 472, 
	473, 453, 455, 453, 456, 453, 453, 453, 
	453, 453, 461, 453, 461, 466, 453, 468, 
	453, 474, 474, 475, 490, 491, 477, 493, 
	494, 481, 495, 496, 497, 498, 499, 501, 
	502, 503, 504, 474, 474, 474, 474, 474, 
	474, 478, 483, 474, 474, 474, 474, 474, 
	474, 474, 474, 474, 492, 474, 492, 474, 
	474, 474, 474, 500, 474, 87, 91, 97, 
	505, 507, 510, 99, 505, 505, 506, 511, 
	511, 512, 513, 515, 517, 518, 511, 511, 
	514, 511, 514, 511, 516, 511, 511, 511, 
	520, 519, 519, 521, 522, 523, 525, 527, 
	528, 533, 540, 519, 519, 519, 519, 524, 
	519, 524, 519, 526, 519, 519, 520, 529, 
	530, 531, 532, 534, 535, 538, 536, 537, 
	539, 541, 542, 544, 543, 552, 553, 555, 
	556, 558, 560, 561, 562, 564, 566, 567, 
	569, 570, 591, 594, 595, 596, 664, 665, 
	666, 667, 668, 563, 670, 686, 691, 698, 
	703, 705, 711, 714, 715, 719, 713, 723, 
	734, 738, 741, 749, 753, 756, 757, 543, 
	103, 546, 543, 543, 548, 550, 551, 543, 
	549, 543, 543, 543, 543, 543, 104, 543, 
	543, 543, 543, 543, 557, 543, 557, 543, 
	543, 109, 543, 543, 110, 543, 543, 563, 
	543, 568, 543, 571, 580, 543, 117, 583, 
	584, 585, 543, 586, 119, 589, 120, 122, 
	590, 543, 572, 574, 543, 573, 543, 543, 
	575, 578, 579, 543, 576, 577, 543, 543, 
	543, 543, 587, 123, 593, 543, 543, 597, 
	543, 543, 543, 598, 600, 543, 599, 543, 
	599, 543, 601, 602, 603, 131, 137, 142, 
	626, 144, 543, 543, 543, 604, 605, 543, 
	132, 543, 543, 543, 133, 543, 543, 543, 
	136, 618, 620, 138, 543, 543, 139, 140, 
	543, 627, 631, 635, 628, 629, 630, 632, 
	633, 634, 543, 543, 636, 640, 646, 637, 
	644, 645, 638, 642, 643, 639, 641, 543, 
	647, 655, 660, 648, 649, 650, 651, 652, 
	653, 654, 656, 657, 658, 659, 543, 543, 
	543, 663, 146, 149, 543, 669, 543, 671, 
	672, 681, 684, 673, 674, 675, 676, 677, 
	678, 679, 680, 544, 682, 683, 685, 687, 
	690, 688, 689, 692, 695, 693, 694, 696, 
	697, 699, 701, 700, 702, 704, 706, 708, 
	707, 709, 710, 712, 544, 716, 717, 718, 
	720, 722, 721, 724, 725, 726, 731, 727, 
	728, 729, 543, 544, 545, 103, 730, 550, 
	732, 733, 735, 736, 737, 739, 740, 742, 
	743, 744, 747, 745, 746, 748, 750, 751, 
	752, 754, 755, 543, 758, 758, 759, 760, 
	761, 763, 758, 758, 758, 762, 758, 762, 
	758, 764, 758, 766, 765, 765, 767, 768, 
	765, 769, 771, 765, 765, 765, 765, 770, 
	765, 770, 772, 765, 774, 773, 773, 777, 
	778, 779, 773, 780, 782, 785, 786, 787, 
	788, 789, 773, 790, 791, 795, 818, 822, 
	773, 823, 825, 827, 773, 828, 829, 831, 
	835, 837, 838, 773, 840, 858, 863, 870, 
	878, 885, 892, 897, 898, 902, 896, 907, 
	917, 923, 926, 935, 939, 943, 944, 945, 
	775, 773, 776, 773, 773, 773, 773, 773, 
	773, 781, 773, 781, 773, 153, 784, 773, 
	773, 773, 773, 773, 773, 773, 792, 773, 
	773, 154, 156, 773, 157, 802, 810, 813, 
	797, 814, 815, 803, 807, 808, 773, 797, 
	157, 799, 800, 158, 773, 799, 773, 773, 
	801, 773, 804, 806, 773, 804, 805, 807, 
	808, 806, 773, 773, 809, 773, 773, 811, 
	806, 807, 808, 811, 812, 773, 804, 806, 
	807, 808, 773, 804, 806, 807, 808, 773, 
	816, 806, 807, 808, 816, 817, 773, 157, 
	818, 797, 819, 807, 808, 820, 806, 157, 
	820, 797, 821, 824, 826, 159, 160, 773, 
	773, 832, 833, 834, 829, 836, 773, 773, 
	839, 773, 773, 841, 842, 851, 856, 843, 
	844, 845, 846, 847, 848, 849, 850, 774, 
	852, 853, 854, 855, 774, 857, 859, 862, 
	860, 861, 774, 774, 864, 867, 865, 866, 
	868, 869, 774, 871, 873, 872, 874, 875, 
	876, 773, 773, 879, 774, 880, 773, 881, 
	882, 883, 884, 775, 886, 889, 887, 888, 
	890, 891, 893, 894, 895, 774, 899, 900, 
	901, 903, 905, 906, 904, 774, 908, 909, 
	910, 913, 911, 912, 914, 915, 916, 918, 
	920, 919, 921, 922, 924, 925, 927, 928, 
	930, 933, 929, 931, 932, 934, 936, 937, 
	938, 940, 941, 942, 773, 773, 946, 947, 
	948, 946, 950, 949, 951, 949, 952, 953, 
	954, 949, 949
]

class << self
	attr_accessor :_lex_trans_actions
	private :_lex_trans_actions, :_lex_trans_actions=
end
self._lex_trans_actions = [
	1, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 2, 3, 4, 0, 5, 0, 
	0, 0, 6, 0, 7, 0, 8, 0, 
	7, 0, 0, 0, 0, 8, 7, 0, 
	8, 0, 7, 7, 0, 0, 0, 0, 
	0, 0, 0, 9, 0, 10, 0, 0, 
	0, 11, 0, 7, 0, 8, 0, 7, 
	0, 0, 0, 0, 8, 7, 0, 8, 
	0, 7, 7, 0, 0, 0, 0, 0, 
	0, 0, 12, 0, 13, 0, 0, 0, 
	14, 0, 15, 0, 0, 0, 0, 16, 
	0, 0, 0, 0, 0, 0, 17, 18, 
	19, 20, 21, 0, 0, 0, 22, 23, 
	0, 0, 24, 25, 26, 27, 28, 29, 
	29, 30, 31, 29, 32, 31, 33, 31, 
	29, 29, 30, 29, 34, 29, 29, 35, 
	29, 29, 29, 29, 29, 29, 0, 36, 
	37, 0, 38, 37, 39, 37, 0, 0, 
	36, 0, 40, 0, 0, 0, 0, 0, 
	0, 0, 0, 27, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	41, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 42, 43, 44, 45, 0, 0, 
	0, 45, 28, 46, 29, 29, 29, 46, 
	47, 48, 49, 0, 0, 0, 0, 0, 
	50, 51, 0, 52, 0, 28, 0, 53, 
	0, 29, 54, 29, 55, 29, 56, 57, 
	58, 57, 59, 57, 0, 60, 61, 60, 
	62, 60, 63, 64, 0, 65, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 66, 
	66, 67, 0, 28, 0, 68, 0, 7, 
	0, 8, 0, 7, 0, 0, 0, 0, 
	8, 7, 0, 8, 0, 7, 7, 0, 
	0, 0, 0, 0, 0, 0, 0, 69, 
	0, 0, 0, 0, 69, 70, 0, 0, 
	0, 71, 72, 73, 74, 0, 7, 7, 
	75, 76, 76, 0, 0, 0, 28, 0, 
	0, 0, 29, 54, 29, 29, 29, 56, 
	57, 58, 57, 57, 57, 0, 60, 61, 
	60, 60, 60, 77, 63, 78, 79, 0, 
	80, 81, 82, 85, 86, 0, 28, 0, 
	7, 0, 7, 87, 88, 89, 56, 90, 
	0, 91, 0, 92, 93, 94, 0, 95, 
	96, 0, 97, 7, 7, 98, 99, 0, 
	0, 100, 101, 102, 103, 103, 103, 103, 
	103, 103, 103, 103, 104, 105, 106, 0, 
	0, 107, 0, 108, 109, 110, 0, 111, 
	112, 113, 0, 7, 0, 0, 114, 115, 
	0, 28, 116, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 117, 118, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 119, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 120, 121, 122, 0, 
	123, 124, 125, 7, 7, 126, 0, 0, 
	127, 128, 129, 103, 103, 103, 103, 103, 
	103, 103, 103, 130, 131, 132, 0, 0, 
	133, 0, 134, 135, 136, 0, 137, 138, 
	139, 0, 7, 0, 0, 140, 141, 0, 
	28, 142, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 143, 144, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	145, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 146, 147, 148, 0, 149, 
	150, 0, 151, 0, 152, 153, 154, 155, 
	156, 157, 0, 158, 159, 160, 161, 162, 
	163, 7, 164, 0, 0, 165, 166, 167, 
	168, 169, 170, 171, 0, 172, 7, 173, 
	174, 0, 0, 175, 176, 177, 178, 0, 
	179, 180, 181, 0, 182, 0, 0, 183, 
	184, 185, 186, 187, 188, 0, 28, 0, 
	0, 7, 7, 0, 0, 0, 189, 0, 
	0, 0, 0, 190, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 191, 192, 193, 194, 195, 196, 
	56, 197, 0, 198, 0, 0, 0, 199, 
	0, 200, 201, 0, 0, 202, 0, 0, 
	0, 203, 0, 204, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	203, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 205, 0, 0, 0, 
	0, 206, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 7, 207, 208, 0, 0, 0, 209, 
	210, 211, 56, 212, 0, 28, 213, 0, 
	214, 215, 0, 28, 0, 0, 216, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 217, 0, 218, 0, 219, 220, 221, 
	222, 223, 56, 224, 0, 0, 225, 0, 
	226, 227, 228, 229, 28, 0, 27, 0, 
	0, 27, 0, 0, 0, 0, 0, 0, 
	7, 7, 7, 230, 231, 232, 233, 234, 
	235, 236, 0, 237, 238, 239, 240, 241, 
	242, 243, 244, 245, 56, 246, 0, 247, 
	248, 249, 250, 251, 252, 0, 0, 0, 
	253, 7, 7, 0, 254, 255, 256, 257, 
	258, 0, 0, 0, 0, 0, 259, 260, 
	56, 261, 0, 262, 28, 263, 264, 265, 
	266, 267, 268, 0, 28, 0, 0, 0, 
	0, 0, 0, 269, 270, 271, 272, 56, 
	273, 0, 274, 28, 275, 276, 277, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 278, 279, 0, 8, 0, 
	0, 7, 280, 0, 0, 280, 280, 0, 
	0, 7, 7, 0, 281, 0, 281, 281, 
	281, 0, 0, 281, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 0, 281, 282, 
	283, 0, 284, 285, 0, 69, 0, 286, 
	0, 287, 288, 289, 290, 291, 29, 292, 
	293, 294, 295, 296, 56, 297, 0, 298, 
	299, 0, 300, 301, 0, 302, 303, 280, 
	304, 0, 305, 0, 0, 306, 0, 0, 
	0, 0, 307, 0, 0, 0, 0, 0, 
	0, 308, 0, 0, 309, 0, 310, 311, 
	0, 0, 0, 312, 0, 0, 313, 314, 
	315, 316, 0, 0, 0, 317, 318, 0, 
	319, 320, 321, 0, 7, 322, 323, 324, 
	0, 325, 103, 103, 103, 103, 103, 103, 
	103, 103, 326, 327, 328, 0, 0, 329, 
	0, 330, 331, 332, 0, 333, 334, 335, 
	0, 7, 0, 0, 336, 337, 0, 28, 
	338, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 339, 340, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 341, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 342, 343, 
	344, 0, 0, 0, 345, 28, 346, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 69, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 347, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 348, 349, 350, 351, 352, 352, 348, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 278, 278, 278, 278, 278, 
	278, 278, 278, 353, 354, 355, 0, 28, 
	0, 0, 356, 357, 358, 56, 359, 0, 
	360, 28, 361, 7, 362, 363, 0, 28, 
	364, 0, 0, 365, 366, 367, 368, 56, 
	369, 0, 28, 370, 371, 372, 373, 0, 
	28, 0, 374, 0, 7, 0, 0, 0, 
	0, 0, 375, 0, 0, 376, 376, 0, 
	377, 0, 0, 0, 378, 7, 379, 379, 
	379, 0, 0, 380, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	381, 382, 0, 383, 384, 385, 386, 387, 
	388, 56, 389, 0, 390, 0, 0, 391, 
	392, 393, 394, 395, 396, 397, 0, 398, 
	399, 0, 0, 400, 401, 402, 0, 0, 
	403, 0, 0, 402, 404, 404, 405, 406, 
	0, 407, 407, 0, 408, 409, 410, 411, 
	0, 412, 402, 402, 413, 0, 0, 414, 
	414, 0, 415, 416, 0, 417, 418, 419, 
	419, 420, 420, 0, 0, 421, 422, 422, 
	423, 423, 424, 425, 425, 426, 426, 427, 
	428, 428, 429, 429, 0, 0, 430, 431, 
	432, 433, 434, 435, 435, 432, 434, 436, 
	376, 437, 0, 0, 0, 0, 0, 438, 
	439, 379, 379, 379, 440, 379, 441, 442, 
	28, 443, 444, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 445, 
	0, 0, 0, 0, 440, 0, 0, 0, 
	0, 0, 446, 447, 0, 0, 0, 0, 
	0, 0, 448, 0, 0, 0, 0, 0, 
	447, 449, 450, 0, 451, 0, 452, 0, 
	0, 0, 0, 453, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 454, 0, 0, 
	0, 0, 0, 0, 0, 453, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 455, 456, 457, 7, 
	80, 458, 0, 459, 0, 460, 0, 0, 
	0, 461, 462
]

class << self
	attr_accessor :_lex_to_state_actions
	private :_lex_to_state_actions, :_lex_to_state_actions=
end
self._lex_to_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 83, 0, 0, 0, 0, 
	0, 0, 0, 0, 83, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 83, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 83, 0, 0, 
	83, 0, 83, 0, 0, 0, 83, 83, 
	0, 0, 0, 0, 83, 0, 83, 0, 
	83, 0, 0, 0, 0, 83, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 83, 0, 
	0, 0, 0, 0, 0, 83, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 83, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 83, 0, 0, 0, 0, 0, 83, 
	0, 0, 0, 0, 0, 0, 0, 83, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 83, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 83, 0, 
	0, 0, 0, 0, 0, 83, 0, 0, 
	0, 0, 0, 0, 0, 83, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 83, 0, 0, 83, 0, 0, 
	0, 0, 0
]

class << self
	attr_accessor :_lex_from_state_actions
	private :_lex_from_state_actions, :_lex_from_state_actions=
end
self._lex_from_state_actions = [
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 84, 0, 0, 0, 0, 
	0, 0, 0, 0, 84, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 84, 0, 0, 
	84, 0, 84, 0, 0, 0, 84, 84, 
	0, 0, 0, 0, 84, 0, 84, 0, 
	84, 0, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 84, 0, 
	0, 0, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 84, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 84, 0, 0, 0, 0, 0, 84, 
	0, 0, 0, 0, 0, 0, 0, 84, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 84, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 84, 0, 
	0, 0, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 84, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 0, 0, 0, 0, 0, 0, 
	0, 0, 84, 0, 0, 84, 0, 0, 
	0, 0, 0
]

class << self
	attr_accessor :_lex_eof_trans
	private :_lex_eof_trans, :_lex_eof_trans=
end
self._lex_eof_trans = [
	0, 1, 1, 1, 1, 1, 1, 1, 
	1, 1, 1, 13, 13, 13, 13, 19, 
	19, 19, 19, 19, 19, 19, 19, 19, 
	19, 19, 19, 19, 19, 44, 44, 44, 
	44, 50, 50, 50, 50, 50, 50, 50, 
	50, 50, 50, 50, 50, 50, 50, 75, 
	75, 75, 75, 81, 81, 81, 81, 0, 
	0, 0, 0, 95, 97, 99, 99, 99, 
	104, 104, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 108, 
	108, 108, 108, 108, 108, 108, 108, 169, 
	169, 169, 169, 169, 169, 169, 169, 169, 
	169, 169, 169, 179, 181, 181, 181, 193, 
	195, 195, 195, 195, 195, 201, 193, 193, 
	193, 193, 193, 193, 193, 228, 228, 228, 
	228, 228, 228, 228, 228, 228, 228, 228, 
	228, 228, 228, 246, 246, 246, 246, 246, 
	246, 246, 246, 246, 246, 246, 246, 246, 
	246, 193, 228, 228, 228, 228, 278, 278, 
	278, 283, 285, 285, 285, 289, 289, 283, 
	289, 289, 289, 289, 289, 289, 289, 289, 
	289, 319, 319, 0, 332, 333, 334, 336, 
	338, 340, 338, 338, 0, 350, 351, 355, 
	355, 356, 365, 366, 367, 367, 367, 370, 
	370, 372, 373, 374, 374, 374, 376, 377, 
	378, 378, 374, 370, 370, 383, 384, 384, 
	384, 384, 384, 387, 387, 387, 387, 387, 
	387, 387, 387, 397, 398, 398, 398, 398, 
	410, 410, 410, 398, 398, 398, 398, 410, 
	410, 410, 410, 410, 410, 410, 410, 410, 
	421, 410, 422, 423, 423, 0, 430, 434, 
	434, 435, 444, 445, 446, 446, 446, 449, 
	449, 451, 452, 453, 453, 453, 455, 456, 
	457, 457, 453, 449, 449, 462, 463, 463, 
	463, 463, 463, 466, 466, 466, 466, 466, 
	466, 466, 466, 476, 477, 477, 477, 477, 
	489, 489, 489, 477, 477, 477, 477, 489, 
	489, 489, 489, 489, 489, 489, 489, 489, 
	500, 489, 501, 502, 502, 0, 509, 510, 
	0, 516, 0, 523, 527, 527, 0, 0, 
	536, 537, 541, 541, 0, 546, 0, 549, 
	0, 552, 552, 553, 554, 0, 595, 597, 
	598, 599, 600, 602, 604, 608, 608, 599, 
	599, 599, 599, 610, 599, 599, 604, 599, 
	599, 595, 614, 614, 614, 614, 614, 614, 
	604, 604, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 653, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 620, 620, 620, 
	620, 620, 620, 620, 620, 599, 0, 696, 
	697, 698, 700, 696, 703, 0, 722, 724, 
	726, 727, 728, 729, 730, 732, 729, 729, 
	729, 729, 729, 735, 729, 729, 737, 735, 
	735, 729, 0, 756, 757, 104, 104, 760, 
	761, 104, 757, 757, 764, 766, 769, 757, 
	770, 757, 771, 772, 774, 776, 757, 764, 
	777, 777, 766, 777, 781, 777, 777, 777, 
	777, 0, 179, 789, 790, 789, 789, 0, 
	799, 800, 802, 804, 806, 804, 808, 0, 
	820, 821, 822, 823, 825, 827, 829, 830, 
	830, 830, 830, 830, 830, 830, 830, 830, 
	830, 830, 830, 830, 830, 830, 830, 0, 
	193, 888, 891, 892, 896, 898, 899, 900, 
	901, 902, 904, 907, 908, 910, 912, 915, 
	916, 918, 919, 193, 916, 921, 916, 907, 
	907, 907, 907, 938, 941, 943, 944, 948, 
	951, 952, 953, 954, 938, 938, 938, 938, 
	938, 938, 938, 938, 938, 938, 938, 907, 
	958, 907, 907, 907, 959, 966, 966, 968, 
	970, 979, 980, 981, 981, 981, 984, 984, 
	986, 987, 988, 988, 988, 990, 991, 992, 
	992, 988, 984, 984, 997, 998, 998, 998, 
	998, 998, 1001, 1001, 1001, 1001, 1001, 1001, 
	1001, 1001, 1011, 1012, 1012, 1012, 1012, 1024, 
	1024, 1024, 1012, 1012, 1012, 1012, 1024, 1024, 
	1024, 1024, 1024, 1024, 1024, 1024, 1024, 1024, 
	1024, 1024, 1024, 1024, 1039, 1040, 1041, 1041, 
	193, 907, 907, 1045, 907, 902, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1099, 892, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1047, 1047, 1047, 1047, 
	1047, 1047, 1047, 1047, 1124, 907, 0, 1131, 
	1132, 1133, 1135, 1137, 1139, 0, 1148, 1149, 
	1150, 1151, 1153, 1148, 1156, 0, 289, 1210, 
	1212, 1213, 1214, 1215, 1217, 1219, 1221, 1224, 
	1224, 1215, 1215, 1227, 1228, 1215, 1215, 1230, 
	1232, 1233, 1233, 1236, 1247, 289, 1253, 1255, 
	1256, 1258, 1236, 1236, 1261, 1261, 1261, 1267, 
	1268, 1270, 1271, 1261, 1261, 1278, 1283, 1288, 
	1261, 1261, 1295, 1295, 1261, 1261, 1232, 1215, 
	1215, 1232, 1215, 1215, 1221, 289, 1312, 1313, 
	1313, 1313, 1313, 1313, 1313, 1319, 1221, 1322, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1362, 1363, 1323, 1323, 
	1367, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1323, 
	1323, 1323, 1323, 1323, 1323, 1323, 1323, 1421, 
	1215, 1422, 0, 1426, 1426, 0, 1430, 1430, 
	1430, 1430, 1434
]

class << self
	attr_accessor :lex_start
end
self.lex_start = 171;
class << self
	attr_accessor :lex_error
end
self.lex_error = 0;

class << self
	attr_accessor :lex_en_interp_words
end
self.lex_en_interp_words = 180;
class << self
	attr_accessor :lex_en_interp_string
end
self.lex_en_interp_string = 245;
class << self
	attr_accessor :lex_en_plain_words
end
self.lex_en_plain_words = 309;
class << self
	attr_accessor :lex_en_plain_string
end
self.lex_en_plain_string = 312;
class << self
	attr_accessor :lex_en_interp_backslash_delimited
end
self.lex_en_interp_backslash_delimited = 314;
class << self
	attr_accessor :lex_en_plain_backslash_delimited
end
self.lex_en_plain_backslash_delimited = 318;
class << self
	attr_accessor :lex_en_interp_backslash_delimited_words
end
self.lex_en_interp_backslash_delimited_words = 319;
class << self
	attr_accessor :lex_en_plain_backslash_delimited_words
end
self.lex_en_plain_backslash_delimited_words = 324;
class << self
	attr_accessor :lex_en_regexp_modifiers
end
self.lex_en_regexp_modifiers = 326;
class << self
	attr_accessor :lex_en_expr_variable
end
self.lex_en_expr_variable = 328;
class << self
	attr_accessor :lex_en_expr_fname
end
self.lex_en_expr_fname = 333;
class << self
	attr_accessor :lex_en_expr_endfn
end
self.lex_en_expr_endfn = 446;
class << self
	attr_accessor :lex_en_expr_dot
end
self.lex_en_expr_dot = 453;
class << self
	attr_accessor :lex_en_expr_arg
end
self.lex_en_expr_arg = 474;
class << self
	attr_accessor :lex_en_expr_cmdarg
end
self.lex_en_expr_cmdarg = 505;
class << self
	attr_accessor :lex_en_expr_endarg
end
self.lex_en_expr_endarg = 511;
class << self
	attr_accessor :lex_en_expr_mid
end
self.lex_en_expr_mid = 519;
class << self
	attr_accessor :lex_en_expr_beg
end
self.lex_en_expr_beg = 543;
class << self
	attr_accessor :lex_en_expr_labelarg
end
self.lex_en_expr_labelarg = 758;
class << self
	attr_accessor :lex_en_expr_value
end
self.lex_en_expr_value = 765;
class << self
	attr_accessor :lex_en_expr_end
end
self.lex_en_expr_end = 773;
class << self
	attr_accessor :lex_en_leading_dot
end
self.lex_en_leading_dot = 946;
class << self
	attr_accessor :lex_en_line_comment
end
self.lex_en_line_comment = 949;
class << self
	attr_accessor :lex_en_line_begin
end
self.lex_en_line_begin = 171;


# line 82 "lib/parser/lexer.rl"
  # %

  ESCAPES = {
    ?a.ord => "\a", ?b.ord  => "\b", ?e.ord => "\e", ?f.ord => "\f",
    ?n.ord => "\n", ?r.ord  => "\r", ?s.ord => "\s", ?t.ord => "\t",
    ?v.ord => "\v", ?\\.ord => "\\"
  }.freeze

  REGEXP_META_CHARACTERS = Regexp.union(*"\\$()*+.<>?[]^{|}".chars).freeze

  RBRACE_OR_RBRACK = %w"} ]".freeze

  attr_reader   :source_buffer

  attr_accessor :diagnostics
  attr_accessor :static_env
  attr_accessor :force_utf32

  attr_accessor :cond, :cmdarg, :in_kwarg

  attr_accessor :tokens, :comments

  def initialize(version)
    @version    = version
    @static_env = nil

    @tokens     = nil
    @comments   = nil

    reset
  end

  def reset(reset_state=true)
    # Ragel state:
    if reset_state
      # Unit tests set state prior to resetting lexer.
      @cs     = self.class.lex_en_line_begin

      @cond   = StackState.new('cond')
      @cmdarg = StackState.new('cmdarg')
      @cond_stack   = []
      @cmdarg_stack = []
    end

    @force_utf32   = false # Set to true by some tests

    @source_pts    = nil # @source as a codepoint array

    @p             = 0   # stream position (saved manually in #advance)
    @ts            = nil # token start
    @te            = nil # token end
    @act           = 0   # next action

    @stack         = []  # state stack
    @top           = 0   # state stack top pointer

    # Lexer state:
    @token_queue   = []
    @literal_stack = []

    @eq_begin_s    = nil # location of last encountered =begin
    @sharp_s       = nil # location of last encountered #

    @newline_s     = nil # location of last encountered newline

    @num_base      = nil # last numeric base
    @num_digits_s  = nil # starting position of numeric digits
    @num_suffix_s  = nil # starting position of numeric suffix
    @num_xfrm      = nil # numeric suffix-induced transformation

    @escape_s      = nil # starting position of current sequence
    @escape        = nil # last escaped sequence, as string

    @herebody_s    = nil # starting position of current heredoc line

    # Ruby 1.9 ->() lambdas emit a distinct token if do/{ is
    # encountered after a matching closing parenthesis.
    @paren_nest    = 0
    @lambda_stack  = []

    # After encountering the closing line of <<~SQUIGGLY_HEREDOC,
    # we store the indentation level and give it out to the parser
    # on request. It is not possible to infer indentation level just
    # from the AST because escape sequences such as `\ ` or `\t` are
    # expanded inside the lexer, but count as non-whitespace for
    # indentation purposes.
    @dedent_level  = nil

    # If the lexer is in `command state' (aka expr_value)
    # at the entry to #advance, it will transition to expr_cmdarg
    # instead of expr_arg at certain points.
    @command_state = false

    # True at the end of "def foo a:"
    @in_kwarg      = false
  end

  def source_buffer=(source_buffer)
    @source_buffer = source_buffer

    if @source_buffer
      source = @source_buffer.source

      if defined?(Encoding) && source.encoding == Encoding::UTF_8
        @source_pts = source.unpack('U*')
      else
        @source_pts = source.unpack('C*')
      end

      if @source_pts[0] == 0xfeff
        # Skip byte order mark.
        @p = 1
      end
    else
      @source_pts = nil
    end
  end

  def encoding
    @source_buffer.source.encoding
  end

  LEX_STATES = {
    :line_begin    => lex_en_line_begin,
    :expr_dot      => lex_en_expr_dot,
    :expr_fname    => lex_en_expr_fname,
    :expr_value    => lex_en_expr_value,
    :expr_beg      => lex_en_expr_beg,
    :expr_mid      => lex_en_expr_mid,
    :expr_arg      => lex_en_expr_arg,
    :expr_cmdarg   => lex_en_expr_cmdarg,
    :expr_end      => lex_en_expr_end,
    :expr_endarg   => lex_en_expr_endarg,
    :expr_endfn    => lex_en_expr_endfn,
    :expr_labelarg => lex_en_expr_labelarg,

    :interp_string => lex_en_interp_string,
    :interp_words  => lex_en_interp_words,
    :plain_string  => lex_en_plain_string,
    :plain_words   => lex_en_plain_string,
  }

  def state
    LEX_STATES.invert.fetch(@cs, @cs)
  end

  def state=(state)
    @cs = LEX_STATES.fetch(state)
  end

  def push_cmdarg
    @cmdarg_stack.push(@cmdarg)
    @cmdarg = StackState.new("cmdarg.#{@cmdarg_stack.count}")
  end

  def pop_cmdarg
    @cmdarg = @cmdarg_stack.pop
  end

  def push_cond
    @cond_stack.push(@cond)
    @cond = StackState.new("cond.#{@cond_stack.count}")
  end

  def pop_cond
    @cond = @cond_stack.pop
  end

  def dedent_level
    # We erase @dedent_level as a precaution to avoid accidentally
    # using a stale value.
    dedent_level, @dedent_level = @dedent_level, nil
    dedent_level
  end

  # Return next token: [type, value].
  def advance
    if @token_queue.any?
      return @token_queue.shift
    end

    # Ugly, but dependent on Ragel output. Consider refactoring it somehow.
    klass = self.class
    _lex_trans_keys         = klass.send :_lex_trans_keys
    _lex_key_spans          = klass.send :_lex_key_spans
    _lex_index_offsets      = klass.send :_lex_index_offsets
    _lex_indicies           = klass.send :_lex_indicies
    _lex_trans_targs        = klass.send :_lex_trans_targs
    _lex_trans_actions      = klass.send :_lex_trans_actions
    _lex_to_state_actions   = klass.send :_lex_to_state_actions
    _lex_from_state_actions = klass.send :_lex_from_state_actions
    _lex_eof_trans          = klass.send :_lex_eof_trans

    pe = @source_pts.size + 2
    p, eof = @p, pe

    @command_state = (@cs == klass.lex_en_expr_value ||
                      @cs == klass.lex_en_line_begin)

    
# line 11015 "lib/parser/lexer.rb"
begin
	testEof = false
	_slen, _trans, _keys, _inds, _acts, _nacts = nil
	_goto_level = 0
	_resume = 10
	_eof_trans = 15
	_again = 20
	_test_eof = 30
	_out = 40
	while true
	if _goto_level <= 0
	if p == pe
		_goto_level = _test_eof
		next
	end
	if  @cs == 0
		_goto_level = _out
		next
	end
	end
	if _goto_level <= _resume
	case _lex_from_state_actions[ @cs] 
	when 84 then
# line 1 "NONE"
		begin
 @ts = p
		end
# line 11043 "lib/parser/lexer.rb"
	end
	_keys =  @cs << 1
	_inds = _lex_index_offsets[ @cs]
	_slen = _lex_key_spans[ @cs]
	_wide = ( (@source_pts[p] || 0))
	_trans = if (   _slen > 0 && 
			_lex_trans_keys[_keys] <= _wide && 
			_wide <= _lex_trans_keys[_keys + 1] 
		    ) then
			_lex_indicies[ _inds + _wide - _lex_trans_keys[_keys] ] 
		 else 
			_lex_indicies[ _inds + _slen ]
		 end
	end
	if _goto_level <= _eof_trans
	 @cs = _lex_trans_targs[_trans]
	if _lex_trans_actions[_trans] != 0
	case _lex_trans_actions[_trans]
	when 28 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 103 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 29 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
	when 56 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
	when 60 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 283 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 36 then
# line 1441 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 38 then
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 40 then
# line 1485 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 66 then
# line 1675 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
	when 323 then
# line 1729 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
	when 352 then
# line 1802 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 428 then
# line 2020 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
	when 422 then
# line 2021 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
	when 425 then
# line 2022 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
	when 419 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
	when 434 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
	when 402 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
	when 414 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 409 then
# line 2083 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 407 then
# line 2084 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 80 then
# line 2219 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 7 then
# line 1 "NONE"
		begin
 @te = p+1
		end
	when 100 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 765
		_goto_level = _again
		next
	end

   end
		end
	when 5 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 96 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 95 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 101 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 98 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 99 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 6 then
# line 845 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 4 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 127 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 765
		_goto_level = _again
		next
	end

   end
		end
	when 10 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 124 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 123 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 128 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 126 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 11 then
# line 845 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 9 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 150 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 149 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 152 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 153 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 156 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 155 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 158 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 165 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 765
		_goto_level = _again
		next
	end

   end
		end
	when 13 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 162 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 161 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 166 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 164 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 12 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 168 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 167 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 175 then
# line 1013 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DBEG, '#{'.freeze)

    if current_literal.heredoc?
      current_literal.saved_herebody_s = @herebody_s
      @herebody_s = nil
    end

    current_literal.start_interp_brace
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 765
		_goto_level = _again
		next
	end

   end
		end
	when 15 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 171 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 170 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 176 then
# line 958 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    current_literal.flush_string
    current_literal.extend_content

    emit(:tSTRING_DVAR, nil, @ts, @ts + 1)

    p = @ts
    	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end

   end
		end
	when 173 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 174 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 14 then
# line 821 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 178 then
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 177 then
# line 821 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    string = tok

    # tLABEL_END is only possible in non-cond context on >= 2.2
    if @version >= 22 && !@cond.active?
      lookahead = @source_buffer.slice(@te...@te+2)
    end

    current_literal = literal
    if !current_literal.heredoc? &&
          (token = current_literal.nest_and_try_closing(string, @ts, @te, lookahead))
      if token[0] == :tLABEL_END
        p += 1
        pop_literal
         @cs = 758;
      else
         @cs = (pop_literal);
      end
      	begin
		p += 1
		_goto_level = _out
		next
	end

    else
      current_literal.extend_string(string, @ts, @te)
    end
   end
		end
	when 180 then
# line 945 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    literal.extend_space @ts, @te
   end
		end
	when 181 then
# line 1103 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tREGEXP_OPT, tok(@ts, @te - 1), @ts, @te - 1)
        p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 182 then
# line 1091 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        unknown_options = tok.scan(/[^imxouesn]/)
        if unknown_options.any?
          diagnostic :error, :regexp_options,
                     { :options => unknown_options.join }
        end

        emit(:tREGEXP_OPT)
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 16 then
# line 1231 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 183 then
# line 1231 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if    tok =~ /^\$([1-9][0-9]*)$/
          emit(:tNTH_REF, tok(@ts + 1).to_i)
        elsif tok =~ /^\$([&`'+])$/
          emit(:tBACK_REF)
        else
          emit(:tGVAR)
        end

         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 185 then
# line 1244 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@@[0-9]/
          diagnostic :error, :cvar_name, { :name => tok }
        end

        emit(:tCVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 184 then
# line 1254 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tok =~ /^@[0-9]/
          diagnostic :error, :ivar_name, { :name => tok }
        end

        emit(:tIVAR)
         @cs = (stack_pop); 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 206 then
# line 1275 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 192 then
# line 1283 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 18 then
# line 1287 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
            @cs = 773; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 189 then
# line 1296 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 201 then
# line 1300 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 20 then
# line 1306 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if version?(23)
          type, delimiter = tok[0..-2], tok[-1].chr
          	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

        else
          p = @ts - 1
          	begin
		 @cs = 773
		_goto_level = _again
		next
	end

        end
       end
		end
	when 188 then
# line 1319 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 187 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 205 then
# line 1275 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 202 then
# line 1279 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 204 then
# line 1283 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 199 then
# line 1287 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
            @cs = 773; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 195 then
# line 1296 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 200 then
# line 1303 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 193 then
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 198 then
# line 1319 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 19 then
# line 1296 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit_table(PUNCTUATION)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 17 then
# line 1319 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 191 then
# line 1 "NONE"
		begin
	case  @act
	when 39 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN);
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 40 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 41 then
	begin begin p = (( @te))-1; end
 emit(:tIDENTIFIER)
            @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
end 
			end
	when 22 then
# line 1331 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           p = p - 1;  @cs = 758; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 208 then
# line 1337 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 207 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 210 then
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 209 then
# line 1337 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 21 then
# line 1337 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 216 then
# line 1363 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 215 then
# line 1369 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 214 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 226 then
# line 1348 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 217 then
# line 1352 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tIDENTIFIER)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 222 then
# line 1363 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 220 then
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 225 then
# line 1369 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 249 then
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 232 then
# line 1445 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 238 then
# line 1469 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 24 then
# line 1477 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 240 then
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 39 then
# line 1497 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 227 then
# line 1511 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 228 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 239 then
# line 1436 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 235 then
# line 1458 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

       end
		end
	when 237 then
# line 1474 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 231 then
# line 1497 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 230 then
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 248 then
# line 1511 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 25 then
# line 1502 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 41 then
# line 1511 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 23 then
# line 1 "NONE"
		begin
	case  @act
	when 67 then
	begin begin p = (( @te))-1; end

        if tok(tm, tm + 1) == '/'.freeze
          # Ambiguous regexp literal.
          diagnostic :warning, :ambiguous_literal, nil, range(tm, tm + 1)
        end

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 68 then
	begin begin p = (( @te))-1; end

        diagnostic :warning, :ambiguous_prefix, { :prefix => tok(tm, @te) },
                   range(tm, @te)

        p = tm - 1
        	begin
		 @cs = 543
		_goto_level = _again
		next
	end

      end
	when 73 then
	begin begin p = (( @te))-1; end

        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

      end
	else
	begin begin p = (( @te))-1; end
end
end 
			end
	when 43 then
# line 1547 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 253 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 254 then
# line 1547 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 44 then
# line 1547 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
  end
		end
	when 42 then
# line 1 "NONE"
		begin
	case  @act
	when 80 then
	begin begin p = (( @te))-1; end

        if @cond.active?
          emit(:kDO_COND, 'do'.freeze, @te - 2, @te)
        else
          emit(:kDO, 'do'.freeze, @te - 2, @te)
        end
         @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 81 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 474
		_goto_level = _again
		next
	end
 end
end 
			end
	when 264 then
# line 1581 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_do(true)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 257 then
# line 1587 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 258 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 259 then
# line 1584 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 262 then
# line 1587 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 268 then
# line 1611 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 267 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 276 then
# line 1603 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 270 then
# line 1605 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 274 then
# line 1611 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 269 then
# line 1 "NONE"
		begin
	case  @act
	when 88 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 89 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
 end
end 
			end
	when 53 then
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 305 then
# line 1643 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type = delimiter = tok[0].chr
        p = p - 1; 	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 299 then
# line 1650 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = @source_buffer.slice(@ts).chr, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 51 then
# line 1657 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 306 then
# line 1703 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 65 then
# line 1717 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 320 then
# line 1748 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 319 then
# line 1758 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 307 then
# line 1797 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 48 then
# line 1817 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = p - 1;

        if version?(18)
          ident = tok(@ts, @te - 2)

          emit((@source_buffer.slice(@ts) =~ /[A-Z]/) ? :tCONSTANT : :tIDENTIFIER,
               ident, @ts, @te - 2)
          p = p - 1; # continue as a symbol

          if !@static_env.nil? && @static_env.declared?(ident)
             @cs = 773;
          else
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:tLABEL, tok(@ts, @te - 2), @ts, @te - 1)
           @cs = 758;
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 293 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 171
		_goto_level = _again
		next
	end
  end
		end
	when 52 then
# line 1876 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 279 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 304 then
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 303 then
# line 1633 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tSTAR, '*'.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 300 then
# line 1657 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        type, delimiter = tok[0..-2], tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 298 then
# line 1663 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 308 then
# line 1717 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1), @ts)
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 318 then
# line 1758 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :incomplete_escape, nil, range(@ts, @ts + 1)
       end
		end
	when 324 then
# line 1764 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 301 then
# line 1797 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 346 then
# line 1216 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 290 then
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 292 then
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 171
		_goto_level = _again
		next
	end
  end
		end
	when 295 then
# line 1876 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 50 then
# line 1663 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :string_eof, nil, range(@ts, @ts + 1)
       end
		end
	when 68 then
# line 1731 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 49 then
# line 1860 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
		end
	when 64 then
# line 1876 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = @ts - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 47 then
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 111 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 112 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
 end
	when 116 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
 end
end 
			end
	when 354 then
# line 1896 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 355 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 356 then
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 360 then
# line 1896 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 71 then
# line 1906 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 364 then
# line 1911 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        	begin
		 @cs = (push_literal(tok, tok, @ts))
		_goto_level = _again
		next
	end

       end
		end
	when 363 then
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 362 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 366 then
# line 1915 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 365 then
# line 1921 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 70 then
# line 1921 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 543
		_goto_level = _again
		next
	end
  end
		end
	when 396 then
# line 1932 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tLAMBDA, '->'.freeze, @ts, @ts + 2)

        @lambda_stack.push @paren_nest
         @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 78 then
# line 1969 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 374 then
# line 2104 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        type, delimiter = tok, tok[-1].chr
        	begin
		 @cs = (push_literal(type, delimiter, @ts, nil, false, false, true))
		_goto_level = _again
		next
	end

       end
		end
	when 73 then
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 393 then
# line 2129 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 387 then
# line 2156 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 380 then
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 511;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 392 then
# line 2174 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tOP_ASGN, tok(@ts, @te - 1))
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 378 then
# line 2178 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tEH, '?'.freeze)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 375 then
# line 2186 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 377 then
# line 2199 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tSEMI, ';'.freeze)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 442 then
# line 2202 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :error, :bare_backslash, nil, range(@ts, @ts + 1)
        p = p - 1;
       end
		end
	when 373 then
# line 2208 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 372 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 452 then
# line 1965 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 450 then
# line 1969 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 449 then
# line 1980 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(KEYWORDS)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 399 then
# line 2054 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 439 then
# line 2114 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 391 then
# line 2122 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1; 	begin
		 @stack[ @top] =  @cs
		 @top+= 1
		 @cs = 328
		_goto_level = _again
		next
	end
  end
		end
	when 397 then
# line 2129 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 453; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 444 then
# line 1216 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
   end
		end
	when 386 then
# line 2156 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 398 then
# line 2186 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 384 then
# line 2193 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 390 then
# line 2208 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 74 then
# line 2054 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :error, :no_dot_digit_literal
       end
		end
	when 72 then
# line 2208 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin 
        diagnostic :fatal, :unexpected, { :character => tok.inspect[1..-2] }
       end
		end
	when 75 then
# line 1 "NONE"
		begin
	case  @act
	when 132 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 133 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 134 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 135 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 139 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 145 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 152 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
end 
			end
	when 82 then
# line 2220 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 457 then
# line 2223 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 171; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 458 then
# line 2223 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 171; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 79 then
# line 2223 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  emit(:tNL, nil, @newline_s, @newline_s + 1)
           p = p - 1;  @cs = 171; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 461 then
# line 2233 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = 171
		_goto_level = _again
		next
	end

       end
		end
	when 460 then
# line 2241 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        diagnostic :fatal, :embedded_document, nil,
                   range(@eq_begin_s, @eq_begin_s + '=begin'.length)
       end
		end
	when 93 then
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 949
		_goto_level = _again
		next
	end
  end
		end
	when 2 then
# line 2255 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 85 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = p - 1; 	begin
		 @cs = 765
		_goto_level = _again
		next
	end
  end
		end
	when 86 then
# line 518 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    # Sit at EOF indefinitely. #advance would return $eof each time.
    # This allows to feed the lexer more data if needed; this is only used
    # in tests.
    #
    # Note that this action is not embedded into e_eof like e_heredoc_nl and e_bs
    # below. This is due to the fact that scanner state at EOF is observed
    # by tests, and encapsulating it in a rule would break the introspection.
    p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

   end
		end
	when 87 then
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 92 then
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  @eq_begin_s = @ts
           	begin
		 @cs = 949
		_goto_level = _again
		next
	end
  end
		end
	when 91 then
# line 2258 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 765
		_goto_level = _again
		next
	end
  end
		end
	when 1 then
# line 2258 "lib/parser/lexer.rl"
		begin
 begin p = (( @te))-1; end
 begin  p = p - 1; 	begin
		 @cs = 765
		_goto_level = _again
		next
	end
  end
		end
	when 63 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 97 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 125 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 151 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 157 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 163 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 169 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 172 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 179 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
	when 250 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1427 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        # Unlike expr_beg as invoked in the next rule, do not warn
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 241 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1486 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 233 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1497 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 321 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1748 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        escape = { " "  => '\s', "\r" => '\r', "\n" => '\n', "\t" => '\t',
                   "\v" => '\v', "\f" => '\f' }[@source_buffer.slice(@ts + 1)]
        diagnostic :warning, :invalid_escape_use, { :escape => escape }, range

        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 294 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1863 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = @ts - 1
           	begin
		 @cs = 171
		_goto_level = _again
		next
	end
  end
		end
	when 462 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2233 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit_comment(@eq_begin_s, @te)
        	begin
		 @cs = 171
		_goto_level = _again
		next
	end

       end
		end
	when 459 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2238 "lib/parser/lexer.rl"
		begin
 @te = p+1
		end
	when 94 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2251 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  @eq_begin_s = @ts
           	begin
		 @cs = 949
		_goto_level = _again
		next
	end
  end
		end
	when 3 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 2255 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = pe - 3  end
		end
	when 416 then
# line 626 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 415 then
# line 627 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, chars)) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 417 then
# line 628 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 410 then
# line 632 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Float(chars))) } 		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 411 then
# line 636 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tRATIONAL,  Rational(chars)) } 		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 412 then
# line 637 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tIMAGINARY, Complex(0, Rational(chars))) } 		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 120 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 146 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 342 then
# line 652 "lib/parser/lexer.rl"
		begin

    @escape = ""

    codepoints  = tok(@escape_s + 2, p - 1)
    codepoint_s = @escape_s + 2

    codepoints.split(/[ \t]/).each do |codepoint_str|
      codepoint = codepoint_str.to_i(16)

      if codepoint >= 0x110000
        diagnostic :error, :unicode_point_too_large, nil,
                   range(codepoint_s, codepoint_s + codepoint_str.length)
        break
      end

      @escape     += codepoint.chr(Encoding::UTF_8)
      codepoint_s += codepoint_str.length + 1
    end
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 104 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 130 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 326 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 107 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 133 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 329 then
# line 679 "lib/parser/lexer.rl"
		begin

    diagnostic :fatal, :invalid_escape
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 109 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 135 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 331 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 106 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 132 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 328 then
# line 705 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s, p).to_i(8) % 0x100) 		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 122 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 148 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 344 then
# line 709 "lib/parser/lexer.rl"
		begin
 @escape = encode_escape(tok(@escape_s + 1, p).to_i(16)) 		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 117 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 143 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 339 then
# line 713 "lib/parser/lexer.rl"
		begin
 @escape = tok(@escape_s + 1, p).to_i(16).chr(Encoding::UTF_8) 		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 121 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 147 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 343 then
# line 717 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_hex_escape, nil, range(@escape_s - 1, p + 2)
      		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 116 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 142 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 338 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 119 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 145 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 341 then
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 105 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 131 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 327 then
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 154 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 159 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 54 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 30 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1441 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 32 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 34 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1485 "lib/parser/lexer.rl"
		begin
 tm = p 		end
	when 194 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 213 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 221 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 33 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1497 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        p = @ts - 1
        	begin
		 @cs = 773
		_goto_level = _again
		next
	end

       end
		end
	when 252 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 244 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1508 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 263 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 275 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1605 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 271 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1608 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 55 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 291 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 361 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 357 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1887 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
      if @in_kwarg
        p = p - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end

      else
        	begin
		 @cs = 171
		_goto_level = _again
		next
	end

      end
     end
		end
	when 370 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1915 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 367 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1918 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 171
		_goto_level = _again
		next
	end
  end
		end
	when 443 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2193 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 385 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2196 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 946
		_goto_level = _again
		next
	end
  end
		end
	when 88 then
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 243 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1410 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          p = @ts - 1
          	begin
		 @cs = 773
		_goto_level = _again
		next
	end

        else
          emit(:tLCURLY, '{'.freeze, @te - 1, @te)
           @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 265 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1570 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE_ARG, '{'.freeze)
        end
         @cs = 765;
       end
		end
	when 353 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1775 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop
          emit(:tLAMBEG, '{'.freeze)
        else
          emit(:tLBRACE, '{'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 455 then
# line 983 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    current_literal = literal
    if current_literal
      current_literal.start_interp_brace
    end
  		end
# line 1940 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 456 then
# line 992 "lib/parser/lexer.rl"
		begin

    current_literal = literal
    if current_literal
      if current_literal.end_interp_brace_and_try_closing
        if version?(18, 19)
          emit(:tRCURLY, '}'.freeze, p - 1, p)
        else
          emit(:tSTRING_DEND, '}'.freeze, p - 1, p)
        end

        if current_literal.saved_herebody_s
          @herebody_s = current_literal.saved_herebody_s
        end

        p = p - 1;
         @cs = (stack_pop);
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
    end
  		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 511;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 57 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
	when 61 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 197 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 212 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 224 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 246 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 261 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 273 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1605 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 297 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 359 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 369 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1915 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 389 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2193 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 90 then
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 218 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1356 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 309 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 282 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 382 then
# line 1172 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1 "NONE"
		begin
	case  @act
	when 132 then
	begin begin p = (( @te))-1; end

        if @lambda_stack.last == @paren_nest
          @lambda_stack.pop

          if tok == '{'.freeze
            emit(:tLAMBEG, '{'.freeze)
          else # 'do'
            emit(:kDO_LAMBDA, 'do'.freeze)
          end
        else
          if tok == '{'.freeze
            emit(:tLCURLY, '{'.freeze)
          else # 'do'
            emit_do
          end
        end

         @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 133 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 333; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 134 then
	begin begin p = (( @te))-1; end
 emit(:kCLASS, 'class'.freeze, @ts, @ts + 5)
           emit(:tLSHFT, '<<'.freeze,    @te - 2, @te)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 135 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 136 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 137 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 138 then
	begin begin p = (( @te))-1; end

        emit_table(KEYWORDS)

        if version?(18) && tok == 'not'.freeze
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 139 then
	begin begin p = (( @te))-1; end

        if version?(18)
          emit(:tIDENTIFIER)

          unless !@static_env.nil? && @static_env.declared?(tok)
             @cs = (arg_or_cmdarg);
          end
        else
          emit(:k__ENCODING__, '__ENCODING__'.freeze)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 140 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 141 then
	begin begin p = (( @te))-1; end

        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 143 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tINTEGER, tok(@ts, @te - 1).to_i, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 144 then
	begin begin p = (( @te))-1; end

        if version?(18, 19, 20)
          diagnostic :error,
                     :trailing_in_number, { :character => tok(@te - 1, @te) },
                     range(@te - 1, @te)
        else
          emit(:tFLOAT, tok(@ts, @te - 1).to_f, @ts, @te - 1)
          p = p - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
      end
	when 145 then
	begin begin p = (( @te))-1; end

        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 147 then
	begin begin p = (( @te))-1; end
 emit(:tCONSTANT)
            @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 151 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 152 then
	begin begin p = (( @te))-1; end

        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
end 
			end
	when 219 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1356 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tFID, tok(@ts, tm), @ts, tm)
            @cs = (arg_or_cmdarg); p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 310 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 284 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 383 then
# line 1173 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2136 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if tm == @te
          # Suffix was consumed, e.g. foo!
          emit(:tFID)
        else
          # Suffix was not consumed, e.g. foo!=
          emit(:tIDENTIFIER, tok(@ts, tm), @ts, tm)
          p = tm - 1
        end
         @cs = 474; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 311 then
# line 1178 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 285 then
# line 1178 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 312 then
# line 1179 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 286 then
# line 1179 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 316 then
# line 1180 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 289 then
# line 1180 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 315 then
# line 1181 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 288 then
# line 1181 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1 "NONE"
		begin
	case  @act
	when 94 then
	begin begin p = (( @te))-1; end

        emit(:tUNARY_NUM, tok(@ts, @ts + 1), @ts, @ts + 1)
        p = p - 1;  @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

      end
	when 111 then
	begin begin p = (( @te))-1; end
 emit_table(PUNCTUATION_BEGIN)
           	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 112 then
	begin begin p = (( @te))-1; end
 emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 113 then
	begin begin p = (( @te))-1; end
 emit_table(KEYWORDS_BEGIN)
            @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end
 end
	when 115 then
	begin begin p = (( @te))-1; end
 p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
 end
	when 116 then
	begin begin p = (( @te))-1; end

    emit(:tIDENTIFIER)

    if !@static_env.nil? && @static_env.declared?(tok)
       @cs = 446; 	begin
		p += 1
		_goto_level = _out
		next
	end

    else
       @cs = (arg_or_cmdarg); 	begin
		p += 1
		_goto_level = _out
		next
	end

    end
  end
	when 119 then
	begin begin p = (( @te))-1; end
 p = @ts - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
 end
end 
			end
	when 313 then
# line 1182 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 287 then
# line 1182 "lib/parser/lexer.rl"
		begin
 tm = p - 3 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  p = @ts - 1
           	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 314 then
# line 1187 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 1709 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tSYMBOL, tok(@ts + 1, tm), @ts, tm)
        p = tm - 1
         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 438 then
# line 1192 "lib/parser/lexer.rl"
		begin
 tm = p - 2 		end
# line 2118 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tCONSTANT, tok(@ts, tm), @ts, tm)
           p = tm - 1; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 242 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1404 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze, @te - 1, @te)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 345 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 1787 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK, '['.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 441 then
# line 1198 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)
  		end
# line 2182 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLBRACK2, '['.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 234 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1385 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        if version?(18)
          emit(:tLPAREN2, '('.freeze, @te - 1, @te)
           @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
          emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 247 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1398 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN2, '('.freeze)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 255 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1524 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit(:tLPAREN_ARG, '('.freeze, @te - 1, @te)
        if version?(18)
           @cs = 765; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        end
       end
		end
	when 302 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 1792 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:tLPAREN, '('.freeze)
           	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 394 then
# line 1205 "lib/parser/lexer.rl"
		begin

    @cond.push(false); @cmdarg.push(false)

    @paren_nest += 1
  		end
# line 2156 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit_table(PUNCTUATION)
            @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 395 then
# line 1211 "lib/parser/lexer.rl"
		begin

    @paren_nest -= 1
  		end
# line 2160 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        emit_table(PUNCTUATION)
        @cond.lexpop; @cmdarg.lexpop

        if RBRACE_OR_RBRACK.include?(tok)
           @cs = 511;
        else # )
          # fnext expr_endfn; ?
        end

        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 67 then
# line 1675 "lib/parser/lexer.rl"
		begin
 heredoc_e      = p 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 317 then
# line 1676 "lib/parser/lexer.rl"
		begin
 new_herebody_s = p 		end
# line 1677 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        tok(@ts, heredoc_e) =~ /^<<(-?)(~?)(["'`]?)(.*)\3$/

        indent      = !$1.empty? || !$2.empty?
        dedent_body = !$2.empty?
        type        =  $3.empty? ? '<<"'.freeze : ('<<'.freeze + $3)
        delimiter   =  $4

        if dedent_body && version?(18, 19, 20, 21, 22)
          emit(:tLSHFT, '<<'.freeze, @ts, @ts + 2)
          p = @ts + 1
           @cs = 543; 	begin
		p += 1
		_goto_level = _out
		next
	end

        else
           @cs = (push_literal(type, delimiter, @ts, heredoc_e, indent, dedent_body));

          @herebody_s ||= new_herebody_s
          p = @herebody_s - 1
        end
       end
		end
	when 322 then
# line 1729 "lib/parser/lexer.rl"
		begin
 @escape = nil 		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 349 then
# line 1802 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1803 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  emit(:kRESCUE, 'rescue'.freeze, @ts, tm)
           p = tm - 1
            @cs = 519; 	begin
		p += 1
		_goto_level = _out
		next
	end
  end
		end
	when 429 then
# line 2020 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 423 then
# line 2021 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 426 then
# line 2022 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 420 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 435 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 404 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
	when 436 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 81 then
# line 2219 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 2220 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin  p = tm - 1; 	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 8 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 203 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1275 "lib/parser/lexer.rl"
		begin
 @act = 39;		end
	when 190 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1279 "lib/parser/lexer.rl"
		begin
 @act = 40;		end
	when 186 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1283 "lib/parser/lexer.rl"
		begin
 @act = 41;		end
	when 26 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1445 "lib/parser/lexer.rl"
		begin
 @act = 67;		end
	when 236 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 27 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1497 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 229 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 256 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1534 "lib/parser/lexer.rl"
		begin
 @act = 80;		end
	when 45 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1547 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 277 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1599 "lib/parser/lexer.rl"
		begin
 @act = 88;		end
	when 266 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1603 "lib/parser/lexer.rl"
		begin
 @act = 89;		end
	when 280 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1797 "lib/parser/lexer.rl"
		begin
 @act = 111;		end
	when 348 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1803 "lib/parser/lexer.rl"
		begin
 @act = 112;		end
	when 347 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1809 "lib/parser/lexer.rl"
		begin
 @act = 113;		end
	when 69 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 278 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 281 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1876 "lib/parser/lexer.rl"
		begin
 @act = 119;		end
	when 451 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1940 "lib/parser/lexer.rl"
		begin
 @act = 132;		end
	when 446 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1965 "lib/parser/lexer.rl"
		begin
 @act = 133;		end
	when 454 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1975 "lib/parser/lexer.rl"
		begin
 @act = 135;		end
	when 447 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1980 "lib/parser/lexer.rl"
		begin
 @act = 136;		end
	when 448 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1984 "lib/parser/lexer.rl"
		begin
 @act = 137;		end
	when 453 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1988 "lib/parser/lexer.rl"
		begin
 @act = 138;		end
	when 445 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1999 "lib/parser/lexer.rl"
		begin
 @act = 139;		end
	when 440 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2013 "lib/parser/lexer.rl"
		begin
 @act = 140;		end
	when 376 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 406 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2071 "lib/parser/lexer.rl"
		begin
 @act = 144;		end
	when 76 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @act = 145;		end
	when 379 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2114 "lib/parser/lexer.rl"
		begin
 @act = 147;		end
	when 371 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 151;		end
	when 381 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2136 "lib/parser/lexer.rl"
		begin
 @act = 152;		end
	when 160 then
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 883 "lib/parser/lexer.rl"
		begin
 @te = p+1
 begin 
    current_literal = literal
    if @te == pe
      diagnostic :fatal, :string_eof, nil,
                 range(current_literal.str_s, current_literal.str_s + 1)
    end

    if current_literal.heredoc?
      line = tok(@herebody_s, @ts).gsub(/\r+$/, ''.freeze)

      if version?(18, 19, 20)
        # See ruby:c48b4209c
        line = line.gsub(/\r.*$/, ''.freeze)
      end

      # Try ending the heredoc with the complete most recently
      # scanned line. @herebody_s always refers to the start of such line.
      if current_literal.nest_and_try_closing(line, @herebody_s, @ts)
        # Adjust @herebody_s to point to the next line.
        @herebody_s = @te

        # Continue regular lexing after the heredoc reference (<<END).
        p = current_literal.heredoc_e - 1
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      else
        # Calculate indentation level for <<~HEREDOCs.
        current_literal.infer_indent_level(line)

        # Ditto.
        @herebody_s = @te
      end
    else
      # Try ending the literal with a newline.
      if current_literal.nest_and_try_closing(tok, @ts, @te)
         @cs = (pop_literal); 	begin
		p += 1
		_goto_level = _out
		next
	end

      end

      if @herebody_s
        # This is a regular literal intertwined with a heredoc. Like:
        #
        #     p <<-foo+"1
        #     bar
        #     foo
        #     2"
        #
        # which, incidentally, evaluates to "bar\n1\n2".
        p = @herebody_s - 1
        @herebody_s = nil
      end
    end

    if current_literal.words? && !eof_codepoint?(@source_pts[p])
      current_literal.extend_space @ts, @te
    else
      # A literal newline is appended if the heredoc was _not_ closed
      # this time (see fbreak above). See also Literal#nest_and_try_closing
      # for rationale of calling #flush_string here.
      current_literal.extend_string tok, @ts, @te
      current_literal.flush_string
    end
   end
		end
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
	when 110 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 136 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 332 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 115 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 141 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 337 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 114 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 140 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 336 then
# line 693 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 112 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 138 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 334 then
# line 698 "lib/parser/lexer.rl"
		begin
 @escape = "\x7f" 		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 108 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 134 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 330 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 118 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 144 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 340 then
# line 729 "lib/parser/lexer.rl"
		begin

        diagnostic :fatal, :invalid_unicode_escape, nil, range(@escape_s - 1, p)
      		end
# line 740 "lib/parser/lexer.rl"
		begin

          diagnostic :fatal, :unterminated_unicode, nil, range(p - 1, p)
        		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 102 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 129 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 325 then
# line 772 "lib/parser/lexer.rl"
		begin

    @escape_s = p
    @escape   = nil
  		end
# line 766 "lib/parser/lexer.rl"
		begin

      diagnostic :fatal, :escape_eof, nil, range(p - 1, p)
    		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 58 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
	when 196 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1316 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 211 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1334 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 223 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1366 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 245 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1505 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin  	begin
		 @cs = 773
		_goto_level = _again
		next
	end
  end
		end
	when 260 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1584 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 272 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1605 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 296 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1860 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 358 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1884 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 368 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1915 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 388 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2193 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 89 then
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 2248 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1;		end
	when 431 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 401 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
	when 413 then
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 408 then
# line 2083 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 405 then
# line 2084 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 631 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tFLOAT,     Float(chars)) } 		end
# line 2086 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@ts, @num_suffix_s)

        if version?(18, 19, 20)
          emit(:tFLOAT, Float(digits), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits)
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 251 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 492 "lib/parser/lexer.rl"
		begin

    # Record position of a newline for precise location reporting on tNL
    # tokens.
    #
    # This action is embedded directly into c_nl, as it is idempotent and
    # there are no cases when we need to skip it.
    @newline_s = p
  		end
# line 1502 "lib/parser/lexer.rl"
		begin
 @act = 74;		end
	when 35 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1497 "lib/parser/lexer.rl"
		begin
 @act = 73;		end
	when 46 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1547 "lib/parser/lexer.rl"
		begin
 @act = 81;		end
	when 62 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 77 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1969 "lib/parser/lexer.rl"
		begin
 @act = 134;		end
	when 37 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 351 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1802 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1848 "lib/parser/lexer.rl"
		begin
 @act = 115;		end
	when 350 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1802 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1216 "lib/parser/lexer.rl"
		begin
 @act = 116;		end
	when 432 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @act = 141;		end
	when 113 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 139 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 335 then
# line 672 "lib/parser/lexer.rl"
		begin

    codepoint = @source_pts[p - 1]
    if (@escape = ESCAPES[codepoint]).nil?
      @escape = encode_escape(@source_buffer.slice(p - 1))
    end
  		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 111 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 137 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 845 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
    current_literal = literal
    # Get the first character after the backslash.
    escaped_char = @source_buffer.slice(@escape_s).chr

    if current_literal.munge_escape? escaped_char
      # If this particular literal uses this character as an opening
      # or closing delimiter, it is an escape sequence for that
      # particular character. Write it without the backslash.

      if current_literal.regexp? && REGEXP_META_CHARACTERS.match(escaped_char)
        # Regular expressions should include escaped delimiters in their
        # escaped form, except when the escaped character is
        # a closing delimiter but not a regexp metacharacter.
        #
        # The backslash itself cannot be used as a closing delimiter
        # at the same time as an escape symbol, but it is always munged,
        # so this branch also executes for the non-closing-delimiter case
        # for the backslash.
        current_literal.extend_string(tok, @ts, @te)
      else
        current_literal.extend_string(escaped_char, @ts, @te)
      end
    else
      # It does not. So this is an actual escape sequence, yay!
      if current_literal.regexp?
        # Regular expressions should include escape sequences in their
        # escaped form. On the other hand, escaped newlines are removed.
        current_literal.extend_string(tok.gsub("\\\n".freeze, ''.freeze), @ts, @te)
      else
        current_literal.extend_string(@escape || tok, @ts, @te)
      end
    end
   end
		end
	when 333 then
# line 699 "lib/parser/lexer.rl"
		begin
 @escape = @source_buffer.slice(p - 1).chr 		end
# line 683 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord & 0x9f)
  		end
# line 687 "lib/parser/lexer.rl"
		begin

    @escape = encode_escape(@escape[0].ord | 0x80)
  		end
# line 1731 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        value = @escape || tok(@ts + 1)

        if version?(18)
          if defined?(Encoding)
            emit(:tINTEGER, value.dup.force_encoding(Encoding::BINARY)[0].ord)
          else
            emit(:tINTEGER, value[0].ord)
          end
        else
          emit(:tCHARACTER, value)
        end

         @cs = 773; 	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 427 then
# line 2020 "lib/parser/lexer.rl"
		begin
 @num_base = 16; @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 421 then
# line 2021 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 424 then
# line 2022 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 418 then
# line 2023 "lib/parser/lexer.rl"
		begin
 @num_base = 2;  @num_digits_s = p 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 430 then
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 400 then
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2027 "lib/parser/lexer.rl"
		begin
 @te = p
p = p - 1; begin 
        digits = tok(@num_digits_s, @num_suffix_s)

        if digits.end_with? '_'.freeze
          diagnostic :error, :trailing_in_number, { :character => '_'.freeze },
                     range(@te - 1, @te)
        elsif digits.empty? && @num_base == 8 && version?(18)
          # 1.8 did not raise an error on 0o.
          digits = '0'.freeze
        elsif digits.empty?
          diagnostic :error, :empty_numeric
        elsif @num_base == 8 && (invalid_idx = digits.index(/[89]/))
          invalid_s = @num_digits_s + invalid_idx
          diagnostic :error, :invalid_octal, nil,
                     range(invalid_s, invalid_s + 1)
        end

        if version?(18, 19, 20)
          emit(:tINTEGER, digits.to_i(@num_base), @ts, @num_suffix_s)
          p = @num_suffix_s - 1
        else
          @num_xfrm.call(digits.to_i(@num_base))
        end
        	begin
		p += 1
		_goto_level = _out
		next
	end

       end
		end
	when 31 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 812 "lib/parser/lexer.rl"
		begin

    # After every heredoc was parsed, @herebody_s contains the
    # position of next token after all heredocs.
    if @herebody_s
      p = @herebody_s
      @herebody_s = nil
    end
  		end
# line 1457 "lib/parser/lexer.rl"
		begin
 tm = p 		end
# line 1458 "lib/parser/lexer.rl"
		begin
 @act = 68;		end
	when 59 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 1128 "lib/parser/lexer.rl"
		begin
 @sharp_s = p - 1 		end
# line 1131 "lib/parser/lexer.rl"
		begin
 emit_comment(@sharp_s, p == pe ? p - 2 : p) 		end
# line 1626 "lib/parser/lexer.rl"
		begin
 @act = 94;		end
	when 437 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2059 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 433 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2024 "lib/parser/lexer.rl"
		begin
 @num_base = 10; @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2059 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
	when 403 then
# line 1 "NONE"
		begin
 @te = p+1
		end
# line 2025 "lib/parser/lexer.rl"
		begin
 @num_base = 8;  @num_digits_s = @ts 		end
# line 2026 "lib/parser/lexer.rl"
		begin
 @num_suffix_s = p 		end
# line 625 "lib/parser/lexer.rl"
		begin
 @num_xfrm = lambda { |chars| emit(:tINTEGER,   chars) } 		end
# line 2059 "lib/parser/lexer.rl"
		begin
 @act = 143;		end
# line 21651 "lib/parser/lexer.rb"
	end
	end
	end
	if _goto_level <= _again
	case _lex_to_state_actions[ @cs] 
	when 83 then
# line 1 "NONE"
		begin
 @ts = nil;		end
# line 21661 "lib/parser/lexer.rb"
	end

	if  @cs == 0
		_goto_level = _out
		next
	end
	p += 1
	if p != pe
		_goto_level = _resume
		next
	end
	end
	if _goto_level <= _test_eof
	if p == eof
	if _lex_eof_trans[ @cs] > 0
		_trans = _lex_eof_trans[ @cs] - 1;
		_goto_level = _eof_trans
		next;
	end
	end

	end
	if _goto_level <= _out
		break
	end
end
	end

# line 282 "lib/parser/lexer.rl"
    # %

    @p = p

    if @token_queue.any?
      @token_queue.shift
    elsif @cs == klass.lex_error
      [ false, [ '$error'.freeze, range(p - 1, p) ] ]
    else
      eof = @source_pts.size
      [ false, [ '$eof'.freeze,   range(eof, eof) ] ]
    end
  end

  protected

  def eof_codepoint?(point)
    [0x04, 0x1a, 0x00].include? point
  end

  def version?(*versions)
    versions.include?(@version)
  end

  def stack_pop
    @top -= 1
    @stack[@top]
  end

  if defined?(Encoding)
    def encode_escape(ord)
      ord.chr.force_encoding(@source_buffer.source.encoding)
    end
  else
    def encode_escape(ord)
      ord.chr
    end
  end

  def tok(s = @ts, e = @te)
    @source_buffer.slice(s...e)
  end

  def range(s = @ts, e = @te)
    Parser::Source::Range.new(@source_buffer, s, e)
  end

  def emit(type, value = tok, s = @ts, e = @te)
    token = [ type, [ value, range(s, e) ] ]

    @token_queue.push(token)

    @tokens.push(token) if @tokens

    token
  end

  def emit_table(table, s = @ts, e = @te)
    value = tok(s, e)

    emit(table[value], value, s, e)
  end

  def emit_do(do_block=false)
    if @cond.active?
      emit(:kDO_COND, 'do'.freeze)
    elsif @cmdarg.active? || do_block
      emit(:kDO_BLOCK, 'do'.freeze)
    else
      emit(:kDO, 'do'.freeze)
    end
  end

  def arg_or_cmdarg
    if @command_state
      self.class.lex_en_expr_cmdarg
    else
      self.class.lex_en_expr_arg
    end
  end

  def emit_comment(s = @ts, e = @te)
    if @comments
      @comments.push(Parser::Source::Comment.new(range(s, e)))
    end

    if @tokens
      @tokens.push([ :tCOMMENT, [ tok(s, e), range(s, e) ] ])
    end

    nil
  end

  def diagnostic(type, reason, arguments=nil, location=range, highlights=[])
    @diagnostics.process(
        Parser::Diagnostic.new(type, reason, arguments, location, highlights))
  end

  #
  # === LITERAL STACK ===
  #

  def push_literal(*args)
    new_literal = Literal.new(self, *args)
    @literal_stack.push(new_literal)

    if new_literal.words? && new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_backslash_delimited_words
      else
        self.class.lex_en_plain_backslash_delimited_words
      end
    elsif new_literal.words? && !new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_words
      else
        self.class.lex_en_plain_words
      end
    elsif !new_literal.words? && new_literal.backslash_delimited?
      if new_literal.interpolate?
        self.class.lex_en_interp_backslash_delimited
      else
        self.class.lex_en_plain_backslash_delimited
      end
    else
      if new_literal.interpolate?
        self.class.lex_en_interp_string
      else
        self.class.lex_en_plain_string
      end
    end
  end

  def literal
    @literal_stack.last
  end

  def pop_literal
    old_literal = @literal_stack.pop

    @dedent_level = old_literal.dedent_level

    if old_literal.type == :tREGEXP_BEG
      # Fetch modifiers.
      self.class.lex_en_regexp_modifiers
    else
      self.class.lex_en_expr_end
    end
  end

  # Mapping of strings to parser tokens.

  PUNCTUATION = {
    '='   => :tEQL,     '&'   => :tAMPER2,  '|'   => :tPIPE,
    '!'   => :tBANG,    '^'   => :tCARET,   '+'   => :tPLUS,
    '-'   => :tMINUS,   '*'   => :tSTAR2,   '/'   => :tDIVIDE,
    '%'   => :tPERCENT, '~'   => :tTILDE,   ','   => :tCOMMA,
    ';'   => :tSEMI,    '.'   => :tDOT,     '..'  => :tDOT2,
    '...' => :tDOT3,    '['   => :tLBRACK2, ']'   => :tRBRACK,
    '('   => :tLPAREN2, ')'   => :tRPAREN,  '?'   => :tEH,
    ':'   => :tCOLON,   '&&'  => :tANDOP,   '||'  => :tOROP,
    '-@'  => :tUMINUS,  '+@'  => :tUPLUS,   '~@'  => :tTILDE,
    '**'  => :tPOW,     '->'  => :tLAMBDA,  '=~'  => :tMATCH,
    '!~'  => :tNMATCH,  '=='  => :tEQ,      '!='  => :tNEQ,
    '>'   => :tGT,      '>>'  => :tRSHFT,   '>='  => :tGEQ,
    '<'   => :tLT,      '<<'  => :tLSHFT,   '<='  => :tLEQ,
    '=>'  => :tASSOC,   '::'  => :tCOLON2,  '===' => :tEQQ,
    '<=>' => :tCMP,     '[]'  => :tAREF,    '[]=' => :tASET,
    '{'   => :tLCURLY,  '}'   => :tRCURLY,  '`'   => :tBACK_REF2,
    '!@'  => :tBANG,    '&.'  => :tANDDOT,
  }

  PUNCTUATION_BEGIN = {
    '&'   => :tAMPER,   '*'   => :tSTAR,    '**'  => :tDSTAR,
    '+'   => :tUPLUS,   '-'   => :tUMINUS,  '::'  => :tCOLON3,
    '('   => :tLPAREN,  '{'   => :tLBRACE,  '['   => :tLBRACK,
  }

  KEYWORDS = {
    'if'     => :kIF_MOD,      'unless'   => :kUNLESS_MOD,
    'while'  => :kWHILE_MOD,   'until'    => :kUNTIL_MOD,
    'rescue' => :kRESCUE_MOD,  'defined?' => :kDEFINED,
    'BEGIN'  => :klBEGIN,      'END'      => :klEND,
  }

  KEYWORDS_BEGIN = {
    'if'     => :kIF,          'unless'   => :kUNLESS,
    'while'  => :kWHILE,       'until'    => :kUNTIL,
    'rescue' => :kRESCUE,      'defined?' => :kDEFINED,
  }

  %w(class module def undef begin end then elsif else ensure case when
     for break next redo retry in do return yield super self nil true
     false and or not alias __FILE__ __LINE__ __ENCODING__).each do |keyword|
    KEYWORDS_BEGIN[keyword] = KEYWORDS[keyword] = :"k#{keyword.upcase}"
  end

  
# line 2263 "lib/parser/lexer.rl"

  # %
end
