namespace :props do
  desc 'Write new property value hashes for the properties scanner'
  task :update do
    require 'regexp_property_values'
    RegexpPropertyValues.update
    dir = File.join(__dir__, '../lib/regexp_parser/scanner/properties')

    write_hash_to_file = ->(hash, path) do
      File.open(path, 'w') do |f|
        f.puts '# THIS FILE IS AUTO-GENERATED BY `rake props:update` - DO NOT EDIT',
               *hash.sort.map { |pair| pair.join(',') }
      end
      puts "Wrote #{hash.count} aliases to `#{path}`"
    end

    long_names_to_tokens = RegexpPropertyValues.all.map do |val|
      [val.identifier, val.full_name.downcase]
    end
    write_hash_to_file.call(long_names_to_tokens, "#{dir}/long.csv")

    short_names_to_tokens = RegexpPropertyValues.alias_hash.map do |k, v|
      [k.identifier, v.full_name.downcase]
    end
    write_hash_to_file.call(short_names_to_tokens, "#{dir}/short.csv")
  end
end
