% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pal-brewer.r
\name{brewer_pal}
\alias{brewer_pal}
\title{Color Brewer palette (discrete).}
\usage{
brewer_pal(type = "seq", palette = 1, direction = 1)
}
\arguments{
\item{type}{One of seq (sequential), div (diverging) or qual (qualitative)}

\item{palette}{If a string, will use that named palette.  If a number, will
index into the list of palettes of appropriate \code{type}}

\item{direction}{Sets the order of colors in the scale. If 1, the default,
colors are as output by \code{\link[RColorBrewer]{brewer.pal}}. If -1, the
order of colors is reversed.}
}
\description{
Color Brewer palette (discrete).
}
\examples{
show_col(brewer_pal()(10))
show_col(brewer_pal("div")(5))
show_col(brewer_pal(palette = "Greens")(5))

# Can use with gradient_n to create a continous gradient
cols <- brewer_pal("div")(5)
show_col(gradient_n_pal(cols)(seq(0, 1, length.out = 30)))
}
\references{
\url{http://colorbrewer2.org}
}

