% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_core_utilities.R
\name{getParameterType}
\alias{getParameterType}
\title{Get Parameter Type}
\usage{
getParameterType(obj, var)
}
\arguments{
\item{obj}{The rpact result object.}

\item{var}{The variable/parameter name.}
}
\value{
Returns a \code{\link[base]{character}} of specifying the corresponding type of a given parameter name.
Returns \code{NULL} if the specified \code{parameterName} does not exist.
}
\description{
Returns the parameter type for a given object and parameter name.
}
\details{
This function identifies and returns the type that will be used in print outputs of an rpact result object.
}
\examples{
\dontrun{
getParameterType(getDesignInverseNormal(), "kMax")
}

}
\seealso{
\code{\link[=getParameterName]{getParameterName()}} for getting the parameter name for a given caption.
\code{\link[=getParameterCaption]{getParameterCaption()}} for getting the parameter caption for a given name.
}
\keyword{internal}
