% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/topic-errors.R
\name{topic-condition-formatting}
\alias{topic-condition-formatting}
\title{Formatting condition messages}
\description{
Condition signallers like \code{\link[=abort]{abort()}}, \code{\link[=warn]{warn()}}, and \code{\link[=signal]{signal()}} take a character vector of \strong{bulleted text} as \code{message} argument. This makes it easy to write messages in a list format where each bullet conveys a single important point.\if{html}{\out{<div class="sourceCode r">}}\preformatted{abort(c(
  "The error header",
  "*" = "An error bullet",
  "i" = "An info bullet",
  "x" = "A cross bullet"
))
#> Error:
#> ! The error header
#> * An error bullet
#> i An info bullet
#> x A cross bullet
}\if{html}{\out{</div>}}

See the \href{https://style.tidyverse.org/error-messages.html}{tidyverse error style guide} for more about this style of error messaging.

By default, condition messages use unicode symbols rather than simple letters. This is not the case here because unicode isn't supported in documentation. If you'd like to disable unicode symbols globally, add this to your Rprofile:\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(cli.condition_unicode_bullets = FALSE)
}\if{html}{\out{</div>}}
\subsection{Use cli formatting}{

By default, rlang uses an internal mechanism to format bullets. It is preferable to delegate formatting to the \href{https://cli.r-lib.org/}{cli package} because it uses sophisticated paragraph wrapping and bullet indenting that make long lines easier to read. In the following example, a long \code{!} bullet is broken with an indented newline:\if{html}{\out{<div class="sourceCode r">}}\preformatted{rlang::global_entrace(class = "errorr")
#> Error in `rlang::global_entrace()`:
#> ! `class` must be one of "error", "warning", or "message",
#>   not "errorr".
#> i Did you mean "error"?
}\if{html}{\out{</div>}}

To enable cli formatting, use \code{\link[cli:cli_abort]{cli::cli_abort()}}, \code{\link[cli:cli_abort]{cli::cli_warn()}}, and \code{\link[cli:cli_abort]{cli::cli_inform()}}. Not only do these wrappers improve the formatting of messages, they also add many features such as interpolation, semantic formatting of text elements, and pluralisation:\if{html}{\out{<div class="sourceCode r">}}\preformatted{inform_marbles <- function(n_marbles) \{
  cli::cli_inform(c(
    "i" = "I have \{n_marbles\} shiny marble\{?s\} in my bag.",
    "v" = "Way to go \{.code cli::cli_inform()\}!"
  ))
\}

inform_marbles(1)
#> i I have 1 shiny marble in my bag.
#> v Way to go `cli::cli_inform()`!

inform_marbles(2)
#> i I have 2 shiny marbles in my bag.
#> v Way to go `cli::cli_inform()`!
}\if{html}{\out{</div>}}
}
}
\keyword{internal}
