% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/publish.CauseSpecificCox.R
\name{publish.CauseSpecificCox}
\alias{publish.CauseSpecificCox}
\title{Tabulizing cause-specific hazard ratio from all causes with confidence limits and Wald test p-values.}
\usage{
\method{publish}{CauseSpecificCox}(
  object,
  cause,
  confint.method,
  pvalue.method,
  factor.reference = "extraline",
  units = NULL,
  print = TRUE,
  ...
)
}
\arguments{
\item{object}{Cause-specific hazard model obtained with
\code{CSC}.}

\item{cause}{Show a table for this cause. If omitted, list all
causes.}

\item{confint.method}{See \code{regressionTable}}

\item{pvalue.method}{See \code{regressionTable}}

\item{factor.reference}{See \code{regressionTable}}

\item{units}{See \code{regressionTable}}

\item{print}{If \code{TRUE} print the table(s).}

\item{...}{passed on to control formatting of parameters,
confidence intervals and p-values.  See
\code{summary.regressionTable}.}
}
\value{
Table with cause-specific hazard ratios, confidence limits and p-values.
}
\description{
Publish cause-specific Cox models
}
\details{
The cause-specific hazard ratio's are combined into one table.
}
\examples{
if (requireNamespace("riskRegression",quietly=TRUE)){
library(riskRegression)
library(prodlim)
library(survival)
data(Melanoma,package="riskRegression")
fit1 <- CSC(list(Hist(time,status)~sex,Hist(time,status)~invasion+epicel+age),
            data=Melanoma)
publish(fit1)
publish(fit1,pvalue.stars=TRUE)
publish(fit1,factor.reference="inline",units=list("age"="years"))

# wide format (same variables in both Cox regression formula) 
fit2 <- CSC(Hist(time,status)~invasion+epicel+age, data=Melanoma)
publish(fit2)

# with p-values
x <- publish(fit2,print=FALSE)
table <- cbind(x[[1]]$regressionTable,
           x[[2]]$regressionTable[,-c(1,2)])
}

}
\author{
Thomas Alexander Gerds <tab@biostat.ku.dk>
}
