% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discrete-igv.R
\name{pal_igv}
\alias{pal_igv}
\title{Integrative Genomics Viewer (IGV) Color Palettes}
\usage{
pal_igv(palette = c("default", "alternating"), alpha = 1)
}
\arguments{
\item{palette}{Palette type.
There are two available options:
\code{"default"} (51-color palette);
\code{"alternating"} (2-color palette).}

\item{alpha}{Transparency level, a real number in (0, 1].
See \code{alpha} in \code{\link[grDevices]{rgb}} for details.}
}
\description{
Color palettes based on the colors used by
Integrative Genomics Viewer (IGV).
}
\examples{
library("scales")
show_col(pal_igv("default")(51))
show_col(pal_igv("alternating")(2))
}
\references{
James T. Robinson, Helga Thorvaldsd\'{o}ttir, Wendy Winckler,
Mitchell Guttman, Eric S. Lander, Gad Getz, Jill P. Mesirov.
Integrative Genomics Viewer. \emph{Nature Biotechnology} 29, 24--26 (2011).
}
\author{
Nan Xiao <\email{me@nanx.me}> |
<\href{https://nanx.me}{https://nanx.me}>
}
