% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colwise-filter.R
\name{filter_all}
\alias{filter_all}
\alias{filter_if}
\alias{filter_at}
\title{Filter within a selection of variables}
\usage{
filter_all(.tbl, .vars_predicate)

filter_if(.tbl, .predicate, .vars_predicate)

filter_at(.tbl, .vars, .vars_predicate)
}
\arguments{
\item{.tbl}{A \code{tbl} object.}

\item{.vars_predicate}{A quoted predicate expression as returned by
\code{\link[=all_vars]{all_vars()}} or \code{\link[=any_vars]{any_vars()}}.}

\item{.predicate}{A predicate function to be applied to the columns
or a logical vector. The variables for which \code{.predicate} is or
returns \code{TRUE} are selected. This argument is passed to
\code{\link[rlang:as_function]{rlang::as_function()}} and thus supports quosure-style lambda
functions and strings representing function names.}

\item{.vars}{A list of columns generated by \code{\link[=vars]{vars()}},
or a character vector of column names, or a numeric vector of column
positions.}
}
\description{
These \link{scoped} filtering verbs apply a predicate expression to a
selection of variables. The predicate expression should be quoted
with \code{\link[=all_vars]{all_vars()}} or \code{\link[=any_vars]{any_vars()}} and should mention the pronoun
\code{.} to refer to variables.
}
\examples{
# While filter() accepts expressions with specific variables, the
# scoped filter verbs take an expression with the pronoun `.` and
# replicate it over all variables. This expression should be quoted
# with all_vars() or any_vars():
all_vars(is.na(.))
any_vars(is.na(.))


# You can take the intersection of the replicated expressions:
filter_all(mtcars, all_vars(. > 150))

# Or the union:
filter_all(mtcars, any_vars(. > 150))


# You can vary the selection of columns on which to apply the
# predicate. filter_at() takes a vars() specification:
filter_at(mtcars, vars(starts_with("d")), any_vars((. \%\% 2) == 0))

# And filter_if() selects variables with a predicate function:
filter_if(mtcars, ~ all(floor(.) == .), all_vars(. != 0))
}
