% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update.bayesfactor_models.R
\name{update.bayesfactor_models}
\alias{update.bayesfactor_models}
\title{Update bayesfactor_models}
\usage{
\method{update}{bayesfactor_models}(object, subset = NULL, reference = NULL, ...)
}
\arguments{
\item{object}{A \code{\link{bayesfactor_models}} object.}

\item{subset}{Vector of model indices to keep or remove.}

\item{reference}{Index of model to rereference to, or \code{"top"} to reference to the best model, or \code{"bottom"} to reference to the worst model.}

\item{...}{Currently not used.}
}
\description{
Update bayesfactor_models
}
\examples{
\dontrun{
library(lme4)
lmer1 <- lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
lmer2 <- lmer(Sepal.Length ~ Petal.Length + (Petal.Length | Species), data = iris)
lmer3 <- lmer(
  Sepal.Length ~ Petal.Length + (Petal.Length | Species) + (1 | Petal.Width),
  data = iris
)

m <- bayesfactor_models(lmer1, lmer2, lmer3, denominator = 1)
m

update(m, reference = "bottom")
}
}
