% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/progenyPermutations.r
\name{progenyPerm}
\alias{progenyPerm}
\title{Compute progeny pathway scores and assesses significance based on permutations}
\usage{
progenyPerm(
  df,
  weight_matrix,
  k = 10000,
  z_scores = TRUE,
  get_nulldist = FALSE
)
}
\arguments{
\item{df}{A data.frame of n*m+1 dimension, where n is the number of omic
features to be considered and m is the number of samples/contrasts.
The first column should be the identifiers of the omic features. 
These identifiers must be coherent with the identifiers of the weight matrix.}

\item{weight_matrix}{A progeny coefficient matrix. the first column should be
the identifiers of the omic features and should be coherent with 
the identifiers provided in df.}

\item{k}{The number of permutations to be performed to generate
the null-distribution used to estimate the significance of progeny scores.  
The default value is 10000.}

\item{z_scores}{if true, the z-scores will be returned for 
the pathway activity estimations. Else, the function returns 
a normalized z-score value between -1 and 1.}

\item{get_nulldist}{if true, the null score distribution used for 
normalization will be returned along with the actual normalized score data 
frame.}
}
\value{
This function returns a list of two elements. The first element is 
a data frame of p*m+1 dimensions, where p is the number of progeny pathways,
and m is the number of samples/contrasts. Each cell represents the 
significance of a progeny pathway score for one sample/contrast. The 
significance ranges between -1 and 1. The significance is equal to x*2-1, x 
being the quantile of the progeny pathway score with respect to the null 
distribution. Thus, this significance can be interpreted as the equivalent of 
1-p.value two-sided test over an empirical distribution) with the sign 
indicating the direction of the regulation. The second element is the null 
distribution list (a null distribution is generated for each sample/contrast).
}
\description{
Compute progeny pathway scores and assesses significance based on permutations
}
\examples{
# use example gene expression matrix
gene_expression <- as.matrix(read.csv(system.file("extdata", 
"human_input.csv", package = "progeny"), row.names = 1))

# calculate pathway activities
progeny(gene_expression, scale=TRUE, organism="Human", top=100, perm=10000)
}
