/*
 * Copyright (C) 2013 Canonical, Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; version 3.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "fakevideorenderercontrol.h"
#include "fakecameraservice.h"

#include <QAbstractVideoSurface>
#include <QDebug>
#include <QUrl>
#include <QVideoSurfaceFormat>

//const QLatin1String viewfinderImage = QLatin1String("/usr/share/fakeCamera/viewfinder_landscape.jpg");

FakeVideoRendererControl::FakeVideoRendererControl(FakeCameraService *service, QObject *parent)
   : QVideoRendererControl(parent)
   , m_surface(0),
     m_service(service)
{
    QObject::connect(&(m_service->fakeSensor()), SIGNAL(newViewfinderFrame()),
                     this, SLOT(updateViewfinderFrame()));
}

FakeVideoRendererControl::~FakeVideoRendererControl()
{
}

QAbstractVideoSurface *FakeVideoRendererControl::surface() const
{
    return m_surface;
}

void FakeVideoRendererControl::setSurface(QAbstractVideoSurface *surface)
{
    if (m_surface != surface) {
        m_surface = surface;
        Q_EMIT surfaceChanged(surface);
    }
}

void FakeVideoRendererControl::stopViewfinder()
{
    if (m_surface)
        m_surface->stop();
}

void FakeVideoRendererControl::updateViewfinderFrame()
{
    if (!m_surface)
        return;

    QVideoFrame frame(m_service->fakeSensor().viewfinderFrame());
    if (!frame.isValid())
        return;

    if (!m_surface->isActive()) {
        QVideoSurfaceFormat format(frame.size(), frame.pixelFormat());

        if (!m_surface->start(format)) {
            qWarning() << "Failed to start viewfinder with format:" << format;
        }
    }

    if (m_surface->isActive()) {
        m_surface->present(frame);
    }
}
