/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower@users.sourceforge.net                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/

#ifndef INPUTTEXTWGT_H
#define INPUTTEXTWGT_H

#include <QTextEdit>
#include <QKeyEvent>
#include <QString>

/**
	@author Anistratov Oleg <ower@users.sourceforge.net>
*/
class InputTextWgt : public QTextEdit
{
  Q_OBJECT

  private:
    static QString Chars_US;
    static QString Chars_UA;
    static QString Chars_RU;
    static bool inited;

    QString     m_currentMsg;
    QString**   m_msgHistory;
    quint16     m_msgsSize;
    quint16     m_currentMsgNumber;
    int         m_current;

    void nextMsg   ();
    void prevMsg   ();
    void addMsg    (const QString &);

  public:
    InputTextWgt(QWidget *parent = 0);
    ~InputTextWgt(){qDebug("[InputTextWgt::~InputTextWgt]");}

    static void initChars(const QString  &);

  protected:
    void keyPressEvent(QKeyEvent* ev);
//     void wheelEvent   (QWheelEvent* ev)
//     {
//       if     (ev->delta() > 0) prevMsg();
//       else if(ev->delta() < 0) nextMsg();
//     }

  public slots:
    void changeTextCharMap();
    void sendMsg   ();
    void append    (const QString & str){insertPlainText(str);}

  signals:
    void wantSend();
};

#endif
