/* -*- Mode: C; c-basic-offset: 4 -*-
 * python-xklavier: Python bindings for libxklavier
 * Copyright (C) 2009 One Laptop Per Child Association Inc
 * Author: Sayamindu Dasgupta <sayamindu@laptop.org>
 *
 *   xklaviermodule.c: module wrapping the libxklavier library
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <pygobject.h>
 
void xklavier_register_classes (PyObject *d);
void xklavier_add_constants(PyObject *module, const gchar *strip_prefix);

extern PyMethodDef xklavier_functions[];
 
DL_EXPORT(void)
initxklavier(void)
{
    PyObject *m, *d;
 
    init_pygobject ();
 
    m = Py_InitModule ("xklavier", xklavier_functions);
    d = PyModule_GetDict (m);
 
    xklavier_register_classes (d);
    xklavier_add_constants(m, "");

 
    if (PyErr_Occurred ()) {
        Py_FatalError ("can't initialise module xklavier");
    }
}

