# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import deserialize
from twilio.base import serialize
from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page


class BindingList(ListResource):

    def __init__(self, version, chat_service_sid):
        """
        Initialize the BindingList

        :param Version version: Version that contains the resource
        :param chat_service_sid: The SID of the Conversation Service that the resource is associated with.

        :returns: twilio.rest.conversations.v1.service.binding.BindingList
        :rtype: twilio.rest.conversations.v1.service.binding.BindingList
        """
        super(BindingList, self).__init__(version)

        # Path Solution
        self._solution = {'chat_service_sid': chat_service_sid, }
        self._uri = '/Services/{chat_service_sid}/Bindings'.format(**self._solution)

    def stream(self, binding_type=values.unset, identity=values.unset, limit=None,
               page_size=None):
        """
        Streams BindingInstance records from the API as a generator stream.
        This operation lazily loads records as efficiently as possible until the limit
        is reached.
        The results are returned as a generator, so this operation is memory efficient.

        :param list[BindingInstance.BindingType] binding_type: The push technology used by the Binding resources to read.
        :param list[unicode] identity: The identity of Conversation User associated with this binding.
        :param int limit: Upper limit for the number of records to return. stream()
                          guarantees to never return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, stream() will attempt to read the
                              limit with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.service.binding.BindingInstance]
        """
        limits = self._version.read_limits(limit, page_size)

        page = self.page(binding_type=binding_type, identity=identity, page_size=limits['page_size'], )

        return self._version.stream(page, limits['limit'])

    def list(self, binding_type=values.unset, identity=values.unset, limit=None,
             page_size=None):
        """
        Lists BindingInstance records from the API as a list.
        Unlike stream(), this operation is eager and will load `limit` records into
        memory before returning.

        :param list[BindingInstance.BindingType] binding_type: The push technology used by the Binding resources to read.
        :param list[unicode] identity: The identity of Conversation User associated with this binding.
        :param int limit: Upper limit for the number of records to return. list() guarantees
                          never to return more than limit.  Default is no limit
        :param int page_size: Number of records to fetch per request, when not set will use
                              the default value of 50 records.  If no page_size is defined
                              but a limit is defined, list() will attempt to read the limit
                              with the most efficient page size, i.e. min(limit, 1000)

        :returns: Generator that will yield up to limit results
        :rtype: list[twilio.rest.conversations.v1.service.binding.BindingInstance]
        """
        return list(self.stream(
            binding_type=binding_type,
            identity=identity,
            limit=limit,
            page_size=page_size,
        ))

    def page(self, binding_type=values.unset, identity=values.unset,
             page_token=values.unset, page_number=values.unset,
             page_size=values.unset):
        """
        Retrieve a single page of BindingInstance records from the API.
        Request is executed immediately

        :param list[BindingInstance.BindingType] binding_type: The push technology used by the Binding resources to read.
        :param list[unicode] identity: The identity of Conversation User associated with this binding.
        :param str page_token: PageToken provided by the API
        :param int page_number: Page Number, this value is simply for client state
        :param int page_size: Number of records to return, defaults to 50

        :returns: Page of BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingPage
        """
        data = values.of({
            'BindingType': serialize.map(binding_type, lambda e: e),
            'Identity': serialize.map(identity, lambda e: e),
            'PageToken': page_token,
            'Page': page_number,
            'PageSize': page_size,
        })

        response = self._version.page(method='GET', uri=self._uri, params=data, )

        return BindingPage(self._version, response, self._solution)

    def get_page(self, target_url):
        """
        Retrieve a specific page of BindingInstance records from the API.
        Request is executed immediately

        :param str target_url: API-generated URL for the requested results page

        :returns: Page of BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingPage
        """
        response = self._version.domain.twilio.request(
            'GET',
            target_url,
        )

        return BindingPage(self._version, response, self._solution)

    def get(self, sid):
        """
        Constructs a BindingContext

        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.service.binding.BindingContext
        :rtype: twilio.rest.conversations.v1.service.binding.BindingContext
        """
        return BindingContext(self._version, chat_service_sid=self._solution['chat_service_sid'], sid=sid, )

    def __call__(self, sid):
        """
        Constructs a BindingContext

        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.service.binding.BindingContext
        :rtype: twilio.rest.conversations.v1.service.binding.BindingContext
        """
        return BindingContext(self._version, chat_service_sid=self._solution['chat_service_sid'], sid=sid, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.BindingList>'


class BindingPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the BindingPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API
        :param chat_service_sid: The SID of the Conversation Service that the resource is associated with.

        :returns: twilio.rest.conversations.v1.service.binding.BindingPage
        :rtype: twilio.rest.conversations.v1.service.binding.BindingPage
        """
        super(BindingPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of BindingInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.conversations.v1.service.binding.BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingInstance
        """
        return BindingInstance(self._version, payload, chat_service_sid=self._solution['chat_service_sid'], )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Conversations.V1.BindingPage>'


class BindingContext(InstanceContext):

    def __init__(self, version, chat_service_sid, sid):
        """
        Initialize the BindingContext

        :param Version version: Version that contains the resource
        :param chat_service_sid: The SID of the Conversation Service that the resource is associated with.
        :param sid: A 34 character string that uniquely identifies this resource.

        :returns: twilio.rest.conversations.v1.service.binding.BindingContext
        :rtype: twilio.rest.conversations.v1.service.binding.BindingContext
        """
        super(BindingContext, self).__init__(version)

        # Path Solution
        self._solution = {'chat_service_sid': chat_service_sid, 'sid': sid, }
        self._uri = '/Services/{chat_service_sid}/Bindings/{sid}'.format(**self._solution)

    def delete(self):
        """
        Deletes the BindingInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._version.delete(method='DELETE', uri=self._uri, )

    def fetch(self):
        """
        Fetch the BindingInstance

        :returns: The fetched BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return BindingInstance(
            self._version,
            payload,
            chat_service_sid=self._solution['chat_service_sid'],
            sid=self._solution['sid'],
        )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.BindingContext {}>'.format(context)


class BindingInstance(InstanceResource):

    class BindingType(object):
        APN = "apn"
        GCM = "gcm"
        FCM = "fcm"

    def __init__(self, version, payload, chat_service_sid, sid=None):
        """
        Initialize the BindingInstance

        :returns: twilio.rest.conversations.v1.service.binding.BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingInstance
        """
        super(BindingInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'sid': payload.get('sid'),
            'account_sid': payload.get('account_sid'),
            'chat_service_sid': payload.get('chat_service_sid'),
            'credential_sid': payload.get('credential_sid'),
            'date_created': deserialize.iso8601_datetime(payload.get('date_created')),
            'date_updated': deserialize.iso8601_datetime(payload.get('date_updated')),
            'endpoint': payload.get('endpoint'),
            'identity': payload.get('identity'),
            'binding_type': payload.get('binding_type'),
            'message_types': payload.get('message_types'),
            'url': payload.get('url'),
        }

        # Context
        self._context = None
        self._solution = {'chat_service_sid': chat_service_sid, 'sid': sid or self._properties['sid'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: BindingContext for this BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingContext
        """
        if self._context is None:
            self._context = BindingContext(
                self._version,
                chat_service_sid=self._solution['chat_service_sid'],
                sid=self._solution['sid'],
            )
        return self._context

    @property
    def sid(self):
        """
        :returns: A 34 character string that uniquely identifies this resource.
        :rtype: unicode
        """
        return self._properties['sid']

    @property
    def account_sid(self):
        """
        :returns: The unique ID of the Account responsible for this binding.
        :rtype: unicode
        """
        return self._properties['account_sid']

    @property
    def chat_service_sid(self):
        """
        :returns: The SID of the Conversation Service that the resource is associated with.
        :rtype: unicode
        """
        return self._properties['chat_service_sid']

    @property
    def credential_sid(self):
        """
        :returns: The SID of the Credential for the binding.
        :rtype: unicode
        """
        return self._properties['credential_sid']

    @property
    def date_created(self):
        """
        :returns: The date that this resource was created.
        :rtype: datetime
        """
        return self._properties['date_created']

    @property
    def date_updated(self):
        """
        :returns: The date that this resource was last updated.
        :rtype: datetime
        """
        return self._properties['date_updated']

    @property
    def endpoint(self):
        """
        :returns: The unique endpoint identifier for the Binding.
        :rtype: unicode
        """
        return self._properties['endpoint']

    @property
    def identity(self):
        """
        :returns: The identity of Conversation User associated with this binding.
        :rtype: unicode
        """
        return self._properties['identity']

    @property
    def binding_type(self):
        """
        :returns: The push technology to use for the binding.
        :rtype: BindingInstance.BindingType
        """
        return self._properties['binding_type']

    @property
    def message_types(self):
        """
        :returns: The Conversation message types the binding is subscribed to.
        :rtype: list[unicode]
        """
        return self._properties['message_types']

    @property
    def url(self):
        """
        :returns: An absolute URL for this binding.
        :rtype: unicode
        """
        return self._properties['url']

    def delete(self):
        """
        Deletes the BindingInstance

        :returns: True if delete succeeds, False otherwise
        :rtype: bool
        """
        return self._proxy.delete()

    def fetch(self):
        """
        Fetch the BindingInstance

        :returns: The fetched BindingInstance
        :rtype: twilio.rest.conversations.v1.service.binding.BindingInstance
        """
        return self._proxy.fetch()

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Conversations.V1.BindingInstance {}>'.format(context)
