# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.eventgrid.aio import EventGridManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestEventGridManagementEventSubscriptionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(EventGridManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_get_delivery_attributes(self, resource_group):
        response = await self.client.event_subscriptions.get_delivery_attributes(
            scope="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_get(self, resource_group):
        response = await self.client.event_subscriptions.get(
            scope="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.event_subscriptions.begin_create_or_update(
                scope="str",
                event_subscription_name="str",
                event_subscription_info={
                    "deadLetterDestination": "dead_letter_destination",
                    "deadLetterWithResourceIdentity": {
                        "deadLetterDestination": "dead_letter_destination",
                        "identity": {
                            "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                            "type": "str",
                            "userAssignedIdentity": "str",
                        },
                    },
                    "deliveryWithResourceIdentity": {
                        "destination": "event_subscription_destination",
                        "identity": {
                            "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                            "type": "str",
                            "userAssignedIdentity": "str",
                        },
                    },
                    "destination": "event_subscription_destination",
                    "eventDeliverySchema": "str",
                    "expirationTimeUtc": "2020-02-20 00:00:00",
                    "filter": {
                        "advancedFilters": ["advanced_filter"],
                        "enableAdvancedFilteringOnArrays": bool,
                        "includedEventTypes": ["str"],
                        "isSubjectCaseSensitive": False,
                        "subjectBeginsWith": "str",
                        "subjectEndsWith": "str",
                    },
                    "id": "str",
                    "labels": ["str"],
                    "name": "str",
                    "provisioningState": "str",
                    "retryPolicy": {"eventTimeToLiveInMinutes": 1440, "maxDeliveryAttempts": 30},
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "topic": "str",
                    "type": "str",
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_begin_delete(self, resource_group):
        response = await (
            await self.client.event_subscriptions.begin_delete(
                scope="str",
                event_subscription_name="str",
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_begin_update(self, resource_group):
        response = await (
            await self.client.event_subscriptions.begin_update(
                scope="str",
                event_subscription_name="str",
                event_subscription_update_parameters={
                    "deadLetterDestination": "dead_letter_destination",
                    "deadLetterWithResourceIdentity": {
                        "deadLetterDestination": "dead_letter_destination",
                        "identity": {
                            "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                            "type": "str",
                            "userAssignedIdentity": "str",
                        },
                    },
                    "deliveryWithResourceIdentity": {
                        "destination": "event_subscription_destination",
                        "identity": {
                            "federatedIdentityCredentialInfo": {"federatedClientId": "str"},
                            "type": "str",
                            "userAssignedIdentity": "str",
                        },
                    },
                    "destination": "event_subscription_destination",
                    "eventDeliverySchema": "str",
                    "expirationTimeUtc": "2020-02-20 00:00:00",
                    "filter": {
                        "advancedFilters": ["advanced_filter"],
                        "enableAdvancedFilteringOnArrays": bool,
                        "includedEventTypes": ["str"],
                        "isSubjectCaseSensitive": False,
                        "subjectBeginsWith": "str",
                        "subjectEndsWith": "str",
                    },
                    "labels": ["str"],
                    "retryPolicy": {"eventTimeToLiveInMinutes": 1440, "maxDeliveryAttempts": 30},
                },
                api_version="2025-04-01-preview",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_get_full_url(self, resource_group):
        response = await self.client.event_subscriptions.get_full_url(
            scope="str",
            event_subscription_name="str",
            api_version="2025-04-01-preview",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_subscription(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_subscription(
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_subscription_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_subscription_for_topic_type(
            topic_type_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_resource_group(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_global_by_resource_group_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_global_by_resource_group_for_topic_type(
            resource_group_name=resource_group.name,
            topic_type_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_subscription(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_subscription(
            location="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_resource_group(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_resource_group(
            resource_group_name=resource_group.name,
            location="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_subscription_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_subscription_for_topic_type(
            location="str",
            topic_type_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_regional_by_resource_group_for_topic_type(self, resource_group):
        response = self.client.event_subscriptions.list_regional_by_resource_group_for_topic_type(
            resource_group_name=resource_group.name,
            location="str",
            topic_type_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_by_resource(self, resource_group):
        response = self.client.event_subscriptions.list_by_resource(
            resource_group_name=resource_group.name,
            provider_namespace="str",
            resource_type_name="str",
            resource_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_event_subscriptions_list_by_domain_topic(self, resource_group):
        response = self.client.event_subscriptions.list_by_domain_topic(
            resource_group_name=resource_group.name,
            domain_name="str",
            topic_name="str",
            api_version="2025-04-01-preview",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...
