# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.network.aio import NetworkManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestNetworkManagementExpressRoutePortsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(NetworkManagementClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_begin_delete(self, resource_group):
        response = await (
            await self.client.express_route_ports.begin_delete(
                resource_group_name=resource_group.name,
                express_route_port_name="str",
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_get(self, resource_group):
        response = await self.client.express_route_ports.get(
            resource_group_name=resource_group.name,
            express_route_port_name="str",
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_begin_create_or_update(self, resource_group):
        response = await (
            await self.client.express_route_ports.begin_create_or_update(
                resource_group_name=resource_group.name,
                express_route_port_name="str",
                parameters={
                    "allocationDate": "str",
                    "bandwidthInGbps": 0,
                    "billingType": "str",
                    "circuits": [{"id": "str"}],
                    "encapsulation": "str",
                    "etag": "str",
                    "etherType": "str",
                    "id": "str",
                    "identity": {
                        "principalId": "str",
                        "tenantId": "str",
                        "type": "str",
                        "userAssignedIdentities": {"str": {"clientId": "str", "principalId": "str"}},
                    },
                    "links": [
                        {
                            "adminState": "str",
                            "coloLocation": "str",
                            "connectorType": "str",
                            "etag": "str",
                            "id": "str",
                            "interfaceName": "str",
                            "macSecConfig": {
                                "cakSecretIdentifier": "str",
                                "cipher": "str",
                                "cknSecretIdentifier": "str",
                                "sciState": "str",
                            },
                            "name": "str",
                            "patchPanelId": "str",
                            "provisioningState": "str",
                            "rackId": "str",
                            "routerName": "str",
                        }
                    ],
                    "location": "str",
                    "mtu": "str",
                    "name": "str",
                    "peeringLocation": "str",
                    "provisionedBandwidthInGbps": 0.0,
                    "provisioningState": "str",
                    "resourceGuid": "str",
                    "tags": {"str": "str"},
                    "type": "str",
                },
                api_version="2024-05-01",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_update_tags(self, resource_group):
        response = await self.client.express_route_ports.update_tags(
            resource_group_name=resource_group.name,
            express_route_port_name="str",
            parameters={"tags": {"str": "str"}},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_list_by_resource_group(self, resource_group):
        response = self.client.express_route_ports.list_by_resource_group(
            resource_group_name=resource_group.name,
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_list(self, resource_group):
        response = self.client.express_route_ports.list(
            api_version="2024-05-01",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_express_route_ports_generate_loa(self, resource_group):
        response = await self.client.express_route_ports.generate_loa(
            resource_group_name=resource_group.name,
            express_route_port_name="str",
            request={"customerName": "str"},
            api_version="2024-05-01",
        )

        # please add some check logic here by yourself
        # ...
