This doc shows some cases for developers about how to write customized code based on SDK generated by autorest.

# Where to write your code?

SDK provides mechanism to develop your code. You just need to write your code in `_patch.py` then your code will override the generated code. For example: [webpubsub patch](https://github.com/Azure/azure-sdk-for-python/blob/main/sdk/webpubsub/azure-messaging-webpubsubservice/azure/messaging/webpubsubservice/_patch.py)



# Customization Scenario

Here are some samples about how to customize code in different scenario. Some samples use `directive`, which is useful method to do some customized change. For more info about `directive`, please see [directive doc](https://github.com/Azure/autorest/blob/main/docs/generate/built-in-directives.md).

## How to customize client?

With the help of `importlib`, it is easy to use your own client to override generated client. For example: [webpubsub customized client](https://github.com/Azure/azure-sdk-for-python/blob/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/azure/messaging/webpubsubservice/_patch.py#L378-L379)

![img.png](client.png)

## How to rename operation?

Use `directive` in `readme.md`, you could redefine operation name. Then run autorest again, the operation name will be changed. For example: [webpubsub rename operation](https://github.com/Azure/azure-sdk-for-python/tree/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/swagger#settings)

![img.png](rename_operation.png)



## How to delete operation?

Same with [How to rename operation](#How to rename operation). For example: [webpubsub delete operation](https://github.com/Azure/azure-sdk-for-python/tree/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/swagger#settings)

![](delete_operation.png)

## How to rename operation parameter?

Same with [How to rename operation](#How to rename operation). For example: [webpubsub rename parameter](https://github.com/Azure/azure-sdk-for-python/tree/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/swagger#settings)

![img.png](rename_parameter.png)

## How to move operation parameter to client?

Same with [How to rename operation](#How to rename operation). For example: [webpubsub move operation parameter to client](https://github.com/Azure/azure-sdk-for-python/tree/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/swagger#userexistsimpl)

![img.png](move_parameter_to_client.png)

## How to move operation from operation groups to client?

Same with [How to rename operation](#How to rename operation). For example: [webpubsub move operation to client](https://github.com/Azure/azure-sdk-for-python/tree/0d071b55cde1eb1ba89032b14adfb94e8d52f873/sdk/webpubsub/azure-messaging-webpubsubservice/swagger#settings)

![](move_operation_to_client.png)

## How to customize function?

Write your function directly in your own client. For example: [webpubsub customize function](https://github.com/Azure/azure-sdk-for-python/blob/64ddee845ecd805ea39a581f60155735f84a7dcd/sdk/webpubsub/azure-messaging-webpubsubservice/azure/messaging/webpubsubservice/_patch.py#L326)

Or

Replace generated code with your handwritten code by `importlib`:

```python
def patch_sdk():
    curr_package = importlib.import_module("azure.messaging.webpubsubservice")
    curr_package.WebPubSubServiceClient.generated_function = handwritten_function
```

