/*
 * gfblevel - Graphical front end for fblevel which uses GTK
 *            (www.gtk.org). This program doesn't require fblevel
 *            to be installed.  Credit to Stephan Leemburg for device
 *            access code from fblevel.
 *
 * Copyright (C) 2001 Gord Peters <GordPeters@smarttech.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
#include <errno.h>
#include <fcntl.h>
#include <stdio.h>
#include <gtk/gtk.h>
#include <linux/fb.h>
#include <linux/version.h>
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))
#include <asm/pmu.h>
#else
#include <linux/pmu.h>
#endif
#include <sys/ioctl.h>
#include <sys/stat.h>
#include <sys/types.h>

#ifndef FBIOBLANK
#define FBIOBLANK      0x4611          /* 0 or vesa-level+1 */
#endif

#define BACKLIGHT_MIN   0
#define BACKLIGHT_MAX  15

static int fbfd_G= -1;
static int pmufd_G= -1;

/* Copied from fblevel */
static void
fbon(int on)
{
    ioctl(fbfd_G, FBIOBLANK, !on);
}

/* Copied from fblevel */
static int
fblevel(int level)
{
    ioctl(pmufd_G, (level < 0) ? PMU_IOC_GET_BACKLIGHT : PMU_IOC_SET_BACKLIGHT,
	  &level);
    return level;
}

void
fb_set_level(GtkAdjustment *adj)
{
    fblevel((int)adj->value);
}

void
fb_toggle_on_off(GtkWidget *widget, gpointer data)
{

    if (GTK_TOGGLE_BUTTON(widget)->active) {
        fbon(1);
    }
    else {
        fbon(0);
    }

}

void
create_window(int level)
{
    GtkWidget *window;
    GtkWidget *box1, *box2;
    GtkWidget *button, *fboncb;
    GtkWidget *separator;
    GtkWidget *hscale;
    GtkWidget *label;
    GtkObject *adj1;

    /* Standard window-creating stuff */
    window= gtk_window_new(GTK_WINDOW_TOPLEVEL);
    gtk_signal_connect(GTK_OBJECT (window), "destroy",
		       GTK_SIGNAL_FUNC(gtk_main_quit),
		       NULL);
    gtk_window_set_title(GTK_WINDOW (window), "gfblevel");

    box1= gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER (window), box1);
    gtk_widget_show(box1);

    box2= gtk_hbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER (box2), 10);
    gtk_box_pack_start(GTK_BOX (box1), box2, TRUE, TRUE, 0);
    gtk_widget_show(box2);

    if (pmufd_G >= 0) {
        /* Create the label */
        label= gtk_label_new("Brightness:");
	gtk_box_pack_start(GTK_BOX(box2), label, TRUE, TRUE, 0);
	gtk_widget_show(label);

	/* Create the adjustment widget */
	adj1= gtk_adjustment_new(level, BACKLIGHT_MIN, BACKLIGHT_MAX, 1.0, 1.0,
				 0.0);
	gtk_signal_connect(GTK_OBJECT (adj1), "value_changed",
			   GTK_SIGNAL_FUNC (fb_set_level), NULL);

	hscale= gtk_hscale_new(GTK_ADJUSTMENT (adj1));
	gtk_widget_set_usize(GTK_WIDGET (hscale), 200, 30);
	gtk_scale_set_digits(GTK_SCALE (hscale), 0);
	gtk_box_pack_start(GTK_BOX (box2), hscale, TRUE, TRUE, 0);
	gtk_widget_show(hscale);
    }

    if (fbfd_G >= 0) {
        /* fb on/off checkbox */
        fboncb= gtk_check_button_new_with_label("on");
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(fboncb), TRUE);
	gtk_signal_connect(GTK_OBJECT (fboncb), "toggled",
			   GTK_SIGNAL_FUNC (fb_toggle_on_off), NULL);
	gtk_box_pack_start(GTK_BOX (box2), fboncb, TRUE, TRUE, 0);
	gtk_widget_show(fboncb);
    }

    separator= gtk_hseparator_new();
    gtk_box_pack_start(GTK_BOX (box1), separator, FALSE, TRUE, 0);
    gtk_widget_show(separator);

    box2= gtk_vbox_new(FALSE, 10);
    gtk_container_set_border_width(GTK_CONTAINER (box2), 10);
    gtk_box_pack_start(GTK_BOX (box1), box2, FALSE, TRUE, 0);
    gtk_widget_show(box2);

    button= gtk_button_new_with_label("Quit");
    gtk_signal_connect_object(GTK_OBJECT (button), "clicked",
			      GTK_SIGNAL_FUNC(gtk_main_quit),
			      NULL);
    gtk_box_pack_start(GTK_BOX (box2), button, TRUE, TRUE, 0);
    GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
    gtk_widget_grab_default(button);
    gtk_widget_show(button);

    gtk_widget_show(window);
}

int
main(int argc, char **argv)
{
    int level;

    pmufd_G= open("/dev/pmu", O_RDONLY);
    fbfd_G= open("/dev/fb0", O_RDONLY);

    if (pmufd_G < 0) perror("can't open /dev/pmu");
    if (fbfd_G < 0) perror("can't open /dev/fb0");

    if ((pmufd_G < 0) && (fbfd_G < 0)) {
        return 1;
    }

    level= fblevel(-1);

    gtk_init(&argc, &argv);
    create_window(level);
    gtk_main();

    return 0;
}
