/********************************************************************************
 *   Copyright (C) 2008-2009 by Bram Schoenmakers <bramschoenmakers@kde.nl>     *
 *                                                                              *
 *   This program is free software; you can redistribute it and/or modify       *
 *   it under the terms of the GNU General Public License as published by       *
 *   the Free Software Foundation; either version 2 of the License, or          *
 *   (at your option) any later version.                                        *
 *                                                                              *
 *   This program is distributed in the hope that it will be useful,            *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of             *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              *
 *   GNU General Public License for more details.                               *
 *                                                                              *
 *   You should have received a copy of the GNU General Public License          *
 *   along with this program; if not, write to the                              *
 *   Free Software Foundation, Inc.,                                            *
 *   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA .             *
 ********************************************************************************/

#include <KComboBox>
#include <KLocale>

#include "locationdialog.h"

LocationDialog::LocationDialog( QWidget *p_parent )
: KDialog( p_parent )
, m_accuracy( s_default_accuracy )
{
  /* Recorded accuracy level of the location information. Current range is 1-16 :
   * World level is 1
   * Country is ~3
   * Region is ~6
   * City is ~11
   * Street is ~16
   *
   * http://www.flickr.com/services/api/flickr.photos.search.html
   */
  m_accuracyCombo = new KComboBox( this );
  connect( m_accuracyCombo, SIGNAL( currentIndexChanged( int ) ), this, SLOT( accuracyChanged( int ) ) );
  m_accuracyCombo->addItem( i18n( "World scale" ), 1 );
  m_accuracyCombo->addItem( i18n( "Country scale" ), 3 );
  m_accuracyCombo->addItem( i18n( "Region scale" ), 6 );
  m_accuracyCombo->addItem( i18n( "City scale" ), 11 );
  m_accuracyCombo->addItem( i18n( "Street scale" ), 16 );
}

LocationDialog::~LocationDialog()
{
}

int LocationDialog::getAccuracy() const
{
  return m_accuracy;
}

void LocationDialog::setAccuracy( int p_accuracy )
{
  m_accuracy = p_accuracy;
  int index = m_accuracyCombo->findData( p_accuracy );
  m_accuracyCombo->setCurrentIndex( index );
}

void LocationDialog::accuracyChanged( int p_index )
{
  m_accuracy = m_accuracyCombo->itemData( p_index ).toInt();
}

