package Statistic;
our $VERSION = '2004-01-20';
our @ISA = 'BaseObject';

use Classes::Filter;

sub new {
	my $proto = shift;
	my @Constructor_Parameters = @_;

	my $class = ref( $proto ) || $proto;

	my $self = bless $proto->SUPER::new( @Constructor_Parameters ), $class;

	#

	$self->{'FilterList'}	= [];
	$self->{'FilterNb'}		= 0;

	$self->{'Label'}		= '';
	$self->{'Output'}		= 'html';
	$self->{'Offset'}		= 1;
	$self->{'Type'}			= 'Time';
	$self->{'Parameters'}	= {};

	$self->{'From'}			= '2003-01';
	$self->{'To'}			= '2003-12';
	$self->{'KeyType'}		= 'YYYY-MM';

	$self->{'data'}			= [];
	$self->{'FilterLabel'}  = [];

	#

	my %Hashage = @Constructor_Parameters;
	foreach my $Key ( keys %Hashage )
	{
		$self->set($ Key, $Hashage{$Key} );
	}

	return $self;
}

=pod

Parameter list :

Graph_Type
Graph_FileName
Graph_Width
Graph_Height

=cut

sub addFilter($$)
{
	my $self = shift;
	my $Filter = shift;

	my @FiltList = @{$self->{'FilterList'}};
	push @FiltList, $Filter;
	$self->{'FilterList'} = \@FiltList;

	$self->{'FilterNb'} ++;
}

sub get_Filter_by_num($$)
{
	my $self = shift;
	my $FiltNum = int( shift );

	return $self->{'FilterList'}->[$FiltNum];
}

sub del_Filter_by_num($$)
{
	my $self = shift;
	my $FiltNum = int( shift );

	my @FiltList = @{$self->{'FilterList'}};
	my @Part1 = @FiltList[ 0, $FiltNum - 1 ];
	my @Part2 = @FiltList[ $FiltNum + 1, $#FiltList ];

	$self->{'FilterList'} = \@FiltList;
	$self->{'FilterNb'} --;
}

##############################################################################

sub TimeValueList($)
{
	my $self = shift;

	my @ValueList = ( $self->From() );

	  # YYYY-MM-DD :
	if ( $self->KeyType() eq 'YYYY-MM-DD' )
	{
		my $Cursor = $self->From();
		while( $Cursor lt ( $self->To() ) )
		{
			$Cursor = sprintf( "%04d-%02d-%02d", Date::Calc::Add_Delta_Days( split( /-/, $Cursor ), 1 ) );
			push @ValueList, $Cursor;
		}
	}

	  # YYYY-MM :
	if ( $self->KeyType() eq 'YYYY-MM' )
	{
		my $Cursor = $self->From();
		while( $Cursor lt ( $self->To() ) )
		{
			$Cursor = sprintf( "%04d-%02d", Date::Calc::Add_Delta_YM( split( /-/, $Cursor.'-01' ), 0, 1 ) );
			push @ValueList, $Cursor;
		}
	}

	  # YYYY, MM, DD, HH :
	if ( length( $self->KeyType() ) <= 4 )
	{
		pop @ValueList;
		my $Length = length( $self->KeyType() );
		for( my $i = $self->From() ; $i <= $self->To() ; $i ++ )
		{
			push @ValueList, ( '0'x( $Length - length( $i ) ).$i );
		}
	}

	return @ValueList;
}

sub prepare_display($)
{
	my $self = shift;

	my %equiv = ( 'Y', 1, 'M', 6, 'D', 9, 'H', 12 );
	$self->Offset( $equiv{ substr( $self->KeyType(), 0, 1 ) } );

	  # Invert boundaries :
	if ( $self->From() gt $self->To() )
	{
		my $Tmp = $self->From();
		$self->From( $self->To() );
		$self->To( $Tmp );
	}

	my @DataSerial = ();
	my @FilterLabel = ();

	#

	if ( $self->Type() eq 'Time' )
	{
		push @DataSerial, [ $self->TimeValueList() ];
		for( my $i = 0 ; $i < ( $self->FilterNb() ) ; $i ++ )
		{
			my $Filter = $self->get_Filter_by_num( $i );
			my @Values = $Filter->Time_Statistic( $self->Offset(), [ $self->TimeValueList() ] );
			push @DataSerial, \@Values;
			push @FilterLabel, $Filter->FileName();
		}
	}

	#

	$self->data( \@DataSerial );
	$self->FilterLabel( \@FilterLabel );
}

sub display($)
{
	my $self = shift;

	if ( ! $::cgi->param( 'backend' ) ) {$::cgi->param( 'backend', $::conf{'default_backend'} );};

	#

	if ( $::cgi->param( 'backend' ) eq 'HTML' )
	{
		if ( $self->Type() eq 'Time' ) {	return $self->display_time_html() };
	}
	else
	{
		if ( $self->Type() eq 'Time' ) {	return $self->display_time_image() };
	}

	return 0;
}

sub display_time_html($)
{
	my $self = shift;

	print "<table border=1>\n";

	print '  <tr><td>Filter</td>';
	foreach my $Time ( @{$self->data->[0]} )
	{
		print '<td>'.$Time.'</td>';
	}
	print "</tr>\n";

	for( my $i = 1 ; $i <= ( $self->FilterNb() ) ; $i ++ )
	{
		print '  <tr><td>'.( $self->FilterLabel->[$i-1] ).'</td>';
		foreach my $Val ( @{$self->data->[$i]} )
		{
			print '<td>'.$Val.'</td>';
		}
		print "</tr>\n";
	}

	print "</table>\n";
}

sub display_time_image($)
{
	my $self = shift;

	my $GraphType = $self->Parameters()->{'Graph_Type'};
	my $FileName = $self->Parameters()->{'Graph_FileName'};

	if ( ( $GraphType !~ m/^pie/ ) and ( $GraphType !~ m/^bars/ ) )
	{
		$::cgi->param( 'backend', 'GD' );
	}

	#

	if ( $::cgi->param( 'backend' ) eq 'GD' )
	{
		my $graph = eval( "GD::Graph::".$GraphType )->new(
			$self->Parameters()->{'Graph_Width'},
			$self->Parameters()->{'Graph_Height'}
		);
		if ( $graph->can_do_ttf() )
		{
			$graph->set(
				transparent	=> $::conf{'GD_transparent'},
				interlaced	=> 1,
				x_label		=> 'Time',
				y_label		=> 'Alert Nb',
				title		=> $self->Label(),
			);

			if ( $GraphType !~ m/^pie/i )
			{
				$graph->set(
					x_label	=> 'Time',
					y_label	=> 'Alert Nb',
				);
				if ( $GraphType ne 'hbars' )
				{
					$graph->set( x_labels_vertical => 1 );
				}

				  # Graph Legend :
				$graph->set_legend( @{$self->{'FilterLabel'}} );
			}

			my $gd = $graph->plot( $self->data() );
			local *PNG;
			undef $!;
			open( PNG, '>'.$FileName );
			if ( $! and ( $! !~ m/Inappropriate ioctl for device/i ) )
			{
				::error( "Can't write image $FileName : did you do the chown -R like told in Docs/INSTALL.txt ? ($!)" );
				return 0;
			}
			print PNG $gd->png();
			close( PNG );
		}
		else
		{
			::error( "True Type fonts support not compiled in GD" );
			return 0;
		}
	}

	if ( $::cgi->param( 'backend' ) eq 'PS' )
	{
		local $::PS_Title = $self->Label() || 'Attacks per period';
		$FileName =~ s/\.png$/.jpg/i; # Hack !!!!!!!!!!!!!!!!!!!!
		$self->Parameters()->{'Graph_FileName'} = $FileName;

		my $PS_Template = '';
		if ( $GraphType =~ m/^pie/ ) {$PS_Template = 'piechart';};
		if ( $GraphType =~ m/^bars/ ) {$PS_Template = 'histogram_vbar';};

		my $res = &::postscript( $self->data(), "$PS_Template.ps", "generated/PostScript/Stats-$PS_Template.ps", $self->Parameters()->{'Graph_Width'} );
		if ( ! $res ) {return 0; };
		`$::conf{'gs_path'} -sDEVICE=jpeg -dNOPAUSE -dBATCH -dGraphicsAlphaBits=4 -dTextAlphaBits=4 -sOutputFile="$FileName" "generated/PostScript/Stats-$PS_Template.ps"`;

		unlink "generated/PostScript/Stats-$PS_Template.ps";
	}

	return $FileName;
}

1;
