#!/bin/sh

# Configuration: $1 is the number of col pairs in a row

echo "<html><body>"
echo "<!-- Generated by tab2html.sh, do not edit! -->"
echo "<table border=1 cellspacing=0>"
awk -F "[\t]*" -v "cols=$1" '
BEGIN {
	len = 0
}

/^[@]/ {
# print header
	print "<tr>"
	sub("^@", "", $0)
	for(n = 0; n < cols; n++)
		print "<th>" $1 "<th>" $2

	next
}

# load data
(NF == 2) {
	CELL[len] = "<td>" $1 "<td>" $2
	len++
}

END {
	rows = len / cols
	if (rows != int(rows))
		rows++;
	rows = int(rows);
	for(r = 0; r < rows; r++) {
		print "<tr>"
		for(c = 0; c < cols; c++) {
			idx = c*rows + r
			cell = CELL[idx]
			if (cell == "")
				cell = "<td>&nbsp;<td>&nbsp;"
			print cell
		}
	}
}

'
echo "</table></body></html>"
