'\"
'\" Copyright (c) 2003-2004 Paul H Alfille, MD
'\" (paul.alfille@gmail.com)
'\"
'\" Device manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH DS2405 3  2003 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B DS2405
\- Addressable Switch
.SH SYNOPSIS
1-wire network branch controller.
.PP
.B 05
[.]XXXXXXXXXXXX[XX][/[
.B PIO
|
.B sensed
|
.so man3/standard_mini.3so
]]
.SH FAMILY CODE
.TP
.I 05
.SH SPECIAL PROPERTIES
.SS PIO
.I read-write, yes-no
.br
State of the open-drain output (
.I PIO
) pin. 0 = non-conducting (off), 1 = conducting (on).
.br
Writing zero will turn off the switch, non-zero will turn on the switch. Reading the
.I PIO
state will return the switch setting. To determine the actual logic level at the switch, refer to the
.I sensed
property.
.SS sensed
.I read-only, yes-no
.br
Logic level at the
.I PIO
pin. 0 = ground. 1 = high (~2.4V - 5V ). Really makes sense only if the
.I PIO
state is set to zero (off), else will read zero.
.SH STANDARD PROPERTIES
.so man3/standard.3so
.SH ALARMS
None implemented.
.SH DESCRIPTION
.so man3/description.3so
.SS DS2405
The
.B DS2405 (3)
allows control of other devices, like LEDs and relays. It is an early design and has been superceeded by the
.B DS2406
and
.B DS2408
or even
.B DS2450
that have more PIO pins, and do not employ an arcane use the the alarm state to signal PIO status.
.SH ADDRESSING
.so man3/addressing.3so
.SH DATASHEET
.br
http://pdfserv.maxim-ic.com/en/ds/DS2405.pdf
.SH SEE ALSO
.so man3/seealso.3so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
