///////////////////////////////////////////////////////////////////////////////
//
//  Copyright (2008) Alexander Stukowski
//
//  This file is part of OVITO (Open Visualization Tool).
//
//  OVITO is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.
//
//  OVITO is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//
///////////////////////////////////////////////////////////////////////////////

/******************************************************************************
* This header file includes the standard system headers used throughout
* the core.
*
* This header file is included by every .cpp file in the project to facilitate
* the generation of precompiled headers. This feature is mainly used with the
* Microsoft Visual C++ compiler.
******************************************************************************/

#ifndef __OVITO_CORE_H
#define __OVITO_CORE_H

/******************************************************************************
* The Base module is required by the Core module.
******************************************************************************/
#include <base/Base.h>

/******************************************************************************
* Include Qt OpenGL module.
******************************************************************************/
#include <QtOpenGL>

#ifdef max
#undef max
#endif
#ifdef min
#undef min
#endif

#ifdef MAKING_MODULE_CORE
#define CORE_DLLEXPORT DLL_EXPORT_DECL
#else
#define CORE_DLLEXPORT DLL_IMPORT_DECL
#endif

/******************************************************************************
* Include some basic and often used classes from the Base module by default.
******************************************************************************/
#include <base/utilities/Exception.h>
#include <base/utilities/Logger.h>
#include <base/io/SaveStream.h>
#include <base/io/LoadStream.h>
#include <base/utilities/Color.h>
#include <base/linalg/LinAlg.h>

// Make all classes of the Core namespace available by default.
namespace Core {};
using namespace Core;

/******************************************************************************
* Include some basic and often used classes from the Core module by default.
******************************************************************************/
#include <core/plugins/PluginClass.h>
#include <core/viewport/OpenGLInterface.h>

#endif // __OVITO_CORE_H
