
# NAME

osmium-add-locations-to-ways - add node locations to ways in OSM file


# SYNOPSIS

**osmium add-locations-to-ways** \[*OPTIONS*\] *OSM-FILE*...


# DESCRIPTION

Usually only nodes have locations and the ways refer to those locations via the
IDs of the nodes. This program will copy the input file(s) to the output,
taking the locations from the nodes and adding them to the ways. This makes
it easier for other programs to assemble the way geometries.

The input file must contain all nodes needed for the ways, otherwise there will
be an error. You can change this behaviour using the `--ignore-missing-nodes`
option.

Nodes without any tags will not be copied (unless the **--keep-untagged-nodes**,
**-n** option is used). The size of the output file will be similar or a bit
smaller than the input file (unless the **--keep-untagged-nodes**,
**-n** option is used in which case it will be a lot bigger).

Note that the OSM files generated by this command use a non-standard format
extension.

The **osmium add-locations-to-ways** command has to keep an index of the node
locations in memory or in a temporary file on disk while doing its work. There
are several different ways it can do that which have different advantages and
disadvantages. The default is good enough for most cases, but see the
**osmium-index-types**(5) man page for details.

If the **--keep-untagged-nodes**, **-n** option is used, files created by this
command can be updated with the **apply-changes** command using the
**--locations-on-ways** option.

This command will not work on full history files.

This commands reads its input file(s) only once and writes its output file
in one go so it can be streamed, ie. it can read from STDIN and write to
STDOUT.


# OPTIONS

-i, --index-type=TYPE
:   Set the index type. For details see the **osmium-index-types**(5) man
    page.

-I, --show-index-types
:   Shows a list of available index types. For details see the
    **osmium-index-types**(5) man page.

-n, --keep-untagged-nodes
:   Keep the untagged nodes in the output file.

--ignore-missing-nodes
:   If this is not set a missing node needed for a way results in an error.
    If this is set, errors are ignored and the way will have an invalid
    location set for the missing node.

@MAN_COMMON_OPTIONS@
@MAN_PROGRESS_OPTIONS@
@MAN_INPUT_OPTIONS@
@MAN_OUTPUT_OPTIONS@

# DIAGNOSTICS

**osmium add-locations-to-ways** exits with exit code

0
  ~ if everything went alright,

1
  ~ if there was an error processing the data, or

2
  ~ if there was a problem with the command line arguments.


# MEMORY USAGE

**osmium add-locations-to-ways** will usually keep all node locations in
memory. For larger data files, this can need several tens of GBytes of memory.
See the **osmium-index-types**(5) man page for details.


# EXAMPLES

Add node locations to an extract keeping all nodes:

    osmium add-locations-to-ways -n -o germany-low.osm.pbf germany.osm.pbf

Add node locations to a planet file (without untagged nodes):

    osmium add-locations-to-ways -i dense_mmap_array -o planet-low.osm.pbf planet.osm.pbf


# SEE ALSO

* **osmium**(1), **osmium-file-formats**(5), **osmium-index-types**(5)
* [Osmium website](http://osmcode.org/osmium-tool/)

