# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory USN-851-1 (elinks)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(66112);
 script_cve_id("CVE-2006-5925", "CVE-2008-7224");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.8");
 script_tag(name:"risk_factor", value:"High");
 script_name("Ubuntu USN-851-1 (elinks)");

 desc = "The remote host is missing an update to elinks
announced via advisory USN-851-1.

Details follow:

Teemu Salmela discovered that Elinks did not properly validate input when
processing smb:// URLs. If a user were tricked into viewing a malicious
website and had smbclient installed, a remote attacker could execute
arbitrary code with the privileges of the user invoking the program.
(CVE-2006-5925)

Jakub Wilk discovered a logic error in Elinks, leading to a buffer
overflow. If a user were tricked into viewing a malicious website, a remote
attacker could cause a denial of service via application crash, or possibly
execute arbitrary code with the privileges of the user invoking the
program. (CVE-2008-7224)

Solution:
The problem can be corrected by upgrading your system to the
following package versions:

Ubuntu 6.06 LTS:
  elinks                          0.10.6-1ubuntu3.4
  elinks-lite                     0.10.6-1ubuntu3.4

After a standard system upgrade you need to restart Elinks to effect
the necessary changes.

https://secure1.securityspace.com/smysecure/catid.html?in=USN-851-1

Risk factor : High";

 script_description(desc);

 script_summary("Ubuntu USN-851-1 (elinks)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Ubuntu Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"elinks", ver:"0.10.6-1ubuntu3.4", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"elinks-lite", ver:"0.10.6-1ubuntu3.4", rls:"UBUNTU6.06 LTS")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
