###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_openforum_detect.nasl 4296 2009-08-27 15:33:24Z aug $
#
# OpenForum Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900926);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("OpenForum Version Detection");
  desc = "
  Overview: This script detects the installed version of OpenForum and
  sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of OpenForum");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

opnfrmPort = get_http_port(default:80);
if(!opnfrmPort){
  opnfrmPort = 80;
}

if(!get_port_state(opnfrmPort)){
  exit(0);
}

foreach dir (make_list("/openforum", "/opnfrm", "/forum", cgi_dirs()))
{
  sndReq = http_get(item:string(dir, "/index.php"), port:opnfrmPort);
  rcvRes = http_send_recv(port:opnfrmPort, data:sndReq);
  if("OpenForum" >< rcvRes)
  {
    opnfrmVer = eregmatch(pattern:"Version (([0-9.]+) ?(Beta|Alpha[0-9]+?)?)",
                          string:rcvRes);
    if(opnfrmVer[1] != NULL)
    {
      ofVer = ereg_replace(pattern:" ", string:opnfrmVer[1], replace:".");
      if(ofVer != NULL){
       set_kb_item(name:"www/" + opnfrmPort + "/OpenForum", value:ofVer +
                                                          " under " + dir);
       security_note(data:"OpenForum version " + ofVer + " running at " +
                          "location " + dir +  " was detected on the host");
      }
    }
  }
}

