###############################################################################
# OpenVAS Vulnerability Test
# $Id: samba_32494.nasl 8288 2010-07-05 10:48:02Z mime $
#
# Samba Arbitrary Memory Contents Information Disclosure Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100337);
 script_bugtraq_id(32494);
 script_cve_id("CVE-2008-4314");
 script_version ("1.0-$Revision: 8288 $");
 script_tag(name:"cvss_base", value:"8.5");
 script_tag(name:"risk_factor", value:"Critical");

 script_name("Samba Arbitrary Memory Contents Information Disclosure Vulnerability");

desc = "Overview:
Samba is prone to an information-disclosure vulnerability.

Successful exploits will allow attackers to obtain arbitrary
memory contents.

This issue affects Samba 3.0.29 through 3.2.4.

Solution:
Updates are available. Please see the references for more information.

References:
http://www.securityfocus.com/bid/32494
http://www.samba.org
http://support.avaya.com/elmodocs2/security/ASA-2009-014.htm
http://sourceforge.net/project/shownotes.php?group_id=151951&release_id=503763
http://support.nortel.com/go/main.jsp?cscat=BLTNDETAIL&id=838290
http://us1.samba.org/samba/security/CVE-2008-4314.html
http://sunsolve.sun.com/search/document.do?assetkey=1-66-249087-1

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine if Samba is prone to an information-disclosure vulnerability");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("smb_nativelanman.nasl");
 script_require_ports(139, 445);
 script_require_keys("SMB/NativeLanManager");
 exit(0);
}

include("version_func.inc");

port = get_kb_item("SMB/transport");
if(!port)port = 139;

if(!get_port_state(port))exit(0);

if(!lanman = get_kb_item("SMB/NativeLanManager"))exit(0);
if("Samba" >!< lanman)exit(0);

if(!version = eregmatch(pattern:"Samba ([0-9.]+)", string: lanman))exit(0);
if(isnull(version[1]))exit(0);

if(version_in_range(version:version[1], test_version:"3.0.29", test_version2: "3.2.4")) {
  security_warning(port:port);
  exit(0);
}  

exit(0);

