###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_nulllogic_groupware_detect_win.nasl 3329 2009-07-10 17:42:37Z jul $
#
# NullLogic Groupware Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800905);
  script_version("$Revision: 1.1$");
  script_tag(name:"risk_factor", value:"None");
  script_name("NullLogic Groupware Version Detection");
  desc = "

  Overview: This script detects the installed version of NullLogic Groupware
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set Version of NullLogic Groupware in KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 4110);
  exit(0);
}


include("http_func.inc");

ngPort = get_http_port(default:4110);
if(!ngPort){
  ngPort = 4110;
}

if(!get_port_state(ngPort)){
  exit(0);
}

banner = get_http_banner(port:ngPort);
if("NullLogic Groupware" >!< banner){
  exit(0);
}

ngVer = eregmatch(pattern:"NullLogic Groupware ([0-9.]+)" , string:banner);
if(ngVer[1] != NULL)
{
  set_kb_item(name:"NullLogic-Groupware/Ver", value:ngVer[1]);
  security_note(data:"NullLogic Groupware version " + ngVer[1] +
                         " was detected on the host");
}
