#
#VID e69ba632-326f-11d9-b5b7-000854d03344
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52308);
 script_bugtraq_id(11657);
 script_cve_id("CVE-2004-0980");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "FreeBSD Ports: ez-ipupdate";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: ez-ipupdate

CVE-2004-0980
Format string vulnerability in ez-ipupdate.c for ez-ipupdate 3.0.10
through 3.0.11b8, when running in daemon mode with certain service
types in use, allows remote servers to execute arbitrary code.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://lists.netsys.com/pipermail/full-disclosure/2004-November/028590.html
http://www.vuxml.org/freebsd/e69ba632-326f-11d9-b5b7-000854d03344.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: ez-ipupdate";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"ez-ipupdate");
if(!isnull(bver) && revcomp(a:bver, b:"3.0.11b8_2")<0) {
    security_note(0, data:"Package ez-ipupdate version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
