\name{testLmFisher}
\alias{testLmFisher}
\title{Fisher test for a linear model.}
\description{
This ROT function, called from a Test C++ object, is given two samples, a  
scalar and a parameter vector. It predicts the values corresponding to the  
explanatory variables through the linear model, then computes the Fisher    
statistic. It is tested against the scalar, then the function returns the   
result of the test and the Fisher value.                                                                                                                                            
}
\usage{
testLmFisher(x, beta, y, testLevel = 0.95)
}
\arguments{
  \item{x}{A m-by-n matrix containing the explanatory variables.}
  \item{beta}{A n-by-1 vector containng the linear model parameters.}
  \item{y}{A n-by-1 vector containng the response variables.}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
  A list is returned, containing two scalars ,                  
  \item{testResult}{A scalar simulating a boolean (easier for Rserve)}
  \item{valueFisher}{A scalar.}
}
\details{
As it is not asked in LinearModel.getPredict(), no prediction interval 
is returned; it is up to the user to be careful about that. It is also to  
noted that the sample is not assumed to contain the '1's corresponding to  
the intercept parameter.
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
set.seed(1)
x <- matrix(runif(40), 10, 4)
r <- matrix(c(1,2,3,4), 4, 1)
y <- x \%*\% r + matrix(rnorm(10, 0, 0.05), 10, 1)
LM <- computeLinearModel(x, y)
testLmFisher(x, LM$parameterEstimate, y) 
}
\keyword{multivariate}