// This code was generated by CLI, a command line interface
// compiler for C++.
//

// Begin prologue.
//
#include <odb/option-parsers.hxx>
//
// End prologue.

#include <odb/options.hxx>

#include <map>
#include <set>
#include <string>
#include <vector>
#include <ostream>
#include <sstream>
#include <cstring>
#include <fstream>

namespace cli
{
  // unknown_option
  //
  unknown_option::
  ~unknown_option () throw ()
  {
  }

  void unknown_option::
  print (::std::ostream& os) const
  {
    os << "unknown option '" << option ().c_str () << "'";
  }

  const char* unknown_option::
  what () const throw ()
  {
    return "unknown option";
  }

  // unknown_argument
  //
  unknown_argument::
  ~unknown_argument () throw ()
  {
  }

  void unknown_argument::
  print (::std::ostream& os) const
  {
    os << "unknown argument '" << argument ().c_str () << "'";
  }

  const char* unknown_argument::
  what () const throw ()
  {
    return "unknown argument";
  }

  // missing_value
  //
  missing_value::
  ~missing_value () throw ()
  {
  }

  void missing_value::
  print (::std::ostream& os) const
  {
    os << "missing value for option '" << option ().c_str () << "'";
  }

  const char* missing_value::
  what () const throw ()
  {
    return "missing option value";
  }

  // invalid_value
  //
  invalid_value::
  ~invalid_value () throw ()
  {
  }

  void invalid_value::
  print (::std::ostream& os) const
  {
    os << "invalid value '" << value ().c_str () << "' for option '"
       << option ().c_str () << "'";
  }

  const char* invalid_value::
  what () const throw ()
  {
    return "invalid option value";
  }

  // eos_reached
  //
  void eos_reached::
  print (::std::ostream& os) const
  {
    os << what ();
  }

  const char* eos_reached::
  what () const throw ()
  {
    return "end of argument stream reached";
  }

  // file_io_failure
  //
  file_io_failure::
  ~file_io_failure () throw ()
  {
  }

  void file_io_failure::
  print (::std::ostream& os) const
  {
    os << "unable to open file '" << file ().c_str () << "' or read failure";
  }

  const char* file_io_failure::
  what () const throw ()
  {
    return "unable to open file or read failure";
  }

  // unmatched_quote
  //
  unmatched_quote::
  ~unmatched_quote () throw ()
  {
  }

  void unmatched_quote::
  print (::std::ostream& os) const
  {
    os << "unmatched quote in argument '" << argument ().c_str () << "'";
  }

  const char* unmatched_quote::
  what () const throw ()
  {
    return "unmatched quote";
  }

  // scanner
  //
  scanner::
  ~scanner ()
  {
  }

  // argv_scanner
  //
  bool argv_scanner::
  more ()
  {
    return i_ < argc_;
  }

  const char* argv_scanner::
  peek ()
  {
    if (i_ < argc_)
      return argv_[i_];
    else
      throw eos_reached ();
  }

  const char* argv_scanner::
  next ()
  {
    if (i_ < argc_)
    {
      const char* r (argv_[i_]);

      if (erase_)
      {
        for (int i (i_ + 1); i < argc_; ++i)
          argv_[i - 1] = argv_[i];

        --argc_;
        argv_[argc_] = 0;
      }
      else
        ++i_;

      return r;
    }
    else
      throw eos_reached ();
  }

  void argv_scanner::
  skip ()
  {
    if (i_ < argc_)
      ++i_;
    else
      throw eos_reached ();
  }

  // argv_file_scanner
  //
  bool argv_file_scanner::
  more ()
  {
    if (!args_.empty ())
      return true;

    while (base::more ())
    {
      // See if the next argument is the file option.
      //
      const char* a (base::peek ());
      const option_info* oi;

      if (!skip_ && (oi = find (a)))
      {
        base::next ();

        if (!base::more ())
          throw missing_value (oi->option);

        if (oi->search_func != 0)
        {
          std::string f (oi->search_func (base::next (), oi->arg));

          if (!f.empty ())
            load (f);
        }
        else
          load (base::next ());

        if (!args_.empty ())
          return true;
      }
      else
      {
        if (!skip_)
          skip_ = (std::strcmp (a, "--") == 0);

        return true;
      }
    }

    return false;
  }

  const char* argv_file_scanner::
  peek ()
  {
    if (!more ())
      throw eos_reached ();

    return args_.empty () ? base::peek () : args_.front ().c_str ();
  }

  const char* argv_file_scanner::
  next ()
  {
    if (!more ())
      throw eos_reached ();

    if (args_.empty ())
      return base::next ();
    else
    {
      hold_.swap (args_.front ());
      args_.pop_front ();
      return hold_.c_str ();
    }
  }

  void argv_file_scanner::
  skip ()
  {
    if (!more ())
      throw eos_reached ();

    if (args_.empty ())
      return base::skip ();
    else
      args_.pop_front ();
  }

  const argv_file_scanner::option_info* argv_file_scanner::
  find (const char* a) const
  {
    for (std::size_t i (0); i < options_count_; ++i)
      if (std::strcmp (a, options_[i].option) == 0)
        return &options_[i];

    return 0;
  }

  void argv_file_scanner::
  load (const std::string& file)
  {
    using namespace std;

    ifstream is (file.c_str ());

    if (!is.is_open ())
      throw file_io_failure (file);

    while (!is.eof ())
    {
      string line;
      getline (is, line);

      if (is.fail () && !is.eof ())
        throw file_io_failure (file);

      string::size_type n (line.size ());

      // Trim the line from leading and trailing whitespaces.
      //
      if (n != 0)
      {
        const char* f (line.c_str ());
        const char* l (f + n);

        const char* of (f);
        while (f < l && (*f == ' ' || *f == '\t' || *f == '\r'))
          ++f;

        --l;

        const char* ol (l);
        while (l > f && (*l == ' ' || *l == '\t' || *l == '\r'))
          --l;

        if (f != of || l != ol)
          line = f <= l ? string (f, l - f + 1) : string ();
      }

      // Ignore empty lines, those that start with #.
      //
      if (line.empty () || line[0] == '#')
        continue;

      string::size_type p (line.find (' '));

      if (p == string::npos)
      {
        if (!skip_)
          skip_ = (line == "--");

        args_.push_back (line);
      }
      else
      {
        string s1 (line, 0, p);

        // Skip leading whitespaces in the argument.
        //
        n = line.size ();
        for (++p; p < n; ++p)
        {
          char c (line[p]);

          if (c != ' ' && c != '\t' && c != '\r')
            break;
        }

        string s2 (line, p);

        // If the string is wrapped in quotes, remove them.
        //
        n = s2.size ();
        char cf (s2[0]), cl (s2[n - 1]);

        if (cf == '"' || cf == '\'' || cl == '"' || cl == '\'')
        {
          if (n == 1 || cf != cl)
            throw unmatched_quote (s2);

          s2 = string (s2, 1, n - 2);
        }

        const option_info* oi;
        if (!skip_ && (oi = find (s1.c_str ())))
        {
          if (s2.empty ())
            throw missing_value (oi->option);

          if (oi->search_func != 0)
          {
            std::string f (oi->search_func (s2.c_str (), oi->arg));

            if (!f.empty ())
              load (f);
          }
          else
            load (s2);
        }
        else
        {
          args_.push_back (s1);
          args_.push_back (s2);
        }
      }
    }
  }

  void options::
  push_back (const option& o)
  {
    container_type::size_type n (size ());
    container_type::push_back (o);
    map_[o.name ()] = n;

    for (option_names::const_iterator i (o.aliases ().begin ());
         i != o.aliases ().end (); ++i)
      map_[*i] = n;
  }

  template <typename X>
  struct parser
  {
    static void
    parse (X& x, bool& xs, scanner& s)
    {
      std::string o (s.next ());

      if (s.more ())
      {
        std::string v (s.next ());
        std::istringstream is (v);
        if (!(is >> x && is.eof ()))
          throw invalid_value (o, v);
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <>
  struct parser<bool>
  {
    static void
    parse (bool& x, scanner& s)
    {
      s.next ();
      x = true;
    }
  };

  template <>
  struct parser<std::string>
  {
    static void
    parse (std::string& x, bool& xs, scanner& s)
    {
      const char* o (s.next ());

      if (s.more ())
        x = s.next ();
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X>
  struct parser<std::vector<X> >
  {
    static void
    parse (std::vector<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.push_back (x);
      xs = true;
    }
  };

  template <typename X>
  struct parser<std::set<X> >
  {
    static void
    parse (std::set<X>& c, bool& xs, scanner& s)
    {
      X x;
      bool dummy;
      parser<X>::parse (x, dummy, s);
      c.insert (x);
      xs = true;
    }
  };

  template <typename K, typename V>
  struct parser<std::map<K, V> >
  {
    static void
    parse (std::map<K, V>& m, bool& xs, scanner& s)
    {
      std::string o (s.next ());

      if (s.more ())
      {
        std::string ov (s.next ());
        std::string::size_type p = ov.find ('=');

        if (p == std::string::npos)
        {
          K k = K ();

          if (!ov.empty ())
          {
            std::istringstream ks (ov);

            if (!(ks >> k && ks.eof ()))
              throw invalid_value (o, ov);
          }

          m[k] = V ();
        }
        else
        {
          K k = K ();
          V v = V ();
          std::string kstr (ov, 0, p);
          std::string vstr (ov, p + 1);

          if (!kstr.empty ())
          {
            std::istringstream ks (kstr);

            if (!(ks >> k && ks.eof ()))
              throw invalid_value (o, ov);
          }

          if (!vstr.empty ())
          {
            std::istringstream vs (vstr);

            if (!(vs >> v && vs.eof ()))
              throw invalid_value (o, ov);
          }

          m[k] = v;
        }
      }
      else
        throw missing_value (o);

      xs = true;
    }
  };

  template <typename X, typename T, T X::*M>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, s);
  }

  template <typename X, typename T, T X::*M, bool X::*S>
  void
  thunk (X& x, scanner& s)
  {
    parser<T>::parse (x.*M, x.*S, s);
  }
}

#include <map>
#include <cstring>

// options
//

options::
options ()
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
}

options::
options (int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int start,
         int& argc,
         char** argv,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
}

options::
options (int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
  ::cli::argv_scanner s (argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (int start,
         int& argc,
         char** argv,
         int& end,
         bool erase,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
  ::cli::argv_scanner s (start, argc, argv, erase);
  _parse (s, opt, arg);
  end = s.end ();
}

options::
options (::cli::scanner& s,
         ::cli::unknown_mode opt,
         ::cli::unknown_mode arg)
: help_ (),
  version_ (),
  I_ (),
  I_specified_ (false),
  D_ (),
  D_specified_ (false),
  U_ (),
  U_specified_ (false),
  database_ (),
  database_specified_ (false),
  multi_database_ (::multi_database::disabled),
  multi_database_specified_ (false),
  default_database_ (),
  default_database_specified_ (false),
  generate_query_ (),
  generate_prepared_ (),
  omit_unprepared_ (),
  generate_session_ (),
  generate_schema_ (),
  generate_schema_only_ (),
  suppress_migration_ (),
  suppress_schema_version_ (),
  schema_version_table_ (),
  schema_version_table_specified_ (false),
  schema_format_ (),
  schema_format_specified_ (false),
  omit_drop_ (),
  omit_create_ (),
  schema_name_ (),
  schema_name_specified_ (false),
  fkeys_deferrable_mode_ (),
  fkeys_deferrable_mode_specified_ (false),
  default_pointer_ ("*"),
  default_pointer_specified_ (false),
  session_type_ ("odb::session"),
  session_type_specified_ (false),
  profile_ (),
  profile_specified_ (false),
  at_once_ (),
  schema_ (),
  schema_specified_ (false),
  export_symbol_ (),
  export_symbol_specified_ (false),
  extern_symbol_ (),
  extern_symbol_specified_ (false),
  std_ (cxx_version::cxx98),
  std_specified_ (false),
  warn_hard_add_ (),
  warn_hard_delete_ (),
  warn_hard_ (),
  output_dir_ (),
  output_dir_specified_ (false),
  input_name_ (),
  input_name_specified_ (false),
  changelog_ (),
  changelog_specified_ (false),
  changelog_in_ (),
  changelog_in_specified_ (false),
  changelog_out_ (),
  changelog_out_specified_ (false),
  changelog_dir_ (),
  changelog_dir_specified_ (false),
  init_changelog_ (),
  odb_file_suffix_ (),
  odb_file_suffix_specified_ (false),
  sql_file_suffix_ (),
  sql_file_suffix_specified_ (false),
  schema_file_suffix_ (),
  schema_file_suffix_specified_ (false),
  changelog_file_suffix_ (),
  changelog_file_suffix_specified_ (false),
  hxx_suffix_ (".hxx"),
  hxx_suffix_specified_ (false),
  ixx_suffix_ (".ixx"),
  ixx_suffix_specified_ (false),
  cxx_suffix_ (".cxx"),
  cxx_suffix_specified_ (false),
  sql_suffix_ (".sql"),
  sql_suffix_specified_ (false),
  changelog_suffix_ (".xml"),
  changelog_suffix_specified_ (false),
  hxx_prologue_ (),
  hxx_prologue_specified_ (false),
  ixx_prologue_ (),
  ixx_prologue_specified_ (false),
  cxx_prologue_ (),
  cxx_prologue_specified_ (false),
  schema_prologue_ (),
  schema_prologue_specified_ (false),
  sql_prologue_ (),
  sql_prologue_specified_ (false),
  migration_prologue_ (),
  migration_prologue_specified_ (false),
  sql_interlude_ (),
  sql_interlude_specified_ (false),
  hxx_epilogue_ (),
  hxx_epilogue_specified_ (false),
  ixx_epilogue_ (),
  ixx_epilogue_specified_ (false),
  cxx_epilogue_ (),
  cxx_epilogue_specified_ (false),
  schema_epilogue_ (),
  schema_epilogue_specified_ (false),
  sql_epilogue_ (),
  sql_epilogue_specified_ (false),
  migration_epilogue_ (),
  migration_epilogue_specified_ (false),
  hxx_prologue_file_ (),
  hxx_prologue_file_specified_ (false),
  ixx_prologue_file_ (),
  ixx_prologue_file_specified_ (false),
  cxx_prologue_file_ (),
  cxx_prologue_file_specified_ (false),
  schema_prologue_file_ (),
  schema_prologue_file_specified_ (false),
  sql_prologue_file_ (),
  sql_prologue_file_specified_ (false),
  migration_prologue_file_ (),
  migration_prologue_file_specified_ (false),
  sql_interlude_file_ (),
  sql_interlude_file_specified_ (false),
  hxx_epilogue_file_ (),
  hxx_epilogue_file_specified_ (false),
  ixx_epilogue_file_ (),
  ixx_epilogue_file_specified_ (false),
  cxx_epilogue_file_ (),
  cxx_epilogue_file_specified_ (false),
  schema_epilogue_file_ (),
  schema_epilogue_file_specified_ (false),
  sql_epilogue_file_ (),
  sql_epilogue_file_specified_ (false),
  migration_epilogue_file_ (),
  migration_epilogue_file_specified_ (false),
  odb_prologue_ (),
  odb_prologue_specified_ (false),
  odb_prologue_file_ (),
  odb_prologue_file_specified_ (false),
  odb_epilogue_ (),
  odb_epilogue_specified_ (false),
  odb_epilogue_file_ (),
  odb_epilogue_file_specified_ (false),
  table_prefix_ (),
  table_prefix_specified_ (false),
  index_suffix_ (),
  index_suffix_specified_ (false),
  fkey_suffix_ (),
  fkey_suffix_specified_ (false),
  sequence_suffix_ (),
  sequence_suffix_specified_ (false),
  sql_name_case_ (),
  sql_name_case_specified_ (false),
  table_regex_ (),
  table_regex_specified_ (false),
  column_regex_ (),
  column_regex_specified_ (false),
  index_regex_ (),
  index_regex_specified_ (false),
  fkey_regex_ (),
  fkey_regex_specified_ (false),
  sequence_regex_ (),
  sequence_regex_specified_ (false),
  statement_regex_ (),
  statement_regex_specified_ (false),
  sql_name_regex_ (),
  sql_name_regex_specified_ (false),
  sql_name_regex_trace_ (),
  accessor_regex_ (),
  accessor_regex_specified_ (false),
  accessor_regex_trace_ (),
  modifier_regex_ (),
  modifier_regex_specified_ (false),
  modifier_regex_trace_ (),
  include_with_brackets_ (),
  include_prefix_ (),
  include_prefix_specified_ (false),
  include_regex_ (),
  include_regex_specified_ (false),
  include_regex_trace_ (),
  guard_prefix_ (),
  guard_prefix_specified_ (false),
  show_sloc_ (),
  sloc_limit_ (),
  sloc_limit_specified_ (false),
  options_file_ (),
  options_file_specified_ (false),
  x_ (),
  x_specified_ (false),
  v_ (),
  trace_ (),
  mysql_engine_ ("InnoDB"),
  mysql_engine_specified_ (false),
  sqlite_override_null_ (),
  sqlite_lax_auto_id_ (),
  pgsql_server_version_ (7, 4),
  pgsql_server_version_specified_ (false),
  oracle_client_version_ (10, 1),
  oracle_client_version_specified_ (false),
  oracle_warn_truncation_ (),
  mssql_server_version_ (10, 0),
  mssql_server_version_specified_ (false),
  mssql_short_limit_ (1024),
  mssql_short_limit_specified_ (false)
{
  _parse (s, opt, arg);
}

void options::
print_usage (::std::ostream& os)
{
  os << "--help                        Print usage information and exit." << ::std::endl;

  os << "--version                     Print version and exit." << ::std::endl;

  os << "-I <dir>                      Add <dir> to the beginning of the list of" << ::std::endl
     << "                              directories to be searched for included header" << ::std::endl
     << "                              files." << ::std::endl;

  os << "-D <name>[=<def>]             Define macro <name> with definition <def>." << ::std::endl;

  os << "-U <name>                     Cancel any previous definitions of macro <name>," << ::std::endl
     << "                              either built-in or provided with the '-D' option." << ::std::endl;

  os << "--database|-d <db>            Generate code for the <db> database." << ::std::endl;

  os << "--multi-database|-m <type>    Enable multi-database support and specify its" << ::std::endl
     << "                              type." << ::std::endl;

  os << "--default-database <db>       When static multi-database support is used," << ::std::endl
     << "                              specify the database that should be made the" << ::std::endl
     << "                              default." << ::std::endl;

  os << "--generate-query|-q           Generate query support code." << ::std::endl;

  os << "--generate-prepared           Generate prepared query execution support code." << ::std::endl;

  os << "--omit-unprepared             Omit un-prepared (once-off) query execution" << ::std::endl
     << "                              support code." << ::std::endl;

  os << "--generate-session|-e         Generate session support code." << ::std::endl;

  os << "--generate-schema|-s          Generate the database schema." << ::std::endl;

  os << "--generate-schema-only        Generate only the database schema." << ::std::endl;

  os << "--suppress-migration          Suppress the generation of database schema" << ::std::endl
     << "                              migration statements." << ::std::endl;

  os << "--suppress-schema-version     Suppress the generation of schema version table." << ::std::endl;

  os << "--schema-version-table <name> Specify the alternative schema version table name" << ::std::endl
     << "                              instead of the default 'schema_version'." << ::std::endl;

  os << "--schema-format <format>      Generate the database schema in the specified" << ::std::endl
     << "                              format." << ::std::endl;

  os << "--omit-drop                   Omit 'DROP' statements from the generated" << ::std::endl
     << "                              database schema." << ::std::endl;

  os << "--omit-create                 Omit 'CREATE' statements from the generated" << ::std::endl
     << "                              database schema." << ::std::endl;

  os << "--schema-name <name>          Use <name> as the database schema name." << ::std::endl;

  os << "--fkeys-deferrable-mode <m>   Use constraint checking mode <m> in foreign keys" << ::std::endl
     << "                              generated for object relationships." << ::std::endl;

  os << "--default-pointer <ptr>       Use <ptr> as the default pointer for persistent" << ::std::endl
     << "                              objects and views." << ::std::endl;

  os << "--session-type <type>         Use <type> as the alternative session type" << ::std::endl
     << "                              instead of the default 'odb::session'." << ::std::endl;

  os << "--profile|-p <name>           Specify a profile that should be used during" << ::std::endl
     << "                              compilation." << ::std::endl;

  os << "--at-once                     Generate code for all the input files as well as" << ::std::endl
     << "                              for all the files that they include at once." << ::std::endl;

  os << "--schema <schema>             Specify a database schema (database namespace)" << ::std::endl
     << "                              that should be assigned to the persistent classes" << ::std::endl
     << "                              in the file being compiled." << ::std::endl;

  os << "--export-symbol <symbol>      Insert <symbol> in places where DLL export/import" << ::std::endl
     << "                              control statements" << ::std::endl
     << "                              ('__declspec(dllexport/dllimport)') are" << ::std::endl
     << "                              necessary." << ::std::endl;

  os << "--extern-symbol <symbol>      If <symbol> is defined, insert it in places where" << ::std::endl
     << "                              a template instantiation must be declared" << ::std::endl
     << "                              'extern'." << ::std::endl;

  os << "--std <version>               Specify the C++ standard that should be used" << ::std::endl
     << "                              during compilation." << ::std::endl;

  os << "--warn-hard-add               Warn about hard-added data members." << ::std::endl;

  os << "--warn-hard-delete            Warn about hard-deleted data members and" << ::std::endl
     << "                              persistent classes." << ::std::endl;

  os << "--warn-hard                   Warn about both hard-added and hard-deleted data" << ::std::endl
     << "                              members and persistent classes." << ::std::endl;

  os << "--output-dir|-o <dir>         Write the generated files to <dir> instead of the" << ::std::endl
     << "                              current directory." << ::std::endl;

  os << "--input-name <name>           Use <name> instead of the input file to derive" << ::std::endl
     << "                              the names of the generated files." << ::std::endl;

  os << "--changelog <file>            Read/write changelog from/to <file> instead of" << ::std::endl
     << "                              the default changelog file." << ::std::endl;

  os << "--changelog-in <file>         Read changelog from <file> instead of the default" << ::std::endl
     << "                              changelog file." << ::std::endl;

  os << "--changelog-out <file>        Write changelog to <file> instead of the default" << ::std::endl
     << "                              changelog file." << ::std::endl;

  os << "--changelog-dir <dir>         Use <dir> instead of the input file directory as" << ::std::endl
     << "                              the changelog file directory." << ::std::endl;

  os << "--init-changelog              Force re-initialization of the changelog even if" << ::std::endl
     << "                              one exists (all the existing change history will" << ::std::endl
     << "                              be lost)." << ::std::endl;

  os << "--odb-file-suffix <suffix>    Use <suffix> to construct the names of the" << ::std::endl
     << "                              generated C++ files." << ::std::endl;

  os << "--sql-file-suffix <suffix>    Use <suffix> to construct the name of the" << ::std::endl
     << "                              generated schema SQL file." << ::std::endl;

  os << "--schema-file-suffix <suffix> Use <suffix> to construct the name of the" << ::std::endl
     << "                              generated schema C++ source file." << ::std::endl;

  os << "--changelog-file-suffix <sfx> Use <sfx> to construct the name of the changelog" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--hxx-suffix <suffix>         Use <suffix> instead of the default '.hxx' to" << ::std::endl
     << "                              construct the name of the generated C++ header" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--ixx-suffix <suffix>         Use <suffix> instead of the default '.ixx' to" << ::std::endl
     << "                              construct the name of the generated C++ inline" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--cxx-suffix <suffix>         Use <suffix> instead of the default '.cxx' to" << ::std::endl
     << "                              construct the name of the generated C++ source" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--sql-suffix <suffix>         Use <suffix> instead of the default '.sql' to" << ::std::endl
     << "                              construct the name of the generated database" << ::std::endl
     << "                              schema file." << ::std::endl;

  os << "--changelog-suffix <suffix>   Use <suffix> instead of the default '.xml' to" << ::std::endl
     << "                              construct the name of the changelog file." << ::std::endl;

  os << "--hxx-prologue <text>         Insert <text> at the beginning of the generated" << ::std::endl
     << "                              C++ header file." << ::std::endl;

  os << "--ixx-prologue <text>         Insert <text> at the beginning of the generated" << ::std::endl
     << "                              C++ inline file." << ::std::endl;

  os << "--cxx-prologue <text>         Insert <text> at the beginning of the generated" << ::std::endl
     << "                              C++ source file." << ::std::endl;

  os << "--schema-prologue <text>      Insert <text> at the beginning of the generated" << ::std::endl
     << "                              schema C++ source file." << ::std::endl;

  os << "--sql-prologue <text>         Insert <text> at the beginning of the generated" << ::std::endl
     << "                              database schema file." << ::std::endl;

  os << "--migration-prologue <text>   Insert <text> at the beginning of the generated" << ::std::endl
     << "                              database migration file." << ::std::endl;

  os << "--sql-interlude <text>        Insert <text> after all the 'DROP' and before any" << ::std::endl
     << "                              'CREATE' statements in the generated database" << ::std::endl
     << "                              schema file." << ::std::endl;

  os << "--hxx-epilogue <text>         Insert <text> at the end of the generated C++" << ::std::endl
     << "                              header file." << ::std::endl;

  os << "--ixx-epilogue <text>         Insert <text> at the end of the generated C++" << ::std::endl
     << "                              inline file." << ::std::endl;

  os << "--cxx-epilogue <text>         Insert <text> at the end of the generated C++" << ::std::endl
     << "                              source file." << ::std::endl;

  os << "--schema-epilogue <text>      Insert <text> at the end of the generated schema" << ::std::endl
     << "                              C++ source file." << ::std::endl;

  os << "--sql-epilogue <text>         Insert <text> at the end of the generated" << ::std::endl
     << "                              database schema file." << ::std::endl;

  os << "--migration-epilogue <text>   Insert <text> at the end of the generated" << ::std::endl
     << "                              database migration file." << ::std::endl;

  os << "--hxx-prologue-file <file>    Insert the content of <file> at the beginning of" << ::std::endl
     << "                              the generated C++ header file." << ::std::endl;

  os << "--ixx-prologue-file <file>    Insert the content of <file> at the beginning of" << ::std::endl
     << "                              the generated C++ inline file." << ::std::endl;

  os << "--cxx-prologue-file <file>    Insert the content of <file> at the beginning of" << ::std::endl
     << "                              the generated C++ source file." << ::std::endl;

  os << "--schema-prologue-file <file> Insert the content of <file> at the beginning of" << ::std::endl
     << "                              the generated schema C++ source file." << ::std::endl;

  os << "--sql-prologue-file <file>    Insert the content of <file> at the beginning of" << ::std::endl
     << "                              the generated database schema file." << ::std::endl;

  os << "--migration-prologue-file <f> Insert the content of file <f> at the beginning" << ::std::endl
     << "                              of the generated database migration file." << ::std::endl;

  os << "--sql-interlude-file <file>   Insert the content of <file> after all the 'DROP'" << ::std::endl
     << "                              and before any 'CREATE' statements in the" << ::std::endl
     << "                              generated database schema file." << ::std::endl;

  os << "--hxx-epilogue-file <file>    Insert the content of <file> at the end of the" << ::std::endl
     << "                              generated C++ header file." << ::std::endl;

  os << "--ixx-epilogue-file <file>    Insert the content of <file> at the end of the" << ::std::endl
     << "                              generated C++ inline file." << ::std::endl;

  os << "--cxx-epilogue-file <file>    Insert the content of <file> at the end of the" << ::std::endl
     << "                              generated C++ source file." << ::std::endl;

  os << "--schema-epilogue-file <file> Insert the content of <file> at the end of the" << ::std::endl
     << "                              generated schema C++ source file." << ::std::endl;

  os << "--sql-epilogue-file <file>    Insert the content of <file> at the end of the" << ::std::endl
     << "                              generated database schema file." << ::std::endl;

  os << "--migration-epilogue-file <f> Insert the content of file <f> at the end of the" << ::std::endl
     << "                              generated database migration file." << ::std::endl;

  os << "--odb-prologue <text>         Compile <text> before the input header file." << ::std::endl;

  os << "--odb-prologue-file <file>    Compile <file> contents before the input header" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--odb-epilogue <text>         Compile <text> after the input header file." << ::std::endl;

  os << "--odb-epilogue-file <file>    Compile <file> contents after the input header" << ::std::endl
     << "                              file." << ::std::endl;

  os << "--table-prefix <prefix>       Add <prefix> to table names and, for databases" << ::std::endl
     << "                              that have global index and/or foreign key names," << ::std::endl
     << "                              to those names as well." << ::std::endl;

  os << "--index-suffix <suffix>       Use <suffix> instead of the default '_i' to" << ::std::endl
     << "                              construct index names." << ::std::endl;

  os << "--fkey-suffix <suffix>        Use <suffix> instead of the default '_fk' to" << ::std::endl
     << "                              construct foreign key names." << ::std::endl;

  os << "--sequence-suffix <suffix>    Use <suffix> instead of the default '_seq' to" << ::std::endl
     << "                              construct sequence names." << ::std::endl;

  os << "--sql-name-case <case>        Convert all automatically-derived SQL names to" << ::std::endl
     << "                              upper or lower case." << ::std::endl;

  os << "--table-regex <regex>         Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              table names." << ::std::endl;

  os << "--column-regex <regex>        Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              column names." << ::std::endl;

  os << "--index-regex <regex>         Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              index names." << ::std::endl;

  os << "--fkey-regex <regex>          Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              foreign key names." << ::std::endl;

  os << "--sequence-regex <regex>      Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              sequence names." << ::std::endl;

  os << "--statement-regex <regex>     Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform automatically-derived" << ::std::endl
     << "                              prepared statement names." << ::std::endl;

  os << "--sql-name-regex <regex>      Add <regex> to the list of regular expressions" << ::std::endl
     << "                              that is used to transform all" << ::std::endl
     << "                              automatically-derived SQL names." << ::std::endl;

  os << "--sql-name-regex-trace        Trace the process of applying regular expressions" << ::std::endl
     << "                              specified with the SQL name '--*-regex' options." << ::std::endl;

  os << "--accessor-regex <regex>      Add <regex> to the list of regular expressions" << ::std::endl
     << "                              used to transform data member names to function" << ::std::endl
     << "                              names when searching for a suitable accessor" << ::std::endl
     << "                              function." << ::std::endl;

  os << "--accessor-regex-trace        Trace the process of applying regular expressions" << ::std::endl
     << "                              specified with the '--accessor-regex' option." << ::std::endl;

  os << "--modifier-regex <regex>      Add <regex> to the list of regular expressions" << ::std::endl
     << "                              used to transform data member names to function" << ::std::endl
     << "                              names when searching for a suitable modifier" << ::std::endl
     << "                              function." << ::std::endl;

  os << "--modifier-regex-trace        Trace the process of applying regular expressions" << ::std::endl
     << "                              specified with the '--modifier-regex' option." << ::std::endl;

  os << "--include-with-brackets       Use angle brackets (<>) instead of quotes (\"\") in" << ::std::endl
     << "                              the generated '#include' directives." << ::std::endl;

  os << "--include-prefix <prefix>     Add <prefix> to the generated '#include'" << ::std::endl
     << "                              directive paths." << ::std::endl;

  os << "--include-regex <regex>       Add <regex> to the list of regular expressions" << ::std::endl
     << "                              used to transform generated '#include' directive" << ::std::endl
     << "                              paths." << ::std::endl;

  os << "--include-regex-trace         Trace the process of applying regular expressions" << ::std::endl
     << "                              specified with the '--include-regex' option." << ::std::endl;

  os << "--guard-prefix <prefix>       Add <prefix> to the generated header inclusion" << ::std::endl
     << "                              guards." << ::std::endl;

  os << "--show-sloc                   Print the number of generated physical source" << ::std::endl
     << "                              lines of code (SLOC)." << ::std::endl;

  os << "--sloc-limit <num>            Check that the number of generated physical" << ::std::endl
     << "                              source lines of code (SLOC) does not exceed" << ::std::endl
     << "                              <num>." << ::std::endl;

  os << "--options-file <file>         Read additional options from <file> with each" << ::std::endl
     << "                              option appearing on a separate line optionally" << ::std::endl
     << "                              followed by space and an option value." << ::std::endl;

  os << "-x <option>                   Pass <option> to the underlying C++ compiler" << ::std::endl
     << "                              ('g++')." << ::std::endl;

  os << "-v                            Print the commands executed to run the stages of" << ::std::endl
     << "                              compilation." << ::std::endl;

  os << "--trace                       Trace the compilation process." << ::std::endl;

  os << "--mysql-engine <engine>       Use <engine> instead of the default 'InnoDB' in" << ::std::endl
     << "                              the generated database schema file." << ::std::endl;

  os << "--sqlite-override-null        Make all columns in the generated database schema" << ::std::endl
     << "                              allow 'NULL' values." << ::std::endl;

  os << "--sqlite-lax-auto-id          Do not force monotonically increasing" << ::std::endl
     << "                              automatically-assigned object ids." << ::std::endl;

  os << "--pgsql-server-version <ver>  Specify the minimum PostgreSQL server version" << ::std::endl
     << "                              with which the generated C++ code and schema will" << ::std::endl
     << "                              be used." << ::std::endl;

  os << "--oracle-client-version <ver> Specify the minimum Oracle client library (OCI)" << ::std::endl
     << "                              version with which the generated C++ code will be" << ::std::endl
     << "                              linked." << ::std::endl;

  os << "--oracle-warn-truncation      Warn about SQL names that are longer than 30" << ::std::endl
     << "                              characters and are therefore truncated." << ::std::endl;

  os << "--mssql-server-version <ver>  Specify the minimum SQL Server server version" << ::std::endl
     << "                              with which the generated C++ code and schema will" << ::std::endl
     << "                              be used." << ::std::endl;

  os << "--mssql-short-limit <size>    Specify the short data size limit." << ::std::endl;
}

static ::cli::options _cli_options_desc_;

struct _cli_options_desc_init
{
  _cli_options_desc_init (::cli::options& os)
  {
    options::fill (os);
  }
};

static _cli_options_desc_init _cli_options_desc_init_ (_cli_options_desc_);

void options::
fill (::cli::options&  os)
{
  // --help
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--help", a, true, dv);
    os.push_back (o);
  }

  // --version
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--version", a, true, dv);
    os.push_back (o);
  }

  // -I
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("-I", a, false, dv);
    os.push_back (o);
  }

  // -D
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("-D", a, false, dv);
    os.push_back (o);
  }

  // -U
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("-U", a, false, dv);
    os.push_back (o);
  }

  // --database
  //
  {
    ::cli::option_names a;
    a.push_back ("-d");
    std::string dv;
    ::cli::option o ("--database", a, false, dv);
    os.push_back (o);
  }

  // --multi-database
  //
  {
    ::cli::option_names a;
    a.push_back ("-m");
    std::string dv;
    ::cli::option o ("--multi-database", a, false, dv);
    os.push_back (o);
  }

  // --default-database
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--default-database", a, false, dv);
    os.push_back (o);
  }

  // --generate-query
  //
  {
    ::cli::option_names a;
    a.push_back ("-q");
    std::string dv;
    ::cli::option o ("--generate-query", a, true, dv);
    os.push_back (o);
  }

  // --generate-prepared
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--generate-prepared", a, true, dv);
    os.push_back (o);
  }

  // --omit-unprepared
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--omit-unprepared", a, true, dv);
    os.push_back (o);
  }

  // --generate-session
  //
  {
    ::cli::option_names a;
    a.push_back ("-e");
    std::string dv;
    ::cli::option o ("--generate-session", a, true, dv);
    os.push_back (o);
  }

  // --generate-schema
  //
  {
    ::cli::option_names a;
    a.push_back ("-s");
    std::string dv;
    ::cli::option o ("--generate-schema", a, true, dv);
    os.push_back (o);
  }

  // --generate-schema-only
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--generate-schema-only", a, true, dv);
    os.push_back (o);
  }

  // --suppress-migration
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--suppress-migration", a, true, dv);
    os.push_back (o);
  }

  // --suppress-schema-version
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--suppress-schema-version", a, true, dv);
    os.push_back (o);
  }

  // --schema-version-table
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-version-table", a, false, dv);
    os.push_back (o);
  }

  // --schema-format
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-format", a, false, dv);
    os.push_back (o);
  }

  // --omit-drop
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--omit-drop", a, true, dv);
    os.push_back (o);
  }

  // --omit-create
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--omit-create", a, true, dv);
    os.push_back (o);
  }

  // --schema-name
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-name", a, false, dv);
    os.push_back (o);
  }

  // --fkeys-deferrable-mode
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--fkeys-deferrable-mode", a, false, dv);
    os.push_back (o);
  }

  // --default-pointer
  //
  {
    ::cli::option_names a;
    std::string dv ("*");
    ::cli::option o ("--default-pointer", a, false, dv);
    os.push_back (o);
  }

  // --session-type
  //
  {
    ::cli::option_names a;
    std::string dv ("odb::session");
    ::cli::option o ("--session-type", a, false, dv);
    os.push_back (o);
  }

  // --profile
  //
  {
    ::cli::option_names a;
    a.push_back ("-p");
    std::string dv;
    ::cli::option o ("--profile", a, false, dv);
    os.push_back (o);
  }

  // --at-once
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--at-once", a, true, dv);
    os.push_back (o);
  }

  // --schema
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema", a, false, dv);
    os.push_back (o);
  }

  // --export-symbol
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--export-symbol", a, false, dv);
    os.push_back (o);
  }

  // --extern-symbol
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--extern-symbol", a, false, dv);
    os.push_back (o);
  }

  // --std
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--std", a, false, dv);
    os.push_back (o);
  }

  // --warn-hard-add
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--warn-hard-add", a, true, dv);
    os.push_back (o);
  }

  // --warn-hard-delete
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--warn-hard-delete", a, true, dv);
    os.push_back (o);
  }

  // --warn-hard
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--warn-hard", a, true, dv);
    os.push_back (o);
  }

  // --output-dir
  //
  {
    ::cli::option_names a;
    a.push_back ("-o");
    std::string dv;
    ::cli::option o ("--output-dir", a, false, dv);
    os.push_back (o);
  }

  // --input-name
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--input-name", a, false, dv);
    os.push_back (o);
  }

  // --changelog
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--changelog", a, false, dv);
    os.push_back (o);
  }

  // --changelog-in
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--changelog-in", a, false, dv);
    os.push_back (o);
  }

  // --changelog-out
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--changelog-out", a, false, dv);
    os.push_back (o);
  }

  // --changelog-dir
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--changelog-dir", a, false, dv);
    os.push_back (o);
  }

  // --init-changelog
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--init-changelog", a, true, dv);
    os.push_back (o);
  }

  // --odb-file-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--odb-file-suffix", a, false, dv);
    os.push_back (o);
  }

  // --sql-file-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-file-suffix", a, false, dv);
    os.push_back (o);
  }

  // --schema-file-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-file-suffix", a, false, dv);
    os.push_back (o);
  }

  // --changelog-file-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--changelog-file-suffix", a, false, dv);
    os.push_back (o);
  }

  // --hxx-suffix
  //
  {
    ::cli::option_names a;
    std::string dv (".hxx");
    ::cli::option o ("--hxx-suffix", a, false, dv);
    os.push_back (o);
  }

  // --ixx-suffix
  //
  {
    ::cli::option_names a;
    std::string dv (".ixx");
    ::cli::option o ("--ixx-suffix", a, false, dv);
    os.push_back (o);
  }

  // --cxx-suffix
  //
  {
    ::cli::option_names a;
    std::string dv (".cxx");
    ::cli::option o ("--cxx-suffix", a, false, dv);
    os.push_back (o);
  }

  // --sql-suffix
  //
  {
    ::cli::option_names a;
    std::string dv (".sql");
    ::cli::option o ("--sql-suffix", a, false, dv);
    os.push_back (o);
  }

  // --changelog-suffix
  //
  {
    ::cli::option_names a;
    std::string dv (".xml");
    ::cli::option o ("--changelog-suffix", a, false, dv);
    os.push_back (o);
  }

  // --hxx-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--hxx-prologue", a, false, dv);
    os.push_back (o);
  }

  // --ixx-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--ixx-prologue", a, false, dv);
    os.push_back (o);
  }

  // --cxx-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--cxx-prologue", a, false, dv);
    os.push_back (o);
  }

  // --schema-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-prologue", a, false, dv);
    os.push_back (o);
  }

  // --sql-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-prologue", a, false, dv);
    os.push_back (o);
  }

  // --migration-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--migration-prologue", a, false, dv);
    os.push_back (o);
  }

  // --sql-interlude
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-interlude", a, false, dv);
    os.push_back (o);
  }

  // --hxx-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--hxx-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --ixx-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--ixx-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --cxx-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--cxx-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --schema-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --sql-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --migration-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--migration-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --hxx-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--hxx-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --ixx-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--ixx-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --cxx-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--cxx-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --schema-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --sql-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --migration-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--migration-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --sql-interlude-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-interlude-file", a, false, dv);
    os.push_back (o);
  }

  // --hxx-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--hxx-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --ixx-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--ixx-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --cxx-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--cxx-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --schema-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--schema-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --sql-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --migration-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--migration-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --odb-prologue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--odb-prologue", a, false, dv);
    os.push_back (o);
  }

  // --odb-prologue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--odb-prologue-file", a, false, dv);
    os.push_back (o);
  }

  // --odb-epilogue
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--odb-epilogue", a, false, dv);
    os.push_back (o);
  }

  // --odb-epilogue-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--odb-epilogue-file", a, false, dv);
    os.push_back (o);
  }

  // --table-prefix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--table-prefix", a, false, dv);
    os.push_back (o);
  }

  // --index-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--index-suffix", a, false, dv);
    os.push_back (o);
  }

  // --fkey-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--fkey-suffix", a, false, dv);
    os.push_back (o);
  }

  // --sequence-suffix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sequence-suffix", a, false, dv);
    os.push_back (o);
  }

  // --sql-name-case
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-name-case", a, false, dv);
    os.push_back (o);
  }

  // --table-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--table-regex", a, false, dv);
    os.push_back (o);
  }

  // --column-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--column-regex", a, false, dv);
    os.push_back (o);
  }

  // --index-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--index-regex", a, false, dv);
    os.push_back (o);
  }

  // --fkey-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--fkey-regex", a, false, dv);
    os.push_back (o);
  }

  // --sequence-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sequence-regex", a, false, dv);
    os.push_back (o);
  }

  // --statement-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--statement-regex", a, false, dv);
    os.push_back (o);
  }

  // --sql-name-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-name-regex", a, false, dv);
    os.push_back (o);
  }

  // --sql-name-regex-trace
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sql-name-regex-trace", a, true, dv);
    os.push_back (o);
  }

  // --accessor-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--accessor-regex", a, false, dv);
    os.push_back (o);
  }

  // --accessor-regex-trace
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--accessor-regex-trace", a, true, dv);
    os.push_back (o);
  }

  // --modifier-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--modifier-regex", a, false, dv);
    os.push_back (o);
  }

  // --modifier-regex-trace
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--modifier-regex-trace", a, true, dv);
    os.push_back (o);
  }

  // --include-with-brackets
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--include-with-brackets", a, true, dv);
    os.push_back (o);
  }

  // --include-prefix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--include-prefix", a, false, dv);
    os.push_back (o);
  }

  // --include-regex
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--include-regex", a, false, dv);
    os.push_back (o);
  }

  // --include-regex-trace
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--include-regex-trace", a, true, dv);
    os.push_back (o);
  }

  // --guard-prefix
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--guard-prefix", a, false, dv);
    os.push_back (o);
  }

  // --show-sloc
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--show-sloc", a, true, dv);
    os.push_back (o);
  }

  // --sloc-limit
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sloc-limit", a, false, dv);
    os.push_back (o);
  }

  // --options-file
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--options-file", a, false, dv);
    os.push_back (o);
  }

  // -x
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("-x", a, false, dv);
    os.push_back (o);
  }

  // -v
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("-v", a, true, dv);
    os.push_back (o);
  }

  // --trace
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--trace", a, true, dv);
    os.push_back (o);
  }

  // --mysql-engine
  //
  {
    ::cli::option_names a;
    std::string dv ("InnoDB");
    ::cli::option o ("--mysql-engine", a, false, dv);
    os.push_back (o);
  }

  // --sqlite-override-null
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sqlite-override-null", a, true, dv);
    os.push_back (o);
  }

  // --sqlite-lax-auto-id
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--sqlite-lax-auto-id", a, true, dv);
    os.push_back (o);
  }

  // --pgsql-server-version
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--pgsql-server-version", a, false, dv);
    os.push_back (o);
  }

  // --oracle-client-version
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--oracle-client-version", a, false, dv);
    os.push_back (o);
  }

  // --oracle-warn-truncation
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--oracle-warn-truncation", a, true, dv);
    os.push_back (o);
  }

  // --mssql-server-version
  //
  {
    ::cli::option_names a;
    std::string dv;
    ::cli::option o ("--mssql-server-version", a, false, dv);
    os.push_back (o);
  }

  // --mssql-short-limit
  //
  {
    ::cli::option_names a;
    std::string dv ("1024");
    ::cli::option o ("--mssql-short-limit", a, false, dv);
    os.push_back (o);
  }
}

const ::cli::options& options::
description ()
{
  return _cli_options_desc_;
};

typedef
std::map<std::string, void (*) (options&, ::cli::scanner&)>
_cli_options_map;

static _cli_options_map _cli_options_map_;

struct _cli_options_map_init
{
  _cli_options_map_init ()
  {
    _cli_options_map_["--help"] = 
    &::cli::thunk< options, bool, &options::help_ >;
    _cli_options_map_["--version"] = 
    &::cli::thunk< options, bool, &options::version_ >;
    _cli_options_map_["-I"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::I_,
      &options::I_specified_ >;
    _cli_options_map_["-D"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::D_,
      &options::D_specified_ >;
    _cli_options_map_["-U"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::U_,
      &options::U_specified_ >;
    _cli_options_map_["--database"] = 
    &::cli::thunk< options, std::vector< ::database>, &options::database_,
      &options::database_specified_ >;
    _cli_options_map_["-d"] = 
    &::cli::thunk< options, std::vector< ::database>, &options::database_,
      &options::database_specified_ >;
    _cli_options_map_["--multi-database"] = 
    &::cli::thunk< options, ::multi_database, &options::multi_database_,
      &options::multi_database_specified_ >;
    _cli_options_map_["-m"] = 
    &::cli::thunk< options, ::multi_database, &options::multi_database_,
      &options::multi_database_specified_ >;
    _cli_options_map_["--default-database"] = 
    &::cli::thunk< options, ::database, &options::default_database_,
      &options::default_database_specified_ >;
    _cli_options_map_["--generate-query"] = 
    &::cli::thunk< options, bool, &options::generate_query_ >;
    _cli_options_map_["-q"] = 
    &::cli::thunk< options, bool, &options::generate_query_ >;
    _cli_options_map_["--generate-prepared"] = 
    &::cli::thunk< options, bool, &options::generate_prepared_ >;
    _cli_options_map_["--omit-unprepared"] = 
    &::cli::thunk< options, bool, &options::omit_unprepared_ >;
    _cli_options_map_["--generate-session"] = 
    &::cli::thunk< options, bool, &options::generate_session_ >;
    _cli_options_map_["-e"] = 
    &::cli::thunk< options, bool, &options::generate_session_ >;
    _cli_options_map_["--generate-schema"] = 
    &::cli::thunk< options, bool, &options::generate_schema_ >;
    _cli_options_map_["-s"] = 
    &::cli::thunk< options, bool, &options::generate_schema_ >;
    _cli_options_map_["--generate-schema-only"] = 
    &::cli::thunk< options, bool, &options::generate_schema_only_ >;
    _cli_options_map_["--suppress-migration"] = 
    &::cli::thunk< options, bool, &options::suppress_migration_ >;
    _cli_options_map_["--suppress-schema-version"] = 
    &::cli::thunk< options, bool, &options::suppress_schema_version_ >;
    _cli_options_map_["--schema-version-table"] = 
    &::cli::thunk< options, database_map<qname>, &options::schema_version_table_,
      &options::schema_version_table_specified_ >;
    _cli_options_map_["--schema-format"] = 
    &::cli::thunk< options, database_map<std::set< ::schema_format> >, &options::schema_format_,
      &options::schema_format_specified_ >;
    _cli_options_map_["--omit-drop"] = 
    &::cli::thunk< options, bool, &options::omit_drop_ >;
    _cli_options_map_["--omit-create"] = 
    &::cli::thunk< options, bool, &options::omit_create_ >;
    _cli_options_map_["--schema-name"] = 
    &::cli::thunk< options, database_map<std::string>, &options::schema_name_,
      &options::schema_name_specified_ >;
    _cli_options_map_["--fkeys-deferrable-mode"] = 
    &::cli::thunk< options, database_map<deferrable>, &options::fkeys_deferrable_mode_,
      &options::fkeys_deferrable_mode_specified_ >;
    _cli_options_map_["--default-pointer"] = 
    &::cli::thunk< options, std::string, &options::default_pointer_,
      &options::default_pointer_specified_ >;
    _cli_options_map_["--session-type"] = 
    &::cli::thunk< options, std::string, &options::session_type_,
      &options::session_type_specified_ >;
    _cli_options_map_["--profile"] = 
    &::cli::thunk< options, std::string, &options::profile_,
      &options::profile_specified_ >;
    _cli_options_map_["-p"] = 
    &::cli::thunk< options, std::string, &options::profile_,
      &options::profile_specified_ >;
    _cli_options_map_["--at-once"] = 
    &::cli::thunk< options, bool, &options::at_once_ >;
    _cli_options_map_["--schema"] = 
    &::cli::thunk< options, database_map<qname>, &options::schema_,
      &options::schema_specified_ >;
    _cli_options_map_["--export-symbol"] = 
    &::cli::thunk< options, database_map<std::string>, &options::export_symbol_,
      &options::export_symbol_specified_ >;
    _cli_options_map_["--extern-symbol"] = 
    &::cli::thunk< options, database_map<std::string>, &options::extern_symbol_,
      &options::extern_symbol_specified_ >;
    _cli_options_map_["--std"] = 
    &::cli::thunk< options, cxx_version, &options::std_,
      &options::std_specified_ >;
    _cli_options_map_["--warn-hard-add"] = 
    &::cli::thunk< options, bool, &options::warn_hard_add_ >;
    _cli_options_map_["--warn-hard-delete"] = 
    &::cli::thunk< options, bool, &options::warn_hard_delete_ >;
    _cli_options_map_["--warn-hard"] = 
    &::cli::thunk< options, bool, &options::warn_hard_ >;
    _cli_options_map_["--output-dir"] = 
    &::cli::thunk< options, std::string, &options::output_dir_,
      &options::output_dir_specified_ >;
    _cli_options_map_["-o"] = 
    &::cli::thunk< options, std::string, &options::output_dir_,
      &options::output_dir_specified_ >;
    _cli_options_map_["--input-name"] = 
    &::cli::thunk< options, std::string, &options::input_name_,
      &options::input_name_specified_ >;
    _cli_options_map_["--changelog"] = 
    &::cli::thunk< options, database_map<std::string>, &options::changelog_,
      &options::changelog_specified_ >;
    _cli_options_map_["--changelog-in"] = 
    &::cli::thunk< options, database_map<std::string>, &options::changelog_in_,
      &options::changelog_in_specified_ >;
    _cli_options_map_["--changelog-out"] = 
    &::cli::thunk< options, database_map<std::string>, &options::changelog_out_,
      &options::changelog_out_specified_ >;
    _cli_options_map_["--changelog-dir"] = 
    &::cli::thunk< options, database_map<std::string>, &options::changelog_dir_,
      &options::changelog_dir_specified_ >;
    _cli_options_map_["--init-changelog"] = 
    &::cli::thunk< options, bool, &options::init_changelog_ >;
    _cli_options_map_["--odb-file-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::odb_file_suffix_,
      &options::odb_file_suffix_specified_ >;
    _cli_options_map_["--sql-file-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::sql_file_suffix_,
      &options::sql_file_suffix_specified_ >;
    _cli_options_map_["--schema-file-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::schema_file_suffix_,
      &options::schema_file_suffix_specified_ >;
    _cli_options_map_["--changelog-file-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::changelog_file_suffix_,
      &options::changelog_file_suffix_specified_ >;
    _cli_options_map_["--hxx-suffix"] = 
    &::cli::thunk< options, std::string, &options::hxx_suffix_,
      &options::hxx_suffix_specified_ >;
    _cli_options_map_["--ixx-suffix"] = 
    &::cli::thunk< options, std::string, &options::ixx_suffix_,
      &options::ixx_suffix_specified_ >;
    _cli_options_map_["--cxx-suffix"] = 
    &::cli::thunk< options, std::string, &options::cxx_suffix_,
      &options::cxx_suffix_specified_ >;
    _cli_options_map_["--sql-suffix"] = 
    &::cli::thunk< options, std::string, &options::sql_suffix_,
      &options::sql_suffix_specified_ >;
    _cli_options_map_["--changelog-suffix"] = 
    &::cli::thunk< options, std::string, &options::changelog_suffix_,
      &options::changelog_suffix_specified_ >;
    _cli_options_map_["--hxx-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::hxx_prologue_,
      &options::hxx_prologue_specified_ >;
    _cli_options_map_["--ixx-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::ixx_prologue_,
      &options::ixx_prologue_specified_ >;
    _cli_options_map_["--cxx-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::cxx_prologue_,
      &options::cxx_prologue_specified_ >;
    _cli_options_map_["--schema-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::schema_prologue_,
      &options::schema_prologue_specified_ >;
    _cli_options_map_["--sql-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::sql_prologue_,
      &options::sql_prologue_specified_ >;
    _cli_options_map_["--migration-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::migration_prologue_,
      &options::migration_prologue_specified_ >;
    _cli_options_map_["--sql-interlude"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::sql_interlude_,
      &options::sql_interlude_specified_ >;
    _cli_options_map_["--hxx-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::hxx_epilogue_,
      &options::hxx_epilogue_specified_ >;
    _cli_options_map_["--ixx-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::ixx_epilogue_,
      &options::ixx_epilogue_specified_ >;
    _cli_options_map_["--cxx-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::cxx_epilogue_,
      &options::cxx_epilogue_specified_ >;
    _cli_options_map_["--schema-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::schema_epilogue_,
      &options::schema_epilogue_specified_ >;
    _cli_options_map_["--sql-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::sql_epilogue_,
      &options::sql_epilogue_specified_ >;
    _cli_options_map_["--migration-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::migration_epilogue_,
      &options::migration_epilogue_specified_ >;
    _cli_options_map_["--hxx-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::hxx_prologue_file_,
      &options::hxx_prologue_file_specified_ >;
    _cli_options_map_["--ixx-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::ixx_prologue_file_,
      &options::ixx_prologue_file_specified_ >;
    _cli_options_map_["--cxx-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::cxx_prologue_file_,
      &options::cxx_prologue_file_specified_ >;
    _cli_options_map_["--schema-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::schema_prologue_file_,
      &options::schema_prologue_file_specified_ >;
    _cli_options_map_["--sql-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::sql_prologue_file_,
      &options::sql_prologue_file_specified_ >;
    _cli_options_map_["--migration-prologue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::migration_prologue_file_,
      &options::migration_prologue_file_specified_ >;
    _cli_options_map_["--sql-interlude-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::sql_interlude_file_,
      &options::sql_interlude_file_specified_ >;
    _cli_options_map_["--hxx-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::hxx_epilogue_file_,
      &options::hxx_epilogue_file_specified_ >;
    _cli_options_map_["--ixx-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::ixx_epilogue_file_,
      &options::ixx_epilogue_file_specified_ >;
    _cli_options_map_["--cxx-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::cxx_epilogue_file_,
      &options::cxx_epilogue_file_specified_ >;
    _cli_options_map_["--schema-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::schema_epilogue_file_,
      &options::schema_epilogue_file_specified_ >;
    _cli_options_map_["--sql-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::sql_epilogue_file_,
      &options::sql_epilogue_file_specified_ >;
    _cli_options_map_["--migration-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::string>, &options::migration_epilogue_file_,
      &options::migration_epilogue_file_specified_ >;
    _cli_options_map_["--odb-prologue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::odb_prologue_,
      &options::odb_prologue_specified_ >;
    _cli_options_map_["--odb-prologue-file"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::odb_prologue_file_,
      &options::odb_prologue_file_specified_ >;
    _cli_options_map_["--odb-epilogue"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::odb_epilogue_,
      &options::odb_epilogue_specified_ >;
    _cli_options_map_["--odb-epilogue-file"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::odb_epilogue_file_,
      &options::odb_epilogue_file_specified_ >;
    _cli_options_map_["--table-prefix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::table_prefix_,
      &options::table_prefix_specified_ >;
    _cli_options_map_["--index-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::index_suffix_,
      &options::index_suffix_specified_ >;
    _cli_options_map_["--fkey-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::fkey_suffix_,
      &options::fkey_suffix_specified_ >;
    _cli_options_map_["--sequence-suffix"] = 
    &::cli::thunk< options, database_map<std::string>, &options::sequence_suffix_,
      &options::sequence_suffix_specified_ >;
    _cli_options_map_["--sql-name-case"] = 
    &::cli::thunk< options, database_map<name_case>, &options::sql_name_case_,
      &options::sql_name_case_specified_ >;
    _cli_options_map_["--table-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::table_regex_,
      &options::table_regex_specified_ >;
    _cli_options_map_["--column-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::column_regex_,
      &options::column_regex_specified_ >;
    _cli_options_map_["--index-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::index_regex_,
      &options::index_regex_specified_ >;
    _cli_options_map_["--fkey-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::fkey_regex_,
      &options::fkey_regex_specified_ >;
    _cli_options_map_["--sequence-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::sequence_regex_,
      &options::sequence_regex_specified_ >;
    _cli_options_map_["--statement-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::statement_regex_,
      &options::statement_regex_specified_ >;
    _cli_options_map_["--sql-name-regex"] = 
    &::cli::thunk< options, database_map<std::vector<std::string> >, &options::sql_name_regex_,
      &options::sql_name_regex_specified_ >;
    _cli_options_map_["--sql-name-regex-trace"] = 
    &::cli::thunk< options, bool, &options::sql_name_regex_trace_ >;
    _cli_options_map_["--accessor-regex"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::accessor_regex_,
      &options::accessor_regex_specified_ >;
    _cli_options_map_["--accessor-regex-trace"] = 
    &::cli::thunk< options, bool, &options::accessor_regex_trace_ >;
    _cli_options_map_["--modifier-regex"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::modifier_regex_,
      &options::modifier_regex_specified_ >;
    _cli_options_map_["--modifier-regex-trace"] = 
    &::cli::thunk< options, bool, &options::modifier_regex_trace_ >;
    _cli_options_map_["--include-with-brackets"] = 
    &::cli::thunk< options, bool, &options::include_with_brackets_ >;
    _cli_options_map_["--include-prefix"] = 
    &::cli::thunk< options, std::string, &options::include_prefix_,
      &options::include_prefix_specified_ >;
    _cli_options_map_["--include-regex"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::include_regex_,
      &options::include_regex_specified_ >;
    _cli_options_map_["--include-regex-trace"] = 
    &::cli::thunk< options, bool, &options::include_regex_trace_ >;
    _cli_options_map_["--guard-prefix"] = 
    &::cli::thunk< options, std::string, &options::guard_prefix_,
      &options::guard_prefix_specified_ >;
    _cli_options_map_["--show-sloc"] = 
    &::cli::thunk< options, bool, &options::show_sloc_ >;
    _cli_options_map_["--sloc-limit"] = 
    &::cli::thunk< options, std::size_t, &options::sloc_limit_,
      &options::sloc_limit_specified_ >;
    _cli_options_map_["--options-file"] = 
    &::cli::thunk< options, std::string, &options::options_file_,
      &options::options_file_specified_ >;
    _cli_options_map_["-x"] = 
    &::cli::thunk< options, std::vector<std::string>, &options::x_,
      &options::x_specified_ >;
    _cli_options_map_["-v"] = 
    &::cli::thunk< options, bool, &options::v_ >;
    _cli_options_map_["--trace"] = 
    &::cli::thunk< options, bool, &options::trace_ >;
    _cli_options_map_["--mysql-engine"] = 
    &::cli::thunk< options, std::string, &options::mysql_engine_,
      &options::mysql_engine_specified_ >;
    _cli_options_map_["--sqlite-override-null"] = 
    &::cli::thunk< options, bool, &options::sqlite_override_null_ >;
    _cli_options_map_["--sqlite-lax-auto-id"] = 
    &::cli::thunk< options, bool, &options::sqlite_lax_auto_id_ >;
    _cli_options_map_["--pgsql-server-version"] = 
    &::cli::thunk< options, ::pgsql_version, &options::pgsql_server_version_,
      &options::pgsql_server_version_specified_ >;
    _cli_options_map_["--oracle-client-version"] = 
    &::cli::thunk< options, ::oracle_version, &options::oracle_client_version_,
      &options::oracle_client_version_specified_ >;
    _cli_options_map_["--oracle-warn-truncation"] = 
    &::cli::thunk< options, bool, &options::oracle_warn_truncation_ >;
    _cli_options_map_["--mssql-server-version"] = 
    &::cli::thunk< options, ::mssql_version, &options::mssql_server_version_,
      &options::mssql_server_version_specified_ >;
    _cli_options_map_["--mssql-short-limit"] = 
    &::cli::thunk< options, unsigned int, &options::mssql_short_limit_,
      &options::mssql_short_limit_specified_ >;
  }
};

static _cli_options_map_init _cli_options_map_init_;

bool options::
_parse (const char* o, ::cli::scanner& s)
{
  _cli_options_map::const_iterator i (_cli_options_map_.find (o));

  if (i != _cli_options_map_.end ())
  {
    (*(i->second)) (*this, s);
    return true;
  }

  return false;
}

void options::
_parse (::cli::scanner& s,
        ::cli::unknown_mode opt_mode,
        ::cli::unknown_mode arg_mode)
{
  bool opt = true;

  while (s.more ())
  {
    const char* o = s.peek ();

    if (std::strcmp (o, "--") == 0)
    {
      s.skip ();
      opt = false;
      continue;
    }

    if (opt && _parse (o, s));
    else if (opt && std::strncmp (o, "-", 1) == 0 && o[1] != '\0')
    {
      switch (opt_mode)
      {
        case ::cli::unknown_mode::skip:
        {
          s.skip ();
          continue;
        }
        case ::cli::unknown_mode::stop:
        {
          break;
        }
        case ::cli::unknown_mode::fail:
        {
          throw ::cli::unknown_option (o);
        }
      }

      break;
    }
    else
    {
      switch (arg_mode)
      {
        case ::cli::unknown_mode::skip:
        {
          s.skip ();
          continue;
        }
        case ::cli::unknown_mode::stop:
        {
          break;
        }
        case ::cli::unknown_mode::fail:
        {
          throw ::cli::unknown_argument (o);
        }
      }

      break;
    }
  }
}

// Begin epilogue.
//
//
// End epilogue.

