package com.mockobjects;

/*
 * TYPE TO PROVIDE VERY BASIC ARRAYLIST IMPLEMENTATION TO BRIDGE GAP BETWEEN
 * JDK1.1.7 and JDK 1.2
 */


class ArrayList extends java.util.Vector {

    /**
     * ArrayList constructor comment.
     */
    public ArrayList() {
        super();
    }

    /**
     * ArrayList constructor comment.
     * @param initialCapacity int
     */
    public ArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    /**
     * ArrayList constructor comment.
     * @param initialCapacity int
     * @param capacityIncrement int
     */
    public ArrayList(int initialCapacity, int capacityIncrement) {
        super(initialCapacity, capacityIncrement);
    }

    public void add(Object item) {
        super.addElement(item);
    }

    public void clear() {
        super.removeAllElements();
    }

    public boolean equals(ArrayList list) {
        if (size() != list.size())
            return false;

        for (int i = 0; i < size(); i++) {
            if (!this.elementAt(i).equals(list.elementAt(i)))
                return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if(obj instanceof ArrayList)
            return equals((ArrayList)obj);
        else
            return false;
    }

    public Object get(int index) {
        return super.elementAt(index);
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Object[] toArray(Object[] result) {
        for(int i=0;i<this.size();i++) {
            result[i] = this.elementAt(i);
        }

        return result;
    }
}
