const char* ExtensionToString(Extension extension) {
  switch (extension) {
    case Extension::kSPV_AMD_gcn_shader:
      return "SPV_AMD_gcn_shader";
    case Extension::kSPV_AMD_gpu_shader_half_float:
      return "SPV_AMD_gpu_shader_half_float";
    case Extension::kSPV_AMD_gpu_shader_half_float_fetch:
      return "SPV_AMD_gpu_shader_half_float_fetch";
    case Extension::kSPV_AMD_gpu_shader_int16:
      return "SPV_AMD_gpu_shader_int16";
    case Extension::kSPV_AMD_shader_ballot:
      return "SPV_AMD_shader_ballot";
    case Extension::kSPV_AMD_shader_explicit_vertex_parameter:
      return "SPV_AMD_shader_explicit_vertex_parameter";
    case Extension::kSPV_AMD_shader_fragment_mask:
      return "SPV_AMD_shader_fragment_mask";
    case Extension::kSPV_AMD_shader_image_load_store_lod:
      return "SPV_AMD_shader_image_load_store_lod";
    case Extension::kSPV_AMD_shader_trinary_minmax:
      return "SPV_AMD_shader_trinary_minmax";
    case Extension::kSPV_AMD_texture_gather_bias_lod:
      return "SPV_AMD_texture_gather_bias_lod";
    case Extension::kSPV_EXT_demote_to_helper_invocation:
      return "SPV_EXT_demote_to_helper_invocation";
    case Extension::kSPV_EXT_descriptor_indexing:
      return "SPV_EXT_descriptor_indexing";
    case Extension::kSPV_EXT_fragment_fully_covered:
      return "SPV_EXT_fragment_fully_covered";
    case Extension::kSPV_EXT_fragment_invocation_density:
      return "SPV_EXT_fragment_invocation_density";
    case Extension::kSPV_EXT_fragment_shader_interlock:
      return "SPV_EXT_fragment_shader_interlock";
    case Extension::kSPV_EXT_physical_storage_buffer:
      return "SPV_EXT_physical_storage_buffer";
    case Extension::kSPV_EXT_shader_stencil_export:
      return "SPV_EXT_shader_stencil_export";
    case Extension::kSPV_EXT_shader_viewport_index_layer:
      return "SPV_EXT_shader_viewport_index_layer";
    case Extension::kSPV_GOOGLE_decorate_string:
      return "SPV_GOOGLE_decorate_string";
    case Extension::kSPV_GOOGLE_hlsl_functionality1:
      return "SPV_GOOGLE_hlsl_functionality1";
    case Extension::kSPV_GOOGLE_user_type:
      return "SPV_GOOGLE_user_type";
    case Extension::kSPV_INTEL_device_side_avc_motion_estimation:
      return "SPV_INTEL_device_side_avc_motion_estimation";
    case Extension::kSPV_INTEL_media_block_io:
      return "SPV_INTEL_media_block_io";
    case Extension::kSPV_INTEL_shader_integer_functions2:
      return "SPV_INTEL_shader_integer_functions2";
    case Extension::kSPV_INTEL_subgroups:
      return "SPV_INTEL_subgroups";
    case Extension::kSPV_KHR_16bit_storage:
      return "SPV_KHR_16bit_storage";
    case Extension::kSPV_KHR_8bit_storage:
      return "SPV_KHR_8bit_storage";
    case Extension::kSPV_KHR_device_group:
      return "SPV_KHR_device_group";
    case Extension::kSPV_KHR_float_controls:
      return "SPV_KHR_float_controls";
    case Extension::kSPV_KHR_multiview:
      return "SPV_KHR_multiview";
    case Extension::kSPV_KHR_no_integer_wrap_decoration:
      return "SPV_KHR_no_integer_wrap_decoration";
    case Extension::kSPV_KHR_physical_storage_buffer:
      return "SPV_KHR_physical_storage_buffer";
    case Extension::kSPV_KHR_post_depth_coverage:
      return "SPV_KHR_post_depth_coverage";
    case Extension::kSPV_KHR_shader_atomic_counter_ops:
      return "SPV_KHR_shader_atomic_counter_ops";
    case Extension::kSPV_KHR_shader_ballot:
      return "SPV_KHR_shader_ballot";
    case Extension::kSPV_KHR_shader_clock:
      return "SPV_KHR_shader_clock";
    case Extension::kSPV_KHR_shader_draw_parameters:
      return "SPV_KHR_shader_draw_parameters";
    case Extension::kSPV_KHR_storage_buffer_storage_class:
      return "SPV_KHR_storage_buffer_storage_class";
    case Extension::kSPV_KHR_subgroup_vote:
      return "SPV_KHR_subgroup_vote";
    case Extension::kSPV_KHR_variable_pointers:
      return "SPV_KHR_variable_pointers";
    case Extension::kSPV_KHR_vulkan_memory_model:
      return "SPV_KHR_vulkan_memory_model";
    case Extension::kSPV_NVX_multiview_per_view_attributes:
      return "SPV_NVX_multiview_per_view_attributes";
    case Extension::kSPV_NV_compute_shader_derivatives:
      return "SPV_NV_compute_shader_derivatives";
    case Extension::kSPV_NV_cooperative_matrix:
      return "SPV_NV_cooperative_matrix";
    case Extension::kSPV_NV_fragment_shader_barycentric:
      return "SPV_NV_fragment_shader_barycentric";
    case Extension::kSPV_NV_geometry_shader_passthrough:
      return "SPV_NV_geometry_shader_passthrough";
    case Extension::kSPV_NV_mesh_shader:
      return "SPV_NV_mesh_shader";
    case Extension::kSPV_NV_ray_tracing:
      return "SPV_NV_ray_tracing";
    case Extension::kSPV_NV_sample_mask_override_coverage:
      return "SPV_NV_sample_mask_override_coverage";
    case Extension::kSPV_NV_shader_image_footprint:
      return "SPV_NV_shader_image_footprint";
    case Extension::kSPV_NV_shader_sm_builtins:
      return "SPV_NV_shader_sm_builtins";
    case Extension::kSPV_NV_shader_subgroup_partitioned:
      return "SPV_NV_shader_subgroup_partitioned";
    case Extension::kSPV_NV_shading_rate:
      return "SPV_NV_shading_rate";
    case Extension::kSPV_NV_stereo_view_rendering:
      return "SPV_NV_stereo_view_rendering";
    case Extension::kSPV_NV_viewport_array2:
      return "SPV_NV_viewport_array2";
    case Extension::kSPV_VALIDATOR_ignore_type_decl_unique:
      return "SPV_VALIDATOR_ignore_type_decl_unique";
  };

  return "";
}


    bool GetExtensionFromString(const char* str, Extension* extension) {
        static const char* known_ext_strs[] = { "SPV_AMD_gcn_shader", "SPV_AMD_gpu_shader_half_float", "SPV_AMD_gpu_shader_half_float_fetch", "SPV_AMD_gpu_shader_int16", "SPV_AMD_shader_ballot", "SPV_AMD_shader_explicit_vertex_parameter", "SPV_AMD_shader_fragment_mask", "SPV_AMD_shader_image_load_store_lod", "SPV_AMD_shader_trinary_minmax", "SPV_AMD_texture_gather_bias_lod", "SPV_EXT_demote_to_helper_invocation", "SPV_EXT_descriptor_indexing", "SPV_EXT_fragment_fully_covered", "SPV_EXT_fragment_invocation_density", "SPV_EXT_fragment_shader_interlock", "SPV_EXT_physical_storage_buffer", "SPV_EXT_shader_stencil_export", "SPV_EXT_shader_viewport_index_layer", "SPV_GOOGLE_decorate_string", "SPV_GOOGLE_hlsl_functionality1", "SPV_GOOGLE_user_type", "SPV_INTEL_device_side_avc_motion_estimation", "SPV_INTEL_media_block_io", "SPV_INTEL_shader_integer_functions2", "SPV_INTEL_subgroups", "SPV_KHR_16bit_storage", "SPV_KHR_8bit_storage", "SPV_KHR_device_group", "SPV_KHR_float_controls", "SPV_KHR_multiview", "SPV_KHR_no_integer_wrap_decoration", "SPV_KHR_physical_storage_buffer", "SPV_KHR_post_depth_coverage", "SPV_KHR_shader_atomic_counter_ops", "SPV_KHR_shader_ballot", "SPV_KHR_shader_clock", "SPV_KHR_shader_draw_parameters", "SPV_KHR_storage_buffer_storage_class", "SPV_KHR_subgroup_vote", "SPV_KHR_variable_pointers", "SPV_KHR_vulkan_memory_model", "SPV_NVX_multiview_per_view_attributes", "SPV_NV_compute_shader_derivatives", "SPV_NV_cooperative_matrix", "SPV_NV_fragment_shader_barycentric", "SPV_NV_geometry_shader_passthrough", "SPV_NV_mesh_shader", "SPV_NV_ray_tracing", "SPV_NV_sample_mask_override_coverage", "SPV_NV_shader_image_footprint", "SPV_NV_shader_sm_builtins", "SPV_NV_shader_subgroup_partitioned", "SPV_NV_shading_rate", "SPV_NV_stereo_view_rendering", "SPV_NV_viewport_array2", "SPV_VALIDATOR_ignore_type_decl_unique" };
        static const Extension known_ext_ids[] = { Extension::kSPV_AMD_gcn_shader, Extension::kSPV_AMD_gpu_shader_half_float, Extension::kSPV_AMD_gpu_shader_half_float_fetch, Extension::kSPV_AMD_gpu_shader_int16, Extension::kSPV_AMD_shader_ballot, Extension::kSPV_AMD_shader_explicit_vertex_parameter, Extension::kSPV_AMD_shader_fragment_mask, Extension::kSPV_AMD_shader_image_load_store_lod, Extension::kSPV_AMD_shader_trinary_minmax, Extension::kSPV_AMD_texture_gather_bias_lod, Extension::kSPV_EXT_demote_to_helper_invocation, Extension::kSPV_EXT_descriptor_indexing, Extension::kSPV_EXT_fragment_fully_covered, Extension::kSPV_EXT_fragment_invocation_density, Extension::kSPV_EXT_fragment_shader_interlock, Extension::kSPV_EXT_physical_storage_buffer, Extension::kSPV_EXT_shader_stencil_export, Extension::kSPV_EXT_shader_viewport_index_layer, Extension::kSPV_GOOGLE_decorate_string, Extension::kSPV_GOOGLE_hlsl_functionality1, Extension::kSPV_GOOGLE_user_type, Extension::kSPV_INTEL_device_side_avc_motion_estimation, Extension::kSPV_INTEL_media_block_io, Extension::kSPV_INTEL_shader_integer_functions2, Extension::kSPV_INTEL_subgroups, Extension::kSPV_KHR_16bit_storage, Extension::kSPV_KHR_8bit_storage, Extension::kSPV_KHR_device_group, Extension::kSPV_KHR_float_controls, Extension::kSPV_KHR_multiview, Extension::kSPV_KHR_no_integer_wrap_decoration, Extension::kSPV_KHR_physical_storage_buffer, Extension::kSPV_KHR_post_depth_coverage, Extension::kSPV_KHR_shader_atomic_counter_ops, Extension::kSPV_KHR_shader_ballot, Extension::kSPV_KHR_shader_clock, Extension::kSPV_KHR_shader_draw_parameters, Extension::kSPV_KHR_storage_buffer_storage_class, Extension::kSPV_KHR_subgroup_vote, Extension::kSPV_KHR_variable_pointers, Extension::kSPV_KHR_vulkan_memory_model, Extension::kSPV_NVX_multiview_per_view_attributes, Extension::kSPV_NV_compute_shader_derivatives, Extension::kSPV_NV_cooperative_matrix, Extension::kSPV_NV_fragment_shader_barycentric, Extension::kSPV_NV_geometry_shader_passthrough, Extension::kSPV_NV_mesh_shader, Extension::kSPV_NV_ray_tracing, Extension::kSPV_NV_sample_mask_override_coverage, Extension::kSPV_NV_shader_image_footprint, Extension::kSPV_NV_shader_sm_builtins, Extension::kSPV_NV_shader_subgroup_partitioned, Extension::kSPV_NV_shading_rate, Extension::kSPV_NV_stereo_view_rendering, Extension::kSPV_NV_viewport_array2, Extension::kSPV_VALIDATOR_ignore_type_decl_unique };
        const auto b = std::begin(known_ext_strs);
        const auto e = std::end(known_ext_strs);
        const auto found = std::equal_range(
            b, e, str, [](const char* str1, const char* str2) {
                return std::strcmp(str1, str2) < 0;
            });
        if (found.first == e || found.first == found.second) return false;

        *extension = known_ext_ids[found.first - b];
        return true;
    }
    

const char* CapabilityToString(SpvCapability capability) {
  switch (capability) {
    case SpvCapabilityMatrix:
      return "Matrix";
    case SpvCapabilityShader:
      return "Shader";
    case SpvCapabilityGeometry:
      return "Geometry";
    case SpvCapabilityTessellation:
      return "Tessellation";
    case SpvCapabilityAddresses:
      return "Addresses";
    case SpvCapabilityLinkage:
      return "Linkage";
    case SpvCapabilityKernel:
      return "Kernel";
    case SpvCapabilityVector16:
      return "Vector16";
    case SpvCapabilityFloat16Buffer:
      return "Float16Buffer";
    case SpvCapabilityFloat16:
      return "Float16";
    case SpvCapabilityFloat64:
      return "Float64";
    case SpvCapabilityInt64:
      return "Int64";
    case SpvCapabilityInt64Atomics:
      return "Int64Atomics";
    case SpvCapabilityImageBasic:
      return "ImageBasic";
    case SpvCapabilityImageReadWrite:
      return "ImageReadWrite";
    case SpvCapabilityImageMipmap:
      return "ImageMipmap";
    case SpvCapabilityPipes:
      return "Pipes";
    case SpvCapabilityGroups:
      return "Groups";
    case SpvCapabilityDeviceEnqueue:
      return "DeviceEnqueue";
    case SpvCapabilityLiteralSampler:
      return "LiteralSampler";
    case SpvCapabilityAtomicStorage:
      return "AtomicStorage";
    case SpvCapabilityInt16:
      return "Int16";
    case SpvCapabilityTessellationPointSize:
      return "TessellationPointSize";
    case SpvCapabilityGeometryPointSize:
      return "GeometryPointSize";
    case SpvCapabilityImageGatherExtended:
      return "ImageGatherExtended";
    case SpvCapabilityStorageImageMultisample:
      return "StorageImageMultisample";
    case SpvCapabilityUniformBufferArrayDynamicIndexing:
      return "UniformBufferArrayDynamicIndexing";
    case SpvCapabilitySampledImageArrayDynamicIndexing:
      return "SampledImageArrayDynamicIndexing";
    case SpvCapabilityStorageBufferArrayDynamicIndexing:
      return "StorageBufferArrayDynamicIndexing";
    case SpvCapabilityStorageImageArrayDynamicIndexing:
      return "StorageImageArrayDynamicIndexing";
    case SpvCapabilityClipDistance:
      return "ClipDistance";
    case SpvCapabilityCullDistance:
      return "CullDistance";
    case SpvCapabilityImageCubeArray:
      return "ImageCubeArray";
    case SpvCapabilitySampleRateShading:
      return "SampleRateShading";
    case SpvCapabilityImageRect:
      return "ImageRect";
    case SpvCapabilitySampledRect:
      return "SampledRect";
    case SpvCapabilityGenericPointer:
      return "GenericPointer";
    case SpvCapabilityInt8:
      return "Int8";
    case SpvCapabilityInputAttachment:
      return "InputAttachment";
    case SpvCapabilitySparseResidency:
      return "SparseResidency";
    case SpvCapabilityMinLod:
      return "MinLod";
    case SpvCapabilitySampled1D:
      return "Sampled1D";
    case SpvCapabilityImage1D:
      return "Image1D";
    case SpvCapabilitySampledCubeArray:
      return "SampledCubeArray";
    case SpvCapabilitySampledBuffer:
      return "SampledBuffer";
    case SpvCapabilityImageBuffer:
      return "ImageBuffer";
    case SpvCapabilityImageMSArray:
      return "ImageMSArray";
    case SpvCapabilityStorageImageExtendedFormats:
      return "StorageImageExtendedFormats";
    case SpvCapabilityImageQuery:
      return "ImageQuery";
    case SpvCapabilityDerivativeControl:
      return "DerivativeControl";
    case SpvCapabilityInterpolationFunction:
      return "InterpolationFunction";
    case SpvCapabilityTransformFeedback:
      return "TransformFeedback";
    case SpvCapabilityGeometryStreams:
      return "GeometryStreams";
    case SpvCapabilityStorageImageReadWithoutFormat:
      return "StorageImageReadWithoutFormat";
    case SpvCapabilityStorageImageWriteWithoutFormat:
      return "StorageImageWriteWithoutFormat";
    case SpvCapabilityMultiViewport:
      return "MultiViewport";
    case SpvCapabilitySubgroupDispatch:
      return "SubgroupDispatch";
    case SpvCapabilityNamedBarrier:
      return "NamedBarrier";
    case SpvCapabilityPipeStorage:
      return "PipeStorage";
    case SpvCapabilityGroupNonUniform:
      return "GroupNonUniform";
    case SpvCapabilityGroupNonUniformVote:
      return "GroupNonUniformVote";
    case SpvCapabilityGroupNonUniformArithmetic:
      return "GroupNonUniformArithmetic";
    case SpvCapabilityGroupNonUniformBallot:
      return "GroupNonUniformBallot";
    case SpvCapabilityGroupNonUniformShuffle:
      return "GroupNonUniformShuffle";
    case SpvCapabilityGroupNonUniformShuffleRelative:
      return "GroupNonUniformShuffleRelative";
    case SpvCapabilityGroupNonUniformClustered:
      return "GroupNonUniformClustered";
    case SpvCapabilityGroupNonUniformQuad:
      return "GroupNonUniformQuad";
    case SpvCapabilityShaderLayer:
      return "ShaderLayer";
    case SpvCapabilityShaderViewportIndex:
      return "ShaderViewportIndex";
    case SpvCapabilitySubgroupBallotKHR:
      return "SubgroupBallotKHR";
    case SpvCapabilityDrawParameters:
      return "DrawParameters";
    case SpvCapabilitySubgroupVoteKHR:
      return "SubgroupVoteKHR";
    case SpvCapabilityStorageBuffer16BitAccess:
      return "StorageBuffer16BitAccess";
    case SpvCapabilityUniformAndStorageBuffer16BitAccess:
      return "UniformAndStorageBuffer16BitAccess";
    case SpvCapabilityStoragePushConstant16:
      return "StoragePushConstant16";
    case SpvCapabilityStorageInputOutput16:
      return "StorageInputOutput16";
    case SpvCapabilityDeviceGroup:
      return "DeviceGroup";
    case SpvCapabilityMultiView:
      return "MultiView";
    case SpvCapabilityVariablePointersStorageBuffer:
      return "VariablePointersStorageBuffer";
    case SpvCapabilityVariablePointers:
      return "VariablePointers";
    case SpvCapabilityAtomicStorageOps:
      return "AtomicStorageOps";
    case SpvCapabilitySampleMaskPostDepthCoverage:
      return "SampleMaskPostDepthCoverage";
    case SpvCapabilityStorageBuffer8BitAccess:
      return "StorageBuffer8BitAccess";
    case SpvCapabilityUniformAndStorageBuffer8BitAccess:
      return "UniformAndStorageBuffer8BitAccess";
    case SpvCapabilityStoragePushConstant8:
      return "StoragePushConstant8";
    case SpvCapabilityDenormPreserve:
      return "DenormPreserve";
    case SpvCapabilityDenormFlushToZero:
      return "DenormFlushToZero";
    case SpvCapabilitySignedZeroInfNanPreserve:
      return "SignedZeroInfNanPreserve";
    case SpvCapabilityRoundingModeRTE:
      return "RoundingModeRTE";
    case SpvCapabilityRoundingModeRTZ:
      return "RoundingModeRTZ";
    case SpvCapabilityFloat16ImageAMD:
      return "Float16ImageAMD";
    case SpvCapabilityImageGatherBiasLodAMD:
      return "ImageGatherBiasLodAMD";
    case SpvCapabilityFragmentMaskAMD:
      return "FragmentMaskAMD";
    case SpvCapabilityStencilExportEXT:
      return "StencilExportEXT";
    case SpvCapabilityImageReadWriteLodAMD:
      return "ImageReadWriteLodAMD";
    case SpvCapabilityShaderClockKHR:
      return "ShaderClockKHR";
    case SpvCapabilitySampleMaskOverrideCoverageNV:
      return "SampleMaskOverrideCoverageNV";
    case SpvCapabilityGeometryShaderPassthroughNV:
      return "GeometryShaderPassthroughNV";
    case SpvCapabilityShaderViewportIndexLayerEXT:
      return "ShaderViewportIndexLayerEXT";
    case SpvCapabilityShaderViewportMaskNV:
      return "ShaderViewportMaskNV";
    case SpvCapabilityShaderStereoViewNV:
      return "ShaderStereoViewNV";
    case SpvCapabilityPerViewAttributesNV:
      return "PerViewAttributesNV";
    case SpvCapabilityFragmentFullyCoveredEXT:
      return "FragmentFullyCoveredEXT";
    case SpvCapabilityMeshShadingNV:
      return "MeshShadingNV";
    case SpvCapabilityImageFootprintNV:
      return "ImageFootprintNV";
    case SpvCapabilityFragmentBarycentricNV:
      return "FragmentBarycentricNV";
    case SpvCapabilityComputeDerivativeGroupQuadsNV:
      return "ComputeDerivativeGroupQuadsNV";
    case SpvCapabilityFragmentDensityEXT:
      return "FragmentDensityEXT";
    case SpvCapabilityGroupNonUniformPartitionedNV:
      return "GroupNonUniformPartitionedNV";
    case SpvCapabilityShaderNonUniform:
      return "ShaderNonUniform";
    case SpvCapabilityRuntimeDescriptorArray:
      return "RuntimeDescriptorArray";
    case SpvCapabilityInputAttachmentArrayDynamicIndexing:
      return "InputAttachmentArrayDynamicIndexing";
    case SpvCapabilityUniformTexelBufferArrayDynamicIndexing:
      return "UniformTexelBufferArrayDynamicIndexing";
    case SpvCapabilityStorageTexelBufferArrayDynamicIndexing:
      return "StorageTexelBufferArrayDynamicIndexing";
    case SpvCapabilityUniformBufferArrayNonUniformIndexing:
      return "UniformBufferArrayNonUniformIndexing";
    case SpvCapabilitySampledImageArrayNonUniformIndexing:
      return "SampledImageArrayNonUniformIndexing";
    case SpvCapabilityStorageBufferArrayNonUniformIndexing:
      return "StorageBufferArrayNonUniformIndexing";
    case SpvCapabilityStorageImageArrayNonUniformIndexing:
      return "StorageImageArrayNonUniformIndexing";
    case SpvCapabilityInputAttachmentArrayNonUniformIndexing:
      return "InputAttachmentArrayNonUniformIndexing";
    case SpvCapabilityUniformTexelBufferArrayNonUniformIndexing:
      return "UniformTexelBufferArrayNonUniformIndexing";
    case SpvCapabilityStorageTexelBufferArrayNonUniformIndexing:
      return "StorageTexelBufferArrayNonUniformIndexing";
    case SpvCapabilityRayTracingNV:
      return "RayTracingNV";
    case SpvCapabilityVulkanMemoryModel:
      return "VulkanMemoryModel";
    case SpvCapabilityVulkanMemoryModelDeviceScope:
      return "VulkanMemoryModelDeviceScope";
    case SpvCapabilityPhysicalStorageBufferAddresses:
      return "PhysicalStorageBufferAddresses";
    case SpvCapabilityComputeDerivativeGroupLinearNV:
      return "ComputeDerivativeGroupLinearNV";
    case SpvCapabilityCooperativeMatrixNV:
      return "CooperativeMatrixNV";
    case SpvCapabilityFragmentShaderSampleInterlockEXT:
      return "FragmentShaderSampleInterlockEXT";
    case SpvCapabilityFragmentShaderShadingRateInterlockEXT:
      return "FragmentShaderShadingRateInterlockEXT";
    case SpvCapabilityShaderSMBuiltinsNV:
      return "ShaderSMBuiltinsNV";
    case SpvCapabilityFragmentShaderPixelInterlockEXT:
      return "FragmentShaderPixelInterlockEXT";
    case SpvCapabilityDemoteToHelperInvocationEXT:
      return "DemoteToHelperInvocationEXT";
    case SpvCapabilitySubgroupShuffleINTEL:
      return "SubgroupShuffleINTEL";
    case SpvCapabilitySubgroupBufferBlockIOINTEL:
      return "SubgroupBufferBlockIOINTEL";
    case SpvCapabilitySubgroupImageBlockIOINTEL:
      return "SubgroupImageBlockIOINTEL";
    case SpvCapabilitySubgroupImageMediaBlockIOINTEL:
      return "SubgroupImageMediaBlockIOINTEL";
    case SpvCapabilityIntegerFunctions2INTEL:
      return "IntegerFunctions2INTEL";
    case SpvCapabilitySubgroupAvcMotionEstimationINTEL:
      return "SubgroupAvcMotionEstimationINTEL";
    case SpvCapabilitySubgroupAvcMotionEstimationIntraINTEL:
      return "SubgroupAvcMotionEstimationIntraINTEL";
    case SpvCapabilitySubgroupAvcMotionEstimationChromaINTEL:
      return "SubgroupAvcMotionEstimationChromaINTEL";
    case SpvCapabilityMax:
      assert(0 && "Attempting to convert SpvCapabilityMax to string");
      return "";
  };

  return "";
}