/*
 *  @(#)ImmutableTestRecord.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.itf.impl;

import net.sourceforge.groboutils.pmti.v1.itf.ITestRecord;



/**
 * Simple immutable implementation of ITestRecord.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:52:00 $
 * @since      July 7, 2002
 */
public class ImmutableTestRecord implements ITestRecord
{
    
    private String name;
    private String suite;
    private int tCount;
    private long tRuntime;
    private String[] failures;
    private String[] errors;
    private String log;
    
    
    public ImmutableTestRecord( String name, String suite, int tCount,
            long tRuntime, String[] failures, String[] errors, String log )
    {
        setTestName( name );
        setTestSuite( suite );
        setTestCount( tCount );
        setRuntime( tRuntime );
        setFailures( failures );
        setErrors( errors );
        setLog( log );
    }
    
    
    public ImmutableTestRecord( ITestRecord tr )
    {
        if (tr == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        
        setTestName( tr.getTestName() );
        setTestSuite( tr.getTestSuite() );
        setTestCount( tr.getTestCount() );
        setRuntime( tr.getRuntime() );
        setFailures( tr.getFailures() );
        setErrors( tr.getErrors() );
        setLog( tr.getLog() );
    }
    
    
    public String getTestName()
    {
        return this.name;
    }
    
    public String getTestSuite()
    {
        return this.suite;
    }
    
    public int getTestCount()
    {
        return this.tCount;
    }
    
    public long getRuntime()
    {
        return this.tRuntime;
    }
    
    public String[] getFailures()
    {
        String ret[] = new String[ this.failures.length ];
        System.arraycopy( this.failures, 0, ret, 0, this.failures.length );
        return ret;
    }
    
    public String[] getErrors()
    {
        String ret[] = new String[ this.errors.length ];
        System.arraycopy( this.errors, 0, ret, 0, this.errors.length );
        return ret;
    }
    
    public String getLog()
    {
        return this.log;
    }
    
    
    
    //-------------------------------
    // Package protected
    
    ImmutableTestRecord()
    {
        setErrors( null );
        setFailures( null );
    }
    
    
    void setTestName( String name )
    {
        this.name = name;
    }
    
    
    void setTestSuite( String suite )
    {
        this.suite = suite;
    }
    
    
    void setTestCount( int count )
    {
        if (count < 0)
        {
            count = 0;
        }
        this.tCount = count;
    }
    
    
    void setRuntime( long time )
    {
        if (time < 0L)
        {
            time = 0L;
        }
        this.tRuntime = time;
    }
    
    
    void setFailures( String[] f )
    {
        if (f == null)
        {
            f = new String[0];
        }
        this.failures = new String[ f.length ];
        System.arraycopy( f, 0, this.failures, 0, f.length );
    }
    
    
    void setErrors( String[] e )
    {
        if (e == null)
        {
            e = new String[0];
        }
        this.errors = new String[ e.length ];
        System.arraycopy( e, 0, this.errors, 0, e.length );
    }
    
    
    void setLog( String log )
    {
        this.log = log;
    }
}

