/*
 * @(#)ClassSignatureUtil.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.codecoverage.v2.util;


/**
 * Knows how to create a class signature.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:51:29 $
 * @since     December 17, 2002
 */
public class ClassSignatureUtil
{
    protected static ClassSignatureUtil s_instance = new ClassSignatureUtil();
    
    
    protected ClassSignatureUtil()
    {
        // do nothing
    }
    
    
    public static ClassSignatureUtil getInstance()
    {
        return s_instance;
    }
    
    
    public String createClassSignature( String className, long checksum )
    {
        if (className == null)
        {
            throw new IllegalArgumentException("no null args");
        }
        return className + '-' + checksum;
    }
    
    
    public String getClassName( String signature )
    {
        if (signature == null)
        {
            throw new IllegalArgumentException( "No null args." );
        }
        int pos = signature.indexOf( '-' );
        if (pos < 0)
        {
            return signature;
        }
        return signature.substring( 0, pos );
    }
}

