/***************************************************************************
                           dclib.h  -  description
                             -------------------
    begin                : Mon May 5 2003
    copyright            : (C) 2003 by Mathias Küster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCLIB_H
#define DCLIB_H

/* */
#include <dclib/dcos.h>

/**
  *@author Mathias Küster
  */

#include <time.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Initialise used libraries.
 * Parameter must be argv[0].
 * Parameter is only used if compiled for socks proxy support.
 */
void dclibInitDepLibs( char * argv0 );
/** cleanup used libraries */
void dclibDeInitDepLibs();
/** get dclib start time */
time_t dclibUptime();
/** get dclib version string */
const char * dclibVersion();
/** get dclib build date and if svn, the revision */
const char * dclibBuildInfo();
/** get dclib verbose setting */
int dclibVerbose();
/**  set dclib verbose */
void setdclibVerbose( int n );
/** get SSL support */
bool dclibSupportsSSL();

#define DPRINTF if (dclibVerbose()) printf

#ifdef __cplusplus
}
#endif

#endif
