/*
  CoreLinux++ 
  Copyright (C) 2000 CoreLinux Consortium
  
   The CoreLinux++ Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The CoreLinux++ Library Library is distributed in the hope that it will 
   be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the GNU C Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
*/   

#if   !defined(__COMMON_HPP)
#include <Common.hpp>
#endif

#if   !defined(__COMMANDFRAMEEXCEPTION_HPP)
#include <CommandFrameException.hpp>
#endif

namespace   corelinux
{
   //
   // Default public constructor
   //

   CommandFrameException::CommandFrameException
      ( 
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      Exception("CommandFrameException",file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }

   //
   // Implementation protected constructor
   //

   CommandFrameException::CommandFrameException
      ( 
         CharCptr why,
         CharCptr file,
         LineNum  line,
         Severity severity,
         bool     outOfMemory
      )
      :
      Exception(why,file,line,severity,outOfMemory)
   {
      ;  // do nothing
   }
   //
   // Default protected constructor
   //

   CommandFrameException::CommandFrameException( void )
      :
      Exception()
   {
      NEVER_GET_HERE;
   }

   //
   // Copy constructor
   //

   CommandFrameException::CommandFrameException( CommandFrameExceptionCref aRef )
      :
      Exception( aRef )
   {
      ;  // do nothing
   }

   //
   // Destructor
   //

   CommandFrameException::~CommandFrameException( void )
   {
      ;  // do nothing
   }

   //
   // Assignment operator
   //

   CommandFrameExceptionRef CommandFrameException::operator=
      ( 
         CommandFrameExceptionCref aRef 
      )
   {
      Exception::operator=( aRef );
      return (*this);
   }

   //
   // Equality operator
   //

   bool  CommandFrameException::operator==( CommandFrameExceptionCref aRef ) const
   {
      return (this == &aRef);
   }

}

/*
   Common rcs information do not modify
   $Author: frankc $
   $Revision: 1.1 $
   $Date: 2000/05/03 03:58:36 $
   $Locker:  $
*/


