/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.util.SampleStat;

public class MetricMutableStat
extends MetricMutable {
    private final String numSamplesName;
    private final String numSamplesDesc;
    private final String avgValueName;
    private final String avgValueDesc;
    private final String stdevValueName;
    private final String stdevValueDesc;
    private final String iMinValueName;
    private final String iMinValueDesc;
    private final String iMaxValueName;
    private final String iMaxValueDesc;
    private final String minValueName;
    private final String minValueDesc;
    private final String maxValueName;
    private final String maxValueDesc;
    private final SampleStat intervalStat = new SampleStat();
    private final SampleStat prevStat = new SampleStat();
    private final SampleStat.MinMax minMax = new SampleStat.MinMax();
    private long numSamples = 0L;
    private boolean extended = false;

    public MetricMutableStat(String name, String description, String sampleName, String valueName, boolean extended) {
        super(name, description);
        String desc = StringUtils.uncapitalize((String)description);
        this.numSamplesName = name + "_num_" + sampleName;
        this.numSamplesDesc = "Number of " + sampleName + " for " + desc;
        this.avgValueName = name + "_avg_" + valueName;
        this.avgValueDesc = "Average " + valueName + " for " + desc;
        this.stdevValueName = name + "_stdev_" + valueName;
        this.stdevValueDesc = "Standard deviation of " + valueName + " for " + desc;
        this.iMinValueName = name + "_imin_" + valueName;
        this.iMinValueDesc = "Interval min " + valueName + " for " + desc;
        this.iMaxValueName = name + "_imax_" + valueName;
        this.iMaxValueDesc = "Interval max " + valueName + " for " + desc;
        this.minValueName = name + "_min_" + valueName;
        this.minValueDesc = "Min " + valueName + " for " + desc;
        this.maxValueName = name + "_max_" + valueName;
        this.maxValueDesc = "Max " + valueName + " for " + desc;
        this.extended = extended;
    }

    public MetricMutableStat(String name, String description, String sampleName, String valueName) {
        this(name, description, sampleName, valueName, false);
    }

    public synchronized void add(long numSamples, long sum) {
        this.intervalStat.add(numSamples, sum);
        this.setChanged();
    }

    public synchronized void add(long value) {
        this.intervalStat.add(value);
        this.minMax.add(value);
        this.setChanged();
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            this.numSamples += this.intervalStat.numSamples();
            builder.addCounter(this.numSamplesName, this.numSamplesDesc, this.numSamples);
            builder.addGauge(this.avgValueName, this.avgValueDesc, this.lastStat().mean());
            if (this.extended) {
                builder.addGauge(this.stdevValueName, this.stdevValueDesc, this.lastStat().stddev());
                builder.addGauge(this.iMinValueName, this.iMinValueDesc, this.lastStat().min());
                builder.addGauge(this.iMaxValueName, this.iMaxValueDesc, this.lastStat().max());
                builder.addGauge(this.minValueName, this.minValueDesc, this.minMax.min());
                builder.addGauge(this.maxValueName, this.maxValueDesc, this.minMax.max());
            }
            if (this.changed()) {
                this.intervalStat.copyTo(this.prevStat);
                this.intervalStat.reset();
                this.clearChanged();
            }
        }
    }

    private SampleStat lastStat() {
        return this.changed() ? this.intervalStat : this.prevStat;
    }

    public void resetMinMax() {
        this.minMax.reset();
    }
}

