/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.util.Locale;
import javax.servlet.jsp.JspException;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.localization.LocalizationUtility;
import net.sourceforge.stripes.tag.InputOptionsCollectionTag;
import net.sourceforge.stripes.util.ReflectUtil;
import net.sourceforge.stripes.util.bean.BeanUtil;
import net.sourceforge.stripes.util.bean.ExpressionException;

public class InputOptionsEnumerationTag
extends InputOptionsCollectionTag {
    private String className;

    public void setEnum(String name) {
        this.className = name;
    }

    public String getEnum() {
        return this.className;
    }

    public int doStartTag() throws JspException {
        Class clazz = null;
        try {
            clazz = ReflectUtil.findClass(this.className);
        }
        catch (Exception e) {
            try {
                int last = this.className.lastIndexOf(46);
                if (last > 0) {
                    String n2 = new StringBuilder(this.className).replace(last, last + 1, "$").toString();
                    clazz = ReflectUtil.findClass(n2);
                }
            }
            catch (Exception e2) {
                throw new StripesJspException("Could not process class [" + this.className + "]. Attribute 'enum' on " + "tag options-enumeration must be the fully qualified name of a " + "class which is a java 1.5 enum.", e);
            }
        }
        if (!clazz.isEnum()) {
            throw new StripesJspException("The class name supplied, [" + this.className + "], does not appear to be " + "a JDK1.5 enum class.");
        }
        Enum[] enums = (Enum[])clazz.getEnumConstants();
        try {
            Locale locale = this.getPageContext().getRequest().getLocale();
            for (Enum item : enums) {
                Object label = null;
                String packageName = clazz.getPackage() == null ? "" : clazz.getPackage().getName();
                label = LocalizationUtility.getLocalizedFieldName(clazz.getSimpleName() + "." + item.name(), packageName, null, locale);
                if (label == null) {
                    label = this.getLabel() != null ? BeanUtil.getPropertyValue(this.getLabel(), item) : item.toString();
                }
                Object group = null;
                if (this.getGroup() != null) {
                    group = BeanUtil.getPropertyValue(this.getGroup(), item);
                }
                this.addEntry(item, label, item, group);
            }
        }
        catch (ExpressionException ee) {
            throw new StripesJspException("A problem occurred generating an options-enumeration. Most likely either the class [" + this.getEnum() + "] is not an enum or, [" + this.getLabel() + "] is not a valid property of the enum.", ee);
        }
        return 0;
    }
}

