/***********************************************************************
  Copyright (c) 2001, Nishan Systems, Inc.
  All rights reserved.
  
  Redistribution and use in source and binary forms, with or without 
  modification, are permitted provided that the following conditions are 
  met:
  
  - Redistributions of source code must retain the above copyright notice, 
    this list of conditions and the following disclaimer. 
  
  - Redistributions in binary form must reproduce the above copyright 
    notice, this list of conditions and the following disclaimer in the 
    documentation and/or other materials provided with the distribution. 
  
  - Neither the name of the Nishan Systems, Inc. nor the names of its 
    contributors may be used to endorse or promote products derived from 
    this software without specific prior written permission. 
  
  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
  IMPLIED WARRANTIES OF MERCHANTABILITY, NON-INFRINGEMENT AND FITNESS FOR A 
  PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL NISHAN SYSTEMS, INC. 
  OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
  EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
  PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
  OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
  OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
***********************************************************************/

/*
 * This file contains definitions of macros used for 
 * initializing and configuring the SoIP service software.
 *
 */

#ifndef _SNS_h_
#define _SNS_h_

#include "iSNStypes.h"

/* This should be a string */
#define ISNS_VERSION "2.1.1"

/* This should be an integer, and is the protocol version */
#define SNS_VERSION 1

/* control node name */
#define CONTROL_NODE "iqn.control.node"

char isns_control_node[256];

/*
 * iSNS Readyness Typedefs
 */
typedef enum {

  SNS_FIRST_UP,
  SNS_RESYNC=SNS_FIRST_UP,
  SNS_UP,
  SNS_DOWN

}  SNSReadyness;


/*
 * Macros used for configuring the client/server and server/server
 * UDP based communication protocol
 */

#define SNS_STP_POLL_INTERVAL    2

/*
 * Delay (in seconds) between successive heartbeats generated by the
 * the primary server and waiting period before heartbeat timeout.
 */
#define SNS_ESI_INTERVAL         15
#define SNS_HEARTBEAT_INTERVAL   2
#define SNS_HEARTBEAT_WAITTIME   5

/*
 * Timeout an outstanding iSNS request. If a response is not received
 * with in this window, the device or entity making the name server
 * request will be timedout
 *
 */
#define SNS_REQ_TIMEOUT         10

/*
 * Timeout value for a iSNS request. If a response to an SNS request
 * is not received with in this window, the requesting SOIP service
 * entity will timeout. This is a timeout value used between a iSNS
 * client and iSNS server.
 */
#define SNS_REQUEST_TIMEOUT      2
#define SNS_REQUEST_RETRIES      4


/*
 * server Database configuration parameters
 */
#define SNS_DB_BLOCK_SIZE      512


/*
 * Buffer size for exchanging data between client and server 
 * during database resync 
 */
#define SNS_RESYNC_BFR_SIZE   1024

/*
 * number of active resyncs at a time
 */
#define SNS_ACTIVE_RESYNCS      10
#define SNS_PRI_RESYNC_TIMEOUT   7
#define SNS_CLI_RESYNC_TIMEOUT   3
#define SNS_RESYNC_RETRIES       3

/*
 * resync IP addr linked list states
 */
#define SNS_SYNC_ACTIVE          1
#define SNS_SYNC_WAITING         2

/*
 * Function prototypes
 */
#ifdef SNS_LINUX  
extern int
SNSReceiveMain();
#else
extern DWORD WINAPI
SNSReceiveMain(LPVOID lparam);
#endif

#ifdef SNS_LINUX
extern int
SNSResyncMain();
#else
extern DWORD WINAPI
SNSResyncMain(LPVOID lparam);
#endif

extern STATUS
SNSInit (ISNS_Entity);

int SNSMain(ISNS_Entity role);

extern void 
SNSExceptionHandler(void);

#endif
